/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 197:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 271:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

let LazyResult, Processor

class Document extends Container {
  constructor(defaults) {
    // type needs to be passed to super, otherwise child roots won't be normalized correctly
    super({ type: 'document', ...defaults })

    if (!this.nodes) {
      this.nodes = []
    }
  }

  toResult(opts = {}) {
    let lazy = new LazyResult(new Processor(), this, opts)

    return lazy.stringify()
  }
}

Document.registerLazyResult = dependant => {
  LazyResult = dependant
}

Document.registerProcessor = dependant => {
  Processor = dependant
}

module.exports = Document
Document.default = Document


/***/ }),

/***/ 346:
/***/ ((module) => {

"use strict";


const DEFAULT_RAW = {
  after: '\n',
  beforeClose: '\n',
  beforeComment: '\n',
  beforeDecl: '\n',
  beforeOpen: ' ',
  beforeRule: '\n',
  colon: ': ',
  commentLeft: ' ',
  commentRight: ' ',
  emptyBody: '',
  indent: '    ',
  semicolon: false
}

function capitalize(str) {
  return str[0].toUpperCase() + str.slice(1)
}

class Stringifier {
  constructor(builder) {
    this.builder = builder
  }

  atrule(node, semicolon) {
    let name = '@' + node.name
    let params = node.params ? this.rawValue(node, 'params') : ''

    if (typeof node.raws.afterName !== 'undefined') {
      name += node.raws.afterName
    } else if (params) {
      name += ' '
    }

    if (node.nodes) {
      this.block(node, name + params)
    } else {
      let end = (node.raws.between || '') + (semicolon ? ';' : '')
      this.builder(name + params + end, node)
    }
  }

  beforeAfter(node, detect) {
    let value
    if (node.type === 'decl') {
      value = this.raw(node, null, 'beforeDecl')
    } else if (node.type === 'comment') {
      value = this.raw(node, null, 'beforeComment')
    } else if (detect === 'before') {
      value = this.raw(node, null, 'beforeRule')
    } else {
      value = this.raw(node, null, 'beforeClose')
    }

    let buf = node.parent
    let depth = 0
    while (buf && buf.type !== 'root') {
      depth += 1
      buf = buf.parent
    }

    if (value.includes('\n')) {
      let indent = this.raw(node, null, 'indent')
      if (indent.length) {
        for (let step = 0; step < depth; step++) value += indent
      }
    }

    return value
  }

  block(node, start) {
    let between = this.raw(node, 'between', 'beforeOpen')
    this.builder(start + between + '{', node, 'start')

    let after
    if (node.nodes && node.nodes.length) {
      this.body(node)
      after = this.raw(node, 'after')
    } else {
      after = this.raw(node, 'after', 'emptyBody')
    }

    if (after) this.builder(after)
    this.builder('}', node, 'end')
  }

  body(node) {
    let last = node.nodes.length - 1
    while (last > 0) {
      if (node.nodes[last].type !== 'comment') break
      last -= 1
    }

    let semicolon = this.raw(node, 'semicolon')
    for (let i = 0; i < node.nodes.length; i++) {
      let child = node.nodes[i]
      let before = this.raw(child, 'before')
      if (before) this.builder(before)
      this.stringify(child, last !== i || semicolon)
    }
  }

  comment(node) {
    let left = this.raw(node, 'left', 'commentLeft')
    let right = this.raw(node, 'right', 'commentRight')
    this.builder('/*' + left + node.text + right + '*/', node)
  }

  decl(node, semicolon) {
    let between = this.raw(node, 'between', 'colon')
    let string = node.prop + between + this.rawValue(node, 'value')

    if (node.important) {
      string += node.raws.important || ' !important'
    }

    if (semicolon) string += ';'
    this.builder(string, node)
  }

  document(node) {
    this.body(node)
  }

  raw(node, own, detect) {
    let value
    if (!detect) detect = own

    // Already had
    if (own) {
      value = node.raws[own]
      if (typeof value !== 'undefined') return value
    }

    let parent = node.parent

    if (detect === 'before') {
      // Hack for first rule in CSS
      if (!parent || (parent.type === 'root' && parent.first === node)) {
        return ''
      }

      // `root` nodes in `document` should use only their own raws
      if (parent && parent.type === 'document') {
        return ''
      }
    }

    // Floating child without parent
    if (!parent) return DEFAULT_RAW[detect]

    // Detect style by other nodes
    let root = node.root()
    if (!root.rawCache) root.rawCache = {}
    if (typeof root.rawCache[detect] !== 'undefined') {
      return root.rawCache[detect]
    }

    if (detect === 'before' || detect === 'after') {
      return this.beforeAfter(node, detect)
    } else {
      let method = 'raw' + capitalize(detect)
      if (this[method]) {
        value = this[method](root, node)
      } else {
        root.walk(i => {
          value = i.raws[own]
          if (typeof value !== 'undefined') return false
        })
      }
    }

    if (typeof value === 'undefined') value = DEFAULT_RAW[detect]

    root.rawCache[detect] = value
    return value
  }

  rawBeforeClose(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length > 0) {
        if (typeof i.raws.after !== 'undefined') {
          value = i.raws.after
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '')
          }
          return false
        }
      }
    })
    if (value) value = value.replace(/\S/g, '')
    return value
  }

  rawBeforeComment(root, node) {
    let value
    root.walkComments(i => {
      if (typeof i.raws.before !== 'undefined') {
        value = i.raws.before
        if (value.includes('\n')) {
          value = value.replace(/[^\n]+$/, '')
        }
        return false
      }
    })
    if (typeof value === 'undefined') {
      value = this.raw(node, null, 'beforeDecl')
    } else if (value) {
      value = value.replace(/\S/g, '')
    }
    return value
  }

  rawBeforeDecl(root, node) {
    let value
    root.walkDecls(i => {
      if (typeof i.raws.before !== 'undefined') {
        value = i.raws.before
        if (value.includes('\n')) {
          value = value.replace(/[^\n]+$/, '')
        }
        return false
      }
    })
    if (typeof value === 'undefined') {
      value = this.raw(node, null, 'beforeRule')
    } else if (value) {
      value = value.replace(/\S/g, '')
    }
    return value
  }

  rawBeforeOpen(root) {
    let value
    root.walk(i => {
      if (i.type !== 'decl') {
        value = i.raws.between
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawBeforeRule(root) {
    let value
    root.walk(i => {
      if (i.nodes && (i.parent !== root || root.first !== i)) {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '')
          }
          return false
        }
      }
    })
    if (value) value = value.replace(/\S/g, '')
    return value
  }

  rawColon(root) {
    let value
    root.walkDecls(i => {
      if (typeof i.raws.between !== 'undefined') {
        value = i.raws.between.replace(/[^\s:]/g, '')
        return false
      }
    })
    return value
  }

  rawEmptyBody(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length === 0) {
        value = i.raws.after
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawIndent(root) {
    if (root.raws.indent) return root.raws.indent
    let value
    root.walk(i => {
      let p = i.parent
      if (p && p !== root && p.parent && p.parent === root) {
        if (typeof i.raws.before !== 'undefined') {
          let parts = i.raws.before.split('\n')
          value = parts[parts.length - 1]
          value = value.replace(/\S/g, '')
          return false
        }
      }
    })
    return value
  }

  rawSemicolon(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length && i.last.type === 'decl') {
        value = i.raws.semicolon
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawValue(node, prop) {
    let value = node[prop]
    let raw = node.raws[prop]
    if (raw && raw.value === value) {
      return raw.raw
    }

    return value
  }

  root(node) {
    this.body(node)
    if (node.raws.after) this.builder(node.raws.after)
  }

  rule(node) {
    this.block(node, this.rawValue(node, 'selector'))
    if (node.raws.ownSemicolon) {
      this.builder(node.raws.ownSemicolon, node, 'end')
    }
  }

  stringify(node, semicolon) {
    /* c8 ignore start */
    if (!this[node.type]) {
      throw new Error(
        'Unknown AST node type ' +
          node.type +
          '. ' +
          'Maybe you need to change PostCSS stringifier.'
      )
    }
    /* c8 ignore stop */
    this[node.type](node, semicolon)
  }
}

module.exports = Stringifier
Stringifier.default = Stringifier


/***/ }),

/***/ 356:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let pico = __webpack_require__(2775)

let terminalHighlight = __webpack_require__(9746)

class CssSyntaxError extends Error {
  constructor(message, line, column, source, file, plugin) {
    super(message)
    this.name = 'CssSyntaxError'
    this.reason = message

    if (file) {
      this.file = file
    }
    if (source) {
      this.source = source
    }
    if (plugin) {
      this.plugin = plugin
    }
    if (typeof line !== 'undefined' && typeof column !== 'undefined') {
      if (typeof line === 'number') {
        this.line = line
        this.column = column
      } else {
        this.line = line.line
        this.column = line.column
        this.endLine = column.line
        this.endColumn = column.column
      }
    }

    this.setMessage()

    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, CssSyntaxError)
    }
  }

  setMessage() {
    this.message = this.plugin ? this.plugin + ': ' : ''
    this.message += this.file ? this.file : '<css input>'
    if (typeof this.line !== 'undefined') {
      this.message += ':' + this.line + ':' + this.column
    }
    this.message += ': ' + this.reason
  }

  showSourceCode(color) {
    if (!this.source) return ''

    let css = this.source
    if (color == null) color = pico.isColorSupported

    let aside = text => text
    let mark = text => text
    let highlight = text => text
    if (color) {
      let { bold, gray, red } = pico.createColors(true)
      mark = text => bold(red(text))
      aside = text => gray(text)
      if (terminalHighlight) {
        highlight = text => terminalHighlight(text)
      }
    }

    let lines = css.split(/\r?\n/)
    let start = Math.max(this.line - 3, 0)
    let end = Math.min(this.line + 2, lines.length)
    let maxWidth = String(end).length

    return lines
      .slice(start, end)
      .map((line, index) => {
        let number = start + 1 + index
        let gutter = ' ' + (' ' + number).slice(-maxWidth) + ' | '
        if (number === this.line) {
          if (line.length > 160) {
            let padding = 20
            let subLineStart = Math.max(0, this.column - padding)
            let subLineEnd = Math.max(
              this.column + padding,
              this.endColumn + padding
            )
            let subLine = line.slice(subLineStart, subLineEnd)

            let spacing =
              aside(gutter.replace(/\d/g, ' ')) +
              line
                .slice(0, Math.min(this.column - 1, padding - 1))
                .replace(/[^\t]/g, ' ')

            return (
              mark('>') +
              aside(gutter) +
              highlight(subLine) +
              '\n ' +
              spacing +
              mark('^')
            )
          }

          let spacing =
            aside(gutter.replace(/\d/g, ' ')) +
            line.slice(0, this.column - 1).replace(/[^\t]/g, ' ')

          return (
            mark('>') +
            aside(gutter) +
            highlight(line) +
            '\n ' +
            spacing +
            mark('^')
          )
        }

        return ' ' + aside(gutter) + highlight(line)
      })
      .join('\n')
  }

  toString() {
    let code = this.showSourceCode()
    if (code) {
      code = '\n\n' + code + '\n'
    }
    return this.name + ': ' + this.message + code
  }
}

module.exports = CssSyntaxError
CssSyntaxError.default = CssSyntaxError


/***/ }),

/***/ 448:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)
let Document = __webpack_require__(271)
let MapGenerator = __webpack_require__(1670)
let parse = __webpack_require__(4295)
let Result = __webpack_require__(9055)
let Root = __webpack_require__(9434)
let stringify = __webpack_require__(633)
let { isClean, my } = __webpack_require__(1381)
let warnOnce = __webpack_require__(3122)

const TYPE_TO_CLASS_NAME = {
  atrule: 'AtRule',
  comment: 'Comment',
  decl: 'Declaration',
  document: 'Document',
  root: 'Root',
  rule: 'Rule'
}

const PLUGIN_PROPS = {
  AtRule: true,
  AtRuleExit: true,
  Comment: true,
  CommentExit: true,
  Declaration: true,
  DeclarationExit: true,
  Document: true,
  DocumentExit: true,
  Once: true,
  OnceExit: true,
  postcssPlugin: true,
  prepare: true,
  Root: true,
  RootExit: true,
  Rule: true,
  RuleExit: true
}

const NOT_VISITORS = {
  Once: true,
  postcssPlugin: true,
  prepare: true
}

const CHILDREN = 0

function isPromise(obj) {
  return typeof obj === 'object' && typeof obj.then === 'function'
}

function getEvents(node) {
  let key = false
  let type = TYPE_TO_CLASS_NAME[node.type]
  if (node.type === 'decl') {
    key = node.prop.toLowerCase()
  } else if (node.type === 'atrule') {
    key = node.name.toLowerCase()
  }

  if (key && node.append) {
    return [
      type,
      type + '-' + key,
      CHILDREN,
      type + 'Exit',
      type + 'Exit-' + key
    ]
  } else if (key) {
    return [type, type + '-' + key, type + 'Exit', type + 'Exit-' + key]
  } else if (node.append) {
    return [type, CHILDREN, type + 'Exit']
  } else {
    return [type, type + 'Exit']
  }
}

function toStack(node) {
  let events
  if (node.type === 'document') {
    events = ['Document', CHILDREN, 'DocumentExit']
  } else if (node.type === 'root') {
    events = ['Root', CHILDREN, 'RootExit']
  } else {
    events = getEvents(node)
  }

  return {
    eventIndex: 0,
    events,
    iterator: 0,
    node,
    visitorIndex: 0,
    visitors: []
  }
}

function cleanMarks(node) {
  node[isClean] = false
  if (node.nodes) node.nodes.forEach(i => cleanMarks(i))
  return node
}

let postcss = {}

class LazyResult {
  get content() {
    return this.stringify().content
  }

  get css() {
    return this.stringify().css
  }

  get map() {
    return this.stringify().map
  }

  get messages() {
    return this.sync().messages
  }

  get opts() {
    return this.result.opts
  }

  get processor() {
    return this.result.processor
  }

  get root() {
    return this.sync().root
  }

  get [Symbol.toStringTag]() {
    return 'LazyResult'
  }

  constructor(processor, css, opts) {
    this.stringified = false
    this.processed = false

    let root
    if (
      typeof css === 'object' &&
      css !== null &&
      (css.type === 'root' || css.type === 'document')
    ) {
      root = cleanMarks(css)
    } else if (css instanceof LazyResult || css instanceof Result) {
      root = cleanMarks(css.root)
      if (css.map) {
        if (typeof opts.map === 'undefined') opts.map = {}
        if (!opts.map.inline) opts.map.inline = false
        opts.map.prev = css.map
      }
    } else {
      let parser = parse
      if (opts.syntax) parser = opts.syntax.parse
      if (opts.parser) parser = opts.parser
      if (parser.parse) parser = parser.parse

      try {
        root = parser(css, opts)
      } catch (error) {
        this.processed = true
        this.error = error
      }

      if (root && !root[my]) {
        /* c8 ignore next 2 */
        Container.rebuild(root)
      }
    }

    this.result = new Result(processor, root, opts)
    this.helpers = { ...postcss, postcss, result: this.result }
    this.plugins = this.processor.plugins.map(plugin => {
      if (typeof plugin === 'object' && plugin.prepare) {
        return { ...plugin, ...plugin.prepare(this.result) }
      } else {
        return plugin
      }
    })
  }

  async() {
    if (this.error) return Promise.reject(this.error)
    if (this.processed) return Promise.resolve(this.result)
    if (!this.processing) {
      this.processing = this.runAsync()
    }
    return this.processing
  }

  catch(onRejected) {
    return this.async().catch(onRejected)
  }

  finally(onFinally) {
    return this.async().then(onFinally, onFinally)
  }

  getAsyncError() {
    throw new Error('Use process(css).then(cb) to work with async plugins')
  }

  handleError(error, node) {
    let plugin = this.result.lastPlugin
    try {
      if (node) node.addToError(error)
      this.error = error
      if (error.name === 'CssSyntaxError' && !error.plugin) {
        error.plugin = plugin.postcssPlugin
        error.setMessage()
      } else if (plugin.postcssVersion) {
        if (false) {}
      }
    } catch (err) {
      /* c8 ignore next 3 */
      // eslint-disable-next-line no-console
      if (console && console.error) console.error(err)
    }
    return error
  }

  prepareVisitors() {
    this.listeners = {}
    let add = (plugin, type, cb) => {
      if (!this.listeners[type]) this.listeners[type] = []
      this.listeners[type].push([plugin, cb])
    }
    for (let plugin of this.plugins) {
      if (typeof plugin === 'object') {
        for (let event in plugin) {
          if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
            throw new Error(
              `Unknown event ${event} in ${plugin.postcssPlugin}. ` +
                `Try to update PostCSS (${this.processor.version} now).`
            )
          }
          if (!NOT_VISITORS[event]) {
            if (typeof plugin[event] === 'object') {
              for (let filter in plugin[event]) {
                if (filter === '*') {
                  add(plugin, event, plugin[event][filter])
                } else {
                  add(
                    plugin,
                    event + '-' + filter.toLowerCase(),
                    plugin[event][filter]
                  )
                }
              }
            } else if (typeof plugin[event] === 'function') {
              add(plugin, event, plugin[event])
            }
          }
        }
      }
    }
    this.hasListener = Object.keys(this.listeners).length > 0
  }

  async runAsync() {
    this.plugin = 0
    for (let i = 0; i < this.plugins.length; i++) {
      let plugin = this.plugins[i]
      let promise = this.runOnRoot(plugin)
      if (isPromise(promise)) {
        try {
          await promise
        } catch (error) {
          throw this.handleError(error)
        }
      }
    }

    this.prepareVisitors()
    if (this.hasListener) {
      let root = this.result.root
      while (!root[isClean]) {
        root[isClean] = true
        let stack = [toStack(root)]
        while (stack.length > 0) {
          let promise = this.visitTick(stack)
          if (isPromise(promise)) {
            try {
              await promise
            } catch (e) {
              let node = stack[stack.length - 1].node
              throw this.handleError(e, node)
            }
          }
        }
      }

      if (this.listeners.OnceExit) {
        for (let [plugin, visitor] of this.listeners.OnceExit) {
          this.result.lastPlugin = plugin
          try {
            if (root.type === 'document') {
              let roots = root.nodes.map(subRoot =>
                visitor(subRoot, this.helpers)
              )

              await Promise.all(roots)
            } else {
              await visitor(root, this.helpers)
            }
          } catch (e) {
            throw this.handleError(e)
          }
        }
      }
    }

    this.processed = true
    return this.stringify()
  }

  runOnRoot(plugin) {
    this.result.lastPlugin = plugin
    try {
      if (typeof plugin === 'object' && plugin.Once) {
        if (this.result.root.type === 'document') {
          let roots = this.result.root.nodes.map(root =>
            plugin.Once(root, this.helpers)
          )

          if (isPromise(roots[0])) {
            return Promise.all(roots)
          }

          return roots
        }

        return plugin.Once(this.result.root, this.helpers)
      } else if (typeof plugin === 'function') {
        return plugin(this.result.root, this.result)
      }
    } catch (error) {
      throw this.handleError(error)
    }
  }

  stringify() {
    if (this.error) throw this.error
    if (this.stringified) return this.result
    this.stringified = true

    this.sync()

    let opts = this.result.opts
    let str = stringify
    if (opts.syntax) str = opts.syntax.stringify
    if (opts.stringifier) str = opts.stringifier
    if (str.stringify) str = str.stringify

    let map = new MapGenerator(str, this.result.root, this.result.opts)
    let data = map.generate()
    this.result.css = data[0]
    this.result.map = data[1]

    return this.result
  }

  sync() {
    if (this.error) throw this.error
    if (this.processed) return this.result
    this.processed = true

    if (this.processing) {
      throw this.getAsyncError()
    }

    for (let plugin of this.plugins) {
      let promise = this.runOnRoot(plugin)
      if (isPromise(promise)) {
        throw this.getAsyncError()
      }
    }

    this.prepareVisitors()
    if (this.hasListener) {
      let root = this.result.root
      while (!root[isClean]) {
        root[isClean] = true
        this.walkSync(root)
      }
      if (this.listeners.OnceExit) {
        if (root.type === 'document') {
          for (let subRoot of root.nodes) {
            this.visitSync(this.listeners.OnceExit, subRoot)
          }
        } else {
          this.visitSync(this.listeners.OnceExit, root)
        }
      }
    }

    return this.result
  }

  then(onFulfilled, onRejected) {
    if (false) {}
    return this.async().then(onFulfilled, onRejected)
  }

  toString() {
    return this.css
  }

  visitSync(visitors, node) {
    for (let [plugin, visitor] of visitors) {
      this.result.lastPlugin = plugin
      let promise
      try {
        promise = visitor(node, this.helpers)
      } catch (e) {
        throw this.handleError(e, node.proxyOf)
      }
      if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
        return true
      }
      if (isPromise(promise)) {
        throw this.getAsyncError()
      }
    }
  }

  visitTick(stack) {
    let visit = stack[stack.length - 1]
    let { node, visitors } = visit

    if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
      stack.pop()
      return
    }

    if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
      let [plugin, visitor] = visitors[visit.visitorIndex]
      visit.visitorIndex += 1
      if (visit.visitorIndex === visitors.length) {
        visit.visitors = []
        visit.visitorIndex = 0
      }
      this.result.lastPlugin = plugin
      try {
        return visitor(node.toProxy(), this.helpers)
      } catch (e) {
        throw this.handleError(e, node)
      }
    }

    if (visit.iterator !== 0) {
      let iterator = visit.iterator
      let child
      while ((child = node.nodes[node.indexes[iterator]])) {
        node.indexes[iterator] += 1
        if (!child[isClean]) {
          child[isClean] = true
          stack.push(toStack(child))
          return
        }
      }
      visit.iterator = 0
      delete node.indexes[iterator]
    }

    let events = visit.events
    while (visit.eventIndex < events.length) {
      let event = events[visit.eventIndex]
      visit.eventIndex += 1
      if (event === CHILDREN) {
        if (node.nodes && node.nodes.length) {
          node[isClean] = true
          visit.iterator = node.getIterator()
        }
        return
      } else if (this.listeners[event]) {
        visit.visitors = this.listeners[event]
        return
      }
    }
    stack.pop()
  }

  walkSync(node) {
    node[isClean] = true
    let events = getEvents(node)
    for (let event of events) {
      if (event === CHILDREN) {
        if (node.nodes) {
          node.each(child => {
            if (!child[isClean]) this.walkSync(child)
          })
        }
      } else {
        let visitors = this.listeners[event]
        if (visitors) {
          if (this.visitSync(visitors, node.toProxy())) return
        }
      }
    }
  }

  warnings() {
    return this.sync().warnings()
  }
}

LazyResult.registerPostcss = dependant => {
  postcss = dependant
}

module.exports = LazyResult
LazyResult.default = LazyResult

Root.registerLazyResult(LazyResult)
Document.registerLazyResult(LazyResult)


/***/ }),

/***/ 461:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Load in dependencies
var computedStyle = __webpack_require__(6109);

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ 628:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(4067);

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ 633:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Stringifier = __webpack_require__(346)

function stringify(node, builder) {
  let str = new Stringifier(builder)
  str.stringify(node)
}

module.exports = stringify
stringify.default = stringify


/***/ }),

/***/ 683:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Comment = __webpack_require__(6589)
let Declaration = __webpack_require__(1516)
let Node = __webpack_require__(7490)
let { isClean, my } = __webpack_require__(1381)

let AtRule, parse, Root, Rule

function cleanSource(nodes) {
  return nodes.map(i => {
    if (i.nodes) i.nodes = cleanSource(i.nodes)
    delete i.source
    return i
  })
}

function markTreeDirty(node) {
  node[isClean] = false
  if (node.proxyOf.nodes) {
    for (let i of node.proxyOf.nodes) {
      markTreeDirty(i)
    }
  }
}

class Container extends Node {
  get first() {
    if (!this.proxyOf.nodes) return undefined
    return this.proxyOf.nodes[0]
  }

  get last() {
    if (!this.proxyOf.nodes) return undefined
    return this.proxyOf.nodes[this.proxyOf.nodes.length - 1]
  }

  append(...children) {
    for (let child of children) {
      let nodes = this.normalize(child, this.last)
      for (let node of nodes) this.proxyOf.nodes.push(node)
    }

    this.markDirty()

    return this
  }

  cleanRaws(keepBetween) {
    super.cleanRaws(keepBetween)
    if (this.nodes) {
      for (let node of this.nodes) node.cleanRaws(keepBetween)
    }
  }

  each(callback) {
    if (!this.proxyOf.nodes) return undefined
    let iterator = this.getIterator()

    let index, result
    while (this.indexes[iterator] < this.proxyOf.nodes.length) {
      index = this.indexes[iterator]
      result = callback(this.proxyOf.nodes[index], index)
      if (result === false) break

      this.indexes[iterator] += 1
    }

    delete this.indexes[iterator]
    return result
  }

  every(condition) {
    return this.nodes.every(condition)
  }

  getIterator() {
    if (!this.lastEach) this.lastEach = 0
    if (!this.indexes) this.indexes = {}

    this.lastEach += 1
    let iterator = this.lastEach
    this.indexes[iterator] = 0

    return iterator
  }

  getProxyProcessor() {
    return {
      get(node, prop) {
        if (prop === 'proxyOf') {
          return node
        } else if (!node[prop]) {
          return node[prop]
        } else if (
          prop === 'each' ||
          (typeof prop === 'string' && prop.startsWith('walk'))
        ) {
          return (...args) => {
            return node[prop](
              ...args.map(i => {
                if (typeof i === 'function') {
                  return (child, index) => i(child.toProxy(), index)
                } else {
                  return i
                }
              })
            )
          }
        } else if (prop === 'every' || prop === 'some') {
          return cb => {
            return node[prop]((child, ...other) =>
              cb(child.toProxy(), ...other)
            )
          }
        } else if (prop === 'root') {
          return () => node.root().toProxy()
        } else if (prop === 'nodes') {
          return node.nodes.map(i => i.toProxy())
        } else if (prop === 'first' || prop === 'last') {
          return node[prop].toProxy()
        } else {
          return node[prop]
        }
      },

      set(node, prop, value) {
        if (node[prop] === value) return true
        node[prop] = value
        if (prop === 'name' || prop === 'params' || prop === 'selector') {
          node.markDirty()
        }
        return true
      }
    }
  }

  index(child) {
    if (typeof child === 'number') return child
    if (child.proxyOf) child = child.proxyOf
    return this.proxyOf.nodes.indexOf(child)
  }

  insertAfter(exist, add) {
    let existIndex = this.index(exist)
    let nodes = this.normalize(add, this.proxyOf.nodes[existIndex]).reverse()
    existIndex = this.index(exist)
    for (let node of nodes) this.proxyOf.nodes.splice(existIndex + 1, 0, node)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (existIndex < index) {
        this.indexes[id] = index + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  insertBefore(exist, add) {
    let existIndex = this.index(exist)
    let type = existIndex === 0 ? 'prepend' : false
    let nodes = this.normalize(
      add,
      this.proxyOf.nodes[existIndex],
      type
    ).reverse()
    existIndex = this.index(exist)
    for (let node of nodes) this.proxyOf.nodes.splice(existIndex, 0, node)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (existIndex <= index) {
        this.indexes[id] = index + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  normalize(nodes, sample) {
    if (typeof nodes === 'string') {
      nodes = cleanSource(parse(nodes).nodes)
    } else if (typeof nodes === 'undefined') {
      nodes = []
    } else if (Array.isArray(nodes)) {
      nodes = nodes.slice(0)
      for (let i of nodes) {
        if (i.parent) i.parent.removeChild(i, 'ignore')
      }
    } else if (nodes.type === 'root' && this.type !== 'document') {
      nodes = nodes.nodes.slice(0)
      for (let i of nodes) {
        if (i.parent) i.parent.removeChild(i, 'ignore')
      }
    } else if (nodes.type) {
      nodes = [nodes]
    } else if (nodes.prop) {
      if (typeof nodes.value === 'undefined') {
        throw new Error('Value field is missed in node creation')
      } else if (typeof nodes.value !== 'string') {
        nodes.value = String(nodes.value)
      }
      nodes = [new Declaration(nodes)]
    } else if (nodes.selector || nodes.selectors) {
      nodes = [new Rule(nodes)]
    } else if (nodes.name) {
      nodes = [new AtRule(nodes)]
    } else if (nodes.text) {
      nodes = [new Comment(nodes)]
    } else {
      throw new Error('Unknown node type in node creation')
    }

    let processed = nodes.map(i => {
      /* c8 ignore next */
      if (!i[my]) Container.rebuild(i)
      i = i.proxyOf
      if (i.parent) i.parent.removeChild(i)
      if (i[isClean]) markTreeDirty(i)

      if (!i.raws) i.raws = {}
      if (typeof i.raws.before === 'undefined') {
        if (sample && typeof sample.raws.before !== 'undefined') {
          i.raws.before = sample.raws.before.replace(/\S/g, '')
        }
      }
      i.parent = this.proxyOf
      return i
    })

    return processed
  }

  prepend(...children) {
    children = children.reverse()
    for (let child of children) {
      let nodes = this.normalize(child, this.first, 'prepend').reverse()
      for (let node of nodes) this.proxyOf.nodes.unshift(node)
      for (let id in this.indexes) {
        this.indexes[id] = this.indexes[id] + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  push(child) {
    child.parent = this
    this.proxyOf.nodes.push(child)
    return this
  }

  removeAll() {
    for (let node of this.proxyOf.nodes) node.parent = undefined
    this.proxyOf.nodes = []

    this.markDirty()

    return this
  }

  removeChild(child) {
    child = this.index(child)
    this.proxyOf.nodes[child].parent = undefined
    this.proxyOf.nodes.splice(child, 1)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (index >= child) {
        this.indexes[id] = index - 1
      }
    }

    this.markDirty()

    return this
  }

  replaceValues(pattern, opts, callback) {
    if (!callback) {
      callback = opts
      opts = {}
    }

    this.walkDecls(decl => {
      if (opts.props && !opts.props.includes(decl.prop)) return
      if (opts.fast && !decl.value.includes(opts.fast)) return

      decl.value = decl.value.replace(pattern, callback)
    })

    this.markDirty()

    return this
  }

  some(condition) {
    return this.nodes.some(condition)
  }

  walk(callback) {
    return this.each((child, i) => {
      let result
      try {
        result = callback(child, i)
      } catch (e) {
        throw child.addToError(e)
      }
      if (result !== false && child.walk) {
        result = child.walk(callback)
      }

      return result
    })
  }

  walkAtRules(name, callback) {
    if (!callback) {
      callback = name
      return this.walk((child, i) => {
        if (child.type === 'atrule') {
          return callback(child, i)
        }
      })
    }
    if (name instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'atrule' && name.test(child.name)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'atrule' && child.name === name) {
        return callback(child, i)
      }
    })
  }

  walkComments(callback) {
    return this.walk((child, i) => {
      if (child.type === 'comment') {
        return callback(child, i)
      }
    })
  }

  walkDecls(prop, callback) {
    if (!callback) {
      callback = prop
      return this.walk((child, i) => {
        if (child.type === 'decl') {
          return callback(child, i)
        }
      })
    }
    if (prop instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'decl' && prop.test(child.prop)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'decl' && child.prop === prop) {
        return callback(child, i)
      }
    })
  }

  walkRules(selector, callback) {
    if (!callback) {
      callback = selector

      return this.walk((child, i) => {
        if (child.type === 'rule') {
          return callback(child, i)
        }
      })
    }
    if (selector instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'rule' && selector.test(child.selector)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'rule' && child.selector === selector) {
        return callback(child, i)
      }
    })
  }
}

Container.registerParse = dependant => {
  parse = dependant
}

Container.registerRule = dependant => {
  Rule = dependant
}

Container.registerAtRule = dependant => {
  AtRule = dependant
}

Container.registerRoot = dependant => {
  Root = dependant
}

module.exports = Container
Container.default = Container

/* c8 ignore start */
Container.rebuild = node => {
  if (node.type === 'atrule') {
    Object.setPrototypeOf(node, AtRule.prototype)
  } else if (node.type === 'rule') {
    Object.setPrototypeOf(node, Rule.prototype)
  } else if (node.type === 'decl') {
    Object.setPrototypeOf(node, Declaration.prototype)
  } else if (node.type === 'comment') {
    Object.setPrototypeOf(node, Comment.prototype)
  } else if (node.type === 'root') {
    Object.setPrototypeOf(node, Root.prototype)
  }

  node[my] = true

  if (node.nodes) {
    node.nodes.forEach(child => {
      Container.rebuild(child)
    })
  }
}
/* c8 ignore stop */


/***/ }),

/***/ 1087:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule isEventSupported
 */



var ExecutionEnvironment = __webpack_require__(8202);

var useHasFeature;
if (ExecutionEnvironment.canUseDOM) {
  useHasFeature =
    document.implementation &&
    document.implementation.hasFeature &&
    // always returns true in newer browsers as per the standard.
    // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature
    document.implementation.hasFeature('', '') !== true;
}

/**
 * Checks if an event is supported in the current execution environment.
 *
 * NOTE: This will not work correctly for non-generic events such as `change`,
 * `reset`, `load`, `error`, and `select`.
 *
 * Borrows from Modernizr.
 *
 * @param {string} eventNameSuffix Event name, e.g. "click".
 * @param {?boolean} capture Check if the capture phase is supported.
 * @return {boolean} True if the event is supported.
 * @internal
 * @license Modernizr 3.0.0pre (Custom Build) | MIT
 */
function isEventSupported(eventNameSuffix, capture) {
  if (!ExecutionEnvironment.canUseDOM ||
      capture && !('addEventListener' in document)) {
    return false;
  }

  var eventName = 'on' + eventNameSuffix;
  var isSupported = eventName in document;

  if (!isSupported) {
    var element = document.createElement('div');
    element.setAttribute(eventName, 'return;');
    isSupported = typeof element[eventName] === 'function';
  }

  if (!isSupported && useHasFeature && eventNameSuffix === 'wheel') {
    // This is the only way to test support for the `wheel` event in IE9+.
    isSupported = document.implementation.hasFeature('Events.wheel', '3.0');
  }

  return isSupported;
}

module.exports = isEventSupported;


/***/ }),

/***/ 1326:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

class AtRule extends Container {
  constructor(defaults) {
    super(defaults)
    this.type = 'atrule'
  }

  append(...children) {
    if (!this.proxyOf.nodes) this.nodes = []
    return super.append(...children)
  }

  prepend(...children) {
    if (!this.proxyOf.nodes) this.nodes = []
    return super.prepend(...children)
  }
}

module.exports = AtRule
AtRule.default = AtRule

Container.registerAtRule(AtRule)


/***/ }),

/***/ 1381:
/***/ ((module) => {

"use strict";


module.exports.isClean = Symbol('isClean')

module.exports.my = Symbol('my')


/***/ }),

/***/ 1443:
/***/ ((module) => {

module.exports = function postcssPrefixSelector(options) {
  const prefix = options.prefix;
  const prefixWithSpace = /\s+$/.test(prefix) ? prefix : `${prefix} `;
  const ignoreFiles = options.ignoreFiles ? [].concat(options.ignoreFiles) : [];
  const includeFiles = options.includeFiles
    ? [].concat(options.includeFiles)
    : [];

  return function (root) {
    if (
      ignoreFiles.length &&
      root.source.input.file &&
      isFileInArray(root.source.input.file, ignoreFiles)
    ) {
      return;
    }
    if (
      includeFiles.length &&
      root.source.input.file &&
      !isFileInArray(root.source.input.file, includeFiles)
    ) {
      return;
    }

    root.walkRules((rule) => {
      const keyframeRules = [
        'keyframes',
        '-webkit-keyframes',
        '-moz-keyframes',
        '-o-keyframes',
        '-ms-keyframes',
      ];

      if (rule.parent && keyframeRules.includes(rule.parent.name)) {
        return;
      }

      rule.selectors = rule.selectors.map((selector) => {
        if (options.exclude && excludeSelector(selector, options.exclude)) {
          return selector;
        }

        if (options.transform) {
          return options.transform(
            prefix,
            selector,
            prefixWithSpace + selector,
            root.source.input.file,
            rule
          );
        }

        return prefixWithSpace + selector;
      });
    });
  };
};

function isFileInArray(file, arr) {
  return arr.some((ruleOrString) => {
    if (ruleOrString instanceof RegExp) {
      return ruleOrString.test(file);
    }

    return file.includes(ruleOrString);
  });
}

function excludeSelector(selector, excludeArr) {
  return excludeArr.some((excludeRule) => {
    if (excludeRule instanceof RegExp) {
      return excludeRule.test(selector);
    }

    return selector === excludeRule;
  });
}


/***/ }),

/***/ 1516:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Node = __webpack_require__(7490)

class Declaration extends Node {
  get variable() {
    return this.prop.startsWith('--') || this.prop[0] === '$'
  }

  constructor(defaults) {
    if (
      defaults &&
      typeof defaults.value !== 'undefined' &&
      typeof defaults.value !== 'string'
    ) {
      defaults = { ...defaults, value: String(defaults.value) }
    }
    super(defaults)
    this.type = 'decl'
  }
}

module.exports = Declaration
Declaration.default = Declaration


/***/ }),

/***/ 1524:
/***/ ((module) => {

var minus = "-".charCodeAt(0);
var plus = "+".charCodeAt(0);
var dot = ".".charCodeAt(0);
var exp = "e".charCodeAt(0);
var EXP = "E".charCodeAt(0);

// Check if three code points would start a number
// https://www.w3.org/TR/css-syntax-3/#starts-with-a-number
function likeNumber(value) {
  var code = value.charCodeAt(0);
  var nextCode;

  if (code === plus || code === minus) {
    nextCode = value.charCodeAt(1);

    if (nextCode >= 48 && nextCode <= 57) {
      return true;
    }

    var nextNextCode = value.charCodeAt(2);

    if (nextCode === dot && nextNextCode >= 48 && nextNextCode <= 57) {
      return true;
    }

    return false;
  }

  if (code === dot) {
    nextCode = value.charCodeAt(1);

    if (nextCode >= 48 && nextCode <= 57) {
      return true;
    }

    return false;
  }

  if (code >= 48 && code <= 57) {
    return true;
  }

  return false;
}

// Consume a number
// https://www.w3.org/TR/css-syntax-3/#consume-number
module.exports = function(value) {
  var pos = 0;
  var length = value.length;
  var code;
  var nextCode;
  var nextNextCode;

  if (length === 0 || !likeNumber(value)) {
    return false;
  }

  code = value.charCodeAt(pos);

  if (code === plus || code === minus) {
    pos++;
  }

  while (pos < length) {
    code = value.charCodeAt(pos);

    if (code < 48 || code > 57) {
      break;
    }

    pos += 1;
  }

  code = value.charCodeAt(pos);
  nextCode = value.charCodeAt(pos + 1);

  if (code === dot && nextCode >= 48 && nextCode <= 57) {
    pos += 2;

    while (pos < length) {
      code = value.charCodeAt(pos);

      if (code < 48 || code > 57) {
        break;
      }

      pos += 1;
    }
  }

  code = value.charCodeAt(pos);
  nextCode = value.charCodeAt(pos + 1);
  nextNextCode = value.charCodeAt(pos + 2);

  if (
    (code === exp || code === EXP) &&
    ((nextCode >= 48 && nextCode <= 57) ||
      ((nextCode === plus || nextCode === minus) &&
        nextNextCode >= 48 &&
        nextNextCode <= 57))
  ) {
    pos += nextCode === plus || nextCode === minus ? 3 : 2;

    while (pos < length) {
      code = value.charCodeAt(pos);

      if (code < 48 || code > 57) {
        break;
      }

      pos += 1;
    }
  }

  return {
    number: value.slice(0, pos),
    unit: value.slice(pos)
  };
};


/***/ }),

/***/ 1544:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parse = __webpack_require__(8491);
var walk = __webpack_require__(3815);
var stringify = __webpack_require__(4725);

function ValueParser(value) {
  if (this instanceof ValueParser) {
    this.nodes = parse(value);
    return this;
  }
  return new ValueParser(value);
}

ValueParser.prototype.toString = function() {
  return Array.isArray(this.nodes) ? stringify(this.nodes) : "";
};

ValueParser.prototype.walk = function(cb, bubble) {
  walk(this.nodes, cb, bubble);
  return this;
};

ValueParser.unit = __webpack_require__(1524);

ValueParser.walk = walk;

ValueParser.stringify = stringify;

module.exports = ValueParser;


/***/ }),

/***/ 1609:
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ 1670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { dirname, relative, resolve, sep } = __webpack_require__(197)
let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)
let { pathToFileURL } = __webpack_require__(2739)

let Input = __webpack_require__(5380)

let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator)
let pathAvailable = Boolean(dirname && resolve && relative && sep)

class MapGenerator {
  constructor(stringify, root, opts, cssString) {
    this.stringify = stringify
    this.mapOpts = opts.map || {}
    this.root = root
    this.opts = opts
    this.css = cssString
    this.originalCSS = cssString
    this.usesFileUrls = !this.mapOpts.from && this.mapOpts.absolute

    this.memoizedFileURLs = new Map()
    this.memoizedPaths = new Map()
    this.memoizedURLs = new Map()
  }

  addAnnotation() {
    let content

    if (this.isInline()) {
      content =
        'data:application/json;base64,' + this.toBase64(this.map.toString())
    } else if (typeof this.mapOpts.annotation === 'string') {
      content = this.mapOpts.annotation
    } else if (typeof this.mapOpts.annotation === 'function') {
      content = this.mapOpts.annotation(this.opts.to, this.root)
    } else {
      content = this.outputFile() + '.map'
    }
    let eol = '\n'
    if (this.css.includes('\r\n')) eol = '\r\n'

    this.css += eol + '/*# sourceMappingURL=' + content + ' */'
  }

  applyPrevMaps() {
    for (let prev of this.previous()) {
      let from = this.toUrl(this.path(prev.file))
      let root = prev.root || dirname(prev.file)
      let map

      if (this.mapOpts.sourcesContent === false) {
        map = new SourceMapConsumer(prev.text)
        if (map.sourcesContent) {
          map.sourcesContent = null
        }
      } else {
        map = prev.consumer()
      }

      this.map.applySourceMap(map, from, this.toUrl(this.path(root)))
    }
  }

  clearAnnotation() {
    if (this.mapOpts.annotation === false) return

    if (this.root) {
      let node
      for (let i = this.root.nodes.length - 1; i >= 0; i--) {
        node = this.root.nodes[i]
        if (node.type !== 'comment') continue
        if (node.text.startsWith('# sourceMappingURL=')) {
          this.root.removeChild(i)
        }
      }
    } else if (this.css) {
      this.css = this.css.replace(/\n*\/\*#[\S\s]*?\*\/$/gm, '')
    }
  }

  generate() {
    this.clearAnnotation()
    if (pathAvailable && sourceMapAvailable && this.isMap()) {
      return this.generateMap()
    } else {
      let result = ''
      this.stringify(this.root, i => {
        result += i
      })
      return [result]
    }
  }

  generateMap() {
    if (this.root) {
      this.generateString()
    } else if (this.previous().length === 1) {
      let prev = this.previous()[0].consumer()
      prev.file = this.outputFile()
      this.map = SourceMapGenerator.fromSourceMap(prev, {
        ignoreInvalidMapping: true
      })
    } else {
      this.map = new SourceMapGenerator({
        file: this.outputFile(),
        ignoreInvalidMapping: true
      })
      this.map.addMapping({
        generated: { column: 0, line: 1 },
        original: { column: 0, line: 1 },
        source: this.opts.from
          ? this.toUrl(this.path(this.opts.from))
          : '<no source>'
      })
    }

    if (this.isSourcesContent()) this.setSourcesContent()
    if (this.root && this.previous().length > 0) this.applyPrevMaps()
    if (this.isAnnotation()) this.addAnnotation()

    if (this.isInline()) {
      return [this.css]
    } else {
      return [this.css, this.map]
    }
  }

  generateString() {
    this.css = ''
    this.map = new SourceMapGenerator({
      file: this.outputFile(),
      ignoreInvalidMapping: true
    })

    let line = 1
    let column = 1

    let noSource = '<no source>'
    let mapping = {
      generated: { column: 0, line: 0 },
      original: { column: 0, line: 0 },
      source: ''
    }

    let last, lines
    this.stringify(this.root, (str, node, type) => {
      this.css += str

      if (node && type !== 'end') {
        mapping.generated.line = line
        mapping.generated.column = column - 1
        if (node.source && node.source.start) {
          mapping.source = this.sourcePath(node)
          mapping.original.line = node.source.start.line
          mapping.original.column = node.source.start.column - 1
          this.map.addMapping(mapping)
        } else {
          mapping.source = noSource
          mapping.original.line = 1
          mapping.original.column = 0
          this.map.addMapping(mapping)
        }
      }

      lines = str.match(/\n/g)
      if (lines) {
        line += lines.length
        last = str.lastIndexOf('\n')
        column = str.length - last
      } else {
        column += str.length
      }

      if (node && type !== 'start') {
        let p = node.parent || { raws: {} }
        let childless =
          node.type === 'decl' || (node.type === 'atrule' && !node.nodes)
        if (!childless || node !== p.last || p.raws.semicolon) {
          if (node.source && node.source.end) {
            mapping.source = this.sourcePath(node)
            mapping.original.line = node.source.end.line
            mapping.original.column = node.source.end.column - 1
            mapping.generated.line = line
            mapping.generated.column = column - 2
            this.map.addMapping(mapping)
          } else {
            mapping.source = noSource
            mapping.original.line = 1
            mapping.original.column = 0
            mapping.generated.line = line
            mapping.generated.column = column - 1
            this.map.addMapping(mapping)
          }
        }
      }
    })
  }

  isAnnotation() {
    if (this.isInline()) {
      return true
    }
    if (typeof this.mapOpts.annotation !== 'undefined') {
      return this.mapOpts.annotation
    }
    if (this.previous().length) {
      return this.previous().some(i => i.annotation)
    }
    return true
  }

  isInline() {
    if (typeof this.mapOpts.inline !== 'undefined') {
      return this.mapOpts.inline
    }

    let annotation = this.mapOpts.annotation
    if (typeof annotation !== 'undefined' && annotation !== true) {
      return false
    }

    if (this.previous().length) {
      return this.previous().some(i => i.inline)
    }
    return true
  }

  isMap() {
    if (typeof this.opts.map !== 'undefined') {
      return !!this.opts.map
    }
    return this.previous().length > 0
  }

  isSourcesContent() {
    if (typeof this.mapOpts.sourcesContent !== 'undefined') {
      return this.mapOpts.sourcesContent
    }
    if (this.previous().length) {
      return this.previous().some(i => i.withContent())
    }
    return true
  }

  outputFile() {
    if (this.opts.to) {
      return this.path(this.opts.to)
    } else if (this.opts.from) {
      return this.path(this.opts.from)
    } else {
      return 'to.css'
    }
  }

  path(file) {
    if (this.mapOpts.absolute) return file
    if (file.charCodeAt(0) === 60 /* `<` */) return file
    if (/^\w+:\/\//.test(file)) return file
    let cached = this.memoizedPaths.get(file)
    if (cached) return cached

    let from = this.opts.to ? dirname(this.opts.to) : '.'

    if (typeof this.mapOpts.annotation === 'string') {
      from = dirname(resolve(from, this.mapOpts.annotation))
    }

    let path = relative(from, file)
    this.memoizedPaths.set(file, path)

    return path
  }

  previous() {
    if (!this.previousMaps) {
      this.previousMaps = []
      if (this.root) {
        this.root.walk(node => {
          if (node.source && node.source.input.map) {
            let map = node.source.input.map
            if (!this.previousMaps.includes(map)) {
              this.previousMaps.push(map)
            }
          }
        })
      } else {
        let input = new Input(this.originalCSS, this.opts)
        if (input.map) this.previousMaps.push(input.map)
      }
    }

    return this.previousMaps
  }

  setSourcesContent() {
    let already = {}
    if (this.root) {
      this.root.walk(node => {
        if (node.source) {
          let from = node.source.input.from
          if (from && !already[from]) {
            already[from] = true
            let fromUrl = this.usesFileUrls
              ? this.toFileUrl(from)
              : this.toUrl(this.path(from))
            this.map.setSourceContent(fromUrl, node.source.input.css)
          }
        }
      })
    } else if (this.css) {
      let from = this.opts.from
        ? this.toUrl(this.path(this.opts.from))
        : '<no source>'
      this.map.setSourceContent(from, this.css)
    }
  }

  sourcePath(node) {
    if (this.mapOpts.from) {
      return this.toUrl(this.mapOpts.from)
    } else if (this.usesFileUrls) {
      return this.toFileUrl(node.source.input.from)
    } else {
      return this.toUrl(this.path(node.source.input.from))
    }
  }

  toBase64(str) {
    if (Buffer) {
      return Buffer.from(str).toString('base64')
    } else {
      return window.btoa(unescape(encodeURIComponent(str)))
    }
  }

  toFileUrl(path) {
    let cached = this.memoizedFileURLs.get(path)
    if (cached) return cached

    if (pathToFileURL) {
      let fileURL = pathToFileURL(path).toString()
      this.memoizedFileURLs.set(path, fileURL)

      return fileURL
    } else {
      throw new Error(
        '`map.absolute` option is not available in this PostCSS build'
      )
    }
  }

  toUrl(path) {
    let cached = this.memoizedURLs.get(path)
    if (cached) return cached

    if (sep === '\\') {
      path = path.replace(/\\/g, '/')
    }

    let url = encodeURI(path).replace(/[#?]/g, encodeURIComponent)
    this.memoizedURLs.set(path, url)

    return url
  }
}

module.exports = MapGenerator


/***/ }),

/***/ 1866:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 2213:
/***/ ((module) => {

/**
 * Copyright 2004-present Facebook. All Rights Reserved.
 *
 * @providesModule UserAgent_DEPRECATED
 */

/**
 *  Provides entirely client-side User Agent and OS detection. You should prefer
 *  the non-deprecated UserAgent module when possible, which exposes our
 *  authoritative server-side PHP-based detection to the client.
 *
 *  Usage is straightforward:
 *
 *    if (UserAgent_DEPRECATED.ie()) {
 *      //  IE
 *    }
 *
 *  You can also do version checks:
 *
 *    if (UserAgent_DEPRECATED.ie() >= 7) {
 *      //  IE7 or better
 *    }
 *
 *  The browser functions will return NaN if the browser does not match, so
 *  you can also do version compares the other way:
 *
 *    if (UserAgent_DEPRECATED.ie() < 7) {
 *      //  IE6 or worse
 *    }
 *
 *  Note that the version is a float and may include a minor version number,
 *  so you should always use range operators to perform comparisons, not
 *  strict equality.
 *
 *  **Note:** You should **strongly** prefer capability detection to browser
 *  version detection where it's reasonable:
 *
 *    http://www.quirksmode.org/js/support.html
 *
 *  Further, we have a large number of mature wrapper functions and classes
 *  which abstract away many browser irregularities. Check the documentation,
 *  grep for things, or ask on javascript@lists.facebook.com before writing yet
 *  another copy of "event || window.event".
 *
 */

var _populated = false;

// Browsers
var _ie, _firefox, _opera, _webkit, _chrome;

// Actual IE browser for compatibility mode
var _ie_real_version;

// Platforms
var _osx, _windows, _linux, _android;

// Architectures
var _win64;

// Devices
var _iphone, _ipad, _native;

var _mobile;

function _populate() {
  if (_populated) {
    return;
  }

  _populated = true;

  // To work around buggy JS libraries that can't handle multi-digit
  // version numbers, Opera 10's user agent string claims it's Opera
  // 9, then later includes a Version/X.Y field:
  //
  // Opera/9.80 (foo) Presto/2.2.15 Version/10.10
  var uas = navigator.userAgent;
  var agent = /(?:MSIE.(\d+\.\d+))|(?:(?:Firefox|GranParadiso|Iceweasel).(\d+\.\d+))|(?:Opera(?:.+Version.|.)(\d+\.\d+))|(?:AppleWebKit.(\d+(?:\.\d+)?))|(?:Trident\/\d+\.\d+.*rv:(\d+\.\d+))/.exec(uas);
  var os    = /(Mac OS X)|(Windows)|(Linux)/.exec(uas);

  _iphone = /\b(iPhone|iP[ao]d)/.exec(uas);
  _ipad = /\b(iP[ao]d)/.exec(uas);
  _android = /Android/i.exec(uas);
  _native = /FBAN\/\w+;/i.exec(uas);
  _mobile = /Mobile/i.exec(uas);

  // Note that the IE team blog would have you believe you should be checking
  // for 'Win64; x64'.  But MSDN then reveals that you can actually be coming
  // from either x64 or ia64;  so ultimately, you should just check for Win64
  // as in indicator of whether you're in 64-bit IE.  32-bit IE on 64-bit
  // Windows will send 'WOW64' instead.
  _win64 = !!(/Win64/.exec(uas));

  if (agent) {
    _ie = agent[1] ? parseFloat(agent[1]) : (
          agent[5] ? parseFloat(agent[5]) : NaN);
    // IE compatibility mode
    if (_ie && document && document.documentMode) {
      _ie = document.documentMode;
    }
    // grab the "true" ie version from the trident token if available
    var trident = /(?:Trident\/(\d+.\d+))/.exec(uas);
    _ie_real_version = trident ? parseFloat(trident[1]) + 4 : _ie;

    _firefox = agent[2] ? parseFloat(agent[2]) : NaN;
    _opera   = agent[3] ? parseFloat(agent[3]) : NaN;
    _webkit  = agent[4] ? parseFloat(agent[4]) : NaN;
    if (_webkit) {
      // We do not add the regexp to the above test, because it will always
      // match 'safari' only since 'AppleWebKit' appears before 'Chrome' in
      // the userAgent string.
      agent = /(?:Chrome\/(\d+\.\d+))/.exec(uas);
      _chrome = agent && agent[1] ? parseFloat(agent[1]) : NaN;
    } else {
      _chrome = NaN;
    }
  } else {
    _ie = _firefox = _opera = _chrome = _webkit = NaN;
  }

  if (os) {
    if (os[1]) {
      // Detect OS X version.  If no version number matches, set _osx to true.
      // Version examples:  10, 10_6_1, 10.7
      // Parses version number as a float, taking only first two sets of
      // digits.  If only one set of digits is found, returns just the major
      // version number.
      var ver = /(?:Mac OS X (\d+(?:[._]\d+)?))/.exec(uas);

      _osx = ver ? parseFloat(ver[1].replace('_', '.')) : true;
    } else {
      _osx = false;
    }
    _windows = !!os[2];
    _linux   = !!os[3];
  } else {
    _osx = _windows = _linux = false;
  }
}

var UserAgent_DEPRECATED = {

  /**
   *  Check if the UA is Internet Explorer.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  ie: function() {
    return _populate() || _ie;
  },

  /**
   * Check if we're in Internet Explorer compatibility mode.
   *
   * @return bool true if in compatibility mode, false if
   * not compatibility mode or not ie
   */
  ieCompatibilityMode: function() {
    return _populate() || (_ie_real_version > _ie);
  },


  /**
   * Whether the browser is 64-bit IE.  Really, this is kind of weak sauce;  we
   * only need this because Skype can't handle 64-bit IE yet.  We need to remove
   * this when we don't need it -- tracked by #601957.
   */
  ie64: function() {
    return UserAgent_DEPRECATED.ie() && _win64;
  },

  /**
   *  Check if the UA is Firefox.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  firefox: function() {
    return _populate() || _firefox;
  },


  /**
   *  Check if the UA is Opera.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  opera: function() {
    return _populate() || _opera;
  },


  /**
   *  Check if the UA is WebKit.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  webkit: function() {
    return _populate() || _webkit;
  },

  /**
   *  For Push
   *  WILL BE REMOVED VERY SOON. Use UserAgent_DEPRECATED.webkit
   */
  safari: function() {
    return UserAgent_DEPRECATED.webkit();
  },

  /**
   *  Check if the UA is a Chrome browser.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  chrome : function() {
    return _populate() || _chrome;
  },


  /**
   *  Check if the user is running Windows.
   *
   *  @return bool `true' if the user's OS is Windows.
   */
  windows: function() {
    return _populate() || _windows;
  },


  /**
   *  Check if the user is running Mac OS X.
   *
   *  @return float|bool   Returns a float if a version number is detected,
   *                       otherwise true/false.
   */
  osx: function() {
    return _populate() || _osx;
  },

  /**
   * Check if the user is running Linux.
   *
   * @return bool `true' if the user's OS is some flavor of Linux.
   */
  linux: function() {
    return _populate() || _linux;
  },

  /**
   * Check if the user is running on an iPhone or iPod platform.
   *
   * @return bool `true' if the user is running some flavor of the
   *    iPhone OS.
   */
  iphone: function() {
    return _populate() || _iphone;
  },

  mobile: function() {
    return _populate() || (_iphone || _ipad || _android || _mobile);
  },

  nativeApp: function() {
    // webviews inside of the native apps
    return _populate() || _native;
  },

  android: function() {
    return _populate() || _android;
  },

  ipad: function() {
    return _populate() || _ipad;
  }
};

module.exports = UserAgent_DEPRECATED;


/***/ }),

/***/ 2327:
/***/ ((module) => {

"use strict";


const SINGLE_QUOTE = "'".charCodeAt(0)
const DOUBLE_QUOTE = '"'.charCodeAt(0)
const BACKSLASH = '\\'.charCodeAt(0)
const SLASH = '/'.charCodeAt(0)
const NEWLINE = '\n'.charCodeAt(0)
const SPACE = ' '.charCodeAt(0)
const FEED = '\f'.charCodeAt(0)
const TAB = '\t'.charCodeAt(0)
const CR = '\r'.charCodeAt(0)
const OPEN_SQUARE = '['.charCodeAt(0)
const CLOSE_SQUARE = ']'.charCodeAt(0)
const OPEN_PARENTHESES = '('.charCodeAt(0)
const CLOSE_PARENTHESES = ')'.charCodeAt(0)
const OPEN_CURLY = '{'.charCodeAt(0)
const CLOSE_CURLY = '}'.charCodeAt(0)
const SEMICOLON = ';'.charCodeAt(0)
const ASTERISK = '*'.charCodeAt(0)
const COLON = ':'.charCodeAt(0)
const AT = '@'.charCodeAt(0)

const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g
const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g
const RE_BAD_BRACKET = /.[\r\n"'(/\\]/
const RE_HEX_ESCAPE = /[\da-f]/i

module.exports = function tokenizer(input, options = {}) {
  let css = input.css.valueOf()
  let ignore = options.ignoreErrors

  let code, content, escape, next, quote
  let currentToken, escaped, escapePos, n, prev

  let length = css.length
  let pos = 0
  let buffer = []
  let returned = []

  function position() {
    return pos
  }

  function unclosed(what) {
    throw input.error('Unclosed ' + what, pos)
  }

  function endOfFile() {
    return returned.length === 0 && pos >= length
  }

  function nextToken(opts) {
    if (returned.length) return returned.pop()
    if (pos >= length) return

    let ignoreUnclosed = opts ? opts.ignoreUnclosed : false

    code = css.charCodeAt(pos)

    switch (code) {
      case NEWLINE:
      case SPACE:
      case TAB:
      case CR:
      case FEED: {
        next = pos
        do {
          next += 1
          code = css.charCodeAt(next)
        } while (
          code === SPACE ||
          code === NEWLINE ||
          code === TAB ||
          code === CR ||
          code === FEED
        )

        currentToken = ['space', css.slice(pos, next)]
        pos = next - 1
        break
      }

      case OPEN_SQUARE:
      case CLOSE_SQUARE:
      case OPEN_CURLY:
      case CLOSE_CURLY:
      case COLON:
      case SEMICOLON:
      case CLOSE_PARENTHESES: {
        let controlChar = String.fromCharCode(code)
        currentToken = [controlChar, controlChar, pos]
        break
      }

      case OPEN_PARENTHESES: {
        prev = buffer.length ? buffer.pop()[1] : ''
        n = css.charCodeAt(pos + 1)
        if (
          prev === 'url' &&
          n !== SINGLE_QUOTE &&
          n !== DOUBLE_QUOTE &&
          n !== SPACE &&
          n !== NEWLINE &&
          n !== TAB &&
          n !== FEED &&
          n !== CR
        ) {
          next = pos
          do {
            escaped = false
            next = css.indexOf(')', next + 1)
            if (next === -1) {
              if (ignore || ignoreUnclosed) {
                next = pos
                break
              } else {
                unclosed('bracket')
              }
            }
            escapePos = next
            while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
              escapePos -= 1
              escaped = !escaped
            }
          } while (escaped)

          currentToken = ['brackets', css.slice(pos, next + 1), pos, next]

          pos = next
        } else {
          next = css.indexOf(')', pos + 1)
          content = css.slice(pos, next + 1)

          if (next === -1 || RE_BAD_BRACKET.test(content)) {
            currentToken = ['(', '(', pos]
          } else {
            currentToken = ['brackets', content, pos, next]
            pos = next
          }
        }

        break
      }

      case SINGLE_QUOTE:
      case DOUBLE_QUOTE: {
        quote = code === SINGLE_QUOTE ? "'" : '"'
        next = pos
        do {
          escaped = false
          next = css.indexOf(quote, next + 1)
          if (next === -1) {
            if (ignore || ignoreUnclosed) {
              next = pos + 1
              break
            } else {
              unclosed('string')
            }
          }
          escapePos = next
          while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
            escapePos -= 1
            escaped = !escaped
          }
        } while (escaped)

        currentToken = ['string', css.slice(pos, next + 1), pos, next]
        pos = next
        break
      }

      case AT: {
        RE_AT_END.lastIndex = pos + 1
        RE_AT_END.test(css)
        if (RE_AT_END.lastIndex === 0) {
          next = css.length - 1
        } else {
          next = RE_AT_END.lastIndex - 2
        }

        currentToken = ['at-word', css.slice(pos, next + 1), pos, next]

        pos = next
        break
      }

      case BACKSLASH: {
        next = pos
        escape = true
        while (css.charCodeAt(next + 1) === BACKSLASH) {
          next += 1
          escape = !escape
        }
        code = css.charCodeAt(next + 1)
        if (
          escape &&
          code !== SLASH &&
          code !== SPACE &&
          code !== NEWLINE &&
          code !== TAB &&
          code !== CR &&
          code !== FEED
        ) {
          next += 1
          if (RE_HEX_ESCAPE.test(css.charAt(next))) {
            while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
              next += 1
            }
            if (css.charCodeAt(next + 1) === SPACE) {
              next += 1
            }
          }
        }

        currentToken = ['word', css.slice(pos, next + 1), pos, next]

        pos = next
        break
      }

      default: {
        if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
          next = css.indexOf('*/', pos + 2) + 1
          if (next === 0) {
            if (ignore || ignoreUnclosed) {
              next = css.length
            } else {
              unclosed('comment')
            }
          }

          currentToken = ['comment', css.slice(pos, next + 1), pos, next]
          pos = next
        } else {
          RE_WORD_END.lastIndex = pos + 1
          RE_WORD_END.test(css)
          if (RE_WORD_END.lastIndex === 0) {
            next = css.length - 1
          } else {
            next = RE_WORD_END.lastIndex - 2
          }

          currentToken = ['word', css.slice(pos, next + 1), pos, next]
          buffer.push(currentToken)
          pos = next
        }

        break
      }
    }

    pos++
    return currentToken
  }

  function back(token) {
    returned.push(token)
  }

  return {
    back,
    endOfFile,
    nextToken,
    position
  }
}


/***/ }),

/***/ 2739:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 2775:
/***/ ((module) => {

var x=String;
var create=function() {return {isColorSupported:false,reset:x,bold:x,dim:x,italic:x,underline:x,inverse:x,hidden:x,strikethrough:x,black:x,red:x,green:x,yellow:x,blue:x,magenta:x,cyan:x,white:x,gray:x,bgBlack:x,bgRed:x,bgGreen:x,bgYellow:x,bgBlue:x,bgMagenta:x,bgCyan:x,bgWhite:x,blackBright:x,redBright:x,greenBright:x,yellowBright:x,blueBright:x,magentaBright:x,cyanBright:x,whiteBright:x,bgBlackBright:x,bgRedBright:x,bgGreenBright:x,bgYellowBright:x,bgBlueBright:x,bgMagentaBright:x,bgCyanBright:x,bgWhiteBright:x}};
module.exports=create();
module.exports.createColors = create;


/***/ }),

/***/ 3122:
/***/ ((module) => {

"use strict";
/* eslint-disable no-console */


let printed = {}

module.exports = function warnOnce(message) {
  if (printed[message]) return
  printed[message] = true

  if (typeof console !== 'undefined' && console.warn) {
    console.warn(message)
  }
}


/***/ }),

/***/ 3815:
/***/ ((module) => {

module.exports = function walk(nodes, cb, bubble) {
  var i, max, node, result;

  for (i = 0, max = nodes.length; i < max; i += 1) {
    node = nodes[i];
    if (!bubble) {
      result = cb(node, i, nodes);
    }

    if (
      result !== false &&
      node.type === "function" &&
      Array.isArray(node.nodes)
    ) {
      walk(node.nodes, cb, bubble);
    }

    if (bubble) {
      cb(node, i, nodes);
    }
  }
};


/***/ }),

/***/ 3937:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let AtRule = __webpack_require__(1326)
let Comment = __webpack_require__(6589)
let Declaration = __webpack_require__(1516)
let Root = __webpack_require__(9434)
let Rule = __webpack_require__(4092)
let tokenizer = __webpack_require__(2327)

const SAFE_COMMENT_NEIGHBOR = {
  empty: true,
  space: true
}

function findLastWithPosition(tokens) {
  for (let i = tokens.length - 1; i >= 0; i--) {
    let token = tokens[i]
    let pos = token[3] || token[2]
    if (pos) return pos
  }
}

class Parser {
  constructor(input) {
    this.input = input

    this.root = new Root()
    this.current = this.root
    this.spaces = ''
    this.semicolon = false

    this.createTokenizer()
    this.root.source = { input, start: { column: 1, line: 1, offset: 0 } }
  }

  atrule(token) {
    let node = new AtRule()
    node.name = token[1].slice(1)
    if (node.name === '') {
      this.unnamedAtrule(node, token)
    }
    this.init(node, token[2])

    let type
    let prev
    let shift
    let last = false
    let open = false
    let params = []
    let brackets = []

    while (!this.tokenizer.endOfFile()) {
      token = this.tokenizer.nextToken()
      type = token[0]

      if (type === '(' || type === '[') {
        brackets.push(type === '(' ? ')' : ']')
      } else if (type === '{' && brackets.length > 0) {
        brackets.push('}')
      } else if (type === brackets[brackets.length - 1]) {
        brackets.pop()
      }

      if (brackets.length === 0) {
        if (type === ';') {
          node.source.end = this.getPosition(token[2])
          node.source.end.offset++
          this.semicolon = true
          break
        } else if (type === '{') {
          open = true
          break
        } else if (type === '}') {
          if (params.length > 0) {
            shift = params.length - 1
            prev = params[shift]
            while (prev && prev[0] === 'space') {
              prev = params[--shift]
            }
            if (prev) {
              node.source.end = this.getPosition(prev[3] || prev[2])
              node.source.end.offset++
            }
          }
          this.end(token)
          break
        } else {
          params.push(token)
        }
      } else {
        params.push(token)
      }

      if (this.tokenizer.endOfFile()) {
        last = true
        break
      }
    }

    node.raws.between = this.spacesAndCommentsFromEnd(params)
    if (params.length) {
      node.raws.afterName = this.spacesAndCommentsFromStart(params)
      this.raw(node, 'params', params)
      if (last) {
        token = params[params.length - 1]
        node.source.end = this.getPosition(token[3] || token[2])
        node.source.end.offset++
        this.spaces = node.raws.between
        node.raws.between = ''
      }
    } else {
      node.raws.afterName = ''
      node.params = ''
    }

    if (open) {
      node.nodes = []
      this.current = node
    }
  }

  checkMissedSemicolon(tokens) {
    let colon = this.colon(tokens)
    if (colon === false) return

    let founded = 0
    let token
    for (let j = colon - 1; j >= 0; j--) {
      token = tokens[j]
      if (token[0] !== 'space') {
        founded += 1
        if (founded === 2) break
      }
    }
    // If the token is a word, e.g. `!important`, `red` or any other valid property's value.
    // Then we need to return the colon after that word token. [3] is the "end" colon of that word.
    // And because we need it after that one we do +1 to get the next one.
    throw this.input.error(
      'Missed semicolon',
      token[0] === 'word' ? token[3] + 1 : token[2]
    )
  }

  colon(tokens) {
    let brackets = 0
    let prev, token, type
    for (let [i, element] of tokens.entries()) {
      token = element
      type = token[0]

      if (type === '(') {
        brackets += 1
      }
      if (type === ')') {
        brackets -= 1
      }
      if (brackets === 0 && type === ':') {
        if (!prev) {
          this.doubleColon(token)
        } else if (prev[0] === 'word' && prev[1] === 'progid') {
          continue
        } else {
          return i
        }
      }

      prev = token
    }
    return false
  }

  comment(token) {
    let node = new Comment()
    this.init(node, token[2])
    node.source.end = this.getPosition(token[3] || token[2])
    node.source.end.offset++

    let text = token[1].slice(2, -2)
    if (/^\s*$/.test(text)) {
      node.text = ''
      node.raws.left = text
      node.raws.right = ''
    } else {
      let match = text.match(/^(\s*)([^]*\S)(\s*)$/)
      node.text = match[2]
      node.raws.left = match[1]
      node.raws.right = match[3]
    }
  }

  createTokenizer() {
    this.tokenizer = tokenizer(this.input)
  }

  decl(tokens, customProperty) {
    let node = new Declaration()
    this.init(node, tokens[0][2])

    let last = tokens[tokens.length - 1]
    if (last[0] === ';') {
      this.semicolon = true
      tokens.pop()
    }

    node.source.end = this.getPosition(
      last[3] || last[2] || findLastWithPosition(tokens)
    )
    node.source.end.offset++

    while (tokens[0][0] !== 'word') {
      if (tokens.length === 1) this.unknownWord(tokens)
      node.raws.before += tokens.shift()[1]
    }
    node.source.start = this.getPosition(tokens[0][2])

    node.prop = ''
    while (tokens.length) {
      let type = tokens[0][0]
      if (type === ':' || type === 'space' || type === 'comment') {
        break
      }
      node.prop += tokens.shift()[1]
    }

    node.raws.between = ''

    let token
    while (tokens.length) {
      token = tokens.shift()

      if (token[0] === ':') {
        node.raws.between += token[1]
        break
      } else {
        if (token[0] === 'word' && /\w/.test(token[1])) {
          this.unknownWord([token])
        }
        node.raws.between += token[1]
      }
    }

    if (node.prop[0] === '_' || node.prop[0] === '*') {
      node.raws.before += node.prop[0]
      node.prop = node.prop.slice(1)
    }

    let firstSpaces = []
    let next
    while (tokens.length) {
      next = tokens[0][0]
      if (next !== 'space' && next !== 'comment') break
      firstSpaces.push(tokens.shift())
    }

    this.precheckMissedSemicolon(tokens)

    for (let i = tokens.length - 1; i >= 0; i--) {
      token = tokens[i]
      if (token[1].toLowerCase() === '!important') {
        node.important = true
        let string = this.stringFrom(tokens, i)
        string = this.spacesFromEnd(tokens) + string
        if (string !== ' !important') node.raws.important = string
        break
      } else if (token[1].toLowerCase() === 'important') {
        let cache = tokens.slice(0)
        let str = ''
        for (let j = i; j > 0; j--) {
          let type = cache[j][0]
          if (str.trim().startsWith('!') && type !== 'space') {
            break
          }
          str = cache.pop()[1] + str
        }
        if (str.trim().startsWith('!')) {
          node.important = true
          node.raws.important = str
          tokens = cache
        }
      }

      if (token[0] !== 'space' && token[0] !== 'comment') {
        break
      }
    }

    let hasWord = tokens.some(i => i[0] !== 'space' && i[0] !== 'comment')

    if (hasWord) {
      node.raws.between += firstSpaces.map(i => i[1]).join('')
      firstSpaces = []
    }
    this.raw(node, 'value', firstSpaces.concat(tokens), customProperty)

    if (node.value.includes(':') && !customProperty) {
      this.checkMissedSemicolon(tokens)
    }
  }

  doubleColon(token) {
    throw this.input.error(
      'Double colon',
      { offset: token[2] },
      { offset: token[2] + token[1].length }
    )
  }

  emptyRule(token) {
    let node = new Rule()
    this.init(node, token[2])
    node.selector = ''
    node.raws.between = ''
    this.current = node
  }

  end(token) {
    if (this.current.nodes && this.current.nodes.length) {
      this.current.raws.semicolon = this.semicolon
    }
    this.semicolon = false

    this.current.raws.after = (this.current.raws.after || '') + this.spaces
    this.spaces = ''

    if (this.current.parent) {
      this.current.source.end = this.getPosition(token[2])
      this.current.source.end.offset++
      this.current = this.current.parent
    } else {
      this.unexpectedClose(token)
    }
  }

  endFile() {
    if (this.current.parent) this.unclosedBlock()
    if (this.current.nodes && this.current.nodes.length) {
      this.current.raws.semicolon = this.semicolon
    }
    this.current.raws.after = (this.current.raws.after || '') + this.spaces
    this.root.source.end = this.getPosition(this.tokenizer.position())
  }

  freeSemicolon(token) {
    this.spaces += token[1]
    if (this.current.nodes) {
      let prev = this.current.nodes[this.current.nodes.length - 1]
      if (prev && prev.type === 'rule' && !prev.raws.ownSemicolon) {
        prev.raws.ownSemicolon = this.spaces
        this.spaces = ''
        prev.source.end = this.getPosition(token[2])
        prev.source.end.offset += prev.raws.ownSemicolon.length
      }
    }
  }

  // Helpers

  getPosition(offset) {
    let pos = this.input.fromOffset(offset)
    return {
      column: pos.col,
      line: pos.line,
      offset
    }
  }

  init(node, offset) {
    this.current.push(node)
    node.source = {
      input: this.input,
      start: this.getPosition(offset)
    }
    node.raws.before = this.spaces
    this.spaces = ''
    if (node.type !== 'comment') this.semicolon = false
  }

  other(start) {
    let end = false
    let type = null
    let colon = false
    let bracket = null
    let brackets = []
    let customProperty = start[1].startsWith('--')

    let tokens = []
    let token = start
    while (token) {
      type = token[0]
      tokens.push(token)

      if (type === '(' || type === '[') {
        if (!bracket) bracket = token
        brackets.push(type === '(' ? ')' : ']')
      } else if (customProperty && colon && type === '{') {
        if (!bracket) bracket = token
        brackets.push('}')
      } else if (brackets.length === 0) {
        if (type === ';') {
          if (colon) {
            this.decl(tokens, customProperty)
            return
          } else {
            break
          }
        } else if (type === '{') {
          this.rule(tokens)
          return
        } else if (type === '}') {
          this.tokenizer.back(tokens.pop())
          end = true
          break
        } else if (type === ':') {
          colon = true
        }
      } else if (type === brackets[brackets.length - 1]) {
        brackets.pop()
        if (brackets.length === 0) bracket = null
      }

      token = this.tokenizer.nextToken()
    }

    if (this.tokenizer.endOfFile()) end = true
    if (brackets.length > 0) this.unclosedBracket(bracket)

    if (end && colon) {
      if (!customProperty) {
        while (tokens.length) {
          token = tokens[tokens.length - 1][0]
          if (token !== 'space' && token !== 'comment') break
          this.tokenizer.back(tokens.pop())
        }
      }
      this.decl(tokens, customProperty)
    } else {
      this.unknownWord(tokens)
    }
  }

  parse() {
    let token
    while (!this.tokenizer.endOfFile()) {
      token = this.tokenizer.nextToken()

      switch (token[0]) {
        case 'space':
          this.spaces += token[1]
          break

        case ';':
          this.freeSemicolon(token)
          break

        case '}':
          this.end(token)
          break

        case 'comment':
          this.comment(token)
          break

        case 'at-word':
          this.atrule(token)
          break

        case '{':
          this.emptyRule(token)
          break

        default:
          this.other(token)
          break
      }
    }
    this.endFile()
  }

  precheckMissedSemicolon(/* tokens */) {
    // Hook for Safe Parser
  }

  raw(node, prop, tokens, customProperty) {
    let token, type
    let length = tokens.length
    let value = ''
    let clean = true
    let next, prev

    for (let i = 0; i < length; i += 1) {
      token = tokens[i]
      type = token[0]
      if (type === 'space' && i === length - 1 && !customProperty) {
        clean = false
      } else if (type === 'comment') {
        prev = tokens[i - 1] ? tokens[i - 1][0] : 'empty'
        next = tokens[i + 1] ? tokens[i + 1][0] : 'empty'
        if (!SAFE_COMMENT_NEIGHBOR[prev] && !SAFE_COMMENT_NEIGHBOR[next]) {
          if (value.slice(-1) === ',') {
            clean = false
          } else {
            value += token[1]
          }
        } else {
          clean = false
        }
      } else {
        value += token[1]
      }
    }
    if (!clean) {
      let raw = tokens.reduce((all, i) => all + i[1], '')
      node.raws[prop] = { raw, value }
    }
    node[prop] = value
  }

  rule(tokens) {
    tokens.pop()

    let node = new Rule()
    this.init(node, tokens[0][2])

    node.raws.between = this.spacesAndCommentsFromEnd(tokens)
    this.raw(node, 'selector', tokens)
    this.current = node
  }

  spacesAndCommentsFromEnd(tokens) {
    let lastTokenType
    let spaces = ''
    while (tokens.length) {
      lastTokenType = tokens[tokens.length - 1][0]
      if (lastTokenType !== 'space' && lastTokenType !== 'comment') break
      spaces = tokens.pop()[1] + spaces
    }
    return spaces
  }

  // Errors

  spacesAndCommentsFromStart(tokens) {
    let next
    let spaces = ''
    while (tokens.length) {
      next = tokens[0][0]
      if (next !== 'space' && next !== 'comment') break
      spaces += tokens.shift()[1]
    }
    return spaces
  }

  spacesFromEnd(tokens) {
    let lastTokenType
    let spaces = ''
    while (tokens.length) {
      lastTokenType = tokens[tokens.length - 1][0]
      if (lastTokenType !== 'space') break
      spaces = tokens.pop()[1] + spaces
    }
    return spaces
  }

  stringFrom(tokens, from) {
    let result = ''
    for (let i = from; i < tokens.length; i++) {
      result += tokens[i][1]
    }
    tokens.splice(from, tokens.length - from)
    return result
  }

  unclosedBlock() {
    let pos = this.current.source.start
    throw this.input.error('Unclosed block', pos.line, pos.column)
  }

  unclosedBracket(bracket) {
    throw this.input.error(
      'Unclosed bracket',
      { offset: bracket[2] },
      { offset: bracket[2] + 1 }
    )
  }

  unexpectedClose(token) {
    throw this.input.error(
      'Unexpected }',
      { offset: token[2] },
      { offset: token[2] + 1 }
    )
  }

  unknownWord(tokens) {
    throw this.input.error(
      'Unknown word ' + tokens[0][1],
      { offset: tokens[0][2] },
      { offset: tokens[0][2] + tokens[0][1].length }
    )
  }

  unnamedAtrule(node, token) {
    throw this.input.error(
      'At-rule without name',
      { offset: token[2] },
      { offset: token[2] + token[1].length }
    )
  }
}

module.exports = Parser


/***/ }),

/***/ 4067:
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ 4092:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)
let list = __webpack_require__(7374)

class Rule extends Container {
  get selectors() {
    return list.comma(this.selector)
  }

  set selectors(values) {
    let match = this.selector ? this.selector.match(/,\s*/) : null
    let sep = match ? match[0] : ',' + this.raw('between', 'beforeOpen')
    this.selector = values.join(sep)
  }

  constructor(defaults) {
    super(defaults)
    this.type = 'rule'
    if (!this.nodes) this.nodes = []
  }
}

module.exports = Rule
Rule.default = Rule

Container.registerRule(Rule)


/***/ }),

/***/ 4132:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = true;
var TextareaAutosize_1 = __webpack_require__(4462);
exports.A = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ 4295:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)
let Input = __webpack_require__(5380)
let Parser = __webpack_require__(3937)

function parse(css, opts) {
  let input = new Input(css, opts)
  let parser = new Parser(input)
  try {
    parser.parse()
  } catch (e) {
    if (false) {}
    throw e
  }

  return parser.root
}

module.exports = parse
parse.default = parse

Container.registerParse(parse)


/***/ }),

/***/ 4306:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.4
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ 4462:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__(1609);
var PropTypes = __webpack_require__(5826);
var autosize = __webpack_require__(4306);
var _getLineHeight = __webpack_require__(461);
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ 4725:
/***/ ((module) => {

function stringifyNode(node, custom) {
  var type = node.type;
  var value = node.value;
  var buf;
  var customResult;

  if (custom && (customResult = custom(node)) !== undefined) {
    return customResult;
  } else if (type === "word" || type === "space") {
    return value;
  } else if (type === "string") {
    buf = node.quote || "";
    return buf + value + (node.unclosed ? "" : buf);
  } else if (type === "comment") {
    return "/*" + value + (node.unclosed ? "" : "*/");
  } else if (type === "div") {
    return (node.before || "") + value + (node.after || "");
  } else if (Array.isArray(node.nodes)) {
    buf = stringify(node.nodes, custom);
    if (type !== "function") {
      return buf;
    }
    return (
      value +
      "(" +
      (node.before || "") +
      buf +
      (node.after || "") +
      (node.unclosed ? "" : ")")
    );
  }
  return value;
}

function stringify(nodes, custom) {
  var result, i;

  if (Array.isArray(nodes)) {
    result = "";
    for (i = nodes.length - 1; ~i; i -= 1) {
      result = stringifyNode(nodes[i], custom) + result;
    }
    return result;
  }
  return stringifyNode(nodes, custom);
}

module.exports = stringify;


/***/ }),

/***/ 5042:
/***/ ((module) => {

// This alphabet uses `A-Za-z0-9_-` symbols.
// The order of characters is optimized for better gzip and brotli compression.
// References to the same file (works both for gzip and brotli):
// `'use`, `andom`, and `rict'`
// References to the brotli default dictionary:
// `-26T`, `1983`, `40px`, `75px`, `bush`, `jack`, `mind`, `very`, and `wolf`
let urlAlphabet =
  'useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict'

let customAlphabet = (alphabet, defaultSize = 21) => {
  return (size = defaultSize) => {
    let id = ''
    // A compact alternative for `for (var i = 0; i < step; i++)`.
    let i = size | 0
    while (i--) {
      // `| 0` is more compact and faster than `Math.floor()`.
      id += alphabet[(Math.random() * alphabet.length) | 0]
    }
    return id
  }
}

let nanoid = (size = 21) => {
  let id = ''
  // A compact alternative for `for (var i = 0; i < step; i++)`.
  let i = size | 0
  while (i--) {
    // `| 0` is more compact and faster than `Math.floor()`.
    id += urlAlphabet[(Math.random() * 64) | 0]
  }
  return id
}

module.exports = { nanoid, customAlphabet }


/***/ }),

/***/ 5215:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 5380:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { nanoid } = __webpack_require__(5042)
let { isAbsolute, resolve } = __webpack_require__(197)
let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)
let { fileURLToPath, pathToFileURL } = __webpack_require__(2739)

let CssSyntaxError = __webpack_require__(356)
let PreviousMap = __webpack_require__(5696)
let terminalHighlight = __webpack_require__(9746)

let lineToIndexCache = Symbol('lineToIndexCache')

let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator)
let pathAvailable = Boolean(resolve && isAbsolute)

function getLineToIndex(input) {
  if (input[lineToIndexCache]) return input[lineToIndexCache]
  let lines = input.css.split('\n')
  let lineToIndex = new Array(lines.length)
  let prevIndex = 0

  for (let i = 0, l = lines.length; i < l; i++) {
    lineToIndex[i] = prevIndex
    prevIndex += lines[i].length + 1
  }

  input[lineToIndexCache] = lineToIndex
  return lineToIndex
}

class Input {
  get from() {
    return this.file || this.id
  }

  constructor(css, opts = {}) {
    if (
      css === null ||
      typeof css === 'undefined' ||
      (typeof css === 'object' && !css.toString)
    ) {
      throw new Error(`PostCSS received ${css} instead of CSS string`)
    }

    this.css = css.toString()

    if (this.css[0] === '\uFEFF' || this.css[0] === '\uFFFE') {
      this.hasBOM = true
      this.css = this.css.slice(1)
    } else {
      this.hasBOM = false
    }

    this.document = this.css
    if (opts.document) this.document = opts.document.toString()

    if (opts.from) {
      if (
        !pathAvailable ||
        /^\w+:\/\//.test(opts.from) ||
        isAbsolute(opts.from)
      ) {
        this.file = opts.from
      } else {
        this.file = resolve(opts.from)
      }
    }

    if (pathAvailable && sourceMapAvailable) {
      let map = new PreviousMap(this.css, opts)
      if (map.text) {
        this.map = map
        let file = map.consumer().file
        if (!this.file && file) this.file = this.mapResolve(file)
      }
    }

    if (!this.file) {
      this.id = '<input css ' + nanoid(6) + '>'
    }
    if (this.map) this.map.file = this.from
  }

  error(message, line, column, opts = {}) {
    let endColumn, endLine, endOffset, offset, result

    if (line && typeof line === 'object') {
      let start = line
      let end = column
      if (typeof start.offset === 'number') {
        offset = start.offset
        let pos = this.fromOffset(offset)
        line = pos.line
        column = pos.col
      } else {
        line = start.line
        column = start.column
        offset = this.fromLineAndColumn(line, column)
      }
      if (typeof end.offset === 'number') {
        endOffset = end.offset
        let pos = this.fromOffset(endOffset)
        endLine = pos.line
        endColumn = pos.col
      } else {
        endLine = end.line
        endColumn = end.column
        endOffset = this.fromLineAndColumn(end.line, end.column)
      }
    } else if (!column) {
      offset = line
      let pos = this.fromOffset(offset)
      line = pos.line
      column = pos.col
    } else {
      offset = this.fromLineAndColumn(line, column)
    }

    let origin = this.origin(line, column, endLine, endColumn)
    if (origin) {
      result = new CssSyntaxError(
        message,
        origin.endLine === undefined
          ? origin.line
          : { column: origin.column, line: origin.line },
        origin.endLine === undefined
          ? origin.column
          : { column: origin.endColumn, line: origin.endLine },
        origin.source,
        origin.file,
        opts.plugin
      )
    } else {
      result = new CssSyntaxError(
        message,
        endLine === undefined ? line : { column, line },
        endLine === undefined ? column : { column: endColumn, line: endLine },
        this.css,
        this.file,
        opts.plugin
      )
    }

    result.input = { column, endColumn, endLine, endOffset, line, offset, source: this.css }
    if (this.file) {
      if (pathToFileURL) {
        result.input.url = pathToFileURL(this.file).toString()
      }
      result.input.file = this.file
    }

    return result
  }

  fromLineAndColumn(line, column) {
    let lineToIndex = getLineToIndex(this)
    let index = lineToIndex[line - 1]
    return index + column - 1
  }

  fromOffset(offset) {
    let lineToIndex = getLineToIndex(this)
    let lastLine = lineToIndex[lineToIndex.length - 1]

    let min = 0
    if (offset >= lastLine) {
      min = lineToIndex.length - 1
    } else {
      let max = lineToIndex.length - 2
      let mid
      while (min < max) {
        mid = min + ((max - min) >> 1)
        if (offset < lineToIndex[mid]) {
          max = mid - 1
        } else if (offset >= lineToIndex[mid + 1]) {
          min = mid + 1
        } else {
          min = mid
          break
        }
      }
    }
    return {
      col: offset - lineToIndex[min] + 1,
      line: min + 1
    }
  }

  mapResolve(file) {
    if (/^\w+:\/\//.test(file)) {
      return file
    }
    return resolve(this.map.consumer().sourceRoot || this.map.root || '.', file)
  }

  origin(line, column, endLine, endColumn) {
    if (!this.map) return false
    let consumer = this.map.consumer()

    let from = consumer.originalPositionFor({ column, line })
    if (!from.source) return false

    let to
    if (typeof endLine === 'number') {
      to = consumer.originalPositionFor({ column: endColumn, line: endLine })
    }

    let fromUrl

    if (isAbsolute(from.source)) {
      fromUrl = pathToFileURL(from.source)
    } else {
      fromUrl = new URL(
        from.source,
        this.map.consumer().sourceRoot || pathToFileURL(this.map.mapFile)
      )
    }

    let result = {
      column: from.column,
      endColumn: to && to.column,
      endLine: to && to.line,
      line: from.line,
      url: fromUrl.toString()
    }

    if (fromUrl.protocol === 'file:') {
      if (fileURLToPath) {
        result.file = fileURLToPath(fromUrl)
      } else {
        /* c8 ignore next 2 */
        throw new Error(`file: protocol is not available in this PostCSS build`)
      }
    }

    let source = consumer.sourceContentFor(from.source)
    if (source) result.source = source

    return result
  }

  toJSON() {
    let json = {}
    for (let name of ['hasBOM', 'css', 'file', 'id']) {
      if (this[name] != null) {
        json[name] = this[name]
      }
    }
    if (this.map) {
      json.map = { ...this.map }
      if (json.map.consumerCache) {
        json.map.consumerCache = undefined
      }
    }
    return json
  }
}

module.exports = Input
Input.default = Input

if (terminalHighlight && terminalHighlight.registerInput) {
  terminalHighlight.registerInput(Input)
}


/***/ }),

/***/ 5404:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const CSSValueParser = __webpack_require__(1544)

/**
 * @type {import('postcss').PluginCreator}
 */
module.exports = (opts) => {

  const DEFAULTS = {
    skipHostRelativeUrls: true,
  }
  const config = Object.assign(DEFAULTS, opts)

  return {
    postcssPlugin: 'rebaseUrl',

    Declaration(decl) {
      // The faster way to find Declaration node
      const parsedValue = CSSValueParser(decl.value)

      let valueChanged = false
      parsedValue.walk(node => {
        if (node.type !== 'function' || node.value !== 'url') {
          return
        }

        const urlVal = node.nodes[0].value

        // bases relative URLs with rootUrl
        const basedUrl = new URL(urlVal, opts.rootUrl)

        // skip host-relative, already normalized URLs (e.g. `/images/image.jpg`, without `..`s)
        if ((basedUrl.pathname === urlVal) && config.skipHostRelativeUrls) {
          return false // skip this value
        }

        node.nodes[0].value = basedUrl.toString()
        valueChanged = true

        return false // do not walk deeper
      })

      if (valueChanged) {
        decl.value = CSSValueParser.stringify(parsedValue)
      }

    }
  }
}

module.exports.postcss = true


/***/ }),

/***/ 5417:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/*istanbul ignore start*/


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Diff;

/*istanbul ignore end*/
function Diff() {}

Diff.prototype = {
  /*istanbul ignore start*/

  /*istanbul ignore end*/
  diff: function diff(oldString, newString) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var callback = options.callback;

    if (typeof options === 'function') {
      callback = options;
      options = {};
    }

    this.options = options;
    var self = this;

    function done(value) {
      if (callback) {
        setTimeout(function () {
          callback(undefined, value);
        }, 0);
        return true;
      } else {
        return value;
      }
    } // Allow subclasses to massage the input prior to running


    oldString = this.castInput(oldString);
    newString = this.castInput(newString);
    oldString = this.removeEmpty(this.tokenize(oldString));
    newString = this.removeEmpty(this.tokenize(newString));
    var newLen = newString.length,
        oldLen = oldString.length;
    var editLength = 1;
    var maxEditLength = newLen + oldLen;
    var bestPath = [{
      newPos: -1,
      components: []
    }]; // Seed editLength = 0, i.e. the content starts with the same values

    var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);

    if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
      // Identity per the equality and tokenizer
      return done([{
        value: this.join(newString),
        count: newString.length
      }]);
    } // Main worker method. checks all permutations of a given edit length for acceptance.


    function execEditLength() {
      for (var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2) {
        var basePath =
        /*istanbul ignore start*/
        void 0
        /*istanbul ignore end*/
        ;

        var addPath = bestPath[diagonalPath - 1],
            removePath = bestPath[diagonalPath + 1],
            _oldPos = (removePath ? removePath.newPos : 0) - diagonalPath;

        if (addPath) {
          // No one else is going to attempt to use this value, clear it
          bestPath[diagonalPath - 1] = undefined;
        }

        var canAdd = addPath && addPath.newPos + 1 < newLen,
            canRemove = removePath && 0 <= _oldPos && _oldPos < oldLen;

        if (!canAdd && !canRemove) {
          // If this path is a terminal then prune
          bestPath[diagonalPath] = undefined;
          continue;
        } // Select the diagonal that we want to branch from. We select the prior
        // path whose position in the new string is the farthest from the origin
        // and does not pass the bounds of the diff graph


        if (!canAdd || canRemove && addPath.newPos < removePath.newPos) {
          basePath = clonePath(removePath);
          self.pushComponent(basePath.components, undefined, true);
        } else {
          basePath = addPath; // No need to clone, we've pulled it from the list

          basePath.newPos++;
          self.pushComponent(basePath.components, true, undefined);
        }

        _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath); // If we have hit the end of both strings, then we are done

        if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
          return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
        } else {
          // Otherwise track this path as a potential candidate and continue.
          bestPath[diagonalPath] = basePath;
        }
      }

      editLength++;
    } // Performs the length of edit iteration. Is a bit fugly as this has to support the
    // sync and async mode which is never fun. Loops over execEditLength until a value
    // is produced.


    if (callback) {
      (function exec() {
        setTimeout(function () {
          // This should not happen, but we want to be safe.

          /* istanbul ignore next */
          if (editLength > maxEditLength) {
            return callback();
          }

          if (!execEditLength()) {
            exec();
          }
        }, 0);
      })();
    } else {
      while (editLength <= maxEditLength) {
        var ret = execEditLength();

        if (ret) {
          return ret;
        }
      }
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  pushComponent: function pushComponent(components, added, removed) {
    var last = components[components.length - 1];

    if (last && last.added === added && last.removed === removed) {
      // We need to clone here as the component clone operation is just
      // as shallow array clone
      components[components.length - 1] = {
        count: last.count + 1,
        added: added,
        removed: removed
      };
    } else {
      components.push({
        count: 1,
        added: added,
        removed: removed
      });
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
    var newLen = newString.length,
        oldLen = oldString.length,
        newPos = basePath.newPos,
        oldPos = newPos - diagonalPath,
        commonCount = 0;

    while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])) {
      newPos++;
      oldPos++;
      commonCount++;
    }

    if (commonCount) {
      basePath.components.push({
        count: commonCount
      });
    }

    basePath.newPos = newPos;
    return oldPos;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  equals: function equals(left, right) {
    if (this.options.comparator) {
      return this.options.comparator(left, right);
    } else {
      return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  removeEmpty: function removeEmpty(array) {
    var ret = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i]) {
        ret.push(array[i]);
      }
    }

    return ret;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  castInput: function castInput(value) {
    return value;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  tokenize: function tokenize(value) {
    return value.split('');
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  join: function join(chars) {
    return chars.join('');
  }
};

function buildValues(diff, components, newString, oldString, useLongestToken) {
  var componentPos = 0,
      componentLen = components.length,
      newPos = 0,
      oldPos = 0;

  for (; componentPos < componentLen; componentPos++) {
    var component = components[componentPos];

    if (!component.removed) {
      if (!component.added && useLongestToken) {
        var value = newString.slice(newPos, newPos + component.count);
        value = value.map(function (value, i) {
          var oldValue = oldString[oldPos + i];
          return oldValue.length > value.length ? oldValue : value;
        });
        component.value = diff.join(value);
      } else {
        component.value = diff.join(newString.slice(newPos, newPos + component.count));
      }

      newPos += component.count; // Common case

      if (!component.added) {
        oldPos += component.count;
      }
    } else {
      component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
      oldPos += component.count; // Reverse add and remove so removes are output first to match common convention
      // The diffing algorithm is tied to add then remove output and this is the simplest
      // route to get the desired output with minimal overhead.

      if (componentPos && components[componentPos - 1].added) {
        var tmp = components[componentPos - 1];
        components[componentPos - 1] = components[componentPos];
        components[componentPos] = tmp;
      }
    }
  } // Special case handle for when one terminal is ignored (i.e. whitespace).
  // For this case we merge the terminal into the prior string and drop the change.
  // This is only available for string mode.


  var lastComponent = components[componentLen - 1];

  if (componentLen > 1 && typeof lastComponent.value === 'string' && (lastComponent.added || lastComponent.removed) && diff.equals('', lastComponent.value)) {
    components[componentLen - 2].value += lastComponent.value;
    components.pop();
  }

  return components;
}

function clonePath(path) {
  return {
    newPos: path.newPos,
    components: path.components.slice(0)
  };
}


/***/ }),

/***/ 5696:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { existsSync, readFileSync } = __webpack_require__(9977)
let { dirname, join } = __webpack_require__(197)
let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)

function fromBase64(str) {
  if (Buffer) {
    return Buffer.from(str, 'base64').toString()
  } else {
    /* c8 ignore next 2 */
    return window.atob(str)
  }
}

class PreviousMap {
  constructor(css, opts) {
    if (opts.map === false) return
    this.loadAnnotation(css)
    this.inline = this.startWith(this.annotation, 'data:')

    let prev = opts.map ? opts.map.prev : undefined
    let text = this.loadMap(opts.from, prev)
    if (!this.mapFile && opts.from) {
      this.mapFile = opts.from
    }
    if (this.mapFile) this.root = dirname(this.mapFile)
    if (text) this.text = text
  }

  consumer() {
    if (!this.consumerCache) {
      this.consumerCache = new SourceMapConsumer(this.text)
    }
    return this.consumerCache
  }

  decodeInline(text) {
    let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/
    let baseUri = /^data:application\/json;base64,/
    let charsetUri = /^data:application\/json;charset=utf-?8,/
    let uri = /^data:application\/json,/

    let uriMatch = text.match(charsetUri) || text.match(uri)
    if (uriMatch) {
      return decodeURIComponent(text.substr(uriMatch[0].length))
    }

    let baseUriMatch = text.match(baseCharsetUri) || text.match(baseUri)
    if (baseUriMatch) {
      return fromBase64(text.substr(baseUriMatch[0].length))
    }

    let encoding = text.match(/data:application\/json;([^,]+),/)[1]
    throw new Error('Unsupported source map encoding ' + encoding)
  }

  getAnnotationURL(sourceMapString) {
    return sourceMapString.replace(/^\/\*\s*# sourceMappingURL=/, '').trim()
  }

  isMap(map) {
    if (typeof map !== 'object') return false
    return (
      typeof map.mappings === 'string' ||
      typeof map._mappings === 'string' ||
      Array.isArray(map.sections)
    )
  }

  loadAnnotation(css) {
    let comments = css.match(/\/\*\s*# sourceMappingURL=/g)
    if (!comments) return

    // sourceMappingURLs from comments, strings, etc.
    let start = css.lastIndexOf(comments.pop())
    let end = css.indexOf('*/', start)

    if (start > -1 && end > -1) {
      // Locate the last sourceMappingURL to avoid pickin
      this.annotation = this.getAnnotationURL(css.substring(start, end))
    }
  }

  loadFile(path) {
    this.root = dirname(path)
    if (existsSync(path)) {
      this.mapFile = path
      return readFileSync(path, 'utf-8').toString().trim()
    }
  }

  loadMap(file, prev) {
    if (prev === false) return false

    if (prev) {
      if (typeof prev === 'string') {
        return prev
      } else if (typeof prev === 'function') {
        let prevPath = prev(file)
        if (prevPath) {
          let map = this.loadFile(prevPath)
          if (!map) {
            throw new Error(
              'Unable to load previous source map: ' + prevPath.toString()
            )
          }
          return map
        }
      } else if (prev instanceof SourceMapConsumer) {
        return SourceMapGenerator.fromSourceMap(prev).toString()
      } else if (prev instanceof SourceMapGenerator) {
        return prev.toString()
      } else if (this.isMap(prev)) {
        return JSON.stringify(prev)
      } else {
        throw new Error(
          'Unsupported previous source map format: ' + prev.toString()
        )
      }
    } else if (this.inline) {
      return this.decodeInline(this.annotation)
    } else if (this.annotation) {
      let map = this.annotation
      if (file) map = join(dirname(file), map)
      return this.loadFile(map)
    }
  }

  startWith(string, start) {
    if (!string) return false
    return string.substr(0, start.length) === start
  }

  withContent() {
    return !!(
      this.consumer().sourcesContent &&
      this.consumer().sourcesContent.length > 0
    )
  }
}

module.exports = PreviousMap
PreviousMap.default = PreviousMap


/***/ }),

/***/ 5776:
/***/ ((module) => {

"use strict";


class Warning {
  constructor(text, opts = {}) {
    this.type = 'warning'
    this.text = text

    if (opts.node && opts.node.source) {
      let range = opts.node.rangeBy(opts)
      this.line = range.start.line
      this.column = range.start.column
      this.endLine = range.end.line
      this.endColumn = range.end.column
    }

    for (let opt in opts) this[opt] = opts[opt]
  }

  toString() {
    if (this.node) {
      return this.node.error(this.text, {
        index: this.index,
        plugin: this.plugin,
        word: this.word
      }).message
    }

    if (this.plugin) {
      return this.plugin + ': ' + this.text
    }

    return this.text
  }
}

module.exports = Warning
Warning.default = Warning


/***/ }),

/***/ 5826:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(628)();
}


/***/ }),

/***/ 6109:
/***/ ((module) => {

// This code has been refactored for 140 bytes
// You can see the original here: https://github.com/twolfson/computedStyle/blob/04cd1da2e30fa45844f95f5cb1ac898e9b9ef050/lib/computedStyle.js
var computedStyle = function (el, prop, getComputedStyle) {
  getComputedStyle = window.getComputedStyle;

  // In one fell swoop
  return (
    // If we have getComputedStyle
    getComputedStyle ?
      // Query it
      // TODO: From CSS-Query notes, we might need (node, null) for FF
      getComputedStyle(el) :

    // Otherwise, we are in IE and use currentStyle
      el.currentStyle
  )[
    // Switch to camelCase for CSSOM
    // DEV: Grabbed from jQuery
    // https://github.com/jquery/jquery/blob/1.9-stable/src/css.js#L191-L194
    // https://github.com/jquery/jquery/blob/1.9-stable/src/core.js#L593-L597
    prop.replace(/-(\w)/gi, function (word, letter) {
      return letter.toUpperCase();
    })
  ];
};

module.exports = computedStyle;


/***/ }),

/***/ 6589:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Node = __webpack_require__(7490)

class Comment extends Node {
  constructor(defaults) {
    super(defaults)
    this.type = 'comment'
  }
}

module.exports = Comment
Comment.default = Comment


/***/ }),

/***/ 7191:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule normalizeWheel
 * @typechecks
 */



var UserAgent_DEPRECATED = __webpack_require__(2213);

var isEventSupported = __webpack_require__(1087);


// Reasonable defaults
var PIXEL_STEP  = 10;
var LINE_HEIGHT = 40;
var PAGE_HEIGHT = 800;

/**
 * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
 * complicated, thus this doc is long and (hopefully) detailed enough to answer
 * your questions.
 *
 * If you need to react to the mouse wheel in a predictable way, this code is
 * like your bestest friend. * hugs *
 *
 * As of today, there are 4 DOM event types you can listen to:
 *
 *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
 *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
 *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
 *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
 *
 * So what to do?  The is the best:
 *
 *   normalizeWheel.getEventType();
 *
 * In your event callback, use this code to get sane interpretation of the
 * deltas.  This code will return an object with properties:
 *
 *   spinX   -- normalized spin speed (use for zoom) - x plane
 *   spinY   -- " - y plane
 *   pixelX  -- normalized distance (to pixels) - x plane
 *   pixelY  -- " - y plane
 *
 * Wheel values are provided by the browser assuming you are using the wheel to
 * scroll a web page by a number of lines or pixels (or pages).  Values can vary
 * significantly on different platforms and browsers, forgetting that you can
 * scroll at different speeds.  Some devices (like trackpads) emit more events
 * at smaller increments with fine granularity, and some emit massive jumps with
 * linear speed or acceleration.
 *
 * This code does its best to normalize the deltas for you:
 *
 *   - spin is trying to normalize how far the wheel was spun (or trackpad
 *     dragged).  This is super useful for zoom support where you want to
 *     throw away the chunky scroll steps on the PC and make those equal to
 *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
 *     resolve a single slow step on a wheel to 1.
 *
 *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
 *     get the crazy differences between browsers, but at least it'll be in
 *     pixels!
 *
 *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
 *     should translate to positive value zooming IN, negative zooming OUT.
 *     This matches the newer 'wheel' event.
 *
 * Why are there spinX, spinY (or pixels)?
 *
 *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
 *     with a mouse.  It results in side-scrolling in the browser by default.
 *
 *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
 *
 *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
 *     probably is by browsers in conjunction with fancy 3D controllers .. but
 *     you know.
 *
 * Implementation info:
 *
 * Examples of 'wheel' event if you scroll slowly (down) by one step with an
 * average mouse:
 *
 *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
 *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
 *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
 *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
 *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
 *
 * On the trackpad:
 *
 *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
 *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
 *
 * On other/older browsers.. it's more complicated as there can be multiple and
 * also missing delta values.
 *
 * The 'wheel' event is more standard:
 *
 * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
 *
 * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
 * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
 * backward compatibility with older events.  Those other values help us
 * better normalize spin speed.  Example of what the browsers provide:
 *
 *                          | event.wheelDelta | event.detail
 *        ------------------+------------------+--------------
 *          Safari v5/OS X  |       -120       |       0
 *          Safari v5/Win7  |       -120       |       0
 *         Chrome v17/OS X  |       -120       |       0
 *         Chrome v17/Win7  |       -120       |       0
 *                IE9/Win7  |       -120       |   undefined
 *         Firefox v4/OS X  |     undefined    |       1
 *         Firefox v4/Win7  |     undefined    |       3
 *
 */
function normalizeWheel(/*object*/ event) /*object*/ {
  var sX = 0, sY = 0,       // spinX, spinY
      pX = 0, pY = 0;       // pixelX, pixelY

  // Legacy
  if ('detail'      in event) { sY = event.detail; }
  if ('wheelDelta'  in event) { sY = -event.wheelDelta / 120; }
  if ('wheelDeltaY' in event) { sY = -event.wheelDeltaY / 120; }
  if ('wheelDeltaX' in event) { sX = -event.wheelDeltaX / 120; }

  // side scrolling on FF with DOMMouseScroll
  if ( 'axis' in event && event.axis === event.HORIZONTAL_AXIS ) {
    sX = sY;
    sY = 0;
  }

  pX = sX * PIXEL_STEP;
  pY = sY * PIXEL_STEP;

  if ('deltaY' in event) { pY = event.deltaY; }
  if ('deltaX' in event) { pX = event.deltaX; }

  if ((pX || pY) && event.deltaMode) {
    if (event.deltaMode == 1) {          // delta in LINE units
      pX *= LINE_HEIGHT;
      pY *= LINE_HEIGHT;
    } else {                             // delta in PAGE units
      pX *= PAGE_HEIGHT;
      pY *= PAGE_HEIGHT;
    }
  }

  // Fall-back if spin cannot be determined
  if (pX && !sX) { sX = (pX < 1) ? -1 : 1; }
  if (pY && !sY) { sY = (pY < 1) ? -1 : 1; }

  return { spinX  : sX,
           spinY  : sY,
           pixelX : pX,
           pixelY : pY };
}


/**
 * The best combination if you prefer spinX + spinY normalization.  It favors
 * the older DOMMouseScroll for Firefox, as FF does not include wheelDelta with
 * 'wheel' event, making spin speed determination impossible.
 */
normalizeWheel.getEventType = function() /*string*/ {
  return (UserAgent_DEPRECATED.firefox())
           ? 'DOMMouseScroll'
           : (isEventSupported('wheel'))
               ? 'wheel'
               : 'mousewheel';
};

module.exports = normalizeWheel;


/***/ }),

/***/ 7374:
/***/ ((module) => {

"use strict";


let list = {
  comma(string) {
    return list.split(string, [','], true)
  },

  space(string) {
    let spaces = [' ', '\n', '\t']
    return list.split(string, spaces)
  },

  split(string, separators, last) {
    let array = []
    let current = ''
    let split = false

    let func = 0
    let inQuote = false
    let prevQuote = ''
    let escape = false

    for (let letter of string) {
      if (escape) {
        escape = false
      } else if (letter === '\\') {
        escape = true
      } else if (inQuote) {
        if (letter === prevQuote) {
          inQuote = false
        }
      } else if (letter === '"' || letter === "'") {
        inQuote = true
        prevQuote = letter
      } else if (letter === '(') {
        func += 1
      } else if (letter === ')') {
        if (func > 0) func -= 1
      } else if (func === 0) {
        if (separators.includes(letter)) split = true
      }

      if (split) {
        if (current !== '') array.push(current.trim())
        current = ''
        split = false
      } else {
        current += letter
      }
    }

    if (last || current !== '') array.push(current.trim())
    return array
  }
}

module.exports = list
list.default = list


/***/ }),

/***/ 7490:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let CssSyntaxError = __webpack_require__(356)
let Stringifier = __webpack_require__(346)
let stringify = __webpack_require__(633)
let { isClean, my } = __webpack_require__(1381)

function cloneNode(obj, parent) {
  let cloned = new obj.constructor()

  for (let i in obj) {
    if (!Object.prototype.hasOwnProperty.call(obj, i)) {
      /* c8 ignore next 2 */
      continue
    }
    if (i === 'proxyCache') continue
    let value = obj[i]
    let type = typeof value

    if (i === 'parent' && type === 'object') {
      if (parent) cloned[i] = parent
    } else if (i === 'source') {
      cloned[i] = value
    } else if (Array.isArray(value)) {
      cloned[i] = value.map(j => cloneNode(j, cloned))
    } else {
      if (type === 'object' && value !== null) value = cloneNode(value)
      cloned[i] = value
    }
  }

  return cloned
}

function sourceOffset(inputCSS, position) {
  // Not all custom syntaxes support `offset` in `source.start` and `source.end`
  if (position && typeof position.offset !== 'undefined') {
    return position.offset
  }

  let column = 1
  let line = 1
  let offset = 0

  for (let i = 0; i < inputCSS.length; i++) {
    if (line === position.line && column === position.column) {
      offset = i
      break
    }

    if (inputCSS[i] === '\n') {
      column = 1
      line += 1
    } else {
      column += 1
    }
  }

  return offset
}

class Node {
  get proxyOf() {
    return this
  }

  constructor(defaults = {}) {
    this.raws = {}
    this[isClean] = false
    this[my] = true

    for (let name in defaults) {
      if (name === 'nodes') {
        this.nodes = []
        for (let node of defaults[name]) {
          if (typeof node.clone === 'function') {
            this.append(node.clone())
          } else {
            this.append(node)
          }
        }
      } else {
        this[name] = defaults[name]
      }
    }
  }

  addToError(error) {
    error.postcssNode = this
    if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
      let s = this.source
      error.stack = error.stack.replace(
        /\n\s{4}at /,
        `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
      )
    }
    return error
  }

  after(add) {
    this.parent.insertAfter(this, add)
    return this
  }

  assign(overrides = {}) {
    for (let name in overrides) {
      this[name] = overrides[name]
    }
    return this
  }

  before(add) {
    this.parent.insertBefore(this, add)
    return this
  }

  cleanRaws(keepBetween) {
    delete this.raws.before
    delete this.raws.after
    if (!keepBetween) delete this.raws.between
  }

  clone(overrides = {}) {
    let cloned = cloneNode(this)
    for (let name in overrides) {
      cloned[name] = overrides[name]
    }
    return cloned
  }

  cloneAfter(overrides = {}) {
    let cloned = this.clone(overrides)
    this.parent.insertAfter(this, cloned)
    return cloned
  }

  cloneBefore(overrides = {}) {
    let cloned = this.clone(overrides)
    this.parent.insertBefore(this, cloned)
    return cloned
  }

  error(message, opts = {}) {
    if (this.source) {
      let { end, start } = this.rangeBy(opts)
      return this.source.input.error(
        message,
        { column: start.column, line: start.line },
        { column: end.column, line: end.line },
        opts
      )
    }
    return new CssSyntaxError(message)
  }

  getProxyProcessor() {
    return {
      get(node, prop) {
        if (prop === 'proxyOf') {
          return node
        } else if (prop === 'root') {
          return () => node.root().toProxy()
        } else {
          return node[prop]
        }
      },

      set(node, prop, value) {
        if (node[prop] === value) return true
        node[prop] = value
        if (
          prop === 'prop' ||
          prop === 'value' ||
          prop === 'name' ||
          prop === 'params' ||
          prop === 'important' ||
          /* c8 ignore next */
          prop === 'text'
        ) {
          node.markDirty()
        }
        return true
      }
    }
  }

  /* c8 ignore next 3 */
  markClean() {
    this[isClean] = true
  }

  markDirty() {
    if (this[isClean]) {
      this[isClean] = false
      let next = this
      while ((next = next.parent)) {
        next[isClean] = false
      }
    }
  }

  next() {
    if (!this.parent) return undefined
    let index = this.parent.index(this)
    return this.parent.nodes[index + 1]
  }

  positionBy(opts = {}) {
    let pos = this.source.start
    if (opts.index) {
      pos = this.positionInside(opts.index)
    } else if (opts.word) {
      let inputString =
        'document' in this.source.input
          ? this.source.input.document
          : this.source.input.css
      let stringRepresentation = inputString.slice(
        sourceOffset(inputString, this.source.start),
        sourceOffset(inputString, this.source.end)
      )
      let index = stringRepresentation.indexOf(opts.word)
      if (index !== -1) pos = this.positionInside(index)
    }
    return pos
  }

  positionInside(index) {
    let column = this.source.start.column
    let line = this.source.start.line
    let inputString =
      'document' in this.source.input
        ? this.source.input.document
        : this.source.input.css
    let offset = sourceOffset(inputString, this.source.start)
    let end = offset + index

    for (let i = offset; i < end; i++) {
      if (inputString[i] === '\n') {
        column = 1
        line += 1
      } else {
        column += 1
      }
    }

    return { column, line, offset: end }
  }

  prev() {
    if (!this.parent) return undefined
    let index = this.parent.index(this)
    return this.parent.nodes[index - 1]
  }

  rangeBy(opts = {}) {
    let inputString =
      'document' in this.source.input
        ? this.source.input.document
        : this.source.input.css
    let start = {
      column: this.source.start.column,
      line: this.source.start.line,
      offset: sourceOffset(inputString, this.source.start)
    }
    let end = this.source.end
      ? {
          column: this.source.end.column + 1,
          line: this.source.end.line,
          offset:
            typeof this.source.end.offset === 'number'
              ? // `source.end.offset` is exclusive, so we don't need to add 1
                this.source.end.offset
              : // Since line/column in this.source.end is inclusive,
                // the `sourceOffset(... , this.source.end)` returns an inclusive offset.
                // So, we add 1 to convert it to exclusive.
                sourceOffset(inputString, this.source.end) + 1
        }
      : {
          column: start.column + 1,
          line: start.line,
          offset: start.offset + 1
        }

    if (opts.word) {
      let stringRepresentation = inputString.slice(
        sourceOffset(inputString, this.source.start),
        sourceOffset(inputString, this.source.end)
      )
      let index = stringRepresentation.indexOf(opts.word)
      if (index !== -1) {
        start = this.positionInside(index)
        end = this.positionInside(index + opts.word.length)
      }
    } else {
      if (opts.start) {
        start = {
          column: opts.start.column,
          line: opts.start.line,
          offset: sourceOffset(inputString, opts.start)
        }
      } else if (opts.index) {
        start = this.positionInside(opts.index)
      }

      if (opts.end) {
        end = {
          column: opts.end.column,
          line: opts.end.line,
          offset: sourceOffset(inputString, opts.end)
        }
      } else if (typeof opts.endIndex === 'number') {
        end = this.positionInside(opts.endIndex)
      } else if (opts.index) {
        end = this.positionInside(opts.index + 1)
      }
    }

    if (
      end.line < start.line ||
      (end.line === start.line && end.column <= start.column)
    ) {
      end = {
        column: start.column + 1,
        line: start.line,
        offset: start.offset + 1
      }
    }

    return { end, start }
  }

  raw(prop, defaultType) {
    let str = new Stringifier()
    return str.raw(this, prop, defaultType)
  }

  remove() {
    if (this.parent) {
      this.parent.removeChild(this)
    }
    this.parent = undefined
    return this
  }

  replaceWith(...nodes) {
    if (this.parent) {
      let bookmark = this
      let foundSelf = false
      for (let node of nodes) {
        if (node === this) {
          foundSelf = true
        } else if (foundSelf) {
          this.parent.insertAfter(bookmark, node)
          bookmark = node
        } else {
          this.parent.insertBefore(bookmark, node)
        }
      }

      if (!foundSelf) {
        this.remove()
      }
    }

    return this
  }

  root() {
    let result = this
    while (result.parent && result.parent.type !== 'document') {
      result = result.parent
    }
    return result
  }

  toJSON(_, inputs) {
    let fixed = {}
    let emitInputs = inputs == null
    inputs = inputs || new Map()
    let inputsNextIndex = 0

    for (let name in this) {
      if (!Object.prototype.hasOwnProperty.call(this, name)) {
        /* c8 ignore next 2 */
        continue
      }
      if (name === 'parent' || name === 'proxyCache') continue
      let value = this[name]

      if (Array.isArray(value)) {
        fixed[name] = value.map(i => {
          if (typeof i === 'object' && i.toJSON) {
            return i.toJSON(null, inputs)
          } else {
            return i
          }
        })
      } else if (typeof value === 'object' && value.toJSON) {
        fixed[name] = value.toJSON(null, inputs)
      } else if (name === 'source') {
        if (value == null) continue
        let inputId = inputs.get(value.input)
        if (inputId == null) {
          inputId = inputsNextIndex
          inputs.set(value.input, inputsNextIndex)
          inputsNextIndex++
        }
        fixed[name] = {
          end: value.end,
          inputId,
          start: value.start
        }
      } else {
        fixed[name] = value
      }
    }

    if (emitInputs) {
      fixed.inputs = [...inputs.keys()].map(input => input.toJSON())
    }

    return fixed
  }

  toProxy() {
    if (!this.proxyCache) {
      this.proxyCache = new Proxy(this, this.getProxyProcessor())
    }
    return this.proxyCache
  }

  toString(stringifier = stringify) {
    if (stringifier.stringify) stringifier = stringifier.stringify
    let result = ''
    stringifier(this, i => {
      result += i
    })
    return result
  }

  warn(result, text, opts = {}) {
    let data = { node: this }
    for (let i in opts) data[i] = opts[i]
    return result.warn(text, data)
  }
}

module.exports = Node
Node.default = Node


/***/ }),

/***/ 7520:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(7191);


/***/ }),

/***/ 7661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let MapGenerator = __webpack_require__(1670)
let parse = __webpack_require__(4295)
const Result = __webpack_require__(9055)
let stringify = __webpack_require__(633)
let warnOnce = __webpack_require__(3122)

class NoWorkResult {
  get content() {
    return this.result.css
  }

  get css() {
    return this.result.css
  }

  get map() {
    return this.result.map
  }

  get messages() {
    return []
  }

  get opts() {
    return this.result.opts
  }

  get processor() {
    return this.result.processor
  }

  get root() {
    if (this._root) {
      return this._root
    }

    let root
    let parser = parse

    try {
      root = parser(this._css, this._opts)
    } catch (error) {
      this.error = error
    }

    if (this.error) {
      throw this.error
    } else {
      this._root = root
      return root
    }
  }

  get [Symbol.toStringTag]() {
    return 'NoWorkResult'
  }

  constructor(processor, css, opts) {
    css = css.toString()
    this.stringified = false

    this._processor = processor
    this._css = css
    this._opts = opts
    this._map = undefined
    let root

    let str = stringify
    this.result = new Result(this._processor, root, this._opts)
    this.result.css = css

    let self = this
    Object.defineProperty(this.result, 'root', {
      get() {
        return self.root
      }
    })

    let map = new MapGenerator(str, root, this._opts, css)
    if (map.isMap()) {
      let [generatedCSS, generatedMap] = map.generate()
      if (generatedCSS) {
        this.result.css = generatedCSS
      }
      if (generatedMap) {
        this.result.map = generatedMap
      }
    } else {
      map.clearAnnotation()
      this.result.css = map.css
    }
  }

  async() {
    if (this.error) return Promise.reject(this.error)
    return Promise.resolve(this.result)
  }

  catch(onRejected) {
    return this.async().catch(onRejected)
  }

  finally(onFinally) {
    return this.async().then(onFinally, onFinally)
  }

  sync() {
    if (this.error) throw this.error
    return this.result
  }

  then(onFulfilled, onRejected) {
    if (false) {}

    return this.async().then(onFulfilled, onRejected)
  }

  toString() {
    return this._css
  }

  warnings() {
    return []
  }
}

module.exports = NoWorkResult
NoWorkResult.default = NoWorkResult


/***/ }),

/***/ 7734:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst


  var envHasBigInt64Array = typeof BigInt64Array !== 'undefined';


module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }


    if ((a instanceof Map) && (b instanceof Map)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      for (i of a.entries())
        if (!equal(i[1], b.get(i[0]))) return false;
      return true;
    }

    if ((a instanceof Set) && (b instanceof Set)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      return true;
    }

    if (ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (a[i] !== b[i]) return false;
      return true;
    }


    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 8021:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;
/*istanbul ignore start*/


__webpack_unused_export__ = ({
  value: true
});
exports.JJ = diffChars;
__webpack_unused_export__ = void 0;

/*istanbul ignore end*/
var
/*istanbul ignore start*/
_base = _interopRequireDefault(__webpack_require__(5417))
/*istanbul ignore end*/
;

/*istanbul ignore start*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*istanbul ignore end*/
var characterDiff = new
/*istanbul ignore start*/
_base
/*istanbul ignore end*/
.
/*istanbul ignore start*/
default
/*istanbul ignore end*/
();

/*istanbul ignore start*/
__webpack_unused_export__ = characterDiff;

/*istanbul ignore end*/
function diffChars(oldStr, newStr, options) {
  return characterDiff.diff(oldStr, newStr, options);
}


/***/ }),

/***/ 8202:
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule ExecutionEnvironment
 */

/*jslint evil: true */



var canUseDOM = !!(
  typeof window !== 'undefined' &&
  window.document &&
  window.document.createElement
);

/**
 * Simple, lightweight module assisting with the detection and context of
 * Worker. Helps avoid circular dependencies and allows code to reason about
 * whether or not they are in a Worker, even if they never include the main
 * `ReactWorker` dependency.
 */
var ExecutionEnvironment = {

  canUseDOM: canUseDOM,

  canUseWorkers: typeof Worker !== 'undefined',

  canUseEventListeners:
    canUseDOM && !!(window.addEventListener || window.attachEvent),

  canUseViewport: canUseDOM && !!window.screen,

  isInWorker: !canUseDOM // For now, this is true - might change in the future.

};

module.exports = ExecutionEnvironment;


/***/ }),

/***/ 8491:
/***/ ((module) => {

var openParentheses = "(".charCodeAt(0);
var closeParentheses = ")".charCodeAt(0);
var singleQuote = "'".charCodeAt(0);
var doubleQuote = '"'.charCodeAt(0);
var backslash = "\\".charCodeAt(0);
var slash = "/".charCodeAt(0);
var comma = ",".charCodeAt(0);
var colon = ":".charCodeAt(0);
var star = "*".charCodeAt(0);
var uLower = "u".charCodeAt(0);
var uUpper = "U".charCodeAt(0);
var plus = "+".charCodeAt(0);
var isUnicodeRange = /^[a-f0-9?-]+$/i;

module.exports = function(input) {
  var tokens = [];
  var value = input;

  var next,
    quote,
    prev,
    token,
    escape,
    escapePos,
    whitespacePos,
    parenthesesOpenPos;
  var pos = 0;
  var code = value.charCodeAt(pos);
  var max = value.length;
  var stack = [{ nodes: tokens }];
  var balanced = 0;
  var parent;

  var name = "";
  var before = "";
  var after = "";

  while (pos < max) {
    // Whitespaces
    if (code <= 32) {
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      token = value.slice(pos, next);

      prev = tokens[tokens.length - 1];
      if (code === closeParentheses && balanced) {
        after = token;
      } else if (prev && prev.type === "div") {
        prev.after = token;
        prev.sourceEndIndex += token.length;
      } else if (
        code === comma ||
        code === colon ||
        (code === slash &&
          value.charCodeAt(next + 1) !== star &&
          (!parent ||
            (parent && parent.type === "function" && parent.value !== "calc")))
      ) {
        before = token;
      } else {
        tokens.push({
          type: "space",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;

      // Quotes
    } else if (code === singleQuote || code === doubleQuote) {
      next = pos;
      quote = code === singleQuote ? "'" : '"';
      token = {
        type: "string",
        sourceIndex: pos,
        quote: quote
      };
      do {
        escape = false;
        next = value.indexOf(quote, next + 1);
        if (~next) {
          escapePos = next;
          while (value.charCodeAt(escapePos - 1) === backslash) {
            escapePos -= 1;
            escape = !escape;
          }
        } else {
          value += quote;
          next = value.length - 1;
          token.unclosed = true;
        }
      } while (escape);
      token.value = value.slice(pos + 1, next);
      token.sourceEndIndex = token.unclosed ? next : next + 1;
      tokens.push(token);
      pos = next + 1;
      code = value.charCodeAt(pos);

      // Comments
    } else if (code === slash && value.charCodeAt(pos + 1) === star) {
      next = value.indexOf("*/", pos);

      token = {
        type: "comment",
        sourceIndex: pos,
        sourceEndIndex: next + 2
      };

      if (next === -1) {
        token.unclosed = true;
        next = value.length;
        token.sourceEndIndex = next;
      }

      token.value = value.slice(pos + 2, next);
      tokens.push(token);

      pos = next + 2;
      code = value.charCodeAt(pos);

      // Operation within calc
    } else if (
      (code === slash || code === star) &&
      parent &&
      parent.type === "function" &&
      parent.value === "calc"
    ) {
      token = value[pos];
      tokens.push({
        type: "word",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token
      });
      pos += 1;
      code = value.charCodeAt(pos);

      // Dividers
    } else if (code === slash || code === comma || code === colon) {
      token = value[pos];

      tokens.push({
        type: "div",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token,
        before: before,
        after: ""
      });
      before = "";

      pos += 1;
      code = value.charCodeAt(pos);

      // Open parentheses
    } else if (openParentheses === code) {
      // Whitespaces after open parentheses
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      parenthesesOpenPos = pos;
      token = {
        type: "function",
        sourceIndex: pos - name.length,
        value: name,
        before: value.slice(parenthesesOpenPos + 1, next)
      };
      pos = next;

      if (name === "url" && code !== singleQuote && code !== doubleQuote) {
        next -= 1;
        do {
          escape = false;
          next = value.indexOf(")", next + 1);
          if (~next) {
            escapePos = next;
            while (value.charCodeAt(escapePos - 1) === backslash) {
              escapePos -= 1;
              escape = !escape;
            }
          } else {
            value += ")";
            next = value.length - 1;
            token.unclosed = true;
          }
        } while (escape);
        // Whitespaces before closed
        whitespacePos = next;
        do {
          whitespacePos -= 1;
          code = value.charCodeAt(whitespacePos);
        } while (code <= 32);
        if (parenthesesOpenPos < whitespacePos) {
          if (pos !== whitespacePos + 1) {
            token.nodes = [
              {
                type: "word",
                sourceIndex: pos,
                sourceEndIndex: whitespacePos + 1,
                value: value.slice(pos, whitespacePos + 1)
              }
            ];
          } else {
            token.nodes = [];
          }
          if (token.unclosed && whitespacePos + 1 !== next) {
            token.after = "";
            token.nodes.push({
              type: "space",
              sourceIndex: whitespacePos + 1,
              sourceEndIndex: next,
              value: value.slice(whitespacePos + 1, next)
            });
          } else {
            token.after = value.slice(whitespacePos + 1, next);
            token.sourceEndIndex = next;
          }
        } else {
          token.after = "";
          token.nodes = [];
        }
        pos = next + 1;
        token.sourceEndIndex = token.unclosed ? next : pos;
        code = value.charCodeAt(pos);
        tokens.push(token);
      } else {
        balanced += 1;
        token.after = "";
        token.sourceEndIndex = pos + 1;
        tokens.push(token);
        stack.push(token);
        tokens = token.nodes = [];
        parent = token;
      }
      name = "";

      // Close parentheses
    } else if (closeParentheses === code && balanced) {
      pos += 1;
      code = value.charCodeAt(pos);

      parent.after = after;
      parent.sourceEndIndex += after.length;
      after = "";
      balanced -= 1;
      stack[stack.length - 1].sourceEndIndex = pos;
      stack.pop();
      parent = stack[balanced];
      tokens = parent.nodes;

      // Words
    } else {
      next = pos;
      do {
        if (code === backslash) {
          next += 1;
        }
        next += 1;
        code = value.charCodeAt(next);
      } while (
        next < max &&
        !(
          code <= 32 ||
          code === singleQuote ||
          code === doubleQuote ||
          code === comma ||
          code === colon ||
          code === slash ||
          code === openParentheses ||
          (code === star &&
            parent &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === slash &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === closeParentheses && balanced)
        )
      );
      token = value.slice(pos, next);

      if (openParentheses === code) {
        name = token;
      } else if (
        (uLower === token.charCodeAt(0) || uUpper === token.charCodeAt(0)) &&
        plus === token.charCodeAt(1) &&
        isUnicodeRange.test(token.slice(2))
      ) {
        tokens.push({
          type: "unicode-range",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      } else {
        tokens.push({
          type: "word",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;
    }
  }

  for (pos = stack.length - 1; pos; pos -= 1) {
    stack[pos].unclosed = true;
    stack[pos].sourceEndIndex = value.length;
  }

  return stack[0].nodes;
};


/***/ }),

/***/ 9055:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Warning = __webpack_require__(5776)

class Result {
  get content() {
    return this.css
  }

  constructor(processor, root, opts) {
    this.processor = processor
    this.messages = []
    this.root = root
    this.opts = opts
    this.css = ''
    this.map = undefined
  }

  toString() {
    return this.css
  }

  warn(text, opts = {}) {
    if (!opts.plugin) {
      if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
        opts.plugin = this.lastPlugin.postcssPlugin
      }
    }

    let warning = new Warning(text, opts)
    this.messages.push(warning)

    return warning
  }

  warnings() {
    return this.messages.filter(i => i.type === 'warning')
  }
}

module.exports = Result
Result.default = Result


/***/ }),

/***/ 9434:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

let LazyResult, Processor

class Root extends Container {
  constructor(defaults) {
    super(defaults)
    this.type = 'root'
    if (!this.nodes) this.nodes = []
  }

  normalize(child, sample, type) {
    let nodes = super.normalize(child)

    if (sample) {
      if (type === 'prepend') {
        if (this.nodes.length > 1) {
          sample.raws.before = this.nodes[1].raws.before
        } else {
          delete sample.raws.before
        }
      } else if (this.first !== sample) {
        for (let node of nodes) {
          node.raws.before = sample.raws.before
        }
      }
    }

    return nodes
  }

  removeChild(child, ignore) {
    let index = this.index(child)

    if (!ignore && index === 0 && this.nodes.length > 1) {
      this.nodes[1].raws.before = this.nodes[index].raws.before
    }

    return super.removeChild(child)
  }

  toResult(opts = {}) {
    let lazy = new LazyResult(new Processor(), this, opts)
    return lazy.stringify()
  }
}

Root.registerLazyResult = dependant => {
  LazyResult = dependant
}

Root.registerProcessor = dependant => {
  Processor = dependant
}

module.exports = Root
Root.default = Root

Container.registerRoot(Root)


/***/ }),

/***/ 9656:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Document = __webpack_require__(271)
let LazyResult = __webpack_require__(448)
let NoWorkResult = __webpack_require__(7661)
let Root = __webpack_require__(9434)

class Processor {
  constructor(plugins = []) {
    this.version = '8.5.6'
    this.plugins = this.normalize(plugins)
  }

  normalize(plugins) {
    let normalized = []
    for (let i of plugins) {
      if (i.postcss === true) {
        i = i()
      } else if (i.postcss) {
        i = i.postcss
      }

      if (typeof i === 'object' && Array.isArray(i.plugins)) {
        normalized = normalized.concat(i.plugins)
      } else if (typeof i === 'object' && i.postcssPlugin) {
        normalized.push(i)
      } else if (typeof i === 'function') {
        normalized.push(i)
      } else if (typeof i === 'object' && (i.parse || i.stringify)) {
        if (false) {}
      } else {
        throw new Error(i + ' is not a PostCSS plugin')
      }
    }
    return normalized
  }

  process(css, opts = {}) {
    if (
      !this.plugins.length &&
      !opts.parser &&
      !opts.stringifier &&
      !opts.syntax
    ) {
      return new NoWorkResult(this, css, opts)
    } else {
      return new LazyResult(this, css, opts)
    }
  }

  use(plugin) {
    this.plugins = this.plugins.concat(this.normalize([plugin]))
    return this
  }
}

module.exports = Processor
Processor.default = Processor

Root.registerProcessor(Processor)
Document.registerProcessor(Processor)


/***/ }),

/***/ 9681:
/***/ ((module) => {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ả": "A",
	"Ạ": "A",
	"Ẩ": "A",
	"Ẫ": "A",
	"Ậ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ẻ": "E",
	"Ẽ": "E",
	"Ẹ": "E",
	"Ể": "E",
	"Ễ": "E",
	"Ệ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ỉ": "I",
	"Ị": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ỏ": "O",
	"Ọ": "O",
	"Ổ": "O",
	"Ỗ": "O",
	"Ộ": "O",
	"Ờ": "O",
	"Ở": "O",
	"Ỡ": "O",
	"Ớ": "O",
	"Ợ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ủ": "U",
	"Ụ": "U",
	"Ử": "U",
	"Ữ": "U",
	"Ự": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ả": "a",
	"ạ": "a",
	"ẩ": "a",
	"ẫ": "a",
	"ậ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ẻ": "e",
	"ẽ": "e",
	"ẹ": "e",
	"ể": "e",
	"ễ": "e",
	"ệ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ỉ": "i",
	"ị": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ỏ": "o",
	"ọ": "o",
	"ổ": "o",
	"ỗ": "o",
	"ộ": "o",
	"ờ": "o",
	"ở": "o",
	"ỡ": "o",
	"ớ": "o",
	"ợ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ủ": "u",
	"ụ": "u",
	"ử": "u",
	"ữ": "u",
	"ự": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ 9746:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 9977:
/***/ (() => {

/* (ignored) */

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  AlignmentControl: () => (/* reexport */ AlignmentControl),
  AlignmentToolbar: () => (/* reexport */ AlignmentToolbar),
  Autocomplete: () => (/* reexport */ autocomplete_default),
  BlockAlignmentControl: () => (/* reexport */ BlockAlignmentControl),
  BlockAlignmentToolbar: () => (/* reexport */ BlockAlignmentToolbar),
  BlockBreadcrumb: () => (/* reexport */ block_breadcrumb_default),
  BlockCanvas: () => (/* reexport */ block_canvas_default),
  BlockColorsStyleSelector: () => (/* reexport */ color_style_selector_default),
  BlockContextProvider: () => (/* reexport */ BlockContextProvider),
  BlockControls: () => (/* reexport */ block_controls_default),
  BlockEdit: () => (/* reexport */ BlockEdit),
  BlockEditorKeyboardShortcuts: () => (/* reexport */ keyboard_shortcuts_default),
  BlockEditorProvider: () => (/* reexport */ provider_provider_default),
  BlockFormatControls: () => (/* reexport */ BlockFormatControls),
  BlockIcon: () => (/* reexport */ block_icon_default),
  BlockInspector: () => (/* reexport */ block_inspector_default),
  BlockList: () => (/* reexport */ BlockList),
  BlockMover: () => (/* reexport */ block_mover_default),
  BlockNavigationDropdown: () => (/* reexport */ dropdown_default),
  BlockPopover: () => (/* reexport */ block_popover_default),
  BlockPreview: () => (/* reexport */ block_preview_default),
  BlockSelectionClearer: () => (/* reexport */ BlockSelectionClearer),
  BlockSettingsMenu: () => (/* reexport */ block_settings_menu_default),
  BlockSettingsMenuControls: () => (/* reexport */ block_settings_menu_controls_default),
  BlockStyles: () => (/* reexport */ block_styles_default),
  BlockTitle: () => (/* reexport */ BlockTitle),
  BlockToolbar: () => (/* reexport */ BlockToolbar),
  BlockTools: () => (/* reexport */ BlockTools),
  BlockVerticalAlignmentControl: () => (/* reexport */ BlockVerticalAlignmentControl),
  BlockVerticalAlignmentToolbar: () => (/* reexport */ BlockVerticalAlignmentToolbar),
  ButtonBlockAppender: () => (/* reexport */ button_block_appender_default),
  ButtonBlockerAppender: () => (/* reexport */ ButtonBlockerAppender),
  ColorPalette: () => (/* reexport */ color_palette_default),
  ColorPaletteControl: () => (/* reexport */ ColorPaletteControl),
  ContrastChecker: () => (/* reexport */ contrast_checker_default),
  CopyHandler: () => (/* reexport */ CopyHandler),
  DefaultBlockAppender: () => (/* reexport */ DefaultBlockAppender),
  FontSizePicker: () => (/* reexport */ font_size_picker_default),
  HeadingLevelDropdown: () => (/* reexport */ HeadingLevelDropdown),
  HeightControl: () => (/* reexport */ HeightControl),
  InnerBlocks: () => (/* reexport */ inner_blocks_default),
  Inserter: () => (/* reexport */ inserter_default),
  InspectorAdvancedControls: () => (/* reexport */ InspectorAdvancedControls),
  InspectorControls: () => (/* reexport */ inspector_controls_default),
  JustifyContentControl: () => (/* reexport */ JustifyContentControl),
  JustifyToolbar: () => (/* reexport */ JustifyToolbar),
  LineHeightControl: () => (/* reexport */ line_height_control_default),
  LinkControl: () => (/* reexport */ link_control_default),
  MediaPlaceholder: () => (/* reexport */ media_placeholder_default),
  MediaReplaceFlow: () => (/* reexport */ media_replace_flow_default),
  MediaUpload: () => (/* reexport */ media_upload_default),
  MediaUploadCheck: () => (/* reexport */ check_default),
  MultiSelectScrollIntoView: () => (/* reexport */ MultiSelectScrollIntoView),
  NavigableToolbar: () => (/* reexport */ NavigableToolbar),
  ObserveTyping: () => (/* reexport */ observe_typing_default),
  PanelColorSettings: () => (/* reexport */ panel_color_settings_default),
  PlainText: () => (/* reexport */ plain_text_default),
  RecursionProvider: () => (/* reexport */ RecursionProvider),
  RichText: () => (/* reexport */ rich_text_default),
  RichTextShortcut: () => (/* reexport */ RichTextShortcut),
  RichTextToolbarButton: () => (/* reexport */ RichTextToolbarButton),
  SETTINGS_DEFAULTS: () => (/* reexport */ SETTINGS_DEFAULTS),
  SkipToSelectedBlock: () => (/* reexport */ SkipToSelectedBlock),
  Typewriter: () => (/* reexport */ typewriter_default),
  URLInput: () => (/* reexport */ url_input_default),
  URLInputButton: () => (/* reexport */ button_default),
  URLPopover: () => (/* reexport */ url_popover_default),
  Warning: () => (/* reexport */ warning_default),
  WritingFlow: () => (/* reexport */ writing_flow_default),
  __experimentalBlockAlignmentMatrixControl: () => (/* reexport */ block_alignment_matrix_control_default),
  __experimentalBlockFullHeightAligmentControl: () => (/* reexport */ block_full_height_alignment_control_default),
  __experimentalBlockPatternSetup: () => (/* reexport */ block_pattern_setup_default),
  __experimentalBlockPatternsList: () => (/* reexport */ block_patterns_list_default),
  __experimentalBlockVariationPicker: () => (/* reexport */ block_variation_picker_default),
  __experimentalBlockVariationTransforms: () => (/* reexport */ block_variation_transforms_default),
  __experimentalBorderRadiusControl: () => (/* reexport */ BorderRadiusControl),
  __experimentalColorGradientControl: () => (/* reexport */ control_default),
  __experimentalColorGradientSettingsDropdown: () => (/* reexport */ ColorGradientSettingsDropdown),
  __experimentalDateFormatPicker: () => (/* reexport */ DateFormatPicker),
  __experimentalDuotoneControl: () => (/* reexport */ duotone_control_default),
  __experimentalFontAppearanceControl: () => (/* reexport */ FontAppearanceControl),
  __experimentalFontFamilyControl: () => (/* reexport */ FontFamilyControl),
  __experimentalGetBorderClassesAndStyles: () => (/* reexport */ getBorderClassesAndStyles),
  __experimentalGetColorClassesAndStyles: () => (/* reexport */ getColorClassesAndStyles),
  __experimentalGetElementClassName: () => (/* reexport */ __experimentalGetElementClassName),
  __experimentalGetGapCSSValue: () => (/* reexport */ getGapCSSValue),
  __experimentalGetGradientClass: () => (/* reexport */ __experimentalGetGradientClass),
  __experimentalGetGradientObjectByGradientValue: () => (/* reexport */ __experimentalGetGradientObjectByGradientValue),
  __experimentalGetShadowClassesAndStyles: () => (/* reexport */ getShadowClassesAndStyles),
  __experimentalGetSpacingClassesAndStyles: () => (/* reexport */ getSpacingClassesAndStyles),
  __experimentalImageEditor: () => (/* reexport */ ImageEditor),
  __experimentalImageSizeControl: () => (/* reexport */ ImageSizeControl),
  __experimentalImageURLInputUI: () => (/* reexport */ ImageURLInputUI),
  __experimentalInspectorPopoverHeader: () => (/* reexport */ InspectorPopoverHeader),
  __experimentalLetterSpacingControl: () => (/* reexport */ LetterSpacingControl),
  __experimentalLibrary: () => (/* reexport */ library_default),
  __experimentalLinkControl: () => (/* reexport */ DeprecatedExperimentalLinkControl),
  __experimentalLinkControlSearchInput: () => (/* reexport */ __experimentalLinkControlSearchInput),
  __experimentalLinkControlSearchItem: () => (/* reexport */ __experimentalLinkControlSearchItem),
  __experimentalLinkControlSearchResults: () => (/* reexport */ __experimentalLinkControlSearchResults),
  __experimentalListView: () => (/* reexport */ list_view_list_view_default),
  __experimentalPanelColorGradientSettings: () => (/* reexport */ panel_color_gradient_settings_default),
  __experimentalPreviewOptions: () => (/* reexport */ PreviewOptions),
  __experimentalPublishDateTimePicker: () => (/* reexport */ publish_date_time_picker_default),
  __experimentalRecursionProvider: () => (/* reexport */ DeprecatedExperimentalRecursionProvider),
  __experimentalResponsiveBlockControl: () => (/* reexport */ responsive_block_control_default),
  __experimentalSpacingSizesControl: () => (/* reexport */ SpacingSizesControl),
  __experimentalTextDecorationControl: () => (/* reexport */ TextDecorationControl),
  __experimentalTextTransformControl: () => (/* reexport */ TextTransformControl),
  __experimentalUnitControl: () => (/* reexport */ UnitControl),
  __experimentalUseBlockOverlayActive: () => (/* reexport */ useBlockOverlayActive),
  __experimentalUseBlockPreview: () => (/* reexport */ useBlockPreview),
  __experimentalUseBorderProps: () => (/* reexport */ useBorderProps),
  __experimentalUseColorProps: () => (/* reexport */ useColorProps),
  __experimentalUseCustomSides: () => (/* reexport */ useCustomSides),
  __experimentalUseGradient: () => (/* reexport */ __experimentalUseGradient),
  __experimentalUseHasRecursion: () => (/* reexport */ DeprecatedExperimentalUseHasRecursion),
  __experimentalUseMultipleOriginColorsAndGradients: () => (/* reexport */ useMultipleOriginColorsAndGradients),
  __experimentalUseResizeCanvas: () => (/* reexport */ useResizeCanvas),
  __experimentalWritingModeControl: () => (/* reexport */ WritingModeControl),
  __unstableBlockNameContext: () => (/* reexport */ block_name_context_default),
  __unstableBlockSettingsMenuFirstItem: () => (/* reexport */ block_settings_menu_first_item_default),
  __unstableBlockToolbarLastItem: () => (/* reexport */ block_toolbar_last_item_default),
  __unstableEditorStyles: () => (/* reexport */ editor_styles_default),
  __unstableIframe: () => (/* reexport */ iframe_default),
  __unstableInserterMenuExtension: () => (/* reexport */ inserter_menu_extension_default),
  __unstableRichTextInputEvent: () => (/* reexport */ __unstableRichTextInputEvent),
  __unstableUseBlockSelectionClearer: () => (/* reexport */ useBlockSelectionClearer),
  __unstableUseClipboardHandler: () => (/* reexport */ __unstableUseClipboardHandler),
  __unstableUseMouseMoveTypingReset: () => (/* reexport */ useMouseMoveTypingReset),
  __unstableUseTypewriter: () => (/* reexport */ useTypewriter),
  __unstableUseTypingObserver: () => (/* reexport */ useTypingObserver),
  createCustomColorsHOC: () => (/* reexport */ createCustomColorsHOC),
  getColorClassName: () => (/* reexport */ getColorClassName),
  getColorObjectByAttributeValues: () => (/* reexport */ getColorObjectByAttributeValues),
  getColorObjectByColorValue: () => (/* reexport */ getColorObjectByColorValue),
  getComputedFluidTypographyValue: () => (/* reexport */ getComputedFluidTypographyValue),
  getCustomValueFromPreset: () => (/* reexport */ getCustomValueFromPreset),
  getFontSize: () => (/* reexport */ utils_getFontSize),
  getFontSizeClass: () => (/* reexport */ getFontSizeClass),
  getFontSizeObjectByValue: () => (/* reexport */ utils_getFontSizeObjectByValue),
  getGradientSlugByValue: () => (/* reexport */ getGradientSlugByValue),
  getGradientValueBySlug: () => (/* reexport */ getGradientValueBySlug),
  getPxFromCssUnit: () => (/* reexport */ get_px_from_css_unit_default),
  getSpacingPresetCssVar: () => (/* reexport */ getSpacingPresetCssVar),
  getTypographyClassesAndStyles: () => (/* reexport */ getTypographyClassesAndStyles),
  isValueSpacingPreset: () => (/* reexport */ isValueSpacingPreset),
  privateApis: () => (/* reexport */ privateApis),
  store: () => (/* reexport */ store),
  storeConfig: () => (/* reexport */ storeConfig),
  transformStyles: () => (/* reexport */ transform_styles_default),
  useBlockBindingsUtils: () => (/* reexport */ useBlockBindingsUtils),
  useBlockCommands: () => (/* reexport */ useBlockCommands),
  useBlockDisplayInformation: () => (/* reexport */ useBlockDisplayInformation),
  useBlockEditContext: () => (/* reexport */ useBlockEditContext),
  useBlockEditingMode: () => (/* reexport */ useBlockEditingMode),
  useBlockProps: () => (/* reexport */ use_block_props_useBlockProps),
  useCachedTruthy: () => (/* reexport */ useCachedTruthy),
  useHasRecursion: () => (/* reexport */ useHasRecursion),
  useInnerBlocksProps: () => (/* reexport */ useInnerBlocksProps),
  useSetting: () => (/* reexport */ useSetting),
  useSettings: () => (/* reexport */ use_settings_useSettings),
  useStyleOverride: () => (/* reexport */ useStyleOverride),
  withColorContext: () => (/* reexport */ with_color_context_default),
  withColors: () => (/* reexport */ withColors),
  withFontSizes: () => (/* reexport */ with_font_sizes_default)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js
var private_selectors_namespaceObject = {};
__webpack_require__.r(private_selectors_namespaceObject);
__webpack_require__.d(private_selectors_namespaceObject, {
  getAllPatterns: () => (getAllPatterns),
  getBlockRemovalRules: () => (getBlockRemovalRules),
  getBlockSettings: () => (getBlockSettings),
  getBlockStyles: () => (getBlockStyles),
  getBlockWithoutAttributes: () => (getBlockWithoutAttributes),
  getClosestAllowedInsertionPoint: () => (getClosestAllowedInsertionPoint),
  getClosestAllowedInsertionPointForPattern: () => (getClosestAllowedInsertionPointForPattern),
  getContentLockingParent: () => (getContentLockingParent),
  getEnabledBlockParents: () => (getEnabledBlockParents),
  getEnabledClientIdsTree: () => (getEnabledClientIdsTree),
  getExpandedBlock: () => (getExpandedBlock),
  getInserterMediaCategories: () => (getInserterMediaCategories),
  getInsertionPoint: () => (getInsertionPoint),
  getLastFocus: () => (getLastFocus),
  getLastInsertedBlocksClientIds: () => (getLastInsertedBlocksClientIds),
  getOpenedBlockSettingsMenu: () => (getOpenedBlockSettingsMenu),
  getParentSectionBlock: () => (getParentSectionBlock),
  getPatternBySlug: () => (getPatternBySlug),
  getRegisteredInserterMediaCategories: () => (getRegisteredInserterMediaCategories),
  getRemovalPromptData: () => (getRemovalPromptData),
  getReusableBlocks: () => (getReusableBlocks),
  getSectionRootClientId: () => (getSectionRootClientId),
  getStyleOverrides: () => (getStyleOverrides),
  getTemporarilyEditingAsBlocks: () => (getTemporarilyEditingAsBlocks),
  getTemporarilyEditingFocusModeToRevert: () => (getTemporarilyEditingFocusModeToRevert),
  getZoomLevel: () => (getZoomLevel),
  hasAllowedPatterns: () => (hasAllowedPatterns),
  hasBlockSpotlight: () => (private_selectors_hasBlockSpotlight),
  isBlockHidden: () => (isBlockHidden),
  isBlockInterfaceHidden: () => (private_selectors_isBlockInterfaceHidden),
  isBlockSubtreeDisabled: () => (isBlockSubtreeDisabled),
  isContainerInsertableToInContentOnlyMode: () => (isContainerInsertableToInContentOnlyMode),
  isDragging: () => (private_selectors_isDragging),
  isSectionBlock: () => (isSectionBlock),
  isZoomOut: () => (isZoomOut)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  __experimentalGetActiveBlockIdByBlockNames: () => (__experimentalGetActiveBlockIdByBlockNames),
  __experimentalGetAllowedBlocks: () => (__experimentalGetAllowedBlocks),
  __experimentalGetAllowedPatterns: () => (__experimentalGetAllowedPatterns),
  __experimentalGetBlockListSettingsForBlocks: () => (__experimentalGetBlockListSettingsForBlocks),
  __experimentalGetDirectInsertBlock: () => (__experimentalGetDirectInsertBlock),
  __experimentalGetGlobalBlocksByName: () => (__experimentalGetGlobalBlocksByName),
  __experimentalGetLastBlockAttributeChanges: () => (__experimentalGetLastBlockAttributeChanges),
  __experimentalGetParsedPattern: () => (__experimentalGetParsedPattern),
  __experimentalGetPatternTransformItems: () => (__experimentalGetPatternTransformItems),
  __experimentalGetPatternsByBlockTypes: () => (__experimentalGetPatternsByBlockTypes),
  __experimentalGetReusableBlockTitle: () => (__experimentalGetReusableBlockTitle),
  __unstableGetBlockWithoutInnerBlocks: () => (__unstableGetBlockWithoutInnerBlocks),
  __unstableGetClientIdWithClientIdsTree: () => (__unstableGetClientIdWithClientIdsTree),
  __unstableGetClientIdsTree: () => (__unstableGetClientIdsTree),
  __unstableGetContentLockingParent: () => (__unstableGetContentLockingParent),
  __unstableGetSelectedBlocksWithPartialSelection: () => (__unstableGetSelectedBlocksWithPartialSelection),
  __unstableGetTemporarilyEditingAsBlocks: () => (__unstableGetTemporarilyEditingAsBlocks),
  __unstableGetTemporarilyEditingFocusModeToRevert: () => (__unstableGetTemporarilyEditingFocusModeToRevert),
  __unstableGetVisibleBlocks: () => (__unstableGetVisibleBlocks),
  __unstableHasActiveBlockOverlayActive: () => (__unstableHasActiveBlockOverlayActive),
  __unstableIsFullySelected: () => (__unstableIsFullySelected),
  __unstableIsLastBlockChangeIgnored: () => (__unstableIsLastBlockChangeIgnored),
  __unstableIsSelectionCollapsed: () => (__unstableIsSelectionCollapsed),
  __unstableIsSelectionMergeable: () => (__unstableIsSelectionMergeable),
  __unstableIsWithinBlockOverlay: () => (__unstableIsWithinBlockOverlay),
  __unstableSelectionHasUnmergeableBlock: () => (__unstableSelectionHasUnmergeableBlock),
  areInnerBlocksControlled: () => (areInnerBlocksControlled),
  canEditBlock: () => (canEditBlock),
  canInsertBlockType: () => (canInsertBlockType),
  canInsertBlocks: () => (canInsertBlocks),
  canLockBlockType: () => (canLockBlockType),
  canMoveBlock: () => (canMoveBlock),
  canMoveBlocks: () => (canMoveBlocks),
  canRemoveBlock: () => (canRemoveBlock),
  canRemoveBlocks: () => (canRemoveBlocks),
  didAutomaticChange: () => (didAutomaticChange),
  getAdjacentBlockClientId: () => (getAdjacentBlockClientId),
  getAllowedBlocks: () => (getAllowedBlocks),
  getBlock: () => (getBlock),
  getBlockAttributes: () => (getBlockAttributes),
  getBlockCount: () => (getBlockCount),
  getBlockEditingMode: () => (getBlockEditingMode),
  getBlockHierarchyRootClientId: () => (getBlockHierarchyRootClientId),
  getBlockIndex: () => (getBlockIndex),
  getBlockInsertionPoint: () => (getBlockInsertionPoint),
  getBlockListSettings: () => (getBlockListSettings),
  getBlockMode: () => (getBlockMode),
  getBlockName: () => (getBlockName),
  getBlockNamesByClientId: () => (getBlockNamesByClientId),
  getBlockOrder: () => (getBlockOrder),
  getBlockParents: () => (getBlockParents),
  getBlockParentsByBlockName: () => (getBlockParentsByBlockName),
  getBlockRootClientId: () => (getBlockRootClientId),
  getBlockSelectionEnd: () => (getBlockSelectionEnd),
  getBlockSelectionStart: () => (getBlockSelectionStart),
  getBlockTransformItems: () => (getBlockTransformItems),
  getBlocks: () => (getBlocks),
  getBlocksByClientId: () => (getBlocksByClientId),
  getBlocksByName: () => (getBlocksByName),
  getClientIdsOfDescendants: () => (getClientIdsOfDescendants),
  getClientIdsWithDescendants: () => (getClientIdsWithDescendants),
  getDirectInsertBlock: () => (getDirectInsertBlock),
  getDraggedBlockClientIds: () => (getDraggedBlockClientIds),
  getFirstMultiSelectedBlockClientId: () => (getFirstMultiSelectedBlockClientId),
  getGlobalBlockCount: () => (getGlobalBlockCount),
  getHoveredBlockClientId: () => (getHoveredBlockClientId),
  getInserterItems: () => (getInserterItems),
  getLastMultiSelectedBlockClientId: () => (getLastMultiSelectedBlockClientId),
  getLowestCommonAncestorWithSelectedBlock: () => (getLowestCommonAncestorWithSelectedBlock),
  getMultiSelectedBlockClientIds: () => (getMultiSelectedBlockClientIds),
  getMultiSelectedBlocks: () => (getMultiSelectedBlocks),
  getMultiSelectedBlocksEndClientId: () => (getMultiSelectedBlocksEndClientId),
  getMultiSelectedBlocksStartClientId: () => (getMultiSelectedBlocksStartClientId),
  getNextBlockClientId: () => (getNextBlockClientId),
  getPatternsByBlockTypes: () => (getPatternsByBlockTypes),
  getPreviousBlockClientId: () => (getPreviousBlockClientId),
  getSelectedBlock: () => (getSelectedBlock),
  getSelectedBlockClientId: () => (getSelectedBlockClientId),
  getSelectedBlockClientIds: () => (getSelectedBlockClientIds),
  getSelectedBlockCount: () => (getSelectedBlockCount),
  getSelectedBlocksInitialCaretPosition: () => (getSelectedBlocksInitialCaretPosition),
  getSelectionEnd: () => (getSelectionEnd),
  getSelectionStart: () => (getSelectionStart),
  getSettings: () => (getSettings),
  getTemplate: () => (getTemplate),
  getTemplateLock: () => (getTemplateLock),
  hasBlockMovingClientId: () => (hasBlockMovingClientId),
  hasDraggedInnerBlock: () => (hasDraggedInnerBlock),
  hasInserterItems: () => (hasInserterItems),
  hasMultiSelection: () => (hasMultiSelection),
  hasSelectedBlock: () => (hasSelectedBlock),
  hasSelectedInnerBlock: () => (hasSelectedInnerBlock),
  isAncestorBeingDragged: () => (isAncestorBeingDragged),
  isAncestorMultiSelected: () => (isAncestorMultiSelected),
  isBlockBeingDragged: () => (isBlockBeingDragged),
  isBlockHighlighted: () => (isBlockHighlighted),
  isBlockInsertionPointVisible: () => (isBlockInsertionPointVisible),
  isBlockMultiSelected: () => (isBlockMultiSelected),
  isBlockSelected: () => (isBlockSelected),
  isBlockValid: () => (isBlockValid),
  isBlockVisible: () => (isBlockVisible),
  isBlockWithinSelection: () => (isBlockWithinSelection),
  isCaretWithinFormattedText: () => (isCaretWithinFormattedText),
  isDraggingBlocks: () => (isDraggingBlocks),
  isFirstMultiSelectedBlock: () => (isFirstMultiSelectedBlock),
  isGroupable: () => (isGroupable),
  isLastBlockChangePersistent: () => (isLastBlockChangePersistent),
  isMultiSelecting: () => (selectors_isMultiSelecting),
  isSelectionEnabled: () => (selectors_isSelectionEnabled),
  isTyping: () => (selectors_isTyping),
  isUngroupable: () => (isUngroupable),
  isValidTemplate: () => (isValidTemplate),
  wasBlockJustInserted: () => (wasBlockJustInserted)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js
var private_actions_namespaceObject = {};
__webpack_require__.r(private_actions_namespaceObject);
__webpack_require__.d(private_actions_namespaceObject, {
  __experimentalUpdateSettings: () => (__experimentalUpdateSettings),
  clearBlockRemovalPrompt: () => (clearBlockRemovalPrompt),
  deleteStyleOverride: () => (deleteStyleOverride),
  ensureDefaultBlock: () => (ensureDefaultBlock),
  expandBlock: () => (expandBlock),
  hideBlockInterface: () => (hideBlockInterface),
  modifyContentLockBlock: () => (modifyContentLockBlock),
  privateRemoveBlocks: () => (privateRemoveBlocks),
  resetZoomLevel: () => (resetZoomLevel),
  setBlockRemovalRules: () => (setBlockRemovalRules),
  setInsertionPoint: () => (setInsertionPoint),
  setLastFocus: () => (setLastFocus),
  setOpenedBlockSettingsMenu: () => (setOpenedBlockSettingsMenu),
  setStyleOverride: () => (setStyleOverride),
  setZoomLevel: () => (setZoomLevel),
  showBlockInterface: () => (showBlockInterface),
  startDragging: () => (startDragging),
  stopDragging: () => (stopDragging),
  stopEditingAsBlocks: () => (stopEditingAsBlocks),
  toggleBlockSpotlight: () => (toggleBlockSpotlight)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  __unstableDeleteSelection: () => (__unstableDeleteSelection),
  __unstableExpandSelection: () => (__unstableExpandSelection),
  __unstableMarkAutomaticChange: () => (__unstableMarkAutomaticChange),
  __unstableMarkLastChangeAsPersistent: () => (__unstableMarkLastChangeAsPersistent),
  __unstableMarkNextChangeAsNotPersistent: () => (__unstableMarkNextChangeAsNotPersistent),
  __unstableSaveReusableBlock: () => (__unstableSaveReusableBlock),
  __unstableSetEditorMode: () => (__unstableSetEditorMode),
  __unstableSetTemporarilyEditingAsBlocks: () => (__unstableSetTemporarilyEditingAsBlocks),
  __unstableSplitSelection: () => (__unstableSplitSelection),
  clearSelectedBlock: () => (clearSelectedBlock),
  duplicateBlocks: () => (duplicateBlocks),
  enterFormattedText: () => (enterFormattedText),
  exitFormattedText: () => (exitFormattedText),
  flashBlock: () => (flashBlock),
  hideInsertionPoint: () => (hideInsertionPoint),
  hoverBlock: () => (hoverBlock),
  insertAfterBlock: () => (insertAfterBlock),
  insertBeforeBlock: () => (insertBeforeBlock),
  insertBlock: () => (insertBlock),
  insertBlocks: () => (insertBlocks),
  insertDefaultBlock: () => (insertDefaultBlock),
  mergeBlocks: () => (mergeBlocks),
  moveBlockToPosition: () => (moveBlockToPosition),
  moveBlocksDown: () => (moveBlocksDown),
  moveBlocksToPosition: () => (moveBlocksToPosition),
  moveBlocksUp: () => (moveBlocksUp),
  multiSelect: () => (multiSelect),
  receiveBlocks: () => (receiveBlocks),
  registerInserterMediaCategory: () => (registerInserterMediaCategory),
  removeBlock: () => (removeBlock),
  removeBlocks: () => (removeBlocks),
  replaceBlock: () => (replaceBlock),
  replaceBlocks: () => (replaceBlocks),
  replaceInnerBlocks: () => (replaceInnerBlocks),
  resetBlocks: () => (resetBlocks),
  resetSelection: () => (resetSelection),
  selectBlock: () => (selectBlock),
  selectNextBlock: () => (selectNextBlock),
  selectPreviousBlock: () => (selectPreviousBlock),
  selectionChange: () => (selectionChange),
  setBlockEditingMode: () => (setBlockEditingMode),
  setBlockMovingClientId: () => (setBlockMovingClientId),
  setBlockVisibility: () => (setBlockVisibility),
  setHasControlledInnerBlocks: () => (setHasControlledInnerBlocks),
  setTemplateValidity: () => (setTemplateValidity),
  showInsertionPoint: () => (showInsertionPoint),
  startDraggingBlocks: () => (startDraggingBlocks),
  startMultiSelect: () => (startMultiSelect),
  startTyping: () => (startTyping),
  stopDraggingBlocks: () => (stopDraggingBlocks),
  stopMultiSelect: () => (stopMultiSelect),
  stopTyping: () => (stopTyping),
  synchronizeTemplate: () => (synchronizeTemplate),
  toggleBlockHighlight: () => (toggleBlockHighlight),
  toggleBlockMode: () => (toggleBlockMode),
  toggleSelection: () => (toggleSelection),
  unsetBlockEditingMode: () => (unsetBlockEditingMode),
  updateBlock: () => (updateBlock),
  updateBlockAttributes: () => (updateBlockAttributes),
  updateBlockListSettings: () => (updateBlockListSettings),
  updateSettings: () => (updateSettings),
  validateBlocksToTemplate: () => (validateBlocksToTemplate)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/upload-media/build-module/store/selectors.js
var store_selectors_namespaceObject = {};
__webpack_require__.r(store_selectors_namespaceObject);
__webpack_require__.d(store_selectors_namespaceObject, {
  getItems: () => (getItems),
  getSettings: () => (selectors_getSettings),
  isUploading: () => (isUploading),
  isUploadingById: () => (isUploadingById),
  isUploadingByUrl: () => (isUploadingByUrl)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/upload-media/build-module/store/private-selectors.js
var store_private_selectors_namespaceObject = {};
__webpack_require__.r(store_private_selectors_namespaceObject);
__webpack_require__.d(store_private_selectors_namespaceObject, {
  getAllItems: () => (getAllItems),
  getBlobUrls: () => (getBlobUrls),
  getItem: () => (getItem),
  getPausedUploadForPost: () => (getPausedUploadForPost),
  isBatchUploaded: () => (isBatchUploaded),
  isPaused: () => (isPaused),
  isUploadingToPost: () => (isUploadingToPost)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/upload-media/build-module/store/actions.js
var store_actions_namespaceObject = {};
__webpack_require__.r(store_actions_namespaceObject);
__webpack_require__.d(store_actions_namespaceObject, {
  addItems: () => (addItems),
  cancelItem: () => (cancelItem)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/upload-media/build-module/store/private-actions.js
var store_private_actions_namespaceObject = {};
__webpack_require__.r(store_private_actions_namespaceObject);
__webpack_require__.d(store_private_actions_namespaceObject, {
  addItem: () => (addItem),
  finishOperation: () => (finishOperation),
  pauseQueue: () => (pauseQueue),
  prepareItem: () => (prepareItem),
  processItem: () => (processItem),
  removeItem: () => (removeItem),
  resumeQueue: () => (resumeQueue),
  revokeBlobUrls: () => (revokeBlobUrls),
  updateSettings: () => (private_actions_updateSettings),
  uploadItem: () => (uploadItem)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/index.js
var global_styles_namespaceObject = {};
__webpack_require__.r(global_styles_namespaceObject);
__webpack_require__.d(global_styles_namespaceObject, {
  AdvancedPanel: () => (AdvancedPanel),
  BackgroundPanel: () => (background_panel_BackgroundImagePanel),
  BorderPanel: () => (BorderPanel),
  ColorPanel: () => (ColorPanel),
  DimensionsPanel: () => (DimensionsPanel),
  FiltersPanel: () => (FiltersPanel),
  GlobalStylesContext: () => (GlobalStylesContext),
  ImageSettingsPanel: () => (ImageSettingsPanel),
  TypographyPanel: () => (TypographyPanel),
  areGlobalStyleConfigsEqual: () => (areGlobalStyleConfigsEqual),
  getBlockCSSSelector: () => (getBlockCSSSelector),
  getBlockSelectors: () => (getBlockSelectors),
  getGlobalStylesChanges: () => (getGlobalStylesChanges),
  getLayoutStyles: () => (getLayoutStyles),
  toStyles: () => (toStyles),
  useGlobalSetting: () => (useGlobalSetting),
  useGlobalStyle: () => (useGlobalStyle),
  useGlobalStylesOutput: () => (useGlobalStylesOutput),
  useGlobalStylesOutputWithConfig: () => (useGlobalStylesOutputWithConfig),
  useGlobalStylesReset: () => (useGlobalStylesReset),
  useHasBackgroundPanel: () => (useHasBackgroundPanel),
  useHasBorderPanel: () => (useHasBorderPanel),
  useHasBorderPanelControls: () => (useHasBorderPanelControls),
  useHasColorPanel: () => (useHasColorPanel),
  useHasDimensionsPanel: () => (useHasDimensionsPanel),
  useHasFiltersPanel: () => (useHasFiltersPanel),
  useHasImageSettingsPanel: () => (useHasImageSettingsPanel),
  useHasTypographyPanel: () => (useHasTypographyPanel),
  useSettingsForBlockElement: () => (useSettingsForBlockElement)
});

;// external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// external ["wp","hooks"]
const external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// ./node_modules/@wordpress/block-editor/build-module/components/block-edit/context.js

const mayDisplayControlsKey = Symbol("mayDisplayControls");
const mayDisplayParentControlsKey = Symbol("mayDisplayParentControls");
const blockEditingModeKey = Symbol("blockEditingMode");
const blockBindingsKey = Symbol("blockBindings");
const isPreviewModeKey = Symbol("isPreviewMode");
const DEFAULT_BLOCK_EDIT_CONTEXT = {
  name: "",
  isSelected: false
};
const Context = (0,external_wp_element_namespaceObject.createContext)(DEFAULT_BLOCK_EDIT_CONTEXT);
Context.displayName = "BlockEditContext";
const { Provider } = Context;
function useBlockEditContext() {
  return (0,external_wp_element_namespaceObject.useContext)(Context);
}


;// external ["wp","deprecated"]
const external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
// EXTERNAL MODULE: ./node_modules/fast-deep-equal/es6/index.js
var es6 = __webpack_require__(7734);
var es6_default = /*#__PURE__*/__webpack_require__.n(es6);
;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// ./node_modules/@wordpress/block-editor/build-module/store/defaults.js

const PREFERENCES_DEFAULTS = {
  insertUsage: {}
};
const SETTINGS_DEFAULTS = {
  alignWide: false,
  supportsLayout: true,
  // colors setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  colors: [
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Black"),
      slug: "black",
      color: "#000000"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Cyan bluish gray"),
      slug: "cyan-bluish-gray",
      color: "#abb8c3"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("White"),
      slug: "white",
      color: "#ffffff"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Pale pink"),
      slug: "pale-pink",
      color: "#f78da7"
    },
    { name: (0,external_wp_i18n_namespaceObject.__)("Vivid red"), slug: "vivid-red", color: "#cf2e2e" },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Luminous vivid orange"),
      slug: "luminous-vivid-orange",
      color: "#ff6900"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Luminous vivid amber"),
      slug: "luminous-vivid-amber",
      color: "#fcb900"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Light green cyan"),
      slug: "light-green-cyan",
      color: "#7bdcb5"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Vivid green cyan"),
      slug: "vivid-green-cyan",
      color: "#00d084"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Pale cyan blue"),
      slug: "pale-cyan-blue",
      color: "#8ed1fc"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Vivid cyan blue"),
      slug: "vivid-cyan-blue",
      color: "#0693e3"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Vivid purple"),
      slug: "vivid-purple",
      color: "#9b51e0"
    }
  ],
  // fontSizes setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  fontSizes: [
    {
      name: (0,external_wp_i18n_namespaceObject._x)("Small", "font size name"),
      size: 13,
      slug: "small"
    },
    {
      name: (0,external_wp_i18n_namespaceObject._x)("Normal", "font size name"),
      size: 16,
      slug: "normal"
    },
    {
      name: (0,external_wp_i18n_namespaceObject._x)("Medium", "font size name"),
      size: 20,
      slug: "medium"
    },
    {
      name: (0,external_wp_i18n_namespaceObject._x)("Large", "font size name"),
      size: 36,
      slug: "large"
    },
    {
      name: (0,external_wp_i18n_namespaceObject._x)("Huge", "font size name"),
      size: 42,
      slug: "huge"
    }
  ],
  // Image default size slug.
  imageDefaultSize: "large",
  imageSizes: [
    { slug: "thumbnail", name: (0,external_wp_i18n_namespaceObject.__)("Thumbnail") },
    { slug: "medium", name: (0,external_wp_i18n_namespaceObject.__)("Medium") },
    { slug: "large", name: (0,external_wp_i18n_namespaceObject.__)("Large") },
    { slug: "full", name: (0,external_wp_i18n_namespaceObject.__)("Full Size") }
  ],
  // Allow plugin to disable Image Editor if need be.
  imageEditing: true,
  // This is current max width of the block inner area
  // It's used to constraint image resizing and this value could be overridden later by themes
  maxWidth: 580,
  // Allowed block types for the editor, defaulting to true (all supported).
  allowedBlockTypes: true,
  // Maximum upload size in bytes allowed for the site.
  maxUploadFileSize: 0,
  // List of allowed mime types and file extensions.
  allowedMimeTypes: null,
  // Allows to disable block locking interface.
  canLockBlocks: true,
  // Allows to disable Openverse media category in the inserter.
  enableOpenverseMediaCategory: true,
  clearBlockSelection: true,
  __experimentalCanUserUseUnfilteredHTML: false,
  __experimentalBlockDirectory: false,
  __mobileEnablePageTemplates: false,
  __experimentalBlockPatterns: [],
  __experimentalBlockPatternCategories: [],
  isPreviewMode: false,
  // These settings will be completely revamped in the future.
  // The goal is to evolve this into an API which will instruct
  // the block inspector to animate transitions between what it
  // displays based on the relationship between the selected block
  // and its parent, and only enable it if the parent is controlling
  // its children blocks.
  blockInspectorAnimation: {
    animationParent: "core/navigation",
    "core/navigation": { enterDirection: "leftToRight" },
    "core/navigation-submenu": { enterDirection: "rightToLeft" },
    "core/navigation-link": { enterDirection: "rightToLeft" },
    "core/search": { enterDirection: "rightToLeft" },
    "core/social-links": { enterDirection: "rightToLeft" },
    "core/page-list": { enterDirection: "rightToLeft" },
    "core/spacer": { enterDirection: "rightToLeft" },
    "core/home-link": { enterDirection: "rightToLeft" },
    "core/site-title": { enterDirection: "rightToLeft" },
    "core/site-logo": { enterDirection: "rightToLeft" }
  },
  generateAnchors: false,
  // gradients setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  gradients: [
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Vivid cyan blue to vivid purple"),
      gradient: "linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)",
      slug: "vivid-cyan-blue-to-vivid-purple"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Light green cyan to vivid green cyan"),
      gradient: "linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%)",
      slug: "light-green-cyan-to-vivid-green-cyan"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Luminous vivid amber to luminous vivid orange"),
      gradient: "linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%)",
      slug: "luminous-vivid-amber-to-luminous-vivid-orange"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Luminous vivid orange to vivid red"),
      gradient: "linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%)",
      slug: "luminous-vivid-orange-to-vivid-red"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Very light gray to cyan bluish gray"),
      gradient: "linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%)",
      slug: "very-light-gray-to-cyan-bluish-gray"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Cool to warm spectrum"),
      gradient: "linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%)",
      slug: "cool-to-warm-spectrum"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Blush light purple"),
      gradient: "linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%)",
      slug: "blush-light-purple"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Blush bordeaux"),
      gradient: "linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%)",
      slug: "blush-bordeaux"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Luminous dusk"),
      gradient: "linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%)",
      slug: "luminous-dusk"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Pale ocean"),
      gradient: "linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%)",
      slug: "pale-ocean"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Electric grass"),
      gradient: "linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%)",
      slug: "electric-grass"
    },
    {
      name: (0,external_wp_i18n_namespaceObject.__)("Midnight"),
      gradient: "linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%)",
      slug: "midnight"
    }
  ],
  __unstableResolvedAssets: { styles: [], scripts: [] }
};


;// ./node_modules/@wordpress/block-editor/build-module/store/array.js
function insertAt(array, elements, index) {
  return [
    ...array.slice(0, index),
    ...Array.isArray(elements) ? elements : [elements],
    ...array.slice(index)
  ];
}
function moveTo(array, from, to, count = 1) {
  const withoutMovedElements = [...array];
  withoutMovedElements.splice(from, count);
  return insertAt(
    withoutMovedElements,
    array.slice(from, from + count),
    to
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/store/private-keys.js
const globalStylesDataKey = Symbol("globalStylesDataKey");
const globalStylesLinksDataKey = Symbol("globalStylesLinks");
const selectBlockPatternsKey = Symbol("selectBlockPatternsKey");
const reusableBlocksSelectKey = Symbol("reusableBlocksSelect");
const sectionRootClientIdKey = Symbol("sectionRootClientIdKey");
const mediaEditKey = Symbol("mediaEditKey");
const essentialFormatKey = Symbol("essentialFormat");


;// external ["wp","privateApis"]
const external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// ./node_modules/@wordpress/block-editor/build-module/lock-unlock.js

const { lock, unlock } = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)(
  "I acknowledge private features are not for use in themes or plugins and doing so will break in the next version of WordPress.",
  "@wordpress/block-editor"
);


;// ./node_modules/@wordpress/block-editor/build-module/store/reducer.js









const { isContentBlock } = unlock(external_wp_blocks_namespaceObject.privateApis);
const identity = (x) => x;
function mapBlockOrder(blocks2, rootClientId = "") {
  const result = /* @__PURE__ */ new Map();
  const current = [];
  result.set(rootClientId, current);
  blocks2.forEach((block) => {
    const { clientId, innerBlocks } = block;
    current.push(clientId);
    mapBlockOrder(innerBlocks, clientId).forEach(
      (order, subClientId) => {
        result.set(subClientId, order);
      }
    );
  });
  return result;
}
function mapBlockParents(blocks2, rootClientId = "") {
  const result = [];
  const stack = [[rootClientId, blocks2]];
  while (stack.length) {
    const [parent, currentBlocks] = stack.shift();
    currentBlocks.forEach(({ innerBlocks, ...block }) => {
      result.push([block.clientId, parent]);
      if (innerBlocks?.length) {
        stack.push([block.clientId, innerBlocks]);
      }
    });
  }
  return result;
}
function flattenBlocks(blocks2, transform = identity) {
  const result = [];
  const stack = [...blocks2];
  while (stack.length) {
    const { innerBlocks, ...block } = stack.shift();
    stack.push(...innerBlocks);
    result.push([block.clientId, transform(block)]);
  }
  return result;
}
function getFlattenedClientIds(blocks2) {
  const result = {};
  const stack = [...blocks2];
  while (stack.length) {
    const { innerBlocks, ...block } = stack.shift();
    stack.push(...innerBlocks);
    result[block.clientId] = true;
  }
  return result;
}
function getFlattenedBlocksWithoutAttributes(blocks2) {
  return flattenBlocks(blocks2, (block) => {
    const { attributes, ...restBlock } = block;
    return restBlock;
  });
}
function getFlattenedBlockAttributes(blocks2) {
  return flattenBlocks(blocks2, (block) => block.attributes);
}
function hasSameKeys(a, b) {
  return es6_default()(Object.keys(a), Object.keys(b));
}
function isUpdatingSameBlockAttribute(action, lastAction) {
  return action.type === "UPDATE_BLOCK_ATTRIBUTES" && lastAction !== void 0 && lastAction.type === "UPDATE_BLOCK_ATTRIBUTES" && es6_default()(action.clientIds, lastAction.clientIds) && hasSameKeys(action.attributes, lastAction.attributes);
}
function updateBlockTreeForBlocks(state, blocks2) {
  const treeToUpdate = state.tree;
  const stack = [...blocks2];
  const flattenedBlocks = [...blocks2];
  while (stack.length) {
    const block = stack.shift();
    stack.push(...block.innerBlocks);
    flattenedBlocks.push(...block.innerBlocks);
  }
  for (const block of flattenedBlocks) {
    treeToUpdate.set(block.clientId, {});
  }
  for (const block of flattenedBlocks) {
    treeToUpdate.set(
      block.clientId,
      Object.assign(treeToUpdate.get(block.clientId), {
        ...state.byClientId.get(block.clientId),
        attributes: state.attributes.get(block.clientId),
        innerBlocks: block.innerBlocks.map(
          (subBlock) => treeToUpdate.get(subBlock.clientId)
        )
      })
    );
  }
}
function updateParentInnerBlocksInTree(state, updatedClientIds, updateChildrenOfUpdatedClientIds = false) {
  const treeToUpdate = state.tree;
  const uncontrolledParents = /* @__PURE__ */ new Set([]);
  const controlledParents = /* @__PURE__ */ new Set();
  for (const clientId of updatedClientIds) {
    let current = updateChildrenOfUpdatedClientIds ? clientId : state.parents.get(clientId);
    do {
      if (state.controlledInnerBlocks[current]) {
        controlledParents.add(current);
        break;
      } else {
        uncontrolledParents.add(current);
        current = state.parents.get(current);
      }
    } while (current !== void 0);
  }
  for (const clientId of uncontrolledParents) {
    treeToUpdate.set(clientId, { ...treeToUpdate.get(clientId) });
  }
  for (const clientId of uncontrolledParents) {
    treeToUpdate.get(clientId).innerBlocks = (state.order.get(clientId) || []).map((subClientId) => treeToUpdate.get(subClientId));
  }
  for (const clientId of controlledParents) {
    treeToUpdate.set("controlled||" + clientId, {
      innerBlocks: (state.order.get(clientId) || []).map(
        (subClientId) => treeToUpdate.get(subClientId)
      )
    });
  }
}
const withBlockTree = (reducer) => (state = {}, action) => {
  const newState = reducer(state, action);
  if (newState === state) {
    return state;
  }
  newState.tree = state.tree ? state.tree : /* @__PURE__ */ new Map();
  switch (action.type) {
    case "RECEIVE_BLOCKS":
    case "INSERT_BLOCKS": {
      newState.tree = new Map(newState.tree);
      updateBlockTreeForBlocks(newState, action.blocks);
      updateParentInnerBlocksInTree(
        newState,
        action.rootClientId ? [action.rootClientId] : [""],
        true
      );
      break;
    }
    case "UPDATE_BLOCK":
      newState.tree = new Map(newState.tree);
      newState.tree.set(action.clientId, {
        ...newState.tree.get(action.clientId),
        ...newState.byClientId.get(action.clientId),
        attributes: newState.attributes.get(action.clientId)
      });
      updateParentInnerBlocksInTree(
        newState,
        [action.clientId],
        false
      );
      break;
    case "SYNC_DERIVED_BLOCK_ATTRIBUTES":
    case "UPDATE_BLOCK_ATTRIBUTES": {
      newState.tree = new Map(newState.tree);
      action.clientIds.forEach((clientId) => {
        newState.tree.set(clientId, {
          ...newState.tree.get(clientId),
          attributes: newState.attributes.get(clientId)
        });
      });
      updateParentInnerBlocksInTree(
        newState,
        action.clientIds,
        false
      );
      break;
    }
    case "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
      const inserterClientIds = getFlattenedClientIds(
        action.blocks
      );
      newState.tree = new Map(newState.tree);
      action.replacedClientIds.forEach((clientId) => {
        newState.tree.delete(clientId);
        if (!inserterClientIds[clientId]) {
          newState.tree.delete("controlled||" + clientId);
        }
      });
      updateBlockTreeForBlocks(newState, action.blocks);
      updateParentInnerBlocksInTree(
        newState,
        action.blocks.map((b) => b.clientId),
        false
      );
      const parentsOfRemovedBlocks2 = [];
      for (const clientId of action.clientIds) {
        const parentId = state.parents.get(clientId);
        if (parentId !== void 0 && (parentId === "" || newState.byClientId.get(parentId))) {
          parentsOfRemovedBlocks2.push(parentId);
        }
      }
      updateParentInnerBlocksInTree(
        newState,
        parentsOfRemovedBlocks2,
        true
      );
      break;
    }
    case "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN":
      const parentsOfRemovedBlocks = [];
      for (const clientId of action.clientIds) {
        const parentId = state.parents.get(clientId);
        if (parentId !== void 0 && (parentId === "" || newState.byClientId.get(parentId))) {
          parentsOfRemovedBlocks.push(parentId);
        }
      }
      newState.tree = new Map(newState.tree);
      action.removedClientIds.forEach((clientId) => {
        newState.tree.delete(clientId);
        newState.tree.delete("controlled||" + clientId);
      });
      updateParentInnerBlocksInTree(
        newState,
        parentsOfRemovedBlocks,
        true
      );
      break;
    case "MOVE_BLOCKS_TO_POSITION": {
      const updatedBlockUids = [];
      if (action.fromRootClientId) {
        updatedBlockUids.push(action.fromRootClientId);
      } else {
        updatedBlockUids.push("");
      }
      if (action.toRootClientId) {
        updatedBlockUids.push(action.toRootClientId);
      }
      newState.tree = new Map(newState.tree);
      updateParentInnerBlocksInTree(
        newState,
        updatedBlockUids,
        true
      );
      break;
    }
    case "MOVE_BLOCKS_UP":
    case "MOVE_BLOCKS_DOWN": {
      const updatedBlockUids = [
        action.rootClientId ? action.rootClientId : ""
      ];
      newState.tree = new Map(newState.tree);
      updateParentInnerBlocksInTree(
        newState,
        updatedBlockUids,
        true
      );
      break;
    }
    case "SAVE_REUSABLE_BLOCK_SUCCESS": {
      const updatedBlockUids = [];
      newState.attributes.forEach((attributes, clientId) => {
        if (newState.byClientId.get(clientId).name === "core/block" && attributes.ref === action.updatedId) {
          updatedBlockUids.push(clientId);
        }
      });
      newState.tree = new Map(newState.tree);
      updatedBlockUids.forEach((clientId) => {
        newState.tree.set(clientId, {
          ...newState.byClientId.get(clientId),
          attributes: newState.attributes.get(clientId),
          innerBlocks: newState.tree.get(clientId).innerBlocks
        });
      });
      updateParentInnerBlocksInTree(
        newState,
        updatedBlockUids,
        false
      );
    }
  }
  return newState;
};
function withPersistentBlockChange(reducer) {
  let lastAction;
  let markNextChangeAsNotPersistent = false;
  let explicitPersistent;
  return (state, action) => {
    let nextState = reducer(state, action);
    let nextIsPersistentChange;
    if (action.type === "SET_EXPLICIT_PERSISTENT") {
      explicitPersistent = action.isPersistentChange;
      nextIsPersistentChange = state.isPersistentChange ?? true;
    }
    if (explicitPersistent !== void 0) {
      nextIsPersistentChange = explicitPersistent;
      return nextIsPersistentChange === nextState.isPersistentChange ? nextState : {
        ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }
    const isExplicitPersistentChange = action.type === "MARK_LAST_CHANGE_AS_PERSISTENT" || markNextChangeAsNotPersistent;
    if (state === nextState && !isExplicitPersistentChange) {
      markNextChangeAsNotPersistent = action.type === "MARK_NEXT_CHANGE_AS_NOT_PERSISTENT";
      nextIsPersistentChange = state?.isPersistentChange ?? true;
      if (state.isPersistentChange === nextIsPersistentChange) {
        return state;
      }
      return {
        ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }
    nextState = {
      ...nextState,
      isPersistentChange: isExplicitPersistentChange ? !markNextChangeAsNotPersistent : !isUpdatingSameBlockAttribute(action, lastAction)
    };
    lastAction = action;
    markNextChangeAsNotPersistent = action.type === "MARK_NEXT_CHANGE_AS_NOT_PERSISTENT";
    return nextState;
  };
}
function withIgnoredBlockChange(reducer) {
  const IGNORED_ACTION_TYPES = /* @__PURE__ */ new Set(["RECEIVE_BLOCKS"]);
  return (state, action) => {
    const nextState = reducer(state, action);
    if (nextState !== state) {
      nextState.isIgnoredChange = IGNORED_ACTION_TYPES.has(action.type);
    }
    return nextState;
  };
}
const withInnerBlocksRemoveCascade = (reducer) => (state, action) => {
  const getAllChildren = (clientIds) => {
    let result = clientIds;
    for (let i = 0; i < result.length; i++) {
      if (!state.order.get(result[i]) || action.keepControlledInnerBlocks && action.keepControlledInnerBlocks[result[i]]) {
        continue;
      }
      if (result === clientIds) {
        result = [...result];
      }
      result.push(...state.order.get(result[i]));
    }
    return result;
  };
  if (state) {
    switch (action.type) {
      case "REMOVE_BLOCKS":
        action = {
          ...action,
          type: "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN",
          removedClientIds: getAllChildren(action.clientIds)
        };
        break;
      case "REPLACE_BLOCKS":
        action = {
          ...action,
          type: "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN",
          replacedClientIds: getAllChildren(action.clientIds)
        };
        break;
    }
  }
  return reducer(state, action);
};
const withBlockReset = (reducer) => (state, action) => {
  if (action.type === "RESET_BLOCKS") {
    const newState = {
      ...state,
      byClientId: new Map(
        getFlattenedBlocksWithoutAttributes(action.blocks)
      ),
      attributes: new Map(getFlattenedBlockAttributes(action.blocks)),
      order: mapBlockOrder(action.blocks),
      parents: new Map(mapBlockParents(action.blocks)),
      controlledInnerBlocks: {}
    };
    newState.tree = new Map(state?.tree);
    updateBlockTreeForBlocks(newState, action.blocks);
    newState.tree.set("", {
      innerBlocks: action.blocks.map(
        (subBlock) => newState.tree.get(subBlock.clientId)
      )
    });
    return newState;
  }
  return reducer(state, action);
};
const withReplaceInnerBlocks = (reducer) => (state, action) => {
  if (action.type !== "REPLACE_INNER_BLOCKS") {
    return reducer(state, action);
  }
  const nestedControllers = {};
  if (Object.keys(state.controlledInnerBlocks).length) {
    const stack = [...action.blocks];
    while (stack.length) {
      const { innerBlocks, ...block } = stack.shift();
      stack.push(...innerBlocks);
      if (!!state.controlledInnerBlocks[block.clientId]) {
        nestedControllers[block.clientId] = true;
      }
    }
  }
  let stateAfterBlocksRemoval = state;
  if (state.order.get(action.rootClientId)) {
    stateAfterBlocksRemoval = reducer(stateAfterBlocksRemoval, {
      type: "REMOVE_BLOCKS",
      keepControlledInnerBlocks: nestedControllers,
      clientIds: state.order.get(action.rootClientId)
    });
  }
  let stateAfterInsert = stateAfterBlocksRemoval;
  if (action.blocks.length) {
    stateAfterInsert = reducer(stateAfterInsert, {
      ...action,
      type: "INSERT_BLOCKS",
      index: 0
    });
    const stateAfterInsertOrder = new Map(stateAfterInsert.order);
    Object.keys(nestedControllers).forEach((key) => {
      if (state.order.get(key)) {
        stateAfterInsertOrder.set(key, state.order.get(key));
      }
    });
    stateAfterInsert.order = stateAfterInsertOrder;
    stateAfterInsert.tree = new Map(stateAfterInsert.tree);
    Object.keys(nestedControllers).forEach((_key) => {
      const key = `controlled||${_key}`;
      if (state.tree.has(key)) {
        stateAfterInsert.tree.set(key, state.tree.get(key));
      }
    });
  }
  return stateAfterInsert;
};
const withSaveReusableBlock = (reducer) => (state, action) => {
  if (state && action.type === "SAVE_REUSABLE_BLOCK_SUCCESS") {
    const { id, updatedId } = action;
    if (id === updatedId) {
      return state;
    }
    state = { ...state };
    state.attributes = new Map(state.attributes);
    state.attributes.forEach((attributes, clientId) => {
      const { name } = state.byClientId.get(clientId);
      if (name === "core/block" && attributes.ref === id) {
        state.attributes.set(clientId, {
          ...attributes,
          ref: updatedId
        });
      }
    });
  }
  return reducer(state, action);
};
const withResetControlledBlocks = (reducer) => (state, action) => {
  if (action.type === "SET_HAS_CONTROLLED_INNER_BLOCKS") {
    const tempState = reducer(state, {
      type: "REPLACE_INNER_BLOCKS",
      rootClientId: action.clientId,
      blocks: []
    });
    return reducer(tempState, action);
  }
  return reducer(state, action);
};
const blocks = (0,external_wp_compose_namespaceObject.pipe)(
  external_wp_data_namespaceObject.combineReducers,
  withSaveReusableBlock,
  // Needs to be before withBlockCache.
  withBlockTree,
  // Needs to be before withInnerBlocksRemoveCascade.
  withInnerBlocksRemoveCascade,
  withReplaceInnerBlocks,
  // Needs to be after withInnerBlocksRemoveCascade.
  withBlockReset,
  withPersistentBlockChange,
  withIgnoredBlockChange,
  withResetControlledBlocks
)({
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  byClientId(state = /* @__PURE__ */ new Map(), action) {
    switch (action.type) {
      case "RECEIVE_BLOCKS":
      case "INSERT_BLOCKS": {
        const newState = new Map(state);
        getFlattenedBlocksWithoutAttributes(action.blocks).forEach(
          ([key, value]) => {
            newState.set(key, value);
          }
        );
        return newState;
      }
      case "UPDATE_BLOCK": {
        if (!state.has(action.clientId)) {
          return state;
        }
        const { attributes, ...changes } = action.updates;
        if (Object.values(changes).length === 0) {
          return state;
        }
        const newState = new Map(state);
        newState.set(action.clientId, {
          ...state.get(action.clientId),
          ...changes
        });
        return newState;
      }
      case "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        if (!action.blocks) {
          return state;
        }
        const newState = new Map(state);
        action.replacedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        getFlattenedBlocksWithoutAttributes(action.blocks).forEach(
          ([key, value]) => {
            newState.set(key, value);
          }
        );
        return newState;
      }
      case "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const newState = new Map(state);
        action.removedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        return newState;
      }
    }
    return state;
  },
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  attributes(state = /* @__PURE__ */ new Map(), action) {
    switch (action.type) {
      case "RECEIVE_BLOCKS":
      case "INSERT_BLOCKS": {
        const newState = new Map(state);
        getFlattenedBlockAttributes(action.blocks).forEach(
          ([key, value]) => {
            newState.set(key, value);
          }
        );
        return newState;
      }
      case "UPDATE_BLOCK": {
        if (!state.get(action.clientId) || !action.updates.attributes) {
          return state;
        }
        const newState = new Map(state);
        newState.set(action.clientId, {
          ...state.get(action.clientId),
          ...action.updates.attributes
        });
        return newState;
      }
      case "SYNC_DERIVED_BLOCK_ATTRIBUTES":
      case "UPDATE_BLOCK_ATTRIBUTES": {
        if (action.clientIds.every((id) => !state.get(id))) {
          return state;
        }
        let hasChange = false;
        const newState = new Map(state);
        for (const clientId of action.clientIds) {
          const updatedAttributeEntries = Object.entries(
            !!action.options?.uniqueByBlock ? action.attributes[clientId] : action.attributes ?? {}
          );
          if (updatedAttributeEntries.length === 0) {
            continue;
          }
          let hasUpdatedAttributes = false;
          const existingAttributes = state.get(clientId);
          const newAttributes = {};
          updatedAttributeEntries.forEach(([key, value]) => {
            if (existingAttributes[key] !== value) {
              hasUpdatedAttributes = true;
              newAttributes[key] = value;
            }
          });
          hasChange = hasChange || hasUpdatedAttributes;
          if (hasUpdatedAttributes) {
            newState.set(clientId, {
              ...existingAttributes,
              ...newAttributes
            });
          }
        }
        return hasChange ? newState : state;
      }
      case "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        if (!action.blocks) {
          return state;
        }
        const newState = new Map(state);
        action.replacedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        getFlattenedBlockAttributes(action.blocks).forEach(
          ([key, value]) => {
            newState.set(key, value);
          }
        );
        return newState;
      }
      case "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const newState = new Map(state);
        action.removedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        return newState;
      }
    }
    return state;
  },
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  order(state = /* @__PURE__ */ new Map(), action) {
    switch (action.type) {
      case "RECEIVE_BLOCKS": {
        const blockOrder = mapBlockOrder(action.blocks);
        const newState = new Map(state);
        blockOrder.forEach((order, clientId) => {
          if (clientId !== "") {
            newState.set(clientId, order);
          }
        });
        newState.set(
          "",
          (state.get("") ?? []).concat(blockOrder[""])
        );
        return newState;
      }
      case "INSERT_BLOCKS": {
        const { rootClientId = "" } = action;
        const subState = state.get(rootClientId) || [];
        const mappedBlocks = mapBlockOrder(
          action.blocks,
          rootClientId
        );
        const { index = subState.length } = action;
        const newState = new Map(state);
        mappedBlocks.forEach((order, clientId) => {
          newState.set(clientId, order);
        });
        newState.set(
          rootClientId,
          insertAt(
            subState,
            mappedBlocks.get(rootClientId),
            index
          )
        );
        return newState;
      }
      case "MOVE_BLOCKS_TO_POSITION": {
        const {
          fromRootClientId = "",
          toRootClientId = "",
          clientIds
        } = action;
        const { index = state.get(toRootClientId).length } = action;
        if (fromRootClientId === toRootClientId) {
          const subState = state.get(toRootClientId);
          const fromIndex = subState.indexOf(clientIds[0]);
          const newState2 = new Map(state);
          newState2.set(
            toRootClientId,
            moveTo(
              state.get(toRootClientId),
              fromIndex,
              index,
              clientIds.length
            )
          );
          return newState2;
        }
        const newState = new Map(state);
        newState.set(
          fromRootClientId,
          state.get(fromRootClientId)?.filter((id) => !clientIds.includes(id)) ?? []
        );
        newState.set(
          toRootClientId,
          insertAt(state.get(toRootClientId), clientIds, index)
        );
        return newState;
      }
      case "MOVE_BLOCKS_UP": {
        const { clientIds, rootClientId = "" } = action;
        const firstClientId = clientIds[0];
        const subState = state.get(rootClientId);
        if (!subState.length || firstClientId === subState[0]) {
          return state;
        }
        const firstIndex = subState.indexOf(firstClientId);
        const newState = new Map(state);
        newState.set(
          rootClientId,
          moveTo(
            subState,
            firstIndex,
            firstIndex - 1,
            clientIds.length
          )
        );
        return newState;
      }
      case "MOVE_BLOCKS_DOWN": {
        const { clientIds, rootClientId = "" } = action;
        const firstClientId = clientIds[0];
        const lastClientId = clientIds[clientIds.length - 1];
        const subState = state.get(rootClientId);
        if (!subState.length || lastClientId === subState[subState.length - 1]) {
          return state;
        }
        const firstIndex = subState.indexOf(firstClientId);
        const newState = new Map(state);
        newState.set(
          rootClientId,
          moveTo(
            subState,
            firstIndex,
            firstIndex + 1,
            clientIds.length
          )
        );
        return newState;
      }
      case "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const { clientIds } = action;
        if (!action.blocks) {
          return state;
        }
        const mappedBlocks = mapBlockOrder(action.blocks);
        const newState = new Map(state);
        action.replacedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        mappedBlocks.forEach((order, clientId) => {
          if (clientId !== "") {
            newState.set(clientId, order);
          }
        });
        newState.forEach((order, clientId) => {
          const newSubOrder = Object.values(order).reduce(
            (result, subClientId) => {
              if (subClientId === clientIds[0]) {
                return [...result, ...mappedBlocks.get("")];
              }
              if (clientIds.indexOf(subClientId) === -1) {
                result.push(subClientId);
              }
              return result;
            },
            []
          );
          newState.set(clientId, newSubOrder);
        });
        return newState;
      }
      case "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const newState = new Map(state);
        action.removedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        newState.forEach((order, clientId) => {
          const newSubOrder = order?.filter(
            (id) => !action.removedClientIds.includes(id)
          ) ?? [];
          if (newSubOrder.length !== order.length) {
            newState.set(clientId, newSubOrder);
          }
        });
        return newState;
      }
    }
    return state;
  },
  // While technically redundant data as the inverse of `order`, it serves as
  // an optimization for the selectors which derive the ancestry of a block.
  parents(state = /* @__PURE__ */ new Map(), action) {
    switch (action.type) {
      case "RECEIVE_BLOCKS": {
        const newState = new Map(state);
        mapBlockParents(action.blocks).forEach(
          ([key, value]) => {
            newState.set(key, value);
          }
        );
        return newState;
      }
      case "INSERT_BLOCKS": {
        const newState = new Map(state);
        mapBlockParents(
          action.blocks,
          action.rootClientId || ""
        ).forEach(([key, value]) => {
          newState.set(key, value);
        });
        return newState;
      }
      case "MOVE_BLOCKS_TO_POSITION": {
        const newState = new Map(state);
        action.clientIds.forEach((id) => {
          newState.set(id, action.toRootClientId || "");
        });
        return newState;
      }
      case "REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const newState = new Map(state);
        action.replacedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        mapBlockParents(
          action.blocks,
          state.get(action.clientIds[0])
        ).forEach(([key, value]) => {
          newState.set(key, value);
        });
        return newState;
      }
      case "REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN": {
        const newState = new Map(state);
        action.removedClientIds.forEach((clientId) => {
          newState.delete(clientId);
        });
        return newState;
      }
    }
    return state;
  },
  controlledInnerBlocks(state = {}, { type, clientId, hasControlledInnerBlocks }) {
    if (type === "SET_HAS_CONTROLLED_INNER_BLOCKS") {
      return {
        ...state,
        [clientId]: hasControlledInnerBlocks
      };
    }
    return state;
  }
});
function isBlockInterfaceHidden(state = false, action) {
  switch (action.type) {
    case "HIDE_BLOCK_INTERFACE":
      return true;
    case "SHOW_BLOCK_INTERFACE":
      return false;
  }
  return state;
}
function isTyping(state = false, action) {
  switch (action.type) {
    case "START_TYPING":
      return true;
    case "STOP_TYPING":
      return false;
  }
  return state;
}
function isDragging(state = false, action) {
  switch (action.type) {
    case "START_DRAGGING":
      return true;
    case "STOP_DRAGGING":
      return false;
  }
  return state;
}
function draggedBlocks(state = [], action) {
  switch (action.type) {
    case "START_DRAGGING_BLOCKS":
      return action.clientIds;
    case "STOP_DRAGGING_BLOCKS":
      return [];
  }
  return state;
}
function blockVisibility(state = {}, action) {
  if (action.type === "SET_BLOCK_VISIBILITY") {
    return {
      ...state,
      ...action.updates
    };
  }
  return state;
}
function selectionHelper(state = {}, action) {
  switch (action.type) {
    case "CLEAR_SELECTED_BLOCK": {
      if (state.clientId) {
        return {};
      }
      return state;
    }
    case "SELECT_BLOCK":
      if (action.clientId === state.clientId) {
        return state;
      }
      return { clientId: action.clientId };
    case "REPLACE_INNER_BLOCKS":
    case "INSERT_BLOCKS": {
      if (!action.updateSelection || !action.blocks.length) {
        return state;
      }
      return { clientId: action.blocks[0].clientId };
    }
    case "REMOVE_BLOCKS":
      if (!action.clientIds || !action.clientIds.length || action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }
      return {};
    case "REPLACE_BLOCKS": {
      if (action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }
      const blockToSelect = action.blocks[action.indexToSelect] || action.blocks[action.blocks.length - 1];
      if (!blockToSelect) {
        return {};
      }
      if (blockToSelect.clientId === state.clientId) {
        return state;
      }
      return { clientId: blockToSelect.clientId };
    }
  }
  return state;
}
function selection(state = {}, action) {
  switch (action.type) {
    case "SELECTION_CHANGE":
      if (action.clientId) {
        return {
          selectionStart: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.startOffset
          },
          selectionEnd: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.endOffset
          }
        };
      }
      return {
        selectionStart: action.start || state.selectionStart,
        selectionEnd: action.end || state.selectionEnd
      };
    case "RESET_SELECTION":
      const { selectionStart: selectionStart2, selectionEnd: selectionEnd2 } = action;
      return {
        selectionStart: selectionStart2,
        selectionEnd: selectionEnd2
      };
    case "MULTI_SELECT":
      const { start, end } = action;
      if (start === state.selectionStart?.clientId && end === state.selectionEnd?.clientId) {
        return state;
      }
      return {
        selectionStart: { clientId: start },
        selectionEnd: { clientId: end }
      };
    case "RESET_BLOCKS":
      const startClientId = state?.selectionStart?.clientId;
      const endClientId = state?.selectionEnd?.clientId;
      if (!startClientId && !endClientId) {
        return state;
      }
      if (!action.blocks.some(
        (block) => block.clientId === startClientId
      )) {
        return {
          selectionStart: {},
          selectionEnd: {}
        };
      }
      if (!action.blocks.some(
        (block) => block.clientId === endClientId
      )) {
        return {
          ...state,
          selectionEnd: state.selectionStart
        };
      }
  }
  const selectionStart = selectionHelper(state.selectionStart, action);
  const selectionEnd = selectionHelper(state.selectionEnd, action);
  if (selectionStart === state.selectionStart && selectionEnd === state.selectionEnd) {
    return state;
  }
  return {
    selectionStart,
    selectionEnd
  };
}
function isMultiSelecting(state = false, action) {
  switch (action.type) {
    case "START_MULTI_SELECT":
      return true;
    case "STOP_MULTI_SELECT":
      return false;
  }
  return state;
}
function isSelectionEnabled(state = true, action) {
  switch (action.type) {
    case "TOGGLE_SELECTION":
      return action.isSelectionEnabled;
  }
  return state;
}
function removalPromptData(state = false, action) {
  switch (action.type) {
    case "DISPLAY_BLOCK_REMOVAL_PROMPT":
      const { clientIds, selectPrevious, message } = action;
      return {
        clientIds,
        selectPrevious,
        message
      };
    case "CLEAR_BLOCK_REMOVAL_PROMPT":
      return false;
  }
  return state;
}
function blockRemovalRules(state = false, action) {
  switch (action.type) {
    case "SET_BLOCK_REMOVAL_RULES":
      return action.rules;
  }
  return state;
}
function initialPosition(state = null, action) {
  if (action.type === "REPLACE_BLOCKS" && action.initialPosition !== void 0) {
    return action.initialPosition;
  } else if ([
    "MULTI_SELECT",
    "SELECT_BLOCK",
    "RESET_SELECTION",
    "INSERT_BLOCKS",
    "REPLACE_INNER_BLOCKS"
  ].includes(action.type)) {
    return action.initialPosition;
  }
  return state;
}
function blocksMode(state = {}, action) {
  if (action.type === "TOGGLE_BLOCK_MODE") {
    const { clientId } = action;
    return {
      ...state,
      [clientId]: state[clientId] && state[clientId] === "html" ? "visual" : "html"
    };
  }
  return state;
}
function insertionCue(state = null, action) {
  switch (action.type) {
    case "SHOW_INSERTION_POINT": {
      const {
        rootClientId,
        index,
        __unstableWithInserter,
        operation,
        nearestSide
      } = action;
      const nextState = {
        rootClientId,
        index,
        __unstableWithInserter,
        operation,
        nearestSide
      };
      return es6_default()(state, nextState) ? state : nextState;
    }
    case "HIDE_INSERTION_POINT":
      return null;
  }
  return state;
}
function template(state = { isValid: true }, action) {
  switch (action.type) {
    case "SET_TEMPLATE_VALIDITY":
      return {
        ...state,
        isValid: action.isValid
      };
  }
  return state;
}
function settings(state = SETTINGS_DEFAULTS, action) {
  switch (action.type) {
    case "UPDATE_SETTINGS": {
      const updatedSettings = action.reset ? {
        ...SETTINGS_DEFAULTS,
        ...action.settings
      } : {
        ...state,
        ...action.settings
      };
      Object.defineProperty(updatedSettings, "__unstableIsPreviewMode", {
        get() {
          external_wp_deprecated_default()("__unstableIsPreviewMode", {
            since: "6.8",
            alternative: "isPreviewMode"
          });
          return this.isPreviewMode;
        }
      });
      return updatedSettings;
    }
  }
  return state;
}
function preferences(state = PREFERENCES_DEFAULTS, action) {
  switch (action.type) {
    case "INSERT_BLOCKS":
    case "REPLACE_BLOCKS": {
      const nextInsertUsage = action.blocks.reduce(
        (prevUsage, block) => {
          const { attributes, name: blockName } = block;
          let id = blockName;
          const match = (0,external_wp_data_namespaceObject.select)(external_wp_blocks_namespaceObject.store).getActiveBlockVariation(
            blockName,
            attributes
          );
          if (match?.name) {
            id += "/" + match.name;
          }
          if (blockName === "core/block") {
            id += "/" + attributes.ref;
          }
          return {
            ...prevUsage,
            [id]: {
              time: action.time,
              count: prevUsage[id] ? prevUsage[id].count + 1 : 1
            }
          };
        },
        state.insertUsage
      );
      return {
        ...state,
        insertUsage: nextInsertUsage
      };
    }
  }
  return state;
}
const blockListSettings = (state = {}, action) => {
  switch (action.type) {
    // Even if the replaced blocks have the same client ID, our logic
    // should correct the state.
    case "REPLACE_BLOCKS":
    case "REMOVE_BLOCKS": {
      return Object.fromEntries(
        Object.entries(state).filter(
          ([id]) => !action.clientIds.includes(id)
        )
      );
    }
    case "UPDATE_BLOCK_LIST_SETTINGS": {
      const updates = typeof action.clientId === "string" ? { [action.clientId]: action.settings } : action.clientId;
      for (const clientId in updates) {
        if (!updates[clientId]) {
          if (!state[clientId]) {
            delete updates[clientId];
          }
        } else if (es6_default()(state[clientId], updates[clientId])) {
          delete updates[clientId];
        }
      }
      if (Object.keys(updates).length === 0) {
        return state;
      }
      const merged = { ...state, ...updates };
      for (const clientId in updates) {
        if (!updates[clientId]) {
          delete merged[clientId];
        }
      }
      return merged;
    }
  }
  return state;
};
function lastBlockAttributesChange(state = null, action) {
  switch (action.type) {
    case "UPDATE_BLOCK":
      if (!action.updates.attributes) {
        break;
      }
      return { [action.clientId]: action.updates.attributes };
    case "UPDATE_BLOCK_ATTRIBUTES":
      return action.clientIds.reduce(
        (accumulator, id) => ({
          ...accumulator,
          [id]: !!action.options?.uniqueByBlock ? action.attributes[id] : action.attributes
        }),
        {}
      );
  }
  return state;
}
function highlightedBlock(state, action) {
  switch (action.type) {
    case "TOGGLE_BLOCK_HIGHLIGHT":
      const { clientId, isHighlighted } = action;
      if (isHighlighted) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }
      return state;
    case "SELECT_BLOCK":
      if (action.clientId !== state) {
        return null;
      }
  }
  return state;
}
function hasBlockSpotlight(state, action) {
  switch (action.type) {
    case "TOGGLE_BLOCK_SPOTLIGHT":
      const { clientId, hasBlockSpotlight: _hasBlockSpotlight } = action;
      if (_hasBlockSpotlight) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }
      return state;
    case "SELECT_BLOCK":
      if (action.clientId !== state) {
        return null;
      }
      return state;
    case "SELECTION_CHANGE":
      if (action.start?.clientId !== state || action.end?.clientId !== state) {
        return null;
      }
      return state;
    case "CLEAR_SELECTED_BLOCK":
      return null;
  }
  return state;
}
function expandedBlock(state = null, action) {
  switch (action.type) {
    case "SET_BLOCK_EXPANDED_IN_LIST_VIEW":
      return action.clientId;
    case "SELECT_BLOCK":
      if (action.clientId !== state) {
        return null;
      }
  }
  return state;
}
function lastBlockInserted(state = {}, action) {
  switch (action.type) {
    case "INSERT_BLOCKS":
    case "REPLACE_BLOCKS":
      if (!action.blocks.length) {
        return state;
      }
      const clientIds = action.blocks.map((block) => {
        return block.clientId;
      });
      const source = action.meta?.source;
      return { clientIds, source };
    case "RESET_BLOCKS":
      return {};
  }
  return state;
}
function temporarilyEditingAsBlocks(state = "", action) {
  if (action.type === "SET_TEMPORARILY_EDITING_AS_BLOCKS") {
    return action.temporarilyEditingAsBlocks;
  }
  return state;
}
function temporarilyEditingFocusModeRevert(state = "", action) {
  if (action.type === "SET_TEMPORARILY_EDITING_AS_BLOCKS") {
    return action.focusModeToRevert;
  }
  return state;
}
function blockEditingModes(state = /* @__PURE__ */ new Map(), action) {
  switch (action.type) {
    case "SET_BLOCK_EDITING_MODE":
      if (state.get(action.clientId) === action.mode) {
        return state;
      }
      return new Map(state).set(action.clientId, action.mode);
    case "UNSET_BLOCK_EDITING_MODE": {
      if (!state.has(action.clientId)) {
        return state;
      }
      const newState = new Map(state);
      newState.delete(action.clientId);
      return newState;
    }
    case "RESET_BLOCKS": {
      return state.has("") ? (/* @__PURE__ */ new Map()).set("", state.get("")) : state;
    }
  }
  return state;
}
function openedBlockSettingsMenu(state = null, action) {
  if ("SET_OPENED_BLOCK_SETTINGS_MENU" === action.type) {
    return action?.clientId ?? null;
  }
  return state;
}
function styleOverrides(state = /* @__PURE__ */ new Map(), action) {
  switch (action.type) {
    case "SET_STYLE_OVERRIDE":
      return new Map(state).set(action.id, action.style);
    case "DELETE_STYLE_OVERRIDE": {
      const newState = new Map(state);
      newState.delete(action.id);
      return newState;
    }
  }
  return state;
}
function registeredInserterMediaCategories(state = [], action) {
  switch (action.type) {
    case "REGISTER_INSERTER_MEDIA_CATEGORY":
      return [...state, action.category];
  }
  return state;
}
function lastFocus(state = false, action) {
  switch (action.type) {
    case "LAST_FOCUS":
      return action.lastFocus;
  }
  return state;
}
function zoomLevel(state = 100, action) {
  switch (action.type) {
    case "SET_ZOOM_LEVEL":
      return action.zoom;
    case "RESET_ZOOM_LEVEL":
      return 100;
  }
  return state;
}
function insertionPoint(state = null, action) {
  switch (action.type) {
    case "SET_INSERTION_POINT":
      return action.value;
    case "SELECT_BLOCK":
      return null;
  }
  return state;
}
const combinedReducers = (0,external_wp_data_namespaceObject.combineReducers)({
  blocks,
  isDragging,
  isTyping,
  isBlockInterfaceHidden,
  draggedBlocks,
  selection,
  isMultiSelecting,
  isSelectionEnabled,
  initialPosition,
  blocksMode,
  blockListSettings,
  insertionPoint,
  insertionCue,
  template,
  settings,
  preferences,
  lastBlockAttributesChange,
  lastFocus,
  expandedBlock,
  highlightedBlock,
  lastBlockInserted,
  temporarilyEditingAsBlocks,
  temporarilyEditingFocusModeRevert,
  blockVisibility,
  blockEditingModes,
  styleOverrides,
  removalPromptData,
  blockRemovalRules,
  openedBlockSettingsMenu,
  registeredInserterMediaCategories,
  zoomLevel,
  hasBlockSpotlight
});
function getBlockTreeBlock(state, clientId) {
  if (clientId === "") {
    const rootBlock = state.blocks.tree.get(clientId);
    if (!rootBlock) {
      return;
    }
    return {
      clientId: "",
      ...rootBlock
    };
  }
  if (!state.blocks.controlledInnerBlocks[clientId]) {
    return state.blocks.tree.get(clientId);
  }
  const controlledTree = state.blocks.tree.get(`controlled||${clientId}`);
  const regularTree = state.blocks.tree.get(clientId);
  return {
    ...regularTree,
    innerBlocks: controlledTree?.innerBlocks
  };
}
function traverseBlockTree(state, clientId, callback) {
  const tree = getBlockTreeBlock(state, clientId);
  if (!tree) {
    return;
  }
  callback(tree);
  if (!tree?.innerBlocks?.length) {
    return;
  }
  for (const innerBlock of tree?.innerBlocks) {
    traverseBlockTree(state, innerBlock.clientId, callback);
  }
}
function findParentInClientIdsList(state, clientId, clientIds) {
  if (!clientIds.length) {
    return;
  }
  let parent = state.blocks.parents.get(clientId);
  while (parent !== void 0) {
    if (clientIds.includes(parent)) {
      return parent;
    }
    parent = state.blocks.parents.get(parent);
  }
}
function hasBindings(block) {
  return block?.attributes?.metadata?.bindings && Object.keys(block?.attributes?.metadata?.bindings).length;
}
function getDerivedBlockEditingModesForTree(state, treeClientId = "") {
  const isZoomedOut = state?.zoomLevel < 100 || state?.zoomLevel === "auto-scaled";
  const derivedBlockEditingModes = /* @__PURE__ */ new Map();
  const sectionRootClientId = state.settings?.[sectionRootClientIdKey];
  const sectionClientIds = state.blocks.order.get(sectionRootClientId);
  const hasDisabledBlocks = Array.from(state.blockEditingModes).some(
    ([, mode]) => mode === "disabled"
  );
  const templatePartClientIds = [];
  const syncedPatternClientIds = [];
  Object.keys(state.blocks.controlledInnerBlocks).forEach((clientId) => {
    const block = state.blocks.byClientId?.get(clientId);
    if (block?.name === "core/template-part") {
      templatePartClientIds.push(clientId);
    }
    if (block?.name === "core/block") {
      syncedPatternClientIds.push(clientId);
    }
  });
  const contentOnlyTemplateLockedClientIds = Object.keys(
    state.blockListSettings
  ).filter(
    (clientId) => state.blockListSettings[clientId]?.templateLock === "contentOnly"
  );
  const unsyncedPatternClientIds = !!window?.__experimentalContentOnlyPatternInsertion ? Array.from(state.blocks.attributes.keys()).filter(
    (clientId) => state.blocks.attributes.get(clientId)?.metadata?.patternName
  ) : [];
  const contentOnlyParents = [
    ...contentOnlyTemplateLockedClientIds,
    ...unsyncedPatternClientIds,
    ...window?.__experimentalContentOnlyPatternInsertion ? templatePartClientIds : []
  ];
  traverseBlockTree(state, treeClientId, (block) => {
    const { clientId, name: blockName } = block;
    if (state.blockEditingModes.has(clientId)) {
      return;
    }
    if (hasDisabledBlocks) {
      let ancestorBlockEditingMode;
      let parent = state.blocks.parents.get(clientId);
      while (parent !== void 0) {
        if (state.blockEditingModes.has(parent)) {
          ancestorBlockEditingMode = state.blockEditingModes.get(parent);
        }
        if (ancestorBlockEditingMode) {
          break;
        }
        parent = state.blocks.parents.get(parent);
      }
      if (ancestorBlockEditingMode === "disabled") {
        derivedBlockEditingModes.set(clientId, "disabled");
        return;
      }
    }
    if (isZoomedOut) {
      if (clientId === sectionRootClientId) {
        derivedBlockEditingModes.set(clientId, "contentOnly");
        return;
      }
      if (!sectionClientIds?.length) {
        derivedBlockEditingModes.set(clientId, "disabled");
        return;
      }
      if (sectionClientIds.includes(clientId)) {
        derivedBlockEditingModes.set(clientId, "contentOnly");
        return;
      }
      derivedBlockEditingModes.set(clientId, "disabled");
      return;
    }
    if (syncedPatternClientIds.length) {
      if (syncedPatternClientIds.includes(clientId)) {
        if (findParentInClientIdsList(
          state,
          clientId,
          syncedPatternClientIds
        )) {
          derivedBlockEditingModes.set(clientId, "disabled");
          return;
        }
        return;
      }
      const parentPatternClientId = findParentInClientIdsList(
        state,
        clientId,
        syncedPatternClientIds
      );
      if (parentPatternClientId) {
        if (findParentInClientIdsList(
          state,
          parentPatternClientId,
          syncedPatternClientIds
        )) {
          derivedBlockEditingModes.set(clientId, "disabled");
          return;
        }
        if (hasBindings(block)) {
          derivedBlockEditingModes.set(clientId, "contentOnly");
          return;
        }
        derivedBlockEditingModes.set(clientId, "disabled");
      }
    }
    if (contentOnlyParents.length) {
      const hasContentOnlyParent = !!findParentInClientIdsList(
        state,
        clientId,
        contentOnlyParents
      );
      if (hasContentOnlyParent) {
        if (isContentBlock(blockName)) {
          derivedBlockEditingModes.set(clientId, "contentOnly");
        } else {
          derivedBlockEditingModes.set(clientId, "disabled");
        }
      }
    }
  });
  return derivedBlockEditingModes;
}
function getDerivedBlockEditingModesUpdates({
  prevState,
  nextState,
  addedBlocks,
  removedClientIds
}) {
  const prevDerivedBlockEditingModes = prevState.derivedBlockEditingModes;
  let nextDerivedBlockEditingModes;
  removedClientIds?.forEach((clientId) => {
    traverseBlockTree(prevState, clientId, (block) => {
      if (prevDerivedBlockEditingModes.has(block.clientId)) {
        if (!nextDerivedBlockEditingModes) {
          nextDerivedBlockEditingModes = new Map(
            prevDerivedBlockEditingModes
          );
        }
        nextDerivedBlockEditingModes.delete(block.clientId);
      }
    });
  });
  addedBlocks?.forEach((addedBlock) => {
    const updates = getDerivedBlockEditingModesForTree(
      nextState,
      addedBlock.clientId
    );
    if (updates.size) {
      if (!nextDerivedBlockEditingModes) {
        nextDerivedBlockEditingModes = new Map([
          ...prevDerivedBlockEditingModes?.size ? prevDerivedBlockEditingModes : [],
          ...updates
        ]);
      } else {
        nextDerivedBlockEditingModes = new Map([
          ...nextDerivedBlockEditingModes?.size ? nextDerivedBlockEditingModes : [],
          ...updates
        ]);
      }
    }
  });
  return nextDerivedBlockEditingModes;
}
function withDerivedBlockEditingModes(reducer) {
  return (state, action) => {
    const nextState = reducer(state, action);
    if (action.type !== "SET_EDITOR_MODE" && nextState === state) {
      return state;
    }
    switch (action.type) {
      case "REMOVE_BLOCKS": {
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          removedClientIds: action.clientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "RECEIVE_BLOCKS":
      case "INSERT_BLOCKS": {
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks: action.blocks
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "UPDATE_BLOCK_ATTRIBUTES": {
        const addedBlocks = [];
        const removedClientIds = [];
        for (const clientId of action?.clientIds) {
          const attributes = action.options?.uniqueByBlock ? action.attributes[clientId] : action.attributes;
          if (!attributes) {
            break;
          }
          if (
            // patternName is switching from falsy to truthy, indicating
            // this block is becoming an unsynced pattern.
            attributes.metadata?.patternName && !state.blocks.attributes.get(clientId)?.metadata?.patternName
          ) {
            addedBlocks.push(
              nextState.blocks.tree.get(clientId)
            );
          } else if (
            // patternName is switching from truthy to falsy, this block is becoming
            // a regular block but was an unsynced pattern.
            // Check that `metadata` is part of the included attributes, as
            // `updateBlockAttributes` merges attributes, if it isn't present
            // the previous `metadata` would be retained.
            attributes.metadata && !attributes.metadata?.patternName && state.blocks.attributes.get(clientId)?.metadata?.patternName
          ) {
            removedClientIds.push(clientId);
          }
        }
        if (!addedBlocks?.length && !removedClientIds?.length) {
          break;
        }
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks,
          removedClientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "UPDATE_BLOCK_LIST_SETTINGS": {
        const addedBlocks = [];
        const removedClientIds = [];
        const updates = typeof action.clientId === "string" ? { [action.clientId]: action.settings } : action.clientId;
        for (const clientId in updates) {
          const isNewContentOnlyBlock = state.blockListSettings[clientId]?.templateLock !== "contentOnly" && nextState.blockListSettings[clientId]?.templateLock === "contentOnly";
          const wasContentOnlyBlock = state.blockListSettings[clientId]?.templateLock === "contentOnly" && nextState.blockListSettings[clientId]?.templateLock !== "contentOnly";
          if (isNewContentOnlyBlock) {
            addedBlocks.push(
              nextState.blocks.tree.get(clientId)
            );
          } else if (wasContentOnlyBlock) {
            removedClientIds.push(clientId);
          }
        }
        if (!addedBlocks.length && !removedClientIds.length) {
          break;
        }
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks,
          removedClientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "SET_BLOCK_EDITING_MODE":
      case "UNSET_BLOCK_EDITING_MODE":
      case "SET_HAS_CONTROLLED_INNER_BLOCKS": {
        const updatedBlock = getBlockTreeBlock(
          nextState,
          action.clientId
        );
        if (!updatedBlock) {
          break;
        }
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          removedClientIds: [action.clientId],
          addedBlocks: [updatedBlock]
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "REPLACE_BLOCKS": {
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks: action.blocks,
          removedClientIds: action.clientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "REPLACE_INNER_BLOCKS": {
        const removedClientIds = state.blocks.order.get(
          action.rootClientId
        );
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks: action.blocks,
          removedClientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "MOVE_BLOCKS_TO_POSITION": {
        const addedBlocks = action.clientIds.map((clientId) => {
          return nextState.blocks.byClientId.get(clientId);
        });
        const nextDerivedBlockEditingModes = getDerivedBlockEditingModesUpdates({
          prevState: state,
          nextState,
          addedBlocks,
          removedClientIds: action.clientIds
        });
        if (nextDerivedBlockEditingModes) {
          return {
            ...nextState,
            derivedBlockEditingModes: nextDerivedBlockEditingModes ?? state.derivedBlockEditingModes
          };
        }
        break;
      }
      case "UPDATE_SETTINGS": {
        if (state?.settings?.[sectionRootClientIdKey] !== nextState?.settings?.[sectionRootClientIdKey]) {
          return {
            ...nextState,
            derivedBlockEditingModes: getDerivedBlockEditingModesForTree(nextState)
          };
        }
        break;
      }
      case "RESET_BLOCKS":
      case "SET_EDITOR_MODE":
      case "RESET_ZOOM_LEVEL":
      case "SET_ZOOM_LEVEL": {
        return {
          ...nextState,
          derivedBlockEditingModes: getDerivedBlockEditingModesForTree(nextState)
        };
      }
    }
    nextState.derivedBlockEditingModes = state?.derivedBlockEditingModes ?? /* @__PURE__ */ new Map();
    return nextState;
  };
}
function withAutomaticChangeReset(reducer) {
  return (state, action) => {
    const nextState = reducer(state, action);
    if (!state) {
      return nextState;
    }
    nextState.automaticChangeStatus = state.automaticChangeStatus;
    if (action.type === "MARK_AUTOMATIC_CHANGE") {
      return {
        ...nextState,
        automaticChangeStatus: "pending"
      };
    }
    if (action.type === "MARK_AUTOMATIC_CHANGE_FINAL" && state.automaticChangeStatus === "pending") {
      return {
        ...nextState,
        automaticChangeStatus: "final"
      };
    }
    if (nextState.blocks === state.blocks && nextState.selection === state.selection) {
      return nextState;
    }
    if (nextState.automaticChangeStatus !== "final" && nextState.selection !== state.selection) {
      return nextState;
    }
    return {
      ...nextState,
      automaticChangeStatus: void 0
    };
  };
}
var reducer_default = (0,external_wp_compose_namespaceObject.pipe)(
  withDerivedBlockEditingModes,
  withAutomaticChangeReset
)(combinedReducers);


;// external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// ./node_modules/@wordpress/icons/build-module/library/symbol.js


var symbol_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z" }) });


;// external ["wp","richText"]
const external_wp_richText_namespaceObject = window["wp"]["richText"];
;// external ["wp","blockSerializationDefaultParser"]
const external_wp_blockSerializationDefaultParser_namespaceObject = window["wp"]["blockSerializationDefaultParser"];
;// ./node_modules/@wordpress/block-editor/build-module/store/constants.js
const STORE_NAME = "core/block-editor";


;// ./node_modules/@wordpress/block-editor/build-module/utils/object.js
function setImmutably(object, path, value) {
  path = Array.isArray(path) ? [...path] : [path];
  object = Array.isArray(object) ? [...object] : { ...object };
  const leaf = path.pop();
  let prev = object;
  for (const key of path) {
    const lvl = prev[key];
    prev = prev[key] = Array.isArray(lvl) ? [...lvl] : { ...lvl };
  }
  prev[leaf] = value;
  return object;
}
const getValueFromObjectPath = (object, path, defaultValue) => {
  const arrayPath = Array.isArray(path) ? path : path.split(".");
  let value = object;
  arrayPath.forEach((fieldName) => {
    value = value?.[fieldName];
  });
  return value ?? defaultValue;
};
function uniqByProperty(array, property) {
  const seen = /* @__PURE__ */ new Set();
  return array.filter((item) => {
    const value = item[property];
    return seen.has(value) ? false : seen.add(value);
  });
}


;// ./node_modules/@wordpress/block-editor/build-module/store/get-block-settings.js




const blockedPaths = [
  "color",
  "border",
  "dimensions",
  "typography",
  "spacing"
];
const deprecatedFlags = {
  "color.palette": (settings) => settings.colors,
  "color.gradients": (settings) => settings.gradients,
  "color.custom": (settings) => settings.disableCustomColors === void 0 ? void 0 : !settings.disableCustomColors,
  "color.customGradient": (settings) => settings.disableCustomGradients === void 0 ? void 0 : !settings.disableCustomGradients,
  "typography.fontSizes": (settings) => settings.fontSizes,
  "typography.customFontSize": (settings) => settings.disableCustomFontSizes === void 0 ? void 0 : !settings.disableCustomFontSizes,
  "typography.lineHeight": (settings) => settings.enableCustomLineHeight,
  "spacing.units": (settings) => {
    if (settings.enableCustomUnits === void 0) {
      return;
    }
    if (settings.enableCustomUnits === true) {
      return ["px", "em", "rem", "vh", "vw", "%"];
    }
    return settings.enableCustomUnits;
  },
  "spacing.padding": (settings) => settings.enableCustomSpacing
};
const prefixedFlags = {
  /*
   * These were only available in the plugin
   * and can be removed when the minimum WordPress version
   * for the plugin is 5.9.
   */
  "border.customColor": "border.color",
  "border.customStyle": "border.style",
  "border.customWidth": "border.width",
  "typography.customFontStyle": "typography.fontStyle",
  "typography.customFontWeight": "typography.fontWeight",
  "typography.customLetterSpacing": "typography.letterSpacing",
  "typography.customTextDecorations": "typography.textDecoration",
  "typography.customTextTransforms": "typography.textTransform",
  /*
   * These were part of WordPress 5.8 and we need to keep them.
   */
  "border.customRadius": "border.radius",
  "spacing.customMargin": "spacing.margin",
  "spacing.customPadding": "spacing.padding",
  "typography.customLineHeight": "typography.lineHeight"
};
const removeCustomPrefixes = (path) => {
  return prefixedFlags[path] || path;
};
function getBlockSettings(state, clientId, ...paths) {
  const blockName = getBlockName(state, clientId);
  const candidates = [];
  if (clientId) {
    let id = clientId;
    do {
      const name = getBlockName(state, id);
      if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "__experimentalSettings", false)) {
        candidates.push(id);
      }
    } while (id = state.blocks.parents.get(id));
  }
  return paths.map((path) => {
    if (blockedPaths.includes(path)) {
      console.warn(
        "Top level useSetting paths are disabled. Please use a subpath to query the information needed."
      );
      return void 0;
    }
    let result = (0,external_wp_hooks_namespaceObject.applyFilters)(
      "blockEditor.useSetting.before",
      void 0,
      path,
      clientId,
      blockName
    );
    if (void 0 !== result) {
      return result;
    }
    const normalizedPath = removeCustomPrefixes(path);
    for (const candidateClientId of candidates) {
      const candidateAtts = getBlockAttributes(
        state,
        candidateClientId
      );
      result = getValueFromObjectPath(
        candidateAtts.settings?.blocks?.[blockName],
        normalizedPath
      ) ?? getValueFromObjectPath(
        candidateAtts.settings,
        normalizedPath
      );
      if (result !== void 0) {
        break;
      }
    }
    const settings = getSettings(state);
    if (result === void 0 && blockName) {
      result = getValueFromObjectPath(
        settings.__experimentalFeatures?.blocks?.[blockName],
        normalizedPath
      );
    }
    if (result === void 0) {
      result = getValueFromObjectPath(
        settings.__experimentalFeatures,
        normalizedPath
      );
    }
    if (result !== void 0) {
      if (external_wp_blocks_namespaceObject.__EXPERIMENTAL_PATHS_WITH_OVERRIDE[normalizedPath]) {
        return result.custom ?? result.theme ?? result.default;
      }
      return result;
    }
    const deprecatedSettingsValue = deprecatedFlags[normalizedPath]?.(settings);
    if (deprecatedSettingsValue !== void 0) {
      return deprecatedSettingsValue;
    }
    return normalizedPath === "typography.dropCap" ? true : void 0;
  });
}


;// ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js







const { isContentBlock: private_selectors_isContentBlock } = unlock(external_wp_blocks_namespaceObject.privateApis);

function private_selectors_isBlockInterfaceHidden(state) {
  return state.isBlockInterfaceHidden;
}
function getLastInsertedBlocksClientIds(state) {
  return state?.lastBlockInserted?.clientIds;
}
function getBlockWithoutAttributes(state, clientId) {
  return state.blocks.byClientId.get(clientId);
}
const isBlockSubtreeDisabled = (state, clientId) => {
  const isChildSubtreeDisabled = (childClientId) => {
    return getBlockEditingMode(state, childClientId) === "disabled" && getBlockOrder(state, childClientId).every(
      isChildSubtreeDisabled
    );
  };
  return getBlockOrder(state, clientId).every(isChildSubtreeDisabled);
};
function isContainerInsertableToInContentOnlyMode(state, blockName, rootClientId) {
  const isBlockContentBlock = private_selectors_isContentBlock(blockName);
  const rootBlockName = getBlockName(state, rootClientId);
  const isContainerContentBlock = private_selectors_isContentBlock(rootBlockName);
  const isRootBlockMain = getSectionRootClientId(state) === rootClientId;
  return isRootBlockMain || isContainerContentBlock && isBlockContentBlock;
}
function getEnabledClientIdsTreeUnmemoized(state, rootClientId) {
  const blockOrder = getBlockOrder(state, rootClientId);
  const result = [];
  for (const clientId of blockOrder) {
    const innerBlocks = getEnabledClientIdsTreeUnmemoized(
      state,
      clientId
    );
    if (getBlockEditingMode(state, clientId) !== "disabled") {
      result.push({ clientId, innerBlocks });
    } else {
      result.push(...innerBlocks);
    }
  }
  return result;
}
const getEnabledClientIdsTree = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  () => (0,external_wp_data_namespaceObject.createSelector)(getEnabledClientIdsTreeUnmemoized, (state) => [
    state.blocks.order,
    state.derivedBlockEditingModes,
    state.blockEditingModes
  ])
);
const getEnabledBlockParents = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId, ascending = false) => {
    return getBlockParents(state, clientId, ascending).filter(
      (parent) => getBlockEditingMode(state, parent) !== "disabled"
    );
  },
  (state) => [
    state.blocks.parents,
    state.blockEditingModes,
    state.settings.templateLock,
    state.blockListSettings
  ]
);
function getRemovalPromptData(state) {
  return state.removalPromptData;
}
function getBlockRemovalRules(state) {
  return state.blockRemovalRules;
}
function getOpenedBlockSettingsMenu(state) {
  return state.openedBlockSettingsMenu;
}
const getStyleOverrides = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    const clientIds = getClientIdsWithDescendants(state);
    const clientIdMap = clientIds.reduce((acc, clientId, index) => {
      acc[clientId] = index;
      return acc;
    }, {});
    return [...state.styleOverrides].sort((overrideA, overrideB) => {
      const [, { clientId: clientIdA }] = overrideA;
      const [, { clientId: clientIdB }] = overrideB;
      const aIndex = clientIdMap[clientIdA] ?? -1;
      const bIndex = clientIdMap[clientIdB] ?? -1;
      return aIndex - bIndex;
    });
  },
  (state) => [state.blocks.order, state.styleOverrides]
);
function getRegisteredInserterMediaCategories(state) {
  return state.registeredInserterMediaCategories;
}
const getInserterMediaCategories = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    const {
      settings: {
        inserterMediaCategories,
        allowedMimeTypes,
        enableOpenverseMediaCategory
      },
      registeredInserterMediaCategories
    } = state;
    if (!inserterMediaCategories && !registeredInserterMediaCategories.length || !allowedMimeTypes) {
      return;
    }
    const coreInserterMediaCategoriesNames = inserterMediaCategories?.map(({ name }) => name) || [];
    const mergedCategories = [
      ...inserterMediaCategories || [],
      ...(registeredInserterMediaCategories || []).filter(
        ({ name }) => !coreInserterMediaCategoriesNames.includes(name)
      )
    ];
    return mergedCategories.filter((category) => {
      if (!enableOpenverseMediaCategory && category.name === "openverse") {
        return false;
      }
      return Object.values(allowedMimeTypes).some(
        (mimeType) => mimeType.startsWith(`${category.mediaType}/`)
      );
    });
  },
  (state) => [
    state.settings.inserterMediaCategories,
    state.settings.allowedMimeTypes,
    state.settings.enableOpenverseMediaCategory,
    state.registeredInserterMediaCategories
  ]
);
const hasAllowedPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, rootClientId = null) => {
      const { getAllPatterns: getAllPatterns2 } = unlock(select(STORE_NAME));
      const patterns = getAllPatterns2();
      const { allowedBlockTypes } = getSettings(state);
      return patterns.some((pattern) => {
        const { inserter = true } = pattern;
        if (!inserter) {
          return false;
        }
        const grammar = getGrammar(pattern);
        return checkAllowListRecursive(grammar, allowedBlockTypes) && grammar.every(
          ({ name: blockName }) => canInsertBlockType(state, blockName, rootClientId)
        );
      });
    },
    (state, rootClientId) => [
      ...getAllPatternsDependants(select)(state),
      ...getInsertBlockTypeDependants(select)(state, rootClientId)
    ]
  )
);
const getPatternBySlug = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, patternName) => {
      if (patternName?.startsWith("core/block/")) {
        const _id = parseInt(
          patternName.slice("core/block/".length),
          10
        );
        const block = unlock(select(STORE_NAME)).getReusableBlocks().find(({ id }) => id === _id);
        if (!block) {
          return null;
        }
        return mapUserPattern(
          block,
          state.settings.__experimentalUserPatternCategories
        );
      }
      return [
        // This setting is left for back compat.
        ...state.settings.__experimentalBlockPatterns ?? [],
        ...state.settings[selectBlockPatternsKey]?.(select) ?? []
      ].find(({ name }) => name === patternName);
    },
    (state, patternName) => patternName?.startsWith("core/block/") ? [
      unlock(select(STORE_NAME)).getReusableBlocks(),
      state.settings.__experimentalReusableBlocks
    ] : [
      state.settings.__experimentalBlockPatterns,
      state.settings[selectBlockPatternsKey]?.(select)
    ]
  )
);
const getAllPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)((state) => {
    return [
      ...unlock(select(STORE_NAME)).getReusableBlocks().map(
        (userPattern) => mapUserPattern(
          userPattern,
          state.settings.__experimentalUserPatternCategories
        )
      ),
      // This setting is left for back compat.
      ...state.settings.__experimentalBlockPatterns ?? [],
      ...state.settings[selectBlockPatternsKey]?.(select) ?? []
    ].filter(
      (x, index, arr) => index === arr.findIndex((y) => x.name === y.name)
    );
  }, getAllPatternsDependants(select))
);
const EMPTY_ARRAY = [];
const getReusableBlocks = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (state) => {
    const reusableBlocksSelect = state.settings[reusableBlocksSelectKey];
    return (reusableBlocksSelect ? reusableBlocksSelect(select) : state.settings.__experimentalReusableBlocks) ?? EMPTY_ARRAY;
  }
);
function getLastFocus(state) {
  return state.lastFocus;
}
function private_selectors_isDragging(state) {
  return state.isDragging;
}
function getExpandedBlock(state) {
  return state.expandedBlock;
}
const getContentLockingParent = (state, clientId) => {
  let current = clientId;
  let result;
  while (!result && (current = state.blocks.parents.get(current))) {
    if (getTemplateLock(state, current) === "contentOnly") {
      result = current;
    }
  }
  return result;
};
const getParentSectionBlock = (state, clientId) => {
  let current = clientId;
  let result;
  while (!result && (current = state.blocks.parents.get(current))) {
    if (isSectionBlock(state, current)) {
      result = current;
    }
  }
  return result;
};
function isSectionBlock(state, clientId) {
  const blockName = getBlockName(state, clientId);
  if (blockName === "core/block" || getTemplateLock(state, clientId) === "contentOnly") {
    return true;
  }
  const attributes = getBlockAttributes(state, clientId);
  const isTemplatePart = blockName === "core/template-part";
  if ((attributes?.metadata?.patternName || isTemplatePart) && !!window?.__experimentalContentOnlyPatternInsertion) {
    return true;
  }
  return false;
}
function getTemporarilyEditingAsBlocks(state) {
  return state.temporarilyEditingAsBlocks;
}
function getTemporarilyEditingFocusModeToRevert(state) {
  return state.temporarilyEditingFocusModeRevert;
}
const getBlockStyles = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientIds) => clientIds.reduce((styles, clientId) => {
    styles[clientId] = state.blocks.attributes.get(clientId)?.style;
    return styles;
  }, {}),
  (state, clientIds) => [
    ...clientIds.map(
      (clientId) => state.blocks.attributes.get(clientId)?.style
    )
  ]
);
function getSectionRootClientId(state) {
  return state.settings?.[sectionRootClientIdKey];
}
function isZoomOut(state) {
  return state.zoomLevel === "auto-scaled" || state.zoomLevel < 100;
}
function getZoomLevel(state) {
  return state.zoomLevel;
}
function getClosestAllowedInsertionPoint(state, name, clientId = "") {
  const blockNames = Array.isArray(name) ? name : [name];
  const areBlockNamesAllowedInClientId = (id) => blockNames.every(
    (currentName) => canInsertBlockType(state, currentName, id)
  );
  if (!clientId) {
    if (areBlockNamesAllowedInClientId(clientId)) {
      return clientId;
    }
    const sectionRootClientId = getSectionRootClientId(state);
    if (sectionRootClientId && areBlockNamesAllowedInClientId(sectionRootClientId)) {
      return sectionRootClientId;
    }
    return null;
  }
  let current = clientId;
  while (current !== null && !areBlockNamesAllowedInClientId(current)) {
    const parentClientId = getBlockRootClientId(state, current);
    current = parentClientId;
  }
  return current;
}
function getClosestAllowedInsertionPointForPattern(state, pattern, clientId) {
  const { allowedBlockTypes } = getSettings(state);
  const isAllowed = checkAllowListRecursive(
    getGrammar(pattern),
    allowedBlockTypes
  );
  if (!isAllowed) {
    return null;
  }
  const names = getGrammar(pattern).map(({ blockName: name }) => name);
  return getClosestAllowedInsertionPoint(state, names, clientId);
}
function getInsertionPoint(state) {
  return state.insertionPoint;
}
const isBlockHidden = (state, clientId) => {
  const blockName = getBlockName(state, clientId);
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(state, blockName, "visibility", true)) {
    return false;
  }
  const attributes = state.blocks.attributes.get(clientId);
  return attributes?.metadata?.blockVisibility === false;
};
function private_selectors_hasBlockSpotlight(state) {
  return !!state.hasBlockSpotlight;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/inserter/block-patterns-tab/utils.js

const INSERTER_PATTERN_TYPES = {
  user: "user",
  theme: "theme",
  directory: "directory"
};
const INSERTER_SYNC_TYPES = {
  full: "fully",
  unsynced: "unsynced"
};
const allPatternsCategory = {
  name: "allPatterns",
  label: (0,external_wp_i18n_namespaceObject._x)("All", "patterns")
};
const myPatternsCategory = {
  name: "myPatterns",
  label: (0,external_wp_i18n_namespaceObject.__)("My patterns")
};
const starterPatternsCategory = {
  name: "core/starter-content",
  label: (0,external_wp_i18n_namespaceObject.__)("Starter content")
};
function isPatternFiltered(pattern, sourceFilter, syncFilter) {
  const isUserPattern = pattern.name.startsWith("core/block");
  const isDirectoryPattern = pattern.source === "core" || pattern.source?.startsWith("pattern-directory");
  if (sourceFilter === INSERTER_PATTERN_TYPES.theme && (isUserPattern || isDirectoryPattern)) {
    return true;
  }
  if (sourceFilter === INSERTER_PATTERN_TYPES.directory && (isUserPattern || !isDirectoryPattern)) {
    return true;
  }
  if (sourceFilter === INSERTER_PATTERN_TYPES.user && pattern.type !== INSERTER_PATTERN_TYPES.user) {
    return true;
  }
  if (syncFilter === INSERTER_SYNC_TYPES.full && pattern.syncStatus !== "") {
    return true;
  }
  if (syncFilter === INSERTER_SYNC_TYPES.unsynced && pattern.syncStatus !== "unsynced" && isUserPattern) {
    return true;
  }
  return false;
}


;// ./node_modules/@wordpress/block-editor/build-module/store/utils.js








const isFiltered = Symbol("isFiltered");
const parsedPatternCache = /* @__PURE__ */ new WeakMap();
const grammarMapCache = /* @__PURE__ */ new WeakMap();
function mapUserPattern(userPattern, __experimentalUserPatternCategories = []) {
  return {
    name: `core/block/${userPattern.id}`,
    id: userPattern.id,
    type: INSERTER_PATTERN_TYPES.user,
    title: userPattern.title?.raw,
    categories: userPattern.wp_pattern_category?.map((catId) => {
      const category = __experimentalUserPatternCategories.find(
        ({ id }) => id === catId
      );
      return category ? category.slug : catId;
    }),
    content: userPattern.content?.raw,
    syncStatus: userPattern.wp_pattern_sync_status
  };
}
function parsePattern(pattern) {
  const blocks = (0,external_wp_blocks_namespaceObject.parse)(pattern.content, {
    __unstableSkipMigrationLogs: true
  });
  if (blocks.length === 1) {
    blocks[0].attributes = {
      ...blocks[0].attributes,
      metadata: {
        ...blocks[0].attributes.metadata || {},
        categories: pattern.categories,
        patternName: pattern.name,
        name: blocks[0].attributes.metadata?.name || pattern.title
      }
    };
  }
  return {
    ...pattern,
    blocks
  };
}
function getParsedPattern(pattern) {
  let parsedPattern = parsedPatternCache.get(pattern);
  if (!parsedPattern) {
    parsedPattern = parsePattern(pattern);
    parsedPatternCache.set(pattern, parsedPattern);
  }
  return parsedPattern;
}
function getGrammar(pattern) {
  let grammarMap = grammarMapCache.get(pattern);
  if (!grammarMap) {
    grammarMap = (0,external_wp_blockSerializationDefaultParser_namespaceObject.parse)(pattern.content);
    grammarMap = grammarMap.filter((block) => block.blockName !== null);
    grammarMapCache.set(pattern, grammarMap);
  }
  return grammarMap;
}
const checkAllowList = (list, item, defaultResult = null) => {
  if (typeof list === "boolean") {
    return list;
  }
  if (Array.isArray(list)) {
    if (list.includes("core/post-content") && item === null) {
      return true;
    }
    return list.includes(item);
  }
  return defaultResult;
};
const checkAllowListRecursive = (blocks, allowedBlockTypes) => {
  if (typeof allowedBlockTypes === "boolean") {
    return allowedBlockTypes;
  }
  const blocksQueue = [...blocks];
  while (blocksQueue.length > 0) {
    const block = blocksQueue.shift();
    const isAllowed = checkAllowList(
      allowedBlockTypes,
      block.name || block.blockName,
      true
    );
    if (!isAllowed) {
      return false;
    }
    block.innerBlocks?.forEach((innerBlock) => {
      blocksQueue.push(innerBlock);
    });
  }
  return true;
};
const getAllPatternsDependants = (select) => (state) => {
  return [
    state.settings.__experimentalBlockPatterns,
    state.settings.__experimentalUserPatternCategories,
    state.settings.__experimentalReusableBlocks,
    state.settings[selectBlockPatternsKey]?.(select),
    state.blockPatterns,
    unlock(select(STORE_NAME)).getReusableBlocks()
  ];
};
const getInsertBlockTypeDependants = () => (state, rootClientId) => {
  return [
    state.blockListSettings[rootClientId],
    state.blocks.byClientId.get(rootClientId),
    state.settings.allowedBlockTypes,
    state.settings.templateLock,
    getBlockEditingMode(state, rootClientId),
    getSectionRootClientId(state),
    isSectionBlock(state, rootClientId)
  ];
};


;// ./node_modules/@wordpress/block-editor/build-module/utils/sorting.js
const comparator = (field, items, order) => {
  return (a, b) => {
    let cmpA, cmpB;
    if (typeof field === "function") {
      cmpA = field(a);
      cmpB = field(b);
    } else {
      cmpA = a[field];
      cmpB = b[field];
    }
    if (cmpA > cmpB) {
      return order === "asc" ? 1 : -1;
    } else if (cmpB > cmpA) {
      return order === "asc" ? -1 : 1;
    }
    const orderA = items.findIndex((item) => item === a);
    const orderB = items.findIndex((item) => item === b);
    if (orderA > orderB) {
      return 1;
    } else if (orderB > orderA) {
      return -1;
    }
    return 0;
  };
};
function orderBy(items, field, order = "asc") {
  return items.concat().sort(comparator(field, items, order));
}


;// ./node_modules/@wordpress/block-editor/build-module/store/selectors.js












const { isContentBlock: selectors_isContentBlock } = unlock(external_wp_blocks_namespaceObject.privateApis);
const MILLISECONDS_PER_HOUR = 3600 * 1e3;
const MILLISECONDS_PER_DAY = 24 * 3600 * 1e3;
const MILLISECONDS_PER_WEEK = 7 * 24 * 3600 * 1e3;
const selectors_EMPTY_ARRAY = [];
const EMPTY_SET = /* @__PURE__ */ new Set();
const DEFAULT_INSERTER_OPTIONS = {
  [isFiltered]: true
};
function getBlockName(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  const socialLinkName = "core/social-link";
  if (external_wp_element_namespaceObject.Platform.OS !== "web" && block?.name === socialLinkName) {
    const attributes = state.blocks.attributes.get(clientId);
    const { service } = attributes ?? {};
    return service ? `${socialLinkName}-${service}` : socialLinkName;
  }
  return block ? block.name : null;
}
function isBlockValid(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  return !!block && block.isValid;
}
function getBlockAttributes(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  if (!block) {
    return null;
  }
  return state.blocks.attributes.get(clientId);
}
function getBlock(state, clientId) {
  if (!state.blocks.byClientId.has(clientId)) {
    return null;
  }
  return state.blocks.tree.get(clientId);
}
const __unstableGetBlockWithoutInnerBlocks = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId) => {
    const block = state.blocks.byClientId.get(clientId);
    if (!block) {
      return null;
    }
    return {
      ...block,
      attributes: getBlockAttributes(state, clientId)
    };
  },
  (state, clientId) => [
    state.blocks.byClientId.get(clientId),
    state.blocks.attributes.get(clientId)
  ]
);
function getBlocks(state, rootClientId) {
  const treeKey = !rootClientId || !areInnerBlocksControlled(state, rootClientId) ? rootClientId || "" : "controlled||" + rootClientId;
  return state.blocks.tree.get(treeKey)?.innerBlocks || selectors_EMPTY_ARRAY;
}
const __unstableGetClientIdWithClientIdsTree = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId) => {
    external_wp_deprecated_default()(
      "wp.data.select( 'core/block-editor' ).__unstableGetClientIdWithClientIdsTree",
      {
        since: "6.3",
        version: "6.5"
      }
    );
    return {
      clientId,
      innerBlocks: __unstableGetClientIdsTree(state, clientId)
    };
  },
  (state) => [state.blocks.order]
);
const __unstableGetClientIdsTree = (0,external_wp_data_namespaceObject.createSelector)(
  (state, rootClientId = "") => {
    external_wp_deprecated_default()(
      "wp.data.select( 'core/block-editor' ).__unstableGetClientIdsTree",
      {
        since: "6.3",
        version: "6.5"
      }
    );
    return getBlockOrder(state, rootClientId).map(
      (clientId) => __unstableGetClientIdWithClientIdsTree(state, clientId)
    );
  },
  (state) => [state.blocks.order]
);
const getClientIdsOfDescendants = (0,external_wp_data_namespaceObject.createSelector)(
  (state, rootIds) => {
    rootIds = Array.isArray(rootIds) ? [...rootIds] : [rootIds];
    const ids = [];
    for (const rootId of rootIds) {
      const order = state.blocks.order.get(rootId);
      if (order) {
        ids.push(...order);
      }
    }
    let index = 0;
    while (index < ids.length) {
      const id = ids[index];
      const order = state.blocks.order.get(id);
      if (order) {
        ids.splice(index + 1, 0, ...order);
      }
      index++;
    }
    return ids;
  },
  (state) => [state.blocks.order]
);
const getClientIdsWithDescendants = (state) => getClientIdsOfDescendants(state, "");
const getGlobalBlockCount = (0,external_wp_data_namespaceObject.createSelector)(
  (state, blockName) => {
    const clientIds = getClientIdsWithDescendants(state);
    if (!blockName) {
      return clientIds.length;
    }
    let count = 0;
    for (const clientId of clientIds) {
      const block = state.blocks.byClientId.get(clientId);
      if (block.name === blockName) {
        count++;
      }
    }
    return count;
  },
  (state) => [state.blocks.order, state.blocks.byClientId]
);
const getBlocksByName = (0,external_wp_data_namespaceObject.createSelector)(
  (state, blockName) => {
    if (!blockName) {
      return selectors_EMPTY_ARRAY;
    }
    const blockNames = Array.isArray(blockName) ? blockName : [blockName];
    const clientIds = getClientIdsWithDescendants(state);
    const foundBlocks = clientIds.filter((clientId) => {
      const block = state.blocks.byClientId.get(clientId);
      return blockNames.includes(block.name);
    });
    return foundBlocks.length > 0 ? foundBlocks : selectors_EMPTY_ARRAY;
  },
  (state) => [state.blocks.order, state.blocks.byClientId]
);
function __experimentalGetGlobalBlocksByName(state, blockName) {
  external_wp_deprecated_default()(
    "wp.data.select( 'core/block-editor' ).__experimentalGetGlobalBlocksByName",
    {
      since: "6.5",
      alternative: `wp.data.select( 'core/block-editor' ).getBlocksByName`
    }
  );
  return getBlocksByName(state, blockName);
}
const getBlocksByClientId = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(
    (clientId) => getBlock(state, clientId)
  ),
  (state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(
    (clientId) => state.blocks.tree.get(clientId)
  )
);
const getBlockNamesByClientId = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientIds) => getBlocksByClientId(state, clientIds).filter(Boolean).map((block) => block.name),
  (state, clientIds) => getBlocksByClientId(state, clientIds)
);
function getBlockCount(state, rootClientId) {
  return getBlockOrder(state, rootClientId).length;
}
function getSelectionStart(state) {
  return state.selection.selectionStart;
}
function getSelectionEnd(state) {
  return state.selection.selectionEnd;
}
function getBlockSelectionStart(state) {
  return state.selection.selectionStart.clientId;
}
function getBlockSelectionEnd(state) {
  return state.selection.selectionEnd.clientId;
}
function getSelectedBlockCount(state) {
  const multiSelectedBlockCount = getMultiSelectedBlockClientIds(state).length;
  if (multiSelectedBlockCount) {
    return multiSelectedBlockCount;
  }
  return state.selection.selectionStart.clientId ? 1 : 0;
}
function hasSelectedBlock(state) {
  const { selectionStart, selectionEnd } = state.selection;
  return !!selectionStart.clientId && selectionStart.clientId === selectionEnd.clientId;
}
function getSelectedBlockClientId(state) {
  const { selectionStart, selectionEnd } = state.selection;
  const { clientId } = selectionStart;
  if (!clientId || clientId !== selectionEnd.clientId) {
    return null;
  }
  return clientId;
}
function getSelectedBlock(state) {
  const clientId = getSelectedBlockClientId(state);
  return clientId ? getBlock(state, clientId) : null;
}
function getBlockRootClientId(state, clientId) {
  return state.blocks.parents.get(clientId) ?? null;
}
const getBlockParents = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId, ascending = false) => {
    const parents = [];
    let current = clientId;
    while (current = state.blocks.parents.get(current)) {
      parents.push(current);
    }
    if (!parents.length) {
      return selectors_EMPTY_ARRAY;
    }
    return ascending ? parents : parents.reverse();
  },
  (state) => [state.blocks.parents]
);
const getBlockParentsByBlockName = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId, blockName, ascending = false) => {
    const parents = getBlockParents(state, clientId, ascending);
    const hasName = Array.isArray(blockName) ? (name) => blockName.includes(name) : (name) => blockName === name;
    return parents.filter((id) => hasName(getBlockName(state, id)));
  },
  (state) => [state.blocks.parents]
);
function getBlockHierarchyRootClientId(state, clientId) {
  let current = clientId;
  let parent;
  do {
    parent = current;
    current = state.blocks.parents.get(current);
  } while (current);
  return parent;
}
function getLowestCommonAncestorWithSelectedBlock(state, clientId) {
  const selectedId = getSelectedBlockClientId(state);
  const clientParents = [...getBlockParents(state, clientId), clientId];
  const selectedParents = [
    ...getBlockParents(state, selectedId),
    selectedId
  ];
  let lowestCommonAncestor;
  const maxDepth = Math.min(clientParents.length, selectedParents.length);
  for (let index = 0; index < maxDepth; index++) {
    if (clientParents[index] === selectedParents[index]) {
      lowestCommonAncestor = clientParents[index];
    } else {
      break;
    }
  }
  return lowestCommonAncestor;
}
function getAdjacentBlockClientId(state, startClientId, modifier = 1) {
  if (startClientId === void 0) {
    startClientId = getSelectedBlockClientId(state);
  }
  if (startClientId === void 0) {
    if (modifier < 0) {
      startClientId = getFirstMultiSelectedBlockClientId(state);
    } else {
      startClientId = getLastMultiSelectedBlockClientId(state);
    }
  }
  if (!startClientId) {
    return null;
  }
  const rootClientId = getBlockRootClientId(state, startClientId);
  if (rootClientId === null) {
    return null;
  }
  const { order } = state.blocks;
  const orderSet = order.get(rootClientId);
  const index = orderSet.indexOf(startClientId);
  const nextIndex = index + 1 * modifier;
  if (nextIndex < 0) {
    return null;
  }
  if (nextIndex === orderSet.length) {
    return null;
  }
  return orderSet[nextIndex];
}
function getPreviousBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, -1);
}
function getNextBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, 1);
}
function getSelectedBlocksInitialCaretPosition(state) {
  return state.initialPosition;
}
const getSelectedBlockClientIds = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    const { selectionStart, selectionEnd } = state.selection;
    if (!selectionStart.clientId || !selectionEnd.clientId) {
      return selectors_EMPTY_ARRAY;
    }
    if (selectionStart.clientId === selectionEnd.clientId) {
      return [selectionStart.clientId];
    }
    const rootClientId = getBlockRootClientId(
      state,
      selectionStart.clientId
    );
    if (rootClientId === null) {
      return selectors_EMPTY_ARRAY;
    }
    const blockOrder = getBlockOrder(state, rootClientId);
    const startIndex = blockOrder.indexOf(selectionStart.clientId);
    const endIndex = blockOrder.indexOf(selectionEnd.clientId);
    if (startIndex > endIndex) {
      return blockOrder.slice(endIndex, startIndex + 1);
    }
    return blockOrder.slice(startIndex, endIndex + 1);
  },
  (state) => [
    state.blocks.order,
    state.selection.selectionStart.clientId,
    state.selection.selectionEnd.clientId
  ]
);
function getMultiSelectedBlockClientIds(state) {
  const { selectionStart, selectionEnd } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return selectors_EMPTY_ARRAY;
  }
  return getSelectedBlockClientIds(state);
}
const getMultiSelectedBlocks = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
    if (!multiSelectedBlockClientIds.length) {
      return selectors_EMPTY_ARRAY;
    }
    return multiSelectedBlockClientIds.map(
      (clientId) => getBlock(state, clientId)
    );
  },
  (state) => [
    ...getSelectedBlockClientIds.getDependants(state),
    state.blocks.byClientId,
    state.blocks.order,
    state.blocks.attributes
  ]
);
function getFirstMultiSelectedBlockClientId(state) {
  return getMultiSelectedBlockClientIds(state)[0] || null;
}
function getLastMultiSelectedBlockClientId(state) {
  const selectedClientIds = getMultiSelectedBlockClientIds(state);
  return selectedClientIds[selectedClientIds.length - 1] || null;
}
function isFirstMultiSelectedBlock(state, clientId) {
  return getFirstMultiSelectedBlockClientId(state) === clientId;
}
function isBlockMultiSelected(state, clientId) {
  return getMultiSelectedBlockClientIds(state).indexOf(clientId) !== -1;
}
const isAncestorMultiSelected = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientId) => {
    let ancestorClientId = clientId;
    let isMultiSelected = false;
    while (ancestorClientId && !isMultiSelected) {
      ancestorClientId = getBlockRootClientId(state, ancestorClientId);
      isMultiSelected = isBlockMultiSelected(state, ancestorClientId);
    }
    return isMultiSelected;
  },
  (state) => [
    state.blocks.order,
    state.selection.selectionStart.clientId,
    state.selection.selectionEnd.clientId
  ]
);
function getMultiSelectedBlocksStartClientId(state) {
  const { selectionStart, selectionEnd } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }
  return selectionStart.clientId || null;
}
function getMultiSelectedBlocksEndClientId(state) {
  const { selectionStart, selectionEnd } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }
  return selectionEnd.clientId || null;
}
function __unstableIsFullySelected(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !selectionAnchor.attributeKey && !selectionFocus.attributeKey && typeof selectionAnchor.offset === "undefined" && typeof selectionFocus.offset === "undefined";
}
function __unstableIsSelectionCollapsed(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !!selectionAnchor && !!selectionFocus && selectionAnchor.clientId === selectionFocus.clientId && selectionAnchor.attributeKey === selectionFocus.attributeKey && selectionAnchor.offset === selectionFocus.offset;
}
function __unstableSelectionHasUnmergeableBlock(state) {
  return getSelectedBlockClientIds(state).some((clientId) => {
    const blockName = getBlockName(state, clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
    return !blockType.merge;
  });
}
function __unstableIsSelectionMergeable(state, isForward) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return false;
  }
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === "undefined" || typeof selectionFocus.offset === "undefined") {
    return false;
  }
  const anchorRootClientId = getBlockRootClientId(
    state,
    selectionAnchor.clientId
  );
  const focusRootClientId = getBlockRootClientId(
    state,
    selectionFocus.clientId
  );
  if (anchorRootClientId !== focusRootClientId) {
    return false;
  }
  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const targetBlockClientId = isForward ? selectionEnd.clientId : selectionStart.clientId;
  const blockToMergeClientId = isForward ? selectionStart.clientId : selectionEnd.clientId;
  const targetBlockName = getBlockName(state, targetBlockClientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlockName);
  if (!targetBlockType.merge) {
    return false;
  }
  const blockToMerge = getBlock(state, blockToMergeClientId);
  if (blockToMerge.name === targetBlockName) {
    return true;
  }
  const blocksToMerge = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blockToMerge, targetBlockName);
  return blocksToMerge && blocksToMerge.length;
}
const __unstableGetSelectedBlocksWithPartialSelection = (state) => {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return selectors_EMPTY_ARRAY;
  }
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === "undefined" || typeof selectionFocus.offset === "undefined") {
    return selectors_EMPTY_ARRAY;
  }
  const anchorRootClientId = getBlockRootClientId(
    state,
    selectionAnchor.clientId
  );
  const focusRootClientId = getBlockRootClientId(
    state,
    selectionFocus.clientId
  );
  if (anchorRootClientId !== focusRootClientId) {
    return selectors_EMPTY_ARRAY;
  }
  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);
  const [selectionStart, selectionEnd] = anchorIndex > focusIndex ? [selectionFocus, selectionAnchor] : [selectionAnchor, selectionFocus];
  const blockA = getBlock(state, selectionStart.clientId);
  const blockB = getBlock(state, selectionEnd.clientId);
  const htmlA = blockA.attributes[selectionStart.attributeKey];
  const htmlB = blockB.attributes[selectionEnd.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({ html: htmlA });
  let valueB = (0,external_wp_richText_namespaceObject.create)({ html: htmlB });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, 0, selectionStart.offset);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, selectionEnd.offset, valueB.text.length);
  return [
    {
      ...blockA,
      attributes: {
        ...blockA.attributes,
        [selectionStart.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
          value: valueA
        })
      }
    },
    {
      ...blockB,
      attributes: {
        ...blockB.attributes,
        [selectionEnd.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
          value: valueB
        })
      }
    }
  ];
};
function getBlockOrder(state, rootClientId) {
  return state.blocks.order.get(rootClientId || "") || selectors_EMPTY_ARRAY;
}
function getBlockIndex(state, clientId) {
  const rootClientId = getBlockRootClientId(state, clientId);
  return getBlockOrder(state, rootClientId).indexOf(clientId);
}
function isBlockSelected(state, clientId) {
  const { selectionStart, selectionEnd } = state.selection;
  if (selectionStart.clientId !== selectionEnd.clientId) {
    return false;
  }
  return selectionStart.clientId === clientId;
}
function hasSelectedInnerBlock(state, clientId, deep = false) {
  const selectedBlockClientIds = getSelectedBlockClientIds(state);
  if (!selectedBlockClientIds.length) {
    return false;
  }
  if (deep) {
    return selectedBlockClientIds.some(
      (id) => (
        // Pass true because we don't care about order and it's more
        // performant.
        getBlockParents(state, id, true).includes(clientId)
      )
    );
  }
  return selectedBlockClientIds.some(
    (id) => getBlockRootClientId(state, id) === clientId
  );
}
function hasDraggedInnerBlock(state, clientId, deep = false) {
  return getBlockOrder(state, clientId).some(
    (innerClientId) => isBlockBeingDragged(state, innerClientId) || deep && hasDraggedInnerBlock(state, innerClientId, deep)
  );
}
function isBlockWithinSelection(state, clientId) {
  if (!clientId) {
    return false;
  }
  const clientIds = getMultiSelectedBlockClientIds(state);
  const index = clientIds.indexOf(clientId);
  return index > -1 && index < clientIds.length - 1;
}
function hasMultiSelection(state) {
  const { selectionStart, selectionEnd } = state.selection;
  return selectionStart.clientId !== selectionEnd.clientId;
}
function selectors_isMultiSelecting(state) {
  return state.isMultiSelecting;
}
function selectors_isSelectionEnabled(state) {
  return state.isSelectionEnabled;
}
function getBlockMode(state, clientId) {
  return state.blocksMode[clientId] || "visual";
}
function selectors_isTyping(state) {
  return state.isTyping;
}
function isDraggingBlocks(state) {
  return !!state.draggedBlocks.length;
}
function getDraggedBlockClientIds(state) {
  return state.draggedBlocks;
}
function isBlockBeingDragged(state, clientId) {
  return state.draggedBlocks.includes(clientId);
}
function isAncestorBeingDragged(state, clientId) {
  if (!isDraggingBlocks(state)) {
    return false;
  }
  const parents = getBlockParents(state, clientId);
  return parents.some(
    (parentClientId) => isBlockBeingDragged(state, parentClientId)
  );
}
function isCaretWithinFormattedText() {
  external_wp_deprecated_default()(
    'wp.data.select( "core/block-editor" ).isCaretWithinFormattedText',
    {
      since: "6.1",
      version: "6.3"
    }
  );
  return false;
}
const getBlockInsertionPoint = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    let rootClientId, index;
    const {
      insertionCue,
      selection: { selectionEnd }
    } = state;
    if (insertionCue !== null) {
      return insertionCue;
    }
    const { clientId } = selectionEnd;
    if (clientId) {
      rootClientId = getBlockRootClientId(state, clientId) || void 0;
      index = getBlockIndex(state, selectionEnd.clientId) + 1;
    } else {
      index = getBlockOrder(state).length;
    }
    return { rootClientId, index };
  },
  (state) => [
    state.insertionCue,
    state.selection.selectionEnd.clientId,
    state.blocks.parents,
    state.blocks.order
  ]
);
function isBlockInsertionPointVisible(state) {
  return state.insertionCue !== null;
}
function isValidTemplate(state) {
  return state.template.isValid;
}
function getTemplate(state) {
  return state.settings.template;
}
function getTemplateLock(state, rootClientId) {
  if (!rootClientId) {
    return state.settings.templateLock ?? false;
  }
  return getBlockListSettings(state, rootClientId)?.templateLock ?? false;
}
const isBlockVisibleInTheInserter = (state, blockNameOrType, rootClientId = null) => {
  let blockType;
  let blockName;
  if (blockNameOrType && "object" === typeof blockNameOrType) {
    blockType = blockNameOrType;
    blockName = blockNameOrType.name;
  } else {
    blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockNameOrType);
    blockName = blockNameOrType;
  }
  if (!blockType) {
    return false;
  }
  const { allowedBlockTypes } = getSettings(state);
  const isBlockAllowedInEditor = checkAllowList(
    allowedBlockTypes,
    blockName,
    true
  );
  if (!isBlockAllowedInEditor) {
    return false;
  }
  const parents = (Array.isArray(blockType.parent) ? blockType.parent : []).concat(Array.isArray(blockType.ancestor) ? blockType.ancestor : []);
  if (parents.length > 0) {
    if (parents.includes("core/post-content")) {
      return true;
    }
    let current = rootClientId;
    let hasParent = false;
    do {
      if (parents.includes(getBlockName(state, current))) {
        hasParent = true;
        break;
      }
      current = state.blocks.parents.get(current);
    } while (current);
    return hasParent;
  }
  return true;
};
const canInsertBlockTypeUnmemoized = (state, blockName, rootClientId = null) => {
  if (!isBlockVisibleInTheInserter(state, blockName, rootClientId)) {
    return false;
  }
  let blockType;
  if (blockName && "object" === typeof blockName) {
    blockType = blockName;
    blockName = blockType.name;
  } else {
    blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
  }
  if (getTemplateLock(state, rootClientId)) {
    return false;
  }
  const blockEditingMode = getBlockEditingMode(state, rootClientId ?? "");
  if (blockEditingMode === "disabled") {
    return false;
  }
  const parentBlockListSettings = getBlockListSettings(state, rootClientId);
  if (rootClientId && parentBlockListSettings === void 0) {
    return false;
  }
  const isContentRoleBlock = selectors_isContentBlock(blockName);
  const isParentSectionBlock = !!isSectionBlock(state, rootClientId);
  const isBlockWithinSection = !!getParentSectionBlock(
    state,
    rootClientId
  );
  if ((isParentSectionBlock || isBlockWithinSection) && !isContentRoleBlock) {
    return false;
  }
  if ((isParentSectionBlock || blockEditingMode === "contentOnly") && !isContainerInsertableToInContentOnlyMode(
    state,
    blockName,
    rootClientId
  )) {
    return false;
  }
  const parentName = getBlockName(state, rootClientId);
  const parentBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(parentName);
  const parentAllowedChildBlocks = parentBlockType?.allowedBlocks;
  let hasParentAllowedBlock = checkAllowList(
    parentAllowedChildBlocks,
    blockName
  );
  if (hasParentAllowedBlock !== false) {
    const parentAllowedBlocks = parentBlockListSettings?.allowedBlocks;
    const hasParentListAllowedBlock = checkAllowList(
      parentAllowedBlocks,
      blockName
    );
    if (hasParentListAllowedBlock !== null) {
      hasParentAllowedBlock = hasParentListAllowedBlock;
    }
  }
  const blockAllowedParentBlocks = blockType.parent;
  const hasBlockAllowedParent = checkAllowList(
    blockAllowedParentBlocks,
    parentName
  );
  let hasBlockAllowedAncestor = true;
  const blockAllowedAncestorBlocks = blockType.ancestor;
  if (blockAllowedAncestorBlocks) {
    const ancestors = [
      rootClientId,
      ...getBlockParents(state, rootClientId)
    ];
    hasBlockAllowedAncestor = ancestors.some(
      (ancestorClientId) => checkAllowList(
        blockAllowedAncestorBlocks,
        getBlockName(state, ancestorClientId)
      )
    );
  }
  const canInsert = hasBlockAllowedAncestor && (hasParentAllowedBlock === null && hasBlockAllowedParent === null || hasParentAllowedBlock === true || hasBlockAllowedParent === true);
  if (!canInsert) {
    return canInsert;
  }
  return (0,external_wp_hooks_namespaceObject.applyFilters)(
    "blockEditor.__unstableCanInsertBlockType",
    canInsert,
    blockType,
    rootClientId,
    {
      // Pass bound selectors of the current registry. If we're in a nested
      // context, the data will differ from the one selected from the root
      // registry.
      getBlock: getBlock.bind(null, state),
      getBlockParentsByBlockName: getBlockParentsByBlockName.bind(
        null,
        state
      )
    }
  );
};
const canInsertBlockType = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    canInsertBlockTypeUnmemoized,
    (state, blockName, rootClientId) => getInsertBlockTypeDependants(select)(state, rootClientId)
  )
);
function canInsertBlocks(state, clientIds, rootClientId = null) {
  return clientIds.every(
    (id) => canInsertBlockType(state, getBlockName(state, id), rootClientId)
  );
}
function canRemoveBlock(state, clientId) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  if (attributes.lock?.remove !== void 0) {
    return !attributes.lock.remove;
  }
  const rootClientId = getBlockRootClientId(state, clientId);
  if (getTemplateLock(state, rootClientId)) {
    return false;
  }
  const isBlockWithinSection = !!getParentSectionBlock(state, clientId);
  const isContentRoleBlock = selectors_isContentBlock(
    getBlockName(state, clientId)
  );
  if (isBlockWithinSection && !isContentRoleBlock) {
    return false;
  }
  const isParentSectionBlock = !!isSectionBlock(state, rootClientId);
  const rootBlockEditingMode = getBlockEditingMode(state, rootClientId);
  if ((isParentSectionBlock || rootBlockEditingMode === "contentOnly") && !isContainerInsertableToInContentOnlyMode(
    state,
    getBlockName(state, clientId),
    rootClientId
  )) {
    return false;
  }
  return rootBlockEditingMode !== "disabled";
}
function canRemoveBlocks(state, clientIds) {
  return clientIds.every((clientId) => canRemoveBlock(state, clientId));
}
function canMoveBlock(state, clientId) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  if (attributes.lock?.move !== void 0) {
    return !attributes.lock.move;
  }
  const rootClientId = getBlockRootClientId(state, clientId);
  const templateLock = getTemplateLock(state, rootClientId);
  if (templateLock === "all" || templateLock === "contentOnly") {
    return false;
  }
  const isBlockWithinSection = !!getParentSectionBlock(state, clientId);
  const isContentRoleBlock = selectors_isContentBlock(
    getBlockName(state, clientId)
  );
  if (isBlockWithinSection && !isContentRoleBlock) {
    return false;
  }
  const isParentSectionBlock = !!isSectionBlock(state, rootClientId);
  const rootBlockEditingMode = getBlockEditingMode(state, rootClientId);
  if ((isParentSectionBlock || rootBlockEditingMode === "contentOnly") && !isContainerInsertableToInContentOnlyMode(
    state,
    getBlockName(state, clientId),
    rootClientId
  )) {
    return false;
  }
  return getBlockEditingMode(state, rootClientId) !== "disabled";
}
function canMoveBlocks(state, clientIds) {
  return clientIds.every((clientId) => canMoveBlock(state, clientId));
}
function canEditBlock(state, clientId) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  const { lock } = attributes;
  return !lock?.edit;
}
function canLockBlockType(state, nameOrType) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(nameOrType, "lock", true)) {
    return false;
  }
  return !!state.settings?.canLockBlocks;
}
function getInsertUsage(state, id) {
  return state.preferences.insertUsage?.[id] ?? null;
}
const canIncludeBlockTypeInInserter = (state, blockType, rootClientId) => {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "inserter", true)) {
    return false;
  }
  return canInsertBlockTypeUnmemoized(state, blockType.name, rootClientId);
};
const getItemFromVariation = (state, item) => (variation) => {
  const variationId = `${item.id}/${variation.name}`;
  const { time, count = 0 } = getInsertUsage(state, variationId) || {};
  return {
    ...item,
    id: variationId,
    icon: variation.icon || item.icon,
    title: variation.title || item.title,
    description: variation.description || item.description,
    category: variation.category || item.category,
    // If `example` is explicitly undefined for the variation, the preview will not be shown.
    example: variation.hasOwnProperty("example") ? variation.example : item.example,
    initialAttributes: {
      ...item.initialAttributes,
      ...variation.attributes
    },
    innerBlocks: variation.innerBlocks,
    keywords: variation.keywords || item.keywords,
    frecency: calculateFrecency(time, count)
  };
};
const calculateFrecency = (time, count) => {
  if (!time) {
    return count;
  }
  const duration = Date.now() - time;
  switch (true) {
    case duration < MILLISECONDS_PER_HOUR:
      return count * 4;
    case duration < MILLISECONDS_PER_DAY:
      return count * 2;
    case duration < MILLISECONDS_PER_WEEK:
      return count / 2;
    default:
      return count / 4;
  }
};
const buildBlockTypeItem = (state, { buildScope = "inserter" }) => (blockType) => {
  const id = blockType.name;
  let isDisabled = false;
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType.name, "multiple", true)) {
    isDisabled = getBlocksByClientId(
      state,
      getClientIdsWithDescendants(state)
    ).some(({ name }) => name === blockType.name);
  }
  const { time, count = 0 } = getInsertUsage(state, id) || {};
  const blockItemBase = {
    id,
    name: blockType.name,
    title: blockType.title,
    icon: blockType.icon,
    isDisabled,
    frecency: calculateFrecency(time, count)
  };
  if (buildScope === "transform") {
    return blockItemBase;
  }
  const inserterVariations = (0,external_wp_blocks_namespaceObject.getBlockVariations)(
    blockType.name,
    "inserter"
  );
  return {
    ...blockItemBase,
    initialAttributes: {},
    description: blockType.description,
    category: blockType.category,
    keywords: blockType.keywords,
    parent: blockType.parent,
    ancestor: blockType.ancestor,
    variations: inserterVariations,
    example: blockType.example,
    utility: 1
    // Deprecated.
  };
};
const getInserterItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, rootClientId = null, options = DEFAULT_INSERTER_OPTIONS) => {
      const buildReusableBlockInserterItem = (reusableBlock) => {
        const icon = !reusableBlock.wp_pattern_sync_status ? {
          src: symbol_default,
          foreground: "var(--wp-block-synced-color)"
        } : symbol_default;
        const userPattern = mapUserPattern(reusableBlock);
        const { time, count = 0 } = getInsertUsage(state, userPattern.name) || {};
        const frecency = calculateFrecency(time, count);
        return {
          id: userPattern.name,
          name: "core/block",
          initialAttributes: { ref: reusableBlock.id },
          title: userPattern.title,
          icon,
          category: "reusable",
          keywords: ["reusable"],
          isDisabled: false,
          utility: 1,
          // Deprecated.
          frecency,
          content: userPattern.content,
          get blocks() {
            return getParsedPattern(userPattern).blocks;
          },
          syncStatus: userPattern.syncStatus
        };
      };
      const patternInserterItems = canInsertBlockTypeUnmemoized(
        state,
        "core/block",
        rootClientId
      ) ? unlock(select(STORE_NAME)).getReusableBlocks().map(buildReusableBlockInserterItem) : [];
      const buildBlockTypeInserterItem = buildBlockTypeItem(state, {
        buildScope: "inserter"
      });
      let blockTypeInserterItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(
        (blockType) => (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "inserter", true)
      ).map(buildBlockTypeInserterItem);
      if (options[isFiltered] !== false) {
        blockTypeInserterItems = blockTypeInserterItems.filter(
          (blockType) => canIncludeBlockTypeInInserter(
            state,
            blockType,
            rootClientId
          )
        );
      } else {
        blockTypeInserterItems = blockTypeInserterItems.filter(
          (blockType) => isBlockVisibleInTheInserter(
            state,
            blockType,
            rootClientId
          )
        ).map((blockType) => ({
          ...blockType,
          isAllowedInCurrentRoot: canIncludeBlockTypeInInserter(
            state,
            blockType,
            rootClientId
          )
        }));
      }
      const stretchVariations = [];
      const items = blockTypeInserterItems.reduce(
        (accumulator, item) => {
          const { variations = [] } = item;
          if (!variations.some(({ isDefault }) => isDefault)) {
            accumulator.push(item);
          }
          if (variations.length) {
            const variationMapper = getItemFromVariation(
              state,
              item
            );
            variations.map(variationMapper).forEach((variation) => {
              if (variation.id === "core/paragraph/stretchy-paragraph" || variation.id === "core/heading/stretchy-heading") {
                stretchVariations.push(variation);
              } else {
                accumulator.push(variation);
              }
            });
          }
          return accumulator;
        },
        []
      );
      items.push(...stretchVariations);
      const groupByType = (blocks, block) => {
        const { core, noncore } = blocks;
        const type = block.name.startsWith("core/") ? core : noncore;
        type.push(block);
        return blocks;
      };
      const { core: coreItems, noncore: nonCoreItems } = items.reduce(
        groupByType,
        { core: [], noncore: [] }
      );
      const sortedBlockTypes = [...coreItems, ...nonCoreItems];
      return [...sortedBlockTypes, ...patternInserterItems];
    },
    (state, rootClientId) => [
      (0,external_wp_blocks_namespaceObject.getBlockTypes)(),
      unlock(select(STORE_NAME)).getReusableBlocks(),
      state.blocks.order,
      state.preferences.insertUsage,
      ...getInsertBlockTypeDependants(select)(state, rootClientId)
    ]
  )
);
const getBlockTransformItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, blocks, rootClientId = null) => {
      const normalizedBlocks = Array.isArray(blocks) ? blocks : [blocks];
      const buildBlockTypeTransformItem = buildBlockTypeItem(state, {
        buildScope: "transform"
      });
      const blockTypeTransformItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(
        (blockType) => canIncludeBlockTypeInInserter(
          state,
          blockType,
          rootClientId
        )
      ).map(buildBlockTypeTransformItem);
      const itemsByName = Object.fromEntries(
        Object.entries(blockTypeTransformItems).map(
          ([, value]) => [value.name, value]
        )
      );
      const possibleTransforms = (0,external_wp_blocks_namespaceObject.getPossibleBlockTransformations)(
        normalizedBlocks
      ).reduce((accumulator, block) => {
        if (itemsByName[block?.name]) {
          accumulator.push(itemsByName[block.name]);
        }
        return accumulator;
      }, []);
      return orderBy(
        possibleTransforms,
        (block) => itemsByName[block.name].frecency,
        "desc"
      );
    },
    (state, blocks, rootClientId) => [
      (0,external_wp_blocks_namespaceObject.getBlockTypes)(),
      state.preferences.insertUsage,
      ...getInsertBlockTypeDependants(select)(state, rootClientId)
    ]
  )
);
const hasInserterItems = (state, rootClientId = null) => {
  const hasBlockType = (0,external_wp_blocks_namespaceObject.getBlockTypes)().some(
    (blockType) => canIncludeBlockTypeInInserter(state, blockType, rootClientId)
  );
  if (hasBlockType) {
    return true;
  }
  const hasReusableBlock = canInsertBlockTypeUnmemoized(
    state,
    "core/block",
    rootClientId
  );
  return hasReusableBlock;
};
const getAllowedBlocks = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, rootClientId = null) => {
      if (!rootClientId) {
        return;
      }
      const blockTypes = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(
        (blockType) => canIncludeBlockTypeInInserter(state, blockType, rootClientId)
      );
      const hasReusableBlock = canInsertBlockTypeUnmemoized(
        state,
        "core/block",
        rootClientId
      );
      if (hasReusableBlock) {
        blockTypes.push("core/block");
      }
      return blockTypes;
    },
    (state, rootClientId) => [
      (0,external_wp_blocks_namespaceObject.getBlockTypes)(),
      ...getInsertBlockTypeDependants(select)(state, rootClientId)
    ]
  )
);
const __experimentalGetAllowedBlocks = (0,external_wp_data_namespaceObject.createSelector)(
  (state, rootClientId = null) => {
    external_wp_deprecated_default()(
      'wp.data.select( "core/block-editor" ).__experimentalGetAllowedBlocks',
      {
        alternative: 'wp.data.select( "core/block-editor" ).getAllowedBlocks',
        since: "6.2",
        version: "6.4"
      }
    );
    return getAllowedBlocks(state, rootClientId);
  },
  (state, rootClientId) => getAllowedBlocks.getDependants(state, rootClientId)
);
function getDirectInsertBlock(state, rootClientId = null) {
  if (!rootClientId) {
    return;
  }
  const { defaultBlock, directInsert } = state.blockListSettings[rootClientId] ?? {};
  if (!defaultBlock || !directInsert) {
    return;
  }
  return defaultBlock;
}
function __experimentalGetDirectInsertBlock(state, rootClientId = null) {
  external_wp_deprecated_default()(
    'wp.data.select( "core/block-editor" ).__experimentalGetDirectInsertBlock',
    {
      alternative: 'wp.data.select( "core/block-editor" ).getDirectInsertBlock',
      since: "6.3",
      version: "6.4"
    }
  );
  return getDirectInsertBlock(state, rootClientId);
}
const __experimentalGetParsedPattern = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (state, patternName) => {
    const pattern = unlock(select(STORE_NAME)).getPatternBySlug(
      patternName
    );
    return pattern ? getParsedPattern(pattern) : null;
  }
);
const getAllowedPatternsDependants = (select) => (state, rootClientId) => [
  ...getAllPatternsDependants(select)(state),
  ...getInsertBlockTypeDependants(select)(state, rootClientId)
];
const patternsWithParsedBlocks = /* @__PURE__ */ new WeakMap();
function enhancePatternWithParsedBlocks(pattern) {
  let enhancedPattern = patternsWithParsedBlocks.get(pattern);
  if (!enhancedPattern) {
    enhancedPattern = {
      ...pattern,
      get blocks() {
        return getParsedPattern(pattern).blocks;
      }
    };
    patternsWithParsedBlocks.set(pattern, enhancedPattern);
  }
  return enhancedPattern;
}
const __experimentalGetAllowedPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => {
    return (0,external_wp_data_namespaceObject.createSelector)(
      (state, rootClientId = null, options = DEFAULT_INSERTER_OPTIONS) => {
        const { getAllPatterns } = unlock(select(STORE_NAME));
        const patterns = getAllPatterns();
        const { allowedBlockTypes } = getSettings(state);
        const parsedPatterns = patterns.filter(({ inserter = true }) => !!inserter).map(enhancePatternWithParsedBlocks);
        const availableParsedPatterns = parsedPatterns.filter(
          (pattern) => checkAllowListRecursive(
            getGrammar(pattern),
            allowedBlockTypes
          )
        );
        const patternsAllowed = availableParsedPatterns.filter(
          (pattern) => getGrammar(pattern).every(
            ({ blockName: name }) => options[isFiltered] !== false ? canInsertBlockType(
              state,
              name,
              rootClientId
            ) : isBlockVisibleInTheInserter(
              state,
              name,
              rootClientId
            )
          )
        );
        return patternsAllowed;
      },
      getAllowedPatternsDependants(select)
    );
  }
);
const getPatternsByBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, blockNames, rootClientId = null) => {
      if (!blockNames) {
        return selectors_EMPTY_ARRAY;
      }
      const patterns = select(STORE_NAME).__experimentalGetAllowedPatterns(
        rootClientId
      );
      const normalizedBlockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
      const filteredPatterns = patterns.filter(
        (pattern) => pattern?.blockTypes?.some?.(
          (blockName) => normalizedBlockNames.includes(blockName)
        )
      );
      if (filteredPatterns.length === 0) {
        return selectors_EMPTY_ARRAY;
      }
      return filteredPatterns;
    },
    (state, blockNames, rootClientId) => getAllowedPatternsDependants(select)(state, rootClientId)
  )
);
const __experimentalGetPatternsByBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => {
    external_wp_deprecated_default()(
      'wp.data.select( "core/block-editor" ).__experimentalGetPatternsByBlockTypes',
      {
        alternative: 'wp.data.select( "core/block-editor" ).getPatternsByBlockTypes',
        since: "6.2",
        version: "6.4"
      }
    );
    return select(STORE_NAME).getPatternsByBlockTypes;
  }
);
const __experimentalGetPatternTransformItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, blocks, rootClientId = null) => {
      if (!blocks) {
        return selectors_EMPTY_ARRAY;
      }
      if (blocks.some(
        ({ clientId, innerBlocks }) => innerBlocks.length || areInnerBlocksControlled(state, clientId)
      )) {
        return selectors_EMPTY_ARRAY;
      }
      const selectedBlockNames = Array.from(
        new Set(blocks.map(({ name }) => name))
      );
      return select(STORE_NAME).getPatternsByBlockTypes(
        selectedBlockNames,
        rootClientId
      );
    },
    (state, blocks, rootClientId) => getAllowedPatternsDependants(select)(state, rootClientId)
  )
);
function getBlockListSettings(state, clientId) {
  return state.blockListSettings[clientId];
}
function getSettings(state) {
  return state.settings;
}
function isLastBlockChangePersistent(state) {
  return state.blocks.isPersistentChange;
}
const __experimentalGetBlockListSettingsForBlocks = (0,external_wp_data_namespaceObject.createSelector)(
  (state, clientIds = []) => {
    return clientIds.reduce((blockListSettingsForBlocks, clientId) => {
      if (!state.blockListSettings[clientId]) {
        return blockListSettingsForBlocks;
      }
      return {
        ...blockListSettingsForBlocks,
        [clientId]: state.blockListSettings[clientId]
      };
    }, {});
  },
  (state) => [state.blockListSettings]
);
const __experimentalGetReusableBlockTitle = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state, ref) => {
      external_wp_deprecated_default()(
        "wp.data.select( 'core/block-editor' ).__experimentalGetReusableBlockTitle",
        {
          since: "6.6",
          version: "6.8"
        }
      );
      const reusableBlock = unlock(select(STORE_NAME)).getReusableBlocks().find((block) => block.id === ref);
      if (!reusableBlock) {
        return null;
      }
      return reusableBlock.title?.raw;
    },
    () => [unlock(select(STORE_NAME)).getReusableBlocks()]
  )
);
function __unstableIsLastBlockChangeIgnored(state) {
  return state.blocks.isIgnoredChange;
}
function __experimentalGetLastBlockAttributeChanges(state) {
  return state.lastBlockAttributesChange;
}
function hasBlockMovingClientId() {
  external_wp_deprecated_default()(
    'wp.data.select( "core/block-editor" ).hasBlockMovingClientId',
    {
      since: "6.7",
      hint: "Block moving mode feature has been removed"
    }
  );
  return false;
}
function didAutomaticChange(state) {
  return !!state.automaticChangeStatus;
}
function isBlockHighlighted(state, clientId) {
  return state.highlightedBlock === clientId;
}
function areInnerBlocksControlled(state, clientId) {
  return !!state.blocks.controlledInnerBlocks[clientId];
}
const __experimentalGetActiveBlockIdByBlockNames = (0,external_wp_data_namespaceObject.createSelector)(
  (state, validBlockNames) => {
    if (!validBlockNames.length) {
      return null;
    }
    const selectedBlockClientId = getSelectedBlockClientId(state);
    if (validBlockNames.includes(
      getBlockName(state, selectedBlockClientId)
    )) {
      return selectedBlockClientId;
    }
    const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
    const entityAreaParents = getBlockParentsByBlockName(
      state,
      selectedBlockClientId || multiSelectedBlockClientIds[0],
      validBlockNames
    );
    if (entityAreaParents) {
      return entityAreaParents[entityAreaParents.length - 1];
    }
    return null;
  },
  (state, validBlockNames) => [
    state.selection.selectionStart.clientId,
    state.selection.selectionEnd.clientId,
    validBlockNames
  ]
);
function wasBlockJustInserted(state, clientId, source) {
  const { lastBlockInserted } = state;
  return lastBlockInserted.clientIds?.includes(clientId) && lastBlockInserted.source === source;
}
function isBlockVisible(state, clientId) {
  return state.blockVisibility?.[clientId] ?? true;
}
function getHoveredBlockClientId() {
  external_wp_deprecated_default()(
    "wp.data.select( 'core/block-editor' ).getHoveredBlockClientId",
    {
      since: "6.9",
      version: "7.1"
    }
  );
  return void 0;
}
const __unstableGetVisibleBlocks = (0,external_wp_data_namespaceObject.createSelector)(
  (state) => {
    const visibleBlocks = new Set(
      Object.keys(state.blockVisibility).filter(
        (key) => state.blockVisibility[key]
      )
    );
    if (visibleBlocks.size === 0) {
      return EMPTY_SET;
    }
    return visibleBlocks;
  },
  (state) => [state.blockVisibility]
);
function __unstableHasActiveBlockOverlayActive(state, clientId) {
  if (getBlockEditingMode(state, clientId) !== "default") {
    return false;
  }
  if (!canEditBlock(state, clientId)) {
    return true;
  }
  if (isZoomOut(state)) {
    const sectionRootClientId = getSectionRootClientId(state);
    if (sectionRootClientId) {
      const sectionClientIds = getBlockOrder(
        state,
        sectionRootClientId
      );
      if (sectionClientIds?.includes(clientId)) {
        return true;
      }
    } else if (clientId && !getBlockRootClientId(state, clientId)) {
      return true;
    }
  }
  const blockSupportDisable = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(
    getBlockName(state, clientId),
    "__experimentalDisableBlockOverlay",
    false
  );
  const shouldEnableIfUnselected = blockSupportDisable ? false : areInnerBlocksControlled(state, clientId);
  return shouldEnableIfUnselected && !isBlockSelected(state, clientId) && !hasSelectedInnerBlock(state, clientId, true);
}
function __unstableIsWithinBlockOverlay(state, clientId) {
  let parent = state.blocks.parents.get(clientId);
  while (!!parent) {
    if (__unstableHasActiveBlockOverlayActive(state, parent)) {
      return true;
    }
    parent = state.blocks.parents.get(parent);
  }
  return false;
}
function getBlockEditingMode(state, clientId = "") {
  if (clientId === null) {
    clientId = "";
  }
  if (state.derivedBlockEditingModes?.has(clientId)) {
    return state.derivedBlockEditingModes.get(clientId);
  }
  if (state.blockEditingModes.has(clientId)) {
    return state.blockEditingModes.get(clientId);
  }
  return "default";
}
const isUngroupable = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (state, clientId = "") => {
    const _clientId = clientId || getSelectedBlockClientId(state);
    if (!_clientId) {
      return false;
    }
    const { getGroupingBlockName } = select(external_wp_blocks_namespaceObject.store);
    const block = getBlock(state, _clientId);
    const groupingBlockName = getGroupingBlockName();
    const _isUngroupable = block && (block.name === groupingBlockName || (0,external_wp_blocks_namespaceObject.getBlockType)(block.name)?.transforms?.ungroup) && !!block.innerBlocks.length;
    return _isUngroupable && canRemoveBlock(state, _clientId);
  }
);
const isGroupable = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (state, clientIds = selectors_EMPTY_ARRAY) => {
    const { getGroupingBlockName } = select(external_wp_blocks_namespaceObject.store);
    const groupingBlockName = getGroupingBlockName();
    const _clientIds = clientIds?.length ? clientIds : getSelectedBlockClientIds(state);
    const rootClientId = _clientIds?.length ? getBlockRootClientId(state, _clientIds[0]) : void 0;
    const groupingBlockAvailable = canInsertBlockType(
      state,
      groupingBlockName,
      rootClientId
    );
    const _isGroupable = groupingBlockAvailable && _clientIds.length;
    return _isGroupable && canRemoveBlocks(state, _clientIds);
  }
);
const __unstableGetContentLockingParent = (state, clientId) => {
  external_wp_deprecated_default()(
    "wp.data.select( 'core/block-editor' ).__unstableGetContentLockingParent",
    {
      since: "6.1",
      version: "6.7"
    }
  );
  return getContentLockingParent(state, clientId);
};
function __unstableGetTemporarilyEditingAsBlocks(state) {
  external_wp_deprecated_default()(
    "wp.data.select( 'core/block-editor' ).__unstableGetTemporarilyEditingAsBlocks",
    {
      since: "6.1",
      version: "6.7"
    }
  );
  return getTemporarilyEditingAsBlocks(state);
}
function __unstableGetTemporarilyEditingFocusModeToRevert(state) {
  external_wp_deprecated_default()(
    "wp.data.select( 'core/block-editor' ).__unstableGetTemporarilyEditingFocusModeToRevert",
    {
      since: "6.5",
      version: "6.7"
    }
  );
  return getTemporarilyEditingFocusModeToRevert(state);
}


;// external ["wp","a11y"]
const external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js






const castArray = (maybeArray) => Array.isArray(maybeArray) ? maybeArray : [maybeArray];
const privateSettings = [
  "inserterMediaCategories",
  "blockInspectorAnimation",
  "mediaSideload"
];
function __experimentalUpdateSettings(settings, { stripExperimentalSettings = false, reset = false } = {}) {
  let incomingSettings = settings;
  if (Object.hasOwn(incomingSettings, "__unstableIsPreviewMode")) {
    external_wp_deprecated_default()(
      "__unstableIsPreviewMode argument in wp.data.dispatch('core/block-editor').updateSettings",
      {
        since: "6.8",
        alternative: "isPreviewMode"
      }
    );
    incomingSettings = { ...incomingSettings };
    incomingSettings.isPreviewMode = incomingSettings.__unstableIsPreviewMode;
    delete incomingSettings.__unstableIsPreviewMode;
  }
  let cleanSettings = incomingSettings;
  if (stripExperimentalSettings && external_wp_element_namespaceObject.Platform.OS === "web") {
    cleanSettings = {};
    for (const key in incomingSettings) {
      if (!privateSettings.includes(key)) {
        cleanSettings[key] = incomingSettings[key];
      }
    }
  }
  return {
    type: "UPDATE_SETTINGS",
    settings: cleanSettings,
    reset
  };
}
function hideBlockInterface() {
  return {
    type: "HIDE_BLOCK_INTERFACE"
  };
}
function showBlockInterface() {
  return {
    type: "SHOW_BLOCK_INTERFACE"
  };
}
const privateRemoveBlocks = (clientIds, selectPrevious = true, forceRemove = false) => ({ select, dispatch, registry }) => {
  if (!clientIds || !clientIds.length) {
    return;
  }
  clientIds = castArray(clientIds);
  const canRemoveBlocks = select.canRemoveBlocks(clientIds);
  if (!canRemoveBlocks) {
    return;
  }
  const rules = !forceRemove && select.getBlockRemovalRules();
  if (rules) {
    let flattenBlocks2 = function(blocks) {
      const result = [];
      const stack = [...blocks];
      while (stack.length) {
        const { innerBlocks, ...block } = stack.shift();
        stack.push(...innerBlocks);
        result.push(block);
      }
      return result;
    };
    var flattenBlocks = flattenBlocks2;
    const blockList = clientIds.map(select.getBlock);
    const flattenedBlocks = flattenBlocks2(blockList);
    let message;
    for (const rule of rules) {
      message = rule.callback(flattenedBlocks);
      if (message) {
        dispatch(
          displayBlockRemovalPrompt(
            clientIds,
            selectPrevious,
            message
          )
        );
        return;
      }
    }
  }
  if (selectPrevious) {
    dispatch.selectPreviousBlock(clientIds[0], selectPrevious);
  }
  registry.batch(() => {
    dispatch({ type: "REMOVE_BLOCKS", clientIds });
    dispatch(ensureDefaultBlock());
  });
};
const ensureDefaultBlock = () => ({ select, dispatch }) => {
  const count = select.getBlockCount();
  if (count > 0) {
    return;
  }
  const { __unstableHasCustomAppender } = select.getSettings();
  if (__unstableHasCustomAppender) {
    return;
  }
  dispatch.insertDefaultBlock();
};
function displayBlockRemovalPrompt(clientIds, selectPrevious, message) {
  return {
    type: "DISPLAY_BLOCK_REMOVAL_PROMPT",
    clientIds,
    selectPrevious,
    message
  };
}
function clearBlockRemovalPrompt() {
  return {
    type: "CLEAR_BLOCK_REMOVAL_PROMPT"
  };
}
function setBlockRemovalRules(rules = false) {
  return {
    type: "SET_BLOCK_REMOVAL_RULES",
    rules
  };
}
function setOpenedBlockSettingsMenu(clientId) {
  return {
    type: "SET_OPENED_BLOCK_SETTINGS_MENU",
    clientId
  };
}
function setStyleOverride(id, style) {
  return {
    type: "SET_STYLE_OVERRIDE",
    id,
    style
  };
}
function deleteStyleOverride(id) {
  return {
    type: "DELETE_STYLE_OVERRIDE",
    id
  };
}
function setLastFocus(lastFocus = null) {
  return {
    type: "LAST_FOCUS",
    lastFocus
  };
}
function stopEditingAsBlocks(clientId) {
  return ({ select, dispatch, registry }) => {
    const focusModeToRevert = unlock(
      registry.select(store)
    ).getTemporarilyEditingFocusModeToRevert();
    dispatch.__unstableMarkNextChangeAsNotPersistent();
    dispatch.updateBlockAttributes(clientId, {
      templateLock: "contentOnly"
    });
    dispatch.updateBlockListSettings(clientId, {
      ...select.getBlockListSettings(clientId),
      templateLock: "contentOnly"
    });
    dispatch.updateSettings({ focusMode: focusModeToRevert });
    dispatch.__unstableSetTemporarilyEditingAsBlocks();
  };
}
function startDragging() {
  return {
    type: "START_DRAGGING"
  };
}
function stopDragging() {
  return {
    type: "STOP_DRAGGING"
  };
}
function expandBlock(clientId) {
  return {
    type: "SET_BLOCK_EXPANDED_IN_LIST_VIEW",
    clientId
  };
}
function setInsertionPoint(value) {
  return {
    type: "SET_INSERTION_POINT",
    value
  };
}
const modifyContentLockBlock = (clientId) => ({ select, dispatch }) => {
  dispatch.selectBlock(clientId);
  dispatch.__unstableMarkNextChangeAsNotPersistent();
  dispatch.updateBlockAttributes(clientId, {
    templateLock: void 0
  });
  dispatch.updateBlockListSettings(clientId, {
    ...select.getBlockListSettings(clientId),
    templateLock: false
  });
  const focusModeToRevert = select.getSettings().focusMode;
  dispatch.updateSettings({ focusMode: true });
  dispatch.__unstableSetTemporarilyEditingAsBlocks(
    clientId,
    focusModeToRevert
  );
};
const setZoomLevel = (zoom = 100) => ({ select, dispatch }) => {
  if (zoom !== 100) {
    const firstSelectedClientId = select.getBlockSelectionStart();
    const sectionRootClientId = select.getSectionRootClientId();
    if (firstSelectedClientId) {
      let sectionClientId;
      if (sectionRootClientId) {
        const sectionClientIds = select.getBlockOrder(sectionRootClientId);
        if (sectionClientIds?.includes(firstSelectedClientId)) {
          sectionClientId = firstSelectedClientId;
        } else {
          sectionClientId = select.getBlockParents(firstSelectedClientId).find(
            (parent) => sectionClientIds.includes(parent)
          );
        }
      } else {
        sectionClientId = select.getBlockHierarchyRootClientId(
          firstSelectedClientId
        );
      }
      if (sectionClientId) {
        dispatch.selectBlock(sectionClientId);
      } else {
        dispatch.clearSelectedBlock();
      }
      (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)("You are currently in zoom-out mode."));
    }
  }
  dispatch({
    type: "SET_ZOOM_LEVEL",
    zoom
  });
};
function resetZoomLevel() {
  return {
    type: "RESET_ZOOM_LEVEL"
  };
}
function toggleBlockSpotlight(clientId, hasBlockSpotlight) {
  return {
    type: "TOGGLE_BLOCK_SPOTLIGHT",
    clientId,
    hasBlockSpotlight
  };
}


;// external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// external ["wp","preferences"]
const external_wp_preferences_namespaceObject = window["wp"]["preferences"];
;// ./node_modules/@wordpress/block-editor/build-module/utils/selection.js

const START_OF_SELECTED_AREA = "\x86";
function retrieveSelectedAttribute(blockAttributes) {
  if (!blockAttributes) {
    return;
  }
  return Object.keys(blockAttributes).find((name) => {
    const value = blockAttributes[name];
    return (typeof value === "string" || value instanceof external_wp_richText_namespaceObject.RichTextData) && // To do: refactor this to use rich text's selection instead, so we
    // no longer have to use on this hack inserting a special character.
    value.toString().indexOf(START_OF_SELECTED_AREA) !== -1;
  });
}
function findRichTextAttributeKey(blockType) {
  for (const [key, value] of Object.entries(blockType.attributes)) {
    if (value.source === "rich-text" || value.source === "html") {
      return key;
    }
  }
}


;// ./node_modules/@wordpress/block-editor/build-module/store/actions.js









const actions_castArray = (maybeArray) => Array.isArray(maybeArray) ? maybeArray : [maybeArray];
const resetBlocks = (blocks) => ({ dispatch }) => {
  dispatch({ type: "RESET_BLOCKS", blocks });
  dispatch(validateBlocksToTemplate(blocks));
};
const validateBlocksToTemplate = (blocks) => ({ select, dispatch }) => {
  const template = select.getTemplate();
  const templateLock = select.getTemplateLock();
  const isBlocksValidToTemplate = !template || templateLock !== "all" || (0,external_wp_blocks_namespaceObject.doBlocksMatchTemplate)(blocks, template);
  const isValidTemplate = select.isValidTemplate();
  if (isBlocksValidToTemplate !== isValidTemplate) {
    dispatch.setTemplateValidity(isBlocksValidToTemplate);
    return isBlocksValidToTemplate;
  }
};
function resetSelection(selectionStart, selectionEnd, initialPosition) {
  return {
    type: "RESET_SELECTION",
    selectionStart,
    selectionEnd,
    initialPosition
  };
}
function receiveBlocks(blocks) {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).receiveBlocks', {
    since: "5.9",
    alternative: "resetBlocks or insertBlocks"
  });
  return {
    type: "RECEIVE_BLOCKS",
    blocks
  };
}
function updateBlockAttributes(clientIds, attributes, options = { uniqueByBlock: false }) {
  if (typeof options === "boolean") {
    options = { uniqueByBlock: options };
  }
  return {
    type: "UPDATE_BLOCK_ATTRIBUTES",
    clientIds: actions_castArray(clientIds),
    attributes,
    options
  };
}
function updateBlock(clientId, updates) {
  return {
    type: "UPDATE_BLOCK",
    clientId,
    updates
  };
}
function selectBlock(clientId, initialPosition = 0) {
  return {
    type: "SELECT_BLOCK",
    initialPosition,
    clientId
  };
}
function hoverBlock() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).hoverBlock', {
    since: "6.9",
    version: "7.1"
  });
  return {
    type: "DO_NOTHING"
  };
}
const selectPreviousBlock = (clientId, fallbackToParent = false) => ({ select, dispatch }) => {
  const previousBlockClientId = select.getPreviousBlockClientId(clientId);
  if (previousBlockClientId) {
    dispatch.selectBlock(previousBlockClientId, -1);
  } else if (fallbackToParent) {
    const firstParentClientId = select.getBlockRootClientId(clientId);
    if (firstParentClientId) {
      dispatch.selectBlock(firstParentClientId, -1);
    }
  }
};
const selectNextBlock = (clientId) => ({ select, dispatch }) => {
  const nextBlockClientId = select.getNextBlockClientId(clientId);
  if (nextBlockClientId) {
    dispatch.selectBlock(nextBlockClientId);
  }
};
function startMultiSelect() {
  return {
    type: "START_MULTI_SELECT"
  };
}
function stopMultiSelect() {
  return {
    type: "STOP_MULTI_SELECT"
  };
}
const multiSelect = (start, end, __experimentalInitialPosition = 0) => ({ select, dispatch }) => {
  const startBlockRootClientId = select.getBlockRootClientId(start);
  const endBlockRootClientId = select.getBlockRootClientId(end);
  if (startBlockRootClientId !== endBlockRootClientId) {
    return;
  }
  dispatch({
    type: "MULTI_SELECT",
    start,
    end,
    initialPosition: __experimentalInitialPosition
  });
  const blockCount = select.getSelectedBlockCount();
  (0,external_wp_a11y_namespaceObject.speak)(
    (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: %s: number of selected blocks */
      (0,external_wp_i18n_namespaceObject._n)("%s block selected.", "%s blocks selected.", blockCount),
      blockCount
    ),
    "assertive"
  );
};
function clearSelectedBlock() {
  return {
    type: "CLEAR_SELECTED_BLOCK"
  };
}
function toggleSelection(isSelectionEnabled = true) {
  return {
    type: "TOGGLE_SELECTION",
    isSelectionEnabled
  };
}
const replaceBlocks = (clientIds, blocks, indexToSelect, initialPosition = 0, meta) => ({ select, dispatch, registry }) => {
  clientIds = actions_castArray(clientIds);
  blocks = actions_castArray(blocks);
  const rootClientId = select.getBlockRootClientId(clientIds[0]);
  for (let index = 0; index < blocks.length; index++) {
    const block = blocks[index];
    const canInsertBlock = select.canInsertBlockType(
      block.name,
      rootClientId
    );
    if (!canInsertBlock) {
      return;
    }
  }
  registry.batch(() => {
    dispatch({
      type: "REPLACE_BLOCKS",
      clientIds,
      blocks,
      time: Date.now(),
      indexToSelect,
      initialPosition,
      meta
    });
    dispatch.ensureDefaultBlock();
  });
};
function replaceBlock(clientId, block) {
  return replaceBlocks(clientId, block);
}
const createOnMove = (type) => (clientIds, rootClientId) => ({ select, dispatch }) => {
  const canMoveBlocks = select.canMoveBlocks(clientIds);
  if (!canMoveBlocks) {
    return;
  }
  dispatch({ type, clientIds: actions_castArray(clientIds), rootClientId });
};
const moveBlocksDown = createOnMove("MOVE_BLOCKS_DOWN");
const moveBlocksUp = createOnMove("MOVE_BLOCKS_UP");
const moveBlocksToPosition = (clientIds, fromRootClientId = "", toRootClientId = "", index) => ({ select, dispatch }) => {
  const canMoveBlocks = select.canMoveBlocks(clientIds);
  if (!canMoveBlocks) {
    return;
  }
  if (fromRootClientId !== toRootClientId) {
    const canRemoveBlocks = select.canRemoveBlocks(clientIds);
    if (!canRemoveBlocks) {
      return;
    }
    const canInsertBlocks = select.canInsertBlocks(
      clientIds,
      toRootClientId
    );
    if (!canInsertBlocks) {
      return;
    }
  }
  dispatch({
    type: "MOVE_BLOCKS_TO_POSITION",
    fromRootClientId,
    toRootClientId,
    clientIds,
    index
  });
};
function moveBlockToPosition(clientId, fromRootClientId = "", toRootClientId = "", index) {
  return moveBlocksToPosition(
    [clientId],
    fromRootClientId,
    toRootClientId,
    index
  );
}
function insertBlock(block, index, rootClientId, updateSelection, meta) {
  return insertBlocks(
    [block],
    index,
    rootClientId,
    updateSelection,
    0,
    meta
  );
}
const insertBlocks = (blocks, index, rootClientId, updateSelection = true, initialPosition = 0, meta) => ({ select, dispatch }) => {
  if (initialPosition !== null && typeof initialPosition === "object") {
    meta = initialPosition;
    initialPosition = 0;
    external_wp_deprecated_default()(
      "meta argument in wp.data.dispatch('core/block-editor')",
      {
        since: "5.8",
        hint: "The meta argument is now the 6th argument of the function"
      }
    );
  }
  blocks = actions_castArray(blocks);
  const allowedBlocks = [];
  for (const block of blocks) {
    const isValid = select.canInsertBlockType(
      block.name,
      rootClientId
    );
    if (isValid) {
      allowedBlocks.push(block);
    }
  }
  if (allowedBlocks.length) {
    dispatch({
      type: "INSERT_BLOCKS",
      blocks: allowedBlocks,
      index,
      rootClientId,
      time: Date.now(),
      updateSelection,
      initialPosition: updateSelection ? initialPosition : null,
      meta
    });
  }
};
function showInsertionPoint(rootClientId, index, __unstableOptions = {}) {
  const { __unstableWithInserter, operation, nearestSide } = __unstableOptions;
  return {
    type: "SHOW_INSERTION_POINT",
    rootClientId,
    index,
    __unstableWithInserter,
    operation,
    nearestSide
  };
}
const hideInsertionPoint = () => ({ select, dispatch }) => {
  if (!select.isBlockInsertionPointVisible()) {
    return;
  }
  dispatch({
    type: "HIDE_INSERTION_POINT"
  });
};
function setTemplateValidity(isValid) {
  return {
    type: "SET_TEMPLATE_VALIDITY",
    isValid
  };
}
const synchronizeTemplate = () => ({ select, dispatch }) => {
  dispatch({ type: "SYNCHRONIZE_TEMPLATE" });
  const blocks = select.getBlocks();
  const template = select.getTemplate();
  const updatedBlockList = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(
    blocks,
    template
  );
  dispatch.resetBlocks(updatedBlockList);
};
const __unstableDeleteSelection = (isForward) => ({ registry, select, dispatch }) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return;
  }
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === "undefined" || typeof selectionFocus.offset === "undefined") {
    return false;
  }
  const anchorRootClientId = select.getBlockRootClientId(
    selectionAnchor.clientId
  );
  const focusRootClientId = select.getBlockRootClientId(
    selectionFocus.clientId
  );
  if (anchorRootClientId !== focusRootClientId) {
    return;
  }
  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const targetSelection = isForward ? selectionEnd : selectionStart;
  const targetBlock = select.getBlock(targetSelection.clientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlock.name);
  if (!targetBlockType.merge) {
    return;
  }
  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockB = select.getBlock(selectionB.clientId);
  const htmlA = blockA.attributes[selectionA.attributeKey];
  const htmlB = blockB.attributes[selectionB.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({ html: htmlA });
  let valueB = (0,external_wp_richText_namespaceObject.create)({ html: htmlB });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.insert)(valueB, START_OF_SELECTED_AREA, 0, selectionB.offset);
  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA, {
    [selectionA.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({ value: valueA })
  });
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB, {
    [selectionB.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({ value: valueB })
  });
  const followingBlock = isForward ? cloneA : cloneB;
  const blocksWithTheSameType = blockA.name === blockB.name ? [followingBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(followingBlock, targetBlockType.name);
  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  }
  let updatedAttributes;
  if (isForward) {
    const blockToMerge = blocksWithTheSameType.pop();
    updatedAttributes = targetBlockType.merge(
      blockToMerge.attributes,
      cloneB.attributes
    );
  } else {
    const blockToMerge = blocksWithTheSameType.shift();
    updatedAttributes = targetBlockType.merge(
      cloneA.attributes,
      blockToMerge.attributes
    );
  }
  const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
  const convertedHtml = updatedAttributes[newAttributeKey];
  const convertedValue = (0,external_wp_richText_namespaceObject.create)({ html: convertedHtml });
  const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
  const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
  const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({ value: newValue });
  updatedAttributes[newAttributeKey] = newHtml;
  const selectedBlockClientIds = select.getSelectedBlockClientIds();
  const replacement = [
    ...isForward ? blocksWithTheSameType : [],
    {
      // Preserve the original client ID.
      ...targetBlock,
      attributes: {
        ...targetBlock.attributes,
        ...updatedAttributes
      }
    },
    ...isForward ? [] : blocksWithTheSameType
  ];
  registry.batch(() => {
    dispatch.selectionChange(
      targetBlock.clientId,
      newAttributeKey,
      newOffset,
      newOffset
    );
    dispatch.replaceBlocks(
      selectedBlockClientIds,
      replacement,
      0,
      // If we don't pass the `indexToSelect` it will default to the last block.
      select.getSelectedBlocksInitialCaretPosition()
    );
  });
};
const __unstableSplitSelection = (blocks = []) => ({ registry, select, dispatch }) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  const anchorRootClientId = select.getBlockRootClientId(
    selectionAnchor.clientId
  );
  const focusRootClientId = select.getBlockRootClientId(
    selectionFocus.clientId
  );
  if (anchorRootClientId !== focusRootClientId) {
    return;
  }
  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockB = select.getBlock(selectionB.clientId);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const attributeKeyA = typeof selectionA.attributeKey === "string" ? selectionA.attributeKey : findRichTextAttributeKey(blockAType);
  const attributeKeyB = typeof selectionB.attributeKey === "string" ? selectionB.attributeKey : findRichTextAttributeKey(blockBType);
  const blockAttributes = select.getBlockAttributes(
    selectionA.clientId
  );
  const bindings = blockAttributes?.metadata?.bindings;
  if (bindings?.[attributeKeyA]) {
    if (blocks.length) {
      const { createWarningNotice } = registry.dispatch(external_wp_notices_namespaceObject.store);
      createWarningNotice(
        (0,external_wp_i18n_namespaceObject.__)(
          "Blocks can't be inserted into other blocks with bindings"
        ),
        {
          type: "snackbar"
        }
      );
      return;
    }
    dispatch.insertAfterBlock(selectionA.clientId);
    return;
  }
  if (!attributeKeyA || !attributeKeyB || typeof selectionAnchor.offset === "undefined" || typeof selectionFocus.offset === "undefined") {
    return;
  }
  if (selectionA.clientId === selectionB.clientId && attributeKeyA === attributeKeyB && selectionA.offset === selectionB.offset) {
    if (blocks.length) {
      if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockA)) {
        dispatch.replaceBlocks(
          [selectionA.clientId],
          blocks,
          blocks.length - 1,
          -1
        );
        return;
      }
    } else if (!select.getBlockOrder(selectionA.clientId).length) {
      let createEmpty2 = function() {
        const defaultBlockName2 = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();
        return select.canInsertBlockType(
          defaultBlockName2,
          anchorRootClientId
        ) ? (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName2) : (0,external_wp_blocks_namespaceObject.createBlock)(
          select.getBlockName(selectionA.clientId)
        );
      };
      var createEmpty = createEmpty2;
      const length = blockAttributes[attributeKeyA].length;
      if (selectionA.offset === 0 && length) {
        dispatch.insertBlocks(
          [createEmpty2()],
          select.getBlockIndex(selectionA.clientId),
          anchorRootClientId,
          false
        );
        return;
      }
      if (selectionA.offset === length) {
        dispatch.insertBlocks(
          [createEmpty2()],
          select.getBlockIndex(selectionA.clientId) + 1,
          anchorRootClientId
        );
        return;
      }
    }
  }
  const htmlA = blockA.attributes[attributeKeyA];
  const htmlB = blockB.attributes[attributeKeyB];
  let valueA = (0,external_wp_richText_namespaceObject.create)({ html: htmlA });
  let valueB = (0,external_wp_richText_namespaceObject.create)({ html: htmlB });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, 0, selectionB.offset);
  let head = {
    // Preserve the original client ID.
    ...blockA,
    // If both start and end are the same, should only copy innerBlocks
    // once.
    innerBlocks: blockA.clientId === blockB.clientId ? [] : blockA.innerBlocks,
    attributes: {
      ...blockA.attributes,
      [attributeKeyA]: (0,external_wp_richText_namespaceObject.toHTMLString)({ value: valueA })
    }
  };
  let tail = {
    ...blockB,
    // Only preserve the original client ID if the end is different.
    clientId: blockA.clientId === blockB.clientId ? (0,external_wp_blocks_namespaceObject.createBlock)(blockB.name).clientId : blockB.clientId,
    attributes: {
      ...blockB.attributes,
      [attributeKeyB]: (0,external_wp_richText_namespaceObject.toHTMLString)({ value: valueB })
    }
  };
  const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();
  if (
    // A block is only split when the selection is within the same
    // block.
    blockA.clientId === blockB.clientId && defaultBlockName && tail.name !== defaultBlockName && select.canInsertBlockType(defaultBlockName, anchorRootClientId)
  ) {
    const switched = (0,external_wp_blocks_namespaceObject.switchToBlockType)(tail, defaultBlockName);
    if (switched?.length === 1) {
      tail = switched[0];
    }
  }
  if (!blocks.length) {
    dispatch.replaceBlocks(select.getSelectedBlockClientIds(), [
      head,
      tail
    ]);
    return;
  }
  let selection;
  const output = [];
  const clonedBlocks = [...blocks];
  const firstBlock = clonedBlocks.shift();
  const headType = (0,external_wp_blocks_namespaceObject.getBlockType)(head.name);
  const firstBlocks = headType.merge && firstBlock.name === headType.name ? [firstBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(firstBlock, headType.name);
  if (firstBlocks?.length) {
    const first = firstBlocks.shift();
    head = {
      ...head,
      attributes: {
        ...head.attributes,
        ...headType.merge(head.attributes, first.attributes)
      }
    };
    output.push(head);
    selection = {
      clientId: head.clientId,
      attributeKey: attributeKeyA,
      offset: (0,external_wp_richText_namespaceObject.create)({ html: head.attributes[attributeKeyA] }).text.length
    };
    clonedBlocks.unshift(...firstBlocks);
  } else {
    if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(head)) {
      output.push(head);
    }
    output.push(firstBlock);
  }
  const lastBlock = clonedBlocks.pop();
  const tailType = (0,external_wp_blocks_namespaceObject.getBlockType)(tail.name);
  if (clonedBlocks.length) {
    output.push(...clonedBlocks);
  }
  if (lastBlock) {
    const lastBlocks = tailType.merge && tailType.name === lastBlock.name ? [lastBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(lastBlock, tailType.name);
    if (lastBlocks?.length) {
      const last = lastBlocks.pop();
      output.push({
        ...tail,
        attributes: {
          ...tail.attributes,
          ...tailType.merge(last.attributes, tail.attributes)
        }
      });
      output.push(...lastBlocks);
      selection = {
        clientId: tail.clientId,
        attributeKey: attributeKeyB,
        offset: (0,external_wp_richText_namespaceObject.create)({
          html: last.attributes[attributeKeyB]
        }).text.length
      };
    } else {
      output.push(lastBlock);
      if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(tail)) {
        output.push(tail);
      }
    }
  } else if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(tail)) {
    output.push(tail);
  }
  registry.batch(() => {
    dispatch.replaceBlocks(
      select.getSelectedBlockClientIds(),
      output,
      output.length - 1,
      0
    );
    if (selection) {
      dispatch.selectionChange(
        selection.clientId,
        selection.attributeKey,
        selection.offset,
        selection.offset
      );
    }
  });
};
const __unstableExpandSelection = () => ({ select, dispatch }) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  dispatch.selectionChange({
    start: { clientId: selectionAnchor.clientId },
    end: { clientId: selectionFocus.clientId }
  });
};
const mergeBlocks = (firstBlockClientId, secondBlockClientId) => ({ registry, select, dispatch }) => {
  const clientIdA = firstBlockClientId;
  const clientIdB = secondBlockClientId;
  const blockA = select.getBlock(clientIdA);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  if (!blockAType || select.getBlockEditingMode(clientIdA) === "disabled" || select.getBlockEditingMode(clientIdB) === "disabled") {
    return;
  }
  const blockB = select.getBlock(clientIdB);
  if (!blockAType.merge && (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockA.name, "__experimentalOnMerge")) {
    const blocksWithTheSameType2 = (0,external_wp_blocks_namespaceObject.switchToBlockType)(
      blockB,
      blockAType.name
    );
    if (blocksWithTheSameType2?.length !== 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }
    const [blockWithSameType] = blocksWithTheSameType2;
    if (blockWithSameType.innerBlocks.length < 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }
    registry.batch(() => {
      dispatch.insertBlocks(
        blockWithSameType.innerBlocks,
        void 0,
        clientIdA
      );
      dispatch.removeBlock(clientIdB);
      dispatch.selectBlock(
        blockWithSameType.innerBlocks[0].clientId
      );
      const nextBlockClientId = select.getNextBlockClientId(clientIdA);
      if (nextBlockClientId && select.getBlockName(clientIdA) === select.getBlockName(nextBlockClientId)) {
        const rootAttributes = select.getBlockAttributes(clientIdA);
        const previousRootAttributes = select.getBlockAttributes(nextBlockClientId);
        if (Object.keys(rootAttributes).every(
          (key) => rootAttributes[key] === previousRootAttributes[key]
        )) {
          dispatch.moveBlocksToPosition(
            select.getBlockOrder(nextBlockClientId),
            nextBlockClientId,
            clientIdA
          );
          dispatch.removeBlock(nextBlockClientId, false);
        }
      }
    });
    return;
  }
  if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockA)) {
    dispatch.removeBlock(
      clientIdA,
      select.isBlockSelected(clientIdA)
    );
    return;
  }
  if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockB)) {
    dispatch.removeBlock(
      clientIdB,
      select.isBlockSelected(clientIdB)
    );
    return;
  }
  if (!blockAType.merge) {
    if ((0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(blockB, "content")) {
      dispatch.removeBlock(
        clientIdB,
        select.isBlockSelected(clientIdB)
      );
    } else {
      dispatch.selectBlock(blockA.clientId);
    }
    return;
  }
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const { clientId, attributeKey, offset } = select.getSelectionStart();
  const selectedBlockType = clientId === clientIdA ? blockAType : blockBType;
  const attributeDefinition = selectedBlockType.attributes[attributeKey];
  const canRestoreTextSelection = (clientId === clientIdA || clientId === clientIdB) && attributeKey !== void 0 && offset !== void 0 && // We cannot restore text selection if the RichText identifier
  // is not a defined block attribute key. This can be the case if the
  // fallback instance ID is used to store selection (and no RichText
  // identifier is set), or when the identifier is wrong.
  !!attributeDefinition;
  if (!attributeDefinition) {
    if (typeof attributeKey === "number") {
      window.console.error(
        `RichText needs an identifier prop that is the block attribute key of the attribute it controls. Its type is expected to be a string, but was ${typeof attributeKey}`
      );
    } else {
      window.console.error(
        "The RichText identifier prop does not match any attributes defined by the block."
      );
    }
  }
  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA);
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB);
  if (canRestoreTextSelection) {
    const selectedBlock = clientId === clientIdA ? cloneA : cloneB;
    const html = selectedBlock.attributes[attributeKey];
    const value = (0,external_wp_richText_namespaceObject.insert)(
      (0,external_wp_richText_namespaceObject.create)({ html }),
      START_OF_SELECTED_AREA,
      offset,
      offset
    );
    selectedBlock.attributes[attributeKey] = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value
    });
  }
  const blocksWithTheSameType = blockA.name === blockB.name ? [cloneB] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(cloneB, blockA.name);
  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  }
  const updatedAttributes = blockAType.merge(
    cloneA.attributes,
    blocksWithTheSameType[0].attributes
  );
  if (canRestoreTextSelection) {
    const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
    const convertedHtml = updatedAttributes[newAttributeKey];
    const convertedValue = (0,external_wp_richText_namespaceObject.create)({ html: convertedHtml });
    const newOffset = convertedValue.text.indexOf(
      START_OF_SELECTED_AREA
    );
    const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
    const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({ value: newValue });
    updatedAttributes[newAttributeKey] = newHtml;
    dispatch.selectionChange(
      blockA.clientId,
      newAttributeKey,
      newOffset,
      newOffset
    );
  }
  dispatch.replaceBlocks(
    [blockA.clientId, blockB.clientId],
    [
      {
        ...blockA,
        attributes: {
          ...blockA.attributes,
          ...updatedAttributes
        }
      },
      ...blocksWithTheSameType.slice(1)
    ],
    0
    // If we don't pass the `indexToSelect` it will default to the last block.
  );
};
const removeBlocks = (clientIds, selectPrevious = true) => privateRemoveBlocks(clientIds, selectPrevious);
function removeBlock(clientId, selectPrevious) {
  return removeBlocks([clientId], selectPrevious);
}
function replaceInnerBlocks(rootClientId, blocks, updateSelection = false, initialPosition = 0) {
  return {
    type: "REPLACE_INNER_BLOCKS",
    rootClientId,
    blocks,
    updateSelection,
    initialPosition: updateSelection ? initialPosition : null,
    time: Date.now()
  };
}
function toggleBlockMode(clientId) {
  return {
    type: "TOGGLE_BLOCK_MODE",
    clientId
  };
}
function startTyping() {
  return {
    type: "START_TYPING"
  };
}
function stopTyping() {
  return {
    type: "STOP_TYPING"
  };
}
function startDraggingBlocks(clientIds = []) {
  return {
    type: "START_DRAGGING_BLOCKS",
    clientIds
  };
}
function stopDraggingBlocks() {
  return {
    type: "STOP_DRAGGING_BLOCKS"
  };
}
function enterFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).enterFormattedText', {
    since: "6.1",
    version: "6.3"
  });
  return {
    type: "DO_NOTHING"
  };
}
function exitFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).exitFormattedText', {
    since: "6.1",
    version: "6.3"
  });
  return {
    type: "DO_NOTHING"
  };
}
function selectionChange(clientId, attributeKey, startOffset, endOffset) {
  if (typeof clientId === "string") {
    return {
      type: "SELECTION_CHANGE",
      clientId,
      attributeKey,
      startOffset,
      endOffset
    };
  }
  return { type: "SELECTION_CHANGE", ...clientId };
}
const insertDefaultBlock = (attributes, rootClientId, index) => ({ dispatch }) => {
  const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();
  if (!defaultBlockName) {
    return;
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName, attributes);
  return dispatch.insertBlock(block, index, rootClientId);
};
function updateBlockListSettings(clientId, settings) {
  return {
    type: "UPDATE_BLOCK_LIST_SETTINGS",
    clientId,
    settings
  };
}
function updateSettings(settings) {
  return __experimentalUpdateSettings(settings, {
    stripExperimentalSettings: true
  });
}
function __unstableSaveReusableBlock(id, updatedId) {
  return {
    type: "SAVE_REUSABLE_BLOCK_SUCCESS",
    id,
    updatedId
  };
}
function __unstableMarkLastChangeAsPersistent() {
  return { type: "MARK_LAST_CHANGE_AS_PERSISTENT" };
}
function __unstableMarkNextChangeAsNotPersistent() {
  return { type: "MARK_NEXT_CHANGE_AS_NOT_PERSISTENT" };
}
const __unstableMarkAutomaticChange = () => ({ dispatch }) => {
  dispatch({ type: "MARK_AUTOMATIC_CHANGE" });
  const { requestIdleCallback = (cb) => setTimeout(cb, 100) } = window;
  requestIdleCallback(() => {
    dispatch({ type: "MARK_AUTOMATIC_CHANGE_FINAL" });
  });
};
const __unstableSetEditorMode = (mode) => ({ registry }) => {
  registry.dispatch(external_wp_preferences_namespaceObject.store).set("core", "editorTool", mode);
  if (mode === "navigation") {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)("You are currently in Write mode."));
  } else if (mode === "edit") {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)("You are currently in Design mode."));
  }
};
function setBlockMovingClientId() {
  external_wp_deprecated_default()(
    'wp.data.dispatch( "core/block-editor" ).setBlockMovingClientId',
    {
      since: "6.7",
      hint: "Block moving mode feature has been removed"
    }
  );
  return {
    type: "DO_NOTHING"
  };
}
const duplicateBlocks = (clientIds, updateSelection = true) => ({ select, dispatch }) => {
  if (!clientIds || !clientIds.length) {
    return;
  }
  const blocks = select.getBlocksByClientId(clientIds);
  if (blocks.some((block) => !block)) {
    return;
  }
  const blockNames = blocks.map((block) => block.name);
  if (blockNames.some(
    (blockName) => !(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, "multiple", true)
  )) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientIds[0]);
  const clientIdsArray = actions_castArray(clientIds);
  const lastSelectedIndex = select.getBlockIndex(
    clientIdsArray[clientIdsArray.length - 1]
  );
  const clonedBlocks = blocks.map(
    (block) => (0,external_wp_blocks_namespaceObject.__experimentalCloneSanitizedBlock)(block)
  );
  dispatch.insertBlocks(
    clonedBlocks,
    lastSelectedIndex + 1,
    rootClientId,
    updateSelection
  );
  if (clonedBlocks.length > 1 && updateSelection) {
    dispatch.multiSelect(
      clonedBlocks[0].clientId,
      clonedBlocks[clonedBlocks.length - 1].clientId
    );
  }
  return clonedBlocks.map((block) => block.clientId);
};
const insertBeforeBlock = (clientId) => ({ select, dispatch }) => {
  if (!clientId) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);
  if (isLocked) {
    return;
  }
  const blockIndex = select.getBlockIndex(clientId);
  const directInsertBlock = rootClientId ? select.getDirectInsertBlock(rootClientId) : null;
  if (!directInsertBlock) {
    return dispatch.insertDefaultBlock({}, rootClientId, blockIndex);
  }
  const copiedAttributes = {};
  if (directInsertBlock.attributesToCopy) {
    const attributes = select.getBlockAttributes(clientId);
    directInsertBlock.attributesToCopy.forEach((key) => {
      if (attributes[key]) {
        copiedAttributes[key] = attributes[key];
      }
    });
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(directInsertBlock.name, {
    ...directInsertBlock.attributes,
    ...copiedAttributes
  });
  return dispatch.insertBlock(block, blockIndex, rootClientId);
};
const insertAfterBlock = (clientId) => ({ select, dispatch }) => {
  if (!clientId) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);
  if (isLocked) {
    return;
  }
  const blockIndex = select.getBlockIndex(clientId);
  const directInsertBlock = rootClientId ? select.getDirectInsertBlock(rootClientId) : null;
  if (!directInsertBlock) {
    return dispatch.insertDefaultBlock(
      {},
      rootClientId,
      blockIndex + 1
    );
  }
  const copiedAttributes = {};
  if (directInsertBlock.attributesToCopy) {
    const attributes = select.getBlockAttributes(clientId);
    directInsertBlock.attributesToCopy.forEach((key) => {
      if (attributes[key]) {
        copiedAttributes[key] = attributes[key];
      }
    });
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(directInsertBlock.name, {
    ...directInsertBlock.attributes,
    ...copiedAttributes
  });
  return dispatch.insertBlock(block, blockIndex + 1, rootClientId);
};
function toggleBlockHighlight(clientId, isHighlighted) {
  return {
    type: "TOGGLE_BLOCK_HIGHLIGHT",
    clientId,
    isHighlighted
  };
}
const flashBlock = (clientId, timeout = 150) => async ({ dispatch }) => {
  dispatch(toggleBlockHighlight(clientId, true));
  await new Promise((resolve) => setTimeout(resolve, timeout));
  dispatch(toggleBlockHighlight(clientId, false));
};
function setHasControlledInnerBlocks(clientId, hasControlledInnerBlocks) {
  return {
    type: "SET_HAS_CONTROLLED_INNER_BLOCKS",
    hasControlledInnerBlocks,
    clientId
  };
}
function setBlockVisibility(updates) {
  return {
    type: "SET_BLOCK_VISIBILITY",
    updates
  };
}
function __unstableSetTemporarilyEditingAsBlocks(temporarilyEditingAsBlocks, focusModeToRevert) {
  return {
    type: "SET_TEMPORARILY_EDITING_AS_BLOCKS",
    temporarilyEditingAsBlocks,
    focusModeToRevert
  };
}
const registerInserterMediaCategory = (category) => ({ select, dispatch }) => {
  if (!category || typeof category !== "object") {
    console.error(
      "Category should be an `InserterMediaCategory` object."
    );
    return;
  }
  if (!category.name) {
    console.error(
      "Category should have a `name` that should be unique among all media categories."
    );
    return;
  }
  if (!category.labels?.name) {
    console.error("Category should have a `labels.name`.");
    return;
  }
  if (!["image", "audio", "video"].includes(category.mediaType)) {
    console.error(
      "Category should have `mediaType` property that is one of `image|audio|video`."
    );
    return;
  }
  if (!category.fetch || typeof category.fetch !== "function") {
    console.error(
      "Category should have a `fetch` function defined with the following signature `(InserterMediaRequest) => Promise<InserterMediaItem[]>`."
    );
    return;
  }
  const registeredInserterMediaCategories = select.getRegisteredInserterMediaCategories();
  if (registeredInserterMediaCategories.some(
    ({ name }) => name === category.name
  )) {
    console.error(
      `A category is already registered with the same name: "${category.name}".`
    );
    return;
  }
  if (registeredInserterMediaCategories.some(
    ({ labels: { name } = {} }) => name === category.labels?.name
  )) {
    console.error(
      `A category is already registered with the same labels.name: "${category.labels.name}".`
    );
    return;
  }
  dispatch({
    type: "REGISTER_INSERTER_MEDIA_CATEGORY",
    category: { ...category, isExternalResource: true }
  });
};
function setBlockEditingMode(clientId = "", mode) {
  return {
    type: "SET_BLOCK_EDITING_MODE",
    clientId,
    mode
  };
}
function unsetBlockEditingMode(clientId = "") {
  return {
    type: "UNSET_BLOCK_EDITING_MODE",
    clientId
  };
}


;// ./node_modules/@wordpress/block-editor/build-module/store/index.js








const storeConfig = {
  reducer: reducer_default,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
};
const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, {
  ...storeConfig,
  persist: ["preferences"]
});
const registeredStore = (0,external_wp_data_namespaceObject.registerStore)(STORE_NAME, {
  ...storeConfig,
  persist: ["preferences"]
});
unlock(registeredStore).registerPrivateActions(private_actions_namespaceObject);
unlock(registeredStore).registerPrivateSelectors(private_selectors_namespaceObject);
unlock(store).registerPrivateActions(private_actions_namespaceObject);
unlock(store).registerPrivateSelectors(private_selectors_namespaceObject);


;// ./node_modules/@wordpress/block-editor/build-module/components/use-settings/index.js





function use_settings_useSettings(...paths) {
  const { clientId = null } = useBlockEditContext();
  return (0,external_wp_data_namespaceObject.useSelect)(
    (select) => unlock(select(store)).getBlockSettings(
      clientId,
      ...paths
    ),
    [clientId, ...paths]
  );
}
function useSetting(path) {
  external_wp_deprecated_default()("wp.blockEditor.useSetting", {
    since: "6.5",
    alternative: "wp.blockEditor.useSettings",
    note: "The new useSettings function can retrieve multiple settings at once, with better performance."
  });
  const [value] = use_settings_useSettings(path);
  return value;
}


;// external ["wp","styleEngine"]
const external_wp_styleEngine_namespaceObject = window["wp"]["styleEngine"];
;// ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/fluid-utils.js
const DEFAULT_MAXIMUM_VIEWPORT_WIDTH = "1600px";
const DEFAULT_MINIMUM_VIEWPORT_WIDTH = "320px";
const DEFAULT_SCALE_FACTOR = 1;
const DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MIN = 0.25;
const DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MAX = 0.75;
const DEFAULT_MINIMUM_FONT_SIZE_LIMIT = "14px";
function getComputedFluidTypographyValue({
  minimumFontSize,
  maximumFontSize,
  fontSize,
  minimumViewportWidth = DEFAULT_MINIMUM_VIEWPORT_WIDTH,
  maximumViewportWidth = DEFAULT_MAXIMUM_VIEWPORT_WIDTH,
  scaleFactor = DEFAULT_SCALE_FACTOR,
  minimumFontSizeLimit
}) {
  minimumFontSizeLimit = !!getTypographyValueAndUnit(minimumFontSizeLimit) ? minimumFontSizeLimit : DEFAULT_MINIMUM_FONT_SIZE_LIMIT;
  if (fontSize) {
    const fontSizeParsed = getTypographyValueAndUnit(fontSize);
    if (!fontSizeParsed?.unit) {
      return null;
    }
    const minimumFontSizeLimitParsed = getTypographyValueAndUnit(
      minimumFontSizeLimit,
      {
        coerceTo: fontSizeParsed.unit
      }
    );
    if (!!minimumFontSizeLimitParsed?.value && !minimumFontSize && !maximumFontSize) {
      if (fontSizeParsed?.value <= minimumFontSizeLimitParsed?.value) {
        return null;
      }
    }
    if (!maximumFontSize) {
      maximumFontSize = `${fontSizeParsed.value}${fontSizeParsed.unit}`;
    }
    if (!minimumFontSize) {
      const fontSizeValueInPx = fontSizeParsed.unit === "px" ? fontSizeParsed.value : fontSizeParsed.value * 16;
      const minimumFontSizeFactor = Math.min(
        Math.max(
          1 - 0.075 * Math.log2(fontSizeValueInPx),
          DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MIN
        ),
        DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MAX
      );
      const calculatedMinimumFontSize = roundToPrecision(
        fontSizeParsed.value * minimumFontSizeFactor,
        3
      );
      if (!!minimumFontSizeLimitParsed?.value && calculatedMinimumFontSize < minimumFontSizeLimitParsed?.value) {
        minimumFontSize = `${minimumFontSizeLimitParsed.value}${minimumFontSizeLimitParsed.unit}`;
      } else {
        minimumFontSize = `${calculatedMinimumFontSize}${fontSizeParsed.unit}`;
      }
    }
  }
  const minimumFontSizeParsed = getTypographyValueAndUnit(minimumFontSize);
  const fontSizeUnit = minimumFontSizeParsed?.unit || "rem";
  const maximumFontSizeParsed = getTypographyValueAndUnit(maximumFontSize, {
    coerceTo: fontSizeUnit
  });
  if (!minimumFontSizeParsed || !maximumFontSizeParsed) {
    return null;
  }
  const minimumFontSizeRem = getTypographyValueAndUnit(minimumFontSize, {
    coerceTo: "rem"
  });
  const maximumViewportWidthParsed = getTypographyValueAndUnit(
    maximumViewportWidth,
    { coerceTo: fontSizeUnit }
  );
  const minimumViewportWidthParsed = getTypographyValueAndUnit(
    minimumViewportWidth,
    { coerceTo: fontSizeUnit }
  );
  if (!maximumViewportWidthParsed || !minimumViewportWidthParsed || !minimumFontSizeRem) {
    return null;
  }
  const linearDenominator = maximumViewportWidthParsed.value - minimumViewportWidthParsed.value;
  if (!linearDenominator) {
    return null;
  }
  const minViewportWidthOffsetValue = roundToPrecision(
    minimumViewportWidthParsed.value / 100,
    3
  );
  const viewportWidthOffset = roundToPrecision(minViewportWidthOffsetValue, 3) + fontSizeUnit;
  const linearFactor = 100 * ((maximumFontSizeParsed.value - minimumFontSizeParsed.value) / linearDenominator);
  const linearFactorScaled = roundToPrecision(
    (linearFactor || 1) * scaleFactor,
    3
  );
  const fluidTargetFontSize = `${minimumFontSizeRem.value}${minimumFontSizeRem.unit} + ((1vw - ${viewportWidthOffset}) * ${linearFactorScaled})`;
  return `clamp(${minimumFontSize}, ${fluidTargetFontSize}, ${maximumFontSize})`;
}
function getTypographyValueAndUnit(rawValue, options = {}) {
  if (typeof rawValue !== "string" && typeof rawValue !== "number") {
    return null;
  }
  if (isFinite(rawValue)) {
    rawValue = `${rawValue}px`;
  }
  const { coerceTo, rootSizeValue, acceptableUnits } = {
    coerceTo: "",
    // Default browser font size. Later we could inject some JS to compute this `getComputedStyle( document.querySelector( "html" ) ).fontSize`.
    rootSizeValue: 16,
    acceptableUnits: ["rem", "px", "em"],
    ...options
  };
  const acceptableUnitsGroup = acceptableUnits?.join("|");
  const regexUnits = new RegExp(
    `^(\\d*\\.?\\d+)(${acceptableUnitsGroup}){1,1}$`
  );
  const matches = rawValue.match(regexUnits);
  if (!matches || matches.length < 3) {
    return null;
  }
  let [, value, unit] = matches;
  let returnValue = parseFloat(value);
  if ("px" === coerceTo && ("em" === unit || "rem" === unit)) {
    returnValue = returnValue * rootSizeValue;
    unit = coerceTo;
  }
  if ("px" === unit && ("em" === coerceTo || "rem" === coerceTo)) {
    returnValue = returnValue / rootSizeValue;
    unit = coerceTo;
  }
  if (("em" === coerceTo || "rem" === coerceTo) && ("em" === unit || "rem" === unit)) {
    unit = coerceTo;
  }
  return {
    value: roundToPrecision(returnValue, 3),
    unit
  };
}
function roundToPrecision(value, digits = 3) {
  const base = Math.pow(10, digits);
  return Number.isFinite(value) ? parseFloat(Math.round(value * base) / base) : void 0;
}


;// ./node_modules/@wordpress/block-editor/build-module/utils/format-font-style.js

function formatFontStyle(fontStyle) {
  if (!fontStyle) {
    return {};
  }
  if (typeof fontStyle === "object") {
    return fontStyle;
  }
  let name;
  switch (fontStyle) {
    case "normal":
      name = (0,external_wp_i18n_namespaceObject._x)("Regular", "font style");
      break;
    case "italic":
      name = (0,external_wp_i18n_namespaceObject._x)("Italic", "font style");
      break;
    case "oblique":
      name = (0,external_wp_i18n_namespaceObject._x)("Oblique", "font style");
      break;
    default:
      name = fontStyle;
      break;
  }
  return { name, value: fontStyle };
}


;// ./node_modules/@wordpress/block-editor/build-module/utils/format-font-weight.js

function formatFontWeight(fontWeight) {
  if (!fontWeight) {
    return {};
  }
  if (typeof fontWeight === "object") {
    return fontWeight;
  }
  let name;
  switch (fontWeight) {
    case "normal":
    case "400":
      name = (0,external_wp_i18n_namespaceObject._x)("Regular", "font weight");
      break;
    case "bold":
    case "700":
      name = (0,external_wp_i18n_namespaceObject._x)("Bold", "font weight");
      break;
    case "100":
      name = (0,external_wp_i18n_namespaceObject._x)("Thin", "font weight");
      break;
    case "200":
      name = (0,external_wp_i18n_namespaceObject._x)("Extra Light", "font weight");
      break;
    case "300":
      name = (0,external_wp_i18n_namespaceObject._x)("Light", "font weight");
      break;
    case "500":
      name = (0,external_wp_i18n_namespaceObject._x)("Medium", "font weight");
      break;
    case "600":
      name = (0,external_wp_i18n_namespaceObject._x)("Semi Bold", "font weight");
      break;
    case "800":
      name = (0,external_wp_i18n_namespaceObject._x)("Extra Bold", "font weight");
      break;
    case "900":
      name = (0,external_wp_i18n_namespaceObject._x)("Black", "font weight");
      break;
    case "1000":
      name = (0,external_wp_i18n_namespaceObject._x)("Extra Black", "font weight");
      break;
    default:
      name = fontWeight;
      break;
  }
  return { name, value: fontWeight };
}


;// ./node_modules/@wordpress/block-editor/build-module/utils/get-font-styles-and-weights.js



const FONT_STYLES = [
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Regular", "font style"),
    value: "normal"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Italic", "font style"),
    value: "italic"
  }
];
const FONT_WEIGHTS = [
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Thin", "font weight"),
    value: "100"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Extra Light", "font weight"),
    value: "200"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Light", "font weight"),
    value: "300"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Regular", "font weight"),
    value: "400"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Medium", "font weight"),
    value: "500"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Semi Bold", "font weight"),
    value: "600"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Bold", "font weight"),
    value: "700"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Extra Bold", "font weight"),
    value: "800"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Black", "font weight"),
    value: "900"
  },
  {
    name: (0,external_wp_i18n_namespaceObject._x)("Extra Black", "font weight"),
    value: "1000"
  }
];
function getFontStylesAndWeights(fontFamilyFaces) {
  let fontStyles = [];
  let fontWeights = [];
  const combinedStyleAndWeightOptions = [];
  const isSystemFont = !fontFamilyFaces || fontFamilyFaces?.length === 0;
  let isVariableFont = false;
  fontFamilyFaces?.forEach((face) => {
    if ("string" === typeof face.fontWeight && /\s/.test(face.fontWeight.trim())) {
      isVariableFont = true;
      let [startValue, endValue] = face.fontWeight.split(" ");
      startValue = parseInt(startValue.slice(0, 1));
      if (endValue === "1000") {
        endValue = 10;
      } else {
        endValue = parseInt(endValue.slice(0, 1));
      }
      for (let i = startValue; i <= endValue; i++) {
        const fontWeightValue = `${i.toString()}00`;
        if (!fontWeights.some(
          (weight) => weight.value === fontWeightValue
        )) {
          fontWeights.push(formatFontWeight(fontWeightValue));
        }
      }
    }
    const fontWeight = formatFontWeight(
      "number" === typeof face.fontWeight ? face.fontWeight.toString() : face.fontWeight
    );
    const fontStyle = formatFontStyle(face.fontStyle);
    if (fontStyle && Object.keys(fontStyle).length) {
      if (!fontStyles.some(
        (style) => style.value === fontStyle.value
      )) {
        fontStyles.push(fontStyle);
      }
    }
    if (fontWeight && Object.keys(fontWeight).length) {
      if (!fontWeights.some(
        (weight) => weight.value === fontWeight.value
      )) {
        if (!isVariableFont) {
          fontWeights.push(fontWeight);
        }
      }
    }
  });
  if (!fontWeights.some((weight) => weight.value >= "600")) {
    fontWeights.push({
      name: (0,external_wp_i18n_namespaceObject._x)("Bold", "font weight"),
      value: "700"
    });
  }
  if (!fontStyles.some((style) => style.value === "italic")) {
    fontStyles.push({
      name: (0,external_wp_i18n_namespaceObject._x)("Italic", "font style"),
      value: "italic"
    });
  }
  if (isSystemFont) {
    fontStyles = FONT_STYLES;
    fontWeights = FONT_WEIGHTS;
  }
  fontStyles = fontStyles.length === 0 ? FONT_STYLES : fontStyles;
  fontWeights = fontWeights.length === 0 ? FONT_WEIGHTS : fontWeights;
  fontStyles.forEach(({ name: styleName, value: styleValue }) => {
    fontWeights.forEach(({ name: weightName, value: weightValue }) => {
      const optionName = styleValue === "normal" ? weightName : (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: 1: Font weight name. 2: Font style name. */
        (0,external_wp_i18n_namespaceObject._x)("%1$s %2$s", "font"),
        weightName,
        styleName
      );
      combinedStyleAndWeightOptions.push({
        key: `${styleValue}-${weightValue}`,
        name: optionName,
        style: {
          fontStyle: styleValue,
          fontWeight: weightValue
        }
      });
    });
  });
  return {
    fontStyles,
    fontWeights,
    combinedStyleAndWeightOptions,
    isSystemFont,
    isVariableFont
  };
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/typography-utils.js


function getTypographyFontSizeValue(preset, settings) {
  const { size: defaultSize } = preset;
  if (!defaultSize || "0" === defaultSize || false === preset?.fluid) {
    return defaultSize;
  }
  if (!isFluidTypographyEnabled(settings?.typography) && !isFluidTypographyEnabled(preset)) {
    return defaultSize;
  }
  let fluidTypographySettings = getFluidTypographyOptionsFromSettings(settings);
  fluidTypographySettings = typeof fluidTypographySettings?.fluid === "object" ? fluidTypographySettings?.fluid : {};
  const fluidFontSizeValue = getComputedFluidTypographyValue({
    minimumFontSize: preset?.fluid?.min,
    maximumFontSize: preset?.fluid?.max,
    fontSize: defaultSize,
    minimumFontSizeLimit: fluidTypographySettings?.minFontSize,
    maximumViewportWidth: fluidTypographySettings?.maxViewportWidth,
    minimumViewportWidth: fluidTypographySettings?.minViewportWidth
  });
  if (!!fluidFontSizeValue) {
    return fluidFontSizeValue;
  }
  return defaultSize;
}
function isFluidTypographyEnabled(typographySettings) {
  const fluidSettings = typographySettings?.fluid;
  return true === fluidSettings || fluidSettings && typeof fluidSettings === "object" && Object.keys(fluidSettings).length > 0;
}
function getFluidTypographyOptionsFromSettings(settings) {
  const typographySettings = settings?.typography;
  const layoutSettings = settings?.layout;
  const defaultMaxViewportWidth = getTypographyValueAndUnit(
    layoutSettings?.wideSize
  ) ? layoutSettings?.wideSize : null;
  return isFluidTypographyEnabled(typographySettings) && defaultMaxViewportWidth ? {
    fluid: {
      maxViewportWidth: defaultMaxViewportWidth,
      ...typographySettings.fluid
    }
  } : {
    fluid: typographySettings?.fluid
  };
}
function getMergedFontFamiliesAndFontFamilyFaces(settings, selectedFontFamily) {
  const fontFamiliesFromSettings = settings?.typography?.fontFamilies;
  const fontFamilies = ["default", "theme", "custom"].flatMap(
    (key) => fontFamiliesFromSettings?.[key] ?? []
  );
  const fontFamilyFaces = fontFamilies.find(
    (family) => family.fontFamily === selectedFontFamily
  )?.fontFace ?? [];
  return { fontFamilies, fontFamilyFaces };
}
function findNearestFontWeight(availableFontWeights, newFontWeightValue) {
  newFontWeightValue = "number" === typeof newFontWeightValue ? newFontWeightValue.toString() : newFontWeightValue;
  if (!newFontWeightValue || typeof newFontWeightValue !== "string") {
    return "";
  }
  if (!availableFontWeights || availableFontWeights.length === 0) {
    return newFontWeightValue;
  }
  const nearestFontWeight = availableFontWeights?.reduce(
    (nearest, { value: fw }) => {
      const currentDiff = Math.abs(
        parseInt(fw) - parseInt(newFontWeightValue)
      );
      const nearestDiff = Math.abs(
        parseInt(nearest) - parseInt(newFontWeightValue)
      );
      return currentDiff < nearestDiff ? fw : nearest;
    },
    availableFontWeights[0]?.value
  );
  return nearestFontWeight;
}
function findNearestFontStyle(availableFontStyles, newFontStyleValue) {
  if (typeof newFontStyleValue !== "string" || !newFontStyleValue) {
    return "";
  }
  const validStyles = ["normal", "italic", "oblique"];
  if (!validStyles.includes(newFontStyleValue)) {
    return "";
  }
  if (!availableFontStyles || availableFontStyles.length === 0 || availableFontStyles.find(
    (style) => style.value === newFontStyleValue
  )) {
    return newFontStyleValue;
  }
  if (newFontStyleValue === "oblique" && !availableFontStyles.find((style) => style.value === "oblique")) {
    return "italic";
  }
  return "";
}
function findNearestStyleAndWeight(fontFamilyFaces, fontStyle, fontWeight) {
  let nearestFontStyle = fontStyle;
  let nearestFontWeight = fontWeight;
  const { fontStyles, fontWeights, combinedStyleAndWeightOptions } = getFontStylesAndWeights(fontFamilyFaces);
  const hasFontStyle = fontStyles?.some(
    ({ value: fs }) => fs === fontStyle
  );
  const hasFontWeight = fontWeights?.some(
    ({ value: fw }) => fw?.toString() === fontWeight?.toString()
  );
  if (!hasFontStyle) {
    nearestFontStyle = fontStyle ? findNearestFontStyle(fontStyles, fontStyle) : combinedStyleAndWeightOptions?.find(
      (option) => option.style.fontWeight === findNearestFontWeight(fontWeights, fontWeight)
    )?.style?.fontStyle;
  }
  if (!hasFontWeight) {
    nearestFontWeight = fontWeight ? findNearestFontWeight(fontWeights, fontWeight) : combinedStyleAndWeightOptions?.find(
      (option) => option.style.fontStyle === (nearestFontStyle || fontStyle)
    )?.style?.fontWeight;
  }
  return { nearestFontStyle, nearestFontWeight };
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/utils.js





const ROOT_BLOCK_SELECTOR = "body";
const ROOT_CSS_PROPERTIES_SELECTOR = ":root";
const PRESET_METADATA = [
  {
    path: ["color", "palette"],
    valueKey: "color",
    cssVarInfix: "color",
    classes: [
      { classSuffix: "color", propertyName: "color" },
      {
        classSuffix: "background-color",
        propertyName: "background-color"
      },
      {
        classSuffix: "border-color",
        propertyName: "border-color"
      }
    ]
  },
  {
    path: ["color", "gradients"],
    valueKey: "gradient",
    cssVarInfix: "gradient",
    classes: [
      {
        classSuffix: "gradient-background",
        propertyName: "background"
      }
    ]
  },
  {
    path: ["color", "duotone"],
    valueKey: "colors",
    cssVarInfix: "duotone",
    valueFunc: ({ slug }) => `url( '#wp-duotone-${slug}' )`,
    classes: []
  },
  {
    path: ["shadow", "presets"],
    valueKey: "shadow",
    cssVarInfix: "shadow",
    classes: []
  },
  {
    path: ["typography", "fontSizes"],
    valueFunc: (preset, settings) => getTypographyFontSizeValue(preset, settings),
    valueKey: "size",
    cssVarInfix: "font-size",
    classes: [{ classSuffix: "font-size", propertyName: "font-size" }]
  },
  {
    path: ["typography", "fontFamilies"],
    valueKey: "fontFamily",
    cssVarInfix: "font-family",
    classes: [
      { classSuffix: "font-family", propertyName: "font-family" }
    ]
  },
  {
    path: ["spacing", "spacingSizes"],
    valueKey: "size",
    cssVarInfix: "spacing",
    classes: []
  },
  {
    path: ["border", "radiusSizes"],
    valueKey: "size",
    cssVarInfix: "border-radius",
    classes: []
  }
];
const STYLE_PATH_TO_CSS_VAR_INFIX = {
  "color.background": "color",
  "color.text": "color",
  "filter.duotone": "duotone",
  "elements.link.color.text": "color",
  "elements.link.:hover.color.text": "color",
  "elements.link.typography.fontFamily": "font-family",
  "elements.link.typography.fontSize": "font-size",
  "elements.button.color.text": "color",
  "elements.button.color.background": "color",
  "elements.caption.color.text": "color",
  "elements.button.typography.fontFamily": "font-family",
  "elements.button.typography.fontSize": "font-size",
  "elements.heading.color": "color",
  "elements.heading.color.background": "color",
  "elements.heading.typography.fontFamily": "font-family",
  "elements.heading.gradient": "gradient",
  "elements.heading.color.gradient": "gradient",
  "elements.h1.color": "color",
  "elements.h1.color.background": "color",
  "elements.h1.typography.fontFamily": "font-family",
  "elements.h1.color.gradient": "gradient",
  "elements.h2.color": "color",
  "elements.h2.color.background": "color",
  "elements.h2.typography.fontFamily": "font-family",
  "elements.h2.color.gradient": "gradient",
  "elements.h3.color": "color",
  "elements.h3.color.background": "color",
  "elements.h3.typography.fontFamily": "font-family",
  "elements.h3.color.gradient": "gradient",
  "elements.h4.color": "color",
  "elements.h4.color.background": "color",
  "elements.h4.typography.fontFamily": "font-family",
  "elements.h4.color.gradient": "gradient",
  "elements.h5.color": "color",
  "elements.h5.color.background": "color",
  "elements.h5.typography.fontFamily": "font-family",
  "elements.h5.color.gradient": "gradient",
  "elements.h6.color": "color",
  "elements.h6.color.background": "color",
  "elements.h6.typography.fontFamily": "font-family",
  "elements.h6.color.gradient": "gradient",
  "color.gradient": "gradient",
  shadow: "shadow",
  "typography.fontSize": "font-size",
  "typography.fontFamily": "font-family"
};
const STYLE_PATH_TO_PRESET_BLOCK_ATTRIBUTE = {
  "color.background": "backgroundColor",
  "color.text": "textColor",
  "color.gradient": "gradient",
  "typography.fontSize": "fontSize",
  "typography.fontFamily": "fontFamily"
};
function useToolsPanelDropdownMenuProps() {
  const isMobile = (0,external_wp_compose_namespaceObject.useViewportMatch)("medium", "<");
  return !isMobile ? {
    popoverProps: {
      placement: "left-start",
      // For non-mobile, inner sidebar width (248px) - button width (24px) - border (1px) + padding (16px) + spacing (20px)
      offset: 259
    }
  } : {};
}
function findInPresetsBy(features, blockName, presetPath, presetProperty, presetValueValue) {
  const orderedPresetsByOrigin = [
    getValueFromObjectPath(features, [
      "blocks",
      blockName,
      ...presetPath
    ]),
    getValueFromObjectPath(features, presetPath)
  ];
  for (const presetByOrigin of orderedPresetsByOrigin) {
    if (presetByOrigin) {
      const origins = ["custom", "theme", "default"];
      for (const origin of origins) {
        const presets = presetByOrigin[origin];
        if (presets) {
          const presetObject = presets.find(
            (preset) => preset[presetProperty] === presetValueValue
          );
          if (presetObject) {
            if (presetProperty === "slug") {
              return presetObject;
            }
            const highestPresetObjectWithSameSlug = findInPresetsBy(
              features,
              blockName,
              presetPath,
              "slug",
              presetObject.slug
            );
            if (highestPresetObjectWithSameSlug[presetProperty] === presetObject[presetProperty]) {
              return presetObject;
            }
            return void 0;
          }
        }
      }
    }
  }
}
function getPresetVariableFromValue(features, blockName, variableStylePath, presetPropertyValue) {
  if (!presetPropertyValue) {
    return presetPropertyValue;
  }
  const cssVarInfix = STYLE_PATH_TO_CSS_VAR_INFIX[variableStylePath];
  const metadata = PRESET_METADATA.find(
    (data) => data.cssVarInfix === cssVarInfix
  );
  if (!metadata) {
    return presetPropertyValue;
  }
  const { valueKey, path } = metadata;
  const presetObject = findInPresetsBy(
    features,
    blockName,
    path,
    valueKey,
    presetPropertyValue
  );
  if (!presetObject) {
    return presetPropertyValue;
  }
  return `var:preset|${cssVarInfix}|${presetObject.slug}`;
}
function getValueFromPresetVariable(features, blockName, variable, [presetType, slug]) {
  const metadata = PRESET_METADATA.find(
    (data) => data.cssVarInfix === presetType
  );
  if (!metadata) {
    return variable;
  }
  const presetObject = findInPresetsBy(
    features.settings,
    blockName,
    metadata.path,
    "slug",
    slug
  );
  if (presetObject) {
    const { valueKey } = metadata;
    const result = presetObject[valueKey];
    return getValueFromVariable(features, blockName, result);
  }
  return variable;
}
function getValueFromCustomVariable(features, blockName, variable, path) {
  const result = getValueFromObjectPath(features.settings, [
    "blocks",
    blockName,
    "custom",
    ...path
  ]) ?? getValueFromObjectPath(features.settings, ["custom", ...path]);
  if (!result) {
    return variable;
  }
  return getValueFromVariable(features, blockName, result);
}
function getValueFromVariable(features, blockName, variable) {
  if (!variable || typeof variable !== "string") {
    if (typeof variable?.ref === "string") {
      variable = getValueFromObjectPath(features, variable.ref);
      if (!variable || !!variable?.ref) {
        return variable;
      }
    } else {
      return variable;
    }
  }
  const USER_VALUE_PREFIX = "var:";
  const THEME_VALUE_PREFIX = "var(--wp--";
  const THEME_VALUE_SUFFIX = ")";
  let parsedVar;
  if (variable.startsWith(USER_VALUE_PREFIX)) {
    parsedVar = variable.slice(USER_VALUE_PREFIX.length).split("|");
  } else if (variable.startsWith(THEME_VALUE_PREFIX) && variable.endsWith(THEME_VALUE_SUFFIX)) {
    parsedVar = variable.slice(THEME_VALUE_PREFIX.length, -THEME_VALUE_SUFFIX.length).split("--");
  } else {
    return variable;
  }
  const [type, ...path] = parsedVar;
  if (type === "preset") {
    return getValueFromPresetVariable(
      features,
      blockName,
      variable,
      path
    );
  }
  if (type === "custom") {
    return getValueFromCustomVariable(
      features,
      blockName,
      variable,
      path
    );
  }
  return variable;
}
function scopeSelector(scope, selector) {
  if (!scope || !selector) {
    return selector;
  }
  const scopes = scope.split(",");
  const selectors = selector.split(",");
  const selectorsScoped = [];
  scopes.forEach((outer) => {
    selectors.forEach((inner) => {
      selectorsScoped.push(`${outer.trim()} ${inner.trim()}`);
    });
  });
  return selectorsScoped.join(", ");
}
function scopeFeatureSelectors(scope, selectors) {
  if (!scope || !selectors) {
    return;
  }
  const featureSelectors = {};
  Object.entries(selectors).forEach(([feature, selector]) => {
    if (typeof selector === "string") {
      featureSelectors[feature] = scopeSelector(scope, selector);
    }
    if (typeof selector === "object") {
      featureSelectors[feature] = {};
      Object.entries(selector).forEach(
        ([subfeature, subfeatureSelector]) => {
          featureSelectors[feature][subfeature] = scopeSelector(
            scope,
            subfeatureSelector
          );
        }
      );
    }
  });
  return featureSelectors;
}
function appendToSelector(selector, toAppend) {
  if (!selector.includes(",")) {
    return selector + toAppend;
  }
  const selectors = selector.split(",");
  const newSelectors = selectors.map((sel) => sel + toAppend);
  return newSelectors.join(",");
}
function areGlobalStyleConfigsEqual(original, variation) {
  if (typeof original !== "object" || typeof variation !== "object") {
    return original === variation;
  }
  return es6_default()(original?.styles, variation?.styles) && es6_default()(original?.settings, variation?.settings);
}
function getBlockStyleVariationSelector(variation, blockSelector) {
  const variationClass = `.is-style-${variation}`;
  if (!blockSelector) {
    return variationClass;
  }
  const ancestorRegex = /((?::\([^)]+\))?\s*)([^\s:]+)/;
  const addVariationClass = (_match, group1, group2) => {
    return group1 + group2 + variationClass;
  };
  const result = blockSelector.split(",").map((part) => part.replace(ancestorRegex, addVariationClass));
  return result.join(",");
}
function getResolvedThemeFilePath(file, themeFileURIs) {
  if (!file || !themeFileURIs || !Array.isArray(themeFileURIs)) {
    return file;
  }
  const uri = themeFileURIs.find(
    (themeFileUri) => themeFileUri?.name === file
  );
  if (!uri?.href) {
    return file;
  }
  return uri?.href;
}
function getResolvedRefValue(ruleValue, tree) {
  if (!ruleValue || !tree) {
    return ruleValue;
  }
  if (typeof ruleValue !== "string" && ruleValue?.ref) {
    const resolvedRuleValue = (0,external_wp_styleEngine_namespaceObject.getCSSValueFromRawStyle)(
      getValueFromObjectPath(tree, ruleValue.ref)
    );
    if (resolvedRuleValue?.ref) {
      return void 0;
    }
    if (resolvedRuleValue === void 0) {
      return ruleValue;
    }
    return resolvedRuleValue;
  }
  return ruleValue;
}
function getResolvedValue(ruleValue, tree) {
  if (!ruleValue || !tree) {
    return ruleValue;
  }
  const resolvedValue = getResolvedRefValue(ruleValue, tree);
  if (resolvedValue?.url) {
    resolvedValue.url = getResolvedThemeFilePath(
      resolvedValue.url,
      tree?._links?.["wp:theme-file"]
    );
  }
  return resolvedValue;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/context.js

const DEFAULT_GLOBAL_STYLES_CONTEXT = {
  user: {},
  base: {},
  merged: {},
  setUserConfig: () => {
  }
};
const GlobalStylesContext = (0,external_wp_element_namespaceObject.createContext)(
  DEFAULT_GLOBAL_STYLES_CONTEXT
);
GlobalStylesContext.displayName = "GlobalStylesContext";


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/hooks.js









const EMPTY_CONFIG = { settings: {}, styles: {} };
const VALID_SETTINGS = [
  "appearanceTools",
  "useRootPaddingAwareAlignments",
  "background.backgroundImage",
  "background.backgroundRepeat",
  "background.backgroundSize",
  "background.backgroundPosition",
  "border.color",
  "border.radius",
  "border.style",
  "border.width",
  "border.radiusSizes",
  "shadow.presets",
  "shadow.defaultPresets",
  "color.background",
  "color.button",
  "color.caption",
  "color.custom",
  "color.customDuotone",
  "color.customGradient",
  "color.defaultDuotone",
  "color.defaultGradients",
  "color.defaultPalette",
  "color.duotone",
  "color.gradients",
  "color.heading",
  "color.link",
  "color.palette",
  "color.text",
  "custom",
  "dimensions.aspectRatio",
  "dimensions.minHeight",
  "layout.contentSize",
  "layout.definitions",
  "layout.wideSize",
  "lightbox.enabled",
  "lightbox.allowEditing",
  "position.fixed",
  "position.sticky",
  "spacing.customSpacingSize",
  "spacing.defaultSpacingSizes",
  "spacing.spacingSizes",
  "spacing.spacingScale",
  "spacing.blockGap",
  "spacing.margin",
  "spacing.padding",
  "spacing.units",
  "typography.fluid",
  "typography.customFontSize",
  "typography.defaultFontSizes",
  "typography.dropCap",
  "typography.fontFamilies",
  "typography.fontSizes",
  "typography.fontStyle",
  "typography.fontWeight",
  "typography.letterSpacing",
  "typography.lineHeight",
  "typography.textAlign",
  "typography.textColumns",
  "typography.textDecoration",
  "typography.textTransform",
  "typography.writingMode"
];
const useGlobalStylesReset = () => {
  const { user, setUserConfig } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const config = {
    settings: user.settings,
    styles: user.styles
  };
  const canReset = !!config && !es6_default()(config, EMPTY_CONFIG);
  return [
    canReset,
    (0,external_wp_element_namespaceObject.useCallback)(() => setUserConfig(EMPTY_CONFIG), [setUserConfig])
  ];
};
function useGlobalSetting(propertyPath, blockName, source = "all") {
  const { setUserConfig, ...configs } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const appendedBlockPath = blockName ? ".blocks." + blockName : "";
  const appendedPropertyPath = propertyPath ? "." + propertyPath : "";
  const contextualPath = `settings${appendedBlockPath}${appendedPropertyPath}`;
  const globalPath = `settings${appendedPropertyPath}`;
  const sourceKey = source === "all" ? "merged" : source;
  const settingValue = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const configToUse = configs[sourceKey];
    if (!configToUse) {
      throw "Unsupported source";
    }
    if (propertyPath) {
      return getValueFromObjectPath(configToUse, contextualPath) ?? getValueFromObjectPath(configToUse, globalPath);
    }
    let result = {};
    VALID_SETTINGS.forEach((setting) => {
      const value = getValueFromObjectPath(
        configToUse,
        `settings${appendedBlockPath}.${setting}`
      ) ?? getValueFromObjectPath(configToUse, `settings.${setting}`);
      if (value !== void 0) {
        result = setImmutably(result, setting.split("."), value);
      }
    });
    return result;
  }, [
    configs,
    sourceKey,
    propertyPath,
    contextualPath,
    globalPath,
    appendedBlockPath
  ]);
  const setSetting = (newValue) => {
    setUserConfig(
      (currentConfig) => setImmutably(currentConfig, contextualPath.split("."), newValue)
    );
  };
  return [settingValue, setSetting];
}
function useGlobalStyle(path, blockName, source = "all", { shouldDecodeEncode = true } = {}) {
  const {
    merged: mergedConfig,
    base: baseConfig,
    user: userConfig,
    setUserConfig
  } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const appendedPath = path ? "." + path : "";
  const finalPath = !blockName ? `styles${appendedPath}` : `styles.blocks.${blockName}${appendedPath}`;
  const setStyle = (newValue) => {
    setUserConfig(
      (currentConfig) => setImmutably(
        currentConfig,
        finalPath.split("."),
        shouldDecodeEncode ? getPresetVariableFromValue(
          mergedConfig.settings,
          blockName,
          path,
          newValue
        ) : newValue
      )
    );
  };
  let rawResult, result;
  switch (source) {
    case "all":
      rawResult = getValueFromObjectPath(mergedConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(mergedConfig, blockName, rawResult) : rawResult;
      break;
    case "user":
      rawResult = getValueFromObjectPath(userConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(mergedConfig, blockName, rawResult) : rawResult;
      break;
    case "base":
      rawResult = getValueFromObjectPath(baseConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(baseConfig, blockName, rawResult) : rawResult;
      break;
    default:
      throw "Unsupported source";
  }
  return [result, setStyle];
}
function useSettingsForBlockElement(parentSettings, blockName, element) {
  const { supportedStyles, supports } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      return {
        supportedStyles: unlock(
          select(external_wp_blocks_namespaceObject.store)
        ).getSupportedStyles(blockName, element),
        supports: select(external_wp_blocks_namespaceObject.store).getBlockType(blockName)?.supports
      };
    },
    [blockName, element]
  );
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const updatedSettings = { ...parentSettings };
    if (!supportedStyles.includes("fontSize")) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        fontSizes: {},
        customFontSize: false,
        defaultFontSizes: false
      };
    }
    if (!supportedStyles.includes("fontFamily")) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        fontFamilies: {}
      };
    }
    updatedSettings.color = {
      ...updatedSettings.color,
      text: updatedSettings.color?.text && supportedStyles.includes("color"),
      background: updatedSettings.color?.background && (supportedStyles.includes("background") || supportedStyles.includes("backgroundColor")),
      button: updatedSettings.color?.button && supportedStyles.includes("buttonColor"),
      heading: updatedSettings.color?.heading && supportedStyles.includes("headingColor"),
      link: updatedSettings.color?.link && supportedStyles.includes("linkColor"),
      caption: updatedSettings.color?.caption && supportedStyles.includes("captionColor")
    };
    if (!supportedStyles.includes("background")) {
      updatedSettings.color.gradients = [];
      updatedSettings.color.customGradient = false;
    }
    if (!supportedStyles.includes("filter")) {
      updatedSettings.color.defaultDuotone = false;
      updatedSettings.color.customDuotone = false;
    }
    [
      "lineHeight",
      "fontStyle",
      "fontWeight",
      "letterSpacing",
      "textAlign",
      "textTransform",
      "textDecoration",
      "writingMode"
    ].forEach((key) => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.typography = {
          ...updatedSettings.typography,
          [key]: false
        };
      }
    });
    if (!supportedStyles.includes("columnCount")) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        textColumns: false
      };
    }
    ["contentSize", "wideSize"].forEach((key) => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.layout = {
          ...updatedSettings.layout,
          [key]: false
        };
      }
    });
    ["padding", "margin", "blockGap"].forEach((key) => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.spacing = {
          ...updatedSettings.spacing,
          [key]: false
        };
      }
      const sides = Array.isArray(supports?.spacing?.[key]) ? supports?.spacing?.[key] : supports?.spacing?.[key]?.sides;
      if (sides?.length && updatedSettings.spacing?.[key]) {
        updatedSettings.spacing = {
          ...updatedSettings.spacing,
          [key]: {
            ...updatedSettings.spacing?.[key],
            sides
          }
        };
      }
    });
    ["aspectRatio", "minHeight"].forEach((key) => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.dimensions = {
          ...updatedSettings.dimensions,
          [key]: false
        };
      }
    });
    ["radius", "color", "style", "width"].forEach((key) => {
      if (!supportedStyles.includes(
        "border" + key.charAt(0).toUpperCase() + key.slice(1)
      )) {
        updatedSettings.border = {
          ...updatedSettings.border,
          [key]: false
        };
      }
    });
    ["backgroundImage", "backgroundSize"].forEach((key) => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.background = {
          ...updatedSettings.background,
          [key]: false
        };
      }
    });
    updatedSettings.shadow = supportedStyles.includes("shadow") ? updatedSettings.shadow : false;
    if (element) {
      updatedSettings.typography.textAlign = false;
    }
    return updatedSettings;
  }, [parentSettings, supportedStyles, supports, element]);
}
function useColorsPerOrigin(settings) {
  const customColors = settings?.color?.palette?.custom;
  const themeColors = settings?.color?.palette?.theme;
  const defaultColors = settings?.color?.palette?.default;
  const shouldDisplayDefaultColors = settings?.color?.defaultPalette;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeColors && themeColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Theme",
          "Indicates this palette comes from the theme."
        ),
        colors: themeColors
      });
    }
    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Default",
          "Indicates this palette comes from WordPress."
        ),
        colors: defaultColors
      });
    }
    if (customColors && customColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Custom",
          "Indicates this palette is created by the user."
        ),
        colors: customColors
      });
    }
    return result;
  }, [
    customColors,
    themeColors,
    defaultColors,
    shouldDisplayDefaultColors
  ]);
}
function useGradientsPerOrigin(settings) {
  const customGradients = settings?.color?.gradients?.custom;
  const themeGradients = settings?.color?.gradients?.theme;
  const defaultGradients = settings?.color?.gradients?.default;
  const shouldDisplayDefaultGradients = settings?.color?.defaultGradients;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeGradients && themeGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Theme",
          "Indicates this palette comes from the theme."
        ),
        gradients: themeGradients
      });
    }
    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Default",
          "Indicates this palette comes from WordPress."
        ),
        gradients: defaultGradients
      });
    }
    if (customGradients && customGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Custom",
          "Indicates this palette is created by the user."
        ),
        gradients: customGradients
      });
    }
    return result;
  }, [
    customGradients,
    themeGradients,
    defaultGradients,
    shouldDisplayDefaultGradients
  ]);
}


;// ./node_modules/clsx/dist/clsx.mjs
function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f)}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}/* harmony default export */ const dist_clsx = (clsx);
;// ./node_modules/@wordpress/block-editor/build-module/hooks/utils.js













const utils_cleanEmptyObject = (object) => {
  if (object === null || typeof object !== "object" || Array.isArray(object)) {
    return object;
  }
  const cleanedNestedObjects = Object.entries(object).map(([key, value]) => [key, utils_cleanEmptyObject(value)]).filter(([, value]) => value !== void 0);
  return !cleanedNestedObjects.length ? void 0 : Object.fromEntries(cleanedNestedObjects);
};
function transformStyles(activeSupports, migrationPaths, result, source, index, results) {
  if (Object.values(activeSupports ?? {}).every(
    (isActive) => !isActive
  )) {
    return result;
  }
  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  }
  let referenceBlockAttributes = source[0]?.attributes;
  if (results.length > 1 && source.length > 1) {
    if (source[index]) {
      referenceBlockAttributes = source[index]?.attributes;
    } else {
      return result;
    }
  }
  let returnBlock = result;
  Object.entries(activeSupports).forEach(([support, isActive]) => {
    if (isActive) {
      migrationPaths[support].forEach((path) => {
        const styleValue = getValueFromObjectPath(
          referenceBlockAttributes,
          path
        );
        if (styleValue) {
          returnBlock = {
            ...returnBlock,
            attributes: setImmutably(
              returnBlock.attributes,
              path,
              styleValue
            )
          };
        }
      });
    }
  });
  return returnBlock;
}
function shouldSkipSerialization(blockNameOrType, featureSet, feature) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, featureSet);
  const skipSerialization = support?.__experimentalSkipSerialization;
  if (Array.isArray(skipSerialization)) {
    return skipSerialization.includes(feature);
  }
  return skipSerialization;
}
const pendingStyleOverrides = /* @__PURE__ */ new WeakMap();
function useStyleOverride({ id, css }) {
  return usePrivateStyleOverride({ id, css });
}
function usePrivateStyleOverride({
  id,
  css,
  assets,
  __unstableType,
  variation,
  clientId
} = {}) {
  const { setStyleOverride, deleteStyleOverride } = unlock(
    (0,external_wp_data_namespaceObject.useDispatch)(store)
  );
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const fallbackId = (0,external_wp_element_namespaceObject.useId)();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!css && !assets) {
      return;
    }
    const _id = id || fallbackId;
    const override = {
      id,
      css,
      assets,
      __unstableType,
      variation,
      clientId
    };
    if (!pendingStyleOverrides.get(registry)) {
      pendingStyleOverrides.set(registry, []);
    }
    pendingStyleOverrides.get(registry).push([_id, override]);
    window.queueMicrotask(() => {
      if (pendingStyleOverrides.get(registry)?.length) {
        registry.batch(() => {
          pendingStyleOverrides.get(registry).forEach((args) => {
            setStyleOverride(...args);
          });
          pendingStyleOverrides.set(registry, []);
        });
      }
    });
    return () => {
      const isPending = pendingStyleOverrides.get(registry)?.find(([currentId]) => currentId === _id);
      if (isPending) {
        pendingStyleOverrides.set(
          registry,
          pendingStyleOverrides.get(registry).filter(([currentId]) => currentId !== _id)
        );
      } else {
        deleteStyleOverride(_id);
      }
    };
  }, [
    id,
    css,
    clientId,
    assets,
    __unstableType,
    fallbackId,
    setStyleOverride,
    deleteStyleOverride,
    registry
  ]);
}
function useBlockSettings(name, parentLayout) {
  const [
    backgroundImage,
    backgroundSize,
    customFontFamilies,
    defaultFontFamilies,
    themeFontFamilies,
    defaultFontSizesEnabled,
    customFontSizes,
    defaultFontSizes,
    themeFontSizes,
    customFontSize,
    fontStyle,
    fontWeight,
    lineHeight,
    textAlign,
    textColumns,
    textDecoration,
    writingMode,
    textTransform,
    letterSpacing,
    padding,
    margin,
    blockGap,
    defaultSpacingSizesEnabled,
    customSpacingSize,
    userSpacingSizes,
    defaultSpacingSizes,
    themeSpacingSizes,
    units,
    aspectRatio,
    minHeight,
    layout,
    borderColor,
    borderRadius,
    borderStyle,
    borderWidth,
    borderRadiusSizes,
    customColorsEnabled,
    customColors,
    customDuotone,
    themeColors,
    defaultColors,
    defaultPalette,
    defaultDuotone,
    userDuotonePalette,
    themeDuotonePalette,
    defaultDuotonePalette,
    userGradientPalette,
    themeGradientPalette,
    defaultGradientPalette,
    defaultGradients,
    areCustomGradientsEnabled,
    isBackgroundEnabled,
    isLinkEnabled,
    isTextEnabled,
    isHeadingEnabled,
    isButtonEnabled,
    shadow
  ] = use_settings_useSettings(
    "background.backgroundImage",
    "background.backgroundSize",
    "typography.fontFamilies.custom",
    "typography.fontFamilies.default",
    "typography.fontFamilies.theme",
    "typography.defaultFontSizes",
    "typography.fontSizes.custom",
    "typography.fontSizes.default",
    "typography.fontSizes.theme",
    "typography.customFontSize",
    "typography.fontStyle",
    "typography.fontWeight",
    "typography.lineHeight",
    "typography.textAlign",
    "typography.textColumns",
    "typography.textDecoration",
    "typography.writingMode",
    "typography.textTransform",
    "typography.letterSpacing",
    "spacing.padding",
    "spacing.margin",
    "spacing.blockGap",
    "spacing.defaultSpacingSizes",
    "spacing.customSpacingSize",
    "spacing.spacingSizes.custom",
    "spacing.spacingSizes.default",
    "spacing.spacingSizes.theme",
    "spacing.units",
    "dimensions.aspectRatio",
    "dimensions.minHeight",
    "layout",
    "border.color",
    "border.radius",
    "border.style",
    "border.width",
    "border.radiusSizes",
    "color.custom",
    "color.palette.custom",
    "color.customDuotone",
    "color.palette.theme",
    "color.palette.default",
    "color.defaultPalette",
    "color.defaultDuotone",
    "color.duotone.custom",
    "color.duotone.theme",
    "color.duotone.default",
    "color.gradients.custom",
    "color.gradients.theme",
    "color.gradients.default",
    "color.defaultGradients",
    "color.customGradient",
    "color.background",
    "color.link",
    "color.text",
    "color.heading",
    "color.button",
    "shadow"
  );
  const rawSettings = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      background: {
        backgroundImage,
        backgroundSize
      },
      color: {
        palette: {
          custom: customColors,
          theme: themeColors,
          default: defaultColors
        },
        gradients: {
          custom: userGradientPalette,
          theme: themeGradientPalette,
          default: defaultGradientPalette
        },
        duotone: {
          custom: userDuotonePalette,
          theme: themeDuotonePalette,
          default: defaultDuotonePalette
        },
        defaultGradients,
        defaultPalette,
        defaultDuotone,
        custom: customColorsEnabled,
        customGradient: areCustomGradientsEnabled,
        customDuotone,
        background: isBackgroundEnabled,
        link: isLinkEnabled,
        heading: isHeadingEnabled,
        button: isButtonEnabled,
        text: isTextEnabled
      },
      typography: {
        fontFamilies: {
          custom: customFontFamilies,
          default: defaultFontFamilies,
          theme: themeFontFamilies
        },
        fontSizes: {
          custom: customFontSizes,
          default: defaultFontSizes,
          theme: themeFontSizes
        },
        customFontSize,
        defaultFontSizes: defaultFontSizesEnabled,
        fontStyle,
        fontWeight,
        lineHeight,
        textAlign,
        textColumns,
        textDecoration,
        textTransform,
        letterSpacing,
        writingMode
      },
      spacing: {
        spacingSizes: {
          custom: userSpacingSizes,
          default: defaultSpacingSizes,
          theme: themeSpacingSizes
        },
        customSpacingSize,
        defaultSpacingSizes: defaultSpacingSizesEnabled,
        padding,
        margin,
        blockGap,
        units
      },
      border: {
        color: borderColor,
        radius: borderRadius,
        style: borderStyle,
        width: borderWidth,
        radiusSizes: borderRadiusSizes
      },
      dimensions: {
        aspectRatio,
        minHeight
      },
      layout,
      parentLayout,
      shadow
    };
  }, [
    backgroundImage,
    backgroundSize,
    customFontFamilies,
    defaultFontFamilies,
    themeFontFamilies,
    defaultFontSizesEnabled,
    customFontSizes,
    defaultFontSizes,
    themeFontSizes,
    customFontSize,
    fontStyle,
    fontWeight,
    lineHeight,
    textAlign,
    textColumns,
    textDecoration,
    textTransform,
    letterSpacing,
    writingMode,
    padding,
    margin,
    blockGap,
    defaultSpacingSizesEnabled,
    customSpacingSize,
    userSpacingSizes,
    defaultSpacingSizes,
    themeSpacingSizes,
    units,
    aspectRatio,
    minHeight,
    layout,
    parentLayout,
    borderColor,
    borderRadius,
    borderStyle,
    borderWidth,
    borderRadiusSizes,
    customColorsEnabled,
    customColors,
    customDuotone,
    themeColors,
    defaultColors,
    defaultPalette,
    defaultDuotone,
    userDuotonePalette,
    themeDuotonePalette,
    defaultDuotonePalette,
    userGradientPalette,
    themeGradientPalette,
    defaultGradientPalette,
    defaultGradients,
    areCustomGradientsEnabled,
    isBackgroundEnabled,
    isLinkEnabled,
    isTextEnabled,
    isHeadingEnabled,
    isButtonEnabled,
    shadow
  ]);
  return useSettingsForBlockElement(rawSettings, name);
}
function createBlockEditFilter(features) {
  features = features.map((settings) => {
    return { ...settings, Edit: (0,external_wp_element_namespaceObject.memo)(settings.edit) };
  });
  const withBlockEditHooks = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(
    (OriginalBlockEdit) => (props) => {
      const context = useBlockEditContext();
      return [
        ...features.map((feature, i) => {
          const {
            Edit,
            hasSupport,
            attributeKeys = [],
            shareWithChildBlocks
          } = feature;
          const shouldDisplayControls = context[mayDisplayControlsKey] || context[mayDisplayParentControlsKey] && shareWithChildBlocks;
          if (!shouldDisplayControls || !hasSupport(props.name)) {
            return null;
          }
          const neededProps = {};
          for (const key of attributeKeys) {
            if (props.attributes[key]) {
              neededProps[key] = props.attributes[key];
            }
          }
          return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            Edit,
            {
              name: props.name,
              isSelected: props.isSelected,
              clientId: props.clientId,
              setAttributes: props.setAttributes,
              __unstableParentLayout: props.__unstableParentLayout,
              ...neededProps
            },
            i
          );
        }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(OriginalBlockEdit, { ...props }, "edit")
      ];
    },
    "withBlockEditHooks"
  );
  (0,external_wp_hooks_namespaceObject.addFilter)("editor.BlockEdit", "core/editor/hooks", withBlockEditHooks);
}
function BlockProps({
  index,
  useBlockProps: hook,
  setAllWrapperProps,
  ...props
}) {
  const wrapperProps = hook(props);
  const setWrapperProps = (next) => setAllWrapperProps((prev) => {
    const nextAll = [...prev];
    nextAll[index] = next;
    return nextAll;
  });
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    setWrapperProps(wrapperProps);
    return () => {
      setWrapperProps(void 0);
    };
  });
  return null;
}
const BlockPropsPure = (0,external_wp_element_namespaceObject.memo)(BlockProps);
function createBlockListBlockFilter(features) {
  const withBlockListBlockHooks = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(
    (BlockListBlock) => (props) => {
      const [allWrapperProps, setAllWrapperProps] = (0,external_wp_element_namespaceObject.useState)(
        Array(features.length).fill(void 0)
      );
      return [
        ...features.map((feature, i) => {
          const {
            hasSupport,
            attributeKeys = [],
            useBlockProps,
            isMatch
          } = feature;
          const neededProps = {};
          for (const key of attributeKeys) {
            if (props.attributes[key]) {
              neededProps[key] = props.attributes[key];
            }
          }
          if (
            // Skip rendering if none of the needed attributes are
            // set.
            !Object.keys(neededProps).length || !hasSupport(props.name) || isMatch && !isMatch(neededProps)
          ) {
            return null;
          }
          return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            BlockPropsPure,
            {
              index: i,
              useBlockProps,
              setAllWrapperProps,
              name: props.name,
              clientId: props.clientId,
              ...neededProps
            },
            i
          );
        }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          BlockListBlock,
          {
            ...props,
            wrapperProps: allWrapperProps.filter(Boolean).reduce((acc, wrapperProps) => {
              return {
                ...acc,
                ...wrapperProps,
                className: dist_clsx(
                  acc.className,
                  wrapperProps.className
                ),
                style: {
                  ...acc.style,
                  ...wrapperProps.style
                }
              };
            }, props.wrapperProps || {})
          },
          "edit"
        )
      ];
    },
    "withBlockListBlockHooks"
  );
  (0,external_wp_hooks_namespaceObject.addFilter)(
    "editor.BlockListBlock",
    "core/editor/hooks",
    withBlockListBlockHooks
  );
}
function createBlockSaveFilter(features) {
  function extraPropsFromHooks(props, name, attributes) {
    return features.reduce((accu, feature) => {
      const { hasSupport, attributeKeys = [], addSaveProps } = feature;
      const neededAttributes = {};
      for (const key of attributeKeys) {
        if (attributes[key]) {
          neededAttributes[key] = attributes[key];
        }
      }
      if (
        // Skip rendering if none of the needed attributes are
        // set.
        !Object.keys(neededAttributes).length || !hasSupport(name)
      ) {
        return accu;
      }
      return addSaveProps(accu, name, neededAttributes);
    }, props);
  }
  (0,external_wp_hooks_namespaceObject.addFilter)(
    "blocks.getSaveContent.extraProps",
    "core/editor/hooks",
    extraPropsFromHooks,
    0
  );
  (0,external_wp_hooks_namespaceObject.addFilter)(
    "blocks.getSaveContent.extraProps",
    "core/editor/hooks",
    (props) => {
      if (props.hasOwnProperty("className") && !props.className) {
        delete props.className;
      }
      return props;
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/compat.js


function migrateLightBlockWrapper(settings) {
  const { apiVersion = 1 } = settings;
  if (apiVersion < 2 && (0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "lightBlockWrapper", false)) {
    settings.apiVersion = 2;
  }
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/compat/migrateLightBlockWrapper",
  migrateLightBlockWrapper
);

;// external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// ./node_modules/@wordpress/block-editor/build-module/components/block-controls/groups.js

const BlockControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)("BlockControls");
const BlockControlsBlock = (0,external_wp_components_namespaceObject.createSlotFill)("BlockControlsBlock");
const BlockControlsInline = (0,external_wp_components_namespaceObject.createSlotFill)("BlockFormatControls");
const BlockControlsOther = (0,external_wp_components_namespaceObject.createSlotFill)("BlockControlsOther");
const BlockControlsParent = (0,external_wp_components_namespaceObject.createSlotFill)("BlockControlsParent");
const groups = {
  default: BlockControlsDefault,
  block: BlockControlsBlock,
  inline: BlockControlsInline,
  other: BlockControlsOther,
  parent: BlockControlsParent
};
var groups_default = groups;


;// ./node_modules/@wordpress/block-editor/build-module/components/block-controls/hook.js


function useBlockControlsFill(group, shareWithChildBlocks) {
  const context = useBlockEditContext();
  if (context[mayDisplayControlsKey]) {
    return groups_default[group]?.Fill;
  }
  if (context[mayDisplayParentControlsKey] && shareWithChildBlocks) {
    return groups_default.parent.Fill;
  }
  return null;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-controls/fill.js



function BlockControlsFill({
  group = "default",
  controls,
  children,
  __experimentalShareWithChildBlocks = false
}) {
  const Fill = useBlockControlsFill(
    group,
    __experimentalShareWithChildBlocks
  );
  if (!Fill) {
    return null;
  }
  const innerMarkup = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    group === "default" && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, { controls }),
    children
  ] });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalStyleProvider, { document, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Fill, { children: (fillProps) => {
    const { forwardedContext = [] } = fillProps;
    return forwardedContext.reduce(
      (inner, [Provider, props]) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Provider, { ...props, children: inner }),
      innerMarkup
    );
  } }) });
}


;// external ["wp","warning"]
const external_wp_warning_namespaceObject = window["wp"]["warning"];
var external_wp_warning_default = /*#__PURE__*/__webpack_require__.n(external_wp_warning_namespaceObject);
;// ./node_modules/@wordpress/block-editor/build-module/components/block-controls/slot.js






const { ComponentsContext } = unlock(external_wp_components_namespaceObject.privateApis);
function BlockControlsSlot({ group = "default", ...props }) {
  const toolbarState = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolbarContext);
  const contextState = (0,external_wp_element_namespaceObject.useContext)(ComponentsContext);
  const fillProps = (0,external_wp_element_namespaceObject.useMemo)(
    () => ({
      forwardedContext: [
        [external_wp_components_namespaceObject.__experimentalToolbarContext.Provider, { value: toolbarState }],
        [ComponentsContext.Provider, { value: contextState }]
      ]
    }),
    [toolbarState, contextState]
  );
  const slotFill = groups_default[group];
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(slotFill.name);
  if (!slotFill) {
    external_wp_warning_default()(`Unknown BlockControls group "${group}" provided.`);
    return null;
  }
  if (!fills?.length) {
    return null;
  }
  const { Slot } = slotFill;
  const slot = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, { ...props, bubblesVirtually: true, fillProps });
  if (group === "default") {
    return slot;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, { children: slot });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js



const BlockControls = BlockControlsFill;
BlockControls.Slot = BlockControlsSlot;
const BlockFormatControls = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockControlsFill, { group: "inline", ...props });
};
BlockFormatControls.Slot = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockControlsSlot, { group: "inline", ...props });
};
var block_controls_default = BlockControls;


;// ./node_modules/@wordpress/icons/build-module/library/justify-left.js


var justify_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M9 9v6h11V9H9zM4 20h1.5V4H4v16z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-center.js


var justify_center_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M12.5 15v5H11v-5H4V9h7V4h1.5v5h7v6h-7Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-right.js


var justify_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4 15h11V9H4v6zM18.5 4v16H20V4h-1.5z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-space-between.js


var justify_space_between_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M9 15h6V9H9v6zm-5 5h1.5V4H4v16zM18.5 4v16H20V4h-1.5z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-stretch.js


var justify_stretch_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4 4H5.5V20H4V4ZM7 10L17 10V14L7 14V10ZM20 4H18.5V20H20V4Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/arrow-right.js


var arrow_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/arrow-down.js


var arrow_down_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m16.5 13.5-3.7 3.7V4h-1.5v13.2l-3.8-3.7-1 1 5.5 5.6 5.5-5.6z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/layouts/definitions.js
const LAYOUT_DEFINITIONS = {
  default: {
    name: "default",
    slug: "flow",
    className: "is-layout-flow",
    baseStyles: [
      {
        selector: " > .alignleft",
        rules: {
          float: "left",
          "margin-inline-start": "0",
          "margin-inline-end": "2em"
        }
      },
      {
        selector: " > .alignright",
        rules: {
          float: "right",
          "margin-inline-start": "2em",
          "margin-inline-end": "0"
        }
      },
      {
        selector: " > .aligncenter",
        rules: {
          "margin-left": "auto !important",
          "margin-right": "auto !important"
        }
      }
    ],
    spacingStyles: [
      {
        selector: " > :first-child",
        rules: {
          "margin-block-start": "0"
        }
      },
      {
        selector: " > :last-child",
        rules: {
          "margin-block-end": "0"
        }
      },
      {
        selector: " > *",
        rules: {
          "margin-block-start": null,
          "margin-block-end": "0"
        }
      }
    ]
  },
  constrained: {
    name: "constrained",
    slug: "constrained",
    className: "is-layout-constrained",
    baseStyles: [
      {
        selector: " > .alignleft",
        rules: {
          float: "left",
          "margin-inline-start": "0",
          "margin-inline-end": "2em"
        }
      },
      {
        selector: " > .alignright",
        rules: {
          float: "right",
          "margin-inline-start": "2em",
          "margin-inline-end": "0"
        }
      },
      {
        selector: " > .aligncenter",
        rules: {
          "margin-left": "auto !important",
          "margin-right": "auto !important"
        }
      },
      {
        selector: " > :where(:not(.alignleft):not(.alignright):not(.alignfull))",
        rules: {
          "max-width": "var(--wp--style--global--content-size)",
          "margin-left": "auto !important",
          "margin-right": "auto !important"
        }
      },
      {
        selector: " > .alignwide",
        rules: {
          "max-width": "var(--wp--style--global--wide-size)"
        }
      }
    ],
    spacingStyles: [
      {
        selector: " > :first-child",
        rules: {
          "margin-block-start": "0"
        }
      },
      {
        selector: " > :last-child",
        rules: {
          "margin-block-end": "0"
        }
      },
      {
        selector: " > *",
        rules: {
          "margin-block-start": null,
          "margin-block-end": "0"
        }
      }
    ]
  },
  flex: {
    name: "flex",
    slug: "flex",
    className: "is-layout-flex",
    displayMode: "flex",
    baseStyles: [
      {
        selector: "",
        rules: {
          "flex-wrap": "wrap",
          "align-items": "center"
        }
      },
      {
        selector: " > :is(*, div)",
        // :is(*, div) instead of just * increases the specificity by 001.
        rules: {
          margin: "0"
        }
      }
    ],
    spacingStyles: [
      {
        selector: "",
        rules: {
          gap: null
        }
      }
    ]
  },
  grid: {
    name: "grid",
    slug: "grid",
    className: "is-layout-grid",
    displayMode: "grid",
    baseStyles: [
      {
        selector: " > :is(*, div)",
        // :is(*, div) instead of just * increases the specificity by 001.
        rules: {
          margin: "0"
        }
      }
    ],
    spacingStyles: [
      {
        selector: "",
        rules: {
          gap: null
        }
      }
    ]
  }
};


;// ./node_modules/@wordpress/block-editor/build-module/layouts/utils.js


function appendSelectors(selectors, append = "") {
  return selectors.split(",").map(
    (subselector) => `${subselector}${append ? ` ${append}` : ""}`
  ).join(",");
}
function getBlockGapCSS(selector, layoutDefinitions = LAYOUT_DEFINITIONS, layoutType, blockGapValue) {
  let output = "";
  if (layoutDefinitions?.[layoutType]?.spacingStyles?.length && blockGapValue) {
    layoutDefinitions[layoutType].spacingStyles.forEach((gapStyle) => {
      output += `${appendSelectors(
        selector,
        gapStyle.selector.trim()
      )} { `;
      output += Object.entries(gapStyle.rules).map(
        ([cssProperty, value]) => `${cssProperty}: ${value ? value : blockGapValue}`
      ).join("; ");
      output += "; }";
    });
  }
  return output;
}
function getAlignmentsInfo(layout) {
  const { contentSize, wideSize, type = "default" } = layout;
  const alignmentInfo = {};
  const sizeRegex = /^(?!0)\d+(px|em|rem|vw|vh|%|svw|lvw|dvw|svh|lvh|dvh|vi|svi|lvi|dvi|vb|svb|lvb|dvb|vmin|svmin|lvmin|dvmin|vmax|svmax|lvmax|dvmax)?$/i;
  if (sizeRegex.test(contentSize) && type === "constrained") {
    alignmentInfo.none = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)("Max %s wide"), contentSize);
  }
  if (sizeRegex.test(wideSize)) {
    alignmentInfo.wide = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)("Max %s wide"), wideSize);
  }
  return alignmentInfo;
}


;// ./node_modules/@wordpress/icons/build-module/library/sides-all.js


var sides_all_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/sides-horizontal.js


var sides_horizontal_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m4.5 7.5v9h1.5v-9z" }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m18 7.5v9h1.5v-9z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/sides-vertical.js


var sides_vertical_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m7.5 6h9v-1.5h-9z" }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m7.5 19.5h9v-1.5h-9z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/sides-top.js


var sides_top_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m16.5 6h-9v-1.5h9z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/sides-right.js


var sides_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m18 16.5v-9h1.5v9z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/sides-bottom.js


var sides_bottom_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m16.5 19.5h-9v-1.5h9z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/sides-left.js


var sides_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
      style: { opacity: 0.25 }
    }
  ),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m4.5 16.5v-9h1.5v9z" })
] });


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/utils.js


const RANGE_CONTROL_MAX_SIZE = 8;
const ALL_SIDES = ["top", "right", "bottom", "left"];
const DEFAULT_VALUES = {
  top: void 0,
  right: void 0,
  bottom: void 0,
  left: void 0
};
const ICONS = {
  custom: sides_all_default,
  axial: sides_all_default,
  horizontal: sides_horizontal_default,
  vertical: sides_vertical_default,
  top: sides_top_default,
  right: sides_right_default,
  bottom: sides_bottom_default,
  left: sides_left_default
};
const LABELS = {
  default: (0,external_wp_i18n_namespaceObject.__)("Spacing control"),
  top: (0,external_wp_i18n_namespaceObject.__)("Top"),
  bottom: (0,external_wp_i18n_namespaceObject.__)("Bottom"),
  left: (0,external_wp_i18n_namespaceObject.__)("Left"),
  right: (0,external_wp_i18n_namespaceObject.__)("Right"),
  mixed: (0,external_wp_i18n_namespaceObject.__)("Mixed"),
  vertical: (0,external_wp_i18n_namespaceObject.__)("Vertical"),
  horizontal: (0,external_wp_i18n_namespaceObject.__)("Horizontal"),
  axial: (0,external_wp_i18n_namespaceObject.__)("Horizontal & vertical"),
  custom: (0,external_wp_i18n_namespaceObject.__)("Custom")
};
const VIEWS = {
  axial: "axial",
  top: "top",
  right: "right",
  bottom: "bottom",
  left: "left",
  custom: "custom"
};
function isValueSpacingPreset(value) {
  if (!value?.includes) {
    return false;
  }
  return value === "0" || value.includes("var:preset|spacing|");
}
function getCustomValueFromPreset(value, spacingSizes) {
  if (!isValueSpacingPreset(value)) {
    return value;
  }
  const slug = getSpacingPresetSlug(value);
  const spacingSize = spacingSizes.find(
    (size) => String(size.slug) === slug
  );
  return spacingSize?.size;
}
function getPresetValueFromCustomValue(value, spacingSizes) {
  if (!value || isValueSpacingPreset(value) || value === "0") {
    return value;
  }
  const spacingMatch = spacingSizes.find(
    (size) => String(size.size) === String(value)
  );
  if (spacingMatch?.slug) {
    return `var:preset|spacing|${spacingMatch.slug}`;
  }
  return value;
}
function getSpacingPresetCssVar(value) {
  if (!value) {
    return;
  }
  const slug = value.match(/var:preset\|spacing\|(.+)/);
  if (!slug) {
    return value;
  }
  return `var(--wp--preset--spacing--${slug[1]})`;
}
function getSpacingPresetSlug(value) {
  if (!value) {
    return;
  }
  if (value === "0" || value === "default") {
    return value;
  }
  const slug = value.match(/var:preset\|spacing\|(.+)/);
  return slug ? slug[1] : void 0;
}
function getSliderValueFromPreset(presetValue, spacingSizes) {
  if (presetValue === void 0) {
    return 0;
  }
  const slug = parseFloat(presetValue, 10) === 0 ? "0" : getSpacingPresetSlug(presetValue);
  const sliderValue = spacingSizes.findIndex((spacingSize) => {
    return String(spacingSize.slug) === slug;
  });
  return sliderValue !== -1 ? sliderValue : NaN;
}
function hasAxisSupport(sides, axis) {
  if (!sides || !sides.length) {
    return false;
  }
  const hasHorizontalSupport = sides.includes("horizontal") || sides.includes("left") && sides.includes("right");
  const hasVerticalSupport = sides.includes("vertical") || sides.includes("top") && sides.includes("bottom");
  if (axis === "horizontal") {
    return hasHorizontalSupport;
  }
  if (axis === "vertical") {
    return hasVerticalSupport;
  }
  return hasHorizontalSupport || hasVerticalSupport;
}
function hasBalancedSidesSupport(sides = []) {
  const counts = { top: 0, right: 0, bottom: 0, left: 0 };
  sides.forEach((side) => counts[side] += 1);
  return (counts.top + counts.bottom) % 2 === 0 && (counts.left + counts.right) % 2 === 0;
}
function getInitialView(values = {}, sides) {
  const { top, right, bottom, left } = values;
  const sideValues = [top, right, bottom, left].filter(Boolean);
  const hasMatchingAxialValues = top === bottom && left === right && (!!top || !!left);
  const hasNoValuesAndBalancedSides = !sideValues.length && hasBalancedSidesSupport(sides);
  const hasOnlyAxialSides = sides?.includes("horizontal") && sides?.includes("vertical") && sides?.length === 2;
  if (hasAxisSupport(sides) && (hasMatchingAxialValues || hasNoValuesAndBalancedSides)) {
    return VIEWS.axial;
  }
  if (hasOnlyAxialSides && sideValues.length === 1) {
    let side;
    Object.entries(values).some(([key, value]) => {
      side = key;
      return value !== void 0;
    });
    return side;
  }
  if (sides?.length === 1 && !sideValues.length) {
    return sides[0];
  }
  return VIEWS.custom;
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/gap.js

function getGapBoxControlValueFromStyle(blockGapValue) {
  if (!blockGapValue) {
    return null;
  }
  const isValueString = typeof blockGapValue === "string";
  return {
    top: isValueString ? blockGapValue : blockGapValue?.top,
    left: isValueString ? blockGapValue : blockGapValue?.left
  };
}
function getGapCSSValue(blockGapValue, defaultValue = "0") {
  const blockGapBoxControlValue = getGapBoxControlValueFromStyle(blockGapValue);
  if (!blockGapBoxControlValue) {
    return null;
  }
  const row = getSpacingPresetCssVar(blockGapBoxControlValue?.top) || defaultValue;
  const column = getSpacingPresetCssVar(blockGapBoxControlValue?.left) || defaultValue;
  return row === column ? row : `${row} ${column}`;
}


;// ./node_modules/@wordpress/icons/build-module/library/justify-top.js


var justify_top_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M9 20h6V9H9v11zM4 4v1.5h16V4H4z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-center-vertical.js


var justify_center_vertical_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M20 11h-5V4H9v7H4v1.5h5V20h6v-7.5h5z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-bottom.js


var justify_bottom_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M15 4H9v11h6V4zM4 18.5V20h16v-1.5H4z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-stretch-vertical.js


var justify_stretch_vertical_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4 4L20 4L20 5.5L4 5.5L4 4ZM10 7L14 7L14 17L10 17L10 7ZM20 18.5L4 18.5L4 20L20 20L20 18.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/justify-space-between-vertical.js


var justify_space_between_vertical_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7 4H17V8L7 8V4ZM7 16L17 16V20L7 20V16ZM20 11.25H4V12.75H20V11.25Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/ui.js




const BLOCK_ALIGNMENTS_CONTROLS = {
  top: {
    icon: justify_top_default,
    title: (0,external_wp_i18n_namespaceObject._x)("Align top", "Block vertical alignment setting")
  },
  center: {
    icon: justify_center_vertical_default,
    title: (0,external_wp_i18n_namespaceObject._x)("Align middle", "Block vertical alignment setting")
  },
  bottom: {
    icon: justify_bottom_default,
    title: (0,external_wp_i18n_namespaceObject._x)("Align bottom", "Block vertical alignment setting")
  },
  stretch: {
    icon: justify_stretch_vertical_default,
    title: (0,external_wp_i18n_namespaceObject._x)("Stretch to fill", "Block vertical alignment setting")
  },
  "space-between": {
    icon: justify_space_between_vertical_default,
    title: (0,external_wp_i18n_namespaceObject._x)("Space between", "Block vertical alignment setting")
  }
};
const DEFAULT_CONTROLS = ["top", "center", "bottom"];
const DEFAULT_CONTROL = "top";
function BlockVerticalAlignmentUI({
  value,
  onChange,
  controls = DEFAULT_CONTROLS,
  isCollapsed = true,
  isToolbar
}) {
  function applyOrUnset(align) {
    return () => onChange(value === align ? void 0 : align);
  }
  const activeAlignment = BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? { isCollapsed } : {};
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    UIComponent,
    {
      icon: activeAlignment ? activeAlignment.icon : defaultAlignmentControl.icon,
      label: (0,external_wp_i18n_namespaceObject._x)(
        "Change vertical alignment",
        "Block vertical alignment setting label"
      ),
      controls: controls.map((control) => {
        return {
          ...BLOCK_ALIGNMENTS_CONTROLS[control],
          isActive: value === control,
          role: isCollapsed ? "menuitemradio" : void 0,
          onClick: applyOrUnset(control)
        };
      }),
      ...extraProps
    }
  );
}
var ui_default = BlockVerticalAlignmentUI;


;// ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/index.js


const BlockVerticalAlignmentControl = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ui_default, { ...props, isToolbar: false });
};
const BlockVerticalAlignmentToolbar = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ui_default, { ...props, isToolbar: true });
};


;// ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/ui.js




const icons = {
  left: justify_left_default,
  center: justify_center_default,
  right: justify_right_default,
  "space-between": justify_space_between_default,
  stretch: justify_stretch_default
};
function JustifyContentUI({
  allowedControls = ["left", "center", "right", "space-between"],
  isCollapsed = true,
  onChange,
  value,
  popoverProps,
  isToolbar
}) {
  const handleClick = (next) => {
    if (next === value) {
      onChange(void 0);
    } else {
      onChange(next);
    }
  };
  const icon = value ? icons[value] : icons.left;
  const allControls = [
    {
      name: "left",
      icon: justify_left_default,
      title: (0,external_wp_i18n_namespaceObject.__)("Justify items left"),
      isActive: "left" === value,
      onClick: () => handleClick("left")
    },
    {
      name: "center",
      icon: justify_center_default,
      title: (0,external_wp_i18n_namespaceObject.__)("Justify items center"),
      isActive: "center" === value,
      onClick: () => handleClick("center")
    },
    {
      name: "right",
      icon: justify_right_default,
      title: (0,external_wp_i18n_namespaceObject.__)("Justify items right"),
      isActive: "right" === value,
      onClick: () => handleClick("right")
    },
    {
      name: "space-between",
      icon: justify_space_between_default,
      title: (0,external_wp_i18n_namespaceObject.__)("Space between items"),
      isActive: "space-between" === value,
      onClick: () => handleClick("space-between")
    },
    {
      name: "stretch",
      icon: justify_stretch_default,
      title: (0,external_wp_i18n_namespaceObject.__)("Stretch items"),
      isActive: "stretch" === value,
      onClick: () => handleClick("stretch")
    }
  ];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? { isCollapsed } : {};
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    UIComponent,
    {
      icon,
      popoverProps,
      label: (0,external_wp_i18n_namespaceObject.__)("Change items justification"),
      controls: allControls.filter(
        (elem) => allowedControls.includes(elem.name)
      ),
      ...extraProps
    }
  );
}
var ui_ui_default = JustifyContentUI;


;// ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js


const JustifyContentControl = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ui_ui_default, { ...props, isToolbar: false });
};
const JustifyToolbar = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ui_ui_default, { ...props, isToolbar: true });
};


;// ./node_modules/@wordpress/block-editor/build-module/layouts/flex.js









const justifyContentMap = {
  left: "flex-start",
  right: "flex-end",
  center: "center",
  "space-between": "space-between"
};
const alignItemsMap = {
  left: "flex-start",
  right: "flex-end",
  center: "center",
  stretch: "stretch"
};
const verticalAlignmentMap = {
  top: "flex-start",
  center: "center",
  bottom: "flex-end",
  stretch: "stretch",
  "space-between": "space-between"
};
const defaultAlignments = {
  horizontal: "center",
  vertical: "top"
};
const flexWrapOptions = ["wrap", "nowrap"];
var flex_default = {
  name: "flex",
  label: (0,external_wp_i18n_namespaceObject.__)("Flex"),
  inspectorControls: function FlexLayoutInspectorControls({
    layout = {},
    onChange,
    layoutBlockSupport = {}
  }) {
    const { allowOrientation = true, allowJustification = true } = layoutBlockSupport;
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, { children: [
        allowJustification && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          FlexLayoutJustifyContentControl,
          {
            layout,
            onChange
          }
        ) }),
        allowOrientation && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          OrientationControl,
          {
            layout,
            onChange
          }
        ) })
      ] }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(FlexWrapControl, { layout, onChange })
    ] });
  },
  toolBarControls: function FlexLayoutToolbarControls({
    layout = {},
    onChange,
    layoutBlockSupport
  }) {
    const { allowVerticalAlignment = true, allowJustification = true } = layoutBlockSupport;
    if (!allowJustification && !allowVerticalAlignment) {
      return null;
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(block_controls_default, { group: "block", __experimentalShareWithChildBlocks: true, children: [
      allowJustification && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        FlexLayoutJustifyContentControl,
        {
          layout,
          onChange,
          isToolbar: true
        }
      ),
      allowVerticalAlignment && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        FlexLayoutVerticalAlignmentControl,
        {
          layout,
          onChange
        }
      )
    ] });
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const { orientation = "horizontal" } = layout;
    const blockGapValue = style?.spacing?.blockGap && !shouldSkipSerialization(blockName, "spacing", "blockGap") ? getGapCSSValue(style?.spacing?.blockGap, "0.5em") : void 0;
    const justifyContent = justifyContentMap[layout.justifyContent];
    const flexWrap = flexWrapOptions.includes(layout.flexWrap) ? layout.flexWrap : "wrap";
    const verticalAlignment = verticalAlignmentMap[layout.verticalAlignment];
    const alignItems = alignItemsMap[layout.justifyContent] || alignItemsMap.left;
    let output = "";
    const rules = [];
    if (flexWrap && flexWrap !== "wrap") {
      rules.push(`flex-wrap: ${flexWrap}`);
    }
    if (orientation === "horizontal") {
      if (verticalAlignment) {
        rules.push(`align-items: ${verticalAlignment}`);
      }
      if (justifyContent) {
        rules.push(`justify-content: ${justifyContent}`);
      }
    } else {
      if (verticalAlignment) {
        rules.push(`justify-content: ${verticalAlignment}`);
      }
      rules.push("flex-direction: column");
      rules.push(`align-items: ${alignItems}`);
    }
    if (rules.length) {
      output = `${appendSelectors(selector)} {
				${rules.join("; ")};
			}`;
    }
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(
        selector,
        layoutDefinitions,
        "flex",
        blockGapValue
      );
    }
    return output;
  },
  getOrientation(layout) {
    const { orientation = "horizontal" } = layout;
    return orientation;
  },
  getAlignments() {
    return [];
  }
};
function FlexLayoutVerticalAlignmentControl({ layout, onChange }) {
  const { orientation = "horizontal" } = layout;
  const defaultVerticalAlignment = orientation === "horizontal" ? defaultAlignments.horizontal : defaultAlignments.vertical;
  const { verticalAlignment = defaultVerticalAlignment } = layout;
  const onVerticalAlignmentChange = (value) => {
    onChange({
      ...layout,
      verticalAlignment: value
    });
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    BlockVerticalAlignmentControl,
    {
      onChange: onVerticalAlignmentChange,
      value: verticalAlignment,
      controls: orientation === "horizontal" ? ["top", "center", "bottom", "stretch"] : ["top", "center", "bottom", "space-between"]
    }
  );
}
const POPOVER_PROPS = {
  placement: "bottom-start"
};
function FlexLayoutJustifyContentControl({
  layout,
  onChange,
  isToolbar = false
}) {
  const { justifyContent = "left", orientation = "horizontal" } = layout;
  const onJustificationChange = (value) => {
    onChange({
      ...layout,
      justifyContent: value
    });
  };
  const allowedControls = ["left", "center", "right"];
  if (orientation === "horizontal") {
    allowedControls.push("space-between");
  } else {
    allowedControls.push("stretch");
  }
  if (isToolbar) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      JustifyContentControl,
      {
        allowedControls,
        value: justifyContent,
        onChange: onJustificationChange,
        popoverProps: POPOVER_PROPS
      }
    );
  }
  const justificationOptions = [
    {
      value: "left",
      icon: justify_left_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Justify items left")
    },
    {
      value: "center",
      icon: justify_center_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Justify items center")
    },
    {
      value: "right",
      icon: justify_right_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Justify items right")
    }
  ];
  if (orientation === "horizontal") {
    justificationOptions.push({
      value: "space-between",
      icon: justify_space_between_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Space between items")
    });
  } else {
    justificationOptions.push({
      value: "stretch",
      icon: justify_stretch_default,
      label: (0,external_wp_i18n_namespaceObject.__)("Stretch items")
    });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Justification"),
      value: justifyContent,
      onChange: onJustificationChange,
      className: "block-editor-hooks__flex-layout-justification-controls",
      children: justificationOptions.map(({ value, icon, label }) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            value,
            icon,
            label
          },
          value
        );
      })
    }
  );
}
function FlexWrapControl({ layout, onChange }) {
  const { flexWrap = "wrap" } = layout;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.ToggleControl,
    {
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Allow to wrap to multiple lines"),
      onChange: (value) => {
        onChange({
          ...layout,
          flexWrap: value ? "wrap" : "nowrap"
        });
      },
      checked: flexWrap === "wrap"
    }
  );
}
function OrientationControl({ layout, onChange }) {
  const {
    orientation = "horizontal",
    verticalAlignment,
    justifyContent
  } = layout;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      className: "block-editor-hooks__flex-layout-orientation-controls",
      label: (0,external_wp_i18n_namespaceObject.__)("Orientation"),
      value: orientation,
      onChange: (value) => {
        let newVerticalAlignment = verticalAlignment;
        let newJustification = justifyContent;
        if (value === "horizontal") {
          if (verticalAlignment === "space-between") {
            newVerticalAlignment = "center";
          }
          if (justifyContent === "stretch") {
            newJustification = "left";
          }
        } else {
          if (verticalAlignment === "stretch") {
            newVerticalAlignment = "top";
          }
          if (justifyContent === "space-between") {
            newJustification = "left";
          }
        }
        return onChange({
          ...layout,
          orientation: value,
          verticalAlignment: newVerticalAlignment,
          justifyContent: newJustification
        });
      },
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            icon: arrow_right_default,
            value: "horizontal",
            label: (0,external_wp_i18n_namespaceObject.__)("Horizontal")
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            icon: arrow_down_default,
            value: "vertical",
            label: (0,external_wp_i18n_namespaceObject.__)("Vertical")
          }
        )
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/layouts/flow.js





var flow_default = {
  name: "default",
  label: (0,external_wp_i18n_namespaceObject.__)("Flow"),
  inspectorControls: function DefaultLayoutInspectorControls() {
    return null;
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const blockGapStyleValue = getGapCSSValue(style?.spacing?.blockGap);
    let blockGapValue = "";
    if (!shouldSkipSerialization(blockName, "spacing", "blockGap")) {
      if (blockGapStyleValue?.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue?.top);
      } else if (typeof blockGapStyleValue === "string") {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }
    let output = "";
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(
        selector,
        layoutDefinitions,
        "default",
        blockGapValue
      );
    }
    return output;
  },
  getOrientation() {
    return "vertical";
  },
  getAlignments(layout, isBlockBasedTheme) {
    const alignmentInfo = getAlignmentsInfo(layout);
    if (layout.alignments !== void 0) {
      if (!layout.alignments.includes("none")) {
        layout.alignments.unshift("none");
      }
      return layout.alignments.map((alignment) => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }
    const alignments = [
      { name: "left" },
      { name: "center" },
      { name: "right" }
    ];
    if (!isBlockBasedTheme) {
      const { contentSize, wideSize } = layout;
      if (contentSize) {
        alignments.unshift({ name: "full" });
      }
      if (wideSize) {
        alignments.unshift({
          name: "wide",
          info: alignmentInfo.wide
        });
      }
    }
    alignments.unshift({ name: "none", info: alignmentInfo.none });
    return alignments;
  }
};


;// ./node_modules/@wordpress/icons/build-module/icon/index.js

var icon_default = (0,external_wp_element_namespaceObject.forwardRef)(
  ({ icon, size = 24, ...props }, ref) => {
    return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
      width: size,
      height: size,
      ...props,
      ref
    });
  }
);


;// ./node_modules/@wordpress/icons/build-module/library/align-none.js


var align_none_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19 5.5H5V4h14v1.5ZM19 20H5v-1.5h14V20ZM5 9h14v6H5V9Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/stretch-wide.js


var stretch_wide_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M16 5.5H8V4h8v1.5ZM16 20H8v-1.5h8V20ZM5 9h14v6H5V9Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/layouts/constrained.js











var constrained_default = {
  name: "constrained",
  label: (0,external_wp_i18n_namespaceObject.__)("Constrained"),
  inspectorControls: function DefaultLayoutInspectorControls({
    layout,
    onChange,
    layoutBlockSupport = {}
  }) {
    const { wideSize, contentSize, justifyContent = "center" } = layout;
    const {
      allowJustification = true,
      allowCustomContentAndWideSize = true
    } = layoutBlockSupport;
    const onJustificationChange = (value) => {
      onChange({
        ...layout,
        justifyContent: value
      });
    };
    const justificationOptions = [
      {
        value: "left",
        icon: justify_left_default,
        label: (0,external_wp_i18n_namespaceObject.__)("Justify items left")
      },
      {
        value: "center",
        icon: justify_center_default,
        label: (0,external_wp_i18n_namespaceObject.__)("Justify items center")
      },
      {
        value: "right",
        icon: justify_right_default,
        label: (0,external_wp_i18n_namespaceObject.__)("Justify items right")
      }
    ];
    const [availableUnits] = use_settings_useSettings("spacing.units");
    const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
      availableUnits: availableUnits || ["%", "px", "em", "rem", "vw"]
    });
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.__experimentalVStack,
      {
        spacing: 4,
        className: "block-editor-hooks__layout-constrained",
        children: [
          allowCustomContentAndWideSize && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalUnitControl,
              {
                __next40pxDefaultSize: true,
                label: (0,external_wp_i18n_namespaceObject.__)("Content width"),
                labelPosition: "top",
                value: contentSize || wideSize || "",
                onChange: (nextWidth) => {
                  nextWidth = 0 > parseFloat(nextWidth) ? "0" : nextWidth;
                  onChange({
                    ...layout,
                    contentSize: nextWidth
                  });
                },
                units,
                prefix: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlPrefixWrapper, { variant: "icon", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: align_none_default }) })
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalUnitControl,
              {
                __next40pxDefaultSize: true,
                label: (0,external_wp_i18n_namespaceObject.__)("Wide width"),
                labelPosition: "top",
                value: wideSize || contentSize || "",
                onChange: (nextWidth) => {
                  nextWidth = 0 > parseFloat(nextWidth) ? "0" : nextWidth;
                  onChange({
                    ...layout,
                    wideSize: nextWidth
                  });
                },
                units,
                prefix: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlPrefixWrapper, { variant: "icon", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: stretch_wide_default }) })
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "block-editor-hooks__layout-constrained-helptext", children: (0,external_wp_i18n_namespaceObject.__)(
              "Customize the width for all elements that are assigned to the center or wide columns."
            ) })
          ] }),
          allowJustification && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalToggleGroupControl,
            {
              __next40pxDefaultSize: true,
              __nextHasNoMarginBottom: true,
              label: (0,external_wp_i18n_namespaceObject.__)("Justification"),
              value: justifyContent,
              onChange: onJustificationChange,
              children: justificationOptions.map(
                ({ value, icon, label }) => {
                  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                    external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
                    {
                      value,
                      icon,
                      label
                    },
                    value
                  );
                }
              )
            }
          )
        ]
      }
    );
  },
  toolBarControls: function DefaultLayoutToolbarControls({
    layout = {},
    onChange,
    layoutBlockSupport
  }) {
    const { allowJustification = true } = layoutBlockSupport;
    if (!allowJustification) {
      return null;
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls_default, { group: "block", __experimentalShareWithChildBlocks: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      DefaultLayoutJustifyContentControl,
      {
        layout,
        onChange
      }
    ) });
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout = {},
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const { contentSize, wideSize, justifyContent } = layout;
    const blockGapStyleValue = getGapCSSValue(style?.spacing?.blockGap);
    let blockGapValue = "";
    if (!shouldSkipSerialization(blockName, "spacing", "blockGap")) {
      if (blockGapStyleValue?.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue?.top);
      } else if (typeof blockGapStyleValue === "string") {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }
    const marginLeft = justifyContent === "left" ? "0 !important" : "auto !important";
    const marginRight = justifyContent === "right" ? "0 !important" : "auto !important";
    let output = !!contentSize || !!wideSize ? `
					${appendSelectors(
      selector,
      "> :where(:not(.alignleft):not(.alignright):not(.alignfull))"
    )} {
						max-width: ${contentSize ?? wideSize};
						margin-left: ${marginLeft};
						margin-right: ${marginRight};
					}
					${appendSelectors(selector, "> .alignwide")}  {
						max-width: ${wideSize ?? contentSize};
					}
					${appendSelectors(selector, "> .alignfull")} {
						max-width: none;
					}
				` : "";
    if (justifyContent === "left") {
      output += `${appendSelectors(
        selector,
        "> :where(:not(.alignleft):not(.alignright):not(.alignfull))"
      )}
			{ margin-left: ${marginLeft}; }`;
    } else if (justifyContent === "right") {
      output += `${appendSelectors(
        selector,
        "> :where(:not(.alignleft):not(.alignright):not(.alignfull))"
      )}
			{ margin-right: ${marginRight}; }`;
    }
    if (style?.spacing?.padding) {
      const paddingValues = (0,external_wp_styleEngine_namespaceObject.getCSSRules)(style);
      paddingValues.forEach((rule) => {
        if (rule.key === "paddingRight") {
          const paddingRightValue = rule.value === "0" ? "0px" : rule.value;
          output += `
					${appendSelectors(selector, "> .alignfull")} {
						margin-right: calc(${paddingRightValue} * -1);
					}
					`;
        } else if (rule.key === "paddingLeft") {
          const paddingLeftValue = rule.value === "0" ? "0px" : rule.value;
          output += `
					${appendSelectors(selector, "> .alignfull")} {
						margin-left: calc(${paddingLeftValue} * -1);
					}
					`;
        }
      });
    }
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(
        selector,
        layoutDefinitions,
        "constrained",
        blockGapValue
      );
    }
    return output;
  },
  getOrientation() {
    return "vertical";
  },
  getAlignments(layout) {
    const alignmentInfo = getAlignmentsInfo(layout);
    if (layout.alignments !== void 0) {
      if (!layout.alignments.includes("none")) {
        layout.alignments.unshift("none");
      }
      return layout.alignments.map((alignment) => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }
    const { contentSize, wideSize } = layout;
    const alignments = [
      { name: "left" },
      { name: "center" },
      { name: "right" }
    ];
    if (contentSize) {
      alignments.unshift({ name: "full" });
    }
    if (wideSize) {
      alignments.unshift({ name: "wide", info: alignmentInfo.wide });
    }
    alignments.unshift({ name: "none", info: alignmentInfo.none });
    return alignments;
  }
};
const constrained_POPOVER_PROPS = {
  placement: "bottom-start"
};
function DefaultLayoutJustifyContentControl({ layout, onChange }) {
  const { justifyContent = "center" } = layout;
  const onJustificationChange = (value) => {
    onChange({
      ...layout,
      justifyContent: value
    });
  };
  const allowedControls = ["left", "center", "right"];
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    JustifyContentControl,
    {
      allowedControls,
      value: justifyContent,
      onChange: onJustificationChange,
      popoverProps: constrained_POPOVER_PROPS
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/layouts/grid.js








const RANGE_CONTROL_MAX_VALUES = {
  px: 600,
  "%": 100,
  vw: 100,
  vh: 100,
  em: 38,
  rem: 38,
  svw: 100,
  lvw: 100,
  dvw: 100,
  svh: 100,
  lvh: 100,
  dvh: 100,
  vi: 100,
  svi: 100,
  lvi: 100,
  dvi: 100,
  vb: 100,
  svb: 100,
  lvb: 100,
  dvb: 100,
  vmin: 100,
  svmin: 100,
  lvmin: 100,
  dvmin: 100,
  vmax: 100,
  svmax: 100,
  lvmax: 100,
  dvmax: 100
};
const units = [
  { value: "px", label: "px", default: 0 },
  { value: "rem", label: "rem", default: 0 },
  { value: "em", label: "em", default: 0 }
];
var grid_default = {
  name: "grid",
  label: (0,external_wp_i18n_namespaceObject.__)("Grid"),
  inspectorControls: function GridLayoutInspectorControls({
    layout = {},
    onChange,
    layoutBlockSupport = {}
  }) {
    const { allowSizingOnChildren = false } = layoutBlockSupport;
    const showColumnsControl = window.__experimentalEnableGridInteractivity || !!layout?.columnCount;
    const showMinWidthControl = window.__experimentalEnableGridInteractivity || !layout?.columnCount;
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        GridLayoutTypeControl,
        {
          layout,
          onChange
        }
      ),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 4, children: [
        showColumnsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          GridLayoutColumnsAndRowsControl,
          {
            layout,
            onChange,
            allowSizingOnChildren
          }
        ),
        showMinWidthControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          GridLayoutMinimumWidthControl,
          {
            layout,
            onChange
          }
        )
      ] })
    ] });
  },
  toolBarControls: function GridLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const {
      minimumColumnWidth = null,
      columnCount = null,
      rowCount = null
    } = layout;
    if (false) {}
    const blockGapValue = style?.spacing?.blockGap && !shouldSkipSerialization(blockName, "spacing", "blockGap") ? getGapCSSValue(style?.spacing?.blockGap, "0.5em") : void 0;
    let output = "";
    const rules = [];
    if (minimumColumnWidth && columnCount > 0) {
      const maxValue = `max(${minimumColumnWidth}, ( 100% - (${blockGapValue || "1.2rem"}*${columnCount - 1}) ) / ${columnCount})`;
      rules.push(
        `grid-template-columns: repeat(auto-fill, minmax(${maxValue}, 1fr))`,
        `container-type: inline-size`
      );
      if (rowCount) {
        rules.push(
          `grid-template-rows: repeat(${rowCount}, minmax(1rem, auto))`
        );
      }
    } else if (columnCount) {
      rules.push(
        `grid-template-columns: repeat(${columnCount}, minmax(0, 1fr))`
      );
      if (rowCount) {
        rules.push(
          `grid-template-rows: repeat(${rowCount}, minmax(1rem, auto))`
        );
      }
    } else {
      rules.push(
        `grid-template-columns: repeat(auto-fill, minmax(min(${minimumColumnWidth || "12rem"}, 100%), 1fr))`,
        "container-type: inline-size"
      );
    }
    if (rules.length) {
      output = `${appendSelectors(selector)} { ${rules.join(
        "; "
      )}; }`;
    }
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(
        selector,
        layoutDefinitions,
        "grid",
        blockGapValue
      );
    }
    return output;
  },
  getOrientation() {
    return "horizontal";
  },
  getAlignments() {
    return [];
  }
};
function GridLayoutMinimumWidthControl({ layout, onChange }) {
  const { minimumColumnWidth, columnCount, isManualPlacement } = layout;
  const defaultValue = isManualPlacement || columnCount ? null : "12rem";
  const value = minimumColumnWidth || defaultValue;
  const [quantity, unit = "rem"] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);
  const handleSliderChange = (next) => {
    onChange({
      ...layout,
      minimumColumnWidth: [next, unit].join("")
    });
  };
  const handleUnitChange = (newUnit) => {
    let newValue;
    if (["em", "rem"].includes(newUnit) && unit === "px") {
      newValue = (quantity / 16).toFixed(2) + newUnit;
    } else if (["em", "rem"].includes(unit) && newUnit === "px") {
      newValue = Math.round(quantity * 16) + newUnit;
    }
    onChange({
      ...layout,
      minimumColumnWidth: newValue
    });
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "block-editor-hooks__grid-layout-minimum-width-control", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { as: "legend", children: (0,external_wp_i18n_namespaceObject.__)("Minimum column width") }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, { gap: 4, children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalUnitControl,
        {
          size: "__unstable-large",
          onChange: (newValue) => {
            onChange({
              ...layout,
              minimumColumnWidth: newValue === "" ? void 0 : newValue
            });
          },
          onUnitChange: handleUnitChange,
          value,
          units,
          min: 0,
          label: (0,external_wp_i18n_namespaceObject.__)("Minimum column width"),
          hideLabelFromVision: true
        }
      ) }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.RangeControl,
        {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          onChange: handleSliderChange,
          value: quantity || 0,
          min: 0,
          max: RANGE_CONTROL_MAX_VALUES[unit] || 600,
          withInputField: false,
          label: (0,external_wp_i18n_namespaceObject.__)("Minimum column width"),
          hideLabelFromVision: true
        }
      ) })
    ] })
  ] });
}
function GridLayoutColumnsAndRowsControl({
  layout,
  onChange,
  allowSizingOnChildren
}) {
  const defaultColumnCount = window.__experimentalEnableGridInteractivity ? void 0 : 3;
  const {
    columnCount = defaultColumnCount,
    rowCount,
    isManualPlacement
  } = layout;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "block-editor-hooks__grid-layout-columns-and-rows-controls", children: [
    (!window.__experimentalEnableGridInteractivity || !isManualPlacement) && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { as: "legend", children: (0,external_wp_i18n_namespaceObject.__)("Columns") }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, { gap: 4, children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalNumberControl,
        {
          size: "__unstable-large",
          onChange: (value) => {
            if (window.__experimentalEnableGridInteractivity) {
              const defaultNewColumnCount = isManualPlacement ? 1 : void 0;
              const newColumnCount = value === "" || value === "0" ? defaultNewColumnCount : parseInt(value, 10);
              onChange({
                ...layout,
                columnCount: newColumnCount
              });
            } else {
              const newColumnCount = value === "" || value === "0" ? 1 : parseInt(value, 10);
              onChange({
                ...layout,
                columnCount: newColumnCount
              });
            }
          },
          value: columnCount,
          min: 1,
          label: (0,external_wp_i18n_namespaceObject.__)("Columns"),
          hideLabelFromVision: !window.__experimentalEnableGridInteractivity || !isManualPlacement
        }
      ) }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: window.__experimentalEnableGridInteractivity && allowSizingOnChildren && isManualPlacement ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalNumberControl,
        {
          size: "__unstable-large",
          onChange: (value) => {
            const newRowCount = value === "" || value === "0" ? 1 : parseInt(value, 10);
            onChange({
              ...layout,
              rowCount: newRowCount
            });
          },
          value: rowCount,
          min: 1,
          label: (0,external_wp_i18n_namespaceObject.__)("Rows")
        }
      ) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.RangeControl,
        {
          __next40pxDefaultSize: true,
          __nextHasNoMarginBottom: true,
          value: columnCount ?? 1,
          onChange: (value) => onChange({
            ...layout,
            columnCount: value === "" || value === "0" ? 1 : value
          }),
          min: 1,
          max: 16,
          withInputField: false,
          label: (0,external_wp_i18n_namespaceObject.__)("Columns"),
          hideLabelFromVision: true
        }
      ) })
    ] })
  ] }) });
}
function GridLayoutTypeControl({ layout, onChange }) {
  const { columnCount, rowCount, minimumColumnWidth, isManualPlacement } = layout;
  const [tempColumnCount, setTempColumnCount] = (0,external_wp_element_namespaceObject.useState)(
    columnCount || 3
  );
  const [tempRowCount, setTempRowCount] = (0,external_wp_element_namespaceObject.useState)(rowCount);
  const [tempMinimumColumnWidth, setTempMinimumColumnWidth] = (0,external_wp_element_namespaceObject.useState)(
    minimumColumnWidth || "12rem"
  );
  const gridPlacement = isManualPlacement || !!columnCount && !window.__experimentalEnableGridInteractivity ? "manual" : "auto";
  const onChangeType = (value) => {
    if (value === "manual") {
      setTempMinimumColumnWidth(minimumColumnWidth || "12rem");
    } else {
      setTempColumnCount(columnCount || 3);
      setTempRowCount(rowCount);
    }
    onChange({
      ...layout,
      columnCount: value === "manual" ? tempColumnCount : null,
      rowCount: value === "manual" && window.__experimentalEnableGridInteractivity ? tempRowCount : void 0,
      isManualPlacement: value === "manual" && window.__experimentalEnableGridInteractivity ? true : void 0,
      minimumColumnWidth: value === "auto" ? tempMinimumColumnWidth : null
    });
  };
  const helpText = gridPlacement === "manual" ? (0,external_wp_i18n_namespaceObject.__)(
    "Grid items can be manually placed in any position on the grid."
  ) : (0,external_wp_i18n_namespaceObject.__)(
    "Grid items are placed automatically depending on their order."
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Grid item position"),
      value: gridPlacement,
      onChange: onChangeType,
      isBlock: true,
      help: window.__experimentalEnableGridInteractivity ? helpText : void 0,
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
          {
            value: "auto",
            label: (0,external_wp_i18n_namespaceObject.__)("Auto")
          },
          "auto"
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
          {
            value: "manual",
            label: (0,external_wp_i18n_namespaceObject.__)("Manual")
          },
          "manual"
        )
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/layouts/index.js




const layoutTypes = [flow_default, flex_default, constrained_default, grid_default];
function getLayoutType(name = "default") {
  return layoutTypes.find((layoutType) => layoutType.name === name);
}
function getLayoutTypes() {
  return layoutTypes;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-list/layout.js




const defaultLayout = { type: "default" };
const Layout = (0,external_wp_element_namespaceObject.createContext)(defaultLayout);
Layout.displayName = "BlockLayoutContext";
const LayoutProvider = Layout.Provider;
function useLayout() {
  return (0,external_wp_element_namespaceObject.useContext)(Layout);
}
function LayoutStyle({ layout = {}, css, ...props }) {
  const layoutType = getLayoutType(layout.type);
  const [blockGapSupport] = use_settings_useSettings("spacing.blockGap");
  const hasBlockGapSupport = blockGapSupport !== null;
  if (layoutType) {
    if (css) {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("style", { children: css });
    }
    const layoutStyle = layoutType.getLayoutStyle?.({
      hasBlockGapSupport,
      layout,
      ...props
    });
    if (layoutStyle) {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("style", { children: layoutStyle });
    }
  }
  return null;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/use-available-alignments.js




const use_available_alignments_EMPTY_ARRAY = [];
const use_available_alignments_DEFAULT_CONTROLS = ["none", "left", "center", "right", "wide", "full"];
const WIDE_CONTROLS = ["wide", "full"];
function useAvailableAlignments(controls = use_available_alignments_DEFAULT_CONTROLS) {
  if (!controls.includes("none")) {
    controls = ["none", ...controls];
  }
  const isNoneOnly = controls.length === 1 && controls[0] === "none";
  const [wideControlsEnabled, themeSupportsLayout, isBlockBasedTheme] = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      if (isNoneOnly) {
        return [false, false, false];
      }
      const settings = select(store).getSettings();
      return [
        settings.alignWide ?? false,
        settings.supportsLayout,
        settings.__unstableIsBlockBasedTheme
      ];
    },
    [isNoneOnly]
  );
  const layout = useLayout();
  if (isNoneOnly) {
    return use_available_alignments_EMPTY_ARRAY;
  }
  const layoutType = getLayoutType(layout?.type);
  if (themeSupportsLayout) {
    const layoutAlignments = layoutType.getAlignments(
      layout,
      isBlockBasedTheme
    );
    const alignments2 = layoutAlignments.filter(
      (alignment) => controls.includes(alignment.name)
    );
    if (alignments2.length === 1 && alignments2[0].name === "none") {
      return use_available_alignments_EMPTY_ARRAY;
    }
    return alignments2;
  }
  if (layoutType.name !== "default" && layoutType.name !== "constrained") {
    return use_available_alignments_EMPTY_ARRAY;
  }
  const alignments = controls.filter((control) => {
    if (layout.alignments) {
      return layout.alignments.includes(control);
    }
    if (!wideControlsEnabled && WIDE_CONTROLS.includes(control)) {
      return false;
    }
    return use_available_alignments_DEFAULT_CONTROLS.includes(control);
  }).map((name) => ({ name }));
  if (alignments.length === 1 && alignments[0].name === "none") {
    return use_available_alignments_EMPTY_ARRAY;
  }
  return alignments;
}


;// ./node_modules/@wordpress/icons/build-module/library/position-left.js


var position_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5 5.5h8V4H5v1.5ZM5 20h8v-1.5H5V20ZM19 9H5v6h14V9Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/position-center.js


var position_center_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19 5.5H5V4h14v1.5ZM19 20H5v-1.5h14V20ZM7 9h10v6H7V9Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/position-right.js


var position_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19 5.5h-8V4h8v1.5ZM19 20h-8v-1.5h8V20ZM5 9h14v6H5V9Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/stretch-full-width.js


var stretch_full_width_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5 4h14v11H5V4Zm11 16H8v-1.5h8V20Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/constants.js


const constants_BLOCK_ALIGNMENTS_CONTROLS = {
  none: {
    icon: align_none_default,
    title: (0,external_wp_i18n_namespaceObject._x)("None", "Alignment option")
  },
  left: {
    icon: position_left_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align left")
  },
  center: {
    icon: position_center_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align center")
  },
  right: {
    icon: position_right_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align right")
  },
  wide: {
    icon: stretch_wide_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Wide width")
  },
  full: {
    icon: stretch_full_width_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Full width")
  }
};
const constants_DEFAULT_CONTROL = "none";


;// ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/ui.js






function BlockAlignmentUI({
  value,
  onChange,
  controls,
  isToolbar,
  isCollapsed = true
}) {
  const enabledControls = useAvailableAlignments(controls);
  const hasEnabledControls = !!enabledControls.length;
  if (!hasEnabledControls) {
    return null;
  }
  function onChangeAlignment(align) {
    onChange([value, "none"].includes(align) ? void 0 : align);
  }
  const activeAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[constants_DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const commonProps = {
    icon: activeAlignmentControl ? activeAlignmentControl.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject.__)("Align")
  };
  const extraProps = isToolbar ? {
    isCollapsed,
    controls: enabledControls.map(({ name: controlName }) => {
      return {
        ...constants_BLOCK_ALIGNMENTS_CONTROLS[controlName],
        isActive: value === controlName || !value && controlName === "none",
        role: isCollapsed ? "menuitemradio" : void 0,
        onClick: () => onChangeAlignment(controlName)
      };
    })
  } : {
    toggleProps: { description: (0,external_wp_i18n_namespaceObject.__)("Change alignment") },
    children: ({ onClose }) => {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, { className: "block-editor-block-alignment-control__menu-group", children: enabledControls.map(
        ({ name: controlName, info }) => {
          const { icon, title } = constants_BLOCK_ALIGNMENTS_CONTROLS[controlName];
          const isSelected = controlName === value || !value && controlName === "none";
          return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.MenuItem,
            {
              icon,
              iconPosition: "left",
              className: dist_clsx(
                "components-dropdown-menu__menu-item",
                {
                  "is-active": isSelected
                }
              ),
              isSelected,
              onClick: () => {
                onChangeAlignment(
                  controlName
                );
                onClose();
              },
              role: "menuitemradio",
              info,
              children: title
            },
            controlName
          );
        }
      ) }) });
    }
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(UIComponent, { ...commonProps, ...extraProps });
}
var block_alignment_control_ui_ui_default = BlockAlignmentUI;


;// ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/index.js


const BlockAlignmentControl = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_alignment_control_ui_ui_default, { ...props, isToolbar: false });
};
const BlockAlignmentToolbar = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_alignment_control_ui_ui_default, { ...props, isToolbar: true });
};


;// ./node_modules/@wordpress/block-editor/build-module/components/block-editing-mode/index.js




function useBlockEditingMode(mode) {
  const context = useBlockEditContext();
  const { clientId = "" } = context;
  const { setBlockEditingMode, unsetBlockEditingMode } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const globalBlockEditingMode = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => (
      // Avoid adding the subscription if not needed!
      clientId ? null : select(store).getBlockEditingMode()
    ),
    [clientId]
  );
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (mode) {
      setBlockEditingMode(clientId, mode);
    }
    return () => {
      if (mode) {
        unsetBlockEditingMode(clientId);
      }
    };
  }, [clientId, mode, setBlockEditingMode, unsetBlockEditingMode]);
  return clientId ? context[blockEditingModeKey] : globalBlockEditingMode;
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/align.js







const ALL_ALIGNMENTS = ["left", "center", "right", "wide", "full"];
const WIDE_ALIGNMENTS = ["wide", "full"];
function getValidAlignments(blockAlign, hasWideBlockSupport = true, hasWideEnabled = true) {
  let validAlignments;
  if (Array.isArray(blockAlign)) {
    validAlignments = ALL_ALIGNMENTS.filter(
      (value) => blockAlign.includes(value)
    );
  } else if (blockAlign === true) {
    validAlignments = [...ALL_ALIGNMENTS];
  } else {
    validAlignments = [];
  }
  if (!hasWideEnabled || blockAlign === true && !hasWideBlockSupport) {
    return validAlignments.filter(
      (alignment) => !WIDE_ALIGNMENTS.includes(alignment)
    );
  }
  return validAlignments;
}
function addAttribute(settings) {
  if ("type" in (settings.attributes?.align ?? {})) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "align")) {
    settings.attributes = {
      ...settings.attributes,
      align: {
        type: "string",
        // Allow for '' since it is used by the `updateAlignment` function
        // in toolbar controls for special cases with defined default values.
        enum: [...ALL_ALIGNMENTS, ""]
      }
    };
  }
  return settings;
}
function BlockEditAlignmentToolbarControlsPure({
  name: blockName,
  align,
  setAttributes
}) {
  const blockAllowedAlignments = getValidAlignments(
    (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, "align"),
    (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, "alignWide", true)
  );
  const validAlignments = useAvailableAlignments(
    blockAllowedAlignments
  ).map(({ name }) => name);
  const blockEditingMode = useBlockEditingMode();
  if (!validAlignments.length || blockEditingMode !== "default") {
    return null;
  }
  const updateAlignment = (nextAlign) => {
    if (!nextAlign) {
      const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
      const blockDefaultAlign = blockType?.attributes?.align?.default;
      if (blockDefaultAlign) {
        nextAlign = "";
      }
    }
    setAttributes({ align: nextAlign });
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls_default, { group: "block", __experimentalShareWithChildBlocks: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    BlockAlignmentControl,
    {
      value: align,
      onChange: updateAlignment,
      controls: validAlignments
    }
  ) });
}
var align_default = {
  shareWithChildBlocks: true,
  edit: BlockEditAlignmentToolbarControlsPure,
  useBlockProps,
  addSaveProps: addAssignedAlign,
  attributeKeys: ["align"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "align", false);
  }
};
function useBlockProps({ name, align }) {
  const blockAllowedAlignments = getValidAlignments(
    (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, "align"),
    (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "alignWide", true)
  );
  const validAlignments = useAvailableAlignments(blockAllowedAlignments);
  if (validAlignments.some((alignment) => alignment.name === align)) {
    return { "data-align": align };
  }
  return {};
}
function addAssignedAlign(props, blockType, attributes) {
  const { align } = attributes;
  const blockAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, "align");
  const hasWideBlockSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "alignWide", true);
  const isAlignValid = getValidAlignments(
    blockAlign,
    hasWideBlockSupport
  ).includes(align);
  if (isAlignValid) {
    props.className = dist_clsx(`align${align}`, props.className);
  }
  return props;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/editor/align/addAttribute",
  addAttribute
);


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/groups.js

const InspectorControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControls");
const InspectorControlsAdvanced = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorAdvancedControls");
const InspectorControlsBindings = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsBindings");
const InspectorControlsBackground = (0,external_wp_components_namespaceObject.createSlotFill)(
  "InspectorControlsBackground"
);
const InspectorControlsBorder = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsBorder");
const InspectorControlsColor = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsColor");
const InspectorControlsFilter = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsFilter");
const InspectorControlsDimensions = (0,external_wp_components_namespaceObject.createSlotFill)(
  "InspectorControlsDimensions"
);
const InspectorControlsPosition = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsPosition");
const InspectorControlsTypography = (0,external_wp_components_namespaceObject.createSlotFill)(
  "InspectorControlsTypography"
);
const InspectorControlsListView = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsListView");
const InspectorControlsStyles = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsStyles");
const InspectorControlsEffects = (0,external_wp_components_namespaceObject.createSlotFill)("InspectorControlsEffects");
const groups_groups = {
  default: InspectorControlsDefault,
  advanced: InspectorControlsAdvanced,
  background: InspectorControlsBackground,
  bindings: InspectorControlsBindings,
  border: InspectorControlsBorder,
  color: InspectorControlsColor,
  dimensions: InspectorControlsDimensions,
  effects: InspectorControlsEffects,
  filter: InspectorControlsFilter,
  list: InspectorControlsListView,
  position: InspectorControlsPosition,
  settings: InspectorControlsDefault,
  // Alias for default.
  styles: InspectorControlsStyles,
  typography: InspectorControlsTypography
};
var groups_groups_default = groups_groups;
const PrivateInspectorControlsAllowedBlocks = (0,external_wp_components_namespaceObject.createSlotFill)(
  Symbol("PrivateInspectorControlsAllowedBlocks")
);


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/fill.js







function InspectorControlsFill({
  children,
  group = "default",
  __experimentalGroup,
  resetAllFilter
}) {
  if (__experimentalGroup) {
    external_wp_deprecated_default()(
      "`__experimentalGroup` property in `InspectorControlsFill`",
      {
        since: "6.2",
        version: "6.4",
        alternative: "`group`"
      }
    );
    group = __experimentalGroup;
  }
  const context = useBlockEditContext();
  const Fill = groups_groups_default[group]?.Fill;
  if (!Fill) {
    external_wp_warning_default()(`Unknown InspectorControls group "${group}" provided.`);
    return null;
  }
  if (!context[mayDisplayControlsKey]) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalStyleProvider, { document, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Fill, { children: (fillProps) => {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      ToolsPanelInspectorControl,
      {
        fillProps,
        children,
        resetAllFilter
      }
    );
  } }) });
}
function RegisterResetAll({ resetAllFilter, children }) {
  const { registerResetAllFilter, deregisterResetAllFilter } = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (resetAllFilter && registerResetAllFilter && deregisterResetAllFilter) {
      registerResetAllFilter(resetAllFilter);
      return () => {
        deregisterResetAllFilter(resetAllFilter);
      };
    }
  }, [resetAllFilter, registerResetAllFilter, deregisterResetAllFilter]);
  return children;
}
function ToolsPanelInspectorControl({ children, resetAllFilter, fillProps }) {
  const { forwardedContext = [] } = fillProps;
  const innerMarkup = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(RegisterResetAll, { resetAllFilter, children });
  return forwardedContext.reduce(
    (inner, [Provider, props]) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Provider, { ...props, children: inner }),
    innerMarkup
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-tools-panel.js







function BlockSupportToolsPanel({ children, group, label }) {
  const { updateBlockAttributes } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    getBlockAttributes,
    getMultiSelectedBlockClientIds,
    getSelectedBlockClientId,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const panelId = getSelectedBlockClientId();
  const resetAll = (0,external_wp_element_namespaceObject.useCallback)(
    (resetFilters = []) => {
      const newAttributes = {};
      const clientIds = hasMultiSelection() ? getMultiSelectedBlockClientIds() : [panelId];
      clientIds.forEach((clientId) => {
        const { style } = getBlockAttributes(clientId);
        let newBlockAttributes = { style };
        resetFilters.forEach((resetFilter) => {
          newBlockAttributes = {
            ...newBlockAttributes,
            ...resetFilter(newBlockAttributes)
          };
        });
        newBlockAttributes = {
          ...newBlockAttributes,
          style: utils_cleanEmptyObject(newBlockAttributes.style)
        };
        newAttributes[clientId] = newBlockAttributes;
      });
      updateBlockAttributes(clientIds, newAttributes, true);
    },
    [
      getBlockAttributes,
      getMultiSelectedBlockClientIds,
      hasMultiSelection,
      panelId,
      updateBlockAttributes
    ]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      className: `${group}-block-support-panel`,
      label,
      resetAll,
      panelId,
      hasInnerWrapper: true,
      shouldRenderPlaceholderItems: true,
      __experimentalFirstVisibleItemClass: "first",
      __experimentalLastVisibleItemClass: "last",
      dropdownMenuProps,
      children
    },
    panelId
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-slot-container.js



function BlockSupportSlotContainer({
  Slot,
  fillProps,
  ...props
}) {
  const toolsPanelContext = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  const computedFillProps = (0,external_wp_element_namespaceObject.useMemo)(
    () => ({
      ...fillProps ?? {},
      forwardedContext: [
        ...fillProps?.forwardedContext ?? [],
        [external_wp_components_namespaceObject.__experimentalToolsPanelContext.Provider, { value: toolsPanelContext }]
      ]
    }),
    [toolsPanelContext, fillProps]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, { ...props, fillProps: computedFillProps, bubblesVirtually: true });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/slot.js







function InspectorControlsSlot({
  __experimentalGroup,
  group = "default",
  label,
  fillProps,
  ...props
}) {
  if (__experimentalGroup) {
    external_wp_deprecated_default()(
      "`__experimentalGroup` property in `InspectorControlsSlot`",
      {
        since: "6.2",
        version: "6.4",
        alternative: "`group`"
      }
    );
    group = __experimentalGroup;
  }
  const slotFill = groups_groups_default[group];
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(slotFill?.name);
  if (!slotFill) {
    external_wp_warning_default()(`Unknown InspectorControls group "${group}" provided.`);
    return null;
  }
  if (!fills?.length) {
    return null;
  }
  const { Slot } = slotFill;
  if (label) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockSupportToolsPanel, { group, label, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      BlockSupportSlotContainer,
      {
        ...props,
        fillProps,
        Slot
      }
    ) });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, { ...props, fillProps, bubblesVirtually: true });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/index.js



const InspectorControls = InspectorControlsFill;
InspectorControls.Slot = InspectorControlsSlot;
const InspectorAdvancedControls = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(InspectorControlsFill, { ...props, group: "advanced" });
};
InspectorAdvancedControls.Slot = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(InspectorControlsSlot, { ...props, group: "advanced" });
};
InspectorAdvancedControls.slotName = "InspectorAdvancedControls";
var inspector_controls_default = InspectorControls;


;// ./node_modules/@wordpress/icons/build-module/library/reset.js


var reset_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7 11.5h10V13H7z" }) });


;// external ["wp","url"]
const external_wp_url_namespaceObject = window["wp"]["url"];
;// external ["wp","dom"]
const external_wp_dom_namespaceObject = window["wp"]["dom"];
;// external ["wp","blob"]
const external_wp_blob_namespaceObject = window["wp"]["blob"];
;// external ["wp","keycodes"]
const external_wp_keycodes_namespaceObject = window["wp"]["keycodes"];
;// ./node_modules/@wordpress/icons/build-module/library/media.js


var media_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m7 6.5 4 2.5-4 2.5z" }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "m5 3c-1.10457 0-2 .89543-2 2v14c0 1.1046.89543 2 2 2h14c1.1046 0 2-.8954 2-2v-14c0-1.10457-.8954-2-2-2zm14 1.5h-14c-.27614 0-.5.22386-.5.5v10.7072l3.62953-2.6465c.25108-.1831.58905-.1924.84981-.0234l2.92666 1.8969 3.5712-3.4719c.2911-.2831.7545-.2831 1.0456 0l2.9772 2.8945v-9.3568c0-.27614-.2239-.5-.5-.5zm-14.5 14.5v-1.4364l4.09643-2.987 2.99567 1.9417c.2936.1903.6798.1523.9307-.0917l3.4772-3.3806 3.4772 3.3806.0228-.0234v2.5968c0 .2761-.2239.5-.5.5h-14c-.27614 0-.5-.2239-.5-.5z"
    }
  )
] });


;// ./node_modules/@wordpress/icons/build-module/library/upload.js


var upload_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M18.5 15v3.5H13V6.7l4.5 4.1 1-1.1-6.2-5.8-5.8 5.8 1 1.1 4-4v11.7h-6V15H4v5h16v-5z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/post-featured-image.js


var post_featured_image_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19 3H5c-.6 0-1 .4-1 1v7c0 .5.4 1 1 1h14c.5 0 1-.4 1-1V4c0-.6-.4-1-1-1zM5.5 10.5v-.4l1.8-1.3 1.3.8c.3.2.7.2.9-.1L11 8.1l2.4 2.4H5.5zm13 0h-2.9l-4-4c-.3-.3-.8-.3-1.1 0L8.9 8l-1.2-.8c-.3-.2-.6-.2-.9 0l-1.3 1V4.5h13v6zM4 20h9v-1.5H4V20zm0-4h16v-1.5H4V16z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/media-upload/index.js

const MediaUpload = () => null;
var media_upload_default = (0,external_wp_components_namespaceObject.withFilters)("editor.MediaUpload")(MediaUpload);


;// ./node_modules/@wordpress/block-editor/build-module/components/media-upload/check.js


function MediaUploadCheck({ fallback = null, children }) {
  const hasUploadPermissions = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const { getSettings } = select(store);
    return !!getSettings().mediaUpload;
  }, []);
  return hasUploadPermissions ? children : fallback;
}
var check_default = MediaUploadCheck;


;// external ["wp","isShallowEqual"]
const external_wp_isShallowEqual_namespaceObject = window["wp"]["isShallowEqual"];
var external_wp_isShallowEqual_default = /*#__PURE__*/__webpack_require__.n(external_wp_isShallowEqual_namespaceObject);
;// ./node_modules/@wordpress/icons/build-module/library/link-off.js


var link_off_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M17.031 4.703 15.576 4l-1.56 3H14v.03l-2.324 4.47H9.5V13h1.396l-1.502 2.889h-.95a3.694 3.694 0 0 1 0-7.389H10V7H8.444a5.194 5.194 0 1 0 0 10.389h.17L7.5 19.53l1.416.719L15.049 8.5h.507a3.694 3.694 0 0 1 0 7.39H14v1.5h1.556a5.194 5.194 0 0 0 .273-10.383l1.202-2.304Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/keyboard-return.js


var keyboard_return_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m6.734 16.106 2.176-2.38-1.093-1.028-3.846 4.158 3.846 4.158 1.093-1.028-2.176-2.38h2.811c1.125 0 2.25.03 3.374 0 1.428-.001 3.362-.25 4.963-1.277 1.66-1.065 2.868-2.906 2.868-5.859 0-2.479-1.327-4.896-3.65-5.93-1.82-.813-3.044-.8-4.806-.788l-.567.002v1.5c.184 0 .368 0 .553-.002 1.82-.007 2.704-.014 4.21.657 1.854.827 2.76 2.657 2.76 4.561 0 2.472-.973 3.824-2.178 4.596-1.258.807-2.864 1.04-4.163 1.04h-.02c-1.115.03-2.229 0-3.344 0H6.734Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/chevron-left-small.js


var chevron_left_small_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m13.1 16-3.4-4 3.4-4 1.1 1-2.6 3 2.6 3-1.1 1z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/chevron-right-small.js


var chevron_right_small_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M10.8622 8.04053L14.2805 12.0286L10.8622 16.0167L9.72327 15.0405L12.3049 12.0286L9.72327 9.01672L10.8622 8.04053Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/settings-drawer.js






function LinkSettingsDrawer({ children, settingsOpen, setSettingsOpen }) {
  const prefersReducedMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const MaybeAnimatePresence = prefersReducedMotion ? external_wp_element_namespaceObject.Fragment : external_wp_components_namespaceObject.__unstableAnimatePresence;
  const MaybeMotionDiv = prefersReducedMotion ? "div" : external_wp_components_namespaceObject.__unstableMotion.div;
  const id = (0,external_wp_compose_namespaceObject.useInstanceId)(LinkSettingsDrawer);
  const settingsDrawerId = `link-control-settings-drawer-${id}`;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        __next40pxDefaultSize: true,
        className: "block-editor-link-control__drawer-toggle",
        "aria-expanded": settingsOpen,
        onClick: () => setSettingsOpen(!settingsOpen),
        icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? chevron_left_small_default : chevron_right_small_default,
        "aria-controls": settingsDrawerId,
        children: (0,external_wp_i18n_namespaceObject._x)("Advanced", "Additional link settings")
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(MaybeAnimatePresence, { children: settingsOpen && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      MaybeMotionDiv,
      {
        className: "block-editor-link-control__drawer",
        hidden: !settingsOpen,
        id: settingsDrawerId,
        initial: "collapsed",
        animate: "open",
        exit: "collapsed",
        variants: {
          open: { opacity: 1, height: "auto" },
          collapsed: { opacity: 0, height: 0 }
        },
        transition: {
          duration: 0.1
        },
        children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-link-control__drawer-inner", children })
      }
    ) })
  ] });
}
var settings_drawer_default = LinkSettingsDrawer;


// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(1609);
;// ./node_modules/@wordpress/block-editor/build-module/components/url-input/index.js











function isFunction(maybeFunc) {
  return typeof maybeFunc === "function";
}
class URLInput extends external_wp_element_namespaceObject.Component {
  constructor(props) {
    super(props);
    this.onChange = this.onChange.bind(this);
    this.onFocus = this.onFocus.bind(this);
    this.onKeyDown = this.onKeyDown.bind(this);
    this.selectLink = this.selectLink.bind(this);
    this.handleOnClick = this.handleOnClick.bind(this);
    this.bindSuggestionNode = this.bindSuggestionNode.bind(this);
    this.autocompleteRef = props.autocompleteRef || (0,external_wp_element_namespaceObject.createRef)();
    this.inputRef = props.inputRef || (0,external_wp_element_namespaceObject.createRef)();
    this.updateSuggestions = (0,external_wp_compose_namespaceObject.debounce)(
      this.updateSuggestions.bind(this),
      200
    );
    this.suggestionNodes = [];
    this.suggestionsRequest = null;
    this.state = {
      suggestions: [],
      showSuggestions: false,
      suggestionsValue: null,
      selectedSuggestion: null,
      suggestionsListboxId: "",
      suggestionOptionIdPrefix: ""
    };
  }
  componentDidUpdate(prevProps) {
    const { showSuggestions, selectedSuggestion } = this.state;
    const { value, __experimentalShowInitialSuggestions = false } = this.props;
    if (showSuggestions && selectedSuggestion !== null && this.suggestionNodes[selectedSuggestion]) {
      this.suggestionNodes[selectedSuggestion].scrollIntoView({
        behavior: "instant",
        block: "nearest",
        inline: "nearest"
      });
    }
    if (prevProps.value !== value && !this.props.disableSuggestions) {
      if (value?.length) {
        this.updateSuggestions(value);
      } else if (__experimentalShowInitialSuggestions) {
        this.updateSuggestions();
      }
    }
  }
  componentDidMount() {
    if (this.shouldShowInitialSuggestions()) {
      this.updateSuggestions();
    }
  }
  componentWillUnmount() {
    this.suggestionsRequest?.cancel?.();
    this.suggestionsRequest = null;
  }
  bindSuggestionNode(index) {
    return (ref) => {
      this.suggestionNodes[index] = ref;
    };
  }
  shouldShowInitialSuggestions() {
    const { __experimentalShowInitialSuggestions = false, value } = this.props;
    return __experimentalShowInitialSuggestions && !(value && value.length);
  }
  updateSuggestions(value = "") {
    const {
      __experimentalFetchLinkSuggestions: fetchLinkSuggestions,
      __experimentalHandleURLSuggestions: handleURLSuggestions
    } = this.props;
    if (!fetchLinkSuggestions) {
      return;
    }
    const isInitialSuggestions = !value?.length;
    value = value.trim();
    if (!isInitialSuggestions && (value.length < 2 || !handleURLSuggestions && (0,external_wp_url_namespaceObject.isURL)(value))) {
      this.suggestionsRequest?.cancel?.();
      this.suggestionsRequest = null;
      this.setState({
        suggestions: [],
        showSuggestions: false,
        suggestionsValue: value,
        selectedSuggestion: null,
        loading: false
      });
      return;
    }
    this.setState({
      selectedSuggestion: null,
      loading: true
    });
    const request = fetchLinkSuggestions(value, {
      isInitialSuggestions
    });
    request.then((suggestions) => {
      if (this.suggestionsRequest !== request) {
        return;
      }
      this.setState({
        suggestions,
        suggestionsValue: value,
        loading: false,
        showSuggestions: !!suggestions.length
      });
      if (!!suggestions.length) {
        this.props.debouncedSpeak(
          (0,external_wp_i18n_namespaceObject.sprintf)(
            /* translators: %d: number of results. */
            (0,external_wp_i18n_namespaceObject._n)(
              "%d result found, use up and down arrow keys to navigate.",
              "%d results found, use up and down arrow keys to navigate.",
              suggestions.length
            ),
            suggestions.length
          ),
          "assertive"
        );
      } else {
        this.props.debouncedSpeak(
          (0,external_wp_i18n_namespaceObject.__)("No results."),
          "assertive"
        );
      }
    }).catch(() => {
      if (this.suggestionsRequest !== request) {
        return;
      }
      this.setState({
        loading: false
      });
    }).finally(() => {
      if (this.suggestionsRequest === request) {
        this.suggestionsRequest = null;
      }
    });
    this.suggestionsRequest = request;
  }
  onChange(newValue) {
    this.props.onChange(newValue);
  }
  onFocus() {
    const { suggestions } = this.state;
    const { disableSuggestions, value } = this.props;
    if (value && !disableSuggestions && !(suggestions && suggestions.length) && this.suggestionsRequest === null) {
      this.updateSuggestions(value);
    }
  }
  onKeyDown(event) {
    this.props.onKeyDown?.(event);
    const { showSuggestions, selectedSuggestion, suggestions, loading } = this.state;
    if (!showSuggestions || !suggestions.length || loading) {
      switch (event.keyCode) {
        // When UP is pressed, if the caret is at the start of the text, move it to the 0
        // position.
        case external_wp_keycodes_namespaceObject.UP: {
          if (0 !== event.target.selectionStart) {
            event.preventDefault();
            event.target.setSelectionRange(0, 0);
          }
          break;
        }
        // When DOWN is pressed, if the caret is not at the end of the text, move it to the
        // last position.
        case external_wp_keycodes_namespaceObject.DOWN: {
          if (this.props.value.length !== event.target.selectionStart) {
            event.preventDefault();
            event.target.setSelectionRange(
              this.props.value.length,
              this.props.value.length
            );
          }
          break;
        }
        // Submitting while loading should trigger onSubmit.
        case external_wp_keycodes_namespaceObject.ENTER: {
          if (this.props.onSubmit) {
            event.preventDefault();
            this.props.onSubmit(null, event);
          }
          break;
        }
      }
      return;
    }
    const suggestion = this.state.suggestions[this.state.selectedSuggestion];
    switch (event.keyCode) {
      case external_wp_keycodes_namespaceObject.UP: {
        event.preventDefault();
        const previousIndex = !selectedSuggestion ? suggestions.length - 1 : selectedSuggestion - 1;
        this.setState({
          selectedSuggestion: previousIndex
        });
        break;
      }
      case external_wp_keycodes_namespaceObject.DOWN: {
        event.preventDefault();
        const nextIndex = selectedSuggestion === null || selectedSuggestion === suggestions.length - 1 ? 0 : selectedSuggestion + 1;
        this.setState({
          selectedSuggestion: nextIndex
        });
        break;
      }
      case external_wp_keycodes_namespaceObject.TAB: {
        if (this.state.selectedSuggestion !== null) {
          this.selectLink(suggestion);
          this.props.speak((0,external_wp_i18n_namespaceObject.__)("Link selected."));
        }
        break;
      }
      case external_wp_keycodes_namespaceObject.ENTER: {
        event.preventDefault();
        if (this.state.selectedSuggestion !== null) {
          this.selectLink(suggestion);
          if (this.props.onSubmit) {
            this.props.onSubmit(suggestion, event);
          }
        } else if (this.props.onSubmit) {
          this.props.onSubmit(null, event);
        }
        break;
      }
    }
  }
  selectLink(suggestion) {
    this.props.onChange(suggestion.url, suggestion);
    this.setState({
      selectedSuggestion: null,
      showSuggestions: false
    });
  }
  handleOnClick(suggestion) {
    this.selectLink(suggestion);
    this.inputRef.current.focus();
  }
  static getDerivedStateFromProps({
    value,
    instanceId,
    disableSuggestions,
    __experimentalShowInitialSuggestions = false
  }, { showSuggestions }) {
    let shouldShowSuggestions = showSuggestions;
    const hasValue = value && value.length;
    if (!__experimentalShowInitialSuggestions && !hasValue) {
      shouldShowSuggestions = false;
    }
    if (disableSuggestions === true) {
      shouldShowSuggestions = false;
    }
    return {
      showSuggestions: shouldShowSuggestions,
      suggestionsListboxId: `block-editor-url-input-suggestions-${instanceId}`,
      suggestionOptionIdPrefix: `block-editor-url-input-suggestion-${instanceId}`
    };
  }
  render() {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      this.renderControl(),
      this.renderSuggestions()
    ] });
  }
  renderControl() {
    const {
      label = null,
      className,
      isFullWidth,
      instanceId,
      placeholder = (0,external_wp_i18n_namespaceObject.__)("Paste URL or type to search"),
      __experimentalRenderControl: renderControl,
      value = "",
      hideLabelFromVision = false,
      help = null,
      disabled = false
    } = this.props;
    const {
      loading,
      showSuggestions,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix
    } = this.state;
    const inputId = `url-input-control-${instanceId}`;
    const controlProps = {
      id: inputId,
      // Passes attribute to label for the for attribute
      label,
      className: dist_clsx("block-editor-url-input", className, {
        "is-full-width": isFullWidth
      }),
      hideLabelFromVision
    };
    const inputProps = {
      id: inputId,
      value,
      required: true,
      type: "text",
      onChange: disabled ? () => {
      } : this.onChange,
      // Disable onChange when disabled
      onFocus: disabled ? () => {
      } : this.onFocus,
      // Disable onFocus when disabled
      placeholder,
      onKeyDown: disabled ? () => {
      } : this.onKeyDown,
      // Disable onKeyDown when disabled
      role: "combobox",
      "aria-label": label ? void 0 : (0,external_wp_i18n_namespaceObject.__)("URL"),
      // Ensure input always has an accessible label
      "aria-expanded": showSuggestions,
      "aria-autocomplete": "list",
      "aria-owns": suggestionsListboxId,
      "aria-activedescendant": selectedSuggestion !== null ? `${suggestionOptionIdPrefix}-${selectedSuggestion}` : void 0,
      ref: this.inputRef,
      disabled,
      suffix: this.props.suffix,
      help
    };
    if (renderControl) {
      return renderControl(controlProps, inputProps, loading);
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.BaseControl, { __nextHasNoMarginBottom: true, ...controlProps, children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControl, { ...inputProps, __next40pxDefaultSize: true }),
      loading && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {})
    ] });
  }
  renderSuggestions() {
    const {
      className,
      __experimentalRenderSuggestions: renderSuggestions
    } = this.props;
    const {
      showSuggestions,
      suggestions,
      suggestionsValue,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix,
      loading
    } = this.state;
    if (!showSuggestions || suggestions.length === 0) {
      return null;
    }
    const suggestionsListProps = {
      id: suggestionsListboxId,
      ref: this.autocompleteRef,
      role: "listbox"
    };
    const buildSuggestionItemProps = (suggestion, index) => {
      return {
        role: "option",
        tabIndex: "-1",
        id: `${suggestionOptionIdPrefix}-${index}`,
        ref: this.bindSuggestionNode(index),
        "aria-selected": index === selectedSuggestion ? true : void 0
      };
    };
    if (isFunction(renderSuggestions)) {
      return renderSuggestions({
        suggestions,
        selectedSuggestion,
        suggestionsListProps,
        buildSuggestionItemProps,
        isLoading: loading,
        handleSuggestionClick: this.handleOnClick,
        isInitialSuggestions: !suggestionsValue?.length,
        currentInputValue: suggestionsValue
      });
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Popover, { placement: "bottom", focusOnMount: false, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      "div",
      {
        ...suggestionsListProps,
        className: dist_clsx("block-editor-url-input__suggestions", {
          [`${className}__suggestions`]: className
        }),
        children: suggestions.map((suggestion, index) => /* @__PURE__ */ (0,external_React_.createElement)(
          external_wp_components_namespaceObject.Button,
          {
            __next40pxDefaultSize: true,
            ...buildSuggestionItemProps(suggestion, index),
            key: suggestion.id,
            className: dist_clsx(
              "block-editor-url-input__suggestion",
              {
                "is-selected": index === selectedSuggestion
              }
            ),
            onClick: () => this.handleOnClick(suggestion)
          },
          suggestion.title
        ))
      }
    ) });
  }
}
var url_input_default = (0,external_wp_compose_namespaceObject.compose)(
  external_wp_compose_namespaceObject.withSafeTimeout,
  external_wp_components_namespaceObject.withSpokenMessages,
  external_wp_compose_namespaceObject.withInstanceId,
  (0,external_wp_data_namespaceObject.withSelect)((select, props) => {
    if (isFunction(props.__experimentalFetchLinkSuggestions)) {
      return;
    }
    const { getSettings } = select(store);
    return {
      __experimentalFetchLinkSuggestions: getSettings().__experimentalFetchLinkSuggestions
    };
  })
)(URLInput);


;// ./node_modules/@wordpress/icons/build-module/library/plus.js


var plus_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M11 12.5V17.5H12.5V12.5H17.5V11H12.5V6H11V11H6V12.5H11Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-create-button.js





const LinkControlSearchCreate = ({
  searchTerm,
  onClick,
  itemProps,
  buttonText
}) => {
  if (!searchTerm) {
    return null;
  }
  let text;
  if (buttonText) {
    text = typeof buttonText === "function" ? buttonText(searchTerm) : buttonText;
  } else {
    text = (0,external_wp_element_namespaceObject.createInterpolateElement)(
      (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %s: search term. */
        (0,external_wp_i18n_namespaceObject.__)("Create: <mark>%s</mark>"),
        searchTerm
      ),
      { mark: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("mark", {}) }
    );
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.MenuItem,
    {
      ...itemProps,
      iconPosition: "left",
      icon: plus_default,
      className: "block-editor-link-control__search-item",
      onClick,
      children: text
    }
  );
};
var search_create_button_default = LinkControlSearchCreate;


;// ./node_modules/@wordpress/icons/build-module/library/post-list.js


var post_list_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M18 5.5H6a.5.5 0 0 0-.5.5v12a.5.5 0 0 0 .5.5h12a.5.5 0 0 0 .5-.5V6a.5.5 0 0 0-.5-.5ZM6 4h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2Zm1 5h1.5v1.5H7V9Zm1.5 4.5H7V15h1.5v-1.5ZM10 9h7v1.5h-7V9Zm7 4.5h-7V15h7v-1.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/page.js


var page_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M15.5 7.5h-7V9h7V7.5Zm-7 3.5h7v1.5h-7V11Zm7 3.5h-7V16h7v-1.5Z" }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M17 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2ZM7 5.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H7a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5Z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/tag.js


var tag_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4.75 4a.75.75 0 0 0-.75.75v7.826c0 .2.08.39.22.53l6.72 6.716a2.313 2.313 0 0 0 3.276-.001l5.61-5.611-.531-.53.532.528a2.315 2.315 0 0 0 0-3.264L13.104 4.22a.75.75 0 0 0-.53-.22H4.75ZM19 12.576a.815.815 0 0 1-.236.574l-5.61 5.611a.814.814 0 0 1-1.153 0L5.5 12.264V5.5h6.763l6.5 6.502a.816.816 0 0 1 .237.574ZM8.75 9.75a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/category.js


var category_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    d: "M6 5.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM4 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2V6zm11-.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5h-3a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM13 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2h-3a2 2 0 01-2-2V6zm5 8.5h-3a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5zM15 13a2 2 0 00-2 2v3a2 2 0 002 2h3a2 2 0 002-2v-3a2 2 0 00-2-2h-3zm-9 1.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5v-3a.5.5 0 01.5-.5zM4 15a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2v-3z",
    fillRule: "evenodd",
    clipRule: "evenodd"
  }
) });


;// ./node_modules/@wordpress/icons/build-module/library/file.js


var file_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12.848 8a1 1 0 0 1-.914-.594l-.723-1.63a.5.5 0 0 0-.447-.276H5a.5.5 0 0 0-.5.5v11.5a.5.5 0 0 0 .5.5h14a.5.5 0 0 0 .5-.5v-9A.5.5 0 0 0 19 8h-6.152Zm.612-1.5a.5.5 0 0 1-.462-.31l-.445-1.084A2 2 0 0 0 10.763 4H5a2 2 0 0 0-2 2v11.5a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-9a2 2 0 0 0-2-2h-5.54Z"
  }
) });


;// ./node_modules/@wordpress/icons/build-module/library/globe.js


var globe_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8Zm6.5 8c0 .6 0 1.2-.2 1.8h-2.7c0-.6.2-1.1.2-1.8s0-1.2-.2-1.8h2.7c.2.6.2 1.1.2 1.8Zm-.9-3.2h-2.4c-.3-.9-.7-1.8-1.1-2.4-.1-.2-.2-.4-.3-.5 1.6.5 3 1.6 3.8 3ZM12.8 17c-.3.5-.6 1-.8 1.3-.2-.3-.5-.8-.8-1.3-.3-.5-.6-1.1-.8-1.7h3.3c-.2.6-.5 1.2-.8 1.7Zm-2.9-3.2c-.1-.6-.2-1.1-.2-1.8s0-1.2.2-1.8H14c.1.6.2 1.1.2 1.8s0 1.2-.2 1.8H9.9ZM11.2 7c.3-.5.6-1 .8-1.3.2.3.5.8.8 1.3.3.5.6 1.1.8 1.7h-3.3c.2-.6.5-1.2.8-1.7Zm-1-1.2c-.1.2-.2.3-.3.5-.4.7-.8 1.5-1.1 2.4H6.4c.8-1.4 2.2-2.5 3.8-3Zm-1.8 8H5.7c-.2-.6-.2-1.1-.2-1.8s0-1.2.2-1.8h2.7c0 .6-.2 1.1-.2 1.8s0 1.2.2 1.8Zm-2 1.4h2.4c.3.9.7 1.8 1.1 2.4.1.2.2.4.3.5-1.6-.5-3-1.6-3.8-3Zm7.4 3c.1-.2.2-.3.3-.5.4-.7.8-1.5 1.1-2.4h2.4c-.8 1.4-2.2 2.5-3.8 3Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/home.js


var home_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M12 4L4 7.9V20h16V7.9L12 4zm6.5 14.5H14V13h-4v5.5H5.5V8.8L12 5.7l6.5 3.1v9.7z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/verse.js


var verse_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M17.8 2l-.9.3c-.1 0-3.6 1-5.2 2.1C10 5.5 9.3 6.5 8.9 7.1c-.6.9-1.7 4.7-1.7 6.3l-.9 2.3c-.2.4 0 .8.4 1 .1 0 .2.1.3.1.3 0 .6-.2.7-.5l.6-1.5c.3 0 .7-.1 1.2-.2.7-.1 1.4-.3 2.2-.5.8-.2 1.6-.5 2.4-.8.7-.3 1.4-.7 1.9-1.2s.8-1.2 1-1.9c.2-.7.3-1.6.4-2.4.1-.8.1-1.7.2-2.5 0-.8.1-1.5.2-2.1V2zm-1.9 5.6c-.1.8-.2 1.5-.3 2.1-.2.6-.4 1-.6 1.3-.3.3-.8.6-1.4.9-.7.3-1.4.5-2.2.8-.6.2-1.3.3-1.8.4L15 7.5c.3-.3.6-.7 1-1.1 0 .4 0 .8-.1 1.2zM6 20h8v-1.5H6V20z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-item.js








const TYPES = {
  post: {
    icon: post_list_default,
    label: (0,external_wp_i18n_namespaceObject.__)("Post")
  },
  page: {
    icon: page_default,
    label: (0,external_wp_i18n_namespaceObject.__)("Page")
  },
  post_tag: {
    icon: tag_default,
    label: (0,external_wp_i18n_namespaceObject.__)("Tag")
  },
  category: {
    icon: category_default,
    label: (0,external_wp_i18n_namespaceObject.__)("Category")
  },
  attachment: {
    icon: file_default,
    label: (0,external_wp_i18n_namespaceObject.__)("Attachment")
  }
};
function SearchItemIcon({ isURL, suggestion }) {
  let icon = null;
  if (isURL) {
    icon = globe_default;
  } else if (suggestion.type in TYPES) {
    icon = TYPES[suggestion.type].icon;
    if (suggestion.type === "page") {
      if (suggestion.isFrontPage) {
        icon = home_default;
      }
      if (suggestion.isBlogHome) {
        icon = verse_default;
      }
    }
  }
  if (icon) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      icon_default,
      {
        className: "block-editor-link-control__search-item-icon",
        icon
      }
    );
  }
  return null;
}
function addLeadingSlash(url) {
  const trimmedURL = url?.trim();
  if (!trimmedURL?.length) {
    return url;
  }
  return url?.replace(/^\/?/, "/");
}
function removeTrailingSlash(url) {
  const trimmedURL = url?.trim();
  if (!trimmedURL?.length) {
    return url;
  }
  return url?.replace(/\/$/, "");
}
const partialRight = (fn, ...partialArgs) => (...args) => fn(...args, ...partialArgs);
const defaultTo = (d) => (v) => {
  return v === null || v === void 0 || v !== v ? d : v;
};
function getURLForDisplay(url) {
  if (!url) {
    return url;
  }
  return (0,external_wp_compose_namespaceObject.pipe)(
    external_wp_url_namespaceObject.safeDecodeURI,
    external_wp_url_namespaceObject.getPath,
    defaultTo(""),
    partialRight(external_wp_url_namespaceObject.filterURLForDisplay, 24),
    removeTrailingSlash,
    addLeadingSlash
  )(url);
}
const LinkControlSearchItem = ({
  itemProps,
  suggestion,
  searchTerm,
  onClick,
  isURL = false,
  shouldShowType = false
}) => {
  const info = isURL ? (0,external_wp_i18n_namespaceObject.__)("Press ENTER to add this link") : getURLForDisplay(suggestion.url);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.MenuItem,
    {
      ...itemProps,
      info,
      iconPosition: "left",
      icon: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(SearchItemIcon, { suggestion, isURL }),
      onClick,
      shortcut: shouldShowType && getVisualTypeName(suggestion),
      className: "block-editor-link-control__search-item",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.TextHighlight,
        {
          text: (0,external_wp_dom_namespaceObject.__unstableStripHTML)(suggestion.title),
          highlight: searchTerm
        }
      )
    }
  );
};
function getVisualTypeName(suggestion) {
  if (suggestion.isFrontPage) {
    return (0,external_wp_i18n_namespaceObject.__)("Front page");
  }
  if (suggestion.isBlogHome) {
    return (0,external_wp_i18n_namespaceObject.__)("Blog home");
  }
  if (suggestion.type in TYPES) {
    return TYPES[suggestion.type].label;
  }
  return suggestion.type;
}
var search_item_default = LinkControlSearchItem;
const __experimentalLinkControlSearchItem = (props) => {
  external_wp_deprecated_default()("wp.blockEditor.__experimentalLinkControlSearchItem", {
    since: "6.8"
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkControlSearchItem, { ...props });
};


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/constants.js

const CREATE_TYPE = "__CREATE__";
const TEL_TYPE = "tel";
const URL_TYPE = "link";
const MAILTO_TYPE = "mailto";
const INTERNAL_TYPE = "internal";
const LINK_ENTRY_TYPES = [
  URL_TYPE,
  MAILTO_TYPE,
  TEL_TYPE,
  INTERNAL_TYPE
];
const DEFAULT_LINK_SETTINGS = [
  {
    id: "opensInNewTab",
    title: (0,external_wp_i18n_namespaceObject.__)("Open in new tab")
  }
];


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-results.js








function LinkControlSearchResults({
  withCreateSuggestion,
  currentInputValue,
  handleSuggestionClick,
  suggestionsListProps,
  buildSuggestionItemProps,
  suggestions,
  selectedSuggestion,
  isLoading,
  isInitialSuggestions,
  createSuggestionButtonText,
  suggestionsQuery
}) {
  const resultsListClasses = dist_clsx(
    "block-editor-link-control__search-results",
    {
      "is-loading": isLoading
    }
  );
  const isSingleDirectEntryResult = suggestions.length === 1 && LINK_ENTRY_TYPES.includes(suggestions[0].type);
  const shouldShowCreateSuggestion = withCreateSuggestion && !isSingleDirectEntryResult && !isInitialSuggestions;
  const shouldShowSuggestionsTypes = !suggestionsQuery?.type;
  const labelText = isInitialSuggestions ? (0,external_wp_i18n_namespaceObject.__)("Suggestions") : (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: search term. */
    (0,external_wp_i18n_namespaceObject.__)('Search results for "%s"'),
    currentInputValue
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-link-control__search-results-wrapper", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "div",
    {
      ...suggestionsListProps,
      className: resultsListClasses,
      "aria-label": labelText,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, { children: suggestions.map((suggestion, index) => {
        if (shouldShowCreateSuggestion && CREATE_TYPE === suggestion.type) {
          return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            search_create_button_default,
            {
              searchTerm: currentInputValue,
              buttonText: createSuggestionButtonText,
              onClick: () => handleSuggestionClick(suggestion),
              itemProps: buildSuggestionItemProps(
                suggestion,
                index
              ),
              isSelected: index === selectedSuggestion
            },
            suggestion.type
          );
        }
        if (CREATE_TYPE === suggestion.type) {
          return null;
        }
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          search_item_default,
          {
            itemProps: buildSuggestionItemProps(
              suggestion,
              index
            ),
            suggestion,
            index,
            onClick: () => {
              handleSuggestionClick(suggestion);
            },
            isSelected: index === selectedSuggestion,
            isURL: LINK_ENTRY_TYPES.includes(
              suggestion.type
            ),
            searchTerm: currentInputValue,
            shouldShowType: shouldShowSuggestionsTypes,
            isFrontPage: suggestion?.isFrontPage,
            isBlogHome: suggestion?.isBlogHome
          },
          `${suggestion.id}-${suggestion.type}`
        );
      }) })
    }
  ) });
}
var search_results_default = LinkControlSearchResults;
const __experimentalLinkControlSearchResults = (props) => {
  external_wp_deprecated_default()("wp.blockEditor.__experimentalLinkControlSearchResults", {
    since: "6.8"
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkControlSearchResults, { ...props });
};


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/is-url-like.js

function isURLLike(val) {
  const hasSpaces = val.includes(" ");
  if (hasSpaces) {
    return false;
  }
  const protocol = (0,external_wp_url_namespaceObject.getProtocol)(val);
  const protocolIsValid = (0,external_wp_url_namespaceObject.isValidProtocol)(protocol);
  const mayBeTLD = hasPossibleTLD(val);
  const isWWW = val?.startsWith("www.");
  const isInternal = val?.startsWith("#") && (0,external_wp_url_namespaceObject.isValidFragment)(val);
  return protocolIsValid || isWWW || isInternal || mayBeTLD;
}
function hasPossibleTLD(url, maxLength = 6) {
  const cleanedURL = url.split(/[?#]/)[0];
  const regex = new RegExp(
    `(?<=\\S)\\.(?:[a-zA-Z_]{2,${maxLength}})(?:\\/|$)`
  );
  return regex.test(cleanedURL);
}


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-search-handler.js






const handleNoop = () => Promise.resolve([]);
const handleDirectEntry = (val) => {
  let type = URL_TYPE;
  const protocol = (0,external_wp_url_namespaceObject.getProtocol)(val) || "";
  if (protocol.includes("mailto")) {
    type = MAILTO_TYPE;
  }
  if (protocol.includes("tel")) {
    type = TEL_TYPE;
  }
  if (val?.startsWith("#")) {
    type = INTERNAL_TYPE;
  }
  return Promise.resolve([
    {
      id: val,
      title: val,
      url: type === "URL" ? (0,external_wp_url_namespaceObject.prependHTTP)(val) : val,
      type
    }
  ]);
};
const handleEntitySearch = async (val, suggestionsQuery, fetchSearchSuggestions, withCreateSuggestion, pageOnFront, pageForPosts) => {
  const { isInitialSuggestions } = suggestionsQuery;
  const results = await fetchSearchSuggestions(val, suggestionsQuery);
  results.map((result) => {
    if (Number(result.id) === pageOnFront) {
      result.isFrontPage = true;
      return result;
    } else if (Number(result.id) === pageForPosts) {
      result.isBlogHome = true;
      return result;
    }
    return result;
  });
  if (isInitialSuggestions) {
    return results;
  }
  return isURLLike(val) || !withCreateSuggestion ? results : results.concat({
    // the `id` prop is intentionally omitted here because it
    // is never exposed as part of the component's public API.
    // see: https://github.com/WordPress/gutenberg/pull/19775#discussion_r378931316.
    title: val,
    // Must match the existing `<input>`s text value.
    url: val,
    // Must match the existing `<input>`s text value.
    type: CREATE_TYPE
  });
};
function useSearchHandler(suggestionsQuery, allowDirectEntry, withCreateSuggestion) {
  const { fetchSearchSuggestions, pageOnFront, pageForPosts } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getSettings } = select(store);
      return {
        pageOnFront: getSettings().pageOnFront,
        pageForPosts: getSettings().pageForPosts,
        fetchSearchSuggestions: getSettings().__experimentalFetchLinkSuggestions
      };
    },
    []
  );
  const directEntryHandler = allowDirectEntry ? handleDirectEntry : handleNoop;
  return (0,external_wp_element_namespaceObject.useCallback)(
    (val, { isInitialSuggestions }) => {
      return isURLLike(val) ? directEntryHandler(val, { isInitialSuggestions }) : handleEntitySearch(
        val,
        { ...suggestionsQuery, isInitialSuggestions },
        fetchSearchSuggestions,
        withCreateSuggestion,
        pageOnFront,
        pageForPosts
      );
    },
    [
      directEntryHandler,
      fetchSearchSuggestions,
      pageOnFront,
      pageForPosts,
      suggestionsQuery,
      withCreateSuggestion
    ]
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-input.js








const noopSearchHandler = () => Promise.resolve([]);
const noop = () => {
};
const LinkControlSearchInput = (0,external_wp_element_namespaceObject.forwardRef)(
  ({
    value,
    children,
    currentLink = {},
    className = null,
    placeholder = null,
    withCreateSuggestion = false,
    onCreateSuggestion = noop,
    onChange = noop,
    onSelect = noop,
    showSuggestions = true,
    renderSuggestions = (props) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(search_results_default, { ...props }),
    fetchSuggestions = null,
    allowDirectEntry = true,
    showInitialSuggestions = false,
    suggestionsQuery = {},
    withURLSuggestion = true,
    createSuggestionButtonText,
    hideLabelFromVision = false,
    suffix,
    isEntity = false
  }, ref) => {
    const genericSearchHandler = useSearchHandler(
      suggestionsQuery,
      allowDirectEntry,
      withCreateSuggestion,
      withURLSuggestion
    );
    const searchHandler = showSuggestions ? fetchSuggestions || genericSearchHandler : noopSearchHandler;
    const [focusedSuggestion, setFocusedSuggestion] = (0,external_wp_element_namespaceObject.useState)();
    const onInputChange = (selection, suggestion) => {
      onChange(selection);
      setFocusedSuggestion(suggestion);
    };
    const handleRenderSuggestions = (props) => renderSuggestions({
      ...props,
      withCreateSuggestion,
      createSuggestionButtonText,
      suggestionsQuery,
      handleSuggestionClick: (suggestion) => {
        if (props.handleSuggestionClick) {
          props.handleSuggestionClick(suggestion);
        }
        onSuggestionSelected(suggestion);
      }
    });
    const onSuggestionSelected = async (selectedSuggestion) => {
      let suggestion = selectedSuggestion;
      if (CREATE_TYPE === selectedSuggestion.type) {
        try {
          suggestion = await onCreateSuggestion(
            selectedSuggestion.title
          );
          if (suggestion?.url) {
            onSelect(suggestion);
          }
        } catch (e) {
        }
        return;
      }
      if (allowDirectEntry || suggestion && Object.keys(suggestion).length >= 1) {
        const { id, url, ...restLinkProps } = currentLink ?? {};
        onSelect(
          // Some direct entries don't have types or IDs, and we still need to clear the previous ones.
          { ...restLinkProps, ...suggestion },
          suggestion
        );
      }
    };
    const _placeholder = placeholder ?? (0,external_wp_i18n_namespaceObject.__)("Search or type URL");
    const label = hideLabelFromVision && placeholder !== "" ? _placeholder : (0,external_wp_i18n_namespaceObject.__)("Link");
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-link-control__search-input-container", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        url_input_default,
        {
          disableSuggestions: currentLink?.url === value,
          label,
          hideLabelFromVision,
          className,
          value,
          onChange: onInputChange,
          placeholder: _placeholder,
          __experimentalRenderSuggestions: showSuggestions ? handleRenderSuggestions : null,
          __experimentalFetchLinkSuggestions: searchHandler,
          __experimentalHandleURLSuggestions: true,
          __experimentalShowInitialSuggestions: showInitialSuggestions,
          onSubmit: (suggestion, event) => {
            const hasSuggestion = suggestion || focusedSuggestion;
            if (!hasSuggestion && !value?.trim()?.length) {
              event.preventDefault();
            } else {
              onSuggestionSelected(
                hasSuggestion || { url: value }
              );
            }
          },
          inputRef: ref,
          suffix,
          disabled: isEntity
        }
      ),
      children
    ] });
  }
);
var search_input_default = LinkControlSearchInput;
const __experimentalLinkControlSearchInput = (props) => {
  external_wp_deprecated_default()("wp.blockEditor.__experimentalLinkControlSearchInput", {
    since: "6.8"
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkControlSearchInput, { ...props });
};


;// ./node_modules/@wordpress/icons/build-module/library/info.js


var info_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.5 12a6.5 6.5 0 1 0 13 0 6.5 6.5 0 0 0-13 0ZM12 4a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm.75 4v1.5h-1.5V8h1.5Zm0 8v-5h-1.5v5h1.5Z"
  }
) });


;// ./node_modules/@wordpress/icons/build-module/library/pencil.js


var pencil_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/copy-small.js


var copy_small_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.625 5.5h9.75c.069 0 .125.056.125.125v9.75a.125.125 0 0 1-.125.125h-9.75a.125.125 0 0 1-.125-.125v-9.75c0-.069.056-.125.125-.125ZM4 5.625C4 4.728 4.728 4 5.625 4h9.75C16.273 4 17 4.728 17 5.625v9.75c0 .898-.727 1.625-1.625 1.625h-9.75A1.625 1.625 0 0 1 4 15.375v-9.75Zm14.5 11.656v-9H20v9C20 18.8 18.77 20 17.251 20H6.25v-1.5h11.001c.69 0 1.249-.528 1.249-1.219Z"
  }
) });


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/viewer-slot.js

const { Slot: ViewerSlot, Fill: ViewerFill } = (0,external_wp_components_namespaceObject.createSlotFill)(
  "BlockEditorLinkControlViewer"
);
var viewer_slot_default = (/* unused pure expression or super */ null && (ViewerSlot));


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-rich-url-data.js



function reducer(state, action) {
  switch (action.type) {
    case "RESOLVED":
      return {
        ...state,
        isFetching: false,
        richData: action.richData
      };
    case "ERROR":
      return {
        ...state,
        isFetching: false,
        richData: null
      };
    case "LOADING":
      return {
        ...state,
        isFetching: true
      };
    default:
      throw new Error(`Unexpected action type ${action.type}`);
  }
}
function useRemoteUrlData(url) {
  const [state, dispatch] = (0,external_wp_element_namespaceObject.useReducer)(reducer, {
    richData: null,
    isFetching: false
  });
  const { fetchRichUrlData } = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const { getSettings } = select(store);
    return {
      fetchRichUrlData: getSettings().__experimentalFetchRichUrlData
    };
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (url?.length && fetchRichUrlData && typeof AbortController !== "undefined") {
      dispatch({
        type: "LOADING"
      });
      const controller = new window.AbortController();
      const signal = controller.signal;
      fetchRichUrlData(url, {
        signal
      }).then((urlData) => {
        dispatch({
          type: "RESOLVED",
          richData: urlData
        });
      }).catch(() => {
        if (!signal.aborted) {
          dispatch({
            type: "ERROR"
          });
        }
      });
      return () => {
        controller.abort();
      };
    }
  }, [url]);
  return state;
}
var use_rich_url_data_default = useRemoteUrlData;


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/link-preview.js













function filterTitleForDisplay(title) {
  return title.replace(/^[a-z\-.\+]+[0-9]*:(\/\/)?/i, "").replace(/^www\./i, "");
}
function LinkPreview({
  value,
  onEditClick,
  hasRichPreviews = false,
  hasUnlinkControl = false,
  onRemove
}) {
  const showIconLabels = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(external_wp_preferences_namespaceObject.store).get("core", "showIconLabels"),
    []
  );
  const showRichPreviews = hasRichPreviews ? value?.url : null;
  const { richData, isFetching } = use_rich_url_data_default(showRichPreviews);
  const hasRichData = richData && Object.keys(richData).length;
  const displayURL = value && (0,external_wp_url_namespaceObject.filterURLForDisplay)((0,external_wp_url_namespaceObject.safeDecodeURI)(value.url), 24) || "";
  const isEmptyURL = !value?.url?.length;
  const displayTitle = !isEmptyURL && (0,external_wp_dom_namespaceObject.__unstableStripHTML)(richData?.title || value?.title || displayURL);
  const isUrlRedundant = !value?.url || filterTitleForDisplay(displayTitle) === displayURL;
  let icon;
  if (richData?.icon) {
    icon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("img", { src: richData?.icon, alt: "" });
  } else if (isEmptyURL) {
    icon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: info_default, size: 32 });
  } else {
    icon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: globe_default });
  }
  const { createNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const ref = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(value.url, () => {
    createNotice("info", (0,external_wp_i18n_namespaceObject.__)("Link copied to clipboard."), {
      isDismissible: true,
      type: "snackbar"
    });
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "div",
    {
      role: "group",
      "aria-label": (0,external_wp_i18n_namespaceObject.__)("Manage link"),
      className: dist_clsx("block-editor-link-control__search-item", {
        "is-current": true,
        "is-rich": hasRichData,
        "is-fetching": !!isFetching,
        "is-preview": true,
        "is-error": isEmptyURL,
        "is-url-title": displayTitle === displayURL
      }),
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-link-control__search-item-top", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          "span",
          {
            className: "block-editor-link-control__search-item-header",
            role: "figure",
            "aria-label": (
              /* translators: Accessibility text for the link preview when editing a link. */
              (0,external_wp_i18n_namespaceObject.__)("Link information")
            ),
            children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                "span",
                {
                  className: dist_clsx(
                    "block-editor-link-control__search-item-icon",
                    {
                      "is-image": richData?.icon
                    }
                  ),
                  children: icon
                }
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-editor-link-control__search-item-details", children: !isEmptyURL ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  external_wp_components_namespaceObject.ExternalLink,
                  {
                    className: "block-editor-link-control__search-item-title",
                    href: value.url,
                    children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalTruncate, { numberOfLines: 1, children: displayTitle })
                  }
                ),
                !isUrlRedundant && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-editor-link-control__search-item-info", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalTruncate, { numberOfLines: 1, children: displayURL }) })
              ] }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-editor-link-control__search-item-error-notice", children: (0,external_wp_i18n_namespaceObject.__)("Link is empty") }) })
            ]
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.Button,
          {
            icon: pencil_default,
            label: (0,external_wp_i18n_namespaceObject.__)("Edit link"),
            onClick: onEditClick,
            size: "compact",
            showTooltip: !showIconLabels
          }
        ),
        hasUnlinkControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.Button,
          {
            icon: link_off_default,
            label: (0,external_wp_i18n_namespaceObject.__)("Remove link"),
            onClick: onRemove,
            size: "compact",
            showTooltip: !showIconLabels
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.Button,
          {
            icon: copy_small_default,
            label: (0,external_wp_i18n_namespaceObject.__)("Copy link"),
            ref,
            accessibleWhenDisabled: true,
            disabled: isEmptyURL,
            size: "compact",
            showTooltip: !showIconLabels
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ViewerSlot, { fillProps: value })
      ] })
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/settings.js



const settings_noop = () => {
};
const LinkControlSettings = ({ value, onChange = settings_noop, settings }) => {
  if (!settings || !settings.length) {
    return null;
  }
  const handleSettingChange = (setting) => (newValue) => {
    onChange({
      ...value,
      [setting.id]: newValue
    });
  };
  const theSettings = settings.map((setting) => {
    if ("render" in setting) {
      if (typeof setting.render === "function") {
        const renderedContent = setting.render(
          setting,
          value,
          onChange
        );
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          "div",
          {
            className: "block-editor-link-control__setting",
            children: renderedContent
          },
          setting.id
        );
      }
      return null;
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.CheckboxControl,
      {
        __nextHasNoMarginBottom: true,
        className: "block-editor-link-control__setting",
        label: setting.title,
        onChange: handleSettingChange(setting),
        checked: value ? !!value[setting.id] : false,
        help: setting?.help
      },
      setting.id
    );
  }).filter(Boolean);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "block-editor-link-control__settings", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, { as: "legend", children: (0,external_wp_i18n_namespaceObject.__)("Currently selected link settings") }),
    theSettings
  ] });
};
var settings_default = LinkControlSettings;


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-create-page.js


function useCreatePage(handleCreatePage) {
  const cancelableCreateSuggestion = (0,external_wp_element_namespaceObject.useRef)();
  const [isCreatingPage, setIsCreatingPage] = (0,external_wp_element_namespaceObject.useState)(false);
  const [errorMessage, setErrorMessage] = (0,external_wp_element_namespaceObject.useState)(null);
  const createPage = async function(suggestionTitle) {
    setIsCreatingPage(true);
    setErrorMessage(null);
    try {
      cancelableCreateSuggestion.current = makeCancelable(
        // Using Promise.resolve to allow createSuggestion to return a
        // non-Promise based value.
        Promise.resolve(handleCreatePage(suggestionTitle))
      );
      return await cancelableCreateSuggestion.current.promise;
    } catch (error) {
      if (error && error.isCanceled) {
        return;
      }
      setErrorMessage(
        error.message || (0,external_wp_i18n_namespaceObject.__)(
          "An unknown error occurred during creation. Please try again."
        )
      );
      throw error;
    } finally {
      setIsCreatingPage(false);
    }
  };
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    return () => {
      if (cancelableCreateSuggestion.current) {
        cancelableCreateSuggestion.current.cancel();
      }
    };
  }, []);
  return {
    createPage,
    isCreatingPage,
    errorMessage
  };
}
const makeCancelable = (promise) => {
  let hasCanceled_ = false;
  const wrappedPromise = new Promise((resolve, reject) => {
    promise.then(
      (val) => hasCanceled_ ? reject({ isCanceled: true }) : resolve(val),
      (error) => hasCanceled_ ? reject({ isCanceled: true }) : reject(error)
    );
  });
  return {
    promise: wrappedPromise,
    cancel() {
      hasCanceled_ = true;
    }
  };
};


// EXTERNAL MODULE: ./node_modules/fast-deep-equal/index.js
var fast_deep_equal = __webpack_require__(5215);
var fast_deep_equal_default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal);
;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-internal-value.js


function useInternalValue(value) {
  const [internalValue, setInternalValue] = (0,external_wp_element_namespaceObject.useState)(value || {});
  const [previousValue, setPreviousValue] = (0,external_wp_element_namespaceObject.useState)(value);
  if (!fast_deep_equal_default()(value, previousValue)) {
    setPreviousValue(value);
    setInternalValue(value);
  }
  const setInternalURLInputValue = (nextValue) => {
    setInternalValue({
      ...internalValue,
      url: nextValue
    });
  };
  const setInternalTextInputValue = (nextValue) => {
    setInternalValue({
      ...internalValue,
      title: nextValue
    });
  };
  const createSetInternalSettingValueHandler = (settingsKeys) => (nextValue) => {
    const settingsUpdates = Object.keys(nextValue).reduce(
      (acc, key) => {
        if (settingsKeys.includes(key)) {
          acc[key] = nextValue[key];
        }
        return acc;
      },
      {}
    );
    setInternalValue({
      ...internalValue,
      ...settingsUpdates
    });
  };
  return [
    internalValue,
    setInternalValue,
    setInternalURLInputValue,
    setInternalTextInputValue,
    createSetInternalSettingValueHandler
  ];
}


;// ./node_modules/@wordpress/block-editor/build-module/components/link-control/index.js





















const link_control_noop = () => {
};
const PREFERENCE_SCOPE = "core/block-editor";
const PREFERENCE_KEY = "linkControlSettingsDrawer";
function LinkControl({
  searchInputPlaceholder,
  value,
  settings = DEFAULT_LINK_SETTINGS,
  onChange = link_control_noop,
  onRemove,
  onCancel,
  noDirectEntry = false,
  showSuggestions = true,
  showInitialSuggestions,
  forceIsEditingLink,
  createSuggestion,
  withCreateSuggestion,
  inputValue: propInputValue = "",
  suggestionsQuery = {},
  noURLSuggestion = false,
  createSuggestionButtonText,
  hasRichPreviews = false,
  hasTextControl = false,
  renderControlBottom = null,
  handleEntities = false
}) {
  if (withCreateSuggestion === void 0 && createSuggestion) {
    withCreateSuggestion = true;
  }
  const [settingsOpen, setSettingsOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const { advancedSettingsPreference } = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const prefsStore = select(external_wp_preferences_namespaceObject.store);
    return {
      advancedSettingsPreference: prefsStore.get(PREFERENCE_SCOPE, PREFERENCE_KEY) ?? false
    };
  }, []);
  const { set: setPreference } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_preferences_namespaceObject.store);
  const setSettingsOpenWithPreference = (prefVal) => {
    if (setPreference) {
      setPreference(PREFERENCE_SCOPE, PREFERENCE_KEY, prefVal);
    }
    setSettingsOpen(prefVal);
  };
  const isSettingsOpen = advancedSettingsPreference || settingsOpen;
  const isMountingRef = (0,external_wp_element_namespaceObject.useRef)(true);
  const wrapperNode = (0,external_wp_element_namespaceObject.useRef)();
  const textInputRef = (0,external_wp_element_namespaceObject.useRef)();
  const searchInputRef = (0,external_wp_element_namespaceObject.useRef)();
  const isEndingEditWithFocusRef = (0,external_wp_element_namespaceObject.useRef)(false);
  const settingsKeys = settings.map(({ id }) => id);
  const [
    internalControlValue,
    setInternalControlValue,
    setInternalURLInputValue,
    setInternalTextInputValue,
    createSetInternalSettingValueHandler
  ] = useInternalValue(value);
  const isEntity = handleEntities && !!internalControlValue?.id;
  const baseId = (0,external_wp_compose_namespaceObject.useInstanceId)(LinkControl, "link-control");
  const helpTextId = isEntity ? `${baseId}__help` : null;
  const valueHasChanges = value && !(0,external_wp_isShallowEqual_namespaceObject.isShallowEqualObjects)(internalControlValue, value);
  const [isEditingLink, setIsEditingLink] = (0,external_wp_element_namespaceObject.useState)(
    forceIsEditingLink !== void 0 ? forceIsEditingLink : !value || !value.url
  );
  const { createPage, isCreatingPage, errorMessage } = useCreatePage(createSuggestion);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (forceIsEditingLink === void 0) {
      return;
    }
    setIsEditingLink(forceIsEditingLink);
  }, [forceIsEditingLink]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (isMountingRef.current) {
      return;
    }
    const nextFocusTarget = external_wp_dom_namespaceObject.focus.focusable.find(wrapperNode.current)[0] || wrapperNode.current;
    nextFocusTarget.focus();
    isEndingEditWithFocusRef.current = false;
  }, [isEditingLink, isCreatingPage]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    isMountingRef.current = false;
    return () => {
      isMountingRef.current = true;
    };
  }, []);
  const hasLinkValue = value?.url?.trim()?.length > 0;
  const stopEditing = () => {
    isEndingEditWithFocusRef.current = !!wrapperNode.current?.contains(
      wrapperNode.current.ownerDocument.activeElement
    );
    setIsEditingLink(false);
  };
  const handleSelectSuggestion = (updatedValue) => {
    const nonSettingsChanges = Object.keys(updatedValue).reduce(
      (acc, key) => {
        if (!settingsKeys.includes(key)) {
          acc[key] = updatedValue[key];
        }
        return acc;
      },
      {}
    );
    onChange({
      ...internalControlValue,
      ...nonSettingsChanges,
      // As title is not a setting, it must be manually applied
      // in such a way as to preserve the users changes over
      // any "title" value provided by the "suggestion".
      title: internalControlValue?.title || updatedValue?.title
    });
    stopEditing();
  };
  const handleSubmit = () => {
    if (valueHasChanges) {
      onChange({
        ...value,
        ...internalControlValue,
        url: currentUrlInputValue
      });
    }
    stopEditing();
  };
  const handleSubmitWithEnter = (event) => {
    const { keyCode } = event;
    if (keyCode === external_wp_keycodes_namespaceObject.ENTER && !currentInputIsEmpty) {
      event.preventDefault();
      handleSubmit();
    }
  };
  const resetInternalValues = () => {
    setInternalControlValue(value);
  };
  const handleCancel = (event) => {
    event.preventDefault();
    event.stopPropagation();
    resetInternalValues();
    if (hasLinkValue) {
      stopEditing();
    } else {
      onRemove?.();
    }
    onCancel?.();
  };
  const [shouldFocusSearchInput, setShouldFocusSearchInput] = (0,external_wp_element_namespaceObject.useState)(false);
  const handleUnlink = () => {
    const { id, kind, type, ...restValue } = internalControlValue;
    setInternalControlValue({
      ...restValue,
      id: void 0,
      kind: void 0,
      type: void 0,
      url: void 0
    });
    setShouldFocusSearchInput(true);
  };
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (shouldFocusSearchInput) {
      searchInputRef.current?.focus();
      setShouldFocusSearchInput(false);
    }
  }, [shouldFocusSearchInput]);
  const currentUrlInputValue = propInputValue || internalControlValue?.url || "";
  const currentInputIsEmpty = !currentUrlInputValue?.trim()?.length;
  const shownUnlinkControl = onRemove && value && !isEditingLink && !isCreatingPage;
  const showActions = isEditingLink && hasLinkValue;
  const showTextControl = hasLinkValue && hasTextControl;
  const isEditing = (isEditingLink || !value) && !isCreatingPage;
  const isDisabled = !valueHasChanges || currentInputIsEmpty;
  const showSettings = !!settings?.length && isEditingLink && hasLinkValue;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    "div",
    {
      tabIndex: -1,
      ref: wrapperNode,
      className: "block-editor-link-control",
      children: [
        isCreatingPage && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-link-control__loading", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}),
          " ",
          (0,external_wp_i18n_namespaceObject.__)("Creating"),
          "\u2026"
        ] }),
        isEditing && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
            "div",
            {
              className: dist_clsx({
                "block-editor-link-control__search-input-wrapper": true,
                "has-text-control": showTextControl,
                "has-actions": showActions
              }),
              children: [
                showTextControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  external_wp_components_namespaceObject.TextControl,
                  {
                    __nextHasNoMarginBottom: true,
                    ref: textInputRef,
                    className: "block-editor-link-control__field block-editor-link-control__text-content",
                    label: (0,external_wp_i18n_namespaceObject.__)("Text"),
                    value: internalControlValue?.title,
                    onChange: setInternalTextInputValue,
                    onKeyDown: handleSubmitWithEnter,
                    __next40pxDefaultSize: true
                  }
                ),
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  search_input_default,
                  {
                    ref: searchInputRef,
                    currentLink: value,
                    className: "block-editor-link-control__field block-editor-link-control__search-input",
                    placeholder: searchInputPlaceholder,
                    value: currentUrlInputValue,
                    withCreateSuggestion,
                    onCreateSuggestion: createPage,
                    onChange: setInternalURLInputValue,
                    onSelect: handleSelectSuggestion,
                    showInitialSuggestions,
                    allowDirectEntry: !noDirectEntry,
                    showSuggestions,
                    suggestionsQuery,
                    withURLSuggestion: !noURLSuggestion,
                    createSuggestionButtonText,
                    hideLabelFromVision: !showTextControl,
                    isEntity,
                    suffix: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                      SearchSuffixControl,
                      {
                        isEntity,
                        showActions,
                        isDisabled,
                        onUnlink: handleUnlink,
                        onSubmit: handleSubmit,
                        helpTextId
                      }
                    )
                  }
                ),
                isEntity && helpTextId && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  "p",
                  {
                    id: helpTextId,
                    className: "block-editor-link-control__help",
                    children: (0,external_wp_i18n_namespaceObject.sprintf)(
                      /* translators: %s: entity type (e.g., page, post) */
                      (0,external_wp_i18n_namespaceObject.__)("Synced with the selected %s."),
                      internalControlValue?.type || "item"
                    )
                  }
                )
              ]
            }
          ),
          errorMessage && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Notice,
            {
              className: "block-editor-link-control__search-error",
              status: "error",
              isDismissible: false,
              children: errorMessage
            }
          )
        ] }),
        value && !isEditingLink && !isCreatingPage && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          LinkPreview,
          {
            value,
            onEditClick: () => setIsEditingLink(true),
            hasRichPreviews,
            hasUnlinkControl: shownUnlinkControl,
            onRemove: () => {
              onRemove();
              setIsEditingLink(true);
            }
          },
          value?.url
        ),
        showSettings && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-link-control__tools", children: !currentInputIsEmpty && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          settings_drawer_default,
          {
            settingsOpen: isSettingsOpen,
            setSettingsOpen: setSettingsOpenWithPreference,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              settings_default,
              {
                value: internalControlValue,
                settings,
                onChange: createSetInternalSettingValueHandler(
                  settingsKeys
                )
              }
            )
          }
        ) }),
        showActions && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalHStack,
          {
            justify: "right",
            className: "block-editor-link-control__search-actions",
            children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  variant: "tertiary",
                  onClick: handleCancel,
                  children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
                }
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  variant: "primary",
                  onClick: isDisabled ? link_control_noop : handleSubmit,
                  className: "block-editor-link-control__search-submit",
                  "aria-disabled": isDisabled,
                  children: (0,external_wp_i18n_namespaceObject.__)("Apply")
                }
              )
            ]
          }
        ),
        !isCreatingPage && renderControlBottom && renderControlBottom()
      ]
    }
  );
}
function SearchSuffixControl({
  isEntity,
  showActions,
  isDisabled,
  onUnlink,
  onSubmit,
  helpTextId
}) {
  if (isEntity) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        icon: link_off_default,
        onClick: onUnlink,
        "aria-describedby": helpTextId,
        showTooltip: true,
        label: (0,external_wp_i18n_namespaceObject.__)("Unsync and edit"),
        __next40pxDefaultSize: true
      }
    );
  }
  if (showActions) {
    return void 0;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlSuffixWrapper, { variant: "control", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Button,
    {
      onClick: isDisabled ? link_control_noop : onSubmit,
      label: (0,external_wp_i18n_namespaceObject.__)("Submit"),
      icon: keyboard_return_default,
      className: "block-editor-link-control__search-submit",
      "aria-disabled": isDisabled,
      size: "small"
    }
  ) });
}
LinkControl.ViewerFill = ViewerFill;
LinkControl.DEFAULT_LINK_SETTINGS = DEFAULT_LINK_SETTINGS;
const DeprecatedExperimentalLinkControl = (props) => {
  external_wp_deprecated_default()("wp.blockEditor.__experimentalLinkControl", {
    since: "6.8",
    alternative: "wp.blockEditor.LinkControl"
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkControl, { ...props });
};
DeprecatedExperimentalLinkControl.ViewerFill = LinkControl.ViewerFill;
DeprecatedExperimentalLinkControl.DEFAULT_LINK_SETTINGS = LinkControl.DEFAULT_LINK_SETTINGS;
var link_control_default = LinkControl;


;// ./node_modules/@wordpress/block-editor/build-module/components/media-replace-flow/index.js














const media_replace_flow_noop = () => {
};
let uniqueId = 0;
const MediaReplaceFlow = ({
  mediaURL,
  mediaId,
  mediaIds,
  allowedTypes,
  accept,
  onError,
  onSelect,
  onSelectURL,
  onReset,
  onToggleFeaturedImage,
  useFeaturedImage,
  onFilesUpload = media_replace_flow_noop,
  name = (0,external_wp_i18n_namespaceObject.__)("Replace"),
  createNotice,
  removeNotice,
  children,
  multiple = false,
  addToGallery,
  handleUpload = true,
  popoverProps,
  renderToggle
}) => {
  const { getSettings } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const errorNoticeID = `block-editor/media-replace-flow/error-notice/${++uniqueId}`;
  const onUploadError = (message) => {
    const safeMessage = (0,external_wp_dom_namespaceObject.__unstableStripHTML)(message);
    if (onError) {
      onError(safeMessage);
      return;
    }
    setTimeout(() => {
      createNotice("error", safeMessage, {
        speak: true,
        id: errorNoticeID,
        isDismissible: true
      });
    }, 1e3);
  };
  const selectMedia = (media, closeMenu) => {
    if (useFeaturedImage && onToggleFeaturedImage) {
      onToggleFeaturedImage();
    }
    closeMenu();
    onSelect(media);
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)("The media file has been replaced"));
    removeNotice(errorNoticeID);
  };
  const uploadFiles = (event, closeMenu) => {
    const files = event.target.files;
    if (!handleUpload) {
      closeMenu();
      return onSelect(files);
    }
    onFilesUpload(files);
    getSettings().mediaUpload({
      allowedTypes,
      filesList: files,
      onFileChange: ([media]) => {
        selectMedia(media, closeMenu);
      },
      onError: onUploadError
    });
  };
  const openOnArrowDown = (event) => {
    if (event.keyCode === external_wp_keycodes_namespaceObject.DOWN) {
      event.preventDefault();
      event.target.click();
    }
  };
  const onlyAllowsImages = () => {
    if (!allowedTypes || allowedTypes.length === 0) {
      return false;
    }
    return allowedTypes.every(
      (allowedType) => allowedType === "image" || allowedType.startsWith("image/")
    );
  };
  const gallery = multiple && onlyAllowsImages();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Dropdown,
    {
      popoverProps,
      contentClassName: "block-editor-media-replace-flow__options",
      renderToggle: ({ isOpen, onToggle }) => {
        if (renderToggle) {
          return renderToggle({
            "aria-expanded": isOpen,
            "aria-haspopup": "true",
            onClick: onToggle,
            onKeyDown: openOnArrowDown,
            children: name
          });
        }
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.ToolbarButton,
          {
            "aria-expanded": isOpen,
            "aria-haspopup": "true",
            onClick: onToggle,
            onKeyDown: openOnArrowDown,
            children: name
          }
        );
      },
      renderContent: ({ onClose }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.NavigableMenu, { className: "block-editor-media-replace-flow__media-upload-menu", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(check_default, { children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              media_upload_default,
              {
                gallery,
                addToGallery,
                multiple,
                value: multiple ? mediaIds : mediaId,
                onSelect: (media) => selectMedia(media, onClose),
                allowedTypes,
                render: ({ open }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  external_wp_components_namespaceObject.MenuItem,
                  {
                    icon: media_default,
                    onClick: open,
                    children: (0,external_wp_i18n_namespaceObject.__)("Open Media Library")
                  }
                )
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.FormFileUpload,
              {
                onChange: (event) => {
                  uploadFiles(event, onClose);
                },
                accept,
                multiple: !!multiple,
                render: ({ openFileDialog }) => {
                  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                    external_wp_components_namespaceObject.MenuItem,
                    {
                      icon: upload_default,
                      onClick: () => {
                        openFileDialog();
                      },
                      children: (0,external_wp_i18n_namespaceObject._x)("Upload", "verb")
                    }
                  );
                }
              }
            )
          ] }),
          onToggleFeaturedImage && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.MenuItem,
            {
              icon: post_featured_image_default,
              onClick: onToggleFeaturedImage,
              isPressed: useFeaturedImage,
              children: (0,external_wp_i18n_namespaceObject.__)("Use featured image")
            }
          ),
          mediaURL && onReset && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.MenuItem,
            {
              onClick: () => {
                onReset();
                onClose();
              },
              children: (0,external_wp_i18n_namespaceObject.__)("Reset")
            }
          ),
          typeof children === "function" ? children({ onClose }) : children
        ] }),
        onSelectURL && // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("form", { className: "block-editor-media-flow__url-input", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-editor-media-replace-flow__image-url-label", children: (0,external_wp_i18n_namespaceObject.__)("Current media URL:") }),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            link_control_default,
            {
              value: { url: mediaURL },
              settings: [],
              showSuggestions: false,
              onChange: ({ url }) => {
                onSelectURL(url);
              },
              searchInputPlaceholder: (0,external_wp_i18n_namespaceObject.__)(
                "Paste or type URL"
              )
            }
          )
        ] })
      ] })
    }
  );
};
var media_replace_flow_default = (0,external_wp_compose_namespaceObject.compose)([
  (0,external_wp_data_namespaceObject.withDispatch)((dispatch) => {
    const { createNotice, removeNotice } = dispatch(external_wp_notices_namespaceObject.store);
    return {
      createNotice,
      removeNotice
    };
  }),
  (0,external_wp_components_namespaceObject.withFilters)("editor.MediaReplaceFlow")
])(MediaReplaceFlow);


;// ./node_modules/@wordpress/block-editor/build-module/components/background-image-control/index.js

















const IMAGE_BACKGROUND_TYPE = "image";
const BACKGROUND_POPOVER_PROPS = {
  placement: "left-start",
  offset: 36,
  shift: true,
  className: "block-editor-global-styles-background-panel__popover"
};
const background_image_control_noop = () => {
};
const focusToggleButton = (containerRef) => {
  window.requestAnimationFrame(() => {
    const [toggleButton] = external_wp_dom_namespaceObject.focus.tabbable.find(containerRef?.current);
    if (!toggleButton) {
      return;
    }
    toggleButton.focus();
  });
};
function backgroundSizeHelpText(value) {
  if (value === "cover" || value === void 0) {
    return (0,external_wp_i18n_namespaceObject.__)("Image covers the space evenly.");
  }
  if (value === "contain") {
    return (0,external_wp_i18n_namespaceObject.__)("Image is contained without distortion.");
  }
  return (0,external_wp_i18n_namespaceObject.__)("Image has a fixed width.");
}
const coordsToBackgroundPosition = (value) => {
  if (!value || isNaN(value.x) && isNaN(value.y)) {
    return void 0;
  }
  const x = isNaN(value.x) ? 0.5 : value.x;
  const y = isNaN(value.y) ? 0.5 : value.y;
  return `${x * 100}% ${y * 100}%`;
};
const backgroundPositionToCoords = (value) => {
  if (!value) {
    return { x: void 0, y: void 0 };
  }
  let [x, y] = value.split(" ").map((v) => parseFloat(v) / 100);
  x = isNaN(x) ? void 0 : x;
  y = isNaN(y) ? x : y;
  return { x, y };
};
function InspectorImagePreviewItem({
  as = "span",
  imgUrl,
  toggleProps = {},
  filename,
  label,
  onToggleCallback = background_image_control_noop
}) {
  const { isOpen, ...restToggleProps } = toggleProps;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (typeof isOpen !== "undefined") {
      onToggleCallback(isOpen);
    }
  }, [isOpen, onToggleCallback]);
  const renderPreviewContent = () => {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.__experimentalHStack,
      {
        justify: "flex-start",
        as: "span",
        className: "block-editor-global-styles-background-panel__inspector-preview-inner",
        children: [
          imgUrl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            "span",
            {
              className: "block-editor-global-styles-background-panel__inspector-image-indicator-wrapper",
              "aria-hidden": true,
              children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                "span",
                {
                  className: "block-editor-global-styles-background-panel__inspector-image-indicator",
                  style: {
                    backgroundImage: `url(${imgUrl})`
                  }
                }
              )
            }
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.FlexItem, { as: "span", style: imgUrl ? {} : { flexGrow: 1 }, children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalTruncate,
              {
                numberOfLines: 1,
                className: "block-editor-global-styles-background-panel__inspector-media-replace-title",
                children: label
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, { as: "span", children: imgUrl ? (0,external_wp_i18n_namespaceObject.sprintf)(
              /* translators: %s: file name */
              (0,external_wp_i18n_namespaceObject.__)("Background image: %s"),
              filename || label
            ) : (0,external_wp_i18n_namespaceObject.__)("No background image selected") })
          ] })
        ]
      }
    );
  };
  return as === "button" ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, { __next40pxDefaultSize: true, ...restToggleProps, children: renderPreviewContent() }) : renderPreviewContent();
}
function BackgroundControlsPanel({
  label,
  filename,
  url: imgUrl,
  children,
  onToggle: onToggleCallback = background_image_control_noop,
  hasImageValue,
  onReset,
  containerRef
}) {
  if (!hasImageValue) {
    return;
  }
  const imgLabel = label || (0,external_wp_url_namespaceObject.getFilename)(imgUrl) || (0,external_wp_i18n_namespaceObject.__)("Add background image");
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Dropdown,
    {
      popoverProps: BACKGROUND_POPOVER_PROPS,
      renderToggle: ({ onToggle, isOpen }) => {
        const toggleProps = {
          onClick: onToggle,
          className: "block-editor-global-styles-background-panel__dropdown-toggle",
          "aria-expanded": isOpen,
          "aria-label": (0,external_wp_i18n_namespaceObject.__)(
            "Background size, position and repeat options."
          ),
          isOpen
        };
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            InspectorImagePreviewItem,
            {
              imgUrl,
              filename,
              label: imgLabel,
              toggleProps,
              as: "button",
              onToggleCallback
            }
          ),
          onReset && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              label: (0,external_wp_i18n_namespaceObject.__)("Reset"),
              className: "block-editor-global-styles-background-panel__reset",
              size: "small",
              icon: reset_default,
              onClick: () => {
                onReset();
                if (isOpen) {
                  onToggle();
                }
                focusToggleButton(containerRef);
              }
            }
          )
        ] });
      },
      renderContent: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalDropdownContentWrapper,
        {
          className: "block-editor-global-styles-background-panel__dropdown-content-wrapper",
          paddingSize: "medium",
          children
        }
      )
    }
  );
}
function LoadingSpinner() {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Placeholder, { className: "block-editor-global-styles-background-panel__loading", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) });
}
function BackgroundImageControls({
  onChange,
  style,
  inheritedValue,
  onRemoveImage = background_image_control_noop,
  onResetImage = background_image_control_noop,
  displayInPanel,
  defaultValues,
  containerRef
}) {
  const [isUploading, setIsUploading] = (0,external_wp_element_namespaceObject.useState)(false);
  const { getSettings } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const { id, title, url } = style?.background?.backgroundImage || {
    ...inheritedValue?.background?.backgroundImage
  };
  const { createErrorNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const onUploadError = (message) => {
    createErrorNotice(message, { type: "snackbar" });
    setIsUploading(false);
  };
  const resetBackgroundImage = () => onChange(
    setImmutably(
      style,
      ["background", "backgroundImage"],
      void 0
    )
  );
  const onSelectMedia = (media) => {
    if (!media || !media.url) {
      resetBackgroundImage();
      setIsUploading(false);
      return;
    }
    if ((0,external_wp_blob_namespaceObject.isBlobURL)(media.url)) {
      setIsUploading(true);
      return;
    }
    if (media.media_type && media.media_type !== IMAGE_BACKGROUND_TYPE || !media.media_type && media.type && media.type !== IMAGE_BACKGROUND_TYPE) {
      onUploadError(
        (0,external_wp_i18n_namespaceObject.__)("Only images can be used as a background image.")
      );
      return;
    }
    const sizeValue = style?.background?.backgroundSize || defaultValues?.backgroundSize;
    const positionValue = style?.background?.backgroundPosition;
    onChange(
      setImmutably(style, ["background"], {
        ...style?.background,
        backgroundImage: {
          url: media.url,
          id: media.id,
          source: "file",
          title: media.title || void 0
        },
        backgroundPosition: (
          /*
           * A background image uploaded and set in the editor receives a default background position of '50% 0',
           * when the background image size is the equivalent of "Tile".
           * This is to increase the chance that the image's focus point is visible.
           * This is in-editor only to assist with the user experience.
           */
          !positionValue && ("auto" === sizeValue || !sizeValue) ? "50% 0" : positionValue
        ),
        backgroundSize: sizeValue
      })
    );
    setIsUploading(false);
    focusToggleButton(containerRef);
  };
  const onFilesDrop = (filesList) => {
    getSettings().mediaUpload({
      allowedTypes: [IMAGE_BACKGROUND_TYPE],
      filesList,
      onFileChange([image]) {
        onSelectMedia(image);
      },
      onError: onUploadError,
      multiple: false
    });
  };
  const hasValue = hasBackgroundImageValue(style);
  const onRemove = () => onChange(
    setImmutably(style, ["background"], {
      backgroundImage: "none"
    })
  );
  const canRemove = !hasValue && hasBackgroundImageValue(inheritedValue);
  const imgLabel = title || (0,external_wp_url_namespaceObject.getFilename)(url) || (0,external_wp_i18n_namespaceObject.__)("Add background image");
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-global-styles-background-panel__image-tools-panel-item", children: [
    isUploading && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LoadingSpinner, {}),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      media_replace_flow_default,
      {
        mediaId: id,
        mediaURL: url,
        allowedTypes: [IMAGE_BACKGROUND_TYPE],
        accept: "image/*",
        onSelect: onSelectMedia,
        popoverProps: {
          className: dist_clsx({
            "block-editor-global-styles-background-panel__media-replace-popover": displayInPanel
          })
        },
        name: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          InspectorImagePreviewItem,
          {
            imgUrl: url,
            filename: title,
            label: imgLabel
          }
        ),
        renderToggle: (props) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, { ...props, __next40pxDefaultSize: true }),
        onError: onUploadError,
        onReset: () => {
          focusToggleButton(containerRef);
          onResetImage();
        },
        children: canRemove && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.MenuItem,
          {
            onClick: () => {
              focusToggleButton(containerRef);
              onRemove();
              onRemoveImage();
            },
            children: (0,external_wp_i18n_namespaceObject.__)("Remove")
          }
        )
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.DropZone,
      {
        onFilesDrop,
        label: (0,external_wp_i18n_namespaceObject.__)("Drop to upload")
      }
    )
  ] });
}
function BackgroundSizeControls({
  onChange,
  style,
  inheritedValue,
  defaultValues
}) {
  const sizeValue = style?.background?.backgroundSize || inheritedValue?.background?.backgroundSize;
  const repeatValue = style?.background?.backgroundRepeat || inheritedValue?.background?.backgroundRepeat;
  const imageValue = style?.background?.backgroundImage?.url || inheritedValue?.background?.backgroundImage?.url;
  const isUploadedImage = style?.background?.backgroundImage?.id;
  const positionValue = style?.background?.backgroundPosition || inheritedValue?.background?.backgroundPosition;
  const attachmentValue = style?.background?.backgroundAttachment || inheritedValue?.background?.backgroundAttachment;
  let currentValueForToggle = !sizeValue && isUploadedImage ? defaultValues?.backgroundSize : sizeValue || "auto";
  currentValueForToggle = !["cover", "contain", "auto"].includes(
    currentValueForToggle
  ) ? "auto" : currentValueForToggle;
  const repeatCheckedValue = !(repeatValue === "no-repeat" || currentValueForToggle === "cover" && repeatValue === void 0);
  const updateBackgroundSize = (next) => {
    let nextRepeat = repeatValue;
    let nextPosition = positionValue;
    if (next === "contain") {
      nextRepeat = "no-repeat";
      nextPosition = void 0;
    }
    if (next === "cover") {
      nextRepeat = void 0;
      nextPosition = void 0;
    }
    if ((currentValueForToggle === "cover" || currentValueForToggle === "contain") && next === "auto") {
      nextRepeat = void 0;
      if (!!style?.background?.backgroundImage?.id) {
        nextPosition = "50% 0";
      }
    }
    if (!next && currentValueForToggle === "auto") {
      next = "auto";
    }
    onChange(
      setImmutably(style, ["background"], {
        ...style?.background,
        backgroundPosition: nextPosition,
        backgroundRepeat: nextRepeat,
        backgroundSize: next
      })
    );
  };
  const updateBackgroundPosition = (next) => {
    onChange(
      setImmutably(
        style,
        ["background", "backgroundPosition"],
        coordsToBackgroundPosition(next)
      )
    );
  };
  const toggleIsRepeated = () => onChange(
    setImmutably(
      style,
      ["background", "backgroundRepeat"],
      repeatCheckedValue === true ? "no-repeat" : "repeat"
    )
  );
  const toggleScrollWithPage = () => onChange(
    setImmutably(
      style,
      ["background", "backgroundAttachment"],
      attachmentValue === "fixed" ? "scroll" : "fixed"
    )
  );
  const backgroundPositionValue = !positionValue && isUploadedImage && "contain" === sizeValue ? defaultValues?.backgroundPosition : positionValue;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 3, className: "single-column", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.FocalPointPicker,
      {
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)("Focal point"),
        url: imageValue,
        value: backgroundPositionToCoords(backgroundPositionValue),
        onChange: updateBackgroundPosition
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.ToggleControl,
      {
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)("Fixed background"),
        checked: attachmentValue === "fixed",
        onChange: toggleScrollWithPage
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.__experimentalToggleGroupControl,
      {
        __nextHasNoMarginBottom: true,
        size: "__unstable-large",
        label: (0,external_wp_i18n_namespaceObject.__)("Size"),
        value: currentValueForToggle,
        onChange: updateBackgroundSize,
        isBlock: true,
        help: backgroundSizeHelpText(
          sizeValue || defaultValues?.backgroundSize
        ),
        children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
            {
              value: "cover",
              label: (0,external_wp_i18n_namespaceObject._x)(
                "Cover",
                "Size option for background image control"
              )
            },
            "cover"
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
            {
              value: "contain",
              label: (0,external_wp_i18n_namespaceObject._x)(
                "Contain",
                "Size option for background image control"
              )
            },
            "contain"
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
            {
              value: "auto",
              label: (0,external_wp_i18n_namespaceObject._x)(
                "Tile",
                "Size option for background image control"
              )
            },
            "tile"
          )
        ]
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "flex-start", spacing: 2, as: "span", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalUnitControl,
        {
          "aria-label": (0,external_wp_i18n_namespaceObject.__)("Background image width"),
          onChange: updateBackgroundSize,
          value: sizeValue,
          size: "__unstable-large",
          __unstableInputWidth: "100px",
          min: 0,
          placeholder: (0,external_wp_i18n_namespaceObject.__)("Auto"),
          disabled: currentValueForToggle !== "auto" || currentValueForToggle === void 0
        }
      ),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.ToggleControl,
        {
          __nextHasNoMarginBottom: true,
          label: (0,external_wp_i18n_namespaceObject.__)("Repeat"),
          checked: repeatCheckedValue,
          onChange: toggleIsRepeated,
          disabled: currentValueForToggle === "cover"
        }
      )
    ] })
  ] });
}
function BackgroundImagePanel({
  value,
  onChange,
  inheritedValue = value,
  settings,
  defaultValues = {}
}) {
  const { globalStyles, _links } = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const { getSettings } = select(store);
    const _settings = getSettings();
    return {
      globalStyles: _settings[globalStylesDataKey],
      _links: _settings[globalStylesLinksDataKey]
    };
  }, []);
  const resolvedInheritedValue = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const resolvedValues = {
      background: {}
    };
    if (!inheritedValue?.background) {
      return inheritedValue;
    }
    Object.entries(inheritedValue?.background).forEach(
      ([key, backgroundValue]) => {
        resolvedValues.background[key] = getResolvedValue(
          backgroundValue,
          {
            styles: globalStyles,
            _links
          }
        );
      }
    );
    return resolvedValues;
  }, [globalStyles, _links, inheritedValue]);
  const resetBackground = () => onChange(setImmutably(value, ["background"], {}));
  const { title, url } = value?.background?.backgroundImage || {
    ...resolvedInheritedValue?.background?.backgroundImage
  };
  const hasImageValue = hasBackgroundImageValue(value) || hasBackgroundImageValue(resolvedInheritedValue);
  const imageValue = value?.background?.backgroundImage || inheritedValue?.background?.backgroundImage;
  const shouldShowBackgroundImageControls = hasImageValue && "none" !== imageValue && (settings?.background?.backgroundSize || settings?.background?.backgroundPosition || settings?.background?.backgroundRepeat);
  const [isDropDownOpen, setIsDropDownOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const containerRef = (0,external_wp_element_namespaceObject.useRef)();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "div",
    {
      ref: containerRef,
      className: dist_clsx(
        "block-editor-global-styles-background-panel__inspector-media-replace-container",
        {
          "is-open": isDropDownOpen
        }
      ),
      children: shouldShowBackgroundImageControls ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        BackgroundControlsPanel,
        {
          label: title,
          filename: title,
          url,
          onToggle: setIsDropDownOpen,
          hasImageValue,
          onReset: resetBackground,
          containerRef,
          children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 3, className: "single-column", children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              BackgroundImageControls,
              {
                onChange,
                style: value,
                inheritedValue: resolvedInheritedValue,
                displayInPanel: true,
                onResetImage: () => {
                  setIsDropDownOpen(false);
                  resetBackground();
                },
                onRemoveImage: () => setIsDropDownOpen(false),
                defaultValues,
                containerRef
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              BackgroundSizeControls,
              {
                onChange,
                style: value,
                defaultValues,
                inheritedValue: resolvedInheritedValue
              }
            )
          ] })
        }
      ) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        BackgroundImageControls,
        {
          onChange,
          style: value,
          inheritedValue: resolvedInheritedValue,
          defaultValues,
          onResetImage: () => {
            setIsDropDownOpen(false);
            resetBackground();
          },
          onRemoveImage: () => setIsDropDownOpen(false),
          containerRef
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/background-panel.js







const background_panel_DEFAULT_CONTROLS = {
  backgroundImage: true
};
function useHasBackgroundPanel(settings) {
  return external_wp_element_namespaceObject.Platform.OS === "web" && settings?.background?.backgroundImage;
}
function hasBackgroundSizeValue(style) {
  return style?.background?.backgroundPosition !== void 0 || style?.background?.backgroundSize !== void 0;
}
function hasBackgroundImageValue(style) {
  return !!style?.background?.backgroundImage?.id || // Supports url() string values in theme.json.
  "string" === typeof style?.background?.backgroundImage || !!style?.background?.backgroundImage?.url;
}
function BackgroundToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children,
  headerLabel
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label: headerLabel,
      resetAll,
      panelId,
      dropdownMenuProps,
      children
    }
  );
}
function background_panel_BackgroundImagePanel({
  as: Wrapper = BackgroundToolsPanel,
  value,
  onChange,
  inheritedValue,
  settings,
  panelId,
  defaultControls = background_panel_DEFAULT_CONTROLS,
  defaultValues = {},
  headerLabel = (0,external_wp_i18n_namespaceObject.__)("Background image")
}) {
  const showBackgroundImageControl = useHasBackgroundPanel(settings);
  const resetBackground = () => onChange(setImmutably(value, ["background"], {}));
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      background: {}
    };
  }, []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      headerLabel,
      children: showBackgroundImageControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalToolsPanelItem,
        {
          hasValue: () => !!value?.background,
          label: (0,external_wp_i18n_namespaceObject.__)("Image"),
          onDeselect: resetBackground,
          isShownByDefault: defaultControls.backgroundImage,
          panelId,
          children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            BackgroundImagePanel,
            {
              value,
              onChange,
              settings,
              inheritedValue,
              defaultControls,
              defaultValues
            }
          )
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/background.js









const BACKGROUND_SUPPORT_KEY = "background";
const BACKGROUND_BLOCK_DEFAULT_VALUES = {
  backgroundSize: "cover",
  backgroundPosition: "50% 50%"
  // used only when backgroundSize is 'contain'.
};
function hasBackgroundSupport(blockName, feature = "any") {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, BACKGROUND_SUPPORT_KEY);
  if (support === true) {
    return true;
  }
  if (feature === "any") {
    return !!support?.backgroundImage || !!support?.backgroundSize || !!support?.backgroundRepeat;
  }
  return !!support?.[feature];
}
function setBackgroundStyleDefaults(backgroundStyle) {
  if (!backgroundStyle || !backgroundStyle?.backgroundImage?.url) {
    return;
  }
  let backgroundStylesWithDefaults;
  if (!backgroundStyle?.backgroundSize) {
    backgroundStylesWithDefaults = {
      backgroundSize: BACKGROUND_BLOCK_DEFAULT_VALUES.backgroundSize
    };
  }
  if ("contain" === backgroundStyle?.backgroundSize && !backgroundStyle?.backgroundPosition) {
    backgroundStylesWithDefaults = {
      backgroundPosition: BACKGROUND_BLOCK_DEFAULT_VALUES.backgroundPosition
    };
  }
  return backgroundStylesWithDefaults;
}
function background_useBlockProps({ name, style }) {
  if (!hasBackgroundSupport(name) || !style?.background?.backgroundImage) {
    return;
  }
  const backgroundStyles = setBackgroundStyleDefaults(style?.background);
  if (!backgroundStyles) {
    return;
  }
  return {
    style: {
      ...backgroundStyles
    }
  };
}
function getBackgroundImageClasses(style) {
  return hasBackgroundImageValue(style) ? "has-background" : "";
}
function BackgroundInspectorControl({ children }) {
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((attributes) => {
    return {
      ...attributes,
      style: {
        ...attributes.style,
        background: void 0
      }
    };
  }, []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls_default, { group: "background", resetAllFilter, children });
}
function background_BackgroundImagePanel({
  clientId,
  name,
  setAttributes,
  settings
}) {
  const { style, inheritedValue } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getBlockAttributes, getSettings } = select(store);
      const _settings = getSettings();
      return {
        style: getBlockAttributes(clientId)?.style,
        /*
         * To ensure we pass down the right inherited values:
         * @TODO 1. Pass inherited value down to all block style controls,
         *   See: packages/block-editor/src/hooks/style.js
         * @TODO 2. Add support for block style variations,
         *   See implementation: packages/block-editor/src/hooks/block-style-variation.js
         */
        inheritedValue: _settings[globalStylesDataKey]?.blocks?.[name]
      };
    },
    [clientId, name]
  );
  if (!useHasBackgroundPanel(settings) || !hasBackgroundSupport(name, "backgroundImage")) {
    return null;
  }
  const onChange = (newStyle) => {
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };
  const updatedSettings = {
    ...settings,
    background: {
      ...settings.background,
      backgroundSize: settings?.background?.backgroundSize && hasBackgroundSupport(name, "backgroundSize")
    }
  };
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    BACKGROUND_SUPPORT_KEY,
    "defaultControls"
  ]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    background_panel_BackgroundImagePanel,
    {
      inheritedValue,
      as: BackgroundInspectorControl,
      panelId: clientId,
      defaultValues: BACKGROUND_BLOCK_DEFAULT_VALUES,
      settings: updatedSettings,
      onChange,
      defaultControls,
      value: style
    }
  );
}
var background_default = {
  useBlockProps: background_useBlockProps,
  attributeKeys: ["style"],
  hasSupport: hasBackgroundSupport
};


;// ./node_modules/@wordpress/block-editor/build-module/hooks/lock.js

function lock_addAttribute(settings) {
  if ("type" in (settings.attributes?.lock ?? {})) {
    return settings;
  }
  settings.attributes = {
    ...settings.attributes,
    lock: {
      type: "object"
    }
  };
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)("blocks.registerBlockType", "core/lock/addAttribute", lock_addAttribute);


;// ./node_modules/@wordpress/icons/build-module/library/block-default.js


var block_default_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M19 8h-1V6h-5v2h-2V6H6v2H5c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-8c0-1.1-.9-2-2-2zm.5 10c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5v-8c0-.3.2-.5.5-.5h14c.3 0 .5.2.5.5v8z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/block-icon/index.js





function BlockIcon({ icon, showColors = false, className, context }) {
  if (icon?.src === "block-default") {
    icon = {
      src: block_default_default
    };
  }
  const renderedIcon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Icon, { icon: icon && icon.src ? icon.src : icon, context });
  const style = showColors ? {
    backgroundColor: icon && icon.background,
    color: icon && icon.foreground
  } : {};
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "span",
    {
      style,
      className: dist_clsx("block-editor-block-icon", className, {
        "has-colors": showColors
      }),
      children: renderedIcon
    }
  );
}
var block_icon_default = (0,external_wp_element_namespaceObject.memo)(BlockIcon);


;// ./node_modules/@wordpress/block-editor/build-module/components/block-manager/checklist.js



function BlockTypesChecklist({ blockTypes, value, onItemChange }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", { className: "block-editor-block-manager__checklist", children: blockTypes.map((blockType) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    "li",
    {
      className: "block-editor-block-manager__checklist-item",
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.CheckboxControl,
          {
            __nextHasNoMarginBottom: true,
            label: blockType.title,
            checked: value.includes(blockType.name),
            onChange: (...args) => onItemChange(blockType, ...args)
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_icon_default, { icon: blockType.icon })
      ]
    },
    blockType.name
  )) });
}
var checklist_default = BlockTypesChecklist;


;// ./node_modules/@wordpress/block-editor/build-module/components/block-manager/category.js





function BlockManagerCategory({
  title,
  blockTypes,
  selectedBlockTypes,
  onChange
}) {
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(BlockManagerCategory);
  const toggleVisible = (0,external_wp_element_namespaceObject.useCallback)(
    (blockType, nextIsChecked) => {
      if (nextIsChecked) {
        onChange([...selectedBlockTypes, blockType]);
      } else {
        onChange(
          selectedBlockTypes.filter(
            ({ name }) => name !== blockType.name
          )
        );
      }
    },
    [selectedBlockTypes, onChange]
  );
  const toggleAllVisible = (0,external_wp_element_namespaceObject.useCallback)(
    (nextIsChecked) => {
      if (nextIsChecked) {
        onChange([
          ...selectedBlockTypes,
          ...blockTypes.filter(
            (blockType) => !selectedBlockTypes.find(
              ({ name }) => name === blockType.name
            )
          )
        ]);
      } else {
        onChange(
          selectedBlockTypes.filter(
            (selectedBlockType) => !blockTypes.find(
              ({ name }) => name === selectedBlockType.name
            )
          )
        );
      }
    },
    [blockTypes, selectedBlockTypes, onChange]
  );
  if (!blockTypes.length) {
    return null;
  }
  const checkedBlockNames = blockTypes.map(({ name }) => name).filter(
    (type) => (selectedBlockTypes ?? []).some(
      (selectedBlockType) => selectedBlockType.name === type
    )
  );
  const titleId = "block-editor-block-manager__category-title-" + instanceId;
  const isAllChecked = checkedBlockNames.length === blockTypes.length;
  const isIndeterminate = !isAllChecked && checkedBlockNames.length > 0;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    "div",
    {
      role: "group",
      "aria-labelledby": titleId,
      className: "block-editor-block-manager__category",
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.CheckboxControl,
          {
            __nextHasNoMarginBottom: true,
            checked: isAllChecked,
            onChange: toggleAllVisible,
            className: "block-editor-block-manager__category-title",
            indeterminate: isIndeterminate,
            label: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { id: titleId, children: title })
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          checklist_default,
          {
            blockTypes,
            value: checkedBlockNames,
            onItemChange: toggleVisible
          }
        )
      ]
    }
  );
}
var category_category_default = BlockManagerCategory;


;// ./node_modules/@wordpress/block-editor/build-module/components/block-manager/index.js









function BlockManager({
  blockTypes,
  selectedBlockTypes,
  onChange,
  showSelectAll = true
}) {
  const debouncedSpeak = (0,external_wp_compose_namespaceObject.useDebounce)(external_wp_a11y_namespaceObject.speak, 500);
  const [search, setSearch] = (0,external_wp_element_namespaceObject.useState)("");
  const { categories, isMatchingSearchTerm } = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    return {
      categories: select(external_wp_blocks_namespaceObject.store).getCategories(),
      isMatchingSearchTerm: select(external_wp_blocks_namespaceObject.store).isMatchingSearchTerm
    };
  }, []);
  const filteredBlockTypes = blockTypes.filter((blockType) => {
    return !search || isMatchingSearchTerm(blockType, search);
  });
  const isIndeterminate = selectedBlockTypes.length > 0 && selectedBlockTypes.length !== blockTypes.length;
  const isAllChecked = blockTypes.length > 0 && selectedBlockTypes.length === blockTypes.length;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!search) {
      return;
    }
    const count = filteredBlockTypes.length;
    const resultsFoundMessage = (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: %d: number of results. */
      (0,external_wp_i18n_namespaceObject._n)("%d result found.", "%d results found.", count),
      count
    );
    debouncedSpeak(resultsFoundMessage);
  }, [filteredBlockTypes?.length, search, debouncedSpeak]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { className: "block-editor-block-manager__content", spacing: 4, children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.SearchControl,
      {
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)("Search for a block"),
        placeholder: (0,external_wp_i18n_namespaceObject.__)("Search for a block"),
        value: search,
        onChange: (nextSearch) => setSearch(nextSearch),
        className: "block-editor-block-manager__search"
      }
    ),
    showSelectAll && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.CheckboxControl,
      {
        className: "block-editor-block-manager__select-all",
        label: (0,external_wp_i18n_namespaceObject.__)("Select all"),
        checked: isAllChecked,
        onChange: () => {
          if (isAllChecked) {
            onChange([]);
          } else {
            onChange(blockTypes);
          }
        },
        indeterminate: isIndeterminate,
        __nextHasNoMarginBottom: true
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      "div",
      {
        tabIndex: "0",
        role: "region",
        "aria-label": (0,external_wp_i18n_namespaceObject.__)("Available block types"),
        className: "block-editor-block-manager__results",
        children: [
          filteredBlockTypes.length === 0 && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "block-editor-block-manager__no-results", children: (0,external_wp_i18n_namespaceObject.__)("No blocks found.") }),
          categories.map((category) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            category_category_default,
            {
              title: category.title,
              blockTypes: filteredBlockTypes.filter(
                (blockType) => blockType.category === category.slug
              ),
              selectedBlockTypes,
              onChange
            },
            category.slug
          )),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            category_category_default,
            {
              title: (0,external_wp_i18n_namespaceObject.__)("Uncategorized"),
              blockTypes: filteredBlockTypes.filter(
                ({ category }) => !category
              ),
              selectedBlockTypes,
              onChange
            }
          )
        ]
      }
    )
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-allowed-blocks/modal.js







function BlockAllowedBlocksModal({
  clientId,
  blockTypes,
  selectedBlockTypes,
  onClose
}) {
  const [currentSelectedBlockTypes, setCurrentSelectedBlockTypes] = (0,external_wp_element_namespaceObject.useState)(selectedBlockTypes);
  const { updateBlockAttributes } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const handleSubmit = () => {
    const isFullySelected = currentSelectedBlockTypes.length === blockTypes.length;
    const newBlockNames = currentSelectedBlockTypes.map(
      ({ name }) => name
    );
    updateBlockAttributes(clientId, {
      allowedBlocks: isFullySelected ? void 0 : newBlockNames
    });
    onClose();
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: (0,external_wp_i18n_namespaceObject.__)("Manage allowed blocks"),
      onRequestClose: onClose,
      overlayClassName: "block-editor-block-allowed-blocks-modal",
      focusOnMount: "firstContentElement",
      size: "medium",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
        external_wp_components_namespaceObject.__experimentalVStack,
        {
          as: "form",
          onSubmit: (e) => {
            e.preventDefault();
            handleSubmit();
          },
          spacing: "4",
          children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, { children: (0,external_wp_i18n_namespaceObject.__)(
              "Select which blocks can be added inside this container."
            ) }),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              BlockManager,
              {
                blockTypes,
                selectedBlockTypes: currentSelectedBlockTypes,
                onChange: (newSelectedBlockTypes) => {
                  setCurrentSelectedBlockTypes(newSelectedBlockTypes);
                }
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
              external_wp_components_namespaceObject.Flex,
              {
                className: "block-editor-block-allowed-blocks-modal__actions",
                justify: "flex-end",
                expanded: false,
                children: [
                  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                    external_wp_components_namespaceObject.Button,
                    {
                      variant: "tertiary",
                      onClick: onClose,
                      __next40pxDefaultSize: true,
                      children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
                    }
                  ) }),
                  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                    external_wp_components_namespaceObject.Button,
                    {
                      variant: "primary",
                      type: "submit",
                      __next40pxDefaultSize: true,
                      children: (0,external_wp_i18n_namespaceObject.__)("Apply")
                    }
                  ) })
                ]
              }
            )
          ]
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-allowed-blocks/allowed-blocks-control.js








function BlockAllowedBlocksControl({ clientId }) {
  const [isBlockControlOpened, setIsBlockControlOpened] = (0,external_wp_element_namespaceObject.useState)(false);
  const { blockTypes, selectedBlockNames } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getBlockAttributes } = select(store);
      return {
        blockTypes: select(external_wp_blocks_namespaceObject.store).getBlockTypes(),
        selectedBlockNames: getBlockAttributes(clientId)?.allowedBlocks
      };
    },
    [clientId]
  );
  const filteredBlockTypes = blockTypes.filter(
    (blockType) => (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "inserter", true) && (!blockType.parent || blockType.parent.includes("core/post-content"))
  );
  if (!filteredBlockTypes) {
    return null;
  }
  const selectedBlockTypes = selectedBlockNames === void 0 ? filteredBlockTypes : filteredBlockTypes.filter(
    (blockType) => selectedBlockNames.includes(blockType.name)
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-block-allowed-blocks-control", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.BaseControl,
      {
        help: (0,external_wp_i18n_namespaceObject.__)(
          "Specify which blocks are allowed inside this container."
        ),
        __nextHasNoMarginBottom: true,
        children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { children: (0,external_wp_i18n_namespaceObject.__)("Allowed Blocks") }),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "secondary",
              onClick: () => {
                setIsBlockControlOpened(true);
              },
              className: "block-editor-block-allowed-blocks-control__button",
              children: (0,external_wp_i18n_namespaceObject.__)("Manage allowed blocks")
            }
          )
        ]
      }
    ),
    isBlockControlOpened && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      BlockAllowedBlocksModal,
      {
        clientId,
        blockTypes: filteredBlockTypes,
        selectedBlockTypes,
        onClose: () => setIsBlockControlOpened(false)
      }
    )
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/allowed-blocks.js







function BlockEditAllowedBlocksControlPure({ clientId }) {
  const isContentOnly = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      return select(store).getBlockEditingMode(clientId) === "contentOnly";
    },
    [clientId]
  );
  if (isContentOnly) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivateInspectorControlsAllowedBlocks.Fill, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockAllowedBlocksControl, { clientId }) });
}
var allowed_blocks_default = {
  edit: BlockEditAllowedBlocksControlPure,
  attributeKeys: ["allowedBlocks"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "allowedBlocks");
  }
};
function allowed_blocks_addAttribute(settings) {
  if (settings?.attributes?.allowedBlocks?.type) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "allowedBlocks")) {
    settings.attributes = {
      ...settings.attributes,
      allowedBlocks: {
        type: "array"
      }
    };
  }
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/allowedBlocks/attribute",
  allowed_blocks_addAttribute
);
function addTransforms(result, source, index, results) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(result.name, "allowedBlocks")) {
    return result;
  }
  if (source.length !== 1 && results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  }
  if (results.length === 1 && source.length > 1 || results.length > 1 && source.length === 1) {
    return result;
  }
  if (results.length > 1 && source.length > 1 && results.length !== source.length) {
    return result;
  }
  if (result.attributes.allowedBlocks) {
    return result;
  }
  const sourceAllowedBlocks = source[index]?.attributes?.allowedBlocks;
  if (!sourceAllowedBlocks) {
    return result;
  }
  const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(result.name);
  const destinationAllowedBlocks = blockType?.allowedBlocks || [];
  if (!destinationAllowedBlocks.length) {
    return {
      ...result,
      attributes: {
        ...result.attributes,
        allowedBlocks: sourceAllowedBlocks
      }
    };
  }
  const filteredSourceAllowedBlocks = sourceAllowedBlocks.filter(
    (block) => destinationAllowedBlocks.includes(block)
  );
  return {
    ...result,
    attributes: {
      ...result.attributes,
      allowedBlocks: filteredSourceAllowedBlocks
    }
  };
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.switchToBlockType.transformedBlock",
  "core/allowedBlocks/addTransforms",
  addTransforms
);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/anchor.js








const ANCHOR_REGEX = /[\s#]/g;
const ANCHOR_SCHEMA = {
  type: "string",
  source: "attribute",
  attribute: "id",
  selector: "*"
};
function anchor_addAttribute(settings) {
  if ("type" in (settings.attributes?.anchor ?? {})) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "anchor")) {
    settings.attributes = {
      ...settings.attributes,
      anchor: ANCHOR_SCHEMA
    };
  }
  return settings;
}
function BlockEditAnchorControlPure({ anchor, setAttributes }) {
  const blockEditingMode = useBlockEditingMode();
  if (blockEditingMode !== "default") {
    return null;
  }
  const isWeb = external_wp_element_namespaceObject.Platform.OS === "web";
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls_default, { group: "advanced", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.TextControl,
    {
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      className: "html-anchor-control",
      label: (0,external_wp_i18n_namespaceObject.__)("HTML anchor"),
      help: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
        (0,external_wp_i18n_namespaceObject.__)(
          "Enter a word or two \u2014 without spaces \u2014 to make a unique web address just for this block, called an \u201Canchor\u201D. Then, you\u2019ll be able to link directly to this section of your page."
        ),
        isWeb && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
          " ",
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.ExternalLink,
            {
              href: (0,external_wp_i18n_namespaceObject.__)(
                "https://wordpress.org/documentation/article/page-jumps/"
              ),
              children: (0,external_wp_i18n_namespaceObject.__)("Learn more about anchors")
            }
          )
        ] })
      ] }),
      value: anchor || "",
      placeholder: !isWeb ? (0,external_wp_i18n_namespaceObject.__)("Add an anchor") : null,
      onChange: (nextValue) => {
        nextValue = nextValue.replace(ANCHOR_REGEX, "-");
        setAttributes({
          anchor: nextValue
        });
      },
      autoCapitalize: "none",
      autoComplete: "off"
    }
  ) });
}
var anchor_default = {
  addSaveProps,
  edit: BlockEditAnchorControlPure,
  attributeKeys: ["anchor"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "anchor");
  }
};
function addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "anchor")) {
    extraProps.id = attributes.anchor === "" ? null : attributes.anchor;
  }
  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)("blocks.registerBlockType", "core/anchor/attribute", anchor_addAttribute);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/aria-label.js


function aria_label_addAttribute(settings) {
  if (settings?.attributes?.ariaLabel?.type) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "ariaLabel")) {
    settings.attributes = {
      ...settings.attributes,
      ariaLabel: {
        type: "string"
      }
    };
  }
  return settings;
}
function aria_label_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "ariaLabel")) {
    extraProps["aria-label"] = attributes.ariaLabel === "" ? null : attributes.ariaLabel;
  }
  return extraProps;
}
var aria_label_default = {
  addSaveProps: aria_label_addSaveProps,
  attributeKeys: ["ariaLabel"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "ariaLabel");
  }
};
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/ariaLabel/attribute",
  aria_label_addAttribute
);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/custom-class-name.js








function custom_class_name_addAttribute(settings) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "customClassName", true)) {
    settings.attributes = {
      ...settings.attributes,
      className: {
        type: "string"
      }
    };
  }
  return settings;
}
function CustomClassNameControlsPure({ className, setAttributes }) {
  const blockEditingMode = useBlockEditingMode();
  if (blockEditingMode !== "default") {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls_default, { group: "advanced", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.TextControl,
    {
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      autoComplete: "off",
      label: (0,external_wp_i18n_namespaceObject.__)("Additional CSS class(es)"),
      value: className || "",
      onChange: (nextValue) => {
        setAttributes({
          className: nextValue !== "" ? nextValue : void 0
        });
      },
      help: (0,external_wp_i18n_namespaceObject.__)("Separate multiple classes with spaces.")
    }
  ) });
}
var custom_class_name_default = {
  edit: CustomClassNameControlsPure,
  addSaveProps: custom_class_name_addSaveProps,
  attributeKeys: ["className"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "customClassName", true);
  }
};
function custom_class_name_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "customClassName", true) && attributes.className) {
    extraProps.className = dist_clsx(
      extraProps.className,
      attributes.className
    );
  }
  return extraProps;
}
function custom_class_name_addTransforms(result, source, index, results) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(result.name, "customClassName", true)) {
    return result;
  }
  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  }
  if (results.length === 1 && source.length > 1 || results.length > 1 && source.length === 1) {
    return result;
  }
  if (source[index]) {
    const originClassName = source[index]?.attributes.className;
    if (originClassName && result.attributes.className === void 0) {
      return {
        ...result,
        attributes: {
          ...result.attributes,
          className: originClassName
        }
      };
    }
  }
  return result;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/editor/custom-class-name/attribute",
  custom_class_name_addAttribute
);
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.switchToBlockType.transformedBlock",
  "core/customClassName/addTransforms",
  custom_class_name_addTransforms
);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/generated-class-name.js


function addGeneratedClassName(extraProps, blockType) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "className", true)) {
    if (typeof extraProps.className === "string") {
      extraProps.className = [
        .../* @__PURE__ */ new Set([
          (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name),
          ...extraProps.className.split(" ")
        ])
      ].join(" ").trim();
    } else {
      extraProps.className = (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name);
    }
  }
  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.getSaveContent.extraProps",
  "core/generated-class-name/save-props",
  addGeneratedClassName
);


;// ./node_modules/colord/index.mjs
var colord_r={grad:.9,turn:360,rad:360/(2*Math.PI)},t=function(r){return"string"==typeof r?r.length>0:"number"==typeof r},n=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=Math.pow(10,t)),Math.round(n*r)/n+0},e=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=1),r>n?n:r>t?r:t},u=function(r){return(r=isFinite(r)?r%360:0)>0?r:r+360},a=function(r){return{r:e(r.r,0,255),g:e(r.g,0,255),b:e(r.b,0,255),a:e(r.a)}},o=function(r){return{r:n(r.r),g:n(r.g),b:n(r.b),a:n(r.a,3)}},i=/^#([0-9a-f]{3,8})$/i,s=function(r){var t=r.toString(16);return t.length<2?"0"+t:t},h=function(r){var t=r.r,n=r.g,e=r.b,u=r.a,a=Math.max(t,n,e),o=a-Math.min(t,n,e),i=o?a===t?(n-e)/o:a===n?2+(e-t)/o:4+(t-n)/o:0;return{h:60*(i<0?i+6:i),s:a?o/a*100:0,v:a/255*100,a:u}},b=function(r){var t=r.h,n=r.s,e=r.v,u=r.a;t=t/360*6,n/=100,e/=100;var a=Math.floor(t),o=e*(1-n),i=e*(1-(t-a)*n),s=e*(1-(1-t+a)*n),h=a%6;return{r:255*[e,i,o,o,s,e][h],g:255*[s,e,e,i,o,o][h],b:255*[o,o,s,e,e,i][h],a:u}},g=function(r){return{h:u(r.h),s:e(r.s,0,100),l:e(r.l,0,100),a:e(r.a)}},d=function(r){return{h:n(r.h),s:n(r.s),l:n(r.l),a:n(r.a,3)}},f=function(r){return b((n=(t=r).s,{h:t.h,s:(n*=((e=t.l)<50?e:100-e)/100)>0?2*n/(e+n)*100:0,v:e+n,a:t.a}));var t,n,e},c=function(r){return{h:(t=h(r)).h,s:(u=(200-(n=t.s))*(e=t.v)/100)>0&&u<200?n*e/100/(u<=100?u:200-u)*100:0,l:u/2,a:t.a};var t,n,e,u},l=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(r){var t=i.exec(r);return t?(r=t[1]).length<=4?{r:parseInt(r[0]+r[0],16),g:parseInt(r[1]+r[1],16),b:parseInt(r[2]+r[2],16),a:4===r.length?n(parseInt(r[3]+r[3],16)/255,2):1}:6===r.length||8===r.length?{r:parseInt(r.substr(0,2),16),g:parseInt(r.substr(2,2),16),b:parseInt(r.substr(4,2),16),a:8===r.length?n(parseInt(r.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(r){var t=v.exec(r)||m.exec(r);return t?t[2]!==t[4]||t[4]!==t[6]?null:a({r:Number(t[1])/(t[2]?100/255:1),g:Number(t[3])/(t[4]?100/255:1),b:Number(t[5])/(t[6]?100/255:1),a:void 0===t[7]?1:Number(t[7])/(t[8]?100:1)}):null},"rgb"],[function(t){var n=l.exec(t)||p.exec(t);if(!n)return null;var e,u,a=g({h:(e=n[1],u=n[2],void 0===u&&(u="deg"),Number(e)*(colord_r[u]||1)),s:Number(n[3]),l:Number(n[4]),a:void 0===n[5]?1:Number(n[5])/(n[6]?100:1)});return f(a)},"hsl"]],object:[[function(r){var n=r.r,e=r.g,u=r.b,o=r.a,i=void 0===o?1:o;return t(n)&&t(e)&&t(u)?a({r:Number(n),g:Number(e),b:Number(u),a:Number(i)}):null},"rgb"],[function(r){var n=r.h,e=r.s,u=r.l,a=r.a,o=void 0===a?1:a;if(!t(n)||!t(e)||!t(u))return null;var i=g({h:Number(n),s:Number(e),l:Number(u),a:Number(o)});return f(i)},"hsl"],[function(r){var n=r.h,a=r.s,o=r.v,i=r.a,s=void 0===i?1:i;if(!t(n)||!t(a)||!t(o))return null;var h=function(r){return{h:u(r.h),s:e(r.s,0,100),v:e(r.v,0,100),a:e(r.a)}}({h:Number(n),s:Number(a),v:Number(o),a:Number(s)});return b(h)},"hsv"]]},N=function(r,t){for(var n=0;n<t.length;n++){var e=t[n][0](r);if(e)return[e,t[n][1]]}return[null,void 0]},x=function(r){return"string"==typeof r?N(r.trim(),y.string):"object"==typeof r&&null!==r?N(r,y.object):[null,void 0]},I=function(r){return x(r)[1]},M=function(r,t){var n=c(r);return{h:n.h,s:e(n.s+100*t,0,100),l:n.l,a:n.a}},H=function(r){return(299*r.r+587*r.g+114*r.b)/1e3/255},$=function(r,t){var n=c(r);return{h:n.h,s:n.s,l:e(n.l+100*t,0,100),a:n.a}},colord_j=function(){function r(r){this.parsed=x(r)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1}}return r.prototype.isValid=function(){return null!==this.parsed},r.prototype.brightness=function(){return n(H(this.rgba),2)},r.prototype.isDark=function(){return H(this.rgba)<.5},r.prototype.isLight=function(){return H(this.rgba)>=.5},r.prototype.toHex=function(){return r=o(this.rgba),t=r.r,e=r.g,u=r.b,i=(a=r.a)<1?s(n(255*a)):"","#"+s(t)+s(e)+s(u)+i;var r,t,e,u,a,i},r.prototype.toRgb=function(){return o(this.rgba)},r.prototype.toRgbString=function(){return r=o(this.rgba),t=r.r,n=r.g,e=r.b,(u=r.a)<1?"rgba("+t+", "+n+", "+e+", "+u+")":"rgb("+t+", "+n+", "+e+")";var r,t,n,e,u},r.prototype.toHsl=function(){return d(c(this.rgba))},r.prototype.toHslString=function(){return r=d(c(this.rgba)),t=r.h,n=r.s,e=r.l,(u=r.a)<1?"hsla("+t+", "+n+"%, "+e+"%, "+u+")":"hsl("+t+", "+n+"%, "+e+"%)";var r,t,n,e,u},r.prototype.toHsv=function(){return r=h(this.rgba),{h:n(r.h),s:n(r.s),v:n(r.v),a:n(r.a,3)};var r},r.prototype.invert=function(){return w({r:255-(r=this.rgba).r,g:255-r.g,b:255-r.b,a:r.a});var r},r.prototype.saturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,r))},r.prototype.desaturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,-r))},r.prototype.grayscale=function(){return w(M(this.rgba,-1))},r.prototype.lighten=function(r){return void 0===r&&(r=.1),w($(this.rgba,r))},r.prototype.darken=function(r){return void 0===r&&(r=.1),w($(this.rgba,-r))},r.prototype.rotate=function(r){return void 0===r&&(r=15),this.hue(this.hue()+r)},r.prototype.alpha=function(r){return"number"==typeof r?w({r:(t=this.rgba).r,g:t.g,b:t.b,a:r}):n(this.rgba.a,3);var t},r.prototype.hue=function(r){var t=c(this.rgba);return"number"==typeof r?w({h:r,s:t.s,l:t.l,a:t.a}):n(t.h)},r.prototype.isEqual=function(r){return this.toHex()===w(r).toHex()},r}(),w=function(r){return r instanceof colord_j?r:new colord_j(r)},S=[],k=function(r){r.forEach(function(r){S.indexOf(r)<0&&(r(colord_j,y),S.push(r))})},E=function(){return new colord_j({r:255*Math.random(),g:255*Math.random(),b:255*Math.random()})};

;// ./node_modules/colord/plugins/names.mjs
/* harmony default export */ function names(e,f){var a={white:"#ffffff",bisque:"#ffe4c4",blue:"#0000ff",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",antiquewhite:"#faebd7",aqua:"#00ffff",azure:"#f0ffff",whitesmoke:"#f5f5f5",papayawhip:"#ffefd5",plum:"#dda0dd",blanchedalmond:"#ffebcd",black:"#000000",gold:"#ffd700",goldenrod:"#daa520",gainsboro:"#dcdcdc",cornsilk:"#fff8dc",cornflowerblue:"#6495ed",burlywood:"#deb887",aquamarine:"#7fffd4",beige:"#f5f5dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkkhaki:"#bdb76b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",peachpuff:"#ffdab9",darkmagenta:"#8b008b",darkred:"#8b0000",darkorchid:"#9932cc",darkorange:"#ff8c00",darkslateblue:"#483d8b",gray:"#808080",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",deeppink:"#ff1493",deepskyblue:"#00bfff",wheat:"#f5deb3",firebrick:"#b22222",floralwhite:"#fffaf0",ghostwhite:"#f8f8ff",darkviolet:"#9400d3",magenta:"#ff00ff",green:"#008000",dodgerblue:"#1e90ff",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",blueviolet:"#8a2be2",forestgreen:"#228b22",lawngreen:"#7cfc00",indianred:"#cd5c5c",indigo:"#4b0082",fuchsia:"#ff00ff",brown:"#a52a2a",maroon:"#800000",mediumblue:"#0000cd",lightcoral:"#f08080",darkturquoise:"#00ced1",lightcyan:"#e0ffff",ivory:"#fffff0",lightyellow:"#ffffe0",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",linen:"#faf0e6",mediumaquamarine:"#66cdaa",lemonchiffon:"#fffacd",lime:"#00ff00",khaki:"#f0e68c",mediumseagreen:"#3cb371",limegreen:"#32cd32",mediumspringgreen:"#00fa9a",lightskyblue:"#87cefa",lightblue:"#add8e6",midnightblue:"#191970",lightpink:"#ffb6c1",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",mintcream:"#f5fffa",lightslategray:"#778899",lightslategrey:"#778899",navajowhite:"#ffdead",navy:"#000080",mediumvioletred:"#c71585",powderblue:"#b0e0e6",palegoldenrod:"#eee8aa",oldlace:"#fdf5e6",paleturquoise:"#afeeee",mediumturquoise:"#48d1cc",mediumorchid:"#ba55d3",rebeccapurple:"#663399",lightsteelblue:"#b0c4de",mediumslateblue:"#7b68ee",thistle:"#d8bfd8",tan:"#d2b48c",orchid:"#da70d6",mediumpurple:"#9370db",purple:"#800080",pink:"#ffc0cb",skyblue:"#87ceeb",springgreen:"#00ff7f",palegreen:"#98fb98",red:"#ff0000",yellow:"#ffff00",slateblue:"#6a5acd",lavenderblush:"#fff0f5",peru:"#cd853f",palevioletred:"#db7093",violet:"#ee82ee",teal:"#008080",slategray:"#708090",slategrey:"#708090",aliceblue:"#f0f8ff",darkseagreen:"#8fbc8f",darkolivegreen:"#556b2f",greenyellow:"#adff2f",seagreen:"#2e8b57",seashell:"#fff5ee",tomato:"#ff6347",silver:"#c0c0c0",sienna:"#a0522d",lavender:"#e6e6fa",lightgreen:"#90ee90",orange:"#ffa500",orangered:"#ff4500",steelblue:"#4682b4",royalblue:"#4169e1",turquoise:"#40e0d0",yellowgreen:"#9acd32",salmon:"#fa8072",saddlebrown:"#8b4513",sandybrown:"#f4a460",rosybrown:"#bc8f8f",darksalmon:"#e9967a",lightgoldenrodyellow:"#fafad2",snow:"#fffafa",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",dimgray:"#696969",dimgrey:"#696969",olivedrab:"#6b8e23",olive:"#808000"},r={};for(var d in a)r[a[d]]=d;var l={};e.prototype.toName=function(f){if(!(this.rgba.a||this.rgba.r||this.rgba.g||this.rgba.b))return"transparent";var d,i,n=r[this.toHex()];if(n)return n;if(null==f?void 0:f.closest){var o=this.toRgb(),t=1/0,b="black";if(!l.length)for(var c in a)l[c]=new e(a[c]).toRgb();for(var g in a){var u=(d=o,i=l[g],Math.pow(d.r-i.r,2)+Math.pow(d.g-i.g,2)+Math.pow(d.b-i.b,2));u<t&&(t=u,b=g)}return b}};f.string.push([function(f){var r=f.toLowerCase(),d="transparent"===r?"#0000":a[r];return d?new e(d).toRgb():null},"name"])}

;// ./node_modules/colord/plugins/a11y.mjs
var a11y_o=function(o){var t=o/255;return t<.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},a11y_t=function(t){return.2126*a11y_o(t.r)+.7152*a11y_o(t.g)+.0722*a11y_o(t.b)};/* harmony default export */ function a11y(o){o.prototype.luminance=function(){return o=a11y_t(this.rgba),void 0===(r=2)&&(r=0),void 0===n&&(n=Math.pow(10,r)),Math.round(n*o)/n+0;var o,r,n},o.prototype.contrast=function(r){void 0===r&&(r="#FFF");var n,a,i,e,v,u,d,c=r instanceof o?r:new o(r);return e=this.rgba,v=c.toRgb(),u=a11y_t(e),d=a11y_t(v),n=u>d?(u+.05)/(d+.05):(d+.05)/(u+.05),void 0===(a=2)&&(a=0),void 0===i&&(i=Math.pow(10,a)),Math.floor(i*n)/i+0},o.prototype.isReadable=function(o,t){return void 0===o&&(o="#FFF"),void 0===t&&(t={}),this.contrast(o)>=(e=void 0===(i=(r=t).size)?"normal":i,"AAA"===(a=void 0===(n=r.level)?"AA":n)&&"normal"===e?7:"AA"===a&&"large"===e?3:4.5);var r,n,a,i,e}}

;// ./node_modules/@wordpress/block-editor/build-module/components/colors/utils.js





k([names, a11y]);
const { kebabCase } = unlock(external_wp_components_namespaceObject.privateApis);
const getColorObjectByAttributeValues = (colors, definedColor, customColor) => {
  if (definedColor) {
    const colorObj = colors?.find(
      (color) => color.slug === definedColor
    );
    if (colorObj) {
      return colorObj;
    }
  }
  return {
    color: customColor
  };
};
const getColorObjectByColorValue = (colors, colorValue) => {
  return colors?.find((color) => color.color === colorValue);
};
function getColorClassName(colorContextName, colorSlug) {
  if (!colorContextName || !colorSlug) {
    return void 0;
  }
  return `has-${kebabCase(colorSlug)}-${colorContextName}`;
}
function getMostReadableColor(colors, colorValue) {
  const colordColor = w(colorValue);
  const getColorContrast = ({ color }) => colordColor.contrast(color);
  const maxContrast = Math.max(...colors.map(getColorContrast));
  return colors.find((color) => getColorContrast(color) === maxContrast).color;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/use-multiple-origin-colors-and-gradients.js



function useMultipleOriginColorsAndGradients() {
  const [
    enableCustomColors,
    customColors,
    themeColors,
    defaultColors,
    shouldDisplayDefaultColors,
    enableCustomGradients,
    customGradients,
    themeGradients,
    defaultGradients,
    shouldDisplayDefaultGradients
  ] = use_settings_useSettings(
    "color.custom",
    "color.palette.custom",
    "color.palette.theme",
    "color.palette.default",
    "color.defaultPalette",
    "color.customGradient",
    "color.gradients.custom",
    "color.gradients.theme",
    "color.gradients.default",
    "color.defaultGradients"
  );
  const colorGradientSettings = {
    disableCustomColors: !enableCustomColors,
    disableCustomGradients: !enableCustomGradients
  };
  colorGradientSettings.colors = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeColors && themeColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Theme",
          "Indicates this palette comes from the theme."
        ),
        slug: "theme",
        colors: themeColors
      });
    }
    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Default",
          "Indicates this palette comes from WordPress."
        ),
        slug: "default",
        colors: defaultColors
      });
    }
    if (customColors && customColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Custom",
          "Indicates this palette is created by the user."
        ),
        slug: "custom",
        colors: customColors
      });
    }
    return result;
  }, [
    customColors,
    themeColors,
    defaultColors,
    shouldDisplayDefaultColors
  ]);
  colorGradientSettings.gradients = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeGradients && themeGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Theme",
          "Indicates this palette comes from the theme."
        ),
        slug: "theme",
        gradients: themeGradients
      });
    }
    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Default",
          "Indicates this palette comes from WordPress."
        ),
        slug: "default",
        gradients: defaultGradients
      });
    }
    if (customGradients && customGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)(
          "Custom",
          "Indicates this palette is created by the user."
        ),
        slug: "custom",
        gradients: customGradients
      });
    }
    return result;
  }, [
    customGradients,
    themeGradients,
    defaultGradients,
    shouldDisplayDefaultGradients
  ]);
  colorGradientSettings.hasColorsOrGradients = !!colorGradientSettings.colors.length || !!colorGradientSettings.gradients.length;
  return colorGradientSettings;
}


;// ./node_modules/@wordpress/icons/build-module/library/link.js


var link_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/linked-button.js




function LinkedButton({ isLinked, ...props }) {
  const label = isLinked ? (0,external_wp_i18n_namespaceObject.__)("Unlink radii") : (0,external_wp_i18n_namespaceObject.__)("Link radii");
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Button,
    {
      ...props,
      className: "components-border-radius-control__linked-button",
      size: "small",
      icon: isLinked ? link_default : link_off_default,
      iconSize: 24,
      label
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/utils.js

function mode(inputArray) {
  const arr = [...inputArray];
  return arr.sort(
    (a, b) => inputArray.filter((v) => v === b).length - inputArray.filter((v) => v === a).length
  ).shift();
}
function getAllUnit(selectedUnits = {}) {
  const { flat, ...cornerUnits } = selectedUnits;
  return flat || mode(Object.values(cornerUnits).filter(Boolean)) || "px";
}
function getAllValue(values = {}) {
  if (typeof values === "string") {
    return values;
  }
  const parsedQuantitiesAndUnits = Object.values(values).map((value2) => {
    const newValue = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value2);
    if (typeof value2 === "string" && newValue[0] === void 0) {
      return [value2, ""];
    }
    return newValue;
  });
  const allValues = parsedQuantitiesAndUnits.map(
    (value2) => value2[0] ?? ""
  );
  const allUnits = parsedQuantitiesAndUnits.map((value2) => value2[1]);
  const value = allValues.every((v) => v === allValues[0]) ? allValues[0] : "";
  const unit = mode(allUnits);
  const allValue = value === 0 || value ? `${value}${unit || ""}` : void 0;
  return allValue;
}
function hasMixedValues(values = {}) {
  if (typeof values === "string") {
    return false;
  }
  if (!values || typeof values !== "object") {
    return false;
  }
  const cornerValues = Object.values(values);
  if (cornerValues.length === 0) {
    return false;
  }
  const firstValue = cornerValues[0];
  const allSame = cornerValues.every((value) => value === firstValue);
  return !allSame;
}
function hasDefinedValues(values) {
  if (!values) {
    return false;
  }
  if (typeof values === "string") {
    return true;
  }
  const filteredValues = Object.values(values).filter((value) => {
    return !!value || value === 0;
  });
  return !!filteredValues.length;
}
function isValuePreset(value) {
  if (!value?.includes) {
    return false;
  }
  return value === "0" || value.includes("var:preset|border-radius|");
}
function getPresetSlug(value) {
  if (!value) {
    return;
  }
  if (value === "0" || value === "default") {
    return value;
  }
  const slug = value.match(/var:preset\|border-radius\|(.+)/);
  return slug ? slug[1] : void 0;
}
function utils_getSliderValueFromPreset(presetValue, presets) {
  if (presetValue === void 0) {
    return 0;
  }
  const slug = parseFloat(presetValue, 10) === 0 ? "0" : getPresetSlug(presetValue);
  const sliderValue = presets.findIndex((size) => {
    return String(size.slug) === slug;
  });
  return sliderValue !== -1 ? sliderValue : NaN;
}
function utils_getCustomValueFromPreset(value, presets) {
  if (!isValuePreset(value)) {
    return value;
  }
  const slug = parseFloat(value, 10) === 0 ? "0" : getPresetSlug(value);
  const radiusSize = presets.find((size) => String(size.slug) === slug);
  return radiusSize?.size;
}
function getPresetValueFromControlValue(controlValue, controlType, presets) {
  const size = parseInt(controlValue, 10);
  if (controlType === "selectList") {
    if (size === 0) {
      return void 0;
    }
  } else if (size === 0) {
    return "0";
  }
  return `var:preset|border-radius|${presets[controlValue]?.slug}`;
}
function utils_getPresetValueFromCustomValue(value, presets) {
  if (!value || isValuePreset(value) || value === "0") {
    return value;
  }
  const spacingMatch = presets.find(
    (size) => String(size.size) === String(value)
  );
  if (spacingMatch?.slug) {
    return `var:preset|border-radius|${spacingMatch.slug}`;
  }
  return value;
}
function convertPresetsToCustomValues(values, presets) {
  if (!values || typeof values !== "object") {
    return values;
  }
  const converted = {};
  Object.keys(values).forEach((key) => {
    const value = values[key];
    if (isValuePreset(value)) {
      const customValue = utils_getCustomValueFromPreset(value, presets);
      converted[key] = customValue !== void 0 ? customValue : value;
    } else {
      converted[key] = value;
    }
  });
  return converted;
}


;// ./node_modules/@wordpress/icons/build-module/library/settings.js


var settings_settings_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m19 7.5h-7.628c-.3089-.87389-1.1423-1.5-2.122-1.5-.97966 0-1.81309.62611-2.12197 1.5h-2.12803v1.5h2.12803c.30888.87389 1.14231 1.5 2.12197 1.5.9797 0 1.8131-.62611 2.122-1.5h7.628z" }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "m19 15h-2.128c-.3089-.8739-1.1423-1.5-2.122-1.5s-1.8131.6261-2.122 1.5h-7.628v1.5h7.628c.3089.8739 1.1423 1.5 2.122 1.5s1.8131-.6261 2.122-1.5h2.128z" })
] });


;// ./node_modules/@wordpress/icons/build-module/library/corner-all.js


var corner_all_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.75 6A.25.25 0 0 1 6 5.75h3v-1.5H6A1.75 1.75 0 0 0 4.25 6v3h1.5V6ZM18 18.25h-3v1.5h3A1.75 1.75 0 0 0 19.75 18v-3h-1.5v3a.25.25 0 0 1-.25.25ZM18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5Zm-12.5 9v-3h-1.5v3c0 .966.784 1.75 1.75 1.75h3v-1.5H6a.25.25 0 0 1-.25-.25Z"
  }
) });


;// ./node_modules/@wordpress/icons/build-module/library/corner-top-left.js


var corner_top_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.G, { opacity: ".25", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5.75 6A.25.25 0 0 1 6 5.75h3v-1.5H6A1.75 1.75 0 0 0 4.25 6v3h1.5V6ZM18 18.25h-3v1.5h3A1.75 1.75 0 0 0 19.75 18v-3h-1.5v3a.25.25 0 0 1-.25.25ZM18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5ZM5.75 18v-3h-1.5v3c0 .966.784 1.75 1.75 1.75h3v-1.5H6a.25.25 0 0 1-.25-.25Z" }) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M6 5.75a.25.25 0 0 0-.25.25v3h-1.5V6c0-.966.784-1.75 1.75-1.75h3v1.5H6Z"
    }
  )
] });


;// ./node_modules/@wordpress/icons/build-module/library/corner-top-right.js


var corner_top_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.G, { opacity: ".25", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5.75 6A.25.25 0 0 1 6 5.75h3v-1.5H6A1.75 1.75 0 0 0 4.25 6v3h1.5V6ZM18 18.25h-3v1.5h3A1.75 1.75 0 0 0 19.75 18v-3h-1.5v3a.25.25 0 0 1-.25.25ZM18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5ZM5.75 18v-3h-1.5v3c0 .966.784 1.75 1.75 1.75h3v-1.5H6a.25.25 0 0 1-.25-.25Z" }) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5Z"
    }
  )
] });


;// ./node_modules/@wordpress/icons/build-module/library/corner-bottom-left.js


var corner_bottom_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.G, { opacity: ".25", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5.75 6A.25.25 0 0 1 6 5.75h3v-1.5H6A1.75 1.75 0 0 0 4.25 6v3h1.5V6ZM18 18.25h-3v1.5h3A1.75 1.75 0 0 0 19.75 18v-3h-1.5v3a.25.25 0 0 1-.25.25ZM18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5ZM5.75 18v-3h-1.5v3c0 .966.784 1.75 1.75 1.75h3v-1.5H6a.25.25 0 0 1-.25-.25Z" }) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M5.75 15v3c0 .138.112.25.25.25h3v1.5H6A1.75 1.75 0 0 1 4.25 18v-3h1.5Z"
    }
  )
] });


;// ./node_modules/@wordpress/icons/build-module/library/corner-bottom-right.js


var corner_bottom_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.G, { opacity: ".25", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M5.75 6A.25.25 0 0 1 6 5.75h3v-1.5H6A1.75 1.75 0 0 0 4.25 6v3h1.5V6ZM18 18.25h-3v1.5h3A1.75 1.75 0 0 0 19.75 18v-3h-1.5v3a.25.25 0 0 1-.25.25ZM18.25 9V6a.25.25 0 0 0-.25-.25h-3v-1.5h3c.966 0 1.75.784 1.75 1.75v3h-1.5ZM5.75 18v-3h-1.5v3c0 .966.784 1.75 1.75 1.75h3v-1.5H6a.25.25 0 0 1-.25-.25Z" }) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_primitives_namespaceObject.Path,
    {
      fillRule: "evenodd",
      clipRule: "evenodd",
      d: "M15 18.25h3a.25.25 0 0 0 .25-.25v-3h1.5v3A1.75 1.75 0 0 1 18 19.75h-3v-1.5Z"
    }
  )
] });


;// ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/constants.js


const constants_DEFAULT_VALUES = {
  topLeft: void 0,
  topRight: void 0,
  bottomLeft: void 0,
  bottomRight: void 0
};
const constants_RANGE_CONTROL_MAX_SIZE = 8;
const constants_EMPTY_ARRAY = [];
const CORNERS = {
  all: (0,external_wp_i18n_namespaceObject.__)("Border radius"),
  topLeft: (0,external_wp_i18n_namespaceObject.__)("Top left"),
  topRight: (0,external_wp_i18n_namespaceObject.__)("Top right"),
  bottomLeft: (0,external_wp_i18n_namespaceObject.__)("Bottom left"),
  bottomRight: (0,external_wp_i18n_namespaceObject.__)("Bottom right")
};
const constants_ICONS = {
  all: corner_all_default,
  topLeft: corner_top_left_default,
  topRight: corner_top_right_default,
  bottomLeft: corner_bottom_left_default,
  bottomRight: corner_bottom_right_default
};
const MIN_BORDER_RADIUS_VALUE = 0;
const MAX_BORDER_RADIUS_VALUES = {
  px: 100,
  em: 20,
  rem: 20
};


;// ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/single-input-control.js







function SingleInputControl({
  corner,
  onChange,
  selectedUnits,
  setSelectedUnits,
  values: valuesProp,
  units,
  presets
}) {
  const changeCornerValue = (validatedValue) => {
    if (corner === "all") {
      onChange({
        topLeft: validatedValue,
        topRight: validatedValue,
        bottomLeft: validatedValue,
        bottomRight: validatedValue
      });
    } else {
      onChange({
        ...values,
        [corner]: validatedValue
      });
    }
  };
  const onChangeValue = (next) => {
    if (!onChange) {
      return;
    }
    const isNumeric = !isNaN(parseFloat(next));
    const nextValue = isNumeric ? next : void 0;
    changeCornerValue(nextValue);
  };
  const onChangeUnit = (next) => {
    const newUnits = { ...selectedUnits };
    if (corner === "all") {
      newUnits.flat = next;
      newUnits.topLeft = next;
      newUnits.topRight = next;
      newUnits.bottomLeft = next;
      newUnits.bottomRight = next;
    } else {
      newUnits[corner] = next;
    }
    setSelectedUnits(newUnits);
  };
  const values = typeof valuesProp !== "string" ? valuesProp : {
    topLeft: valuesProp,
    topRight: valuesProp,
    bottomLeft: valuesProp,
    bottomRight: valuesProp
  };
  let value;
  if (corner === "all") {
    const convertedValues = convertPresetsToCustomValues(values, presets);
    const customValue = getAllValue(convertedValues);
    value = utils_getPresetValueFromCustomValue(customValue, presets);
  } else {
    value = utils_getPresetValueFromCustomValue(values[corner], presets);
  }
  const resolvedPresetValue = isValuePreset(value) ? utils_getCustomValueFromPreset(value, presets) : value;
  const [parsedQuantity, parsedUnit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(resolvedPresetValue);
  const computedUnit = value ? parsedUnit : selectedUnits[corner] || selectedUnits.flat || "px";
  const unitConfig = units && units.find((item) => item.value === computedUnit);
  const step = unitConfig?.step || 1;
  const [showCustomValueControl, setShowCustomValueControl] = (0,external_wp_element_namespaceObject.useState)(
    value !== void 0 && !isValuePreset(value)
  );
  const showRangeControl = presets.length <= constants_RANGE_CONTROL_MAX_SIZE;
  const presetIndex = utils_getSliderValueFromPreset(value, presets);
  const rangeTooltip = (newValue) => value === void 0 ? void 0 : presets[newValue]?.name;
  const marks = presets.slice(1, presets.length - 1).map((_newValue, index) => ({
    value: index + 1,
    label: void 0
  }));
  const hasPresets = marks.length > 0;
  let options = [];
  if (!showRangeControl) {
    options = [
      ...presets,
      {
        name: (0,external_wp_i18n_namespaceObject.__)("Custom"),
        slug: "custom",
        size: resolvedPresetValue
      }
    ].map((size, index) => ({
      key: index,
      name: size.name
    }));
  }
  const icon = constants_ICONS[corner];
  const handleSliderChange = (next) => {
    const val = next !== void 0 ? `${next}${computedUnit}` : void 0;
    changeCornerValue(val);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { children: [
    icon && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Icon,
      {
        className: "components-border-radius-control__icon",
        icon,
        size: 24
      }
    ),
    (!hasPresets || showCustomValueControl) && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "components-border-radius-control__input-controls-wrapper", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, { text: CORNERS[corner], placement: "top", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "components-border-radius-control__tooltip-wrapper", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalUnitControl,
        {
          className: "components-border-radius-control__unit-control",
          "aria-label": CORNERS[corner],
          value: [parsedQuantity, computedUnit].join(
            ""
          ),
          onChange: onChangeValue,
          onUnitChange: onChangeUnit,
          size: "__unstable-large",
          min: MIN_BORDER_RADIUS_VALUE,
          units
        }
      ) }) }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.RangeControl,
        {
          __next40pxDefaultSize: true,
          label: (0,external_wp_i18n_namespaceObject.__)("Border radius"),
          hideLabelFromVision: true,
          className: "components-border-radius-control__range-control",
          value: parsedQuantity ?? "",
          min: MIN_BORDER_RADIUS_VALUE,
          max: MAX_BORDER_RADIUS_VALUES[computedUnit],
          initialPosition: 0,
          withInputField: false,
          onChange: handleSliderChange,
          step,
          __nextHasNoMarginBottom: true
        }
      )
    ] }),
    hasPresets && showRangeControl && !showCustomValueControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.RangeControl,
      {
        __next40pxDefaultSize: true,
        className: "components-border-radius-control__range-control",
        value: presetIndex,
        onChange: (newSize) => {
          changeCornerValue(
            getPresetValueFromControlValue(
              newSize,
              "range",
              presets
            )
          );
        },
        withInputField: false,
        "aria-valuenow": presetIndex,
        "aria-valuetext": presets[presetIndex]?.name,
        renderTooltipContent: rangeTooltip,
        min: 0,
        max: presets.length - 1,
        marks,
        label: CORNERS[corner],
        hideLabelFromVision: true,
        __nextHasNoMarginBottom: true
      }
    ),
    !showRangeControl && !showCustomValueControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.CustomSelectControl,
      {
        className: "components-border-radius-control__custom-select-control",
        value: options.find(
          (option) => option.key === presetIndex
        ) || options[options.length - 1],
        onChange: (selection) => {
          if (selection.selectedItem.key === options.length - 1) {
            setShowCustomValueControl(true);
          } else {
            changeCornerValue(
              getPresetValueFromControlValue(
                selection.selectedItem.key,
                "selectList",
                presets
              )
            );
          }
        },
        options,
        label: CORNERS[corner],
        hideLabelFromVision: true,
        size: "__unstable-large"
      }
    ),
    hasPresets && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        label: showCustomValueControl ? (0,external_wp_i18n_namespaceObject.__)("Use border radius preset") : (0,external_wp_i18n_namespaceObject.__)("Set custom border radius"),
        icon: settings_settings_default,
        onClick: () => {
          setShowCustomValueControl(!showCustomValueControl);
        },
        isPressed: showCustomValueControl,
        size: "small",
        className: "components-border-radius-control__custom-toggle",
        iconSize: 24
      }
    )
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/index.js









function useBorderRadiusSizes(presets) {
  const defaultSizes = presets?.default ?? constants_EMPTY_ARRAY;
  const customSizes = presets?.custom ?? constants_EMPTY_ARRAY;
  const themeSizes = presets?.theme ?? constants_EMPTY_ARRAY;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const sizes = [
      { name: (0,external_wp_i18n_namespaceObject.__)("None"), slug: "0", size: 0 },
      ...customSizes,
      ...themeSizes,
      ...defaultSizes
    ];
    return sizes.length > constants_RANGE_CONTROL_MAX_SIZE ? [
      {
        name: (0,external_wp_i18n_namespaceObject.__)("Default"),
        slug: "default",
        size: void 0
      },
      ...sizes
    ] : sizes;
  }, [customSizes, themeSizes, defaultSizes]);
}
function BorderRadiusControl({ onChange, values, presets }) {
  const [isLinked, setIsLinked] = (0,external_wp_element_namespaceObject.useState)(
    !hasDefinedValues(values) || !hasMixedValues(values)
  );
  const options = useBorderRadiusSizes(presets);
  const [selectedUnits, setSelectedUnits] = (0,external_wp_element_namespaceObject.useState)({
    flat: typeof values === "string" ? (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values)[1] : void 0,
    topLeft: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.topLeft)[1],
    topRight: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.topRight)[1],
    bottomLeft: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.bottomLeft)[1],
    bottomRight: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(
      values?.bottomRight
    )[1]
  });
  const [availableUnits] = use_settings_useSettings("spacing.units");
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ["px", "em", "rem"]
  });
  const toggleLinked = () => setIsLinked(!isLinked);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "components-border-radius-control", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { className: "components-border-radius-control__header", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { as: "legend", children: (0,external_wp_i18n_namespaceObject.__)("Radius") }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkedButton, { onClick: toggleLinked, isLinked })
    ] }),
    isLinked ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      SingleInputControl,
      {
        onChange,
        selectedUnits,
        setSelectedUnits,
        values,
        units,
        corner: "all",
        presets: options
      }
    ) }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, { children: [
      "topLeft",
      "topRight",
      "bottomLeft",
      "bottomRight"
    ].map((corner) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      SingleInputControl,
      {
        onChange,
        selectedUnits,
        setSelectedUnits,
        values: values || constants_DEFAULT_VALUES,
        units,
        corner,
        presets: options
      },
      corner
    )) })
  ] });
}


;// ./node_modules/@wordpress/icons/build-module/library/check.js


var check_check_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M16.5 7.5 10 13.9l-2.5-2.4-1 1 3.5 3.6 7.5-7.6z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/shadow.js


var shadow_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M12 8c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm0 6.5c-1.4 0-2.5-1.1-2.5-2.5s1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5-1.1 2.5-2.5 2.5zM12.8 3h-1.5v3h1.5V3zm-1.6 18h1.5v-3h-1.5v3zm6.8-9.8v1.5h3v-1.5h-3zm-12 0H3v1.5h3v-1.5zm9.7 5.6 2.1 2.1 1.1-1.1-2.1-2.1-1.1 1.1zM8.3 7.2 6.2 5.1 5.1 6.2l2.1 2.1 1.1-1.1zM5.1 17.8l1.1 1.1 2.1-2.1-1.1-1.1-2.1 2.1zM18.9 6.2l-1.1-1.1-2.1 2.1 1.1 1.1 2.1-2.1z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/shadow-panel-components.js






const shadow_panel_components_EMPTY_ARRAY = [];
function ShadowPopoverContainer({ shadow, onShadowChange, settings }) {
  const shadows = useShadowPresets(settings);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-global-styles__shadow-popover-container", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 4, children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalHeading, { level: 5, children: (0,external_wp_i18n_namespaceObject.__)("Drop shadow") }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      ShadowPresets,
      {
        presets: shadows,
        activeShadow: shadow,
        onSelect: onShadowChange
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-global-styles__clear-shadow", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        __next40pxDefaultSize: true,
        variant: "tertiary",
        onClick: () => onShadowChange(void 0),
        disabled: !shadow,
        accessibleWhenDisabled: true,
        children: (0,external_wp_i18n_namespaceObject.__)("Clear")
      }
    ) })
  ] }) });
}
function ShadowPresets({ presets, activeShadow, onSelect }) {
  return !presets ? null : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Composite,
    {
      role: "listbox",
      className: "block-editor-global-styles__shadow__list",
      "aria-label": (0,external_wp_i18n_namespaceObject.__)("Drop shadows"),
      children: presets.map(({ name, slug, shadow }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        ShadowIndicator,
        {
          label: name,
          isActive: shadow === activeShadow,
          type: slug === "unset" ? "unset" : "preset",
          onSelect: () => onSelect(shadow === activeShadow ? void 0 : shadow),
          shadow
        },
        slug
      ))
    }
  );
}
function ShadowIndicator({ type, label, isActive, onSelect, shadow }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, { text: label, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Composite.Item,
    {
      role: "option",
      "aria-label": label,
      "aria-selected": isActive,
      className: dist_clsx("block-editor-global-styles__shadow__item", {
        "is-active": isActive
      }),
      render: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        "button",
        {
          className: dist_clsx(
            "block-editor-global-styles__shadow-indicator",
            {
              unset: type === "unset"
            }
          ),
          onClick: onSelect,
          style: { boxShadow: shadow },
          "aria-label": label,
          children: isActive && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: check_check_default })
        }
      )
    }
  ) });
}
function ShadowPopover({ shadow, onShadowChange, settings }) {
  const popoverProps = {
    placement: "left-start",
    offset: 36,
    shift: true
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Dropdown,
    {
      popoverProps,
      className: "block-editor-global-styles__shadow-dropdown",
      renderToggle: renderShadowToggle(shadow, onShadowChange),
      renderContent: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalDropdownContentWrapper, { paddingSize: "medium", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        ShadowPopoverContainer,
        {
          shadow,
          onShadowChange,
          settings
        }
      ) })
    }
  );
}
function renderShadowToggle(shadow, onShadowChange) {
  return ({ onToggle, isOpen }) => {
    const shadowButtonRef = (0,external_wp_element_namespaceObject.useRef)(void 0);
    const toggleProps = {
      onClick: onToggle,
      className: dist_clsx(
        "block-editor-global-styles__shadow-dropdown-toggle",
        { "is-open": isOpen }
      ),
      "aria-expanded": isOpen,
      ref: shadowButtonRef
    };
    const removeButtonProps = {
      onClick: () => {
        if (isOpen) {
          onToggle();
        }
        onShadowChange(void 0);
        shadowButtonRef.current?.focus();
      },
      className: dist_clsx(
        "block-editor-global-styles__shadow-editor__remove-button",
        { "is-open": isOpen }
      ),
      label: (0,external_wp_i18n_namespaceObject.__)("Remove")
    };
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, { __next40pxDefaultSize: true, ...toggleProps, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "flex-start", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          icon_default,
          {
            className: "block-editor-global-styles__toggle-icon",
            icon: shadow_default,
            size: 24
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { children: (0,external_wp_i18n_namespaceObject.__)("Drop shadow") })
      ] }) }),
      !!shadow && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.Button,
        {
          __next40pxDefaultSize: true,
          size: "small",
          icon: reset_default,
          ...removeButtonProps
        }
      )
    ] });
  };
}
function useShadowPresets(settings) {
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!settings?.shadow) {
      return shadow_panel_components_EMPTY_ARRAY;
    }
    const defaultPresetsEnabled = settings?.shadow?.defaultPresets;
    const {
      default: defaultShadows,
      theme: themeShadows,
      custom: customShadows
    } = settings?.shadow?.presets ?? {};
    const unsetShadow = {
      name: (0,external_wp_i18n_namespaceObject.__)("Unset"),
      slug: "unset",
      shadow: "none"
    };
    const shadowPresets = [
      ...defaultPresetsEnabled && defaultShadows || shadow_panel_components_EMPTY_ARRAY,
      ...themeShadows || shadow_panel_components_EMPTY_ARRAY,
      ...customShadows || shadow_panel_components_EMPTY_ARRAY
    ];
    if (shadowPresets.length) {
      shadowPresets.unshift(unsetShadow);
    }
    return shadowPresets;
  }, [settings]);
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/border-panel.js










function useHasBorderPanel(settings) {
  const controls = Object.values(useHasBorderPanelControls(settings));
  return controls.some(Boolean);
}
function useHasBorderPanelControls(settings) {
  const controls = {
    hasBorderColor: useHasBorderColorControl(settings),
    hasBorderRadius: useHasBorderRadiusControl(settings),
    hasBorderStyle: useHasBorderStyleControl(settings),
    hasBorderWidth: useHasBorderWidthControl(settings),
    hasShadow: useHasShadowControl(settings)
  };
  return controls;
}
function useHasBorderColorControl(settings) {
  return settings?.border?.color;
}
function useHasBorderRadiusControl(settings) {
  return settings?.border?.radius;
}
function useHasBorderStyleControl(settings) {
  return settings?.border?.style;
}
function useHasBorderWidthControl(settings) {
  return settings?.border?.width;
}
function useHasShadowControl(settings) {
  const shadows = useShadowPresets(settings);
  return !!settings?.shadow && shadows.length > 0;
}
function BorderToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children,
  label
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label,
      resetAll,
      panelId,
      dropdownMenuProps,
      children
    }
  );
}
const border_panel_DEFAULT_CONTROLS = {
  radius: true,
  color: true,
  width: true,
  shadow: true
};
function BorderPanel({
  as: Wrapper = BorderToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  name,
  defaultControls = border_panel_DEFAULT_CONTROLS
}) {
  const colors = useColorsPerOrigin(settings);
  const decodeValue = (0,external_wp_element_namespaceObject.useCallback)(
    (rawValue) => getValueFromVariable({ settings }, "", rawValue),
    [settings]
  );
  const encodeColorValue = (colorValue) => {
    const allColors = colors.flatMap(
      ({ colors: originColors }) => originColors
    );
    const colorObject = allColors.find(
      ({ color }) => color === colorValue
    );
    return colorObject ? "var:preset|color|" + colorObject.slug : colorValue;
  };
  const border = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(inheritedValue?.border)) {
      const borderValue = { ...inheritedValue?.border };
      ["top", "right", "bottom", "left"].forEach((side) => {
        borderValue[side] = {
          ...borderValue[side],
          color: decodeValue(borderValue[side]?.color)
        };
      });
      return borderValue;
    }
    return {
      ...inheritedValue?.border,
      color: inheritedValue?.border?.color ? decodeValue(inheritedValue?.border?.color) : void 0
    };
  }, [inheritedValue?.border, decodeValue]);
  const setBorder = (newBorder) => onChange({ ...value, border: newBorder });
  const showBorderColor = useHasBorderColorControl(settings);
  const showBorderStyle = useHasBorderStyleControl(settings);
  const showBorderWidth = useHasBorderWidthControl(settings);
  const showBorderRadius = useHasBorderRadiusControl(settings);
  const borderRadiusValues = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (typeof inheritedValue?.border?.radius !== "object") {
      return decodeValue(inheritedValue?.border?.radius);
    }
    return {
      topLeft: decodeValue(inheritedValue?.border?.radius?.topLeft),
      topRight: decodeValue(inheritedValue?.border?.radius?.topRight),
      bottomLeft: decodeValue(
        inheritedValue?.border?.radius?.bottomLeft
      ),
      bottomRight: decodeValue(
        inheritedValue?.border?.radius?.bottomRight
      )
    };
  }, [inheritedValue?.border?.radius, decodeValue]);
  const setBorderRadius = (newBorderRadius) => setBorder({ ...border, radius: newBorderRadius });
  const hasBorderRadius = () => {
    const borderValues = value?.border?.radius;
    if (typeof borderValues === "object") {
      return Object.entries(borderValues).some(Boolean);
    }
    return !!borderValues;
  };
  const hasShadowControl = useHasShadowControl(settings);
  const shadow = decodeValue(inheritedValue?.shadow);
  const shadowPresets = settings?.shadow?.presets ?? {};
  const mergedShadowPresets = shadowPresets.custom ?? shadowPresets.theme ?? shadowPresets.default ?? [];
  const setShadow = (newValue) => {
    const slug = mergedShadowPresets?.find(
      ({ shadow: shadowName }) => shadowName === newValue
    )?.slug;
    onChange(
      setImmutably(
        value,
        ["shadow"],
        slug ? `var:preset|shadow|${slug}` : newValue || void 0
      )
    );
  };
  const hasShadow = () => !!value?.shadow;
  const resetShadow = () => setShadow(void 0);
  const resetBorder = () => {
    if (hasBorderRadius()) {
      return setBorder({ radius: value?.border?.radius });
    }
    setBorder(void 0);
  };
  const onBorderChange = (newBorder) => {
    const updatedBorder = { ...newBorder };
    if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(updatedBorder)) {
      ["top", "right", "bottom", "left"].forEach((side) => {
        if (updatedBorder[side]) {
          updatedBorder[side] = {
            ...updatedBorder[side],
            color: encodeColorValue(updatedBorder[side]?.color)
          };
        }
      });
    } else if (updatedBorder) {
      updatedBorder.color = encodeColorValue(updatedBorder.color);
    }
    setBorder({ radius: border?.radius, ...updatedBorder });
  };
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      border: void 0,
      shadow: void 0
    };
  }, []);
  const showBorderByDefault = defaultControls?.color || defaultControls?.width;
  const hasBorderControl = showBorderColor || showBorderStyle || showBorderWidth || showBorderRadius;
  const label = useBorderPanelLabel({
    blockName: name,
    hasShadowControl,
    hasBorderControl
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      label,
      children: [
        (showBorderWidth || showBorderColor) && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: () => (0,external_wp_components_namespaceObject.__experimentalIsDefinedBorder)(value?.border),
            label: (0,external_wp_i18n_namespaceObject.__)("Border"),
            onDeselect: () => resetBorder(),
            isShownByDefault: showBorderByDefault,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.BorderBoxControl,
              {
                colors,
                enableAlpha: true,
                enableStyle: showBorderStyle,
                onChange: onBorderChange,
                popoverOffset: 40,
                popoverPlacement: "left-start",
                value: border,
                __experimentalIsRenderedInSidebar: true,
                size: "__unstable-large",
                hideLabelFromVision: !hasShadowControl,
                label: (0,external_wp_i18n_namespaceObject.__)("Border")
              }
            )
          }
        ),
        showBorderRadius && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: hasBorderRadius,
            label: (0,external_wp_i18n_namespaceObject.__)("Radius"),
            onDeselect: () => setBorderRadius(void 0),
            isShownByDefault: defaultControls.radius,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              BorderRadiusControl,
              {
                presets: settings?.border?.radiusSizes,
                values: borderRadiusValues,
                onChange: (newValue) => {
                  setBorderRadius(newValue || void 0);
                }
              }
            )
          }
        ),
        hasShadowControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Shadow"),
            hasValue: hasShadow,
            onDeselect: resetShadow,
            isShownByDefault: defaultControls.shadow,
            panelId,
            children: [
              hasBorderControl ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { as: "legend", children: (0,external_wp_i18n_namespaceObject.__)("Shadow") }) : null,
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                ShadowPopover,
                {
                  shadow,
                  onShadowChange: setShadow,
                  settings
                }
              )
            ]
          }
        )
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/border.js














const BORDER_SUPPORT_KEY = "__experimentalBorder";
const SHADOW_SUPPORT_KEY = "shadow";
const getColorByProperty = (colors, property, value) => {
  let matchedColor;
  colors.some(
    (origin) => origin.colors.some((color) => {
      if (color[property] === value) {
        matchedColor = color;
        return true;
      }
      return false;
    })
  );
  return matchedColor;
};
const getMultiOriginColor = ({ colors, namedColor, customColor }) => {
  if (namedColor) {
    const colorObject2 = getColorByProperty(colors, "slug", namedColor);
    if (colorObject2) {
      return colorObject2;
    }
  }
  if (!customColor) {
    return { color: void 0 };
  }
  const colorObject = getColorByProperty(colors, "color", customColor);
  return colorObject ? colorObject : { color: customColor };
};
function getColorSlugFromVariable(value) {
  const namedColor = /var:preset\|color\|(.+)/.exec(value);
  if (namedColor && namedColor[1]) {
    return namedColor[1];
  }
  return null;
}
function styleToAttributes(style) {
  if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(style?.border)) {
    return {
      style,
      borderColor: void 0
    };
  }
  const borderColorValue = style?.border?.color;
  const borderColorSlug = borderColorValue?.startsWith("var:preset|color|") ? borderColorValue.substring("var:preset|color|".length) : void 0;
  const updatedStyle = { ...style };
  updatedStyle.border = {
    ...updatedStyle.border,
    color: borderColorSlug ? void 0 : borderColorValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    borderColor: borderColorSlug
  };
}
function attributesToStyle(attributes) {
  if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(attributes.style?.border)) {
    return attributes.style;
  }
  return {
    ...attributes.style,
    border: {
      ...attributes.style?.border,
      color: attributes.borderColor ? "var:preset|color|" + attributes.borderColor : attributes.style?.border?.color
    }
  };
}
function BordersInspectorControl({ label, children, resetAllFilter }) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(
    (attributes) => {
      const existingStyle = attributesToStyle(attributes);
      const updatedStyle = resetAllFilter(existingStyle);
      return {
        ...attributes,
        ...styleToAttributes(updatedStyle)
      };
    },
    [resetAllFilter]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    inspector_controls_default,
    {
      group: "border",
      resetAllFilter: attributesResetAllFilter,
      label,
      children
    }
  );
}
function border_BorderPanel({ clientId, name, setAttributes, settings }) {
  const isEnabled = useHasBorderPanel(settings);
  function selector(select) {
    const { style: style2, borderColor: borderColor2 } = select(store).getBlockAttributes(clientId) || {};
    return { style: style2, borderColor: borderColor2 };
  }
  const { style, borderColor } = (0,external_wp_data_namespaceObject.useSelect)(selector, [clientId]);
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return attributesToStyle({ style, borderColor });
  }, [style, borderColor]);
  const onChange = (newStyle) => {
    setAttributes(styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = {
    ...(0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
      BORDER_SUPPORT_KEY,
      "__experimentalDefaultControls"
    ]),
    ...(0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
      SHADOW_SUPPORT_KEY,
      "__experimentalDefaultControls"
    ])
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    BorderPanel,
    {
      as: BordersInspectorControl,
      panelId: clientId,
      settings,
      value,
      onChange,
      defaultControls
    }
  );
}
function hasBorderSupport(blockName, feature = "any") {
  if (external_wp_element_namespaceObject.Platform.OS !== "web") {
    return false;
  }
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, BORDER_SUPPORT_KEY);
  if (support === true) {
    return true;
  }
  if (feature === "any") {
    return !!(support?.color || support?.radius || support?.width || support?.style);
  }
  return !!support?.[feature];
}
function hasShadowSupport(blockName) {
  return hasBlockSupport(blockName, SHADOW_SUPPORT_KEY);
}
function useBorderPanelLabel({
  blockName,
  hasBorderControl,
  hasShadowControl
} = {}) {
  const settings = useBlockSettings(blockName);
  const controls = useHasBorderPanelControls(settings);
  if (!hasBorderControl && !hasShadowControl && blockName) {
    hasBorderControl = controls?.hasBorderColor || controls?.hasBorderStyle || controls?.hasBorderWidth || controls?.hasBorderRadius;
    hasShadowControl = controls?.hasShadow;
  }
  if (hasBorderControl && hasShadowControl) {
    return (0,external_wp_i18n_namespaceObject.__)("Border & Shadow");
  }
  if (hasShadowControl) {
    return (0,external_wp_i18n_namespaceObject.__)("Shadow");
  }
  return (0,external_wp_i18n_namespaceObject.__)("Border");
}
function removeBorderAttribute(style, attribute) {
  return cleanEmptyObject({
    ...style,
    border: {
      ...style?.border,
      [attribute]: void 0
    }
  });
}
function addAttributes(settings) {
  if (!hasBorderSupport(settings, "color")) {
    return settings;
  }
  if (settings.attributes.borderColor) {
    return settings;
  }
  return {
    ...settings,
    attributes: {
      ...settings.attributes,
      borderColor: {
        type: "string"
      }
    }
  };
}
function border_addSaveProps(props, blockNameOrType, attributes) {
  if (!hasBorderSupport(blockNameOrType, "color") || shouldSkipSerialization(blockNameOrType, BORDER_SUPPORT_KEY, "color")) {
    return props;
  }
  const borderClasses = getBorderClasses(attributes);
  const newClassName = dist_clsx(props.className, borderClasses);
  props.className = newClassName ? newClassName : void 0;
  return props;
}
function getBorderClasses(attributes) {
  const { borderColor, style } = attributes;
  const borderColorClass = getColorClassName("border-color", borderColor);
  return dist_clsx({
    "has-border-color": borderColor || style?.border?.color,
    [borderColorClass]: !!borderColorClass
  });
}
function border_useBlockProps({ name, borderColor, style }) {
  const { colors } = useMultipleOriginColorsAndGradients();
  if (!hasBorderSupport(name, "color") || shouldSkipSerialization(name, BORDER_SUPPORT_KEY, "color")) {
    return {};
  }
  const { color: borderColorValue } = getMultiOriginColor({
    colors,
    namedColor: borderColor
  });
  const { color: borderTopColor } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.top?.color)
  });
  const { color: borderRightColor } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.right?.color)
  });
  const { color: borderBottomColor } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.bottom?.color)
  });
  const { color: borderLeftColor } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.left?.color)
  });
  const extraStyles = {
    borderTopColor: borderTopColor || borderColorValue,
    borderRightColor: borderRightColor || borderColorValue,
    borderBottomColor: borderBottomColor || borderColorValue,
    borderLeftColor: borderLeftColor || borderColorValue
  };
  return border_addSaveProps(
    { style: utils_cleanEmptyObject(extraStyles) || {} },
    name,
    { borderColor, style }
  );
}
var border_default = {
  useBlockProps: border_useBlockProps,
  addSaveProps: border_addSaveProps,
  attributeKeys: ["borderColor", "style"],
  hasSupport(name) {
    return hasBorderSupport(name, "color");
  }
};
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/border/addAttributes",
  addAttributes
);


;// ./node_modules/@wordpress/block-editor/build-module/components/gradients/use-gradient.js





function __experimentalGetGradientClass(gradientSlug) {
  if (!gradientSlug) {
    return void 0;
  }
  return `has-${gradientSlug}-gradient-background`;
}
function getGradientValueBySlug(gradients, slug) {
  const gradient = gradients?.find((g) => g.slug === slug);
  return gradient && gradient.gradient;
}
function __experimentalGetGradientObjectByGradientValue(gradients, value) {
  const gradient = gradients?.find((g) => g.gradient === value);
  return gradient;
}
function getGradientSlugByValue(gradients, value) {
  const gradient = __experimentalGetGradientObjectByGradientValue(
    gradients,
    value
  );
  return gradient && gradient.slug;
}
function __experimentalUseGradient({
  gradientAttribute = "gradient",
  customGradientAttribute = "customGradient"
} = {}) {
  const { clientId } = useBlockEditContext();
  const [
    userGradientPalette,
    themeGradientPalette,
    defaultGradientPalette
  ] = use_settings_useSettings(
    "color.gradients.custom",
    "color.gradients.theme",
    "color.gradients.default"
  );
  const allGradients = (0,external_wp_element_namespaceObject.useMemo)(
    () => [
      ...userGradientPalette || [],
      ...themeGradientPalette || [],
      ...defaultGradientPalette || []
    ],
    [userGradientPalette, themeGradientPalette, defaultGradientPalette]
  );
  const { gradient, customGradient } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getBlockAttributes } = select(store);
      const attributes = getBlockAttributes(clientId) || {};
      return {
        customGradient: attributes[customGradientAttribute],
        gradient: attributes[gradientAttribute]
      };
    },
    [clientId, gradientAttribute, customGradientAttribute]
  );
  const { updateBlockAttributes } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const setGradient = (0,external_wp_element_namespaceObject.useCallback)(
    (newGradientValue) => {
      const slug = getGradientSlugByValue(
        allGradients,
        newGradientValue
      );
      if (slug) {
        updateBlockAttributes(clientId, {
          [gradientAttribute]: slug,
          [customGradientAttribute]: void 0
        });
        return;
      }
      updateBlockAttributes(clientId, {
        [gradientAttribute]: void 0,
        [customGradientAttribute]: newGradientValue
      });
    },
    [allGradients, clientId, updateBlockAttributes]
  );
  const gradientClass = __experimentalGetGradientClass(gradient);
  let gradientValue;
  if (gradient) {
    gradientValue = getGradientValueBySlug(allGradients, gradient);
  } else {
    gradientValue = customGradient;
  }
  return { gradientClass, gradientValue, setGradient };
}


;// ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/control.js






const { Tabs } = unlock(external_wp_components_namespaceObject.privateApis);
const colorsAndGradientKeys = [
  "colors",
  "disableCustomColors",
  "gradients",
  "disableCustomGradients"
];
const TAB_IDS = { color: "color", gradient: "gradient" };
function ColorGradientControlInner({
  colors,
  gradients,
  disableCustomColors,
  disableCustomGradients,
  __experimentalIsRenderedInSidebar,
  className,
  label,
  onColorChange,
  onGradientChange,
  colorValue,
  gradientValue,
  clearable,
  showTitle = true,
  enableAlpha,
  headingLevel
}) {
  const canChooseAColor = onColorChange && (colors && colors.length > 0 || !disableCustomColors);
  const canChooseAGradient = onGradientChange && (gradients && gradients.length > 0 || !disableCustomGradients);
  if (!canChooseAColor && !canChooseAGradient) {
    return null;
  }
  const tabPanels = {
    [TAB_IDS.color]: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.ColorPalette,
      {
        value: colorValue,
        onChange: canChooseAGradient ? (newColor) => {
          onColorChange(newColor);
          onGradientChange();
        } : onColorChange,
        ...{ colors, disableCustomColors },
        __experimentalIsRenderedInSidebar,
        clearable,
        enableAlpha,
        headingLevel
      }
    ),
    [TAB_IDS.gradient]: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.GradientPicker,
      {
        value: gradientValue,
        onChange: canChooseAColor ? (newGradient) => {
          onGradientChange(newGradient);
          onColorChange();
        } : onGradientChange,
        ...{ gradients, disableCustomGradients },
        __experimentalIsRenderedInSidebar,
        clearable,
        headingLevel
      }
    )
  };
  const renderPanelType = (type) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-color-gradient-control__panel", children: tabPanels[type] });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.BaseControl,
    {
      __nextHasNoMarginBottom: true,
      className: dist_clsx(
        "block-editor-color-gradient-control",
        className
      ),
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("fieldset", { className: "block-editor-color-gradient-control__fieldset", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 1, children: [
        showTitle && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("legend", { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-color-gradient-control__color-indicator", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { children: label }) }) }),
        canChooseAColor && canChooseAGradient && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          Tabs,
          {
            defaultTabId: gradientValue ? TAB_IDS.gradient : !!canChooseAColor && TAB_IDS.color,
            children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(Tabs.TabList, { children: [
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.Tab, { tabId: TAB_IDS.color, children: (0,external_wp_i18n_namespaceObject.__)("Color") }),
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.Tab, { tabId: TAB_IDS.gradient, children: (0,external_wp_i18n_namespaceObject.__)("Gradient") })
              ] }),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                Tabs.TabPanel,
                {
                  tabId: TAB_IDS.color,
                  className: "block-editor-color-gradient-control__panel",
                  focusable: false,
                  children: tabPanels.color
                }
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                Tabs.TabPanel,
                {
                  tabId: TAB_IDS.gradient,
                  className: "block-editor-color-gradient-control__panel",
                  focusable: false,
                  children: tabPanels.gradient
                }
              )
            ]
          }
        ) }),
        !canChooseAGradient && renderPanelType(TAB_IDS.color),
        !canChooseAColor && renderPanelType(TAB_IDS.gradient)
      ] }) })
    }
  );
}
function ColorGradientControlSelect(props) {
  const [colors, gradients, customColors, customGradients] = use_settings_useSettings(
    "color.palette",
    "color.gradients",
    "color.custom",
    "color.customGradient"
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    ColorGradientControlInner,
    {
      colors,
      gradients,
      disableCustomColors: !customColors,
      disableCustomGradients: !customGradients,
      ...props
    }
  );
}
function ColorGradientControl(props) {
  if (colorsAndGradientKeys.every((key) => props.hasOwnProperty(key))) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorGradientControlInner, { ...props });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorGradientControlSelect, { ...props });
}
var control_default = ColorGradientControl;


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/color-panel.js











function useHasColorPanel(settings) {
  const hasTextPanel = useHasTextPanel(settings);
  const hasBackgroundPanel = useHasBackgroundColorPanel(settings);
  const hasLinkPanel = useHasLinkPanel(settings);
  const hasHeadingPanel = useHasHeadingPanel(settings);
  const hasButtonPanel = useHasButtonPanel(settings);
  const hasCaptionPanel = useHasCaptionPanel(settings);
  return hasTextPanel || hasBackgroundPanel || hasLinkPanel || hasHeadingPanel || hasButtonPanel || hasCaptionPanel;
}
function useHasTextPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.text && (colors?.length > 0 || settings?.color?.custom);
}
function useHasLinkPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.link && (colors?.length > 0 || settings?.color?.custom);
}
function useHasCaptionPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.caption && (colors?.length > 0 || settings?.color?.custom);
}
function useHasHeadingPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.heading && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function useHasButtonPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.button && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function useHasBackgroundColorPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.background && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function ColorToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label: (0,external_wp_i18n_namespaceObject.__)("Elements"),
      resetAll,
      panelId,
      hasInnerWrapper: true,
      headingLevel: 3,
      className: "color-block-support-panel",
      __experimentalFirstVisibleItemClass: "first",
      __experimentalLastVisibleItemClass: "last",
      dropdownMenuProps,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "color-block-support-panel__inner-wrapper", children })
    }
  );
}
const color_panel_DEFAULT_CONTROLS = {
  text: true,
  background: true,
  link: true,
  heading: true,
  button: true,
  caption: true
};
const popoverProps = {
  placement: "left-start",
  offset: 36,
  shift: true,
  flip: true,
  resize: false
};
const { Tabs: color_panel_Tabs } = unlock(external_wp_components_namespaceObject.privateApis);
const LabeledColorIndicators = ({ indicators, label }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "flex-start", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalZStack, { isLayered: false, offset: -8, children: indicators.map((indicator, index) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, { expanded: false, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ColorIndicator, { colorValue: indicator }) }, index)) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { className: "block-editor-panel-color-gradient-settings__color-name", children: label })
] });
function ColorPanelTab({
  isGradient,
  inheritedValue,
  userValue,
  setValue,
  colorGradientControlSettings
}) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    control_default,
    {
      ...colorGradientControlSettings,
      showTitle: false,
      enableAlpha: true,
      __experimentalIsRenderedInSidebar: true,
      colorValue: isGradient ? void 0 : inheritedValue,
      gradientValue: isGradient ? inheritedValue : void 0,
      onColorChange: isGradient ? void 0 : setValue,
      onGradientChange: isGradient ? setValue : void 0,
      clearable: inheritedValue === userValue,
      headingLevel: 3
    }
  );
}
function ColorPanelDropdown({
  label,
  hasValue,
  resetValue,
  isShownByDefault,
  indicators,
  tabs,
  colorGradientControlSettings,
  panelId
}) {
  const currentTab = tabs.find((tab) => tab.userValue !== void 0);
  const { key: firstTabKey, ...firstTab } = tabs[0] ?? {};
  const colorGradientDropdownButtonRef = (0,external_wp_element_namespaceObject.useRef)(void 0);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanelItem,
    {
      className: "block-editor-tools-panel-color-gradient-settings__item",
      hasValue,
      label,
      onDeselect: resetValue,
      isShownByDefault,
      panelId,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.Dropdown,
        {
          popoverProps,
          className: "block-editor-tools-panel-color-gradient-settings__dropdown",
          renderToggle: ({ onToggle, isOpen }) => {
            const toggleProps = {
              onClick: onToggle,
              className: dist_clsx(
                "block-editor-panel-color-gradient-settings__dropdown",
                { "is-open": isOpen }
              ),
              "aria-expanded": isOpen,
              ref: colorGradientDropdownButtonRef
            };
            return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, { ...toggleProps, __next40pxDefaultSize: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                LabeledColorIndicators,
                {
                  indicators,
                  label
                }
              ) }),
              hasValue() && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  label: (0,external_wp_i18n_namespaceObject.__)("Reset"),
                  className: "block-editor-panel-color-gradient-settings__reset",
                  size: "small",
                  icon: reset_default,
                  onClick: () => {
                    resetValue();
                    if (isOpen) {
                      onToggle();
                    }
                    colorGradientDropdownButtonRef.current?.focus();
                  }
                }
              )
            ] });
          },
          renderContent: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalDropdownContentWrapper, { paddingSize: "none", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-editor-panel-color-gradient-settings__dropdown-content", children: [
            tabs.length === 1 && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              ColorPanelTab,
              {
                ...firstTab,
                colorGradientControlSettings
              },
              firstTabKey
            ),
            tabs.length > 1 && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(color_panel_Tabs, { defaultTabId: currentTab?.key, children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(color_panel_Tabs.TabList, { children: tabs.map((tab) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                color_panel_Tabs.Tab,
                {
                  tabId: tab.key,
                  children: tab.label
                },
                tab.key
              )) }),
              tabs.map((tab) => {
                const { key: tabKey, ...restTabProps } = tab;
                return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  color_panel_Tabs.TabPanel,
                  {
                    tabId: tabKey,
                    focusable: false,
                    children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                      ColorPanelTab,
                      {
                        ...restTabProps,
                        colorGradientControlSettings
                      },
                      tabKey
                    )
                  },
                  tabKey
                );
              })
            ] })
          ] }) })
        }
      )
    }
  );
}
function ColorPanel({
  as: Wrapper = ColorToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = color_panel_DEFAULT_CONTROLS,
  children
}) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  const areCustomSolidsEnabled = settings?.color?.custom;
  const areCustomGradientsEnabled = settings?.color?.customGradient;
  const hasSolidColors = colors.length > 0 || areCustomSolidsEnabled;
  const hasGradientColors = gradients.length > 0 || areCustomGradientsEnabled;
  const decodeValue = (rawValue) => getValueFromVariable({ settings }, "", rawValue);
  const encodeColorValue = (colorValue) => {
    const allColors = colors.flatMap(
      ({ colors: originColors }) => originColors
    );
    const colorObject = allColors.find(
      ({ color }) => color === colorValue
    );
    return colorObject ? "var:preset|color|" + colorObject.slug : colorValue;
  };
  const encodeGradientValue = (gradientValue) => {
    const allGradients = gradients.flatMap(
      ({ gradients: originGradients }) => originGradients
    );
    const gradientObject = allGradients.find(
      ({ gradient: gradient2 }) => gradient2 === gradientValue
    );
    return gradientObject ? "var:preset|gradient|" + gradientObject.slug : gradientValue;
  };
  const showBackgroundPanel = useHasBackgroundColorPanel(settings);
  const backgroundColor = decodeValue(inheritedValue?.color?.background);
  const userBackgroundColor = decodeValue(value?.color?.background);
  const gradient = decodeValue(inheritedValue?.color?.gradient);
  const userGradient = decodeValue(value?.color?.gradient);
  const hasBackground = () => !!userBackgroundColor || !!userGradient;
  const setBackgroundColor = (newColor) => {
    const newValue = setImmutably(
      value,
      ["color", "background"],
      encodeColorValue(newColor)
    );
    newValue.color.gradient = void 0;
    onChange(newValue);
  };
  const setGradient = (newGradient) => {
    const newValue = setImmutably(
      value,
      ["color", "gradient"],
      encodeGradientValue(newGradient)
    );
    newValue.color.background = void 0;
    onChange(newValue);
  };
  const resetBackground = () => {
    const newValue = setImmutably(
      value,
      ["color", "background"],
      void 0
    );
    newValue.color.gradient = void 0;
    onChange(newValue);
  };
  const showLinkPanel = useHasLinkPanel(settings);
  const linkColor = decodeValue(
    inheritedValue?.elements?.link?.color?.text
  );
  const userLinkColor = decodeValue(value?.elements?.link?.color?.text);
  const setLinkColor = (newColor) => {
    onChange(
      setImmutably(
        value,
        ["elements", "link", "color", "text"],
        encodeColorValue(newColor)
      )
    );
  };
  const hoverLinkColor = decodeValue(
    inheritedValue?.elements?.link?.[":hover"]?.color?.text
  );
  const userHoverLinkColor = decodeValue(
    value?.elements?.link?.[":hover"]?.color?.text
  );
  const setHoverLinkColor = (newColor) => {
    onChange(
      setImmutably(
        value,
        ["elements", "link", ":hover", "color", "text"],
        encodeColorValue(newColor)
      )
    );
  };
  const hasLink = () => !!userLinkColor || !!userHoverLinkColor;
  const resetLink = () => {
    let newValue = setImmutably(
      value,
      ["elements", "link", ":hover", "color", "text"],
      void 0
    );
    newValue = setImmutably(
      newValue,
      ["elements", "link", "color", "text"],
      void 0
    );
    onChange(newValue);
  };
  const showTextPanel = useHasTextPanel(settings);
  const textColor = decodeValue(inheritedValue?.color?.text);
  const userTextColor = decodeValue(value?.color?.text);
  const hasTextColor = () => !!userTextColor;
  const setTextColor = (newColor) => {
    let changedObject = setImmutably(
      value,
      ["color", "text"],
      encodeColorValue(newColor)
    );
    if (textColor === linkColor) {
      changedObject = setImmutably(
        changedObject,
        ["elements", "link", "color", "text"],
        encodeColorValue(newColor)
      );
    }
    onChange(changedObject);
  };
  const resetTextColor = () => setTextColor(void 0);
  const elements = [
    {
      name: "caption",
      label: (0,external_wp_i18n_namespaceObject.__)("Captions"),
      showPanel: useHasCaptionPanel(settings)
    },
    {
      name: "button",
      label: (0,external_wp_i18n_namespaceObject.__)("Button"),
      showPanel: useHasButtonPanel(settings)
    },
    {
      name: "heading",
      label: (0,external_wp_i18n_namespaceObject.__)("Heading"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h1",
      label: (0,external_wp_i18n_namespaceObject.__)("H1"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h2",
      label: (0,external_wp_i18n_namespaceObject.__)("H2"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h3",
      label: (0,external_wp_i18n_namespaceObject.__)("H3"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h4",
      label: (0,external_wp_i18n_namespaceObject.__)("H4"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h5",
      label: (0,external_wp_i18n_namespaceObject.__)("H5"),
      showPanel: useHasHeadingPanel(settings)
    },
    {
      name: "h6",
      label: (0,external_wp_i18n_namespaceObject.__)("H6"),
      showPanel: useHasHeadingPanel(settings)
    }
  ];
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      color: void 0,
      elements: {
        ...previousValue?.elements,
        link: {
          ...previousValue?.elements?.link,
          color: void 0,
          ":hover": {
            color: void 0
          }
        },
        ...elements.reduce((acc, element) => {
          return {
            ...acc,
            [element.name]: {
              ...previousValue?.elements?.[element.name],
              color: void 0
            }
          };
        }, {})
      }
    };
  }, []);
  const items = [
    showTextPanel && {
      key: "text",
      label: (0,external_wp_i18n_namespaceObject.__)("Text"),
      hasValue: hasTextColor,
      resetValue: resetTextColor,
      isShownByDefault: defaultControls.text,
      indicators: [textColor],
      tabs: [
        {
          key: "text",
          label: (0,external_wp_i18n_namespaceObject.__)("Text"),
          inheritedValue: textColor,
          setValue: setTextColor,
          userValue: userTextColor
        }
      ]
    },
    showBackgroundPanel && {
      key: "background",
      label: (0,external_wp_i18n_namespaceObject.__)("Background"),
      hasValue: hasBackground,
      resetValue: resetBackground,
      isShownByDefault: defaultControls.background,
      indicators: [gradient ?? backgroundColor],
      tabs: [
        hasSolidColors && {
          key: "background",
          label: (0,external_wp_i18n_namespaceObject.__)("Color"),
          inheritedValue: backgroundColor,
          setValue: setBackgroundColor,
          userValue: userBackgroundColor
        },
        hasGradientColors && {
          key: "gradient",
          label: (0,external_wp_i18n_namespaceObject.__)("Gradient"),
          inheritedValue: gradient,
          setValue: setGradient,
          userValue: userGradient,
          isGradient: true
        }
      ].filter(Boolean)
    },
    showLinkPanel && {
      key: "link",
      label: (0,external_wp_i18n_namespaceObject.__)("Link"),
      hasValue: hasLink,
      resetValue: resetLink,
      isShownByDefault: defaultControls.link,
      indicators: [linkColor, hoverLinkColor],
      tabs: [
        {
          key: "link",
          label: (0,external_wp_i18n_namespaceObject.__)("Default"),
          inheritedValue: linkColor,
          setValue: setLinkColor,
          userValue: userLinkColor
        },
        {
          key: "hover",
          label: (0,external_wp_i18n_namespaceObject.__)("Hover"),
          inheritedValue: hoverLinkColor,
          setValue: setHoverLinkColor,
          userValue: userHoverLinkColor
        }
      ]
    }
  ].filter(Boolean);
  elements.forEach(({ name, label, showPanel }) => {
    if (!showPanel) {
      return;
    }
    const elementBackgroundColor = decodeValue(
      inheritedValue?.elements?.[name]?.color?.background
    );
    const elementGradient = decodeValue(
      inheritedValue?.elements?.[name]?.color?.gradient
    );
    const elementTextColor = decodeValue(
      inheritedValue?.elements?.[name]?.color?.text
    );
    const elementBackgroundUserColor = decodeValue(
      value?.elements?.[name]?.color?.background
    );
    const elementGradientUserColor = decodeValue(
      value?.elements?.[name]?.color?.gradient
    );
    const elementTextUserColor = decodeValue(
      value?.elements?.[name]?.color?.text
    );
    const hasElement = () => !!(elementTextUserColor || elementBackgroundUserColor || elementGradientUserColor);
    const resetElement = () => {
      const newValue = setImmutably(
        value,
        ["elements", name, "color", "background"],
        void 0
      );
      newValue.elements[name].color.gradient = void 0;
      newValue.elements[name].color.text = void 0;
      onChange(newValue);
    };
    const setElementTextColor = (newTextColor) => {
      onChange(
        setImmutably(
          value,
          ["elements", name, "color", "text"],
          encodeColorValue(newTextColor)
        )
      );
    };
    const setElementBackgroundColor = (newBackgroundColor) => {
      const newValue = setImmutably(
        value,
        ["elements", name, "color", "background"],
        encodeColorValue(newBackgroundColor)
      );
      newValue.elements[name].color.gradient = void 0;
      onChange(newValue);
    };
    const setElementGradient = (newGradient) => {
      const newValue = setImmutably(
        value,
        ["elements", name, "color", "gradient"],
        encodeGradientValue(newGradient)
      );
      newValue.elements[name].color.background = void 0;
      onChange(newValue);
    };
    const supportsTextColor = true;
    const supportsBackground = name !== "caption";
    items.push({
      key: name,
      label,
      hasValue: hasElement,
      resetValue: resetElement,
      isShownByDefault: defaultControls[name],
      indicators: supportsTextColor && supportsBackground ? [
        elementTextColor,
        elementGradient ?? elementBackgroundColor
      ] : [
        supportsTextColor ? elementTextColor : elementGradient ?? elementBackgroundColor
      ],
      tabs: [
        hasSolidColors && supportsTextColor && {
          key: "text",
          label: (0,external_wp_i18n_namespaceObject.__)("Text"),
          inheritedValue: elementTextColor,
          setValue: setElementTextColor,
          userValue: elementTextUserColor
        },
        hasSolidColors && supportsBackground && {
          key: "background",
          label: (0,external_wp_i18n_namespaceObject.__)("Background"),
          inheritedValue: elementBackgroundColor,
          setValue: setElementBackgroundColor,
          userValue: elementBackgroundUserColor
        },
        hasGradientColors && supportsBackground && {
          key: "gradient",
          label: (0,external_wp_i18n_namespaceObject.__)("Gradient"),
          inheritedValue: elementGradient,
          setValue: setElementGradient,
          userValue: elementGradientUserColor,
          isGradient: true
        }
      ].filter(Boolean)
    });
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      children: [
        items.map((item) => {
          const { key, ...restItem } = item;
          return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            ColorPanelDropdown,
            {
              ...restItem,
              colorGradientControlSettings: {
                colors,
                disableCustomColors: !areCustomSolidsEnabled,
                gradients,
                disableCustomGradients: !areCustomGradientsEnabled
              },
              panelId
            },
            key
          );
        }),
        children
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/contrast-checker/index.js







k([names, a11y]);
function ContrastChecker({
  backgroundColor,
  fallbackBackgroundColor,
  fallbackTextColor,
  fallbackLinkColor,
  fontSize,
  // Font size value in pixels.
  isLargeText,
  textColor,
  linkColor,
  enableAlphaChecker = false
}) {
  const currentBackgroundColor = backgroundColor || fallbackBackgroundColor;
  if (!currentBackgroundColor) {
    return null;
  }
  const currentTextColor = textColor || fallbackTextColor;
  const currentLinkColor = linkColor || fallbackLinkColor;
  if (!currentTextColor && !currentLinkColor) {
    return null;
  }
  const textColors = [
    {
      color: currentTextColor,
      description: (0,external_wp_i18n_namespaceObject.__)("text color")
    },
    {
      color: currentLinkColor,
      description: (0,external_wp_i18n_namespaceObject.__)("link color")
    }
  ];
  const colordBackgroundColor = w(currentBackgroundColor);
  const backgroundColorHasTransparency = colordBackgroundColor.alpha() < 1;
  const backgroundColorBrightness = colordBackgroundColor.brightness();
  const isReadableOptions = {
    level: "AA",
    size: isLargeText || isLargeText !== false && fontSize >= 24 ? "large" : "small"
  };
  let message = "";
  let speakMessage = "";
  for (const item of textColors) {
    if (!item.color) {
      continue;
    }
    const colordTextColor = w(item.color);
    const isColordTextReadable = colordTextColor.isReadable(
      colordBackgroundColor,
      isReadableOptions
    );
    const textHasTransparency = colordTextColor.alpha() < 1;
    if (!isColordTextReadable) {
      if (backgroundColorHasTransparency || textHasTransparency) {
        continue;
      }
      message = backgroundColorBrightness < colordTextColor.brightness() ? (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s is a type of text color, e.g., "text color" or "link color".
        (0,external_wp_i18n_namespaceObject.__)(
          "This color combination may be hard for people to read. Try using a darker background color and/or a brighter %s."
        ),
        item.description
      ) : (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s is a type of text color, e.g., "text color" or "link color".
        (0,external_wp_i18n_namespaceObject.__)(
          "This color combination may be hard for people to read. Try using a brighter background color and/or a darker %s."
        ),
        item.description
      );
      speakMessage = (0,external_wp_i18n_namespaceObject.__)(
        "This color combination may be hard for people to read."
      );
      break;
    }
    if (textHasTransparency && enableAlphaChecker) {
      message = (0,external_wp_i18n_namespaceObject.__)("Transparent text may be hard for people to read.");
      speakMessage = (0,external_wp_i18n_namespaceObject.__)(
        "Transparent text may be hard for people to read."
      );
    }
  }
  if (!message) {
    return null;
  }
  (0,external_wp_a11y_namespaceObject.speak)(speakMessage);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-contrast-checker", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Notice,
    {
      spokenMessage: null,
      status: "warning",
      isDismissible: false,
      children: message
    }
  ) });
}
var contrast_checker_default = ContrastChecker;


;// ./node_modules/@wordpress/block-editor/build-module/components/provider/block-refs-provider.js



const BlockRefs = (0,external_wp_element_namespaceObject.createContext)({ refsMap: (0,external_wp_compose_namespaceObject.observableMap)() });
BlockRefs.displayName = "BlockRefsContext";
function BlockRefsProvider({ children }) {
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => ({ refsMap: (0,external_wp_compose_namespaceObject.observableMap)() }), []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockRefs.Provider, { value, children });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js



function useBlockRefProvider(clientId) {
  const { refsMap } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(
    (element) => {
      refsMap.set(clientId, element);
      return () => refsMap.delete(clientId);
    },
    [clientId]
  );
}
function assignRef(ref, value) {
  if (typeof ref === "function") {
    ref(value);
  } else if (ref) {
    ref.current = value;
  }
}
function useBlockElementRef(clientId, ref) {
  const { refsMap } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    assignRef(ref, refsMap.get(clientId));
    const unsubscribe = refsMap.subscribe(
      clientId,
      () => assignRef(ref, refsMap.get(clientId))
    );
    return () => {
      unsubscribe();
      assignRef(ref, null);
    };
  }, [refsMap, clientId, ref]);
}
function useBlockElement(clientId) {
  const [blockElement, setBlockElement] = (0,external_wp_element_namespaceObject.useState)(null);
  useBlockElementRef(clientId, setBlockElement);
  return blockElement;
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/contrast-checker.js




function getComputedValue(node, property) {
  return node.ownerDocument.defaultView.getComputedStyle(node).getPropertyValue(property);
}
function getBlockElementColors(blockEl) {
  if (!blockEl) {
    return {};
  }
  const firstLinkElement = blockEl.querySelector("a");
  const linkColor = !!firstLinkElement?.innerText ? getComputedValue(firstLinkElement, "color") : void 0;
  const textColor = getComputedValue(blockEl, "color");
  let backgroundColorNode = blockEl;
  let backgroundColor = getComputedValue(
    backgroundColorNode,
    "background-color"
  );
  while (backgroundColor === "rgba(0, 0, 0, 0)" && backgroundColorNode.parentNode && backgroundColorNode.parentNode.nodeType === backgroundColorNode.parentNode.ELEMENT_NODE) {
    backgroundColorNode = backgroundColorNode.parentNode;
    backgroundColor = getComputedValue(
      backgroundColorNode,
      "background-color"
    );
  }
  return {
    textColor,
    backgroundColor,
    linkColor
  };
}
function contrast_checker_reducer(prevColors, newColors) {
  const hasChanged = Object.keys(newColors).some(
    (key) => prevColors[key] !== newColors[key]
  );
  return hasChanged ? newColors : prevColors;
}
function BlockColorContrastChecker({ clientId }) {
  const blockEl = useBlockElement(clientId);
  const [colors, setColors] = (0,external_wp_element_namespaceObject.useReducer)(contrast_checker_reducer, {});
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!blockEl) {
      return;
    }
    function updateColors() {
      setColors(getBlockElementColors(blockEl));
    }
    window.requestAnimationFrame(
      () => window.requestAnimationFrame(updateColors)
    );
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    contrast_checker_default,
    {
      backgroundColor: colors.backgroundColor,
      textColor: colors.textColor,
      linkColor: colors.linkColor,
      enableAlphaChecker: true
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/color.js















const COLOR_SUPPORT_KEY = "color";
const hasColorSupport = (blockNameOrType) => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, COLOR_SUPPORT_KEY);
  return colorSupport && (colorSupport.link === true || colorSupport.gradient === true || colorSupport.background !== false || colorSupport.text !== false);
};
const hasLinkColorSupport = (blockType) => {
  if (external_wp_element_namespaceObject.Platform.OS !== "web") {
    return false;
  }
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport !== null && typeof colorSupport === "object" && !!colorSupport.link;
};
const hasGradientSupport = (blockNameOrType) => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, COLOR_SUPPORT_KEY);
  return colorSupport !== null && typeof colorSupport === "object" && !!colorSupport.gradients;
};
const hasBackgroundColorSupport = (blockType) => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.background !== false;
};
const hasTextColorSupport = (blockType) => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.text !== false;
};
function color_addAttributes(settings) {
  if (!hasColorSupport(settings)) {
    return settings;
  }
  if (!settings.attributes.backgroundColor) {
    Object.assign(settings.attributes, {
      backgroundColor: {
        type: "string"
      }
    });
  }
  if (!settings.attributes.textColor) {
    Object.assign(settings.attributes, {
      textColor: {
        type: "string"
      }
    });
  }
  if (hasGradientSupport(settings) && !settings.attributes.gradient) {
    Object.assign(settings.attributes, {
      gradient: {
        type: "string"
      }
    });
  }
  return settings;
}
function color_addSaveProps(props, blockNameOrType, attributes) {
  if (!hasColorSupport(blockNameOrType) || shouldSkipSerialization(blockNameOrType, COLOR_SUPPORT_KEY)) {
    return props;
  }
  const hasGradient = hasGradientSupport(blockNameOrType);
  const { backgroundColor, textColor, gradient, style } = attributes;
  const shouldSerialize = (feature) => !shouldSkipSerialization(
    blockNameOrType,
    COLOR_SUPPORT_KEY,
    feature
  );
  const textClass = shouldSerialize("text") ? getColorClassName("color", textColor) : void 0;
  const gradientClass = shouldSerialize("gradients") ? __experimentalGetGradientClass(gradient) : void 0;
  const backgroundClass = shouldSerialize("background") ? getColorClassName("background-color", backgroundColor) : void 0;
  const serializeHasBackground = shouldSerialize("background") || shouldSerialize("gradients");
  const hasBackground = backgroundColor || style?.color?.background || hasGradient && (gradient || style?.color?.gradient);
  const newClassName = dist_clsx(props.className, textClass, gradientClass, {
    // Don't apply the background class if there's a custom gradient.
    [backgroundClass]: (!hasGradient || !style?.color?.gradient) && !!backgroundClass,
    "has-text-color": shouldSerialize("text") && (textColor || style?.color?.text),
    "has-background": serializeHasBackground && hasBackground,
    "has-link-color": shouldSerialize("link") && style?.elements?.link?.color
  });
  props.className = newClassName ? newClassName : void 0;
  return props;
}
function color_styleToAttributes(style) {
  const textColorValue = style?.color?.text;
  const textColorSlug = textColorValue?.startsWith("var:preset|color|") ? textColorValue.substring("var:preset|color|".length) : void 0;
  const backgroundColorValue = style?.color?.background;
  const backgroundColorSlug = backgroundColorValue?.startsWith(
    "var:preset|color|"
  ) ? backgroundColorValue.substring("var:preset|color|".length) : void 0;
  const gradientValue = style?.color?.gradient;
  const gradientSlug = gradientValue?.startsWith("var:preset|gradient|") ? gradientValue.substring("var:preset|gradient|".length) : void 0;
  const updatedStyle = { ...style };
  updatedStyle.color = {
    ...updatedStyle.color,
    text: textColorSlug ? void 0 : textColorValue,
    background: backgroundColorSlug ? void 0 : backgroundColorValue,
    gradient: gradientSlug ? void 0 : gradientValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    textColor: textColorSlug,
    backgroundColor: backgroundColorSlug,
    gradient: gradientSlug
  };
}
function color_attributesToStyle(attributes) {
  return {
    ...attributes.style,
    color: {
      ...attributes.style?.color,
      text: attributes.textColor ? "var:preset|color|" + attributes.textColor : attributes.style?.color?.text,
      background: attributes.backgroundColor ? "var:preset|color|" + attributes.backgroundColor : attributes.style?.color?.background,
      gradient: attributes.gradient ? "var:preset|gradient|" + attributes.gradient : attributes.style?.color?.gradient
    }
  };
}
function ColorInspectorControl({ children, resetAllFilter }) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(
    (attributes) => {
      const existingStyle = color_attributesToStyle(attributes);
      const updatedStyle = resetAllFilter(existingStyle);
      return {
        ...attributes,
        ...color_styleToAttributes(updatedStyle)
      };
    },
    [resetAllFilter]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    inspector_controls_default,
    {
      group: "color",
      resetAllFilter: attributesResetAllFilter,
      children
    }
  );
}
function ColorEdit({ clientId, name, setAttributes, settings }) {
  const isEnabled = useHasColorPanel(settings);
  function selector(select) {
    const { style: style2, textColor: textColor2, backgroundColor: backgroundColor2, gradient: gradient2 } = select(store).getBlockAttributes(clientId) || {};
    return { style: style2, textColor: textColor2, backgroundColor: backgroundColor2, gradient: gradient2 };
  }
  const { style, textColor, backgroundColor, gradient } = (0,external_wp_data_namespaceObject.useSelect)(
    selector,
    [clientId]
  );
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return color_attributesToStyle({
      style,
      textColor,
      backgroundColor,
      gradient
    });
  }, [style, textColor, backgroundColor, gradient]);
  const onChange = (newStyle) => {
    setAttributes(color_styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    COLOR_SUPPORT_KEY,
    "__experimentalDefaultControls"
  ]);
  const enableContrastChecking = external_wp_element_namespaceObject.Platform.OS === "web" && !value?.color?.gradient && (settings?.color?.text || settings?.color?.link) && // Contrast checking is enabled by default.
  // Deactivating it requires `enableContrastChecker` to have
  // an explicit value of `false`.
  false !== (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    COLOR_SUPPORT_KEY,
    "enableContrastChecker"
  ]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    ColorPanel,
    {
      as: ColorInspectorControl,
      panelId: clientId,
      settings,
      value,
      onChange,
      defaultControls,
      enableContrastChecker: false !== (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
        COLOR_SUPPORT_KEY,
        "enableContrastChecker"
      ]),
      children: enableContrastChecking && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockColorContrastChecker, { clientId })
    }
  );
}
function color_useBlockProps({
  name,
  backgroundColor,
  textColor,
  gradient,
  style
}) {
  const [userPalette, themePalette, defaultPalette] = use_settings_useSettings(
    "color.palette.custom",
    "color.palette.theme",
    "color.palette.default"
  );
  const colors = (0,external_wp_element_namespaceObject.useMemo)(
    () => [
      ...userPalette || [],
      ...themePalette || [],
      ...defaultPalette || []
    ],
    [userPalette, themePalette, defaultPalette]
  );
  if (!hasColorSupport(name) || shouldSkipSerialization(name, COLOR_SUPPORT_KEY)) {
    return {};
  }
  const extraStyles = {};
  if (textColor && !shouldSkipSerialization(name, COLOR_SUPPORT_KEY, "text")) {
    extraStyles.color = getColorObjectByAttributeValues(
      colors,
      textColor
    )?.color;
  }
  if (backgroundColor && !shouldSkipSerialization(name, COLOR_SUPPORT_KEY, "background")) {
    extraStyles.backgroundColor = getColorObjectByAttributeValues(
      colors,
      backgroundColor
    )?.color;
  }
  const saveProps = color_addSaveProps({ style: extraStyles }, name, {
    textColor,
    backgroundColor,
    gradient,
    style
  });
  const hasBackgroundValue = backgroundColor || style?.color?.background || gradient || style?.color?.gradient;
  return {
    ...saveProps,
    className: dist_clsx(
      saveProps.className,
      // Add background image classes in the editor, if not already handled by background color values.
      !hasBackgroundValue && getBackgroundImageClasses(style)
    )
  };
}
var color_default = {
  useBlockProps: color_useBlockProps,
  addSaveProps: color_addSaveProps,
  attributeKeys: ["backgroundColor", "textColor", "gradient", "style"],
  hasSupport: hasColorSupport
};
const MIGRATION_PATHS = {
  linkColor: [["style", "elements", "link", "color", "text"]],
  textColor: [["textColor"], ["style", "color", "text"]],
  backgroundColor: [
    ["backgroundColor"],
    ["style", "color", "background"]
  ],
  gradient: [["gradient"], ["style", "color", "gradient"]]
};
function color_addTransforms(result, source, index, results) {
  const destinationBlockType = result.name;
  const activeSupports = {
    linkColor: hasLinkColorSupport(destinationBlockType),
    textColor: hasTextColorSupport(destinationBlockType),
    backgroundColor: hasBackgroundColorSupport(destinationBlockType),
    gradient: hasGradientSupport(destinationBlockType)
  };
  return transformStyles(
    activeSupports,
    MIGRATION_PATHS,
    result,
    source,
    index,
    results
  );
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/color/addAttribute",
  color_addAttributes
);
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.switchToBlockType.transformedBlock",
  "core/color/addTransforms",
  color_addTransforms
);


;// ./node_modules/@wordpress/block-editor/build-module/components/font-family/index.js






function FontFamilyControl({
  /** Start opting into the larger default height that will become the default size in a future version. */
  __next40pxDefaultSize = false,
  /** Start opting into the new margin-free styles that will become the default in a future version. */
  __nextHasNoMarginBottom = false,
  value = "",
  onChange,
  fontFamilies,
  className,
  ...props
}) {
  const [blockLevelFontFamilies] = use_settings_useSettings("typography.fontFamilies");
  if (!fontFamilies) {
    fontFamilies = blockLevelFontFamilies;
  }
  if (!fontFamilies || fontFamilies.length === 0) {
    return null;
  }
  const options = [
    {
      key: "",
      name: (0,external_wp_i18n_namespaceObject.__)("Default")
    },
    ...fontFamilies.map(({ fontFamily, name }) => ({
      key: fontFamily,
      name: name || fontFamily,
      style: { fontFamily }
    }))
  ];
  if (!__nextHasNoMarginBottom) {
    external_wp_deprecated_default()(
      "Bottom margin styles for wp.blockEditor.FontFamilyControl",
      {
        since: "6.7",
        version: "7.0",
        hint: "Set the `__nextHasNoMarginBottom` prop to true to start opting into the new styles, which will become the default in a future version"
      }
    );
  }
  if (!__next40pxDefaultSize && (props.size === void 0 || props.size === "default")) {
    external_wp_deprecated_default()(
      `36px default size for wp.blockEditor.__experimentalFontFamilyControl`,
      {
        since: "6.8",
        version: "7.1",
        hint: "Set the `__next40pxDefaultSize` prop to true to start opting into the new default size, which will become the default in a future version."
      }
    );
  }
  const selectedValue = options.find((option) => option.key === value) ?? "";
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.CustomSelectControl,
    {
      __next40pxDefaultSize,
      __shouldNotWarnDeprecated36pxSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Font"),
      value: selectedValue,
      onChange: ({ selectedItem }) => onChange(selectedItem.key),
      options,
      className: dist_clsx("block-editor-font-family-control", className, {
        "is-next-has-no-margin-bottom": __nextHasNoMarginBottom
      }),
      ...props
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/font-appearance-control/index.js






const getFontAppearanceLabel = (hasFontStyles, hasFontWeights) => {
  if (!hasFontStyles) {
    return (0,external_wp_i18n_namespaceObject.__)("Font weight");
  }
  if (!hasFontWeights) {
    return (0,external_wp_i18n_namespaceObject.__)("Font style");
  }
  return (0,external_wp_i18n_namespaceObject.__)("Appearance");
};
function FontAppearanceControl(props) {
  const {
    /** Start opting into the larger default height that will become the default size in a future version. */
    __next40pxDefaultSize = false,
    onChange,
    hasFontStyles = true,
    hasFontWeights = true,
    fontFamilyFaces,
    value: { fontStyle, fontWeight },
    ...otherProps
  } = props;
  const hasStylesOrWeights = hasFontStyles || hasFontWeights;
  const label = getFontAppearanceLabel(hasFontStyles, hasFontWeights);
  const defaultOption = {
    key: "default",
    name: (0,external_wp_i18n_namespaceObject.__)("Default"),
    style: { fontStyle: void 0, fontWeight: void 0 }
  };
  const { fontStyles, fontWeights, combinedStyleAndWeightOptions } = getFontStylesAndWeights(fontFamilyFaces);
  const combineOptions = () => {
    const combinedOptions = [defaultOption];
    if (combinedStyleAndWeightOptions) {
      combinedOptions.push(...combinedStyleAndWeightOptions);
    }
    return combinedOptions;
  };
  const styleOptions = () => {
    const combinedOptions = [defaultOption];
    fontStyles.forEach(({ name, value }) => {
      combinedOptions.push({
        key: value,
        name,
        style: { fontStyle: value, fontWeight: void 0 }
      });
    });
    return combinedOptions;
  };
  const weightOptions = () => {
    const combinedOptions = [defaultOption];
    fontWeights.forEach(({ name, value }) => {
      combinedOptions.push({
        key: value,
        name,
        style: { fontStyle: void 0, fontWeight: value }
      });
    });
    return combinedOptions;
  };
  const selectOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (hasFontStyles && hasFontWeights) {
      return combineOptions();
    }
    return hasFontStyles ? styleOptions() : weightOptions();
  }, [
    props.options,
    fontStyles,
    fontWeights,
    combinedStyleAndWeightOptions
  ]);
  const currentSelection = selectOptions.find(
    (option) => option.style.fontStyle === fontStyle && option.style.fontWeight === fontWeight
  ) || selectOptions[0];
  const getDescribedBy = () => {
    if (!currentSelection) {
      return (0,external_wp_i18n_namespaceObject.__)("No selected font appearance");
    }
    if (!hasFontStyles) {
      return (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: Currently selected font weight.
        (0,external_wp_i18n_namespaceObject.__)("Currently selected font weight: %s"),
        currentSelection.name
      );
    }
    if (!hasFontWeights) {
      return (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: Currently selected font style.
        (0,external_wp_i18n_namespaceObject.__)("Currently selected font style: %s"),
        currentSelection.name
      );
    }
    return (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: Currently selected font appearance.
      (0,external_wp_i18n_namespaceObject.__)("Currently selected font appearance: %s"),
      currentSelection.name
    );
  };
  if (!__next40pxDefaultSize && (otherProps.size === void 0 || otherProps.size === "default")) {
    external_wp_deprecated_default()(
      `36px default size for wp.blockEditor.__experimentalFontAppearanceControl`,
      {
        since: "6.8",
        version: "7.1",
        hint: "Set the `__next40pxDefaultSize` prop to true to start opting into the new default size, which will become the default in a future version."
      }
    );
  }
  return hasStylesOrWeights && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.CustomSelectControl,
    {
      ...otherProps,
      className: "components-font-appearance-control",
      __next40pxDefaultSize,
      __shouldNotWarnDeprecated36pxSize: true,
      label,
      describedBy: getDescribedBy(),
      options: selectOptions,
      value: currentSelection,
      onChange: ({ selectedItem }) => onChange(selectedItem.style)
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/line-height-control/utils.js
const BASE_DEFAULT_VALUE = 1.5;
const STEP = 0.01;
const SPIN_FACTOR = 10;
const RESET_VALUE = "";
function isLineHeightDefined(lineHeight) {
  return lineHeight !== void 0 && lineHeight !== RESET_VALUE;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/line-height-control/index.js





const line_height_control_LineHeightControl = ({
  /** Start opting into the larger default height that will become the default size in a future version. */
  __next40pxDefaultSize = false,
  value: lineHeight,
  onChange,
  __unstableInputWidth = "60px",
  ...otherProps
}) => {
  const isDefined = isLineHeightDefined(lineHeight);
  const adjustNextValue = (nextValue, wasTypedOrPasted) => {
    if (isDefined) {
      return nextValue;
    }
    const spin = STEP * SPIN_FACTOR;
    switch (`${nextValue}`) {
      case `${spin}`:
        return BASE_DEFAULT_VALUE + spin;
      case "0": {
        if (wasTypedOrPasted) {
          return nextValue;
        }
        return BASE_DEFAULT_VALUE - spin;
      }
      case "":
        return BASE_DEFAULT_VALUE;
      default:
        return nextValue;
    }
  };
  const stateReducer = (state, action) => {
    const wasTypedOrPasted = ["insertText", "insertFromPaste"].includes(
      action.payload.event.nativeEvent?.inputType
    );
    const value2 = adjustNextValue(state.value, wasTypedOrPasted);
    return { ...state, value: value2 };
  };
  const value = isDefined ? lineHeight : RESET_VALUE;
  const handleOnChange = (nextValue, { event }) => {
    if (nextValue === "") {
      onChange();
      return;
    }
    if (event.type === "click") {
      onChange(adjustNextValue(`${nextValue}`, false));
      return;
    }
    onChange(`${nextValue}`);
  };
  if (!__next40pxDefaultSize && (otherProps.size === void 0 || otherProps.size === "default")) {
    external_wp_deprecated_default()(`36px default size for wp.blockEditor.LineHeightControl`, {
      since: "6.8",
      version: "7.1",
      hint: "Set the `__next40pxDefaultSize` prop to true to start opting into the new default size, which will become the default in a future version."
    });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-line-height-control", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalNumberControl,
    {
      ...otherProps,
      __shouldNotWarnDeprecated36pxSize: true,
      __next40pxDefaultSize,
      __unstableInputWidth,
      __unstableStateReducer: stateReducer,
      onChange: handleOnChange,
      label: (0,external_wp_i18n_namespaceObject.__)("Line height"),
      placeholder: BASE_DEFAULT_VALUE,
      step: STEP,
      spinFactor: SPIN_FACTOR,
      value,
      min: 0,
      spinControls: "custom"
    }
  ) });
};
var line_height_control_default = line_height_control_LineHeightControl;


;// ./node_modules/@wordpress/block-editor/build-module/components/letter-spacing-control/index.js





function LetterSpacingControl({
  __next40pxDefaultSize = false,
  value,
  onChange,
  __unstableInputWidth = "60px",
  ...otherProps
}) {
  const [availableUnits] = use_settings_useSettings("spacing.units");
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ["px", "em", "rem"],
    defaultValues: { px: 2, em: 0.2, rem: 0.2 }
  });
  if (!__next40pxDefaultSize && (otherProps.size === void 0 || otherProps.size === "default")) {
    external_wp_deprecated_default()(
      `36px default size for wp.blockEditor.__experimentalLetterSpacingControl`,
      {
        since: "6.8",
        version: "7.1",
        hint: "Set the `__next40pxDefaultSize` prop to true to start opting into the new default size, which will become the default in a future version."
      }
    );
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalUnitControl,
    {
      __next40pxDefaultSize,
      __shouldNotWarnDeprecated36pxSize: true,
      ...otherProps,
      label: (0,external_wp_i18n_namespaceObject.__)("Letter spacing"),
      value,
      __unstableInputWidth,
      units,
      onChange
    }
  );
}


;// ./node_modules/@wordpress/icons/build-module/library/align-left.js


var align_left_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M13 5.5H4V4h9v1.5Zm7 7H4V11h16v1.5Zm-7 7H4V18h9v1.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/align-center.js


var align_center_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7.5 5.5h9V4h-9v1.5Zm-3.5 7h16V11H4v1.5Zm3.5 7h9V18h-9v1.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/align-right.js


var align_right_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M11.111 5.5H20V4h-8.889v1.5ZM4 12.5h16V11H4v1.5Zm7.111 7H20V18h-8.889v1.5Z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/align-justify.js


var align_justify_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M4 12.8h16v-1.5H4v1.5zm0 7h12.4v-1.5H4v1.5zM4 4.3v1.5h16V4.3H4z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/text-alignment-control/index.js






const TEXT_ALIGNMENT_OPTIONS = [
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Align text left"),
    value: "left",
    icon: align_left_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Align text center"),
    value: "center",
    icon: align_center_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Align text right"),
    value: "right",
    icon: align_right_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Justify text"),
    value: "justify",
    icon: align_justify_default
  }
];
const DEFAULT_OPTIONS = ["left", "center", "right"];
function TextAlignmentControl({
  className,
  value,
  onChange,
  options = DEFAULT_OPTIONS
}) {
  const validOptions = (0,external_wp_element_namespaceObject.useMemo)(
    () => TEXT_ALIGNMENT_OPTIONS.filter(
      (option) => options.includes(option.value)
    ),
    [options]
  );
  if (!validOptions.length) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      isDeselectable: true,
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Text alignment"),
      className: dist_clsx(
        "block-editor-text-alignment-control",
        className
      ),
      value,
      onChange: (newValue) => {
        onChange(newValue === value ? void 0 : newValue);
      },
      children: validOptions.map((option) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            value: option.value,
            icon: option.icon,
            label: option.label
          },
          option.value
        );
      })
    }
  );
}


;// ./node_modules/@wordpress/icons/build-module/library/format-uppercase.js


var format_uppercase_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M6.1 6.8L2.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H6.1zm-.8 6.8L7 8.9l1.7 4.7H5.3zm15.1-.7c-.4-.5-.9-.8-1.6-1 .4-.2.7-.5.8-.9.2-.4.3-.9.3-1.4 0-.9-.3-1.6-.8-2-.6-.5-1.3-.7-2.4-.7h-3.5V18h4.2c1.1 0 2-.3 2.6-.8.6-.6 1-1.4 1-2.4-.1-.8-.3-1.4-.6-1.9zm-5.7-4.7h1.8c.6 0 1.1.1 1.4.4.3.2.5.7.5 1.3 0 .6-.2 1.1-.5 1.3-.3.2-.8.4-1.4.4h-1.8V8.2zm4 8c-.4.3-.9.5-1.5.5h-2.6v-3.8h2.6c1.4 0 2 .6 2 1.9.1.6-.1 1-.5 1.4z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/format-lowercase.js


var format_lowercase_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M11 16.8c-.1-.1-.2-.3-.3-.5v-2.6c0-.9-.1-1.7-.3-2.2-.2-.5-.5-.9-.9-1.2-.4-.2-.9-.3-1.6-.3-.5 0-1 .1-1.5.2s-.9.3-1.2.6l.2 1.2c.4-.3.7-.4 1.1-.5.3-.1.7-.2 1-.2.6 0 1 .1 1.3.4.3.2.4.7.4 1.4-1.2 0-2.3.2-3.3.7s-1.4 1.1-1.4 2.1c0 .7.2 1.2.7 1.6.4.4 1 .6 1.8.6.9 0 1.7-.4 2.4-1.2.1.3.2.5.4.7.1.2.3.3.6.4.3.1.6.1 1.1.1h.1l.2-1.2h-.1c-.4.1-.6 0-.7-.1zM9.2 16c-.2.3-.5.6-.9.8-.3.1-.7.2-1.1.2-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.9 0-.6.2-1 .7-1.3.5-.3 1.3-.4 2.5-.5v2zm10.6-3.9c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2s-.2 1.4-.6 2z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/format-capitalize.js


var format_capitalize_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7.1 6.8L3.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H7.1zm-.8 6.8L8 8.9l1.7 4.7H6.3zm14.5-1.5c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2 .1.8-.2 1.4-.6 2z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/text-transform-control/index.js





const TEXT_TRANSFORMS = [
  {
    label: (0,external_wp_i18n_namespaceObject.__)("None"),
    value: "none",
    icon: reset_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Uppercase"),
    value: "uppercase",
    icon: format_uppercase_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Lowercase"),
    value: "lowercase",
    icon: format_lowercase_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Capitalize"),
    value: "capitalize",
    icon: format_capitalize_default
  }
];
function TextTransformControl({ className, value, onChange }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      isDeselectable: true,
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Letter case"),
      className: dist_clsx(
        "block-editor-text-transform-control",
        className
      ),
      value,
      onChange: (newValue) => {
        onChange(newValue === value ? void 0 : newValue);
      },
      children: TEXT_TRANSFORMS.map((option) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            value: option.value,
            icon: option.icon,
            label: option.label
          },
          option.value
        );
      })
    }
  );
}


;// ./node_modules/@wordpress/icons/build-module/library/format-underline.js


var format_underline_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7 18v1h10v-1H7zm5-2c1.5 0 2.6-.4 3.4-1.2.8-.8 1.1-2 1.1-3.5V5H15v5.8c0 1.2-.2 2.1-.6 2.8-.4.7-1.2 1-2.4 1s-2-.3-2.4-1c-.4-.7-.6-1.6-.6-2.8V5H7.5v6.2c0 1.5.4 2.7 1.1 3.5.8.9 1.9 1.3 3.4 1.3z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/format-strikethrough.js


var format_strikethrough_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M9.1 9v-.5c0-.6.2-1.1.7-1.4.5-.3 1.2-.5 2-.5.7 0 1.4.1 2.1.3.7.2 1.4.5 2.1.9l.2-1.9c-.6-.3-1.2-.5-1.9-.7-.8-.1-1.6-.2-2.4-.2-1.5 0-2.7.3-3.6 1-.8.7-1.2 1.5-1.2 2.6V9h2zM20 12H4v1h8.3c.3.1.6.2.8.3.5.2.9.5 1.1.8.3.3.4.7.4 1.2 0 .7-.2 1.1-.8 1.5-.5.3-1.2.5-2.1.5-.8 0-1.6-.1-2.4-.3-.8-.2-1.5-.5-2.2-.8L7 18.1c.5.2 1.2.4 2 .6.8.2 1.6.3 2.4.3 1.7 0 3-.3 3.9-1 .9-.7 1.3-1.6 1.3-2.8 0-.9-.2-1.7-.7-2.2H20v-1z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/text-decoration-control/index.js





const TEXT_DECORATIONS = [
  {
    label: (0,external_wp_i18n_namespaceObject.__)("None"),
    value: "none",
    icon: reset_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Underline"),
    value: "underline",
    icon: format_underline_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Strikethrough"),
    value: "line-through",
    icon: format_strikethrough_default
  }
];
function TextDecorationControl({
  value,
  onChange,
  className
}) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      isDeselectable: true,
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Decoration"),
      className: dist_clsx(
        "block-editor-text-decoration-control",
        className
      ),
      value,
      onChange: (newValue) => {
        onChange(newValue === value ? void 0 : newValue);
      },
      children: TEXT_DECORATIONS.map((option) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            value: option.value,
            icon: option.icon,
            label: option.label
          },
          option.value
        );
      })
    }
  );
}


;// ./node_modules/@wordpress/icons/build-module/library/text-horizontal.js


var text_horizontal_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M8.2 14.4h3.9L13 17h1.7L11 6.5H9.3L5.6 17h1.7l.9-2.6zm2-5.5 1.4 4H8.8l1.4-4zm7.4 7.5-1.3.8.8 1.4H5.5V20h14.3l-2.2-3.6z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/text-vertical.js


var text_vertical_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M7 5.6v1.7l2.6.9v3.9L7 13v1.7L17.5 11V9.3L7 5.6zm4.2 6V8.8l4 1.4-4 1.4zm-5.7 5.6V5.5H4v14.3l3.6-2.2-.8-1.3-1.3.9z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/writing-mode-control/index.js





const WRITING_MODES = [
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Horizontal"),
    value: "horizontal-tb",
    icon: text_horizontal_default
  },
  {
    label: (0,external_wp_i18n_namespaceObject.__)("Vertical"),
    value: (0,external_wp_i18n_namespaceObject.isRTL)() ? "vertical-lr" : "vertical-rl",
    icon: text_vertical_default
  }
];
function WritingModeControl({ className, value, onChange }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToggleGroupControl,
    {
      isDeselectable: true,
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)("Orientation"),
      className: dist_clsx("block-editor-writing-mode-control", className),
      value,
      onChange: (newValue) => {
        onChange(newValue === value ? void 0 : newValue);
      },
      children: WRITING_MODES.map((option) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon,
          {
            value: option.value,
            icon: option.icon,
            label: option.label
          },
          option.value
        );
      })
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/typography-panel.js















const MIN_TEXT_COLUMNS = 1;
const MAX_TEXT_COLUMNS = 6;
function useHasTypographyPanel(settings) {
  const hasFontFamily = useHasFontFamilyControl(settings);
  const hasLineHeight = useHasLineHeightControl(settings);
  const hasFontAppearance = useHasAppearanceControl(settings);
  const hasLetterSpacing = useHasLetterSpacingControl(settings);
  const hasTextAlign = useHasTextAlignmentControl(settings);
  const hasTextTransform = useHasTextTransformControl(settings);
  const hasTextDecoration = useHasTextDecorationControl(settings);
  const hasWritingMode = useHasWritingModeControl(settings);
  const hasTextColumns = useHasTextColumnsControl(settings);
  const hasFontSize = useHasFontSizeControl(settings);
  return hasFontFamily || hasLineHeight || hasFontAppearance || hasLetterSpacing || hasTextAlign || hasTextTransform || hasFontSize || hasTextDecoration || hasWritingMode || hasTextColumns;
}
function useHasFontSizeControl(settings) {
  return settings?.typography?.defaultFontSizes !== false && settings?.typography?.fontSizes?.default?.length || settings?.typography?.fontSizes?.theme?.length || settings?.typography?.fontSizes?.custom?.length || settings?.typography?.customFontSize;
}
function useHasFontFamilyControl(settings) {
  return ["default", "theme", "custom"].some(
    (key) => settings?.typography?.fontFamilies?.[key]?.length
  );
}
function useHasLineHeightControl(settings) {
  return settings?.typography?.lineHeight;
}
function useHasAppearanceControl(settings) {
  return settings?.typography?.fontStyle || settings?.typography?.fontWeight;
}
function useAppearanceControlLabel(settings) {
  if (!settings?.typography?.fontStyle) {
    return (0,external_wp_i18n_namespaceObject.__)("Font weight");
  }
  if (!settings?.typography?.fontWeight) {
    return (0,external_wp_i18n_namespaceObject.__)("Font style");
  }
  return (0,external_wp_i18n_namespaceObject.__)("Appearance");
}
function useHasLetterSpacingControl(settings) {
  return settings?.typography?.letterSpacing;
}
function useHasTextTransformControl(settings) {
  return settings?.typography?.textTransform;
}
function useHasTextAlignmentControl(settings) {
  return settings?.typography?.textAlign;
}
function useHasTextDecorationControl(settings) {
  return settings?.typography?.textDecoration;
}
function useHasWritingModeControl(settings) {
  return settings?.typography?.writingMode;
}
function useHasTextColumnsControl(settings) {
  return settings?.typography?.textColumns;
}
function getMergedFontSizes(settings) {
  const fontSizes = settings?.typography?.fontSizes;
  const defaultFontSizesEnabled = !!settings?.typography?.defaultFontSizes;
  return [
    ...fontSizes?.custom ?? [],
    ...fontSizes?.theme ?? [],
    ...defaultFontSizesEnabled ? fontSizes?.default ?? [] : []
  ];
}
function TypographyToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label: (0,external_wp_i18n_namespaceObject.__)("Typography"),
      resetAll,
      panelId,
      dropdownMenuProps,
      children
    }
  );
}
const typography_panel_DEFAULT_CONTROLS = {
  fontFamily: true,
  fontSize: true,
  fontAppearance: true,
  lineHeight: true,
  letterSpacing: true,
  textAlign: true,
  textTransform: true,
  textDecoration: true,
  writingMode: true,
  textColumns: true
};
function TypographyPanel({
  as: Wrapper = TypographyToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = typography_panel_DEFAULT_CONTROLS,
  fitText = false
}) {
  const decodeValue = (rawValue) => getValueFromVariable({ settings }, "", rawValue);
  const hasFontFamilyEnabled = useHasFontFamilyControl(settings);
  const fontFamily = decodeValue(inheritedValue?.typography?.fontFamily);
  const { fontFamilies, fontFamilyFaces } = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return getMergedFontFamiliesAndFontFamilyFaces(settings, fontFamily);
  }, [settings, fontFamily]);
  const setFontFamily = (newValue) => {
    const slug = fontFamilies?.find(
      ({ fontFamily: f }) => f === newValue
    )?.slug;
    onChange(
      setImmutably(
        value,
        ["typography", "fontFamily"],
        slug ? `var:preset|font-family|${slug}` : newValue || void 0
      )
    );
  };
  const hasFontFamily = () => !!value?.typography?.fontFamily;
  const resetFontFamily = () => setFontFamily(void 0);
  const hasFontSizeEnabled = useHasFontSizeControl(settings);
  const disableCustomFontSizes = !settings?.typography?.customFontSize;
  const mergedFontSizes = getMergedFontSizes(settings);
  const fontSize = decodeValue(inheritedValue?.typography?.fontSize);
  const currentFontSizeSlug = (() => {
    const rawValue = inheritedValue?.typography?.fontSize;
    if (!rawValue || typeof rawValue !== "string") {
      return void 0;
    }
    if (rawValue.startsWith("var:preset|font-size|")) {
      return rawValue.replace("var:preset|font-size|", "");
    }
    const cssVarMatch = rawValue.match(
      /^var\(--wp--preset--font-size--([^)]+)\)$/
    );
    if (cssVarMatch) {
      return cssVarMatch[1];
    }
    return void 0;
  })();
  const setFontSize = (newValue, metadata) => {
    const actualValue = !!metadata?.slug ? `var:preset|font-size|${metadata?.slug}` : newValue;
    onChange(
      setImmutably(
        value,
        ["typography", "fontSize"],
        actualValue || void 0
      )
    );
  };
  const hasFontSize = () => !!value?.typography?.fontSize;
  const resetFontSize = () => setFontSize(void 0);
  const hasAppearanceControl = useHasAppearanceControl(settings);
  const appearanceControlLabel = useAppearanceControlLabel(settings);
  const hasFontStyles = settings?.typography?.fontStyle;
  const hasFontWeights = settings?.typography?.fontWeight;
  const fontStyle = decodeValue(inheritedValue?.typography?.fontStyle);
  const fontWeight = decodeValue(inheritedValue?.typography?.fontWeight);
  const { nearestFontStyle, nearestFontWeight } = findNearestStyleAndWeight(
    fontFamilyFaces,
    fontStyle,
    fontWeight
  );
  const setFontAppearance = (0,external_wp_element_namespaceObject.useCallback)(
    ({ fontStyle: newFontStyle, fontWeight: newFontWeight }) => {
      if (newFontStyle !== fontStyle || newFontWeight !== fontWeight) {
        onChange({
          ...value,
          typography: {
            ...value?.typography,
            fontStyle: newFontStyle || void 0,
            fontWeight: newFontWeight || void 0
          }
        });
      }
    },
    [fontStyle, fontWeight, onChange, value]
  );
  const hasFontAppearance = () => !!value?.typography?.fontStyle || !!value?.typography?.fontWeight;
  const resetFontAppearance = (0,external_wp_element_namespaceObject.useCallback)(() => {
    setFontAppearance({});
  }, [setFontAppearance]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (nearestFontStyle && nearestFontWeight) {
      setFontAppearance({
        fontStyle: nearestFontStyle,
        fontWeight: nearestFontWeight
      });
    } else {
      resetFontAppearance();
    }
  }, [
    nearestFontStyle,
    nearestFontWeight,
    resetFontAppearance,
    setFontAppearance
  ]);
  const hasLineHeightEnabled = useHasLineHeightControl(settings);
  const lineHeight = decodeValue(inheritedValue?.typography?.lineHeight);
  const setLineHeight = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "lineHeight"],
        newValue || void 0
      )
    );
  };
  const hasLineHeight = () => value?.typography?.lineHeight !== void 0;
  const resetLineHeight = () => setLineHeight(void 0);
  const hasLetterSpacingControl = useHasLetterSpacingControl(settings);
  const letterSpacing = decodeValue(
    inheritedValue?.typography?.letterSpacing
  );
  const setLetterSpacing = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "letterSpacing"],
        newValue || void 0
      )
    );
  };
  const hasLetterSpacing = () => !!value?.typography?.letterSpacing;
  const resetLetterSpacing = () => setLetterSpacing(void 0);
  const hasTextColumnsControl = useHasTextColumnsControl(settings);
  const textColumns = decodeValue(inheritedValue?.typography?.textColumns);
  const setTextColumns = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "textColumns"],
        newValue || void 0
      )
    );
  };
  const hasTextColumns = () => !!value?.typography?.textColumns;
  const resetTextColumns = () => setTextColumns(void 0);
  const hasTextTransformControl = useHasTextTransformControl(settings);
  const textTransform = decodeValue(
    inheritedValue?.typography?.textTransform
  );
  const setTextTransform = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "textTransform"],
        newValue || void 0
      )
    );
  };
  const hasTextTransform = () => !!value?.typography?.textTransform;
  const resetTextTransform = () => setTextTransform(void 0);
  const hasTextDecorationControl = useHasTextDecorationControl(settings);
  const textDecoration = decodeValue(
    inheritedValue?.typography?.textDecoration
  );
  const setTextDecoration = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "textDecoration"],
        newValue || void 0
      )
    );
  };
  const hasTextDecoration = () => !!value?.typography?.textDecoration;
  const resetTextDecoration = () => setTextDecoration(void 0);
  const hasWritingModeControl = useHasWritingModeControl(settings);
  const writingMode = decodeValue(inheritedValue?.typography?.writingMode);
  const setWritingMode = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "writingMode"],
        newValue || void 0
      )
    );
  };
  const hasWritingMode = () => !!value?.typography?.writingMode;
  const resetWritingMode = () => setWritingMode(void 0);
  const hasTextAlignmentControl = useHasTextAlignmentControl(settings);
  const textAlign = decodeValue(inheritedValue?.typography?.textAlign);
  const setTextAlign = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["typography", "textAlign"],
        newValue || void 0
      )
    );
  };
  const hasTextAlign = () => !!value?.typography?.textAlign;
  const resetTextAlign = () => setTextAlign(void 0);
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      typography: {}
    };
  }, []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      children: [
        hasFontFamilyEnabled && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Font"),
            hasValue: hasFontFamily,
            onDeselect: resetFontFamily,
            isShownByDefault: defaultControls.fontFamily,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              FontFamilyControl,
              {
                fontFamilies,
                value: fontFamily,
                onChange: setFontFamily,
                size: "__unstable-large",
                __nextHasNoMarginBottom: true
              }
            )
          }
        ),
        hasFontSizeEnabled && !fitText && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Size"),
            hasValue: hasFontSize,
            onDeselect: resetFontSize,
            isShownByDefault: defaultControls.fontSize,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.FontSizePicker,
              {
                value: currentFontSizeSlug || fontSize,
                valueMode: currentFontSizeSlug ? "slug" : "literal",
                onChange: setFontSize,
                fontSizes: mergedFontSizes,
                disableCustomFontSizes,
                withReset: false,
                withSlider: true,
                size: "__unstable-large"
              }
            )
          }
        ),
        hasAppearanceControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: appearanceControlLabel,
            hasValue: hasFontAppearance,
            onDeselect: resetFontAppearance,
            isShownByDefault: defaultControls.fontAppearance,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              FontAppearanceControl,
              {
                value: {
                  fontStyle,
                  fontWeight
                },
                onChange: setFontAppearance,
                hasFontStyles,
                hasFontWeights,
                fontFamilyFaces,
                size: "__unstable-large"
              }
            )
          }
        ),
        hasLineHeightEnabled && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: (0,external_wp_i18n_namespaceObject.__)("Line height"),
            hasValue: hasLineHeight,
            onDeselect: resetLineHeight,
            isShownByDefault: defaultControls.lineHeight,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              line_height_control_default,
              {
                __unstableInputWidth: "auto",
                value: lineHeight,
                onChange: setLineHeight,
                size: "__unstable-large"
              }
            )
          }
        ),
        hasLetterSpacingControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: (0,external_wp_i18n_namespaceObject.__)("Letter spacing"),
            hasValue: hasLetterSpacing,
            onDeselect: resetLetterSpacing,
            isShownByDefault: defaultControls.letterSpacing,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              LetterSpacingControl,
              {
                value: letterSpacing,
                onChange: setLetterSpacing,
                size: "__unstable-large",
                __unstableInputWidth: "auto"
              }
            )
          }
        ),
        hasTextColumnsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: (0,external_wp_i18n_namespaceObject.__)("Columns"),
            hasValue: hasTextColumns,
            onDeselect: resetTextColumns,
            isShownByDefault: defaultControls.textColumns,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalNumberControl,
              {
                label: (0,external_wp_i18n_namespaceObject.__)("Columns"),
                max: MAX_TEXT_COLUMNS,
                min: MIN_TEXT_COLUMNS,
                onChange: setTextColumns,
                size: "__unstable-large",
                spinControls: "custom",
                value: textColumns,
                initialPosition: 1
              }
            )
          }
        ),
        hasTextDecorationControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: (0,external_wp_i18n_namespaceObject.__)("Decoration"),
            hasValue: hasTextDecoration,
            onDeselect: resetTextDecoration,
            isShownByDefault: defaultControls.textDecoration,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              TextDecorationControl,
              {
                value: textDecoration,
                onChange: setTextDecoration,
                size: "__unstable-large",
                __unstableInputWidth: "auto"
              }
            )
          }
        ),
        hasWritingModeControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            className: "single-column",
            label: (0,external_wp_i18n_namespaceObject.__)("Orientation"),
            hasValue: hasWritingMode,
            onDeselect: resetWritingMode,
            isShownByDefault: defaultControls.writingMode,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              WritingModeControl,
              {
                value: writingMode,
                onChange: setWritingMode,
                size: "__unstable-large",
                __nextHasNoMarginBottom: true
              }
            )
          }
        ),
        hasTextTransformControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Letter case"),
            hasValue: hasTextTransform,
            onDeselect: resetTextTransform,
            isShownByDefault: defaultControls.textTransform,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              TextTransformControl,
              {
                value: textTransform,
                onChange: setTextTransform,
                showNone: true,
                isBlock: true,
                size: "__unstable-large",
                __nextHasNoMarginBottom: true
              }
            )
          }
        ),
        hasTextAlignmentControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Text alignment"),
            hasValue: hasTextAlign,
            onDeselect: resetTextAlign,
            isShownByDefault: defaultControls.textAlign,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              TextAlignmentControl,
              {
                value: textAlign,
                onChange: setTextAlign,
                size: "__unstable-large",
                __nextHasNoMarginBottom: true
              }
            )
          }
        )
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/line-height.js





const LINE_HEIGHT_SUPPORT_KEY = "typography.lineHeight";
function LineHeightEdit(props) {
  const {
    attributes: { style },
    setAttributes
  } = props;
  const onChange = (newLineHeightValue) => {
    const newStyle = {
      ...style,
      typography: {
        ...style?.typography,
        lineHeight: newLineHeightValue
      }
    };
    setAttributes({ style: cleanEmptyObject(newStyle) });
  };
  return /* @__PURE__ */ jsx(
    LineHeightControl,
    {
      __unstableInputWidth: "100%",
      value: style?.typography?.lineHeight,
      onChange,
      size: "__unstable-large"
    }
  );
}
function useIsLineHeightDisabled({ name: blockName } = {}) {
  const [isEnabled] = useSettings("typography.lineHeight");
  return !isEnabled || !hasBlockSupport(blockName, LINE_HEIGHT_SUPPORT_KEY);
}


;// external ["wp","tokenList"]
const external_wp_tokenList_namespaceObject = window["wp"]["tokenList"];
var external_wp_tokenList_default = /*#__PURE__*/__webpack_require__.n(external_wp_tokenList_namespaceObject);
;// ./node_modules/@wordpress/block-editor/build-module/hooks/font-family.js







const FONT_FAMILY_SUPPORT_KEY = "typography.__experimentalFontFamily";
const { kebabCase: font_family_kebabCase } = unlock(external_wp_components_namespaceObject.privateApis);
function font_family_addAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, FONT_FAMILY_SUPPORT_KEY)) {
    return settings;
  }
  if (!settings.attributes.fontFamily) {
    Object.assign(settings.attributes, {
      fontFamily: {
        type: "string"
      }
    });
  }
  return settings;
}
function font_family_addSaveProps(props, blockType, attributes) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, FONT_FAMILY_SUPPORT_KEY)) {
    return props;
  }
  if (shouldSkipSerialization(
    blockType,
    TYPOGRAPHY_SUPPORT_KEY,
    "fontFamily"
  )) {
    return props;
  }
  if (!attributes?.fontFamily) {
    return props;
  }
  const classes = new (external_wp_tokenList_default())(props.className);
  classes.add(`has-${font_family_kebabCase(attributes?.fontFamily)}-font-family`);
  const newClassName = classes.value;
  props.className = newClassName ? newClassName : void 0;
  return props;
}
function font_family_useBlockProps({ name, fontFamily }) {
  return font_family_addSaveProps({}, name, { fontFamily });
}
var font_family_default = {
  useBlockProps: font_family_useBlockProps,
  addSaveProps: font_family_addSaveProps,
  attributeKeys: ["fontFamily"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_FAMILY_SUPPORT_KEY);
  }
};
function resetFontFamily({ setAttributes }) {
  setAttributes({ fontFamily: void 0 });
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/fontFamily/addAttribute",
  font_family_addAttributes
);


;// ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/utils.js


const { kebabCase: utils_kebabCase } = unlock(external_wp_components_namespaceObject.privateApis);
const utils_getFontSize = (fontSizes, fontSizeAttribute, customFontSizeAttribute) => {
  if (fontSizeAttribute) {
    const fontSizeObject = fontSizes?.find(
      ({ slug }) => slug === fontSizeAttribute
    );
    if (fontSizeObject) {
      return fontSizeObject;
    }
  }
  return {
    size: customFontSizeAttribute
  };
};
function utils_getFontSizeObjectByValue(fontSizes, value) {
  const fontSizeObject = fontSizes?.find(({ size }) => size === value);
  if (fontSizeObject) {
    return fontSizeObject;
  }
  return {
    size: value
  };
}
function getFontSizeClass(fontSizeSlug) {
  if (!fontSizeSlug) {
    return;
  }
  return `has-${utils_kebabCase(fontSizeSlug)}-font-size`;
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/font-size.js









const FONT_SIZE_SUPPORT_KEY = "typography.fontSize";
function font_size_addAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, FONT_SIZE_SUPPORT_KEY)) {
    return settings;
  }
  if (!settings.attributes.fontSize) {
    Object.assign(settings.attributes, {
      fontSize: {
        type: "string"
      }
    });
  }
  return settings;
}
function font_size_addSaveProps(props, blockNameOrType, attributes) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockNameOrType, FONT_SIZE_SUPPORT_KEY)) {
    return props;
  }
  if (shouldSkipSerialization(
    blockNameOrType,
    TYPOGRAPHY_SUPPORT_KEY,
    "fontSize"
  )) {
    return props;
  }
  const classes = new (external_wp_tokenList_default())(props.className);
  classes.add(getFontSizeClass(attributes.fontSize));
  const newClassName = classes.value;
  props.className = newClassName ? newClassName : void 0;
  return props;
}
function FontSizeEdit(props) {
  const {
    attributes: { fontSize, style, fitText },
    setAttributes
  } = props;
  const [fontSizes] = useSettings("typography.fontSizes");
  if (fitText) {
    return null;
  }
  const onChange = (value, selectedItem) => {
    const fontSizeSlug = selectedItem?.slug || getFontSizeObjectByValue(fontSizes, value).slug;
    setAttributes({
      style: cleanEmptyObject({
        ...style,
        typography: {
          ...style?.typography,
          fontSize: fontSizeSlug ? void 0 : value
        }
      }),
      fontSize: fontSizeSlug
    });
  };
  const fontSizeObject = getFontSize(
    fontSizes,
    fontSize,
    style?.typography?.fontSize
  );
  const fontSizeValue = fontSizeObject?.size || style?.typography?.fontSize || fontSize;
  return /* @__PURE__ */ jsx(
    FontSizePicker,
    {
      onChange,
      value: fontSize || fontSizeValue,
      valueMode: fontSize ? "slug" : "literal",
      withReset: false,
      withSlider: true,
      size: "__unstable-large"
    }
  );
}
function useIsFontSizeDisabled({ name: blockName } = {}) {
  const [fontSizes] = useSettings("typography.fontSizes");
  const hasFontSizes = !!fontSizes?.length;
  return !hasBlockSupport(blockName, FONT_SIZE_SUPPORT_KEY) || !hasFontSizes;
}
function font_size_useBlockProps({ name, fontSize, style }) {
  const [fontSizes, fluidTypographySettings, layoutSettings] = use_settings_useSettings(
    "typography.fontSizes",
    "typography.fluid",
    "layout"
  );
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_SIZE_SUPPORT_KEY) || shouldSkipSerialization(name, TYPOGRAPHY_SUPPORT_KEY, "fontSize") || !fontSize && !style?.typography?.fontSize) {
    return;
  }
  let props;
  if (style?.typography?.fontSize) {
    props = {
      style: {
        fontSize: getTypographyFontSizeValue(
          { size: style.typography.fontSize },
          {
            typography: {
              fluid: fluidTypographySettings
            },
            layout: layoutSettings
          }
        )
      }
    };
  }
  if (fontSize) {
    props = {
      style: {
        fontSize: utils_getFontSize(
          fontSizes,
          fontSize,
          style?.typography?.fontSize
        ).size
      }
    };
  }
  if (!props) {
    return;
  }
  return font_size_addSaveProps(props, name, { fontSize });
}
var font_size_default = {
  useBlockProps: font_size_useBlockProps,
  addSaveProps: font_size_addSaveProps,
  attributeKeys: ["fontSize", "style", "fitText"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_SIZE_SUPPORT_KEY);
  }
};
const font_size_MIGRATION_PATHS = {
  fontSize: [["fontSize"], ["style", "typography", "fontSize"]]
};
function font_size_addTransforms(result, source, index, results) {
  const destinationBlockType = result.name;
  const activeSupports = {
    fontSize: (0,external_wp_blocks_namespaceObject.hasBlockSupport)(
      destinationBlockType,
      FONT_SIZE_SUPPORT_KEY
    )
  };
  return transformStyles(
    activeSupports,
    font_size_MIGRATION_PATHS,
    result,
    source,
    index,
    results
  );
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/font/addAttribute",
  font_size_addAttributes
);
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.switchToBlockType.transformedBlock",
  "core/font-size/addTransforms",
  font_size_addTransforms
);


;// ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/ui.js




const DEFAULT_ALIGNMENT_CONTROLS = [
  {
    icon: align_left_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text left"),
    align: "left"
  },
  {
    icon: align_center_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text center"),
    align: "center"
  },
  {
    icon: align_right_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text right"),
    align: "right"
  }
];
const ui_POPOVER_PROPS = {
  placement: "bottom-start"
};
function AlignmentUI({
  value,
  onChange,
  alignmentControls = DEFAULT_ALIGNMENT_CONTROLS,
  label = (0,external_wp_i18n_namespaceObject.__)("Align text"),
  description = (0,external_wp_i18n_namespaceObject.__)("Change text alignment"),
  isCollapsed = true,
  isToolbar
}) {
  function applyOrUnset(align) {
    return () => onChange(value === align ? void 0 : align);
  }
  const activeAlignment = alignmentControls.find(
    (control) => control.align === value
  );
  function setIcon() {
    if (activeAlignment) {
      return activeAlignment.icon;
    }
    return (0,external_wp_i18n_namespaceObject.isRTL)() ? align_right_default : align_left_default;
  }
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? { isCollapsed } : {
    toggleProps: {
      description
    },
    popoverProps: ui_POPOVER_PROPS
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    UIComponent,
    {
      icon: setIcon(),
      label,
      controls: alignmentControls.map((control) => {
        const { align } = control;
        const isActive = value === align;
        return {
          ...control,
          isActive,
          role: isCollapsed ? "menuitemradio" : void 0,
          onClick: applyOrUnset(align)
        };
      }),
      ...extraProps
    }
  );
}
var alignment_control_ui_ui_default = AlignmentUI;


;// ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/index.js


const AlignmentControl = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(alignment_control_ui_ui_default, { ...props, isToolbar: false });
};
const AlignmentToolbar = (props) => {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(alignment_control_ui_ui_default, { ...props, isToolbar: true });
};


;// ./node_modules/@wordpress/block-editor/build-module/hooks/text-align.js









const TEXT_ALIGN_SUPPORT_KEY = "typography.textAlign";
const text_align_TEXT_ALIGNMENT_OPTIONS = [
  {
    icon: align_left_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text left"),
    align: "left"
  },
  {
    icon: align_center_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text center"),
    align: "center"
  },
  {
    icon: align_right_default,
    title: (0,external_wp_i18n_namespaceObject.__)("Align text right"),
    align: "right"
  }
];
const VALID_TEXT_ALIGNMENTS = ["left", "center", "right"];
const NO_TEXT_ALIGNMENTS = [];
function getValidTextAlignments(blockTextAlign) {
  if (Array.isArray(blockTextAlign)) {
    return VALID_TEXT_ALIGNMENTS.filter(
      (textAlign) => blockTextAlign.includes(textAlign)
    );
  }
  return blockTextAlign === true ? VALID_TEXT_ALIGNMENTS : NO_TEXT_ALIGNMENTS;
}
function BlockEditTextAlignmentToolbarControlsPure({
  style,
  name: blockName,
  setAttributes
}) {
  const settings = useBlockSettings(blockName);
  const hasTextAlignControl = settings?.typography?.textAlign;
  const blockEditingMode = useBlockEditingMode();
  if (!hasTextAlignControl || blockEditingMode !== "default") {
    return null;
  }
  const validTextAlignments = getValidTextAlignments(
    (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, TEXT_ALIGN_SUPPORT_KEY)
  );
  if (!validTextAlignments.length) {
    return null;
  }
  const textAlignmentControls = text_align_TEXT_ALIGNMENT_OPTIONS.filter(
    (control) => validTextAlignments.includes(control.align)
  );
  const onChange = (newTextAlignValue) => {
    const newStyle = {
      ...style,
      typography: {
        ...style?.typography,
        textAlign: newTextAlignValue
      }
    };
    setAttributes({ style: utils_cleanEmptyObject(newStyle) });
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls_default, { group: "block", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    AlignmentControl,
    {
      value: style?.typography?.textAlign,
      onChange,
      alignmentControls: textAlignmentControls
    }
  ) });
}
var text_align_default = {
  edit: BlockEditTextAlignmentToolbarControlsPure,
  useBlockProps: text_align_useBlockProps,
  addSaveProps: addAssignedTextAlign,
  attributeKeys: ["style"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, TEXT_ALIGN_SUPPORT_KEY, false);
  }
};
function text_align_useBlockProps({ name, style }) {
  if (!style?.typography?.textAlign) {
    return null;
  }
  const validTextAlignments = getValidTextAlignments(
    (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, TEXT_ALIGN_SUPPORT_KEY)
  );
  if (!validTextAlignments.length) {
    return null;
  }
  if (shouldSkipSerialization(name, TYPOGRAPHY_SUPPORT_KEY, "textAlign")) {
    return null;
  }
  const textAlign = style.typography.textAlign;
  const className = dist_clsx({
    [`has-text-align-${textAlign}`]: textAlign
  });
  return { className };
}
function addAssignedTextAlign(props, blockType, attributes) {
  if (!attributes?.style?.typography?.textAlign) {
    return props;
  }
  const { textAlign } = attributes.style.typography;
  const blockTextAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, TEXT_ALIGN_SUPPORT_KEY);
  const isTextAlignValid = getValidTextAlignments(blockTextAlign).includes(textAlign);
  if (isTextAlignValid && !shouldSkipSerialization(
    blockType,
    TYPOGRAPHY_SUPPORT_KEY,
    "textAlign"
  )) {
    props.className = dist_clsx(
      `has-text-align-${textAlign}`,
      props.className
    );
  }
  return props;
}


;// ./node_modules/@wordpress/block-editor/build-module/utils/fit-text-utils.js
function findOptimalFontSize(textElement, applyFontSize) {
  const alreadyHasScrollableHeight = textElement.scrollHeight > textElement.clientHeight;
  let minSize = 5;
  let maxSize = 2400;
  let bestSize = minSize;
  const computedStyle = window.getComputedStyle(textElement);
  const paddingLeft = parseFloat(computedStyle.paddingLeft) || 0;
  const paddingRight = parseFloat(computedStyle.paddingRight) || 0;
  const range = document.createRange();
  range.selectNodeContents(textElement);
  while (minSize <= maxSize) {
    const midSize = Math.floor((minSize + maxSize) / 2);
    applyFontSize(midSize);
    const rect = range.getBoundingClientRect();
    const textWidth = rect.width;
    const fitsWidth = textElement.scrollWidth <= textElement.clientWidth && textWidth <= textElement.clientWidth - paddingLeft - paddingRight;
    const fitsHeight = alreadyHasScrollableHeight || textElement.scrollHeight <= textElement.clientHeight;
    if (fitsWidth && fitsHeight) {
      bestSize = midSize;
      minSize = midSize + 1;
    } else {
      maxSize = midSize - 1;
    }
  }
  range.detach();
  return bestSize;
}
function optimizeFitText(textElement, applyFontSize) {
  if (!textElement) {
    return;
  }
  applyFontSize(0);
  const optimalSize = findOptimalFontSize(textElement, applyFontSize);
  applyFontSize(optimalSize);
  return optimalSize;
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/fit-text.js




const EMPTY_OBJECT = {};



const FIT_TEXT_SUPPORT_KEY = "typography.fitText";
function fit_text_addAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, FIT_TEXT_SUPPORT_KEY)) {
    return settings;
  }
  if (settings.attributes?.fitText) {
    return settings;
  }
  return {
    ...settings,
    attributes: {
      ...settings.attributes,
      fitText: {
        type: "boolean"
      }
    }
  };
}
function useFitText({ fitText, name, clientId }) {
  const hasFitTextSupport2 = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FIT_TEXT_SUPPORT_KEY);
  const blockElement = useBlockElement(clientId);
  const { blockAttributes, parentId } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      if (!clientId || !hasFitTextSupport2 || !fitText) {
        return EMPTY_OBJECT;
      }
      return {
        blockAttributes: select(store).getBlockAttributes(clientId),
        parentId: select(store).getBlockRootClientId(clientId)
      };
    },
    [clientId, hasFitTextSupport2, fitText]
  );
  const applyFitText = (0,external_wp_element_namespaceObject.useCallback)(() => {
    if (!blockElement || !hasFitTextSupport2 || !fitText) {
      return;
    }
    const styleId = `fit-text-${clientId}`;
    let styleElement = blockElement.ownerDocument.getElementById(styleId);
    if (!styleElement) {
      styleElement = blockElement.ownerDocument.createElement("style");
      styleElement.id = styleId;
      blockElement.ownerDocument.head.appendChild(styleElement);
    }
    const blockSelector = `#block-${clientId}`;
    const applyFontSize = (fontSize) => {
      if (fontSize === 0) {
        styleElement.textContent = "";
      } else {
        styleElement.textContent = `${blockSelector} { font-size: ${fontSize}px !important; }`;
      }
    };
    optimizeFitText(blockElement, applyFontSize);
  }, [blockElement, clientId, hasFitTextSupport2, fitText]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!fitText || !blockElement || !clientId || !hasFitTextSupport2) {
      return;
    }
    const currentElement = blockElement;
    const previousVisibility = currentElement.style.visibility;
    let hideFrameId = null;
    let calculateFrameId = null;
    let showTimeoutId = null;
    hideFrameId = window.requestAnimationFrame(() => {
      currentElement.style.visibility = "hidden";
      calculateFrameId = window.requestAnimationFrame(() => {
        applyFitText();
        showTimeoutId = setTimeout(() => {
          currentElement.style.visibility = previousVisibility;
        }, 10);
      });
    });
    let resizeObserver;
    if (window.ResizeObserver && currentElement.parentElement) {
      resizeObserver = new window.ResizeObserver(applyFitText);
      resizeObserver.observe(currentElement.parentElement);
      resizeObserver.observe(currentElement);
    }
    return () => {
      if (hideFrameId !== null) {
        window.cancelAnimationFrame(hideFrameId);
      }
      if (calculateFrameId !== null) {
        window.cancelAnimationFrame(calculateFrameId);
      }
      if (showTimeoutId !== null) {
        clearTimeout(showTimeoutId);
      }
      if (resizeObserver) {
        resizeObserver.disconnect();
      }
      const styleId = `fit-text-${clientId}`;
      const styleElement = currentElement.ownerDocument.getElementById(styleId);
      if (styleElement) {
        styleElement.remove();
      }
    };
  }, [
    fitText,
    clientId,
    parentId,
    applyFitText,
    blockElement,
    hasFitTextSupport2
  ]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (fitText && blockElement && hasFitTextSupport2) {
      const frameId = window.requestAnimationFrame(() => {
        if (blockElement) {
          applyFitText();
        }
      });
      return () => window.cancelAnimationFrame(frameId);
    }
  }, [
    blockAttributes,
    fitText,
    applyFitText,
    blockElement,
    hasFitTextSupport2
  ]);
}
function fit_text_addSaveProps(props, blockType, attributes) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, FIT_TEXT_SUPPORT_KEY)) {
    return props;
  }
  const { fitText } = attributes;
  if (!fitText) {
    return props;
  }
  const className = props.className ? `${props.className} has-fit-text` : "has-fit-text";
  return {
    ...props,
    className
  };
}
function fit_text_useBlockProps({ name, fitText, clientId }) {
  useFitText({ fitText, name, clientId });
  if (!fitText || !(0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FIT_TEXT_SUPPORT_KEY)) {
    return {};
  }
  return {
    className: "has-fit-text"
  };
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/fit-text/addAttribute",
  fit_text_addAttributes
);
const hasFitTextSupport = (blockNameOrType) => {
  return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockNameOrType, FIT_TEXT_SUPPORT_KEY);
};
var fit_text_default = {
  useBlockProps: fit_text_useBlockProps,
  addSaveProps: fit_text_addSaveProps,
  attributeKeys: ["fitText"],
  hasSupport: hasFitTextSupport,
  edit: () => null
};


;// ./node_modules/@wordpress/block-editor/build-module/hooks/typography.js













function omit(object, keys) {
  return Object.fromEntries(
    Object.entries(object).filter(([key]) => !keys.includes(key))
  );
}
const LETTER_SPACING_SUPPORT_KEY = "typography.__experimentalLetterSpacing";
const TEXT_TRANSFORM_SUPPORT_KEY = "typography.__experimentalTextTransform";
const TEXT_DECORATION_SUPPORT_KEY = "typography.__experimentalTextDecoration";
const TEXT_COLUMNS_SUPPORT_KEY = "typography.textColumns";
const FONT_STYLE_SUPPORT_KEY = "typography.__experimentalFontStyle";
const FONT_WEIGHT_SUPPORT_KEY = "typography.__experimentalFontWeight";
const WRITING_MODE_SUPPORT_KEY = "typography.__experimentalWritingMode";
const TYPOGRAPHY_SUPPORT_KEY = "typography";
const TYPOGRAPHY_SUPPORT_KEYS = [
  LINE_HEIGHT_SUPPORT_KEY,
  FONT_SIZE_SUPPORT_KEY,
  FONT_STYLE_SUPPORT_KEY,
  FONT_WEIGHT_SUPPORT_KEY,
  FONT_FAMILY_SUPPORT_KEY,
  TEXT_ALIGN_SUPPORT_KEY,
  TEXT_COLUMNS_SUPPORT_KEY,
  TEXT_DECORATION_SUPPORT_KEY,
  WRITING_MODE_SUPPORT_KEY,
  TEXT_TRANSFORM_SUPPORT_KEY,
  LETTER_SPACING_SUPPORT_KEY,
  FIT_TEXT_SUPPORT_KEY
];
function typography_styleToAttributes(style) {
  const updatedStyle = { ...omit(style, ["fontFamily"]) };
  const fontSizeValue = style?.typography?.fontSize;
  const fontFamilyValue = style?.typography?.fontFamily;
  const fontSizeSlug = typeof fontSizeValue === "string" && fontSizeValue?.startsWith("var:preset|font-size|") ? fontSizeValue.substring("var:preset|font-size|".length) : void 0;
  const fontFamilySlug = fontFamilyValue?.startsWith(
    "var:preset|font-family|"
  ) ? fontFamilyValue.substring("var:preset|font-family|".length) : void 0;
  updatedStyle.typography = {
    ...omit(updatedStyle.typography, ["fontFamily"]),
    fontSize: fontSizeSlug ? void 0 : fontSizeValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    fontFamily: fontFamilySlug,
    fontSize: fontSizeSlug
  };
}
function typography_attributesToStyle(attributes) {
  return {
    ...attributes.style,
    typography: {
      ...attributes.style?.typography,
      fontFamily: attributes.fontFamily ? "var:preset|font-family|" + attributes.fontFamily : void 0,
      fontSize: attributes.fontSize ? "var:preset|font-size|" + attributes.fontSize : attributes.style?.typography?.fontSize
    }
  };
}
function TypographyInspectorControl({ children, resetAllFilter }) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(
    (attributes) => {
      const existingStyle = typography_attributesToStyle(attributes);
      const updatedStyle = resetAllFilter(existingStyle);
      return {
        ...attributes,
        ...typography_styleToAttributes(updatedStyle)
      };
    },
    [resetAllFilter]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    inspector_controls_default,
    {
      group: "typography",
      resetAllFilter: attributesResetAllFilter,
      children
    }
  );
}
function typography_TypographyPanel({ clientId, name, setAttributes, settings }) {
  function selector(select) {
    const { style: style2, fontFamily: fontFamily2, fontSize: fontSize2, fitText: fitText2 } = select(store).getBlockAttributes(clientId) || {};
    return { style: style2, fontFamily: fontFamily2, fontSize: fontSize2, fitText: fitText2 };
  }
  const { style, fontFamily, fontSize, fitText } = (0,external_wp_data_namespaceObject.useSelect)(selector, [
    clientId
  ]);
  const isEnabled = useHasTypographyPanel(settings);
  const value = (0,external_wp_element_namespaceObject.useMemo)(
    () => typography_attributesToStyle({ style, fontFamily, fontSize }),
    [style, fontSize, fontFamily]
  );
  const onChange = (newStyle) => {
    setAttributes(typography_styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    TYPOGRAPHY_SUPPORT_KEY,
    "__experimentalDefaultControls"
  ]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    TypographyPanel,
    {
      as: TypographyInspectorControl,
      panelId: clientId,
      settings,
      value,
      onChange,
      defaultControls,
      fitText
    }
  );
}
const hasTypographySupport = (blockName) => {
  return TYPOGRAPHY_SUPPORT_KEYS.some(
    (key) => hasBlockSupport(blockName, key)
  );
};


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/hooks/use-spacing-sizes.js




const use_spacing_sizes_EMPTY_ARRAY = [];
const compare = new Intl.Collator("und", { numeric: true }).compare;
function useSpacingSizes() {
  const [
    customSpacingSizes,
    themeSpacingSizes,
    defaultSpacingSizes,
    defaultSpacingSizesEnabled
  ] = use_settings_useSettings(
    "spacing.spacingSizes.custom",
    "spacing.spacingSizes.theme",
    "spacing.spacingSizes.default",
    "spacing.defaultSpacingSizes"
  );
  const customSizes = customSpacingSizes ?? use_spacing_sizes_EMPTY_ARRAY;
  const themeSizes = themeSpacingSizes ?? use_spacing_sizes_EMPTY_ARRAY;
  const defaultSizes = defaultSpacingSizes && defaultSpacingSizesEnabled !== false ? defaultSpacingSizes : use_spacing_sizes_EMPTY_ARRAY;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const sizes = [
      { name: (0,external_wp_i18n_namespaceObject.__)("None"), slug: "0", size: 0 },
      ...customSizes,
      ...themeSizes,
      ...defaultSizes
    ];
    if (sizes.every(({ slug }) => /^[0-9]/.test(slug))) {
      sizes.sort((a, b) => compare(a.slug, b.slug));
    }
    return sizes.length > RANGE_CONTROL_MAX_SIZE ? [
      {
        name: (0,external_wp_i18n_namespaceObject.__)("Default"),
        slug: "default",
        size: void 0
      },
      ...sizes
    ] : sizes;
  }, [customSizes, themeSizes, defaultSizes]);
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls/spacing-input-control.js










const CUSTOM_VALUE_SETTINGS = {
  px: { max: 300, steps: 1 },
  "%": { max: 100, steps: 1 },
  vw: { max: 100, steps: 1 },
  vh: { max: 100, steps: 1 },
  em: { max: 10, steps: 0.1 },
  rm: { max: 10, steps: 0.1 },
  svw: { max: 100, steps: 1 },
  lvw: { max: 100, steps: 1 },
  dvw: { max: 100, steps: 1 },
  svh: { max: 100, steps: 1 },
  lvh: { max: 100, steps: 1 },
  dvh: { max: 100, steps: 1 },
  vi: { max: 100, steps: 1 },
  svi: { max: 100, steps: 1 },
  lvi: { max: 100, steps: 1 },
  dvi: { max: 100, steps: 1 },
  vb: { max: 100, steps: 1 },
  svb: { max: 100, steps: 1 },
  lvb: { max: 100, steps: 1 },
  dvb: { max: 100, steps: 1 },
  vmin: { max: 100, steps: 1 },
  svmin: { max: 100, steps: 1 },
  lvmin: { max: 100, steps: 1 },
  dvmin: { max: 100, steps: 1 },
  vmax: { max: 100, steps: 1 },
  svmax: { max: 100, steps: 1 },
  lvmax: { max: 100, steps: 1 },
  dvmax: { max: 100, steps: 1 }
};
function SpacingInputControl({
  icon,
  isMixed = false,
  minimumCustomValue,
  onChange,
  onMouseOut,
  onMouseOver,
  showSideInLabel = true,
  side,
  spacingSizes,
  type,
  value
}) {
  value = getPresetValueFromCustomValue(value, spacingSizes);
  let selectListSizes = spacingSizes;
  const showRangeControl = spacingSizes.length <= RANGE_CONTROL_MAX_SIZE;
  const disableCustomSpacingSizes = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const editorSettings = select(store).getSettings();
    return editorSettings?.disableCustomSpacingSizes;
  });
  const [showCustomValueControl, setShowCustomValueControl] = (0,external_wp_element_namespaceObject.useState)(
    !disableCustomSpacingSizes && value !== void 0 && !isValueSpacingPreset(value)
  );
  const [minValue, setMinValue] = (0,external_wp_element_namespaceObject.useState)(minimumCustomValue);
  const previousValue = (0,external_wp_compose_namespaceObject.usePrevious)(value);
  if (!!value && previousValue !== value && !isValueSpacingPreset(value) && showCustomValueControl !== true) {
    setShowCustomValueControl(true);
  }
  const [availableUnits] = use_settings_useSettings("spacing.units");
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ["px", "em", "rem"]
  });
  let currentValue = null;
  const showCustomValueInSelectList = !showRangeControl && !showCustomValueControl && value !== void 0 && (!isValueSpacingPreset(value) || isValueSpacingPreset(value) && isMixed);
  if (showCustomValueInSelectList) {
    selectListSizes = [
      ...spacingSizes,
      {
        name: !isMixed ? (
          // translators: %s: A custom measurement, e.g. a number followed by a unit like 12px.
          (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)("Custom (%s)"), value)
        ) : (0,external_wp_i18n_namespaceObject.__)("Mixed"),
        slug: "custom",
        size: value
      }
    ];
    currentValue = selectListSizes.length - 1;
  } else if (!isMixed) {
    currentValue = !showCustomValueControl ? getSliderValueFromPreset(value, spacingSizes) : getCustomValueFromPreset(value, spacingSizes);
  }
  const selectedUnit = (0,external_wp_element_namespaceObject.useMemo)(
    () => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(currentValue),
    [currentValue]
  )[1] || units[0]?.value;
  const setInitialValue = () => {
    if (value === void 0) {
      onChange("0");
    }
  };
  const customTooltipContent = (newValue) => value === void 0 ? void 0 : spacingSizes[newValue]?.name;
  const customRangeValue = parseFloat(currentValue, 10);
  const getNewCustomValue = (newSize) => {
    const isNumeric = !isNaN(parseFloat(newSize));
    const nextValue = isNumeric ? newSize : void 0;
    return nextValue;
  };
  const getNewPresetValue = (newSize, controlType) => {
    const size = parseInt(newSize, 10);
    if (controlType === "selectList") {
      if (size === 0) {
        return void 0;
      }
      if (size === 1) {
        return "0";
      }
    } else if (size === 0) {
      return "0";
    }
    return `var:preset|spacing|${spacingSizes[newSize]?.slug}`;
  };
  const handleCustomValueSliderChange = (next) => {
    onChange([next, selectedUnit].join(""));
  };
  const allPlaceholder = isMixed ? (0,external_wp_i18n_namespaceObject.__)("Mixed") : null;
  const options = selectListSizes.map((size, index) => ({
    key: index,
    name: size.name
  }));
  const marks = spacingSizes.slice(1, spacingSizes.length - 1).map((_newValue, index) => ({
    value: index + 1,
    label: void 0
  }));
  const sideLabel = ALL_SIDES.includes(side) && showSideInLabel ? LABELS[side] : "";
  const typeLabel = showSideInLabel ? type?.toLowerCase() : type;
  const ariaLabel = (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: 1: The side of the block being modified (top, bottom, left etc.). 2. Type of spacing being modified (padding, margin, etc).
    (0,external_wp_i18n_namespaceObject._x)("%1$s %2$s", "spacing"),
    sideLabel,
    typeLabel
  ).trim();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { className: "spacing-sizes-control__wrapper", children: [
    icon && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Icon,
      {
        className: "spacing-sizes-control__icon",
        icon,
        size: 24
      }
    ),
    showCustomValueControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalUnitControl,
        {
          onMouseOver,
          onMouseOut,
          onFocus: onMouseOver,
          onBlur: onMouseOut,
          onChange: (newSize) => onChange(getNewCustomValue(newSize)),
          value: currentValue,
          units,
          min: minValue,
          placeholder: allPlaceholder,
          disableUnits: isMixed,
          label: ariaLabel,
          hideLabelFromVision: true,
          className: "spacing-sizes-control__custom-value-input",
          size: "__unstable-large",
          onDragStart: () => {
            if (value?.charAt(0) === "-") {
              setMinValue(0);
            }
          },
          onDrag: () => {
            if (value?.charAt(0) === "-") {
              setMinValue(0);
            }
          },
          onDragEnd: () => {
            setMinValue(minimumCustomValue);
          }
        }
      ),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.RangeControl,
        {
          __next40pxDefaultSize: true,
          onMouseOver,
          onMouseOut,
          onFocus: onMouseOver,
          onBlur: onMouseOut,
          value: customRangeValue,
          min: 0,
          max: CUSTOM_VALUE_SETTINGS[selectedUnit]?.max ?? 10,
          step: CUSTOM_VALUE_SETTINGS[selectedUnit]?.steps ?? 0.1,
          withInputField: false,
          onChange: handleCustomValueSliderChange,
          className: "spacing-sizes-control__custom-value-range",
          __nextHasNoMarginBottom: true,
          label: ariaLabel,
          hideLabelFromVision: true
        }
      )
    ] }),
    showRangeControl && !showCustomValueControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.RangeControl,
      {
        __next40pxDefaultSize: true,
        onMouseOver,
        onMouseOut,
        className: "spacing-sizes-control__range-control",
        value: currentValue,
        onChange: (newSize) => onChange(getNewPresetValue(newSize)),
        onMouseDown: (event) => {
          if (event?.nativeEvent?.offsetX < 35) {
            setInitialValue();
          }
        },
        withInputField: false,
        "aria-valuenow": currentValue,
        "aria-valuetext": spacingSizes[currentValue]?.name,
        renderTooltipContent: customTooltipContent,
        min: 0,
        max: spacingSizes.length - 1,
        marks,
        label: ariaLabel,
        hideLabelFromVision: true,
        __nextHasNoMarginBottom: true,
        onFocus: onMouseOver,
        onBlur: onMouseOut
      }
    ),
    !showRangeControl && !showCustomValueControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.CustomSelectControl,
      {
        className: "spacing-sizes-control__custom-select-control",
        value: (
          // passing empty string as a fallback to continue using the
          // component in controlled mode
          options.find(
            (option) => option.key === currentValue
          ) || ""
        ),
        onChange: (selection) => {
          onChange(
            getNewPresetValue(
              selection.selectedItem.key,
              "selectList"
            )
          );
        },
        options,
        label: ariaLabel,
        hideLabelFromVision: true,
        size: "__unstable-large",
        onMouseOver,
        onMouseOut,
        onFocus: onMouseOver,
        onBlur: onMouseOut
      }
    ),
    !disableCustomSpacingSizes && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        label: showCustomValueControl ? (0,external_wp_i18n_namespaceObject.__)("Use size preset") : (0,external_wp_i18n_namespaceObject.__)("Set custom size"),
        icon: settings_settings_default,
        onClick: () => {
          setShowCustomValueControl(!showCustomValueControl);
        },
        isPressed: showCustomValueControl,
        size: "small",
        className: "spacing-sizes-control__custom-toggle",
        iconSize: 24
      }
    )
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls/axial.js



const groupedSides = ["vertical", "horizontal"];
function AxialInputControls({
  minimumCustomValue,
  onChange,
  onMouseOut,
  onMouseOver,
  sides,
  spacingSizes,
  type,
  values
}) {
  const createHandleOnChange = (side) => (next) => {
    if (!onChange) {
      return;
    }
    const nextValues = {
      ...Object.keys(values).reduce((acc, key) => {
        acc[key] = getPresetValueFromCustomValue(
          values[key],
          spacingSizes
        );
        return acc;
      }, {})
    };
    if (side === "vertical") {
      nextValues.top = next;
      nextValues.bottom = next;
    }
    if (side === "horizontal") {
      nextValues.left = next;
      nextValues.right = next;
    }
    onChange(nextValues);
  };
  const filteredSides = sides?.length ? groupedSides.filter((side) => hasAxisSupport(sides, side)) : groupedSides;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: filteredSides.map((side) => {
    const axisValue = side === "vertical" ? values.top : values.left;
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      SpacingInputControl,
      {
        icon: ICONS[side],
        label: LABELS[side],
        minimumCustomValue,
        onChange: createHandleOnChange(side),
        onMouseOut,
        onMouseOver,
        side,
        spacingSizes,
        type,
        value: axisValue,
        withInputField: false
      },
      `spacing-sizes-control-${side}`
    );
  }) });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls/separated.js



function SeparatedInputControls({
  minimumCustomValue,
  onChange,
  onMouseOut,
  onMouseOver,
  sides,
  spacingSizes,
  type,
  values
}) {
  const filteredSides = sides?.length ? ALL_SIDES.filter((side) => sides.includes(side)) : ALL_SIDES;
  const createHandleOnChange = (side) => (next) => {
    const nextValues = {
      ...Object.keys(values).reduce((acc, key) => {
        acc[key] = getPresetValueFromCustomValue(
          values[key],
          spacingSizes
        );
        return acc;
      }, {})
    };
    nextValues[side] = next;
    onChange(nextValues);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: filteredSides.map((side) => {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      SpacingInputControl,
      {
        icon: ICONS[side],
        label: LABELS[side],
        minimumCustomValue,
        onChange: createHandleOnChange(side),
        onMouseOut,
        onMouseOver,
        side,
        spacingSizes,
        type,
        value: values[side],
        withInputField: false
      },
      `spacing-sizes-control-${side}`
    );
  }) });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls/single.js



function single_SingleInputControl({
  minimumCustomValue,
  onChange,
  onMouseOut,
  onMouseOver,
  showSideInLabel,
  side,
  spacingSizes,
  type,
  values
}) {
  const createHandleOnChange = (currentSide) => (next) => {
    const nextValues = {
      ...Object.keys(values).reduce((acc, key) => {
        acc[key] = getPresetValueFromCustomValue(
          values[key],
          spacingSizes
        );
        return acc;
      }, {})
    };
    nextValues[currentSide] = next;
    onChange(nextValues);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    SpacingInputControl,
    {
      label: LABELS[side],
      minimumCustomValue,
      onChange: createHandleOnChange(side),
      onMouseOut,
      onMouseOver,
      showSideInLabel,
      side,
      spacingSizes,
      type,
      value: values[side],
      withInputField: false
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/linked-button.js




function linked_button_LinkedButton({ isLinked, ...props }) {
  const label = isLinked ? (0,external_wp_i18n_namespaceObject.__)("Unlink sides") : (0,external_wp_i18n_namespaceObject.__)("Link sides");
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Button,
    {
      ...props,
      size: "small",
      icon: isLinked ? link_default : link_off_default,
      iconSize: 24,
      label
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/index.js










function SpacingSizesControl({
  inputProps,
  label: labelProp,
  minimumCustomValue = 0,
  onChange,
  onMouseOut,
  onMouseOver,
  showSideInLabel = true,
  sides = ALL_SIDES,
  useSelect,
  values
}) {
  const spacingSizes = useSpacingSizes();
  const inputValues = values || DEFAULT_VALUES;
  const hasOneSide = sides?.length === 1;
  const hasOnlyAxialSides = sides?.includes("horizontal") && sides?.includes("vertical") && sides?.length === 2;
  const [view, setView] = (0,external_wp_element_namespaceObject.useState)(getInitialView(inputValues, sides));
  const toggleLinked = () => {
    setView(view === VIEWS.axial ? VIEWS.custom : VIEWS.axial);
  };
  const handleOnChange = (nextValue) => {
    const newValues = { ...values, ...nextValue };
    onChange(newValues);
  };
  const inputControlProps = {
    ...inputProps,
    minimumCustomValue,
    onChange: handleOnChange,
    onMouseOut,
    onMouseOver,
    sides,
    spacingSizes,
    type: labelProp,
    useSelect,
    values: inputValues
  };
  const renderControls = () => {
    if (view === VIEWS.axial) {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(AxialInputControls, { ...inputControlProps });
    }
    if (view === VIEWS.custom) {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(SeparatedInputControls, { ...inputControlProps });
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      single_SingleInputControl,
      {
        side: view,
        ...inputControlProps,
        showSideInLabel
      }
    );
  };
  const sideLabel = ALL_SIDES.includes(view) && showSideInLabel ? LABELS[view] : "";
  const label = (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: 1: The side of the block being modified (top, bottom, left etc.). 2. Type of spacing being modified (padding, margin, etc).
    (0,external_wp_i18n_namespaceObject._x)("%1$s %2$s", "spacing"),
    labelProp,
    sideLabel
  ).trim();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "spacing-sizes-control", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { className: "spacing-sizes-control__header", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.BaseControl.VisualLabel,
        {
          as: "legend",
          className: "spacing-sizes-control__label",
          children: label
        }
      ),
      !hasOneSide && !hasOnlyAxialSides && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        linked_button_LinkedButton,
        {
          label: labelProp,
          onClick: toggleLinked,
          isLinked: view === VIEWS.axial
        }
      )
    ] }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: 0.5, children: renderControls() })
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/height-control/index.js





const RANGE_CONTROL_CUSTOM_SETTINGS = {
  px: { max: 1e3, step: 1 },
  "%": { max: 100, step: 1 },
  vw: { max: 100, step: 1 },
  vh: { max: 100, step: 1 },
  em: { max: 50, step: 0.1 },
  rem: { max: 50, step: 0.1 },
  svw: { max: 100, step: 1 },
  lvw: { max: 100, step: 1 },
  dvw: { max: 100, step: 1 },
  svh: { max: 100, step: 1 },
  lvh: { max: 100, step: 1 },
  dvh: { max: 100, step: 1 },
  vi: { max: 100, step: 1 },
  svi: { max: 100, step: 1 },
  lvi: { max: 100, step: 1 },
  dvi: { max: 100, step: 1 },
  vb: { max: 100, step: 1 },
  svb: { max: 100, step: 1 },
  lvb: { max: 100, step: 1 },
  dvb: { max: 100, step: 1 },
  vmin: { max: 100, step: 1 },
  svmin: { max: 100, step: 1 },
  lvmin: { max: 100, step: 1 },
  dvmin: { max: 100, step: 1 },
  vmax: { max: 100, step: 1 },
  svmax: { max: 100, step: 1 },
  lvmax: { max: 100, step: 1 },
  dvmax: { max: 100, step: 1 }
};
function HeightControl({
  label = (0,external_wp_i18n_namespaceObject.__)("Height"),
  onChange,
  value
}) {
  const customRangeValue = parseFloat(value);
  const [availableUnits] = use_settings_useSettings("spacing.units");
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || [
      "%",
      "px",
      "em",
      "rem",
      "vh",
      "vw"
    ]
  });
  const selectedUnit = (0,external_wp_element_namespaceObject.useMemo)(
    () => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value),
    [value]
  )[1] || units[0]?.value || "px";
  const handleSliderChange = (next) => {
    onChange([next, selectedUnit].join(""));
  };
  const handleUnitChange = (newUnit) => {
    const [currentValue, currentUnit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);
    if (["em", "rem"].includes(newUnit) && currentUnit === "px") {
      onChange((currentValue / 16).toFixed(2) + newUnit);
    } else if (["em", "rem"].includes(currentUnit) && newUnit === "px") {
      onChange(Math.round(currentValue * 16) + newUnit);
    } else if ([
      "%",
      "vw",
      "svw",
      "lvw",
      "dvw",
      "vh",
      "svh",
      "lvh",
      "dvh",
      "vi",
      "svi",
      "lvi",
      "dvi",
      "vb",
      "svb",
      "lvb",
      "dvb",
      "vmin",
      "svmin",
      "lvmin",
      "dvmin",
      "vmax",
      "svmax",
      "lvmax",
      "dvmax"
    ].includes(newUnit) && currentValue > 100) {
      onChange(100 + newUnit);
    }
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", { className: "block-editor-height-control", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, { as: "legend", children: label }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalUnitControl,
        {
          value,
          units,
          onChange,
          onUnitChange: handleUnitChange,
          min: 0,
          size: "__unstable-large",
          label,
          hideLabelFromVision: true
        }
      ) }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { isBlock: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalSpacer, { marginX: 2, marginBottom: 0, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.RangeControl,
        {
          __next40pxDefaultSize: true,
          value: customRangeValue,
          min: 0,
          max: RANGE_CONTROL_CUSTOM_SETTINGS[selectedUnit]?.max ?? 100,
          step: RANGE_CONTROL_CUSTOM_SETTINGS[selectedUnit]?.step ?? 0.1,
          withInputField: false,
          onChange: handleSliderChange,
          __nextHasNoMarginBottom: true,
          label,
          hideLabelFromVision: true
        }
      ) }) })
    ] })
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/grid/use-get-number-of-blocks-before-cell.js


function useGetNumberOfBlocksBeforeCell(gridClientId, numColumns) {
  const { getBlockOrder, getBlockAttributes } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const getNumberOfBlocksBeforeCell = (column, row) => {
    const targetIndex = (row - 1) * numColumns + column - 1;
    let count = 0;
    for (const clientId of getBlockOrder(gridClientId)) {
      const { columnStart, rowStart } = getBlockAttributes(clientId).style?.layout ?? {};
      const cellIndex = (rowStart - 1) * numColumns + columnStart - 1;
      if (cellIndex < targetIndex) {
        count++;
      }
    }
    return count;
  };
  return getNumberOfBlocksBeforeCell;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/child-layout-control/index.js








function helpText(selfStretch, parentLayout) {
  const { orientation = "horizontal" } = parentLayout;
  if (selfStretch === "fill") {
    return (0,external_wp_i18n_namespaceObject.__)("Stretch to fill available space.");
  }
  if (selfStretch === "fixed" && orientation === "horizontal") {
    return (0,external_wp_i18n_namespaceObject.__)("Specify a fixed width.");
  } else if (selfStretch === "fixed") {
    return (0,external_wp_i18n_namespaceObject.__)("Specify a fixed height.");
  }
  return (0,external_wp_i18n_namespaceObject.__)("Fit contents.");
}
function ChildLayoutControl({
  value: childLayout = {},
  onChange,
  parentLayout,
  isShownByDefault,
  panelId
}) {
  const {
    type: parentType,
    default: { type: defaultParentType = "default" } = {}
  } = parentLayout ?? {};
  const parentLayoutType = parentType || defaultParentType;
  if (parentLayoutType === "flex") {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      FlexControls,
      {
        childLayout,
        onChange,
        parentLayout,
        isShownByDefault,
        panelId
      }
    );
  } else if (parentLayoutType === "grid") {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      GridControls,
      {
        childLayout,
        onChange,
        parentLayout,
        isShownByDefault,
        panelId
      }
    );
  }
  return null;
}
function FlexControls({
  childLayout,
  onChange,
  parentLayout,
  isShownByDefault,
  panelId
}) {
  const { selfStretch, flexSize } = childLayout;
  const { orientation = "horizontal" } = parentLayout ?? {};
  const hasFlexValue = () => !!selfStretch;
  const flexResetLabel = orientation === "horizontal" ? (0,external_wp_i18n_namespaceObject.__)("Width") : (0,external_wp_i18n_namespaceObject.__)("Height");
  const [availableUnits] = use_settings_useSettings("spacing.units");
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || [
      "%",
      "px",
      "em",
      "rem",
      "vh",
      "vw"
    ]
  });
  const resetFlex = () => {
    onChange({
      selfStretch: void 0,
      flexSize: void 0
    });
  };
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (selfStretch === "fixed" && !flexSize) {
      onChange({
        ...childLayout,
        selfStretch: "fit"
      });
    }
  }, []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    external_wp_components_namespaceObject.__experimentalVStack,
    {
      as: external_wp_components_namespaceObject.__experimentalToolsPanelItem,
      spacing: 2,
      hasValue: hasFlexValue,
      label: flexResetLabel,
      onDeselect: resetFlex,
      isShownByDefault,
      panelId,
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalToggleGroupControl,
          {
            __nextHasNoMarginBottom: true,
            size: "__unstable-large",
            label: childLayoutOrientation(parentLayout),
            value: selfStretch || "fit",
            help: helpText(selfStretch, parentLayout),
            onChange: (value) => {
              const newFlexSize = value !== "fixed" ? null : flexSize;
              onChange({
                selfStretch: value,
                flexSize: newFlexSize
              });
            },
            isBlock: true,
            children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
                {
                  value: "fit",
                  label: (0,external_wp_i18n_namespaceObject._x)(
                    "Fit",
                    "Intrinsic block width in flex layout"
                  )
                },
                "fit"
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
                {
                  value: "fill",
                  label: (0,external_wp_i18n_namespaceObject._x)(
                    "Grow",
                    "Block with expanding width in flex layout"
                  )
                },
                "fill"
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.__experimentalToggleGroupControlOption,
                {
                  value: "fixed",
                  label: (0,external_wp_i18n_namespaceObject._x)(
                    "Fixed",
                    "Block with fixed width in flex layout"
                  )
                },
                "fixed"
              )
            ]
          }
        ),
        selfStretch === "fixed" && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalUnitControl,
          {
            size: "__unstable-large",
            units,
            onChange: (value) => {
              onChange({
                selfStretch,
                flexSize: value
              });
            },
            value: flexSize,
            min: 0,
            label: flexResetLabel,
            hideLabelFromVision: true
          }
        )
      ]
    }
  );
}
function childLayoutOrientation(parentLayout) {
  const { orientation = "horizontal" } = parentLayout;
  return orientation === "horizontal" ? (0,external_wp_i18n_namespaceObject.__)("Width") : (0,external_wp_i18n_namespaceObject.__)("Height");
}
function GridControls({
  childLayout,
  onChange,
  parentLayout,
  isShownByDefault,
  panelId
}) {
  const { columnStart, rowStart, columnSpan, rowSpan } = childLayout;
  const { columnCount, rowCount } = parentLayout ?? {};
  const rootClientId = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).getBlockRootClientId(panelId)
  );
  const { moveBlocksToPosition, __unstableMarkNextChangeAsNotPersistent } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const getNumberOfBlocksBeforeCell = useGetNumberOfBlocksBeforeCell(
    rootClientId,
    columnCount || 3
  );
  const hasStartValue = () => !!columnStart || !!rowStart;
  const hasSpanValue = () => !!columnSpan || !!rowSpan;
  const resetGridStarts = () => {
    onChange({
      columnStart: void 0,
      rowStart: void 0
    });
  };
  const resetGridSpans = () => {
    onChange({
      columnSpan: void 0,
      rowSpan: void 0
    });
  };
  const maxColumnSpan = columnCount ? columnCount - (columnStart ?? 1) + 1 : void 0;
  const maxRowSpan = window.__experimentalEnableGridInteractivity && rowCount ? rowCount - (rowStart ?? 1) + 1 : void 0;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.Flex,
      {
        as: external_wp_components_namespaceObject.__experimentalToolsPanelItem,
        hasValue: hasSpanValue,
        label: (0,external_wp_i18n_namespaceObject.__)("Grid span"),
        onDeselect: resetGridSpans,
        isShownByDefault,
        panelId,
        children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { style: { width: "50%" }, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalInputControl,
            {
              size: "__unstable-large",
              label: (0,external_wp_i18n_namespaceObject.__)("Column span"),
              type: "number",
              onChange: (value) => {
                const newColumnSpan = value === "" ? 1 : parseInt(value, 10);
                const constrainedValue = maxColumnSpan ? Math.min(newColumnSpan, maxColumnSpan) : newColumnSpan;
                onChange({
                  columnStart,
                  rowStart,
                  rowSpan,
                  columnSpan: constrainedValue
                });
              },
              value: columnSpan ?? 1,
              min: 1,
              max: maxColumnSpan
            }
          ) }),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { style: { width: "50%" }, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalInputControl,
            {
              size: "__unstable-large",
              label: (0,external_wp_i18n_namespaceObject.__)("Row span"),
              type: "number",
              onChange: (value) => {
                const newRowSpan = value === "" ? 1 : parseInt(value, 10);
                const constrainedValue = maxRowSpan ? Math.min(newRowSpan, maxRowSpan) : newRowSpan;
                onChange({
                  columnStart,
                  rowStart,
                  columnSpan,
                  rowSpan: constrainedValue
                });
              },
              value: rowSpan ?? 1,
              min: 1,
              max: maxRowSpan
            }
          ) })
        ]
      }
    ),
    window.__experimentalEnableGridInteractivity && // Use Flex with an explicit width on the FlexItem instead of HStack to
    // work around an issue in webkit where inputs with a max attribute are
    // sized incorrectly.
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
      external_wp_components_namespaceObject.Flex,
      {
        as: external_wp_components_namespaceObject.__experimentalToolsPanelItem,
        hasValue: hasStartValue,
        label: (0,external_wp_i18n_namespaceObject.__)("Grid placement"),
        onDeselect: resetGridStarts,
        isShownByDefault: false,
        panelId,
        children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { style: { width: "50%" }, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalInputControl,
            {
              size: "__unstable-large",
              label: (0,external_wp_i18n_namespaceObject.__)("Column"),
              type: "number",
              onChange: (value) => {
                const newColumnStart = value === "" ? 1 : parseInt(value, 10);
                onChange({
                  columnStart: newColumnStart,
                  rowStart,
                  columnSpan,
                  rowSpan
                });
                __unstableMarkNextChangeAsNotPersistent();
                moveBlocksToPosition(
                  [panelId],
                  rootClientId,
                  rootClientId,
                  getNumberOfBlocksBeforeCell(
                    newColumnStart,
                    rowStart
                  )
                );
              },
              value: columnStart ?? 1,
              min: 1,
              max: columnCount ? columnCount - (columnSpan ?? 1) + 1 : void 0
            }
          ) }),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { style: { width: "50%" }, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.__experimentalInputControl,
            {
              size: "__unstable-large",
              label: (0,external_wp_i18n_namespaceObject.__)("Row"),
              type: "number",
              onChange: (value) => {
                const newRowStart = value === "" ? 1 : parseInt(value, 10);
                onChange({
                  columnStart,
                  rowStart: newRowStart,
                  columnSpan,
                  rowSpan
                });
                __unstableMarkNextChangeAsNotPersistent();
                moveBlocksToPosition(
                  [panelId],
                  rootClientId,
                  rootClientId,
                  getNumberOfBlocksBeforeCell(
                    columnStart,
                    newRowStart
                  )
                );
              },
              value: rowStart ?? 1,
              min: 1,
              max: rowCount ? rowCount - (rowSpan ?? 1) + 1 : void 0
            }
          ) })
        ]
      }
    )
  ] });
}


;// ./node_modules/@wordpress/block-editor/build-module/components/dimensions-tool/aspect-ratio-tool.js




function AspectRatioTool({
  panelId,
  value,
  onChange = () => {
  },
  options,
  defaultValue = "auto",
  hasValue,
  isShownByDefault = true
}) {
  const displayValue = value ?? "auto";
  const [defaultRatios, themeRatios, showDefaultRatios] = use_settings_useSettings(
    "dimensions.aspectRatios.default",
    "dimensions.aspectRatios.theme",
    "dimensions.defaultAspectRatios"
  );
  const themeOptions = themeRatios?.map(({ name, ratio }) => ({
    label: name,
    value: ratio
  }));
  const defaultOptions = defaultRatios?.map(({ name, ratio }) => ({
    label: name,
    value: ratio
  }));
  const aspectRatioOptions = [
    {
      label: (0,external_wp_i18n_namespaceObject._x)(
        "Original",
        "Aspect ratio option for dimensions control"
      ),
      value: "auto"
    },
    ...showDefaultRatios ? defaultOptions : [],
    ...themeOptions ? themeOptions : [],
    {
      label: (0,external_wp_i18n_namespaceObject._x)("Custom", "Aspect ratio option for dimensions control"),
      value: "custom",
      disabled: true,
      hidden: true
    }
  ];
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanelItem,
    {
      hasValue: hasValue ? hasValue : () => displayValue !== defaultValue,
      label: (0,external_wp_i18n_namespaceObject.__)("Aspect ratio"),
      onDeselect: () => onChange(void 0),
      isShownByDefault,
      panelId,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.SelectControl,
        {
          label: (0,external_wp_i18n_namespaceObject.__)("Aspect ratio"),
          value: displayValue,
          options: options ?? aspectRatioOptions,
          onChange,
          size: "__unstable-large",
          __nextHasNoMarginBottom: true
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/dimensions-panel.js













const AXIAL_SIDES = ["horizontal", "vertical"];
function useHasDimensionsPanel(settings) {
  const hasContentSize = useHasContentSize(settings);
  const hasWideSize = useHasWideSize(settings);
  const hasPadding = useHasPadding(settings);
  const hasMargin = useHasMargin(settings);
  const hasGap = useHasGap(settings);
  const hasMinHeight = useHasMinHeight(settings);
  const hasAspectRatio = useHasAspectRatio(settings);
  const hasChildLayout = useHasChildLayout(settings);
  return external_wp_element_namespaceObject.Platform.OS === "web" && (hasContentSize || hasWideSize || hasPadding || hasMargin || hasGap || hasMinHeight || hasAspectRatio || hasChildLayout);
}
function useHasContentSize(settings) {
  return settings?.layout?.contentSize;
}
function useHasWideSize(settings) {
  return settings?.layout?.wideSize;
}
function useHasPadding(settings) {
  return settings?.spacing?.padding;
}
function useHasMargin(settings) {
  return settings?.spacing?.margin;
}
function useHasGap(settings) {
  return settings?.spacing?.blockGap;
}
function useHasMinHeight(settings) {
  return settings?.dimensions?.minHeight;
}
function useHasAspectRatio(settings) {
  return settings?.dimensions?.aspectRatio;
}
function useHasChildLayout(settings) {
  const {
    type: parentLayoutType = "default",
    default: { type: defaultParentLayoutType = "default" } = {},
    allowSizingOnChildren = false
  } = settings?.parentLayout ?? {};
  const support = (defaultParentLayoutType === "flex" || parentLayoutType === "flex" || defaultParentLayoutType === "grid" || parentLayoutType === "grid") && allowSizingOnChildren;
  return !!settings?.layout && support;
}
function useHasSpacingPresets(settings) {
  const { defaultSpacingSizes, spacingSizes } = settings?.spacing || {};
  return defaultSpacingSizes !== false && spacingSizes?.default?.length > 0 || spacingSizes?.theme?.length > 0 || spacingSizes?.custom?.length > 0;
}
function filterValuesBySides(values, sides) {
  if (!sides || !values) {
    return values;
  }
  const filteredValues = {};
  sides.forEach((side) => {
    if (side === "vertical") {
      filteredValues.top = values.top;
      filteredValues.bottom = values.bottom;
    }
    if (side === "horizontal") {
      filteredValues.left = values.left;
      filteredValues.right = values.right;
    }
    filteredValues[side] = values?.[side];
  });
  return filteredValues;
}
function splitStyleValue(value) {
  if (value && typeof value === "string") {
    return {
      top: value,
      right: value,
      bottom: value,
      left: value
    };
  }
  return value;
}
function splitGapValue(value, isAxialGap) {
  if (!value) {
    return value;
  }
  if (typeof value === "string") {
    return isAxialGap ? { top: value, right: value, bottom: value, left: value } : { top: value };
  }
  return {
    ...value,
    right: value?.left,
    bottom: value?.top
  };
}
function DimensionsToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label: (0,external_wp_i18n_namespaceObject.__)("Dimensions"),
      resetAll,
      panelId,
      dropdownMenuProps,
      children
    }
  );
}
const dimensions_panel_DEFAULT_CONTROLS = {
  contentSize: true,
  wideSize: true,
  padding: true,
  margin: true,
  blockGap: true,
  minHeight: true,
  aspectRatio: true,
  childLayout: true
};
function DimensionsPanel({
  as: Wrapper = DimensionsToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = dimensions_panel_DEFAULT_CONTROLS,
  onVisualize = () => {
  },
  // Special case because the layout controls are not part of the dimensions panel
  // in global styles but not in block inspector.
  includeLayoutControls = false
}) {
  const { dimensions, spacing } = settings;
  const decodeValue = (rawValue) => {
    if (rawValue && typeof rawValue === "object") {
      return Object.keys(rawValue).reduce((acc, key) => {
        acc[key] = getValueFromVariable(
          { settings: { dimensions, spacing } },
          "",
          rawValue[key]
        );
        return acc;
      }, {});
    }
    return getValueFromVariable(
      { settings: { dimensions, spacing } },
      "",
      rawValue
    );
  };
  const showSpacingPresetsControl = useHasSpacingPresets(settings);
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: settings?.spacing?.units || [
      "%",
      "px",
      "em",
      "rem",
      "vw"
    ]
  });
  const minimumMargin = -Infinity;
  const [minMarginValue, setMinMarginValue] = (0,external_wp_element_namespaceObject.useState)(minimumMargin);
  const showContentSizeControl = useHasContentSize(settings) && includeLayoutControls;
  const contentSizeValue = decodeValue(inheritedValue?.layout?.contentSize);
  const setContentSizeValue = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["layout", "contentSize"],
        newValue || void 0
      )
    );
  };
  const hasUserSetContentSizeValue = () => !!value?.layout?.contentSize;
  const resetContentSizeValue = () => setContentSizeValue(void 0);
  const showWideSizeControl = useHasWideSize(settings) && includeLayoutControls;
  const wideSizeValue = decodeValue(inheritedValue?.layout?.wideSize);
  const setWideSizeValue = (newValue) => {
    onChange(
      setImmutably(
        value,
        ["layout", "wideSize"],
        newValue || void 0
      )
    );
  };
  const hasUserSetWideSizeValue = () => !!value?.layout?.wideSize;
  const resetWideSizeValue = () => setWideSizeValue(void 0);
  const showPaddingControl = useHasPadding(settings);
  const rawPadding = decodeValue(inheritedValue?.spacing?.padding);
  const paddingValues = splitStyleValue(rawPadding);
  const paddingSides = Array.isArray(settings?.spacing?.padding) ? settings?.spacing?.padding : settings?.spacing?.padding?.sides;
  const isAxialPadding = paddingSides && paddingSides.some((side) => AXIAL_SIDES.includes(side));
  const setPaddingValues = (newPaddingValues) => {
    const padding = filterValuesBySides(newPaddingValues, paddingSides);
    onChange(setImmutably(value, ["spacing", "padding"], padding));
  };
  const hasPaddingValue = () => !!value?.spacing?.padding && Object.keys(value?.spacing?.padding).length;
  const resetPaddingValue = () => setPaddingValues(void 0);
  const onMouseOverPadding = () => onVisualize("padding");
  const showMarginControl = useHasMargin(settings);
  const rawMargin = decodeValue(inheritedValue?.spacing?.margin);
  const marginValues = splitStyleValue(rawMargin);
  const marginSides = Array.isArray(settings?.spacing?.margin) ? settings?.spacing?.margin : settings?.spacing?.margin?.sides;
  const isAxialMargin = marginSides && marginSides.some((side) => AXIAL_SIDES.includes(side));
  const setMarginValues = (newMarginValues) => {
    const margin = filterValuesBySides(newMarginValues, marginSides);
    onChange(setImmutably(value, ["spacing", "margin"], margin));
  };
  const hasMarginValue = () => !!value?.spacing?.margin && Object.keys(value?.spacing?.margin).length;
  const resetMarginValue = () => setMarginValues(void 0);
  const onMouseOverMargin = () => onVisualize("margin");
  const showGapControl = useHasGap(settings);
  const gapSides = Array.isArray(settings?.spacing?.blockGap) ? settings?.spacing?.blockGap : settings?.spacing?.blockGap?.sides;
  const isAxialGap = gapSides && gapSides.some((side) => AXIAL_SIDES.includes(side));
  const gapValue = decodeValue(inheritedValue?.spacing?.blockGap);
  const gapValues = splitGapValue(gapValue, isAxialGap);
  const setGapValue = (newGapValue) => {
    onChange(
      setImmutably(value, ["spacing", "blockGap"], newGapValue)
    );
  };
  const setGapValues = (nextBoxGapValue) => {
    if (!nextBoxGapValue) {
      setGapValue(null);
    }
    if (!isAxialGap && nextBoxGapValue?.hasOwnProperty("top")) {
      setGapValue(nextBoxGapValue.top);
    } else {
      setGapValue({
        top: nextBoxGapValue?.top,
        left: nextBoxGapValue?.left
      });
    }
  };
  const resetGapValue = () => setGapValue(void 0);
  const hasGapValue = () => !!value?.spacing?.blockGap;
  const showMinHeightControl = useHasMinHeight(settings);
  const minHeightValue = decodeValue(inheritedValue?.dimensions?.minHeight);
  const setMinHeightValue = (newValue) => {
    const tempValue = setImmutably(
      value,
      ["dimensions", "minHeight"],
      newValue
    );
    onChange(
      setImmutably(
        tempValue,
        ["dimensions", "aspectRatio"],
        void 0
      )
    );
  };
  const resetMinHeightValue = () => {
    setMinHeightValue(void 0);
  };
  const hasMinHeightValue = () => !!value?.dimensions?.minHeight;
  const showAspectRatioControl = useHasAspectRatio(settings);
  const aspectRatioValue = decodeValue(
    inheritedValue?.dimensions?.aspectRatio
  );
  const setAspectRatioValue = (newValue) => {
    const tempValue = setImmutably(
      value,
      ["dimensions", "aspectRatio"],
      newValue
    );
    onChange(
      setImmutably(tempValue, ["dimensions", "minHeight"], void 0)
    );
  };
  const hasAspectRatioValue = () => !!value?.dimensions?.aspectRatio;
  const showChildLayoutControl = useHasChildLayout(settings);
  const childLayout = inheritedValue?.layout;
  const setChildLayout = (newChildLayout) => {
    onChange({
      ...value,
      layout: {
        ...newChildLayout
      }
    });
  };
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      layout: utils_cleanEmptyObject({
        ...previousValue?.layout,
        contentSize: void 0,
        wideSize: void 0,
        selfStretch: void 0,
        flexSize: void 0,
        columnStart: void 0,
        rowStart: void 0,
        columnSpan: void 0,
        rowSpan: void 0
      }),
      spacing: {
        ...previousValue?.spacing,
        padding: void 0,
        margin: void 0,
        blockGap: void 0
      },
      dimensions: {
        ...previousValue?.dimensions,
        minHeight: void 0,
        aspectRatio: void 0
      }
    };
  }, []);
  const onMouseLeaveControls = () => onVisualize(false);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      children: [
        (showContentSizeControl || showWideSizeControl) && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "span-columns", children: (0,external_wp_i18n_namespaceObject.__)("Set the width of the main content area.") }),
        showContentSizeControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Content width"),
            hasValue: hasUserSetContentSizeValue,
            onDeselect: resetContentSizeValue,
            isShownByDefault: defaultControls.contentSize ?? dimensions_panel_DEFAULT_CONTROLS.contentSize,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalUnitControl,
              {
                __next40pxDefaultSize: true,
                label: (0,external_wp_i18n_namespaceObject.__)("Content width"),
                labelPosition: "top",
                value: contentSizeValue || "",
                onChange: (nextContentSize) => {
                  setContentSizeValue(nextContentSize);
                },
                units,
                prefix: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlPrefixWrapper, { variant: "icon", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: align_none_default }) })
              }
            )
          }
        ),
        showWideSizeControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Wide width"),
            hasValue: hasUserSetWideSizeValue,
            onDeselect: resetWideSizeValue,
            isShownByDefault: defaultControls.wideSize ?? dimensions_panel_DEFAULT_CONTROLS.wideSize,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.__experimentalUnitControl,
              {
                __next40pxDefaultSize: true,
                label: (0,external_wp_i18n_namespaceObject.__)("Wide width"),
                labelPosition: "top",
                value: wideSizeValue || "",
                onChange: (nextWideSize) => {
                  setWideSizeValue(nextWideSize);
                },
                units,
                prefix: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalInputControlPrefixWrapper, { variant: "icon", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: stretch_wide_default }) })
              }
            )
          }
        ),
        showPaddingControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: hasPaddingValue,
            label: (0,external_wp_i18n_namespaceObject.__)("Padding"),
            onDeselect: resetPaddingValue,
            isShownByDefault: defaultControls.padding ?? dimensions_panel_DEFAULT_CONTROLS.padding,
            className: dist_clsx({
              "tools-panel-item-spacing": showSpacingPresetsControl
            }),
            panelId,
            children: [
              !showSpacingPresetsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.BoxControl,
                {
                  __next40pxDefaultSize: true,
                  values: paddingValues,
                  onChange: setPaddingValues,
                  label: (0,external_wp_i18n_namespaceObject.__)("Padding"),
                  sides: paddingSides,
                  units,
                  allowReset: false,
                  splitOnAxis: isAxialPadding,
                  inputProps: {
                    onMouseOver: onMouseOverPadding,
                    onMouseOut: onMouseLeaveControls
                  }
                }
              ),
              showSpacingPresetsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                SpacingSizesControl,
                {
                  values: paddingValues,
                  onChange: setPaddingValues,
                  label: (0,external_wp_i18n_namespaceObject.__)("Padding"),
                  sides: paddingSides,
                  units,
                  allowReset: false,
                  onMouseOver: onMouseOverPadding,
                  onMouseOut: onMouseLeaveControls
                }
              )
            ]
          }
        ),
        showMarginControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: hasMarginValue,
            label: (0,external_wp_i18n_namespaceObject.__)("Margin"),
            onDeselect: resetMarginValue,
            isShownByDefault: defaultControls.margin ?? dimensions_panel_DEFAULT_CONTROLS.margin,
            className: dist_clsx({
              "tools-panel-item-spacing": showSpacingPresetsControl
            }),
            panelId,
            children: [
              !showSpacingPresetsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.BoxControl,
                {
                  __next40pxDefaultSize: true,
                  values: marginValues,
                  onChange: setMarginValues,
                  inputProps: {
                    min: minMarginValue,
                    onDragStart: () => {
                      setMinMarginValue(0);
                    },
                    onDragEnd: () => {
                      setMinMarginValue(minimumMargin);
                    },
                    onMouseOver: onMouseOverMargin,
                    onMouseOut: onMouseLeaveControls
                  },
                  label: (0,external_wp_i18n_namespaceObject.__)("Margin"),
                  sides: marginSides,
                  units,
                  allowReset: false,
                  splitOnAxis: isAxialMargin
                }
              ),
              showSpacingPresetsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                SpacingSizesControl,
                {
                  values: marginValues,
                  onChange: setMarginValues,
                  minimumCustomValue: -Infinity,
                  label: (0,external_wp_i18n_namespaceObject.__)("Margin"),
                  sides: marginSides,
                  units,
                  allowReset: false,
                  onMouseOver: onMouseOverMargin,
                  onMouseOut: onMouseLeaveControls
                }
              )
            ]
          }
        ),
        showGapControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: hasGapValue,
            label: (0,external_wp_i18n_namespaceObject.__)("Block spacing"),
            onDeselect: resetGapValue,
            isShownByDefault: defaultControls.blockGap ?? dimensions_panel_DEFAULT_CONTROLS.blockGap,
            className: dist_clsx({
              "tools-panel-item-spacing": showSpacingPresetsControl,
              "single-column": (
                // If UnitControl is used, should be single-column.
                !showSpacingPresetsControl && !isAxialGap
              )
            }),
            panelId,
            children: [
              !showSpacingPresetsControl && (isAxialGap ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.BoxControl,
                {
                  __next40pxDefaultSize: true,
                  label: (0,external_wp_i18n_namespaceObject.__)("Block spacing"),
                  min: 0,
                  onChange: setGapValues,
                  units,
                  sides: gapSides,
                  values: gapValues,
                  allowReset: false,
                  splitOnAxis: isAxialGap
                }
              ) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.__experimentalUnitControl,
                {
                  __next40pxDefaultSize: true,
                  label: (0,external_wp_i18n_namespaceObject.__)("Block spacing"),
                  min: 0,
                  onChange: setGapValue,
                  units,
                  value: gapValue
                }
              )),
              showSpacingPresetsControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                SpacingSizesControl,
                {
                  label: (0,external_wp_i18n_namespaceObject.__)("Block spacing"),
                  min: 0,
                  onChange: setGapValues,
                  showSideInLabel: false,
                  sides: isAxialGap ? gapSides : ["top"],
                  values: gapValues,
                  allowReset: false
                }
              )
            ]
          }
        ),
        showChildLayoutControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          ChildLayoutControl,
          {
            value: childLayout,
            onChange: setChildLayout,
            parentLayout: settings?.parentLayout,
            panelId,
            isShownByDefault: defaultControls.childLayout ?? dimensions_panel_DEFAULT_CONTROLS.childLayout
          }
        ),
        showMinHeightControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.__experimentalToolsPanelItem,
          {
            hasValue: hasMinHeightValue,
            label: (0,external_wp_i18n_namespaceObject.__)("Minimum height"),
            onDeselect: resetMinHeightValue,
            isShownByDefault: defaultControls.minHeight ?? dimensions_panel_DEFAULT_CONTROLS.minHeight,
            panelId,
            children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              HeightControl,
              {
                label: (0,external_wp_i18n_namespaceObject.__)("Minimum height"),
                value: minHeightValue,
                onChange: setMinHeightValue
              }
            )
          }
        ),
        showAspectRatioControl && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          AspectRatioTool,
          {
            hasValue: hasAspectRatioValue,
            value: aspectRatioValue,
            onChange: setAspectRatioValue,
            panelId,
            isShownByDefault: defaultControls.aspectRatio ?? dimensions_panel_DEFAULT_CONTROLS.aspectRatio
          }
        )
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-popover/use-popover-scroll.js


const scrollContainerCache = /* @__PURE__ */ new WeakMap();
function usePopoverScroll(contentRef) {
  const effect = (0,external_wp_compose_namespaceObject.useRefEffect)(
    (node) => {
      function onWheel(event) {
        const { deltaX, deltaY, target } = event;
        const contentEl = contentRef.current;
        let scrollContainer = scrollContainerCache.get(contentEl);
        if (!scrollContainer) {
          scrollContainer = (0,external_wp_dom_namespaceObject.getScrollContainer)(contentEl);
          scrollContainerCache.set(contentEl, scrollContainer);
        }
        const eventScrollContainer = (0,external_wp_dom_namespaceObject.getScrollContainer)(target);
        if (!node.contains(eventScrollContainer)) {
          scrollContainer.scrollBy(deltaX, deltaY);
        }
      }
      const options = { passive: true };
      node.addEventListener("wheel", onWheel, options);
      return () => {
        node.removeEventListener("wheel", onWheel, options);
      };
    },
    [contentRef]
  );
  return contentRef ? effect : null;
}
var use_popover_scroll_default = usePopoverScroll;


;// ./node_modules/@wordpress/block-editor/build-module/utils/dom.js
const BLOCK_SELECTOR = ".block-editor-block-list__block";
const APPENDER_SELECTOR = ".block-list-appender";
const BLOCK_APPENDER_CLASS = ".block-editor-button-block-appender";
function isInSameBlock(a, b) {
  return a.closest(BLOCK_SELECTOR) === b.closest(BLOCK_SELECTOR);
}
function isInsideRootBlock(blockElement, element) {
  const parentBlock = element.closest(
    [BLOCK_SELECTOR, APPENDER_SELECTOR, BLOCK_APPENDER_CLASS].join(",")
  );
  return parentBlock === blockElement;
}
function getBlockClientId(node) {
  while (node && node.nodeType !== node.ELEMENT_NODE) {
    node = node.parentNode;
  }
  if (!node) {
    return;
  }
  const elementNode = (
    /** @type {Element} */
    node
  );
  const blockNode = elementNode.closest(BLOCK_SELECTOR);
  if (!blockNode) {
    return;
  }
  return blockNode.id.slice("block-".length);
}
function rectUnion(rect1, rect2) {
  const left = Math.min(rect1.left, rect2.left);
  const right = Math.max(rect1.right, rect2.right);
  const bottom = Math.max(rect1.bottom, rect2.bottom);
  const top = Math.min(rect1.top, rect2.top);
  return new window.DOMRectReadOnly(left, top, right - left, bottom - top);
}
function isElementVisible(element) {
  const viewport = element.ownerDocument.defaultView;
  if (!viewport) {
    return false;
  }
  if (element.classList.contains("components-visually-hidden")) {
    return false;
  }
  const bounds = element.getBoundingClientRect();
  if (bounds.width === 0 || bounds.height === 0) {
    return false;
  }
  if (element.checkVisibility) {
    return element.checkVisibility?.({
      opacityProperty: true,
      contentVisibilityAuto: true,
      visibilityProperty: true
    });
  }
  const style = viewport.getComputedStyle(element);
  if (style.display === "none" || style.visibility === "hidden" || style.opacity === "0") {
    return false;
  }
  return true;
}
function isScrollable(element) {
  const style = window.getComputedStyle(element);
  return style.overflowX === "auto" || style.overflowX === "scroll" || style.overflowY === "auto" || style.overflowY === "scroll";
}
const WITH_OVERFLOW_ELEMENT_BLOCKS = ["core/navigation"];
function getElementBounds(element) {
  const viewport = element.ownerDocument.defaultView;
  if (!viewport) {
    return new window.DOMRectReadOnly();
  }
  let bounds = element.getBoundingClientRect();
  const dataType = element.getAttribute("data-type");
  if (dataType && WITH_OVERFLOW_ELEMENT_BLOCKS.includes(dataType)) {
    const stack = [element];
    let currentElement;
    while (currentElement = stack.pop()) {
      if (!isScrollable(currentElement)) {
        for (const child of currentElement.children) {
          if (isElementVisible(child)) {
            const childBounds = child.getBoundingClientRect();
            bounds = rectUnion(bounds, childBounds);
            stack.push(child);
          }
        }
      }
    }
  }
  const left = Math.max(bounds.left, 0);
  const right = Math.min(bounds.right, viewport.innerWidth);
  bounds = new window.DOMRectReadOnly(
    left,
    bounds.top,
    right - left,
    bounds.height
  );
  return bounds;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/block-popover/index.js








const MAX_POPOVER_RECOMPUTE_COUNTER = Number.MAX_SAFE_INTEGER;
function BlockPopover({
  clientId,
  bottomClientId,
  children,
  __unstablePopoverSlot,
  __unstableContentRef,
  shift = true,
  ...props
}, ref) {
  const selectedElement = useBlockElement(clientId);
  const lastSelectedElement = useBlockElement(bottomClientId ?? clientId);
  const mergedRefs = (0,external_wp_compose_namespaceObject.useMergeRefs)([
    ref,
    use_popover_scroll_default(__unstableContentRef)
  ]);
  const [
    popoverDimensionsRecomputeCounter,
    forceRecomputePopoverDimensions
  ] = (0,external_wp_element_namespaceObject.useReducer)(
    // Module is there to make sure that the counter doesn't overflow.
    (s) => (s + 1) % MAX_POPOVER_RECOMPUTE_COUNTER,
    0
  );
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!selectedElement) {
      return;
    }
    const observer = new window.MutationObserver(
      forceRecomputePopoverDimensions
    );
    observer.observe(selectedElement, { attributes: true });
    return () => {
      observer.disconnect();
    };
  }, [selectedElement]);
  const popoverAnchor = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (
      // popoverDimensionsRecomputeCounter is by definition always equal or greater
      // than 0. This check is only there to satisfy the correctness of the
      // exhaustive-deps rule for the `useMemo` hook.
      popoverDimensionsRecomputeCounter < 0 || !selectedElement || bottomClientId && !lastSelectedElement
    ) {
      return void 0;
    }
    return {
      getBoundingClientRect() {
        return lastSelectedElement ? rectUnion(
          getElementBounds(selectedElement),
          getElementBounds(lastSelectedElement)
        ) : getElementBounds(selectedElement);
      },
      contextElement: selectedElement
    };
  }, [
    popoverDimensionsRecomputeCounter,
    selectedElement,
    bottomClientId,
    lastSelectedElement
  ]);
  if (!selectedElement || bottomClientId && !lastSelectedElement) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Popover,
    {
      ref: mergedRefs,
      animate: false,
      focusOnMount: false,
      anchor: popoverAnchor,
      __unstableSlotName: __unstablePopoverSlot,
      inline: !__unstablePopoverSlot,
      placement: "top-start",
      resize: false,
      flip: false,
      shift,
      ...props,
      className: dist_clsx("block-editor-block-popover", props.className),
      variant: "unstyled",
      children
    }
  );
}
const PrivateBlockPopover = (0,external_wp_element_namespaceObject.forwardRef)(BlockPopover);
const PublicBlockPopover = ({ clientId, bottomClientId, children, ...props }, ref) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  PrivateBlockPopover,
  {
    ...props,
    bottomClientId,
    clientId,
    __unstableContentRef: void 0,
    __unstablePopoverSlot: void 0,
    ref,
    children
  }
);
var block_popover_default = (0,external_wp_element_namespaceObject.forwardRef)(PublicBlockPopover);


;// ./node_modules/@wordpress/block-editor/build-module/components/block-popover/cover.js




function BlockPopoverCover({
  clientId,
  bottomClientId,
  children,
  shift = false,
  additionalStyles,
  ...props
}, ref) {
  bottomClientId ??= clientId;
  const selectedElement = useBlockElement(clientId);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    PrivateBlockPopover,
    {
      ref,
      clientId,
      bottomClientId,
      shift,
      ...props,
      children: selectedElement && clientId === bottomClientId ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        CoverContainer,
        {
          selectedElement,
          additionalStyles,
          children
        }
      ) : children
    }
  );
}
function CoverContainer({
  selectedElement,
  additionalStyles = {},
  children
}) {
  const [width, setWidth] = (0,external_wp_element_namespaceObject.useState)(selectedElement.offsetWidth);
  const [height, setHeight] = (0,external_wp_element_namespaceObject.useState)(selectedElement.offsetHeight);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const observer = new window.ResizeObserver(() => {
      setWidth(selectedElement.offsetWidth);
      setHeight(selectedElement.offsetHeight);
    });
    observer.observe(selectedElement, { box: "border-box" });
    return () => observer.disconnect();
  }, [selectedElement]);
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      position: "absolute",
      width,
      height,
      ...additionalStyles
    };
  }, [width, height, additionalStyles]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { style, children });
}
var cover_default = (0,external_wp_element_namespaceObject.forwardRef)(BlockPopoverCover);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/spacing-visualizer.js





function SpacingVisualizer({ clientId, value, computeStyle, forceShow }) {
  const blockElement = useBlockElement(clientId);
  const [style, updateStyle] = (0,external_wp_element_namespaceObject.useReducer)(
    () => computeStyle(blockElement)
  );
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!blockElement) {
      return;
    }
    const observer = new window.MutationObserver(updateStyle);
    observer.observe(blockElement, {
      attributes: true,
      attributeFilter: ["style", "class"]
    });
    return () => {
      observer.disconnect();
    };
  }, [blockElement]);
  const previousValueRef = (0,external_wp_element_namespaceObject.useRef)(value);
  const [isActive, setIsActive] = (0,external_wp_element_namespaceObject.useState)(false);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (external_wp_isShallowEqual_default()(value, previousValueRef.current) || forceShow) {
      return;
    }
    setIsActive(true);
    previousValueRef.current = value;
    const timeout = setTimeout(() => {
      setIsActive(false);
    }, 400);
    return () => {
      setIsActive(false);
      clearTimeout(timeout);
    };
  }, [value, forceShow]);
  if (!isActive && !forceShow) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    cover_default,
    {
      clientId,
      __unstablePopoverSlot: "block-toolbar",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor__spacing-visualizer", style })
    }
  );
}
function getComputedCSS(element, property) {
  return element.ownerDocument.defaultView.getComputedStyle(element).getPropertyValue(property);
}
function MarginVisualizer({ clientId, value, forceShow }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    SpacingVisualizer,
    {
      clientId,
      value: value?.spacing?.margin,
      computeStyle: (blockElement) => {
        const top = getComputedCSS(blockElement, "margin-top");
        const right = getComputedCSS(blockElement, "margin-right");
        const bottom = getComputedCSS(blockElement, "margin-bottom");
        const left = getComputedCSS(blockElement, "margin-left");
        return {
          borderTopWidth: top,
          borderRightWidth: right,
          borderBottomWidth: bottom,
          borderLeftWidth: left,
          top: top ? `-${top}` : 0,
          right: right ? `-${right}` : 0,
          bottom: bottom ? `-${bottom}` : 0,
          left: left ? `-${left}` : 0
        };
      },
      forceShow
    }
  );
}
function PaddingVisualizer({ clientId, value, forceShow }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    SpacingVisualizer,
    {
      clientId,
      value: value?.spacing?.padding,
      computeStyle: (blockElement) => ({
        borderTopWidth: getComputedCSS(blockElement, "padding-top"),
        borderRightWidth: getComputedCSS(
          blockElement,
          "padding-right"
        ),
        borderBottomWidth: getComputedCSS(
          blockElement,
          "padding-bottom"
        ),
        borderLeftWidth: getComputedCSS(blockElement, "padding-left")
      }),
      forceShow
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/dimensions.js












const DIMENSIONS_SUPPORT_KEY = "dimensions";
const SPACING_SUPPORT_KEY = "spacing";
const dimensions_ALL_SIDES = (/* unused pure expression or super */ null && (["top", "right", "bottom", "left"]));
const dimensions_AXIAL_SIDES = (/* unused pure expression or super */ null && (["vertical", "horizontal"]));
function useVisualizer() {
  const [property, setProperty] = (0,external_wp_element_namespaceObject.useState)(false);
  const { hideBlockInterface, showBlockInterface } = unlock(
    (0,external_wp_data_namespaceObject.useDispatch)(store)
  );
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!property) {
      showBlockInterface();
    } else {
      hideBlockInterface();
    }
  }, [property, showBlockInterface, hideBlockInterface]);
  return [property, setProperty];
}
function DimensionsInspectorControl({ children, resetAllFilter }) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(
    (attributes) => {
      const existingStyle = attributes.style;
      const updatedStyle = resetAllFilter(existingStyle);
      return {
        ...attributes,
        style: updatedStyle
      };
    },
    [resetAllFilter]
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    inspector_controls_default,
    {
      group: "dimensions",
      resetAllFilter: attributesResetAllFilter,
      children
    }
  );
}
function dimensions_DimensionsPanel({ clientId, name, setAttributes, settings }) {
  const isEnabled = useHasDimensionsPanel(settings);
  const value = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).getBlockAttributes(clientId)?.style,
    [clientId]
  );
  const [visualizedProperty, setVisualizedProperty] = useVisualizer();
  const onChange = (newStyle) => {
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };
  if (!isEnabled) {
    return null;
  }
  const defaultDimensionsControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    DIMENSIONS_SUPPORT_KEY,
    "__experimentalDefaultControls"
  ]);
  const defaultSpacingControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [
    SPACING_SUPPORT_KEY,
    "__experimentalDefaultControls"
  ]);
  const defaultControls = {
    ...defaultDimensionsControls,
    ...defaultSpacingControls
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      DimensionsPanel,
      {
        as: DimensionsInspectorControl,
        panelId: clientId,
        settings,
        value,
        onChange,
        defaultControls,
        onVisualize: setVisualizedProperty
      }
    ),
    !!settings?.spacing?.padding && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      PaddingVisualizer,
      {
        forceShow: visualizedProperty === "padding",
        clientId,
        value
      }
    ),
    !!settings?.spacing?.margin && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      MarginVisualizer,
      {
        forceShow: visualizedProperty === "margin",
        clientId,
        value
      }
    )
  ] });
}
function hasDimensionsSupport(blockName, feature = "any") {
  if (external_wp_element_namespaceObject.Platform.OS !== "web") {
    return false;
  }
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, DIMENSIONS_SUPPORT_KEY);
  if (support === true) {
    return true;
  }
  if (feature === "any") {
    return !!(support?.aspectRatio || !!support?.minHeight);
  }
  return !!support?.[feature];
}
var dimensions_default = {
  useBlockProps: dimensions_useBlockProps,
  attributeKeys: ["minHeight", "style"],
  hasSupport(name) {
    return hasDimensionsSupport(name, "aspectRatio");
  }
};
function dimensions_useBlockProps({ name, minHeight, style }) {
  if (!hasDimensionsSupport(name, "aspectRatio") || shouldSkipSerialization(name, DIMENSIONS_SUPPORT_KEY, "aspectRatio")) {
    return {};
  }
  const className = dist_clsx({
    "has-aspect-ratio": !!style?.dimensions?.aspectRatio
  });
  const inlineStyleOverrides = {};
  if (style?.dimensions?.aspectRatio) {
    inlineStyleOverrides.minHeight = "unset";
  } else if (minHeight || style?.dimensions?.minHeight) {
    inlineStyleOverrides.aspectRatio = "unset";
  }
  return { className, style: inlineStyleOverrides };
}
function useCustomSides() {
  external_wp_deprecated_default()("wp.blockEditor.__experimentalUseCustomSides", {
    since: "6.3",
    version: "6.4"
  });
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/style.js














const styleSupportKeys = [
  ...TYPOGRAPHY_SUPPORT_KEYS,
  BORDER_SUPPORT_KEY,
  COLOR_SUPPORT_KEY,
  DIMENSIONS_SUPPORT_KEY,
  BACKGROUND_SUPPORT_KEY,
  SPACING_SUPPORT_KEY,
  SHADOW_SUPPORT_KEY
];
const hasStyleSupport = (nameOrType) => styleSupportKeys.some((key) => (0,external_wp_blocks_namespaceObject.hasBlockSupport)(nameOrType, key));
function getInlineStyles(styles = {}) {
  const output = {};
  (0,external_wp_styleEngine_namespaceObject.getCSSRules)(styles).forEach((rule) => {
    output[rule.key] = rule.value;
  });
  return output;
}
function style_addAttribute(settings) {
  if (!hasStyleSupport(settings)) {
    return settings;
  }
  if (!settings.attributes.style) {
    Object.assign(settings.attributes, {
      style: {
        type: "object"
      }
    });
  }
  return settings;
}
const skipSerializationPathsEdit = {
  [`${BORDER_SUPPORT_KEY}.__experimentalSkipSerialization`]: ["border"],
  [`${COLOR_SUPPORT_KEY}.__experimentalSkipSerialization`]: [
    COLOR_SUPPORT_KEY
  ],
  [`${TYPOGRAPHY_SUPPORT_KEY}.__experimentalSkipSerialization`]: [
    TYPOGRAPHY_SUPPORT_KEY
  ],
  [`${DIMENSIONS_SUPPORT_KEY}.__experimentalSkipSerialization`]: [
    DIMENSIONS_SUPPORT_KEY
  ],
  [`${SPACING_SUPPORT_KEY}.__experimentalSkipSerialization`]: [
    SPACING_SUPPORT_KEY
  ],
  [`${SHADOW_SUPPORT_KEY}.__experimentalSkipSerialization`]: [
    SHADOW_SUPPORT_KEY
  ]
};
const skipSerializationPathsSave = {
  ...skipSerializationPathsEdit,
  [`${DIMENSIONS_SUPPORT_KEY}.aspectRatio`]: [
    `${DIMENSIONS_SUPPORT_KEY}.aspectRatio`
  ],
  // Skip serialization of aspect ratio in save mode.
  [`${BACKGROUND_SUPPORT_KEY}`]: [BACKGROUND_SUPPORT_KEY]
  // Skip serialization of background support in save mode.
};
const skipSerializationPathsSaveChecks = {
  [`${DIMENSIONS_SUPPORT_KEY}.aspectRatio`]: true,
  [`${BACKGROUND_SUPPORT_KEY}`]: true
};
const renamedFeatures = { gradients: "gradient" };
function omitStyle(style, paths, preserveReference = false) {
  if (!style) {
    return style;
  }
  let newStyle = style;
  if (!preserveReference) {
    newStyle = JSON.parse(JSON.stringify(style));
  }
  if (!Array.isArray(paths)) {
    paths = [paths];
  }
  paths.forEach((path) => {
    if (!Array.isArray(path)) {
      path = path.split(".");
    }
    if (path.length > 1) {
      const [firstSubpath, ...restPath] = path;
      omitStyle(newStyle[firstSubpath], [restPath], true);
    } else if (path.length === 1) {
      delete newStyle[path[0]];
    }
  });
  return newStyle;
}
function style_addSaveProps(props, blockNameOrType, attributes, skipPaths = skipSerializationPathsSave) {
  if (!hasStyleSupport(blockNameOrType)) {
    return props;
  }
  let { style } = attributes;
  Object.entries(skipPaths).forEach(([indicator, path]) => {
    const skipSerialization = skipSerializationPathsSaveChecks[indicator] || (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, indicator);
    if (skipSerialization === true) {
      style = omitStyle(style, path);
    }
    if (Array.isArray(skipSerialization)) {
      skipSerialization.forEach((featureName) => {
        const feature = renamedFeatures[featureName] || featureName;
        style = omitStyle(style, [[...path, feature]]);
      });
    }
  });
  props.style = {
    ...getInlineStyles(style),
    ...props.style
  };
  return props;
}
function BlockStyleControls({
  clientId,
  name,
  setAttributes,
  __unstableParentLayout
}) {
  const settings = useBlockSettings(name, __unstableParentLayout);
  const blockEditingMode = useBlockEditingMode();
  const passedProps = {
    clientId,
    name,
    setAttributes,
    settings: {
      ...settings,
      typography: {
        ...settings.typography,
        // The text alignment UI for individual blocks is rendered in
        // the block toolbar, so disable it here.
        textAlign: false
      }
    }
  };
  if (blockEditingMode !== "default") {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorEdit, { ...passedProps }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(background_BackgroundImagePanel, { ...passedProps }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(typography_TypographyPanel, { ...passedProps }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(border_BorderPanel, { ...passedProps }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(dimensions_DimensionsPanel, { ...passedProps })
  ] });
}
var style_default = {
  edit: BlockStyleControls,
  hasSupport: hasStyleSupport,
  addSaveProps: style_addSaveProps,
  attributeKeys: ["style"],
  useBlockProps: style_useBlockProps
};
const elementTypes = [
  { elementType: "button" },
  { elementType: "link", pseudo: [":hover"] },
  {
    elementType: "heading",
    elements: ["h1", "h2", "h3", "h4", "h5", "h6"]
  }
];
const STYLE_BLOCK_PROPS_REFERENCE = {};
function style_useBlockProps({ name, style }) {
  const blockElementsContainerIdentifier = (0,external_wp_compose_namespaceObject.useInstanceId)(
    STYLE_BLOCK_PROPS_REFERENCE,
    "wp-elements"
  );
  const baseElementSelector = `.${blockElementsContainerIdentifier}`;
  const blockElementStyles = style?.elements;
  const styles = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (!blockElementStyles) {
      return;
    }
    const elementCSSRules = [];
    elementTypes.forEach(({ elementType, pseudo, elements }) => {
      const skipSerialization = shouldSkipSerialization(
        name,
        COLOR_SUPPORT_KEY,
        elementType
      );
      if (skipSerialization) {
        return;
      }
      const elementStyles = blockElementStyles?.[elementType];
      if (elementStyles) {
        const selector = scopeSelector(
          baseElementSelector,
          external_wp_blocks_namespaceObject.__EXPERIMENTAL_ELEMENTS[elementType]
        );
        elementCSSRules.push(
          (0,external_wp_styleEngine_namespaceObject.compileCSS)(elementStyles, { selector })
        );
        if (pseudo) {
          pseudo.forEach((pseudoSelector) => {
            if (elementStyles[pseudoSelector]) {
              elementCSSRules.push(
                (0,external_wp_styleEngine_namespaceObject.compileCSS)(elementStyles[pseudoSelector], {
                  selector: scopeSelector(
                    baseElementSelector,
                    `${external_wp_blocks_namespaceObject.__EXPERIMENTAL_ELEMENTS[elementType]}${pseudoSelector}`
                  )
                })
              );
            }
          });
        }
      }
      if (elements) {
        elements.forEach((element) => {
          if (blockElementStyles[element]) {
            elementCSSRules.push(
              (0,external_wp_styleEngine_namespaceObject.compileCSS)(blockElementStyles[element], {
                selector: scopeSelector(
                  baseElementSelector,
                  external_wp_blocks_namespaceObject.__EXPERIMENTAL_ELEMENTS[element]
                )
              })
            );
          }
        });
      }
    });
    return elementCSSRules.length > 0 ? elementCSSRules.join("") : void 0;
  }, [baseElementSelector, blockElementStyles, name]);
  useStyleOverride({ css: styles });
  return style_addSaveProps(
    { className: blockElementsContainerIdentifier },
    name,
    { style },
    skipSerializationPathsEdit
  );
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/style/addAttribute",
  style_addAttribute
);


;// ./node_modules/@wordpress/block-editor/build-module/hooks/settings.js


const hasSettingsSupport = (blockType) => (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, "__experimentalSettings", false);
function settings_addAttribute(settings) {
  if (!hasSettingsSupport(settings)) {
    return settings;
  }
  if (!settings?.attributes?.settings) {
    settings.attributes = {
      ...settings.attributes,
      settings: {
        type: "object"
      }
    };
  }
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/settings/addAttribute",
  settings_addAttribute
);

;// ./node_modules/@wordpress/icons/build-module/library/filter.js


var filter_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M12 4 4 19h16L12 4zm0 3.2 5.5 10.3H12V7.2z" }) });


;// ./node_modules/@wordpress/block-editor/build-module/components/duotone-control/index.js






function DuotoneControl({
  id: idProp,
  colorPalette,
  duotonePalette,
  disableCustomColors,
  disableCustomDuotone,
  value,
  onChange
}) {
  let toolbarIcon;
  if (value === "unset") {
    toolbarIcon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ColorIndicator, { className: "block-editor-duotone-control__unset-indicator" });
  } else if (value) {
    toolbarIcon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.DuotoneSwatch, { values: value });
  } else {
    toolbarIcon = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(icon_default, { icon: filter_default });
  }
  const actionLabel = (0,external_wp_i18n_namespaceObject.__)("Apply duotone filter");
  const id = (0,external_wp_compose_namespaceObject.useInstanceId)(DuotoneControl, "duotone-control", idProp);
  const descriptionId = `${id}__description`;
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Dropdown,
    {
      popoverProps: {
        className: "block-editor-duotone-control__popover",
        headerTitle: (0,external_wp_i18n_namespaceObject.__)("Duotone")
      },
      renderToggle: ({ isOpen, onToggle }) => {
        const openOnArrowDown = (event) => {
          if (!isOpen && event.keyCode === external_wp_keycodes_namespaceObject.DOWN) {
            event.preventDefault();
            onToggle();
          }
        };
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.ToolbarButton,
          {
            showTooltip: true,
            onClick: onToggle,
            "aria-haspopup": "true",
            "aria-expanded": isOpen,
            onKeyDown: openOnArrowDown,
            label: actionLabel,
            icon: toolbarIcon
          }
        );
      },
      renderContent: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.MenuGroup, { label: (0,external_wp_i18n_namespaceObject.__)("Duotone"), children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { children: (0,external_wp_i18n_namespaceObject.__)(
          "Create a two-tone color effect without losing your original image."
        ) }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.DuotonePicker,
          {
            "aria-label": actionLabel,
            "aria-describedby": descriptionId,
            colorPalette,
            duotonePalette,
            disableCustomColors,
            disableCustomDuotone,
            value,
            onChange
          }
        )
      ] })
    }
  );
}
var duotone_control_default = DuotoneControl;


;// ./node_modules/@wordpress/block-editor/build-module/components/duotone/utils.js

function getValuesFromColors(colors = []) {
  const values = { r: [], g: [], b: [], a: [] };
  colors.forEach((color) => {
    const rgbColor = w(color).toRgb();
    values.r.push(rgbColor.r / 255);
    values.g.push(rgbColor.g / 255);
    values.b.push(rgbColor.b / 255);
    values.a.push(rgbColor.a);
  });
  return values;
}
function getDuotoneUnsetStylesheet(selector) {
  return `${selector}{filter:none}`;
}
function getDuotoneStylesheet(selector, id) {
  return `${selector}{filter:url(#${id})}`;
}
function getDuotoneFilter(id, colors) {
  const values = getValuesFromColors(colors);
  return `
<svg
	xmlns:xlink="http://www.w3.org/1999/xlink"
	viewBox="0 0 0 0"
	width="0"
	height="0"
	focusable="false"
	role="none"
	aria-hidden="true"
	style="visibility: hidden; position: absolute; left: -9999px; overflow: hidden;"
>
	<defs>
		<filter id="${id}">
			<!--
				Use sRGB instead of linearRGB so transparency looks correct.
				Use perceptual brightness to convert to grayscale.
			-->
			<feColorMatrix color-interpolation-filters="sRGB" type="matrix" values=" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 "></feColorMatrix>
			<!-- Use sRGB instead of linearRGB to be consistent with how CSS gradients work. -->
			<feComponentTransfer color-interpolation-filters="sRGB">
				<feFuncR type="table" tableValues="${values.r.join(" ")}"></feFuncR>
				<feFuncG type="table" tableValues="${values.g.join(" ")}"></feFuncG>
				<feFuncB type="table" tableValues="${values.b.join(" ")}"></feFuncB>
				<feFuncA type="table" tableValues="${values.a.join(" ")}"></feFuncA>
			</feComponentTransfer>
			<!-- Re-mask the image with the original transparency since the feColorMatrix above loses that information. -->
			<feComposite in2="SourceGraphic" operator="in"></feComposite>
		</filter>
	</defs>
</svg>`;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/get-block-css-selector.js


function getBlockCSSSelector(blockType, target = "root", options = {}) {
  if (!target) {
    return null;
  }
  const { fallback = false } = options;
  const { name, selectors, supports } = blockType;
  const hasSelectors = selectors && Object.keys(selectors).length > 0;
  const path = Array.isArray(target) ? target.join(".") : target;
  let rootSelector = null;
  if (hasSelectors && selectors.root) {
    rootSelector = selectors?.root;
  } else if (supports?.__experimentalSelector) {
    rootSelector = supports.__experimentalSelector;
  } else {
    rootSelector = ".wp-block-" + name.replace("core/", "").replace("/", "-");
  }
  if (path === "root") {
    return rootSelector;
  }
  const pathArray = Array.isArray(target) ? target : target.split(".");
  if (pathArray.length === 1) {
    const fallbackSelector = fallback ? rootSelector : null;
    if (hasSelectors) {
      const featureSelector2 = getValueFromObjectPath(selectors, `${path}.root`, null) || getValueFromObjectPath(selectors, path, null);
      return featureSelector2 || fallbackSelector;
    }
    const featureSelector = getValueFromObjectPath(
      supports,
      `${path}.__experimentalSelector`,
      null
    );
    if (!featureSelector) {
      return fallbackSelector;
    }
    return scopeSelector(rootSelector, featureSelector);
  }
  let subfeatureSelector;
  if (hasSelectors) {
    subfeatureSelector = getValueFromObjectPath(selectors, path, null);
  }
  if (subfeatureSelector) {
    return subfeatureSelector;
  }
  if (fallback) {
    return getBlockCSSSelector(blockType, pathArray[0], options);
  }
  return null;
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/filters-panel.js








const filters_panel_EMPTY_ARRAY = [];
function useMultiOriginColorPresets(settings, { presetSetting, defaultSetting }) {
  const disableDefault = !settings?.color?.[defaultSetting];
  const userPresets = settings?.color?.[presetSetting]?.custom || filters_panel_EMPTY_ARRAY;
  const themePresets = settings?.color?.[presetSetting]?.theme || filters_panel_EMPTY_ARRAY;
  const defaultPresets = settings?.color?.[presetSetting]?.default || filters_panel_EMPTY_ARRAY;
  return (0,external_wp_element_namespaceObject.useMemo)(
    () => [
      ...userPresets,
      ...themePresets,
      ...disableDefault ? filters_panel_EMPTY_ARRAY : defaultPresets
    ],
    [disableDefault, userPresets, themePresets, defaultPresets]
  );
}
function useHasFiltersPanel(settings) {
  return useHasDuotoneControl(settings);
}
function useHasDuotoneControl(settings) {
  return settings.color.customDuotone || settings.color.defaultDuotone || settings.color.duotone.length > 0;
}
function FiltersToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const dropdownMenuProps = useToolsPanelDropdownMenuProps();
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.__experimentalToolsPanel,
    {
      label: (0,external_wp_i18n_namespaceObject._x)("Filters", "Name for applying graphical effects"),
      resetAll,
      panelId,
      dropdownMenuProps,
      children
    }
  );
}
const filters_panel_DEFAULT_CONTROLS = {
  duotone: true
};
const filters_panel_popoverProps = {
  placement: "left-start",
  offset: 36,
  shift: true,
  className: "block-editor-duotone-control__popover",
  headerTitle: (0,external_wp_i18n_namespaceObject.__)("Duotone")
};
const LabeledColorIndicator = ({ indicator, label }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "flex-start", children: [
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalZStack, { isLayered: false, offset: -8, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, { expanded: false, children: indicator === "unset" || !indicator ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ColorIndicator, { className: "block-editor-duotone-control__unset-indicator" }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.DuotoneSwatch, { values: indicator }) }) }),
  /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, { title: label, children: label })
] });
const renderToggle = (duotone, resetDuotone) => ({ onToggle, isOpen }) => {
  const duotoneButtonRef = (0,external_wp_element_namespaceObject.useRef)(void 0);
  const toggleProps = {
    onClick: onToggle,
    className: dist_clsx(
      "block-editor-global-styles-filters-panel__dropdown-toggle",
      { "is-open": isOpen }
    ),
    "aria-expanded": isOpen,
    ref: duotoneButtonRef
  };
  const removeButtonProps = {
    onClick: () => {
      if (isOpen) {
        onToggle();
      }
      resetDuotone();
      duotoneButtonRef.current?.focus();
    },
    className: "block-editor-panel-duotone-settings__reset",
    label: (0,external_wp_i18n_namespaceObject.__)("Reset")
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, { __next40pxDefaultSize: true, ...toggleProps, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      LabeledColorIndicator,
      {
        indicator: duotone,
        label: (0,external_wp_i18n_namespaceObject.__)("Duotone")
      }
    ) }),
    duotone && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.Button,
      {
        size: "small",
        icon: reset_default,
        ...removeButtonProps
      }
    )
  ] });
};
function FiltersPanel({
  as: Wrapper = FiltersToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = filters_panel_DEFAULT_CONTROLS
}) {
  const decodeValue = (rawValue) => getValueFromVariable({ settings }, "", rawValue);
  const hasDuotoneEnabled = useHasDuotoneControl(settings);
  const duotonePalette = useMultiOriginColorPresets(settings, {
    presetSetting: "duotone",
    defaultSetting: "defaultDuotone"
  });
  const colorPalette = useMultiOriginColorPresets(settings, {
    presetSetting: "palette",
    defaultSetting: "defaultPalette"
  });
  const duotone = decodeValue(inheritedValue?.filter?.duotone);
  const setDuotone = (newValue) => {
    const duotonePreset = duotonePalette.find(({ colors }) => {
      return colors === newValue;
    });
    const duotoneValue = duotonePreset ? `var:preset|duotone|${duotonePreset.slug}` : newValue;
    onChange(
      setImmutably(value, ["filter", "duotone"], duotoneValue)
    );
  };
  const hasDuotone = () => !!value?.filter?.duotone;
  const resetDuotone = () => setDuotone(void 0);
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)((previousValue) => {
    return {
      ...previousValue,
      filter: {
        ...previousValue.filter,
        duotone: void 0
      }
    };
  }, []);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    Wrapper,
    {
      resetAllFilter,
      value,
      onChange,
      panelId,
      children: hasDuotoneEnabled && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.__experimentalToolsPanelItem,
        {
          label: (0,external_wp_i18n_namespaceObject.__)("Duotone"),
          hasValue: hasDuotone,
          onDeselect: resetDuotone,
          isShownByDefault: defaultControls.duotone,
          panelId,
          children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Dropdown,
            {
              popoverProps: filters_panel_popoverProps,
              className: "block-editor-global-styles-filters-panel__dropdown",
              renderToggle: renderToggle(duotone, resetDuotone),
              renderContent: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalDropdownContentWrapper, { paddingSize: "small", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.MenuGroup, { label: (0,external_wp_i18n_namespaceObject.__)("Duotone"), children: [
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { children: (0,external_wp_i18n_namespaceObject.__)(
                  "Create a two-tone color effect without losing your original image."
                ) }),
                /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                  external_wp_components_namespaceObject.DuotonePicker,
                  {
                    colorPalette,
                    duotonePalette,
                    disableCustomColors: true,
                    disableCustomDuotone: true,
                    value: duotone,
                    onChange: setDuotone
                  }
                )
              ] }) })
            }
          )
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/duotone.js















const duotone_EMPTY_ARRAY = [];
const isSafari = window?.navigator.userAgent && window.navigator.userAgent.includes("Safari") && !window.navigator.userAgent.includes("Chrome") && !window.navigator.userAgent.includes("Chromium");
k([names]);
function useMultiOriginPresets({ presetSetting, defaultSetting }) {
  const [enableDefault, userPresets, themePresets, defaultPresets] = use_settings_useSettings(
    defaultSetting,
    `${presetSetting}.custom`,
    `${presetSetting}.theme`,
    `${presetSetting}.default`
  );
  return (0,external_wp_element_namespaceObject.useMemo)(
    () => [
      ...userPresets || duotone_EMPTY_ARRAY,
      ...themePresets || duotone_EMPTY_ARRAY,
      ...enableDefault && defaultPresets || duotone_EMPTY_ARRAY
    ],
    [enableDefault, userPresets, themePresets, defaultPresets]
  );
}
function getColorsFromDuotonePreset(duotone, duotonePalette) {
  if (!duotone) {
    return;
  }
  const preset = duotonePalette?.find(({ slug }) => {
    return duotone === `var:preset|duotone|${slug}`;
  });
  return preset ? preset.colors : void 0;
}
function getDuotonePresetFromColors(colors, duotonePalette) {
  if (!colors || !Array.isArray(colors)) {
    return;
  }
  const preset = duotonePalette?.find((duotonePreset) => {
    return duotonePreset?.colors?.every(
      (val, index) => val === colors[index]
    );
  });
  return preset ? `var:preset|duotone|${preset.slug}` : void 0;
}
function DuotonePanelPure({ style, setAttributes, name }) {
  const duotoneStyle = style?.color?.duotone;
  const settings = useBlockSettings(name);
  const blockEditingMode = useBlockEditingMode();
  const duotonePalette = useMultiOriginPresets({
    presetSetting: "color.duotone",
    defaultSetting: "color.defaultDuotone"
  });
  const colorPalette = useMultiOriginPresets({
    presetSetting: "color.palette",
    defaultSetting: "color.defaultPalette"
  });
  const [enableCustomColors, enableCustomDuotone] = use_settings_useSettings(
    "color.custom",
    "color.customDuotone"
  );
  const disableCustomColors = !enableCustomColors;
  const disableCustomDuotone = !enableCustomDuotone || colorPalette?.length === 0 && disableCustomColors;
  if (duotonePalette?.length === 0 && disableCustomDuotone) {
    return null;
  }
  if (blockEditingMode !== "default") {
    return null;
  }
  const duotonePresetOrColors = duotoneStyle === "unset" || Array.isArray(duotoneStyle) ? duotoneStyle : getColorsFromDuotonePreset(duotoneStyle, duotonePalette);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls_default, { group: "filter", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      FiltersPanel,
      {
        value: { filter: { duotone: duotonePresetOrColors } },
        onChange: (newDuotone) => {
          const newStyle = {
            ...style,
            color: {
              ...newDuotone?.filter
            }
          };
          setAttributes({
            style: utils_cleanEmptyObject(newStyle)
          });
        },
        settings
      }
    ) }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls_default, { group: "block", __experimentalShareWithChildBlocks: true, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      duotone_control_default,
      {
        duotonePalette,
        colorPalette,
        disableCustomDuotone,
        disableCustomColors,
        value: duotonePresetOrColors,
        onChange: (newDuotone) => {
          const maybePreset = getDuotonePresetFromColors(
            newDuotone,
            duotonePalette
          );
          const newStyle = {
            ...style,
            color: {
              ...style?.color,
              duotone: maybePreset ?? newDuotone
              // use preset or fallback to custom colors.
            }
          };
          setAttributes({
            style: utils_cleanEmptyObject(newStyle)
          });
        },
        settings
      }
    ) })
  ] });
}
var duotone_default = {
  shareWithChildBlocks: true,
  edit: DuotonePanelPure,
  useBlockProps: duotone_useBlockProps,
  attributeKeys: ["style"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, "filter.duotone");
  }
};
function addDuotoneAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, "filter.duotone")) {
    return settings;
  }
  if (!settings.attributes.style) {
    Object.assign(settings.attributes, {
      style: {
        type: "object"
      }
    });
  }
  return settings;
}
function useDuotoneStyles({
  clientId,
  id: filterId,
  selector: duotoneSelector,
  attribute: duotoneAttr
}) {
  const duotonePalette = useMultiOriginPresets({
    presetSetting: "color.duotone",
    defaultSetting: "color.defaultDuotone"
  });
  const isCustom = Array.isArray(duotoneAttr);
  const duotonePreset = isCustom ? void 0 : getColorsFromDuotonePreset(duotoneAttr, duotonePalette);
  const isPreset = typeof duotoneAttr === "string" && duotonePreset;
  const isCSS = typeof duotoneAttr === "string" && !isPreset;
  let colors = null;
  if (isPreset) {
    colors = duotonePreset;
  } else if (isCSS) {
    colors = duotoneAttr;
  } else if (isCustom) {
    colors = duotoneAttr;
  }
  const selectors = duotoneSelector.split(",");
  const selectorsScoped = selectors.map((selectorPart) => {
    return `.${filterId}${selectorPart.trim()}`;
  });
  const selector = selectorsScoped.join(", ");
  const isValidFilter = Array.isArray(colors) || colors === "unset";
  usePrivateStyleOverride(
    isValidFilter ? {
      css: colors !== "unset" ? getDuotoneStylesheet(selector, filterId) : getDuotoneUnsetStylesheet(selector),
      __unstableType: "presets"
    } : void 0
  );
  usePrivateStyleOverride(
    isValidFilter ? {
      assets: colors !== "unset" ? getDuotoneFilter(filterId, colors) : "",
      __unstableType: "svgs"
    } : void 0
  );
  const blockElement = useBlockElement(clientId);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!isValidFilter) {
      return;
    }
    if (blockElement && isSafari) {
      const display = blockElement.style.display;
      blockElement.style.setProperty("display", "inline-block");
      blockElement.offsetHeight;
      blockElement.style.setProperty("display", display);
    }
  }, [isValidFilter, blockElement, colors]);
}
const DUOTONE_BLOCK_PROPS_REFERENCE = {};
function duotone_useBlockProps({ clientId, name, style }) {
  const id = (0,external_wp_compose_namespaceObject.useInstanceId)(DUOTONE_BLOCK_PROPS_REFERENCE);
  const selector = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
    if (blockType) {
      const duotoneSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(
        blockType,
        "filter.duotone",
        false
      );
      if (!duotoneSupport) {
        return null;
      }
      const experimentalDuotone = (0,external_wp_blocks_namespaceObject.getBlockSupport)(
        blockType,
        "color.__experimentalDuotone",
        false
      );
      if (experimentalDuotone) {
        const rootSelector = getBlockCSSSelector(blockType);
        return typeof experimentalDuotone === "string" ? scopeSelector(rootSelector, experimentalDuotone) : rootSelector;
      }
      return getBlockCSSSelector(blockType, "filter.duotone", {
        fallback: true
      });
    }
  }, [name]);
  const attribute = style?.color?.duotone;
  const filterClass = `wp-duotone-${id}`;
  const shouldRender = selector && attribute;
  useDuotoneStyles({
    clientId,
    id: filterClass,
    selector,
    attribute
  });
  return {
    className: shouldRender ? filterClass : ""
  };
}
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "core/editor/duotone/add-attributes",
  addDuotoneAttributes
);


;// ./node_modules/@wordpress/block-editor/build-module/components/use-block-display-information/index.js




function getPositionTypeLabel(attributes) {
  const positionType = attributes?.style?.position?.type;
  if (positionType === "sticky") {
    return (0,external_wp_i18n_namespaceObject.__)("Sticky");
  }
  if (positionType === "fixed") {
    return (0,external_wp_i18n_namespaceObject.__)("Fixed");
  }
  return null;
}
function useBlockDisplayInformation(clientId) {
  return (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      if (!clientId) {
        return null;
      }
      const { getBlockName, getBlockAttributes } = select(store);
      const { getBlockType, getActiveBlockVariation } = select(external_wp_blocks_namespaceObject.store);
      const blockName = getBlockName(clientId);
      const blockType = getBlockType(blockName);
      if (!blockType) {
        return null;
      }
      const attributes = getBlockAttributes(clientId);
      const match = getActiveBlockVariation(blockName, attributes);
      const isSynced = (0,external_wp_blocks_namespaceObject.isReusableBlock)(blockType) || (0,external_wp_blocks_namespaceObject.isTemplatePart)(blockType);
      const syncedTitle = isSynced ? (0,external_wp_blocks_namespaceObject.__experimentalGetBlockLabel)(blockType, attributes) : void 0;
      const title = syncedTitle || blockType.title;
      const positionLabel = getPositionTypeLabel(attributes);
      const blockTypeInfo = {
        isSynced,
        title,
        icon: blockType.icon,
        description: blockType.description,
        anchor: attributes?.anchor,
        positionLabel,
        positionType: attributes?.style?.position?.type,
        name: attributes?.metadata?.name
      };
      if (!match) {
        return blockTypeInfo;
      }
      return {
        isSynced,
        title: match.title || blockType.title,
        icon: match.icon || blockType.icon,
        description: match.description || blockType.description,
        anchor: attributes?.anchor,
        positionLabel,
        positionType: attributes?.style?.position?.type,
        name: attributes?.metadata?.name
      };
    },
    [clientId]
  );
}


;// ./node_modules/@wordpress/block-editor/build-module/hooks/position.js













const POSITION_SUPPORT_KEY = "position";
const DEFAULT_OPTION = {
  key: "default",
  value: "",
  name: (0,external_wp_i18n_namespaceObject.__)("Default")
};
const STICKY_OPTION = {
  key: "sticky",
  value: "sticky",
  name: (0,external_wp_i18n_namespaceObject._x)("Sticky", "Name for the value of the CSS position property"),
  hint: (0,external_wp_i18n_namespaceObject.__)(
    "The block will stick to the top of the window instead of scrolling."
  )
};
const FIXED_OPTION = {
  key: "fixed",
  value: "fixed",
  name: (0,external_wp_i18n_namespaceObject._x)("Fixed", "Name for the value of the CSS position property"),
  hint: (0,external_wp_i18n_namespaceObject.__)("The block will not move when the page is scrolled.")
};
const POSITION_SIDES = ["top", "right", "bottom", "left"];
const VALID_POSITION_TYPES = ["sticky", "fixed"];
function getPositionCSS({ selector, style }) {
  let output = "";
  const { type: positionType } = style?.position || {};
  if (!VALID_POSITION_TYPES.includes(positionType)) {
    return output;
  }
  output += `${selector} {`;
  output += `position: ${positionType};`;
  POSITION_SIDES.forEach((side) => {
    if (style?.position?.[side] !== void 0) {
      output += `${side}: ${style.position[side]};`;
    }
  });
  if (positionType === "sticky" || positionType === "fixed") {
    output += `z-index: 10`;
  }
  output += `}`;
  return output;
}
function hasStickyPositionSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, POSITION_SUPPORT_KEY);
  return !!(true === support || support?.sticky);
}
function hasFixedPositionSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, POSITION_SUPPORT_KEY);
  return !!(true === support || support?.fixed);
}
function hasPositionSupport(blockType) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, POSITION_SUPPORT_KEY);
  return !!support;
}
function hasPositionValue(props) {
  return props.attributes.style?.position?.type !== void 0;
}
function hasStickyOrFixedPositionValue(attributes) {
  const positionType = attributes?.style?.position?.type;
  return positionType === "sticky" || positionType === "fixed";
}
function resetPosition({ attributes = {}, setAttributes }) {
  const { style = {} } = attributes;
  setAttributes({
    style: cleanEmptyObject({
      ...style,
      position: {
        ...style?.position,
        type: void 0,
        top: void 0,
        right: void 0,
        bottom: void 0,
        left: void 0
      }
    })
  });
}
function useIsPositionDisabled({ name: blockName } = {}) {
  const [allowFixed, allowSticky] = use_settings_useSettings(
    "position.fixed",
    "position.sticky"
  );
  const isDisabled = !allowFixed && !allowSticky;
  return !hasPositionSupport(blockName) || isDisabled;
}
function PositionPanelPure({
  style = {},
  clientId,
  name: blockName,
  setAttributes
}) {
  const allowFixed = hasFixedPositionSupport(blockName);
  const allowSticky = hasStickyPositionSupport(blockName);
  const value = style?.position?.type;
  const { firstParentClientId } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getBlockParents } = select(store);
      const parents = getBlockParents(clientId);
      return { firstParentClientId: parents[parents.length - 1] };
    },
    [clientId]
  );
  const blockInformation = useBlockDisplayInformation(firstParentClientId);
  const stickyHelpText = allowSticky && value === STICKY_OPTION.value && blockInformation ? (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: the name of the parent block. */
    (0,external_wp_i18n_namespaceObject.__)(
      "The block will stick to the scrollable area of the parent %s block."
    ),
    blockInformation.title
  ) : null;
  const options = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const availableOptions = [DEFAULT_OPTION];
    if (allowSticky || value === STICKY_OPTION.value) {
      availableOptions.push(STICKY_OPTION);
    }
    if (allowFixed || value === FIXED_OPTION.value) {
      availableOptions.push(FIXED_OPTION);
    }
    return availableOptions;
  }, [allowFixed, allowSticky, value]);
  const onChangeType = (next) => {
    const placementValue = "0px";
    const newStyle = {
      ...style,
      position: {
        ...style?.position,
        type: next,
        top: next === "sticky" || next === "fixed" ? placementValue : void 0
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };
  const selectedOption = value ? options.find((option) => option.value === value) || DEFAULT_OPTION : DEFAULT_OPTION;
  return external_wp_element_namespaceObject.Platform.select({
    web: options.length > 1 ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls_default, { group: "position", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.BaseControl,
      {
        __nextHasNoMarginBottom: true,
        help: stickyHelpText,
        children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.CustomSelectControl,
          {
            __next40pxDefaultSize: true,
            label: (0,external_wp_i18n_namespaceObject.__)("Position"),
            hideLabelFromVision: true,
            describedBy: (0,external_wp_i18n_namespaceObject.sprintf)(
              // translators: %s: Currently selected position.
              (0,external_wp_i18n_namespaceObject.__)("Currently selected position: %s"),
              selectedOption.name
            ),
            options,
            value: selectedOption,
            onChange: ({ selectedItem }) => {
              onChangeType(selectedItem.value);
            },
            size: "__unstable-large"
          }
        )
      }
    ) }) : null,
    native: null
  });
}
var position_default = {
  edit: function Edit(props) {
    const isPositionDisabled = useIsPositionDisabled(props);
    if (isPositionDisabled) {
      return null;
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(PositionPanelPure, { ...props });
  },
  useBlockProps: position_useBlockProps,
  attributeKeys: ["style"],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, POSITION_SUPPORT_KEY);
  }
};
const POSITION_BLOCK_PROPS_REFERENCE = {};
function position_useBlockProps({ name, style }) {
  const hasPositionBlockSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(
    name,
    POSITION_SUPPORT_KEY
  );
  const isPositionDisabled = useIsPositionDisabled({ name });
  const allowPositionStyles = hasPositionBlockSupport && !isPositionDisabled;
  const id = (0,external_wp_compose_namespaceObject.useInstanceId)(POSITION_BLOCK_PROPS_REFERENCE);
  const positionSelector = `.wp-container-${id}.wp-container-${id}`;
  let css;
  if (allowPositionStyles) {
    css = getPositionCSS({
      selector: positionSelector,
      style
    }) || "";
  }
  const className = dist_clsx({
    [`wp-container-${id}`]: allowPositionStyles && !!css,
    // Only attach a container class if there is generated CSS to be attached.
    [`is-position-${style?.position?.type}`]: allowPositionStyles && !!css && !!style?.position?.type
  });
  useStyleOverride({ css });
  return { className };
}


;// ./node_modules/@wordpress/block-editor/build-module/components/global-styles/use-global-styles-output.js

















const ELEMENT_CLASS_NAMES = {
  button: "wp-element-button",
  caption: "wp-element-caption"
};
const BLOCK_SUPPORT_FEATURE_LEVEL_SELECTORS = {
  __experimentalBorder: "border",
  color: "color",
  spacing: "spacing",
  typography: "typography"
};
const { kebabCase: use_global_styles_output_kebabCase } = unlock(external_wp_components_namespaceObject.privateApis);
function getPresetsDeclarations(blockPresets = {}, mergedSettings) {
  return PRESET_METADATA.reduce(
    (declarations, { path, valueKey, valueFunc, cssVarInfix }) => {
      const presetByOrigin = getValueFromObjectPath(
        blockPresets,
        path,
        []
      );
      ["default", "theme", "custom"].forEach((origin) => {
        if (presetByOrigin[origin]) {
          presetByOrigin[origin].forEach((value) => {
            if (valueKey && !valueFunc) {
              declarations.push(
                `--wp--preset--${cssVarInfix}--${use_global_styles_output_kebabCase(
                  value.slug
                )}: ${value[valueKey]}`
              );
            } else if (valueFunc && typeof valueFunc === "function") {
              declarations.push(
                `--wp--preset--${cssVarInfix}--${use_global_styles_output_kebabCase(
                  value.slug
                )}: ${valueFunc(value, mergedSettings)}`
              );
            }
          });
        }
      });
      return declarations;
    },
    []
  );
}
function getPresetsClasses(blockSelector = "*", blockPresets = {}) {
  return PRESET_METADATA.reduce(
    (declarations, { path, cssVarInfix, classes }) => {
      if (!classes) {
        return declarations;
      }
      const presetByOrigin = getValueFromObjectPath(
        blockPresets,
        path,
        []
      );
      ["default", "theme", "custom"].forEach((origin) => {
        if (presetByOrigin[origin]) {
          presetByOrigin[origin].forEach(({ slug }) => {
            classes.forEach(({ classSuffix, propertyName }) => {
              const classSelectorToUse = `.has-${use_global_styles_output_kebabCase(
                slug
              )}-${classSuffix}`;
              const selectorToUse = blockSelector.split(",").map(
                (selector) => `${selector}${classSelectorToUse}`
              ).join(",");
              const value = `var(--wp--preset--${cssVarInfix}--${use_global_styles_output_kebabCase(
                slug
              )})`;
              declarations += `${selectorToUse}{${propertyName}: ${value} !important;}`;
            });
          });
        }
      });
      return declarations;
    },
    ""
  );
}
function getPresetsSvgFilters(blockPresets = {}) {
  return PRESET_METADATA.filter(
    // Duotone are the only type of filters for now.
    (metadata) => metadata.path.at(-1) === "duotone"
  ).flatMap((metadata) => {
    const presetByOrigin = getValueFromObjectPath(
      blockPresets,
      metadata.path,
      {}
    );
    return ["default", "theme"].filter((origin) => presetByOrigin[origin]).flatMap(
      (origin) => presetByOrigin[origin].map(
        (preset) => getDuotoneFilter(
          `wp-duotone-${preset.slug}`,
          preset.colors
        )
      )
    ).join("");
  });
}
function flattenTree(input = {}, prefix, token) {
  let result = [];
  Object.keys(input).forEach((key) => {
    const newKey = prefix + use_global_styles_output_kebabCase(key.replace("/", "-"));
    const newLeaf = input[key];
    if (newLeaf instanceof Object) {
      const newPrefix = newKey + token;
  