ventClose ) {\n\t\t\t\ttypeModel.set( 'editActive', true );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Makes sure that calculations don't reference calculations with a lower order.\n *\n * For example, our first caclulation can't reference the second, but the second can reference the first.\n * \n * @package Ninja Forms builder\n * @subpackage Advanced\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/advanced/calculations',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * When someone types in the \"name\" or \"eq\" portion of our calculation, we need to make sure\n\t\t\t * that they haven't duplicated a name or made a bad EQ reference.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater-calculations' ), 'keyup:option', this.keyUp );\n\t\t\t/*\n\t\t\t * Same thing for when our calculation option is updated\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater-calculations' ), 'update:option', this.updateCalc );\n\t\t\t/*\n\t\t\t * When we sort our calcluations, we need to make sure that we don't get any bad EQ\n\t\t\t * references.\n\t\t\t */\n\t\t\tthis.listenTo( nfRadio.channel( 'option-repeater-calculations' ), 'sort:option', this.sortCalc );\n\t\t},\n\n\t\tkeyUp: function( e, optionModel ) {\n\t\t\t// Get our current value\n\t\t\tvar value = jQuery( e.target ).val();\n\t\t\t// Check to see if we're editing a name or eq\n            var id = jQuery( e.target ).data( 'id' );\n\t\t\tif( 'name' == id ) { // We are editing the name field\n\t\t\t\t// Check to see if our name already exists.\n\t\t\t\tthis.checkName( value, optionModel );\n\t\t\t\tthis.checkEQ( optionModel.get( 'eq' ), optionModel );\n\t\t\t} else if( 'eq' == id ) { // We're editing the eq\n\t\t\t\t// Check to see if there are any calcs referenced in our eq\n\t\t\t\tthis.checkEQ( value, optionModel );\n\t\t\t} else if( 'dec' == id ) { // We're editing the dec\n                // Check to see that we have a non-negative integer\n                this.checkDec( value, optionModel );\n            }\n\t\t},\n\n\t\tupdateCalc: function( optionModel ) {\n\t\t\tthis.checkName( optionModel.get( 'name' ), optionModel, false );\n\t\t\tthis.checkEQ( optionModel.get( 'eq' ), optionModel );\n\t\t\tthis.checkDec( optionModel.get( 'dec' ), optionModel );\n\n\t\t\tBackbone.Radio.channel( 'calcs' ).trigger( 'update:calc', optionModel );\n\t\t},\n\n\t\tsortCalc: function( optionModel, setting ) {\n\t\t\tthis.checkAllCalcs( setting.collection );\n\t\t},\n\n\t\t/**\n\t\t * Check to see if a calc name exists.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  string \t\t\tname        calc name to check\n\t\t * @param  backbone.model \toptionModel \n\t\t * @return void\n\t\t */\n\t\tcheckName: function( name, optionModel, silent ) {\n\t\t\tsilent = silent || true;\n\t\t\t// Get our current errors, if any.\n\t\t\tvar errors = optionModel.get( 'errors' );\n\t\t\t// Search our calc collection for our name\n\t\t\tvar found = optionModel.collection.where( { name: String(name).trim() } );\n\n\t\t\t// If the name that was passed is the same as our current name, return false.\n\t\t\tif ( name == optionModel.get( 'name' ) ) {\n\t\t\t\tfound = [];\n\t\t\t}\n\n\t\t\t// If our name exists, add an errors to the option model\n\t\t\tif ( 0 != found.length ) {\n\