change \tmodel of our change\n\t\t * @param  boolean \t\t\tundoAll are we in the middle of an undo all action?\n\t\t * @return void\n\t\t */\n\t\tundoDuplicateObject: function( change, undoAll ) {\n\t\t\tvar objectModel = change.get( 'model' );\n\t\t\tvar objectCollection = change.get( 'data' ).collection;\n\n\t\t\tif ( ! undoAll ) {\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tvar results = changeCollection.where( { model: objectModel } );\n\n\t\t\t\t_.each( results, function( model ) {\n\t\t\t\t\tif ( model !== change ) {\n\t\t\t\t\t\tchangeCollection.remove( model );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tobjectCollection.remove( objectModel );\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\t/**\n\t\t * Undo removing a field or an action.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tchange \tmodel of our change\n\t\t * @param  boolean \t\t\tundoAll are we in the middle of an undo all action?\n\t\t * @return void\n\t\t */\n\t\tundoRemoveObject: function( change, undoAll ) {\n\t\t\tvar dataModel = change.get( 'model' );\n\t\t\tvar collection = change.get( 'data' ).collection;\n\n\t\t\tnfRadio.channel( dataModel.get( 'objectDomain' ) ).request( 'add', dataModel );\n\n\t\t\tdelete collection.removedIDs[ dataModel.get( 'id' ) ];\n\t\t\t\n\t\t\tif ( ! undoAll ) {\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tvar results = changeCollection.where( { model: dataModel } );\n\n\t\t\t\t_.each( results, function( model ) {\n\t\t\t\t\tif ( model !== change ) {\n\t\t\t\t\t\tmodel.set( 'disabled', false );\n\t\t\t\t\t}\n\t\t\t\t} );\t\t\t\t\n\t\t\t}\n\n\t\t\t// Trigger a reset on our field collection so that our view re-renders\n\t\t\tcollection.trigger( 'reset', collection );\n\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\t/**\n\t\t * Undo field sorting.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tchange \tmodel of our change\n\t\t * @param  boolean \t\t\tundoAll are we in the middle of an undo all action?\n\t\t * @return void\n\t\t */\n\t\tundoSortFields: function( change, undoAll ) {\n\t\t\tvar data = change.get( 'data' );\n\t\t\tvar fields = data.fields;\n\n\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t_.each( fields, function( changeModel ) {\n\t\t\t\tvar before = changeModel.before;\n\t\t\t\tvar fieldModel = changeModel.model;\n\t\t\t\tfieldModel.set( 'order', before );\n\t\t\t\t// console.log( 'set ' + fieldModel.get( 'label' ) + ' to ' + before );\n\t\t\t} );\n\t\t\t// console.log( fieldCollection.where( { label: 'Name' } ) );\n\t\t\t// console.log( fieldCollection.where( { label: 'Email' } ) );\n\n\n\t\t\tfieldCollection.sort();\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\tundoAddListOption: function( change, undoAll ) {\n\t\t\tvar model = change.get( 'model' );\n\n\t\t\tif ( ! undoAll ) {\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tvar results = changeCollection.where( { model: model } );\n\n\t\t\t\t_.each( results, function( changeModel ) {\n\t\t\t\t\tif ( changeModel !== change ) {\n\t\t\t\t\t\tchangeCollection.remove( changeModel );\n\t\t\t\t\t}\n\t\t\t\t} );\t\t\t\t\n\t\t\t}\n\n\t\t\tmodel.collection.remove( model );\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\tundoRemoveListOption: function( change, undoAll ) {\n\t\t\tvar model = change.get( 'model' );\n\t\t\tvar collection = change.get( 'data' ).collection;\n\t\t\tcollection.add( model );\n\n\t\t\tif ( ! undoAll ) {\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tvar results = changeCollection.where( { model: model } );\n\n\t\t\t\t_.each( results, function( model ) {\n\t\t\t\t\tif ( model !== change ) {\n\t\t\t\t\t\tmodel.set( 'disabled', false );\n\t\t\t\t\t}\n\t\t\t\t} );\t\t\t\t\n\t\t\t}\n\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\tundoSortListOptions: function( change, undoAll ) {\n\t\t\tvar data = change.get( 'data' );\n\t\t\tvar collection = data.collection;\n\t\t\t\n\t\t\tvar objModels = data.objModels;\n\n\t\t\t_.each( objModels, function( changeModel ) {\n\t\t\t\tvar before = changeModel.before;\n\t\t\t\tvar optionModel = changeModel.model;\n\t\t\t\toptionModel.set( 'order', before );\n\t\t\t} );\t\t\t\t\n\n\n\t\t\tcollection.sort();\n\t\t\tthis.maybeRemoveChange( change, undoAll );\n\t\t},\n\n\t\t/**\n\t\t * If our undo action was requested to 'remove' the change from the collection, remove it.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  backbone.model \tchange \tmodel of our change\n\t\t * @param  boolean \t\t\tremove \tshould we remove this item from our change collection\n\t\t * @return void\n\t\t */\n\t\tmaybeRemoveChange: function( change, undoAll ) {\t\t\t\n\t\t\tvar undoAll = typeof undoAll !== 'undefined' ? undoAll : false;\n\t\t\tif ( ! undoAll ) {\n\t\t\t\t// Update preview.\n\t\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\n\t\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\t\tchangeCollection.remove( change );\n\t\t\t\tif ( 0 == changeCollection.length ) {\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'clean', true );\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'close:drawer' );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Returns a clone of a backbone model with all the attributes looped through so that collections contained within are propely cloned.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/cloneModelDeep',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'app' ).reply( 'clone:modelDeep', this.cloneModelDeep, this );\n\t\t},\n\n\t\tcloneModelDeep: function( model ) {\n\t\t\t// Temporary value used to store any new collections.\n\t\t\tvar replace = {};\n\t\t\t// Loop over every model attribute and if we find a collection, clone each model and instantiate a new collection.\n\t\t\t_.each( model.attributes, function( val, key ) {\n\t\t\t\tif( val instanceof Backbone.Collection ) { // Is this a backbone collection?\n\t\t\t\t\tvar clonedCollection = nfRadio.channel( 'app' ).request( 'clone:collectionDeep', val );\n\t\t\t\t\treplace[ key ] = clonedCollection;\n\t\t\t\t} else if ( val instanceof Backbone.Model ) { // Is this a backbone model?\n\t\t\t\t\treplace[ key ] = this.cloneModelDeep( val );\n\t\t\t\t}\n\t\t\t}, this );\n\n\t\t\t// Clone our original model\n\t\t\tvar newModel = model.clone();\n\t\t\t// Overwrite any collections we created above.\n\t\t\t_.each( replace, function( val, key ) {\n\t\t\t\tnewModel.set( key, val );\n\t\t\t} );\n\n\t\t\treturn newModel;\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Returns the appropriate child view for our settings drawer.\n *\n * This enables settings types to register custom childviews for their settings.\n * The option-repeater setting for the list field is an example.\n * \n * @package Ninja Forms builder\n * @subpackage App - Edit Settings Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/getSettingChildView',['views/app/drawer/itemSetting'], function( itemSettingView ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests for field settings child views.\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:settingChildView', this.getSettingChildView, this );\n\t\t},\n\n\t\t/**\n\t\t * Return the appropriate child setting view.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  backbone.model\tmodel \tField setting\n\t\t * @return backbone.view\n\t\t */\n\t\tgetSettingChildView: function( model ) {\n\t\t\t// Get our setting type.\n\t\t\tvar type = model.get( 'type' );\n\t\t\t// Request a setting childview from our setting type channel. (Setting type, not field type)\n\t\t\tvar settingChildView = nfRadio.channel( type ).request( 'get:settingChildView', model ) || itemSettingView;\n\t\t\t\n\t\t\treturn settingChildView\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Updates our model when the user changes a setting.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/changeSettingDefault',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests to update settings.\n\t\t\tnfRadio.channel( 'app' ).reply( 'change:setting', this.changeSetting, this );\n\n\t\t\t// Listen on our app channel for the change setting event. Fired by the setting view.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'change:setting', this.changeSetting, this );\n\t\t},\n\n\t\t/**\n\t\t * When we change our setting, update the model.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \t\t\te                event\n\t\t * @param  backbone.model \tsettingModel model that holds our field type settings info\n\t\t * @param  backbone.model \tdataModel       model that holds our field settings\n\t\t * @return void\n\t\t */\n\t\tchangeSetting: function( e, settingModel, dataModel, value ) {\n\t\t\tvar name = settingModel.get( 'name' );\n\t\t\tvar before = dataModel.get( name );\n\t\t\tvar value = value || null;\n\t\t\tif ( ! value ) {\n\t\t\t\t// Sends out a request on the fields-type (fields-text, fields-checkbox, etc) channel to see if that field type needs to return a special value for saving.\n\t\t\t\tvalue = nfRadio.channel( settingModel.get( 'type' ) ).request( 'before:updateSetting', e, dataModel, name, settingModel );\n\t\t\t}\n\n\t\t\tif( 'undefined' == typeof value ){\n\t\t\t    value = jQuery( e.target ).val();\n            }\n\t\t\t\n\t\t\t// Update our field model with the new setting value.\n\t\t\tdataModel.set( name, value, { settingModel: settingModel } );\n\t\t\tnfRadio.channel( 'setting-' + name ).trigger( 'after:updateSetting', dataModel, settingModel );\n\t\t\t// Register our setting change with our change tracker\n\t\t\tvar after = value;\n\t\t\t\n\t\t\tvar changes = {\n\t\t\t\tattr: name,\n\t\t\t\tbefore: before,\n\t\t\t\tafter: after\n\t\t\t}\n\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tvar currentDomainID = currentDomain.get( 'id' );\n\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Changed ' + settingModel.get( 'label' ) + ' from ' + before + ' to ' + after\n\t\t\t};\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'changeSetting', dataModel, changes, label );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","define( 'views/app/drawer/typeSettingFieldset',['views/app/drawer/itemSetting'], function( itemSettingView ) {\n\tvar view = Marionette.CompositeView.extend( {\n\t\ttemplate: '#tmpl-nf-edit-setting-wrap',\n\t\tchildView: itemSettingView,\n\n\t\tinitialize: function( data ) {\n\t\t\tthis.collection = this.model.get( 'settings' );\n\t\t\tthis.childViewOptions = { dataModel: data.dataModel };\n\t\t\tthis.dataModel = data.dataModel;\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\t// If we don't have a 'settings' property, this is a legacy depdency setup.\n\t\t\t\tif ( 'undefined' == typeof deps.settings ) {\n\t\t\t\t\tdeps.settings = [];\n\t\t\t\t\t_.each(deps, function(dep, name){\n\t\t\t\t\t\tif( 'settings' !== name ) {\n\t\t\t\t\t\t\tdeps.settings.push( { name: name, value: dep } );\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tdeps.match = 'all';\n\t\t\t\t}\n\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tlet name = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.on( 'change:' + name, this.render, this );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis.model.on( 'rerender', this.render, this );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tvar deps = this.model.get( 'deps' );\n\t\t\tif ( deps ) {\n\t\t\t\tfor (var i = deps.settings.length - 1; i >= 0; i--) {\n\t\t\t\t\tname = deps.settings[i].name;\n\t\t\t\t\tthis.dataModel.off( 'change:' + name, this.render );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tonBeforeRender: function() {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'before:renderSetting', this.model, this.dataModel );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'before:renderSetting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'before:renderSetting', this.model, this.dataModel, this );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.setupTooltip();\n\t\t\t/*\n\t\t\t * Send out a radio message.\n\t\t\t */\n\t\t\tnfRadio.channel( 'setting-' + this.model.get( 'name' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\t\t\tnfRadio.channel( 'setting-type-' + this.model.get( 'type' ) ).trigger( 'render:setting', this.model, this.dataModel, this );\n\t\t},\n        \n        /**\n         * Function to append jBox modals to each tooltip element in the option repeater.\n         */\n        setupTooltip: function() {\n            // For each .nf-help in the option repeater...\n            jQuery( this.el ).find( '.nf-help' ).each(function() {\n                // Get the content.\n                var content = jQuery(this).next('.nf-help-text');\n                // Declare the modal.\n                jQuery( this ).jBox( 'Tooltip', {\n                    content: content,\n                    maxWidth: 200,\n                    theme: 'TooltipBorder',\n                    trigger: 'click',\n                    closeOnClick: true\n                })\n            });\n        },\n\n\t\ttemplateHelpers: function () {\n\t\t\tvar that = this;\n\t    \treturn {\n\t    \t\trenderVisible: function() {\n\n\t\t\t\t\tif(!nfAdmin.devMode){\n\t\t\t\t\t\tif('help' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('classes' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\tif('input_limit_set' == this.name) return 'style=\"display:none;\"';\n\n\t\t\t\t\t\tif('checkbox' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('checkbox_values' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif('date' == that.dataModel.get('type')){\n\t\t\t\t\t\t\tif('year_range' == this.name) return 'style=\"display:none;\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn nfRadio.channel( 'settings' ).request( 'check:deps', this, that );\n\t    \t\t},\n\n\t\t\t\trenderSetting: function(){\n\t    \t\t\tvar setting = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-edit-setting-' + this.type );\n\t\t\t\t\treturn setting( this );\n\t\t\t\t},\n\n\t\t\t\trenderInfo: function() {\n\t\t\t\t\tif ( ! this.info ) return '';\n\t\t\t\t\treturn '<a href=\"' + this.info + '\" target=\"_blank\" class=\"nf-external-info\"></a>';\n\t\t\t\t},\n\n\t\t\t\trenderTooltip: function() {\n\t\t\t\t\tif ( ! this.help ) return '';\n\t\t\t\t\tvar helpText, helpTextContainer, helpIcon, helpIconLink, helpTextWrapper;\n\n\t\t\t\t\thelpText = document.createElement( 'div' );\n\t\t\t\t\thelpText.innerHTML = this.help;\n\t\t\t\t\t\n\t\t\t\t\thelpTextContainer = document.createElement( 'div' );\n\t\t\t\t\thelpTextContainer.classList.add( 'nf-help-text' );\n\t\t\t\t\thelpTextContainer.appendChild( helpText );\n\n\t\t\t\t\thelpIcon = document.createElement( 'span' );\n\t\t\t\t\thelpIcon.classList.add( 'dashicons', 'dashicons-admin-comments' );\n                    helpIconLink = document.createElement( 'a' );\n                    helpIconLink.classList.add( 'nf-help' );\n                    helpIconLink.setAttribute( 'href', '#' );\n                    helpIconLink.setAttribute( 'tabindex', '-1' );\n                    helpIconLink.appendChild( helpIcon );\n\n                    helpTextWrapper = document.createElement( 'span' );\n                    helpTextWrapper.appendChild( helpIconLink );\n                    helpTextWrapper.appendChild( helpTextContainer );\n\n                    // The template expects a string value.\n\t\t\t\t\treturn helpTextWrapper.innerHTML;\n\t\t\t\t},\n\t\t\t\t\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = '';\n\t\t\t\t\tif ( 'undefined' != typeof this.width ) {\n\t\t\t\t\t\tclasses += this.width;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tclasses += ' one-half';\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\tclasses += ' nf-error';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn classes;\n\t\t\t\t},\n\n\t\t\t\trenderError: function() {\n\t\t\t\t\tif ( this.error ) {\n\t\t\t\t\t\treturn this.error;\n\t\t\t\t\t}\n\t\t\t\t\treturn '';\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tjQuery( collectionView.el ).find( '.nf-field-sub-settings' ).append( childView.el );\n\t\t}\n\t} );\n\n\treturn view;\n} );\n","/**\n * Handles actions related to field settings that use a fieldset\n * \n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/fieldset',['views/app/drawer/typeSettingFieldset','models/app/settingCollection'], function( fieldsetView, settingCollection ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tnfRadio.channel( 'fieldset' ).reply( 'get:settingChildView', this.getSettingChildView, this );\n\t\t\t// When a list type field is initialized, create an option collection.\n\t\t\tthis.listenTo( nfRadio.channel( 'fieldset' ), 'init:settingModel', this.createSettingsCollection );\n\t\t},\n\n\t\tgetSettingChildView: function( model ) {\n\t\t\treturn fieldsetView;\n\t\t},\n\n\t\t/**\n\t\t * Instantiate settings collection when a fieldset type is 