 function( itemControlsView ) {\n\tvar view = Marionette.LayoutView.extend({\n\t\ttagName: 'tr',\n\t\ttemplate: '#tmpl-nf-action-item',\n\n\t\tregions: {\n\t\t\titemControls: '.nf-item-controls'\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.template = nfRadio.channel( 'actions' ).request( 'get:actionItemTemplate' ) || this.template;\n\t\t\tthis.model.on( 'change:label', this.render, this );\n\t\t\tthis.model.on( 'change:editActive', this.render, this );\n\t\t\tthis.model.on( 'change:active', this.maybeDeactivate, this );\n\t\t},\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change:label', this.render );\n\t\t\tthis.model.off( 'change:editActive', this.render );\n\t\t\tthis.model.off( 'change:active', this.maybeDeactivate );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tif ( this.model.get( 'editActive' ) ) {\n\t\t\t\tjQuery( this.el ).addClass( 'active' );\n\t\t\t} else {\n\t\t\t\tjQuery( this.el ).removeClass( 'active' );\n\t\t\t}\n\n\t\t\tthis.maybeDeactivate();\n\n\t\t\tthis.itemControls.show( new itemControlsView( { model: this.model } ) );\n\t\t},\n\n\t\tmaybeDeactivate: function() {\n\t\t\tif ( 0 == this.model.get( 'active' ) ) {\n\t\t\t\tjQuery( this.el ).addClass( 'deactivated' );\n\t\t\t} else {\n\t\t\t\tjQuery( this.el ).removeClass( 'deactivated' );\n\t\t\t}\n\t\t},\n\n\t\tevents: {\n\t\t\t'change input': 'changeToggle',\n\t\t\t'click': 'maybeClickEdit'\n\t\t},\n\n\t\tmaybeClickEdit: function( e ) {\n\t\t\tif ( 'TR' == jQuery( e.target ).parent().prop( 'tagName' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'click:edit', e, this.model );\n\t\t\t}\n\t\t},\n\n\t\tchangeToggle: function( e ) {\n\t\t\tvar setting = jQuery( e.target ).data( 'setting' );\n\t\t\tvar settingModel = nfRadio.channel( 'actions' ).request( 'get:settingModel', setting );\n\t\t\tnfRadio.channel( 'app' ).request( 'change:setting', e, settingModel, this.model );\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderToggle: function( settingName ) {\n\t\t\t\t\tthis.settingName = settingName || 'active';\n\t\t\t\t\tvar actionLabel = this.label;\n\t\t\t\t\tthis.label = '';\n\t\t\t\t\tthis.value = this[ this.settingName ];\n\t\t\t\t\tthis.name = this.id + '-' + this.settingName;\n\t\t\t\t\tvar html = nfRadio.channel( 'app' ).request( 'get:template',  '#tmpl-nf-edit-setting-toggle' );\n\t\t\t\t\thtml = html( this );\n\t\t\t\t\tthis.label = actionLabel;\n\t\t\t\t\treturn html;\n\t\t\t\t},\n\n\t\t\t\trenderTypeNicename: function() {\n\t\t\t\t\tvar type = nfRadio.channel( 'actions' ).request( 'get:type', this.type );\n\t\t\t\t\tif ( 'undefined' == typeof type ) return;\n\n\t\t\t\t\treturn type.get( 'nicename' );\n\t\t\t\t},\n\n                /**\n\t\t\t\t * [Deprecated] Tooltips are not currently implemented in the context of the action list.\n\t\t\t\t *   However, the template uses a nested template which requires the helper method.\n                 * @returns {string}\n                 */\n\t\t\t\trenderTooltip: function() {\n\t\t\t\t\treturn '';\n\t\t\t\t},\n\n\t\t\t\trenderMergeTags: function() {\n\t\t\t\t\tif ( this.use_merge_tags ) {\n\t\t\t\t\t\treturn '<span class=\"dashicons dashicons-list-view merge-tags\"></span>';\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn '';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/actions/mainContentEmpty',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-main-content-actions-empty',\n\n\t\tonBeforeDestroy: function() {\n\t\t\tjQuery( this.el ).parent().parent().removeClass( 'nf-actions-empty' );\n\t\t\t// jQuery( this.el ).parent().removeClass( 'nf-fields-empty-droppable' ).droppable( 'destroy' );\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tthis.$el = this.$el.children();\n\t\t\tthis.$el.unwrap();\n\t\t\tthis.setElement( this.$el );\n\t\t},\n\n\t\tonShow: function() {\n\t\t\tjQuery( this.el ).parent().parent().addClass( 'nf-actions-empty' );\n\t\t\t// if ( jQuery( this.el ).parent().hasClass( 'ui-sortable' ) ) {\n\t\t\t// \tjQuery( this.el ).parent().sortable( 'destroy' );\n\t\t\t// }\n\t\t\t// jQuery( this.el ).parent().addClass( 'nf-fields-empty-droppable' );\n\t\t\t// jQuery( this.el ).parent().droppable( {\n\t\t\t// \taccept: function( draggable ) {\n\t\t\t// \t\tif ( jQuery( draggable ).hasClass( 'nf-stage' ) || jQuery( draggable ).hasClass( 'nf-field-type-button' ) ) {\n\t\t\t// \t\t\treturn true;\n\t\t\t// \t\t}\n\t\t\t// \t},\n\t\t\t// \thoverClass: 'nf-droppable-hover',\n\t\t\t// \ttolerance: 'pointer',\n\t\t\t// \tover: function( e, ui ) {\n\t\t\t// \t\tui.item = ui.draggable;\n\t\t\t// \t\tnfRadio.channel( 'app' ).request( 'over:fieldsSortable', ui );\n\t\t\t// \t},\n\t\t\t// \tout: function( e, ui ) {\n\t\t\t// \t\tui.item = ui.draggable;\n\t\t\t// \t\tnfRadio.channel( 'app' ).request( 'out:fieldsSortable', ui );\n\t\t\t// \t},\n\t\t\t// \tdrop: function( e, ui ) {\n\t\t\t// \t\tui.item = ui.draggable;\n\t\t\t// \t\tnfRadio.channel( 'app' ).request( 'receive:fieldsSortable', ui );\n\t\t\t// \t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t// \t\tfieldCollection.trigger( 'reset', fieldCollection );\n\t\t\t// \t},\n\t\t\t// } );\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Main content view for our actions.\n *\n * TODO: make dynamic\n *\n * @package Ninja Forms builder\n * @subpackage Actions\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'views/actions/mainContent',['views/actions/actionItem', 'views/actions/mainContentEmpty'], function( actionView, emptyView ) {\n\tvar view = Marionette.CompositeView.extend({\n\t\ttemplate: '#tmpl-nf-action-table',\n\t\tchildView: actionView,\n\t\temptyView: emptyView,\n\n\t\tinitialize: function() {\n\t\t\tthis.template = nfRadio.channel( 'actions' ).request( 'get:mainContentTemplate' ) || this.template;\n\t\t},\n\n\t\tonRender: function() {\n\t\t\tjQuery( this.el ).droppable( {\n\t\t\t\taccept: '.nf-action-type-draggable',\n\t\t\t\tactiveClass: 'nf-droppable-active',\n\t\t\t\thoverClass: 'nf-droppable-hover',\n\t\t\t\tdrop: function( e, ui ) {\n\t\t\t\t\tnfRadio.channel( 'app' ).request( 'drop:actionType', e, ui );\n\t\t\t\t}\n\t\t\t} );\n\t\t},\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tif ( 'undefined' == typeof nfRadio.channel( 'actions' ).request( 'get:type', childView.model.get( 'type' ) ) ) return;\n\n\t\t\tjQuery( collectionView.el ).find( 'tbody' ).append( childView.el );\n\t\t},\n\t});\n\n\treturn view;\n} );\n\n","define( 'views/advanced/mainHeader',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-main-header-settings'\n\t});\n\n\treturn view;\n} );\n","define( 'views/advanced/subHeader',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-sub-header-settings'\n\t});\n\n\treturn view;\n} );\n","define( 'views/advanced/settingItem',[], function() {\n\tvar view = Marionette.ItemView.extend({\n\t\ttagName: 'div',\n\t\ttemplate: '#tmpl-nf-form-setting-type',\n\n\t\tonBeforeDestroy: function() {\n\t\t\tthis.model.off( 'change:editActive', this.updateActiveClass );\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tthis.model.on( 'change:editActive', this.updateActiveClass, this );\n\t\t},\n\n\t\tevents: {\n\t\t\t'click': 'clickEdit'\n\t\t},\n\n\t\tclickEdit: function( e ) {\n\t\t\tif('undefined' !== typeof this.model.get('modal_content')) {\n\t\t\t\tvar modalContent = this.model.get( 'modal_content' );\n\n\t\t\t\tvar settingsModal = new jBox( 'Modal', {\n\t\t\t\t  content: modalContent,\n\t\t\t\t  zIndex:99999999,\n\t\t\t\t  closeButton: 'box',\n\t\t\t\t  overlay: true,\n\t\t\t\t  width: 600,\n\t\t\t\t  repositionOnOpen: true,\n\t\t\t\t  reposition: true\n\t\t\t\t});\n\n\t\t\t\tsettingsModal.open();\n\t\t\t} else{\n\t\t\t\tnfRadio.channel( 'settings' ).trigger( 'click:edit', e, this.model );\n\t\t\t}\n\t\t},\n\n\t\ttemplateHelpers: function() {\n\t\t\treturn {\n\t\t\t\trenderClasses: function() {\n\t\t\t\t\tvar classes = 'nf-setting-wrap ' + this.id;\n\t    \t\t\tif ( this.editActive ) {\n\t    \t\t\t\tclasses += ' active';\n\t    \t\t\t}\n\t    \t\t\treturn classes;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tupdateActiveClass: function() {\n\t\t\tif ( this.model.get( 'editActive' ) ) {\n\t\t\t\tjQuery( this.el ).find( '.nf-setting-wrap' ).addClass( 'active' );\n\t\t\t} else {\n\t\t\t\tjQuery( this.el ).find( '.nf-setting-wrap' ).removeClass( 'active' );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n","define( 'views/advanced/mainContent',['views/advanced/settingItem'], function( settingItem ) {\n\tvar view = Marionette.CompositeView.extend({\n\t\tchildView: settingItem,\n\t\ttemplate: '#tmpl-nf-advanced-main-content',\n\n\t\tattachHtml: function( collectionView, childView ) {\n\t\t\tif('undefined' != typeof childView.model.get('modal_content')) {\n\t\t\t\tjQuery( collectionView.el ).find( '.available' ).append( childView.el );\n\t\t\t\tjQuery( collectionView.el ).find( '.sub-section-header' ).show();\n\t\t\t} else {\n\t\t\t\tjQuery( collectionView.el ).find( '.installed' ).append( childView.el );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn view;\n} );\n","/**\n * Model that represents our form fields.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/fieldModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tobjectType: 'Field',\n\t\t\tobjectDomain: 'fields',\n\t\t\teditActive: false,\n\t\t\torder: 999,\n\t\t\tidAttribute: 'id'\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\tvar type = this.get('type');\n\t\t\tif ( 'undefined' == typeof type ) return;\n\n\t\t\t// Listen for model attribute changes\n\t\t\tthis.on( 'change', this.changeSetting, this );\n\n\t\t\t// Get our parent field type.\n\t\t\tvar fieldType = nfRadio.channel( 'fields' ).request( 'get:type', this.get( 'type' ) );\n\t\t\tvar parentType = fieldType.get( 'parentType' );\n\n\t\t\t// Loop through our field type \"settingDefaults\" and add any default settings.\n\t\t\t_.each( fieldType.get( 'settingDefaults' ), function( val, key ) {\n\t\t\t\tif ( 'undefined' == typeof this.get( key ) ) {\n\t\t\t\t\tthis.set( key, val, { silent: true } );\n\t\t\t\t}\n\t\t\t}, this );\n\n\t\t\t/*\n\t\t\t * If our field type is a saved field, set our field type to the actual field type\n\t\t\t */\n\t\t\tif ( 'saved' == fieldType.get( 'section' ) ) {\n\t\t\t\tthis.set( 'type', fieldType.get( 'type' ) );\n\t\t\t}\n\n\t\t\tif (type === 'listimage') {\n\t\t\t\tthis.get = this.listimageGet;\n\t\t\t\tthis.set = this.listimageSet;\n\t\t\t}\n\n\t\t\t/*\n\t\t\t * Trigger an init event on three channels:\n\t\t\t * \n\t\t\t * fields\n\t\t\t * fields-parentType\n\t\t\t * field-type\n\t\t\t *\n\t\t\t * This lets specific field types modify model attributes before anything uses them.\n\t\t\t */ \n\t\t\tnfRadio.channel( 'fields' ).trigger( 'init:fieldModel', this );\n\t\t\tnfRadio.channel( 'fields-' + parentType ).trigger( 'init:fieldModel', this );\n\t\t\tnfRadio.channel( 'fields-' + this.get( 'type' ) ).trigger( 'init:fieldModel', this );\n\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'fire:updateFieldKey', this.updateFieldKey );\n\t\t},\n\n\t\tlistimageGet: function(attr) {\n            if(attr === 'options') {\n\t\t\t\t\tattr = 'image_options';\n\t\t\t}\n\n            return Backbone.Model.prototype.get.call(this, attr);\n\t\t},\n\t\t\n\t\tlistimageSet: function(attributes, options) {\n\t\t\tif ('options' === attributes) {\n\t\t\t\tattributes = 'image_options';\n\t\t\t}\n\t\t\treturn Backbone.Model.prototype.set.call(this, attributes, options);\n\t\t},\n\n\t\t/**\n\t\t * Fires an event on the fieldSetting-{name} channel saying we've updated a setting.\n\t\t * When we change the model attributes, fire an event saying we've changed something.\n\t\t * \n\t\t * @since  3.0\n\t\t * @return void\n\t\t */\n\t\tchangeSetting: function( model, options ) {\n\t\t\tnfRadio.channel( 'fieldSetting-' + _.keys( model.changedAttributes() )[0] ).trigger( 'update:setting', this, options.settingModel ) ;\n\t\t\tnfRadio.channel( 'fields' ).trigger( 'update:setting', this, options.settingModel );\n\t\t\tnfRadio.channel( 'app' ).trigger( 'update:setting', this, options.settingModel );\n\t\t},\n\n\t\tupdateFieldKey: function( keyModel, settingModel ) {\n\t\t\tnfRadio.channel( 'app' ).trigger( 'replace:fieldKey', this, keyModel, settingModel );\n\t\t},\n        \n        /**\n         * Function used to get the formatted lable of the fieldModel.\n         * \n         * @since 3.3.3\n         * @return String\n         */\n        formatLabel: function() {\n            // Try to use admin label.\n            var label = this.get( 'admin_label' );\n            // If our admin label is empty...\n            if ( '' == label ) {\n                // Use the field label instead.\n                label = this.get( 'label' );\n            }\n            return label;\n        }\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Collection that holds our field models.\n * This is the actual field data created by the user.\n *\n * We listen to the add and remove events so that we can push the new id to either the new fields or removed fields property.\n *\n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/fields/fieldCollection',['models/fields/fieldModel'], function( fieldModel ) {\n\tvar collection = Backbone.Collection.extend( {\n\t\tmodel: fieldModel,\n\t\tcomparator: function( model ){\n\t\t\treturn parseInt( model.get( 'order' ) );\n\t\t},\n\t\ttmpNum: 1,\n\n\t\tinitialize: function() {\n\t\t\tthis.on( 'add', this.addField, this );\n\t\t\tthis.on( 'remove', this.removeField, this );\n\n\t\t\tthis.listenTo( this, 'add:field', this.addNewField );\n\t\t\tthis.listenTo( this, 'append:field', this.appendNewField );\n\t\t\tthis.listenTo( this, 'remove:field', this.removeFieldResponse );\n\t\t\tthis.newIDs = [];\n\t\t},\n\n\t\t/**\n\t\t * When we add a field, push the id onto our new fields property.\n\t\t * This lets us tell the server that this is a new field to be added rather than a field to be updated.\n\t\t *\n\t\t * @since 3.0\n\t\t * @param void\n\t\t */\n\t\taddField: function( model ) {\n\t\t\tthis.newIDs.push( model.get( 'id' ) );\n\t\t},\n\n\t\t/**\n\t\t * When we remove a field, push the id onto our removed fields property.\n\t\t *\n\t\t * @since 3.0\n\t\t * @param void\n\t\t */\n\t\tremoveField: function( model ) {\n\t\t\tthis.removedIDs = this.removedIDs || {};\n\t\t\tthis.removedIDs[ model.get( 'id' ) ] = model.get( 'id' );\n\t\t},\n\n\t\taddNewField: function( model ) {\n\t\t\tthis.add( model );\n\t\t},\n\n\t\tappendNewField: function( model ) {\n\t\t\tif ( 0 == this.length ) {\n\t\t\t\tvar order = 0;\n\t\t\t} else {\n\t\t\t\tvar order = this.at( this.length -1 ).get( 'order' ) + 1;\n\t\t\t}\n\n\t\t\tmodel.set( 'order', order, { silent: true } );\n\t\t\tthis.add( model );\n\t\t},\n\n\t\tremoveFieldResponse: function( model ) {\n\t\t\tthis.remove( model );\n\t\t},\n\n\t\tfieldExists: function( fieldModel ) {\n\t\t\treturn -1 != this.indexOf( fieldModel );\n\t\t}\n\t} );\n\treturn collection;\n} );\n\n","/**\n * Config file for our app domains.\n * \n * this.collection represents all of our app domain (fields, actions, settings) information.\n *\n * This doesn't store the current domain, but rather all the data about each.\n * \n * This data includes:\n * hotkeys\n * header view\n * subheader view\n * content view\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/domainConfig',[\n\t// Require our domain collection\n\t'models/app/domainCollection',\n\t// Require our fields domain files\n\t'views/fields/subHeader',\n\t'views/fields/mainContentFieldCollection',\n\t'views/fields/drawer/settingsTitle',\n\t// Require our actions domain files\n\t'views/actions/mainHeader', \n\t'views/actions/subHeader',\n\t'views/actions/mainContent',\n\t// Require our settings domain files\n\t'views/advanced/mainHeader',\n\t'views/advanced/subHeader',\n\t'views/advanced/mainContent',\n\t// Empty View\n\t'views/app/empty',\n\t// FieldCollection: used by the default formContentData filter\n\t'models/fields/fieldCollection'\n\t], \n\tfunction( \n\t\tappDomainCollection,\n\t\tfieldsSubHeaderView,\n\t\tFieldsMainContentFieldCollectionView,\n\t\tfieldsSettingsTitleView,\n\t\tactionsMainHeaderView,\n\t\tactionsSubHeaderView,\n\t\tactionsMainContentView,\n\t\tsettingsMainHeaderView,\n\t\tsettingsSubHeaderView,\n\t\tsettingsMainContentView,\n\t\tEmptyView,\n\t\tFieldCollection\n\t) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t/*\n\t\t\t * Add our default formContentView filter.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).request( 'add:viewFilter', this.defaultFormContentView, 10, this );\n\t\t\t\n\t\t\t/*\n\t\t\t * Add our default formContentData filter.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).request( 'add:loadFilter', this.defaultFormContentLoad, 10, this );\n\n\t\t\t/*\n\t\t\t * Add our default formContentGutterView filters.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContentGutters' ).request( 'add:leftFilter', this.defaultFormContentGutterView, 10, this );\n\t\t\tnfRadio.channel( 'formContentGutters' ).request( 'add:rightFilter', this.defaultFormContentGutterView, 10, this );\n\n\t\t\t// Define our app domains\n\t\t\tthis.collection = new appDomainCollection( [\n\t\t\t\t{\n\t\t\t\t\tid: 'fields',\n\t\t\t\t\tnicename: nfi18n.domainFormFields,\n\t\t\t\t\thotkeys: {\n\t\t\t\t\t\t'Esc'\t\t\t\t: 'close:drawer',\n\t\t\t\t\t\t'Ctrl+Shift+n'\t\t: 'add:newField',\n\t\t\t\t\t\t'Ctrl+Shift+a'\t\t: 'changeDomain:actions',\n\t\t\t\t\t\t'Ctrl+Shift+s'\t\t: 'changeDomain:settings',\n\t\t\t\t\t\t'Alt+Ctrl+t'\t\t: 'open:mergeTags',\n\t\t\t\t\t\t'up'\t\t\t\t: 'up:mergeTags',\n\t\t\t\t\t\t'down'\t\t\t\t: 'down:mergeTags',\n\t\t\t\t\t\t'Shift+return'\t\t: 'return:mergeTags'\n\t\t\t\t\t},\n\t\t\t\t\tmobileDashicon: 'dashicons-menu',\n\n\t\t\t\t\tgetSubHeaderView: function() {\n\t\t\t\t\t\treturn new fieldsSubHeaderView();\n\t\t\t\t\t},\n\n\t\t\t\t\t/**\n\t\t\t\t\t * Get the formContent view that should be used in our builder.\n\t\t\t\t\t * Uses two filters:\n\t\t\t\t\t * 1) One for our formContentData\n\t\t\t\t\t * 2) One for our formContentView\n\t\t\t\t\t *\n\t\t\t\t\t * If we don't have any view filters, we use the default formContentView.\n\t\t\t\t\t * \n\t\t\t\t\t * @since  3.0\n\t\t\t\t\t * @return formContentView backbone view.\n\t\t\t\t\t */\n\t\t\t\t\tgetMainContentView: function( collection ) {\n\t\t\t\t\t\tvar formContentData = nfRadio.channel( 'settings' ).request( 'get:setting', 'formContentData' );\n\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * As of version 3.0, 'fieldContentsData' has deprecated in favour of 'formContentData'.\n\t\t\t\t\t\t * If we don't have this setting, then we check for this deprecated value.\n\t\t\t\t\t\t * \n\t\t\t\t\t\t * Set our fieldContentsData to our form setting 'fieldContentsData'\n\t\t\t\t\t\t *\n\t\t\t\t\t\t * TODO: Remove this backwards compatibility eventually.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tif ( ! formContentData ) {\n\t\t\t\t\t\t\tformContentData = nfRadio.channel( 'settings' ).request( 'get:setting', 'fieldContentsData' );\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * If we don't have a filter for our formContentData, default to fieldCollection.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tvar formContentLoadFilters = nfRadio.channel( 'formContent' ).request( 'get:loadFilters' );\n\t\t\t\t\t\t\n\t\t\t\t\t\t/* \n\t\t\t\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t\t\t\t*/\n\t\t\t\t\t\tvar sortedArray = _.without( formContentLoadFilters, undefined );\n\t\t\t\t\t\tvar callback = _.first( sortedArray );\n\t\t\t\t\t\tformContentData = callback( formContentData, nfRadio.channel( 'app' ).request( 'get:formModel' ), true );\n\t\t\t\t\t\t\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * Check our fieldContentViewsFilter to see if we have any defined.\n\t\t\t\t\t\t * If we do, overwrite our default with the view returned from the filter.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tvar formContentViewFilters = nfRadio.channel( 'formContent' ).request( 'get:viewFilters' );\n\t\t\t\t\t\t\n\t\t\t\t\t\t/* \n\t\t\t\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t\t\t\t*/\n\t\t\t\t\t\tvar sortedArray = _.without( formContentViewFilters, undefined );\n\t\t\t\t\t\tvar callback = _.first( sortedArray );\n\t\t\t\t\t\tformContentView = callback();\n\n\t\t\t\t\t\tnfRadio.channel( 'settings' ).request( 'update:setting', 'formContentData', formContentData, true );\n\t\t\t\t\t\treturn new formContentView( { collection: formContentData } );\n\t\t\t\t\t},\n\n\t\t\t\t\tgetSettingsTitleView: function( data ) {\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * If we are dealing with a field model, return the fields settings view, otherwise, return the default.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tif ( 'fields' == data.model.get( 'objectDomain' ) ) {\n\t\t\t\t\t\t\treturn new fieldsSettingsTitleView( data );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\treturn this.get( 'getDefaultSettingsTitleView' ).call( this, data );\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t},\n\n\t\t\t\t\tgetGutterLeftView: function( data ) {\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * Check our fieldContentViewsFilter to see if we have any defined.\n\t\t\t\t\t\t * If we do, overwrite our default with the view returned from the filter.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tvar gutterFilters = nfRadio.channel( 'formContentGutters' ).request( 'get:leftFilters' );\n\n\t\t\t\t\t\t/* \n\t\t\t\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t\t\t\t*/\n\t\t\t\t\t\tvar sortedArray = _.without( gutterFilters, undefined );\n\t\t\t\t\t\tvar callback = _.first( sortedArray );\n\t\t\t\t\t\tgutterView = callback();\n\n\t\t\t\t\t\treturn new gutterView(); \n\t\t\t\t\t},\n\n\t\t\t\t\tgetGutterRightView: function() {\n\t\t\t\t\t\t/*\n\t\t\t\t\t\t * Check our fieldContentViewsFilter to see if we have any defined.\n\t\t\t\t\t\t * If we do, overwrite our default with the view returned from the filter.\n\t\t\t\t\t\t */\n\t\t\t\t\t\tvar gutterFilters = nfRadio.channel( 'formContentGutters' ).request( 'get:rightFilters' );\n\t\t\t\t\t\t\n\t\t\t\t\t\t/* \n\t\t\t\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t\t\t\t*/\n\t\t\t\t\t\tvar sortedArray = _.without( gutterFilters, undefined );\n\t\t\t\t\t\tvar callback = _.first( sortedArray );\n\t\t\t\t\t\tgutterView = callback();\n\n\t\t\t\t\t\treturn new gutterView(); \n\t\t\t\t\t}\n\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'actions',\n\t\t\t\t\tnicename: nfi18n.domainActions,\n\t\t\t\t\thotkeys: {\n\t\t\t\t\t\t'Esc'\t\t\t\t: 'close:drawer',\n\t\t\t\t\t\t'Ctrl+Shift+n'\t\t: 'add:newAction',\n\t\t\t\t\t\t'Ctrl+Shift+f'\t\t: 'changeDomain:fields',\n\t\t\t\t\t\t'Ctrl+Shift+s'\t\t: 'changeDomain:settings',\n\t\t\t\t\t\t'Alt+Ctrl+t'\t\t: 'open:mergeTags',\n\t\t\t\t\t\t'up'\t\t\t\t: 'up:mergeTags',\n\t\t\t\t\t\t'down'\t\t\t\t: 'down:mergeTags',\n\t\t\t\t\t\t'Shift+return'\t\t: 'return:mergeTags'\n\t\t\t\t\t},\n\t\t\t\t\tmobileDashicon: 'dashicons-external',\n\n\t\t\t\t\tgetSubHeaderView: function() {\n\t\t\t\t\t\treturn new actionsSubHeaderView();\n\t\t\t\t\t},\n\t\t\t\t\t\n\t\t\t\t\tgetMainContentView: function() {\n\t\t\t\t\t\tvar collection = nfRadio.channel( 'actions' ).request( 'get:collection' );\n\t\t\t\t\t\treturn new actionsMainContentView( { collection: collection } );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'settings',\n\t\t\t\t\tnicename: nfi18n.domainAdvanced,\n\t\t\t\t\thotkeys: {\n\t\t\t\t\t\t'Esc'\t\t\t\t: 'close:drawer',\n\t\t\t\t\t\t'Ctrl+Shift+f'\t\t: 'changeDomain:fields',\n\t\t\t\t\t\t'Ctrl+Shift+a'\t\t: 'changeDomain:actions',\n\t\t\t\t\t\t'Alt+Ctrl+t'\t\t: 'open:mergeTags',\n\t\t\t\t\t\t'up'\t\t\t\t: 'up:mergeTags',\n\t\t\t\t\t\t'down'\t\t\t\t: 'down:mergeTags',\n\t\t\t\t\t\t'Shift+return'\t\t: 'return:mergeTags'\n\t\t\t\t\t},\n\t\t\t\t\tmobileDashicon: 'dashicons-admin-generic',\n\n\t\t\t\t\tgetSubHeaderView: function() {\n\t\t\t\t\t\treturn new settingsSubHeaderView();\n\t\t\t\t\t},\n\t\t\t\t\t\n\t\t\t\t\tgetMainContentView: function() {\n\t\t\t\t\t\tvar collection = nfRadio.channel( 'settings' ).request( 'get:typeCollection' );\n\t\t\t\t\t\treturn new settingsMainContentView( { collection: collection } );\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\tid: 'preview',\n\t\t\t\t\tnicename: 'Preview Form',\n\t\t\t\t\tclasses: 'preview',\n\t\t\t\t\tdashicons: 'dashicons-visibility',\n\t\t\t\t\tmobileDashicon: 'dashicons-visibility',\n\t\t\t\t\turl: nfAdmin.previewurl\n\t\t\t\t}\n\t\t\t] );\n\n\t\t\t/*\n\t\t\t * Send out a radio message with our domain config collection.\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).trigger( 'init:domainCollection', this.collection );\n\n\t\t\t/*\n\t\t\t * Respond to requests to get the app domain collection.\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:domainCollection', this.getDomainCollection, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:domainModel', this.getDomainModel, this );\n\t\t},\n\n\t\tgetDomainCollection: function() {\n\t\t\treturn this.collection;\n\t\t},\n\n\t\tgetDomainModel: function( id ) {\n\t\t\treturn this.collection.get( id );\n\t\t},\n\n\t\tdefaultFormContentView: function( formContentData ) {\n\t\t\treturn FieldsMainContentFieldCollectionView;\n\t\t},\n\n\t\tdefaultFormContentLoad: function( formContentData ) {\n\t\t\tvar fieldCollection = nfRadio.channel( 'fields' ).request( 'get:collection' );\n\t\t\t/*\n\t\t\t * If we only have one load filter, we can just return the field collection.\n\t\t\t */\n\t\t\tvar formContentLoadFilters = nfRadio.channel( 'formContent' ).request( 'get:loadFilters' );\n\t\t\tvar sortedArray = _.without( formContentLoadFilters, undefined );\n\n\t\t\tif ( 1 == sortedArray.length || 'undefined' == typeof formContentData || true === formContentData instanceof Backbone.Collection ) return fieldCollection;\n\n\t\t\t/*\n\t\t\t * If another filter is registered, we are calling this from somewhere else.\n\t\t\t */\n\n        \tvar fieldModels = _.map( formContentData, function( key ) {\n        \t\treturn fieldCollection.findWhere( { key: key } );\n        \t}, this );\n\n        \treturn new FieldCollection( fieldModels );\n\t\t},\n\n\t\tdefaultFormContentGutterView: function( formContentData ) {\n\t\t\treturn EmptyView;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Model for our app data.\n * Listens for changes to the 'clean' attribute and triggers a radio message when the state changes.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'models/app/appModel',[], function() {\n\tvar model = Backbone.Model.extend( {\n\t\tdefaults: {\n\t\t\tloading: false\n\t\t},\n\n\t\tinitialize: function() {\n\t\t\t// Listen to changes to our 'clean' attribute.\n\t\t\tthis.on( 'change:clean', this.changeStatus, this );\n\t\t},\n\n\t\tchangeStatus: function() {\n\t\t\t// Send out a radio message when the 'clean' attribute changes.\n\t\t\tnfRadio.channel( 'app' ).trigger( 'change:clean', this.get( 'clean' ) );\n\t\t}\n\t} );\n\t\n\treturn model;\n} );\n","/**\n * Creates and stores a model that represents app-wide data. i.e. current domain, current drawer, clean, etc.\n *\n * clean is a boolean that represents whether or not changes have been made.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/data',['models/app/appModel'], function( appModel ) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Get the collection that represents all the parts of our application.\n\t\t\tvar appDomainCollection = nfRadio.channel( 'app' ).request( 'get:domainCollection' );\n\t\t\t// Setup our initial model.\n\t\t\tthis.model = new appModel( {\n\t\t\t\tcurrentDrawer: false,\n\t\t\t\tcurrentDomain: appDomainCollection.get( 'fields' ),\n\t\t\t\tclean: true\n\t\t\t} );\n\n\t\t\t/*\n\t\t\t * Set the mobile setting used to track whether or not we're on a mobile device.\n\t\t\t */\n\t\t\tvar mobile = ( 1 == nfAdmin.mobile ) ? true : false;\n\t\t\tthis.model.set( 'mobile', mobile );\n\n\t\t\t/*\n\t\t\t * Respond to requests to see if we are on mobile.\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).reply( 'is:mobile', this.isMobile, this );\n\n\t\t\t/*\n\t\t\t * Respond to app channel requests for information about the state of our app.\n\t\t\t */\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:data', this.getData, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:setting', this.getSetting, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:currentDomain', this.getCurrentDomain, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'get:currentDrawer', this.getCurrentDrawer, this );\n\t\t\tnfRadio.channel( 'drawer' ).reply( 'get:current', this.getCurrentDrawer, this );\n\n\t\t\t/*\n\t\t\t * Respond to app channel requests to update app settings.\n\t\t\t */\t\t\n\t\t\tnfRadio.channel( 'app' ).reply( 'update:currentDomain', this.updateCurrentDomain, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'update:currentDrawer', this.updateCurrentDrawer, this );\n\t\t\tnfRadio.channel( 'app' ).reply( 'update:setting', this.updateSetting, this );\n\n\t\t\tnfRadio.channel( 'settings' ).reply( 'check:deps', this.checkDeps, this );\n\n\t\t},\n\t\t\n\t\t/**\n\t\t * A more robust settings dependency system.\n\t\t * This allows you to have a setting only show when X AND Y are met or when X OR Y are met.\n\t\t * \n\t\t * @since  \n\t\t * @param  {object} setting Setting object\n\t\t * @param  {object} context Object context for where this is being called.\n\t\t * @return {bool}/{string}\n\t\t */\n\t\tcheckDeps: function( setting, context ) {\n\t\t\tif ( ! setting.deps ) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\t// If we do have a \"settings\" property, then this is a new dependency format.\n\t\t\tlet deps_settings = setting.deps.settings;\n\t\t\tlet match = setting.deps.match;\n\t\t\t\n\t\t\tlet hide = false;\n\t\t\t\n\t\t\tfor (var i = deps_settings.length - 1; i >= 0; i--) {\n\t\t\t\tlet name = deps_settings[i].name;\n\t\t\t\tlet value = deps_settings[i].value;\n\n\t\t\t\t// Use == here instead of === in order to avoid string => int comparison.\n\t\t\t    if ( context.dataModel.get( name ) == value ) {\n\t\t        \t// If we're looking for \"any\" match, we can go ahead and return here. \n\t\t        \tif ( 'any' == match ) {\n\t\t        \t\thide = false;\n\t\t        \t\tbreak;\n\t\t        \t}\n\t\t        } else {\n\t        \t\thide = true;\n\t\t        }\n\t\t\t}\n\n\t\t\tif ( hide ) {\n\t\t\t\treturn 'style=\"display:none;\"';\n\t\t\t}\n\t\t\t\n\t\t\treturn '';\n\t\t},\n\n\t\tupdateCurrentDomain: function( model ) {\n\t\t\tthis.updateSetting( 'currentDomain', model );\n\t\t},\n\n\t\tupdateSetting: function( setting, value ) {\n\t\t\tthis.model.set( setting, value );\n\t\t\treturn true;\n\t\t},\n\n\t\tgetSetting: function( setting ) {\n\t\t\treturn this.model.get( setting );\n\t\t},\n\n\t\tgetData: function() {\n\t\t\treturn this.model;\n\t\t},\n\n\t\tgetCurrentDomain: function() {\n\t\t\treturn this.model.get( 'currentDomain' );\n\t\t},\n\n\t\tupdateCurrentDrawer: function( drawerID ) {\n\t\t\tthis.updateSetting( 'currentDrawer', drawerID );\n\t\t\treturn true;\n\t\t},\n\n\t\tgetCurrentDrawer: function() {\n\t\t\tvar currentDrawerID = this.model.get( 'currentDrawer' );\n\t\t\treturn nfRadio.channel( 'app' ).request( 'get:drawer', currentDrawerID );\n\t\t},\n\n\t\tisMobile: function() {\n\t\t\treturn this.model.get( 'mobile' );\n\t\t}\n\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Listens for click events to expand/collapse setting groups.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - New Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/drawerToggleSettingGroup',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Listen for click events on our settings group.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'click:toggleSettingGroup', this.toggleSettingGroup );\n\t\t},\n\n\t\t/**\n\t\t * Set the 'display' attribute of our group model to true or false to toggle.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te     \tevent\n\t\t * @param  backbone.model \tmodel \tgroup setting model\n\t\t * @return void\n\t\t */\n\t\ttoggleSettingGroup: function( e, model ) {\n\t\t\tif ( model.get( 'display' ) ) {\n\t\t\t\t/*\n\t\t\t\t * Make sure that none of our settings have errors\n\t\t\t\t */\n\t\t\t\tvar errors = false;\n\t\t\t\t_.each( model.get( 'settings' ).models, function( setting ) {\n\t\t\t\t\tif ( setting.get( 'error' ) ) {\n\t\t\t\t\t\terrors = true;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t\tif ( ! errors ) {\n\t\t\t\t\tmodel.set( 'display', false );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tmodel.set( 'display', true );\n\t\t\t}\n\t\t}\n\t});\n\n\treturn controller;\n} );\n","/**\n * Updates our database with our form data.\n * \n * @package Ninja Forms builder\n * @subpackage Fields\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/updateDB',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\n\t\tinitialize: function() {\n\t\t\t// Listen for the closing of the drawer and update when it's closed.\n\t\t\tthis.listenTo( nfRadio.channel( 'drawer' ), 'closed', this.updateDB );\n\t\t\t// Respond to requests to update the database.\n\t\t\tnfRadio.channel( 'app' ).reply( 'update:db', this.updateDB, this );\n\t\t\t/*\n\t\t\t * Register our default formContent save filter.\n\t\t\t * This converts our collection into an array of keys.\n\t\t\t */\n\t\t\tnfRadio.channel( 'formContent' ).request( 'add:saveFilter', this.defaultSaveFilter, 10, this );\n\t\t},\n\n\t\t/**\n\t\t * Update our database.\n\t\t * If action isn't specified, assume we're updating the preview.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  string \taction preview or publish\n\t\t * @return void\n\t\t */\n\t\tupdateDB: function( action ) {\n\n\t\t\t// If our app is clean, dont' update.\n\t\t\tif ( nfRadio.channel( 'app' ).request( 'get:setting', 'clean' ) ) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Default action to preview.\n\t\t\taction = action || 'preview';\n\n\t\t\t// Setup our ajax actions based on the action we're performing\n\t\t\tif ( 'preview' == action ) {\n\t\t\t\tvar jsAction = 'nf_preview_update';\n\t\t\t} else if ( 'publish' == action ) {\n\t\t\t\tvar jsAction = 'nf_save_form';\n\t\t\t\t// now using a different ajax action\n\t\t\t\t// var jsAction = 'nf_batch_process';\n\t\t\t}\n\n\t\t\tvar formModel = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\n\t\t\t/*\n\t\t\t * There are pieces of data that are only needed for the builder and not for the front-end.\n\t\t\t * We need to unset those.\n\t\t\t * TODO: Make this more dynamic/filterable.\n\t\t\t */\n\t\t\t_.each( formModel.get( 'fields' ).models, function( fieldModel, index ) {\n\t\t\t\tfieldModel.unset( 'jBox', { silent: true } );\n\t\t\t} );\n\n\t\t\t/*\n\t\t\t * The main content of our form is called the formContent.\n\t\t\t * In this next section, we check to see if any add-ons want to modify that contents before we save.\n\t\t\t * If there aren't any filters found, we default to the field collection.\n\t\t\t * \n\t\t\t */\n\t\t\t\n\t\t\tvar formContentData = nfRadio.channel( 'settings' ).request( 'get:setting', 'formContentData' );\n\t\t\t/*\n\t\t\t * As of version 3.0, 'fieldContentsData' has deprecated in favour of 'formContentData'.\n\t\t\t * If we don't have this setting, then we check for this deprecated value.\n\t\t\t * \n\t\t\t * Set our fieldContentsData to our form setting 'fieldContentsData'\n\t\t\t *\n\t\t\t * TODO: Remove this backwards compatibility eventually.\n\t\t\t */\n\t\t\tif ( ! formContentData ) {\n\t\t\t\tformContentData = nfRadio.channel( 'settings' ).request( 'get:setting', 'fieldContentsData' );\n\t\t\t}\n\n\t\t\tvar formContentSaveDataFilters = nfRadio.channel( 'formContent' ).request( 'get:saveFilters' );\n\t\t\t\t\t\t\n\t\t\t/* \n\t\t\t* Get our first filter, this will be the one with the highest priority.\n\t\t\t*/\n\t\t\tvar sortedArray = _.without( formContentSaveDataFilters, undefined );\n\t\t\tvar callback = _.first( sortedArray );\n\t\t\t/*\n\t\t\t * Set our formContentData to the callback specified in the filter, passing our current formContentData.\n\t\t\t */\n\t\t\tformContentData = callback( formContentData );\n\t\t\t\n\t\t\tif ( 'publish' == action && formModel.get( 'show_publish_options' ) ) {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'open:drawer', 'newForm' );\n\t\t\t\tvar builderEl = nfRadio.channel( 'app' ).request( 'get:builderEl' );\n\t\t\t\tjQuery( builderEl ).addClass( 'disable-main' );\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\t// Get our form data\n\t\t\tvar formData = nfRadio.channel( 'app' ).request( 'get:formModel' );\n\n\t\t\t// Turn our formData model into an object\n\t\t\tvar data = JSON.parse( JSON.stringify( formData ) );\n\t\t\tdata.settings.formContentData = formContentData;\n\n\t\t\t/**\n\t\t\t * Prepare fields for submission.\n\t\t\t */\n\t\t\t\n\t\t\t// Get the field IDs that we've deleted.\n\t\t\tvar removedIDs = formData.get( 'fields' ).removedIDs;\n\n\t\t\t/*\n\t\t\t * data.fields is an array of objects like:\n\t\t\t * field.label = blah\n\t\t\t * field.label_pos = blah\n\t\t\t * etc.\n\t\