settings.label_pos = blah\n\t\t\t *\n\t\t\t * So, we loop through our fields and create a field.settings object.\n\t\t\t */\n\t\t\t_.each( data.fields, function( field ) {\n\t\t\t\tvar id = field.id;\n\t\t\t\t// We dont' want to update id or parent_id\n\t\t\t\tdelete field.id;\n\t\t\t\tdelete field.parent_id;\n\t\t\t\tvar settings = {};\n\t\t\t\t// Loop through all the attributes of our fields\n\t\t\t\tfor (var prop in field) {\n\t\t\t\t    if ( field.hasOwnProperty( prop ) ) {\n\t\t\t\t    \t// If our field property isn't null, then...\n                        if ( null !== field[ prop ] ) {\n                            // Set our settings.prop value.\n                            settings[prop] = field[prop];\n                        }\n                        // Delete the property from the field.\n                        delete field[ prop ];\n                    }\n\t\t\t\t}\n\n\t\t\t\tfor( var setting in settings ){\n\t\t\t\t\tif( null === settings[ setting ] ) {\n\t\t\t\t\t\tdelete settings[setting];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Update our field object.\n\t\t\t\tfield.settings = settings;\n\t\t\t\tfield.id = id;\n\t\t\t} );\n\n\t\t\t// Set our deleted_fields object so that we can know which fields were removed.\n\t\t\tdata.deleted_fields = removedIDs;\n\n\t\t\t/**\n\t\t\t * Prepare actions for submission.\n\t\t\t */\n\t\t\t\n\t\t\t// Get the action IDs that we've deleted.\n\t\t\tvar removedIDs = formData.get( 'actions' ).removedIDs;\n\n\t\t\t/*\n\t\t\t * data.actions is an array of objects like:\n\t\t\t * action.label = blah\n\t\t\t * action.label_pos = blah\n\t\t\t * etc.\n\t\t\t *\n\t\t\t * And we need that format to be:\n\t\t\t * action.settings.label = blah\n\t\t\t * action.settings.label_pos = blah\n\t\t\t *\n\t\t\t * So, we loop through our actions and create a field.settings object.\n\t\t\t */\n\t\t\t_.each( data.actions, function( action ) {\n\t\t\t\tvar id = action.id;\n\t\t\t\t// We dont' want to update id or parent_id\n\t\t\t\tdelete action.id;\n\t\t\t\tdelete action.parent_id;\n\t\t\t\tvar settings = {};\n\t\t\t\t// Loop through all the attributes of our actions\n\t\t\t\tfor (var prop in action) {\n\t\t\t\t    if ( action.hasOwnProperty( prop ) ) {\n\t\t\t\t    \t//Removing null values\n\t\t\t\t\t    if( null !== action[ prop ] ) {\n\t\t\t\t\t\t    // Set our settings.prop value.\n\t\t\t\t\t\t    settings[ prop ] = action[ prop ];\n\t\t\t\t\t    }\n\t\t\t\t        // Delete the property from the action.\n\t\t\t\t        delete action[ prop ];\n\t\t\t\t    }\n\t\t\t\t}\n\t\t\t\t// Update our action object.\n\t\t\t\taction.settings = settings;\n\t\t\t\taction.id = id;\n\t\t\t} );\n\n\t\t\tfor ( var setting in data.settings ) {\n\t\t\t\tif ( null === data.settings[ setting ] ) {\n\t\t\t\t\tdelete data.settings[ setting ];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set our deleted_actions object so that we can know which actions were removed.\n\t\t\tdata.deleted_actions = removedIDs;\n\n\t\t\t// Turn our object into a JSON string.\n\t\t\tdata = JSON.stringify( data );\n\n\t\t\t// Run anything that needs to happen before we update.\n\t\t\tnfRadio.channel( 'app' ).trigger( 'before:updateDB', data );\n\n\t\t\tif ( 'publish' == action ) {\n\t\t\t\tnfRadio.channel( 'app' ).request( 'update:setting', 'loading', true );\n\t\t\t\tnfRadio.channel( 'app' ).trigger( 'change:loading' );\t\n\n\t\t\t\t// If we're on mobile, show a notice that we're publishing\n\t\t\t\tif ( nfRadio.channel( 'app' ).request( 'is:mobile' ) ) {\n\t\t\t\t\tnfRadio.channel( 'notices' ).request( 'add', 'publishing', 'Your Changes Are Being Published', { autoClose: false } );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( 'nf_save_form' === jsAction ) {\n\t\t\t\t// if the form string is long than this, chunk it\n\t\t\t\tvar chunk_size = 100000;\n\t\t\t\tvar data_chunks = [];\n\n\t\t\t\t// Let's chunk this\n\t\t\t\tif( chunk_size < data.length ) {\n\t\t\t\t\tdata_chunks = data.match(new RegExp('.{1,' + chunk_size + '}', 'g'));\n\t\t\t\t}\n\t\t\t\t// if we have chunks send them via the step processor\n\t\t\t\tif( 1 < data_chunks.length ) {\n\t\t\t\t\t// this function will make the ajax call for chunks\n\t\t\t\t\tthis.saveChunkedForm(\n\t\t\t\t\t\tdata_chunks,\n\t\t\t\t\t\t0,\n\t\t\t\t\t\t'nf_batch_process',\n\t\t\t\t\t\taction,\n\t\t\t\t\t\tformModel.get('id'),\n\t\t\t\t\t\ttrue\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\t// otherwise send it the regular way.\n\t\t\t\t\tvar context = this;\n\t\t\t\t\tvar responseData = null;\n\n\t\t\t\t\tjQuery.post( ajaxurl,\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\taction: jsAction,\n\t\t\t\t\t\t\tform: data,\n\t\t\t\t\t\t\tsecurity: nfAdmin.ajaxNonce\n\t\t\t\t\t\t},\n\t\t\t\t\t\tfunction( response ) {\n\t\t\t\t\t\t\tresponseData = response;\n\t\t\t\t\t\t\tcontext.handleFinalResponse( responseData, action );\n\t\t\t\t\t\t}\n\t\t\t\t\t).fail( function( xhr, status, error ) {\n\t\t\t\t\t\tcontext.handleFinalFailure( xhr, status, error, action )\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t} else if ( 'nf_preview_update' === jsAction ) {\n\t\t\t\tvar context = this;\n\t\t\t\tvar responseData = null;\n\t\t\t\tjQuery.post( ajaxurl,\n\t\t\t\t\t{\n\t\t\t\t\t\taction: jsAction,\n\t\t\t\t\t\tform: data,\n\t\t\t\t\t\tsecurity: nfAdmin.ajaxNonce\n\t\t\t\t\t},\n\t\t\t\t\tfunction( response ) {\n\t\t\t\t\t\tresponseData = response;\n\t\t\t\t\t\tcontext.handleFinalResponse( responseData, action );\n\t\t\t\t\t}\n\t\t\t\t).fail( function( xhr, status, error ) {\n\t\t\t\t\tcontext.handleFinalFailure( xhr, status, error, action )\n\t\t\t\t} );\n\t\t\t}\n\t\t},\n\t\t/**\n\t\t * Function to recursively send chunks until all chunks