\tvar maxVal = settingTypeModel.get( 'max_val' );\n\n\t\t\t/*\n\t\t\t * if we gave a min value set, revert to that if the user enters\n\t\t\t * a lower number\n\t\t\t*/\n\t\t\tif( 'undefined' != typeof minVal && null !== minVal ){\n\t\t\t\tif ( e.target.value < minVal ) {\n\t\t\t\t\tfieldModel.set('value', minVal);\n\t\t\t\t\te.target.value = minVal;\n\t\t\t\t}\n\t\t\t}\n\t\t\t/*\n\t\t\t * if we gave a max value set, revert to that if the user enters\n\t\t\t * a higher number\n\t\t\t*/\n\t\t\tif( 'undefined' != typeof maxVal && null !== maxVal ){\n\t\t\t\tif ( e.target.value > maxVal ) {\n\t\t\t\t\tfieldModel.set('value', maxVal);\n\t\t\t\t\te.target.value = maxVal;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn e.target.value;\n\t\t},\n\n\t\tvalidateSetting: function( e, fieldModel ){\n\t\t\t//Check end and start years in Date field\n\t\t\tif( [\"year_range_start\", \"year_range_end\"].includes( fieldModel.get('name') ) ) {\n\t\t\t\t//Determine start and end value and consider current value being changed\n\t\t\t\tconst startValue = fieldModel.get('name') === \"year_range_start\" ? e.target.value : document.getElementById(\"year_range_start\").getAttribute('value'),\n\t\t\t\tendValue = fieldModel.get('name') === \"year_range_end\" ? e.target.value : document.getElementById(\"year_range_end\").getAttribute('value');\n\t\t\t\t//Proceed to check that if both values are set, start must be smaller than end\n\t\t\t\tif(startValue.length > 0 && endValue.length > 0){\n\t\t\t\t\tif(startValue >= endValue){\n\t\t\t\t\t\tfieldModel.set('error', \"Start year must be smaller than end year\" );\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfieldModel.unset('error');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","\ndefine( 'controllers/app/radioSetting',[], function() {\n    var controller = Marionette.Object.extend({\n        initialize: function () {\n            // Respond to requests for field setting filtering.\n\n            console.log( nfRadio.channel( 'radio' ) );\n            nfRadio.channel('radio').reply( 'before:updateSetting', this.updateSetting, this);\n        },\n\n\n        updateSetting: function( e, fieldModel, name, settingTypeModel ) {\n            console.log( 'test' );\n        }\n    });\n    return controller;\n} );\n","/**\n * Listens for clicks on our action item action buttons.\n * \n * @package Ninja Forms builder\n * @subpackage Fields - Main Sortable\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/itemControls',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\n\t\tdeleting: false, // block edit functionality while deleting field\n\n\t\tinitialize: function() {\n\t\t\t// Listen for clicks to edit, delete, duplicate actions.\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:edit', this.clickEdit );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:delete', this.maybeDelete );\n\t\t\tthis.listenTo( nfRadio.channel( 'app' ), 'click:duplicate', this.clickDuplicate );\n\n\t\t\t// Listen for our drawer close and remove our active edit state\n\t\t},\n\n\t\t/**\n\t\t * Open a drawer with our action model for editing settings.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te     \tevent\n\t\t * @param  backbone.model \tmodel \taction model\n\t\t * @return void\n\t\t */\n\t\tclickEdit: function( e, model ) {\n\t\t\t// if we are deleting a field, we don't want to the edit drawer to open\n\t\t\tif( ! this.deleting ) {\n\t\t\t\tvar currentDomain = nfRadio.channel('app').request('get:currentDomain');\n\t\t\t\tvar currentDomainID = currentDomain.get('id');\n\t\t\t\tvar type = nfRadio.channel(currentDomainID).request('get:type', model.get('type'));\n\t\t\t\tnfRadio.channel('app').request('open:drawer', 'editSettings', {\n\t\t\t\t\tmodel: model,\n\t\t\t\t\tgroupCollection: type.get('settingGroups')\n\t\t\t\t});\n\t\t\t\t//loop through repeater fields to reset active state if needed\n\t\t\t\tnfRadio.channel( 'fields-repeater' ).trigger( 'clearEditActive', model );\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Let user know that all data will be lost before actually deleting\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te     \tevent\n\t\t * @param  backbone.model \tmodel \taction model\n\t\t * @return void\n\t\t */\n\t\tmaybeDelete: function( e, dataModel ) {\n\t\t\t// we set deleting to true, so the edit event doesn't open drawer\n\t\t\tthis.deleting = true;\n\t\t\tvar modelID = dataModel.get( 'id' );\n\t\t\tvar modelType = dataModel.get( 'objectType' );\n\n\t\t\t// Build a lookup table for fields that we don't save\n\t\t\tvar nonSaveFields = [ 'html', 'submit', 'hr',\n\t\t\t\t'recaptcha', 'spam', 'creditcard', 'creditcardcvc',\n\t\t\t\t'creditcardexpiration', 'creditcardfullname',\n\t\t\t\t'creditcardnumber', 'creditcardzip' ];\n\n\t\t\t/*\n\t\t\t* If this is a new field that hasn't been saved, then we don't\n\t\t\t * need to check for data\n\t\t\t */\n\t\t\tif( 'field' != modelType.toLowerCase() ) {\n\t\t\t\tthis.clickDelete( e, dataModel );\n\t\t\t} else {\n\t\t\t\t/*\n\t\t\t\t* If the field has been saved, then we need to check for\n\t\t\t\t * submission data for this field\n\t\t\t\t */\n\t\t\t\tif( 'tmp' === modelID.toString().substring( 0, 3 )\n\t\t\t\t\t|| -1 != jQuery.inArray( dataModel.get( 'type' ), nonSaveFields ) ) {\n\t\t\t\t\t// not a saved field so proceed as normal\n\t\t\t\t\tthis.clickDelete( e, dataModel );\n\t\t\t\t} else {\n\t\t\t\t\t// need the form id\n\t\t\t\t\tvar formModel = Backbone.Radio.channel('app').request('get:formModel');\n\t\t\t\t\tvar data = {\n\t\t\t\t\t\t'action': 'nf_maybe_delete_field',\n\t\t\t\t\t\t'security': nfAdmin.ajaxNonce,\n\t\t\t\t\t\t'formID': formModel.get('id'),\n\t\t\t\t\t\t'fieldKey': dataModel.get('key'),\n\t\t\t\t\t\t'fieldID': modelID\n\t\t\t\t\t};\n\t\t\t\t\tvar that = this;\n\n\t\t\t\t\t// make call to see if field has submission data\n\t\t\t\t\tjQuery.post(ajaxurl, data)\n\t\t\t\t\t\t.done(function (response) {\n\t\t\t\t\t\t\tvar res = JSON.parse(response);\n\n\t\t\t\t\t\t\tif (res.data.hasOwnProperty('errors')) {\n\t\t\t\t\t\t\t\tvar errors = res.data.errors;\n\t\t\t\t\t\t\t\tvar errorMsg = '';\n\n\t\t\t\t\t\t\t\tif (Array.isArray(errors)) {\n\t\t\t\t\t\t\t\t\terrors.forEach(function(error) {\n\t\t\t\t\t\t\t\t\t\terrors += error + \"\\n\";\n\t\t\t\t\t\t\t\t\t})\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\terrors = errors;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tconsole.log('Maybe Delete Field  Errors: ', errors);\n\t\t\t\t\t\t\t\talert(errors);\n\t\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (res.data.field_has_data) {\n\t\t\t\t\t\t\t\t// if it does, show warning modal\n\t\t\t\t\t\t\t\tthat.doDeleteFieldModal(e, dataModel);\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t// if not, proceed like normal\n\t\t\t\t\t\t\t\tthat.clickDelete(e, dataModel);\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Create the field delete warning modal\n\t\t *\n\t\t * @param e\n\t\t * @param dataModel\n\t\t */\n\t\tdoDeleteFieldModal: function( e, dataModel ) {\n\t\t\t// Build warning modal to warn user a losing all data related to field\n            var that = this;\n            var modalData = {\n                width: 400,\n                closeOnClick: false,\n                closeOnEsc: true,\n                content: nfi18n.fieldDataDeleteMsg,\n                btnPrimary: {\n                    text: nfi18n.delete,\n                    callback: function() {\n                        // close and destory modal.\n                        deleteModal.toggleModal( false );\n                        deleteModal.destroy();\n                        // proceed as normal, data will be deleted in backend on publish\n                        that.clickDelete( e, dataModel );\n                    }\n                },\n                btnSecondary: {\n                    text: nfi18n.cancel,\n                    callback: function() {\n                        // close and destory modal\n                        deleteModal.toggleModal( false );\n                        deleteModal.destroy();\n                        // set deleting to false so edit can work as normal\n                        that.deleting = false;\n                    }\n                }\n            };\n            var deleteModal = new NinjaModal( modalData );\n\t\t},\n\n\t\t/**\n\t\t * Delete a action model from our collection\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te     \tevent\n\t\t * @param  backbone.model \tmodel \taction model\n\t\t * @return void\n\t\t */\n\t\tclickDelete: function( e, dataModel ) {\n\t\t\tvar newModel = nfRadio.channel( 'app' ).request( 'clone:modelDeep', dataModel );\n\n\t\t\t// Add our action deletion to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: dataModel.get( 'objectType' ),\n\t\t\t\tlabel: dataModel.get( 'label' ),\n\t\t\t\tchange: 'Removed',\n\t\t\t\tdashicon: 'dismiss'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: dataModel.collection\n\t\t\t};\n\n\t\t\tvar changeCollection = nfRadio.channel( 'changes' ).request( 'get:collection' );\n\t\t\tvar results = changeCollection.where( { model: dataModel } );\n\n\t\t\t_.each( results, function( changeModel ) {\n\t\t\t\tvar data = changeModel.get( 'data' );\n\t\t\t\tif ( 'undefined' != typeof data.fields ) {\n\t\t\t\t\t_.each( data.fields, function( field, index ) {\n\t\t\t\t\t\tif ( field.model == dataModel ) {\n\t\t\t\t\t\t\tdata.fields[ index ].model = newModel;\t\t\t\t\t\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t\tchangeModel.set( 'data', data );\n\t\t\t\tchangeModel.set( 'model', newModel );\n\t\t\t\tchangeModel.set( 'disabled', true );\n\t\t\t} );\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'removeObject', newModel, null, label, data );\n\t\t\t\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tvar currentDomainID = currentDomain.get( 'id' );\n\t\t\tnfRadio.channel( currentDomainID ).request( 'delete', dataModel );\n\t\t\tthis.deleting = false;\n\t\t},\n\n\t\t/**\n\t\t * Duplicate a action within our collection, adding the word \"copy\" to the label.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object\t\t\te     \tevent\n\t\t * @param  backbone.model \tmodel \taction model\n\t\t * @return void\n\t\t */\n\t\tclickDuplicate: function( e, model ) {\n\t\t\tvar newModel = nfRadio.channel( 'app' ).request( 'clone:modelDeep', model );\n\t\t\tvar currentDomain = nfRadio.channel( 'app' ).request( 'get:currentDomain' );\n\t\t\tvar currentDomainID = currentDomain.get( 'id' );\n\n\t\t\t// Change our label.\n\t\t\t// Make sure this update is silent to avoid triggering key change events down the waterfall.\n\t\t\tnewModel.set( 'label', newModel.get( 'label' ) + ' Copy', {silent: true} );\n\t\t\t// Update our ID to the new tmp id.\n\t\t\tvar tmpID = nfRadio.channel( currentDomainID ).request( 'get:tmpID' );\n\t\t\tnewModel.set( 'id', tmpID );\n\t\t\t// Add new model.\n\t\t\t// Params are: model, silent, renderTrigger, action\n\t\t\tnfRadio.channel( currentDomainID ).request( 'add', newModel, false, false, 'duplicate' );\n\t\t\t\n\t\t\t// Add our action addition to our change log.\n\t\t\tvar label = {\n\t\t\t\tobject: model.get( 'objectType' ),\n\t\t\t\tlabel: model.get( 'label' ),\n\t\t\t\tchange: 'Duplicated',\n\t\t\t\tdashicon: 'admin-page'\n\t\t\t};\n\n\t\t\tvar data = {\n\t\t\t\tcollection: nfRadio.channel( currentDomainID ).request( 'get:collection' )\n\t\t\t}\n\n\t\t\tnfRadio.channel( 'changes' ).request( 'register:change', 'duplicateObject', newModel, null, label, data );\n\t\t\t\n\t\t\tmodel.trigger( 'change:label', model );\n\n\t\t\t// Update preview.\n\t\t\tnfRadio.channel( 'app' ).request( 'update:db' );\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Config file for our merge tags.\n *\n * this.collection represents all of our registered merge tags.\n * \n * @package Ninja Forms builder\n * @subpackage Main App\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/mergeTags',[\n\t'models/app/mergeTagCollection'\n\t], function(\n\tmergeTagCollection\n\t) {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\tthis.tagSectionCollection = new mergeTagCollection();\n\t\t\tvar that = this;\n\t\t\t_.each( mergeTags, function( tagSection ) {\n\t\t\t\tif ( tagSection.tags ) {\n\t\t\t\t\tvar tags = new mergeTagCollection( tagSection.tags );\n\t\t\t\t} else {\n\t\t\t\t\tvar tags = '';\n\t\t\t\t}\n\n\t\t\t\tthat.tagSectionCollection.add( {\n\t\t\t\t\tid: tagSection.id,\n\t\t\t\t\tlabe