 builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/toggleSetting',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// We don't want the RTE setting to re-render when the value changes.\n\t\t\tnfRadio.channel( 'setting-type-toggle' ).reply( 'renderOnChange', function(){ return false } );\n\n\t\t\t// Respond to requests for field setting filtering.\n\t\t\tnfRadio.channel( 'toggle' ).reply( 'before:updateSetting', this.updateSetting, this );\n\t\t},\n\n\t\t/**\n\t\t * Return either 1 or 0, depending upon the toggle position.\n\t\t * \n\t\t * @since  3.0\n\t\t * @param  Object \t\t\te                event\n\t\t * @param  backbone.model \tfieldModel       field model\n\t\t * @param  string \t\t\tname             setting name\n\t\t * @param  backbone.model \tsettingTypeModel field type model\n\t\t * @return int              1 or 0\n\t\t */\n\t\tupdateSetting: function( e, fieldModel, name, settingTypeModel ) {\n\t\t\tif ( jQuery( e.target ).prop( 'checked' ) ) {\n\t\t\t\tvar value = 1;\n\t\t\t} else {\n\t\t\t\tvar value = 0;\n\t\t\t}\n\n\t\t\treturn value;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to our toggle field.\n * When we change the toggle, the setting value will be 'on' or ''.\n * We need to change this to 1 or 0.\n *\n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/buttonToggleSetting',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// We don't want the RTE setting to re-render when the value changes.\n\t\t\tnfRadio.channel( 'setting-type-button-toggle' ).reply( 'renderOnChange', function(){ return false; } );\n\n\t\t\t// Respond to requests for field setting filtering.\n\t\t\tnfRadio.channel( 'button-toggle' ).reply( 'before:updateSetting', this.updateSetting, this );\n\t\t},\n\n\t\t/**\n\t\t * Return either 1 or 0, depending upon the toggle position.\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Object \t\t\te                event\n\t\t * @param  backbone.model \tfieldModel       field model\n\t\t * @param  string \t\t\tname             setting name\n\t\t * @param  backbone.model \tsettingTypeModel field type model\n\t\t * @return int              1 or 0\n\t\t */\n\t\tupdateSetting: function( e, fieldModel, name, settingTypeModel ) {\n\t\t\treturn e.target.value;\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to number field settings.\n *\n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2015 WP Ninjas\n * @since 3.0\n */\ndefine( 'controllers/app/numberSetting',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\t\t\t// Respond to requests for field setting filtering.\n\t\t\tnfRadio.channel( 'number' ).reply( 'before:updateSetting', this.updateSetting, this );\n\t\t\tnfRadio.channel( 'number' ).reply( 'validate:updateSetting', this.validateSetting, this );\n\t\t},\n\n\t\t/**\n\t\t * Resets value if user enters value below min value or above max value\n\t\t *\n\t\t * @since  3.0\n\t\t * @param  Object \t\t\te                event\n\t\t * @param  backbone.model \tfieldModel       field model\n\t\t * @param  string \t\t\tname             setting name\n\t\t * @param  backbone.model \tsettingTypeModel field type model\n\t\t * @return int              1 or 0\n\t\t */\n\t\tupdateSetting: function( e, fi