zed\n\t\t * @return void\n\t\t */\n\t\tcreateSettingsCollection: function( model ) {\n\t\t\tmodel.set( 'settings', new settingCollection( model.get( 'settings' ) ) );\n\t\t},\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to textbox type of field settings\n * \n * We want to prevent script usage in the Advanced section labels\n * \n * @package Ninja Forms builder\n * @subpackage Fields - Edit Field Drawer\n * @copyright (c) 2024 Saturday Drive\n * @since 3.8\n */\ndefine( 'controllers/app/textboxSetting',[], function() {\n\tvar controller = Marionette.Object.extend( {\n\t\tinitialize: function() {\n\n\t\t\t// Respond to requests for field setting filtering.\n\t\t\tnfRadio.channel( 'textbox' ).reply( 'validate:updateSetting', this.validateSetting, this );\n\t\t},\n\n\t\t/**\n\t\t * Sanitize field as needed to prevent xss\n\t\t * \n\t\t * @since  3.8\n\t\t * @param  Object \t\t\te                event\n\t\t * @param  backbone.model \tfieldModel       field model\n\t\t * @param  string \t\t\tname             setting name\n\t\t * @param  backbone.model \tsettingTypeModel field type model\n\t\t * @return escaped data after error triggered\n\t\t */\n\t\tvalidateSetting: function( e, fieldModel, dataModel ) {\n            //Check characters set in custom classes match sanitize_html_class\n\t\t\tif ( fieldModel.get('name').endsWith(\"_class\" )) {\n\t\t\t\tconst regexp = /^[a-zA-Z 0-9-_]+$/;\n\t\t\t\tif(e.target.value.search(regexp) === -1 &&  '' !== e.target.value){\n\t\t\t\t\tfieldModel.set('error', nfi18n.htmlDetectedError );\n\t\t\t\t} else if(e.target.value.search(regexp) === 0 || '' === e.target.value){\n\t\t\t\t\tfieldModel.unset('error');\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n            //Prevent xss from title and labels\n\t\t\tconst isActionNameLabel = fieldModel.get('name') === \"label\" && fieldModel.get('label') === \"Action Name\";\n            const checkedElements = [\"title\", \"processing_label\", \"changeEmailErrorMsg\", \"changeDateErrorMsg\", \"confirmFieldErrorMsg\", \"fieldNumberNumMinError\", \"fieldNumberNumMaxError\", \"fieldNumberIncrementBy\", \"formErrorsCorrectErrors\", \"validateRequiredField\", \"honeypotHoneypotError\", \"fieldsMarkedRequired\"];\n            if( checkedElements.includes(fieldModel.get('name')) || isActionNameLabel ){\n\t\t\t\tconst regexp = /[/\"<>`]/;\n\t\t\t\tif(e.target.value.search(regexp) !== -1 &&  '' !== e.target.value){\n\t\t\t\t\tconst foundIndex = e.target.value.search(regexp);\n\t\t\t\t\tconst foundChar = e.target.value.charAt(foundIndex);\n\t\t\t\t\tfieldModel.set('error', foundChar + \" \" + nfi18n.titleLabelsErrorMessage);\n\t\t\t\t} else if(e.target.value.search(regexp) === -1 || '' === e.target.value){\n\t\t\t\t\tfieldModel.unset('error');\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t});\n\n\treturn controller;\n} );\n","/**\n * Handles actions related to our toggle field.\n * When we change the toggle, the set